;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
 ;; CHECK-TEXT:      (type $f1 (func))

 ;; CHECK-TEXT:      (type $k1 (cont $f1))

 ;; CHECK-TEXT:      (type $2 (func (param (ref $k1))))

 ;; CHECK-TEXT:      (type $ft1 (func (param i32)))

 ;; CHECK-TEXT:      (type $ct1 (sub (cont $ft1)))

 ;; CHECK-TEXT:      (type $ft (func (param i32) (result i32)))
 ;; CHECK-BIN:      (type $f1 (func))

 ;; CHECK-BIN:      (type $k1 (cont $f1))

 ;; CHECK-BIN:      (type $2 (func (param (ref $k1))))

 ;; CHECK-BIN:      (type $ft1 (func (param i32)))

 ;; CHECK-BIN:      (type $ct1 (sub (cont $ft1)))

 ;; CHECK-BIN:      (type $ft (func (param i32) (result i32)))
 (type $ft (func (param i32) (result i32)))
 ;; CHECK-TEXT:      (type $ct (cont $ft))
 ;; CHECK-BIN:      (type $ct (cont $ft))
 (type $ct (cont $ft))

 ;; CHECK-TEXT:      (type $7 (func (param (ref $ct)) (result (ref $ct))))

 ;; CHECK-TEXT:      (type $8 (func (param contref nullcontref (ref cont) (ref nocont)) (result contref)))

 ;; CHECK-TEXT:      (type $9 (func (param (ref $ct1))))

 ;; CHECK-TEXT:      (type $ct0 (sub (cont $f1)))

 ;; CHECK-TEXT:      (global $kglo (mut (ref null $k1)) (ref.null nocont))

 ;; CHECK-TEXT:      (global $gglo (ref null $k1) (ref.null nocont))

 ;; CHECK-TEXT:      (elem declare func $f1 $f2 $f3 $fglo $r0 $r1)

 ;; CHECK-TEXT:      (tag $exn (type $f1))

 ;; CHECK-TEXT:      (tag $e1 (type $f1))

 ;; CHECK-TEXT:      (tag $e2 (type $f1))

 ;; CHECK-TEXT:      (export "unhandled-1" (func $f1))

 ;; CHECK-TEXT:      (export "unhandled-2" (func $unhandled-2))

 ;; CHECK-TEXT:      (export "unhandled-3" (func $unhandled-3))

 ;; CHECK-TEXT:      (export "handled" (func $handled))

 ;; CHECK-TEXT:      (export "uncaught-1" (func $uncaught-1))

 ;; CHECK-TEXT:      (export "uncaught-2" (func $uncaught-2))

 ;; CHECK-TEXT:      (export "uncaught-3" (func $uncaught-3))

 ;; CHECK-TEXT:      (export "non-linear-1" (func $non-linear-1))

 ;; CHECK-TEXT:      (export "non-linear-2" (func $non-linear-2))

 ;; CHECK-TEXT:      (export "non-linear-3" (func $non-linear-3))

 ;; CHECK-TEXT:      (export "non-linear-4" (func $non-linear-4))

 ;; CHECK-TEXT:      (func $id (type $7) (param $x (ref $ct)) (result (ref $ct))
 ;; CHECK-TEXT-NEXT:  (local.get $x)
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (type $7 (func (param (ref $ct)) (result (ref $ct))))

 ;; CHECK-BIN:      (type $8 (func (param contref nullcontref (ref cont) (ref nocont)) (result contref)))

 ;; CHECK-BIN:      (type $9 (func (param (ref $ct1))))

 ;; CHECK-BIN:      (type $ct0 (sub (cont $f1)))

 ;; CHECK-BIN:      (global $kglo (mut (ref null $k1)) (ref.null nocont))

 ;; CHECK-BIN:      (global $gglo (ref null $k1) (ref.null nocont))

 ;; CHECK-BIN:      (elem declare func $f1 $f2 $f3 $fglo $r0 $r1)

 ;; CHECK-BIN:      (tag $exn (type $f1))

 ;; CHECK-BIN:      (tag $e1 (type $f1))

 ;; CHECK-BIN:      (tag $e2 (type $f1))

 ;; CHECK-BIN:      (export "unhandled-1" (func $f1))

 ;; CHECK-BIN:      (export "unhandled-2" (func $unhandled-2))

 ;; CHECK-BIN:      (export "unhandled-3" (func $unhandled-3))

 ;; CHECK-BIN:      (export "handled" (func $handled))

 ;; CHECK-BIN:      (export "uncaught-1" (func $uncaught-1))

 ;; CHECK-BIN:      (export "uncaught-2" (func $uncaught-2))

 ;; CHECK-BIN:      (export "uncaught-3" (func $uncaught-3))

 ;; CHECK-BIN:      (export "non-linear-1" (func $non-linear-1))

 ;; CHECK-BIN:      (export "non-linear-2" (func $non-linear-2))

 ;; CHECK-BIN:      (export "non-linear-3" (func $non-linear-3))

 ;; CHECK-BIN:      (export "non-linear-4" (func $non-linear-4))

 ;; CHECK-BIN:      (func $id (type $7) (param $x (ref $ct)) (result (ref $ct))
 ;; CHECK-BIN-NEXT:  (local.get $x)
 ;; CHECK-BIN-NEXT: )
 (func $id (param $x (ref $ct)) (result (ref $ct))
  (local.get $x)
 )

  ;; CHECK-TEXT:      (func $id2 (type $8) (param $w contref) (param $x nullcontref) (param $y (ref cont)) (param $z (ref nocont)) (result contref)
  ;; CHECK-TEXT-NEXT:  (local.get $z)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $id2 (type $8) (param $w contref) (param $x nullcontref) (param $y (ref cont)) (param $z (ref nocont)) (result contref)
  ;; CHECK-BIN-NEXT:  (local.get $z)
  ;; CHECK-BIN-NEXT: )
  (func $id2
       (param $w contref)
       (param $x nullcontref)
       (param $y (ref cont))
       (param $z (ref nocont))
       (result contref)
  (local.get $z)
 )

  (tag $exn)
  (tag $e1)
  (tag $e2)

  (type $f1 (func))
  (type $k1 (cont $f1))

  (rec
    (type $f2 (func (param (ref $f3))))
    (type $f3 (func (param (ref $f2))))
  )
  (type $k2 (cont $f2))
  (type $k3 (cont $f3))

  (type $ft1 (func (param i32)))
  (type $ct1 (sub (cont $ft1)))

  (type $ft0 (func))
  (type $ct0 (sub (cont $ft0)))

  (type $f4 (sub (func (result anyref))))
  (type $f5 (sub $f4 (func (result eqref))))
  (type $c4 (sub (cont $f4)))
  (type $c5 (sub $c4 (cont $f5)))

  (type $ft2 (func))
  (type $ct2 (cont $ft2))

  (global $kglo (mut (ref null $ct2)) (ref.null $ct2))
  (global $gglo (ref null $ct2) (ref.null $ct2))

  ;; CHECK-TEXT:      (func $fglo (type $f1)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $fglo (type $f1)
  ;; CHECK-BIN-NEXT: )
  (func $fglo)
  ;; CHECK-BIN-NODEBUG:      (type $0 (func))

  ;; CHECK-BIN-NODEBUG:      (type $1 (cont $0))

  ;; CHECK-BIN-NODEBUG:      (type $2 (func (param (ref $1))))

  ;; CHECK-BIN-NODEBUG:      (type $3 (func (param i32)))

  ;; CHECK-BIN-NODEBUG:      (type $4 (sub (cont $3)))

  ;; CHECK-BIN-NODEBUG:      (type $5 (func (param i32) (result i32)))

  ;; CHECK-BIN-NODEBUG:      (type $6 (cont $5))

  ;; CHECK-BIN-NODEBUG:      (type $7 (func (param (ref $6)) (result (ref $6))))

  ;; CHECK-BIN-NODEBUG:      (type $8 (func (param contref nullcontref (ref cont) (ref nocont)) (result contref)))

  ;; CHECK-BIN-NODEBUG:      (type $9 (func (param (ref $4))))

  ;; CHECK-BIN-NODEBUG:      (type $10 (sub (cont $0)))

  ;; CHECK-BIN-NODEBUG:      (global $global$0 (mut (ref null $1)) (ref.null nocont))

  ;; CHECK-BIN-NODEBUG:      (global $global$1 (ref null $1) (ref.null nocont))

  ;; CHECK-BIN-NODEBUG:      (elem declare func $12 $15 $16 $2 $5 $9)
  (elem declare func $fglo)

  (func
    (global.set $kglo (cont.new $ct2 (ref.func $fglo))))

  (func (param $x (ref $ct1))
    (i32.const 123)
    (local.get $x)
    (cont.bind $ct1 $ct0)
    (drop)
  )

  ;; CHECK-TEXT:      (func $0 (type $f1)
  ;; CHECK-TEXT-NEXT:  (global.set $kglo
  ;; CHECK-TEXT-NEXT:   (cont.new $k1
  ;; CHECK-TEXT-NEXT:    (ref.func $fglo)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )

  ;; CHECK-TEXT:      (func $1 (type $9) (param $x (ref $ct1))
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (cont.bind $ct1 $ct0
  ;; CHECK-TEXT-NEXT:    (i32.const 123)
  ;; CHECK-TEXT-NEXT:    (local.get $x)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )

  ;; CHECK-TEXT:      (func $f1 (type $f1)
  ;; CHECK-TEXT-NEXT:  (suspend $e1)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $3 (type $f1)
  ;; CHECK-BIN-NEXT:  (global.set $kglo
  ;; CHECK-BIN-NEXT:   (cont.new $k1
  ;; CHECK-BIN-NEXT:    (ref.func $fglo)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )

  ;; CHECK-BIN:      (func $4 (type $9) (param $x (ref $ct1))
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (cont.bind $ct1 $ct0
  ;; CHECK-BIN-NEXT:    (i32.const 123)
  ;; CHECK-BIN-NEXT:    (local.get $x)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )

  ;; CHECK-BIN:      (func $f1 (type $f1)
  ;; CHECK-BIN-NEXT:  (suspend $e1)
  ;; CHECK-BIN-NEXT: )
  (func $f1 (export "unhandled-1")
    (suspend $e1)
  )

  ;; CHECK-TEXT:      (func $unhandled-2 (type $f1)
  ;; CHECK-TEXT-NEXT:  (resume $k1
  ;; CHECK-TEXT-NEXT:   (cont.new $k1
  ;; CHECK-TEXT-NEXT:    (ref.func $f1)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unhandled-2 (type $f1)
  ;; CHECK-BIN-NEXT:  (resume $k1
  ;; CHECK-BIN-NEXT:   (cont.new $k1
  ;; CHECK-BIN-NEXT:    (ref.func $f1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $unhandled-2 (export "unhandled-2")
    (resume $k1 (cont.new $k1 (ref.func $f1)))
  )

  ;; CHECK-TEXT:      (func $unhandled-3 (type $f1)
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $h (result (ref $k1))
  ;; CHECK-TEXT-NEXT:    (resume $k1 (on $e2 $h)
  ;; CHECK-TEXT-NEXT:     (cont.new $k1
  ;; CHECK-TEXT-NEXT:      (ref.func $f1)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unhandled-3 (type $f1)
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $block (result (ref $k1))
  ;; CHECK-BIN-NEXT:    (resume $k1 (on $e2 $block)
  ;; CHECK-BIN-NEXT:     (cont.new $k1
  ;; CHECK-BIN-NEXT:      (ref.func $f1)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (unreachable)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $unhandled-3 (export "unhandled-3")
    (block $h (result (ref $k1))
      (resume $k1 (on $e2 $h) (cont.new $k1 (ref.func $f1)))
      (unreachable)
    )
    (drop)
  )

  ;; CHECK-TEXT:      (func $handled (type $f1)
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $h (result (ref $k1))
  ;; CHECK-TEXT-NEXT:    (resume $k1 (on $e1 $h)
  ;; CHECK-TEXT-NEXT:     (cont.new $k1
  ;; CHECK-TEXT-NEXT:      (ref.func $f1)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $handled (type $f1)
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $block (result (ref $k1))
  ;; CHECK-BIN-NEXT:    (resume $k1 (on $e1 $block)
  ;; CHECK-BIN-NEXT:     (cont.new $k1
  ;; CHECK-BIN-NEXT:      (ref.func $f1)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (unreachable)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $handled (export "handled")
    (block $h (result (ref $k1))
      (resume $k1 (on $e1 $h) (cont.new $k1 (ref.func $f1)))
      (unreachable)
    )
    (drop)
  )

  (elem declare func $f2)
  ;; CHECK-TEXT:      (func $f2 (type $f1)
  ;; CHECK-TEXT-NEXT:  (throw $exn)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $f2 (type $f1)
  ;; CHECK-BIN-NEXT:  (throw $exn)
  ;; CHECK-BIN-NEXT: )
  (func $f2
    (throw $exn)
  )

  ;; CHECK-TEXT:      (func $uncaught-1 (type $f1)
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $h (result (ref $k1))
  ;; CHECK-TEXT-NEXT:    (resume $k1 (on $e1 $h)
  ;; CHECK-TEXT-NEXT:     (cont.new $k1
  ;; CHECK-TEXT-NEXT:      (ref.func $f2)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $uncaught-1 (type $f1)
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $block (result (ref $k1))
  ;; CHECK-BIN-NEXT:    (resume $k1 (on $e1 $block)
  ;; CHECK-BIN-NEXT:     (cont.new $k1
  ;; CHECK-BIN-NEXT:      (ref.func $f2)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (unreachable)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $uncaught-1 (export "uncaught-1")
    (block $h (result (ref $k1))
      (resume $k1 (on $e1 $h) (cont.new $k1 (ref.func $f2)))
      (unreachable)
    )
    (drop)
  )

  ;; CHECK-TEXT:      (func $uncaught-2 (type $f1)
  ;; CHECK-TEXT-NEXT:  (resume_throw $k1 $exn
  ;; CHECK-TEXT-NEXT:   (block $h (result (ref $k1))
  ;; CHECK-TEXT-NEXT:    (resume $k1 (on $e1 $h)
  ;; CHECK-TEXT-NEXT:     (cont.new $k1
  ;; CHECK-TEXT-NEXT:      (ref.func $f1)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $uncaught-2 (type $f1)
  ;; CHECK-BIN-NEXT:  (resume_throw $k1 $exn
  ;; CHECK-BIN-NEXT:   (block $block (result (ref $k1))
  ;; CHECK-BIN-NEXT:    (resume $k1 (on $e1 $block)
  ;; CHECK-BIN-NEXT:     (cont.new $k1
  ;; CHECK-BIN-NEXT:      (ref.func $f1)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (unreachable)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $uncaught-2 (export "uncaught-2")
    (block $h (result (ref $k1))
      (resume $k1 (on $e1 $h) (cont.new $k1 (ref.func $f1)))
      (unreachable)
    )
    (resume_throw $k1 $exn)
  )

  (elem declare func $f3)
  ;; CHECK-TEXT:      (func $f3 (type $f1)
  ;; CHECK-TEXT-NEXT:  (call $f4)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $f3 (type $f1)
  ;; CHECK-BIN-NEXT:  (call $f4)
  ;; CHECK-BIN-NEXT: )
  (func $f3
    (call $f4)
  )
  ;; CHECK-TEXT:      (func $f4 (type $f1)
  ;; CHECK-TEXT-NEXT:  (suspend $e1)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $f4 (type $f1)
  ;; CHECK-BIN-NEXT:  (suspend $e1)
  ;; CHECK-BIN-NEXT: )
  (func $f4
    (suspend $e1)
  )

  ;; CHECK-TEXT:      (func $uncaught-3 (type $f1)
  ;; CHECK-TEXT-NEXT:  (resume_throw $k1 $exn
  ;; CHECK-TEXT-NEXT:   (block $h (result (ref $k1))
  ;; CHECK-TEXT-NEXT:    (resume $k1 (on $e1 $h)
  ;; CHECK-TEXT-NEXT:     (cont.new $k1
  ;; CHECK-TEXT-NEXT:      (ref.func $f3)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $uncaught-3 (type $f1)
  ;; CHECK-BIN-NEXT:  (resume_throw $k1 $exn
  ;; CHECK-BIN-NEXT:   (block $block (result (ref $k1))
  ;; CHECK-BIN-NEXT:    (resume $k1 (on $e1 $block)
  ;; CHECK-BIN-NEXT:     (cont.new $k1
  ;; CHECK-BIN-NEXT:      (ref.func $f3)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (unreachable)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $uncaught-3 (export "uncaught-3")
    (block $h (result (ref $k1))
      (resume $k1 (on $e1 $h) (cont.new $k1 (ref.func $f3)))
      (unreachable)
    )
    (resume_throw $k1 $exn)
  )

  (elem declare func $r0 $r1)
  ;; CHECK-TEXT:      (func $r0 (type $f1)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $r0 (type $f1)
  ;; CHECK-BIN-NEXT: )
  (func $r0)

  ;; CHECK-TEXT:      (func $r1 (type $f1)
  ;; CHECK-TEXT-NEXT:  (suspend $e1)
  ;; CHECK-TEXT-NEXT:  (suspend $e1)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $r1 (type $f1)
  ;; CHECK-BIN-NEXT:  (suspend $e1)
  ;; CHECK-BIN-NEXT:  (suspend $e1)
  ;; CHECK-BIN-NEXT: )
  (func $r1 (suspend $e1) (suspend $e1))

  ;; CHECK-TEXT:      (func $nl1 (type $2) (param $k (ref $k1))
  ;; CHECK-TEXT-NEXT:  (resume $k1
  ;; CHECK-TEXT-NEXT:   (local.get $k)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (resume $k1
  ;; CHECK-TEXT-NEXT:   (local.get $k)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $nl1 (type $2) (param $k (ref $k1))
  ;; CHECK-BIN-NEXT:  (resume $k1
  ;; CHECK-BIN-NEXT:   (local.get $k)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (resume $k1
  ;; CHECK-BIN-NEXT:   (local.get $k)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $nl1 (param $k (ref $k1))
    (resume $k1 (local.get $k))
    (resume $k1 (local.get $k))
  )
  ;; CHECK-TEXT:      (func $nl2 (type $2) (param $k (ref $k1))
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $h (result (ref $k1))
  ;; CHECK-TEXT-NEXT:    (resume $k1 (on $e1 $h)
  ;; CHECK-TEXT-NEXT:     (local.get $k)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (resume $k1
  ;; CHECK-TEXT-NEXT:   (local.get $k)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (unreachable)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $nl2 (type $2) (param $k (ref $k1))
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $block (result (ref $k1))
  ;; CHECK-BIN-NEXT:    (resume $k1 (on $e1 $block)
  ;; CHECK-BIN-NEXT:     (local.get $k)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (unreachable)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (resume $k1
  ;; CHECK-BIN-NEXT:   (local.get $k)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (unreachable)
  ;; CHECK-BIN-NEXT: )
  (func $nl2 (param $k (ref $k1))
    (block $h (result (ref $k1))
      (resume $k1 (on $e1 $h) (local.get $k))
      (unreachable)
    )
    (resume $k1 (local.get $k))
    (unreachable)
  )
  ;; CHECK-TEXT:      (func $nl3 (type $2) (param $k (ref $k1))
  ;; CHECK-TEXT-NEXT:  (local $k' (ref null $k1))
  ;; CHECK-TEXT-NEXT:  (local.set $k'
  ;; CHECK-TEXT-NEXT:   (block $h1 (result (ref $k1))
  ;; CHECK-TEXT-NEXT:    (resume $k1 (on $e1 $h1)
  ;; CHECK-TEXT-NEXT:     (local.get $k)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $h2 (result (ref $k1))
  ;; CHECK-TEXT-NEXT:    (resume $k1 (on $e1 $h2)
  ;; CHECK-TEXT-NEXT:     (local.get $k')
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (resume $k1
  ;; CHECK-TEXT-NEXT:   (local.get $k')
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (unreachable)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $nl3 (type $2) (param $k (ref $k1))
  ;; CHECK-BIN-NEXT:  (local $k' (ref null $k1))
  ;; CHECK-BIN-NEXT:  (local.set $k'
  ;; CHECK-BIN-NEXT:   (block $block (result (ref $k1))
  ;; CHECK-BIN-NEXT:    (resume $k1 (on $e1 $block)
  ;; CHECK-BIN-NEXT:     (local.get $k)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (unreachable)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $block1 (result (ref $k1))
  ;; CHECK-BIN-NEXT:    (resume $k1 (on $e1 $block1)
  ;; CHECK-BIN-NEXT:     (local.get $k')
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (unreachable)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (resume $k1
  ;; CHECK-BIN-NEXT:   (local.get $k')
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (unreachable)
  ;; CHECK-BIN-NEXT: )
  (func $nl3 (param $k (ref $k1))
    (local $k' (ref null $k1))
    (block $h1 (result (ref $k1))
      (resume $k1 (on $e1 $h1) (local.get $k))
      (unreachable)
    )
    (local.set $k')
    (block $h2 (result (ref $k1))
      (resume $k1 (on $e1 $h2) (local.get $k'))
      (unreachable)
    )
    (resume $k1 (local.get $k'))
    (unreachable)
  )
  ;; CHECK-TEXT:      (func $nl4 (type $2) (param $k (ref $k1))
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (cont.bind $k1 $k1
  ;; CHECK-TEXT-NEXT:    (local.get $k)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (resume $k1
  ;; CHECK-TEXT-NEXT:   (local.get $k)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $nl4 (type $2) (param $k (ref $k1))
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (cont.bind $k1 $k1
  ;; CHECK-BIN-NEXT:    (local.get $k)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (resume $k1
  ;; CHECK-BIN-NEXT:   (local.get $k)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $nl4 (param $k (ref $k1))
    (drop (cont.bind $k1 $k1 (local.get $k)))
    (resume $k1 (local.get $k))
  )

  ;; CHECK-TEXT:      (func $non-linear-1 (type $f1)
  ;; CHECK-TEXT-NEXT:  (call $nl1
  ;; CHECK-TEXT-NEXT:   (cont.new $k1
  ;; CHECK-TEXT-NEXT:    (ref.func $r0)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $non-linear-1 (type $f1)
  ;; CHECK-BIN-NEXT:  (call $nl1
  ;; CHECK-BIN-NEXT:   (cont.new $k1
  ;; CHECK-BIN-NEXT:    (ref.func $r0)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $non-linear-1 (export "non-linear-1")
    (call $nl1 (cont.new $k1 (ref.func $r0)))
  )
  ;; CHECK-TEXT:      (func $non-linear-2 (type $f1)
  ;; CHECK-TEXT-NEXT:  (call $nl2
  ;; CHECK-TEXT-NEXT:   (cont.new $k1
  ;; CHECK-TEXT-NEXT:    (ref.func $r1)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $non-linear-2 (type $f1)
  ;; CHECK-BIN-NEXT:  (call $nl2
  ;; CHECK-BIN-NEXT:   (cont.new $k1
  ;; CHECK-BIN-NEXT:    (ref.func $r1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $non-linear-2 (export "non-linear-2")
    (call $nl2 (cont.new $k1 (ref.func $r1)))
  )
  ;; CHECK-TEXT:      (func $non-linear-3 (type $f1)
  ;; CHECK-TEXT-NEXT:  (call $nl3
  ;; CHECK-TEXT-NEXT:   (cont.new $k1
  ;; CHECK-TEXT-NEXT:    (ref.func $r1)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $non-linear-3 (type $f1)
  ;; CHECK-BIN-NEXT:  (call $nl3
  ;; CHECK-BIN-NEXT:   (cont.new $k1
  ;; CHECK-BIN-NEXT:    (ref.func $r1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $non-linear-3 (export "non-linear-3")
    (call $nl3 (cont.new $k1 (ref.func $r1)))
  )
  ;; CHECK-TEXT:      (func $non-linear-4 (type $f1)
  ;; CHECK-TEXT-NEXT:  (call $nl4
  ;; CHECK-TEXT-NEXT:   (cont.new $k1
  ;; CHECK-TEXT-NEXT:    (ref.func $r1)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $non-linear-4 (type $f1)
  ;; CHECK-BIN-NEXT:  (call $nl4
  ;; CHECK-BIN-NEXT:   (cont.new $k1
  ;; CHECK-BIN-NEXT:    (ref.func $r1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $non-linear-4 (export "non-linear-4")
    (call $nl4 (cont.new $k1 (ref.func $r1)))
  )

)
;; CHECK-BIN-NODEBUG:      (tag $tag$0 (type $0))

;; CHECK-BIN-NODEBUG:      (tag $tag$1 (type $0))

;; CHECK-BIN-NODEBUG:      (tag $tag$2 (type $0))

;; CHECK-BIN-NODEBUG:      (export "unhandled-1" (func $5))

;; CHECK-BIN-NODEBUG:      (export "unhandled-2" (func $6))

;; CHECK-BIN-NODEBUG:      (export "unhandled-3" (func $7))

;; CHECK-BIN-NODEBUG:      (export "handled" (func $8))

;; CHECK-BIN-NODEBUG:      (export "uncaught-1" (func $10))

;; CHECK-BIN-NODEBUG:      (export "uncaught-2" (func $11))

;; CHECK-BIN-NODEBUG:      (export "uncaught-3" (func $14))

;; CHECK-BIN-NODEBUG:      (export "non-linear-1" (func $21))

;; CHECK-BIN-NODEBUG:      (export "non-linear-2" (func $22))

;; CHECK-BIN-NODEBUG:      (export "non-linear-3" (func $23))

;; CHECK-BIN-NODEBUG:      (export "non-linear-4" (func $24))

;; CHECK-BIN-NODEBUG:      (func $0 (type $7) (param $0 (ref $6)) (result (ref $6))
;; CHECK-BIN-NODEBUG-NEXT:  (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $1 (type $8) (param $0 contref) (param $1 nullcontref) (param $2 (ref cont)) (param $3 (ref nocont)) (result contref)
;; CHECK-BIN-NODEBUG-NEXT:  (local.get $3)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $2 (type $0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $3 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$0
;; CHECK-BIN-NODEBUG-NEXT:   (cont.new $1
;; CHECK-BIN-NODEBUG-NEXT:    (ref.func $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $4 (type $9) (param $0 (ref $4))
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (cont.bind $4 $10
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 123)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $5 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (suspend $tag$1)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $6 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (resume $1
;; CHECK-BIN-NODEBUG-NEXT:   (cont.new $1
;; CHECK-BIN-NODEBUG-NEXT:    (ref.func $5)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $7 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $block (result (ref $1))
;; CHECK-BIN-NODEBUG-NEXT:    (resume $1 (on $tag$2 $block)
;; CHECK-BIN-NODEBUG-NEXT:     (cont.new $1
;; CHECK-BIN-NODEBUG-NEXT:      (ref.func $5)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $8 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $block (result (ref $1))
;; CHECK-BIN-NODEBUG-NEXT:    (resume $1 (on $tag$1 $block)
;; CHECK-BIN-NODEBUG-NEXT:     (cont.new $1
;; CHECK-BIN-NODEBUG-NEXT:      (ref.func $5)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $9 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (throw $tag$0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $10 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $block (result (ref $1))
;; CHECK-BIN-NODEBUG-NEXT:    (resume $1 (on $tag$1 $block)
;; CHECK-BIN-NODEBUG-NEXT:     (cont.new $1
;; CHECK-BIN-NODEBUG-NEXT:      (ref.func $9)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $11 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (resume_throw $1 $tag$0
;; CHECK-BIN-NODEBUG-NEXT:   (block $block (result (ref $1))
;; CHECK-BIN-NODEBUG-NEXT:    (resume $1 (on $tag$1 $block)
;; CHECK-BIN-NODEBUG-NEXT:     (cont.new $1
;; CHECK-BIN-NODEBUG-NEXT:      (ref.func $5)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $12 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (call $13)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $13 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (suspend $tag$1)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $14 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (resume_throw $1 $tag$0
;; CHECK-BIN-NODEBUG-NEXT:   (block $block (result (ref $1))
;; CHECK-BIN-NODEBUG-NEXT:    (resume $1 (on $tag$1 $block)
;; CHECK-BIN-NODEBUG-NEXT:     (cont.new $1
;; CHECK-BIN-NODEBUG-NEXT:      (ref.func $12)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $15 (type $0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $16 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (suspend $tag$1)
;; CHECK-BIN-NODEBUG-NEXT:  (suspend $tag$1)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $17 (type $2) (param $0 (ref $1))
;; CHECK-BIN-NODEBUG-NEXT:  (resume $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (resume $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $18 (type $2) (param $0 (ref $1))
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $block (result (ref $1))
;; CHECK-BIN-NODEBUG-NEXT:    (resume $1 (on $tag$1 $block)
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (resume $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $19 (type $2) (param $0 (ref $1))
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 (ref null $1))
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $1
;; CHECK-BIN-NODEBUG-NEXT:   (block $block (result (ref $1))
;; CHECK-BIN-NODEBUG-NEXT:    (resume $1 (on $tag$1 $block)
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $block1 (result (ref $1))
;; CHECK-BIN-NODEBUG-NEXT:    (resume $1 (on $tag$1 $block1)
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (resume $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $20 (type $2) (param $0 (ref $1))
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (cont.bind $1 $1
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (resume $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $21 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (call $17
;; CHECK-BIN-NODEBUG-NEXT:   (cont.new $1
;; CHECK-BIN-NODEBUG-NEXT:    (ref.func $15)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $22 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (call $18
;; CHECK-BIN-NODEBUG-NEXT:   (cont.new $1
;; CHECK-BIN-NODEBUG-NEXT:    (ref.func $16)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $23 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (call $19
;; CHECK-BIN-NODEBUG-NEXT:   (cont.new $1
;; CHECK-BIN-NODEBUG-NEXT:    (ref.func $16)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $24 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (call $20
;; CHECK-BIN-NODEBUG-NEXT:   (cont.new $1
;; CHECK-BIN-NODEBUG-NEXT:    (ref.func $16)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )
