; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mcpu=corei7 > /dev/null

; Verify that DAGCombiner doesn't crash with an assertion failure in the
; attempt to cast a ISD::UNDEF node to a ConstantSDNode.

; During type legalization, the vector shift operation in function @test1 is
; split into two legal shifts that work on <2 x i64> elements.
; The first shift of the legalized sequence would be a shift by all undefs.
; DAGCombiner will then try to simplify the vector shift and check if the
; vector of shift counts is a splat. Make sure that llc doesn't crash
; at that stage.


define <4 x i64> @test1(<4 x i64> %A) {
  %shl = shl <4 x i64> %A, <i64 undef, i64 undef, i64 1, i64 2>
  ret <4 x i64> %shl
}

; Also, verify that DAGCombiner doesn't crash when trying to combine shifts
; with different combinations of undef elements in the vector shift count.

define <4 x i64> @test2(<4 x i64> %A) {
  %shl = shl <4 x i64> %A, <i64 2, i64 3, i64 undef, i64 undef>
  ret <4 x i64> %shl
}

define <4 x i64> @test3(<4 x i64> %A) {
  %shl = shl <4 x i64> %A, <i64 2, i64 undef, i64 3, i64 undef>
  ret <4 x i64> %shl
}

define <4 x i64> @test4(<4 x i64> %A) {
  %shl = shl <4 x i64> %A, <i64 undef, i64 2, i64 undef, i64 3>
  ret <4 x i64> %shl
}

define <4 x i64> @test5(<4 x i64> %A) {
  %shl = shl <4 x i64> %A, <i64 2, i64 undef, i64 undef, i64 undef>
  ret <4 x i64> %shl
}

define <4 x i64> @test6(<4 x i64> %A) {
  %shl = shl <4 x i64> %A, <i64 undef, i64 undef, i64 3, i64 undef>
  ret <4 x i64> %shl
}

define <4 x i64> @test7(<4 x i64> %A) {
  %shl = shl <4 x i64> %A, <i64 undef, i64 undef, i64 undef, i64 3>
  ret <4 x i64> %shl
}

define <4 x i64> @test8(<4 x i64> %A) {
  %shl = shl <4 x i64> %A, <i64 undef, i64 undef, i64 undef, i64 undef>
  ret <4 x i64> %shl
}


