; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+zbb -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I %s

@PL_reg_match_utf8 = external global i8, align 1

declare signext i32 @test1(i8 signext)

declare signext i32 @test2(i8 signext)

declare signext i32 @test3(i8 signext)

define signext i32 @test() nounwind {
; RV64I-LABEL: test:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lui a0, %hi(PL_reg_match_utf8)
; RV64I-NEXT:    lb s0, %lo(PL_reg_match_utf8)(a0)
; RV64I-NEXT:    beqz s0, .LBB0_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call test1
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call test2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call test3
; RV64I-NEXT:    j .LBB0_3
; RV64I-NEXT:  .LBB0_2:
; RV64I-NEXT:    li a0, 0
; RV64I-NEXT:    call test2
; RV64I-NEXT:  .LBB0_3:
; RV64I-NEXT:    li a0, 0
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = load i8, ptr @PL_reg_match_utf8, align 1
  %2 = icmp eq i8 %1, 0
  br i1 %2, label %7, label %3

3:
  %4 = tail call signext i32 @test1(i8 signext %1)
  %5 = tail call signext i32 @test2(i8 signext %1)
  %6 = tail call signext i32 @test3(i8 signext %1)
  br label %9

7:
  %8 = tail call signext i32 @test2(i8 signext 0)
  br label %9

9:
  ret i32 0
}


define signext i32 @test_loop() nounwind {
; RV64I-LABEL: test_loop:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    li s1, -16
; RV64I-NEXT:    lui s2, %hi(PL_reg_match_utf8)
; RV64I-NEXT:    j .LBB1_2
; RV64I-NEXT:  .LBB1_1: # in Loop: Header=BB1_2 Depth=1
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call test2
; RV64I-NEXT:    addiw s1, s1, 1
; RV64I-NEXT:    beqz s1, .LBB1_4
; RV64I-NEXT:  .LBB1_2: # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    lb s0, %lo(PL_reg_match_utf8)(s2)
; RV64I-NEXT:    beqz s0, .LBB1_1
; RV64I-NEXT:  # %bb.3: # in Loop: Header=BB1_2 Depth=1
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call test1
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call test2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call test3
; RV64I-NEXT:    addiw s1, s1, 1
; RV64I-NEXT:    bnez s1, .LBB1_2
; RV64I-NEXT:  .LBB1_4:
; RV64I-NEXT:    li a0, 0
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
  br label %1

1:
  %2 = phi i32 [ 16, %0 ], [ %12, %11 ]
  %3 = load i8, ptr @PL_reg_match_utf8, align 1
  %4 = icmp eq i8 %3, 0
  br i1 %4, label %9, label %5

5:
  %6 = tail call signext i32 @test1(i8 signext %3)
  %7 = tail call signext i32 @test2(i8 signext %3)
  %8 = tail call signext i32 @test3(i8 signext %3)
  br label %11

9:
  %10 = tail call signext i32 @test2(i8 signext %3)
  br label %11

11:
  %12 = add nsw i32 %2, -1
  %13 = icmp eq i32 %12, 0
  br i1 %13, label %14, label %1

14:
  ret i32 0
}
