@echo off

setlocal ENABLEDELAYEDEXPANSION

set target_platform=%1
set target_configuration=%2
if "%target_platform%"=="" set target_platform=x64

if /I "%target_platform%" equ "all" (
  if "%target_configuration%"=="" (
    set target_configuration=all
  )
  call %0 x86 !target_configuration!
  call %0 x64 !target_configuration!
  call %0 arm !target_configuration!
  call %0 arm64 !target_configuration!
  goto :eof
)

if /I "%target_configuration%" equ "all" (
  call %0 %target_platform% Debug
  call %0 %target_platform% Release
  goto :eof
)

if "%target_configuration%"=="" (
 set target_configuration=Debug
)

set reference_output=%~p0\_reference\%target_platform%\%target_configuration%
set build_output=%~p0\_build\%target_platform%\%target_configuration%

echo Removing version stamps from %reference_output%\winrt
pushd %reference_output%\winrt
powershell -Command "gci -r -include *.h,*.ixx | %%{ (get-content $_) -replace 'was generated by.*|CPPWINRT_VERSION.*','' | set-content $_ }"
popd

echo Removing version stamps from %build_output%\winrt
pushd %build_output%\winrt
powershell -Command "gci -r -include *.h,*.ixx | %%{ (get-content $_) -replace 'was generated by.*|CPPWINRT_VERSION.*','' | set-content $_ }"
popd
