# 0.82.0 release notes

**Release date:** 2024-10-20

## Summary

Just six short months after our monstre [0.81.0 release](0.81.0.md), we're back with
another big one that adds

<div class="compact" markdown>
- Pentium MMX emulation,
- ESS Enhanced FM Audio,
- numerous audio related enhancements,
- a large number of game compatibility fixes,
- improved Windows 3.1x compatibility,
- supercharged 3dfx Voodoo emulation performance,
- experimental Windows ARM64 support,
</div>

and a lot more!

Read on to get the full story! :sunglasses:


## Downloads

Start by downloading the latest version, then make sure to upgrade your
primary configuration as described below.

<div class="compact" markdown>

- [Windows](../windows.md)
- [macOS](../macos.md)
- [Linux](../linux.md)

</div>

For those upgrading from an earlier DOSBox Staging version, please follow the
[upgrade instructions](#how-to-upgrade) below.

First-time users and people migrating from other DOSBox variants should start
by reading the [Getting started guide](../../getting-started/index.md).


## How to upgrade

### Upgrading your primary configuration

Since config settings might be renamed, altered, or deprecated between
releases, it's best to let DOSBox Staging write the new default primary config
on the first launch, then reapply your old settings manually.

Start by backing up your existing primary config. This is where to find
it on each platform:

<div class="compact" markdown>

| <!-- --> | <!-- -->
|----------|----------
| **Windows**  | `C:\Users\%USERNAME%\AppData\Local\DOSBox\dosbox-staging.conf`
| **macOS**    | `~/Library/Preferences/DOSBox/dosbox-staging.conf`
| **Linux**    | `~/.config/dosbox/dosbox-staging.conf`

</div>

You can also execute DOSBox Staging with the `--printconf` option to have the
location of the primary config printed to your console.

After backing up the existing primary config, simply start the new version---a
new `dosbox-staging.conf` will be written containing the new defaults and
updated setting descriptions.

!!! note "Portable mode notes"

    In portable mode, `dosbox-staging.conf` resides in the same folder as your
    DOSBox Staging executable. The migration steps for portable mode users are
    as follows:

      - Unpack the new version into a _new_ folder (this is important).
      - Create a new _empty_ `dosbox-staging.conf` file in the new folder to
        enable portable mode.
      - Launch the new version.

    DOSBox Staging will write the new defaults to the empty
    `dosbox-staging.conf` file. After this, you carry over your settings from
    the old primary config manually.

### After upgrading

Look for deprecation warnings in the logs (in yellow or orange colour) and
update your configs accordingly.


## Game compatibility fixes

- Fix regression in **Command & Conquer: Red Alert** where the emulator crashed
  after playing the game for a while.

- Fix regression in **The Magic Candle 2: The Four and Forty** where the
  second MIDI sequence did not play.

- Fix regression in **Soltys** where the Gravis UltraSound was not starting up
  after the game auto-detected it.

- Fix regression that prevented audio playing in **HELL: A Cyberpunk Thriller**
  on the Gravis Ultrasound.

- Fix **Dunkle Schatten 2** freezing after startup.

- Fix distorted HUD issue in the 3dfx Voodoo version of **Archimedean Dynasty**.

- Fix the odd horizontal black lines appearing in the following
  Synthetic Dimensions games:

    <div class="compact" markdown>

    - **Chronicles of the Sword**
    - **Druid: Daemons of the Mind**
    - **Perfect Assassin**

    </div>

- **1942: The Pacific Air War** can now be played with sound when using the JEMM memory manager
  (see [game notes](https://github.com/dosbox-staging/dosbox-staging/wiki/Game-issues#1942-the-pacific-air-war-including-gold)).

- Generically fix all Windows 3.1x games that complain about enabling file
  sharing, asking the user to run `SHARE.EXE`. This fixes at least the
  following games:

    <div class="compact" markdown>

    - **Comix Zone**
    - **Garfield Caught in the Act**
    - **Microsoft Flight Simulator (v5.0, ATC Workshop)**
    - **Monopoly**
    - **Ultimate Yahtzee**

    </div>

- Fix the intro tune in **Bumpy's Arcade Fantasy** using the wrong instruments
  on the MT-32.

- Fix the AdLib intro jingle not playing in Silmarlis games (e.g., **Crystals of
  Arborea**, **Ishar 1 & 2**, **Storm Master**, **Transantartica**, etc.)

- Fix flipped Sound Blaster Pro 2 output filter behaviour in **Doom** and
  all games that toggle the filter programmatically.


??? note Full PR list of game compatibility improvements

    - Add carry, sign, zero, and parity flags to integer division instructions (#3785)
    - Clean up some leaked file handles (#3673)
    - Fix decrementing of MPU-401 track and conductor counters (#3766)
    - Fix file open error in ISO Drive (#3804)
    - Fix programmatic toggling of the Sound Blaster Pro 2 output filter (#3815)
    - Fix regression in Voodoo 16-bit memory write (#3841)
    - Fix the GUS reset register's startup behavior (#3755)
    - Implement File Locking (#3687)
    - Initialise the OPL operators per the AdLib v1.51 driver (#3772)
    - Integrate MMX emulation (#3426)
    - Move System File Table memory location (#3680)
    - Prevent JEMM memory manager from detecting the VMware interface (#3925)
    - Simplify the GUS reset register logic and fix DMA IRQ handling (#3977)
    - Use inline memory routines for MMX (#3847)
    - Use linear 128 KB video memory pages for VESA modes (#3767)
    - Various MT-32 improvements & fix Bumpy's Arcade Fantasy intro tune (#3729)


## Graphics

### Remove the 'openglnb' output mode

The `openglnb` output mode for OpenGL with nearest-neighbour interpolation has
been removed (**nb** stood for "no bilinear", which is a roundabout way to say
"nearest-neighbour interpolation").

When using CRT shaders or any other shader, `openglnb` and `opengl` worked
exactly the same way---there was zero reason for preferring `openglnb`
over `opengl`.

The only legitimate use-case for `openglnb` was to get nearest-neighbour
interpolation with uneven pixels when not setting any shader explicitly. This
was a relic from the past from pre-shader times when you had to select between
two bad options when aspect-ratio correction was enabled: blurry output (with
bilinear filtering) or sharp output at the expense of uneven pixels (with
nearest-neighbour, or "no bilinear" interpolation). The much better current
solution in DOSBox Staging if you want the "sharp pixel" look is to use the
`sharp` shader.

If you _really_ want to, you can still use nearest-neighbour interpolation
with the new `nearest` shader. But you'll get far better results with
`sharp`, especially on 1080p displays.

The `texturenb` output mode remains available as a last resort fallback for
weak hardware with no functional OpenGL drivers.


### New xBR upscaler shaders

A few of [Hyllian's xBR upscaling
shaders](https://forums.libretro.com/t/xbr-algorithm-tutorial/123) have been
added for those hell-bent on playing games with a fake high-resolution look:

<div class="compact" markdown>

  - `scaler/xbr-lv2-3d`
  - `scaler/xbr-lv2-noblend`
  - `scaler/xbr-lv3`

</div>


### 3dfx Voodoo improvements

- 16-bit memory writes have been fixed in our Voodoo emulation; this resolves
  the distorted HUD issue in the 3dfx Voodoo version of **Archimedean Dynasty**.

- The `voodoo_multithreading` confing setting (which previously toggled three
  extra worker threads), has been replaced with `voodoo_threads` which uses up
  to eight threads based on the number of available physical CPU cores. This
  is enabled by default (`auto` setting), but you can override it by setting
  the number of threads manually from 1 to 16.

- The multithreading performance of the Voodoo emulation has been generally
  improved---at the cost of higher overall CPU usage. Set `voodoo_threads` to
  3 or less to conserve battery power on a laptop.

- Fixed a bug where the wrong shader could be picked when starting a Voodoo
  game with the adaptive CRT shaders enabled.


### Other graphics improvements

- Fixed the hardware cursor handling on the S3 Trio64 card; this fixes the display
  corruption on exit issue in the [Teddybear's Revenge](https://www.pouet.net/prod.php?which=76)
  demo by Eclipse.

- Now we use linear 128 KB video memory pages for all VESA modes. Some games exploit
  this low-level detail of some SVGA cards to access the video memory as a
  single contiguous 128 KB memory block instead of manually flipping between
  two 64 KB pages. This enhancement gets rid of the odd horizontal black lines
  in the following Synthetic Dimensions games and possibly in other games and
  demoscene productions too that use the same hack:

    <div class="compact" markdown>

      - **Chronicles of the Sword**
      - **Druid — Daemons of the Mind**
      - **Perfect Assassin**

    </div>

- Fixed a regression where video captures resulted in slightly larger file
  sizes than previously.


??? note "Full PR list of graphics-related changes"

    - Add `use_nearest_texture_filter` shader pragma and `nearest` shader (#3852)
    - Add xBR upscaler shaders (#3855)
    - Address additional feedback on Voodoo thread count PR #3935 (#3939)
    - Auto switch shader when starting a Voodoo game (#3968)
    - Check if hardware cursor is actually being enabled or disabled before setting VGA_LineDraw (#3725)
    - Comment out voodoo logging for local blending API call (#3907)
    - Fix Windows 98 S3 driver regression (#3946)
    - Fix ZMBV CompareBlock function returning a negative value for 24/32bpp types (#3908)
    - Fix `INT10_ReloadFont()` regression on VGA (#3943)
    - Fix assert failure from incorrectly mapping result of SDL_GL_SwapInterval() (#3844)
    - Fix regression in Voodoo 16-bit memory write (#3841)
    - Import missing S3 Trio64 XGA compare and fill routines from DOSBox-X (#3775)
    - Kill `openglnb` with fire 🔥🔥🔥🔥🔥 (#3672)
    - Minor `vga_draw.cpp` refactor (#3734)
    - Presentation mode, host rate & vsync cleanup (#3824)
    - Remove obsolete Intel iGPU workaround (#3978)
    - Use atomic operations and busy wait for Voodoo threads (#3952)
    - Use linear 128 KB video memory pages for VESA modes (#3767)


## Sound

### Multi-threaded audio processing

Some audio devices, such as the MT-32 and FluidSynth, were already running in
their own threads. We've taken this to the next level, and now the DOSBox
mixer itself has got its own dedicated thread, too. This greatly reduces and
often completely eliminates audio stuttering and glitches. The improvement is
especially noticeable in games that use the Roland MT-32 or FluidSynth for
MIDI music, the AdLib/OPL synth, the IBM Music Feature Card (IMFC), or Red
Book CD Audio.

For example, now you should get zero glitches in the intro of **Eric the
Unready** on the MT-32 when the game repeatedly switches between 320&times;200
and 640&times;480 VGA modes.

We plan to take this approach even further in the following releases, with the
ultimate goal of achieving a 100% glitch-free, hardware-like audio experience.


### ESS Enhanced FM Audio (ESFM) emulation

DOS audio connoisseurs, we have a real treat for you! We've added support for
emulating **ESS Enhanced FM Audio**, or **ESFM**, the
OPL3-compatible FM synth found on later ESS AudioDrive cards.

In "legacy mode", ESFM is fully compatible with the Yamaha OPL3; on most
materials, it yields almost identical output (with the occasional subtle
difference). What sets it apart is its "native mode", in which it
offers advanced synthesis features surpassing the capabilities of the OPL3
chips. It bridges the gap between synthetic-sounding OPL music and
MIDI music that uses sampled real instruments---it definitely makes those
expensive external MIDI modules run for their money!

Unfortunately, since ESFM was released in 1995, only a handful of games
support "native mode," but in the few that do, the results sound quite
spectacular!

- To run ESFM in "legacy mode", use `oplmode = esfm` with any Sound Blaster
  model and configure the game for Sound Blaster and AdLib/OPL as usual.

- To use "native mode", set `sbtype = ess` and configure the **ESS Technology
  ES1688, ES1788, ES1888 Enhanced FM Audio** MIDI music driver in the game's
  setup utility (most games that support ESFM natively use the Miles Sound
  System). For the digital audio driver, select the Sound Blaster Pro option
  (ESS AudioDrive cards are Sound Blaster Pro compatible).

Here's a non-exhaustive list of games that support ESFM Enhanced FM music. If
you discover more, please let us know!

<div class="compact" markdown>

- 11th Hour, The
- Advanced Civilization
- Callahan's Crosstime Saloon
- Gene Machine, The
- Heaven's Dawn
- Heroes of Might and Magic II
- Magic Carpet 2
- Settlers II, The
- Shannara
- Theme Hospital
- WarCraft II
- Z

</div>

<div class="compact" markdown>

| Game                                          | Audio example                                                                                                                 |
| --------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------- |
| Heroes of Might and Magic II — Title (ESFM)   | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/heroes2-title-esfm.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| Heroes of Might and Magic II — Title (OPL)  | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/heroes2-title-opl.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| Heroes of Might and Magic II — In-game (ESFM)      | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/heroes2-ingame-esfm.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| Heroes of Might and Magic II — In-game (OPL)         | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/heroes2-ingame-opl.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| The Settlers 2 — Track 5 (ESFM)   | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/settlers2-track5-esfm.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| The Settlers 2 — Track 5 (OPL)    | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/settlers2-track5-opl.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| The Settlers 2 — Track 14 (ESFM)    | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/settlers2-track14-esfm.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| The Settlers 2 — Track 14 (OPL)    | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/settlers2-track14-opl.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| The Gene Machine (ESFM)  | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/the-gene-machine-esfm.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| The Gene Machine (OPL)  | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/the-gene-machine-opl.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| Heaven's Dawn (ESFM)  | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/heavens-dawn-esfm.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| Heaven's Dawn (OPL)  | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/heavens-dawn-opl.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |

</div>

The more adventurous among you can also try to "retrofit" the `ESFM.MID`
driver from Miles Sound System games that have it into earlier ones that
don't.

Here's how **Discworld** sounds with the ESFM driver from **Heaven's
Dawn**—it's pretty great, sounds almost like sample-based music!

|                                           | |
| --------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------- |
| Discworld (ESFM)   | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/discworld-kitchen-esfm.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |
| Discworld (OPL)  | <audio controls src="https://dosbox-staging.github.io/static/audio/release-notes/0.82.0/discworld-kitchen-opl.mp3"> Your browser does not support the <code>audio</code> element.</audio>   |


### AdLib/OPL DC bias remover

Some games like **Golden Eagle** and **Wizardry VI: Bane of the Cosmic Forge**
play digitised music and sound effects using the OPL (AdLib) channels by rapidly
changing the volume in very crude steps, similar to how the Disney Sound System
and Covox LPT DAC operate.

We've introduced a new `opl_remove_dc_bias` config setting to the `[sblaster]`
section, eliminating these annoying pops in affected games.

Recommended audio settings for **Wizardry VI: Bane of the Cosmic Forge** when
configured for AdLib sound:


```ini
[sblaster]
sbtype = none
oplmode = opl2
opl_remove_dc_bias = true
opl_filter = lpf 2 5500

[speaker]
pcspeaker = off

[autoexec]
mixer opl 500
```

### Default to the 'impulse' PC speaker model

The `impulse` PC speaker model has been made the default option as it emulates
the iconic little speaker found in old PCs more faithfully and with fewer
overall issues.

The catch is that a small percentage of games have problems with it, so you
might need to revert to the legacy and less accurate `discrete` model on a
per-game basis.


### Decouple CMS and AdLib/OPL emulation

The **CMS (Creative Sound System or Game Blaster)** and **OPL (AdLib)**
emulations have finally been decoupled. DOSBox always treated the emulation of
the CMS as "just another OPL option", which was completely wrong as the AdLib
and the CMS use different sound chips and have nothing to do with each other.

This resulted in various complications, such as `oplmode = opl2` always
enabling CMS emulation as well (probably to allow emulating early Sound
Blaster cards that featured both the OPL2 and CMS chips).

The new model allows the user to control the OPL and CMS emulations
separately:

- `oplmode` only determines the type of OPL chip(s) to emulate. Valid values are `none`, `opl2`, `dualopl2`, `opl3`, and `opl3gold`.
- The new `cms` config setting in the `[sblaster]` section controls whether to
  emulate the CMS. Valid values are `on` and `off`.

!!! warning

    As usual, `oplmode = cms` is still accepted with a deprecation warning,
    but you should update your configs to use the new model as we might remove
    support for the legacy settings in the future.


### Sound Blaster Pro 2 output filter fix

Previously, toggling the analog output filter programmatically on the Sound
Blaster Pro 2 (`sbtype = sbpro2`) was flipped due to a coding error. You
can hear the difference in games that toggle the filter, such as **Doom**, when
configured for the SB Pro 2 and authentic output filter emulation is enabled
with `sb_filter = auto`.


### AdLib/OPL improvements

The OPL (AdLib) chip is now initialised with the official AdLib v1.51 driver's
startup values instead of the chip's native power-on state. Most games don't
care about this because they fully overwrite the card with whatever state they
need at startup, but this fixed the missing intro jingle in the following Silmarils
games:

<div class="compact" markdown>

- Boston Bomb Club
- Bunny Bricks
- Crystals of Arborea
- Ishar 1
- Ishar 2
- Metal Mutant
- Storm Master
- Transantartica

</div>

### Gravis Ultrasound fixes & improvements

- Fixed a regression that prevented the Gravis Ultrasound from playing audio
  in **HELL: A Cyberpunk Thriller** and the demo [Atlantis by Riot](https://www.pouet.net/prod.php?which=12690).

- The Gravis UltraSound and Sound Blaster can coexist now when you run
  `ULTRINIT.EXE`. This way, you can use the SB for digital sound effects and
  GUS for MIDI music via `ULTRAMID.EXE` or `MEGAEM.EXE` in supported games.

- The Gravis Ultrasound's configuration options have been revised to reflect
  the actual options available on real hardware:

    - `gusbase` — Base addresses now range from 210 through 260
    - `gusirq` — IRQs 2 and 15 have been added
    - `gusdma` — DMA 0 has been dropped (this setting is only useful on real hardware
      to park/disable the GUS)

- Fix crash in Fasttracker II when GUS is configured to use IRQ 7.


### Further mixer improvements

- Fix lower-pitched audio bug when the emulated audio device's sample rate
  exceeds the host sample rate. E.g., if a program uses the maximum native
  45&thinsp;454 Hz Sound Blaster rate and the host rate is 44&thinsp;100 Hz.

- Host sample rates can now be set continuously from 8000 Hz to 96 kHz.
  This makes DOSBox Staging fully placebo and audio snake oil compliant!
  :sunglasses: :metal:
  Also, by setting custom sample rates, you can capture audio at an emulated
  device's native rate without resampling.

- `blocksize` can now be set to non-power-of-two values, too.

- The `nosound` option now works better because it renders the audio and
  progresses the audio frames rendered counters (e.g., FastTracker II now
  plays the module even in "no sound" mode; previously, it was completely
  stalled). Additionally, you can now capture the audio to a WAV file even in
  "no sound" mode.


### Other audio improvements

- Turn off the "cable delay" emulation MIDI for the MT-32. This fixes the
  intro tune in **Bumpy's Arcade Fantasy**, and probably other game startup
  issues, too.

- Use 16-bit integer rendering mode for the MT-32 which is more accurate to
  the real hardware and much faster. Also, use "nice" partials mode and
  render at libmt32's 48 kHz "analog emulation" rate for improved
  authenticity.

- Map the **Capture MIDI action** to ++ctrl+alt+f6++ by default
  (++cmd+opt+f6++ on macOS).

- Reading audio data from physical CD-ROMs is now done in a separate thread,
  which should eliminate latency and stuttering issues.

- Windows CD-ROM audio is now routed through the DOSBox mixer, bringing it to
  feature parity with Linux.

- Fix no CD Audio issue on Windows if using a USB CD drive (SATA
  drives worked fine).

- The strength of the `tiny` reverb preset has been reduced by 25% as it
  sounded too strong; now it simulates the natural reverberation of a domestic
  room better.

- When using the PipeWire sound daemon on Linux, tools like `pw-top`,
  `pavucontrol`, or the KDE volume applet now show "DOSBox Staging" as the
  application's name instead of the generic "SDL Application".

??? note "Full PR list of sound-related changes"

    - Add a simple DC bias remover for the OPL output (#3310)
    - Add support for ESS mixer registers (#3702)
    - Decouple CMS and OPL emulations (#3559)
    - ESFM emulation (#3614)
    - Fix CD audio support on physical USB drives on Windows (#3840)
    - Fix ESS mixer volume handling (#3705)
    - Fix Ring Buffer PrevIndex() wrapping behavior for non power of 2 size (#3813)
    - Fix Sound Blaster programmatic low-pass filter toggling behaviour (#3712)
    - Fix SoundBlaster DMA stuttering in The Rocketeer (#3915)
    - Fix data race on mixer volume change (#3923)
    - Fix decrementing of MPU-401 track and conductor counters (#3766)
    - Fix programmatic toggling of the Sound Blaster Pro 2 output filter (#3815)
    - Fix the GUS reset register's startup behavior (#3755)
    - Fix thread sanitizer warnings in threaded GUS code (#3919)
    - Further mixer fixes and improvements mega PR #2 (#3756)
    - Improve `sbtype` and `oplmode` descriptions & clean up `sblaster.cpp` (#3566)
    - Improve tiny reverb preset for small-speaker emulation (#3867)
    - Initialise the OPL operators per the AdLib v1.51 driver (#3772)
    - Let GUS use its documented IRQ, DMA, and base addresses (#3960)
    - Make the `impulse` PC speaker model the default (#3851)
    - Map 'Capture MIDI action' to Ctrl+Alt+F6 (Cmd+Opt+F6) by default (#3714)
    - Mirror the Adlib command port (388h) in the GUS (#3763)
    - Move mixer to a seperate thread (#3848)
    - Rework physical CDROM interface (#3591)
    - Show the mixer who's boss 😎 (#3650)
    - Sync Nuked-OPL3 with upstream (#3818)
    - Various MT-32 improvements & fix Bumpy's Arcade Fantasy intro tune (#3729)


## Input

- Fix hang on exiting DOSBox Staging after pressing the ++pause++ key.

- General keyboard handling accuracy improvements, allowing us to get rid of
  the **Ultima VIII** game-specific hack.

??? note "Full PR list of input-related changes"

    - Fix hang on exit after pressing the pause key (#3671)
    - Fix mouse support in Descent II with a Voodoo patch (#3896)
    - Remove special case for joystick axis 2 and 5 and add detection for gamepad trigger buttons (#3885)
    - Replace Ultima VIII keyboard hack with a proper solution (#3784)
    - Revert "Fix mouse support in Descent II with a Voodoo patch" (#3903)

## DOS integration

### New MODE command

A new `MODE` command has been added to set the display mode of the DOS prompt
and the keyboard's typematic rate. The command is loosely based on the
original MS-DOS `MODE` command, but it supports a lot more display modes.

Examples of setting a custom text mode:

```
mode 80x30
mode 80x43
mode 132x34
```

Setting the fastest key repeat with the shortest repeat delay (everybody's
favourite):

```
mode rate=32 delay=1
```

Run `mode /?` to see the full list of options.


### File sharing support

Certain Windows 3.1x programs that rely on `SHARE.EXE` or `VSHARE.386` would
display an error on startup, complaining that `SHARE.EXE` has not been loaded.
This mostly affects office programs (e.g., Microsoft Office, Lotus Office,
Peachtree Complete Accounting, etc.), but also a few games.

The previous workaround was to rely on a small utility called `FAKESHAR.COM`
which, as the name implies, fakes that `SHARE.EXE` is running. This worked mostly
fine with games but could lead to data corruption when using application
programs.

We've added support for file sharing and locking, which means workarounds like
`FAKESHAR.COM` are no longer necessary. All Windows 3.1x games that complain
about `SHARE.EXE` not running should now work out-of-the-box. This fixes at
least the following games:

<div class="compact" markdown>

- Comix Zone
- Garfield Caught in the Act
- Microsoft Flight Simulator (v5.0, ATC Workshop)
- Monopoly
- Ultimate Yahtzee

</div>


### Improved physical CD-ROM mounting

Physical CD-ROM devices are now auto-detected when using the `MOUNT`
command---no more need to use the additional clunky `-usecd` parameter (this
has been removed).

For example:

- **Windows:** `mount d d:\ -t cdrom`
- **Linux:** `mount d /mnt/cdrom -t cdrom`


### Other DOS integration improvements

- `LOADFIX` can now be used with batch files.

- Fix improper handling of some special characters in shell history.

- Improve redirection handling in the DOS shell. This helps with a few game
  installers (e.g., running the **B-Wing Add-On** installer for **X-Wing**
  corrupted the game files without this fix).

- More accurate System File Table (SFT) emulation. This helps with some game
  compatibility issues, e.g. **Dunkle Shatten 2** was freezing without this fix.

- The `DEBUG` and `XCOPY` commands from FreeDOS have been updated to their
  latest versions.

- The command shell now handles double quotes without preceding spaces
  similarly to real MS-DOS. For example, `ECHO"` will now print an empty line
  and batch files that use squashed syntax, like `IF"%1"=="1" GOTO adlib`, will
  now also work.

- The [JEMM memory manager](https://github.com/Baron-von-Riedesel/Jemm) now
  works even with DOSBox Staging's VMware mouse emulated enabled (previuosly,
  JEMM could only be started with `vmware_mouse = off`). This is useful for
  games like **1942: The Pacific Air War** which does not work correctly with
  Staging's emulated EMS memory.


??? note "Full PR list of DOS integration related changes"

    - Add MODE command & various text mode improvements (#3741)
    - Allow loadfix to execute batch files (#3657)
    - Clean up some leaked file handles (#3673)
    - Do not hard exit when running `SET /P` (#3789)
    - Fix Reboot Handler crash (#3683)
    - Fix Windows 3.1 regression from SFT change (#3744)
    - Fix `IMGMOUNT` command error message (#3863)
    - Fix broken shell_history_file config option (std::weak_ptr version) (#3664)
    - Fix improper handling of some characters in shell history (#3791)
    - Fix shell history creation regression (#3485)
    - Fix shell redirection for appending to the end of a file (#3873)
    - Handle double-quotes in the shell similar to real MS-DOS (#3924)
    - Implement File Locking (#3687)
    - Improve redirection handling in the DOS shell (#3838)
    - Improve reset handler (#3696)
    - Keep file handle instead of entry in FileReader (#3528)
    - MODE command fixes & improvements (#3853)
    - Move System File Table memory location (#3680)
    - Move environment functions to psp (+ other small changes) (#3093)
    - Replace use of `stat` in imgmount (#3465)
    - The great DOS_File/DOS_Drive Refactor (plus some timestamp improvements) (#3786)
    - Update bundled FreeDOS binaries (#3876)
    - Use native file I/O in local and overlay drive (#3765)
    - Use wrapping behavior on localFile seek position (#3779)


## General

### Pentium MMX emulation

Finally, we've added Pentium MMX instruction set emulation to run late-90s
demoscene productions (e.g., [heaven seven by
Exceed](https://m.pouet.net/prod.php?which=5)) and the odd game with
MMX-specific enhancements (e.g., **Extreme Assault** and **Z.A.R.**). And
yeah, now you can use the MMX-only real-time resonant filters in Impulse
Tracker, too :sunglasses:

You must enable MMX emulation explicitly by setting `cputype = pentium_mmx` in
your config. All normal and dynamic cores are supported on all platforms.


### Simplified CPU cycles settings

The `cycles` setting has been a source of a lot of confusion, so we've
replaced it with a much simpler way to configure the emulated CPU speed
(believe it or not, there are over 20 valid `cycles` value permutations!)

The new streamlined CPU cycles settings are as follows:

- `cpu_cycles` — Global or real mode only cycles setting.
- `cpu_cycles_protected` — Optional protected mode only cycles setting.
- `cpu_throttle` — Whether the CPU emulation should be dynamically throttled if your host CPU cannot keep up.

Please refer to the settings' descriptions to learn more (e.g., run `config -h
cpu_cycles` from the DOS prompt).

Here are a few concrete examples:

**Set fixed speed globally**

This will roughly emulate the speed of the venerable i486DX2-66 in both real and protected mode. `cpu_cycles_protected = auto` means `cpu_cycles` controls the emulated CPU speed globally, both for real and protected mode.

```ini
[cpu]
cpu_cycles = 25000
cpu_cycles_protected = auto
```

**Different real and protected mode speeds with throttling**

20k cycles for real mode programs, and 400k for protected mode. Throttling is enabled, so if your host machine can't keep up, the actual number of emulated CPU cycles per millisecond will be dynamically lowered.

```ini
[cpu]
cpu_cycles = 20000
cpu_cycles_protected = 400000
cpu_throttle = on
```

**Max speed**

This will make the CPU emulation run as fast as your computer can handle it. Pretty useful when compiling programs, rendering 3D images, or playing late '90s 3D games at 640&times;480 or higher resolutions (as long as they can run glitch-free on very fast CPUs).

```ini
[cpu]
cpu_cycles = max
cpu_cycles_protected = max
```

!!! note "Backward compatibility with `cycles`"

    The legacy `cycles` setting is still available for backward compatibility
    with existing configs. When `cycles` is set, the new CPU settings are
    simply ignored. Do note, however, that we might remove support for `cycles`
    in the future; please start migrating your configs to the new settings
    now.


### Revised CPU cycles defaults

!!! important "Summary of changes"

    - The default emulated CPU speed (cycles) setting for **protected mode**
    programs has been changed from **max** to **60&thinsp;000 cycles**.

    - The **real mode** default of **3000 cycles** is unchanged.

    - When "legacy cycles mode" is enabled by setting `cycles` explicitly, the
      old "max cycles" protected mode default applies.


DOSBox traditionally defaulted to 3000 cycles for real mode programs, and "max
cycles" (as fast as your host CPU can go) for protected mode programs. 3000
cycles for real mode is a good middle-of-the-road setting that gets most games
running (even if not optimally). The "max cycles" setting, on the other hand,
is quite problematic for a couple of reasons:

- A significant number of games crash, misbehave, or manifest subtle bugs when
  the emulated CPU is "too fast". In the early days of DOSBox, `cycles = max`
  was not a problem because the much slower host CPUs from 10-20 years ago
  acted as a "natural throttle" on the effective emulation speed. However,
  many of those old speed-sensitive games that used to work with `cycles =
  max` are now broken on today's fast CPUs.

- The `max` setting is not transferable across setups as it depends on the
  host CPU's speed. Games configured for `cycles = max` might work fine on
  _your_ particular machine, but they could break on your friend's faster
  computer or yours a few years later when you get your next CPU upgrade.
  The `max N%` cycles setting (e.g., `max 70%`) is plagued by the same
  problem.

- `cycles = max` often causes audio glitches and drop-outs in games. It's best
  to use the _lowest fixed cycles value_ that runs the game at an acceptable
  speed (read more tips about that
  [here](https://dosbox-staging.github.io/getting-started/beneath-a-steel-sky/#adjusting-the-emulated-cpu-speed)).

- Some DOS programs _really_ freak out when the emulated CPU is being
  dynamically changed at runtime, which is what `max` tends to do.

All in all, `max` for protected mode is not a good default in 2024, so we've
changed it to **fixed 60&thinsp;000 cycles**, which is roughly equivalent to slow Pentium
speeds. As protected mode games started appearing in the early to mid-90s,
this should run the vast majority of games fairly optimally out-of-the-box.


### 'cputype' normalisation

After introducing the `pentium_mmx` CPU type, we felt the need to clean up the
`cputype` options a bit and make them more logical:

<div class="compact" markdown>

- `386_slow` has been renamed to `386`
- `386` has been renamed to `386_fast`
- `486_slow` has been renamed to `486`
- `pentium_slow` has been renamed to `pentium`

</div>

Please refer to the description of the `cputype` setting for further info
(e.g., execute `config -h cputype` from the DOS prompt).

The descriptions of all CPU settings have been extensively revised and now
include helpful hints, so it's recommended that you familiarise yourself with
them (run `config -h cpu` to see the complete list of CPU settings).

!!! warning

    The old renamed `cputype` values are still accepted with a deprecation
    warning, but you should update your configs to use the new values, as we
    might remove support for the legacy settings in the future.


### Improved CONFIG command

The `CONFIG` command's output is now paginated when you use it to display a
config setting's description (e.g., `config -h glshader` of `config -h
cpu_cycles`). Previously you had to pipe the output through the `MORE` command
to paginate the output, which was a hassle (i.e., `config -h glshader |
more`).

The formatting and colouring of the `CONFIG` command's output has also been
improved.


### Configurable window title bar

You can now fully customise the information displayed in the emulator window's
title bar.

For example, this configuration

```ini
[sdl]
window_titlebar = program=none version=detailed mouse=short
```

yields the following to be displayed in the title bar:


```
DOSBox Staging 0.82.0-alpha (9fdba) - 3000 cycles/ms
```

An animated audio/video capturing indicator and a pause indicator has also
been added.

Please refer to the `window_titlebar` setting's description to learn about the
available options (e.g., run `config -h window_titlebar` from the DOS prompt).


### Read-only directory mounts

The `MOUNT` command now accepts the `-ro` flag to create read-only
(write-protected) directory mounts (the `IMGMOUNT` command already had this
option).

For auto-mounts, you can specify `readonly = true` in the `[drive]` section of
the mount config file (see resources).

Additionally, the built-in `Y` drive has been made read-only by default (you
can change this in `resources/drives/y.conf`, of course, if you want to).


### Experimental Windows ARM64 builds

We're ready for the ARM revolution! :sunglasses:

Luckily, we already have a battle-tested dynamic ARM recompiler that we've
been using for the Apple Silicon macOS builds, so we started providing
experimental Windows ARM64 packages for devices such as the Snapdragon X
Elite.

The ARM64 packages can be downloaded from our [development builds](../development-builds.md)
page (requires a GitHub account).

We don't provide any official support for the experimental Windows ARM64
builds yet.


### Other general improvements

- The **IPX server** has been moved into its own dedicated thread.
  This should improve multi-player game performance, especially for the host
  running the IPX server.

- The **IBM Extended Density Format (XDF)** was used by IBM for software
  distribution on 5.25" and 3.5" media. XDF image files were often provided by
  IBM on CD-ROMs, bulletin boards, and FTP sites.

- A more realistic implementation of the **Time Stamp Counter (TSC)** found on
  Pentium and later CPUs, often used to determine the CPU clock. Now various
  benchmark software should display more realistic CPU speeds (e.g., HWINFO
  and SiSoft Sandra). Games don't seem to be affected by this improvement.

- **Software-initiated reset** requests now restart the emulator instead of
  crashing it. The reset message has been improved and now includes a countdown
  counter.

- Fixed a modem emulation bug where the user could dial themselves (their own
  DOSBox instances), resulting in weird behaviour in games.


??? note "Full PR list of miscellaneous enhancements"

    - Add IBM XDF floppy support (#3442)
    - Add carry, sign, zero, and parity flags to integer division instructions (#3785)
    - `CONFIG` command enhancements (#3667)
    - Config setting improvements and `CONFIG` command fixes (#3754)
    - Implement read-only mounting + make Y drive read-only by default (#3711)
    - Improve the `core` and `cputype` setting descriptions (#3708)
    - Improve title bar and make it configurable (#3249)
    - Integrate MMX emulation (#3426)
    - Introduce a better way to set the CPU cycles with new defaults (#3681)
    - Make the Time Stamp Counter more realistic (#3471)
    - Move IPX server to a background thread (#3414)
    - Paginate the CONFIG command's output (#3758)
    - Prevent JEMM memory manager from detecting the VMware interface (#3925)
    - Provide application name to SDL (#3926)
    - Show memory read breakpoint with BPLIST (#3396)


??? note "Full PR list of miscellaneous fixes"

    - Add DOS Files to shutdown step to avoid a crash when shutting down (#3801)
    - Allow running the `INTRO` built-in from subshells (#3665)
    - Avoid unnecessary new-lines (#3617)
    - Close modem server socket before dialing (#3979)
    - `CONFIG -h` should only list visible setting values (#3753)
    - Discard incoming modem traffic from waiting clients (#3983)
    - Fix division regression by resetting flag type (#3795)
    - Fix 'output' and other 'sdl' settings not changeable in runtime (#3571)
    - Fix IPX ping value display (#3418)
    - Fix MMX crash on moralhardcandy (#3814)
    - Fix Windows 3.1 regression from SFT change (#3744)
    - Fix byte calculation overflow using pages per MB (#3942)
    - Fix file open error in ISO Drive (#3804)
    - Fix switch to dynamic core warning edge case (#3732)
    - Fix warning when using a high cycles value on a non-dynamic core (#3716)
    - Follow-up fix for Debian package on `main` push (#3930)
    - Make parameter addresses properly sized in ppc64le dynrec (fixes #3686) (#3718)
    - Use CreateFileW on Windows to create file in local_drive_create_file() (#3746)


??? note "Full PR list of documentation-related changes"

    - Add bisecting notes to build documentation (#3816)
    - Add comment about PPC64 big-endian and running 32-bit BE code (#3827)
    - Add warning about CMake support being experimental (#3790)
    - Clarify build instructions for low memory targets (#3658)
    - Create .clang-tidy (#3423)
    - Improve the GUS config setting descriptions (#3862)
    - Remove -usecd and -listcd MOUNT parameters from INTRO and the README (#3625)
    - Simple documentation fixes (#3782)
    - Update Windows build guide (#3424)
    - website: Add NixOS install instructions (#3479)


??? note "Full PR list of project maintenance related changes"

    - Add Debian package build scripts and workflow (#3809)
    - Advance vcpkg baseline to upgrade to SDL 2.30.0 (#3606)
    - Allow SDL wraps to be bypassed on macOS (#3483)
    - Audio cleanups (#3615)
    - Avoid the use of std::string_view::data() (#3542)
    - Basic CMake support (#3361)
    - Bump Coverity build from Clang 14 to Clang 15 (#3419)
    - Bump PVS Studio CI from Clang 14 to Clang 15 (#3437)
    - Bump vcpkg baseline and update to upstream libslirp v4.8.0 (#3761)
    - Callback code generation rework (#3748)
    - Centralize app_id handling (continuation) (#3854)
    - Change ppc64 to use correct `POWERPC` target (#3826)
    - Clean up macOS notarization script (#3408)
    - Cleanup a few warnings in cdrom_image.cpp (#3472)
    - Cleanup of using namespace (#3444)
    - Cleanup some missed C++ header conversions (#3412)
    - Create new cross compiler docker images and adjust workflows (#3678)
    - DYN_LOG: Fix formatting type mismatch (#3869)
    - Do not auto-run DOSBox Staging after installing it on Windows (#3583)
    - Eliminate excessive repeat heap calls during normal runtime (#3812)
    - Enable SDL atomic subsystem in Meson wrap (#3934)
    - Fix ARM64 Windows builds (#3973)
    - Fix CDROM_Interface pointer ownership issue (#3634)
    - Fix MSVC CI builds (#3474)
    - Fix compilation warnings reported by g++ 14.1 (#3783)
    - Fix data race in the mapper when using `autotype` (#3928)
    - Fix issue with replace() (#3533)
    - Fix 'launchable' in the Flathub metainfo.xml file (#3933)
    - Fix macOS CI workflow (#3505)
    - Fix sed creating backup files ending with "-e" in macOS bundle (#3406)
    - Fix some PVS warnings (#3484)
    - Fix variables optimizing away when debugging MSClang builds (#3397)
    - Fix vcredist version for MSVC CI runner (#3480)
    - Handle SDL2 like the other dependencies (#3864)
    - Ignore meson.build in VS tests project (#3422)
    - Introduce custom release notes drafter script & workflow (#3398)
    - Make GCC 11 / Ubuntu 22.04 the minimum build target (#3674)
    - Mass update copyright dates (#3584)
    - Migrate to C++20 (#3286)
    - Minor FPU cleanup (#3837)
    - More PVS warning fixes (#3494)
    - Move environment functions to psp (+ other small changes) (#3093)
    - Pin CMake version for MSVC runner (#3598)
    - Reinstate creating the Windows installer package in CI (#3849)
    - Release drafter enhancements (#3546)
    - Remove Debian 10 support (#3534)
    - Remove GCC_LIKELY/GCC_UNLIKELY (#3293)
    - Search for numbered clang-format binaries in format-commit.sh (#3747)
    - Unicode API refactoring (#3797)
    - Unify use of prop->Set_values (#3572)
    - Update SDL wrap to 2.30.6 (#3856)
    - Update simde to 0.8.0 (#3522)
    - Update string_utils to use C++20 constructs (#3540)
    - Upgrade SIMDE to 0.8.2 (#3662)
    - Upgrade Windows CI setup-msbuild GitHub action (#3477)
    - Usage of integer types & disabling sign conversion warnings (#3631)
    - Use C++ system headers (#3284)
    - Use GitHub actions cache for vcpkg (#3503)
    - Use GitHub runners for macOS builds (#3384)
    - Use inline memory routines for MMX (#3847)
    - Use std::atomic for CaptureState enum (#3931)


??? note "Full PR list of other changes"

    - Allow the PVS-Studio workflow run in forked PRs (#3493)
    - Build Windows package for the ARM64 platform (#3823)
    - Don't execute compile workflows on documentation and script changes (#3393)
    - Fix CI to create Debian package on `main` push (#3929)
    - Fix fs_utils_tests for macOS and enable test runs on macOS CI (#3622)
    - Fix msys2 compilation error with cdrom_win32.cpp (#3676)
    - Include DEBUG.COM license in the packages (#3897)
    - Introduce unittests for the Value class (#3369)
    - Minor fix to x87 64-bit memcpy (#3866)
    - Remove hard-coded version string from MSVC CI (#3736)
    - Upgrade deprecated Node.js 16 GitHub actions to latest (#3457)


## Localisation

- Update Dutch, French, Italian, Polish, Portugese, and Spanish translations.
- Use uncompressed CPI code page files instead of the compressed
  FreeDOS-specific CPX format. This improves code page switching
  performance, which was rather slow with low `cpu_cycles` settings.
- Ensure all platform-specific translatable strings are visible to the
  translators.
- Fix format string issues in several translations.

??? note "Full PR list of localisation-related changes"

    - Avoid false positive warnings in translations (#3610)
    - Ensure logs are UTF-8 on Windows, improve deprecated config warning log (#3893)
    - Fix Dutch (nl) translation (#3967)
    - Further refinements to the Italian (it) translation (#3880)
    - Get rid of TAB (0x09) characters and convert ANSI escape sequences to tags in French (fr) translation (#3970)
    - Improve italian (it) translation (#3877)
    - Make the titlebar cycles display translatable again (#3890)
    - Translation (format string) fixes across several languages (#3964)
    - Translations differ between platforms (#3579)
    - Update Dutch (nl) translation (#3874)
    - Update German (de) translation (#3888)
    - Update Italian (it) translation (#3871)
    - Update Polish (pl) translation (#3870)
    - Update Polish (pl) translation (#3944)
    - Update Polish (pl) translation, minor help string fix (#3850)
    - Update Polish (pl) translation, minor string fixes (#3684)
    - Update Portuguese Translation (#3609)
    - Update Spanish translation (#3624)
    - Update italian (it) translation (#3751)
    - Use uncompressed CPI files instead of compressed CPX ones (#3413)


## Contributors

The following commit authors, sponsors, supporters, and backers all invested
their time or funds into the 0.82 release effort. Thank you!

Contributors are listed in alphabetic order.

Thank you for considering supporting our work through a donation on
[GitHub Sponsors](https://github.com/sponsors/dosbox-staging) or
[Open Collective](https://opencollective.com/dosbox-staging). Your
contribution helps us purchase the necessary hardware and licenses to keep our
project going.


### 0.82 commit authors

<div class="compact" markdown>

- altiereslima
- Arcnor
- bluddy
- Burrito78
- classilla
- dreamer
- farsil
- FeralChild64
- ftortoriello
- Grounded0
- interloper98
- japsmits
- johnnovak
- Kappa971
- kcgen
- keenanweaver
- kklobe
- LowLevelMahn
- MeAreJeenius
- rderooy
- Ringdingcoder
- shermp
- stackErr-NameNotResolved
- strikersix23
- Torinde
- weirddan455

</div>


### 0.82 sponsors

<div class="compact" markdown>

- Antti Peltola

</div>

### 0.82 supporters

<div class="compact" markdown>

- Wengier Wu

</div>


### 0.82 backers

<div class="compact" markdown>

- BenBudr
- Burrito78
- Diduz
- Florent Wagner
- Hannu Hartikainen
- Hugo Lucorcio
- marvin-tr-81
- Robin Mattheussen

</div>


## Thank you

We are grateful for all the community contributions and the original DOSBox
project, on which DOSBox Staging is based.
