#ifndef _DRAGON_H_INCLUDED_
#define _DRAGON_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Dragon.h
// --------
// Dragon interface module 
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//                                                         
// INTERFACE MODULE
//
// Class: Dragon
// 
// Description: body module for the dragon parser generater 
//
///////////////////////////////////////////////////////////////////////////////

// Base includes

#include <lfcbase/Chain.h>
#include <lfcbase/SetT.h>
#include <lfcbase/TreeT.h>
#include <lfcbase/ListT.h>

// Dragon includes

#include "Terminal.h"
#include "Production.h"
#include "FirstHash.h"
#include "TransHash.h"
#include "ParseTableEntry.h"
#include "LR1Hash.h"
#include "LR1Trans.h"
#include "ClosureCache.h"


class Dragon {
  
public:

    enum ParserMode { LR1, LALR };

    Dragon(const Chain& parserName, ParserMode m, bool dynamicTable);

    ~Dragon();
    
    void generate(bool dumpIt);

    virtual void generateCode() = 0;
    
    void printParseTable();
    
protected:

    SetT<Chain> _epsSet;    

    SetT<Terminal> _terminalSet;
    SetT<Production> _productionSet;

    ListT<Chain> _sepsignList;
    ListT<Chain> _sepignoreList;

    ListT<ParseTableEntry> _parseTable;
    
    SetT<FirstHash> _firstHashSet;
    SetT<LR1Hash> _LR1HashSet;
    SetT<LR1Trans> _LR1TransSet;

    int _rot;
    void rotate();


    ParserMode _mode;

    int _numStates;
    int _numProd;

    Chain _parserName;
    bool _dynamicTable;

    void readHeader();
    void readTerminals();
    void readProductions();

    void checkProductions();

    void hashFirstSet();
    void getFirstSet(SetT<Chain>& firstSet, const Chain& s);
    void getEpsilonJump(SetT<Chain>& firstSet, const Chain& prod);

    void createTable();
    void createParseTable();

    /*
    void generateCode();
    void generateJavaCode();
    void generateHeaderCode();
    void generateMethodCode();

    void generateGoLangCode();
    */
    
};

#endif





