_exported_symbols = []

# Modules
import duckdb.functional as functional
import duckdb.typing as typing
import functools

_exported_symbols.extend([
    "typing",
    "functional"
])

# Classes
from .duckdb import (
    DuckDBPyRelation,
    DuckDBPyConnection,
    Statement,
    ExplainType,
    StatementType,
    ExpectedResultType,
	CSVLineTerminator,
    PythonExceptionHandling,
    RenderMode,
    Expression,
    ConstantExpression,
    ColumnExpression,
    DefaultExpression,
    CoalesceOperator,
    LambdaExpression,
    StarExpression,
    FunctionExpression,
    CaseExpression,
)
_exported_symbols.extend([
    "DuckDBPyRelation",
    "DuckDBPyConnection",
    "ExplainType",
    "PythonExceptionHandling",
    "Expression",
    "ConstantExpression",
    "ColumnExpression",
    "DefaultExpression",
    "CoalesceOperator",
    "LambdaExpression",
    "StarExpression",
    "FunctionExpression",
    "CaseExpression",
])

# These are overloaded twice, we define them inside of C++ so pybind can deal with it
_exported_symbols.extend([
    'df',
    'arrow'
])
from .duckdb import (
    df,
    arrow
)

# NOTE: this section is generated by tools/pythonpkg/scripts/generate_connection_wrapper_methods.py.
# Do not edit this section manually, your changes will be overwritten!

# START OF CONNECTION WRAPPER

from .duckdb import (
	cursor,
	register_filesystem,
	unregister_filesystem,
	list_filesystems,
	filesystem_is_registered,
	create_function,
	remove_function,
	sqltype,
	dtype,
	type,
	array_type,
	list_type,
	union_type,
	string_type,
	enum_type,
	decimal_type,
	struct_type,
	row_type,
	map_type,
	duplicate,
	execute,
	executemany,
	close,
	interrupt,
	fetchone,
	fetchmany,
	fetchall,
	fetchnumpy,
	fetchdf,
	fetch_df,
	df,
	fetch_df_chunk,
	pl,
	fetch_arrow_table,
	arrow,
	fetch_record_batch,
	torch,
	tf,
	begin,
	commit,
	rollback,
	checkpoint,
	append,
	register,
	unregister,
	table,
	view,
	values,
	table_function,
	read_json,
	extract_statements,
	sql,
	query,
	from_query,
	read_csv,
	from_csv_auto,
	from_df,
	from_arrow,
	from_parquet,
	read_parquet,
	from_parquet,
	read_parquet,
	get_table_names,
	install_extension,
	load_extension,
	project,
	distinct,
	write_csv,
	aggregate,
	alias,
	filter,
	limit,
	order,
	query_df,
	description,
	rowcount,
)

_exported_symbols.extend([
	'cursor',
	'register_filesystem',
	'unregister_filesystem',
	'list_filesystems',
	'filesystem_is_registered',
	'create_function',
	'remove_function',
	'sqltype',
	'dtype',
	'type',
	'array_type',
	'list_type',
	'union_type',
	'string_type',
	'enum_type',
	'decimal_type',
	'struct_type',
	'row_type',
	'map_type',
	'duplicate',
	'execute',
	'executemany',
	'close',
	'interrupt',
	'fetchone',
	'fetchmany',
	'fetchall',
	'fetchnumpy',
	'fetchdf',
	'fetch_df',
	'df',
	'fetch_df_chunk',
	'pl',
	'fetch_arrow_table',
	'arrow',
	'fetch_record_batch',
	'torch',
	'tf',
	'begin',
	'commit',
	'rollback',
	'checkpoint',
	'append',
	'register',
	'unregister',
	'table',
	'view',
	'values',
	'table_function',
	'read_json',
	'extract_statements',
	'sql',
	'query',
	'from_query',
	'read_csv',
	'from_csv_auto',
	'from_df',
	'from_arrow',
	'from_parquet',
	'read_parquet',
	'from_parquet',
	'read_parquet',
	'get_table_names',
	'install_extension',
	'load_extension',
	'project',
	'distinct',
	'write_csv',
	'aggregate',
	'alias',
	'filter',
	'limit',
	'order',
	'query_df',
	'description',
	'rowcount',
])

# END OF CONNECTION WRAPPER

# Enums
from .duckdb import (
    ANALYZE,
    DEFAULT,
    RETURN_NULL,
    STANDARD,
    COLUMNS,
    ROWS
)
_exported_symbols.extend([
    "ANALYZE",
    "DEFAULT",
    "RETURN_NULL",
    "STANDARD"
])


# read-only properties
from .duckdb import (
    __standard_vector_size__,
    __interactive__,
    __jupyter__,
    __version__,
    apilevel,
    comment,
    identifier,
    keyword,
    numeric_const,
    operator,
    paramstyle,
    string_const,
    threadsafety,
    token_type,
    tokenize
)
_exported_symbols.extend([
    "__standard_vector_size__",
    "__interactive__",
    "__jupyter__",
    "__version__",
    "apilevel",
    "comment",
    "identifier",
    "keyword",
    "numeric_const",
    "operator",
    "paramstyle",
    "string_const",
    "threadsafety",
    "token_type",
    "tokenize"
])


from .duckdb import (
    connect,
    default_connection,
    set_default_connection,
)

_exported_symbols.extend([
    "connect",
    "default_connection",
    "set_default_connection",
])

# Exceptions
from .duckdb import (
    Error,
    DataError,
    ConversionException,
    OutOfRangeException,
    TypeMismatchException,
    FatalException,
    IntegrityError,
    ConstraintException,
    InternalError,
    InternalException,
    InterruptException,
    NotSupportedError,
    NotImplementedException,
    OperationalError,
    ConnectionException,
    IOException,
    HTTPException,
    OutOfMemoryException,
    SerializationException,
    TransactionException,
    PermissionException,
    ProgrammingError,
    BinderException,
    CatalogException,
    InvalidInputException,
    InvalidTypeException,
    ParserException,
    SyntaxException,
    SequenceException,
    Warning
)
_exported_symbols.extend([
    "Error",
    "DataError",
    "ConversionException",
    "OutOfRangeException",
    "TypeMismatchException",
    "FatalException",
    "IntegrityError",
    "ConstraintException",
    "InternalError",
    "InternalException",
    "InterruptException",
    "NotSupportedError",
    "NotImplementedException",
    "OperationalError",
    "ConnectionException",
    "IOException",
    "HTTPException",
    "OutOfMemoryException",
    "SerializationException",
    "TransactionException",
    "PermissionException",
    "ProgrammingError",
    "BinderException",
    "CatalogException",
    "InvalidInputException",
    "InvalidTypeException",
    "ParserException",
    "SyntaxException",
    "SequenceException",
    "Warning"
])

# Value
from .value.constant import (
    Value,
    NullValue,
    BooleanValue,
    UnsignedBinaryValue,
    UnsignedShortValue,
    UnsignedIntegerValue,
    UnsignedLongValue,
    BinaryValue,
    ShortValue,
    IntegerValue,
    LongValue,
    HugeIntegerValue,
    FloatValue,
    DoubleValue,
    DecimalValue,
    StringValue,
    UUIDValue,
    BitValue,
    BlobValue,
    DateValue,
    IntervalValue,
    TimestampValue,
    TimestampSecondValue,
    TimestampMilisecondValue,
    TimestampNanosecondValue,
    TimestampTimeZoneValue,
    TimeValue,
    TimeTimeZoneValue,
)

_exported_symbols.extend([
    "Value",
    "NullValue",
    "BooleanValue",
    "UnsignedBinaryValue",
    "UnsignedShortValue",
    "UnsignedIntegerValue",
    "UnsignedLongValue",
    "BinaryValue",
    "ShortValue",
    "IntegerValue",
    "LongValue",
    "HugeIntegerValue",
    "FloatValue",
    "DoubleValue",
    "DecimalValue",
    "StringValue",
    "UUIDValue",
    "BitValue",
    "BlobValue",
    "DateValue",
    "IntervalValue",
    "TimestampValue",
    "TimestampSecondValue",
    "TimestampMilisecondValue",
    "TimestampNanosecondValue",
    "TimestampTimeZoneValue",
    "TimeValue",
    "TimeTimeZoneValue",
])

__all__ = _exported_symbols
