#define len_trim__(cad,len) ({                           integer _r=0,i;                           for(i=0; i<(len) && (cad)[i]; i++)                             if((cad)[i] != ' ') _r=i;                           _r+1; })
#define ceiling_(a) (myceil(*(a)))
#define myceil(a) (sizeof(a) == sizeof(float) ? ceilf(a) : ceil(a))
#include <math.h>
/*  -- translated by f2c (version 20200916).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#define __LAPACK_PRECISION_SINGLE
#include "f2c.h"

/* Table of constant values */

static complex c_b1 = {1.f,0.f};

/* > \brief \b CHETRS_3 */

/*  =========== DOCUMENTATION =========== */

/* Online html documentation available at */
/*            http://www.netlib.org/lapack/explore-html/ */

/* > \htmlonly */
/* > Download CHETRS_3 + dependencies */
/* > <a href="http://www.netlib.org/cgi-bin/netlibfiles.tgz?format=tgz&filename=/lapack/lapack_routine/chetrs_
3.f"> */
/* > [TGZ]</a> */
/* > <a href="http://www.netlib.org/cgi-bin/netlibfiles.zip?format=zip&filename=/lapack/lapack_routine/chetrs_
3.f"> */
/* > [ZIP]</a> */
/* > <a href="http://www.netlib.org/cgi-bin/netlibfiles.txt?format=txt&filename=/lapack/lapack_routine/chetrs_
3.f"> */
/* > [TXT]</a> */
/* > \endhtmlonly */

/*  Definition: */
/*  =========== */

/*       SUBROUTINE CHETRS_3( UPLO, N, NRHS, A, LDA, E, IPIV, B, LDB, */
/*                            INFO ) */

/*       CHARACTER          UPLO */
/*       INTEGER            INFO, LDA, LDB, N, NRHS */
/*       INTEGER            IPIV( * ) */
/*       COMPLEX            A( LDA, * ), B( LDB, * ), E( * ) */


/* > \par Purpose: */
/*  ============= */
/* > */
/* > \verbatim */
/* > CHETRS_3 solves a system of linear equations A * X = B with a complex */
/* > Hermitian matrix A using the factorization computed */
/* > by CHETRF_RK or CHETRF_BK: */
/* > */
/* >    A = P*U*D*(U**H)*(P**T) or A = P*L*D*(L**H)*(P**T), */
/* > */
/* > where U (or L) is unit upper (or lower) triangular matrix, */
/* > U**H (or L**H) is the conjugate of U (or L), P is a permutation */
/* > matrix, P**T is the transpose of P, and D is Hermitian and block */
/* > diagonal with 1-by-1 and 2-by-2 diagonal blocks. */
/* > */
/* > This algorithm is using Level 3 BLAS. */
/* > \endverbatim */

/*  Arguments: */
/*  ========== */

/* > \param[in] UPLO */
/* > \verbatim */
/* >          UPLO is CHARACTER*1 */
/* >          Specifies whether the details of the factorization are */
/* >          stored as an upper or lower triangular matrix: */
/* >          = 'U':  Upper triangular, form is A = P*U*D*(U**H)*(P**T); */
/* >          = 'L':  Lower triangular, form is A = P*L*D*(L**H)*(P**T). */
/* > \endverbatim */
/* > */
/* > \param[in] N */
/* > \verbatim */
/* >          N is INTEGER */
/* >          The order of the matrix A.  N >= 0. */
/* > \endverbatim */
/* > */
/* > \param[in] NRHS */
/* > \verbatim */
/* >          NRHS is INTEGER */
/* >          The number of right hand sides, i.e., the number of columns */
/* >          of the matrix B.  NRHS >= 0. */
/* > \endverbatim */
/* > */
/* > \param[in] A */
/* > \verbatim */
/* >          A is COMPLEX array, dimension (LDA,N) */
/* >          Diagonal of the block diagonal matrix D and factors U or L */
/* >          as computed by CHETRF_RK and CHETRF_BK: */
/* >            a) ONLY diagonal elements of the Hermitian block diagonal */
/* >               matrix D on the diagonal of A, i.e. D(k,k) = A(k,k); */
/* >               (superdiagonal (or subdiagonal) elements of D */
/* >                should be provided on entry in array E), and */
/* >            b) If UPLO = 'U': factor U in the superdiagonal part of A. */
/* >               If UPLO = 'L': factor L in the subdiagonal part of A. */
/* > \endverbatim */
/* > */
/* > \param[in] LDA */
/* > \verbatim */
/* >          LDA is INTEGER */
/* >          The leading dimension of the array A.  LDA >= f2cmax(1,N). */
/* > \endverbatim */
/* > */
/* > \param[in] E */
/* > \verbatim */
/* >          E is COMPLEX array, dimension (N) */
/* >          On entry, contains the superdiagonal (or subdiagonal) */
/* >          elements of the Hermitian block diagonal matrix D */
/* >          with 1-by-1 or 2-by-2 diagonal blocks, where */
/* >          If UPLO = 'U': E(i) = D(i-1,i),i=2:N, E(1) not referenced; */
/* >          If UPLO = 'L': E(i) = D(i+1,i),i=1:N-1, E(N) not referenced. */
/* > */
/* >          NOTE: For 1-by-1 diagonal block D(k), where */
/* >          1 <= k <= N, the element E(k) is not referenced in both */
/* >          UPLO = 'U' or UPLO = 'L' cases. */
/* > \endverbatim */
/* > */
/* > \param[in] IPIV */
/* > \verbatim */
/* >          IPIV is INTEGER array, dimension (N) */
/* >          Details of the interchanges and the block structure of D */
/* >          as determined by CHETRF_RK or CHETRF_BK. */
/* > \endverbatim */
/* > */
/* > \param[in,out] B */
/* > \verbatim */
/* >          B is COMPLEX array, dimension (LDB,NRHS) */
/* >          On entry, the right hand side matrix B. */
/* >          On exit, the solution matrix X. */
/* > \endverbatim */
/* > */
/* > \param[in] LDB */
/* > \verbatim */
/* >          LDB is INTEGER */
/* >          The leading dimension of the array B.  LDB >= f2cmax(1,N). */
/* > \endverbatim */
/* > */
/* > \param[out] INFO */
/* > \verbatim */
/* >          INFO is INTEGER */
/* >          = 0:  successful exit */
/* >          < 0:  if INFO = -i, the i-th argument had an illegal value */
/* > \endverbatim */

/*  Authors: */
/*  ======== */

/* > \author Univ. of Tennessee */
/* > \author Univ. of California Berkeley */
/* > \author Univ. of Colorado Denver */
/* > \author NAG Ltd. */

/* > \date June 2017 */

/* > \ingroup complexHEcomputational */

/* > \par Contributors: */
/*  ================== */
/* > */
/* > \verbatim */
/* > */
/* >  June 2017,  Igor Kozachenko, */
/* >                  Computer Science Division, */
/* >                  University of California, Berkeley */
/* > */
/* >  September 2007, Sven Hammarling, Nicholas J. Higham, Craig Lucas, */
/* >                  School of Mathematics, */
/* >                  University of Manchester */
/* > */
/* > \endverbatim */

/*  ===================================================================== */
void  chetrs_3__(char *uplo, integer *n, integer *nrhs, 
	complex *a, integer *lda, complex *e, integer *ipiv, complex *b, 
	integer *ldb, integer *info)
{
    /* System generated locals */
    integer a_dim1, a_offset, b_dim1, b_offset, i__1, i__2;
    complex q__1, q__2, q__3;

    /* Local variables */
    integer i__, j, k;
    real s;
    complex ak, bk;
    integer kp;
    complex akm1, bkm1, akm1k;
    extern logical lsame_(char *, char *);
    complex denom;
    extern void  cswap_(integer *, complex *, integer *, 
	    complex *, integer *), ctrsm_(char *, char *, char *, char *, 
	    integer *, integer *, complex *, complex *, integer *, complex *, 
	    integer *);
    logical upper;
    extern void  csscal_(integer *, real *, complex *, integer 
	    *), xerbla_(char *, integer *);


/*  -- LAPACK computational routine (version 3.7.1) -- */
/*  -- LAPACK is a software package provided by Univ. of Tennessee,    -- */
/*  -- Univ. of California Berkeley, Univ. of Colorado Denver and NAG Ltd..-- */
/*     June 2017 */


/*  ===================================================================== */


    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    --e;
    --ipiv;
    b_dim1 = *ldb;
    b_offset = 1 + b_dim1;
    b -= b_offset;

    /* Function Body */
    *info = 0;
    upper = lsame_(uplo, "U");
    if (! upper && ! lsame_(uplo, "L")) {
	*info = -1;
    } else if (*n < 0) {
	*info = -2;
    } else if (*nrhs < 0) {
	*info = -3;
    } else if (*lda < f2cmax(1,*n)) {
	*info = -5;
    } else if (*ldb < f2cmax(1,*n)) {
	*info = -9;
    }
    if (*info != 0) {
	i__1 = -(*info);
	xerbla_("CHETRS_3", &i__1);
	return;
    }

/*     Quick return if possible */

    if (*n == 0 || *nrhs == 0) {
	return;
    }

    if (upper) {

/*        Begin Upper */

/*        Solve A*X = B, where A = U*D*U**H. */

/*        P**T * B */

/*        Interchange rows K and IPIV(K) of matrix B in the same order */
/*        that the formation order of IPIV(I) vector for Upper case. */

/*        (We can do the simple loop over IPIV with decrement -1, */
/*        since the ABS value of IPIV(I) represents the row index */
/*        of the interchange with row i in both 1x1 and 2x2 pivot cases) */

	for (k = *n; k >= 1; --k) {
	    kp = (i__1 = ipiv[k], abs(i__1));
	    if (kp != k) {
		cswap_(nrhs, &b[k + b_dim1], ldb, &b[kp + b_dim1], ldb);
	    }
	}

/*        Compute (U \P**T * B) -> B    [ (U \P**T * B) ] */

	ctrsm_("L", "U", "N", "U", n, nrhs, &c_b1, &a[a_offset], lda, &b[
		b_offset], ldb);

/*        Compute D \ B -> B   [ D \ (U \P**T * B) ] */

	i__ = *n;
	while(i__ >= 1) {
	    if (ipiv[i__] > 0) {
		i__1 = i__ + i__ * a_dim1;
		s = 1.f / a[i__1].r;
		csscal_(nrhs, &s, &b[i__ + b_dim1], ldb);
	    } else if (i__ > 1) {
		i__1 = i__;
		akm1k.r = e[i__1].r, akm1k.i = e[i__1].i;
		c_div(&q__1, &a[i__ - 1 + (i__ - 1) * a_dim1], &akm1k);
		akm1.r = q__1.r, akm1.i = q__1.i;
		r_cnjg(&q__2, &akm1k);
		c_div(&q__1, &a[i__ + i__ * a_dim1], &q__2);
		ak.r = q__1.r, ak.i = q__1.i;
		q__2.r = akm1.r * ak.r - akm1.i * ak.i, q__2.i = akm1.r * 
			ak.i + akm1.i * ak.r;
		q__1.r = q__2.r - 1.f, q__1.i = q__2.i - 0.f;
		denom.r = q__1.r, denom.i = q__1.i;
		i__1 = *nrhs;
		for (j = 1; j <= i__1; ++j) {
		    c_div(&q__1, &b[i__ - 1 + j * b_dim1], &akm1k);
		    bkm1.r = q__1.r, bkm1.i = q__1.i;
		    r_cnjg(&q__2, &akm1k);
		    c_div(&q__1, &b[i__ + j * b_dim1], &q__2);
		    bk.r = q__1.r, bk.i = q__1.i;
		    i__2 = i__ - 1 + j * b_dim1;
		    q__3.r = ak.r * bkm1.r - ak.i * bkm1.i, q__3.i = ak.r * 
			    bkm1.i + ak.i * bkm1.r;
		    q__2.r = q__3.r - bk.r, q__2.i = q__3.i - bk.i;
		    c_div(&q__1, &q__2, &denom);
		    b[i__2].r = q__1.r, b[i__2].i = q__1.i;
		    i__2 = i__ + j * b_dim1;
		    q__3.r = akm1.r * bk.r - akm1.i * bk.i, q__3.i = akm1.r * 
			    bk.i + akm1.i * bk.r;
		    q__2.r = q__3.r - bkm1.r, q__2.i = q__3.i - bkm1.i;
		    c_div(&q__1, &q__2, &denom);
		    b[i__2].r = q__1.r, b[i__2].i = q__1.i;
		}
		--i__;
	    }
	    --i__;
	}

/*        Compute (U**H \ B) -> B   [ U**H \ (D \ (U \P**T * B) ) ] */

	ctrsm_("L", "U", "C", "U", n, nrhs, &c_b1, &a[a_offset], lda, &b[
		b_offset], ldb);

/*        P * B  [ P * (U**H \ (D \ (U \P**T * B) )) ] */

/*        Interchange rows K and IPIV(K) of matrix B in reverse order */
/*        from the formation order of IPIV(I) vector for Upper case. */

/*        (We can do the simple loop over IPIV with increment 1, */
/*        since the ABS value of IPIV(I) represents the row index */
/*        of the interchange with row i in both 1x1 and 2x2 pivot cases) */

	i__1 = *n;
	for (k = 1; k <= i__1; ++k) {
	    kp = (i__2 = ipiv[k], abs(i__2));
	    if (kp != k) {
		cswap_(nrhs, &b[k + b_dim1], ldb, &b[kp + b_dim1], ldb);
	    }
	}

    } else {

/*        Begin Lower */

/*        Solve A*X = B, where A = L*D*L**H. */

/*        P**T * B */
/*        Interchange rows K and IPIV(K) of matrix B in the same order */
/*        that the formation order of IPIV(I) vector for Lower case. */

/*        (We can do the simple loop over IPIV with increment 1, */
/*        since the ABS value of IPIV(I) represents the row index */
/*        of the interchange with row i in both 1x1 and 2x2 pivot cases) */

	i__1 = *n;
	for (k = 1; k <= i__1; ++k) {
	    kp = (i__2 = ipiv[k], abs(i__2));
	    if (kp != k) {
		cswap_(nrhs, &b[k + b_dim1], ldb, &b[kp + b_dim1], ldb);
	    }
	}

/*        Compute (L \P**T * B) -> B    [ (L \P**T * B) ] */

	ctrsm_("L", "L", "N", "U", n, nrhs, &c_b1, &a[a_offset], lda, &b[
		b_offset], ldb);

/*        Compute D \ B -> B   [ D \ (L \P**T * B) ] */

	i__ = 1;
	while(i__ <= *n) {
	    if (ipiv[i__] > 0) {
		i__1 = i__ + i__ * a_dim1;
		s = 1.f / a[i__1].r;
		csscal_(nrhs, &s, &b[i__ + b_dim1], ldb);
	    } else if (i__ < *n) {
		i__1 = i__;
		akm1k.r = e[i__1].r, akm1k.i = e[i__1].i;
		r_cnjg(&q__2, &akm1k);
		c_div(&q__1, &a[i__ + i__ * a_dim1], &q__2);
		akm1.r = q__1.r, akm1.i = q__1.i;
		c_div(&q__1, &a[i__ + 1 + (i__ + 1) * a_dim1], &akm1k);
		ak.r = q__1.r, ak.i = q__1.i;
		q__2.r = akm1.r * ak.r - akm1.i * ak.i, q__2.i = akm1.r * 
			ak.i + akm1.i * ak.r;
		q__1.r = q__2.r - 1.f, q__1.i = q__2.i - 0.f;
		denom.r = q__1.r, denom.i = q__1.i;
		i__1 = *nrhs;
		for (j = 1; j <= i__1; ++j) {
		    r_cnjg(&q__2, &akm1k);
		    c_div(&q__1, &b[i__ + j * b_dim1], &q__2);
		    bkm1.r = q__1.r, bkm1.i = q__1.i;
		    c_div(&q__1, &b[i__ + 1 + j * b_dim1], &akm1k);
		    bk.r = q__1.r, bk.i = q__1.i;
		    i__2 = i__ + j * b_dim1;
		    q__3.r = ak.r * bkm1.r - ak.i * bkm1.i, q__3.i = ak.r * 
			    bkm1.i + ak.i * bkm1.r;
		    q__2.r = q__3.r - bk.r, q__2.i = q__3.i - bk.i;
		    c_div(&q__1, &q__2, &denom);
		    b[i__2].r = q__1.r, b[i__2].i = q__1.i;
		    i__2 = i__ + 1 + j * b_dim1;
		    q__3.r = akm1.r * bk.r - akm1.i * bk.i, q__3.i = akm1.r * 
			    bk.i + akm1.i * bk.r;
		    q__2.r = q__3.r - bkm1.r, q__2.i = q__3.i - bkm1.i;
		    c_div(&q__1, &q__2, &denom);
		    b[i__2].r = q__1.r, b[i__2].i = q__1.i;
		}
		++i__;
	    }
	    ++i__;
	}

/*        Compute (L**H \ B) -> B   [ L**H \ (D \ (L \P**T * B) ) ] */

	ctrsm_("L", "L", "C", "U", n, nrhs, &c_b1, &a[a_offset], lda, &b[
		b_offset], ldb);

/*        P * B  [ P * (L**H \ (D \ (L \P**T * B) )) ] */

/*        Interchange rows K and IPIV(K) of matrix B in reverse order */
/*        from the formation order of IPIV(I) vector for Lower case. */

/*        (We can do the simple loop over IPIV with decrement -1, */
/*        since the ABS value of IPIV(I) represents the row index */
/*        of the interchange with row i in both 1x1 and 2x2 pivot cases) */

	for (k = *n; k >= 1; --k) {
	    kp = (i__1 = ipiv[k], abs(i__1));
	    if (kp != k) {
		cswap_(nrhs, &b[k + b_dim1], ldb, &b[kp + b_dim1], ldb);
	    }
	}

/*        END Lower */

    }

    return;

/*     End of CHETRS_3 */

} /* chetrs_3__ */

