/*
 *	PROGRAM:	Dynamic SQL runtime support
 *	MODULE:		chars.h
 *	DESCRIPTION:	character classification
 *
 * The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http://www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 * Copyright (C) Inprise Corporation.
 *
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
 */

const SCHAR CHR_LETTER		= 1;
const SCHAR CHR_DIGIT		= 2;
const SCHAR CHR_IDENT		= 4;
const SCHAR CHR_QUOTE		= 8;
const SCHAR CHR_WHITE		= 16;
const SCHAR CHR_HEX			= 32;
const SCHAR CHR_INTRODUCER	= 64;

// Use the functions at the end of this file; do not reference the array directly.

static const SCHAR classes_array[] = {
/* 000     */ 0,
/* 001     */ 0,
/* 002     */ 0,
/* 003     */ 0,
/* 004     */ 0,
/* 005     */ 0,
/* 006     */ 0,
/* 007     */ 0,
/* 008     */ 0,
/* 009     */ 0 | CHR_WHITE,
/* 010     */ 0 | CHR_WHITE,
/* 011     */ 0,
/* 012     */ 0 | CHR_WHITE,
/* 013     */ 0 | CHR_WHITE,
/* 014     */ 0,
/* 015     */ 0,
/* 016     */ 0,
/* 017     */ 0,
/* 018     */ 0,
/* 019     */ 0,
/* 020     */ 0,
/* 021     */ 0,
/* 022     */ 0,
/* 023     */ 0,
/* 024     */ 0,
/* 025     */ 0,
/* 026     */ 0,
/* 027     */ 0,
/* 028     */ 0,
/* 029     */ 0,
/* 030     */ 0,
/* 031     */ 0,
/* 032     */ 0 | CHR_WHITE,
/* 033  !  */ 0,
/* 034  "  */ 0 | CHR_QUOTE,
/* 035  #  */ 0,
/* 036  $  */ 0 | CHR_IDENT,
/* 037  %  */ 0,
/* 038  &  */ 0,
/* 039  '  */ 0 | CHR_QUOTE,
/* 040  (  */ 0,
/* 041  )  */ 0,
/* 042  *  */ 0,
/* 043  +  */ 0,
/* 044  ,  */ 0,
/* 045  -  */ 0,
/* 046  .  */ 0,
/* 047  /  */ 0,
/* 048  0  */ 0 | CHR_DIGIT | CHR_IDENT | CHR_HEX,
/* 049  1  */ 0 | CHR_DIGIT | CHR_IDENT | CHR_HEX,
/* 050  2  */ 0 | CHR_DIGIT | CHR_IDENT | CHR_HEX,
/* 051  3  */ 0 | CHR_DIGIT | CHR_IDENT | CHR_HEX,
/* 052  4  */ 0 | CHR_DIGIT | CHR_IDENT | CHR_HEX,
/* 053  5  */ 0 | CHR_DIGIT | CHR_IDENT | CHR_HEX,
/* 054  6  */ 0 | CHR_DIGIT | CHR_IDENT | CHR_HEX,
/* 055  7  */ 0 | CHR_DIGIT | CHR_IDENT | CHR_HEX,
/* 056  8  */ 0 | CHR_DIGIT | CHR_IDENT | CHR_HEX,
/* 057  9  */ 0 | CHR_DIGIT | CHR_IDENT | CHR_HEX,
/* 058  :  */ 0,
/* 059  ;  */ 0,
/* 060  <  */ 0,
/* 061  =  */ 0,
/* 062  >  */ 0,
/* 063  ?  */ 0,
/* 064  @  */ 0,
/* 065  A  */ 0 | CHR_LETTER | CHR_IDENT | CHR_HEX,
/* 066  B  */ 0 | CHR_LETTER | CHR_IDENT | CHR_HEX,
/* 067  C  */ 0 | CHR_LETTER | CHR_IDENT | CHR_HEX,
/* 068  D  */ 0 | CHR_LETTER | CHR_IDENT | CHR_HEX,
/* 069  E  */ 0 | CHR_LETTER | CHR_IDENT | CHR_HEX,
/* 070  F  */ 0 | CHR_LETTER | CHR_IDENT | CHR_HEX,
/* 071  G  */ 0 | CHR_LETTER | CHR_IDENT,
/* 072  H  */ 0 | CHR_LETTER | CHR_IDENT,
/* 073  I  */ 0 | CHR_LETTER | CHR_IDENT,
/* 074  J  */ 0 | CHR_LETTER | CHR_IDENT,
/* 075  K  */ 0 | CHR_LETTER | CHR_IDENT,
/* 076  L  */ 0 | CHR_LETTER | CHR_IDENT,
/* 077  M  */ 0 | CHR_LETTER | CHR_IDENT,
/* 078  N  */ 0 | CHR_LETTER | CHR_IDENT,
/* 079  O  */ 0 | CHR_LETTER | CHR_IDENT,
/* 080  P  */ 0 | CHR_LETTER | CHR_IDENT,
/* 081  Q  */ 0 | CHR_LETTER | CHR_IDENT,
/* 082  R  */ 0 | CHR_LETTER | CHR_IDENT,
/* 083  S  */ 0 | CHR_LETTER | CHR_IDENT,
/* 084  T  */ 0 | CHR_LETTER | CHR_IDENT,
/* 085  U  */ 0 | CHR_LETTER | CHR_IDENT,
/* 086  V  */ 0 | CHR_LETTER | CHR_IDENT,
/* 087  W  */ 0 | CHR_LETTER | CHR_IDENT,
/* 088  X  */ 0 | CHR_LETTER | CHR_IDENT,
/* 089  Y  */ 0 | CHR_LETTER | CHR_IDENT,
/* 090  Z  */ 0 | CHR_LETTER | CHR_IDENT,
/* 091  [  */ 0,
/* 092  \  */ 0,
/* 093  ]  */ 0,
/* 094  ^  */ 0,
/* 095  _  */ 0 | CHR_IDENT | CHR_INTRODUCER,
/* 096  `  */ 0,
/* 097  a  */ 0 | CHR_LETTER | CHR_IDENT | CHR_HEX,
/* 098  b  */ 0 | CHR_LETTER | CHR_IDENT | CHR_HEX,
/* 099  c  */ 0 | CHR_LETTER | CHR_IDENT | CHR_HEX,
/* 100  d  */ 0 | CHR_LETTER | CHR_IDENT | CHR_HEX,
/* 101  e  */ 0 | CHR_LETTER | CHR_IDENT | CHR_HEX,
/* 102  f  */ 0 | CHR_LETTER | CHR_IDENT | CHR_HEX,
/* 103  g  */ 0 | CHR_LETTER | CHR_IDENT,
/* 104  h  */ 0 | CHR_LETTER | CHR_IDENT,
/* 105  i  */ 0 | CHR_LETTER | CHR_IDENT,
/* 106  j  */ 0 | CHR_LETTER | CHR_IDENT,
/* 107  k  */ 0 | CHR_LETTER | CHR_IDENT,
/* 108  l  */ 0 | CHR_LETTER | CHR_IDENT,
/* 109  m  */ 0 | CHR_LETTER | CHR_IDENT,
/* 110  n  */ 0 | CHR_LETTER | CHR_IDENT,
/* 111  o  */ 0 | CHR_LETTER | CHR_IDENT,
/* 112  p  */ 0 | CHR_LETTER | CHR_IDENT,
/* 113  q  */ 0 | CHR_LETTER | CHR_IDENT,
/* 114  r  */ 0 | CHR_LETTER | CHR_IDENT,
/* 115  s  */ 0 | CHR_LETTER | CHR_IDENT,
/* 116  t  */ 0 | CHR_LETTER | CHR_IDENT,
/* 117  u  */ 0 | CHR_LETTER | CHR_IDENT,
/* 118  v  */ 0 | CHR_LETTER | CHR_IDENT,
/* 119  w  */ 0 | CHR_LETTER | CHR_IDENT,
/* 120  x  */ 0 | CHR_LETTER | CHR_IDENT,
/* 121  y  */ 0 | CHR_LETTER | CHR_IDENT,
/* 122  z  */ 0 | CHR_LETTER | CHR_IDENT,
/* 123  {  */ 0 | CHR_LETTER | CHR_IDENT,
/* 124  |  */ 0,
/* 125  }  */ 0 | CHR_LETTER | CHR_IDENT,
/* 126  ~  */ 0,
/* 127     */ 0,
/* 128     */ 0,
/* 129     */ 0,
/* 130     */ 0,
/* 131     */ 0,
/* 132     */ 0,
/* 133     */ 0,
/* 134     */ 0,
/* 135     */ 0,
/* 136     */ 0,
/* 137     */ 0,
/* 138     */ 0,
/* 139     */ 0,
/* 140     */ 0,
/* 141     */ 0,
/* 142     */ 0,
/* 143     */ 0,
/* 144     */ 0,
/* 145     */ 0,
/* 146     */ 0,
/* 147     */ 0,
/* 148     */ 0,
/* 149     */ 0,
/* 150     */ 0,
/* 151     */ 0,
/* 152     */ 0,
/* 153     */ 0,
/* 154     */ 0,
/* 155     */ 0,
/* 156     */ 0,
/* 157     */ 0,
/* 158     */ 0,
/* 159     */ 0,
/* 160     */ 0,
/* 161     */ 0,
/* 162     */ 0,
/* 163     */ 0,
/* 164     */ 0,
/* 165     */ 0,
/* 166     */ 0,
/* 167     */ 0,
/* 168     */ 0,
/* 169     */ 0,
/* 170     */ 0,
/* 171     */ 0,
/* 172     */ 0,
/* 173     */ 0,
/* 174     */ 0,
/* 175     */ 0,
/* 176     */ 0,
/* 177     */ 0,
/* 178     */ 0,
/* 179     */ 0,
/* 180     */ 0,
/* 181     */ 0,
/* 182     */ 0,
/* 183     */ 0,
/* 184     */ 0,
/* 185     */ 0,
/* 186     */ 0,
/* 187     */ 0,
/* 188     */ 0,
/* 189     */ 0,
/* 190     */ 0,
/* 191     */ 0,
/* 192     */ 0,
/* 193     */ 0,
/* 194     */ 0,
/* 195     */ 0,
/* 196     */ 0,
/* 197     */ 0,
/* 198     */ 0,
/* 199     */ 0,
/* 200     */ 0,
/* 201     */ 0,
/* 202     */ 0,
/* 203     */ 0,
/* 204     */ 0,
/* 205     */ 0,
/* 206     */ 0,
/* 207     */ 0,
/* 208     */ 0,
/* 209     */ 0,
/* 210     */ 0,
/* 211     */ 0,
/* 212     */ 0,
/* 213     */ 0,
/* 214     */ 0,
/* 215     */ 0,
/* 216     */ 0,
/* 217     */ 0,
/* 218     */ 0,
/* 219     */ 0,
/* 220     */ 0,
/* 221     */ 0,
/* 222     */ 0,
/* 223     */ 0,
/* 224     */ 0,
/* 225     */ 0,
/* 226     */ 0,
/* 227     */ 0,
/* 228     */ 0,
/* 229     */ 0,
/* 230     */ 0,
/* 231     */ 0,
/* 232     */ 0,
/* 233     */ 0,
/* 234     */ 0,
/* 235     */ 0,
/* 236     */ 0,
/* 237     */ 0,
/* 238     */ 0,
/* 239     */ 0,
/* 240     */ 0,
/* 241     */ 0,
/* 242     */ 0,
/* 243     */ 0,
/* 244     */ 0,
/* 245     */ 0,
/* 246     */ 0,
/* 247     */ 0,
/* 248     */ 0,
/* 249     */ 0,
/* 250     */ 0,
/* 251     */ 0,
/* 252     */ 0,
/* 253     */ 0,
/* 254     */ 0,
/* 255     */ 0
};

inline SCHAR classes(int idx)
{
	return classes_array[(UCHAR) idx];
}

inline SCHAR classes(UCHAR idx)
{
	return classes_array[idx];
}

