/**
 * WinPR: Windows Portable Runtime
 * Windows Native System Services
 *
 * Copyright 2013 Marc-Andre Moreau <marcandre.moreau@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef WINPR_NT_H
#define WINPR_NT_H

#include <winpr/winpr.h>
#include <winpr/wtypes.h>
#include <winpr/windows.h>
#include <winpr/cast.h>

#define STATUS_CAST(t, val) WINPR_CXX_COMPAT_CAST(t, val)

#ifndef _WIN32

/* Defined in winnt.h, do not redefine */
#define STATUS_WAIT_0 STATUS_CAST(NTSTATUS, 0x00000000L)
#define STATUS_ABANDONED_WAIT_0 STATUS_CAST(NTSTATUS, 0x00000080L)
#define STATUS_USER_APC STATUS_CAST(NTSTATUS, 0x000000C0L)
#define STATUS_TIMEOUT STATUS_CAST(NTSTATUS, 0x00000102L)
#define STATUS_PENDING STATUS_CAST(NTSTATUS, 0x00000103L)
#define DBG_EXCEPTION_HANDLED STATUS_CAST(NTSTATUS, 0x00010001L)
#define DBG_CONTINUE STATUS_CAST(NTSTATUS, 0x00010002L)
#define STATUS_SEGMENT_NOTIFICATION STATUS_CAST(NTSTATUS, 0x40000005L)
#define STATUS_FATAL_APP_EXIT STATUS_CAST(NTSTATUS, 0x40000015L)
#define DBG_TERMINATE_THREAD STATUS_CAST(NTSTATUS, 0x40010003L)
#define DBG_TERMINATE_PROCESS STATUS_CAST(NTSTATUS, 0x40010004L)
#define DBG_CONTROL_C STATUS_CAST(NTSTATUS, 0x40010005L)
#define DBG_PRINTEXCEPTION_C STATUS_CAST(NTSTATUS, 0x40010006L)
#define DBG_RIPEXCEPTION STATUS_CAST(NTSTATUS, 0x40010007L)
#define DBG_CONTROL_BREAK STATUS_CAST(NTSTATUS, 0x40010008L)
#define DBG_COMMAND_EXCEPTION STATUS_CAST(NTSTATUS, 0x40010009L)
#define STATUS_GUARD_PAGE_VIOLATION STATUS_CAST(NTSTATUS, 0x80000001L)
#define STATUS_DATATYPE_MISALIGNMENT STATUS_CAST(NTSTATUS, 0x80000002L)
#define STATUS_BREAKPOINT STATUS_CAST(NTSTATUS, 0x80000003L)
#define STATUS_SINGLE_STEP STATUS_CAST(NTSTATUS, 0x80000004L)
#define STATUS_LONGJUMP STATUS_CAST(NTSTATUS, 0x80000026L)
#define STATUS_UNWIND_CONSOLIDATE STATUS_CAST(NTSTATUS, 0x80000029L)
#define DBG_EXCEPTION_NOT_HANDLED STATUS_CAST(NTSTATUS, 0x80010001L)
#define STATUS_ACCESS_VIOLATION STATUS_CAST(NTSTATUS, 0xC0000005L)
#define STATUS_IN_PAGE_ERROR STATUS_CAST(NTSTATUS, 0xC0000006L)
#define STATUS_INVALID_HANDLE STATUS_CAST(NTSTATUS, 0xC0000008L)
#define STATUS_INVALID_PARAMETER STATUS_CAST(NTSTATUS, 0xC000000DL)
#define STATUS_NO_MEMORY STATUS_CAST(NTSTATUS, 0xC0000017L)
#define STATUS_ILLEGAL_INSTRUCTION STATUS_CAST(NTSTATUS, 0xC000001DL)
#define STATUS_NONCONTINUABLE_EXCEPTION STATUS_CAST(NTSTATUS, 0xC0000025L)
#define STATUS_INVALID_DISPOSITION STATUS_CAST(NTSTATUS, 0xC0000026L)
#define STATUS_ARRAY_BOUNDS_EXCEEDED STATUS_CAST(NTSTATUS, 0xC000008CL)
#define STATUS_FLOAT_DENORMAL_OPERAND STATUS_CAST(NTSTATUS, 0xC000008DL)
#define STATUS_FLOAT_DIVIDE_BY_ZERO STATUS_CAST(NTSTATUS, 0xC000008EL)
#define STATUS_FLOAT_INEXACT_RESULT STATUS_CAST(NTSTATUS, 0xC000008FL)
#define STATUS_FLOAT_INVALID_OPERATION STATUS_CAST(NTSTATUS, 0xC0000090L)
#define STATUS_FLOAT_OVERFLOW STATUS_CAST(NTSTATUS, 0xC0000091L)
#define STATUS_FLOAT_STACK_CHECK STATUS_CAST(NTSTATUS, 0xC0000092L)
#define STATUS_FLOAT_UNDERFLOW STATUS_CAST(NTSTATUS, 0xC0000093L)
#define STATUS_INTEGER_DIVIDE_BY_ZERO STATUS_CAST(NTSTATUS, 0xC0000094L)
#define STATUS_INTEGER_OVERFLOW STATUS_CAST(NTSTATUS, 0xC0000095L)
#define STATUS_PRIVILEGED_INSTRUCTION STATUS_CAST(NTSTATUS, 0xC0000096L)
#define STATUS_STACK_OVERFLOW STATUS_CAST(NTSTATUS, 0xC00000FDL)
#define STATUS_DLL_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000135L)
#define STATUS_ORDINAL_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000138L)
#define STATUS_ENTRYPOINT_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000139L)
#define STATUS_CONTROL_C_EXIT STATUS_CAST(NTSTATUS, 0xC000013AL)
#define STATUS_DLL_INIT_FAILED STATUS_CAST(NTSTATUS, 0xC0000142L)
#define STATUS_FLOAT_MULTIPLE_FAULTS STATUS_CAST(NTSTATUS, 0xC00002B4L)
#define STATUS_FLOAT_MULTIPLE_TRAPS STATUS_CAST(NTSTATUS, 0xC00002B5L)
#define STATUS_REG_NAT_CONSUMPTION STATUS_CAST(NTSTATUS, 0xC00002C9L)
#define STATUS_STACK_BUFFER_OVERRUN STATUS_CAST(NTSTATUS, 0xC0000409L)
#define STATUS_INVALID_CRUNTIME_PARAMETER STATUS_CAST(NTSTATUS, 0xC0000417L)
#define STATUS_ASSERTION_FAILURE STATUS_CAST(NTSTATUS, 0xC0000420L)
#define STATUS_SXS_EARLY_DEACTIVATION STATUS_CAST(NTSTATUS, 0xC015000FL)
#define STATUS_SXS_INVALID_DEACTIVATION STATUS_CAST(NTSTATUS, 0xC0150010L)

#endif

/* Defined in wincred.h, do not redefine */

#if defined(_WIN32) && !defined(_UWP)

#include <wincred.h>

#else

#define STATUS_LOGON_FAILURE STATUS_CAST(NTSTATUS, 0xC000006DL)
#define STATUS_WRONG_PASSWORD STATUS_CAST(NTSTATUS, 0xC000006AL)
#define STATUS_PASSWORD_EXPIRED STATUS_CAST(NTSTATUS, 0xC0000071L)
#define STATUS_PASSWORD_MUST_CHANGE STATUS_CAST(NTSTATUS, 0xC0000224L)
#define STATUS_ACCESS_DENIED STATUS_CAST(NTSTATUS, 0xC0000022L)
#define STATUS_DOWNGRADE_DETECTED STATUS_CAST(NTSTATUS, 0xC0000388L)
#define STATUS_AUTHENTICATION_FIREWALL_FAILED STATUS_CAST(NTSTATUS, 0xC0000413L)
#define STATUS_ACCOUNT_DISABLED STATUS_CAST(NTSTATUS, 0xC0000072L)
#define STATUS_ACCOUNT_RESTRICTION STATUS_CAST(NTSTATUS, 0xC000006EL)
#define STATUS_ACCOUNT_LOCKED_OUT STATUS_CAST(NTSTATUS, 0xC0000234L)
#define STATUS_ACCOUNT_EXPIRED STATUS_CAST(NTSTATUS, 0xC0000193L)
#define STATUS_LOGON_TYPE_NOT_GRANTED STATUS_CAST(NTSTATUS, 0xC000015BL)

#endif

#define FACILITY_DEBUGGER 0x1
#define FACILITY_RPC_RUNTIME 0x2
#define FACILITY_RPC_STUBS 0x3
#define FACILITY_IO_ERROR_CODE 0x4
#define FACILITY_TERMINAL_SERVER 0xA
#define FACILITY_USB_ERROR_CODE 0x10
#define FACILITY_HID_ERROR_CODE 0x11
#define FACILITY_FIREWIRE_ERROR_CODE 0x12
#define FACILITY_CLUSTER_ERROR_CODE 0x13
#define FACILITY_ACPI_ERROR_CODE 0x14
#define FACILITY_SXS_ERROR_CODE 0x15

/**
 * NTSTATUS codes
 */

#if !defined(STATUS_SUCCESS)
#define STATUS_SUCCESS STATUS_CAST(NTSTATUS, 0x00000000)
#endif

#define STATUS_SEVERITY_SUCCESS 0x0
#define STATUS_SEVERITY_INFORMATIONAL 0x1
#define STATUS_SEVERITY_WARNING 0x2
#define STATUS_SEVERITY_ERROR 0x3

#define STATUS_WAIT_1 STATUS_CAST(NTSTATUS, 0x00000001)
#define STATUS_WAIT_2 STATUS_CAST(NTSTATUS, 0x00000002)
#define STATUS_WAIT_3 STATUS_CAST(NTSTATUS, 0x00000003)
#define STATUS_WAIT_63 STATUS_CAST(NTSTATUS, 0x0000003f)
#define STATUS_ABANDONED STATUS_CAST(NTSTATUS, 0x00000080)
#define STATUS_ABANDONED_WAIT_63 STATUS_CAST(NTSTATUS, 0x000000BF)
//#define STATUS_USER_APC							STATUS_CAST(NTSTATUS,0x000000C0)
#define STATUS_KERNEL_APC STATUS_CAST(NTSTATUS, 0x00000100)
#define STATUS_ALERTED STATUS_CAST(NTSTATUS, 0x00000101)
//#define STATUS_TIMEOUT							STATUS_CAST(NTSTATUS,0x00000102)
//#define STATUS_PENDING							STATUS_CAST(NTSTATUS,0x00000103)
#define STATUS_REPARSE STATUS_CAST(NTSTATUS, 0x00000104)
#define STATUS_MORE_ENTRIES STATUS_CAST(NTSTATUS, 0x00000105)
#define STATUS_NOT_ALL_ASSIGNED STATUS_CAST(NTSTATUS, 0x00000106)
#define STATUS_SOME_NOT_MAPPED STATUS_CAST(NTSTATUS, 0x00000107)
#define STATUS_OPLOCK_BREAK_IN_PROGRESS STATUS_CAST(NTSTATUS, 0x00000108)
#define STATUS_VOLUME_MOUNTED STATUS_CAST(NTSTATUS, 0x00000109)
#define STATUS_RXACT_COMMITTED STATUS_CAST(NTSTATUS, 0x0000010A)
#define STATUS_NOTIFY_CLEANUP STATUS_CAST(NTSTATUS, 0x0000010B)
#define STATUS_NOTIFY_ENUM_DIR STATUS_CAST(NTSTATUS, 0x0000010C)
#define STATUS_NO_QUOTAS_FOR_ACCOUNT STATUS_CAST(NTSTATUS, 0x0000010D)
#define STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED STATUS_CAST(NTSTATUS, 0x0000010E)
#define STATUS_PAGE_FAULT_TRANSITION STATUS_CAST(NTSTATUS, 0x00000110)
#define STATUS_PAGE_FAULT_DEMAND_ZERO STATUS_CAST(NTSTATUS, 0x00000111)
#define STATUS_PAGE_FAULT_COPY_ON_WRITE STATUS_CAST(NTSTATUS, 0x00000112)
#define STATUS_PAGE_FAULT_GUARD_PAGE STATUS_CAST(NTSTATUS, 0x00000113)
#define STATUS_PAGE_FAULT_PAGING_FILE STATUS_CAST(NTSTATUS, 0x00000114)
#define STATUS_CACHE_PAGE_LOCKED STATUS_CAST(NTSTATUS, 0x00000115)
#define STATUS_CRASH_DUMP STATUS_CAST(NTSTATUS, 0x00000116)
#define STATUS_BUFFER_ALL_ZEROS STATUS_CAST(NTSTATUS, 0x00000117)
#define STATUS_REPARSE_OBJECT STATUS_CAST(NTSTATUS, 0x00000118)
#define STATUS_RESOURCE_REQUIREMENTS_CHANGED STATUS_CAST(NTSTATUS, 0x00000119)
#define STATUS_TRANSLATION_COMPLETE STATUS_CAST(NTSTATUS, 0x00000120)
#define STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY STATUS_CAST(NTSTATUS, 0x00000121)
#define STATUS_NOTHING_TO_TERMINATE STATUS_CAST(NTSTATUS, 0x00000122)
#define STATUS_PROCESS_NOT_IN_JOB STATUS_CAST(NTSTATUS, 0x00000123)
#define STATUS_PROCESS_IN_JOB STATUS_CAST(NTSTATUS, 0x00000124)
#define STATUS_VOLSNAP_HIBERNATE_READY STATUS_CAST(NTSTATUS, 0x00000125)
#define STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY STATUS_CAST(NTSTATUS, 0x00000126)

#define STATUS_OBJECT_NAME_EXISTS STATUS_CAST(NTSTATUS, 0x40000000)
#define STATUS_THREAD_WAS_SUSPENDED STATUS_CAST(NTSTATUS, 0x40000001)
#define STATUS_WORKING_SET_LIMIT_RANGE STATUS_CAST(NTSTATUS, 0x40000002)
#define STATUS_IMAGE_NOT_AT_BASE STATUS_CAST(NTSTATUS, 0x40000003)
#define STATUS_RXACT_STATE_CREATED STATUS_CAST(NTSTATUS, 0x40000004)
//#define STATUS_SEGMENT_NOTIFICATION					STATUS_CAST(NTSTATUS,0x40000005)
#define STATUS_LOCAL_USER_SESSION_KEY STATUS_CAST(NTSTATUS, 0x40000006)
#define STATUS_BAD_CURRENT_DIRECTORY STATUS_CAST(NTSTATUS, 0x40000007)
#define STATUS_SERIAL_MORE_WRITES STATUS_CAST(NTSTATUS, 0x40000008)
#define STATUS_REGISTRY_RECOVERED STATUS_CAST(NTSTATUS, 0x40000009)
#define STATUS_FT_READ_RECOVERY_FROM_BACKUP STATUS_CAST(NTSTATUS, 0x4000000A)
#define STATUS_FT_WRITE_RECOVERY STATUS_CAST(NTSTATUS, 0x4000000B)
#define STATUS_SERIAL_COUNTER_TIMEOUT STATUS_CAST(NTSTATUS, 0x4000000C)
#define STATUS_NULL_LM_PASSWORD STATUS_CAST(NTSTATUS, 0x4000000D)
#define STATUS_IMAGE_MACHINE_TYPE_MISMATCH STATUS_CAST(NTSTATUS, 0x4000000E)
#define STATUS_RECEIVE_PARTIAL STATUS_CAST(NTSTATUS, 0x4000000F)
#define STATUS_RECEIVE_EXPEDITED STATUS_CAST(NTSTATUS, 0x40000010)
#define STATUS_RECEIVE_PARTIAL_EXPEDITED STATUS_CAST(NTSTATUS, 0x40000011)
#define STATUS_EVENT_DONE STATUS_CAST(NTSTATUS, 0x40000012)
#define STATUS_EVENT_PENDING STATUS_CAST(NTSTATUS, 0x40000013)
#define STATUS_CHECKING_FILE_SYSTEM STATUS_CAST(NTSTATUS, 0x40000014)
//#define STATUS_FATAL_APP_EXIT						STATUS_CAST(NTSTATUS,0x40000015)
#define STATUS_PREDEFINED_HANDLE STATUS_CAST(NTSTATUS, 0x40000016)
#define STATUS_WAS_UNLOCKED STATUS_CAST(NTSTATUS, 0x40000017)
#define STATUS_SERVICE_NOTIFICATION STATUS_CAST(NTSTATUS, 0x40000018)
#define STATUS_WAS_LOCKED STATUS_CAST(NTSTATUS, 0x40000019)
#define STATUS_LOG_HARD_ERROR STATUS_CAST(NTSTATUS, 0x4000001A)
#define STATUS_ALREADY_WIN32 STATUS_CAST(NTSTATUS, 0x4000001B)
#define STATUS_WX86_UNSIMULATE STATUS_CAST(NTSTATUS, 0x4000001C)
#define STATUS_WX86_CONTINUE STATUS_CAST(NTSTATUS, 0x4000001D)
#define STATUS_WX86_SINGLE_STEP STATUS_CAST(NTSTATUS, 0x4000001E)
#define STATUS_WX86_BREAKPOINT STATUS_CAST(NTSTATUS, 0x4000001F)
#define STATUS_WX86_EXCEPTION_CONTINUE STATUS_CAST(NTSTATUS, 0x40000020)
#define STATUS_WX86_EXCEPTION_LASTCHANCE STATUS_CAST(NTSTATUS, 0x40000021)
#define STATUS_WX86_EXCEPTION_CHAIN STATUS_CAST(NTSTATUS, 0x40000022)
#define STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE STATUS_CAST(NTSTATUS, 0x40000023)
#define STATUS_NO_YIELD_PERFORMED STATUS_CAST(NTSTATUS, 0x40000024)
#define STATUS_TIMER_RESUME_IGNORED STATUS_CAST(NTSTATUS, 0x40000025)
#define STATUS_ARBITRATION_UNHANDLED STATUS_CAST(NTSTATUS, 0x40000026)
#define STATUS_CARDBUS_NOT_SUPPORTED STATUS_CAST(NTSTATUS, 0x40000027)
#define STATUS_WX86_CREATEWX86TIB STATUS_CAST(NTSTATUS, 0x40000028)
#define STATUS_MP_PROCESSOR_MISMATCH STATUS_CAST(NTSTATUS, 0x40000029)
#define STATUS_HIBERNATED STATUS_CAST(NTSTATUS, 0x4000002A)
#define STATUS_RESUME_HIBERNATION STATUS_CAST(NTSTATUS, 0x4000002B)
#define STATUS_FIRMWARE_UPDATED STATUS_CAST(NTSTATUS, 0x4000002C)
#define STATUS_WAKE_SYSTEM STATUS_CAST(NTSTATUS, 0x40000294)
#define STATUS_DS_SHUTTING_DOWN STATUS_CAST(NTSTATUS, 0x40000370)

#define RPC_NT_UUID_LOCAL_ONLY STATUS_CAST(NTSTATUS, 0x40020056)
#define RPC_NT_SEND_INCOMPLETE STATUS_CAST(NTSTATUS, 0x400200AF)

#define STATUS_CTX_CDM_CONNECT STATUS_CAST(NTSTATUS, 0x400A0004)
#define STATUS_CTX_CDM_DISCONNECT STATUS_CAST(NTSTATUS, 0x400A0005)

#define STATUS_SXS_RELEASE_ACTIVATION_CONTEXT STATUS_CAST(NTSTATUS, 0x4015000D)

//#define STATUS_GUARD_PAGE_VIOLATION					STATUS_CAST(NTSTATUS,0x80000001)
//#define STATUS_DATATYPE_MISALIGNMENT					STATUS_CAST(NTSTATUS,0x80000002)
//#define STATUS_BREAKPOINT						STATUS_CAST(NTSTATUS,0x80000003)
//#define STATUS_SINGLE_STEP						STATUS_CAST(NTSTATUS,0x80000004)
#define STATUS_BUFFER_OVERFLOW STATUS_CAST(NTSTATUS, 0x80000005)
#define STATUS_NO_MORE_FILES STATUS_CAST(NTSTATUS, 0x80000006)
#define STATUS_WAKE_SYSTEM_DEBUGGER STATUS_CAST(NTSTATUS, 0x80000007)

#define STATUS_HANDLES_CLOSED STATUS_CAST(NTSTATUS, 0x8000000A)
#define STATUS_NO_INHERITANCE STATUS_CAST(NTSTATUS, 0x8000000B)
#define STATUS_GUID_SUBSTITUTION_MADE STATUS_CAST(NTSTATUS, 0x8000000C)
#define STATUS_PARTIAL_COPY STATUS_CAST(NTSTATUS, 0x8000000D)
#define STATUS_DEVICE_PAPER_EMPTY STATUS_CAST(NTSTATUS, 0x8000000E)
#define STATUS_DEVICE_POWERED_OFF STATUS_CAST(NTSTATUS, 0x8000000F)
#define STATUS_DEVICE_OFF_LINE STATUS_CAST(NTSTATUS, 0x80000010)
#define STATUS_DEVICE_BUSY STATUS_CAST(NTSTATUS, 0x80000011)
#define STATUS_NO_MORE_EAS STATUS_CAST(NTSTATUS, 0x80000012)
#define STATUS_INVALID_EA_NAME STATUS_CAST(NTSTATUS, 0x80000013)
#define STATUS_EA_LIST_INCONSISTENT STATUS_CAST(NTSTATUS, 0x80000014)
#define STATUS_INVALID_EA_FLAG STATUS_CAST(NTSTATUS, 0x80000015)
#define STATUS_VERIFY_REQUIRED STATUS_CAST(NTSTATUS, 0x80000016)
#define STATUS_EXTRANEOUS_INFORMATION STATUS_CAST(NTSTATUS, 0x80000017)
#define STATUS_RXACT_COMMIT_NECESSARY STATUS_CAST(NTSTATUS, 0x80000018)
#define STATUS_NO_MORE_ENTRIES STATUS_CAST(NTSTATUS, 0x8000001A)
#define STATUS_FILEMARK_DETECTED STATUS_CAST(NTSTATUS, 0x8000001B)
#define STATUS_MEDIA_CHANGED STATUS_CAST(NTSTATUS, 0x8000001C)
#define STATUS_BUS_RESET STATUS_CAST(NTSTATUS, 0x8000001D)
#define STATUS_END_OF_MEDIA STATUS_CAST(NTSTATUS, 0x8000001E)
#define STATUS_BEGINNING_OF_MEDIA STATUS_CAST(NTSTATUS, 0x8000001F)
#define STATUS_MEDIA_CHECK STATUS_CAST(NTSTATUS, 0x80000020)
#define STATUS_SETMARK_DETECTED STATUS_CAST(NTSTATUS, 0x80000021)
#define STATUS_NO_DATA_DETECTED STATUS_CAST(NTSTATUS, 0x80000022)
#define STATUS_REDIRECTOR_HAS_OPEN_HANDLES STATUS_CAST(NTSTATUS, 0x80000023)
#define STATUS_SERVER_HAS_OPEN_HANDLES STATUS_CAST(NTSTATUS, 0x80000024)
#define STATUS_ALREADY_DISCONNECTED STATUS_CAST(NTSTATUS, 0x80000025)
//#define STATUS_LONGJUMP							STATUS_CAST(NTSTATUS,0x80000026)
#define STATUS_CLEANER_CARTRIDGE_INSTALLED STATUS_CAST(NTSTATUS, 0x80000027)
#define STATUS_PLUGPLAY_QUERY_VETOED STATUS_CAST(NTSTATUS, 0x80000028)
//#define STATUS_UNWIND_CONSOLIDATE					STATUS_CAST(NTSTATUS,0x80000029)
#define STATUS_REGISTRY_HIVE_RECOVERED STATUS_CAST(NTSTATUS, 0x8000002A)
#define STATUS_DLL_MIGHT_BE_INSECURE STATUS_CAST(NTSTATUS, 0x8000002B)
#define STATUS_DLL_MIGHT_BE_INCOMPATIBLE STATUS_CAST(NTSTATUS, 0x8000002C)

#define STATUS_DEVICE_REQUIRES_CLEANING STATUS_CAST(NTSTATUS, 0x80000288)
#define STATUS_DEVICE_DOOR_OPEN STATUS_CAST(NTSTATUS, 0x80000289)

#define STATUS_CLUSTER_NODE_ALREADY_UP STATUS_CAST(NTSTATUS, 0x80130001)
#define STATUS_CLUSTER_NODE_ALREADY_DOWN STATUS_CAST(NTSTATUS, 0x80130002)
#define STATUS_CLUSTER_NETWORK_ALREADY_ONLINE STATUS_CAST(NTSTATUS, 0x80130003)
#define STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE STATUS_CAST(NTSTATUS, 0x80130004)
#define STATUS_CLUSTER_NODE_ALREADY_MEMBER STATUS_CAST(NTSTATUS, 0x80130005)

//#define STATUS_WAIT_0							STATUS_CAST(NTSTATUS,0x00000000)
#define STATUS_UNSUCCESSFUL STATUS_CAST(NTSTATUS, 0xC0000001)
#define STATUS_NOT_IMPLEMENTED STATUS_CAST(NTSTATUS, 0xC0000002)
#define STATUS_INVALID_INFO_CLASS STATUS_CAST(NTSTATUS, 0xC0000003)
#define STATUS_INFO_LENGTH_MISMATCH STATUS_CAST(NTSTATUS, 0xC0000004)
//#define STATUS_ACCESS_VIOLATION						STATUS_CAST(NTSTATUS,0xC0000005)
//#define STATUS_IN_PAGE_ERROR						STATUS_CAST(NTSTATUS,0xC0000006)
#define STATUS_PAGEFILE_QUOTA STATUS_CAST(NTSTATUS, 0xC0000007)
//#define STATUS_INVALID_HANDLE						STATUS_CAST(NTSTATUS,0xC0000008)
#define STATUS_BAD_INITIAL_STACK STATUS_CAST(NTSTATUS, 0xC0000009)
#define STATUS_BAD_INITIAL_PC STATUS_CAST(NTSTATUS, 0xC000000A)
#define STATUS_INVALID_CID STATUS_CAST(NTSTATUS, 0xC000000B)
#define STATUS_TIMER_NOT_CANCELED STATUS_CAST(NTSTATUS, 0xC000000C)
//#define STATUS_INVALID_PARAMETER					STATUS_CAST(NTSTATUS,0xC000000D)
#define STATUS_NO_SUCH_DEVICE STATUS_CAST(NTSTATUS, 0xC000000E)
#define STATUS_NO_SUCH_FILE STATUS_CAST(NTSTATUS, 0xC000000F)
#define STATUS_INVALID_DEVICE_REQUEST STATUS_CAST(NTSTATUS, 0xC0000010)
#define STATUS_END_OF_FILE STATUS_CAST(NTSTATUS, 0xC0000011)
#define STATUS_WRONG_VOLUME STATUS_CAST(NTSTATUS, 0xC0000012)
#define STATUS_NO_MEDIA_IN_DEVICE STATUS_CAST(NTSTATUS, 0xC0000013)
#define STATUS_UNRECOGNIZED_MEDIA STATUS_CAST(NTSTATUS, 0xC0000014)
#define STATUS_NONEXISTENT_SECTOR STATUS_CAST(NTSTATUS, 0xC0000015)
#define STATUS_MORE_PROCESSING_REQUIRED STATUS_CAST(NTSTATUS, 0xC0000016)
//#define STATUS_NO_MEMORY						STATUS_CAST(NTSTATUS,0xC0000017)
#define STATUS_CONFLICTING_ADDRESSES STATUS_CAST(NTSTATUS, 0xC0000018)
#define STATUS_NOT_MAPPED_VIEW STATUS_CAST(NTSTATUS, 0xC0000019)
#define STATUS_UNABLE_TO_FREE_VM STATUS_CAST(NTSTATUS, 0xC000001A)
#define STATUS_UNABLE_TO_DELETE_SECTION STATUS_CAST(NTSTATUS, 0xC000001B)
#define STATUS_INVALID_SYSTEM_SERVICE STATUS_CAST(NTSTATUS, 0xC000001C)
//#define STATUS_ILLEGAL_INSTRUCTION					STATUS_CAST(NTSTATUS,0xC000001D)
#define STATUS_INVALID_LOCK_SEQUENCE STATUS_CAST(NTSTATUS, 0xC000001E)
#define STATUS_INVALID_VIEW_SIZE STATUS_CAST(NTSTATUS, 0xC000001F)
#define STATUS_INVALID_FILE_FOR_SECTION STATUS_CAST(NTSTATUS, 0xC0000020)
#define STATUS_ALREADY_COMMITTED STATUS_CAST(NTSTATUS, 0xC0000021)
//#define STATUS_ACCESS_DENIED						STATUS_CAST(NTSTATUS,0xC0000022)
#define STATUS_BUFFER_TOO_SMALL STATUS_CAST(NTSTATUS, 0xC0000023)
#define STATUS_OBJECT_TYPE_MISMATCH STATUS_CAST(NTSTATUS, 0xC0000024)
//#define STATUS_NONCONTINUABLE_EXCEPTION					STATUS_CAST(NTSTATUS,0xC0000025)
//#define STATUS_INVALID_DISPOSITION					STATUS_CAST(NTSTATUS,0xC0000026)
#define STATUS_UNWIND STATUS_CAST(NTSTATUS, 0xC0000027)
#define STATUS_BAD_STACK STATUS_CAST(NTSTATUS, 0xC0000028)
#define STATUS_INVALID_UNWIND_TARGET STATUS_CAST(NTSTATUS, 0xC0000029)
#define STATUS_NOT_LOCKED STATUS_CAST(NTSTATUS, 0xC000002A)
#define STATUS_PARITY_ERROR STATUS_CAST(NTSTATUS, 0xC000002B)
#define STATUS_UNABLE_TO_DECOMMIT_VM STATUS_CAST(NTSTATUS, 0xC000002C)
#define STATUS_NOT_COMMITTED STATUS_CAST(NTSTATUS, 0xC000002D)
#define STATUS_INVALID_PORT_ATTRIBUTES STATUS_CAST(NTSTATUS, 0xC000002E)
#define STATUS_PORT_MESSAGE_TOO_LONG STATUS_CAST(NTSTATUS, 0xC000002F)
#define STATUS_INVALID_PARAMETER_MIX STATUS_CAST(NTSTATUS, 0xC0000030)
#define STATUS_INVALID_QUOTA_LOWER STATUS_CAST(NTSTATUS, 0xC0000031)
#define STATUS_DISK_CORRUPT_ERROR STATUS_CAST(NTSTATUS, 0xC0000032)
#define STATUS_OBJECT_NAME_INVALID STATUS_CAST(NTSTATUS, 0xC0000033)
#define STATUS_OBJECT_NAME_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000034)
#define STATUS_OBJECT_NAME_COLLISION STATUS_CAST(NTSTATUS, 0xC0000035)
#define STATUS_PORT_DISCONNECTED STATUS_CAST(NTSTATUS, 0xC0000037)
#define STATUS_DEVICE_ALREADY_ATTACHED STATUS_CAST(NTSTATUS, 0xC0000038)
#define STATUS_OBJECT_PATH_INVALID STATUS_CAST(NTSTATUS, 0xC0000039)
#define STATUS_OBJECT_PATH_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC000003A)
#define STATUS_OBJECT_PATH_SYNTAX_BAD STATUS_CAST(NTSTATUS, 0xC000003B)
#define STATUS_DATA_OVERRUN STATUS_CAST(NTSTATUS, 0xC000003C)
#define STATUS_DATA_LATE_ERROR STATUS_CAST(NTSTATUS, 0xC000003D)
#define STATUS_DATA_ERROR STATUS_CAST(NTSTATUS, 0xC000003E)
#define STATUS_CRC_ERROR STATUS_CAST(NTSTATUS, 0xC000003F)
#define STATUS_SECTION_TOO_BIG STATUS_CAST(NTSTATUS, 0xC0000040)
#define STATUS_PORT_CONNECTION_REFUSED STATUS_CAST(NTSTATUS, 0xC0000041)
#define STATUS_INVALID_PORT_HANDLE STATUS_CAST(NTSTATUS, 0xC0000042)
#define STATUS_SHARING_VIOLATION STATUS_CAST(NTSTATUS, 0xC0000043)
#define STATUS_QUOTA_EXCEEDED STATUS_CAST(NTSTATUS, 0xC0000044)
#define STATUS_INVALID_PAGE_PROTECTION STATUS_CAST(NTSTATUS, 0xC0000045)
#define STATUS_MUTANT_NOT_OWNED STATUS_CAST(NTSTATUS, 0xC0000046)
#define STATUS_SEMAPHORE_LIMIT_EXCEEDED STATUS_CAST(NTSTATUS, 0xC0000047)
#define STATUS_PORT_ALREADY_SET STATUS_CAST(NTSTATUS, 0xC0000048)
#define STATUS_SECTION_NOT_IMAGE STATUS_CAST(NTSTATUS, 0xC0000049)
#define STATUS_SUSPEND_COUNT_EXCEEDED STATUS_CAST(NTSTATUS, 0xC000004A)
#define STATUS_THREAD_IS_TERMINATING STATUS_CAST(NTSTATUS, 0xC000004B)
#define STATUS_BAD_WORKING_SET_LIMIT STATUS_CAST(NTSTATUS, 0xC000004C)
#define STATUS_INCOMPATIBLE_FILE_MAP STATUS_CAST(NTSTATUS, 0xC000004D)
#define STATUS_SECTION_PROTECTION STATUS_CAST(NTSTATUS, 0xC000004E)
#define STATUS_EAS_NOT_SUPPORTED STATUS_CAST(NTSTATUS, 0xC000004F)
#define STATUS_EA_TOO_LARGE STATUS_CAST(NTSTATUS, 0xC0000050)
#define STATUS_NONEXISTENT_EA_ENTRY STATUS_CAST(NTSTATUS, 0xC0000051)
#define STATUS_NO_EAS_ON_FILE STATUS_CAST(NTSTATUS, 0xC0000052)
#define STATUS_EA_CORRUPT_ERROR STATUS_CAST(NTSTATUS, 0xC0000053)
#define STATUS_FILE_LOCK_CONFLICT STATUS_CAST(NTSTATUS, 0xC0000054)
#define STATUS_LOCK_NOT_GRANTED STATUS_CAST(NTSTATUS, 0xC0000055)
#define STATUS_DELETE_PENDING STATUS_CAST(NTSTATUS, 0xC0000056)
#define STATUS_CTL_FILE_NOT_SUPPORTED STATUS_CAST(NTSTATUS, 0xC0000057)
#define STATUS_UNKNOWN_REVISION STATUS_CAST(NTSTATUS, 0xC0000058)
#define STATUS_REVISION_MISMATCH STATUS_CAST(NTSTATUS, 0xC0000059)
#define STATUS_INVALID_OWNER STATUS_CAST(NTSTATUS, 0xC000005A)
#define STATUS_INVALID_PRIMARY_GROUP STATUS_CAST(NTSTATUS, 0xC000005B)
#define STATUS_NO_IMPERSONATION_TOKEN STATUS_CAST(NTSTATUS, 0xC000005C)
#define STATUS_CANT_DISABLE_MANDATORY STATUS_CAST(NTSTATUS, 0xC000005D)
#define STATUS_NO_LOGON_SERVERS STATUS_CAST(NTSTATUS, 0xC000005E)
#ifndef STATUS_NO_SUCH_LOGON_SESSION
#define STATUS_NO_SUCH_LOGON_SESSION STATUS_CAST(NTSTATUS, 0xC000005F)
#endif
#define STATUS_NO_SUCH_PRIVILEGE STATUS_CAST(NTSTATUS, 0xC0000060)
#define STATUS_PRIVILEGE_NOT_HELD STATUS_CAST(NTSTATUS, 0xC0000061)
#define STATUS_INVALID_ACCOUNT_NAME STATUS_CAST(NTSTATUS, 0xC0000062)
#define STATUS_USER_EXISTS STATUS_CAST(NTSTATUS, 0xC0000063)
#ifndef STATUS_NO_SUCH_USER
#define STATUS_NO_SUCH_USER STATUS_CAST(NTSTATUS, 0xC0000064)
#endif
#define STATUS_GROUP_EXISTS STATUS_CAST(NTSTATUS, 0xC0000065)
#define STATUS_NO_SUCH_GROUP STATUS_CAST(NTSTATUS, 0xC0000066)
#define STATUS_MEMBER_IN_GROUP STATUS_CAST(NTSTATUS, 0xC0000067)
#define STATUS_MEMBER_NOT_IN_GROUP STATUS_CAST(NTSTATUS, 0xC0000068)
#define STATUS_LAST_ADMIN STATUS_CAST(NTSTATUS, 0xC0000069)
//#define STATUS_WRONG_PASSWORD						STATUS_CAST(NTSTATUS,0xC000006A)
#define STATUS_ILL_FORMED_PASSWORD STATUS_CAST(NTSTATUS, 0xC000006B)
#define STATUS_PASSWORD_RESTRICTION STATUS_CAST(NTSTATUS, 0xC000006C)
//#define STATUS_LOGON_FAILURE						STATUS_CAST(NTSTATUS,0xC000006D)
//#define STATUS_ACCOUNT_RESTRICTION					STATUS_CAST(NTSTATUS,0xC000006E)
#define STATUS_INVALID_LOGON_HOURS STATUS_CAST(NTSTATUS, 0xC000006F)
#define STATUS_INVALID_WORKSTATION STATUS_CAST(NTSTATUS, 0xC0000070)
//#define STATUS_PASSWORD_EXPIRED						STATUS_CAST(NTSTATUS,0xC0000071)
//#define STATUS_ACCOUNT_DISABLED						STATUS_CAST(NTSTATUS,0xC0000072)
#define STATUS_NONE_MAPPED STATUS_CAST(NTSTATUS, 0xC0000073)
#define STATUS_TOO_MANY_LUIDS_REQUESTED STATUS_CAST(NTSTATUS, 0xC0000074)
#define STATUS_LUIDS_EXHAUSTED STATUS_CAST(NTSTATUS, 0xC0000075)
#define STATUS_INVALID_SUB_AUTHORITY STATUS_CAST(NTSTATUS, 0xC0000076)
#define STATUS_INVALID_ACL STATUS_CAST(NTSTATUS, 0xC0000077)
#define STATUS_INVALID_SID STATUS_CAST(NTSTATUS, 0xC0000078)
#define STATUS_INVALID_SECURITY_DESCR STATUS_CAST(NTSTATUS, 0xC0000079)
#define STATUS_PROCEDURE_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC000007A)
#define STATUS_INVALID_IMAGE_FORMAT STATUS_CAST(NTSTATUS, 0xC000007B)
#define STATUS_NO_TOKEN STATUS_CAST(NTSTATUS, 0xC000007C)
#define STATUS_BAD_INHERITANCE_ACL STATUS_CAST(NTSTATUS, 0xC000007D)
#define STATUS_RANGE_NOT_LOCKED STATUS_CAST(NTSTATUS, 0xC000007E)
#define STATUS_DISK_FULL STATUS_CAST(NTSTATUS, 0xC000007F)
#define STATUS_SERVER_DISABLED STATUS_CAST(NTSTATUS, 0xC0000080)
#define STATUS_SERVER_NOT_DISABLED STATUS_CAST(NTSTATUS, 0xC0000081)
#define STATUS_TOO_MANY_GUIDS_REQUESTED STATUS_CAST(NTSTATUS, 0xC0000082)
#define STATUS_GUIDS_EXHAUSTED STATUS_CAST(NTSTATUS, 0xC0000083)
#define STATUS_INVALID_ID_AUTHORITY STATUS_CAST(NTSTATUS, 0xC0000084)
#define STATUS_AGENTS_EXHAUSTED STATUS_CAST(NTSTATUS, 0xC0000085)
#define STATUS_INVALID_VOLUME_LABEL STATUS_CAST(NTSTATUS, 0xC0000086)
#define STATUS_SECTION_NOT_EXTENDED STATUS_CAST(NTSTATUS, 0xC0000087)
#define STATUS_NOT_MAPPED_DATA STATUS_CAST(NTSTATUS, 0xC0000088)
#define STATUS_RESOURCE_DATA_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000089)
#define STATUS_RESOURCE_TYPE_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC000008A)
#define STATUS_RESOURCE_NAME_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC000008B)
//#define STATUS_ARRAY_BOUNDS_EXCEEDED					STATUS_CAST(NTSTATUS,0xC000008C)
//#define STATUS_FLOAT_DENORMAL_OPERAND					STATUS_CAST(NTSTATUS,0xC000008D)
//#define STATUS_FLOAT_DIVIDE_BY_ZERO					STATUS_CAST(NTSTATUS,0xC000008E)
//#define STATUS_FLOAT_INEXACT_RESULT					STATUS_CAST(NTSTATUS,0xC000008F)
//#define STATUS_FLOAT_INVALID_OPERATION					STATUS_CAST(NTSTATUS,0xC0000090)
//#define STATUS_FLOAT_OVERFLOW						STATUS_CAST(NTSTATUS,0xC0000091)
//#define STATUS_FLOAT_STACK_CHECK					STATUS_CAST(NTSTATUS,0xC0000092)
//#define STATUS_FLOAT_UNDERFLOW						STATUS_CAST(NTSTATUS,0xC0000093)
//#define STATUS_INTEGER_DIVIDE_BY_ZERO					STATUS_CAST(NTSTATUS,0xC0000094)
//#define STATUS_INTEGER_OVERFLOW						STATUS_CAST(NTSTATUS,0xC0000095)
//#define STATUS_PRIVILEGED_INSTRUCTION					STATUS_CAST(NTSTATUS,0xC0000096)
#define STATUS_TOO_MANY_PAGING_FILES STATUS_CAST(NTSTATUS, 0xC0000097)
#define STATUS_FILE_INVALID STATUS_CAST(NTSTATUS, 0xC0000098)
#define STATUS_ALLOTTED_SPACE_EXCEEDED STATUS_CAST(NTSTATUS, 0xC0000099)
#define STATUS_INSUFFICIENT_RESOURCES STATUS_CAST(NTSTATUS, 0xC000009A)
#define STATUS_DFS_EXIT_PATH_FOUND STATUS_CAST(NTSTATUS, 0xC000009B)
#define STATUS_DEVICE_DATA_ERROR STATUS_CAST(NTSTATUS, 0xC000009C)
#define STATUS_DEVICE_NOT_CONNECTED STATUS_CAST(NTSTATUS, 0xC000009D)
#define STATUS_DEVICE_POWER_FAILURE STATUS_CAST(NTSTATUS, 0xC000009E)
#define STATUS_FREE_VM_NOT_AT_BASE STATUS_CAST(NTSTATUS, 0xC000009F)
#define STATUS_MEMORY_NOT_ALLOCATED STATUS_CAST(NTSTATUS, 0xC00000A0)
#define STATUS_WORKING_SET_QUOTA STATUS_CAST(NTSTATUS, 0xC00000A1)
#define STATUS_MEDIA_WRITE_PROTECTED STATUS_CAST(NTSTATUS, 0xC00000A2)
#define STATUS_DEVICE_NOT_READY STATUS_CAST(NTSTATUS, 0xC00000A3)
#define STATUS_INVALID_GROUP_ATTRIBUTES STATUS_CAST(NTSTATUS, 0xC00000A4)
#define STATUS_BAD_IMPERSONATION_LEVEL STATUS_CAST(NTSTATUS, 0xC00000A5)
#define STATUS_CANT_OPEN_ANONYMOUS STATUS_CAST(NTSTATUS, 0xC00000A6)
#define STATUS_BAD_VALIDATION_CLASS STATUS_CAST(NTSTATUS, 0xC00000A7)
#define STATUS_BAD_TOKEN_TYPE STATUS_CAST(NTSTATUS, 0xC00000A8)
#define STATUS_BAD_MASTER_BOOT_RECORD STATUS_CAST(NTSTATUS, 0xC00000A9)
#define STATUS_INSTRUCTION_MISALIGNMENT STATUS_CAST(NTSTATUS, 0xC00000AA)
#define STATUS_INSTANCE_NOT_AVAILABLE STATUS_CAST(NTSTATUS, 0xC00000AB)
#define STATUS_PIPE_NOT_AVAILABLE STATUS_CAST(NTSTATUS, 0xC00000AC)
#define STATUS_INVALID_PIPE_STATE STATUS_CAST(NTSTATUS, 0xC00000AD)
#define STATUS_PIPE_BUSY STATUS_CAST(NTSTATUS, 0xC00000AE)
#define STATUS_ILLEGAL_FUNCTION STATUS_CAST(NTSTATUS, 0xC00000AF)
#define STATUS_PIPE_DISCONNECTED STATUS_CAST(NTSTATUS, 0xC00000B0)
#define STATUS_PIPE_CLOSING STATUS_CAST(NTSTATUS, 0xC00000B1)
#define STATUS_PIPE_CONNECTED STATUS_CAST(NTSTATUS, 0xC00000B2)
#define STATUS_PIPE_LISTENING STATUS_CAST(NTSTATUS, 0xC00000B3)
#define STATUS_INVALID_READ_MODE STATUS_CAST(NTSTATUS, 0xC00000B4)
#define STATUS_IO_TIMEOUT STATUS_CAST(NTSTATUS, 0xC00000B5)
#define STATUS_FILE_FORCED_CLOSED STATUS_CAST(NTSTATUS, 0xC00000B6)
#define STATUS_PROFILING_NOT_STARTED STATUS_CAST(NTSTATUS, 0xC00000B7)
#define STATUS_PROFILING_NOT_STOPPED STATUS_CAST(NTSTATUS, 0xC00000B8)
#define STATUS_COULD_NOT_INTERPRET STATUS_CAST(NTSTATUS, 0xC00000B9)
#define STATUS_FILE_IS_A_DIRECTORY STATUS_CAST(NTSTATUS, 0xC00000BA)
#define STATUS_NOT_SUPPORTED STATUS_CAST(NTSTATUS, 0xC00000BB)
#define STATUS_REMOTE_NOT_LISTENING STATUS_CAST(NTSTATUS, 0xC00000BC)
#define STATUS_DUPLICATE_NAME STATUS_CAST(NTSTATUS, 0xC00000BD)
#define STATUS_BAD_NETWORK_PATH STATUS_CAST(NTSTATUS, 0xC00000BE)
#define STATUS_NETWORK_BUSY STATUS_CAST(NTSTATUS, 0xC00000BF)
#define STATUS_DEVICE_DOES_NOT_EXIST STATUS_CAST(NTSTATUS, 0xC00000C0)
#define STATUS_TOO_MANY_COMMANDS STATUS_CAST(NTSTATUS, 0xC00000C1)
#define STATUS_ADAPTER_HARDWARE_ERROR STATUS_CAST(NTSTATUS, 0xC00000C2)
#define STATUS_INVALID_NETWORK_RESPONSE STATUS_CAST(NTSTATUS, 0xC00000C3)
#define STATUS_UNEXPECTED_NETWORK_ERROR STATUS_CAST(NTSTATUS, 0xC00000C4)
#define STATUS_BAD_REMOTE_ADAPTER STATUS_CAST(NTSTATUS, 0xC00000C5)
#define STATUS_PRINT_QUEUE_FULL STATUS_CAST(NTSTATUS, 0xC00000C6)
#define STATUS_NO_SPOOL_SPACE STATUS_CAST(NTSTATUS, 0xC00000C7)
#define STATUS_PRINT_CANCELLED STATUS_CAST(NTSTATUS, 0xC00000C8)
#define STATUS_NETWORK_NAME_DELETED STATUS_CAST(NTSTATUS, 0xC00000C9)
#define STATUS_NETWORK_ACCESS_DENIED STATUS_CAST(NTSTATUS, 0xC00000CA)
#define STATUS_BAD_DEVICE_TYPE STATUS_CAST(NTSTATUS, 0xC00000CB)
#define STATUS_BAD_NETWORK_NAME STATUS_CAST(NTSTATUS, 0xC00000CC)
#define STATUS_TOO_MANY_NAMES STATUS_CAST(NTSTATUS, 0xC00000CD)
#define STATUS_TOO_MANY_SESSIONS STATUS_CAST(NTSTATUS, 0xC00000CE)
#define STATUS_SHARING_PAUSED STATUS_CAST(NTSTATUS, 0xC00000CF)
#define STATUS_REQUEST_NOT_ACCEPTED STATUS_CAST(NTSTATUS, 0xC00000D0)
#define STATUS_REDIRECTOR_PAUSED STATUS_CAST(NTSTATUS, 0xC00000D1)
#define STATUS_NET_WRITE_FAULT STATUS_CAST(NTSTATUS, 0xC00000D2)
#define STATUS_PROFILING_AT_LIMIT STATUS_CAST(NTSTATUS, 0xC00000D3)
#define STATUS_NOT_SAME_DEVICE STATUS_CAST(NTSTATUS, 0xC00000D4)
#define STATUS_FILE_RENAMED STATUS_CAST(NTSTATUS, 0xC00000D5)
#define STATUS_VIRTUAL_CIRCUIT_CLOSED STATUS_CAST(NTSTATUS, 0xC00000D6)
#define STATUS_NO_SECURITY_ON_OBJECT STATUS_CAST(NTSTATUS, 0xC00000D7)
#define STATUS_CANT_WAIT STATUS_CAST(NTSTATUS, 0xC00000D8)
#define STATUS_PIPE_EMPTY STATUS_CAST(NTSTATUS, 0xC00000D9)
#define STATUS_CANT_ACCESS_DOMAIN_INFO STATUS_CAST(NTSTATUS, 0xC00000DA)
#define STATUS_CANT_TERMINATE_SELF STATUS_CAST(NTSTATUS, 0xC00000DB)
#define STATUS_INVALID_SERVER_STATE STATUS_CAST(NTSTATUS, 0xC00000DC)
#define STATUS_INVALID_DOMAIN_STATE STATUS_CAST(NTSTATUS, 0xC00000DD)
#define STATUS_INVALID_DOMAIN_ROLE STATUS_CAST(NTSTATUS, 0xC00000DE)
#define STATUS_NO_SUCH_DOMAIN STATUS_CAST(NTSTATUS, 0xC00000DF)
#define STATUS_DOMAIN_EXISTS STATUS_CAST(NTSTATUS, 0xC00000E0)
#define STATUS_DOMAIN_LIMIT_EXCEEDED STATUS_CAST(NTSTATUS, 0xC00000E1)
#define STATUS_OPLOCK_NOT_GRANTED STATUS_CAST(NTSTATUS, 0xC00000E2)
#define STATUS_INVALID_OPLOCK_PROTOCOL STATUS_CAST(NTSTATUS, 0xC00000E3)
#define STATUS_INTERNAL_DB_CORRUPTION STATUS_CAST(NTSTATUS, 0xC00000E4)
#define STATUS_INTERNAL_ERROR STATUS_CAST(NTSTATUS, 0xC00000E5)
#define STATUS_GENERIC_NOT_MAPPED STATUS_CAST(NTSTATUS, 0xC00000E6)
#define STATUS_BAD_DESCRIPTOR_FORMAT STATUS_CAST(NTSTATUS, 0xC00000E7)
#define STATUS_INVALID_USER_BUFFER STATUS_CAST(NTSTATUS, 0xC00000E8)
#define STATUS_UNEXPECTED_IO_ERROR STATUS_CAST(NTSTATUS, 0xC00000E9)
#define STATUS_UNEXPECTED_MM_CREATE_ERR STATUS_CAST(NTSTATUS, 0xC00000EA)
#define STATUS_UNEXPECTED_MM_MAP_ERROR STATUS_CAST(NTSTATUS, 0xC00000EB)
#define STATUS_UNEXPECTED_MM_EXTEND_ERR STATUS_CAST(NTSTATUS, 0xC00000EC)
#define STATUS_NOT_LOGON_PROCESS STATUS_CAST(NTSTATUS, 0xC00000ED)
#define STATUS_LOGON_SESSION_EXISTS STATUS_CAST(NTSTATUS, 0xC00000EE)
#define STATUS_INVALID_PARAMETER_1 STATUS_CAST(NTSTATUS, 0xC00000EF)
#define STATUS_INVALID_PARAMETER_2 STATUS_CAST(NTSTATUS, 0xC00000F0)
#define STATUS_INVALID_PARAMETER_3 STATUS_CAST(NTSTATUS, 0xC00000F1)
#define STATUS_INVALID_PARAMETER_4 STATUS_CAST(NTSTATUS, 0xC00000F2)
#define STATUS_INVALID_PARAMETER_5 STATUS_CAST(NTSTATUS, 0xC00000F3)
#define STATUS_INVALID_PARAMETER_6 STATUS_CAST(NTSTATUS, 0xC00000F4)
#define STATUS_INVALID_PARAMETER_7 STATUS_CAST(NTSTATUS, 0xC00000F5)
#define STATUS_INVALID_PARAMETER_8 STATUS_CAST(NTSTATUS, 0xC00000F6)
#define STATUS_INVALID_PARAMETER_9 STATUS_CAST(NTSTATUS, 0xC00000F7)
#define STATUS_INVALID_PARAMETER_10 STATUS_CAST(NTSTATUS, 0xC00000F8)
#define STATUS_INVALID_PARAMETER_11 STATUS_CAST(NTSTATUS, 0xC00000F9)
#define STATUS_INVALID_PARAMETER_12 STATUS_CAST(NTSTATUS, 0xC00000FA)
#define STATUS_REDIRECTOR_NOT_STARTED STATUS_CAST(NTSTATUS, 0xC00000FB)
#define STATUS_REDIRECTOR_STARTED STATUS_CAST(NTSTATUS, 0xC00000FC)
//#define STATUS_STACK_OVERFLOW						STATUS_CAST(NTSTATUS,0xC00000FD)
#define STATUS_NO_SUCH_PACKAGE STATUS_CAST(NTSTATUS, 0xC00000FE)
#define STATUS_BAD_FUNCTION_TABLE STATUS_CAST(NTSTATUS, 0xC00000FF)
#define STATUS_VARIABLE_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000100)
#define STATUS_DIRECTORY_NOT_EMPTY STATUS_CAST(NTSTATUS, 0xC0000101)
#define STATUS_FILE_CORRUPT_ERROR STATUS_CAST(NTSTATUS, 0xC0000102)
#define STATUS_NOT_A_DIRECTORY STATUS_CAST(NTSTATUS, 0xC0000103)
#define STATUS_BAD_LOGON_SESSION_STATE STATUS_CAST(NTSTATUS, 0xC0000104)
#define STATUS_LOGON_SESSION_COLLISION STATUS_CAST(NTSTATUS, 0xC0000105)
#define STATUS_NAME_TOO_LONG STATUS_CAST(NTSTATUS, 0xC0000106)
#define STATUS_FILES_OPEN STATUS_CAST(NTSTATUS, 0xC0000107)
#define STATUS_CONNECTION_IN_USE STATUS_CAST(NTSTATUS, 0xC0000108)
#define STATUS_MESSAGE_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000109)
#define STATUS_PROCESS_IS_TERMINATING STATUS_CAST(NTSTATUS, 0xC000010A)
#define STATUS_INVALID_LOGON_TYPE STATUS_CAST(NTSTATUS, 0xC000010B)
#define STATUS_NO_GUID_TRANSLATION STATUS_CAST(NTSTATUS, 0xC000010C)
#define STATUS_CANNOT_IMPERSONATE STATUS_CAST(NTSTATUS, 0xC000010D)
#define STATUS_IMAGE_ALREADY_LOADED STATUS_CAST(NTSTATUS, 0xC000010E)
#define STATUS_ABIOS_NOT_PRESENT STATUS_CAST(NTSTATUS, 0xC000010F)
#define STATUS_ABIOS_LID_NOT_EXIST STATUS_CAST(NTSTATUS, 0xC0000110)
#define STATUS_ABIOS_LID_ALREADY_OWNED STATUS_CAST(NTSTATUS, 0xC0000111)
#define STATUS_ABIOS_NOT_LID_OWNER STATUS_CAST(NTSTATUS, 0xC0000112)
#define STATUS_ABIOS_INVALID_COMMAND STATUS_CAST(NTSTATUS, 0xC0000113)
#define STATUS_ABIOS_INVALID_LID STATUS_CAST(NTSTATUS, 0xC0000114)
#define STATUS_ABIOS_SELECTOR_NOT_AVAILABLE STATUS_CAST(NTSTATUS, 0xC0000115)
#define STATUS_ABIOS_INVALID_SELECTOR STATUS_CAST(NTSTATUS, 0xC0000116)
#define STATUS_NO_LDT STATUS_CAST(NTSTATUS, 0xC0000117)
#define STATUS_INVALID_LDT_SIZE STATUS_CAST(NTSTATUS, 0xC0000118)
#define STATUS_INVALID_LDT_OFFSET STATUS_CAST(NTSTATUS, 0xC0000119)
#define STATUS_INVALID_LDT_DESCRIPTOR STATUS_CAST(NTSTATUS, 0xC000011A)
#define STATUS_INVALID_IMAGE_NE_FORMAT STATUS_CAST(NTSTATUS, 0xC000011B)
#define STATUS_RXACT_INVALID_STATE STATUS_CAST(NTSTATUS, 0xC000011C)
#define STATUS_RXACT_COMMIT_FAILURE STATUS_CAST(NTSTATUS, 0xC000011D)
#define STATUS_MAPPED_FILE_SIZE_ZERO STATUS_CAST(NTSTATUS, 0xC000011E)
#define STATUS_TOO_MANY_OPENED_FILES STATUS_CAST(NTSTATUS, 0xC000011F)
#define STATUS_CANCELLED STATUS_CAST(NTSTATUS, 0xC0000120)
#define STATUS_CANNOT_DELETE STATUS_CAST(NTSTATUS, 0xC0000121)
#define STATUS_INVALID_COMPUTER_NAME STATUS_CAST(NTSTATUS, 0xC0000122)
#define STATUS_FILE_DELETED STATUS_CAST(NTSTATUS, 0xC0000123)
#define STATUS_SPECIAL_ACCOUNT STATUS_CAST(NTSTATUS, 0xC0000124)
#define STATUS_SPECIAL_GROUP STATUS_CAST(NTSTATUS, 0xC0000125)
#define STATUS_SPECIAL_USER STATUS_CAST(NTSTATUS, 0xC0000126)
#define STATUS_MEMBERS_PRIMARY_GROUP STATUS_CAST(NTSTATUS, 0xC0000127)
#define STATUS_FILE_CLOSED STATUS_CAST(NTSTATUS, 0xC0000128)
#define STATUS_TOO_MANY_THREADS STATUS_CAST(NTSTATUS, 0xC0000129)
#define STATUS_THREAD_NOT_IN_PROCESS STATUS_CAST(NTSTATUS, 0xC000012A)
#define STATUS_TOKEN_ALREADY_IN_USE STATUS_CAST(NTSTATUS, 0xC000012B)
#define STATUS_PAGEFILE_QUOTA_EXCEEDED STATUS_CAST(NTSTATUS, 0xC000012C)
#define STATUS_COMMITMENT_LIMIT STATUS_CAST(NTSTATUS, 0xC000012D)
#define STATUS_INVALID_IMAGE_LE_FORMAT STATUS_CAST(NTSTATUS, 0xC000012E)
#define STATUS_INVALID_IMAGE_NOT_MZ STATUS_CAST(NTSTATUS, 0xC000012F)
#define STATUS_INVALID_IMAGE_PROTECT STATUS_CAST(NTSTATUS, 0xC0000130)
#define STATUS_INVALID_IMAGE_WIN_16 STATUS_CAST(NTSTATUS, 0xC0000131)
#define STATUS_LOGON_SERVER_CONFLICT STATUS_CAST(NTSTATUS, 0xC0000132)
#define STATUS_TIME_DIFFERENCE_AT_DC STATUS_CAST(NTSTATUS, 0xC0000133)
#define STATUS_SYNCHRONIZATION_REQUIRED STATUS_CAST(NTSTATUS, 0xC0000134)
//#define STATUS_DLL_NOT_FOUND						STATUS_CAST(NTSTATUS,0xC0000135)
#define STATUS_OPEN_FAILED STATUS_CAST(NTSTATUS, 0xC0000136)
#define STATUS_IO_PRIVILEGE_FAILED STATUS_CAST(NTSTATUS, 0xC0000137)
//#define STATUS_ORDINAL_NOT_FOUND					STATUS_CAST(NTSTATUS,0xC0000138)
//#define STATUS_ENTRYPOINT_NOT_FOUND					STATUS_CAST(NTSTATUS,0xC0000139)
//#define STATUS_CONTROL_C_EXIT						STATUS_CAST(NTSTATUS,0xC000013A)
#define STATUS_LOCAL_DISCONNECT STATUS_CAST(NTSTATUS, 0xC000013B)
#define STATUS_REMOTE_DISCONNECT STATUS_CAST(NTSTATUS, 0xC000013C)
#define STATUS_REMOTE_RESOURCES STATUS_CAST(NTSTATUS, 0xC000013D)
#define STATUS_LINK_FAILED STATUS_CAST(NTSTATUS, 0xC000013E)
#define STATUS_LINK_TIMEOUT STATUS_CAST(NTSTATUS, 0xC000013F)
#define STATUS_INVALID_CONNECTION STATUS_CAST(NTSTATUS, 0xC0000140)
#define STATUS_INVALID_ADDRESS STATUS_CAST(NTSTATUS, 0xC0000141)
//#define STATUS_DLL_INIT_FAILED						STATUS_CAST(NTSTATUS,0xC0000142)
#define STATUS_MISSING_SYSTEMFILE STATUS_CAST(NTSTATUS, 0xC0000143)
#define STATUS_UNHANDLED_EXCEPTION STATUS_CAST(NTSTATUS, 0xC0000144)
#define STATUS_APP_INIT_FAILURE STATUS_CAST(NTSTATUS, 0xC0000145)
#define STATUS_PAGEFILE_CREATE_FAILED STATUS_CAST(NTSTATUS, 0xC0000146)
#define STATUS_NO_PAGEFILE STATUS_CAST(NTSTATUS, 0xC0000147)
#define STATUS_INVALID_LEVEL STATUS_CAST(NTSTATUS, 0xC0000148)
#define STATUS_WRONG_PASSWORD_CORE STATUS_CAST(NTSTATUS, 0xC0000149)
#define STATUS_ILLEGAL_FLOAT_CONTEXT STATUS_CAST(NTSTATUS, 0xC000014A)
#define STATUS_PIPE_BROKEN STATUS_CAST(NTSTATUS, 0xC000014B)
#define STATUS_REGISTRY_CORRUPT STATUS_CAST(NTSTATUS, 0xC000014C)
#define STATUS_REGISTRY_IO_FAILED STATUS_CAST(NTSTATUS, 0xC000014D)
#define STATUS_NO_EVENT_PAIR STATUS_CAST(NTSTATUS, 0xC000014E)
#define STATUS_UNRECOGNIZED_VOLUME STATUS_CAST(NTSTATUS, 0xC000014F)
#define STATUS_SERIAL_NO_DEVICE_INITED STATUS_CAST(NTSTATUS, 0xC0000150)
#define STATUS_NO_SUCH_ALIAS STATUS_CAST(NTSTATUS, 0xC0000151)
#define STATUS_MEMBER_NOT_IN_ALIAS STATUS_CAST(NTSTATUS, 0xC0000152)
#define STATUS_MEMBER_IN_ALIAS STATUS_CAST(NTSTATUS, 0xC0000153)
#define STATUS_ALIAS_EXISTS STATUS_CAST(NTSTATUS, 0xC0000154)
#define STATUS_LOGON_NOT_GRANTED STATUS_CAST(NTSTATUS, 0xC0000155)
#define STATUS_TOO_MANY_SECRETS STATUS_CAST(NTSTATUS, 0xC0000156)
#define STATUS_SECRET_TOO_LONG STATUS_CAST(NTSTATUS, 0xC0000157)
#define STATUS_INTERNAL_DB_ERROR STATUS_CAST(NTSTATUS, 0xC0000158)
#define STATUS_FULLSCREEN_MODE STATUS_CAST(NTSTATUS, 0xC0000159)
#define STATUS_TOO_MANY_CONTEXT_IDS STATUS_CAST(NTSTATUS, 0xC000015A)
//#define STATUS_LOGON_TYPE_NOT_GRANTED					STATUS_CAST(NTSTATUS,0xC000015B)
#define STATUS_NOT_REGISTRY_FILE STATUS_CAST(NTSTATUS, 0xC000015C)
#define STATUS_NT_CROSS_ENCRYPTION_REQUIRED STATUS_CAST(NTSTATUS, 0xC000015D)
#define STATUS_DOMAIN_CTRLR_CONFIG_ERROR STATUS_CAST(NTSTATUS, 0xC000015E)
#define STATUS_FT_MISSING_MEMBER STATUS_CAST(NTSTATUS, 0xC000015F)
#define STATUS_ILL_FORMED_SERVICE_ENTRY STATUS_CAST(NTSTATUS, 0xC0000160)
#define STATUS_ILLEGAL_CHARACTER STATUS_CAST(NTSTATUS, 0xC0000161)
#define STATUS_UNMAPPABLE_CHARACTER STATUS_CAST(NTSTATUS, 0xC0000162)
#define STATUS_UNDEFINED_CHARACTER STATUS_CAST(NTSTATUS, 0xC0000163)
#define STATUS_FLOPPY_VOLUME STATUS_CAST(NTSTATUS, 0xC0000164)
#define STATUS_FLOPPY_ID_MARK_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000165)
#define STATUS_FLOPPY_WRONG_CYLINDER STATUS_CAST(NTSTATUS, 0xC0000166)
#define STATUS_FLOPPY_UNKNOWN_ERROR STATUS_CAST(NTSTATUS, 0xC0000167)
#define STATUS_FLOPPY_BAD_REGISTERS STATUS_CAST(NTSTATUS, 0xC0000168)
#define STATUS_DISK_RECALIBRATE_FAILED STATUS_CAST(NTSTATUS, 0xC0000169)
#define STATUS_DISK_OPERATION_FAILED STATUS_CAST(NTSTATUS, 0xC000016A)
#define STATUS_DISK_RESET_FAILED STATUS_CAST(NTSTATUS, 0xC000016B)
#define STATUS_SHARED_IRQ_BUSY STATUS_CAST(NTSTATUS, 0xC000016C)
#define STATUS_FT_ORPHANING STATUS_CAST(NTSTATUS, 0xC000016D)
#define STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT STATUS_CAST(NTSTATUS, 0xC000016E)

#define STATUS_PARTITION_FAILURE STATUS_CAST(NTSTATUS, 0xC0000172)
#define STATUS_INVALID_BLOCK_LENGTH STATUS_CAST(NTSTATUS, 0xC0000173)
#define STATUS_DEVICE_NOT_PARTITIONED STATUS_CAST(NTSTATUS, 0xC0000174)
#define STATUS_UNABLE_TO_LOCK_MEDIA STATUS_CAST(NTSTATUS, 0xC0000175)
#define STATUS_UNABLE_TO_UNLOAD_MEDIA STATUS_CAST(NTSTATUS, 0xC0000176)
#define STATUS_EOM_OVERFLOW STATUS_CAST(NTSTATUS, 0xC0000177)
#define STATUS_NO_MEDIA STATUS_CAST(NTSTATUS, 0xC0000178)
#define STATUS_NO_SUCH_MEMBER STATUS_CAST(NTSTATUS, 0xC000017A)
#define STATUS_INVALID_MEMBER STATUS_CAST(NTSTATUS, 0xC000017B)
#define STATUS_KEY_DELETED STATUS_CAST(NTSTATUS, 0xC000017C)
#define STATUS_NO_LOG_SPACE STATUS_CAST(NTSTATUS, 0xC000017D)
#define STATUS_TOO_MANY_SIDS STATUS_CAST(NTSTATUS, 0xC000017E)
#define STATUS_LM_CROSS_ENCRYPTION_REQUIRED STATUS_CAST(NTSTATUS, 0xC000017F)
#define STATUS_KEY_HAS_CHILDREN STATUS_CAST(NTSTATUS, 0xC0000180)
#define STATUS_CHILD_MUST_BE_VOLATILE STATUS_CAST(NTSTATUS, 0xC0000181)
#define STATUS_DEVICE_CONFIGURATION_ERROR STATUS_CAST(NTSTATUS, 0xC0000182)
#define STATUS_DRIVER_INTERNAL_ERROR STATUS_CAST(NTSTATUS, 0xC0000183)
#define STATUS_INVALID_DEVICE_STATE STATUS_CAST(NTSTATUS, 0xC0000184)
#define STATUS_IO_DEVICE_ERROR STATUS_CAST(NTSTATUS, 0xC0000185)
#define STATUS_DEVICE_PROTOCOL_ERROR STATUS_CAST(NTSTATUS, 0xC0000186)
#define STATUS_BACKUP_CONTROLLER STATUS_CAST(NTSTATUS, 0xC0000187)
#define STATUS_LOG_FILE_FULL STATUS_CAST(NTSTATUS, 0xC0000188)
#define STATUS_TOO_LATE STATUS_CAST(NTSTATUS, 0xC0000189)
#define STATUS_NO_TRUST_LSA_SECRET STATUS_CAST(NTSTATUS, 0xC000018A)
#define STATUS_NO_TRUST_SAM_ACCOUNT STATUS_CAST(NTSTATUS, 0xC000018B)
#define STATUS_TRUSTED_DOMAIN_FAILURE STATUS_CAST(NTSTATUS, 0xC000018C)
#define STATUS_TRUSTED_RELATIONSHIP_FAILURE STATUS_CAST(NTSTATUS, 0xC000018D)
#define STATUS_EVENTLOG_FILE_CORRUPT STATUS_CAST(NTSTATUS, 0xC000018E)
#define STATUS_EVENTLOG_CANT_START STATUS_CAST(NTSTATUS, 0xC000018F)
#define STATUS_TRUST_FAILURE STATUS_CAST(NTSTATUS, 0xC0000190)
#define STATUS_MUTANT_LIMIT_EXCEEDED STATUS_CAST(NTSTATUS, 0xC0000191)
#define STATUS_NETLOGON_NOT_STARTED STATUS_CAST(NTSTATUS, 0xC0000192)
//#define STATUS_ACCOUNT_EXPIRED						STATUS_CAST(NTSTATUS,0xC0000193)
#define STATUS_POSSIBLE_DEADLOCK STATUS_CAST(NTSTATUS, 0xC0000194)
#define STATUS_NETWORK_CREDENTIAL_CONFLICT STATUS_CAST(NTSTATUS, 0xC0000195)
#define STATUS_REMOTE_SESSION_LIMIT STATUS_CAST(NTSTATUS, 0xC0000196)
#define STATUS_EVENTLOG_FILE_CHANGED STATUS_CAST(NTSTATUS, 0xC0000197)
#define STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT STATUS_CAST(NTSTATUS, 0xC0000198)
#define STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT STATUS_CAST(NTSTATUS, 0xC0000199)
#define STATUS_NOLOGON_SERVER_TRUST_ACCOUNT STATUS_CAST(NTSTATUS, 0xC000019A)
#define STATUS_DOMAIN_TRUST_INCONSISTENT STATUS_CAST(NTSTATUS, 0xC000019B)
#define STATUS_FS_DRIVER_REQUIRED STATUS_CAST(NTSTATUS, 0xC000019C)
#define STATUS_NO_USER_SESSION_KEY STATUS_CAST(NTSTATUS, 0xC0000202)
#define STATUS_USER_SESSION_DELETED STATUS_CAST(NTSTATUS, 0xC0000203)
#define STATUS_RESOURCE_LANG_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000204)
#define STATUS_INSUFF_SERVER_RESOURCES STATUS_CAST(NTSTATUS, 0xC0000205)
#define STATUS_INVALID_BUFFER_SIZE STATUS_CAST(NTSTATUS, 0xC0000206)
#define STATUS_INVALID_ADDRESS_COMPONENT STATUS_CAST(NTSTATUS, 0xC0000207)
#define STATUS_INVALID_ADDRESS_WILDCARD STATUS_CAST(NTSTATUS, 0xC0000208)
#define STATUS_TOO_MANY_ADDRESSES STATUS_CAST(NTSTATUS, 0xC0000209)
#define STATUS_ADDRESS_ALREADY_EXISTS STATUS_CAST(NTSTATUS, 0xC000020A)
#define STATUS_ADDRESS_CLOSED STATUS_CAST(NTSTATUS, 0xC000020B)
#define STATUS_CONNECTION_DISCONNECTED STATUS_CAST(NTSTATUS, 0xC000020C)
#define STATUS_CONNECTION_RESET STATUS_CAST(NTSTATUS, 0xC000020D)
#define STATUS_TOO_MANY_NODES STATUS_CAST(NTSTATUS, 0xC000020E)
#define STATUS_TRANSACTION_ABORTED STATUS_CAST(NTSTATUS, 0xC000020F)
#define STATUS_TRANSACTION_TIMED_OUT STATUS_CAST(NTSTATUS, 0xC0000210)
#define STATUS_TRANSACTION_NO_RELEASE STATUS_CAST(NTSTATUS, 0xC0000211)
#define STATUS_TRANSACTION_NO_MATCH STATUS_CAST(NTSTATUS, 0xC0000212)
#define STATUS_TRANSACTION_RESPONDED STATUS_CAST(NTSTATUS, 0xC0000213)
#define STATUS_TRANSACTION_INVALID_ID STATUS_CAST(NTSTATUS, 0xC0000214)
#define STATUS_TRANSACTION_INVALID_TYPE STATUS_CAST(NTSTATUS, 0xC0000215)
#define STATUS_NOT_SERVER_SESSION STATUS_CAST(NTSTATUS, 0xC0000216)
#define STATUS_NOT_CLIENT_SESSION STATUS_CAST(NTSTATUS, 0xC0000217)
#define STATUS_CANNOT_LOAD_REGISTRY_FILE STATUS_CAST(NTSTATUS, 0xC0000218)
#define STATUS_DEBUG_ATTACH_FAILED STATUS_CAST(NTSTATUS, 0xC0000219)
#define STATUS_SYSTEM_PROCESS_TERMINATED STATUS_CAST(NTSTATUS, 0xC000021A)
#define STATUS_DATA_NOT_ACCEPTED STATUS_CAST(NTSTATUS, 0xC000021B)
#define STATUS_NO_BROWSER_SERVERS_FOUND STATUS_CAST(NTSTATUS, 0xC000021C)
#define STATUS_VDM_HARD_ERROR STATUS_CAST(NTSTATUS, 0xC000021D)
#define STATUS_DRIVER_CANCEL_TIMEOUT STATUS_CAST(NTSTATUS, 0xC000021E)
#define STATUS_REPLY_MESSAGE_MISMATCH STATUS_CAST(NTSTATUS, 0xC000021F)
#define STATUS_MAPPED_ALIGNMENT STATUS_CAST(NTSTATUS, 0xC0000220)
#define STATUS_IMAGE_CHECKSUM_MISMATCH STATUS_CAST(NTSTATUS, 0xC0000221)
#define STATUS_LOST_WRITEBEHIND_DATA STATUS_CAST(NTSTATUS, 0xC0000222)
#define STATUS_CLIENT_SERVER_PARAMETERS_INVALID STATUS_CAST(NTSTATUS, 0xC0000223)
//#define STATUS_PASSWORD_MUST_CHANGE					STATUS_CAST(NTSTATUS,0xC0000224)
#define STATUS_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000225)
#define STATUS_NOT_TINY_STREAM STATUS_CAST(NTSTATUS, 0xC0000226)
#define STATUS_RECOVERY_FAILURE STATUS_CAST(NTSTATUS, 0xC0000227)
#define STATUS_STACK_OVERFLOW_READ STATUS_CAST(NTSTATUS, 0xC0000228)
#define STATUS_FAIL_CHECK STATUS_CAST(NTSTATUS, 0xC0000229)
#define STATUS_DUPLICATE_OBJECTID STATUS_CAST(NTSTATUS, 0xC000022A)
#define STATUS_OBJECTID_EXISTS STATUS_CAST(NTSTATUS, 0xC000022B)
#define STATUS_CONVERT_TO_LARGE STATUS_CAST(NTSTATUS, 0xC000022C)
#define STATUS_RETRY STATUS_CAST(NTSTATUS, 0xC000022D)
#define STATUS_FOUND_OUT_OF_SCOPE STATUS_CAST(NTSTATUS, 0xC000022E)
#define STATUS_ALLOCATE_BUCKET STATUS_CAST(NTSTATUS, 0xC000022F)
#define STATUS_PROPSET_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000230)
#define STATUS_MARSHALL_OVERFLOW STATUS_CAST(NTSTATUS, 0xC0000231)
#define STATUS_INVALID_VARIANT STATUS_CAST(NTSTATUS, 0xC0000232)
#define STATUS_DOMAIN_CONTROLLER_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000233)
//#define STATUS_ACCOUNT_LOCKED_OUT					STATUS_CAST(NTSTATUS,0xC0000234)
#define STATUS_HANDLE_NOT_CLOSABLE STATUS_CAST(NTSTATUS, 0xC0000235)
#define STATUS_CONNECTION_REFUSED STATUS_CAST(NTSTATUS, 0xC0000236)
#define STATUS_GRACEFUL_DISCONNECT STATUS_CAST(NTSTATUS, 0xC0000237)
#define STATUS_ADDRESS_ALREADY_ASSOCIATED STATUS_CAST(NTSTATUS, 0xC0000238)
#define STATUS_ADDRESS_NOT_ASSOCIATED STATUS_CAST(NTSTATUS, 0xC0000239)
#define STATUS_CONNECTION_INVALID STATUS_CAST(NTSTATUS, 0xC000023A)
#define STATUS_CONNECTION_ACTIVE STATUS_CAST(NTSTATUS, 0xC000023B)
#define STATUS_NETWORK_UNREACHABLE STATUS_CAST(NTSTATUS, 0xC000023C)
#define STATUS_HOST_UNREACHABLE STATUS_CAST(NTSTATUS, 0xC000023D)
#define STATUS_PROTOCOL_UNREACHABLE STATUS_CAST(NTSTATUS, 0xC000023E)
#define STATUS_PORT_UNREACHABLE STATUS_CAST(NTSTATUS, 0xC000023F)
#define STATUS_REQUEST_ABORTED STATUS_CAST(NTSTATUS, 0xC0000240)
#define STATUS_CONNECTION_ABORTED STATUS_CAST(NTSTATUS, 0xC0000241)
#define STATUS_BAD_COMPRESSION_BUFFER STATUS_CAST(NTSTATUS, 0xC0000242)
#define STATUS_USER_MAPPED_FILE STATUS_CAST(NTSTATUS, 0xC0000243)
#define STATUS_AUDIT_FAILED STATUS_CAST(NTSTATUS, 0xC0000244)
#define STATUS_TIMER_RESOLUTION_NOT_SET STATUS_CAST(NTSTATUS, 0xC0000245)
#define STATUS_CONNECTION_COUNT_LIMIT STATUS_CAST(NTSTATUS, 0xC0000246)
#define STATUS_LOGIN_TIME_RESTRICTION STATUS_CAST(NTSTATUS, 0xC0000247)
#define STATUS_LOGIN_WKSTA_RESTRICTION STATUS_CAST(NTSTATUS, 0xC0000248)
#define STATUS_IMAGE_MP_UP_MISMATCH STATUS_CAST(NTSTATUS, 0xC0000249)
#define STATUS_INSUFFICIENT_LOGON_INFO STATUS_CAST(NTSTATUS, 0xC0000250)
#define STATUS_BAD_DLL_ENTRYPOINT STATUS_CAST(NTSTATUS, 0xC0000251)
#define STATUS_BAD_SERVICE_ENTRYPOINT STATUS_CAST(NTSTATUS, 0xC0000252)
#define STATUS_LPC_REPLY_LOST STATUS_CAST(NTSTATUS, 0xC0000253)
#define STATUS_IP_ADDRESS_CONFLICT1 STATUS_CAST(NTSTATUS, 0xC0000254)
#define STATUS_IP_ADDRESS_CONFLICT2 STATUS_CAST(NTSTATUS, 0xC0000255)
#define STATUS_REGISTRY_QUOTA_LIMIT STATUS_CAST(NTSTATUS, 0xC0000256)
#define STATUS_PATH_NOT_COVERED STATUS_CAST(NTSTATUS, 0xC0000257)
#define STATUS_NO_CALLBACK_ACTIVE STATUS_CAST(NTSTATUS, 0xC0000258)
#define STATUS_LICENSE_QUOTA_EXCEEDED STATUS_CAST(NTSTATUS, 0xC0000259)
#define STATUS_PWD_TOO_SHORT STATUS_CAST(NTSTATUS, 0xC000025A)
#define STATUS_PWD_TOO_RECENT STATUS_CAST(NTSTATUS, 0xC000025B)
#define STATUS_PWD_HISTORY_CONFLICT STATUS_CAST(NTSTATUS, 0xC000025C)
#define STATUS_PLUGPLAY_NO_DEVICE STATUS_CAST(NTSTATUS, 0xC000025E)
#define STATUS_UNSUPPORTED_COMPRESSION STATUS_CAST(NTSTATUS, 0xC000025F)
#define STATUS_INVALID_HW_PROFILE STATUS_CAST(NTSTATUS, 0xC0000260)
#define STATUS_INVALID_PLUGPLAY_DEVICE_PATH STATUS_CAST(NTSTATUS, 0xC0000261)
#define STATUS_DRIVER_ORDINAL_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000262)
#define STATUS_DRIVER_ENTRYPOINT_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000263)
#define STATUS_RESOURCE_NOT_OWNED STATUS_CAST(NTSTATUS, 0xC0000264)
#define STATUS_TOO_MANY_LINKS STATUS_CAST(NTSTATUS, 0xC0000265)
#define STATUS_QUOTA_LIST_INCONSISTENT STATUS_CAST(NTSTATUS, 0xC0000266)
#define STATUS_FILE_IS_OFFLINE STATUS_CAST(NTSTATUS, 0xC0000267)
#define STATUS_EVALUATION_EXPIRATION STATUS_CAST(NTSTATUS, 0xC0000268)
#define STATUS_ILLEGAL_DLL_RELOCATION STATUS_CAST(NTSTATUS, 0xC0000269)
#define STATUS_LICENSE_VIOLATION STATUS_CAST(NTSTATUS, 0xC000026A)
#define STATUS_DLL_INIT_FAILED_LOGOFF STATUS_CAST(NTSTATUS, 0xC000026B)
#define STATUS_DRIVER_UNABLE_TO_LOAD STATUS_CAST(NTSTATUS, 0xC000026C)
#define STATUS_DFS_UNAVAILABLE STATUS_CAST(NTSTATUS, 0xC000026D)
#define STATUS_VOLUME_DISMOUNTED STATUS_CAST(NTSTATUS, 0xC000026E)
#define STATUS_WX86_INTERNAL_ERROR STATUS_CAST(NTSTATUS, 0xC000026F)
#define STATUS_WX86_FLOAT_STACK_CHECK STATUS_CAST(NTSTATUS, 0xC0000270)
#define STATUS_VALIDATE_CONTINUE STATUS_CAST(NTSTATUS, 0xC0000271)
#define STATUS_NO_MATCH STATUS_CAST(NTSTATUS, 0xC0000272)
#define STATUS_NO_MORE_MATCHES STATUS_CAST(NTSTATUS, 0xC0000273)
#define STATUS_NOT_A_REPARSE_POINT STATUS_CAST(NTSTATUS, 0xC0000275)
#define STATUS_IO_REPARSE_TAG_INVALID STATUS_CAST(NTSTATUS, 0xC0000276)
#define STATUS_IO_REPARSE_TAG_MISMATCH STATUS_CAST(NTSTATUS, 0xC0000277)
#define STATUS_IO_REPARSE_DATA_INVALID STATUS_CAST(NTSTATUS, 0xC0000278)
#define STATUS_IO_REPARSE_TAG_NOT_HANDLED STATUS_CAST(NTSTATUS, 0xC0000279)
#define STATUS_REPARSE_POINT_NOT_RESOLVED STATUS_CAST(NTSTATUS, 0xC0000280)
#define STATUS_DIRECTORY_IS_A_REPARSE_POINT STATUS_CAST(NTSTATUS, 0xC0000281)
#define STATUS_RANGE_LIST_CONFLICT STATUS_CAST(NTSTATUS, 0xC0000282)
#define STATUS_SOURCE_ELEMENT_EMPTY STATUS_CAST(NTSTATUS, 0xC0000283)
#define STATUS_DESTINATION_ELEMENT_FULL STATUS_CAST(NTSTATUS, 0xC0000284)
#define STATUS_ILLEGAL_ELEMENT_ADDRESS STATUS_CAST(NTSTATUS, 0xC0000285)
#define STATUS_MAGAZINE_NOT_PRESENT STATUS_CAST(NTSTATUS, 0xC0000286)
#define STATUS_REINITIALIZATION_NEEDED STATUS_CAST(NTSTATUS, 0xC0000287)
#define STATUS_ENCRYPTION_FAILED STATUS_CAST(NTSTATUS, 0xC000028A)
#define STATUS_DECRYPTION_FAILED STATUS_CAST(NTSTATUS, 0xC000028B)
#define STATUS_RANGE_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC000028C)
#define STATUS_NO_RECOVERY_POLICY STATUS_CAST(NTSTATUS, 0xC000028D)
#define STATUS_NO_EFS STATUS_CAST(NTSTATUS, 0xC000028E)
#define STATUS_WRONG_EFS STATUS_CAST(NTSTATUS, 0xC000028F)
#define STATUS_NO_USER_KEYS STATUS_CAST(NTSTATUS, 0xC0000290)
#define STATUS_FILE_NOT_ENCRYPTED STATUS_CAST(NTSTATUS, 0xC0000291)
#define STATUS_NOT_EXPORT_FORMAT STATUS_CAST(NTSTATUS, 0xC0000292)
#define STATUS_FILE_ENCRYPTED STATUS_CAST(NTSTATUS, 0xC0000293)
#define STATUS_WMI_GUID_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000295)
#define STATUS_WMI_INSTANCE_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000296)
#define STATUS_WMI_ITEMID_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0000297)
#define STATUS_WMI_TRY_AGAIN STATUS_CAST(NTSTATUS, 0xC0000298)
#define STATUS_SHARED_POLICY STATUS_CAST(NTSTATUS, 0xC0000299)
#define STATUS_POLICY_OBJECT_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC000029A)
#define STATUS_POLICY_ONLY_IN_DS STATUS_CAST(NTSTATUS, 0xC000029B)
#define STATUS_VOLUME_NOT_UPGRADED STATUS_CAST(NTSTATUS, 0xC000029C)
#define STATUS_REMOTE_STORAGE_NOT_ACTIVE STATUS_CAST(NTSTATUS, 0xC000029D)
#define STATUS_REMOTE_STORAGE_MEDIA_ERROR STATUS_CAST(NTSTATUS, 0xC000029E)
#define STATUS_NO_TRACKING_SERVICE STATUS_CAST(NTSTATUS, 0xC000029F)
#define STATUS_SERVER_SID_MISMATCH STATUS_CAST(NTSTATUS, 0xC00002A0)
#define STATUS_DS_NO_ATTRIBUTE_OR_VALUE STATUS_CAST(NTSTATUS, 0xC00002A1)
#define STATUS_DS_INVALID_ATTRIBUTE_SYNTAX STATUS_CAST(NTSTATUS, 0xC00002A2)
#define STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED STATUS_CAST(NTSTATUS, 0xC00002A3)
#define STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS STATUS_CAST(NTSTATUS, 0xC00002A4)
#define STATUS_DS_BUSY STATUS_CAST(NTSTATUS, 0xC00002A5)
#define STATUS_DS_UNAVAILABLE STATUS_CAST(NTSTATUS, 0xC00002A6)
#define STATUS_DS_NO_RIDS_ALLOCATED STATUS_CAST(NTSTATUS, 0xC00002A7)
#define STATUS_DS_NO_MORE_RIDS STATUS_CAST(NTSTATUS, 0xC00002A8)
#define STATUS_DS_INCORRECT_ROLE_OWNER STATUS_CAST(NTSTATUS, 0xC00002A9)
#define STATUS_DS_RIDMGR_INIT_ERROR STATUS_CAST(NTSTATUS, 0xC00002AA)
#define STATUS_DS_OBJ_CLASS_VIOLATION STATUS_CAST(NTSTATUS, 0xC00002AB)
#define STATUS_DS_CANT_ON_NON_LEAF STATUS_CAST(NTSTATUS, 0xC00002AC)
#define STATUS_DS_CANT_ON_RDN STATUS_CAST(NTSTATUS, 0xC00002AD)
#define STATUS_DS_CANT_MOD_OBJ_CLASS STATUS_CAST(NTSTATUS, 0xC00002AE)
#define STATUS_DS_CROSS_DOM_MOVE_FAILED STATUS_CAST(NTSTATUS, 0xC00002AF)
#define STATUS_DS_GC_NOT_AVAILABLE STATUS_CAST(NTSTATUS, 0xC00002B0)
#define STATUS_DIRECTORY_SERVICE_REQUIRED STATUS_CAST(NTSTATUS, 0xC00002B1)
#define STATUS_REPARSE_ATTRIBUTE_CONFLICT STATUS_CAST(NTSTATUS, 0xC00002B2)
#define STATUS_CANT_ENABLE_DENY_ONLY STATUS_CAST(NTSTATUS, 0xC00002B3)
//#define STATUS_FLOAT_MULTIPLE_FAULTS					STATUS_CAST(NTSTATUS,0xC00002B4)
//#define STATUS_FLOAT_MULTIPLE_TRAPS					STATUS_CAST(NTSTATUS,0xC00002B5)
#define STATUS_DEVICE_REMOVED STATUS_CAST(NTSTATUS, 0xC00002B6)
#define STATUS_JOURNAL_DELETE_IN_PROGRESS STATUS_CAST(NTSTATUS, 0xC00002B7)
#define STATUS_JOURNAL_NOT_ACTIVE STATUS_CAST(NTSTATUS, 0xC00002B8)
#define STATUS_NOINTERFACE STATUS_CAST(NTSTATUS, 0xC00002B9)
#define STATUS_DS_ADMIN_LIMIT_EXCEEDED STATUS_CAST(NTSTATUS, 0xC00002C1)
#define STATUS_DRIVER_FAILED_SLEEP STATUS_CAST(NTSTATUS, 0xC00002C2)
#define STATUS_MUTUAL_AUTHENTICATION_FAILED STATUS_CAST(NTSTATUS, 0xC00002C3)
#define STATUS_CORRUPT_SYSTEM_FILE STATUS_CAST(NTSTATUS, 0xC00002C4)
#define STATUS_DATATYPE_MISALIGNMENT_ERROR STATUS_CAST(NTSTATUS, 0xC00002C5)
#define STATUS_WMI_READ_ONLY STATUS_CAST(NTSTATUS, 0xC00002C6)
#define STATUS_WMI_SET_FAILURE STATUS_CAST(NTSTATUS, 0xC00002C7)
#define STATUS_COMMITMENT_MINIMUM STATUS_CAST(NTSTATUS, 0xC00002C8)
//#define STATUS_REG_NAT_CONSUMPTION					STATUS_CAST(NTSTATUS,0xC00002C9)
#define STATUS_TRANSPORT_FULL STATUS_CAST(NTSTATUS, 0xC00002CA)
#define STATUS_DS_SAM_INIT_FAILURE STATUS_CAST(NTSTATUS, 0xC00002CB)
#define STATUS_ONLY_IF_CONNECTED STATUS_CAST(NTSTATUS, 0xC00002CC)
#define STATUS_DS_SENSITIVE_GROUP_VIOLATION STATUS_CAST(NTSTATUS, 0xC00002CD)
#define STATUS_PNP_RESTART_ENUMERATION STATUS_CAST(NTSTATUS, 0xC00002CE)
#define STATUS_JOURNAL_ENTRY_DELETED STATUS_CAST(NTSTATUS, 0xC00002CF)
#define STATUS_DS_CANT_MOD_PRIMARYGROUPID STATUS_CAST(NTSTATUS, 0xC00002D0)
#define STATUS_SYSTEM_IMAGE_BAD_SIGNATURE STATUS_CAST(NTSTATUS, 0xC00002D1)
#define STATUS_PNP_REBOOT_REQUIRED STATUS_CAST(NTSTATUS, 0xC00002D2)
#define STATUS_POWER_STATE_INVALID STATUS_CAST(NTSTATUS, 0xC00002D3)
#define STATUS_DS_INVALID_GROUP_TYPE STATUS_CAST(NTSTATUS, 0xC00002D4)
#define STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN STATUS_CAST(NTSTATUS, 0xC00002D5)
#define STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN STATUS_CAST(NTSTATUS, 0xC00002D6)
#define STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER STATUS_CAST(NTSTATUS, 0xC00002D7)
#define STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER STATUS_CAST(NTSTATUS, 0xC00002D8)
#define STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER STATUS_CAST(NTSTATUS, 0xC00002D9)
#define STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER STATUS_CAST(NTSTATUS, 0xC00002DA)
#define STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER STATUS_CAST(NTSTATUS, 0xC00002DB)
#define STATUS_DS_HAVE_PRIMARY_MEMBERS STATUS_CAST(NTSTATUS, 0xC00002DC)
#define STATUS_WMI_NOT_SUPPORTED STATUS_CAST(NTSTATUS, 0xC00002DD)
#define STATUS_INSUFFICIENT_POWER STATUS_CAST(NTSTATUS, 0xC00002DE)
#define STATUS_SAM_NEED_BOOTKEY_PASSWORD STATUS_CAST(NTSTATUS, 0xC00002DF)
#define STATUS_SAM_NEED_BOOTKEY_FLOPPY STATUS_CAST(NTSTATUS, 0xC00002E0)
#define STATUS_DS_CANT_START STATUS_CAST(NTSTATUS, 0xC00002E1)
#define STATUS_DS_INIT_FAILURE STATUS_CAST(NTSTATUS, 0xC00002E2)
#define STATUS_SAM_INIT_FAILURE STATUS_CAST(NTSTATUS, 0xC00002E3)
#define STATUS_DS_GC_REQUIRED STATUS_CAST(NTSTATUS, 0xC00002E4)
#define STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY STATUS_CAST(NTSTATUS, 0xC00002E5)
#define STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS STATUS_CAST(NTSTATUS, 0xC00002E6)
#define STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED STATUS_CAST(NTSTATUS, 0xC00002E7)
#define STATUS_MULTIPLE_FAULT_VIOLATION STATUS_CAST(NTSTATUS, 0xC00002E8)
#define STATUS_CURRENT_DOMAIN_NOT_ALLOWED STATUS_CAST(NTSTATUS, 0xC00002E9)
#define STATUS_CANNOT_MAKE STATUS_CAST(NTSTATUS, 0xC00002EA)
#define STATUS_SYSTEM_SHUTDOWN STATUS_CAST(NTSTATUS, 0xC00002EB)
#define STATUS_DS_INIT_FAILURE_CONSOLE STATUS_CAST(NTSTATUS, 0xC00002EC)
#define STATUS_DS_SAM_INIT_FAILURE_CONSOLE STATUS_CAST(NTSTATUS, 0xC00002ED)
#define STATUS_UNFINISHED_CONTEXT_DELETED STATUS_CAST(NTSTATUS, 0xC00002EE)
#define STATUS_NO_TGT_REPLY STATUS_CAST(NTSTATUS, 0xC00002EF)
#define STATUS_OBJECTID_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC00002F0)
#define STATUS_NO_IP_ADDRESSES STATUS_CAST(NTSTATUS, 0xC00002F1)
#define STATUS_WRONG_CREDENTIAL_HANDLE STATUS_CAST(NTSTATUS, 0xC00002F2)
#define STATUS_CRYPTO_SYSTEM_INVALID STATUS_CAST(NTSTATUS, 0xC00002F3)
#define STATUS_MAX_REFERRALS_EXCEEDED STATUS_CAST(NTSTATUS, 0xC00002F4)
#define STATUS_MUST_BE_KDC STATUS_CAST(NTSTATUS, 0xC00002F5)
#define STATUS_STRONG_CRYPTO_NOT_SUPPORTED STATUS_CAST(NTSTATUS, 0xC00002F6)
#define STATUS_TOO_MANY_PRINCIPALS STATUS_CAST(NTSTATUS, 0xC00002F7)
#define STATUS_NO_PA_DATA STATUS_CAST(NTSTATUS, 0xC00002F8)
#define STATUS_PKINIT_NAME_MISMATCH STATUS_CAST(NTSTATUS, 0xC00002F9)
#define STATUS_SMARTCARD_LOGON_REQUIRED STATUS_CAST(NTSTATUS, 0xC00002FA)
#define STATUS_KDC_INVALID_REQUEST STATUS_CAST(NTSTATUS, 0xC00002FB)
#define STATUS_KDC_UNABLE_TO_REFER STATUS_CAST(NTSTATUS, 0xC00002FC)
#define STATUS_KDC_UNKNOWN_ETYPE STATUS_CAST(NTSTATUS, 0xC00002FD)
#define STATUS_SHUTDOWN_IN_PROGRESS STATUS_CAST(NTSTATUS, 0xC00002FE)
#define STATUS_SERVER_SHUTDOWN_IN_PROGRESS STATUS_CAST(NTSTATUS, 0xC00002FF)
#define STATUS_NOT_SUPPORTED_ON_SBS STATUS_CAST(NTSTATUS, 0xC0000300)
#define STATUS_WMI_GUID_DISCONNECTED STATUS_CAST(NTSTATUS, 0xC0000301)
#define STATUS_WMI_ALREADY_DISABLED STATUS_CAST(NTSTATUS, 0xC0000302)
#define STATUS_WMI_ALREADY_ENABLED STATUS_CAST(NTSTATUS, 0xC0000303)
#define STATUS_MFT_TOO_FRAGMENTED STATUS_CAST(NTSTATUS, 0xC0000304)
#define STATUS_COPY_PROTECTION_FAILURE STATUS_CAST(NTSTATUS, 0xC0000305)
#define STATUS_CSS_AUTHENTICATION_FAILURE STATUS_CAST(NTSTATUS, 0xC0000306)
#define STATUS_CSS_KEY_NOT_PRESENT STATUS_CAST(NTSTATUS, 0xC0000307)
#define STATUS_CSS_KEY_NOT_ESTABLISHED STATUS_CAST(NTSTATUS, 0xC0000308)
#define STATUS_CSS_SCRAMBLED_SECTOR STATUS_CAST(NTSTATUS, 0xC0000309)
#define STATUS_CSS_REGION_MISMATCH STATUS_CAST(NTSTATUS, 0xC000030A)
#define STATUS_CSS_RESETS_EXHAUSTED STATUS_CAST(NTSTATUS, 0xC000030B)
#define STATUS_PKINIT_FAILURE STATUS_CAST(NTSTATUS, 0xC0000320)
#define STATUS_SMARTCARD_SUBSYSTEM_FAILURE STATUS_CAST(NTSTATUS, 0xC0000321)
#define STATUS_NO_KERB_KEY STATUS_CAST(NTSTATUS, 0xC0000322)
#define STATUS_HOST_DOWN STATUS_CAST(NTSTATUS, 0xC0000350)
#define STATUS_UNSUPPORTED_PREAUTH STATUS_CAST(NTSTATUS, 0xC0000351)
#define STATUS_EFS_ALG_BLOB_TOO_BIG STATUS_CAST(NTSTATUS, 0xC0000352)
#define STATUS_PORT_NOT_SET STATUS_CAST(NTSTATUS, 0xC0000353)
#define STATUS_DEBUGGER_INACTIVE STATUS_CAST(NTSTATUS, 0xC0000354)
#define STATUS_DS_VERSION_CHECK_FAILURE STATUS_CAST(NTSTATUS, 0xC0000355)
#define STATUS_AUDITING_DISABLED STATUS_CAST(NTSTATUS, 0xC0000356)
#define STATUS_PRENT4_MACHINE_ACCOUNT STATUS_CAST(NTSTATUS, 0xC0000357)
#define STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER STATUS_CAST(NTSTATUS, 0xC0000358)
#define STATUS_INVALID_IMAGE_WIN_32 STATUS_CAST(NTSTATUS, 0xC0000359)
#define STATUS_INVALID_IMAGE_WIN_64 STATUS_CAST(NTSTATUS, 0xC000035A)
#define STATUS_BAD_BINDINGS STATUS_CAST(NTSTATUS, 0xC000035B)
#define STATUS_NETWORK_SESSION_EXPIRED STATUS_CAST(NTSTATUS, 0xC000035C)
#define STATUS_APPHELP_BLOCK STATUS_CAST(NTSTATUS, 0xC000035D)
#define STATUS_ALL_SIDS_FILTERED STATUS_CAST(NTSTATUS, 0xC000035E)
#define STATUS_NOT_SAFE_MODE_DRIVER STATUS_CAST(NTSTATUS, 0xC000035F)
#define STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT STATUS_CAST(NTSTATUS, 0xC0000361)
#define STATUS_ACCESS_DISABLED_BY_POLICY_PATH STATUS_CAST(NTSTATUS, 0xC0000362)
#define STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER STATUS_CAST(NTSTATUS, 0xC0000363)
#define STATUS_ACCESS_DISABLED_BY_POLICY_OTHER STATUS_CAST(NTSTATUS, 0xC0000364)
#define STATUS_FAILED_DRIVER_ENTRY STATUS_CAST(NTSTATUS, 0xC0000365)
#define STATUS_DEVICE_ENUMERATION_ERROR STATUS_CAST(NTSTATUS, 0xC0000366)
#define STATUS_WAIT_FOR_OPLOCK STATUS_CAST(NTSTATUS, 0x00000367)
#define STATUS_MOUNT_POINT_NOT_RESOLVED STATUS_CAST(NTSTATUS, 0xC0000368)
#define STATUS_INVALID_DEVICE_OBJECT_PARAMETER STATUS_CAST(NTSTATUS, 0xC0000369)
/* The following is not a typo. It's the same spelling as in the Microsoft headers */
#define STATUS_MCA_OCCURED STATUS_CAST(NTSTATUS, 0xC000036A)
#define STATUS_DRIVER_BLOCKED_CRITICAL STATUS_CAST(NTSTATUS, 0xC000036B)
#define STATUS_DRIVER_BLOCKED STATUS_CAST(NTSTATUS, 0xC000036C)
#define STATUS_DRIVER_DATABASE_ERROR STATUS_CAST(NTSTATUS, 0xC000036D)
#define STATUS_SYSTEM_HIVE_TOO_LARGE STATUS_CAST(NTSTATUS, 0xC000036E)
#define STATUS_INVALID_IMPORT_OF_NON_DLL STATUS_CAST(NTSTATUS, 0xC000036F)
#define STATUS_SMARTCARD_WRONG_PIN STATUS_CAST(NTSTATUS, 0xC0000380)
#define STATUS_SMARTCARD_CARD_BLOCKED STATUS_CAST(NTSTATUS, 0xC0000381)
#define STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED STATUS_CAST(NTSTATUS, 0xC0000382)
#define STATUS_SMARTCARD_NO_CARD STATUS_CAST(NTSTATUS, 0xC0000383)
#define STATUS_SMARTCARD_NO_KEY_CONTAINER STATUS_CAST(NTSTATUS, 0xC0000384)
#define STATUS_SMARTCARD_NO_CERTIFICATE STATUS_CAST(NTSTATUS, 0xC0000385)
#define STATUS_SMARTCARD_NO_KEYSET STATUS_CAST(NTSTATUS, 0xC0000386)
#define STATUS_SMARTCARD_IO_ERROR STATUS_CAST(NTSTATUS, 0xC0000387)
//#define STATUS_DOWNGRADE_DETECTED					STATUS_CAST(NTSTATUS,0xC0000388)
#define STATUS_SMARTCARD_CERT_REVOKED STATUS_CAST(NTSTATUS, 0xC0000389)
#define STATUS_ISSUING_CA_UNTRUSTED STATUS_CAST(NTSTATUS, 0xC000038A)
#define STATUS_REVOCATION_OFFLINE_C STATUS_CAST(NTSTATUS, 0xC000038B)
#define STATUS_PKINIT_CLIENT_FAILURE STATUS_CAST(NTSTATUS, 0xC000038C)
#define STATUS_SMARTCARD_CERT_EXPIRED STATUS_CAST(NTSTATUS, 0xC000038D)
#define STATUS_DRIVER_FAILED_PRIOR_UNLOAD STATUS_CAST(NTSTATUS, 0xC000038E)
#define STATUS_SMARTCARD_SILENT_CONTEXT STATUS_CAST(NTSTATUS, 0xC000038F)
#define STATUS_PER_USER_TRUST_QUOTA_EXCEEDED STATUS_CAST(NTSTATUS, 0xC0000401)
#define STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED STATUS_CAST(NTSTATUS, 0xC0000402)
#define STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED STATUS_CAST(NTSTATUS, 0xC0000403)
#define STATUS_DS_NAME_NOT_UNIQUE STATUS_CAST(NTSTATUS, 0xC0000404)
#define STATUS_DS_DUPLICATE_ID_FOUND STATUS_CAST(NTSTATUS, 0xC0000405)
#define STATUS_DS_GROUP_CONVERSION_ERROR STATUS_CAST(NTSTATUS, 0xC0000406)
#define STATUS_VOLSNAP_PREPARE_HIBERNATE STATUS_CAST(NTSTATUS, 0xC0000407)
#define STATUS_USER2USER_REQUIRED STATUS_CAST(NTSTATUS, 0xC0000408)
//#define STATUS_STACK_BUFFER_OVERRUN					STATUS_CAST(NTSTATUS,0xC0000409)
#define STATUS_NO_S4U_PROT_SUPPORT STATUS_CAST(NTSTATUS, 0xC000040A)
#define STATUS_CROSSREALM_DELEGATION_FAILURE STATUS_CAST(NTSTATUS, 0xC000040B)
#define STATUS_REVOCATION_OFFLINE_KDC STATUS_CAST(NTSTATUS, 0xC000040C)
#define STATUS_ISSUING_CA_UNTRUSTED_KDC STATUS_CAST(NTSTATUS, 0xC000040D)
#define STATUS_KDC_CERT_EXPIRED STATUS_CAST(NTSTATUS, 0xC000040E)
#define STATUS_KDC_CERT_REVOKED STATUS_CAST(NTSTATUS, 0xC000040F)
#define STATUS_PARAMETER_QUOTA_EXCEEDED STATUS_CAST(NTSTATUS, 0xC0000410)
#define STATUS_HIBERNATION_FAILURE STATUS_CAST(NTSTATUS, 0xC0000411)
#define STATUS_DELAY_LOAD_FAILED STATUS_CAST(NTSTATUS, 0xC0000412)
//#define STATUS_AUTHENTICATION_FIREWALL_FAILED				STATUS_CAST(NTSTATUS,0xC0000413)
#define STATUS_VDM_DISALLOWED STATUS_CAST(NTSTATUS, 0xC0000414)
#define STATUS_HUNG_DISPLAY_DRIVER_THREAD STATUS_CAST(NTSTATUS, 0xC0000415)
//#define STATUS_INVALID_CRUNTIME_PARAMETER				STATUS_CAST(NTSTATUS,0xC0000417)
//#define STATUS_ASSERTION_FAILURE					STATUS_CAST(NTSTATUS,0xC0000420L)
#define STATUS_CALLBACK_POP_STACK STATUS_CAST(NTSTATUS, 0xC0000423)
#define STATUS_WOW_ASSERTION STATUS_CAST(NTSTATUS, 0xC0009898)

#define RPC_NT_INVALID_STRING_BINDING STATUS_CAST(NTSTATUS, 0xC0020001)
#define RPC_NT_WRONG_KIND_OF_BINDING STATUS_CAST(NTSTATUS, 0xC0020002)
#define RPC_NT_INVALID_BINDING STATUS_CAST(NTSTATUS, 0xC0020003)
#define RPC_NT_PROTSEQ_NOT_SUPPORTED STATUS_CAST(NTSTATUS, 0xC0020004)
#define RPC_NT_INVALID_RPC_PROTSEQ STATUS_CAST(NTSTATUS, 0xC0020005)
#define RPC_NT_INVALID_STRING_UUID STATUS_CAST(NTSTATUS, 0xC0020006)
#define RPC_NT_INVALID_ENDPOINT_FORMAT STATUS_CAST(NTSTATUS, 0xC0020007)
#define RPC_NT_INVALID_NET_ADDR STATUS_CAST(NTSTATUS, 0xC0020008)
#define RPC_NT_NO_ENDPOINT_FOUND STATUS_CAST(NTSTATUS, 0xC0020009)
#define RPC_NT_INVALID_TIMEOUT STATUS_CAST(NTSTATUS, 0xC002000A)
#define RPC_NT_OBJECT_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC002000B)
#define RPC_NT_ALREADY_REGISTERED STATUS_CAST(NTSTATUS, 0xC002000C)
#define RPC_NT_TYPE_ALREADY_REGISTERED STATUS_CAST(NTSTATUS, 0xC002000D)
#define RPC_NT_ALREADY_LISTENING STATUS_CAST(NTSTATUS, 0xC002000E)
#define RPC_NT_NO_PROTSEQS_REGISTERED STATUS_CAST(NTSTATUS, 0xC002000F)
#define RPC_NT_NOT_LISTENING STATUS_CAST(NTSTATUS, 0xC0020010)
#define RPC_NT_UNKNOWN_MGR_TYPE STATUS_CAST(NTSTATUS, 0xC0020011)
#define RPC_NT_UNKNOWN_IF STATUS_CAST(NTSTATUS, 0xC0020012)
#define RPC_NT_NO_BINDINGS STATUS_CAST(NTSTATUS, 0xC0020013)
#define RPC_NT_NO_PROTSEQS STATUS_CAST(NTSTATUS, 0xC0020014)
#define RPC_NT_CANT_CREATE_ENDPOINT STATUS_CAST(NTSTATUS, 0xC0020015)
#define RPC_NT_OUT_OF_RESOURCES STATUS_CAST(NTSTATUS, 0xC0020016)
#define RPC_NT_SERVER_UNAVAILABLE STATUS_CAST(NTSTATUS, 0xC0020017)
#define RPC_NT_SERVER_TOO_BUSY STATUS_CAST(NTSTATUS, 0xC0020018)
#define RPC_NT_INVALID_NETWORK_OPTIONS STATUS_CAST(NTSTATUS, 0xC0020019)
#define RPC_NT_NO_CALL_ACTIVE STATUS_CAST(NTSTATUS, 0xC002001A)
#define RPC_NT_CALL_FAILED STATUS_CAST(NTSTATUS, 0xC002001B)
#define RPC_NT_CALL_FAILED_DNE STATUS_CAST(NTSTATUS, 0xC002001C)
#define RPC_NT_PROTOCOL_ERROR STATUS_CAST(NTSTATUS, 0xC002001D)
#define RPC_NT_UNSUPPORTED_TRANS_SYN STATUS_CAST(NTSTATUS, 0xC002001F)
#define RPC_NT_UNSUPPORTED_TYPE STATUS_CAST(NTSTATUS, 0xC0020021)
#define RPC_NT_INVALID_TAG STATUS_CAST(NTSTATUS, 0xC0020022)
#define RPC_NT_INVALID_BOUND STATUS_CAST(NTSTATUS, 0xC0020023)
#define RPC_NT_NO_ENTRY_NAME STATUS_CAST(NTSTATUS, 0xC0020024)
#define RPC_NT_INVALID_NAME_SYNTAX STATUS_CAST(NTSTATUS, 0xC0020025)
#define RPC_NT_UNSUPPORTED_NAME_SYNTAX STATUS_CAST(NTSTATUS, 0xC0020026)
#define RPC_NT_UUID_NO_ADDRESS STATUS_CAST(NTSTATUS, 0xC0020028)
#define RPC_NT_DUPLICATE_ENDPOINT STATUS_CAST(NTSTATUS, 0xC0020029)
#define RPC_NT_UNKNOWN_AUTHN_TYPE STATUS_CAST(NTSTATUS, 0xC002002A)
#define RPC_NT_MAX_CALLS_TOO_SMALL STATUS_CAST(NTSTATUS, 0xC002002B)
#define RPC_NT_STRING_TOO_LONG STATUS_CAST(NTSTATUS, 0xC002002C)
#define RPC_NT_PROTSEQ_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC002002D)
#define RPC_NT_PROCNUM_OUT_OF_RANGE STATUS_CAST(NTSTATUS, 0xC002002E)
#define RPC_NT_BINDING_HAS_NO_AUTH STATUS_CAST(NTSTATUS, 0xC002002F)
#define RPC_NT_UNKNOWN_AUTHN_SERVICE STATUS_CAST(NTSTATUS, 0xC0020030)
#define RPC_NT_UNKNOWN_AUTHN_LEVEL STATUS_CAST(NTSTATUS, 0xC0020031)
#define RPC_NT_INVALID_AUTH_IDENTITY STATUS_CAST(NTSTATUS, 0xC0020032)
#define RPC_NT_UNKNOWN_AUTHZ_SERVICE STATUS_CAST(NTSTATUS, 0xC0020033)
#define EPT_NT_INVALID_ENTRY STATUS_CAST(NTSTATUS, 0xC0020034)
#define EPT_NT_CANT_PERFORM_OP STATUS_CAST(NTSTATUS, 0xC0020035)
#define EPT_NT_NOT_REGISTERED STATUS_CAST(NTSTATUS, 0xC0020036)
#define RPC_NT_NOTHING_TO_EXPORT STATUS_CAST(NTSTATUS, 0xC0020037)
#define RPC_NT_INCOMPLETE_NAME STATUS_CAST(NTSTATUS, 0xC0020038)
#define RPC_NT_INVALID_VERS_OPTION STATUS_CAST(NTSTATUS, 0xC0020039)
#define RPC_NT_NO_MORE_MEMBERS STATUS_CAST(NTSTATUS, 0xC002003A)
#define RPC_NT_NOT_ALL_OBJS_UNEXPORTED STATUS_CAST(NTSTATUS, 0xC002003B)
#define RPC_NT_INTERFACE_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC002003C)
#define RPC_NT_ENTRY_ALREADY_EXISTS STATUS_CAST(NTSTATUS, 0xC002003D)
#define RPC_NT_ENTRY_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC002003E)
#define RPC_NT_NAME_SERVICE_UNAVAILABLE STATUS_CAST(NTSTATUS, 0xC002003F)
#define RPC_NT_INVALID_NAF_ID STATUS_CAST(NTSTATUS, 0xC0020040)
#define RPC_NT_CANNOT_SUPPORT STATUS_CAST(NTSTATUS, 0xC0020041)
#define RPC_NT_NO_CONTEXT_AVAILABLE STATUS_CAST(NTSTATUS, 0xC0020042)
#define RPC_NT_INTERNAL_ERROR STATUS_CAST(NTSTATUS, 0xC0020043)
#define RPC_NT_ZERO_DIVIDE STATUS_CAST(NTSTATUS, 0xC0020044)
#define RPC_NT_ADDRESS_ERROR STATUS_CAST(NTSTATUS, 0xC0020045)
#define RPC_NT_FP_DIV_ZERO STATUS_CAST(NTSTATUS, 0xC0020046)
#define RPC_NT_FP_UNDERFLOW STATUS_CAST(NTSTATUS, 0xC0020047)
#define RPC_NT_FP_OVERFLOW STATUS_CAST(NTSTATUS, 0xC0020048)
#define RPC_NT_CALL_IN_PROGRESS STATUS_CAST(NTSTATUS, 0xC0020049)
#define RPC_NT_NO_MORE_BINDINGS STATUS_CAST(NTSTATUS, 0xC002004A)
#define RPC_NT_GROUP_MEMBER_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC002004B)
#define EPT_NT_CANT_CREATE STATUS_CAST(NTSTATUS, 0xC002004C)
#define RPC_NT_INVALID_OBJECT STATUS_CAST(NTSTATUS, 0xC002004D)
#define RPC_NT_NO_INTERFACES STATUS_CAST(NTSTATUS, 0xC002004F)
#define RPC_NT_CALL_CANCELLED STATUS_CAST(NTSTATUS, 0xC0020050)
#define RPC_NT_BINDING_INCOMPLETE STATUS_CAST(NTSTATUS, 0xC0020051)
#define RPC_NT_COMM_FAILURE STATUS_CAST(NTSTATUS, 0xC0020052)
#define RPC_NT_UNSUPPORTED_AUTHN_LEVEL STATUS_CAST(NTSTATUS, 0xC0020053)
#define RPC_NT_NO_PRINC_NAME STATUS_CAST(NTSTATUS, 0xC0020054)
#define RPC_NT_NOT_RPC_ERROR STATUS_CAST(NTSTATUS, 0xC0020055)
#define RPC_NT_SEC_PKG_ERROR STATUS_CAST(NTSTATUS, 0xC0020057)
#define RPC_NT_NOT_CANCELLED STATUS_CAST(NTSTATUS, 0xC0020058)
#define RPC_NT_INVALID_ASYNC_HANDLE STATUS_CAST(NTSTATUS, 0xC0020062)
#define RPC_NT_INVALID_ASYNC_CALL STATUS_CAST(NTSTATUS, 0xC0020063)

#define RPC_NT_NO_MORE_ENTRIES STATUS_CAST(NTSTATUS, 0xC0030001)
#define RPC_NT_SS_CHAR_TRANS_OPEN_FAIL STATUS_CAST(NTSTATUS, 0xC0030002)
#define RPC_NT_SS_CHAR_TRANS_SHORT_FILE STATUS_CAST(NTSTATUS, 0xC0030003)
#define RPC_NT_SS_IN_NULL_CONTEXT STATUS_CAST(NTSTATUS, 0xC0030004)
#define RPC_NT_SS_CONTEXT_MISMATCH STATUS_CAST(NTSTATUS, 0xC0030005)
#define RPC_NT_SS_CONTEXT_DAMAGED STATUS_CAST(NTSTATUS, 0xC0030006)
#define RPC_NT_SS_HANDLES_MISMATCH STATUS_CAST(NTSTATUS, 0xC0030007)
#define RPC_NT_SS_CANNOT_GET_CALL_HANDLE STATUS_CAST(NTSTATUS, 0xC0030008)
#define RPC_NT_NULL_REF_POINTER STATUS_CAST(NTSTATUS, 0xC0030009)
#define RPC_NT_ENUM_VALUE_OUT_OF_RANGE STATUS_CAST(NTSTATUS, 0xC003000A)
#define RPC_NT_BYTE_COUNT_TOO_SMALL STATUS_CAST(NTSTATUS, 0xC003000B)
#define RPC_NT_BAD_STUB_DATA STATUS_CAST(NTSTATUS, 0xC003000C)
#define RPC_NT_INVALID_ES_ACTION STATUS_CAST(NTSTATUS, 0xC0030059)
#define RPC_NT_WRONG_ES_VERSION STATUS_CAST(NTSTATUS, 0xC003005A)
#define RPC_NT_WRONG_STUB_VERSION STATUS_CAST(NTSTATUS, 0xC003005B)
#define RPC_NT_INVALID_PIPE_OBJECT STATUS_CAST(NTSTATUS, 0xC003005C)
#define RPC_NT_INVALID_PIPE_OPERATION STATUS_CAST(NTSTATUS, 0xC003005D)
#define RPC_NT_WRONG_PIPE_VERSION STATUS_CAST(NTSTATUS, 0xC003005E)
#define RPC_NT_PIPE_CLOSED STATUS_CAST(NTSTATUS, 0xC003005F)
#define RPC_NT_PIPE_DISCIPLINE_ERROR STATUS_CAST(NTSTATUS, 0xC0030060)
#define RPC_NT_PIPE_EMPTY STATUS_CAST(NTSTATUS, 0xC0030061)

#define STATUS_PNP_BAD_MPS_TABLE STATUS_CAST(NTSTATUS, 0xC0040035)
#define STATUS_PNP_TRANSLATION_FAILED STATUS_CAST(NTSTATUS, 0xC0040036)
#define STATUS_PNP_IRQ_TRANSLATION_FAILED STATUS_CAST(NTSTATUS, 0xC0040037)
#define STATUS_PNP_INVALID_ID STATUS_CAST(NTSTATUS, 0xC0040038)

#define STATUS_ACPI_INVALID_OPCODE STATUS_CAST(NTSTATUS, 0xC0140001L)
#define STATUS_ACPI_STACK_OVERFLOW STATUS_CAST(NTSTATUS, 0xC0140002L)
#define STATUS_ACPI_ASSERT_FAILED STATUS_CAST(NTSTATUS, 0xC0140003L)
#define STATUS_ACPI_INVALID_INDEX STATUS_CAST(NTSTATUS, 0xC0140004L)
#define STATUS_ACPI_INVALID_ARGUMENT STATUS_CAST(NTSTATUS, 0xC0140005L)
#define STATUS_ACPI_FATAL STATUS_CAST(NTSTATUS, 0xC0140006L)
#define STATUS_ACPI_INVALID_SUPERNAME STATUS_CAST(NTSTATUS, 0xC0140007L)
#define STATUS_ACPI_INVALID_ARGTYPE STATUS_CAST(NTSTATUS, 0xC0140008L)
#define STATUS_ACPI_INVALID_OBJTYPE STATUS_CAST(NTSTATUS, 0xC0140009L)
#define STATUS_ACPI_INVALID_TARGETTYPE STATUS_CAST(NTSTATUS, 0xC014000AL)
#define STATUS_ACPI_INCORRECT_ARGUMENT_COUNT STATUS_CAST(NTSTATUS, 0xC014000BL)
#define STATUS_ACPI_ADDRESS_NOT_MAPPED STATUS_CAST(NTSTATUS, 0xC014000CL)
#define STATUS_ACPI_INVALID_EVENTTYPE STATUS_CAST(NTSTATUS, 0xC014000DL)
#define STATUS_ACPI_HANDLER_COLLISION STATUS_CAST(NTSTATUS, 0xC014000EL)
#define STATUS_ACPI_INVALID_DATA STATUS_CAST(NTSTATUS, 0xC014000FL)
#define STATUS_ACPI_INVALID_REGION STATUS_CAST(NTSTATUS, 0xC0140010L)
#define STATUS_ACPI_INVALID_ACCESS_SIZE STATUS_CAST(NTSTATUS, 0xC0140011L)
#define STATUS_ACPI_ACQUIRE_GLOBAL_LOCK STATUS_CAST(NTSTATUS, 0xC0140012L)
#define STATUS_ACPI_ALREADY_INITIALIZED STATUS_CAST(NTSTATUS, 0xC0140013L)
#define STATUS_ACPI_NOT_INITIALIZED STATUS_CAST(NTSTATUS, 0xC0140014L)
#define STATUS_ACPI_INVALID_MUTEX_LEVEL STATUS_CAST(NTSTATUS, 0xC0140015L)
#define STATUS_ACPI_MUTEX_NOT_OWNED STATUS_CAST(NTSTATUS, 0xC0140016L)
#define STATUS_ACPI_MUTEX_NOT_OWNER STATUS_CAST(NTSTATUS, 0xC0140017L)
#define STATUS_ACPI_RS_ACCESS STATUS_CAST(NTSTATUS, 0xC0140018L)
#define STATUS_ACPI_INVALID_TABLE STATUS_CAST(NTSTATUS, 0xC0140019L)
#define STATUS_ACPI_REG_HANDLER_FAILED STATUS_CAST(NTSTATUS, 0xC0140020L)
#define STATUS_ACPI_POWER_REQUEST_FAILED STATUS_CAST(NTSTATUS, 0xC0140021L)

#define STATUS_CTX_WINSTATION_NAME_INVALID STATUS_CAST(NTSTATUS, 0xC00A0001)
#define STATUS_CTX_INVALID_PD STATUS_CAST(NTSTATUS, 0xC00A0002)
#define STATUS_CTX_PD_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC00A0003)
#define STATUS_CTX_CLOSE_PENDING STATUS_CAST(NTSTATUS, 0xC00A0006)
#define STATUS_CTX_NO_OUTBUF STATUS_CAST(NTSTATUS, 0xC00A0007)
#define STATUS_CTX_MODEM_INF_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC00A0008)
#define STATUS_CTX_INVALID_MODEMNAME STATUS_CAST(NTSTATUS, 0xC00A0009)
#define STATUS_CTX_RESPONSE_ERROR STATUS_CAST(NTSTATUS, 0xC00A000A)
#define STATUS_CTX_MODEM_RESPONSE_TIMEOUT STATUS_CAST(NTSTATUS, 0xC00A000B)
#define STATUS_CTX_MODEM_RESPONSE_NO_CARRIER STATUS_CAST(NTSTATUS, 0xC00A000C)
#define STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE STATUS_CAST(NTSTATUS, 0xC00A000D)
#define STATUS_CTX_MODEM_RESPONSE_BUSY STATUS_CAST(NTSTATUS, 0xC00A000E)
#define STATUS_CTX_MODEM_RESPONSE_VOICE STATUS_CAST(NTSTATUS, 0xC00A000F)
#define STATUS_CTX_TD_ERROR STATUS_CAST(NTSTATUS, 0xC00A0010)
#define STATUS_CTX_LICENSE_CLIENT_INVALID STATUS_CAST(NTSTATUS, 0xC00A0012)
#define STATUS_CTX_LICENSE_NOT_AVAILABLE STATUS_CAST(NTSTATUS, 0xC00A0013)
#define STATUS_CTX_LICENSE_EXPIRED STATUS_CAST(NTSTATUS, 0xC00A0014)
#define STATUS_CTX_WINSTATION_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC00A0015)
#define STATUS_CTX_WINSTATION_NAME_COLLISION STATUS_CAST(NTSTATUS, 0xC00A0016)
#define STATUS_CTX_WINSTATION_BUSY STATUS_CAST(NTSTATUS, 0xC00A0017)
#define STATUS_CTX_BAD_VIDEO_MODE STATUS_CAST(NTSTATUS, 0xC00A0018)
#define STATUS_CTX_GRAPHICS_INVALID STATUS_CAST(NTSTATUS, 0xC00A0022)
#define STATUS_CTX_NOT_CONSOLE STATUS_CAST(NTSTATUS, 0xC00A0024)
#define STATUS_CTX_CLIENT_QUERY_TIMEOUT STATUS_CAST(NTSTATUS, 0xC00A0026)
#define STATUS_CTX_CONSOLE_DISCONNECT STATUS_CAST(NTSTATUS, 0xC00A0027)
#define STATUS_CTX_CONSOLE_CONNECT STATUS_CAST(NTSTATUS, 0xC00A0028)
#define STATUS_CTX_SHADOW_DENIED STATUS_CAST(NTSTATUS, 0xC00A002A)
#define STATUS_CTX_WINSTATION_ACCESS_DENIED STATUS_CAST(NTSTATUS, 0xC00A002B)
#define STATUS_CTX_INVALID_WD STATUS_CAST(NTSTATUS, 0xC00A002E)
#define STATUS_CTX_WD_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC00A002F)
#define STATUS_CTX_SHADOW_INVALID STATUS_CAST(NTSTATUS, 0xC00A0030)
#define STATUS_CTX_SHADOW_DISABLED STATUS_CAST(NTSTATUS, 0xC00A0031)
#define STATUS_RDP_PROTOCOL_ERROR STATUS_CAST(NTSTATUS, 0xC00A0032)
#define STATUS_CTX_CLIENT_LICENSE_NOT_SET STATUS_CAST(NTSTATUS, 0xC00A0033)
#define STATUS_CTX_CLIENT_LICENSE_IN_USE STATUS_CAST(NTSTATUS, 0xC00A0034)
#define STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE STATUS_CAST(NTSTATUS, 0xC00A0035)
#define STATUS_CTX_SHADOW_NOT_RUNNING STATUS_CAST(NTSTATUS, 0xC00A0036)

#define STATUS_CLUSTER_INVALID_NODE STATUS_CAST(NTSTATUS, 0xC0130001)
#define STATUS_CLUSTER_NODE_EXISTS STATUS_CAST(NTSTATUS, 0xC0130002)
#define STATUS_CLUSTER_JOIN_IN_PROGRESS STATUS_CAST(NTSTATUS, 0xC0130003)
#define STATUS_CLUSTER_NODE_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0130004)
#define STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0130005)
#define STATUS_CLUSTER_NETWORK_EXISTS STATUS_CAST(NTSTATUS, 0xC0130006)
#define STATUS_CLUSTER_NETWORK_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0130007)
#define STATUS_CLUSTER_NETINTERFACE_EXISTS STATUS_CAST(NTSTATUS, 0xC0130008)
#define STATUS_CLUSTER_NETINTERFACE_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0130009)
#define STATUS_CLUSTER_INVALID_REQUEST STATUS_CAST(NTSTATUS, 0xC013000A)
#define STATUS_CLUSTER_INVALID_NETWORK_PROVIDER STATUS_CAST(NTSTATUS, 0xC013000B)
#define STATUS_CLUSTER_NODE_DOWN STATUS_CAST(NTSTATUS, 0xC013000C)
#define STATUS_CLUSTER_NODE_UNREACHABLE STATUS_CAST(NTSTATUS, 0xC013000D)
#define STATUS_CLUSTER_NODE_NOT_MEMBER STATUS_CAST(NTSTATUS, 0xC013000E)
#define STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS STATUS_CAST(NTSTATUS, 0xC013000F)
#define STATUS_CLUSTER_INVALID_NETWORK STATUS_CAST(NTSTATUS, 0xC0130010)
#define STATUS_CLUSTER_NO_NET_ADAPTERS STATUS_CAST(NTSTATUS, 0xC0130011)
#define STATUS_CLUSTER_NODE_UP STATUS_CAST(NTSTATUS, 0xC0130012)
#define STATUS_CLUSTER_NODE_PAUSED STATUS_CAST(NTSTATUS, 0xC0130013)
#define STATUS_CLUSTER_NODE_NOT_PAUSED STATUS_CAST(NTSTATUS, 0xC0130014)
#define STATUS_CLUSTER_NO_SECURITY_CONTEXT STATUS_CAST(NTSTATUS, 0xC0130015)
#define STATUS_CLUSTER_NETWORK_NOT_INTERNAL STATUS_CAST(NTSTATUS, 0xC0130016)
#define STATUS_CLUSTER_POISONED STATUS_CAST(NTSTATUS, 0xC0130017)

#define STATUS_SXS_SECTION_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0150001)
#define STATUS_SXS_CANT_GEN_ACTCTX STATUS_CAST(NTSTATUS, 0xC0150002)
#define STATUS_SXS_INVALID_ACTCTXDATA_FORMAT STATUS_CAST(NTSTATUS, 0xC0150003)
#define STATUS_SXS_ASSEMBLY_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0150004)
#define STATUS_SXS_MANIFEST_FORMAT_ERROR STATUS_CAST(NTSTATUS, 0xC0150005)
#define STATUS_SXS_MANIFEST_PARSE_ERROR STATUS_CAST(NTSTATUS, 0xC0150006)
#define STATUS_SXS_ACTIVATION_CONTEXT_DISABLED STATUS_CAST(NTSTATUS, 0xC0150007)
#define STATUS_SXS_KEY_NOT_FOUND STATUS_CAST(NTSTATUS, 0xC0150008)
#define STATUS_SXS_VERSION_CONFLICT STATUS_CAST(NTSTATUS, 0xC0150009)
#define STATUS_SXS_WRONG_SECTION_TYPE STATUS_CAST(NTSTATUS, 0xC015000A)
#define STATUS_SXS_THREAD_QUERIES_DISABLED STATUS_CAST(NTSTATUS, 0xC015000B)
#define STATUS_SXS_ASSEMBLY_MISSING STATUS_CAST(NTSTATUS, 0xC015000C)
#define STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET STATUS_CAST(NTSTATUS, 0xC015000E)
//#define STATUS_SXS_EARLY_DEACTIVATION					STATUS_CAST(NTSTATUS,0xC015000F)
//#define STATUS_SXS_INVALID_DEACTIVATION					STATUS_CAST(NTSTATUS,0xC0150010)
#define STATUS_SXS_MULTIPLE_DEACTIVATION STATUS_CAST(NTSTATUS, 0xC0150011)
#define STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY STATUS_CAST(NTSTATUS, 0xC0150012)
#define STATUS_SXS_PROCESS_TERMINATION_REQUESTED STATUS_CAST(NTSTATUS, 0xC0150013)
#define STATUS_SXS_CORRUPT_ACTIVATION_STACK STATUS_CAST(NTSTATUS, 0xC0150014)
#define STATUS_SXS_CORRUPTION STATUS_CAST(NTSTATUS, 0xC0150015)
#define STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE STATUS_CAST(NTSTATUS, 0xC0150016)
#define STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME STATUS_CAST(NTSTATUS, 0xC0150017)
#define STATUS_SXS_IDENTITY_DUPLICATE_ATTRIBUTE STATUS_CAST(NTSTATUS, 0xC0150018)
#define STATUS_SXS_IDENTITY_PARSE_ERROR STATUS_CAST(NTSTATUS, 0xC0150019)
#define STATUS_SXS_COMPONENT_STORE_CORRUPT STATUS_CAST(NTSTATUS, 0xC015001A)
#define STATUS_SXS_FILE_HASH_MISMATCH STATUS_CAST(NTSTATUS, 0xC015001B)
#define STATUS_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT STATUS_CAST(NTSTATUS, 0xC015001C)
#define STATUS_SXS_IDENTITIES_DIFFERENT STATUS_CAST(NTSTATUS, 0xC015001D)
#define STATUS_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT STATUS_CAST(NTSTATUS, 0xC015001E)
#define STATUS_SXS_FILE_NOT_PART_OF_ASSEMBLY STATUS_CAST(NTSTATUS, 0xC015001F)
#define STATUS_ADVANCED_INSTALLER_FAILED STATUS_CAST(NTSTATUS, 0xC0150020)
#define STATUS_XML_ENCODING_MISMATCH STATUS_CAST(NTSTATUS, 0xC0150021)
#define STATUS_SXS_MANIFEST_TOO_BIG STATUS_CAST(NTSTATUS, 0xC0150022)
#define STATUS_SXS_SETTING_NOT_REGISTERED STATUS_CAST(NTSTATUS, 0xC0150023)
#define STATUS_SXS_TRANSACTION_CLOSURE_INCOMPLETE STATUS_CAST(NTSTATUS, 0xC0150024)
#define STATUS_SXS_PRIMITIVE_INSTALLER_FAILED STATUS_CAST(NTSTATUS, 0xC0150025)
#define STATUS_GENERIC_COMMAND_FAILED STATUS_CAST(NTSTATUS, 0xC0150026)
#define STATUS_SXS_FILE_HASH_MISSING STATUS_CAST(NTSTATUS, 0xC0150027)

/* Defined in winternl.h, always define since we do not include this header */

/* defined in ntstatus.h */
#if !defined(NTSTATUS_FROM_WIN32) && !defined(INLINE_NTSTATUS_FROM_WIN32)
static INLINE NTSTATUS NTSTATUS_FROM_WIN32(long x)
{
	return x <= 0 ? STATUS_CAST(NTSTATUS, x)
	              : STATUS_CAST(NTSTATUS, ((x)&0x0000FFFF) | (0x7 << 16) | 0xC0000000);
}
#endif

#if defined(_WIN32) && !defined(__MINGW32__)

/**
 * winternl.h contains an incomplete definition of enum FILE_INFORMATION_CLASS
 * avoid conflict by prefixing the winternl.h definition by _WINTERNL_ and then
 * make a complete definition of enum FILE_INFORMATION_CLASS ourselves.
 *
 * For more information, refer to [MS-FSCC]: File System Control Codes:
 * http://msdn.microsoft.com/en-us/library/cc231987.aspx
 */

#define FILE_INFORMATION_CLASS _WINTERNL_FILE_INFORMATION_CLASS
#define _FILE_INFORMATION_CLASS _WINTERNL__FILE_INFORMATION_CLASS
#define FileDirectoryInformation _WINTERNL_FileDirectoryInformation

#include <winternl.h>

#undef FILE_INFORMATION_CLASS
#undef _FILE_INFORMATION_CLASS
#undef FileDirectoryInformation

#elif defined(_WIN32)
#include <winternl.h>
#endif

#ifndef __MINGW32__
typedef enum
{
	FileDirectoryInformation = 1,
	FileFullDirectoryInformation,
	FileBothDirectoryInformation,
	FileBasicInformation,
	FileStandardInformation,
	FileInternalInformation,
	FileEaInformation,
	FileAccessInformation,
	FileNameInformation,
	FileRenameInformation,
	FileLinkInformation,
	FileNamesInformation,
	FileDispositionInformation,
	FilePositionInformation,
	FileFullEaInformation,
	FileModeInformation,
	FileAlignmentInformation,
	FileAllInformation,
	FileAllocationInformation,
	FileEndOfFileInformation,
	FileAlternateNameInformation,
	FileStreamInformation,
	FilePipeInformation,
	FilePipeLocalInformation,
	FilePipeRemoteInformation,
	FileMailslotQueryInformation,
	FileMailslotSetInformation,
	FileCompressionInformation,
	FileObjectIdInformation,
	FileUnknownInformation1,
	FileMoveClusterInformation,
	FileQuotaInformation,
	FileReparsePointInformation,
	FileNetworkOpenInformation,
	FileAttributeTagInformation,
	FileTrackingInformation,
	FileIdBothDirectoryInformation,
	FileIdFullDirectoryInformation,
	FileValidDataLengthInformation,
	FileShortNameInformation
} FILE_INFORMATION_CLASS;
#endif /* !__MINGW32__ */

#if !defined(_WIN32) || defined(__MINGW32__)
/* defined in <winternl.h> */
#define FILE_SUPERSEDED 0x00000000
#define FILE_OPENED 0x00000001
#define FILE_CREATED 0x00000002
#define FILE_OVERWRITTEN 0x00000003
#define FILE_EXISTS 0x00000004
#define FILE_DOES_NOT_EXIST 0x00000005
#endif

#if !defined(_WIN32) || defined(_UWP)

#define FILE_SUPERSEDE 0x00000000
#define FILE_OPEN 0x00000001
#define FILE_CREATE 0x00000002
#define FILE_OPEN_IF 0x00000003
#define FILE_OVERWRITE 0x00000004
#define FILE_OVERWRITE_IF 0x00000005
#define FILE_MAXIMUM_DISPOSITION 0x00000005

#define FILE_DIRECTORY_FILE 0x00000001
#define FILE_WRITE_THROUGH 0x00000002
#define FILE_SEQUENTIAL_ONLY 0x00000004
#define FILE_NO_INTERMEDIATE_BUFFERING 0x00000008

#define FILE_SYNCHRONOUS_IO_ALERT 0x00000010
#define FILE_SYNCHRONOUS_IO_NONALERT 0x00000020
#define FILE_NON_DIRECTORY_FILE 0x00000040
#define FILE_CREATE_TREE_CONNECTION 0x00000080

#define FILE_COMPLETE_IF_OPLOCKED 0x00000100
#define FILE_NO_EA_KNOWLEDGE 0x00000200
#define FILE_OPEN_REMOTE_INSTANCE 0x00000400
#define FILE_RANDOM_ACCESS 0x00000800

#define FILE_DELETE_ON_CLOSE 0x00001000
#define FILE_OPEN_BY_FILE_ID 0x00002000
#define FILE_OPEN_FOR_BACKUP_INTENT 0x00004000
#define FILE_NO_COMPRESSION 0x00008000

#define FILE_OPEN_REQUIRING_OPLOCK 0x00010000

#define FILE_RESERVE_OPFILTER 0x00100000
#define FILE_OPEN_REPARSE_POINT 0x00200000
#define FILE_OPEN_NO_RECALL 0x00400000
#define FILE_OPEN_FOR_FREE_SPACE_QUERY 0x00800000

#define FILE_VALID_OPTION_FLAGS 0x00FFFFFF
#define FILE_VALID_PIPE_OPTION_FLAGS 0x00000032
#define FILE_VALID_MAILSLOT_OPTION_FLAGS 0x00000032
#define FILE_VALID_SET_FLAGS 0x00000036

typedef CONST char* PCSZ;

typedef struct
{
	USHORT Length;
	USHORT MaximumLength;
	PCHAR Buffer;
} STRING;
typedef STRING* PSTRING;

typedef STRING ANSI_STRING;
typedef PSTRING PANSI_STRING;
typedef PSTRING PCANSI_STRING;

typedef STRING OEM_STRING;
typedef PSTRING POEM_STRING;
typedef CONST STRING* PCOEM_STRING;

typedef struct
{
	USHORT Length;
	USHORT MaximumLength;
	PWSTR Buffer;
} LSA_UNICODE_STRING, *PLSA_UNICODE_STRING, UNICODE_STRING, *PUNICODE_STRING;

#define OBJ_INHERIT 0x00000002L
#define OBJ_PERMANENT 0x00000010L
#define OBJ_EXCLUSIVE 0x00000020L
#define OBJ_CASE_INSENSITIVE 0x00000040L
#define OBJ_OPENIF 0x00000080L
#define OBJ_OPENLINK 0x00000100L
#define OBJ_KERNEL_HANDLE 0x00000200L
#define OBJ_FORCE_ACCESS_CHECK 0x00000400L
#define OBJ_VALID_ATTRIBUTES 0x000007F2L

typedef struct
{
	ULONG Length;
	HANDLE RootDirectory;
	PUNICODE_STRING ObjectName;
	ULONG Attributes;
	PVOID SecurityDescriptor;
	PVOID SecurityQualityOfService;
} OBJECT_ATTRIBUTES;
typedef OBJECT_ATTRIBUTES* POBJECT_ATTRIBUTES;

typedef struct
{
	union
	{
#ifdef _WIN32
		NTSTATUS Status;
#else
		NTSTATUS status;
#endif
		PVOID Pointer;
	};
	ULONG_PTR Information;
} IO_STATUS_BLOCK, *PIO_STATUS_BLOCK;

typedef VOID (*PIO_APC_ROUTINE)(PVOID ApcContext, PIO_STATUS_BLOCK IoStatusBlock, ULONG Reserved);

#endif

#if !defined(_WIN32)

typedef struct S_PEB PEB;
typedef struct S_PEB* PPEB;

typedef struct S_TEB TEB;
typedef struct S_TEB* PTEB;

/**
 * Process Environment Block
 */

typedef struct
{
	DWORD ThreadId;
	TEB* ThreadEnvironmentBlock;
} THREAD_BLOCK_ID;

struct S_PEB
{
	DWORD ThreadCount;
	DWORD ThreadArraySize;
	THREAD_BLOCK_ID* Threads;
};

/*
 * Thread Environment Block
 */

struct S_TEB
{
	PEB* ProcessEnvironmentBlock;

	DWORD LastErrorValue;
	PVOID TlsSlots[64];
};

#define GENERIC_READ 0x80000000
#define GENERIC_WRITE 0x40000000
#define GENERIC_EXECUTE 0x20000000
#define GENERIC_ALL 0x10000000

#define DELETE 0x00010000
#define READ_CONTROL 0x00020000
#define WRITE_DAC 0x00040000
#define WRITE_OWNER 0x00080000
#define SYNCHRONIZE 0x00100000
#define STANDARD_RIGHTS_REQUIRED 0x000F0000
#define STANDARD_RIGHTS_READ 0x00020000
#define STANDARD_RIGHTS_WRITE 0x00020000
#define STANDARD_RIGHTS_EXECUTE 0x00020000
#define STANDARD_RIGHTS_ALL 0x001F0000
#define SPECIFIC_RIGHTS_ALL 0x0000FFFF
#define ACCESS_SYSTEM_SECURITY 0x01000000
#define MAXIMUM_ALLOWED 0x02000000

#define FILE_READ_DATA 0x0001
#define FILE_LIST_DIRECTORY 0x0001
#define FILE_WRITE_DATA 0x0002
#define FILE_ADD_FILE 0x0002
#define FILE_APPEND_DATA 0x0004
#define FILE_ADD_SUBDIRECTORY 0x0004
#define FILE_CREATE_PIPE_INSTANCE 0x0004
#define FILE_READ_EA 0x0008
#define FILE_WRITE_EA 0x0010
#define FILE_EXECUTE 0x0020
#define FILE_TRAVERSE 0x0020
#define FILE_DELETE_CHILD 0x0040
#define FILE_READ_ATTRIBUTES 0x0080
#define FILE_WRITE_ATTRIBUTES 0x0100

#define FILE_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x1FF)
#define FILE_GENERIC_READ \
	(STANDARD_RIGHTS_READ | FILE_READ_DATA | FILE_READ_ATTRIBUTES | FILE_READ_EA | SYNCHRONIZE)
#define FILE_GENERIC_WRITE                                                             \
	(STANDARD_RIGHTS_WRITE | FILE_WRITE_DATA | FILE_WRITE_ATTRIBUTES | FILE_WRITE_EA | \
	 FILE_APPEND_DATA | SYNCHRONIZE)
#define FILE_GENERIC_EXECUTE \
	(STANDARD_RIGHTS_EXECUTE | FILE_READ_ATTRIBUTES | FILE_EXECUTE | SYNCHRONIZE)

#define FILE_SHARE_READ 0x00000001
#define FILE_SHARE_WRITE 0x00000002
#define FILE_SHARE_DELETE 0x00000004

typedef DWORD ACCESS_MASK;
typedef ACCESS_MASK* PACCESS_MASK;

#ifdef __cplusplus
extern "C"
{
#endif

	WINPR_API PTEB NtCurrentTeb(void);

#ifdef __cplusplus
}
#endif

#endif

#ifdef __cplusplus
extern "C"
{
#endif

	WINPR_API const char* NtStatus2Tag(NTSTATUS ntstatus);
	WINPR_API const char* Win32ErrorCode2Tag(UINT16 code);

	/** @brief convert a \ref FILE_INFORMATION_CLASS to a string
	 *
	 *  @param value The \ref FILE_INFORMATION_CLASS to convert
	 *
	 *  @return A string representation of the value or "UNKNOWN" for invalid values
	 *  @since version 3.13.0
	 */
	WINPR_API const char* FSInformationClass2Tag(FILE_INFORMATION_CLASS value);

#ifdef __cplusplus
}
#endif

#endif /* WINPR_NT_H */
