/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppainttools_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimppainttools
 * @title: gimppainttools
 * @short_description: Access to toolbox paint tools.
 *
 * Functions giving access to toolbox paint tools.
 **/


/**
 * gimp_airbrush:
 * @drawable: The affected drawable.
 * @pressure: The pressure of the airbrush strokes.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Paint in the current brush with varying pressure. Paint application
 * is time-dependent.
 *
 * This tool simulates the use of an airbrush. Paint pressure
 * represents the relative intensity of the paint application. High
 * pressure results in a thicker layer of paint while low pressure
 * results in a thinner layer.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_airbrush (GimpDrawable  *drawable,
               gdouble        pressure,
               gint           num_strokes,
               const gdouble *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_DOUBLE, pressure,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 3), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-airbrush",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_airbrush_default:
 * @drawable: The affected drawable.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Paint in the current brush with varying pressure. Paint application
 * is time-dependent.
 *
 * This tool simulates the use of an airbrush. It is similar to
 * gimp_airbrush() except that the pressure is derived from the
 * airbrush tools options box. It the option has not been set the
 * default for the option will be used.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_airbrush_default (GimpDrawable  *drawable,
                       gint           num_strokes,
                       const gdouble *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 2), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-airbrush-default",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_clone:
 * @drawable: The affected drawable.
 * @src_drawable: The source drawable.
 * @clone_type: The type of clone.
 * @src_x: The x coordinate in the source image.
 * @src_y: The y coordinate in the source image.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Clone from the source to the dest drawable using the current brush
 *
 * This tool clones (copies) from the source drawable starting at the
 * specified source coordinates to the dest drawable. If the
 * \"clone_type\" argument is set to PATTERN-CLONE, then the current
 * pattern is used as the source and the \"src_drawable\" argument is
 * ignored. Pattern cloning assumes a tileable pattern and mods the sum
 * of the src coordinates and subsequent stroke offsets with the width
 * and height of the pattern. For image cloning, if the sum of the src
 * coordinates and subsequent stroke offsets exceeds the extents of the
 * src drawable, then no paint is transferred. The clone tool is
 * capable of transforming between any image types including
 * RGB-&gt;Indexed--although converting from any type to indexed is
 * significantly slower.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_clone (GimpDrawable  *drawable,
            GimpDrawable  *src_drawable,
            GimpCloneType  clone_type,
            gdouble        src_x,
            gdouble        src_y,
            gint           num_strokes,
            const gdouble *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          GIMP_TYPE_DRAWABLE, src_drawable,
                                          GIMP_TYPE_CLONE_TYPE, clone_type,
                                          G_TYPE_DOUBLE, src_x,
                                          G_TYPE_DOUBLE, src_y,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 6), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-clone",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_clone_default:
 * @drawable: The affected drawable.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Clone from the source to the dest drawable using the current brush
 *
 * This tool clones (copies) from the source drawable starting at the
 * specified source coordinates to the dest drawable. This function
 * performs exactly the same as the gimp_clone() function except that
 * the tools arguments are obtained from the clones option dialog. It
 * this dialog has not been activated then the dialogs default values
 * will be used.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_clone_default (GimpDrawable  *drawable,
                    gint           num_strokes,
                    const gdouble *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 2), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-clone-default",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_convolve:
 * @drawable: The affected drawable.
 * @pressure: The pressure.
 * @convolve_type: Convolve type.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Convolve (Blur, Sharpen) using the current brush.
 *
 * This tool convolves the specified drawable with either a sharpening
 * or blurring kernel. The pressure parameter controls the magnitude of
 * the operation. Like the paintbrush, this tool linearly interpolates
 * between the specified stroke coordinates.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_convolve (GimpDrawable     *drawable,
               gdouble           pressure,
               GimpConvolveType  convolve_type,
               gint              num_strokes,
               const gdouble    *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_DOUBLE, pressure,
                                          GIMP_TYPE_CONVOLVE_TYPE, convolve_type,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 4), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-convolve",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_convolve_default:
 * @drawable: The affected drawable.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Convolve (Blur, Sharpen) using the current brush.
 *
 * This tool convolves the specified drawable with either a sharpening
 * or blurring kernel. This function performs exactly the same as the
 * gimp_convolve() function except that the tools arguments are
 * obtained from the convolve option dialog. It this dialog has not
 * been activated then the dialogs default values will be used.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_convolve_default (GimpDrawable  *drawable,
                       gint           num_strokes,
                       const gdouble *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 2), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-convolve-default",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_dodgeburn:
 * @drawable: The affected drawable.
 * @exposure: The exposure of the strokes.
 * @dodgeburn_type: The type either dodge or burn.
 * @dodgeburn_mode: The mode.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Dodgeburn image with varying exposure.
 *
 * Dodgeburn. More details here later.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_dodgeburn (GimpDrawable      *drawable,
                gdouble            exposure,
                GimpDodgeBurnType  dodgeburn_type,
                GimpTransferMode   dodgeburn_mode,
                gint               num_strokes,
                const gdouble     *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_DOUBLE, exposure,
                                          GIMP_TYPE_DODGE_BURN_TYPE, dodgeburn_type,
                                          GIMP_TYPE_TRANSFER_MODE, dodgeburn_mode,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 5), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-dodgeburn",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_dodgeburn_default:
 * @drawable: The affected drawable.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Dodgeburn image with varying exposure. This is the same as the
 * gimp_dodgeburn() function except that the exposure, type and mode
 * are taken from the tools option dialog. If the dialog has not been
 * activated then the defaults as used by the dialog will be used.
 *
 * Dodgeburn. More details here later.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_dodgeburn_default (GimpDrawable  *drawable,
                        gint           num_strokes,
                        const gdouble *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 2), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-dodgeburn-default",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_eraser:
 * @drawable: The affected drawable.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 * @hardness: How to apply the brush.
 * @method: The paint method to use.
 *
 * Erase using the current brush.
 *
 * This tool erases using the current brush mask. If the specified
 * drawable contains an alpha channel, then the erased pixels will
 * become transparent. Otherwise, the eraser tool replaces the contents
 * of the drawable with the background color. Like paintbrush, this
 * tool linearly interpolates between the specified stroke coordinates.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_eraser (GimpDrawable             *drawable,
             gint                      num_strokes,
             const gdouble            *strokes,
             GimpBrushApplicationMode  hardness,
             GimpPaintApplicationMode  method)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          GIMP_TYPE_BRUSH_APPLICATION_MODE, hardness,
                                          GIMP_TYPE_PAINT_APPLICATION_MODE, method,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 2), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-eraser",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_eraser_default:
 * @drawable: The affected drawable.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Erase using the current brush.
 *
 * This tool erases using the current brush mask. This function
 * performs exactly the same as the gimp_eraser() function except that
 * the tools arguments are obtained from the eraser option dialog. It
 * this dialog has not been activated then the dialogs default values
 * will be used.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_eraser_default (GimpDrawable  *drawable,
                     gint           num_strokes,
                     const gdouble *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 2), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-eraser-default",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_heal:
 * @drawable: The affected drawable.
 * @src_drawable: The source drawable.
 * @src_x: The x coordinate in the source image.
 * @src_y: The y coordinate in the source image.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Heal from the source to the dest drawable using the current brush
 *
 * This tool heals the source drawable starting at the specified source
 * coordinates to the dest drawable. For image healing, if the sum of
 * the src coordinates and subsequent stroke offsets exceeds the
 * extents of the src drawable, then no paint is transferred. The
 * healing tool is capable of transforming between any image types
 * except RGB-&gt;Indexed.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_heal (GimpDrawable  *drawable,
           GimpDrawable  *src_drawable,
           gdouble        src_x,
           gdouble        src_y,
           gint           num_strokes,
           const gdouble *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          GIMP_TYPE_DRAWABLE, src_drawable,
                                          G_TYPE_DOUBLE, src_x,
                                          G_TYPE_DOUBLE, src_y,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 5), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-heal",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_heal_default:
 * @drawable: The affected drawable.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Heal from the source to the dest drawable using the current brush
 *
 * This tool heals from the source drawable starting at the specified
 * source coordinates to the dest drawable. This function performs
 * exactly the same as the gimp_heal() function except that the tools
 * arguments are obtained from the healing option dialog. It this
 * dialog has not been activated then the dialogs default values will
 * be used.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_heal_default (GimpDrawable  *drawable,
                   gint           num_strokes,
                   const gdouble *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 2), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-heal-default",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_paintbrush:
 * @drawable: The affected drawable.
 * @fade_out: Fade out parameter.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 * @method: The paint method to use.
 * @gradient_length: Length of gradient to draw.
 *
 * Paint in the current brush with optional fade out parameter and pull
 * colors from a gradient.
 *
 * This tool is the standard paintbrush. It draws linearly interpolated
 * lines through the specified stroke coordinates. It operates on the
 * specified drawable in the foreground color with the active brush.
 * The 'fade-out' parameter is measured in pixels and allows the brush
 * stroke to linearly fall off. The pressure is set to the maximum at
 * the beginning of the stroke. As the distance of the stroke nears the
 * fade-out value, the pressure will approach zero. The gradient-length
 * is the distance to spread the gradient over. It is measured in
 * pixels. If the gradient-length is 0, no gradient is used.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_paintbrush (GimpDrawable             *drawable,
                 gdouble                   fade_out,
                 gint                      num_strokes,
                 const gdouble            *strokes,
                 GimpPaintApplicationMode  method,
                 gdouble                   gradient_length)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_DOUBLE, fade_out,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          GIMP_TYPE_PAINT_APPLICATION_MODE, method,
                                          G_TYPE_DOUBLE, gradient_length,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 3), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-paintbrush",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_paintbrush_default:
 * @drawable: The affected drawable.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Paint in the current brush. The fade out parameter and pull colors
 * from a gradient parameter are set from the paintbrush options
 * dialog. If this dialog has not been activated then the dialog
 * defaults will be used.
 *
 * This tool is similar to the standard paintbrush. It draws linearly
 * interpolated lines through the specified stroke coordinates. It
 * operates on the specified drawable in the foreground color with the
 * active brush. The 'fade-out' parameter is measured in pixels and
 * allows the brush stroke to linearly fall off (value obtained from
 * the option dialog). The pressure is set to the maximum at the
 * beginning of the stroke. As the distance of the stroke nears the
 * fade-out value, the pressure will approach zero. The gradient-length
 * (value obtained from the option dialog) is the distance to spread
 * the gradient over. It is measured in pixels. If the gradient-length
 * is 0, no gradient is used.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_paintbrush_default (GimpDrawable  *drawable,
                         gint           num_strokes,
                         const gdouble *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 2), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-paintbrush-default",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_pencil:
 * @drawable: The affected drawable.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Paint in the current brush without sub-pixel sampling.
 *
 * This tool is the standard pencil. It draws linearly interpolated
 * lines through the specified stroke coordinates. It operates on the
 * specified drawable in the foreground color with the active brush.
 * The brush mask is treated as though it contains only black and white
 * values. Any value below half is treated as black; any above half, as
 * white.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_pencil (GimpDrawable  *drawable,
             gint           num_strokes,
             const gdouble *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 2), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-pencil",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_smudge:
 * @drawable: The affected drawable.
 * @pressure: The pressure of the smudge strokes.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Smudge image with varying pressure.
 *
 * This tool simulates a smudge using the current brush. High pressure
 * results in a greater smudge of paint while low pressure results in a
 * lesser smudge.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_smudge (GimpDrawable  *drawable,
             gdouble        pressure,
             gint           num_strokes,
             const gdouble *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_DOUBLE, pressure,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 3), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-smudge",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_smudge_default:
 * @drawable: The affected drawable.
 * @num_strokes: Number of stroke control points (count each coordinate as 2 points).
 * @strokes: (array length=num_strokes) (element-type gdouble): Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }.
 *
 * Smudge image with varying pressure.
 *
 * This tool simulates a smudge using the current brush. It behaves
 * exactly the same as gimp_smudge() except that the pressure value is
 * taken from the smudge tool options or the options default if the
 * tools option dialog has not been activated.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_smudge_default (GimpDrawable  *drawable,
                     gint           num_strokes,
                     const gdouble *strokes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_INT, num_strokes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 2), strokes, num_strokes);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-smudge-default",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
