/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(0)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/* BINDTOOL_HEADER_FILE(vector_sink.h)                                        */
/* BINDTOOL_HEADER_FILE_HASH(b92aa7ef4345ba35b812f6d053199c6c)                     */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/blocks/vector_sink.h>

template <typename T>
void bind_vector_sink_template(py::module& m, const char* classname)
{
    using vector_sink = gr::blocks::vector_sink<T>;

    py::class_<vector_sink,
               gr::sync_block,
               gr::block,
               gr::basic_block,
               std::shared_ptr<vector_sink>>(m, classname)
        .def(py::init(&gr::blocks::vector_sink<T>::make),
             py::arg("vlen") = 1,
             py::arg("reserve_items") = 1024)
        .def("reset", &vector_sink::reset)
        .def("data", &vector_sink::data)
        .def("tags", &vector_sink::tags);
}

void bind_vector_sink(py::module& m)
{
    bind_vector_sink_template<std::uint8_t>(m, "vector_sink_b");
    bind_vector_sink_template<std::int16_t>(m, "vector_sink_s");
    bind_vector_sink_template<std::int32_t>(m, "vector_sink_i");
    bind_vector_sink_template<float>(m, "vector_sink_f");
    bind_vector_sink_template<gr_complex>(m, "vector_sink_c");
}
