function(set_version VERSION)
  if(DEFINED ENV{HIGHS_MAJOR} AND DEFINED ENV{HIGHS_MINOR})
    set(MAJOR $ENV{HIGHS_MAJOR})
    set(MINOR $ENV{HIGHS_MINOR})
  else()
    # Get Major and Minor and maybe Patch from Version.txt
    file(STRINGS "Version.txt" VERSION_STR)
    foreach(STR ${VERSION_STR})
      if(${STR} MATCHES "HIGHS_MAJOR=(.*)")
        set(MAJOR ${CMAKE_MATCH_1})
      elseif(${STR} MATCHES "HIGHS_MINOR=(.*)")
        set(MINOR ${CMAKE_MATCH_1})
      elseif(${STR} MATCHES "HIGHS_PATCH=(.*)")
        set(PATCH ${CMAKE_MATCH_1})
      endif()
    endforeach()
  endif()

  if(DEFINED ENV{HIGHS_PATCH})
    set(PATCH $ENV{HIGHS_PATCH})
  elseif(NOT DEFINED PATCH)
    set(PATCH 999)
  endif()

  set(${VERSION} "${MAJOR}.${MINOR}.${PATCH}" PARENT_SCOPE)
endfunction()
