# Courses

The Insight Toolkit (ITK) is not only a foundation for the practice of image analysis in industry and academia; ITK has been studied and used to demonstrate principles of scientific and medical image analysis in many university courses around the world.

Kitware also offers periodic [short online courses given by expert instructors](https://www.kitware.com/courses/itk/).

- The University of Iowa-Medical [Image Analysis course](https://data.kitware.com/#collection/57b5c9e58d777f126827f5a1/folder/57b5d18b8d777f10f269311c) is semester-long course taught by Hans Johnson. It is an excellent introduction to medical image analysis and ITK. The course covers the architecture of ITK, programming with ITK, medical image representation, filtering, affine registration, and deformable registration with Demons and b-splines.  Powerpoint files of the lectures are available.
- A long-running [Methods in Medical Image Analysis course](https://www.cs.cmu.edu/~galeotti/methods_course/) from John Galeotti at Carnegie-Mellon has both lecture Powerpoints and high quality video recordings of the lectures available. Its purpose, from its syllabus, is “to gain theoretical and practical skills in medical image analysis, including skills relevant to general image analysis.  The fundamentals of computational medical image analysis will be explored, leading to current research in applying geometry and statistics to segmentation, registration, visualization, and image understanding. Student will develop practical experience through projects using the new v4 of the National Library of Medicine Insight Toolkit (ITK), a popular open-source software library developed by a consortium of institutions including Carnegie Mellon University and the University of Pittsburgh.”
- The University of Pennsylvania, Center for Biomedical Image Computing and Analytics has made available the presentations and code from a on "[CPP for Image Processing and Machine Learning](https://www.nitrc.org/projects/cbica_tutorials)."  The tutorial intends to help someone with a good theoretical background in image processing and machine learning quickly prototype algorithms using C++ and extend them to create meaningful software packages
- A [Medical Image Computing course](http://www.cs.ucf.edu/~bagci/teaching/mic17.html) at the University of Central Florida covers the basics of radiological image modalities and their clinical use, an introduction to medical image computing and toolkits, image filtering, enhancement, noise reduction, and signal processing, medical image registration, medical image segmentation, medical image visualization, shape modeling/analysis of medical images, machine learning/deep learning in medical imaging, neuroimaging: fMRI, DTI, MRI,  and connectome imaging.
- An [Image Registration course](https://www.cs.rpi.edu/courses/spring04/imagereg/) at the Rensselaer Polytechnic Institute (RPI) covers all aspects of image registration, including the underlying mathematics, the images themselves, algorithms, implementations, and applications. Applications range from medical imaging to automatic geometric modeling. Special emphasis is given to software toolkits for image registration.
- The [Computer Assisted Image Analysis course](https://www.it.uu.se/edu/course/homepage/bild1/vt14) at Uppsala University gives an introduction to the processing and analysis of digital images, covering: pointwise image operators, local image operators, Fourier analysis of images, mathematical morphology and distance transforms, image segmentation, object description, classification, color images and image compression, and applications of image analysis.
- An [Advanced Image Processing and Analysis course](https://www.eng.uwo.ca/biomed/courses/courses_9519.html) at Western University explores a few major areas of digital image processing at an advanced level, with primary emphasis on medical applications. Topics covered include image segmentation, image registration, validation of image processing algorithms, and image processing using 3D Slicer and the Insight Toolkit (ITK). Examples will be presented to give the students exposure to real-world applications.
- [Multimedia Analysis](https://www.comp.nus.edu.sg/~cs6240/) taught at the University of Singapore aims to provide a comprehensive and rigorous treatment of the main approaches in multimedia (document, image, video, graphics) analysis.
- [Image Processing](https://my.eng.utah.edu/~cs6640/) at the University of Utah is an introductory course in processing gray-scale and color images taught at the graduate level. This course covers both mathematical fundamentals and implementation.
- A [Digital and Medical Image Processing course](https://www.sfu.ca/outlines.html?2015/spring/ensc/474/d100) at Simon Fraser University develops signal processing techniques of wide applicability, presented in the context of processing and analysis of digital images, in particular 2D and 3D biomedical images. Covers acquisition, formation and representation of digital images, filtering, enhancement and restoration in both spatial and frequency domains, image segmentation, image registration, and discrete image transforms.
- [Medical Image Science: Applications](https://medphysics.wisc.edu/mp-574/) at the University of Wisconsin-Madison presents the application of medical imaging theory to problems in medical imaging science including: concepts of digital image processing, image reconstruction/compression, point response function analysis, noise characteristics, and measurement.
- A [Digital Image Processing course](https://www.ee.columbia.edu/~xlx/ee4830/) at Columbia University introduces fundamental technologies for digital image and video representation, compression, analysis, and processing. Students will gain understanding of algorithm and system design, analytical tools, and practical implementations of various digital image applications.
- The [Applied Medical Image Analysis course](https://catalog.odu.edu/courses/bme/) at Old Dominion University explores hands-on exposure to state-of-the-art algorithms in medical image analysis, which builds on open-source software (Insight Segmentation and Registration Toolkit – ITK), as well as the principles of medical image acquisition in the modalities of clinical interest. Medical imaging modalities – X-rays, CT, and MRI/ITK image pipeline; image enhancement, feature detection; segmentation – basic techniques, feature-based classification and clustering, graph cuts, active contour and surface models; surface and volume meshing; registration – transformations, similarity criteria; shape and appearance models are all explored and discussed in this course.
- The [Introduction to Pattern Recognition](https://www5.cs.fau.de/lectures/ws-1516/introduction-to-pattern-recognition-intropr/exercises/) at Technische Fakultat course covers the Fourier Transform, Fourier Series, k-Means clustering, histogram equalization, image filtering, threshold, edge detection, simple segmentation, morphological operations, normalization, walsh transform, wavelets, eigenfaces.
- [Programming for Medical Imaging](https://www.uu.nl/en/masters/medical-imaging/study-programme) at Utrecht University is a course that teaches the theoretical knowledge and practical skills required for medical imaging. The focus is on C++ and Python.
- [Biomedical Imaging and Analysis](https://www.justcallharry.com/bia-fall-2014.html) at Sun Yat-sen course’s goals are to familiarize students with biological and medical imaging data from various imaging modalities (eg: Magnetic Resonance Imaging (MRI), X-ray Computed Tomography (CT), Fluoroscopy, Ultrasound and Optical Systems for  Microscopy), how these data are acquired as well as how to process 2D, 3D and 4D (3D + time) data for quantification and visualization purposes using contemporary software tools and open-source libraries (including, SimpleITK, ITK, VTK).
- The National Technical University of Athens offers an [Introduction to Biomedical Engineering, Biological Signal Analysis, and Processing](https://biomig.ntua.gr/courses.html) whose lectures include methods and processing techniques, design and implementation of digital filters together with specific applications.
- Professor Owen Carmichael provided video recordings from his course on [Image Processing and Analysis](http://www.infocobuild.com/education/audio-video-courses/computer-science/ecs173-fall2010-uc-davis.html). This course deals with techniques for automated extraction of high-level information from images generated by cameras, three-dimensional surface sensors, and medical devices.
