///////////////////////////////////////////////////////////////////////////////
//                                                         
// LogTest.cc
// -------------
// log class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 1996 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/Logger.h"

int main(int argc, char **argv)
{

    
    int numCheck = 1;
    int checkCount = 1;
    
    try
    {
	
	
	cout << "1.." << numCheck << endl;
	
	Logger l( "logFile", "logtest");
	l.logModule(1, "BASE", Logger::NOTICE);
      
	l << 1 << Logger::LOGERR << "This is an error message\n" ;
	l << 1 << Logger::NOTICE << "This is  notice message\n" ;
	
	l.log(1, Logger::NOTICE, Chain("Another notice message"));
	l.log(1, Logger::LOGERR, Chain("Another error message"));
	l.log(1, Logger::LOGALERT, Chain("Another alert message"));
	l.log(1, Logger::LOGALERT, "Another plain alert message");
	

	cout << "ok " << checkCount << " - logging test" << endl;
	checkCount++;
    }        
    catch (Exception e)
    {
	
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;

}

