///////////////////////////////////////////////////////////////////////////////
//                                                         
// TextIndexTest.cc
// ----------------
// Text Index class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/TextIndex.h"

int main(int argc, char **argv)
{


    int numCheck = 1;
    int checkCount = 1;
    
    try {
	
	
	cout << "1.." << numCheck << endl;
      
	
	Chain text("Fest gemauert in der Erden \
Steht die Form, aus Lehm gebrannt. \
Heute muß die Glocke werden. \
Frisch Gesellen, seid zur Hand. \
Von der Stirne heiß \
Rinnen muß der Schweiß, \
Soll das Werk den Meister loben, \
Doch der Segen kommt von oben. \
Zum Werke, das wir ernst bereiten, \
Geziemt sich wohl ein ernstes Wort; \
Wenn gute Reden sie begleiten, \
Dann fließt die Arbeit munter fort. \
So laßt uns jetzt mit Fleiß betrachten, \
Was durch die schwache Kraft entspringt, \
Den schlechten Mann muß man verachten, \
Der nie bedacht, was er vollbringt. \
Das ist \'s ja, was den Menschen zieret, \
Und dazu ward ihm der Verstand, \
Daß er im innern Herzen spueret, \
Was er erschafft mit seiner Hand. \
Nehmet Holz vom Fichtenstamme, \
Doch recht trocken laßt es sein, \
Daß die eingepreßte Flamme \
Schlage zu dem Schwalch hinein. \
Kocht des Kupfers Brei, \
Schnell das Zinn herbei, \
Daß die zaehe Glockenspeise \
Fließe nach der rechten Weise. \
Was in des Dammes tiefer Grube \
Die Hand mit Feuers Huelfe baut, \
Hoch auf des Turmes Glockenstube \
Da wird es von uns zeugen laut. \
Noch dauern wird \'s in spaeten Tagen \
Und ruehren vieler Menschen Ohr \
Und wird mit dem Betruebten klagen \
Und stimmen zu der Andacht Chor. \
Was unten tief dem Erdensohne \
Das wechselnde Verhaengnis bringt, \
Das schlaegt an die metallne Krone, \
Die es erbaulich weiterklingt. \
Weiße Blasen seh ich springen, \
Wohl! Die Massen sind im Fluß. \
Laßt \'s mit Aschensalz durchdringen, \
Das befoerdert schnell den Guß. \
Auch von Schaume rein \
Muß die Mischung sein, \
Daß vom reinlichen Metalle \
Rein und voll die Stimme schalle. \
Denn mit der Freude Feierklange \
Begrueßt sie das geliebte Kind \
Auf seines Lebens erstem Gange, \
Den es in Schlafes Arm beginnt; \
Ihm ruhen noch im Zeitenschoße \
Die schwarzen und die heitern Lose, \
Der Mutterliebe zarte Sorgen \
Bewachen seinen goldnen Morgen \
Die Jahre fliehen pfeilgeschwind. \
Vom Maedchen reißt sich stolz der Knabe, \
Er stuermt ins Leben wild hinaus, \
Durchmißt die Welt am Wanderstabe. \
Fremd kehrt er heim ins Vaterhaus, \
Und herrlich, in der Jugend Prangen, \
Wie ein Gebild aus Himmelshoehn, \
Mit zuechtigen, verschaemten Wangen \
Sieht er die Jungfrau vor sich stehn. \
Da faßt ein namenloses Sehnen \
Des Juenglings Herz, er irrt allein, \
Aus seinen Augen brechen Traenen, \
Er flieht der Brueder wilder Reihn. \
Erroetend folgt er ihren Spuren \
Und ist von ihrem Gruß beglueckt, \
Das Schoenste sucht er auf den Fluren, \
Womit er seine Liebe schmueckt. \
O! zarte Sehnsucht, sueßes Hoffen, \
Der ersten Liebe goldne Zeit, \
Das Auge sieht den Himmel offen, \
Es schwelgt das Herz in Seligkeit. \
O! daß sie ewig gruenen bliebe, \
Die schoene Zeit der jungen Liebe! \
Wie sich schon die Pfeifen braeunen! \
Dieses Staebchen tauch ich ein, \
Sehn wir \'s ueberglast erscheinen, \
Wird \'s zum Gusse zeitig sein. \
Jetzt, Gesellen, frisch! \
Prueft mir das Gemisch, \
Ob das Sproede mit dem Weichen \
Sich vereint zum guten Zeichen. \
Denn wo das Strenge mit dem Zarten, \
Wo Starkes sich und Mildes paarten, \
Da gibt es einen guten Klang. \
Drum pruefe, wer sich ewig bindet, \
Ob sich das Herz zum Herzen findet! \
Der Wahn ist kurz, die Reu ist lang. \
Lieblich in der Braeute Locken \
Spielt der jugfraeuliche Kranz, \
Wenn die hellen Kirchenglocken \
Laden zu des Festes Glanz. \
Ach! des Lebens schoenste Feier \
Endigt auch den Lebensmai, \
Mit dem Guertel, mit dem Schleier \
Reißt der schoene Wahn entzwei. \
Die Leidenschaft flieht! \
Die Liebe muß bleiben, \
Die Blume verblueht, \
Die Frucht muß treiben. \
Der Mann muß hinaus \
Ins feindliche Leben, \
Muß wirken und streben \
Und pflanzen und schaffen, \
Erlisten, erraffen, \
Muß wetten und wagen, \
Das Glueck zu erjagen. \
Da stroemet herbei die unendliche Gabe, \
Es fuellt sich der Speicher mit koestlicher Habe, \
Die Raeume wachsen, es dehnt sich das Haus. \
Und drinnen waltet \
Die zuechtige Hausfrau, \
Die Mutter der Kinder, \
Und herrschet weise \
Im haeuslichen Kreise, \
Und lehret die Maedchen \
Und wehret den Knaben, \
Und reget ohn Ende \
Die fleißigen Haende, \
Und mehrt den Gewinn \
Mit ordnendem Sinn. \
Und fuellet mit Schaetzen die duftenden Laden, \
Und dreht um die schnurrende Spindel den Faden, \
Und sammelt im reinlich geglaetteten Schrein \
Die schimmernde Wolle, den schneeigten Lein, \
Und fueget zum Guten den Glanz und den Schimmer, \
Und ruhet nimmer. \
Und der Vater mit frohem Blick \
Von des Hauses weitschauendem Giebel \
UEberzaehlet sein bluehend Glueck, \
Siehet der Pfosten ragende Baeume \
Und der Scheunen gefuellte Raeume \
Und die Speicher, vom Segen gebogen, \
Und des Kornes bewegte Wogen, \
Ruehmt sich mit stolzem Mund: \
Fest, wie der Erde Grund, \
Gegen des Ungluecks Macht \
Steht mir des Hauses Pracht! \
Doch mit des Geschickes Maechten \
Ist kein ewger Bund zu flechten, \
Und das Unglueck schreitet schnell. \
Wohl! nun kann der Guß beginnen, \
Schoen gezacket ist der Bruch. \
Doch bevor wir \'s lassen rinnen, \
Betet einen frommen Spruch! \
Stoßt den Zapfen aus! \
Gott bewahr das Haus! \
Rauchend in des Henkels Bogen \
Schießt \'s mit feuerbraunen Wogen. \
Wohtaetig ist des Feuers Macht, \
Wenn sie der Mensch bezaehmt, bewacht, \
Und was er bildet, was er schafft, \
Das dankt er dieser Himmelskraft, \
Doch furchtbar wird die Himmelskraft, \
Wenn sie der Fessel sich entrafft, \
Einhertritt auf der eignen Spur \
Die freie Tochter der Natur. \
Wehe, wenn sie losgelassen \
Wachsend ohne Widerstand \
Durch die volkbelebten Gassen \
Waelzt den ungeheuren Brand! \
Denn die Elemente hassen \
Das Gebild der Menschenhand. \
Aus der Wolke \
Quillt der Segen, \
Stroemt der Regen, \
Aus der Wolke, ohne Wahl, \
Zuckt der Strahl! \
Hoert ihr \'s wimmern hoch vom Turm? \
Das ist Sturm! \
Rot wie Blut \
Ist der Himmel, \
Das ist nicht des Tages Glut! \
Welch Getuemmel \
Straßen auf! \
Dampf wallt auf! \
Flackernd steigt die Feuersaeule, \
Durch der Straße lange Zeile \
Waechst es fort mit Windeseile, \
Kochend wie aus Ofens Rachen \
Gluehn die Luefte, Balken krachen, \
Pfosten stuerzen, Fenster klirren, \
Kinder jammern, Muetter irren, \
Tiere wimmern \
Unter Truemmern, \
Alles rennet, rettet, fluechtet, \
Taghell ist die Nacht gelichtet, \
Durch der Haende lange Kette \
Um die Wette \
Fliegt der Eimer, hoch im Bogen \
Spruetzen Quellen, Wasserwogen. \
Heulend kommt der Sturm geflogen, \
Der die Flamme brausend sucht. \
Prasselnd in die duerre Frucht \
Faellt sie in des Speichers Raeume, \
In der Sparren duerre Baeume, \
Und als wollte sie im Wehen \
Mit sich fort der Erde Wucht \
Reißen, in gewaltger Flucht, \
Waechst sie in des Himmels Hoehen \
Riesengroß! \
Hoffnungslos \
Weicht der Mensch der Goetterstaerke, \
Mueßig sieht er seine Werke \
Und bewundernd untergehn. \
Leergebrannt \
Ist die Staette, \
Wilder Stuerme rauhes Bette, \
In den oeden Fensterhoehlen \
Wohnt das Grauen, \
Und des Himmels Wolken schauen \
Hoch hinein. \
Einen Blick \
Nach den Grabe \
Seiner Habe \
Sendet noch der Mensch zurueck - \
Greift froehlich dann zum Wanderstabe. \
Was Feuers Wut ihm auch geraubt, \
Ein sueßer Trost ist ihm geblieben, \
Er zaehlt die Haupter seiner Lieben, \
Und sieh! ihm fehlt kein teures Haupt. \
In die Erd ist \'s aufgenommen, \
Gluecklich ist die Form gefuellt, \
Wird \'s auch schoen zutage kommen, \
Daß es Fleiß und Kunst vergilt? \
Wenn der Guß mißlang? \
Wenn die Form zersprang? \
Ach! vielleicht indem wir hoffen, \
Hat uns Unheil schon getroffen. \
Dem dukeln schoß der heilgen Erde \
Vertrauen wir der Haende Tat, \
Vertraut der Saemann seine Saat \
Und hofft, daß sie entkeimen werde \
Zum Segen, nach des Himmels Rat. \
Noch koestlicheren Samen bergen \
Wir trauernd in der Erde Schoß \
Und hoffen, daß er aus den Saergen \
Erbluehen soll zu schoenerm Los. \
Von dem Dome, \
Schwer und bang, \
Toent die Glocke \
Grabgesang. \
Ernst begleiten ihre Trauerschlaege \
Einen Wandrer auf dem letzten Wege. \
Ach! die Gattin ist \'s, die teure, \
Ach! es ist die treue Mutter, \
Die der schwarze Fuerst der Schatten \
Wegfuehrt aus dem Arm des Gatten, \
Aus der zarten Kinder Schar, \
Die sie bluehend ihm gebar, \
Die sie an der treuen Brust \
Wachsen sah mit Mutterlust \
Ach! des Hauses zarte bande \
Sind geloest auf immerdar, \
Denn sie wohnt im Schattenlande, \
Die des Hauses Mutter war, \
Denn es fehlt ihr treues Walten, \
Ihre Sorge wacht nicht mehr, \
An verwaister Staette schalten \
Wird die Fremde, liebeleer. \
Bis die Glocke sich verkuehlet, \
Laßt die strenge Arbeit ruhn, \
Wie im Laub der Vogel spielet, \
Mag sich jeder guetlich tun. \
Winkt der Sterne Licht, \
Ledig aller Pflicht \
Hoert der Pursch die Vesper schlagen, \
Meister muß sich immer plagen. \
Munter foerdert seine Schritte \
Fern im wilden Forst der Wandrer \
Nach der lieben Heimathuette. \
Bloekend ziehen \
Heim die Schafe, \
Und der Rinder \
Breitgestirnte, glatte Scharen \
Kommen bruellend, \
Die gewohnten Staelle fuellend. \
Schwer herein \
Schwankt der Wagen, \
Kornbeladen, \
Bunt von Farben \
Auf den Garben \
Liegt der Kranz, \
Und das junge Volk der Schnitter \
Fliegt zum Tanz. \
Markt und Straße werden stiller, \
Um des Lichts gesellge Flamme \
Sammeln sich die Hausbewohner, \
Und das Stadttor schließt sich knarrend. \
Schwarz bedecket \
Sich die Erde, \
Doch den sichern Buerger schrecket \
Nicht die Nacht, \
Die den Boesen graeßlich wecket, \
Denn das Auge des Gesetzes wacht. \
Heilge Ordnung, segenreiche \
Himmelstochter, die das Gleiche \
Frei und leicht und freudig bindet, \
Die der Staedte Bau begruendet, \
Die herein von den Gefilden \
Rief den ungesellgen Wilden, \
Eintrat in der Menschen Huetten, \
Sie gewoehnt zu sanften Sitten \
Und das teuerste der Bande \
Wob, den Trieb zum Vaterlande! \
Tausend fleißge Haende regen, \
helfen sich in munterm Bund, \
Und in feurigem Bewegen \
Werden alle Kraefte kund. \
Meister ruehrt sich und Geselle \
In der Freiheit heilgem Schutz. \
Jeder freut sich seiner Stelle, \
Bietet dem Veraechter Trutz. \
Arbeit ist des Buergers Zierde, \
Segen ist der Muehe Preis, \
Ehrt den Koenig seine Wuerde, \
Ehret uns der Haende Fleiß. \
Holder Friede, \
Sueße Eintracht, \
Weilet, weilet \
Freundlich ueber dieser Stadt! \
Moege nie der Tag erscheinen, \
Wo des rauhen Krieges Horden \
Dieses stille Tal durchtoben, \
Wo der Himmel, \
Den des Abends sanfte Roete \
Lieblich malt, \
Von der Doerfer, von der Staedte \
Wildem Brande schrecklich strahlt! \
Nun zerbrecht mir das Gebaeude, \
Seine Absicht hat \'s erfuellt, \
Daß sich Herz und Auge weide \
An dem wohlgelungnen Bild. \
Schwingt den Hammer, schwingt, \
Bis der Mantel springt, \
Wenn die Glock soll auferstehen, \
Muß die Form in Stuecke gehen. \
Der Meister kann die Form zerbrechen \
Mit weiser Hand, zur rechten Zeit, \
Doch wehe, wenn in Flammenbaechen \
Das gluehnde Erz sich selbst befreit! \
Blindwuetend mit des Donners Krachen \
Zersprengt es das geborstne Haus, \
Und wie aus offnem Hoellenrachen \
Speit es Verderben zuendend aus; \
Wo rohe Kraefte sinnlos walten, \
Da kann sich kein Gebild gestalten, \
Wenn sich die Voelker selbst befrein, \
Da kann die Wohlfahrt nicht gedeihn. \
Weh, wenn sich in dem Schoß der Staedte \
Der Feuerzunder still gehaeuft, \
Das Volk, zerreißend seine Kette, \
Zur Eigenhilfe schrecklich greift! \
Da zerret an der Glocken Straengen \
Der Aufruhr, daß sie heulend schallt \
Und, nur geweiht zu Friedensklaengen, \
Die Losung anstimmt zur Gewalt. \
Freiheit und Gleichheit! hoert man schallen, \
Der ruhge Buerger greift zur Wehr, \
Die Straßen fuellen sich, die Hallen, \
Und Wuergerbanden ziehn umher, \
Das werden Weiber zu Hyaenen \
Und treiben mit Entsetzen Scherz, \
Noch zuckend, mit des Panthers Zaehnen, \
Zerreißen sie des Feindes Herz. \
Nichts Heiliges ist mehr, es loesen \
Sich alle Bande frommer Scheu, \
Der Gute raeumt den Platz dem Boesen, \
Und alle Laster walten frei. \
Gefaehrlich ist \'s, den Leu zu wecken, \
Verderblich ist des Tigers Zahn, \
Jedoch der schrecklichste der Schrecken, \
Das ist der Mensch in seinem Wahn. \
Weh denen, die dem Ewigblinden \
Des Lichtes Himmelsfackel leihn! \
Sie strahlt ihm nicht, sie kann nur zuenden \
Und aeschert Staedt und Laender ein. \
Freude hat mir Gott gegeben! \
Sehet! Wie ein goldner Stern \
Aus der Huelse, blank und eben, \
Schaelt sich der metallne Kern. \
Von dem Helm zum Kranz \
Spielt \'s wie Sonnenglanz, \
Auch des Wappens nette Schilder \
Loben den erfahrnen Bilder. \
Herein! herein! \
Gesellen alle, schließt den Reihen, \
Daß wir die Glocke taufend weihen, \
Concordia soll ihr Name sein, \
Zur Eintracht, zu herzinnigem Vereine \
Versammle sich die liebende Gemeine. \
Und dies sei fortan ihr Beruf, \
Wozu der Meister sie erschuf! \
Hoch ueberm niedern Erdenleben \
Soll sie im blauen Himmelszelt \
Die Nachbarin des Donners schweben \
Und grenzen an die Sternenwelt, \
Soll eine Stimme sein von oben, \
Wie der Gestirne helle Schar, \
Die ihren Schoepfer wandelnd loben \
Und fuehren das bekraenzte Jahr. \
Nur ewigen und ernsten Dingen \
Sei ihr metallner Mund geweiht, \
Und stuendlich mit den schnellen Schwingen \
Beruehr im Fluge sie die Zeit, \
Dem Schicksal leihe sie die Zunge, \
Selbst herzlos, ohne Mitgefuehl, \
Begleite sie mit ihrem Schwunge \
Des Lebens wechselvolles Spiel. \
Und wie der Klang im Ohr vergehet, \
Der maechtig toenend ihr entschallt, \
So lehre sie, daß nichts bestehet, \
Daß alles Irdische verhallt. \
Jetzo mit der Kraft des Stranges \
Wiegt die Glock mir aus der Gruft, \
Daß sie in das Reich des Klanges \
Steige, in die Himmelsluft. \
Zehet, ziehet, hebt! \
Sie bewegt sich, schwebt, \
Freude dieser Stadt bedeute, \
Friede sei ihr erst Gelaeute.");
	SetT<Chain> filter;

	filter.Insert("der");
	filter.Insert("die");
	filter.Insert("das");
	filter.Insert("zum");
	filter.Insert("zur");
	filter.Insert("zu");
	filter.Insert("wer");
	filter.Insert("war");
	filter.Insert("was");
	filter.Insert("von");
	filter.Insert("vor");
	filter.Insert("vom");
	filter.Insert("um");
	filter.Insert("und");
	filter.Insert("ueber");
	filter.Insert("uns");
	filter.Insert("er");
	filter.Insert("sie");
	filter.Insert("es");
	filter.Insert("so");
	filter.Insert("unter");
	filter.Insert("sind");
	filter.Insert("soll");
	filter.Insert("sei");
	filter.Insert("seid");
	filter.Insert("sein");
	filter.Insert("seine");
	filter.Insert("seinen");
	filter.Insert("seiner");
	filter.Insert("selbst");
	filter.Insert("o");
	filter.Insert("nur");
	filter.Insert("nun");
	filter.Insert("ob");
	filter.Insert("noch");
	filter.Insert("muß");
	filter.Insert("nach");
	filter.Insert("ueber");
	filter.Insert("los");
	filter.Insert("ins");
	filter.Insert("in");
	filter.Insert("im");
	filter.Insert("ihre");
	filter.Insert("ihrem");
	filter.Insert("s");
	filter.Insert("man");
	filter.Insert("ist");
	filter.Insert("ihr");
	filter.Insert("ihren");
	filter.Insert("ihm");
	filter.Insert("ich");
	filter.Insert("erst");
	filter.Insert("erstem");
	filter.Insert("ersten");
	filter.Insert("einen");
	filter.Insert("eine");
	filter.Insert("einer");
	filter.Insert("ein");
	filter.Insert("drum");
	filter.Insert("doch");
	filter.Insert("dieses");
	filter.Insert("dies");
	filter.Insert("dieser");
	filter.Insert("des");
	filter.Insert("denn");
	filter.Insert("denen");
	filter.Insert("dem");
	filter.Insert("daß");
	filter.Insert("dazu");
	filter.Insert("dann");
	filter.Insert("da");
	filter.Insert("bleiben");
	filter.Insert("bis");
	filter.Insert("aus");
	filter.Insert("auf");
	filter.Insert("an");
	filter.Insert("als");
	filter.Insert("alles");
	filter.Insert("alle");
	filter.Insert("ach");

	// TextIndex::IndexFilter indexFilter("alpha", "Beta");
	
	SetT<TextIndex::IndexFilter> indexFilter;
	indexFilter.Insert(TextIndex::IndexFilter("d??", Chain()));
	indexFilter.Insert(TextIndex::IndexFilter("z?", Chain()));
	indexFilter.Insert(TextIndex::IndexFilter("z??", Chain()));
	
	
	TextIndex ti(text, indexFilter, 3, Chain(" !-,.;:'"));
	
	Chain key;
	unsigned long long i=0;
	while (ti.nextKey(key) == true)
	{
	    i++;
	    // cout << "key=" << key << endl;
	}
	
	cout << "ok " << checkCount << " - text index test ( " << i << " keys )" << endl;
	checkCount++;

      	
    }        
    catch (Exception e)
    {
	
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;  

}

