///////////////////////////////////////////////////////////////////////////////
//
// Attribute.cc
// ------------
// XML attribute implementation
//
// Design and Implementation by Bjoern Lemke
//               
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: Attribute
// 
// Description: XML attribute container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include "Attribute.h"
#include "XMLEscaper.h"

Attribute::Attribute()
{
}

Attribute::Attribute(const Chain& name)
{
    _name = name;
}

Attribute::Attribute(const Chain& name, const Chain& value, bool treatXMLEscape)
{
    _name = name;
    _value = value;
    if ( treatXMLEscape )
    {
	XMLEscaper esc;
	esc.descape(_value);
    }
}

Attribute::~Attribute()
{
}

const Chain& Attribute::getName() const
{
    return _name;
}

void Attribute::setValue(const Chain& value, bool treatXMLEscape)
{
    _value = value;
    if ( treatXMLEscape )
    {
	XMLEscaper esc;
	esc.descape(_value);
    }
    
}

Chain Attribute::getXMLValue() const
{
    Chain value = _value;
    XMLEscaper esc;
    esc.escape(value);
    return value;
}

Chain Attribute::getValue() const
{
    return _value;
}

Attribute& Attribute::operator=(const Attribute& attr)
{
    _name = attr._name;
    _value = attr._value;
    return (*this);
}
    
bool Attribute::operator==(const Attribute& attr) const
{
    if ( _name == attr._name ) 
	return true;
    return false;
}
