#pragma once

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>


namespace LCompilers::ASR {
/******************************************************************************/
// Visitor functions

template <class Visitor>
static void visit_unit_t(const unit_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::unit)
    switch (x.type) {
        case unitType::TranslationUnit: { v.visit_TranslationUnit((const TranslationUnit_t &)x); return; }
    }
}

template <class Visitor>
static void visit_symbol_t(const symbol_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::symbol)
    switch (x.type) {
        case symbolType::Program: { v.visit_Program((const Program_t &)x); return; }
        case symbolType::Module: { v.visit_Module((const Module_t &)x); return; }
        case symbolType::Function: { v.visit_Function((const Function_t &)x); return; }
        case symbolType::GenericProcedure: { v.visit_GenericProcedure((const GenericProcedure_t &)x); return; }
        case symbolType::CustomOperator: { v.visit_CustomOperator((const CustomOperator_t &)x); return; }
        case symbolType::ExternalSymbol: { v.visit_ExternalSymbol((const ExternalSymbol_t &)x); return; }
        case symbolType::Struct: { v.visit_Struct((const Struct_t &)x); return; }
        case symbolType::Enum: { v.visit_Enum((const Enum_t &)x); return; }
        case symbolType::Union: { v.visit_Union((const Union_t &)x); return; }
        case symbolType::Variable: { v.visit_Variable((const Variable_t &)x); return; }
        case symbolType::Class: { v.visit_Class((const Class_t &)x); return; }
        case symbolType::ClassProcedure: { v.visit_ClassProcedure((const ClassProcedure_t &)x); return; }
        case symbolType::AssociateBlock: { v.visit_AssociateBlock((const AssociateBlock_t &)x); return; }
        case symbolType::Block: { v.visit_Block((const Block_t &)x); return; }
        case symbolType::Requirement: { v.visit_Requirement((const Requirement_t &)x); return; }
        case symbolType::Template: { v.visit_Template((const Template_t &)x); return; }
    }
}

template <class Visitor>
static void visit_stmt_t(const stmt_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::stmt)
    switch (x.type) {
        case stmtType::Allocate: { v.visit_Allocate((const Allocate_t &)x); return; }
        case stmtType::ReAlloc: { v.visit_ReAlloc((const ReAlloc_t &)x); return; }
        case stmtType::Assign: { v.visit_Assign((const Assign_t &)x); return; }
        case stmtType::Assignment: { v.visit_Assignment((const Assignment_t &)x); return; }
        case stmtType::Associate: { v.visit_Associate((const Associate_t &)x); return; }
        case stmtType::Cycle: { v.visit_Cycle((const Cycle_t &)x); return; }
        case stmtType::ExplicitDeallocate: { v.visit_ExplicitDeallocate((const ExplicitDeallocate_t &)x); return; }
        case stmtType::ImplicitDeallocate: { v.visit_ImplicitDeallocate((const ImplicitDeallocate_t &)x); return; }
        case stmtType::DoConcurrentLoop: { v.visit_DoConcurrentLoop((const DoConcurrentLoop_t &)x); return; }
        case stmtType::DoLoop: { v.visit_DoLoop((const DoLoop_t &)x); return; }
        case stmtType::ErrorStop: { v.visit_ErrorStop((const ErrorStop_t &)x); return; }
        case stmtType::Exit: { v.visit_Exit((const Exit_t &)x); return; }
        case stmtType::ForAllSingle: { v.visit_ForAllSingle((const ForAllSingle_t &)x); return; }
        case stmtType::GoTo: { v.visit_GoTo((const GoTo_t &)x); return; }
        case stmtType::GoToTarget: { v.visit_GoToTarget((const GoToTarget_t &)x); return; }
        case stmtType::If: { v.visit_If((const If_t &)x); return; }
        case stmtType::IfArithmetic: { v.visit_IfArithmetic((const IfArithmetic_t &)x); return; }
        case stmtType::Print: { v.visit_Print((const Print_t &)x); return; }
        case stmtType::FileOpen: { v.visit_FileOpen((const FileOpen_t &)x); return; }
        case stmtType::FileClose: { v.visit_FileClose((const FileClose_t &)x); return; }
        case stmtType::FileRead: { v.visit_FileRead((const FileRead_t &)x); return; }
        case stmtType::FileBackspace: { v.visit_FileBackspace((const FileBackspace_t &)x); return; }
        case stmtType::FileRewind: { v.visit_FileRewind((const FileRewind_t &)x); return; }
        case stmtType::FileInquire: { v.visit_FileInquire((const FileInquire_t &)x); return; }
        case stmtType::FileWrite: { v.visit_FileWrite((const FileWrite_t &)x); return; }
        case stmtType::Return: { v.visit_Return((const Return_t &)x); return; }
        case stmtType::Select: { v.visit_Select((const Select_t &)x); return; }
        case stmtType::Stop: { v.visit_Stop((const Stop_t &)x); return; }
        case stmtType::Assert: { v.visit_Assert((const Assert_t &)x); return; }
        case stmtType::SubroutineCall: { v.visit_SubroutineCall((const SubroutineCall_t &)x); return; }
        case stmtType::IntrinsicImpureSubroutine: { v.visit_IntrinsicImpureSubroutine((const IntrinsicImpureSubroutine_t &)x); return; }
        case stmtType::Where: { v.visit_Where((const Where_t &)x); return; }
        case stmtType::WhileLoop: { v.visit_WhileLoop((const WhileLoop_t &)x); return; }
        case stmtType::Nullify: { v.visit_Nullify((const Nullify_t &)x); return; }
        case stmtType::Flush: { v.visit_Flush((const Flush_t &)x); return; }
        case stmtType::ListAppend: { v.visit_ListAppend((const ListAppend_t &)x); return; }
        case stmtType::AssociateBlockCall: { v.visit_AssociateBlockCall((const AssociateBlockCall_t &)x); return; }
        case stmtType::SelectType: { v.visit_SelectType((const SelectType_t &)x); return; }
        case stmtType::CPtrToPointer: { v.visit_CPtrToPointer((const CPtrToPointer_t &)x); return; }
        case stmtType::BlockCall: { v.visit_BlockCall((const BlockCall_t &)x); return; }
        case stmtType::SetInsert: { v.visit_SetInsert((const SetInsert_t &)x); return; }
        case stmtType::SetRemove: { v.visit_SetRemove((const SetRemove_t &)x); return; }
        case stmtType::ListInsert: { v.visit_ListInsert((const ListInsert_t &)x); return; }
        case stmtType::ListRemove: { v.visit_ListRemove((const ListRemove_t &)x); return; }
        case stmtType::ListClear: { v.visit_ListClear((const ListClear_t &)x); return; }
        case stmtType::DictInsert: { v.visit_DictInsert((const DictInsert_t &)x); return; }
        case stmtType::Expr: { v.visit_Expr((const Expr_t &)x); return; }
    }
}

template <class Visitor>
static void visit_expr_t(const expr_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::expr)
    switch (x.type) {
        case exprType::IfExp: { v.visit_IfExp((const IfExp_t &)x); return; }
        case exprType::ComplexConstructor: { v.visit_ComplexConstructor((const ComplexConstructor_t &)x); return; }
        case exprType::NamedExpr: { v.visit_NamedExpr((const NamedExpr_t &)x); return; }
        case exprType::FunctionCall: { v.visit_FunctionCall((const FunctionCall_t &)x); return; }
        case exprType::IntrinsicElementalFunction: { v.visit_IntrinsicElementalFunction((const IntrinsicElementalFunction_t &)x); return; }
        case exprType::IntrinsicArrayFunction: { v.visit_IntrinsicArrayFunction((const IntrinsicArrayFunction_t &)x); return; }
        case exprType::IntrinsicImpureFunction: { v.visit_IntrinsicImpureFunction((const IntrinsicImpureFunction_t &)x); return; }
        case exprType::TypeInquiry: { v.visit_TypeInquiry((const TypeInquiry_t &)x); return; }
        case exprType::StructConstructor: { v.visit_StructConstructor((const StructConstructor_t &)x); return; }
        case exprType::EnumConstructor: { v.visit_EnumConstructor((const EnumConstructor_t &)x); return; }
        case exprType::UnionConstructor: { v.visit_UnionConstructor((const UnionConstructor_t &)x); return; }
        case exprType::ImpliedDoLoop: { v.visit_ImpliedDoLoop((const ImpliedDoLoop_t &)x); return; }
        case exprType::IntegerConstant: { v.visit_IntegerConstant((const IntegerConstant_t &)x); return; }
        case exprType::IntegerBitNot: { v.visit_IntegerBitNot((const IntegerBitNot_t &)x); return; }
        case exprType::IntegerUnaryMinus: { v.visit_IntegerUnaryMinus((const IntegerUnaryMinus_t &)x); return; }
        case exprType::IntegerCompare: { v.visit_IntegerCompare((const IntegerCompare_t &)x); return; }
        case exprType::IntegerBinOp: { v.visit_IntegerBinOp((const IntegerBinOp_t &)x); return; }
        case exprType::UnsignedIntegerConstant: { v.visit_UnsignedIntegerConstant((const UnsignedIntegerConstant_t &)x); return; }
        case exprType::UnsignedIntegerUnaryMinus: { v.visit_UnsignedIntegerUnaryMinus((const UnsignedIntegerUnaryMinus_t &)x); return; }
        case exprType::UnsignedIntegerBitNot: { v.visit_UnsignedIntegerBitNot((const UnsignedIntegerBitNot_t &)x); return; }
        case exprType::UnsignedIntegerCompare: { v.visit_UnsignedIntegerCompare((const UnsignedIntegerCompare_t &)x); return; }
        case exprType::UnsignedIntegerBinOp: { v.visit_UnsignedIntegerBinOp((const UnsignedIntegerBinOp_t &)x); return; }
        case exprType::RealConstant: { v.visit_RealConstant((const RealConstant_t &)x); return; }
        case exprType::RealUnaryMinus: { v.visit_RealUnaryMinus((const RealUnaryMinus_t &)x); return; }
        case exprType::RealCompare: { v.visit_RealCompare((const RealCompare_t &)x); return; }
        case exprType::RealBinOp: { v.visit_RealBinOp((const RealBinOp_t &)x); return; }
        case exprType::RealCopySign: { v.visit_RealCopySign((const RealCopySign_t &)x); return; }
        case exprType::ComplexConstant: { v.visit_ComplexConstant((const ComplexConstant_t &)x); return; }
        case exprType::ComplexUnaryMinus: { v.visit_ComplexUnaryMinus((const ComplexUnaryMinus_t &)x); return; }
        case exprType::ComplexCompare: { v.visit_ComplexCompare((const ComplexCompare_t &)x); return; }
        case exprType::ComplexBinOp: { v.visit_ComplexBinOp((const ComplexBinOp_t &)x); return; }
        case exprType::LogicalConstant: { v.visit_LogicalConstant((const LogicalConstant_t &)x); return; }
        case exprType::LogicalNot: { v.visit_LogicalNot((const LogicalNot_t &)x); return; }
        case exprType::LogicalCompare: { v.visit_LogicalCompare((const LogicalCompare_t &)x); return; }
        case exprType::LogicalBinOp: { v.visit_LogicalBinOp((const LogicalBinOp_t &)x); return; }
        case exprType::ListConstant: { v.visit_ListConstant((const ListConstant_t &)x); return; }
        case exprType::ListLen: { v.visit_ListLen((const ListLen_t &)x); return; }
        case exprType::ListConcat: { v.visit_ListConcat((const ListConcat_t &)x); return; }
        case exprType::ListCompare: { v.visit_ListCompare((const ListCompare_t &)x); return; }
        case exprType::ListCount: { v.visit_ListCount((const ListCount_t &)x); return; }
        case exprType::SetConstant: { v.visit_SetConstant((const SetConstant_t &)x); return; }
        case exprType::SetLen: { v.visit_SetLen((const SetLen_t &)x); return; }
        case exprType::TupleConstant: { v.visit_TupleConstant((const TupleConstant_t &)x); return; }
        case exprType::TupleLen: { v.visit_TupleLen((const TupleLen_t &)x); return; }
        case exprType::TupleCompare: { v.visit_TupleCompare((const TupleCompare_t &)x); return; }
        case exprType::TupleConcat: { v.visit_TupleConcat((const TupleConcat_t &)x); return; }
        case exprType::StringConstant: { v.visit_StringConstant((const StringConstant_t &)x); return; }
        case exprType::StringConcat: { v.visit_StringConcat((const StringConcat_t &)x); return; }
        case exprType::StringRepeat: { v.visit_StringRepeat((const StringRepeat_t &)x); return; }
        case exprType::StringLen: { v.visit_StringLen((const StringLen_t &)x); return; }
        case exprType::StringItem: { v.visit_StringItem((const StringItem_t &)x); return; }
        case exprType::StringSection: { v.visit_StringSection((const StringSection_t &)x); return; }
        case exprType::StringCompare: { v.visit_StringCompare((const StringCompare_t &)x); return; }
        case exprType::StringContains: { v.visit_StringContains((const StringContains_t &)x); return; }
        case exprType::StringOrd: { v.visit_StringOrd((const StringOrd_t &)x); return; }
        case exprType::StringChr: { v.visit_StringChr((const StringChr_t &)x); return; }
        case exprType::StringFormat: { v.visit_StringFormat((const StringFormat_t &)x); return; }
        case exprType::StringPhysicalCast: { v.visit_StringPhysicalCast((const StringPhysicalCast_t &)x); return; }
        case exprType::CPtrCompare: { v.visit_CPtrCompare((const CPtrCompare_t &)x); return; }
        case exprType::SymbolicCompare: { v.visit_SymbolicCompare((const SymbolicCompare_t &)x); return; }
        case exprType::DictConstant: { v.visit_DictConstant((const DictConstant_t &)x); return; }
        case exprType::DictLen: { v.visit_DictLen((const DictLen_t &)x); return; }
        case exprType::Var: { v.visit_Var((const Var_t &)x); return; }
        case exprType::FunctionParam: { v.visit_FunctionParam((const FunctionParam_t &)x); return; }
        case exprType::ArrayConstructor: { v.visit_ArrayConstructor((const ArrayConstructor_t &)x); return; }
        case exprType::ArrayConstant: { v.visit_ArrayConstant((const ArrayConstant_t &)x); return; }
        case exprType::ArrayItem: { v.visit_ArrayItem((const ArrayItem_t &)x); return; }
        case exprType::ArraySection: { v.visit_ArraySection((const ArraySection_t &)x); return; }
        case exprType::ArraySize: { v.visit_ArraySize((const ArraySize_t &)x); return; }
        case exprType::ArrayBound: { v.visit_ArrayBound((const ArrayBound_t &)x); return; }
        case exprType::ArrayTranspose: { v.visit_ArrayTranspose((const ArrayTranspose_t &)x); return; }
        case exprType::ArrayPack: { v.visit_ArrayPack((const ArrayPack_t &)x); return; }
        case exprType::ArrayReshape: { v.visit_ArrayReshape((const ArrayReshape_t &)x); return; }
        case exprType::ArrayBroadcast: { v.visit_ArrayBroadcast((const ArrayBroadcast_t &)x); return; }
        case exprType::BitCast: { v.visit_BitCast((const BitCast_t &)x); return; }
        case exprType::StructInstanceMember: { v.visit_StructInstanceMember((const StructInstanceMember_t &)x); return; }
        case exprType::StructStaticMember: { v.visit_StructStaticMember((const StructStaticMember_t &)x); return; }
        case exprType::EnumStaticMember: { v.visit_EnumStaticMember((const EnumStaticMember_t &)x); return; }
        case exprType::UnionInstanceMember: { v.visit_UnionInstanceMember((const UnionInstanceMember_t &)x); return; }
        case exprType::EnumName: { v.visit_EnumName((const EnumName_t &)x); return; }
        case exprType::EnumValue: { v.visit_EnumValue((const EnumValue_t &)x); return; }
        case exprType::OverloadedCompare: { v.visit_OverloadedCompare((const OverloadedCompare_t &)x); return; }
        case exprType::OverloadedBinOp: { v.visit_OverloadedBinOp((const OverloadedBinOp_t &)x); return; }
        case exprType::OverloadedUnaryMinus: { v.visit_OverloadedUnaryMinus((const OverloadedUnaryMinus_t &)x); return; }
        case exprType::OverloadedStringConcat: { v.visit_OverloadedStringConcat((const OverloadedStringConcat_t &)x); return; }
        case exprType::Cast: { v.visit_Cast((const Cast_t &)x); return; }
        case exprType::ArrayPhysicalCast: { v.visit_ArrayPhysicalCast((const ArrayPhysicalCast_t &)x); return; }
        case exprType::ComplexRe: { v.visit_ComplexRe((const ComplexRe_t &)x); return; }
        case exprType::ComplexIm: { v.visit_ComplexIm((const ComplexIm_t &)x); return; }
        case exprType::DictItem: { v.visit_DictItem((const DictItem_t &)x); return; }
        case exprType::CLoc: { v.visit_CLoc((const CLoc_t &)x); return; }
        case exprType::PointerToCPtr: { v.visit_PointerToCPtr((const PointerToCPtr_t &)x); return; }
        case exprType::GetPointer: { v.visit_GetPointer((const GetPointer_t &)x); return; }
        case exprType::ListItem: { v.visit_ListItem((const ListItem_t &)x); return; }
        case exprType::TupleItem: { v.visit_TupleItem((const TupleItem_t &)x); return; }
        case exprType::ListSection: { v.visit_ListSection((const ListSection_t &)x); return; }
        case exprType::ListRepeat: { v.visit_ListRepeat((const ListRepeat_t &)x); return; }
        case exprType::DictPop: { v.visit_DictPop((const DictPop_t &)x); return; }
        case exprType::SetPop: { v.visit_SetPop((const SetPop_t &)x); return; }
        case exprType::IntegerBitLen: { v.visit_IntegerBitLen((const IntegerBitLen_t &)x); return; }
        case exprType::Ichar: { v.visit_Ichar((const Ichar_t &)x); return; }
        case exprType::Iachar: { v.visit_Iachar((const Iachar_t &)x); return; }
        case exprType::SizeOfType: { v.visit_SizeOfType((const SizeOfType_t &)x); return; }
        case exprType::PointerNullConstant: { v.visit_PointerNullConstant((const PointerNullConstant_t &)x); return; }
        case exprType::PointerAssociated: { v.visit_PointerAssociated((const PointerAssociated_t &)x); return; }
        case exprType::RealSqrt: { v.visit_RealSqrt((const RealSqrt_t &)x); return; }
    }
}

template <class Visitor>
static void visit_ttype_t(const ttype_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::ttype)
    switch (x.type) {
        case ttypeType::Integer: { v.visit_Integer((const Integer_t &)x); return; }
        case ttypeType::UnsignedInteger: { v.visit_UnsignedInteger((const UnsignedInteger_t &)x); return; }
        case ttypeType::Real: { v.visit_Real((const Real_t &)x); return; }
        case ttypeType::Complex: { v.visit_Complex((const Complex_t &)x); return; }
        case ttypeType::String: { v.visit_String((const String_t &)x); return; }
        case ttypeType::Logical: { v.visit_Logical((const Logical_t &)x); return; }
        case ttypeType::Set: { v.visit_Set((const Set_t &)x); return; }
        case ttypeType::List: { v.visit_List((const List_t &)x); return; }
        case ttypeType::Tuple: { v.visit_Tuple((const Tuple_t &)x); return; }
        case ttypeType::StructType: { v.visit_StructType((const StructType_t &)x); return; }
        case ttypeType::EnumType: { v.visit_EnumType((const EnumType_t &)x); return; }
        case ttypeType::UnionType: { v.visit_UnionType((const UnionType_t &)x); return; }
        case ttypeType::ClassType: { v.visit_ClassType((const ClassType_t &)x); return; }
        case ttypeType::Dict: { v.visit_Dict((const Dict_t &)x); return; }
        case ttypeType::Pointer: { v.visit_Pointer((const Pointer_t &)x); return; }
        case ttypeType::Allocatable: { v.visit_Allocatable((const Allocatable_t &)x); return; }
        case ttypeType::CPtr: { v.visit_CPtr((const CPtr_t &)x); return; }
        case ttypeType::SymbolicExpression: { v.visit_SymbolicExpression((const SymbolicExpression_t &)x); return; }
        case ttypeType::TypeParameter: { v.visit_TypeParameter((const TypeParameter_t &)x); return; }
        case ttypeType::Array: { v.visit_Array((const Array_t &)x); return; }
        case ttypeType::FunctionType: { v.visit_FunctionType((const FunctionType_t &)x); return; }
    }
}

template <class Visitor>
static void visit_attribute_t(const attribute_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::attribute)
    switch (x.type) {
        case attributeType::Attribute: { v.visit_Attribute((const Attribute_t &)x); return; }
    }
}

template <class Visitor>
static void visit_tbind_t(const tbind_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::tbind)
    switch (x.type) {
        case tbindType::Bind: { v.visit_Bind((const Bind_t &)x); return; }
    }
}

template <class Visitor>
static void visit_case_stmt_t(const case_stmt_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::case_stmt)
    switch (x.type) {
        case case_stmtType::CaseStmt: { v.visit_CaseStmt((const CaseStmt_t &)x); return; }
        case case_stmtType::CaseStmt_Range: { v.visit_CaseStmt_Range((const CaseStmt_Range_t &)x); return; }
    }
}

template <class Visitor>
static void visit_type_stmt_t(const type_stmt_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::type_stmt)
    switch (x.type) {
        case type_stmtType::TypeStmtName: { v.visit_TypeStmtName((const TypeStmtName_t &)x); return; }
        case type_stmtType::ClassStmt: { v.visit_ClassStmt((const ClassStmt_t &)x); return; }
        case type_stmtType::TypeStmtType: { v.visit_TypeStmtType((const TypeStmtType_t &)x); return; }
    }
}

template <class Visitor>
static void visit_require_instantiation_t(const require_instantiation_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::require_instantiation)
    switch (x.type) {
        case require_instantiationType::Require: { v.visit_Require((const Require_t &)x); return; }
    }
}



template <class Visitor>
static void visit_asr_t(const asr_t &x, Visitor &v) {
    switch (x.type) {
        case asrType::unit: { v.visit_unit((const unit_t &)x); return; }
        case asrType::symbol: { v.visit_symbol((const symbol_t &)x); return; }
        case asrType::stmt: { v.visit_stmt((const stmt_t &)x); return; }
        case asrType::expr: { v.visit_expr((const expr_t &)x); return; }
        case asrType::ttype: { v.visit_ttype((const ttype_t &)x); return; }
        case asrType::attribute: { v.visit_attribute((const attribute_t &)x); return; }
        case asrType::tbind: { v.visit_tbind((const tbind_t &)x); return; }
        case asrType::case_stmt: { v.visit_case_stmt((const case_stmt_t &)x); return; }
        case asrType::type_stmt: { v.visit_type_stmt((const type_stmt_t &)x); return; }
        case asrType::require_instantiation: { v.visit_require_instantiation((const require_instantiation_t &)x); return; }
    }
}



/******************************************************************************/
// Visitor base class

template <class StructType>
class BaseVisitor
{
private:
    StructType& self() { return static_cast<StructType&>(*this); }
public:
    void visit_asr(const asr_t &b) { visit_asr_t(b, self()); }
    void visit_unit(const unit_t &b) { visit_unit_t(b, self()); }
        void visit_TranslationUnit(const TranslationUnit_t & /* x */) { throw LCompilersException("visit_TranslationUnit() not implemented"); }
    void visit_symbol(const symbol_t &b) { visit_symbol_t(b, self()); }
        void visit_Program(const Program_t & /* x */) { throw LCompilersException("visit_Program() not implemented"); }
        void visit_Module(const Module_t & /* x */) { throw LCompilersException("visit_Module() not implemented"); }
        void visit_Function(const Function_t & /* x */) { throw LCompilersException("visit_Function() not implemented"); }
        void visit_GenericProcedure(const GenericProcedure_t & /* x */) { throw LCompilersException("visit_GenericProcedure() not implemented"); }
        void visit_CustomOperator(const CustomOperator_t & /* x */) { throw LCompilersException("visit_CustomOperator() not implemented"); }
        void visit_ExternalSymbol(const ExternalSymbol_t & /* x */) { throw LCompilersException("visit_ExternalSymbol() not implemented"); }
        void visit_Struct(const Struct_t & /* x */) { throw LCompilersException("visit_Struct() not implemented"); }
        void visit_Enum(const Enum_t & /* x */) { throw LCompilersException("visit_Enum() not implemented"); }
        void visit_Union(const Union_t & /* x */) { throw LCompilersException("visit_Union() not implemented"); }
        void visit_Variable(const Variable_t & /* x */) { throw LCompilersException("visit_Variable() not implemented"); }
        void visit_Class(const Class_t & /* x */) { throw LCompilersException("visit_Class() not implemented"); }
        void visit_ClassProcedure(const ClassProcedure_t & /* x */) { throw LCompilersException("visit_ClassProcedure() not implemented"); }
        void visit_AssociateBlock(const AssociateBlock_t & /* x */) { throw LCompilersException("visit_AssociateBlock() not implemented"); }
        void visit_Block(const Block_t & /* x */) { throw LCompilersException("visit_Block() not implemented"); }
        void visit_Requirement(const Requirement_t & /* x */) { throw LCompilersException("visit_Requirement() not implemented"); }
        void visit_Template(const Template_t & /* x */) { throw LCompilersException("visit_Template() not implemented"); }
    void visit_stmt(const stmt_t &b) { visit_stmt_t(b, self()); }
        void visit_Allocate(const Allocate_t & /* x */) { throw LCompilersException("visit_Allocate() not implemented"); }
        void visit_ReAlloc(const ReAlloc_t & /* x */) { throw LCompilersException("visit_ReAlloc() not implemented"); }
        void visit_Assign(const Assign_t & /* x */) { throw LCompilersException("visit_Assign() not implemented"); }
        void visit_Assignment(const Assignment_t & /* x */) { throw LCompilersException("visit_Assignment() not implemented"); }
        void visit_Associate(const Associate_t & /* x */) { throw LCompilersException("visit_Associate() not implemented"); }
        void visit_Cycle(const Cycle_t & /* x */) { throw LCompilersException("visit_Cycle() not implemented"); }
        void visit_ExplicitDeallocate(const ExplicitDeallocate_t & /* x */) { throw LCompilersException("visit_ExplicitDeallocate() not implemented"); }
        void visit_ImplicitDeallocate(const ImplicitDeallocate_t & /* x */) { throw LCompilersException("visit_ImplicitDeallocate() not implemented"); }
        void visit_DoConcurrentLoop(const DoConcurrentLoop_t & /* x */) { throw LCompilersException("visit_DoConcurrentLoop() not implemented"); }
        void visit_DoLoop(const DoLoop_t & /* x */) { throw LCompilersException("visit_DoLoop() not implemented"); }
        void visit_ErrorStop(const ErrorStop_t & /* x */) { throw LCompilersException("visit_ErrorStop() not implemented"); }
        void visit_Exit(const Exit_t & /* x */) { throw LCompilersException("visit_Exit() not implemented"); }
        void visit_ForAllSingle(const ForAllSingle_t & /* x */) { throw LCompilersException("visit_ForAllSingle() not implemented"); }
        void visit_GoTo(const GoTo_t & /* x */) { throw LCompilersException("visit_GoTo() not implemented"); }
        void visit_GoToTarget(const GoToTarget_t & /* x */) { throw LCompilersException("visit_GoToTarget() not implemented"); }
        void visit_If(const If_t & /* x */) { throw LCompilersException("visit_If() not implemented"); }
        void visit_IfArithmetic(const IfArithmetic_t & /* x */) { throw LCompilersException("visit_IfArithmetic() not implemented"); }
        void visit_Print(const Print_t & /* x */) { throw LCompilersException("visit_Print() not implemented"); }
        void visit_FileOpen(const FileOpen_t & /* x */) { throw LCompilersException("visit_FileOpen() not implemented"); }
        void visit_FileClose(const FileClose_t & /* x */) { throw LCompilersException("visit_FileClose() not implemented"); }
        void visit_FileRead(const FileRead_t & /* x */) { throw LCompilersException("visit_FileRead() not implemented"); }
        void visit_FileBackspace(const FileBackspace_t & /* x */) { throw LCompilersException("visit_FileBackspace() not implemented"); }
        void visit_FileRewind(const FileRewind_t & /* x */) { throw LCompilersException("visit_FileRewind() not implemented"); }
        void visit_FileInquire(const FileInquire_t & /* x */) { throw LCompilersException("visit_FileInquire() not implemented"); }
        void visit_FileWrite(const FileWrite_t & /* x */) { throw LCompilersException("visit_FileWrite() not implemented"); }
        void visit_Return(const Return_t & /* x */) { throw LCompilersException("visit_Return() not implemented"); }
        void visit_Select(const Select_t & /* x */) { throw LCompilersException("visit_Select() not implemented"); }
        void visit_Stop(const Stop_t & /* x */) { throw LCompilersException("visit_Stop() not implemented"); }
        void visit_Assert(const Assert_t & /* x */) { throw LCompilersException("visit_Assert() not implemented"); }
        void visit_SubroutineCall(const SubroutineCall_t & /* x */) { throw LCompilersException("visit_SubroutineCall() not implemented"); }
        void visit_IntrinsicImpureSubroutine(const IntrinsicImpureSubroutine_t & /* x */) { throw LCompilersException("visit_IntrinsicImpureSubroutine() not implemented"); }
        void visit_Where(const Where_t & /* x */) { throw LCompilersException("visit_Where() not implemented"); }
        void visit_WhileLoop(const WhileLoop_t & /* x */) { throw LCompilersException("visit_WhileLoop() not implemented"); }
        void visit_Nullify(const Nullify_t & /* x */) { throw LCompilersException("visit_Nullify() not implemented"); }
        void visit_Flush(const Flush_t & /* x */) { throw LCompilersException("visit_Flush() not implemented"); }
        void visit_ListAppend(const ListAppend_t & /* x */) { throw LCompilersException("visit_ListAppend() not implemented"); }
        void visit_AssociateBlockCall(const AssociateBlockCall_t & /* x */) { throw LCompilersException("visit_AssociateBlockCall() not implemented"); }
        void visit_SelectType(const SelectType_t & /* x */) { throw LCompilersException("visit_SelectType() not implemented"); }
        void visit_CPtrToPointer(const CPtrToPointer_t & /* x */) { throw LCompilersException("visit_CPtrToPointer() not implemented"); }
        void visit_BlockCall(const BlockCall_t & /* x */) { throw LCompilersException("visit_BlockCall() not implemented"); }
        void visit_SetInsert(const SetInsert_t & /* x */) { throw LCompilersException("visit_SetInsert() not implemented"); }
        void visit_SetRemove(const SetRemove_t & /* x */) { throw LCompilersException("visit_SetRemove() not implemented"); }
        void visit_ListInsert(const ListInsert_t & /* x */) { throw LCompilersException("visit_ListInsert() not implemented"); }
        void visit_ListRemove(const ListRemove_t & /* x */) { throw LCompilersException("visit_ListRemove() not implemented"); }
        void visit_ListClear(const ListClear_t & /* x */) { throw LCompilersException("visit_ListClear() not implemented"); }
        void visit_DictInsert(const DictInsert_t & /* x */) { throw LCompilersException("visit_DictInsert() not implemented"); }
        void visit_Expr(const Expr_t & /* x */) { throw LCompilersException("visit_Expr() not implemented"); }
    void visit_expr(const expr_t &b) { visit_expr_t(b, self()); }
        void visit_IfExp(const IfExp_t & /* x */) { throw LCompilersException("visit_IfExp() not implemented"); }
        void visit_ComplexConstructor(const ComplexConstructor_t & /* x */) { throw LCompilersException("visit_ComplexConstructor() not implemented"); }
        void visit_NamedExpr(const NamedExpr_t & /* x */) { throw LCompilersException("visit_NamedExpr() not implemented"); }
        void visit_FunctionCall(const FunctionCall_t & /* x */) { throw LCompilersException("visit_FunctionCall() not implemented"); }
        void visit_IntrinsicElementalFunction(const IntrinsicElementalFunction_t & /* x */) { throw LCompilersException("visit_IntrinsicElementalFunction() not implemented"); }
        void visit_IntrinsicArrayFunction(const IntrinsicArrayFunction_t & /* x */) { throw LCompilersException("visit_IntrinsicArrayFunction() not implemented"); }
        void visit_IntrinsicImpureFunction(const IntrinsicImpureFunction_t & /* x */) { throw LCompilersException("visit_IntrinsicImpureFunction() not implemented"); }
        void visit_TypeInquiry(const TypeInquiry_t & /* x */) { throw LCompilersException("visit_TypeInquiry() not implemented"); }
        void visit_StructConstructor(const StructConstructor_t & /* x */) { throw LCompilersException("visit_StructConstructor() not implemented"); }
        void visit_EnumConstructor(const EnumConstructor_t & /* x */) { throw LCompilersException("visit_EnumConstructor() not implemented"); }
        void visit_UnionConstructor(const UnionConstructor_t & /* x */) { throw LCompilersException("visit_UnionConstructor() not implemented"); }
        void visit_ImpliedDoLoop(const ImpliedDoLoop_t & /* x */) { throw LCompilersException("visit_ImpliedDoLoop() not implemented"); }
        void visit_IntegerConstant(const IntegerConstant_t & /* x */) { throw LCompilersException("visit_IntegerConstant() not implemented"); }
        void visit_IntegerBitNot(const IntegerBitNot_t & /* x */) { throw LCompilersException("visit_IntegerBitNot() not implemented"); }
        void visit_IntegerUnaryMinus(const IntegerUnaryMinus_t & /* x */) { throw LCompilersException("visit_IntegerUnaryMinus() not implemented"); }
        void visit_IntegerCompare(const IntegerCompare_t & /* x */) { throw LCompilersException("visit_IntegerCompare() not implemented"); }
        void visit_IntegerBinOp(const IntegerBinOp_t & /* x */) { throw LCompilersException("visit_IntegerBinOp() not implemented"); }
        void visit_UnsignedIntegerConstant(const UnsignedIntegerConstant_t & /* x */) { throw LCompilersException("visit_UnsignedIntegerConstant() not implemented"); }
        void visit_UnsignedIntegerUnaryMinus(const UnsignedIntegerUnaryMinus_t & /* x */) { throw LCompilersException("visit_UnsignedIntegerUnaryMinus() not implemented"); }
        void visit_UnsignedIntegerBitNot(const UnsignedIntegerBitNot_t & /* x */) { throw LCompilersException("visit_UnsignedIntegerBitNot() not implemented"); }
        void visit_UnsignedIntegerCompare(const UnsignedIntegerCompare_t & /* x */) { throw LCompilersException("visit_UnsignedIntegerCompare() not implemented"); }
        void visit_UnsignedIntegerBinOp(const UnsignedIntegerBinOp_t & /* x */) { throw LCompilersException("visit_UnsignedIntegerBinOp() not implemented"); }
        void visit_RealConstant(const RealConstant_t & /* x */) { throw LCompilersException("visit_RealConstant() not implemented"); }
        void visit_RealUnaryMinus(const RealUnaryMinus_t & /* x */) { throw LCompilersException("visit_RealUnaryMinus() not implemented"); }
        void visit_RealCompare(const RealCompare_t & /* x */) { throw LCompilersException("visit_RealCompare() not implemented"); }
        void visit_RealBinOp(const RealBinOp_t & /* x */) { throw LCompilersException("visit_RealBinOp() not implemented"); }
        void visit_RealCopySign(const RealCopySign_t & /* x */) { throw LCompilersException("visit_RealCopySign() not implemented"); }
        void visit_ComplexConstant(const ComplexConstant_t & /* x */) { throw LCompilersException("visit_ComplexConstant() not implemented"); }
        void visit_ComplexUnaryMinus(const ComplexUnaryMinus_t & /* x */) { throw LCompilersException("visit_ComplexUnaryMinus() not implemented"); }
        void visit_ComplexCompare(const ComplexCompare_t & /* x */) { throw LCompilersException("visit_ComplexCompare() not implemented"); }
        void visit_ComplexBinOp(const ComplexBinOp_t & /* x */) { throw LCompilersException("visit_ComplexBinOp() not implemented"); }
        void visit_LogicalConstant(const LogicalConstant_t & /* x */) { throw LCompilersException("visit_LogicalConstant() not implemented"); }
        void visit_LogicalNot(const LogicalNot_t & /* x */) { throw LCompilersException("visit_LogicalNot() not implemented"); }
        void visit_LogicalCompare(const LogicalCompare_t & /* x */) { throw LCompilersException("visit_LogicalCompare() not implemented"); }
        void visit_LogicalBinOp(const LogicalBinOp_t & /* x */) { throw LCompilersException("visit_LogicalBinOp() not implemented"); }
        void visit_ListConstant(const ListConstant_t & /* x */) { throw LCompilersException("visit_ListConstant() not implemented"); }
        void visit_ListLen(const ListLen_t & /* x */) { throw LCompilersException("visit_ListLen() not implemented"); }
        void visit_ListConcat(const ListConcat_t & /* x */) { throw LCompilersException("visit_ListConcat() not implemented"); }
        void visit_ListCompare(const ListCompare_t & /* x */) { throw LCompilersException("visit_ListCompare() not implemented"); }
        void visit_ListCount(const ListCount_t & /* x */) { throw LCompilersException("visit_ListCount() not implemented"); }
        void visit_SetConstant(const SetConstant_t & /* x */) { throw LCompilersException("visit_SetConstant() not implemented"); }
        void visit_SetLen(const SetLen_t & /* x */) { throw LCompilersException("visit_SetLen() not implemented"); }
        void visit_TupleConstant(const TupleConstant_t & /* x */) { throw LCompilersException("visit_TupleConstant() not implemented"); }
        void visit_TupleLen(const TupleLen_t & /* x */) { throw LCompilersException("visit_TupleLen() not implemented"); }
        void visit_TupleCompare(const TupleCompare_t & /* x */) { throw LCompilersException("visit_TupleCompare() not implemented"); }
        void visit_TupleConcat(const TupleConcat_t & /* x */) { throw LCompilersException("visit_TupleConcat() not implemented"); }
        void visit_StringConstant(const StringConstant_t & /* x */) { throw LCompilersException("visit_StringConstant() not implemented"); }
        void visit_StringConcat(const StringConcat_t & /* x */) { throw LCompilersException("visit_StringConcat() not implemented"); }
        void visit_StringRepeat(const StringRepeat_t & /* x */) { throw LCompilersException("visit_StringRepeat() not implemented"); }
        void visit_StringLen(const StringLen_t & /* x */) { throw LCompilersException("visit_StringLen() not implemented"); }
        void visit_StringItem(const StringItem_t & /* x */) { throw LCompilersException("visit_StringItem() not implemented"); }
        void visit_StringSection(const StringSection_t & /* x */) { throw LCompilersException("visit_StringSection() not implemented"); }
        void visit_StringCompare(const StringCompare_t & /* x */) { throw LCompilersException("visit_StringCompare() not implemented"); }
        void visit_StringContains(const StringContains_t & /* x */) { throw LCompilersException("visit_StringContains() not implemented"); }
        void visit_StringOrd(const StringOrd_t & /* x */) { throw LCompilersException("visit_StringOrd() not implemented"); }
        void visit_StringChr(const StringChr_t & /* x */) { throw LCompilersException("visit_StringChr() not implemented"); }
        void visit_StringFormat(const StringFormat_t & /* x */) { throw LCompilersException("visit_StringFormat() not implemented"); }
        void visit_StringPhysicalCast(const StringPhysicalCast_t & /* x */) { throw LCompilersException("visit_StringPhysicalCast() not implemented"); }
        void visit_CPtrCompare(const CPtrCompare_t & /* x */) { throw LCompilersException("visit_CPtrCompare() not implemented"); }
        void visit_SymbolicCompare(const SymbolicCompare_t & /* x */) { throw LCompilersException("visit_SymbolicCompare() not implemented"); }
        void visit_DictConstant(const DictConstant_t & /* x */) { throw LCompilersException("visit_DictConstant() not implemented"); }
        void visit_DictLen(const DictLen_t & /* x */) { throw LCompilersException("visit_DictLen() not implemented"); }
        void visit_Var(const Var_t & /* x */) { throw LCompilersException("visit_Var() not implemented"); }
        void visit_FunctionParam(const FunctionParam_t & /* x */) { throw LCompilersException("visit_FunctionParam() not implemented"); }
        void visit_ArrayConstructor(const ArrayConstructor_t & /* x */) { throw LCompilersException("visit_ArrayConstructor() not implemented"); }
        void visit_ArrayConstant(const ArrayConstant_t & /* x */) { throw LCompilersException("visit_ArrayConstant() not implemented"); }
        void visit_ArrayItem(const ArrayItem_t & /* x */) { throw LCompilersException("visit_ArrayItem() not implemented"); }
        void visit_ArraySection(const ArraySection_t & /* x */) { throw LCompilersException("visit_ArraySection() not implemented"); }
        void visit_ArraySize(const ArraySize_t & /* x */) { throw LCompilersException("visit_ArraySize() not implemented"); }
        void visit_ArrayBound(const ArrayBound_t & /* x */) { throw LCompilersException("visit_ArrayBound() not implemented"); }
        void visit_ArrayTranspose(const ArrayTranspose_t & /* x */) { throw LCompilersException("visit_ArrayTranspose() not implemented"); }
        void visit_ArrayPack(const ArrayPack_t & /* x */) { throw LCompilersException("visit_ArrayPack() not implemented"); }
        void visit_ArrayReshape(const ArrayReshape_t & /* x */) { throw LCompilersException("visit_ArrayReshape() not implemented"); }
        void visit_ArrayBroadcast(const ArrayBroadcast_t & /* x */) { throw LCompilersException("visit_ArrayBroadcast() not implemented"); }
        void visit_BitCast(const BitCast_t & /* x */) { throw LCompilersException("visit_BitCast() not implemented"); }
        void visit_StructInstanceMember(const StructInstanceMember_t & /* x */) { throw LCompilersException("visit_StructInstanceMember() not implemented"); }
        void visit_StructStaticMember(const StructStaticMember_t & /* x */) { throw LCompilersException("visit_StructStaticMember() not implemented"); }
        void visit_EnumStaticMember(const EnumStaticMember_t & /* x */) { throw LCompilersException("visit_EnumStaticMember() not implemented"); }
        void visit_UnionInstanceMember(const UnionInstanceMember_t & /* x */) { throw LCompilersException("visit_UnionInstanceMember() not implemented"); }
        void visit_EnumName(const EnumName_t & /* x */) { throw LCompilersException("visit_EnumName() not implemented"); }
        void visit_EnumValue(const EnumValue_t & /* x */) { throw LCompilersException("visit_EnumValue() not implemented"); }
        void visit_OverloadedCompare(const OverloadedCompare_t & /* x */) { throw LCompilersException("visit_OverloadedCompare() not implemented"); }
        void visit_OverloadedBinOp(const OverloadedBinOp_t & /* x */) { throw LCompilersException("visit_OverloadedBinOp() not implemented"); }
        void visit_OverloadedUnaryMinus(const OverloadedUnaryMinus_t & /* x */) { throw LCompilersException("visit_OverloadedUnaryMinus() not implemented"); }
        void visit_OverloadedStringConcat(const OverloadedStringConcat_t & /* x */) { throw LCompilersException("visit_OverloadedStringConcat() not implemented"); }
        void visit_Cast(const Cast_t & /* x */) { throw LCompilersException("visit_Cast() not implemented"); }
        void visit_ArrayPhysicalCast(const ArrayPhysicalCast_t & /* x */) { throw LCompilersException("visit_ArrayPhysicalCast() not implemented"); }
        void visit_ComplexRe(const ComplexRe_t & /* x */) { throw LCompilersException("visit_ComplexRe() not implemented"); }
        void visit_ComplexIm(const ComplexIm_t & /* x */) { throw LCompilersException("visit_ComplexIm() not implemented"); }
        void visit_DictItem(const DictItem_t & /* x */) { throw LCompilersException("visit_DictItem() not implemented"); }
        void visit_CLoc(const CLoc_t & /* x */) { throw LCompilersException("visit_CLoc() not implemented"); }
        void visit_PointerToCPtr(const PointerToCPtr_t & /* x */) { throw LCompilersException("visit_PointerToCPtr() not implemented"); }
        void visit_GetPointer(const GetPointer_t & /* x */) { throw LCompilersException("visit_GetPointer() not implemented"); }
        void visit_ListItem(const ListItem_t & /* x */) { throw LCompilersException("visit_ListItem() not implemented"); }
        void visit_TupleItem(const TupleItem_t & /* x */) { throw LCompilersException("visit_TupleItem() not implemented"); }
        void visit_ListSection(const ListSection_t & /* x */) { throw LCompilersException("visit_ListSection() not implemented"); }
        void visit_ListRepeat(const ListRepeat_t & /* x */) { throw LCompilersException("visit_ListRepeat() not implemented"); }
        void visit_DictPop(const DictPop_t & /* x */) { throw LCompilersException("visit_DictPop() not implemented"); }
        void visit_SetPop(const SetPop_t & /* x */) { throw LCompilersException("visit_SetPop() not implemented"); }
        void visit_IntegerBitLen(const IntegerBitLen_t & /* x */) { throw LCompilersException("visit_IntegerBitLen() not implemented"); }
        void visit_Ichar(const Ichar_t & /* x */) { throw LCompilersException("visit_Ichar() not implemented"); }
        void visit_Iachar(const Iachar_t & /* x */) { throw LCompilersException("visit_Iachar() not implemented"); }
        void visit_SizeOfType(const SizeOfType_t & /* x */) { throw LCompilersException("visit_SizeOfType() not implemented"); }
        void visit_PointerNullConstant(const PointerNullConstant_t & /* x */) { throw LCompilersException("visit_PointerNullConstant() not implemented"); }
        void visit_PointerAssociated(const PointerAssociated_t & /* x */) { throw LCompilersException("visit_PointerAssociated() not implemented"); }
        void visit_RealSqrt(const RealSqrt_t & /* x */) { throw LCompilersException("visit_RealSqrt() not implemented"); }
    void visit_ttype(const ttype_t &b) { visit_ttype_t(b, self()); }
        void visit_Integer(const Integer_t & /* x */) { throw LCompilersException("visit_Integer() not implemented"); }
        void visit_UnsignedInteger(const UnsignedInteger_t & /* x */) { throw LCompilersException("visit_UnsignedInteger() not implemented"); }
        void visit_Real(const Real_t & /* x */) { throw LCompilersException("visit_Real() not implemented"); }
        void visit_Complex(const Complex_t & /* x */) { throw LCompilersException("visit_Complex() not implemented"); }
        void visit_String(const String_t & /* x */) { throw LCompilersException("visit_String() not implemented"); }
        void visit_Logical(const Logical_t & /* x */) { throw LCompilersException("visit_Logical() not implemented"); }
        void visit_Set(const Set_t & /* x */) { throw LCompilersException("visit_Set() not implemented"); }
        void visit_List(const List_t & /* x */) { throw LCompilersException("visit_List() not implemented"); }
        void visit_Tuple(const Tuple_t & /* x */) { throw LCompilersException("visit_Tuple() not implemented"); }
        void visit_StructType(const StructType_t & /* x */) { throw LCompilersException("visit_StructType() not implemented"); }
        void visit_EnumType(const EnumType_t & /* x */) { throw LCompilersException("visit_EnumType() not implemented"); }
        void visit_UnionType(const UnionType_t & /* x */) { throw LCompilersException("visit_UnionType() not implemented"); }
        void visit_ClassType(const ClassType_t & /* x */) { throw LCompilersException("visit_ClassType() not implemented"); }
        void visit_Dict(const Dict_t & /* x */) { throw LCompilersException("visit_Dict() not implemented"); }
        void visit_Pointer(const Pointer_t & /* x */) { throw LCompilersException("visit_Pointer() not implemented"); }
        void visit_Allocatable(const Allocatable_t & /* x */) { throw LCompilersException("visit_Allocatable() not implemented"); }
        void visit_CPtr(const CPtr_t & /* x */) { throw LCompilersException("visit_CPtr() not implemented"); }
        void visit_SymbolicExpression(const SymbolicExpression_t & /* x */) { throw LCompilersException("visit_SymbolicExpression() not implemented"); }
        void visit_TypeParameter(const TypeParameter_t & /* x */) { throw LCompilersException("visit_TypeParameter() not implemented"); }
        void visit_Array(const Array_t & /* x */) { throw LCompilersException("visit_Array() not implemented"); }
        void visit_FunctionType(const FunctionType_t & /* x */) { throw LCompilersException("visit_FunctionType() not implemented"); }
    void visit_attribute(const attribute_t &b) { visit_attribute_t(b, self()); }
        void visit_Attribute(const Attribute_t & /* x */) { throw LCompilersException("visit_Attribute() not implemented"); }
    void visit_tbind(const tbind_t &b) { visit_tbind_t(b, self()); }
        void visit_Bind(const Bind_t & /* x */) { throw LCompilersException("visit_Bind() not implemented"); }
    void visit_case_stmt(const case_stmt_t &b) { visit_case_stmt_t(b, self()); }
        void visit_CaseStmt(const CaseStmt_t & /* x */) { throw LCompilersException("visit_CaseStmt() not implemented"); }
        void visit_CaseStmt_Range(const CaseStmt_Range_t & /* x */) { throw LCompilersException("visit_CaseStmt_Range() not implemented"); }
    void visit_type_stmt(const type_stmt_t &b) { visit_type_stmt_t(b, self()); }
        void visit_TypeStmtName(const TypeStmtName_t & /* x */) { throw LCompilersException("visit_TypeStmtName() not implemented"); }
        void visit_ClassStmt(const ClassStmt_t & /* x */) { throw LCompilersException("visit_ClassStmt() not implemented"); }
        void visit_TypeStmtType(const TypeStmtType_t & /* x */) { throw LCompilersException("visit_TypeStmtType() not implemented"); }
    void visit_require_instantiation(const require_instantiation_t &b) { visit_require_instantiation_t(b, self()); }
        void visit_Require(const Require_t & /* x */) { throw LCompilersException("visit_Require() not implemented"); }
};


}
