--
--  Copyright (C) 2014-2022, AdaCore
--  SPDX-License-Identifier: Apache-2.0
--

with Ada.Unchecked_Deallocation;

with Langkit_Support.Generic_API; use Langkit_Support.Generic_API;
pragma Warnings (Off, "referenced");
with Langkit_Support.Generic_API.Analysis;
use Langkit_Support.Generic_API.Analysis;
pragma Warnings (On, "referenced");
with Langkit_Support.Generic_API.Introspection;
use Langkit_Support.Generic_API.Introspection;
with Langkit_Support.Internal.Introspection;
use Langkit_Support.Internal.Introspection;
with Langkit_Support.Text;        use Langkit_Support.Text;

with Libadalang.Analysis; use Libadalang.Analysis;
with Libadalang.Common;   use Libadalang.Common;

--  This package provides description tables to enable the generic
--  introspection API in Langkit_Support to work with this Langkit-generated
--  library.

private package Libadalang.Generic_Introspection is

   

   --------------------------
   -- Type index constants --
   --------------------------

      Type_Index_For_Analysis_Unit : constant Type_Index := 1;
      Type_Index_For_Big_Int : constant Type_Index := 2;
      Type_Index_For_Bool : constant Type_Index := 3;
      Type_Index_For_Character : constant Type_Index := 4;
      Type_Index_For_Int : constant Type_Index := 5;
      Type_Index_For_Source_Location_Range : constant Type_Index := 6;
      Type_Index_For_String : constant Type_Index := 7;
      Type_Index_For_Token : constant Type_Index := 8;
      Type_Index_For_Symbol : constant Type_Index := 9;
      Type_Index_For_Analysis_Unit_Kind : constant Type_Index := 10;
      Type_Index_For_Lookup_Kind : constant Type_Index := 11;
      Type_Index_For_Designated_Env_Kind : constant Type_Index := 12;
      Type_Index_For_Ref_Result_Kind : constant Type_Index := 13;
      Type_Index_For_Call_Expr_Kind : constant Type_Index := 14;
      Type_Index_For_Grammar_Rule : constant Type_Index := 15;
      Type_Index_For_Discriminant_Values_Array : constant Type_Index := 16;
      Type_Index_For_Doc_Annotation_Array : constant Type_Index := 17;
      Type_Index_For_Accept_Stmt_Array : constant Type_Index := 18;
      Type_Index_For_Ada_Node_Array : constant Type_Index := 19;
      Type_Index_For_Base_Formal_Param_Decl_Array : constant Type_Index := 20;
      Type_Index_For_Base_Type_Decl_Array : constant Type_Index := 21;
      Type_Index_For_Basic_Decl_Array : constant Type_Index := 22;
      Type_Index_For_Compilation_Unit_Array : constant Type_Index := 23;
      Type_Index_For_Defining_Name_Array : constant Type_Index := 24;
      Type_Index_For_Expr_Array : constant Type_Index := 25;
      Type_Index_For_Generic_Instantiation_Array : constant Type_Index := 26;
      Type_Index_For_Param_Spec_Array : constant Type_Index := 27;
      Type_Index_For_Pragma_Array : constant Type_Index := 28;
      Type_Index_For_Type_Decl_Array : constant Type_Index := 29;
      Type_Index_For_Param_Actual_Array : constant Type_Index := 30;
      Type_Index_For_Ref_Result_Array : constant Type_Index := 31;
      Type_Index_For_Shape_Array : constant Type_Index := 32;
      Type_Index_For_Substitution_Array : constant Type_Index := 33;
      Type_Index_For_Analysis_Unit_Array : constant Type_Index := 34;
      Type_Index_For_Symbol_Array : constant Type_Index := 35;
      Type_Index_For_Completion_Item_Iterator : constant Type_Index := 36;
      Type_Index_For_Aspect : constant Type_Index := 37;
      Type_Index_For_Completion_Item : constant Type_Index := 38;
      Type_Index_For_Discrete_Range : constant Type_Index := 39;
      Type_Index_For_Discriminant_Values : constant Type_Index := 40;
      Type_Index_For_Doc_Annotation : constant Type_Index := 41;
      Type_Index_For_Param_Actual : constant Type_Index := 42;
      Type_Index_For_Ref_Result : constant Type_Index := 43;
      Type_Index_For_Refd_Decl : constant Type_Index := 44;
      Type_Index_For_Refd_Def : constant Type_Index := 45;
      Type_Index_For_Shape : constant Type_Index := 46;
      Type_Index_For_Substitution : constant Type_Index := 47;
      Type_Index_For_Ada_Node : constant Type_Index := 48;
      Type_Index_For_Abort : constant Type_Index := 49;
      Type_Index_For_Abort_Absent : constant Type_Index := 50;
      Type_Index_For_Abort_Present : constant Type_Index := 51;
      Type_Index_For_Abstract : constant Type_Index := 52;
      Type_Index_For_Abstract_Absent : constant Type_Index := 53;
      Type_Index_For_Abstract_Present : constant Type_Index := 54;
      Type_Index_For_Ada_List : constant Type_Index := 55;
      Type_Index_For_Ada_Node_List : constant Type_Index := 56;
      Type_Index_For_Abstract_State_Decl_List : constant Type_Index := 57;
      Type_Index_For_Alternatives_List : constant Type_Index := 58;
      Type_Index_For_Constraint_List : constant Type_Index := 59;
      Type_Index_For_Decl_List : constant Type_Index := 60;
      Type_Index_For_Stmt_List : constant Type_Index := 61;
      Type_Index_For_Aspect_Assoc_List : constant Type_Index := 62;
      Type_Index_For_Base_Assoc_List : constant Type_Index := 63;
      Type_Index_For_Basic_Assoc_List : constant Type_Index := 64;
      Type_Index_For_Assoc_List : constant Type_Index := 65;
      Type_Index_For_Basic_Decl_List : constant Type_Index := 66;
      Type_Index_For_Case_Expr_Alternative_List : constant Type_Index := 67;
      Type_Index_For_Case_Stmt_Alternative_List : constant Type_Index := 68;
      Type_Index_For_Compilation_Unit_List : constant Type_Index := 69;
      Type_Index_For_Concat_Operand_List : constant Type_Index := 70;
      Type_Index_For_Contract_Case_Assoc_List : constant Type_Index := 71;
      Type_Index_For_Defining_Name_List : constant Type_Index := 72;
      Type_Index_For_Discriminant_Spec_List : constant Type_Index := 73;
      Type_Index_For_Elsif_Expr_Part_List : constant Type_Index := 74;
      Type_Index_For_Elsif_Stmt_Part_List : constant Type_Index := 75;
      Type_Index_For_Enum_Literal_Decl_List : constant Type_Index := 76;
      Type_Index_For_Expr_List : constant Type_Index := 77;
      Type_Index_For_Expr_Alternatives_List : constant Type_Index := 78;
      Type_Index_For_Identifier_List : constant Type_Index := 79;
      Type_Index_For_Discriminant_Choice_List : constant Type_Index := 80;
      Type_Index_For_Name_List : constant Type_Index := 81;
      Type_Index_For_Parent_List : constant Type_Index := 82;
      Type_Index_For_Param_Spec_List : constant Type_Index := 83;
      Type_Index_For_Pragma_Node_List : constant Type_Index := 84;
      Type_Index_For_Select_When_Part_List : constant Type_Index := 85;
      Type_Index_For_Unconstrained_Array_Index_List : constant Type_Index := 86;
      Type_Index_For_Variant_List : constant Type_Index := 87;
      Type_Index_For_Aliased : constant Type_Index := 88;
      Type_Index_For_Aliased_Absent : constant Type_Index := 89;
      Type_Index_For_Aliased_Present : constant Type_Index := 90;
      Type_Index_For_All : constant Type_Index := 91;
      Type_Index_For_All_Absent : constant Type_Index := 92;
      Type_Index_For_All_Present : constant Type_Index := 93;
      Type_Index_For_Array_Indices : constant Type_Index := 94;
      Type_Index_For_Constrained_Array_Indices : constant Type_Index := 95;
      Type_Index_For_Unconstrained_Array_Indices : constant Type_Index := 96;
      Type_Index_For_Aspect_Assoc : constant Type_Index := 97;
      Type_Index_For_Aspect_Clause : constant Type_Index := 98;
      Type_Index_For_At_Clause : constant Type_Index := 99;
      Type_Index_For_Attribute_Def_Clause : constant Type_Index := 100;
      Type_Index_For_Enum_Rep_Clause : constant Type_Index := 101;
      Type_Index_For_Record_Rep_Clause : constant Type_Index := 102;
      Type_Index_For_Aspect_Spec : constant Type_Index := 103;
      Type_Index_For_Base_Assoc : constant Type_Index := 104;
      Type_Index_For_Contract_Case_Assoc : constant Type_Index := 105;
      Type_Index_For_Pragma_Argument_Assoc : constant Type_Index := 106;
      Type_Index_For_Base_Formal_Param_Holder : constant Type_Index := 107;
      Type_Index_For_Base_Subp_Spec : constant Type_Index := 108;
      Type_Index_For_Entry_Spec : constant Type_Index := 109;
      Type_Index_For_Enum_Subp_Spec : constant Type_Index := 110;
      Type_Index_For_Subp_Spec : constant Type_Index := 111;
      Type_Index_For_Synthetic_Binary_Spec : constant Type_Index := 112;
      Type_Index_For_Synthetic_Unary_Spec : constant Type_Index := 113;
      Type_Index_For_Component_List : constant Type_Index := 114;
      Type_Index_For_Discriminant_Part : constant Type_Index := 115;
      Type_Index_For_Known_Discriminant_Part : constant Type_Index := 116;
      Type_Index_For_Unknown_Discriminant_Part : constant Type_Index := 117;
      Type_Index_For_Entry_Completion_Formal_Params : constant Type_Index := 118;
      Type_Index_For_Generic_Formal_Part : constant Type_Index := 119;
      Type_Index_For_Base_Record_Def : constant Type_Index := 120;
      Type_Index_For_Null_Record_Def : constant Type_Index := 121;
      Type_Index_For_Record_Def : constant Type_Index := 122;
      Type_Index_For_Basic_Assoc : constant Type_Index := 123;
      Type_Index_For_Aggregate_Assoc : constant Type_Index := 124;
      Type_Index_For_Multi_Dim_Array_Assoc : constant Type_Index := 125;
      Type_Index_For_Composite_Constraint_Assoc : constant Type_Index := 126;
      Type_Index_For_Iterated_Assoc : constant Type_Index := 127;
      Type_Index_For_Param_Assoc : constant Type_Index := 128;
      Type_Index_For_Basic_Decl : constant Type_Index := 129;
      Type_Index_For_Abstract_State_Decl : constant Type_Index := 130;
      Type_Index_For_Anonymous_Expr_Decl : constant Type_Index := 131;
      Type_Index_For_Base_Formal_Param_Decl : constant Type_Index := 132;
      Type_Index_For_Component_Decl : constant Type_Index := 133;
      Type_Index_For_Discriminant_Spec : constant Type_Index := 134;
      Type_Index_For_Generic_Formal : constant Type_Index := 135;
      Type_Index_For_Generic_Formal_Obj_Decl : constant Type_Index := 136;
      Type_Index_For_Generic_Formal_Package : constant Type_Index := 137;
      Type_Index_For_Generic_Formal_Subp_Decl : constant Type_Index := 138;
      Type_Index_For_Generic_Formal_Type_Decl : constant Type_Index := 139;
      Type_Index_For_Param_Spec : constant Type_Index := 140;
      Type_Index_For_Synthetic_Formal_Param_Decl : constant Type_Index := 141;
      Type_Index_For_Base_Package_Decl : constant Type_Index := 142;
      Type_Index_For_Generic_Package_Internal : constant Type_Index := 143;
      Type_Index_For_Package_Decl : constant Type_Index := 144;
      Type_Index_For_Base_Type_Decl : constant Type_Index := 145;
      Type_Index_For_Base_Subtype_Decl : constant Type_Index := 146;
      Type_Index_For_Discrete_Base_Subtype_Decl : constant Type_Index := 147;
      Type_Index_For_Subtype_Decl : constant Type_Index := 148;
      Type_Index_For_Classwide_Type_Decl : constant Type_Index := 149;
      Type_Index_For_Incomplete_Type_Decl : constant Type_Index := 150;
      Type_Index_For_Incomplete_Formal_Type_Decl : constant Type_Index := 151;
      Type_Index_For_Incomplete_Tagged_Type_Decl : constant Type_Index := 152;
      Type_Index_For_Protected_Type_Decl : constant Type_Index := 153;
      Type_Index_For_Task_Type_Decl : constant Type_Index := 154;
      Type_Index_For_Single_Task_Type_Decl : constant Type_Index := 155;
      Type_Index_For_Type_Decl : constant Type_Index := 156;
      Type_Index_For_Anonymous_Type_Decl : constant Type_Index := 157;
      Type_Index_For_Synth_Anonymous_Type_Decl : constant Type_Index := 158;
      Type_Index_For_Concrete_Type_Decl : constant Type_Index := 159;
      Type_Index_For_Formal_Type_Decl : constant Type_Index := 160;
      Type_Index_For_Basic_Subp_Decl : constant Type_Index := 161;
      Type_Index_For_Classic_Subp_Decl : constant Type_Index := 162;
      Type_Index_For_Abstract_Subp_Decl : constant Type_Index := 163;
      Type_Index_For_Formal_Subp_Decl : constant Type_Index := 164;
      Type_Index_For_Abstract_Formal_Subp_Decl : constant Type_Index := 165;
      Type_Index_For_Concrete_Formal_Subp_Decl : constant Type_Index := 166;
      Type_Index_For_Subp_Decl : constant Type_Index := 167;
      Type_Index_For_Entry_Decl : constant Type_Index := 168;
      Type_Index_For_Enum_Literal_Decl : constant Type_Index := 169;
      Type_Index_For_Synthetic_Char_Enum_Lit : constant Type_Index := 170;
      Type_Index_For_Generic_Subp_Internal : constant Type_Index := 171;
      Type_Index_For_Synthetic_Subp_Decl : constant Type_Index := 172;
      Type_Index_For_Body : constant Type_Index := 173;
      Type_Index_For_Base_Subp_Body : constant Type_Index := 174;
      Type_Index_For_Expr_Function : constant Type_Index := 175;
      Type_Index_For_Null_Subp_Decl : constant Type_Index := 176;
      Type_Index_For_Subp_Body : constant Type_Index := 177;
      Type_Index_For_Subp_Renaming_Decl : constant Type_Index := 178;
      Type_Index_For_Body_Stub : constant Type_Index := 179;
      Type_Index_For_Package_Body_Stub : constant Type_Index := 180;
      Type_Index_For_Protected_Body_Stub : constant Type_Index := 181;
      Type_Index_For_Subp_Body_Stub : constant Type_Index := 182;
      Type_Index_For_Task_Body_Stub : constant Type_Index := 183;
      Type_Index_For_Entry_Body : constant Type_Index := 184;
      Type_Index_For_Package_Body : constant Type_Index := 185;
      Type_Index_For_Protected_Body : constant Type_Index := 186;
      Type_Index_For_Task_Body : constant Type_Index := 187;
      Type_Index_For_Entry_Index_Spec : constant Type_Index := 188;
      Type_Index_For_Error_Decl : constant Type_Index := 189;
      Type_Index_For_Exception_Decl : constant Type_Index := 190;
      Type_Index_For_Exception_Handler : constant Type_Index := 191;
      Type_Index_For_For_Loop_Var_Decl : constant Type_Index := 192;
      Type_Index_For_Generic_Decl : constant Type_Index := 193;
      Type_Index_For_Generic_Package_Decl : constant Type_Index := 194;
      Type_Index_For_Generic_Subp_Decl : constant Type_Index := 195;
      Type_Index_For_Generic_Instantiation : constant Type_Index := 196;
      Type_Index_For_Generic_Package_Instantiation : constant Type_Index := 197;
      Type_Index_For_Generic_Subp_Instantiation : constant Type_Index := 198;
      Type_Index_For_Generic_Renaming_Decl : constant Type_Index := 199;
      Type_Index_For_Generic_Package_Renaming_Decl : constant Type_Index := 200;
      Type_Index_For_Generic_Subp_Renaming_Decl : constant Type_Index := 201;
      Type_Index_For_Label_Decl : constant Type_Index := 202;
      Type_Index_For_Named_Stmt_Decl : constant Type_Index := 203;
      Type_Index_For_Number_Decl : constant Type_Index := 204;
      Type_Index_For_Object_Decl : constant Type_Index := 205;
      Type_Index_For_Extended_Return_Stmt_Object_Decl : constant Type_Index := 206;
      Type_Index_For_No_Type_Object_Renaming_Decl : constant Type_Index := 207;
      Type_Index_For_Package_Renaming_Decl : constant Type_Index := 208;
      Type_Index_For_Single_Protected_Decl : constant Type_Index := 209;
      Type_Index_For_Single_Task_Decl : constant Type_Index := 210;
      Type_Index_For_Case_Stmt_Alternative : constant Type_Index := 211;
      Type_Index_For_Compilation_Unit : constant Type_Index := 212;
      Type_Index_For_Component_Clause : constant Type_Index := 213;
      Type_Index_For_Component_Def : constant Type_Index := 214;
      Type_Index_For_Constant : constant Type_Index := 215;
      Type_Index_For_Constant_Absent : constant Type_Index := 216;
      Type_Index_For_Constant_Present : constant Type_Index := 217;
      Type_Index_For_Constraint : constant Type_Index := 218;
      Type_Index_For_Composite_Constraint : constant Type_Index := 219;
      Type_Index_For_Delta_Constraint : constant Type_Index := 220;
      Type_Index_For_Digits_Constraint : constant Type_Index := 221;
      Type_Index_For_Range_Constraint : constant Type_Index := 222;
      Type_Index_For_Declarative_Part : constant Type_Index := 223;
      Type_Index_For_Private_Part : constant Type_Index := 224;
      Type_Index_For_Public_Part : constant Type_Index := 225;
      Type_Index_For_Elsif_Expr_Part : constant Type_Index := 226;
      Type_Index_For_Elsif_Stmt_Part : constant Type_Index := 227;
      Type_Index_For_Expr : constant Type_Index := 228;
      Type_Index_For_Abstract_State_Decl_Expr : constant Type_Index := 229;
      Type_Index_For_Allocator : constant Type_Index := 230;
      Type_Index_For_Base_Aggregate : constant Type_Index := 231;
      Type_Index_For_Aggregate : constant Type_Index := 232;
      Type_Index_For_Bracket_Aggregate : constant Type_Index := 233;
      Type_Index_For_Delta_Aggregate : constant Type_Index := 234;
      Type_Index_For_Bracket_Delta_Aggregate : constant Type_Index := 235;
      Type_Index_For_Null_Record_Aggregate : constant Type_Index := 236;
      Type_Index_For_Bin_Op : constant Type_Index := 237;
      Type_Index_For_Relation_Op : constant Type_Index := 238;
      Type_Index_For_Box_Expr : constant Type_Index := 239;
      Type_Index_For_Case_Expr_Alternative : constant Type_Index := 240;
      Type_Index_For_Concat_Op : constant Type_Index := 241;
      Type_Index_For_Concat_Operand : constant Type_Index := 242;
      Type_Index_For_Cond_Expr : constant Type_Index := 243;
      Type_Index_For_Case_Expr : constant Type_Index := 244;
      Type_Index_For_If_Expr : constant Type_Index := 245;
      Type_Index_For_Contract_Cases : constant Type_Index := 246;
      Type_Index_For_Decl_Expr : constant Type_Index := 247;
      Type_Index_For_Membership_Expr : constant Type_Index := 248;
      Type_Index_For_Name : constant Type_Index := 249;
      Type_Index_For_Attribute_Ref : constant Type_Index := 250;
      Type_Index_For_Call_Expr : constant Type_Index := 251;
      Type_Index_For_Defining_Name : constant Type_Index := 252;
      Type_Index_For_Synthetic_Defining_Name : constant Type_Index := 253;
      Type_Index_For_Discrete_Subtype_Name : constant Type_Index := 254;
      Type_Index_For_Dotted_Name : constant Type_Index := 255;
      Type_Index_For_End_Name : constant Type_Index := 256;
      Type_Index_For_Explicit_Deref : constant Type_Index := 257;
      Type_Index_For_Qual_Expr : constant Type_Index := 258;
      Type_Index_For_Reduce_Attribute_Ref : constant Type_Index := 259;
      Type_Index_For_Single_Tok_Node : constant Type_Index := 260;
      Type_Index_For_Base_Id : constant Type_Index := 261;
      Type_Index_For_Char_Literal : constant Type_Index := 262;
      Type_Index_For_Identifier : constant Type_Index := 263;
      Type_Index_For_Op : constant Type_Index := 264;
      Type_Index_For_Op_Abs : constant Type_Index := 265;
      Type_Index_For_Op_And : constant Type_Index := 266;
      Type_Index_For_Op_And_Then : constant Type_Index := 267;
      Type_Index_For_Op_Concat : constant Type_Index := 268;
      Type_Index_For_Op_Div : constant Type_Index := 269;
      Type_Index_For_Op_Double_Dot : constant Type_Index := 270;
      Type_Index_For_Op_Eq : constant Type_Index := 271;
      Type_Index_For_Op_Gt : constant Type_Index := 272;
      Type_Index_For_Op_Gte : constant Type_Index := 273;
      Type_Index_For_Op_In : constant Type_Index := 274;
      Type_Index_For_Op_Lt : constant Type_Index := 275;
      Type_Index_For_Op_Lte : constant Type_Index := 276;
      Type_Index_For_Op_Minus : constant Type_Index := 277;
      Type_Index_For_Op_Mod : constant Type_Index := 278;
      Type_Index_For_Op_Mult : constant Type_Index := 279;
      Type_Index_For_Op_Neq : constant Type_Index := 280;
      Type_Index_For_Op_Not : constant Type_Index := 281;
      Type_Index_For_Op_Not_In : constant Type_Index := 282;
      Type_Index_For_Op_Or : constant Type_Index := 283;
      Type_Index_For_Op_Or_Else : constant Type_Index := 284;
      Type_Index_For_Op_Plus : constant Type_Index := 285;
      Type_Index_For_Op_Pow : constant Type_Index := 286;
      Type_Index_For_Op_Rem : constant Type_Index := 287;
      Type_Index_For_Op_Xor : constant Type_Index := 288;
      Type_Index_For_String_Literal : constant Type_Index := 289;
      Type_Index_For_Null_Literal : constant Type_Index := 290;
      Type_Index_For_Num_Literal : constant Type_Index := 291;
      Type_Index_For_Int_Literal : constant Type_Index := 292;
      Type_Index_For_Real_Literal : constant Type_Index := 293;
      Type_Index_For_Synthetic_Identifier : constant Type_Index := 294;
      Type_Index_For_Target_Name : constant Type_Index := 295;
      Type_Index_For_Update_Attribute_Ref : constant Type_Index := 296;
      Type_Index_For_Paren_Expr : constant Type_Index := 297;
      Type_Index_For_Quantified_Expr : constant Type_Index := 298;
      Type_Index_For_Raise_Expr : constant Type_Index := 299;
      Type_Index_For_Un_Op : constant Type_Index := 300;
      Type_Index_For_Handled_Stmts : constant Type_Index := 301;
      Type_Index_For_Interface_Kind : constant Type_Index := 302;
      Type_Index_For_Interface_Kind_Limited : constant Type_Index := 303;
      Type_Index_For_Interface_Kind_Protected : constant Type_Index := 304;
      Type_Index_For_Interface_Kind_Synchronized : constant Type_Index := 305;
      Type_Index_For_Interface_Kind_Task : constant Type_Index := 306;
      Type_Index_For_Iter_Type : constant Type_Index := 307;
      Type_Index_For_Iter_Type_In : constant Type_Index := 308;
      Type_Index_For_Iter_Type_Of : constant Type_Index := 309;
      Type_Index_For_Library_Item : constant Type_Index := 310;
      Type_Index_For_Limited : constant Type_Index := 311;
      Type_Index_For_Limited_Absent : constant Type_Index := 312;
      Type_Index_For_Limited_Present : constant Type_Index := 313;
      Type_Index_For_Loop_Spec : constant Type_Index := 314;
      Type_Index_For_For_Loop_Spec : constant Type_Index := 315;
      Type_Index_For_While_Loop_Spec : constant Type_Index := 316;
      Type_Index_For_Mode : constant Type_Index := 317;
      Type_Index_For_Mode_Default : constant Type_Index := 318;
      Type_Index_For_Mode_In : constant Type_Index := 319;
      Type_Index_For_Mode_In_Out : constant Type_Index := 320;
      Type_Index_For_Mode_Out : constant Type_Index := 321;
      Type_Index_For_Multi_Abstract_State_Decl : constant Type_Index := 322;
      Type_Index_For_Not_Null : constant Type_Index := 323;
      Type_Index_For_Not_Null_Absent : constant Type_Index := 324;
      Type_Index_For_Not_Null_Present : constant Type_Index := 325;
      Type_Index_For_Null_Component_Decl : constant Type_Index := 326;
      Type_Index_For_Others_Designator : constant Type_Index := 327;
      Type_Index_For_Overriding : constant Type_Index := 328;
      Type_Index_For_Overriding_Not_Overriding : constant Type_Index := 329;
      Type_Index_For_Overriding_Overriding : constant Type_Index := 330;
      Type_Index_For_Overriding_Unspecified : constant Type_Index := 331;
      Type_Index_For_Params : constant Type_Index := 332;
      Type_Index_For_Paren_Abstract_State_Decl : constant Type_Index := 333;
      Type_Index_For_Pp_Directive : constant Type_Index := 334;
      Type_Index_For_Pp_Else_Directive : constant Type_Index := 335;
      Type_Index_For_Pp_Elsif_Directive : constant Type_Index := 336;
      Type_Index_For_Pp_End_If_Directive : constant Type_Index := 337;
      Type_Index_For_Pp_If_Directive : constant Type_Index := 338;
      Type_Index_For_Pp_Then_Kw : constant Type_Index := 339;
      Type_Index_For_Pragma : constant Type_Index := 340;
      Type_Index_For_Private : constant Type_Index := 341;
      Type_Index_For_Private_Absent : constant Type_Index := 342;
      Type_Index_For_Private_Present : constant Type_Index := 343;
      Type_Index_For_Protected_Def : constant Type_Index := 344;
      Type_Index_For_Protected : constant Type_Index := 345;
      Type_Index_For_Protected_Absent : constant Type_Index := 346;
      Type_Index_For_Protected_Present : constant Type_Index := 347;
      Type_Index_For_Quantifier : constant Type_Index := 348;
      Type_Index_For_Quantifier_All : constant Type_Index := 349;
      Type_Index_For_Quantifier_Some : constant Type_Index := 350;
      Type_Index_For_Range_Spec : constant Type_Index := 351;
      Type_Index_For_Renaming_Clause : constant Type_Index := 352;
      Type_Index_For_Synthetic_Renaming_Clause : constant Type_Index := 353;
      Type_Index_For_Reverse : constant Type_Index := 354;
      Type_Index_For_Reverse_Absent : constant Type_Index := 355;
      Type_Index_For_Reverse_Present : constant Type_Index := 356;
      Type_Index_For_Select_When_Part : constant Type_Index := 357;
      Type_Index_For_Stmt : constant Type_Index := 358;
      Type_Index_For_Composite_Stmt : constant Type_Index := 359;
      Type_Index_For_Accept_Stmt : constant Type_Index := 360;
      Type_Index_For_Accept_Stmt_With_Stmts : constant Type_Index := 361;
      Type_Index_For_Base_Loop_Stmt : constant Type_Index := 362;
      Type_Index_For_For_Loop_Stmt : constant Type_Index := 363;
      Type_Index_For_Loop_Stmt : constant Type_Index := 364;
      Type_Index_For_While_Loop_Stmt : constant Type_Index := 365;
      Type_Index_For_Block_Stmt : constant Type_Index := 366;
      Type_Index_For_Begin_Block : constant Type_Index := 367;
      Type_Index_For_Decl_Block : constant Type_Index := 368;
      Type_Index_For_Case_Stmt : constant Type_Index := 369;
      Type_Index_For_Extended_Return_Stmt : constant Type_Index := 370;
      Type_Index_For_If_Stmt : constant Type_Index := 371;
      Type_Index_For_Named_Stmt : constant Type_Index := 372;
      Type_Index_For_Select_Stmt : constant Type_Index := 373;
      Type_Index_For_Error_Stmt : constant Type_Index := 374;
      Type_Index_For_Simple_Stmt : constant Type_Index := 375;
      Type_Index_For_Abort_Stmt : constant Type_Index := 376;
      Type_Index_For_Assign_Stmt : constant Type_Index := 377;
      Type_Index_For_Call_Stmt : constant Type_Index := 378;
      Type_Index_For_Delay_Stmt : constant Type_Index := 379;
      Type_Index_For_Exit_Stmt : constant Type_Index := 380;
      Type_Index_For_Goto_Stmt : constant Type_Index := 381;
      Type_Index_For_Label : constant Type_Index := 382;
      Type_Index_For_Null_Stmt : constant Type_Index := 383;
      Type_Index_For_Raise_Stmt : constant Type_Index := 384;
      Type_Index_For_Requeue_Stmt : constant Type_Index := 385;
      Type_Index_For_Return_Stmt : constant Type_Index := 386;
      Type_Index_For_Terminate_Alternative : constant Type_Index := 387;
      Type_Index_For_Subp_Kind : constant Type_Index := 388;
      Type_Index_For_Subp_Kind_Function : constant Type_Index := 389;
      Type_Index_For_Subp_Kind_Procedure : constant Type_Index := 390;
      Type_Index_For_Subunit : constant Type_Index := 391;
      Type_Index_For_Synchronized : constant Type_Index := 392;
      Type_Index_For_Synchronized_Absent : constant Type_Index := 393;
      Type_Index_For_Synchronized_Present : constant Type_Index := 394;
      Type_Index_For_Tagged : constant Type_Index := 395;
      Type_Index_For_Tagged_Absent : constant Type_Index := 396;
      Type_Index_For_Tagged_Present : constant Type_Index := 397;
      Type_Index_For_Task_Def : constant Type_Index := 398;
      Type_Index_For_Type_Attributes_Repository : constant Type_Index := 399;
      Type_Index_For_Type_Def : constant Type_Index := 400;
      Type_Index_For_Access_Def : constant Type_Index := 401;
      Type_Index_For_Access_To_Subp_Def : constant Type_Index := 402;
      Type_Index_For_Base_Type_Access_Def : constant Type_Index := 403;
      Type_Index_For_Anonymous_Type_Access_Def : constant Type_Index := 404;
      Type_Index_For_Type_Access_Def : constant Type_Index := 405;
      Type_Index_For_Array_Type_Def : constant Type_Index := 406;
      Type_Index_For_Derived_Type_Def : constant Type_Index := 407;
      Type_Index_For_Enum_Type_Def : constant Type_Index := 408;
      Type_Index_For_Formal_Discrete_Type_Def : constant Type_Index := 409;
      Type_Index_For_Interface_Type_Def : constant Type_Index := 410;
      Type_Index_For_Mod_Int_Type_Def : constant Type_Index := 411;
      Type_Index_For_Private_Type_Def : constant Type_Index := 412;
      Type_Index_For_Real_Type_Def : constant Type_Index := 413;
      Type_Index_For_Decimal_Fixed_Point_Def : constant Type_Index := 414;
      Type_Index_For_Floating_Point_Def : constant Type_Index := 415;
      Type_Index_For_Ordinary_Fixed_Point_Def : constant Type_Index := 416;
      Type_Index_For_Record_Type_Def : constant Type_Index := 417;
      Type_Index_For_Signed_Int_Type_Def : constant Type_Index := 418;
      Type_Index_For_Type_Expr : constant Type_Index := 419;
      Type_Index_For_Anonymous_Type : constant Type_Index := 420;
      Type_Index_For_Enum_Lit_Synth_Type_Expr : constant Type_Index := 421;
      Type_Index_For_Subtype_Indication : constant Type_Index := 422;
      Type_Index_For_Constrained_Subtype_Indication : constant Type_Index := 423;
      Type_Index_For_Discrete_Subtype_Indication : constant Type_Index := 424;
      Type_Index_For_Synthetic_Type_Expr : constant Type_Index := 425;
      Type_Index_For_Unconstrained_Array_Index : constant Type_Index := 426;
      Type_Index_For_Until : constant Type_Index := 427;
      Type_Index_For_Until_Absent : constant Type_Index := 428;
      Type_Index_For_Until_Present : constant Type_Index := 429;
      Type_Index_For_Use_Clause : constant Type_Index := 430;
      Type_Index_For_Use_Package_Clause : constant Type_Index := 431;
      Type_Index_For_Use_Type_Clause : constant Type_Index := 432;
      Type_Index_For_Value_Sequence : constant Type_Index := 433;
      Type_Index_For_Variant : constant Type_Index := 434;
      Type_Index_For_Variant_Part : constant Type_Index := 435;
      Type_Index_For_With_Clause : constant Type_Index := 436;
      Type_Index_For_With_Private : constant Type_Index := 437;
      Type_Index_For_With_Private_Absent : constant Type_Index := 438;
      Type_Index_For_With_Private_Present : constant Type_Index := 439;

   ----------------------------
   -- Member index constants --
   ----------------------------

      Member_Index_For_Aspect_Exists : constant Struct_Member_Index := 1;
      Member_Index_For_Aspect_Node : constant Struct_Member_Index := 2;
      Member_Index_For_Aspect_Value : constant Struct_Member_Index := 3;
      Member_Index_For_Completion_Item_Decl : constant Struct_Member_Index := 4;
      Member_Index_For_Completion_Item_Is_Dot_Call : constant Struct_Member_Index := 5;
      Member_Index_For_Completion_Item_Is_Visible : constant Struct_Member_Index := 6;
      Member_Index_For_Completion_Item_Weight : constant Struct_Member_Index := 7;
      Member_Index_For_Discrete_Range_Low_Bound : constant Struct_Member_Index := 8;
      Member_Index_For_Discrete_Range_High_Bound : constant Struct_Member_Index := 9;
      Member_Index_For_Discriminant_Values_Discriminant : constant Struct_Member_Index := 10;
      Member_Index_For_Discriminant_Values_Values : constant Struct_Member_Index := 11;
      Member_Index_For_Doc_Annotation_Key : constant Struct_Member_Index := 12;
      Member_Index_For_Doc_Annotation_Value : constant Struct_Member_Index := 13;
      Member_Index_For_Param_Actual_Param : constant Struct_Member_Index := 14;
      Member_Index_For_Param_Actual_Actual : constant Struct_Member_Index := 15;
      Member_Index_For_Ref_Result_Ref : constant Struct_Member_Index := 16;
      Member_Index_For_Ref_Result_Kind : constant Struct_Member_Index := 17;
      Member_Index_For_Refd_Decl_Decl : constant Struct_Member_Index := 18;
      Member_Index_For_Refd_Decl_Kind : constant Struct_Member_Index := 19;
      Member_Index_For_Refd_Def_Def_Name : constant Struct_Member_Index := 20;
      Member_Index_For_Refd_Def_Kind : constant Struct_Member_Index := 21;
      Member_Index_For_Shape_Components : constant Struct_Member_Index := 22;
      Member_Index_For_Shape_Discriminants_Values : constant Struct_Member_Index := 23;
      Member_Index_For_Substitution_From_Decl : constant Struct_Member_Index := 24;
      Member_Index_For_Substitution_To_Value : constant Struct_Member_Index := 25;
      Member_Index_For_Substitution_Value_Type : constant Struct_Member_Index := 26;
      Member_Index_For_Constrained_Array_Indices_F_List : constant Struct_Member_Index := 27;
      Member_Index_For_Unconstrained_Array_Indices_F_Types : constant Struct_Member_Index := 28;
      Member_Index_For_Aspect_Assoc_F_Id : constant Struct_Member_Index := 29;
      Member_Index_For_Aspect_Assoc_F_Expr : constant Struct_Member_Index := 30;
      Member_Index_For_At_Clause_F_Name : constant Struct_Member_Index := 31;
      Member_Index_For_At_Clause_F_Expr : constant Struct_Member_Index := 32;
      Member_Index_For_Attribute_Def_Clause_F_Attribute_Expr : constant Struct_Member_Index := 33;
      Member_Index_For_Attribute_Def_Clause_F_Expr : constant Struct_Member_Index := 34;
      Member_Index_For_Enum_Rep_Clause_F_Type_Name : constant Struct_Member_Index := 35;
      Member_Index_For_Enum_Rep_Clause_F_Aggregate : constant Struct_Member_Index := 36;
      Member_Index_For_Record_Rep_Clause_F_Name : constant Struct_Member_Index := 37;
      Member_Index_For_Record_Rep_Clause_F_At_Expr : constant Struct_Member_Index := 38;
      Member_Index_For_Record_Rep_Clause_F_Components : constant Struct_Member_Index := 39;
      Member_Index_For_Aspect_Spec_F_Aspect_Assocs : constant Struct_Member_Index := 40;
      Member_Index_For_Contract_Case_Assoc_F_Guard : constant Struct_Member_Index := 41;
      Member_Index_For_Contract_Case_Assoc_F_Consequence : constant Struct_Member_Index := 42;
      Member_Index_For_Pragma_Argument_Assoc_F_Name : constant Struct_Member_Index := 43;
      Member_Index_For_Pragma_Argument_Assoc_F_Expr : constant Struct_Member_Index := 44;
      Member_Index_For_Entry_Spec_F_Entry_Name : constant Struct_Member_Index := 45;
      Member_Index_For_Entry_Spec_F_Family_Type : constant Struct_Member_Index := 46;
      Member_Index_For_Entry_Spec_F_Entry_Params : constant Struct_Member_Index := 47;
      Member_Index_For_Subp_Spec_F_Subp_Kind : constant Struct_Member_Index := 48;
      Member_Index_For_Subp_Spec_F_Subp_Name : constant Struct_Member_Index := 49;
      Member_Index_For_Subp_Spec_F_Subp_Params : constant Struct_Member_Index := 50;
      Member_Index_For_Subp_Spec_F_Subp_Returns : constant Struct_Member_Index := 51;
      Member_Index_For_Synthetic_Binary_Spec_F_Left_Param : constant Struct_Member_Index := 52;
      Member_Index_For_Synthetic_Binary_Spec_F_Right_Param : constant Struct_Member_Index := 53;
      Member_Index_For_Synthetic_Binary_Spec_F_Return_Type_Expr : constant Struct_Member_Index := 54;
      Member_Index_For_Synthetic_Unary_Spec_F_Right_Param : constant Struct_Member_Index := 55;
      Member_Index_For_Synthetic_Unary_Spec_F_Return_Type_Expr : constant Struct_Member_Index := 56;
      Member_Index_For_Component_List_F_Components : constant Struct_Member_Index := 57;
      Member_Index_For_Component_List_F_Variant_Part : constant Struct_Member_Index := 58;
      Member_Index_For_Known_Discriminant_Part_F_Discr_Specs : constant Struct_Member_Index := 59;
      Member_Index_For_Entry_Completion_Formal_Params_F_Params : constant Struct_Member_Index := 60;
      Member_Index_For_Generic_Formal_Part_F_Decls : constant Struct_Member_Index := 61;
      Member_Index_For_Base_Record_Def_F_Components : constant Struct_Member_Index := 62;
      Member_Index_For_Aggregate_Assoc_F_Designators : constant Struct_Member_Index := 63;
      Member_Index_For_Aggregate_Assoc_F_R_Expr : constant Struct_Member_Index := 64;
      Member_Index_For_Composite_Constraint_Assoc_F_Ids : constant Struct_Member_Index := 65;
      Member_Index_For_Composite_Constraint_Assoc_F_Constraint_Expr : constant Struct_Member_Index := 66;
      Member_Index_For_Iterated_Assoc_F_Spec : constant Struct_Member_Index := 67;
      Member_Index_For_Iterated_Assoc_F_R_Expr : constant Struct_Member_Index := 68;
      Member_Index_For_Param_Assoc_F_Designator : constant Struct_Member_Index := 69;
      Member_Index_For_Param_Assoc_F_R_Expr : constant Struct_Member_Index := 70;
      Member_Index_For_Basic_Decl_F_Aspects : constant Struct_Member_Index := 71;
      Member_Index_For_Abstract_State_Decl_F_Name : constant Struct_Member_Index := 72;
      Member_Index_For_Anonymous_Expr_Decl_F_Expr : constant Struct_Member_Index := 73;
      Member_Index_For_Component_Decl_F_Ids : constant Struct_Member_Index := 74;
      Member_Index_For_Component_Decl_F_Component_Def : constant Struct_Member_Index := 75;
      Member_Index_For_Component_Decl_F_Default_Expr : constant Struct_Member_Index := 76;
      Member_Index_For_Discriminant_Spec_F_Ids : constant Struct_Member_Index := 77;
      Member_Index_For_Discriminant_Spec_F_Type_Expr : constant Struct_Member_Index := 78;
      Member_Index_For_Discriminant_Spec_F_Default_Expr : constant Struct_Member_Index := 79;
      Member_Index_For_Generic_Formal_F_Decl : constant Struct_Member_Index := 80;
      Member_Index_For_Param_Spec_F_Ids : constant Struct_Member_Index := 81;
      Member_Index_For_Param_Spec_F_Has_Aliased : constant Struct_Member_Index := 82;
      Member_Index_For_Param_Spec_F_Mode : constant Struct_Member_Index := 83;
      Member_Index_For_Param_Spec_F_Type_Expr : constant Struct_Member_Index := 84;
      Member_Index_For_Param_Spec_F_Default_Expr : constant Struct_Member_Index := 85;
      Member_Index_For_Synthetic_Formal_Param_Decl_F_Param_Type : constant Struct_Member_Index := 86;
      Member_Index_For_Base_Package_Decl_F_Package_Name : constant Struct_Member_Index := 87;
      Member_Index_For_Base_Package_Decl_F_Public_Part : constant Struct_Member_Index := 88;
      Member_Index_For_Base_Package_Decl_F_Private_Part : constant Struct_Member_Index := 89;
      Member_Index_For_Base_Package_Decl_F_End_Name : constant Struct_Member_Index := 90;
      Member_Index_For_Base_Type_Decl_F_Name : constant Struct_Member_Index := 91;
      Member_Index_For_Subtype_Decl_F_Subtype : constant Struct_Member_Index := 92;
      Member_Index_For_Incomplete_Type_Decl_F_Discriminants : constant Struct_Member_Index := 93;
      Member_Index_For_Incomplete_Formal_Type_Decl_F_Is_Tagged : constant Struct_Member_Index := 94;
      Member_Index_For_Incomplete_Formal_Type_Decl_F_Default_Type : constant Struct_Member_Index := 95;
      Member_Index_For_Incomplete_Tagged_Type_Decl_F_Has_Abstract : constant Struct_Member_Index := 96;
      Member_Index_For_Protected_Type_Decl_F_Discriminants : constant Struct_Member_Index := 97;
      Member_Index_For_Protected_Type_Decl_F_Interfaces : constant Struct_Member_Index := 98;
      Member_Index_For_Protected_Type_Decl_F_Definition : constant Struct_Member_Index := 99;
      Member_Index_For_Task_Type_Decl_F_Discriminants : constant Struct_Member_Index := 100;
      Member_Index_For_Task_Type_Decl_F_Definition : constant Struct_Member_Index := 101;
      Member_Index_For_Type_Decl_F_Discriminants : constant Struct_Member_Index := 102;
      Member_Index_For_Type_Decl_F_Type_Def : constant Struct_Member_Index := 103;
      Member_Index_For_Formal_Type_Decl_F_Default_Type : constant Struct_Member_Index := 104;
      Member_Index_For_Classic_Subp_Decl_F_Overriding : constant Struct_Member_Index := 105;
      Member_Index_For_Classic_Subp_Decl_F_Subp_Spec : constant Struct_Member_Index := 106;
      Member_Index_For_Formal_Subp_Decl_F_Default_Expr : constant Struct_Member_Index := 107;
      Member_Index_For_Entry_Decl_F_Overriding : constant Struct_Member_Index := 108;
      Member_Index_For_Entry_Decl_F_Spec : constant Struct_Member_Index := 109;
      Member_Index_For_Enum_Literal_Decl_F_Name : constant Struct_Member_Index := 110;
      Member_Index_For_Generic_Subp_Internal_F_Subp_Spec : constant Struct_Member_Index := 111;
      Member_Index_For_Synthetic_Subp_Decl_F_Spec : constant Struct_Member_Index := 112;
      Member_Index_For_Base_Subp_Body_F_Overriding : constant Struct_Member_Index := 113;
      Member_Index_For_Base_Subp_Body_F_Subp_Spec : constant Struct_Member_Index := 114;
      Member_Index_For_Expr_Function_F_Expr : constant Struct_Member_Index := 115;
      Member_Index_For_Subp_Body_F_Decls : constant Struct_Member_Index := 116;
      Member_Index_For_Subp_Body_F_Stmts : constant Struct_Member_Index := 117;
      Member_Index_For_Subp_Body_F_End_Name : constant Struct_Member_Index := 118;
      Member_Index_For_Subp_Renaming_Decl_F_Renames : constant Struct_Member_Index := 119;
      Member_Index_For_Package_Body_Stub_F_Name : constant Struct_Member_Index := 120;
      Member_Index_For_Protected_Body_Stub_F_Name : constant Struct_Member_Index := 121;
      Member_Index_For_Subp_Body_Stub_F_Overriding : constant Struct_Member_Index := 122;
      Member_Index_For_Subp_Body_Stub_F_Subp_Spec : constant Struct_Member_Index := 123;
      Member_Index_For_Task_Body_Stub_F_Name : constant Struct_Member_Index := 124;
      Member_Index_For_Entry_Body_F_Entry_Name : constant Struct_Member_Index := 125;
      Member_Index_For_Entry_Body_F_Index_Spec : constant Struct_Member_Index := 126;
      Member_Index_For_Entry_Body_F_Params : constant Struct_Member_Index := 127;
      Member_Index_For_Entry_Body_F_Barrier : constant Struct_Member_Index := 128;
      Member_Index_For_Entry_Body_F_Decls : constant Struct_Member_Index := 129;
      Member_Index_For_Entry_Body_F_Stmts : constant Struct_Member_Index := 130;
      Member_Index_For_Entry_Body_F_End_Name : constant Struct_Member_Index := 131;
      Member_Index_For_Package_Body_F_Package_Name : constant Struct_Member_Index := 132;
      Member_Index_For_Package_Body_F_Decls : constant Struct_Member_Index := 133;
      Member_Index_For_Package_Body_F_Stmts : constant Struct_Member_Index := 134;
      Member_Index_For_Package_Body_F_End_Name : constant Struct_Member_Index := 135;
      Member_Index_For_Protected_Body_F_Name : constant Struct_Member_Index := 136;
      Member_Index_For_Protected_Body_F_Decls : constant Struct_Member_Index := 137;
      Member_Index_For_Protected_Body_F_End_Name : constant Struct_Member_Index := 138;
      Member_Index_For_Task_Body_F_Name : constant Struct_Member_Index := 139;
      Member_Index_For_Task_Body_F_Decls : constant Struct_Member_Index := 140;
      Member_Index_For_Task_Body_F_Stmts : constant Struct_Member_Index := 141;
      Member_Index_For_Task_Body_F_End_Name : constant Struct_Member_Index := 142;
      Member_Index_For_Entry_Index_Spec_F_Id : constant Struct_Member_Index := 143;
      Member_Index_For_Entry_Index_Spec_F_Subtype : constant Struct_Member_Index := 144;
      Member_Index_For_Exception_Decl_F_Ids : constant Struct_Member_Index := 145;
      Member_Index_For_Exception_Decl_F_Renames : constant Struct_Member_Index := 146;
      Member_Index_For_Exception_Handler_F_Exception_Name : constant Struct_Member_Index := 147;
      Member_Index_For_Exception_Handler_F_Handled_Exceptions : constant Struct_Member_Index := 148;
      Member_Index_For_Exception_Handler_F_Stmts : constant Struct_Member_Index := 149;
      Member_Index_For_For_Loop_Var_Decl_F_Id : constant Struct_Member_Index := 150;
      Member_Index_For_For_Loop_Var_Decl_F_Id_Type : constant Struct_Member_Index := 151;
      Member_Index_For_Generic_Decl_F_Formal_Part : constant Struct_Member_Index := 152;
      Member_Index_For_Generic_Package_Decl_F_Package_Decl : constant Struct_Member_Index := 153;
      Member_Index_For_Generic_Subp_Decl_F_Subp_Decl : constant Struct_Member_Index := 154;
      Member_Index_For_Generic_Package_Instantiation_F_Name : constant Struct_Member_Index := 155;
      Member_Index_For_Generic_Package_Instantiation_F_Generic_Pkg_Name : constant Struct_Member_Index := 156;
      Member_Index_For_Generic_Package_Instantiation_F_Params : constant Struct_Member_Index := 157;
      Member_Index_For_Generic_Subp_Instantiation_F_Overriding : constant Struct_Member_Index := 158;
      Member_Index_For_Generic_Subp_Instantiation_F_Kind : constant Struct_Member_Index := 159;
      Member_Index_For_Generic_Subp_Instantiation_F_Subp_Name : constant Struct_Member_Index := 160;
      Member_Index_For_Generic_Subp_Instantiation_F_Generic_Subp_Name : constant Struct_Member_Index := 161;
      Member_Index_For_Generic_Subp_Instantiation_F_Params : constant Struct_Member_Index := 162;
      Member_Index_For_Generic_Package_Renaming_Decl_F_Name : constant Struct_Member_Index := 163;
      Member_Index_For_Generic_Package_Renaming_Decl_F_Renames : constant Struct_Member_Index := 164;
      Member_Index_For_Generic_Subp_Renaming_Decl_F_Kind : constant Struct_Member_Index := 165;
      Member_Index_For_Generic_Subp_Renaming_Decl_F_Name : constant Struct_Member_Index := 166;
      Member_Index_For_Generic_Subp_Renaming_Decl_F_Renames : constant Struct_Member_Index := 167;
      Member_Index_For_Label_Decl_F_Name : constant Struct_Member_Index := 168;
      Member_Index_For_Named_Stmt_Decl_F_Name : constant Struct_Member_Index := 169;
      Member_Index_For_Number_Decl_F_Ids : constant Struct_Member_Index := 170;
      Member_Index_For_Number_Decl_F_Expr : constant Struct_Member_Index := 171;
      Member_Index_For_Object_Decl_F_Ids : constant Struct_Member_Index := 172;
      Member_Index_For_Object_Decl_F_Has_Aliased : constant Struct_Member_Index := 173;
      Member_Index_For_Object_Decl_F_Has_Constant : constant Struct_Member_Index := 174;
      Member_Index_For_Object_Decl_F_Mode : constant Struct_Member_Index := 175;
      Member_Index_For_Object_Decl_F_Type_Expr : constant Struct_Member_Index := 176;
      Member_Index_For_Object_Decl_F_Default_Expr : constant Struct_Member_Index := 177;
      Member_Index_For_Object_Decl_F_Renaming_Clause : constant Struct_Member_Index := 178;
      Member_Index_For_Package_Renaming_Decl_F_Name : constant Struct_Member_Index := 179;
      Member_Index_For_Package_Renaming_Decl_F_Renames : constant Struct_Member_Index := 180;
      Member_Index_For_Single_Protected_Decl_F_Name : constant Struct_Member_Index := 181;
      Member_Index_For_Single_Protected_Decl_F_Interfaces : constant Struct_Member_Index := 182;
      Member_Index_For_Single_Protected_Decl_F_Definition : constant Struct_Member_Index := 183;
      Member_Index_For_Single_Task_Decl_F_Task_Type : constant Struct_Member_Index := 184;
      Member_Index_For_Case_Stmt_Alternative_F_Choices : constant Struct_Member_Index := 185;
      Member_Index_For_Case_Stmt_Alternative_F_Stmts : constant Struct_Member_Index := 186;
      Member_Index_For_Compilation_Unit_F_Prelude : constant Struct_Member_Index := 187;
      Member_Index_For_Compilation_Unit_F_Body : constant Struct_Member_Index := 188;
      Member_Index_For_Compilation_Unit_F_Pragmas : constant Struct_Member_Index := 189;
      Member_Index_For_Component_Clause_F_Id : constant Struct_Member_Index := 190;
      Member_Index_For_Component_Clause_F_Position : constant Struct_Member_Index := 191;
      Member_Index_For_Component_Clause_F_Range : constant Struct_Member_Index := 192;
      Member_Index_For_Component_Def_F_Has_Aliased : constant Struct_Member_Index := 193;
      Member_Index_For_Component_Def_F_Has_Constant : constant Struct_Member_Index := 194;
      Member_Index_For_Component_Def_F_Type_Expr : constant Struct_Member_Index := 195;
      Member_Index_For_Composite_Constraint_F_Constraints : constant Struct_Member_Index := 196;
      Member_Index_For_Delta_Constraint_F_Digits : constant Struct_Member_Index := 197;
      Member_Index_For_Delta_Constraint_F_Range : constant Struct_Member_Index := 198;
      Member_Index_For_Digits_Constraint_F_Digits : constant Struct_Member_Index := 199;
      Member_Index_For_Digits_Constraint_F_Range : constant Struct_Member_Index := 200;
      Member_Index_For_Range_Constraint_F_Range : constant Struct_Member_Index := 201;
      Member_Index_For_Declarative_Part_F_Decls : constant Struct_Member_Index := 202;
      Member_Index_For_Elsif_Expr_Part_F_Cond_Expr : constant Struct_Member_Index := 203;
      Member_Index_For_Elsif_Expr_Part_F_Then_Expr : constant Struct_Member_Index := 204;
      Member_Index_For_Elsif_Stmt_Part_F_Cond_Expr : constant Struct_Member_Index := 205;
      Member_Index_For_Elsif_Stmt_Part_F_Stmts : constant Struct_Member_Index := 206;
      Member_Index_For_Abstract_State_Decl_Expr_F_State_Decl : constant Struct_Member_Index := 207;
      Member_Index_For_Allocator_F_Subpool : constant Struct_Member_Index := 208;
      Member_Index_For_Allocator_F_Type_Or_Expr : constant Struct_Member_Index := 209;
      Member_Index_For_Base_Aggregate_F_Ancestor_Expr : constant Struct_Member_Index := 210;
      Member_Index_For_Base_Aggregate_F_Assocs : constant Struct_Member_Index := 211;
      Member_Index_For_Bin_Op_F_Left : constant Struct_Member_Index := 212;
      Member_Index_For_Bin_Op_F_Op : constant Struct_Member_Index := 213;
      Member_Index_For_Bin_Op_F_Right : constant Struct_Member_Index := 214;
      Member_Index_For_Case_Expr_Alternative_F_Choices : constant Struct_Member_Index := 215;
      Member_Index_For_Case_Expr_Alternative_F_Expr : constant Struct_Member_Index := 216;
      Member_Index_For_Concat_Op_F_First_Operand : constant Struct_Member_Index := 217;
      Member_Index_For_Concat_Op_F_Other_Operands : constant Struct_Member_Index := 218;
      Member_Index_For_Concat_Operand_F_Operator : constant Struct_Member_Index := 219;
      Member_Index_For_Concat_Operand_F_Operand : constant Struct_Member_Index := 220;
      Member_Index_For_Case_Expr_F_Expr : constant Struct_Member_Index := 221;
      Member_Index_For_Case_Expr_F_Cases : constant Struct_Member_Index := 222;
      Member_Index_For_If_Expr_F_Cond_Expr : constant Struct_Member_Index := 223;
      Member_Index_For_If_Expr_F_Then_Expr : constant Struct_Member_Index := 224;
      Member_Index_For_If_Expr_F_Alternatives : constant Struct_Member_Index := 225;
      Member_Index_For_If_Expr_F_Else_Expr : constant Struct_Member_Index := 226;
      Member_Index_For_Contract_Cases_F_Contract_Cases : constant Struct_Member_Index := 227;
      Member_Index_For_Decl_Expr_F_Decls : constant Struct_Member_Index := 228;
      Member_Index_For_Decl_Expr_F_Expr : constant Struct_Member_Index := 229;
      Member_Index_For_Membership_Expr_F_Expr : constant Struct_Member_Index := 230;
      Member_Index_For_Membership_Expr_F_Op : constant Struct_Member_Index := 231;
      Member_Index_For_Membership_Expr_F_Membership_Exprs : constant Struct_Member_Index := 232;
      Member_Index_For_Attribute_Ref_F_Prefix : constant Struct_Member_Index := 233;
      Member_Index_For_Attribute_Ref_F_Attribute : constant Struct_Member_Index := 234;
      Member_Index_For_Attribute_Ref_F_Args : constant Struct_Member_Index := 235;
      Member_Index_For_Call_Expr_F_Name : constant Struct_Member_Index := 236;
      Member_Index_For_Call_Expr_F_Suffix : constant Struct_Member_Index := 237;
      Member_Index_For_Defining_Name_F_Name : constant Struct_Member_Index := 238;
      Member_Index_For_Discrete_Subtype_Name_F_Subtype : constant Struct_Member_Index := 239;
      Member_Index_For_Dotted_Name_F_Prefix : constant Struct_Member_Index := 240;
      Member_Index_For_Dotted_Name_F_Suffix : constant Struct_Member_Index := 241;
      Member_Index_For_End_Name_F_Name : constant Struct_Member_Index := 242;
      Member_Index_For_Explicit_Deref_F_Prefix : constant Struct_Member_Index := 243;
      Member_Index_For_Qual_Expr_F_Prefix : constant Struct_Member_Index := 244;
      Member_Index_For_Qual_Expr_F_Suffix : constant Struct_Member_Index := 245;
      Member_Index_For_Reduce_Attribute_Ref_F_Prefix : constant Struct_Member_Index := 246;
      Member_Index_For_Reduce_Attribute_Ref_F_Attribute : constant Struct_Member_Index := 247;
      Member_Index_For_Reduce_Attribute_Ref_F_Args : constant Struct_Member_Index := 248;
      Member_Index_For_Update_Attribute_Ref_F_Prefix : constant Struct_Member_Index := 249;
      Member_Index_For_Update_Attribute_Ref_F_Attribute : constant Struct_Member_Index := 250;
      Member_Index_For_Update_Attribute_Ref_F_Values : constant Struct_Member_Index := 251;
      Member_Index_For_Paren_Expr_F_Expr : constant Struct_Member_Index := 252;
      Member_Index_For_Quantified_Expr_F_Quantifier : constant Struct_Member_Index := 253;
      Member_Index_For_Quantified_Expr_F_Loop_Spec : constant Struct_Member_Index := 254;
      Member_Index_For_Quantified_Expr_F_Expr : constant Struct_Member_Index := 255;
      Member_Index_For_Raise_Expr_F_Exception_Name : constant Struct_Member_Index := 256;
      Member_Index_For_Raise_Expr_F_Error_Message : constant Struct_Member_Index := 257;
      Member_Index_For_Un_Op_F_Op : constant Struct_Member_Index := 258;
      Member_Index_For_Un_Op_F_Expr : constant Struct_Member_Index := 259;
      Member_Index_For_Handled_Stmts_F_Stmts : constant Struct_Member_Index := 260;
      Member_Index_For_Handled_Stmts_F_Exceptions : constant Struct_Member_Index := 261;
      Member_Index_For_Library_Item_F_Has_Private : constant Struct_Member_Index := 262;
      Member_Index_For_Library_Item_F_Item : constant Struct_Member_Index := 263;
      Member_Index_For_For_Loop_Spec_F_Var_Decl : constant Struct_Member_Index := 264;
      Member_Index_For_For_Loop_Spec_F_Loop_Type : constant Struct_Member_Index := 265;
      Member_Index_For_For_Loop_Spec_F_Has_Reverse : constant Struct_Member_Index := 266;
      Member_Index_For_For_Loop_Spec_F_Iter_Expr : constant Struct_Member_Index := 267;
      Member_Index_For_For_Loop_Spec_F_Iter_Filter : constant Struct_Member_Index := 268;
      Member_Index_For_While_Loop_Spec_F_Expr : constant Struct_Member_Index := 269;
      Member_Index_For_Multi_Abstract_State_Decl_F_Decls : constant Struct_Member_Index := 270;
      Member_Index_For_Params_F_Params : constant Struct_Member_Index := 271;
      Member_Index_For_Paren_Abstract_State_Decl_F_Decl : constant Struct_Member_Index := 272;
      Member_Index_For_Pp_Elsif_Directive_F_Expr : constant Struct_Member_Index := 273;
      Member_Index_For_Pp_Elsif_Directive_F_Then_Kw : constant Struct_Member_Index := 274;
      Member_Index_For_Pp_If_Directive_F_Expr : constant Struct_Member_Index := 275;
      Member_Index_For_Pp_If_Directive_F_Then_Kw : constant Struct_Member_Index := 276;
      Member_Index_For_Pragma_Node_F_Id : constant Struct_Member_Index := 277;
      Member_Index_For_Pragma_Node_F_Args : constant Struct_Member_Index := 278;
      Member_Index_For_Protected_Def_F_Public_Part : constant Struct_Member_Index := 279;
      Member_Index_For_Protected_Def_F_Private_Part : constant Struct_Member_Index := 280;
      Member_Index_For_Protected_Def_F_End_Name : constant Struct_Member_Index := 281;
      Member_Index_For_Range_Spec_F_Range : constant Struct_Member_Index := 282;
      Member_Index_For_Renaming_Clause_F_Renamed_Object : constant Struct_Member_Index := 283;
      Member_Index_For_Select_When_Part_F_Cond_Expr : constant Struct_Member_Index := 284;
      Member_Index_For_Select_When_Part_F_Stmts : constant Struct_Member_Index := 285;
      Member_Index_For_Accept_Stmt_F_Name : constant Struct_Member_Index := 286;
      Member_Index_For_Accept_Stmt_F_Entry_Index_Expr : constant Struct_Member_Index := 287;
      Member_Index_For_Accept_Stmt_F_Params : constant Struct_Member_Index := 288;
      Member_Index_For_Accept_Stmt_With_Stmts_F_Stmts : constant Struct_Member_Index := 289;
      Member_Index_For_Accept_Stmt_With_Stmts_F_End_Name : constant Struct_Member_Index := 290;
      Member_Index_For_Base_Loop_Stmt_F_Spec : constant Struct_Member_Index := 291;
      Member_Index_For_Base_Loop_Stmt_F_Stmts : constant Struct_Member_Index := 292;
      Member_Index_For_Base_Loop_Stmt_F_End_Name : constant Struct_Member_Index := 293;
      Member_Index_For_Begin_Block_F_Stmts : constant Struct_Member_Index := 294;
      Member_Index_For_Begin_Block_F_End_Name : constant Struct_Member_Index := 295;
      Member_Index_For_Decl_Block_F_Decls : constant Struct_Member_Index := 296;
      Member_Index_For_Decl_Block_F_Stmts : constant Struct_Member_Index := 297;
      Member_Index_For_Decl_Block_F_End_Name : constant Struct_Member_Index := 298;
      Member_Index_For_Case_Stmt_F_Expr : constant Struct_Member_Index := 299;
      Member_Index_For_Case_Stmt_F_Pragmas : constant Struct_Member_Index := 300;
      Member_Index_For_Case_Stmt_F_Alternatives : constant Struct_Member_Index := 301;
      Member_Index_For_Extended_Return_Stmt_F_Decl : constant Struct_Member_Index := 302;
      Member_Index_For_Extended_Return_Stmt_F_Stmts : constant Struct_Member_Index := 303;
      Member_Index_For_If_Stmt_F_Cond_Expr : constant Struct_Member_Index := 304;
      Member_Index_For_If_Stmt_F_Then_Stmts : constant Struct_Member_Index := 305;
      Member_Index_For_If_Stmt_F_Alternatives : constant Struct_Member_Index := 306;
      Member_Index_For_If_Stmt_F_Else_Stmts : constant Struct_Member_Index := 307;
      Member_Index_For_Named_Stmt_F_Decl : constant Struct_Member_Index := 308;
      Member_Index_For_Named_Stmt_F_Stmt : constant Struct_Member_Index := 309;
      Member_Index_For_Select_Stmt_F_Guards : constant Struct_Member_Index := 310;
      Member_Index_For_Select_Stmt_F_Else_Stmts : constant Struct_Member_Index := 311;
      Member_Index_For_Select_Stmt_F_Abort_Stmts : constant Struct_Member_Index := 312;
      Member_Index_For_Abort_Stmt_F_Names : constant Struct_Member_Index := 313;
      Member_Index_For_Assign_Stmt_F_Dest : constant Struct_Member_Index := 314;
      Member_Index_For_Assign_Stmt_F_Expr : constant Struct_Member_Index := 315;
      Member_Index_For_Call_Stmt_F_Call : constant Struct_Member_Index := 316;
      Member_Index_For_Delay_Stmt_F_Has_Until : constant Struct_Member_Index := 317;
      Member_Index_For_Delay_Stmt_F_Expr : constant Struct_Member_Index := 318;
      Member_Index_For_Exit_Stmt_F_Loop_Name : constant Struct_Member_Index := 319;
      Member_Index_For_Exit_Stmt_F_Cond_Expr : constant Struct_Member_Index := 320;
      Member_Index_For_Goto_Stmt_F_Label_Name : constant Struct_Member_Index := 321;
      Member_Index_For_Label_F_Decl : constant Struct_Member_Index := 322;
      Member_Index_For_Raise_Stmt_F_Exception_Name : constant Struct_Member_Index := 323;
      Member_Index_For_Raise_Stmt_F_Error_Message : constant Struct_Member_Index := 324;
      Member_Index_For_Requeue_Stmt_F_Call_Name : constant Struct_Member_Index := 325;
      Member_Index_For_Requeue_Stmt_F_Has_Abort : constant Struct_Member_Index := 326;
      Member_Index_For_Return_Stmt_F_Return_Expr : constant Struct_Member_Index := 327;
      Member_Index_For_Subunit_F_Name : constant Struct_Member_Index := 328;
      Member_Index_For_Subunit_F_Body : constant Struct_Member_Index := 329;
      Member_Index_For_Task_Def_F_Interfaces : constant Struct_Member_Index := 330;
      Member_Index_For_Task_Def_F_Public_Part : constant Struct_Member_Index := 331;
      Member_Index_For_Task_Def_F_Private_Part : constant Struct_Member_Index := 332;
      Member_Index_For_Task_Def_F_End_Name : constant Struct_Member_Index := 333;
      Member_Index_For_Access_Def_F_Has_Not_Null : constant Struct_Member_Index := 334;
      Member_Index_For_Access_To_Subp_Def_F_Has_Protected : constant Struct_Member_Index := 335;
      Member_Index_For_Access_To_Subp_Def_F_Subp_Spec : constant Struct_Member_Index := 336;
      Member_Index_For_Anonymous_Type_Access_Def_F_Type_Decl : constant Struct_Member_Index := 337;
      Member_Index_For_Type_Access_Def_F_Has_All : constant Struct_Member_Index := 338;
      Member_Index_For_Type_Access_Def_F_Has_Constant : constant Struct_Member_Index := 339;
      Member_Index_For_Type_Access_Def_F_Subtype_Indication : constant Struct_Member_Index := 340;
      Member_Index_For_Array_Type_Def_F_Indices : constant Struct_Member_Index := 341;
      Member_Index_For_Array_Type_Def_F_Component_Type : constant Struct_Member_Index := 342;
      Member_Index_For_Derived_Type_Def_F_Has_Abstract : constant Struct_Member_Index := 343;
      Member_Index_For_Derived_Type_Def_F_Has_Limited : constant Struct_Member_Index := 344;
      Member_Index_For_Derived_Type_Def_F_Has_Synchronized : constant Struct_Member_Index := 345;
      Member_Index_For_Derived_Type_Def_F_Subtype_Indication : constant Struct_Member_Index := 346;
      Member_Index_For_Derived_Type_Def_F_Interfaces : constant Struct_Member_Index := 347;
      Member_Index_For_Derived_Type_Def_F_Record_Extension : constant Struct_Member_Index := 348;
      Member_Index_For_Derived_Type_Def_F_Has_With_Private : constant Struct_Member_Index := 349;
      Member_Index_For_Enum_Type_Def_F_Enum_Literals : constant Struct_Member_Index := 350;
      Member_Index_For_Interface_Type_Def_F_Interface_Kind : constant Struct_Member_Index := 351;
      Member_Index_For_Interface_Type_Def_F_Interfaces : constant Struct_Member_Index := 352;
      Member_Index_For_Mod_Int_Type_Def_F_Expr : constant Struct_Member_Index := 353;
      Member_Index_For_Private_Type_Def_F_Has_Abstract : constant Struct_Member_Index := 354;
      Member_Index_For_Private_Type_Def_F_Has_Tagged : constant Struct_Member_Index := 355;
      Member_Index_For_Private_Type_Def_F_Has_Limited : constant Struct_Member_Index := 356;
      Member_Index_For_Decimal_Fixed_Point_Def_F_Delta : constant Struct_Member_Index := 357;
      Member_Index_For_Decimal_Fixed_Point_Def_F_Digits : constant Struct_Member_Index := 358;
      Member_Index_For_Decimal_Fixed_Point_Def_F_Range : constant Struct_Member_Index := 359;
      Member_Index_For_Floating_Point_Def_F_Num_Digits : constant Struct_Member_Index := 360;
      Member_Index_For_Floating_Point_Def_F_Range : constant Struct_Member_Index := 361;
      Member_Index_For_Ordinary_Fixed_Point_Def_F_Delta : constant Struct_Member_Index := 362;
      Member_Index_For_Ordinary_Fixed_Point_Def_F_Range : constant Struct_Member_Index := 363;
      Member_Index_For_Record_Type_Def_F_Has_Abstract : constant Struct_Member_Index := 364;
      Member_Index_For_Record_Type_Def_F_Has_Tagged : constant Struct_Member_Index := 365;
      Member_Index_For_Record_Type_Def_F_Has_Limited : constant Struct_Member_Index := 366;
      Member_Index_For_Record_Type_Def_F_Record_Def : constant Struct_Member_Index := 367;
      Member_Index_For_Signed_Int_Type_Def_F_Range : constant Struct_Member_Index := 368;
      Member_Index_For_Anonymous_Type_F_Type_Decl : constant Struct_Member_Index := 369;
      Member_Index_For_Subtype_Indication_F_Has_Not_Null : constant Struct_Member_Index := 370;
      Member_Index_For_Subtype_Indication_F_Name : constant Struct_Member_Index := 371;
      Member_Index_For_Subtype_Indication_F_Constraint : constant Struct_Member_Index := 372;
      Member_Index_For_Synthetic_Type_Expr_F_Target_Type : constant Struct_Member_Index := 373;
      Member_Index_For_Unconstrained_Array_Index_F_Subtype_Indication : constant Struct_Member_Index := 374;
      Member_Index_For_Use_Package_Clause_F_Packages : constant Struct_Member_Index := 375;
      Member_Index_For_Use_Type_Clause_F_Has_All : constant Struct_Member_Index := 376;
      Member_Index_For_Use_Type_Clause_F_Types : constant Struct_Member_Index := 377;
      Member_Index_For_Value_Sequence_F_Iter_Assoc : constant Struct_Member_Index := 378;
      Member_Index_For_Variant_F_Choices : constant Struct_Member_Index := 379;
      Member_Index_For_Variant_F_Components : constant Struct_Member_Index := 380;
      Member_Index_For_Variant_Part_F_Discr_Name : constant Struct_Member_Index := 381;
      Member_Index_For_Variant_Part_F_Variant : constant Struct_Member_Index := 382;
      Member_Index_For_With_Clause_F_Has_Limited : constant Struct_Member_Index := 383;
      Member_Index_For_With_Clause_F_Has_Private : constant Struct_Member_Index := 384;
      Member_Index_For_With_Clause_F_Packages : constant Struct_Member_Index := 385;
      Member_Index_For_Ada_Node_P_Declarative_Scope : constant Struct_Member_Index := 386;
      Member_Index_For_Ada_Node_P_Enclosing_Compilation_Unit : constant Struct_Member_Index := 387;
      Member_Index_For_Ada_Node_P_Get_Uninstantiated_Node : constant Struct_Member_Index := 388;
      Member_Index_For_Ada_Node_P_Complete : constant Struct_Member_Index := 389;
      Member_Index_For_Ada_Node_P_Valid_Keywords : constant Struct_Member_Index := 390;
      Member_Index_For_Ada_Node_P_Generic_Instantiations : constant Struct_Member_Index := 391;
      Member_Index_For_Ada_Node_P_Semantic_Parent : constant Struct_Member_Index := 392;
      Member_Index_For_Ada_Node_P_Parent_Basic_Decl : constant Struct_Member_Index := 393;
      Member_Index_For_Ada_Node_P_Filter_Is_Imported_By : constant Struct_Member_Index := 394;
      Member_Index_For_Ada_Node_P_Xref_Entry_Point : constant Struct_Member_Index := 395;
      Member_Index_For_Ada_Node_P_Resolve_Names : constant Struct_Member_Index := 396;
      Member_Index_For_Ada_Node_P_Standard_Unit : constant Struct_Member_Index := 397;
      Member_Index_For_Ada_Node_P_Std_Entity : constant Struct_Member_Index := 398;
      Member_Index_For_Ada_Node_P_Bool_Type : constant Struct_Member_Index := 399;
      Member_Index_For_Ada_Node_P_Int_Type : constant Struct_Member_Index := 400;
      Member_Index_For_Ada_Node_P_Universal_Int_Type : constant Struct_Member_Index := 401;
      Member_Index_For_Ada_Node_P_Universal_Real_Type : constant Struct_Member_Index := 402;
      Member_Index_For_Ada_Node_P_Std_Char_Type : constant Struct_Member_Index := 403;
      Member_Index_For_Ada_Node_P_Std_Wide_Char_Type : constant Struct_Member_Index := 404;
      Member_Index_For_Ada_Node_P_Std_Wide_Wide_Char_Type : constant Struct_Member_Index := 405;
      Member_Index_For_Ada_Node_P_Top_Level_Decl : constant Struct_Member_Index := 406;
      Member_Index_For_Ada_Node_P_Choice_Match : constant Struct_Member_Index := 407;
      Member_Index_For_Ada_Node_P_Gnat_Xref : constant Struct_Member_Index := 408;
      Member_Index_For_Parent : constant Struct_Member_Index := 409;
      Member_Index_For_Parents : constant Struct_Member_Index := 410;
      Member_Index_For_Children : constant Struct_Member_Index := 411;
      Member_Index_For_Token_Start : constant Struct_Member_Index := 412;
      Member_Index_For_Token_End : constant Struct_Member_Index := 413;
      Member_Index_For_Child_Index : constant Struct_Member_Index := 414;
      Member_Index_For_Previous_Sibling : constant Struct_Member_Index := 415;
      Member_Index_For_Next_Sibling : constant Struct_Member_Index := 416;
      Member_Index_For_Unit : constant Struct_Member_Index := 417;
      Member_Index_For_Is_Ghost : constant Struct_Member_Index := 418;
      Member_Index_For_Full_Sloc_Image : constant Struct_Member_Index := 419;
      Member_Index_For_Abort_Node_P_As_Bool : constant Struct_Member_Index := 420;
      Member_Index_For_Abstract_Node_P_As_Bool : constant Struct_Member_Index := 421;
      Member_Index_For_Assoc_List_P_Zip_With_Params : constant Struct_Member_Index := 422;
      Member_Index_For_Aliased_Node_P_As_Bool : constant Struct_Member_Index := 423;
      Member_Index_For_All_Node_P_As_Bool : constant Struct_Member_Index := 424;
      Member_Index_For_Aspect_Assoc_P_Is_Ghost_Code : constant Struct_Member_Index := 425;
      Member_Index_For_Enum_Rep_Clause_P_Params : constant Struct_Member_Index := 426;
      Member_Index_For_Base_Assoc_P_Assoc_Expr : constant Struct_Member_Index := 427;
      Member_Index_For_Base_Formal_Param_Holder_P_Abstract_Formal_Params : constant Struct_Member_Index := 428;
      Member_Index_For_Base_Formal_Param_Holder_P_Formal_Params : constant Struct_Member_Index := 429;
      Member_Index_For_Base_Formal_Param_Holder_P_Nb_Min_Params : constant Struct_Member_Index := 430;
      Member_Index_For_Base_Formal_Param_Holder_P_Nb_Max_Params : constant Struct_Member_Index := 431;
      Member_Index_For_Base_Formal_Param_Holder_P_Param_Types : constant Struct_Member_Index := 432;
      Member_Index_For_Base_Subp_Spec_P_Returns : constant Struct_Member_Index := 433;
      Member_Index_For_Base_Subp_Spec_P_Params : constant Struct_Member_Index := 434;
      Member_Index_For_Base_Subp_Spec_P_Primitive_Subp_Types : constant Struct_Member_Index := 435;
      Member_Index_For_Base_Subp_Spec_P_Primitive_Subp_First_Type : constant Struct_Member_Index := 436;
      Member_Index_For_Base_Subp_Spec_P_Primitive_Subp_Tagged_Type : constant Struct_Member_Index := 437;
      Member_Index_For_Base_Subp_Spec_P_Return_Type : constant Struct_Member_Index := 438;
      Member_Index_For_Basic_Assoc_P_Get_Params : constant Struct_Member_Index := 439;
      Member_Index_For_Basic_Decl_P_Is_Formal : constant Struct_Member_Index := 440;
      Member_Index_For_Basic_Decl_P_Doc_Annotations : constant Struct_Member_Index := 441;
      Member_Index_For_Basic_Decl_P_Doc : constant Struct_Member_Index := 442;
      Member_Index_For_Basic_Decl_P_Previous_Part_For_Decl : constant Struct_Member_Index := 443;
      Member_Index_For_Basic_Decl_P_Canonical_Part : constant Struct_Member_Index := 444;
      Member_Index_For_Basic_Decl_P_All_Parts : constant Struct_Member_Index := 445;
      Member_Index_For_Basic_Decl_P_Is_Static_Decl : constant Struct_Member_Index := 446;
      Member_Index_For_Basic_Decl_P_Get_Aspect_Assoc : constant Struct_Member_Index := 447;
      Member_Index_For_Basic_Decl_P_Get_Aspect_Spec_Expr : constant Struct_Member_Index := 448;
      Member_Index_For_Basic_Decl_P_Get_Aspect : constant Struct_Member_Index := 449;
      Member_Index_For_Basic_Decl_P_Has_Aspect : constant Struct_Member_Index := 450;
      Member_Index_For_Basic_Decl_P_Get_Pragma : constant Struct_Member_Index := 451;
      Member_Index_For_Basic_Decl_P_Get_Representation_Clause : constant Struct_Member_Index := 452;
      Member_Index_For_Basic_Decl_P_Get_At_Clause : constant Struct_Member_Index := 453;
      Member_Index_For_Basic_Decl_P_Is_Imported : constant Struct_Member_Index := 454;
      Member_Index_For_Basic_Decl_P_Is_Ghost_Code : constant Struct_Member_Index := 455;
      Member_Index_For_Basic_Decl_P_Is_Compilation_Unit_Root : constant Struct_Member_Index := 456;
      Member_Index_For_Basic_Decl_P_Is_Visible : constant Struct_Member_Index := 457;
      Member_Index_For_Basic_Decl_P_Base_Subp_Declarations : constant Struct_Member_Index := 458;
      Member_Index_For_Basic_Decl_P_Root_Subp_Declarations : constant Struct_Member_Index := 459;
      Member_Index_For_Basic_Decl_P_Find_All_Overrides : constant Struct_Member_Index := 460;
      Member_Index_For_Basic_Decl_P_Defining_Names : constant Struct_Member_Index := 461;
      Member_Index_For_Basic_Decl_P_Defining_Name : constant Struct_Member_Index := 462;
      Member_Index_For_Basic_Decl_P_Type_Expression : constant Struct_Member_Index := 463;
      Member_Index_For_Basic_Decl_P_Subp_Spec_Or_Null : constant Struct_Member_Index := 464;
      Member_Index_For_Basic_Decl_P_Is_Subprogram : constant Struct_Member_Index := 465;
      Member_Index_For_Basic_Decl_P_Relative_Name : constant Struct_Member_Index := 466;
      Member_Index_For_Basic_Decl_P_Relative_Name_Text : constant Struct_Member_Index := 467;
      Member_Index_For_Basic_Decl_P_Next_Part_For_Decl : constant Struct_Member_Index := 468;
      Member_Index_For_Basic_Decl_P_Body_Part_For_Decl : constant Struct_Member_Index := 469;
      Member_Index_For_Basic_Decl_P_Most_Visible_Part : constant Struct_Member_Index := 470;
      Member_Index_For_Basic_Decl_P_Fully_Qualified_Name_Array : constant Struct_Member_Index := 471;
      Member_Index_For_Basic_Decl_P_Fully_Qualified_Name : constant Struct_Member_Index := 472;
      Member_Index_For_Basic_Decl_P_Canonical_Fully_Qualified_Name : constant Struct_Member_Index := 473;
      Member_Index_For_Basic_Decl_P_Unique_Identifying_Name : constant Struct_Member_Index := 474;
      Member_Index_For_Basic_Decl_P_Is_Constant_Object : constant Struct_Member_Index := 475;
      Member_Index_For_Anonymous_Expr_Decl_P_Get_Formal : constant Struct_Member_Index := 476;
      Member_Index_For_Base_Formal_Param_Decl_P_Formal_Type : constant Struct_Member_Index := 477;
      Member_Index_For_Base_Package_Decl_P_Body_Part : constant Struct_Member_Index := 478;
      Member_Index_For_Base_Type_Decl_P_Base_Subtype : constant Struct_Member_Index := 479;
      Member_Index_For_Base_Type_Decl_P_Private_Completion : constant Struct_Member_Index := 480;
      Member_Index_For_Base_Type_Decl_P_Is_Inherited_Primitive : constant Struct_Member_Index := 481;
      Member_Index_For_Base_Type_Decl_P_Get_Record_Representation_Clause : constant Struct_Member_Index := 482;
      Member_Index_For_Base_Type_Decl_P_Get_Enum_Representation_Clause : constant Struct_Member_Index := 483;
      Member_Index_For_Base_Type_Decl_P_Is_Record_Type : constant Struct_Member_Index := 484;
      Member_Index_For_Base_Type_Decl_P_Is_Array_Type : constant Struct_Member_Index := 485;
      Member_Index_For_Base_Type_Decl_P_Find_Derived_Types : constant Struct_Member_Index := 486;
      Member_Index_For_Base_Type_Decl_P_Is_Real_Type : constant Struct_Member_Index := 487;
      Member_Index_For_Base_Type_Decl_P_Is_Float_Type : constant Struct_Member_Index := 488;
      Member_Index_For_Base_Type_Decl_P_Is_Fixed_Point : constant Struct_Member_Index := 489;
      Member_Index_For_Base_Type_Decl_P_Is_Enum_Type : constant Struct_Member_Index := 490;
      Member_Index_For_Base_Type_Decl_P_Is_Access_Type : constant Struct_Member_Index := 491;
      Member_Index_For_Base_Type_Decl_P_Is_Char_Type : constant Struct_Member_Index := 492;
      Member_Index_For_Base_Type_Decl_P_Discrete_Range : constant Struct_Member_Index := 493;
      Member_Index_For_Base_Type_Decl_P_Is_Discrete_Type : constant Struct_Member_Index := 494;
      Member_Index_For_Base_Type_Decl_P_Is_Int_Type : constant Struct_Member_Index := 495;
      Member_Index_For_Base_Type_Decl_P_Accessed_Type : constant Struct_Member_Index := 496;
      Member_Index_For_Base_Type_Decl_P_Is_Tagged_Type : constant Struct_Member_Index := 497;
      Member_Index_For_Base_Type_Decl_P_Base_Type : constant Struct_Member_Index := 498;
      Member_Index_For_Base_Type_Decl_P_Base_Types : constant Struct_Member_Index := 499;
      Member_Index_For_Base_Type_Decl_P_Find_All_Derived_Types : constant Struct_Member_Index := 500;
      Member_Index_For_Base_Type_Decl_P_Comp_Type : constant Struct_Member_Index := 501;
      Member_Index_For_Base_Type_Decl_P_Index_Type : constant Struct_Member_Index := 502;
      Member_Index_For_Base_Type_Decl_P_Is_Derived_Type : constant Struct_Member_Index := 503;
      Member_Index_For_Base_Type_Decl_P_Is_Interface_Type : constant Struct_Member_Index := 504;
      Member_Index_For_Base_Type_Decl_P_Matching_Type : constant Struct_Member_Index := 505;
      Member_Index_For_Base_Type_Decl_P_Canonical_Type : constant Struct_Member_Index := 506;
      Member_Index_For_Base_Type_Decl_P_Previous_Part : constant Struct_Member_Index := 507;
      Member_Index_For_Base_Type_Decl_P_Next_Part : constant Struct_Member_Index := 508;
      Member_Index_For_Base_Type_Decl_P_Full_View : constant Struct_Member_Index := 509;
      Member_Index_For_Base_Type_Decl_P_Is_Definite_Subtype : constant Struct_Member_Index := 510;
      Member_Index_For_Base_Type_Decl_P_Is_Private : constant Struct_Member_Index := 511;
      Member_Index_For_Base_Type_Decl_P_Discriminants_List : constant Struct_Member_Index := 512;
      Member_Index_For_Base_Type_Decl_P_Root_Type : constant Struct_Member_Index := 513;
      Member_Index_For_Base_Type_Decl_P_Shapes : constant Struct_Member_Index := 514;
      Member_Index_For_Base_Subtype_Decl_P_Get_Type : constant Struct_Member_Index := 515;
      Member_Index_For_Type_Decl_P_Get_Primitives : constant Struct_Member_Index := 516;
      Member_Index_For_Basic_Subp_Decl_P_Subp_Decl_Spec : constant Struct_Member_Index := 517;
      Member_Index_For_Classic_Subp_Decl_P_Body_Part : constant Struct_Member_Index := 518;
      Member_Index_For_Entry_Decl_P_Body_Part : constant Struct_Member_Index := 519;
      Member_Index_For_Entry_Decl_P_Accept_Stmts : constant Struct_Member_Index := 520;
      Member_Index_For_Enum_Literal_Decl_P_Enum_Type : constant Struct_Member_Index := 521;
      Member_Index_For_Synthetic_Char_Enum_Lit_P_Expr : constant Struct_Member_Index := 522;
      Member_Index_For_Body_Node_P_Previous_Part : constant Struct_Member_Index := 523;
      Member_Index_For_Body_Node_P_Decl_Part : constant Struct_Member_Index := 524;
      Member_Index_For_Body_Node_P_Subunit_Root : constant Struct_Member_Index := 525;
      Member_Index_For_Body_Stub_P_Syntactic_Fully_Qualified_Name : constant Struct_Member_Index := 526;
      Member_Index_For_Generic_Package_Decl_P_Body_Part : constant Struct_Member_Index := 527;
      Member_Index_For_Generic_Subp_Decl_P_Body_Part : constant Struct_Member_Index := 528;
      Member_Index_For_Generic_Instantiation_P_Designated_Generic_Decl : constant Struct_Member_Index := 529;
      Member_Index_For_Generic_Instantiation_P_Inst_Params : constant Struct_Member_Index := 530;
      Member_Index_For_Generic_Subp_Instantiation_P_Designated_Subp : constant Struct_Member_Index := 531;
      Member_Index_For_Object_Decl_P_Private_Part_Decl : constant Struct_Member_Index := 532;
      Member_Index_For_Object_Decl_P_Public_Part_Decl : constant Struct_Member_Index := 533;
      Member_Index_For_Package_Renaming_Decl_P_Renamed_Package : constant Struct_Member_Index := 534;
      Member_Index_For_Package_Renaming_Decl_P_Final_Renamed_Package : constant Struct_Member_Index := 535;
      Member_Index_For_Compilation_Unit_P_Syntactic_Fully_Qualified_Name : constant Struct_Member_Index := 536;
      Member_Index_For_Compilation_Unit_P_Unit_Kind : constant Struct_Member_Index := 537;
      Member_Index_For_Compilation_Unit_P_Withed_Units : constant Struct_Member_Index := 538;
      Member_Index_For_Compilation_Unit_P_Imported_Units : constant Struct_Member_Index := 539;
      Member_Index_For_Compilation_Unit_P_Unit_Dependencies : constant Struct_Member_Index := 540;
      Member_Index_For_Compilation_Unit_P_Decl : constant Struct_Member_Index := 541;
      Member_Index_For_Compilation_Unit_P_Is_Preelaborable : constant Struct_Member_Index := 542;
      Member_Index_For_Compilation_Unit_P_Other_Part : constant Struct_Member_Index := 543;
      Member_Index_For_Compilation_Unit_P_Has_Restriction : constant Struct_Member_Index := 544;
      Member_Index_For_Compilation_Unit_P_All_Config_Pragmas : constant Struct_Member_Index := 545;
      Member_Index_For_Compilation_Unit_P_Config_Pragmas : constant Struct_Member_Index := 546;
      Member_Index_For_Constant_Node_P_As_Bool : constant Struct_Member_Index := 547;
      Member_Index_For_Composite_Constraint_P_Is_Index_Constraint : constant Struct_Member_Index := 548;
      Member_Index_For_Composite_Constraint_P_Is_Discriminant_Constraint : constant Struct_Member_Index := 549;
      Member_Index_For_Expr_P_Expression_Type : constant Struct_Member_Index := 550;
      Member_Index_For_Expr_P_Expected_Expression_Type : constant Struct_Member_Index := 551;
      Member_Index_For_Expr_P_Is_Dynamically_Tagged : constant Struct_Member_Index := 552;
      Member_Index_For_Expr_P_Is_Dispatching_Call : constant Struct_Member_Index := 553;
      Member_Index_For_Expr_P_Is_Static_Expr : constant Struct_Member_Index := 554;
      Member_Index_For_Expr_P_First_Corresponding_Decl : constant Struct_Member_Index := 555;
      Member_Index_For_Expr_P_Eval_As_Int : constant Struct_Member_Index := 556;
      Member_Index_For_Expr_P_Eval_As_Int_In_Env : constant Struct_Member_Index := 557;
      Member_Index_For_Expr_P_Eval_As_String : constant Struct_Member_Index := 558;
      Member_Index_For_Expr_P_Eval_As_String_In_Env : constant Struct_Member_Index := 559;
      Member_Index_For_Expr_P_Matching_Nodes : constant Struct_Member_Index := 560;
      Member_Index_For_Allocator_P_Get_Allocated_Type : constant Struct_Member_Index := 561;
      Member_Index_For_Base_Aggregate_P_Aggregate_Params : constant Struct_Member_Index := 562;
      Member_Index_For_Base_Aggregate_P_Is_Subaggregate : constant Struct_Member_Index := 563;
      Member_Index_For_Concat_Op_P_Operands : constant Struct_Member_Index := 564;
      Member_Index_For_Cond_Expr_P_Dependent_Exprs : constant Struct_Member_Index := 565;
      Member_Index_For_Name_P_Enclosing_Defining_Name : constant Struct_Member_Index := 566;
      Member_Index_For_Name_P_Is_Defining : constant Struct_Member_Index := 567;
      Member_Index_For_Name_P_Name_Is : constant Struct_Member_Index := 568;
      Member_Index_For_Name_P_Is_Direct_Call : constant Struct_Member_Index := 569;
      Member_Index_For_Name_P_Is_Access_Call : constant Struct_Member_Index := 570;
      Member_Index_For_Name_P_Is_Call : constant Struct_Member_Index := 571;
      Member_Index_For_Name_P_Is_Dot_Call : constant Struct_Member_Index := 572;
      Member_Index_For_Name_P_Failsafe_Referenced_Def_Name : constant Struct_Member_Index := 573;
      Member_Index_For_Name_P_Referenced_Defining_Name : constant Struct_Member_Index := 574;
      Member_Index_For_Name_P_All_Env_Elements : constant Struct_Member_Index := 575;
      Member_Index_For_Name_P_Called_Subp_Spec : constant Struct_Member_Index := 576;
      Member_Index_For_Name_P_Referenced_Decl : constant Struct_Member_Index := 577;
      Member_Index_For_Name_P_Failsafe_Referenced_Decl : constant Struct_Member_Index := 578;
      Member_Index_For_Name_P_Referenced_Decl_Internal : constant Struct_Member_Index := 579;
      Member_Index_For_Name_P_Name_Designated_Type : constant Struct_Member_Index := 580;
      Member_Index_For_Name_P_Is_Static_Subtype : constant Struct_Member_Index := 581;
      Member_Index_For_Name_P_Name_Matches : constant Struct_Member_Index := 582;
      Member_Index_For_Name_P_Relative_Name : constant Struct_Member_Index := 583;
      Member_Index_For_Name_P_Is_Operator_Name : constant Struct_Member_Index := 584;
      Member_Index_For_Name_P_Is_Write_Reference : constant Struct_Member_Index := 585;
      Member_Index_For_Name_P_Is_Static_Call : constant Struct_Member_Index := 586;
      Member_Index_For_Name_P_As_Symbol_Array : constant Struct_Member_Index := 587;
      Member_Index_For_Name_P_Canonical_Text : constant Struct_Member_Index := 588;
      Member_Index_For_Name_P_Is_Constant : constant Struct_Member_Index := 589;
      Member_Index_For_Name_P_Call_Params : constant Struct_Member_Index := 590;
      Member_Index_For_Call_Expr_P_Kind : constant Struct_Member_Index := 591;
      Member_Index_For_Call_Expr_P_Is_Array_Slice : constant Struct_Member_Index := 592;
      Member_Index_For_Defining_Name_P_Canonical_Fully_Qualified_Name : constant Struct_Member_Index := 593;
      Member_Index_For_Defining_Name_P_Unique_Identifying_Name : constant Struct_Member_Index := 594;
      Member_Index_For_Defining_Name_P_Fully_Qualified_Name_Array : constant Struct_Member_Index := 595;
      Member_Index_For_Defining_Name_P_Fully_Qualified_Name : constant Struct_Member_Index := 596;
      Member_Index_For_Defining_Name_P_Basic_Decl : constant Struct_Member_Index := 597;
      Member_Index_For_Defining_Name_P_Find_Refs : constant Struct_Member_Index := 598;
      Member_Index_For_Defining_Name_P_Find_All_References : constant Struct_Member_Index := 599;
      Member_Index_For_Defining_Name_P_Find_All_Calls : constant Struct_Member_Index := 600;
      Member_Index_For_Defining_Name_P_Next_Part : constant Struct_Member_Index := 601;
      Member_Index_For_Defining_Name_P_Previous_Part : constant Struct_Member_Index := 602;
      Member_Index_For_Defining_Name_P_Canonical_Part : constant Struct_Member_Index := 603;
      Member_Index_For_Defining_Name_P_Most_Visible_Part : constant Struct_Member_Index := 604;
      Member_Index_For_Defining_Name_P_All_Parts : constant Struct_Member_Index := 605;
      Member_Index_For_Defining_Name_P_Get_Aspect : constant Struct_Member_Index := 606;
      Member_Index_For_Defining_Name_P_Has_Aspect : constant Struct_Member_Index := 607;
      Member_Index_For_Defining_Name_P_Get_Pragma : constant Struct_Member_Index := 608;
      Member_Index_For_Defining_Name_P_Get_Representation_Clause : constant Struct_Member_Index := 609;
      Member_Index_For_Defining_Name_P_Get_At_Clause : constant Struct_Member_Index := 610;
      Member_Index_For_Defining_Name_P_Is_Imported : constant Struct_Member_Index := 611;
      Member_Index_For_Defining_Name_P_Is_Ghost_Code : constant Struct_Member_Index := 612;
      Member_Index_For_End_Name_P_Basic_Decl : constant Struct_Member_Index := 613;
      Member_Index_For_Char_Literal_P_Denoted_Value : constant Struct_Member_Index := 614;
      Member_Index_For_String_Literal_P_Denoted_Value : constant Struct_Member_Index := 615;
      Member_Index_For_Int_Literal_P_Denoted_Value : constant Struct_Member_Index := 616;
      Member_Index_For_Limited_Node_P_As_Bool : constant Struct_Member_Index := 617;
      Member_Index_For_Not_Null_P_As_Bool : constant Struct_Member_Index := 618;
      Member_Index_For_Pragma_Node_P_Is_Ghost_Code : constant Struct_Member_Index := 619;
      Member_Index_For_Pragma_Node_P_Associated_Entities : constant Struct_Member_Index := 620;
      Member_Index_For_Private_Node_P_As_Bool : constant Struct_Member_Index := 621;
      Member_Index_For_Protected_Node_P_As_Bool : constant Struct_Member_Index := 622;
      Member_Index_For_Reverse_Node_P_As_Bool : constant Struct_Member_Index := 623;
      Member_Index_For_Stmt_P_Is_Ghost_Code : constant Struct_Member_Index := 624;
      Member_Index_For_Accept_Stmt_P_Corresponding_Entry : constant Struct_Member_Index := 625;
      Member_Index_For_Subunit_P_Body_Root : constant Struct_Member_Index := 626;
      Member_Index_For_Synchronized_Node_P_As_Bool : constant Struct_Member_Index := 627;
      Member_Index_For_Tagged_Node_P_As_Bool : constant Struct_Member_Index := 628;
      Member_Index_For_Type_Expr_P_Type_Name : constant Struct_Member_Index := 629;
      Member_Index_For_Type_Expr_P_Designated_Type_Decl : constant Struct_Member_Index := 630;
      Member_Index_For_Type_Expr_P_Designated_Type_Decl_From : constant Struct_Member_Index := 631;
      Member_Index_For_Subtype_Indication_P_Subtype_Constraints : constant Struct_Member_Index := 632;
      Member_Index_For_Subtype_Indication_P_Is_Static_Subtype : constant Struct_Member_Index := 633;
      Member_Index_For_Until_Node_P_As_Bool : constant Struct_Member_Index := 634;
      Member_Index_For_With_Private_P_As_Bool : constant Struct_Member_Index := 635;

   ------------------------------
   -- Grammar rule descriptors --
   ------------------------------

   
      
      Rule_Name_1 : aliased constant Text_Type :=
        "Parent_List";
      Rule_Doc_1 : aliased constant Text_Type :=
        "";
      Rule_Desc_1 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_1'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_1'Access,
         Return_Type => Type_Index_For_Parent_List);
      
      Rule_Name_2 : aliased constant Text_Type :=
        "Protected_Type_Decl";
      Rule_Doc_2 : aliased constant Text_Type :=
        "";
      Rule_Desc_2 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_2'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_2'Access,
         Return_Type => Type_Index_For_Protected_Type_Decl);
      
      Rule_Name_3 : aliased constant Text_Type :=
        "Protected_Op";
      Rule_Doc_3 : aliased constant Text_Type :=
        "";
      Rule_Desc_3 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_3'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_3'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_4 : aliased constant Text_Type :=
        "Protected_El";
      Rule_Doc_4 : aliased constant Text_Type :=
        "";
      Rule_Desc_4 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_4'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_4'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_5 : aliased constant Text_Type :=
        "Protected_Def";
      Rule_Doc_5 : aliased constant Text_Type :=
        "";
      Rule_Desc_5 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_5'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_5'Access,
         Return_Type => Type_Index_For_Protected_Def);
      
      Rule_Name_6 : aliased constant Text_Type :=
        "Protected_Decl";
      Rule_Doc_6 : aliased constant Text_Type :=
        "";
      Rule_Desc_6 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_6'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_6'Access,
         Return_Type => Type_Index_For_Single_Protected_Decl);
      
      Rule_Name_7 : aliased constant Text_Type :=
        "Task_Item";
      Rule_Doc_7 : aliased constant Text_Type :=
        "";
      Rule_Desc_7 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_7'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_7'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_8 : aliased constant Text_Type :=
        "Task_Def";
      Rule_Doc_8 : aliased constant Text_Type :=
        "";
      Rule_Desc_8 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_8'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_8'Access,
         Return_Type => Type_Index_For_Task_Def);
      
      Rule_Name_9 : aliased constant Text_Type :=
        "Task_Type_Decl";
      Rule_Doc_9 : aliased constant Text_Type :=
        "";
      Rule_Desc_9 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_9'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_9'Access,
         Return_Type => Type_Index_For_Task_Type_Decl);
      
      Rule_Name_10 : aliased constant Text_Type :=
        "Subtype_Decl";
      Rule_Doc_10 : aliased constant Text_Type :=
        "";
      Rule_Desc_10 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_10'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_10'Access,
         Return_Type => Type_Index_For_Subtype_Decl);
      
      Rule_Name_11 : aliased constant Text_Type :=
        "Interface_Type_Def";
      Rule_Doc_11 : aliased constant Text_Type :=
        "";
      Rule_Desc_11 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_11'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_11'Access,
         Return_Type => Type_Index_For_Interface_Type_Def);
      
      Rule_Name_12 : aliased constant Text_Type :=
        "Unconstrained_Index";
      Rule_Doc_12 : aliased constant Text_Type :=
        "";
      Rule_Desc_12 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_12'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_12'Access,
         Return_Type => Type_Index_For_Unconstrained_Array_Index);
      
      Rule_Name_13 : aliased constant Text_Type :=
        "Array_Type_Def";
      Rule_Doc_13 : aliased constant Text_Type :=
        "";
      Rule_Desc_13 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_13'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_13'Access,
         Return_Type => Type_Index_For_Array_Type_Def);
      
      Rule_Name_14 : aliased constant Text_Type :=
        "Discrete_Subtype_Definition";
      Rule_Doc_14 : aliased constant Text_Type :=
        "";
      Rule_Desc_14 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_14'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_14'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_15 : aliased constant Text_Type :=
        "Constraint_List";
      Rule_Doc_15 : aliased constant Text_Type :=
        "";
      Rule_Desc_15 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_15'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_15'Access,
         Return_Type => Type_Index_For_Constraint_List);
      
      Rule_Name_16 : aliased constant Text_Type :=
        "Signed_Int_Type_Def";
      Rule_Doc_16 : aliased constant Text_Type :=
        "";
      Rule_Desc_16 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_16'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_16'Access,
         Return_Type => Type_Index_For_Signed_Int_Type_Def);
      
      Rule_Name_17 : aliased constant Text_Type :=
        "Mod_Int_Type_Def";
      Rule_Doc_17 : aliased constant Text_Type :=
        "";
      Rule_Desc_17 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_17'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_17'Access,
         Return_Type => Type_Index_For_Mod_Int_Type_Def);
      
      Rule_Name_18 : aliased constant Text_Type :=
        "Derived_Type_Def";
      Rule_Doc_18 : aliased constant Text_Type :=
        "";
      Rule_Desc_18 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_18'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_18'Access,
         Return_Type => Type_Index_For_Derived_Type_Def);
      
      Rule_Name_19 : aliased constant Text_Type :=
        "Composite_Constraint_Assoc";
      Rule_Doc_19 : aliased constant Text_Type :=
        "";
      Rule_Desc_19 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_19'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_19'Access,
         Return_Type => Type_Index_For_Composite_Constraint_Assoc);
      
      Rule_Name_20 : aliased constant Text_Type :=
        "Composite_Constraint";
      Rule_Doc_20 : aliased constant Text_Type :=
        "";
      Rule_Desc_20 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_20'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_20'Access,
         Return_Type => Type_Index_For_Composite_Constraint);
      
      Rule_Name_21 : aliased constant Text_Type :=
        "Digits_Constraint";
      Rule_Doc_21 : aliased constant Text_Type :=
        "";
      Rule_Desc_21 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_21'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_21'Access,
         Return_Type => Type_Index_For_Digits_Constraint);
      
      Rule_Name_22 : aliased constant Text_Type :=
        "Delta_Constraint";
      Rule_Doc_22 : aliased constant Text_Type :=
        "";
      Rule_Desc_22 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_22'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_22'Access,
         Return_Type => Type_Index_For_Delta_Constraint);
      
      Rule_Name_23 : aliased constant Text_Type :=
        "Range_Constraint";
      Rule_Doc_23 : aliased constant Text_Type :=
        "";
      Rule_Desc_23 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_23'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_23'Access,
         Return_Type => Type_Index_For_Range_Constraint);
      
      Rule_Name_24 : aliased constant Text_Type :=
        "Constraint";
      Rule_Doc_24 : aliased constant Text_Type :=
        "";
      Rule_Desc_24 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_24'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_24'Access,
         Return_Type => Type_Index_For_Constraint);
      
      Rule_Name_25 : aliased constant Text_Type :=
        "Discriminant_Spec";
      Rule_Doc_25 : aliased constant Text_Type :=
        "";
      Rule_Desc_25 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_25'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_25'Access,
         Return_Type => Type_Index_For_Discriminant_Spec);
      
      Rule_Name_26 : aliased constant Text_Type :=
        "Discr_Spec_List";
      Rule_Doc_26 : aliased constant Text_Type :=
        "";
      Rule_Desc_26 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_26'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_26'Access,
         Return_Type => Type_Index_For_Discriminant_Spec_List);
      
      Rule_Name_27 : aliased constant Text_Type :=
        "Discriminant_Part";
      Rule_Doc_27 : aliased constant Text_Type :=
        "";
      Rule_Desc_27 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_27'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_27'Access,
         Return_Type => Type_Index_For_Discriminant_Part);
      
      Rule_Name_28 : aliased constant Text_Type :=
        "Enum_Literal_Decl";
      Rule_Doc_28 : aliased constant Text_Type :=
        "";
      Rule_Desc_28 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_28'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_28'Access,
         Return_Type => Type_Index_For_Enum_Literal_Decl);
      
      Rule_Name_29 : aliased constant Text_Type :=
        "Formal_Discrete_Type_Def";
      Rule_Doc_29 : aliased constant Text_Type :=
        "";
      Rule_Desc_29 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_29'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_29'Access,
         Return_Type => Type_Index_For_Formal_Discrete_Type_Def);
      
      Rule_Name_30 : aliased constant Text_Type :=
        "Record_Def";
      Rule_Doc_30 : aliased constant Text_Type :=
        "";
      Rule_Desc_30 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_30'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_30'Access,
         Return_Type => Type_Index_For_Base_Record_Def);
      
      Rule_Name_31 : aliased constant Text_Type :=
        "Range_Spec";
      Rule_Doc_31 : aliased constant Text_Type :=
        "";
      Rule_Desc_31 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_31'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_31'Access,
         Return_Type => Type_Index_For_Range_Spec);
      
      Rule_Name_32 : aliased constant Text_Type :=
        "Real_Type_Def";
      Rule_Doc_32 : aliased constant Text_Type :=
        "";
      Rule_Desc_32 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_32'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_32'Access,
         Return_Type => Type_Index_For_Real_Type_Def);
      
      Rule_Name_33 : aliased constant Text_Type :=
        "Sexpr_Or_Box";
      Rule_Doc_33 : aliased constant Text_Type :=
        "";
      Rule_Desc_33 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_33'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_33'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_34 : aliased constant Text_Type :=
        "Ordinary_Fixed_Point_Def";
      Rule_Doc_34 : aliased constant Text_Type :=
        "";
      Rule_Desc_34 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_34'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_34'Access,
         Return_Type => Type_Index_For_Ordinary_Fixed_Point_Def);
      
      Rule_Name_35 : aliased constant Text_Type :=
        "Decimal_Fixed_Point_Def";
      Rule_Doc_35 : aliased constant Text_Type :=
        "";
      Rule_Desc_35 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_35'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_35'Access,
         Return_Type => Type_Index_For_Decimal_Fixed_Point_Def);
      
      Rule_Name_36 : aliased constant Text_Type :=
        "Floating_Point_Def";
      Rule_Doc_36 : aliased constant Text_Type :=
        "";
      Rule_Desc_36 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_36'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_36'Access,
         Return_Type => Type_Index_For_Floating_Point_Def);
      
      Rule_Name_37 : aliased constant Text_Type :=
        "Record_Type_Def";
      Rule_Doc_37 : aliased constant Text_Type :=
        "";
      Rule_Desc_37 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_37'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_37'Access,
         Return_Type => Type_Index_For_Record_Type_Def);
      
      Rule_Name_38 : aliased constant Text_Type :=
        "Access_Def";
      Rule_Doc_38 : aliased constant Text_Type :=
        "";
      Rule_Desc_38 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_38'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_38'Access,
         Return_Type => Type_Index_For_Access_Def);
      
      Rule_Name_39 : aliased constant Text_Type :=
        "Enum_Type_Def";
      Rule_Doc_39 : aliased constant Text_Type :=
        "";
      Rule_Desc_39 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_39'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_39'Access,
         Return_Type => Type_Index_For_Enum_Type_Def);
      
      Rule_Name_40 : aliased constant Text_Type :=
        "Type_Def";
      Rule_Doc_40 : aliased constant Text_Type :=
        "";
      Rule_Desc_40 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_40'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_40'Access,
         Return_Type => Type_Index_For_Type_Def);
      
      Rule_Name_41 : aliased constant Text_Type :=
        "Variant";
      Rule_Doc_41 : aliased constant Text_Type :=
        "";
      Rule_Desc_41 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_41'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_41'Access,
         Return_Type => Type_Index_For_Variant);
      
      Rule_Name_42 : aliased constant Text_Type :=
        "Anonymous_Type_Decl";
      Rule_Doc_42 : aliased constant Text_Type :=
        "";
      Rule_Desc_42 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_42'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_42'Access,
         Return_Type => Type_Index_For_Anonymous_Type_Decl);
      
      Rule_Name_43 : aliased constant Text_Type :=
        "Incomplete_Type_Decl";
      Rule_Doc_43 : aliased constant Text_Type :=
        "";
      Rule_Desc_43 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_43'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_43'Access,
         Return_Type => Type_Index_For_Incomplete_Type_Decl);
      
      Rule_Name_44 : aliased constant Text_Type :=
        "Type_Decl";
      Rule_Doc_44 : aliased constant Text_Type :=
        "";
      Rule_Desc_44 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_44'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_44'Access,
         Return_Type => Type_Index_For_Base_Type_Decl);
      
      Rule_Name_45 : aliased constant Text_Type :=
        "Variant_Part";
      Rule_Doc_45 : aliased constant Text_Type :=
        "";
      Rule_Desc_45 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_45'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_45'Access,
         Return_Type => Type_Index_For_Variant_Part);
      
      Rule_Name_46 : aliased constant Text_Type :=
        "Component_Def";
      Rule_Doc_46 : aliased constant Text_Type :=
        "";
      Rule_Desc_46 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_46'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_46'Access,
         Return_Type => Type_Index_For_Component_Def);
      
      Rule_Name_47 : aliased constant Text_Type :=
        "Component_Item";
      Rule_Doc_47 : aliased constant Text_Type :=
        "";
      Rule_Desc_47 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_47'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_47'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_48 : aliased constant Text_Type :=
        "Component_Decl";
      Rule_Doc_48 : aliased constant Text_Type :=
        "";
      Rule_Desc_48 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_48'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_48'Access,
         Return_Type => Type_Index_For_Component_Decl);
      
      Rule_Name_49 : aliased constant Text_Type :=
        "Component_List";
      Rule_Doc_49 : aliased constant Text_Type :=
        "";
      Rule_Desc_49 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_49'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_49'Access,
         Return_Type => Type_Index_For_Component_List);
      
      Rule_Name_50 : aliased constant Text_Type :=
        "Generic_Decl";
      Rule_Doc_50 : aliased constant Text_Type :=
        "";
      Rule_Desc_50 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_50'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_50'Access,
         Return_Type => Type_Index_For_Generic_Decl);
      
      Rule_Name_51 : aliased constant Text_Type :=
        "Generic_Formal_Part";
      Rule_Doc_51 : aliased constant Text_Type :=
        "";
      Rule_Desc_51 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_51'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_51'Access,
         Return_Type => Type_Index_For_Generic_Formal_Part);
      
      Rule_Name_52 : aliased constant Text_Type :=
        "Generic_Formal_Decl";
      Rule_Doc_52 : aliased constant Text_Type :=
        "";
      Rule_Desc_52 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_52'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_52'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_53 : aliased constant Text_Type :=
        "Formal_Type_Decl";
      Rule_Doc_53 : aliased constant Text_Type :=
        "";
      Rule_Desc_53 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_53'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_53'Access,
         Return_Type => Type_Index_For_Base_Type_Decl);
      
      Rule_Name_54 : aliased constant Text_Type :=
        "Formal_Subp_Decl";
      Rule_Doc_54 : aliased constant Text_Type :=
        "";
      Rule_Desc_54 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_54'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_54'Access,
         Return_Type => Type_Index_For_Formal_Subp_Decl);
      
      Rule_Name_55 : aliased constant Text_Type :=
        "Renaming_Clause";
      Rule_Doc_55 : aliased constant Text_Type :=
        "";
      Rule_Desc_55 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_55'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_55'Access,
         Return_Type => Type_Index_For_Renaming_Clause);
      
      Rule_Name_56 : aliased constant Text_Type :=
        "Generic_Renaming_Decl";
      Rule_Doc_56 : aliased constant Text_Type :=
        "";
      Rule_Desc_56 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_56'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_56'Access,
         Return_Type => Type_Index_For_Generic_Renaming_Decl);
      
      Rule_Name_57 : aliased constant Text_Type :=
        "Generic_Instantiation";
      Rule_Doc_57 : aliased constant Text_Type :=
        "";
      Rule_Desc_57 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_57'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_57'Access,
         Return_Type => Type_Index_For_Generic_Instantiation);
      
      Rule_Name_58 : aliased constant Text_Type :=
        "Exception_Decl";
      Rule_Doc_58 : aliased constant Text_Type :=
        "";
      Rule_Desc_58 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_58'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_58'Access,
         Return_Type => Type_Index_For_Exception_Decl);
      
      Rule_Name_59 : aliased constant Text_Type :=
        "Basic_Decls";
      Rule_Doc_59 : aliased constant Text_Type :=
        "";
      Rule_Desc_59 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_59'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_59'Access,
         Return_Type => Type_Index_For_Ada_Node_List);
      
      Rule_Name_60 : aliased constant Text_Type :=
        "Package_Renaming_Decl";
      Rule_Doc_60 : aliased constant Text_Type :=
        "";
      Rule_Desc_60 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_60'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_60'Access,
         Return_Type => Type_Index_For_Package_Renaming_Decl);
      
      Rule_Name_61 : aliased constant Text_Type :=
        "Package_Decl";
      Rule_Doc_61 : aliased constant Text_Type :=
        "";
      Rule_Desc_61 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_61'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_61'Access,
         Return_Type => Type_Index_For_Package_Decl);
      
      Rule_Name_62 : aliased constant Text_Type :=
        "Basic_Decl";
      Rule_Doc_62 : aliased constant Text_Type :=
        "";
      Rule_Desc_62 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_62'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_62'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_63 : aliased constant Text_Type :=
        "Object_Decl";
      Rule_Doc_63 : aliased constant Text_Type :=
        "";
      Rule_Desc_63 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_63'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_63'Access,
         Return_Type => Type_Index_For_Basic_Decl);
      
      Rule_Name_64 : aliased constant Text_Type :=
        "Sub_Object_Decl";
      Rule_Doc_64 : aliased constant Text_Type :=
        "";
      Rule_Desc_64 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_64'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_64'Access,
         Return_Type => Type_Index_For_Object_Decl);
      
      Rule_Name_65 : aliased constant Text_Type :=
        "No_Type_Object_Renaming_Decl";
      Rule_Doc_65 : aliased constant Text_Type :=
        "";
      Rule_Desc_65 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_65'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_65'Access,
         Return_Type => Type_Index_For_No_Type_Object_Renaming_Decl);
      
      Rule_Name_66 : aliased constant Text_Type :=
        "Ext_Ret_Stmt_Object_Decl";
      Rule_Doc_66 : aliased constant Text_Type :=
        "";
      Rule_Desc_66 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_66'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_66'Access,
         Return_Type => Type_Index_For_Extended_Return_Stmt_Object_Decl);
      
      Rule_Name_67 : aliased constant Text_Type :=
        "Defining_Id_List";
      Rule_Doc_67 : aliased constant Text_Type :=
        "";
      Rule_Desc_67 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_67'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_67'Access,
         Return_Type => Type_Index_For_Defining_Name_List);
      
      Rule_Name_68 : aliased constant Text_Type :=
        "Number_Decl";
      Rule_Doc_68 : aliased constant Text_Type :=
        "";
      Rule_Desc_68 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_68'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_68'Access,
         Return_Type => Type_Index_For_Number_Decl);
      
      Rule_Name_69 : aliased constant Text_Type :=
        "Contract_Case_Assoc";
      Rule_Doc_69 : aliased constant Text_Type :=
        "";
      Rule_Desc_69 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_69'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_69'Access,
         Return_Type => Type_Index_For_Contract_Case_Assoc);
      
      Rule_Name_70 : aliased constant Text_Type :=
        "Contract_Cases_Expr";
      Rule_Doc_70 : aliased constant Text_Type :=
        "";
      Rule_Desc_70 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_70'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_70'Access,
         Return_Type => Type_Index_For_Contract_Cases);
      
      Rule_Name_71 : aliased constant Text_Type :=
        "Abstract_State_Decl";
      Rule_Doc_71 : aliased constant Text_Type :=
        "";
      Rule_Desc_71 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_71'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_71'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_72 : aliased constant Text_Type :=
        "Multi_Abstract_State_Decl";
      Rule_Doc_72 : aliased constant Text_Type :=
        "";
      Rule_Desc_72 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_72'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_72'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_73 : aliased constant Text_Type :=
        "Aspect_Assoc";
      Rule_Doc_73 : aliased constant Text_Type :=
        "";
      Rule_Desc_73 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_73'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_73'Access,
         Return_Type => Type_Index_For_Aspect_Assoc);
      
      Rule_Name_74 : aliased constant Text_Type :=
        "Aspect_Spec";
      Rule_Doc_74 : aliased constant Text_Type :=
        "";
      Rule_Desc_74 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_74'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_74'Access,
         Return_Type => Type_Index_For_Aspect_Spec);
      
      Rule_Name_75 : aliased constant Text_Type :=
        "Single_Task_Decl";
      Rule_Doc_75 : aliased constant Text_Type :=
        "";
      Rule_Desc_75 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_75'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_75'Access,
         Return_Type => Type_Index_For_Single_Task_Decl);
      
      Rule_Name_76 : aliased constant Text_Type :=
        "Overriding_Indicator";
      Rule_Doc_76 : aliased constant Text_Type :=
        "";
      Rule_Desc_76 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_76'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_76'Access,
         Return_Type => Type_Index_For_Overriding);
      
      Rule_Name_77 : aliased constant Text_Type :=
        "Entry_Decl";
      Rule_Doc_77 : aliased constant Text_Type :=
        "";
      Rule_Desc_77 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_77'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_77'Access,
         Return_Type => Type_Index_For_Entry_Decl);
      
      Rule_Name_78 : aliased constant Text_Type :=
        "Component_Clause";
      Rule_Doc_78 : aliased constant Text_Type :=
        "";
      Rule_Desc_78 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_78'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_78'Access,
         Return_Type => Type_Index_For_Component_Clause);
      
      Rule_Name_79 : aliased constant Text_Type :=
        "Aspect_Clause";
      Rule_Doc_79 : aliased constant Text_Type :=
        "";
      Rule_Desc_79 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_79'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_79'Access,
         Return_Type => Type_Index_For_Aspect_Clause);
      
      Rule_Name_80 : aliased constant Text_Type :=
        "Param_Spec";
      Rule_Doc_80 : aliased constant Text_Type :=
        "";
      Rule_Desc_80 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_80'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_80'Access,
         Return_Type => Type_Index_For_Param_Spec);
      
      Rule_Name_81 : aliased constant Text_Type :=
        "Param_Specs";
      Rule_Doc_81 : aliased constant Text_Type :=
        "";
      Rule_Desc_81 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_81'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_81'Access,
         Return_Type => Type_Index_For_Params);
      
      Rule_Name_82 : aliased constant Text_Type :=
        "Subp_Spec";
      Rule_Doc_82 : aliased constant Text_Type :=
        "";
      Rule_Desc_82 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_82'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_82'Access,
         Return_Type => Type_Index_For_Subp_Spec);
      
      Rule_Name_83 : aliased constant Text_Type :=
        "Expr_Fn";
      Rule_Doc_83 : aliased constant Text_Type :=
        "";
      Rule_Desc_83 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_83'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_83'Access,
         Return_Type => Type_Index_For_Expr_Function);
      
      Rule_Name_84 : aliased constant Text_Type :=
        "Null_Subp_Decl";
      Rule_Doc_84 : aliased constant Text_Type :=
        "";
      Rule_Desc_84 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_84'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_84'Access,
         Return_Type => Type_Index_For_Null_Subp_Decl);
      
      Rule_Name_85 : aliased constant Text_Type :=
        "Abstract_Subp_Decl";
      Rule_Doc_85 : aliased constant Text_Type :=
        "";
      Rule_Desc_85 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_85'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_85'Access,
         Return_Type => Type_Index_For_Abstract_Subp_Decl);
      
      Rule_Name_86 : aliased constant Text_Type :=
        "Subp_Renaming_Decl";
      Rule_Doc_86 : aliased constant Text_Type :=
        "";
      Rule_Desc_86 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_86'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_86'Access,
         Return_Type => Type_Index_For_Subp_Renaming_Decl);
      
      Rule_Name_87 : aliased constant Text_Type :=
        "Simple_Subp_Decl";
      Rule_Doc_87 : aliased constant Text_Type :=
        "";
      Rule_Desc_87 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_87'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_87'Access,
         Return_Type => Type_Index_For_Subp_Decl);
      
      Rule_Name_88 : aliased constant Text_Type :=
        "Subp_Decl";
      Rule_Doc_88 : aliased constant Text_Type :=
        "";
      Rule_Desc_88 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_88'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_88'Access,
         Return_Type => Type_Index_For_Basic_Decl);
      
      Rule_Name_89 : aliased constant Text_Type :=
        "With_Clause";
      Rule_Doc_89 : aliased constant Text_Type :=
        "";
      Rule_Desc_89 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_89'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_89'Access,
         Return_Type => Type_Index_For_With_Clause);
      
      Rule_Name_90 : aliased constant Text_Type :=
        "Context_Item";
      Rule_Doc_90 : aliased constant Text_Type :=
        "";
      Rule_Desc_90 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_90'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_90'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_91 : aliased constant Text_Type :=
        "Use_Clause";
      Rule_Doc_91 : aliased constant Text_Type :=
        "";
      Rule_Desc_91 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_91'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_91'Access,
         Return_Type => Type_Index_For_Use_Clause);
      
      Rule_Name_92 : aliased constant Text_Type :=
        "Use_Package_Clause";
      Rule_Doc_92 : aliased constant Text_Type :=
        "";
      Rule_Desc_92 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_92'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_92'Access,
         Return_Type => Type_Index_For_Use_Package_Clause);
      
      Rule_Name_93 : aliased constant Text_Type :=
        "Use_Type_Clause";
      Rule_Doc_93 : aliased constant Text_Type :=
        "";
      Rule_Desc_93 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_93'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_93'Access,
         Return_Type => Type_Index_For_Use_Type_Clause);
      
      Rule_Name_94 : aliased constant Text_Type :=
        "Subtype_Indication";
      Rule_Doc_94 : aliased constant Text_Type :=
        "";
      Rule_Desc_94 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_94'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_94'Access,
         Return_Type => Type_Index_For_Subtype_Indication);
      
      Rule_Name_95 : aliased constant Text_Type :=
        "Discrete_Subtype_Indication";
      Rule_Doc_95 : aliased constant Text_Type :=
        "";
      Rule_Desc_95 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_95'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_95'Access,
         Return_Type => Type_Index_For_Discrete_Subtype_Indication);
      
      Rule_Name_96 : aliased constant Text_Type :=
        "Constrained_Subtype_Indication";
      Rule_Doc_96 : aliased constant Text_Type :=
        "";
      Rule_Desc_96 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_96'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_96'Access,
         Return_Type => Type_Index_For_Constrained_Subtype_Indication);
      
      Rule_Name_97 : aliased constant Text_Type :=
        "Type_Expr";
      Rule_Doc_97 : aliased constant Text_Type :=
        "";
      Rule_Desc_97 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_97'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_97'Access,
         Return_Type => Type_Index_For_Type_Expr);
      
      Rule_Name_98 : aliased constant Text_Type :=
        "Anonymous_Type";
      Rule_Doc_98 : aliased constant Text_Type :=
        "";
      Rule_Desc_98 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_98'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_98'Access,
         Return_Type => Type_Index_For_Anonymous_Type);
      
      Rule_Name_99 : aliased constant Text_Type :=
        "Mode";
      Rule_Doc_99 : aliased constant Text_Type :=
        "";
      Rule_Desc_99 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_99'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_99'Access,
         Return_Type => Type_Index_For_Mode);
      
      Rule_Name_100 : aliased constant Text_Type :=
        "Pragma_Argument";
      Rule_Doc_100 : aliased constant Text_Type :=
        "";
      Rule_Desc_100 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_100'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_100'Access,
         Return_Type => Type_Index_For_Pragma_Argument_Assoc);
      
      Rule_Name_101 : aliased constant Text_Type :=
        "Pragma";
      Rule_Doc_101 : aliased constant Text_Type :=
        "";
      Rule_Desc_101 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_101'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_101'Access,
         Return_Type => Type_Index_For_Pragma);
      
      Rule_Name_102 : aliased constant Text_Type :=
        "Subunit";
      Rule_Doc_102 : aliased constant Text_Type :=
        "";
      Rule_Desc_102 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_102'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_102'Access,
         Return_Type => Type_Index_For_Subunit);
      
      Rule_Name_103 : aliased constant Text_Type :=
        "Library_Unit_Body";
      Rule_Doc_103 : aliased constant Text_Type :=
        "";
      Rule_Desc_103 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_103'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_103'Access,
         Return_Type => Type_Index_For_Body);
      
      Rule_Name_104 : aliased constant Text_Type :=
        "Library_Unit_Renaming_Decl";
      Rule_Doc_104 : aliased constant Text_Type :=
        "";
      Rule_Desc_104 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_104'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_104'Access,
         Return_Type => Type_Index_For_Basic_Decl);
      
      Rule_Name_105 : aliased constant Text_Type :=
        "Library_Item";
      Rule_Doc_105 : aliased constant Text_Type :=
        "";
      Rule_Desc_105 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_105'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_105'Access,
         Return_Type => Type_Index_For_Library_Item);
      
      Rule_Name_106 : aliased constant Text_Type :=
        "Compilation_Unit";
      Rule_Doc_106 : aliased constant Text_Type :=
        "Parse a compilation unit.";
      Rule_Desc_106 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_106'Access,
         Is_Public   => True,
         Doc         => Rule_Doc_106'Access,
         Return_Type => Type_Index_For_Compilation_Unit);
      
      Rule_Name_107 : aliased constant Text_Type :=
        "Compilation";
      Rule_Doc_107 : aliased constant Text_Type :=
        "Parse an Ada source file.";
      Rule_Desc_107 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_107'Access,
         Is_Public   => True,
         Doc         => Rule_Doc_107'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_108 : aliased constant Text_Type :=
        "Decl_Part";
      Rule_Doc_108 : aliased constant Text_Type :=
        "";
      Rule_Desc_108 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_108'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_108'Access,
         Return_Type => Type_Index_For_Declarative_Part);
      
      Rule_Name_109 : aliased constant Text_Type :=
        "Entry_Body";
      Rule_Doc_109 : aliased constant Text_Type :=
        "";
      Rule_Desc_109 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_109'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_109'Access,
         Return_Type => Type_Index_For_Entry_Body);
      
      Rule_Name_110 : aliased constant Text_Type :=
        "Protected_Body";
      Rule_Doc_110 : aliased constant Text_Type :=
        "";
      Rule_Desc_110 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_110'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_110'Access,
         Return_Type => Type_Index_For_Protected_Body);
      
      Rule_Name_111 : aliased constant Text_Type :=
        "Protected_Body_Stub";
      Rule_Doc_111 : aliased constant Text_Type :=
        "";
      Rule_Desc_111 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_111'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_111'Access,
         Return_Type => Type_Index_For_Protected_Body_Stub);
      
      Rule_Name_112 : aliased constant Text_Type :=
        "Task_Body";
      Rule_Doc_112 : aliased constant Text_Type :=
        "";
      Rule_Desc_112 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_112'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_112'Access,
         Return_Type => Type_Index_For_Task_Body);
      
      Rule_Name_113 : aliased constant Text_Type :=
        "Task_Body_Stub";
      Rule_Doc_113 : aliased constant Text_Type :=
        "";
      Rule_Desc_113 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_113'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_113'Access,
         Return_Type => Type_Index_For_Task_Body_Stub);
      
      Rule_Name_114 : aliased constant Text_Type :=
        "Package_Body_Stub";
      Rule_Doc_114 : aliased constant Text_Type :=
        "";
      Rule_Desc_114 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_114'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_114'Access,
         Return_Type => Type_Index_For_Package_Body_Stub);
      
      Rule_Name_115 : aliased constant Text_Type :=
        "Package_Body";
      Rule_Doc_115 : aliased constant Text_Type :=
        "";
      Rule_Desc_115 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_115'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_115'Access,
         Return_Type => Type_Index_For_Package_Body);
      
      Rule_Name_116 : aliased constant Text_Type :=
        "Terminate_Alternative";
      Rule_Doc_116 : aliased constant Text_Type :=
        "";
      Rule_Desc_116 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_116'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_116'Access,
         Return_Type => Type_Index_For_Terminate_Alternative);
      
      Rule_Name_117 : aliased constant Text_Type :=
        "Select_Stmt";
      Rule_Doc_117 : aliased constant Text_Type :=
        "";
      Rule_Desc_117 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_117'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_117'Access,
         Return_Type => Type_Index_For_Select_Stmt);
      
      Rule_Name_118 : aliased constant Text_Type :=
        "Accept_Stmt";
      Rule_Doc_118 : aliased constant Text_Type :=
        "";
      Rule_Desc_118 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_118'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_118'Access,
         Return_Type => Type_Index_For_Accept_Stmt);
      
      Rule_Name_119 : aliased constant Text_Type :=
        "Case_Alt";
      Rule_Doc_119 : aliased constant Text_Type :=
        "";
      Rule_Desc_119 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_119'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_119'Access,
         Return_Type => Type_Index_For_Case_Stmt_Alternative);
      
      Rule_Name_120 : aliased constant Text_Type :=
        "Case_Stmt";
      Rule_Doc_120 : aliased constant Text_Type :=
        "";
      Rule_Desc_120 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_120'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_120'Access,
         Return_Type => Type_Index_For_Case_Stmt);
      
      Rule_Name_121 : aliased constant Text_Type :=
        "Ext_Return_Stmt";
      Rule_Doc_121 : aliased constant Text_Type :=
        "";
      Rule_Desc_121 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_121'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_121'Access,
         Return_Type => Type_Index_For_Extended_Return_Stmt);
      
      Rule_Name_122 : aliased constant Text_Type :=
        "Iblock_Stmt";
      Rule_Doc_122 : aliased constant Text_Type :=
        "";
      Rule_Desc_122 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_122'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_122'Access,
         Return_Type => Type_Index_For_Block_Stmt);
      
      Rule_Name_123 : aliased constant Text_Type :=
        "Block_Stmt";
      Rule_Doc_123 : aliased constant Text_Type :=
        "";
      Rule_Desc_123 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_123'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_123'Access,
         Return_Type => Type_Index_For_Composite_Stmt);
      
      Rule_Name_124 : aliased constant Text_Type :=
        "While_Loop_Spec";
      Rule_Doc_124 : aliased constant Text_Type :=
        "";
      Rule_Desc_124 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_124'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_124'Access,
         Return_Type => Type_Index_For_While_Loop_Spec);
      
      Rule_Name_125 : aliased constant Text_Type :=
        "Iloop_Stmt";
      Rule_Doc_125 : aliased constant Text_Type :=
        "";
      Rule_Desc_125 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_125'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_125'Access,
         Return_Type => Type_Index_For_Base_Loop_Stmt);
      
      Rule_Name_126 : aliased constant Text_Type :=
        "Loop_Stmt";
      Rule_Doc_126 : aliased constant Text_Type :=
        "";
      Rule_Desc_126 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_126'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_126'Access,
         Return_Type => Type_Index_For_Composite_Stmt);
      
      Rule_Name_127 : aliased constant Text_Type :=
        "Compound_Stmt";
      Rule_Doc_127 : aliased constant Text_Type :=
        "";
      Rule_Desc_127 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_127'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_127'Access,
         Return_Type => Type_Index_For_Composite_Stmt);
      
      Rule_Name_128 : aliased constant Text_Type :=
        "Elsif_Part";
      Rule_Doc_128 : aliased constant Text_Type :=
        "";
      Rule_Desc_128 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_128'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_128'Access,
         Return_Type => Type_Index_For_Elsif_Stmt_Part);
      
      Rule_Name_129 : aliased constant Text_Type :=
        "If_Stmt";
      Rule_Doc_129 : aliased constant Text_Type :=
        "";
      Rule_Desc_129 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_129'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_129'Access,
         Return_Type => Type_Index_For_If_Stmt);
      
      Rule_Name_130 : aliased constant Text_Type :=
        "Raise_Stmt";
      Rule_Doc_130 : aliased constant Text_Type :=
        "";
      Rule_Desc_130 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_130'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_130'Access,
         Return_Type => Type_Index_For_Raise_Stmt);
      
      Rule_Name_131 : aliased constant Text_Type :=
        "Delay_Stmt";
      Rule_Doc_131 : aliased constant Text_Type :=
        "";
      Rule_Desc_131 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_131'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_131'Access,
         Return_Type => Type_Index_For_Delay_Stmt);
      
      Rule_Name_132 : aliased constant Text_Type :=
        "Abort_Stmt";
      Rule_Doc_132 : aliased constant Text_Type :=
        "";
      Rule_Desc_132 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_132'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_132'Access,
         Return_Type => Type_Index_For_Abort_Stmt);
      
      Rule_Name_133 : aliased constant Text_Type :=
        "Body";
      Rule_Doc_133 : aliased constant Text_Type :=
        "";
      Rule_Desc_133 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_133'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_133'Access,
         Return_Type => Type_Index_For_Body);
      
      Rule_Name_134 : aliased constant Text_Type :=
        "Body_Stub";
      Rule_Doc_134 : aliased constant Text_Type :=
        "";
      Rule_Desc_134 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_134'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_134'Access,
         Return_Type => Type_Index_For_Body_Stub);
      
      Rule_Name_135 : aliased constant Text_Type :=
        "Subp_Body_Stub";
      Rule_Doc_135 : aliased constant Text_Type :=
        "";
      Rule_Desc_135 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_135'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_135'Access,
         Return_Type => Type_Index_For_Subp_Body_Stub);
      
      Rule_Name_136 : aliased constant Text_Type :=
        "Recov_Decl_Part";
      Rule_Doc_136 : aliased constant Text_Type :=
        "";
      Rule_Desc_136 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_136'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_136'Access,
         Return_Type => Type_Index_For_Declarative_Part);
      
      Rule_Name_137 : aliased constant Text_Type :=
        "Subp_Body";
      Rule_Doc_137 : aliased constant Text_Type :=
        "";
      Rule_Desc_137 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_137'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_137'Access,
         Return_Type => Type_Index_For_Subp_Body);
      
      Rule_Name_138 : aliased constant Text_Type :=
        "Handled_Stmts";
      Rule_Doc_138 : aliased constant Text_Type :=
        "";
      Rule_Desc_138 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_138'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_138'Access,
         Return_Type => Type_Index_For_Handled_Stmts);
      
      Rule_Name_139 : aliased constant Text_Type :=
        "Exception_Handler";
      Rule_Doc_139 : aliased constant Text_Type :=
        "";
      Rule_Desc_139 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_139'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_139'Access,
         Return_Type => Type_Index_For_Exception_Handler);
      
      Rule_Name_140 : aliased constant Text_Type :=
        "Stmts";
      Rule_Doc_140 : aliased constant Text_Type :=
        "";
      Rule_Desc_140 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_140'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_140'Access,
         Return_Type => Type_Index_For_Stmt_List);
      
      Rule_Name_141 : aliased constant Text_Type :=
        "Label";
      Rule_Doc_141 : aliased constant Text_Type :=
        "";
      Rule_Desc_141 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_141'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_141'Access,
         Return_Type => Type_Index_For_Label);
      
      Rule_Name_142 : aliased constant Text_Type :=
        "Stmt";
      Rule_Doc_142 : aliased constant Text_Type :=
        "Parse a statement, a pragma, or a compound statement (trailing semicolon included).";
      Rule_Desc_142 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_142'Access,
         Is_Public   => True,
         Doc         => Rule_Doc_142'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_143 : aliased constant Text_Type :=
        "Call_Stmt";
      Rule_Doc_143 : aliased constant Text_Type :=
        "";
      Rule_Desc_143 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_143'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_143'Access,
         Return_Type => Type_Index_For_Call_Stmt);
      
      Rule_Name_144 : aliased constant Text_Type :=
        "Simple_Stmt";
      Rule_Doc_144 : aliased constant Text_Type :=
        "";
      Rule_Desc_144 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_144'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_144'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_145 : aliased constant Text_Type :=
        "Null_Stmt";
      Rule_Doc_145 : aliased constant Text_Type :=
        "";
      Rule_Desc_145 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_145'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_145'Access,
         Return_Type => Type_Index_For_Null_Stmt);
      
      Rule_Name_146 : aliased constant Text_Type :=
        "Assignment_Stmt";
      Rule_Doc_146 : aliased constant Text_Type :=
        "";
      Rule_Desc_146 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_146'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_146'Access,
         Return_Type => Type_Index_For_Assign_Stmt);
      
      Rule_Name_147 : aliased constant Text_Type :=
        "Goto_Stmt";
      Rule_Doc_147 : aliased constant Text_Type :=
        "";
      Rule_Desc_147 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_147'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_147'Access,
         Return_Type => Type_Index_For_Goto_Stmt);
      
      Rule_Name_148 : aliased constant Text_Type :=
        "Exit_Stmt";
      Rule_Doc_148 : aliased constant Text_Type :=
        "";
      Rule_Desc_148 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_148'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_148'Access,
         Return_Type => Type_Index_For_Exit_Stmt);
      
      Rule_Name_149 : aliased constant Text_Type :=
        "Return_Stmt";
      Rule_Doc_149 : aliased constant Text_Type :=
        "";
      Rule_Desc_149 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_149'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_149'Access,
         Return_Type => Type_Index_For_Return_Stmt);
      
      Rule_Name_150 : aliased constant Text_Type :=
        "Requeue_Stmt";
      Rule_Doc_150 : aliased constant Text_Type :=
        "";
      Rule_Desc_150 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_150'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_150'Access,
         Return_Type => Type_Index_For_Requeue_Stmt);
      
      Rule_Name_151 : aliased constant Text_Type :=
        "Identifier";
      Rule_Doc_151 : aliased constant Text_Type :=
        "";
      Rule_Desc_151 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_151'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_151'Access,
         Return_Type => Type_Index_For_Identifier);
      
      Rule_Name_152 : aliased constant Text_Type :=
        "Char_Literal";
      Rule_Doc_152 : aliased constant Text_Type :=
        "";
      Rule_Desc_152 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_152'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_152'Access,
         Return_Type => Type_Index_For_Char_Literal);
      
      Rule_Name_153 : aliased constant Text_Type :=
        "String_Literal";
      Rule_Doc_153 : aliased constant Text_Type :=
        "";
      Rule_Desc_153 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_153'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_153'Access,
         Return_Type => Type_Index_For_String_Literal);
      
      Rule_Name_154 : aliased constant Text_Type :=
        "Defining_Id";
      Rule_Doc_154 : aliased constant Text_Type :=
        "";
      Rule_Desc_154 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_154'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_154'Access,
         Return_Type => Type_Index_For_Defining_Name);
      
      Rule_Name_155 : aliased constant Text_Type :=
        "Dec_Literal";
      Rule_Doc_155 : aliased constant Text_Type :=
        "";
      Rule_Desc_155 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_155'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_155'Access,
         Return_Type => Type_Index_For_Real_Literal);
      
      Rule_Name_156 : aliased constant Text_Type :=
        "Int_Literal";
      Rule_Doc_156 : aliased constant Text_Type :=
        "";
      Rule_Desc_156 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_156'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_156'Access,
         Return_Type => Type_Index_For_Int_Literal);
      
      Rule_Name_157 : aliased constant Text_Type :=
        "Num_Literal";
      Rule_Doc_157 : aliased constant Text_Type :=
        "";
      Rule_Desc_157 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_157'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_157'Access,
         Return_Type => Type_Index_For_Num_Literal);
      
      Rule_Name_158 : aliased constant Text_Type :=
        "Null_Literal";
      Rule_Doc_158 : aliased constant Text_Type :=
        "";
      Rule_Desc_158 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_158'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_158'Access,
         Return_Type => Type_Index_For_Null_Literal);
      
      Rule_Name_159 : aliased constant Text_Type :=
        "Allocator";
      Rule_Doc_159 : aliased constant Text_Type :=
        "";
      Rule_Desc_159 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_159'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_159'Access,
         Return_Type => Type_Index_For_Allocator);
      
      Rule_Name_160 : aliased constant Text_Type :=
        "For_Loop_Param_Spec";
      Rule_Doc_160 : aliased constant Text_Type :=
        "";
      Rule_Desc_160 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_160'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_160'Access,
         Return_Type => Type_Index_For_For_Loop_Spec);
      
      Rule_Name_161 : aliased constant Text_Type :=
        "Quantified_Expr";
      Rule_Doc_161 : aliased constant Text_Type :=
        "";
      Rule_Desc_161 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_161'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_161'Access,
         Return_Type => Type_Index_For_Quantified_Expr);
      
      Rule_Name_162 : aliased constant Text_Type :=
        "Case_Expr";
      Rule_Doc_162 : aliased constant Text_Type :=
        "";
      Rule_Desc_162 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_162'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_162'Access,
         Return_Type => Type_Index_For_Case_Expr);
      
      Rule_Name_163 : aliased constant Text_Type :=
        "Case_Expr_Alt";
      Rule_Doc_163 : aliased constant Text_Type :=
        "";
      Rule_Desc_163 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_163'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_163'Access,
         Return_Type => Type_Index_For_Case_Expr_Alternative);
      
      Rule_Name_164 : aliased constant Text_Type :=
        "Raise_Expr";
      Rule_Doc_164 : aliased constant Text_Type :=
        "";
      Rule_Desc_164 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_164'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_164'Access,
         Return_Type => Type_Index_For_Raise_Expr);
      
      Rule_Name_165 : aliased constant Text_Type :=
        "If_Expr";
      Rule_Doc_165 : aliased constant Text_Type :=
        "";
      Rule_Desc_165 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_165'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_165'Access,
         Return_Type => Type_Index_For_If_Expr);
      
      Rule_Name_166 : aliased constant Text_Type :=
        "Conditional_Expr";
      Rule_Doc_166 : aliased constant Text_Type :=
        "";
      Rule_Desc_166 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_166'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_166'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_167 : aliased constant Text_Type :=
        "Box_Expr";
      Rule_Doc_167 : aliased constant Text_Type :=
        "";
      Rule_Desc_167 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_167'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_167'Access,
         Return_Type => Type_Index_For_Box_Expr);
      
      Rule_Name_168 : aliased constant Text_Type :=
        "Others_Designator";
      Rule_Doc_168 : aliased constant Text_Type :=
        "";
      Rule_Desc_168 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_168'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_168'Access,
         Return_Type => Type_Index_For_Others_Designator);
      
      Rule_Name_169 : aliased constant Text_Type :=
        "Iterated_Assoc";
      Rule_Doc_169 : aliased constant Text_Type :=
        "";
      Rule_Desc_169 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_169'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_169'Access,
         Return_Type => Type_Index_For_Iterated_Assoc);
      
      Rule_Name_170 : aliased constant Text_Type :=
        "Aggregate_Assoc";
      Rule_Doc_170 : aliased constant Text_Type :=
        "";
      Rule_Desc_170 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_170'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_170'Access,
         Return_Type => Type_Index_For_Basic_Assoc);
      
      Rule_Name_171 : aliased constant Text_Type :=
        "Regular_Aggregate";
      Rule_Doc_171 : aliased constant Text_Type :=
        "";
      Rule_Desc_171 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_171'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_171'Access,
         Return_Type => Type_Index_For_Base_Aggregate);
      
      Rule_Name_172 : aliased constant Text_Type :=
        "Bracket_Aggregate";
      Rule_Doc_172 : aliased constant Text_Type :=
        "";
      Rule_Desc_172 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_172'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_172'Access,
         Return_Type => Type_Index_For_Base_Aggregate);
      
      Rule_Name_173 : aliased constant Text_Type :=
        "Aggregate";
      Rule_Doc_173 : aliased constant Text_Type :=
        "";
      Rule_Desc_173 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_173'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_173'Access,
         Return_Type => Type_Index_For_Base_Aggregate);
      
      Rule_Name_174 : aliased constant Text_Type :=
        "Direct_Name";
      Rule_Doc_174 : aliased constant Text_Type :=
        "";
      Rule_Desc_174 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_174'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_174'Access,
         Return_Type => Type_Index_For_Base_Id);
      
      Rule_Name_175 : aliased constant Text_Type :=
        "Param_Assoc";
      Rule_Doc_175 : aliased constant Text_Type :=
        "";
      Rule_Desc_175 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_175'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_175'Access,
         Return_Type => Type_Index_For_Param_Assoc);
      
      Rule_Name_176 : aliased constant Text_Type :=
        "Call_Suffix";
      Rule_Doc_176 : aliased constant Text_Type :=
        "";
      Rule_Desc_176 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_176'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_176'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_177 : aliased constant Text_Type :=
        "Attr_Suffix";
      Rule_Doc_177 : aliased constant Text_Type :=
        "";
      Rule_Desc_177 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_177'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_177'Access,
         Return_Type => Type_Index_For_Assoc_List);
      
      Rule_Name_178 : aliased constant Text_Type :=
        "Qualified_Name";
      Rule_Doc_178 : aliased constant Text_Type :=
        "";
      Rule_Desc_178 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_178'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_178'Access,
         Return_Type => Type_Index_For_Qual_Expr);
      
      Rule_Name_179 : aliased constant Text_Type :=
        "Qual_Name_Internal";
      Rule_Doc_179 : aliased constant Text_Type :=
        "";
      Rule_Desc_179 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_179'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_179'Access,
         Return_Type => Type_Index_For_Name);
      
      Rule_Name_180 : aliased constant Text_Type :=
        "Value_Sequence";
      Rule_Doc_180 : aliased constant Text_Type :=
        "";
      Rule_Desc_180 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_180'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_180'Access,
         Return_Type => Type_Index_For_Value_Sequence);
      
      Rule_Name_181 : aliased constant Text_Type :=
        "Name";
      Rule_Doc_181 : aliased constant Text_Type :=
        "";
      Rule_Desc_181 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_181'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_181'Access,
         Return_Type => Type_Index_For_Name);
      
      Rule_Name_182 : aliased constant Text_Type :=
        "Defining_Name";
      Rule_Doc_182 : aliased constant Text_Type :=
        "";
      Rule_Desc_182 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_182'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_182'Access,
         Return_Type => Type_Index_For_Defining_Name);
      
      Rule_Name_183 : aliased constant Text_Type :=
        "Direct_Name_Or_Target_Name";
      Rule_Doc_183 : aliased constant Text_Type :=
        "";
      Rule_Desc_183 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_183'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_183'Access,
         Return_Type => Type_Index_For_Name);
      
      Rule_Name_184 : aliased constant Text_Type :=
        "Target_Name";
      Rule_Doc_184 : aliased constant Text_Type :=
        "";
      Rule_Desc_184 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_184'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_184'Access,
         Return_Type => Type_Index_For_Target_Name);
      
      Rule_Name_185 : aliased constant Text_Type :=
        "Update_Attr_Aggregate";
      Rule_Doc_185 : aliased constant Text_Type :=
        "";
      Rule_Desc_185 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_185'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_185'Access,
         Return_Type => Type_Index_For_Base_Aggregate);
      
      Rule_Name_186 : aliased constant Text_Type :=
        "Update_Attr_Content";
      Rule_Doc_186 : aliased constant Text_Type :=
        "";
      Rule_Desc_186 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_186'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_186'Access,
         Return_Type => Type_Index_For_Assoc_List);
      
      Rule_Name_187 : aliased constant Text_Type :=
        "Multidim_Array_Assoc";
      Rule_Doc_187 : aliased constant Text_Type :=
        "";
      Rule_Desc_187 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_187'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_187'Access,
         Return_Type => Type_Index_For_Multi_Dim_Array_Assoc);
      
      Rule_Name_188 : aliased constant Text_Type :=
        "Subtype_Name";
      Rule_Doc_188 : aliased constant Text_Type :=
        "";
      Rule_Desc_188 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_188'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_188'Access,
         Return_Type => Type_Index_For_Name);
      
      Rule_Name_189 : aliased constant Text_Type :=
        "Static_Name";
      Rule_Doc_189 : aliased constant Text_Type :=
        "";
      Rule_Desc_189 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_189'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_189'Access,
         Return_Type => Type_Index_For_Name);
      
      Rule_Name_190 : aliased constant Text_Type :=
        "Primary";
      Rule_Doc_190 : aliased constant Text_Type :=
        "";
      Rule_Desc_190 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_190'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_190'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_191 : aliased constant Text_Type :=
        "Paren_Expr";
      Rule_Doc_191 : aliased constant Text_Type :=
        "";
      Rule_Desc_191 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_191'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_191'Access,
         Return_Type => Type_Index_For_Paren_Expr);
      
      Rule_Name_192 : aliased constant Text_Type :=
        "Declare_Expr";
      Rule_Doc_192 : aliased constant Text_Type :=
        "";
      Rule_Desc_192 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_192'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_192'Access,
         Return_Type => Type_Index_For_Decl_Expr);
      
      Rule_Name_193 : aliased constant Text_Type :=
        "Factor";
      Rule_Doc_193 : aliased constant Text_Type :=
        "";
      Rule_Desc_193 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_193'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_193'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_194 : aliased constant Text_Type :=
        "Term";
      Rule_Doc_194 : aliased constant Text_Type :=
        "";
      Rule_Desc_194 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_194'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_194'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_195 : aliased constant Text_Type :=
        "Unop_Term";
      Rule_Doc_195 : aliased constant Text_Type :=
        "";
      Rule_Desc_195 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_195'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_195'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_196 : aliased constant Text_Type :=
        "Simple_Expr";
      Rule_Doc_196 : aliased constant Text_Type :=
        "";
      Rule_Desc_196 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_196'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_196'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_197 : aliased constant Text_Type :=
        "Boolean_Op";
      Rule_Doc_197 : aliased constant Text_Type :=
        "";
      Rule_Desc_197 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_197'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_197'Access,
         Return_Type => Type_Index_For_Op);
      
      Rule_Name_198 : aliased constant Text_Type :=
        "Discrete_Range";
      Rule_Doc_198 : aliased constant Text_Type :=
        "";
      Rule_Desc_198 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_198'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_198'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_199 : aliased constant Text_Type :=
        "Choice";
      Rule_Doc_199 : aliased constant Text_Type :=
        "";
      Rule_Desc_199 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_199'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_199'Access,
         Return_Type => Type_Index_For_Ada_Node);
      
      Rule_Name_200 : aliased constant Text_Type :=
        "Choice_List";
      Rule_Doc_200 : aliased constant Text_Type :=
        "";
      Rule_Desc_200 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_200'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_200'Access,
         Return_Type => Type_Index_For_Alternatives_List);
      
      Rule_Name_201 : aliased constant Text_Type :=
        "Rel_Op";
      Rule_Doc_201 : aliased constant Text_Type :=
        "";
      Rule_Desc_201 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_201'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_201'Access,
         Return_Type => Type_Index_For_Op);
      
      Rule_Name_202 : aliased constant Text_Type :=
        "Membership_Choice";
      Rule_Doc_202 : aliased constant Text_Type :=
        "";
      Rule_Desc_202 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_202'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_202'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_203 : aliased constant Text_Type :=
        "Membership_Choice_List";
      Rule_Doc_203 : aliased constant Text_Type :=
        "";
      Rule_Desc_203 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_203'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_203'Access,
         Return_Type => Type_Index_For_Expr_Alternatives_List);
      
      Rule_Name_204 : aliased constant Text_Type :=
        "Relation";
      Rule_Doc_204 : aliased constant Text_Type :=
        "";
      Rule_Desc_204 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_204'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_204'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_205 : aliased constant Text_Type :=
        "Expr";
      Rule_Doc_205 : aliased constant Text_Type :=
        "Parse an expression.";
      Rule_Desc_205 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_205'Access,
         Is_Public   => True,
         Doc         => Rule_Doc_205'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_206 : aliased constant Text_Type :=
        "Pp_Directive";
      Rule_Doc_206 : aliased constant Text_Type :=
        "Parse a preprocessor directive.";
      Rule_Desc_206 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_206'Access,
         Is_Public   => True,
         Doc         => Rule_Doc_206'Access,
         Return_Type => Type_Index_For_Pp_Directive);
      
      Rule_Name_207 : aliased constant Text_Type :=
        "Pp_Then";
      Rule_Doc_207 : aliased constant Text_Type :=
        "";
      Rule_Desc_207 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_207'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_207'Access,
         Return_Type => Type_Index_For_Pp_Then_Kw);
      
      Rule_Name_208 : aliased constant Text_Type :=
        "Pp_Expr";
      Rule_Doc_208 : aliased constant Text_Type :=
        "";
      Rule_Desc_208 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_208'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_208'Access,
         Return_Type => Type_Index_For_Expr);
      
      Rule_Name_209 : aliased constant Text_Type :=
        "Pp_Term";
      Rule_Doc_209 : aliased constant Text_Type :=
        "";
      Rule_Desc_209 : aliased constant Grammar_Rule_Descriptor :=
        (Name        => Rule_Name_209'Access,
         Is_Public   => False,
         Doc         => Rule_Doc_209'Access,
         Return_Type => Type_Index_For_Expr);

   Grammar_Rules : aliased constant Grammar_Rule_Descriptor_Array := (
      1 => Rule_Desc_1'Access,
2 => Rule_Desc_2'Access,
3 => Rule_Desc_3'Access,
4 => Rule_Desc_4'Access,
5 => Rule_Desc_5'Access,
6 => Rule_Desc_6'Access,
7 => Rule_Desc_7'Access,
8 => Rule_Desc_8'Access,
9 => Rule_Desc_9'Access,
10 => Rule_Desc_10'Access,
11 => Rule_Desc_11'Access,
12 => Rule_Desc_12'Access,
13 => Rule_Desc_13'Access,
14 => Rule_Desc_14'Access,
15 => Rule_Desc_15'Access,
16 => Rule_Desc_16'Access,
17 => Rule_Desc_17'Access,
18 => Rule_Desc_18'Access,
19 => Rule_Desc_19'Access,
20 => Rule_Desc_20'Access,
21 => Rule_Desc_21'Access,
22 => Rule_Desc_22'Access,
23 => Rule_Desc_23'Access,
24 => Rule_Desc_24'Access,
25 => Rule_Desc_25'Access,
26 => Rule_Desc_26'Access,
27 => Rule_Desc_27'Access,
28 => Rule_Desc_28'Access,
29 => Rule_Desc_29'Access,
30 => Rule_Desc_30'Access,
31 => Rule_Desc_31'Access,
32 => Rule_Desc_32'Access,
33 => Rule_Desc_33'Access,
34 => Rule_Desc_34'Access,
35 => Rule_Desc_35'Access,
36 => Rule_Desc_36'Access,
37 => Rule_Desc_37'Access,
38 => Rule_Desc_38'Access,
39 => Rule_Desc_39'Access,
40 => Rule_Desc_40'Access,
41 => Rule_Desc_41'Access,
42 => Rule_Desc_42'Access,
43 => Rule_Desc_43'Access,
44 => Rule_Desc_44'Access,
45 => Rule_Desc_45'Access,
46 => Rule_Desc_46'Access,
47 => Rule_Desc_47'Access,
48 => Rule_Desc_48'Access,
49 => Rule_Desc_49'Access,
50 => Rule_Desc_50'Access,
51 => Rule_Desc_51'Access,
52 => Rule_Desc_52'Access,
53 => Rule_Desc_53'Access,
54 => Rule_Desc_54'Access,
55 => Rule_Desc_55'Access,
56 => Rule_Desc_56'Access,
57 => Rule_Desc_57'Access,
58 => Rule_Desc_58'Access,
59 => Rule_Desc_59'Access,
60 => Rule_Desc_60'Access,
61 => Rule_Desc_61'Access,
62 => Rule_Desc_62'Access,
63 => Rule_Desc_63'Access,
64 => Rule_Desc_64'Access,
65 => Rule_Desc_65'Access,
66 => Rule_Desc_66'Access,
67 => Rule_Desc_67'Access,
68 => Rule_Desc_68'Access,
69 => Rule_Desc_69'Access,
70 => Rule_Desc_70'Access,
71 => Rule_Desc_71'Access,
72 => Rule_Desc_72'Access,
73 => Rule_Desc_73'Access,
74 => Rule_Desc_74'Access,
75 => Rule_Desc_75'Access,
76 => Rule_Desc_76'Access,
77 => Rule_Desc_77'Access,
78 => Rule_Desc_78'Access,
79 => Rule_Desc_79'Access,
80 => Rule_Desc_80'Access,
81 => Rule_Desc_81'Access,
82 => Rule_Desc_82'Access,
83 => Rule_Desc_83'Access,
84 => Rule_Desc_84'Access,
85 => Rule_Desc_85'Access,
86 => Rule_Desc_86'Access,
87 => Rule_Desc_87'Access,
88 => Rule_Desc_88'Access,
89 => Rule_Desc_89'Access,
90 => Rule_Desc_90'Access,
91 => Rule_Desc_91'Access,
92 => Rule_Desc_92'Access,
93 => Rule_Desc_93'Access,
94 => Rule_Desc_94'Access,
95 => Rule_Desc_95'Access,
96 => Rule_Desc_96'Access,
97 => Rule_Desc_97'Access,
98 => Rule_Desc_98'Access,
99 => Rule_Desc_99'Access,
100 => Rule_Desc_100'Access,
101 => Rule_Desc_101'Access,
102 => Rule_Desc_102'Access,
103 => Rule_Desc_103'Access,
104 => Rule_Desc_104'Access,
105 => Rule_Desc_105'Access,
106 => Rule_Desc_106'Access,
107 => Rule_Desc_107'Access,
108 => Rule_Desc_108'Access,
109 => Rule_Desc_109'Access,
110 => Rule_Desc_110'Access,
111 => Rule_Desc_111'Access,
112 => Rule_Desc_112'Access,
113 => Rule_Desc_113'Access,
114 => Rule_Desc_114'Access,
115 => Rule_Desc_115'Access,
116 => Rule_Desc_116'Access,
117 => Rule_Desc_117'Access,
118 => Rule_Desc_118'Access,
119 => Rule_Desc_119'Access,
120 => Rule_Desc_120'Access,
121 => Rule_Desc_121'Access,
122 => Rule_Desc_122'Access,
123 => Rule_Desc_123'Access,
124 => Rule_Desc_124'Access,
125 => Rule_Desc_125'Access,
126 => Rule_Desc_126'Access,
127 => Rule_Desc_127'Access,
128 => Rule_Desc_128'Access,
129 => Rule_Desc_129'Access,
130 => Rule_Desc_130'Access,
131 => Rule_Desc_131'Access,
132 => Rule_Desc_132'Access,
133 => Rule_Desc_133'Access,
134 => Rule_Desc_134'Access,
135 => Rule_Desc_135'Access,
136 => Rule_Desc_136'Access,
137 => Rule_Desc_137'Access,
138 => Rule_Desc_138'Access,
139 => Rule_Desc_139'Access,
140 => Rule_Desc_140'Access,
141 => Rule_Desc_141'Access,
142 => Rule_Desc_142'Access,
143 => Rule_Desc_143'Access,
144 => Rule_Desc_144'Access,
145 => Rule_Desc_145'Access,
146 => Rule_Desc_146'Access,
147 => Rule_Desc_147'Access,
148 => Rule_Desc_148'Access,
149 => Rule_Desc_149'Access,
150 => Rule_Desc_150'Access,
151 => Rule_Desc_151'Access,
152 => Rule_Desc_152'Access,
153 => Rule_Desc_153'Access,
154 => Rule_Desc_154'Access,
155 => Rule_Desc_155'Access,
156 => Rule_Desc_156'Access,
157 => Rule_Desc_157'Access,
158 => Rule_Desc_158'Access,
159 => Rule_Desc_159'Access,
160 => Rule_Desc_160'Access,
161 => Rule_Desc_161'Access,
162 => Rule_Desc_162'Access,
163 => Rule_Desc_163'Access,
164 => Rule_Desc_164'Access,
165 => Rule_Desc_165'Access,
166 => Rule_Desc_166'Access,
167 => Rule_Desc_167'Access,
168 => Rule_Desc_168'Access,
169 => Rule_Desc_169'Access,
170 => Rule_Desc_170'Access,
171 => Rule_Desc_171'Access,
172 => Rule_Desc_172'Access,
173 => Rule_Desc_173'Access,
174 => Rule_Desc_174'Access,
175 => Rule_Desc_175'Access,
176 => Rule_Desc_176'Access,
177 => Rule_Desc_177'Access,
178 => Rule_Desc_178'Access,
179 => Rule_Desc_179'Access,
180 => Rule_Desc_180'Access,
181 => Rule_Desc_181'Access,
182 => Rule_Desc_182'Access,
183 => Rule_Desc_183'Access,
184 => Rule_Desc_184'Access,
185 => Rule_Desc_185'Access,
186 => Rule_Desc_186'Access,
187 => Rule_Desc_187'Access,
188 => Rule_Desc_188'Access,
189 => Rule_Desc_189'Access,
190 => Rule_Desc_190'Access,
191 => Rule_Desc_191'Access,
192 => Rule_Desc_192'Access,
193 => Rule_Desc_193'Access,
194 => Rule_Desc_194'Access,
195 => Rule_Desc_195'Access,
196 => Rule_Desc_196'Access,
197 => Rule_Desc_197'Access,
198 => Rule_Desc_198'Access,
199 => Rule_Desc_199'Access,
200 => Rule_Desc_200'Access,
201 => Rule_Desc_201'Access,
202 => Rule_Desc_202'Access,
203 => Rule_Desc_203'Access,
204 => Rule_Desc_204'Access,
205 => Rule_Desc_205'Access,
206 => Rule_Desc_206'Access,
207 => Rule_Desc_207'Access,
208 => Rule_Desc_208'Access,
209 => Rule_Desc_209'Access
   );

   ------------------------------------
   -- General value type descriptors --
   ------------------------------------

   
      
      Debug_Name_For_Internal_Unit : aliased constant String :=
        "AnalysisUnit";
      Desc_For_Internal_Unit : aliased constant Type_Descriptor :=
        (Category   => Analysis_Unit_Category,
         Debug_Name => Debug_Name_For_Internal_Unit'Access);
      
      Debug_Name_For_Big_Integer_Type : aliased constant String :=
        "BigInt";
      Desc_For_Big_Integer_Type : aliased constant Type_Descriptor :=
        (Category   => Big_Int_Category,
         Debug_Name => Debug_Name_For_Big_Integer_Type'Access);
      
      Debug_Name_For_Boolean : aliased constant String :=
        "Bool";
      Desc_For_Boolean : aliased constant Type_Descriptor :=
        (Category   => Bool_Category,
         Debug_Name => Debug_Name_For_Boolean'Access);
      
      Debug_Name_For_Character_Type : aliased constant String :=
        "Character";
      Desc_For_Character_Type : aliased constant Type_Descriptor :=
        (Category   => Char_Category,
         Debug_Name => Debug_Name_For_Character_Type'Access);
      
      Debug_Name_For_Integer : aliased constant String :=
        "Int";
      Desc_For_Integer : aliased constant Type_Descriptor :=
        (Category   => Int_Category,
         Debug_Name => Debug_Name_For_Integer'Access);
      
      Debug_Name_For_Source_Location_Range : aliased constant String :=
        "SourceLocationRange";
      Desc_For_Source_Location_Range : aliased constant Type_Descriptor :=
        (Category   => Source_Location_Range_Category,
         Debug_Name => Debug_Name_For_Source_Location_Range'Access);
      
      Debug_Name_For_String_Type : aliased constant String :=
        "String";
      Desc_For_String_Type : aliased constant Type_Descriptor :=
        (Category   => String_Category,
         Debug_Name => Debug_Name_For_String_Type'Access);
      
      Debug_Name_For_Token_Reference : aliased constant String :=
        "Token";
      Desc_For_Token_Reference : aliased constant Type_Descriptor :=
        (Category   => Token_Category,
         Debug_Name => Debug_Name_For_Token_Reference'Access);
      
      Debug_Name_For_Symbol_Type : aliased constant String :=
        "Symbol";
      Desc_For_Symbol_Type : aliased constant Type_Descriptor :=
        (Category   => Symbol_Category,
         Debug_Name => Debug_Name_For_Symbol_Type'Access);
      
      Debug_Name_For_Analysis_Unit_Kind : aliased constant String :=
        "AnalysisUnitKind";
      Desc_For_Analysis_Unit_Kind : aliased constant Type_Descriptor :=
        (Category   => Enum_Category,
         Debug_Name => Debug_Name_For_Analysis_Unit_Kind'Access);
      
      Debug_Name_For_Lookup_Kind : aliased constant String :=
        "LookupKind";
      Desc_For_Lookup_Kind : aliased constant Type_Descriptor :=
        (Category   => Enum_Category,
         Debug_Name => Debug_Name_For_Lookup_Kind'Access);
      
      Debug_Name_For_Designated_Env_Kind : aliased constant String :=
        "DesignatedEnvKind";
      Desc_For_Designated_Env_Kind : aliased constant Type_Descriptor :=
        (Category   => Enum_Category,
         Debug_Name => Debug_Name_For_Designated_Env_Kind'Access);
      
      Debug_Name_For_Ref_Result_Kind : aliased constant String :=
        "RefResultKind";
      Desc_For_Ref_Result_Kind : aliased constant Type_Descriptor :=
        (Category   => Enum_Category,
         Debug_Name => Debug_Name_For_Ref_Result_Kind'Access);
      
      Debug_Name_For_Call_Expr_Kind : aliased constant String :=
        "CallExprKind";
      Desc_For_Call_Expr_Kind : aliased constant Type_Descriptor :=
        (Category   => Enum_Category,
         Debug_Name => Debug_Name_For_Call_Expr_Kind'Access);
      
      Debug_Name_For_Grammar_Rule : aliased constant String :=
        "GrammarRule";
      Desc_For_Grammar_Rule : aliased constant Type_Descriptor :=
        (Category   => Enum_Category,
         Debug_Name => Debug_Name_For_Grammar_Rule'Access);
      
      Debug_Name_For_Internal_Discriminant_Values_Array_Access : aliased constant String :=
        "DiscriminantValues.array";
      Desc_For_Internal_Discriminant_Values_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Discriminant_Values_Array_Access'Access);
      
      Debug_Name_For_Internal_Doc_Annotation_Array_Access : aliased constant String :=
        "DocAnnotation.array";
      Desc_For_Internal_Doc_Annotation_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Doc_Annotation_Array_Access'Access);
      
      Debug_Name_For_Internal_Entity_Accept_Stmt_Array_Access : aliased constant String :=
        "AcceptStmt.array";
      Desc_For_Internal_Entity_Accept_Stmt_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Accept_Stmt_Array_Access'Access);
      
      Debug_Name_For_Internal_Entity_Array_Access : aliased constant String :=
        "AdaNode.array";
      Desc_For_Internal_Entity_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Array_Access'Access);
      
      Debug_Name_For_Internal_Entity_Base_Formal_Param_Decl_Array_Access : aliased constant String :=
        "BaseFormalParamDecl.array";
      Desc_For_Internal_Entity_Base_Formal_Param_Decl_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Formal_Param_Decl_Array_Access'Access);
      
      Debug_Name_For_Internal_Entity_Base_Type_Decl_Array_Access : aliased constant String :=
        "BaseTypeDecl.array";
      Desc_For_Internal_Entity_Base_Type_Decl_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Type_Decl_Array_Access'Access);
      
      Debug_Name_For_Internal_Entity_Basic_Decl_Array_Access : aliased constant String :=
        "BasicDecl.array";
      Desc_For_Internal_Entity_Basic_Decl_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Basic_Decl_Array_Access'Access);
      
      Debug_Name_For_Internal_Entity_Compilation_Unit_Array_Access : aliased constant String :=
        "CompilationUnit.array";
      Desc_For_Internal_Entity_Compilation_Unit_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Compilation_Unit_Array_Access'Access);
      
      Debug_Name_For_Internal_Entity_Defining_Name_Array_Access : aliased constant String :=
        "DefiningName.array";
      Desc_For_Internal_Entity_Defining_Name_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Defining_Name_Array_Access'Access);
      
      Debug_Name_For_Internal_Entity_Expr_Array_Access : aliased constant String :=
        "Expr.array";
      Desc_For_Internal_Entity_Expr_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Expr_Array_Access'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Instantiation_Array_Access : aliased constant String :=
        "GenericInstantiation.array";
      Desc_For_Internal_Entity_Generic_Instantiation_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Instantiation_Array_Access'Access);
      
      Debug_Name_For_Internal_Entity_Param_Spec_Array_Access : aliased constant String :=
        "ParamSpec.array";
      Desc_For_Internal_Entity_Param_Spec_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Param_Spec_Array_Access'Access);
      
      Debug_Name_For_Internal_Entity_Pragma_Node_Array_Access : aliased constant String :=
        "Pragma.array";
      Desc_For_Internal_Entity_Pragma_Node_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Pragma_Node_Array_Access'Access);
      
      Debug_Name_For_Internal_Entity_Type_Decl_Array_Access : aliased constant String :=
        "TypeDecl.array";
      Desc_For_Internal_Entity_Type_Decl_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Type_Decl_Array_Access'Access);
      
      Debug_Name_For_Internal_Param_Actual_Array_Access : aliased constant String :=
        "ParamActual.array";
      Desc_For_Internal_Param_Actual_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Param_Actual_Array_Access'Access);
      
      Debug_Name_For_Internal_Ref_Result_Array_Access : aliased constant String :=
        "RefResult.array";
      Desc_For_Internal_Ref_Result_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Ref_Result_Array_Access'Access);
      
      Debug_Name_For_Internal_Shape_Array_Access : aliased constant String :=
        "Shape.array";
      Desc_For_Internal_Shape_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Shape_Array_Access'Access);
      
      Debug_Name_For_Internal_Substitution_Array_Access : aliased constant String :=
        "Substitution.array";
      Desc_For_Internal_Substitution_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Substitution_Array_Access'Access);
      
      Debug_Name_For_Internal_Unit_Array_Access : aliased constant String :=
        "AnalysisUnit.array";
      Desc_For_Internal_Unit_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Internal_Unit_Array_Access'Access);
      
      Debug_Name_For_Symbol_Type_Array_Access : aliased constant String :=
        "Symbol.array";
      Desc_For_Symbol_Type_Array_Access : aliased constant Type_Descriptor :=
        (Category   => Array_Category,
         Debug_Name => Debug_Name_For_Symbol_Type_Array_Access'Access);
      
      Debug_Name_For_Internal_Completion_Item_Iterator_Access : aliased constant String :=
        "CompletionItem.iterator";
      Desc_For_Internal_Completion_Item_Iterator_Access : aliased constant Type_Descriptor :=
        (Category   => Iterator_Category,
         Debug_Name => Debug_Name_For_Internal_Completion_Item_Iterator_Access'Access);
      
      Debug_Name_For_Internal_Aspect : aliased constant String :=
        "Aspect";
      Desc_For_Internal_Aspect : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Aspect'Access);
      
      Debug_Name_For_Internal_Completion_Item : aliased constant String :=
        "CompletionItem";
      Desc_For_Internal_Completion_Item : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Completion_Item'Access);
      
      Debug_Name_For_Internal_Discrete_Range : aliased constant String :=
        "DiscreteRange";
      Desc_For_Internal_Discrete_Range : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Discrete_Range'Access);
      
      Debug_Name_For_Internal_Discriminant_Values : aliased constant String :=
        "DiscriminantValues";
      Desc_For_Internal_Discriminant_Values : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Discriminant_Values'Access);
      
      Debug_Name_For_Internal_Doc_Annotation : aliased constant String :=
        "DocAnnotation";
      Desc_For_Internal_Doc_Annotation : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Doc_Annotation'Access);
      
      Debug_Name_For_Internal_Param_Actual : aliased constant String :=
        "ParamActual";
      Desc_For_Internal_Param_Actual : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Param_Actual'Access);
      
      Debug_Name_For_Internal_Ref_Result : aliased constant String :=
        "RefResult";
      Desc_For_Internal_Ref_Result : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Ref_Result'Access);
      
      Debug_Name_For_Internal_Refd_Decl : aliased constant String :=
        "RefdDecl";
      Desc_For_Internal_Refd_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Refd_Decl'Access);
      
      Debug_Name_For_Internal_Refd_Def : aliased constant String :=
        "RefdDef";
      Desc_For_Internal_Refd_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Refd_Def'Access);
      
      Debug_Name_For_Internal_Shape : aliased constant String :=
        "Shape";
      Desc_For_Internal_Shape : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Shape'Access);
      
      Debug_Name_For_Internal_Substitution : aliased constant String :=
        "Substitution";
      Desc_For_Internal_Substitution : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Substitution'Access);
      
      Debug_Name_For_Internal_Entity : aliased constant String :=
        "AdaNode";
      Desc_For_Internal_Entity : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity'Access);
      
      Debug_Name_For_Internal_Entity_Abort_Node : aliased constant String :=
        "Abort";
      Desc_For_Internal_Entity_Abort_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abort_Node'Access);
      
      Debug_Name_For_Internal_Entity_Abort_Absent : aliased constant String :=
        "Abort.Absent";
      Desc_For_Internal_Entity_Abort_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abort_Absent'Access);
      
      Debug_Name_For_Internal_Entity_Abort_Present : aliased constant String :=
        "Abort.Present";
      Desc_For_Internal_Entity_Abort_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abort_Present'Access);
      
      Debug_Name_For_Internal_Entity_Abstract_Node : aliased constant String :=
        "Abstract";
      Desc_For_Internal_Entity_Abstract_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abstract_Node'Access);
      
      Debug_Name_For_Internal_Entity_Abstract_Absent : aliased constant String :=
        "Abstract.Absent";
      Desc_For_Internal_Entity_Abstract_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abstract_Absent'Access);
      
      Debug_Name_For_Internal_Entity_Abstract_Present : aliased constant String :=
        "Abstract.Present";
      Desc_For_Internal_Entity_Abstract_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abstract_Present'Access);
      
      Debug_Name_For_Internal_Entity_Ada_List : aliased constant String :=
        "AdaList";
      Desc_For_Internal_Entity_Ada_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Ada_List'Access);
      
      Debug_Name_For_Internal_Entity_Ada_Node_List : aliased constant String :=
        "AdaNode.list";
      Desc_For_Internal_Entity_Ada_Node_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Ada_Node_List'Access);
      
      Debug_Name_For_Internal_Entity_Abstract_State_Decl_List : aliased constant String :=
        "AbstractStateDeclList";
      Desc_For_Internal_Entity_Abstract_State_Decl_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abstract_State_Decl_List'Access);
      
      Debug_Name_For_Internal_Entity_Alternatives_List : aliased constant String :=
        "AlternativesList";
      Desc_For_Internal_Entity_Alternatives_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Alternatives_List'Access);
      
      Debug_Name_For_Internal_Entity_Constraint_List : aliased constant String :=
        "ConstraintList";
      Desc_For_Internal_Entity_Constraint_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Constraint_List'Access);
      
      Debug_Name_For_Internal_Entity_Decl_List : aliased constant String :=
        "DeclList";
      Desc_For_Internal_Entity_Decl_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Decl_List'Access);
      
      Debug_Name_For_Internal_Entity_Stmt_List : aliased constant String :=
        "StmtList";
      Desc_For_Internal_Entity_Stmt_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Stmt_List'Access);
      
      Debug_Name_For_Internal_Entity_Aspect_Assoc_List : aliased constant String :=
        "AspectAssoc.list";
      Desc_For_Internal_Entity_Aspect_Assoc_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Aspect_Assoc_List'Access);
      
      Debug_Name_For_Internal_Entity_Base_Assoc_List : aliased constant String :=
        "BaseAssoc.list";
      Desc_For_Internal_Entity_Base_Assoc_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Assoc_List'Access);
      
      Debug_Name_For_Internal_Entity_Basic_Assoc_List : aliased constant String :=
        "BasicAssoc.list";
      Desc_For_Internal_Entity_Basic_Assoc_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Basic_Assoc_List'Access);
      
      Debug_Name_For_Internal_Entity_Assoc_List : aliased constant String :=
        "AssocList";
      Desc_For_Internal_Entity_Assoc_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Assoc_List'Access);
      
      Debug_Name_For_Internal_Entity_Basic_Decl_List : aliased constant String :=
        "BasicDecl.list";
      Desc_For_Internal_Entity_Basic_Decl_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Basic_Decl_List'Access);
      
      Debug_Name_For_Internal_Entity_Case_Expr_Alternative_List : aliased constant String :=
        "CaseExprAlternative.list";
      Desc_For_Internal_Entity_Case_Expr_Alternative_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Case_Expr_Alternative_List'Access);
      
      Debug_Name_For_Internal_Entity_Case_Stmt_Alternative_List : aliased constant String :=
        "CaseStmtAlternative.list";
      Desc_For_Internal_Entity_Case_Stmt_Alternative_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Case_Stmt_Alternative_List'Access);
      
      Debug_Name_For_Internal_Entity_Compilation_Unit_List : aliased constant String :=
        "CompilationUnit.list";
      Desc_For_Internal_Entity_Compilation_Unit_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Compilation_Unit_List'Access);
      
      Debug_Name_For_Internal_Entity_Concat_Operand_List : aliased constant String :=
        "ConcatOperand.list";
      Desc_For_Internal_Entity_Concat_Operand_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Concat_Operand_List'Access);
      
      Debug_Name_For_Internal_Entity_Contract_Case_Assoc_List : aliased constant String :=
        "ContractCaseAssoc.list";
      Desc_For_Internal_Entity_Contract_Case_Assoc_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Contract_Case_Assoc_List'Access);
      
      Debug_Name_For_Internal_Entity_Defining_Name_List : aliased constant String :=
        "DefiningName.list";
      Desc_For_Internal_Entity_Defining_Name_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Defining_Name_List'Access);
      
      Debug_Name_For_Internal_Entity_Discriminant_Spec_List : aliased constant String :=
        "DiscriminantSpec.list";
      Desc_For_Internal_Entity_Discriminant_Spec_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Discriminant_Spec_List'Access);
      
      Debug_Name_For_Internal_Entity_Elsif_Expr_Part_List : aliased constant String :=
        "ElsifExprPart.list";
      Desc_For_Internal_Entity_Elsif_Expr_Part_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Elsif_Expr_Part_List'Access);
      
      Debug_Name_For_Internal_Entity_Elsif_Stmt_Part_List : aliased constant String :=
        "ElsifStmtPart.list";
      Desc_For_Internal_Entity_Elsif_Stmt_Part_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Elsif_Stmt_Part_List'Access);
      
      Debug_Name_For_Internal_Entity_Enum_Literal_Decl_List : aliased constant String :=
        "EnumLiteralDecl.list";
      Desc_For_Internal_Entity_Enum_Literal_Decl_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Enum_Literal_Decl_List'Access);
      
      Debug_Name_For_Internal_Entity_Expr_List : aliased constant String :=
        "Expr.list";
      Desc_For_Internal_Entity_Expr_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Expr_List'Access);
      
      Debug_Name_For_Internal_Entity_Expr_Alternatives_List : aliased constant String :=
        "ExprAlternativesList";
      Desc_For_Internal_Entity_Expr_Alternatives_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Expr_Alternatives_List'Access);
      
      Debug_Name_For_Internal_Entity_Identifier_List : aliased constant String :=
        "Identifier.list";
      Desc_For_Internal_Entity_Identifier_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Identifier_List'Access);
      
      Debug_Name_For_Internal_Entity_Discriminant_Choice_List : aliased constant String :=
        "DiscriminantChoiceList";
      Desc_For_Internal_Entity_Discriminant_Choice_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Discriminant_Choice_List'Access);
      
      Debug_Name_For_Internal_Entity_Name_List : aliased constant String :=
        "Name.list";
      Desc_For_Internal_Entity_Name_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Name_List'Access);
      
      Debug_Name_For_Internal_Entity_Parent_List : aliased constant String :=
        "ParentList";
      Desc_For_Internal_Entity_Parent_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Parent_List'Access);
      
      Debug_Name_For_Internal_Entity_Param_Spec_List : aliased constant String :=
        "ParamSpec.list";
      Desc_For_Internal_Entity_Param_Spec_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Param_Spec_List'Access);
      
      Debug_Name_For_Internal_Entity_Pragma_Node_List : aliased constant String :=
        "Pragma.list";
      Desc_For_Internal_Entity_Pragma_Node_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Pragma_Node_List'Access);
      
      Debug_Name_For_Internal_Entity_Select_When_Part_List : aliased constant String :=
        "SelectWhenPart.list";
      Desc_For_Internal_Entity_Select_When_Part_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Select_When_Part_List'Access);
      
      Debug_Name_For_Internal_Entity_Unconstrained_Array_Index_List : aliased constant String :=
        "UnconstrainedArrayIndex.list";
      Desc_For_Internal_Entity_Unconstrained_Array_Index_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Unconstrained_Array_Index_List'Access);
      
      Debug_Name_For_Internal_Entity_Variant_List : aliased constant String :=
        "Variant.list";
      Desc_For_Internal_Entity_Variant_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Variant_List'Access);
      
      Debug_Name_For_Internal_Entity_Aliased_Node : aliased constant String :=
        "Aliased";
      Desc_For_Internal_Entity_Aliased_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Aliased_Node'Access);
      
      Debug_Name_For_Internal_Entity_Aliased_Absent : aliased constant String :=
        "Aliased.Absent";
      Desc_For_Internal_Entity_Aliased_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Aliased_Absent'Access);
      
      Debug_Name_For_Internal_Entity_Aliased_Present : aliased constant String :=
        "Aliased.Present";
      Desc_For_Internal_Entity_Aliased_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Aliased_Present'Access);
      
      Debug_Name_For_Internal_Entity_All_Node : aliased constant String :=
        "All";
      Desc_For_Internal_Entity_All_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_All_Node'Access);
      
      Debug_Name_For_Internal_Entity_All_Absent : aliased constant String :=
        "All.Absent";
      Desc_For_Internal_Entity_All_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_All_Absent'Access);
      
      Debug_Name_For_Internal_Entity_All_Present : aliased constant String :=
        "All.Present";
      Desc_For_Internal_Entity_All_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_All_Present'Access);
      
      Debug_Name_For_Internal_Entity_Array_Indices : aliased constant String :=
        "ArrayIndices";
      Desc_For_Internal_Entity_Array_Indices : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Array_Indices'Access);
      
      Debug_Name_For_Internal_Entity_Constrained_Array_Indices : aliased constant String :=
        "ConstrainedArrayIndices";
      Desc_For_Internal_Entity_Constrained_Array_Indices : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Constrained_Array_Indices'Access);
      
      Debug_Name_For_Internal_Entity_Unconstrained_Array_Indices : aliased constant String :=
        "UnconstrainedArrayIndices";
      Desc_For_Internal_Entity_Unconstrained_Array_Indices : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Unconstrained_Array_Indices'Access);
      
      Debug_Name_For_Internal_Entity_Aspect_Assoc : aliased constant String :=
        "AspectAssoc";
      Desc_For_Internal_Entity_Aspect_Assoc : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Aspect_Assoc'Access);
      
      Debug_Name_For_Internal_Entity_Aspect_Clause : aliased constant String :=
        "AspectClause";
      Desc_For_Internal_Entity_Aspect_Clause : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Aspect_Clause'Access);
      
      Debug_Name_For_Internal_Entity_At_Clause : aliased constant String :=
        "AtClause";
      Desc_For_Internal_Entity_At_Clause : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_At_Clause'Access);
      
      Debug_Name_For_Internal_Entity_Attribute_Def_Clause : aliased constant String :=
        "AttributeDefClause";
      Desc_For_Internal_Entity_Attribute_Def_Clause : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attribute_Def_Clause'Access);
      
      Debug_Name_For_Internal_Entity_Enum_Rep_Clause : aliased constant String :=
        "EnumRepClause";
      Desc_For_Internal_Entity_Enum_Rep_Clause : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Enum_Rep_Clause'Access);
      
      Debug_Name_For_Internal_Entity_Record_Rep_Clause : aliased constant String :=
        "RecordRepClause";
      Desc_For_Internal_Entity_Record_Rep_Clause : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Record_Rep_Clause'Access);
      
      Debug_Name_For_Internal_Entity_Aspect_Spec : aliased constant String :=
        "AspectSpec";
      Desc_For_Internal_Entity_Aspect_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Aspect_Spec'Access);
      
      Debug_Name_For_Internal_Entity_Base_Assoc : aliased constant String :=
        "BaseAssoc";
      Desc_For_Internal_Entity_Base_Assoc : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Assoc'Access);
      
      Debug_Name_For_Internal_Entity_Contract_Case_Assoc : aliased constant String :=
        "ContractCaseAssoc";
      Desc_For_Internal_Entity_Contract_Case_Assoc : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Contract_Case_Assoc'Access);
      
      Debug_Name_For_Internal_Entity_Pragma_Argument_Assoc : aliased constant String :=
        "PragmaArgumentAssoc";
      Desc_For_Internal_Entity_Pragma_Argument_Assoc : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Pragma_Argument_Assoc'Access);
      
      Debug_Name_For_Internal_Entity_Base_Formal_Param_Holder : aliased constant String :=
        "BaseFormalParamHolder";
      Desc_For_Internal_Entity_Base_Formal_Param_Holder : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Formal_Param_Holder'Access);
      
      Debug_Name_For_Internal_Entity_Base_Subp_Spec : aliased constant String :=
        "BaseSubpSpec";
      Desc_For_Internal_Entity_Base_Subp_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Subp_Spec'Access);
      
      Debug_Name_For_Internal_Entity_Entry_Spec : aliased constant String :=
        "EntrySpec";
      Desc_For_Internal_Entity_Entry_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Entry_Spec'Access);
      
      Debug_Name_For_Internal_Entity_Enum_Subp_Spec : aliased constant String :=
        "EnumSubpSpec";
      Desc_For_Internal_Entity_Enum_Subp_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Enum_Subp_Spec'Access);
      
      Debug_Name_For_Internal_Entity_Subp_Spec : aliased constant String :=
        "SubpSpec";
      Desc_For_Internal_Entity_Subp_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Subp_Spec'Access);
      
      Debug_Name_For_Internal_Entity_Synthetic_Binary_Spec : aliased constant String :=
        "SyntheticBinarySpec";
      Desc_For_Internal_Entity_Synthetic_Binary_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Synthetic_Binary_Spec'Access);
      
      Debug_Name_For_Internal_Entity_Synthetic_Unary_Spec : aliased constant String :=
        "SyntheticUnarySpec";
      Desc_For_Internal_Entity_Synthetic_Unary_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Synthetic_Unary_Spec'Access);
      
      Debug_Name_For_Internal_Entity_Component_List : aliased constant String :=
        "ComponentList";
      Desc_For_Internal_Entity_Component_List : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Component_List'Access);
      
      Debug_Name_For_Internal_Entity_Discriminant_Part : aliased constant String :=
        "DiscriminantPart";
      Desc_For_Internal_Entity_Discriminant_Part : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Discriminant_Part'Access);
      
      Debug_Name_For_Internal_Entity_Known_Discriminant_Part : aliased constant String :=
        "KnownDiscriminantPart";
      Desc_For_Internal_Entity_Known_Discriminant_Part : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Known_Discriminant_Part'Access);
      
      Debug_Name_For_Internal_Entity_Unknown_Discriminant_Part : aliased constant String :=
        "UnknownDiscriminantPart";
      Desc_For_Internal_Entity_Unknown_Discriminant_Part : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Unknown_Discriminant_Part'Access);
      
      Debug_Name_For_Internal_Entity_Entry_Completion_Formal_Params : aliased constant String :=
        "EntryCompletionFormalParams";
      Desc_For_Internal_Entity_Entry_Completion_Formal_Params : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Entry_Completion_Formal_Params'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Formal_Part : aliased constant String :=
        "GenericFormalPart";
      Desc_For_Internal_Entity_Generic_Formal_Part : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Formal_Part'Access);
      
      Debug_Name_For_Internal_Entity_Base_Record_Def : aliased constant String :=
        "BaseRecordDef";
      Desc_For_Internal_Entity_Base_Record_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Record_Def'Access);
      
      Debug_Name_For_Internal_Entity_Null_Record_Def : aliased constant String :=
        "NullRecordDef";
      Desc_For_Internal_Entity_Null_Record_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Null_Record_Def'Access);
      
      Debug_Name_For_Internal_Entity_Record_Def : aliased constant String :=
        "RecordDef";
      Desc_For_Internal_Entity_Record_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Record_Def'Access);
      
      Debug_Name_For_Internal_Entity_Basic_Assoc : aliased constant String :=
        "BasicAssoc";
      Desc_For_Internal_Entity_Basic_Assoc : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Basic_Assoc'Access);
      
      Debug_Name_For_Internal_Entity_Aggregate_Assoc : aliased constant String :=
        "AggregateAssoc";
      Desc_For_Internal_Entity_Aggregate_Assoc : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Aggregate_Assoc'Access);
      
      Debug_Name_For_Internal_Entity_Multi_Dim_Array_Assoc : aliased constant String :=
        "MultiDimArrayAssoc";
      Desc_For_Internal_Entity_Multi_Dim_Array_Assoc : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Multi_Dim_Array_Assoc'Access);
      
      Debug_Name_For_Internal_Entity_Composite_Constraint_Assoc : aliased constant String :=
        "CompositeConstraintAssoc";
      Desc_For_Internal_Entity_Composite_Constraint_Assoc : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Composite_Constraint_Assoc'Access);
      
      Debug_Name_For_Internal_Entity_Iterated_Assoc : aliased constant String :=
        "IteratedAssoc";
      Desc_For_Internal_Entity_Iterated_Assoc : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Iterated_Assoc'Access);
      
      Debug_Name_For_Internal_Entity_Param_Assoc : aliased constant String :=
        "ParamAssoc";
      Desc_For_Internal_Entity_Param_Assoc : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Param_Assoc'Access);
      
      Debug_Name_For_Internal_Entity_Basic_Decl : aliased constant String :=
        "BasicDecl";
      Desc_For_Internal_Entity_Basic_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Basic_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Abstract_State_Decl : aliased constant String :=
        "AbstractStateDecl";
      Desc_For_Internal_Entity_Abstract_State_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abstract_State_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Anonymous_Expr_Decl : aliased constant String :=
        "AnonymousExprDecl";
      Desc_For_Internal_Entity_Anonymous_Expr_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Anonymous_Expr_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Base_Formal_Param_Decl : aliased constant String :=
        "BaseFormalParamDecl";
      Desc_For_Internal_Entity_Base_Formal_Param_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Formal_Param_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Component_Decl : aliased constant String :=
        "ComponentDecl";
      Desc_For_Internal_Entity_Component_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Component_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Discriminant_Spec : aliased constant String :=
        "DiscriminantSpec";
      Desc_For_Internal_Entity_Discriminant_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Discriminant_Spec'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Formal : aliased constant String :=
        "GenericFormal";
      Desc_For_Internal_Entity_Generic_Formal : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Formal'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Formal_Obj_Decl : aliased constant String :=
        "GenericFormalObjDecl";
      Desc_For_Internal_Entity_Generic_Formal_Obj_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Formal_Obj_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Formal_Package : aliased constant String :=
        "GenericFormalPackage";
      Desc_For_Internal_Entity_Generic_Formal_Package : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Formal_Package'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Formal_Subp_Decl : aliased constant String :=
        "GenericFormalSubpDecl";
      Desc_For_Internal_Entity_Generic_Formal_Subp_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Formal_Subp_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Formal_Type_Decl : aliased constant String :=
        "GenericFormalTypeDecl";
      Desc_For_Internal_Entity_Generic_Formal_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Formal_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Param_Spec : aliased constant String :=
        "ParamSpec";
      Desc_For_Internal_Entity_Param_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Param_Spec'Access);
      
      Debug_Name_For_Internal_Entity_Synthetic_Formal_Param_Decl : aliased constant String :=
        "SyntheticFormalParamDecl";
      Desc_For_Internal_Entity_Synthetic_Formal_Param_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Synthetic_Formal_Param_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Base_Package_Decl : aliased constant String :=
        "BasePackageDecl";
      Desc_For_Internal_Entity_Base_Package_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Package_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Package_Internal : aliased constant String :=
        "GenericPackageInternal";
      Desc_For_Internal_Entity_Generic_Package_Internal : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Package_Internal'Access);
      
      Debug_Name_For_Internal_Entity_Package_Decl : aliased constant String :=
        "PackageDecl";
      Desc_For_Internal_Entity_Package_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Package_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Base_Type_Decl : aliased constant String :=
        "BaseTypeDecl";
      Desc_For_Internal_Entity_Base_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Base_Subtype_Decl : aliased constant String :=
        "BaseSubtypeDecl";
      Desc_For_Internal_Entity_Base_Subtype_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Subtype_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Discrete_Base_Subtype_Decl : aliased constant String :=
        "DiscreteBaseSubtypeDecl";
      Desc_For_Internal_Entity_Discrete_Base_Subtype_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Discrete_Base_Subtype_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Subtype_Decl : aliased constant String :=
        "SubtypeDecl";
      Desc_For_Internal_Entity_Subtype_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Subtype_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Classwide_Type_Decl : aliased constant String :=
        "ClasswideTypeDecl";
      Desc_For_Internal_Entity_Classwide_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Classwide_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Incomplete_Type_Decl : aliased constant String :=
        "IncompleteTypeDecl";
      Desc_For_Internal_Entity_Incomplete_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Incomplete_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Incomplete_Formal_Type_Decl : aliased constant String :=
        "IncompleteFormalTypeDecl";
      Desc_For_Internal_Entity_Incomplete_Formal_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Incomplete_Formal_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Incomplete_Tagged_Type_Decl : aliased constant String :=
        "IncompleteTaggedTypeDecl";
      Desc_For_Internal_Entity_Incomplete_Tagged_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Incomplete_Tagged_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Protected_Type_Decl : aliased constant String :=
        "ProtectedTypeDecl";
      Desc_For_Internal_Entity_Protected_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Protected_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Task_Type_Decl : aliased constant String :=
        "TaskTypeDecl";
      Desc_For_Internal_Entity_Task_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Task_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Single_Task_Type_Decl : aliased constant String :=
        "SingleTaskTypeDecl";
      Desc_For_Internal_Entity_Single_Task_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Single_Task_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Type_Decl : aliased constant String :=
        "TypeDecl";
      Desc_For_Internal_Entity_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Anonymous_Type_Decl : aliased constant String :=
        "AnonymousTypeDecl";
      Desc_For_Internal_Entity_Anonymous_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Anonymous_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Synth_Anonymous_Type_Decl : aliased constant String :=
        "SynthAnonymousTypeDecl";
      Desc_For_Internal_Entity_Synth_Anonymous_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Synth_Anonymous_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Concrete_Type_Decl : aliased constant String :=
        "ConcreteTypeDecl";
      Desc_For_Internal_Entity_Concrete_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Concrete_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Formal_Type_Decl : aliased constant String :=
        "FormalTypeDecl";
      Desc_For_Internal_Entity_Formal_Type_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Formal_Type_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Basic_Subp_Decl : aliased constant String :=
        "BasicSubpDecl";
      Desc_For_Internal_Entity_Basic_Subp_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Basic_Subp_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Classic_Subp_Decl : aliased constant String :=
        "ClassicSubpDecl";
      Desc_For_Internal_Entity_Classic_Subp_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Classic_Subp_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Abstract_Subp_Decl : aliased constant String :=
        "AbstractSubpDecl";
      Desc_For_Internal_Entity_Abstract_Subp_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abstract_Subp_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Formal_Subp_Decl : aliased constant String :=
        "FormalSubpDecl";
      Desc_For_Internal_Entity_Formal_Subp_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Formal_Subp_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Abstract_Formal_Subp_Decl : aliased constant String :=
        "AbstractFormalSubpDecl";
      Desc_For_Internal_Entity_Abstract_Formal_Subp_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abstract_Formal_Subp_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Concrete_Formal_Subp_Decl : aliased constant String :=
        "ConcreteFormalSubpDecl";
      Desc_For_Internal_Entity_Concrete_Formal_Subp_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Concrete_Formal_Subp_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Subp_Decl : aliased constant String :=
        "SubpDecl";
      Desc_For_Internal_Entity_Subp_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Subp_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Entry_Decl : aliased constant String :=
        "EntryDecl";
      Desc_For_Internal_Entity_Entry_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Entry_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Enum_Literal_Decl : aliased constant String :=
        "EnumLiteralDecl";
      Desc_For_Internal_Entity_Enum_Literal_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Enum_Literal_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Synthetic_Char_Enum_Lit : aliased constant String :=
        "SyntheticCharEnumLit";
      Desc_For_Internal_Entity_Synthetic_Char_Enum_Lit : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Synthetic_Char_Enum_Lit'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Subp_Internal : aliased constant String :=
        "GenericSubpInternal";
      Desc_For_Internal_Entity_Generic_Subp_Internal : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Subp_Internal'Access);
      
      Debug_Name_For_Internal_Entity_Synthetic_Subp_Decl : aliased constant String :=
        "SyntheticSubpDecl";
      Desc_For_Internal_Entity_Synthetic_Subp_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Synthetic_Subp_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Body_Node : aliased constant String :=
        "Body";
      Desc_For_Internal_Entity_Body_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Body_Node'Access);
      
      Debug_Name_For_Internal_Entity_Base_Subp_Body : aliased constant String :=
        "BaseSubpBody";
      Desc_For_Internal_Entity_Base_Subp_Body : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Subp_Body'Access);
      
      Debug_Name_For_Internal_Entity_Expr_Function : aliased constant String :=
        "ExprFunction";
      Desc_For_Internal_Entity_Expr_Function : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Expr_Function'Access);
      
      Debug_Name_For_Internal_Entity_Null_Subp_Decl : aliased constant String :=
        "NullSubpDecl";
      Desc_For_Internal_Entity_Null_Subp_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Null_Subp_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Subp_Body : aliased constant String :=
        "SubpBody";
      Desc_For_Internal_Entity_Subp_Body : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Subp_Body'Access);
      
      Debug_Name_For_Internal_Entity_Subp_Renaming_Decl : aliased constant String :=
        "SubpRenamingDecl";
      Desc_For_Internal_Entity_Subp_Renaming_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Subp_Renaming_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Body_Stub : aliased constant String :=
        "BodyStub";
      Desc_For_Internal_Entity_Body_Stub : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Body_Stub'Access);
      
      Debug_Name_For_Internal_Entity_Package_Body_Stub : aliased constant String :=
        "PackageBodyStub";
      Desc_For_Internal_Entity_Package_Body_Stub : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Package_Body_Stub'Access);
      
      Debug_Name_For_Internal_Entity_Protected_Body_Stub : aliased constant String :=
        "ProtectedBodyStub";
      Desc_For_Internal_Entity_Protected_Body_Stub : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Protected_Body_Stub'Access);
      
      Debug_Name_For_Internal_Entity_Subp_Body_Stub : aliased constant String :=
        "SubpBodyStub";
      Desc_For_Internal_Entity_Subp_Body_Stub : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Subp_Body_Stub'Access);
      
      Debug_Name_For_Internal_Entity_Task_Body_Stub : aliased constant String :=
        "TaskBodyStub";
      Desc_For_Internal_Entity_Task_Body_Stub : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Task_Body_Stub'Access);
      
      Debug_Name_For_Internal_Entity_Entry_Body : aliased constant String :=
        "EntryBody";
      Desc_For_Internal_Entity_Entry_Body : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Entry_Body'Access);
      
      Debug_Name_For_Internal_Entity_Package_Body : aliased constant String :=
        "PackageBody";
      Desc_For_Internal_Entity_Package_Body : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Package_Body'Access);
      
      Debug_Name_For_Internal_Entity_Protected_Body : aliased constant String :=
        "ProtectedBody";
      Desc_For_Internal_Entity_Protected_Body : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Protected_Body'Access);
      
      Debug_Name_For_Internal_Entity_Task_Body : aliased constant String :=
        "TaskBody";
      Desc_For_Internal_Entity_Task_Body : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Task_Body'Access);
      
      Debug_Name_For_Internal_Entity_Entry_Index_Spec : aliased constant String :=
        "EntryIndexSpec";
      Desc_For_Internal_Entity_Entry_Index_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Entry_Index_Spec'Access);
      
      Debug_Name_For_Internal_Entity_Error_Decl : aliased constant String :=
        "ErrorDecl";
      Desc_For_Internal_Entity_Error_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Error_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Exception_Decl : aliased constant String :=
        "ExceptionDecl";
      Desc_For_Internal_Entity_Exception_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Exception_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Exception_Handler : aliased constant String :=
        "ExceptionHandler";
      Desc_For_Internal_Entity_Exception_Handler : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Exception_Handler'Access);
      
      Debug_Name_For_Internal_Entity_For_Loop_Var_Decl : aliased constant String :=
        "ForLoopVarDecl";
      Desc_For_Internal_Entity_For_Loop_Var_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_For_Loop_Var_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Decl : aliased constant String :=
        "GenericDecl";
      Desc_For_Internal_Entity_Generic_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Package_Decl : aliased constant String :=
        "GenericPackageDecl";
      Desc_For_Internal_Entity_Generic_Package_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Package_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Subp_Decl : aliased constant String :=
        "GenericSubpDecl";
      Desc_For_Internal_Entity_Generic_Subp_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Subp_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Instantiation : aliased constant String :=
        "GenericInstantiation";
      Desc_For_Internal_Entity_Generic_Instantiation : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Instantiation'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Package_Instantiation : aliased constant String :=
        "GenericPackageInstantiation";
      Desc_For_Internal_Entity_Generic_Package_Instantiation : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Package_Instantiation'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Subp_Instantiation : aliased constant String :=
        "GenericSubpInstantiation";
      Desc_For_Internal_Entity_Generic_Subp_Instantiation : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Subp_Instantiation'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Renaming_Decl : aliased constant String :=
        "GenericRenamingDecl";
      Desc_For_Internal_Entity_Generic_Renaming_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Renaming_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Package_Renaming_Decl : aliased constant String :=
        "GenericPackageRenamingDecl";
      Desc_For_Internal_Entity_Generic_Package_Renaming_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Package_Renaming_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Generic_Subp_Renaming_Decl : aliased constant String :=
        "GenericSubpRenamingDecl";
      Desc_For_Internal_Entity_Generic_Subp_Renaming_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Generic_Subp_Renaming_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Label_Decl : aliased constant String :=
        "LabelDecl";
      Desc_For_Internal_Entity_Label_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Label_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Named_Stmt_Decl : aliased constant String :=
        "NamedStmtDecl";
      Desc_For_Internal_Entity_Named_Stmt_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Named_Stmt_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Number_Decl : aliased constant String :=
        "NumberDecl";
      Desc_For_Internal_Entity_Number_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Number_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Object_Decl : aliased constant String :=
        "ObjectDecl";
      Desc_For_Internal_Entity_Object_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Object_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Extended_Return_Stmt_Object_Decl : aliased constant String :=
        "ExtendedReturnStmtObjectDecl";
      Desc_For_Internal_Entity_Extended_Return_Stmt_Object_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Extended_Return_Stmt_Object_Decl'Access);
      
      Debug_Name_For_Internal_Entity_No_Type_Object_Renaming_Decl : aliased constant String :=
        "NoTypeObjectRenamingDecl";
      Desc_For_Internal_Entity_No_Type_Object_Renaming_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_No_Type_Object_Renaming_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Package_Renaming_Decl : aliased constant String :=
        "PackageRenamingDecl";
      Desc_For_Internal_Entity_Package_Renaming_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Package_Renaming_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Single_Protected_Decl : aliased constant String :=
        "SingleProtectedDecl";
      Desc_For_Internal_Entity_Single_Protected_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Single_Protected_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Single_Task_Decl : aliased constant String :=
        "SingleTaskDecl";
      Desc_For_Internal_Entity_Single_Task_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Single_Task_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Case_Stmt_Alternative : aliased constant String :=
        "CaseStmtAlternative";
      Desc_For_Internal_Entity_Case_Stmt_Alternative : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Case_Stmt_Alternative'Access);
      
      Debug_Name_For_Internal_Entity_Compilation_Unit : aliased constant String :=
        "CompilationUnit";
      Desc_For_Internal_Entity_Compilation_Unit : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Compilation_Unit'Access);
      
      Debug_Name_For_Internal_Entity_Component_Clause : aliased constant String :=
        "ComponentClause";
      Desc_For_Internal_Entity_Component_Clause : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Component_Clause'Access);
      
      Debug_Name_For_Internal_Entity_Component_Def : aliased constant String :=
        "ComponentDef";
      Desc_For_Internal_Entity_Component_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Component_Def'Access);
      
      Debug_Name_For_Internal_Entity_Constant_Node : aliased constant String :=
        "Constant";
      Desc_For_Internal_Entity_Constant_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Constant_Node'Access);
      
      Debug_Name_For_Internal_Entity_Constant_Absent : aliased constant String :=
        "Constant.Absent";
      Desc_For_Internal_Entity_Constant_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Constant_Absent'Access);
      
      Debug_Name_For_Internal_Entity_Constant_Present : aliased constant String :=
        "Constant.Present";
      Desc_For_Internal_Entity_Constant_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Constant_Present'Access);
      
      Debug_Name_For_Internal_Entity_Constraint : aliased constant String :=
        "Constraint";
      Desc_For_Internal_Entity_Constraint : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Constraint'Access);
      
      Debug_Name_For_Internal_Entity_Composite_Constraint : aliased constant String :=
        "CompositeConstraint";
      Desc_For_Internal_Entity_Composite_Constraint : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Composite_Constraint'Access);
      
      Debug_Name_For_Internal_Entity_Delta_Constraint : aliased constant String :=
        "DeltaConstraint";
      Desc_For_Internal_Entity_Delta_Constraint : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Delta_Constraint'Access);
      
      Debug_Name_For_Internal_Entity_Digits_Constraint : aliased constant String :=
        "DigitsConstraint";
      Desc_For_Internal_Entity_Digits_Constraint : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Digits_Constraint'Access);
      
      Debug_Name_For_Internal_Entity_Range_Constraint : aliased constant String :=
        "RangeConstraint";
      Desc_For_Internal_Entity_Range_Constraint : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Range_Constraint'Access);
      
      Debug_Name_For_Internal_Entity_Declarative_Part : aliased constant String :=
        "DeclarativePart";
      Desc_For_Internal_Entity_Declarative_Part : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Declarative_Part'Access);
      
      Debug_Name_For_Internal_Entity_Private_Part : aliased constant String :=
        "PrivatePart";
      Desc_For_Internal_Entity_Private_Part : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Private_Part'Access);
      
      Debug_Name_For_Internal_Entity_Public_Part : aliased constant String :=
        "PublicPart";
      Desc_For_Internal_Entity_Public_Part : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Public_Part'Access);
      
      Debug_Name_For_Internal_Entity_Elsif_Expr_Part : aliased constant String :=
        "ElsifExprPart";
      Desc_For_Internal_Entity_Elsif_Expr_Part : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Elsif_Expr_Part'Access);
      
      Debug_Name_For_Internal_Entity_Elsif_Stmt_Part : aliased constant String :=
        "ElsifStmtPart";
      Desc_For_Internal_Entity_Elsif_Stmt_Part : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Elsif_Stmt_Part'Access);
      
      Debug_Name_For_Internal_Entity_Expr : aliased constant String :=
        "Expr";
      Desc_For_Internal_Entity_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Abstract_State_Decl_Expr : aliased constant String :=
        "AbstractStateDeclExpr";
      Desc_For_Internal_Entity_Abstract_State_Decl_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abstract_State_Decl_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Allocator : aliased constant String :=
        "Allocator";
      Desc_For_Internal_Entity_Allocator : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Allocator'Access);
      
      Debug_Name_For_Internal_Entity_Base_Aggregate : aliased constant String :=
        "BaseAggregate";
      Desc_For_Internal_Entity_Base_Aggregate : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Aggregate'Access);
      
      Debug_Name_For_Internal_Entity_Aggregate : aliased constant String :=
        "Aggregate";
      Desc_For_Internal_Entity_Aggregate : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Aggregate'Access);
      
      Debug_Name_For_Internal_Entity_Bracket_Aggregate : aliased constant String :=
        "BracketAggregate";
      Desc_For_Internal_Entity_Bracket_Aggregate : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Bracket_Aggregate'Access);
      
      Debug_Name_For_Internal_Entity_Delta_Aggregate : aliased constant String :=
        "DeltaAggregate";
      Desc_For_Internal_Entity_Delta_Aggregate : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Delta_Aggregate'Access);
      
      Debug_Name_For_Internal_Entity_Bracket_Delta_Aggregate : aliased constant String :=
        "BracketDeltaAggregate";
      Desc_For_Internal_Entity_Bracket_Delta_Aggregate : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Bracket_Delta_Aggregate'Access);
      
      Debug_Name_For_Internal_Entity_Null_Record_Aggregate : aliased constant String :=
        "NullRecordAggregate";
      Desc_For_Internal_Entity_Null_Record_Aggregate : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Null_Record_Aggregate'Access);
      
      Debug_Name_For_Internal_Entity_Bin_Op : aliased constant String :=
        "BinOp";
      Desc_For_Internal_Entity_Bin_Op : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Bin_Op'Access);
      
      Debug_Name_For_Internal_Entity_Relation_Op : aliased constant String :=
        "RelationOp";
      Desc_For_Internal_Entity_Relation_Op : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Relation_Op'Access);
      
      Debug_Name_For_Internal_Entity_Box_Expr : aliased constant String :=
        "BoxExpr";
      Desc_For_Internal_Entity_Box_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Box_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Case_Expr_Alternative : aliased constant String :=
        "CaseExprAlternative";
      Desc_For_Internal_Entity_Case_Expr_Alternative : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Case_Expr_Alternative'Access);
      
      Debug_Name_For_Internal_Entity_Concat_Op : aliased constant String :=
        "ConcatOp";
      Desc_For_Internal_Entity_Concat_Op : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Concat_Op'Access);
      
      Debug_Name_For_Internal_Entity_Concat_Operand : aliased constant String :=
        "ConcatOperand";
      Desc_For_Internal_Entity_Concat_Operand : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Concat_Operand'Access);
      
      Debug_Name_For_Internal_Entity_Cond_Expr : aliased constant String :=
        "CondExpr";
      Desc_For_Internal_Entity_Cond_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Cond_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Case_Expr : aliased constant String :=
        "CaseExpr";
      Desc_For_Internal_Entity_Case_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Case_Expr'Access);
      
      Debug_Name_For_Internal_Entity_If_Expr : aliased constant String :=
        "IfExpr";
      Desc_For_Internal_Entity_If_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_If_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Contract_Cases : aliased constant String :=
        "ContractCases";
      Desc_For_Internal_Entity_Contract_Cases : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Contract_Cases'Access);
      
      Debug_Name_For_Internal_Entity_Decl_Expr : aliased constant String :=
        "DeclExpr";
      Desc_For_Internal_Entity_Decl_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Decl_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Membership_Expr : aliased constant String :=
        "MembershipExpr";
      Desc_For_Internal_Entity_Membership_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Membership_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Name : aliased constant String :=
        "Name";
      Desc_For_Internal_Entity_Name : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Name'Access);
      
      Debug_Name_For_Internal_Entity_Attribute_Ref : aliased constant String :=
        "AttributeRef";
      Desc_For_Internal_Entity_Attribute_Ref : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Attribute_Ref'Access);
      
      Debug_Name_For_Internal_Entity_Call_Expr : aliased constant String :=
        "CallExpr";
      Desc_For_Internal_Entity_Call_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Call_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Defining_Name : aliased constant String :=
        "DefiningName";
      Desc_For_Internal_Entity_Defining_Name : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Defining_Name'Access);
      
      Debug_Name_For_Internal_Entity_Synthetic_Defining_Name : aliased constant String :=
        "SyntheticDefiningName";
      Desc_For_Internal_Entity_Synthetic_Defining_Name : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Synthetic_Defining_Name'Access);
      
      Debug_Name_For_Internal_Entity_Discrete_Subtype_Name : aliased constant String :=
        "DiscreteSubtypeName";
      Desc_For_Internal_Entity_Discrete_Subtype_Name : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Discrete_Subtype_Name'Access);
      
      Debug_Name_For_Internal_Entity_Dotted_Name : aliased constant String :=
        "DottedName";
      Desc_For_Internal_Entity_Dotted_Name : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Dotted_Name'Access);
      
      Debug_Name_For_Internal_Entity_End_Name : aliased constant String :=
        "EndName";
      Desc_For_Internal_Entity_End_Name : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_End_Name'Access);
      
      Debug_Name_For_Internal_Entity_Explicit_Deref : aliased constant String :=
        "ExplicitDeref";
      Desc_For_Internal_Entity_Explicit_Deref : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Explicit_Deref'Access);
      
      Debug_Name_For_Internal_Entity_Qual_Expr : aliased constant String :=
        "QualExpr";
      Desc_For_Internal_Entity_Qual_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Qual_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Reduce_Attribute_Ref : aliased constant String :=
        "ReduceAttributeRef";
      Desc_For_Internal_Entity_Reduce_Attribute_Ref : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Reduce_Attribute_Ref'Access);
      
      Debug_Name_For_Internal_Entity_Single_Tok_Node : aliased constant String :=
        "SingleTokNode";
      Desc_For_Internal_Entity_Single_Tok_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Single_Tok_Node'Access);
      
      Debug_Name_For_Internal_Entity_Base_Id : aliased constant String :=
        "BaseId";
      Desc_For_Internal_Entity_Base_Id : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Id'Access);
      
      Debug_Name_For_Internal_Entity_Char_Literal : aliased constant String :=
        "CharLiteral";
      Desc_For_Internal_Entity_Char_Literal : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Char_Literal'Access);
      
      Debug_Name_For_Internal_Entity_Identifier : aliased constant String :=
        "Identifier";
      Desc_For_Internal_Entity_Identifier : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Identifier'Access);
      
      Debug_Name_For_Internal_Entity_Op : aliased constant String :=
        "Op";
      Desc_For_Internal_Entity_Op : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op'Access);
      
      Debug_Name_For_Internal_Entity_Op_Abs : aliased constant String :=
        "Op.Abs";
      Desc_For_Internal_Entity_Op_Abs : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Abs'Access);
      
      Debug_Name_For_Internal_Entity_Op_And : aliased constant String :=
        "Op.And";
      Desc_For_Internal_Entity_Op_And : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_And'Access);
      
      Debug_Name_For_Internal_Entity_Op_And_Then : aliased constant String :=
        "Op.AndThen";
      Desc_For_Internal_Entity_Op_And_Then : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_And_Then'Access);
      
      Debug_Name_For_Internal_Entity_Op_Concat : aliased constant String :=
        "Op.Concat";
      Desc_For_Internal_Entity_Op_Concat : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Concat'Access);
      
      Debug_Name_For_Internal_Entity_Op_Div : aliased constant String :=
        "Op.Div";
      Desc_For_Internal_Entity_Op_Div : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Div'Access);
      
      Debug_Name_For_Internal_Entity_Op_Double_Dot : aliased constant String :=
        "Op.DoubleDot";
      Desc_For_Internal_Entity_Op_Double_Dot : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Double_Dot'Access);
      
      Debug_Name_For_Internal_Entity_Op_Eq : aliased constant String :=
        "Op.Eq";
      Desc_For_Internal_Entity_Op_Eq : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Eq'Access);
      
      Debug_Name_For_Internal_Entity_Op_Gt : aliased constant String :=
        "Op.Gt";
      Desc_For_Internal_Entity_Op_Gt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Gt'Access);
      
      Debug_Name_For_Internal_Entity_Op_Gte : aliased constant String :=
        "Op.Gte";
      Desc_For_Internal_Entity_Op_Gte : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Gte'Access);
      
      Debug_Name_For_Internal_Entity_Op_In : aliased constant String :=
        "Op.In";
      Desc_For_Internal_Entity_Op_In : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_In'Access);
      
      Debug_Name_For_Internal_Entity_Op_Lt : aliased constant String :=
        "Op.Lt";
      Desc_For_Internal_Entity_Op_Lt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Lt'Access);
      
      Debug_Name_For_Internal_Entity_Op_Lte : aliased constant String :=
        "Op.Lte";
      Desc_For_Internal_Entity_Op_Lte : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Lte'Access);
      
      Debug_Name_For_Internal_Entity_Op_Minus : aliased constant String :=
        "Op.Minus";
      Desc_For_Internal_Entity_Op_Minus : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Minus'Access);
      
      Debug_Name_For_Internal_Entity_Op_Mod : aliased constant String :=
        "Op.Mod";
      Desc_For_Internal_Entity_Op_Mod : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Mod'Access);
      
      Debug_Name_For_Internal_Entity_Op_Mult : aliased constant String :=
        "Op.Mult";
      Desc_For_Internal_Entity_Op_Mult : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Mult'Access);
      
      Debug_Name_For_Internal_Entity_Op_Neq : aliased constant String :=
        "Op.Neq";
      Desc_For_Internal_Entity_Op_Neq : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Neq'Access);
      
      Debug_Name_For_Internal_Entity_Op_Not : aliased constant String :=
        "Op.Not";
      Desc_For_Internal_Entity_Op_Not : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Not'Access);
      
      Debug_Name_For_Internal_Entity_Op_Not_In : aliased constant String :=
        "Op.NotIn";
      Desc_For_Internal_Entity_Op_Not_In : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Not_In'Access);
      
      Debug_Name_For_Internal_Entity_Op_Or : aliased constant String :=
        "Op.Or";
      Desc_For_Internal_Entity_Op_Or : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Or'Access);
      
      Debug_Name_For_Internal_Entity_Op_Or_Else : aliased constant String :=
        "Op.OrElse";
      Desc_For_Internal_Entity_Op_Or_Else : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Or_Else'Access);
      
      Debug_Name_For_Internal_Entity_Op_Plus : aliased constant String :=
        "Op.Plus";
      Desc_For_Internal_Entity_Op_Plus : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Plus'Access);
      
      Debug_Name_For_Internal_Entity_Op_Pow : aliased constant String :=
        "Op.Pow";
      Desc_For_Internal_Entity_Op_Pow : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Pow'Access);
      
      Debug_Name_For_Internal_Entity_Op_Rem : aliased constant String :=
        "Op.Rem";
      Desc_For_Internal_Entity_Op_Rem : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Rem'Access);
      
      Debug_Name_For_Internal_Entity_Op_Xor : aliased constant String :=
        "Op.Xor";
      Desc_For_Internal_Entity_Op_Xor : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Op_Xor'Access);
      
      Debug_Name_For_Internal_Entity_String_Literal : aliased constant String :=
        "StringLiteral";
      Desc_For_Internal_Entity_String_Literal : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_String_Literal'Access);
      
      Debug_Name_For_Internal_Entity_Null_Literal : aliased constant String :=
        "NullLiteral";
      Desc_For_Internal_Entity_Null_Literal : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Null_Literal'Access);
      
      Debug_Name_For_Internal_Entity_Num_Literal : aliased constant String :=
        "NumLiteral";
      Desc_For_Internal_Entity_Num_Literal : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Num_Literal'Access);
      
      Debug_Name_For_Internal_Entity_Int_Literal : aliased constant String :=
        "IntLiteral";
      Desc_For_Internal_Entity_Int_Literal : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Int_Literal'Access);
      
      Debug_Name_For_Internal_Entity_Real_Literal : aliased constant String :=
        "RealLiteral";
      Desc_For_Internal_Entity_Real_Literal : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Real_Literal'Access);
      
      Debug_Name_For_Internal_Entity_Synthetic_Identifier : aliased constant String :=
        "SyntheticIdentifier";
      Desc_For_Internal_Entity_Synthetic_Identifier : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Synthetic_Identifier'Access);
      
      Debug_Name_For_Internal_Entity_Target_Name : aliased constant String :=
        "TargetName";
      Desc_For_Internal_Entity_Target_Name : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Target_Name'Access);
      
      Debug_Name_For_Internal_Entity_Update_Attribute_Ref : aliased constant String :=
        "UpdateAttributeRef";
      Desc_For_Internal_Entity_Update_Attribute_Ref : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Update_Attribute_Ref'Access);
      
      Debug_Name_For_Internal_Entity_Paren_Expr : aliased constant String :=
        "ParenExpr";
      Desc_For_Internal_Entity_Paren_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Paren_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Quantified_Expr : aliased constant String :=
        "QuantifiedExpr";
      Desc_For_Internal_Entity_Quantified_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Quantified_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Raise_Expr : aliased constant String :=
        "RaiseExpr";
      Desc_For_Internal_Entity_Raise_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Raise_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Un_Op : aliased constant String :=
        "UnOp";
      Desc_For_Internal_Entity_Un_Op : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Un_Op'Access);
      
      Debug_Name_For_Internal_Entity_Handled_Stmts : aliased constant String :=
        "HandledStmts";
      Desc_For_Internal_Entity_Handled_Stmts : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Handled_Stmts'Access);
      
      Debug_Name_For_Internal_Entity_Interface_Kind : aliased constant String :=
        "InterfaceKind";
      Desc_For_Internal_Entity_Interface_Kind : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Interface_Kind'Access);
      
      Debug_Name_For_Internal_Entity_Interface_Kind_Limited : aliased constant String :=
        "InterfaceKind.Limited";
      Desc_For_Internal_Entity_Interface_Kind_Limited : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Interface_Kind_Limited'Access);
      
      Debug_Name_For_Internal_Entity_Interface_Kind_Protected : aliased constant String :=
        "InterfaceKind.Protected";
      Desc_For_Internal_Entity_Interface_Kind_Protected : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Interface_Kind_Protected'Access);
      
      Debug_Name_For_Internal_Entity_Interface_Kind_Synchronized : aliased constant String :=
        "InterfaceKind.Synchronized";
      Desc_For_Internal_Entity_Interface_Kind_Synchronized : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Interface_Kind_Synchronized'Access);
      
      Debug_Name_For_Internal_Entity_Interface_Kind_Task : aliased constant String :=
        "InterfaceKind.Task";
      Desc_For_Internal_Entity_Interface_Kind_Task : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Interface_Kind_Task'Access);
      
      Debug_Name_For_Internal_Entity_Iter_Type : aliased constant String :=
        "IterType";
      Desc_For_Internal_Entity_Iter_Type : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Iter_Type'Access);
      
      Debug_Name_For_Internal_Entity_Iter_Type_In : aliased constant String :=
        "IterType.In";
      Desc_For_Internal_Entity_Iter_Type_In : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Iter_Type_In'Access);
      
      Debug_Name_For_Internal_Entity_Iter_Type_Of : aliased constant String :=
        "IterType.Of";
      Desc_For_Internal_Entity_Iter_Type_Of : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Iter_Type_Of'Access);
      
      Debug_Name_For_Internal_Entity_Library_Item : aliased constant String :=
        "LibraryItem";
      Desc_For_Internal_Entity_Library_Item : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Library_Item'Access);
      
      Debug_Name_For_Internal_Entity_Limited_Node : aliased constant String :=
        "Limited";
      Desc_For_Internal_Entity_Limited_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Limited_Node'Access);
      
      Debug_Name_For_Internal_Entity_Limited_Absent : aliased constant String :=
        "Limited.Absent";
      Desc_For_Internal_Entity_Limited_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Limited_Absent'Access);
      
      Debug_Name_For_Internal_Entity_Limited_Present : aliased constant String :=
        "Limited.Present";
      Desc_For_Internal_Entity_Limited_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Limited_Present'Access);
      
      Debug_Name_For_Internal_Entity_Loop_Spec : aliased constant String :=
        "LoopSpec";
      Desc_For_Internal_Entity_Loop_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Loop_Spec'Access);
      
      Debug_Name_For_Internal_Entity_For_Loop_Spec : aliased constant String :=
        "ForLoopSpec";
      Desc_For_Internal_Entity_For_Loop_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_For_Loop_Spec'Access);
      
      Debug_Name_For_Internal_Entity_While_Loop_Spec : aliased constant String :=
        "WhileLoopSpec";
      Desc_For_Internal_Entity_While_Loop_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_While_Loop_Spec'Access);
      
      Debug_Name_For_Internal_Entity_Mode : aliased constant String :=
        "Mode";
      Desc_For_Internal_Entity_Mode : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Mode'Access);
      
      Debug_Name_For_Internal_Entity_Mode_Default : aliased constant String :=
        "Mode.Default";
      Desc_For_Internal_Entity_Mode_Default : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Mode_Default'Access);
      
      Debug_Name_For_Internal_Entity_Mode_In : aliased constant String :=
        "Mode.In";
      Desc_For_Internal_Entity_Mode_In : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Mode_In'Access);
      
      Debug_Name_For_Internal_Entity_Mode_In_Out : aliased constant String :=
        "Mode.InOut";
      Desc_For_Internal_Entity_Mode_In_Out : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Mode_In_Out'Access);
      
      Debug_Name_For_Internal_Entity_Mode_Out : aliased constant String :=
        "Mode.Out";
      Desc_For_Internal_Entity_Mode_Out : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Mode_Out'Access);
      
      Debug_Name_For_Internal_Entity_Multi_Abstract_State_Decl : aliased constant String :=
        "MultiAbstractStateDecl";
      Desc_For_Internal_Entity_Multi_Abstract_State_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Multi_Abstract_State_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Not_Null : aliased constant String :=
        "NotNull";
      Desc_For_Internal_Entity_Not_Null : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Not_Null'Access);
      
      Debug_Name_For_Internal_Entity_Not_Null_Absent : aliased constant String :=
        "NotNull.Absent";
      Desc_For_Internal_Entity_Not_Null_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Not_Null_Absent'Access);
      
      Debug_Name_For_Internal_Entity_Not_Null_Present : aliased constant String :=
        "NotNull.Present";
      Desc_For_Internal_Entity_Not_Null_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Not_Null_Present'Access);
      
      Debug_Name_For_Internal_Entity_Null_Component_Decl : aliased constant String :=
        "NullComponentDecl";
      Desc_For_Internal_Entity_Null_Component_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Null_Component_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Others_Designator : aliased constant String :=
        "OthersDesignator";
      Desc_For_Internal_Entity_Others_Designator : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Others_Designator'Access);
      
      Debug_Name_For_Internal_Entity_Overriding_Node : aliased constant String :=
        "Overriding";
      Desc_For_Internal_Entity_Overriding_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Overriding_Node'Access);
      
      Debug_Name_For_Internal_Entity_Overriding_Not_Overriding : aliased constant String :=
        "Overriding.NotOverriding";
      Desc_For_Internal_Entity_Overriding_Not_Overriding : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Overriding_Not_Overriding'Access);
      
      Debug_Name_For_Internal_Entity_Overriding_Overriding : aliased constant String :=
        "Overriding.Overriding";
      Desc_For_Internal_Entity_Overriding_Overriding : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Overriding_Overriding'Access);
      
      Debug_Name_For_Internal_Entity_Overriding_Unspecified : aliased constant String :=
        "Overriding.Unspecified";
      Desc_For_Internal_Entity_Overriding_Unspecified : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Overriding_Unspecified'Access);
      
      Debug_Name_For_Internal_Entity_Params : aliased constant String :=
        "Params";
      Desc_For_Internal_Entity_Params : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Params'Access);
      
      Debug_Name_For_Internal_Entity_Paren_Abstract_State_Decl : aliased constant String :=
        "ParenAbstractStateDecl";
      Desc_For_Internal_Entity_Paren_Abstract_State_Decl : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Paren_Abstract_State_Decl'Access);
      
      Debug_Name_For_Internal_Entity_Pp_Directive : aliased constant String :=
        "PpDirective";
      Desc_For_Internal_Entity_Pp_Directive : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Pp_Directive'Access);
      
      Debug_Name_For_Internal_Entity_Pp_Else_Directive : aliased constant String :=
        "PpElseDirective";
      Desc_For_Internal_Entity_Pp_Else_Directive : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Pp_Else_Directive'Access);
      
      Debug_Name_For_Internal_Entity_Pp_Elsif_Directive : aliased constant String :=
        "PpElsifDirective";
      Desc_For_Internal_Entity_Pp_Elsif_Directive : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Pp_Elsif_Directive'Access);
      
      Debug_Name_For_Internal_Entity_Pp_End_If_Directive : aliased constant String :=
        "PpEndIfDirective";
      Desc_For_Internal_Entity_Pp_End_If_Directive : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Pp_End_If_Directive'Access);
      
      Debug_Name_For_Internal_Entity_Pp_If_Directive : aliased constant String :=
        "PpIfDirective";
      Desc_For_Internal_Entity_Pp_If_Directive : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Pp_If_Directive'Access);
      
      Debug_Name_For_Internal_Entity_Pp_Then_Kw : aliased constant String :=
        "PpThenKw";
      Desc_For_Internal_Entity_Pp_Then_Kw : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Pp_Then_Kw'Access);
      
      Debug_Name_For_Internal_Entity_Pragma_Node : aliased constant String :=
        "Pragma";
      Desc_For_Internal_Entity_Pragma_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Pragma_Node'Access);
      
      Debug_Name_For_Internal_Entity_Private_Node : aliased constant String :=
        "Private";
      Desc_For_Internal_Entity_Private_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Private_Node'Access);
      
      Debug_Name_For_Internal_Entity_Private_Absent : aliased constant String :=
        "Private.Absent";
      Desc_For_Internal_Entity_Private_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Private_Absent'Access);
      
      Debug_Name_For_Internal_Entity_Private_Present : aliased constant String :=
        "Private.Present";
      Desc_For_Internal_Entity_Private_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Private_Present'Access);
      
      Debug_Name_For_Internal_Entity_Protected_Def : aliased constant String :=
        "ProtectedDef";
      Desc_For_Internal_Entity_Protected_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Protected_Def'Access);
      
      Debug_Name_For_Internal_Entity_Protected_Node : aliased constant String :=
        "Protected";
      Desc_For_Internal_Entity_Protected_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Protected_Node'Access);
      
      Debug_Name_For_Internal_Entity_Protected_Absent : aliased constant String :=
        "Protected.Absent";
      Desc_For_Internal_Entity_Protected_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Protected_Absent'Access);
      
      Debug_Name_For_Internal_Entity_Protected_Present : aliased constant String :=
        "Protected.Present";
      Desc_For_Internal_Entity_Protected_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Protected_Present'Access);
      
      Debug_Name_For_Internal_Entity_Quantifier : aliased constant String :=
        "Quantifier";
      Desc_For_Internal_Entity_Quantifier : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Quantifier'Access);
      
      Debug_Name_For_Internal_Entity_Quantifier_All : aliased constant String :=
        "Quantifier.All";
      Desc_For_Internal_Entity_Quantifier_All : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Quantifier_All'Access);
      
      Debug_Name_For_Internal_Entity_Quantifier_Some : aliased constant String :=
        "Quantifier.Some";
      Desc_For_Internal_Entity_Quantifier_Some : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Quantifier_Some'Access);
      
      Debug_Name_For_Internal_Entity_Range_Spec : aliased constant String :=
        "RangeSpec";
      Desc_For_Internal_Entity_Range_Spec : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Range_Spec'Access);
      
      Debug_Name_For_Internal_Entity_Renaming_Clause : aliased constant String :=
        "RenamingClause";
      Desc_For_Internal_Entity_Renaming_Clause : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Renaming_Clause'Access);
      
      Debug_Name_For_Internal_Entity_Synthetic_Renaming_Clause : aliased constant String :=
        "SyntheticRenamingClause";
      Desc_For_Internal_Entity_Synthetic_Renaming_Clause : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Synthetic_Renaming_Clause'Access);
      
      Debug_Name_For_Internal_Entity_Reverse_Node : aliased constant String :=
        "Reverse";
      Desc_For_Internal_Entity_Reverse_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Reverse_Node'Access);
      
      Debug_Name_For_Internal_Entity_Reverse_Absent : aliased constant String :=
        "Reverse.Absent";
      Desc_For_Internal_Entity_Reverse_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Reverse_Absent'Access);
      
      Debug_Name_For_Internal_Entity_Reverse_Present : aliased constant String :=
        "Reverse.Present";
      Desc_For_Internal_Entity_Reverse_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Reverse_Present'Access);
      
      Debug_Name_For_Internal_Entity_Select_When_Part : aliased constant String :=
        "SelectWhenPart";
      Desc_For_Internal_Entity_Select_When_Part : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Select_When_Part'Access);
      
      Debug_Name_For_Internal_Entity_Stmt : aliased constant String :=
        "Stmt";
      Desc_For_Internal_Entity_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Composite_Stmt : aliased constant String :=
        "CompositeStmt";
      Desc_For_Internal_Entity_Composite_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Composite_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Accept_Stmt : aliased constant String :=
        "AcceptStmt";
      Desc_For_Internal_Entity_Accept_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Accept_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Accept_Stmt_With_Stmts : aliased constant String :=
        "AcceptStmtWithStmts";
      Desc_For_Internal_Entity_Accept_Stmt_With_Stmts : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Accept_Stmt_With_Stmts'Access);
      
      Debug_Name_For_Internal_Entity_Base_Loop_Stmt : aliased constant String :=
        "BaseLoopStmt";
      Desc_For_Internal_Entity_Base_Loop_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Loop_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_For_Loop_Stmt : aliased constant String :=
        "ForLoopStmt";
      Desc_For_Internal_Entity_For_Loop_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_For_Loop_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Loop_Stmt : aliased constant String :=
        "LoopStmt";
      Desc_For_Internal_Entity_Loop_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Loop_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_While_Loop_Stmt : aliased constant String :=
        "WhileLoopStmt";
      Desc_For_Internal_Entity_While_Loop_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_While_Loop_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Block_Stmt : aliased constant String :=
        "BlockStmt";
      Desc_For_Internal_Entity_Block_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Block_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Begin_Block : aliased constant String :=
        "BeginBlock";
      Desc_For_Internal_Entity_Begin_Block : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Begin_Block'Access);
      
      Debug_Name_For_Internal_Entity_Decl_Block : aliased constant String :=
        "DeclBlock";
      Desc_For_Internal_Entity_Decl_Block : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Decl_Block'Access);
      
      Debug_Name_For_Internal_Entity_Case_Stmt : aliased constant String :=
        "CaseStmt";
      Desc_For_Internal_Entity_Case_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Case_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Extended_Return_Stmt : aliased constant String :=
        "ExtendedReturnStmt";
      Desc_For_Internal_Entity_Extended_Return_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Extended_Return_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_If_Stmt : aliased constant String :=
        "IfStmt";
      Desc_For_Internal_Entity_If_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_If_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Named_Stmt : aliased constant String :=
        "NamedStmt";
      Desc_For_Internal_Entity_Named_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Named_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Select_Stmt : aliased constant String :=
        "SelectStmt";
      Desc_For_Internal_Entity_Select_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Select_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Error_Stmt : aliased constant String :=
        "ErrorStmt";
      Desc_For_Internal_Entity_Error_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Error_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Simple_Stmt : aliased constant String :=
        "SimpleStmt";
      Desc_For_Internal_Entity_Simple_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Simple_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Abort_Stmt : aliased constant String :=
        "AbortStmt";
      Desc_For_Internal_Entity_Abort_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Abort_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Assign_Stmt : aliased constant String :=
        "AssignStmt";
      Desc_For_Internal_Entity_Assign_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Assign_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Call_Stmt : aliased constant String :=
        "CallStmt";
      Desc_For_Internal_Entity_Call_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Call_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Delay_Stmt : aliased constant String :=
        "DelayStmt";
      Desc_For_Internal_Entity_Delay_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Delay_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Exit_Stmt : aliased constant String :=
        "ExitStmt";
      Desc_For_Internal_Entity_Exit_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Exit_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Goto_Stmt : aliased constant String :=
        "GotoStmt";
      Desc_For_Internal_Entity_Goto_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Goto_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Label : aliased constant String :=
        "Label";
      Desc_For_Internal_Entity_Label : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Label'Access);
      
      Debug_Name_For_Internal_Entity_Null_Stmt : aliased constant String :=
        "NullStmt";
      Desc_For_Internal_Entity_Null_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Null_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Raise_Stmt : aliased constant String :=
        "RaiseStmt";
      Desc_For_Internal_Entity_Raise_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Raise_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Requeue_Stmt : aliased constant String :=
        "RequeueStmt";
      Desc_For_Internal_Entity_Requeue_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Requeue_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Return_Stmt : aliased constant String :=
        "ReturnStmt";
      Desc_For_Internal_Entity_Return_Stmt : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Return_Stmt'Access);
      
      Debug_Name_For_Internal_Entity_Terminate_Alternative : aliased constant String :=
        "TerminateAlternative";
      Desc_For_Internal_Entity_Terminate_Alternative : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Terminate_Alternative'Access);
      
      Debug_Name_For_Internal_Entity_Subp_Kind : aliased constant String :=
        "SubpKind";
      Desc_For_Internal_Entity_Subp_Kind : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Subp_Kind'Access);
      
      Debug_Name_For_Internal_Entity_Subp_Kind_Function : aliased constant String :=
        "SubpKind.Function";
      Desc_For_Internal_Entity_Subp_Kind_Function : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Subp_Kind_Function'Access);
      
      Debug_Name_For_Internal_Entity_Subp_Kind_Procedure : aliased constant String :=
        "SubpKind.Procedure";
      Desc_For_Internal_Entity_Subp_Kind_Procedure : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Subp_Kind_Procedure'Access);
      
      Debug_Name_For_Internal_Entity_Subunit : aliased constant String :=
        "Subunit";
      Desc_For_Internal_Entity_Subunit : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Subunit'Access);
      
      Debug_Name_For_Internal_Entity_Synchronized_Node : aliased constant String :=
        "Synchronized";
      Desc_For_Internal_Entity_Synchronized_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Synchronized_Node'Access);
      
      Debug_Name_For_Internal_Entity_Synchronized_Absent : aliased constant String :=
        "Synchronized.Absent";
      Desc_For_Internal_Entity_Synchronized_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Synchronized_Absent'Access);
      
      Debug_Name_For_Internal_Entity_Synchronized_Present : aliased constant String :=
        "Synchronized.Present";
      Desc_For_Internal_Entity_Synchronized_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Synchronized_Present'Access);
      
      Debug_Name_For_Internal_Entity_Tagged_Node : aliased constant String :=
        "Tagged";
      Desc_For_Internal_Entity_Tagged_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Tagged_Node'Access);
      
      Debug_Name_For_Internal_Entity_Tagged_Absent : aliased constant String :=
        "Tagged.Absent";
      Desc_For_Internal_Entity_Tagged_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Tagged_Absent'Access);
      
      Debug_Name_For_Internal_Entity_Tagged_Present : aliased constant String :=
        "Tagged.Present";
      Desc_For_Internal_Entity_Tagged_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Tagged_Present'Access);
      
      Debug_Name_For_Internal_Entity_Task_Def : aliased constant String :=
        "TaskDef";
      Desc_For_Internal_Entity_Task_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Task_Def'Access);
      
      Debug_Name_For_Internal_Entity_Type_Attributes_Repository : aliased constant String :=
        "TypeAttributesRepository";
      Desc_For_Internal_Entity_Type_Attributes_Repository : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Type_Attributes_Repository'Access);
      
      Debug_Name_For_Internal_Entity_Type_Def : aliased constant String :=
        "TypeDef";
      Desc_For_Internal_Entity_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Access_Def : aliased constant String :=
        "AccessDef";
      Desc_For_Internal_Entity_Access_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Access_Def'Access);
      
      Debug_Name_For_Internal_Entity_Access_To_Subp_Def : aliased constant String :=
        "AccessToSubpDef";
      Desc_For_Internal_Entity_Access_To_Subp_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Access_To_Subp_Def'Access);
      
      Debug_Name_For_Internal_Entity_Base_Type_Access_Def : aliased constant String :=
        "BaseTypeAccessDef";
      Desc_For_Internal_Entity_Base_Type_Access_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Base_Type_Access_Def'Access);
      
      Debug_Name_For_Internal_Entity_Anonymous_Type_Access_Def : aliased constant String :=
        "AnonymousTypeAccessDef";
      Desc_For_Internal_Entity_Anonymous_Type_Access_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Anonymous_Type_Access_Def'Access);
      
      Debug_Name_For_Internal_Entity_Type_Access_Def : aliased constant String :=
        "TypeAccessDef";
      Desc_For_Internal_Entity_Type_Access_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Type_Access_Def'Access);
      
      Debug_Name_For_Internal_Entity_Array_Type_Def : aliased constant String :=
        "ArrayTypeDef";
      Desc_For_Internal_Entity_Array_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Array_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Derived_Type_Def : aliased constant String :=
        "DerivedTypeDef";
      Desc_For_Internal_Entity_Derived_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Derived_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Enum_Type_Def : aliased constant String :=
        "EnumTypeDef";
      Desc_For_Internal_Entity_Enum_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Enum_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Formal_Discrete_Type_Def : aliased constant String :=
        "FormalDiscreteTypeDef";
      Desc_For_Internal_Entity_Formal_Discrete_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Formal_Discrete_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Interface_Type_Def : aliased constant String :=
        "InterfaceTypeDef";
      Desc_For_Internal_Entity_Interface_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Interface_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Mod_Int_Type_Def : aliased constant String :=
        "ModIntTypeDef";
      Desc_For_Internal_Entity_Mod_Int_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Mod_Int_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Private_Type_Def : aliased constant String :=
        "PrivateTypeDef";
      Desc_For_Internal_Entity_Private_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Private_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Real_Type_Def : aliased constant String :=
        "RealTypeDef";
      Desc_For_Internal_Entity_Real_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Real_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Decimal_Fixed_Point_Def : aliased constant String :=
        "DecimalFixedPointDef";
      Desc_For_Internal_Entity_Decimal_Fixed_Point_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Decimal_Fixed_Point_Def'Access);
      
      Debug_Name_For_Internal_Entity_Floating_Point_Def : aliased constant String :=
        "FloatingPointDef";
      Desc_For_Internal_Entity_Floating_Point_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Floating_Point_Def'Access);
      
      Debug_Name_For_Internal_Entity_Ordinary_Fixed_Point_Def : aliased constant String :=
        "OrdinaryFixedPointDef";
      Desc_For_Internal_Entity_Ordinary_Fixed_Point_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Ordinary_Fixed_Point_Def'Access);
      
      Debug_Name_For_Internal_Entity_Record_Type_Def : aliased constant String :=
        "RecordTypeDef";
      Desc_For_Internal_Entity_Record_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Record_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Signed_Int_Type_Def : aliased constant String :=
        "SignedIntTypeDef";
      Desc_For_Internal_Entity_Signed_Int_Type_Def : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Signed_Int_Type_Def'Access);
      
      Debug_Name_For_Internal_Entity_Type_Expr : aliased constant String :=
        "TypeExpr";
      Desc_For_Internal_Entity_Type_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Type_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Anonymous_Type : aliased constant String :=
        "AnonymousType";
      Desc_For_Internal_Entity_Anonymous_Type : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Anonymous_Type'Access);
      
      Debug_Name_For_Internal_Entity_Enum_Lit_Synth_Type_Expr : aliased constant String :=
        "EnumLitSynthTypeExpr";
      Desc_For_Internal_Entity_Enum_Lit_Synth_Type_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Enum_Lit_Synth_Type_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Subtype_Indication : aliased constant String :=
        "SubtypeIndication";
      Desc_For_Internal_Entity_Subtype_Indication : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Subtype_Indication'Access);
      
      Debug_Name_For_Internal_Entity_Constrained_Subtype_Indication : aliased constant String :=
        "ConstrainedSubtypeIndication";
      Desc_For_Internal_Entity_Constrained_Subtype_Indication : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Constrained_Subtype_Indication'Access);
      
      Debug_Name_For_Internal_Entity_Discrete_Subtype_Indication : aliased constant String :=
        "DiscreteSubtypeIndication";
      Desc_For_Internal_Entity_Discrete_Subtype_Indication : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Discrete_Subtype_Indication'Access);
      
      Debug_Name_For_Internal_Entity_Synthetic_Type_Expr : aliased constant String :=
        "SyntheticTypeExpr";
      Desc_For_Internal_Entity_Synthetic_Type_Expr : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Synthetic_Type_Expr'Access);
      
      Debug_Name_For_Internal_Entity_Unconstrained_Array_Index : aliased constant String :=
        "UnconstrainedArrayIndex";
      Desc_For_Internal_Entity_Unconstrained_Array_Index : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Unconstrained_Array_Index'Access);
      
      Debug_Name_For_Internal_Entity_Until_Node : aliased constant String :=
        "Until";
      Desc_For_Internal_Entity_Until_Node : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Until_Node'Access);
      
      Debug_Name_For_Internal_Entity_Until_Absent : aliased constant String :=
        "Until.Absent";
      Desc_For_Internal_Entity_Until_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Until_Absent'Access);
      
      Debug_Name_For_Internal_Entity_Until_Present : aliased constant String :=
        "Until.Present";
      Desc_For_Internal_Entity_Until_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Until_Present'Access);
      
      Debug_Name_For_Internal_Entity_Use_Clause : aliased constant String :=
        "UseClause";
      Desc_For_Internal_Entity_Use_Clause : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Use_Clause'Access);
      
      Debug_Name_For_Internal_Entity_Use_Package_Clause : aliased constant String :=
        "UsePackageClause";
      Desc_For_Internal_Entity_Use_Package_Clause : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Use_Package_Clause'Access);
      
      Debug_Name_For_Internal_Entity_Use_Type_Clause : aliased constant String :=
        "UseTypeClause";
      Desc_For_Internal_Entity_Use_Type_Clause : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Use_Type_Clause'Access);
      
      Debug_Name_For_Internal_Entity_Value_Sequence : aliased constant String :=
        "ValueSequence";
      Desc_For_Internal_Entity_Value_Sequence : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Value_Sequence'Access);
      
      Debug_Name_For_Internal_Entity_Variant : aliased constant String :=
        "Variant";
      Desc_For_Internal_Entity_Variant : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Variant'Access);
      
      Debug_Name_For_Internal_Entity_Variant_Part : aliased constant String :=
        "VariantPart";
      Desc_For_Internal_Entity_Variant_Part : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_Variant_Part'Access);
      
      Debug_Name_For_Internal_Entity_With_Clause : aliased constant String :=
        "WithClause";
      Desc_For_Internal_Entity_With_Clause : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_With_Clause'Access);
      
      Debug_Name_For_Internal_Entity_With_Private : aliased constant String :=
        "WithPrivate";
      Desc_For_Internal_Entity_With_Private : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_With_Private'Access);
      
      Debug_Name_For_Internal_Entity_With_Private_Absent : aliased constant String :=
        "WithPrivate.Absent";
      Desc_For_Internal_Entity_With_Private_Absent : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_With_Private_Absent'Access);
      
      Debug_Name_For_Internal_Entity_With_Private_Present : aliased constant String :=
        "WithPrivate.Present";
      Desc_For_Internal_Entity_With_Private_Present : aliased constant Type_Descriptor :=
        (Category   => Struct_Category,
         Debug_Name => Debug_Name_For_Internal_Entity_With_Private_Present'Access);

   Types : aliased constant Type_Descriptor_Array := (
      Desc_For_Internal_Unit'Access,
Desc_For_Big_Integer_Type'Access,
Desc_For_Boolean'Access,
Desc_For_Character_Type'Access,
Desc_For_Integer'Access,
Desc_For_Source_Location_Range'Access,
Desc_For_String_Type'Access,
Desc_For_Token_Reference'Access,
Desc_For_Symbol_Type'Access,
Desc_For_Analysis_Unit_Kind'Access,
Desc_For_Lookup_Kind'Access,
Desc_For_Designated_Env_Kind'Access,
Desc_For_Ref_Result_Kind'Access,
Desc_For_Call_Expr_Kind'Access,
Desc_For_Grammar_Rule'Access,
Desc_For_Internal_Discriminant_Values_Array_Access'Access,
Desc_For_Internal_Doc_Annotation_Array_Access'Access,
Desc_For_Internal_Entity_Accept_Stmt_Array_Access'Access,
Desc_For_Internal_Entity_Array_Access'Access,
Desc_For_Internal_Entity_Base_Formal_Param_Decl_Array_Access'Access,
Desc_For_Internal_Entity_Base_Type_Decl_Array_Access'Access,
Desc_For_Internal_Entity_Basic_Decl_Array_Access'Access,
Desc_For_Internal_Entity_Compilation_Unit_Array_Access'Access,
Desc_For_Internal_Entity_Defining_Name_Array_Access'Access,
Desc_For_Internal_Entity_Expr_Array_Access'Access,
Desc_For_Internal_Entity_Generic_Instantiation_Array_Access'Access,
Desc_For_Internal_Entity_Param_Spec_Array_Access'Access,
Desc_For_Internal_Entity_Pragma_Node_Array_Access'Access,
Desc_For_Internal_Entity_Type_Decl_Array_Access'Access,
Desc_For_Internal_Param_Actual_Array_Access'Access,
Desc_For_Internal_Ref_Result_Array_Access'Access,
Desc_For_Internal_Shape_Array_Access'Access,
Desc_For_Internal_Substitution_Array_Access'Access,
Desc_For_Internal_Unit_Array_Access'Access,
Desc_For_Symbol_Type_Array_Access'Access,
Desc_For_Internal_Completion_Item_Iterator_Access'Access,
Desc_For_Internal_Aspect'Access,
Desc_For_Internal_Completion_Item'Access,
Desc_For_Internal_Discrete_Range'Access,
Desc_For_Internal_Discriminant_Values'Access,
Desc_For_Internal_Doc_Annotation'Access,
Desc_For_Internal_Param_Actual'Access,
Desc_For_Internal_Ref_Result'Access,
Desc_For_Internal_Refd_Decl'Access,
Desc_For_Internal_Refd_Def'Access,
Desc_For_Internal_Shape'Access,
Desc_For_Internal_Substitution'Access,
Desc_For_Internal_Entity'Access,
Desc_For_Internal_Entity_Abort_Node'Access,
Desc_For_Internal_Entity_Abort_Absent'Access,
Desc_For_Internal_Entity_Abort_Present'Access,
Desc_For_Internal_Entity_Abstract_Node'Access,
Desc_For_Internal_Entity_Abstract_Absent'Access,
Desc_For_Internal_Entity_Abstract_Present'Access,
Desc_For_Internal_Entity_Ada_List'Access,
Desc_For_Internal_Entity_Ada_Node_List'Access,
Desc_For_Internal_Entity_Abstract_State_Decl_List'Access,
Desc_For_Internal_Entity_Alternatives_List'Access,
Desc_For_Internal_Entity_Constraint_List'Access,
Desc_For_Internal_Entity_Decl_List'Access,
Desc_For_Internal_Entity_Stmt_List'Access,
Desc_For_Internal_Entity_Aspect_Assoc_List'Access,
Desc_For_Internal_Entity_Base_Assoc_List'Access,
Desc_For_Internal_Entity_Basic_Assoc_List'Access,
Desc_For_Internal_Entity_Assoc_List'Access,
Desc_For_Internal_Entity_Basic_Decl_List'Access,
Desc_For_Internal_Entity_Case_Expr_Alternative_List'Access,
Desc_For_Internal_Entity_Case_Stmt_Alternative_List'Access,
Desc_For_Internal_Entity_Compilation_Unit_List'Access,
Desc_For_Internal_Entity_Concat_Operand_List'Access,
Desc_For_Internal_Entity_Contract_Case_Assoc_List'Access,
Desc_For_Internal_Entity_Defining_Name_List'Access,
Desc_For_Internal_Entity_Discriminant_Spec_List'Access,
Desc_For_Internal_Entity_Elsif_Expr_Part_List'Access,
Desc_For_Internal_Entity_Elsif_Stmt_Part_List'Access,
Desc_For_Internal_Entity_Enum_Literal_Decl_List'Access,
Desc_For_Internal_Entity_Expr_List'Access,
Desc_For_Internal_Entity_Expr_Alternatives_List'Access,
Desc_For_Internal_Entity_Identifier_List'Access,
Desc_For_Internal_Entity_Discriminant_Choice_List'Access,
Desc_For_Internal_Entity_Name_List'Access,
Desc_For_Internal_Entity_Parent_List'Access,
Desc_For_Internal_Entity_Param_Spec_List'Access,
Desc_For_Internal_Entity_Pragma_Node_List'Access,
Desc_For_Internal_Entity_Select_When_Part_List'Access,
Desc_For_Internal_Entity_Unconstrained_Array_Index_List'Access,
Desc_For_Internal_Entity_Variant_List'Access,
Desc_For_Internal_Entity_Aliased_Node'Access,
Desc_For_Internal_Entity_Aliased_Absent'Access,
Desc_For_Internal_Entity_Aliased_Present'Access,
Desc_For_Internal_Entity_All_Node'Access,
Desc_For_Internal_Entity_All_Absent'Access,
Desc_For_Internal_Entity_All_Present'Access,
Desc_For_Internal_Entity_Array_Indices'Access,
Desc_For_Internal_Entity_Constrained_Array_Indices'Access,
Desc_For_Internal_Entity_Unconstrained_Array_Indices'Access,
Desc_For_Internal_Entity_Aspect_Assoc'Access,
Desc_For_Internal_Entity_Aspect_Clause'Access,
Desc_For_Internal_Entity_At_Clause'Access,
Desc_For_Internal_Entity_Attribute_Def_Clause'Access,
Desc_For_Internal_Entity_Enum_Rep_Clause'Access,
Desc_For_Internal_Entity_Record_Rep_Clause'Access,
Desc_For_Internal_Entity_Aspect_Spec'Access,
Desc_For_Internal_Entity_Base_Assoc'Access,
Desc_For_Internal_Entity_Contract_Case_Assoc'Access,
Desc_For_Internal_Entity_Pragma_Argument_Assoc'Access,
Desc_For_Internal_Entity_Base_Formal_Param_Holder'Access,
Desc_For_Internal_Entity_Base_Subp_Spec'Access,
Desc_For_Internal_Entity_Entry_Spec'Access,
Desc_For_Internal_Entity_Enum_Subp_Spec'Access,
Desc_For_Internal_Entity_Subp_Spec'Access,
Desc_For_Internal_Entity_Synthetic_Binary_Spec'Access,
Desc_For_Internal_Entity_Synthetic_Unary_Spec'Access,
Desc_For_Internal_Entity_Component_List'Access,
Desc_For_Internal_Entity_Discriminant_Part'Access,
Desc_For_Internal_Entity_Known_Discriminant_Part'Access,
Desc_For_Internal_Entity_Unknown_Discriminant_Part'Access,
Desc_For_Internal_Entity_Entry_Completion_Formal_Params'Access,
Desc_For_Internal_Entity_Generic_Formal_Part'Access,
Desc_For_Internal_Entity_Base_Record_Def'Access,
Desc_For_Internal_Entity_Null_Record_Def'Access,
Desc_For_Internal_Entity_Record_Def'Access,
Desc_For_Internal_Entity_Basic_Assoc'Access,
Desc_For_Internal_Entity_Aggregate_Assoc'Access,
Desc_For_Internal_Entity_Multi_Dim_Array_Assoc'Access,
Desc_For_Internal_Entity_Composite_Constraint_Assoc'Access,
Desc_For_Internal_Entity_Iterated_Assoc'Access,
Desc_For_Internal_Entity_Param_Assoc'Access,
Desc_For_Internal_Entity_Basic_Decl'Access,
Desc_For_Internal_Entity_Abstract_State_Decl'Access,
Desc_For_Internal_Entity_Anonymous_Expr_Decl'Access,
Desc_For_Internal_Entity_Base_Formal_Param_Decl'Access,
Desc_For_Internal_Entity_Component_Decl'Access,
Desc_For_Internal_Entity_Discriminant_Spec'Access,
Desc_For_Internal_Entity_Generic_Formal'Access,
Desc_For_Internal_Entity_Generic_Formal_Obj_Decl'Access,
Desc_For_Internal_Entity_Generic_Formal_Package'Access,
Desc_For_Internal_Entity_Generic_Formal_Subp_Decl'Access,
Desc_For_Internal_Entity_Generic_Formal_Type_Decl'Access,
Desc_For_Internal_Entity_Param_Spec'Access,
Desc_For_Internal_Entity_Synthetic_Formal_Param_Decl'Access,
Desc_For_Internal_Entity_Base_Package_Decl'Access,
Desc_For_Internal_Entity_Generic_Package_Internal'Access,
Desc_For_Internal_Entity_Package_Decl'Access,
Desc_For_Internal_Entity_Base_Type_Decl'Access,
Desc_For_Internal_Entity_Base_Subtype_Decl'Access,
Desc_For_Internal_Entity_Discrete_Base_Subtype_Decl'Access,
Desc_For_Internal_Entity_Subtype_Decl'Access,
Desc_For_Internal_Entity_Classwide_Type_Decl'Access,
Desc_For_Internal_Entity_Incomplete_Type_Decl'Access,
Desc_For_Internal_Entity_Incomplete_Formal_Type_Decl'Access,
Desc_For_Internal_Entity_Incomplete_Tagged_Type_Decl'Access,
Desc_For_Internal_Entity_Protected_Type_Decl'Access,
Desc_For_Internal_Entity_Task_Type_Decl'Access,
Desc_For_Internal_Entity_Single_Task_Type_Decl'Access,
Desc_For_Internal_Entity_Type_Decl'Access,
Desc_For_Internal_Entity_Anonymous_Type_Decl'Access,
Desc_For_Internal_Entity_Synth_Anonymous_Type_Decl'Access,
Desc_For_Internal_Entity_Concrete_Type_Decl'Access,
Desc_For_Internal_Entity_Formal_Type_Decl'Access,
Desc_For_Internal_Entity_Basic_Subp_Decl'Access,
Desc_For_Internal_Entity_Classic_Subp_Decl'Access,
Desc_For_Internal_Entity_Abstract_Subp_Decl'Access,
Desc_For_Internal_Entity_Formal_Subp_Decl'Access,
Desc_For_Internal_Entity_Abstract_Formal_Subp_Decl'Access,
Desc_For_Internal_Entity_Concrete_Formal_Subp_Decl'Access,
Desc_For_Internal_Entity_Subp_Decl'Access,
Desc_For_Internal_Entity_Entry_Decl'Access,
Desc_For_Internal_Entity_Enum_Literal_Decl'Access,
Desc_For_Internal_Entity_Synthetic_Char_Enum_Lit'Access,
Desc_For_Internal_Entity_Generic_Subp_Internal'Access,
Desc_For_Internal_Entity_Synthetic_Subp_Decl'Access,
Desc_For_Internal_Entity_Body_Node'Access,
Desc_For_Internal_Entity_Base_Subp_Body'Access,
Desc_For_Internal_Entity_Expr_Function'Access,
Desc_For_Internal_Entity_Null_Subp_Decl'Access,
Desc_For_Internal_Entity_Subp_Body'Access,
Desc_For_Internal_Entity_Subp_Renaming_Decl'Access,
Desc_For_Internal_Entity_Body_Stub'Access,
Desc_For_Internal_Entity_Package_Body_Stub'Access,
Desc_For_Internal_Entity_Protected_Body_Stub'Access,
Desc_For_Internal_Entity_Subp_Body_Stub'Access,
Desc_For_Internal_Entity_Task_Body_Stub'Access,
Desc_For_Internal_Entity_Entry_Body'Access,
Desc_For_Internal_Entity_Package_Body'Access,
Desc_For_Internal_Entity_Protected_Body'Access,
Desc_For_Internal_Entity_Task_Body'Access,
Desc_For_Internal_Entity_Entry_Index_Spec'Access,
Desc_For_Internal_Entity_Error_Decl'Access,
Desc_For_Internal_Entity_Exception_Decl'Access,
Desc_For_Internal_Entity_Exception_Handler'Access,
Desc_For_Internal_Entity_For_Loop_Var_Decl'Access,
Desc_For_Internal_Entity_Generic_Decl'Access,
Desc_For_Internal_Entity_Generic_Package_Decl'Access,
Desc_For_Internal_Entity_Generic_Subp_Decl'Access,
Desc_For_Internal_Entity_Generic_Instantiation'Access,
Desc_For_Internal_Entity_Generic_Package_Instantiation'Access,
Desc_For_Internal_Entity_Generic_Subp_Instantiation'Access,
Desc_For_Internal_Entity_Generic_Renaming_Decl'Access,
Desc_For_Internal_Entity_Generic_Package_Renaming_Decl'Access,
Desc_For_Internal_Entity_Generic_Subp_Renaming_Decl'Access,
Desc_For_Internal_Entity_Label_Decl'Access,
Desc_For_Internal_Entity_Named_Stmt_Decl'Access,
Desc_For_Internal_Entity_Number_Decl'Access,
Desc_For_Internal_Entity_Object_Decl'Access,
Desc_For_Internal_Entity_Extended_Return_Stmt_Object_Decl'Access,
Desc_For_Internal_Entity_No_Type_Object_Renaming_Decl'Access,
Desc_For_Internal_Entity_Package_Renaming_Decl'Access,
Desc_For_Internal_Entity_Single_Protected_Decl'Access,
Desc_For_Internal_Entity_Single_Task_Decl'Access,
Desc_For_Internal_Entity_Case_Stmt_Alternative'Access,
Desc_For_Internal_Entity_Compilation_Unit'Access,
Desc_For_Internal_Entity_Component_Clause'Access,
Desc_For_Internal_Entity_Component_Def'Access,
Desc_For_Internal_Entity_Constant_Node'Access,
Desc_For_Internal_Entity_Constant_Absent'Access,
Desc_For_Internal_Entity_Constant_Present'Access,
Desc_For_Internal_Entity_Constraint'Access,
Desc_For_Internal_Entity_Composite_Constraint'Access,
Desc_For_Internal_Entity_Delta_Constraint'Access,
Desc_For_Internal_Entity_Digits_Constraint'Access,
Desc_For_Internal_Entity_Range_Constraint'Access,
Desc_For_Internal_Entity_Declarative_Part'Access,
Desc_For_Internal_Entity_Private_Part'Access,
Desc_For_Internal_Entity_Public_Part'Access,
Desc_For_Internal_Entity_Elsif_Expr_Part'Access,
Desc_For_Internal_Entity_Elsif_Stmt_Part'Access,
Desc_For_Internal_Entity_Expr'Access,
Desc_For_Internal_Entity_Abstract_State_Decl_Expr'Access,
Desc_For_Internal_Entity_Allocator'Access,
Desc_For_Internal_Entity_Base_Aggregate'Access,
Desc_For_Internal_Entity_Aggregate'Access,
Desc_For_Internal_Entity_Bracket_Aggregate'Access,
Desc_For_Internal_Entity_Delta_Aggregate'Access,
Desc_For_Internal_Entity_Bracket_Delta_Aggregate'Access,
Desc_For_Internal_Entity_Null_Record_Aggregate'Access,
Desc_For_Internal_Entity_Bin_Op'Access,
Desc_For_Internal_Entity_Relation_Op'Access,
Desc_For_Internal_Entity_Box_Expr'Access,
Desc_For_Internal_Entity_Case_Expr_Alternative'Access,
Desc_For_Internal_Entity_Concat_Op'Access,
Desc_For_Internal_Entity_Concat_Operand'Access,
Desc_For_Internal_Entity_Cond_Expr'Access,
Desc_For_Internal_Entity_Case_Expr'Access,
Desc_For_Internal_Entity_If_Expr'Access,
Desc_For_Internal_Entity_Contract_Cases'Access,
Desc_For_Internal_Entity_Decl_Expr'Access,
Desc_For_Internal_Entity_Membership_Expr'Access,
Desc_For_Internal_Entity_Name'Access,
Desc_For_Internal_Entity_Attribute_Ref'Access,
Desc_For_Internal_Entity_Call_Expr'Access,
Desc_For_Internal_Entity_Defining_Name'Access,
Desc_For_Internal_Entity_Synthetic_Defining_Name'Access,
Desc_For_Internal_Entity_Discrete_Subtype_Name'Access,
Desc_For_Internal_Entity_Dotted_Name'Access,
Desc_For_Internal_Entity_End_Name'Access,
Desc_For_Internal_Entity_Explicit_Deref'Access,
Desc_For_Internal_Entity_Qual_Expr'Access,
Desc_For_Internal_Entity_Reduce_Attribute_Ref'Access,
Desc_For_Internal_Entity_Single_Tok_Node'Access,
Desc_For_Internal_Entity_Base_Id'Access,
Desc_For_Internal_Entity_Char_Literal'Access,
Desc_For_Internal_Entity_Identifier'Access,
Desc_For_Internal_Entity_Op'Access,
Desc_For_Internal_Entity_Op_Abs'Access,
Desc_For_Internal_Entity_Op_And'Access,
Desc_For_Internal_Entity_Op_And_Then'Access,
Desc_For_Internal_Entity_Op_Concat'Access,
Desc_For_Internal_Entity_Op_Div'Access,
Desc_For_Internal_Entity_Op_Double_Dot'Access,
Desc_For_Internal_Entity_Op_Eq'Access,
Desc_For_Internal_Entity_Op_Gt'Access,
Desc_For_Internal_Entity_Op_Gte'Access,
Desc_For_Internal_Entity_Op_In'Access,
Desc_For_Internal_Entity_Op_Lt'Access,
Desc_For_Internal_Entity_Op_Lte'Access,
Desc_For_Internal_Entity_Op_Minus'Access,
Desc_For_Internal_Entity_Op_Mod'Access,
Desc_For_Internal_Entity_Op_Mult'Access,
Desc_For_Internal_Entity_Op_Neq'Access,
Desc_For_Internal_Entity_Op_Not'Access,
Desc_For_Internal_Entity_Op_Not_In'Access,
Desc_For_Internal_Entity_Op_Or'Access,
Desc_For_Internal_Entity_Op_Or_Else'Access,
Desc_For_Internal_Entity_Op_Plus'Access,
Desc_For_Internal_Entity_Op_Pow'Access,
Desc_For_Internal_Entity_Op_Rem'Access,
Desc_For_Internal_Entity_Op_Xor'Access,
Desc_For_Internal_Entity_String_Literal'Access,
Desc_For_Internal_Entity_Null_Literal'Access,
Desc_For_Internal_Entity_Num_Literal'Access,
Desc_For_Internal_Entity_Int_Literal'Access,
Desc_For_Internal_Entity_Real_Literal'Access,
Desc_For_Internal_Entity_Synthetic_Identifier'Access,
Desc_For_Internal_Entity_Target_Name'Access,
Desc_For_Internal_Entity_Update_Attribute_Ref'Access,
Desc_For_Internal_Entity_Paren_Expr'Access,
Desc_For_Internal_Entity_Quantified_Expr'Access,
Desc_For_Internal_Entity_Raise_Expr'Access,
Desc_For_Internal_Entity_Un_Op'Access,
Desc_For_Internal_Entity_Handled_Stmts'Access,
Desc_For_Internal_Entity_Interface_Kind'Access,
Desc_For_Internal_Entity_Interface_Kind_Limited'Access,
Desc_For_Internal_Entity_Interface_Kind_Protected'Access,
Desc_For_Internal_Entity_Interface_Kind_Synchronized'Access,
Desc_For_Internal_Entity_Interface_Kind_Task'Access,
Desc_For_Internal_Entity_Iter_Type'Access,
Desc_For_Internal_Entity_Iter_Type_In'Access,
Desc_For_Internal_Entity_Iter_Type_Of'Access,
Desc_For_Internal_Entity_Library_Item'Access,
Desc_For_Internal_Entity_Limited_Node'Access,
Desc_For_Internal_Entity_Limited_Absent'Access,
Desc_For_Internal_Entity_Limited_Present'Access,
Desc_For_Internal_Entity_Loop_Spec'Access,
Desc_For_Internal_Entity_For_Loop_Spec'Access,
Desc_For_Internal_Entity_While_Loop_Spec'Access,
Desc_For_Internal_Entity_Mode'Access,
Desc_For_Internal_Entity_Mode_Default'Access,
Desc_For_Internal_Entity_Mode_In'Access,
Desc_For_Internal_Entity_Mode_In_Out'Access,
Desc_For_Internal_Entity_Mode_Out'Access,
Desc_For_Internal_Entity_Multi_Abstract_State_Decl'Access,
Desc_For_Internal_Entity_Not_Null'Access,
Desc_For_Internal_Entity_Not_Null_Absent'Access,
Desc_For_Internal_Entity_Not_Null_Present'Access,
Desc_For_Internal_Entity_Null_Component_Decl'Access,
Desc_For_Internal_Entity_Others_Designator'Access,
Desc_For_Internal_Entity_Overriding_Node'Access,
Desc_For_Internal_Entity_Overriding_Not_Overriding'Access,
Desc_For_Internal_Entity_Overriding_Overriding'Access,
Desc_For_Internal_Entity_Overriding_Unspecified'Access,
Desc_For_Internal_Entity_Params'Access,
Desc_For_Internal_Entity_Paren_Abstract_State_Decl'Access,
Desc_For_Internal_Entity_Pp_Directive'Access,
Desc_For_Internal_Entity_Pp_Else_Directive'Access,
Desc_For_Internal_Entity_Pp_Elsif_Directive'Access,
Desc_For_Internal_Entity_Pp_End_If_Directive'Access,
Desc_For_Internal_Entity_Pp_If_Directive'Access,
Desc_For_Internal_Entity_Pp_Then_Kw'Access,
Desc_For_Internal_Entity_Pragma_Node'Access,
Desc_For_Internal_Entity_Private_Node'Access,
Desc_For_Internal_Entity_Private_Absent'Access,
Desc_For_Internal_Entity_Private_Present'Access,
Desc_For_Internal_Entity_Protected_Def'Access,
Desc_For_Internal_Entity_Protected_Node'Access,
Desc_For_Internal_Entity_Protected_Absent'Access,
Desc_For_Internal_Entity_Protected_Present'Access,
Desc_For_Internal_Entity_Quantifier'Access,
Desc_For_Internal_Entity_Quantifier_All'Access,
Desc_For_Internal_Entity_Quantifier_Some'Access,
Desc_For_Internal_Entity_Range_Spec'Access,
Desc_For_Internal_Entity_Renaming_Clause'Access,
Desc_For_Internal_Entity_Synthetic_Renaming_Clause'Access,
Desc_For_Internal_Entity_Reverse_Node'Access,
Desc_For_Internal_Entity_Reverse_Absent'Access,
Desc_For_Internal_Entity_Reverse_Present'Access,
Desc_For_Internal_Entity_Select_When_Part'Access,
Desc_For_Internal_Entity_Stmt'Access,
Desc_For_Internal_Entity_Composite_Stmt'Access,
Desc_For_Internal_Entity_Accept_Stmt'Access,
Desc_For_Internal_Entity_Accept_Stmt_With_Stmts'Access,
Desc_For_Internal_Entity_Base_Loop_Stmt'Access,
Desc_For_Internal_Entity_For_Loop_Stmt'Access,
Desc_For_Internal_Entity_Loop_Stmt'Access,
Desc_For_Internal_Entity_While_Loop_Stmt'Access,
Desc_For_Internal_Entity_Block_Stmt'Access,
Desc_For_Internal_Entity_Begin_Block'Access,
Desc_For_Internal_Entity_Decl_Block'Access,
Desc_For_Internal_Entity_Case_Stmt'Access,
Desc_For_Internal_Entity_Extended_Return_Stmt'Access,
Desc_For_Internal_Entity_If_Stmt'Access,
Desc_For_Internal_Entity_Named_Stmt'Access,
Desc_For_Internal_Entity_Select_Stmt'Access,
Desc_For_Internal_Entity_Error_Stmt'Access,
Desc_For_Internal_Entity_Simple_Stmt'Access,
Desc_For_Internal_Entity_Abort_Stmt'Access,
Desc_For_Internal_Entity_Assign_Stmt'Access,
Desc_For_Internal_Entity_Call_Stmt'Access,
Desc_For_Internal_Entity_Delay_Stmt'Access,
Desc_For_Internal_Entity_Exit_Stmt'Access,
Desc_For_Internal_Entity_Goto_Stmt'Access,
Desc_For_Internal_Entity_Label'Access,
Desc_For_Internal_Entity_Null_Stmt'Access,
Desc_For_Internal_Entity_Raise_Stmt'Access,
Desc_For_Internal_Entity_Requeue_Stmt'Access,
Desc_For_Internal_Entity_Return_Stmt'Access,
Desc_For_Internal_Entity_Terminate_Alternative'Access,
Desc_For_Internal_Entity_Subp_Kind'Access,
Desc_For_Internal_Entity_Subp_Kind_Function'Access,
Desc_For_Internal_Entity_Subp_Kind_Procedure'Access,
Desc_For_Internal_Entity_Subunit'Access,
Desc_For_Internal_Entity_Synchronized_Node'Access,
Desc_For_Internal_Entity_Synchronized_Absent'Access,
Desc_For_Internal_Entity_Synchronized_Present'Access,
Desc_For_Internal_Entity_Tagged_Node'Access,
Desc_For_Internal_Entity_Tagged_Absent'Access,
Desc_For_Internal_Entity_Tagged_Present'Access,
Desc_For_Internal_Entity_Task_Def'Access,
Desc_For_Internal_Entity_Type_Attributes_Repository'Access,
Desc_For_Internal_Entity_Type_Def'Access,
Desc_For_Internal_Entity_Access_Def'Access,
Desc_For_Internal_Entity_Access_To_Subp_Def'Access,
Desc_For_Internal_Entity_Base_Type_Access_Def'Access,
Desc_For_Internal_Entity_Anonymous_Type_Access_Def'Access,
Desc_For_Internal_Entity_Type_Access_Def'Access,
Desc_For_Internal_Entity_Array_Type_Def'Access,
Desc_For_Internal_Entity_Derived_Type_Def'Access,
Desc_For_Internal_Entity_Enum_Type_Def'Access,
Desc_For_Internal_Entity_Formal_Discrete_Type_Def'Access,
Desc_For_Internal_Entity_Interface_Type_Def'Access,
Desc_For_Internal_Entity_Mod_Int_Type_Def'Access,
Desc_For_Internal_Entity_Private_Type_Def'Access,
Desc_For_Internal_Entity_Real_Type_Def'Access,
Desc_For_Internal_Entity_Decimal_Fixed_Point_Def'Access,
Desc_For_Internal_Entity_Floating_Point_Def'Access,
Desc_For_Internal_Entity_Ordinary_Fixed_Point_Def'Access,
Desc_For_Internal_Entity_Record_Type_Def'Access,
Desc_For_Internal_Entity_Signed_Int_Type_Def'Access,
Desc_For_Internal_Entity_Type_Expr'Access,
Desc_For_Internal_Entity_Anonymous_Type'Access,
Desc_For_Internal_Entity_Enum_Lit_Synth_Type_Expr'Access,
Desc_For_Internal_Entity_Subtype_Indication'Access,
Desc_For_Internal_Entity_Constrained_Subtype_Indication'Access,
Desc_For_Internal_Entity_Discrete_Subtype_Indication'Access,
Desc_For_Internal_Entity_Synthetic_Type_Expr'Access,
Desc_For_Internal_Entity_Unconstrained_Array_Index'Access,
Desc_For_Internal_Entity_Until_Node'Access,
Desc_For_Internal_Entity_Until_Absent'Access,
Desc_For_Internal_Entity_Until_Present'Access,
Desc_For_Internal_Entity_Use_Clause'Access,
Desc_For_Internal_Entity_Use_Package_Clause'Access,
Desc_For_Internal_Entity_Use_Type_Clause'Access,
Desc_For_Internal_Entity_Value_Sequence'Access,
Desc_For_Internal_Entity_Variant'Access,
Desc_For_Internal_Entity_Variant_Part'Access,
Desc_For_Internal_Entity_With_Clause'Access,
Desc_For_Internal_Entity_With_Private'Access,
Desc_For_Internal_Entity_With_Private_Absent'Access,
Desc_For_Internal_Entity_With_Private_Present'Access
   );

   ---------------------------
   -- Enum type descriptors --
   ---------------------------

   
      

         Enum_Name_For_Analysis_Unit_Kind_1 : aliased constant Text_Type :=
           "Unit_Specification";
         Enum_Name_For_Analysis_Unit_Kind_2 : aliased constant Text_Type :=
           "Unit_Body";

      Enum_Name_For_Analysis_Unit_Kind : aliased constant Text_Type :=
        "Analysis_Unit_Kind";
      Enum_Desc_For_Analysis_Unit_Kind : aliased constant Enum_Type_Descriptor := (
         Last_Value    => 2,
         Name          => Enum_Name_For_Analysis_Unit_Kind'Access,
         Default_Value => 0,
         Value_Names   => (
            1 => Enum_Name_For_Analysis_Unit_Kind_1'Access,
2 => Enum_Name_For_Analysis_Unit_Kind_2'Access
         )
      );
      

         Enum_Name_For_Lookup_Kind_1 : aliased constant Text_Type :=
           "Recursive";
         Enum_Name_For_Lookup_Kind_2 : aliased constant Text_Type :=
           "Flat";
         Enum_Name_For_Lookup_Kind_3 : aliased constant Text_Type :=
           "Minimal";

      Enum_Name_For_Lookup_Kind : aliased constant Text_Type :=
        "Lookup_Kind";
      Enum_Desc_For_Lookup_Kind : aliased constant Enum_Type_Descriptor := (
         Last_Value    => 3,
         Name          => Enum_Name_For_Lookup_Kind'Access,
         Default_Value => 0,
         Value_Names   => (
            1 => Enum_Name_For_Lookup_Kind_1'Access,
2 => Enum_Name_For_Lookup_Kind_2'Access,
3 => Enum_Name_For_Lookup_Kind_3'Access
         )
      );
      

         Enum_Name_For_Designated_Env_Kind_1 : aliased constant Text_Type :=
           "None";
         Enum_Name_For_Designated_Env_Kind_2 : aliased constant Text_Type :=
           "Current_Env";
         Enum_Name_For_Designated_Env_Kind_3 : aliased constant Text_Type :=
           "Named_Env";
         Enum_Name_For_Designated_Env_Kind_4 : aliased constant Text_Type :=
           "Direct_Env";

      Enum_Name_For_Designated_Env_Kind : aliased constant Text_Type :=
        "Designated_Env_Kind";
      Enum_Desc_For_Designated_Env_Kind : aliased constant Enum_Type_Descriptor := (
         Last_Value    => 4,
         Name          => Enum_Name_For_Designated_Env_Kind'Access,
         Default_Value => 1,
         Value_Names   => (
            1 => Enum_Name_For_Designated_Env_Kind_1'Access,
2 => Enum_Name_For_Designated_Env_Kind_2'Access,
3 => Enum_Name_For_Designated_Env_Kind_3'Access,
4 => Enum_Name_For_Designated_Env_Kind_4'Access
         )
      );
      

         Enum_Name_For_Ref_Result_Kind_1 : aliased constant Text_Type :=
           "No_Ref";
         Enum_Name_For_Ref_Result_Kind_2 : aliased constant Text_Type :=
           "Precise";
         Enum_Name_For_Ref_Result_Kind_3 : aliased constant Text_Type :=
           "Imprecise";
         Enum_Name_For_Ref_Result_Kind_4 : aliased constant Text_Type :=
           "Error";

      Enum_Name_For_Ref_Result_Kind : aliased constant Text_Type :=
        "Ref_Result_Kind";
      Enum_Desc_For_Ref_Result_Kind : aliased constant Enum_Type_Descriptor := (
         Last_Value    => 4,
         Name          => Enum_Name_For_Ref_Result_Kind'Access,
         Default_Value => 1,
         Value_Names   => (
            1 => Enum_Name_For_Ref_Result_Kind_1'Access,
2 => Enum_Name_For_Ref_Result_Kind_2'Access,
3 => Enum_Name_For_Ref_Result_Kind_3'Access,
4 => Enum_Name_For_Ref_Result_Kind_4'Access
         )
      );
      

         Enum_Name_For_Call_Expr_Kind_1 : aliased constant Text_Type :=
           "Call";
         Enum_Name_For_Call_Expr_Kind_2 : aliased constant Text_Type :=
           "Array_Slice";
         Enum_Name_For_Call_Expr_Kind_3 : aliased constant Text_Type :=
           "Array_Index";
         Enum_Name_For_Call_Expr_Kind_4 : aliased constant Text_Type :=
           "Type_Conversion";

      Enum_Name_For_Call_Expr_Kind : aliased constant Text_Type :=
        "Call_Expr_Kind";
      Enum_Desc_For_Call_Expr_Kind : aliased constant Enum_Type_Descriptor := (
         Last_Value    => 4,
         Name          => Enum_Name_For_Call_Expr_Kind'Access,
         Default_Value => 0,
         Value_Names   => (
            1 => Enum_Name_For_Call_Expr_Kind_1'Access,
2 => Enum_Name_For_Call_Expr_Kind_2'Access,
3 => Enum_Name_For_Call_Expr_Kind_3'Access,
4 => Enum_Name_For_Call_Expr_Kind_4'Access
         )
      );
      

         Enum_Name_For_Grammar_Rule_1 : aliased constant Text_Type :=
           "Parent_List_Rule";
         Enum_Name_For_Grammar_Rule_2 : aliased constant Text_Type :=
           "Protected_Type_Decl_Rule";
         Enum_Name_For_Grammar_Rule_3 : aliased constant Text_Type :=
           "Protected_Op_Rule";
         Enum_Name_For_Grammar_Rule_4 : aliased constant Text_Type :=
           "Protected_El_Rule";
         Enum_Name_For_Grammar_Rule_5 : aliased constant Text_Type :=
           "Protected_Def_Rule";
         Enum_Name_For_Grammar_Rule_6 : aliased constant Text_Type :=
           "Protected_Decl_Rule";
         Enum_Name_For_Grammar_Rule_7 : aliased constant Text_Type :=
           "Task_Item_Rule";
         Enum_Name_For_Grammar_Rule_8 : aliased constant Text_Type :=
           "Task_Def_Rule";
         Enum_Name_For_Grammar_Rule_9 : aliased constant Text_Type :=
           "Task_Type_Decl_Rule";
         Enum_Name_For_Grammar_Rule_10 : aliased constant Text_Type :=
           "Subtype_Decl_Rule";
         Enum_Name_For_Grammar_Rule_11 : aliased constant Text_Type :=
           "Interface_Type_Def_Rule";
         Enum_Name_For_Grammar_Rule_12 : aliased constant Text_Type :=
           "Unconstrained_Index_Rule";
         Enum_Name_For_Grammar_Rule_13 : aliased constant Text_Type :=
           "Array_Type_Def_Rule";
         Enum_Name_For_Grammar_Rule_14 : aliased constant Text_Type :=
           "Discrete_Subtype_Definition_Rule";
         Enum_Name_For_Grammar_Rule_15 : aliased constant Text_Type :=
           "Constraint_List_Rule";
         Enum_Name_For_Grammar_Rule_16 : aliased constant Text_Type :=
           "Signed_Int_Type_Def_Rule";
         Enum_Name_For_Grammar_Rule_17 : aliased constant Text_Type :=
           "Mod_Int_Type_Def_Rule";
         Enum_Name_For_Grammar_Rule_18 : aliased constant Text_Type :=
           "Derived_Type_Def_Rule";
         Enum_Name_For_Grammar_Rule_19 : aliased constant Text_Type :=
           "Composite_Constraint_Assoc_Rule";
         Enum_Name_For_Grammar_Rule_20 : aliased constant Text_Type :=
           "Composite_Constraint_Rule";
         Enum_Name_For_Grammar_Rule_21 : aliased constant Text_Type :=
           "Digits_Constraint_Rule";
         Enum_Name_For_Grammar_Rule_22 : aliased constant Text_Type :=
           "Delta_Constraint_Rule";
         Enum_Name_For_Grammar_Rule_23 : aliased constant Text_Type :=
           "Range_Constraint_Rule";
         Enum_Name_For_Grammar_Rule_24 : aliased constant Text_Type :=
           "Constraint_Rule";
         Enum_Name_For_Grammar_Rule_25 : aliased constant Text_Type :=
           "Discriminant_Spec_Rule";
         Enum_Name_For_Grammar_Rule_26 : aliased constant Text_Type :=
           "Discr_Spec_List_Rule";
         Enum_Name_For_Grammar_Rule_27 : aliased constant Text_Type :=
           "Discriminant_Part_Rule";
         Enum_Name_For_Grammar_Rule_28 : aliased constant Text_Type :=
           "Enum_Literal_Decl_Rule";
         Enum_Name_For_Grammar_Rule_29 : aliased constant Text_Type :=
           "Formal_Discrete_Type_Def_Rule";
         Enum_Name_For_Grammar_Rule_30 : aliased constant Text_Type :=
           "Record_Def_Rule";
         Enum_Name_For_Grammar_Rule_31 : aliased constant Text_Type :=
           "Range_Spec_Rule";
         Enum_Name_For_Grammar_Rule_32 : aliased constant Text_Type :=
           "Real_Type_Def_Rule";
         Enum_Name_For_Grammar_Rule_33 : aliased constant Text_Type :=
           "Sexpr_Or_Box_Rule";
         Enum_Name_For_Grammar_Rule_34 : aliased constant Text_Type :=
           "Ordinary_Fixed_Point_Def_Rule";
         Enum_Name_For_Grammar_Rule_35 : aliased constant Text_Type :=
           "Decimal_Fixed_Point_Def_Rule";
         Enum_Name_For_Grammar_Rule_36 : aliased constant Text_Type :=
           "Floating_Point_Def_Rule";
         Enum_Name_For_Grammar_Rule_37 : aliased constant Text_Type :=
           "Record_Type_Def_Rule";
         Enum_Name_For_Grammar_Rule_38 : aliased constant Text_Type :=
           "Access_Def_Rule";
         Enum_Name_For_Grammar_Rule_39 : aliased constant Text_Type :=
           "Enum_Type_Def_Rule";
         Enum_Name_For_Grammar_Rule_40 : aliased constant Text_Type :=
           "Type_Def_Rule";
         Enum_Name_For_Grammar_Rule_41 : aliased constant Text_Type :=
           "Variant_Rule";
         Enum_Name_For_Grammar_Rule_42 : aliased constant Text_Type :=
           "Anonymous_Type_Decl_Rule";
         Enum_Name_For_Grammar_Rule_43 : aliased constant Text_Type :=
           "Incomplete_Type_Decl_Rule";
         Enum_Name_For_Grammar_Rule_44 : aliased constant Text_Type :=
           "Type_Decl_Rule";
         Enum_Name_For_Grammar_Rule_45 : aliased constant Text_Type :=
           "Variant_Part_Rule";
         Enum_Name_For_Grammar_Rule_46 : aliased constant Text_Type :=
           "Component_Def_Rule";
         Enum_Name_For_Grammar_Rule_47 : aliased constant Text_Type :=
           "Component_Item_Rule";
         Enum_Name_For_Grammar_Rule_48 : aliased constant Text_Type :=
           "Component_Decl_Rule";
         Enum_Name_For_Grammar_Rule_49 : aliased constant Text_Type :=
           "Component_List_Rule";
         Enum_Name_For_Grammar_Rule_50 : aliased constant Text_Type :=
           "Generic_Decl_Rule";
         Enum_Name_For_Grammar_Rule_51 : aliased constant Text_Type :=
           "Generic_Formal_Part_Rule";
         Enum_Name_For_Grammar_Rule_52 : aliased constant Text_Type :=
           "Generic_Formal_Decl_Rule";
         Enum_Name_For_Grammar_Rule_53 : aliased constant Text_Type :=
           "Formal_Type_Decl_Rule";
         Enum_Name_For_Grammar_Rule_54 : aliased constant Text_Type :=
           "Formal_Subp_Decl_Rule";
         Enum_Name_For_Grammar_Rule_55 : aliased constant Text_Type :=
           "Renaming_Clause_Rule";
         Enum_Name_For_Grammar_Rule_56 : aliased constant Text_Type :=
           "Generic_Renaming_Decl_Rule";
         Enum_Name_For_Grammar_Rule_57 : aliased constant Text_Type :=
           "Generic_Instantiation_Rule";
         Enum_Name_For_Grammar_Rule_58 : aliased constant Text_Type :=
           "Exception_Decl_Rule";
         Enum_Name_For_Grammar_Rule_59 : aliased constant Text_Type :=
           "Basic_Decls_Rule";
         Enum_Name_For_Grammar_Rule_60 : aliased constant Text_Type :=
           "Package_Renaming_Decl_Rule";
         Enum_Name_For_Grammar_Rule_61 : aliased constant Text_Type :=
           "Package_Decl_Rule";
         Enum_Name_For_Grammar_Rule_62 : aliased constant Text_Type :=
           "Basic_Decl_Rule";
         Enum_Name_For_Grammar_Rule_63 : aliased constant Text_Type :=
           "Object_Decl_Rule";
         Enum_Name_For_Grammar_Rule_64 : aliased constant Text_Type :=
           "Sub_Object_Decl_Rule";
         Enum_Name_For_Grammar_Rule_65 : aliased constant Text_Type :=
           "No_Type_Object_Renaming_Decl_Rule";
         Enum_Name_For_Grammar_Rule_66 : aliased constant Text_Type :=
           "Ext_Ret_Stmt_Object_Decl_Rule";
         Enum_Name_For_Grammar_Rule_67 : aliased constant Text_Type :=
           "Defining_Id_List_Rule";
         Enum_Name_For_Grammar_Rule_68 : aliased constant Text_Type :=
           "Number_Decl_Rule";
         Enum_Name_For_Grammar_Rule_69 : aliased constant Text_Type :=
           "Contract_Case_Assoc_Rule";
         Enum_Name_For_Grammar_Rule_70 : aliased constant Text_Type :=
           "Contract_Cases_Expr_Rule";
         Enum_Name_For_Grammar_Rule_71 : aliased constant Text_Type :=
           "Abstract_State_Decl_Rule";
         Enum_Name_For_Grammar_Rule_72 : aliased constant Text_Type :=
           "Multi_Abstract_State_Decl_Rule";
         Enum_Name_For_Grammar_Rule_73 : aliased constant Text_Type :=
           "Aspect_Assoc_Rule";
         Enum_Name_For_Grammar_Rule_74 : aliased constant Text_Type :=
           "Aspect_Spec_Rule";
         Enum_Name_For_Grammar_Rule_75 : aliased constant Text_Type :=
           "Single_Task_Decl_Rule";
         Enum_Name_For_Grammar_Rule_76 : aliased constant Text_Type :=
           "Overriding_Indicator_Rule";
         Enum_Name_For_Grammar_Rule_77 : aliased constant Text_Type :=
           "Entry_Decl_Rule";
         Enum_Name_For_Grammar_Rule_78 : aliased constant Text_Type :=
           "Component_Clause_Rule";
         Enum_Name_For_Grammar_Rule_79 : aliased constant Text_Type :=
           "Aspect_Clause_Rule";
         Enum_Name_For_Grammar_Rule_80 : aliased constant Text_Type :=
           "Param_Spec_Rule";
         Enum_Name_For_Grammar_Rule_81 : aliased constant Text_Type :=
           "Param_Specs_Rule";
         Enum_Name_For_Grammar_Rule_82 : aliased constant Text_Type :=
           "Subp_Spec_Rule";
         Enum_Name_For_Grammar_Rule_83 : aliased constant Text_Type :=
           "Expr_Fn_Rule";
         Enum_Name_For_Grammar_Rule_84 : aliased constant Text_Type :=
           "Null_Subp_Decl_Rule";
         Enum_Name_For_Grammar_Rule_85 : aliased constant Text_Type :=
           "Abstract_Subp_Decl_Rule";
         Enum_Name_For_Grammar_Rule_86 : aliased constant Text_Type :=
           "Subp_Renaming_Decl_Rule";
         Enum_Name_For_Grammar_Rule_87 : aliased constant Text_Type :=
           "Simple_Subp_Decl_Rule";
         Enum_Name_For_Grammar_Rule_88 : aliased constant Text_Type :=
           "Subp_Decl_Rule";
         Enum_Name_For_Grammar_Rule_89 : aliased constant Text_Type :=
           "With_Clause_Rule";
         Enum_Name_For_Grammar_Rule_90 : aliased constant Text_Type :=
           "Context_Item_Rule";
         Enum_Name_For_Grammar_Rule_91 : aliased constant Text_Type :=
           "Use_Clause_Rule";
         Enum_Name_For_Grammar_Rule_92 : aliased constant Text_Type :=
           "Use_Package_Clause_Rule";
         Enum_Name_For_Grammar_Rule_93 : aliased constant Text_Type :=
           "Use_Type_Clause_Rule";
         Enum_Name_For_Grammar_Rule_94 : aliased constant Text_Type :=
           "Subtype_Indication_Rule";
         Enum_Name_For_Grammar_Rule_95 : aliased constant Text_Type :=
           "Discrete_Subtype_Indication_Rule";
         Enum_Name_For_Grammar_Rule_96 : aliased constant Text_Type :=
           "Constrained_Subtype_Indication_Rule";
         Enum_Name_For_Grammar_Rule_97 : aliased constant Text_Type :=
           "Type_Expr_Rule";
         Enum_Name_For_Grammar_Rule_98 : aliased constant Text_Type :=
           "Anonymous_Type_Rule";
         Enum_Name_For_Grammar_Rule_99 : aliased constant Text_Type :=
           "Mode_Rule";
         Enum_Name_For_Grammar_Rule_100 : aliased constant Text_Type :=
           "Pragma_Argument_Rule";
         Enum_Name_For_Grammar_Rule_101 : aliased constant Text_Type :=
           "Pragma_Rule";
         Enum_Name_For_Grammar_Rule_102 : aliased constant Text_Type :=
           "Subunit_Rule";
         Enum_Name_For_Grammar_Rule_103 : aliased constant Text_Type :=
           "Library_Unit_Body_Rule";
         Enum_Name_For_Grammar_Rule_104 : aliased constant Text_Type :=
           "Library_Unit_Renaming_Decl_Rule";
         Enum_Name_For_Grammar_Rule_105 : aliased constant Text_Type :=
           "Library_Item_Rule";
         Enum_Name_For_Grammar_Rule_106 : aliased constant Text_Type :=
           "Compilation_Unit_Rule";
         Enum_Name_For_Grammar_Rule_107 : aliased constant Text_Type :=
           "Compilation_Rule";
         Enum_Name_For_Grammar_Rule_108 : aliased constant Text_Type :=
           "Decl_Part_Rule";
         Enum_Name_For_Grammar_Rule_109 : aliased constant Text_Type :=
           "Entry_Body_Rule";
         Enum_Name_For_Grammar_Rule_110 : aliased constant Text_Type :=
           "Protected_Body_Rule";
         Enum_Name_For_Grammar_Rule_111 : aliased constant Text_Type :=
           "Protected_Body_Stub_Rule";
         Enum_Name_For_Grammar_Rule_112 : aliased constant Text_Type :=
           "Task_Body_Rule";
         Enum_Name_For_Grammar_Rule_113 : aliased constant Text_Type :=
           "Task_Body_Stub_Rule";
         Enum_Name_For_Grammar_Rule_114 : aliased constant Text_Type :=
           "Package_Body_Stub_Rule";
         Enum_Name_For_Grammar_Rule_115 : aliased constant Text_Type :=
           "Package_Body_Rule";
         Enum_Name_For_Grammar_Rule_116 : aliased constant Text_Type :=
           "Terminate_Alternative_Rule";
         Enum_Name_For_Grammar_Rule_117 : aliased constant Text_Type :=
           "Select_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_118 : aliased constant Text_Type :=
           "Accept_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_119 : aliased constant Text_Type :=
           "Case_Alt_Rule";
         Enum_Name_For_Grammar_Rule_120 : aliased constant Text_Type :=
           "Case_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_121 : aliased constant Text_Type :=
           "Ext_Return_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_122 : aliased constant Text_Type :=
           "Iblock_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_123 : aliased constant Text_Type :=
           "Block_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_124 : aliased constant Text_Type :=
           "While_Loop_Spec_Rule";
         Enum_Name_For_Grammar_Rule_125 : aliased constant Text_Type :=
           "Iloop_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_126 : aliased constant Text_Type :=
           "Loop_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_127 : aliased constant Text_Type :=
           "Compound_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_128 : aliased constant Text_Type :=
           "Elsif_Part_Rule";
         Enum_Name_For_Grammar_Rule_129 : aliased constant Text_Type :=
           "If_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_130 : aliased constant Text_Type :=
           "Raise_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_131 : aliased constant Text_Type :=
           "Delay_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_132 : aliased constant Text_Type :=
           "Abort_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_133 : aliased constant Text_Type :=
           "Body_Rule";
         Enum_Name_For_Grammar_Rule_134 : aliased constant Text_Type :=
           "Body_Stub_Rule";
         Enum_Name_For_Grammar_Rule_135 : aliased constant Text_Type :=
           "Subp_Body_Stub_Rule";
         Enum_Name_For_Grammar_Rule_136 : aliased constant Text_Type :=
           "Recov_Decl_Part_Rule";
         Enum_Name_For_Grammar_Rule_137 : aliased constant Text_Type :=
           "Subp_Body_Rule";
         Enum_Name_For_Grammar_Rule_138 : aliased constant Text_Type :=
           "Handled_Stmts_Rule";
         Enum_Name_For_Grammar_Rule_139 : aliased constant Text_Type :=
           "Exception_Handler_Rule";
         Enum_Name_For_Grammar_Rule_140 : aliased constant Text_Type :=
           "Stmts_Rule";
         Enum_Name_For_Grammar_Rule_141 : aliased constant Text_Type :=
           "Label_Rule";
         Enum_Name_For_Grammar_Rule_142 : aliased constant Text_Type :=
           "Stmt_Rule";
         Enum_Name_For_Grammar_Rule_143 : aliased constant Text_Type :=
           "Call_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_144 : aliased constant Text_Type :=
           "Simple_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_145 : aliased constant Text_Type :=
           "Null_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_146 : aliased constant Text_Type :=
           "Assignment_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_147 : aliased constant Text_Type :=
           "Goto_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_148 : aliased constant Text_Type :=
           "Exit_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_149 : aliased constant Text_Type :=
           "Return_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_150 : aliased constant Text_Type :=
           "Requeue_Stmt_Rule";
         Enum_Name_For_Grammar_Rule_151 : aliased constant Text_Type :=
           "Identifier_Rule";
         Enum_Name_For_Grammar_Rule_152 : aliased constant Text_Type :=
           "Char_Literal_Rule";
         Enum_Name_For_Grammar_Rule_153 : aliased constant Text_Type :=
           "String_Literal_Rule";
         Enum_Name_For_Grammar_Rule_154 : aliased constant Text_Type :=
           "Defining_Id_Rule";
         Enum_Name_For_Grammar_Rule_155 : aliased constant Text_Type :=
           "Dec_Literal_Rule";
         Enum_Name_For_Grammar_Rule_156 : aliased constant Text_Type :=
           "Int_Literal_Rule";
         Enum_Name_For_Grammar_Rule_157 : aliased constant Text_Type :=
           "Num_Literal_Rule";
         Enum_Name_For_Grammar_Rule_158 : aliased constant Text_Type :=
           "Null_Literal_Rule";
         Enum_Name_For_Grammar_Rule_159 : aliased constant Text_Type :=
           "Allocator_Rule";
         Enum_Name_For_Grammar_Rule_160 : aliased constant Text_Type :=
           "For_Loop_Param_Spec_Rule";
         Enum_Name_For_Grammar_Rule_161 : aliased constant Text_Type :=
           "Quantified_Expr_Rule";
         Enum_Name_For_Grammar_Rule_162 : aliased constant Text_Type :=
           "Case_Expr_Rule";
         Enum_Name_For_Grammar_Rule_163 : aliased constant Text_Type :=
           "Case_Expr_Alt_Rule";
         Enum_Name_For_Grammar_Rule_164 : aliased constant Text_Type :=
           "Raise_Expr_Rule";
         Enum_Name_For_Grammar_Rule_165 : aliased constant Text_Type :=
           "If_Expr_Rule";
         Enum_Name_For_Grammar_Rule_166 : aliased constant Text_Type :=
           "Conditional_Expr_Rule";
         Enum_Name_For_Grammar_Rule_167 : aliased constant Text_Type :=
           "Box_Expr_Rule";
         Enum_Name_For_Grammar_Rule_168 : aliased constant Text_Type :=
           "Others_Designator_Rule";
         Enum_Name_For_Grammar_Rule_169 : aliased constant Text_Type :=
           "Iterated_Assoc_Rule";
         Enum_Name_For_Grammar_Rule_170 : aliased constant Text_Type :=
           "Aggregate_Assoc_Rule";
         Enum_Name_For_Grammar_Rule_171 : aliased constant Text_Type :=
           "Regular_Aggregate_Rule";
         Enum_Name_For_Grammar_Rule_172 : aliased constant Text_Type :=
           "Bracket_Aggregate_Rule";
         Enum_Name_For_Grammar_Rule_173 : aliased constant Text_Type :=
           "Aggregate_Rule";
         Enum_Name_For_Grammar_Rule_174 : aliased constant Text_Type :=
           "Direct_Name_Rule";
         Enum_Name_For_Grammar_Rule_175 : aliased constant Text_Type :=
           "Param_Assoc_Rule";
         Enum_Name_For_Grammar_Rule_176 : aliased constant Text_Type :=
           "Call_Suffix_Rule";
         Enum_Name_For_Grammar_Rule_177 : aliased constant Text_Type :=
           "Attr_Suffix_Rule";
         Enum_Name_For_Grammar_Rule_178 : aliased constant Text_Type :=
           "Qualified_Name_Rule";
         Enum_Name_For_Grammar_Rule_179 : aliased constant Text_Type :=
           "Qual_Name_Internal_Rule";
         Enum_Name_For_Grammar_Rule_180 : aliased constant Text_Type :=
           "Value_Sequence_Rule";
         Enum_Name_For_Grammar_Rule_181 : aliased constant Text_Type :=
           "Name_Rule";
         Enum_Name_For_Grammar_Rule_182 : aliased constant Text_Type :=
           "Defining_Name_Rule";
         Enum_Name_For_Grammar_Rule_183 : aliased constant Text_Type :=
           "Direct_Name_Or_Target_Name_Rule";
         Enum_Name_For_Grammar_Rule_184 : aliased constant Text_Type :=
           "Target_Name_Rule";
         Enum_Name_For_Grammar_Rule_185 : aliased constant Text_Type :=
           "Update_Attr_Aggregate_Rule";
         Enum_Name_For_Grammar_Rule_186 : aliased constant Text_Type :=
           "Update_Attr_Content_Rule";
         Enum_Name_For_Grammar_Rule_187 : aliased constant Text_Type :=
           "Multidim_Array_Assoc_Rule";
         Enum_Name_For_Grammar_Rule_188 : aliased constant Text_Type :=
           "Subtype_Name_Rule";
         Enum_Name_For_Grammar_Rule_189 : aliased constant Text_Type :=
           "Static_Name_Rule";
         Enum_Name_For_Grammar_Rule_190 : aliased constant Text_Type :=
           "Primary_Rule";
         Enum_Name_For_Grammar_Rule_191 : aliased constant Text_Type :=
           "Paren_Expr_Rule";
         Enum_Name_For_Grammar_Rule_192 : aliased constant Text_Type :=
           "Declare_Expr_Rule";
         Enum_Name_For_Grammar_Rule_193 : aliased constant Text_Type :=
           "Factor_Rule";
         Enum_Name_For_Grammar_Rule_194 : aliased constant Text_Type :=
           "Term_Rule";
         Enum_Name_For_Grammar_Rule_195 : aliased constant Text_Type :=
           "Unop_Term_Rule";
         Enum_Name_For_Grammar_Rule_196 : aliased constant Text_Type :=
           "Simple_Expr_Rule";
         Enum_Name_For_Grammar_Rule_197 : aliased constant Text_Type :=
           "Boolean_Op_Rule";
         Enum_Name_For_Grammar_Rule_198 : aliased constant Text_Type :=
           "Discrete_Range_Rule";
         Enum_Name_For_Grammar_Rule_199 : aliased constant Text_Type :=
           "Choice_Rule";
         Enum_Name_For_Grammar_Rule_200 : aliased constant Text_Type :=
           "Choice_List_Rule";
         Enum_Name_For_Grammar_Rule_201 : aliased constant Text_Type :=
           "Rel_Op_Rule";
         Enum_Name_For_Grammar_Rule_202 : aliased constant Text_Type :=
           "Membership_Choice_Rule";
         Enum_Name_For_Grammar_Rule_203 : aliased constant Text_Type :=
           "Membership_Choice_List_Rule";
         Enum_Name_For_Grammar_Rule_204 : aliased constant Text_Type :=
           "Relation_Rule";
         Enum_Name_For_Grammar_Rule_205 : aliased constant Text_Type :=
           "Expr_Rule";
         Enum_Name_For_Grammar_Rule_206 : aliased constant Text_Type :=
           "Pp_Directive_Rule";
         Enum_Name_For_Grammar_Rule_207 : aliased constant Text_Type :=
           "Pp_Then_Rule";
         Enum_Name_For_Grammar_Rule_208 : aliased constant Text_Type :=
           "Pp_Expr_Rule";
         Enum_Name_For_Grammar_Rule_209 : aliased constant Text_Type :=
           "Pp_Term_Rule";

      Enum_Name_For_Grammar_Rule : aliased constant Text_Type :=
        "Grammar_Rule";
      Enum_Desc_For_Grammar_Rule : aliased constant Enum_Type_Descriptor := (
         Last_Value    => 209,
         Name          => Enum_Name_For_Grammar_Rule'Access,
         Default_Value => 0,
         Value_Names   => (
            1 => Enum_Name_For_Grammar_Rule_1'Access,
2 => Enum_Name_For_Grammar_Rule_2'Access,
3 => Enum_Name_For_Grammar_Rule_3'Access,
4 => Enum_Name_For_Grammar_Rule_4'Access,
5 => Enum_Name_For_Grammar_Rule_5'Access,
6 => Enum_Name_For_Grammar_Rule_6'Access,
7 => Enum_Name_For_Grammar_Rule_7'Access,
8 => Enum_Name_For_Grammar_Rule_8'Access,
9 => Enum_Name_For_Grammar_Rule_9'Access,
10 => Enum_Name_For_Grammar_Rule_10'Access,
11 => Enum_Name_For_Grammar_Rule_11'Access,
12 => Enum_Name_For_Grammar_Rule_12'Access,
13 => Enum_Name_For_Grammar_Rule_13'Access,
14 => Enum_Name_For_Grammar_Rule_14'Access,
15 => Enum_Name_For_Grammar_Rule_15'Access,
16 => Enum_Name_For_Grammar_Rule_16'Access,
17 => Enum_Name_For_Grammar_Rule_17'Access,
18 => Enum_Name_For_Grammar_Rule_18'Access,
19 => Enum_Name_For_Grammar_Rule_19'Access,
20 => Enum_Name_For_Grammar_Rule_20'Access,
21 => Enum_Name_For_Grammar_Rule_21'Access,
22 => Enum_Name_For_Grammar_Rule_22'Access,
23 => Enum_Name_For_Grammar_Rule_23'Access,
24 => Enum_Name_For_Grammar_Rule_24'Access,
25 => Enum_Name_For_Grammar_Rule_25'Access,
26 => Enum_Name_For_Grammar_Rule_26'Access,
27 => Enum_Name_For_Grammar_Rule_27'Access,
28 => Enum_Name_For_Grammar_Rule_28'Access,
29 => Enum_Name_For_Grammar_Rule_29'Access,
30 => Enum_Name_For_Grammar_Rule_30'Access,
31 => Enum_Name_For_Grammar_Rule_31'Access,
32 => Enum_Name_For_Grammar_Rule_32'Access,
33 => Enum_Name_For_Grammar_Rule_33'Access,
34 => Enum_Name_For_Grammar_Rule_34'Access,
35 => Enum_Name_For_Grammar_Rule_35'Access,
36 => Enum_Name_For_Grammar_Rule_36'Access,
37 => Enum_Name_For_Grammar_Rule_37'Access,
38 => Enum_Name_For_Grammar_Rule_38'Access,
39 => Enum_Name_For_Grammar_Rule_39'Access,
40 => Enum_Name_For_Grammar_Rule_40'Access,
41 => Enum_Name_For_Grammar_Rule_41'Access,
42 => Enum_Name_For_Grammar_Rule_42'Access,
43 => Enum_Name_For_Grammar_Rule_43'Access,
44 => Enum_Name_For_Grammar_Rule_44'Access,
45 => Enum_Name_For_Grammar_Rule_45'Access,
46 => Enum_Name_For_Grammar_Rule_46'Access,
47 => Enum_Name_For_Grammar_Rule_47'Access,
48 => Enum_Name_For_Grammar_Rule_48'Access,
49 => Enum_Name_For_Grammar_Rule_49'Access,
50 => Enum_Name_For_Grammar_Rule_50'Access,
51 => Enum_Name_For_Grammar_Rule_51'Access,
52 => Enum_Name_For_Grammar_Rule_52'Access,
53 => Enum_Name_For_Grammar_Rule_53'Access,
54 => Enum_Name_For_Grammar_Rule_54'Access,
55 => Enum_Name_For_Grammar_Rule_55'Access,
56 => Enum_Name_For_Grammar_Rule_56'Access,
57 => Enum_Name_For_Grammar_Rule_57'Access,
58 => Enum_Name_For_Grammar_Rule_58'Access,
59 => Enum_Name_For_Grammar_Rule_59'Access,
60 => Enum_Name_For_Grammar_Rule_60'Access,
61 => Enum_Name_For_Grammar_Rule_61'Access,
62 => Enum_Name_For_Grammar_Rule_62'Access,
63 => Enum_Name_For_Grammar_Rule_63'Access,
64 => Enum_Name_For_Grammar_Rule_64'Access,
65 => Enum_Name_For_Grammar_Rule_65'Access,
66 => Enum_Name_For_Grammar_Rule_66'Access,
67 => Enum_Name_For_Grammar_Rule_67'Access,
68 => Enum_Name_For_Grammar_Rule_68'Access,
69 => Enum_Name_For_Grammar_Rule_69'Access,
70 => Enum_Name_For_Grammar_Rule_70'Access,
71 => Enum_Name_For_Grammar_Rule_71'Access,
72 => Enum_Name_For_Grammar_Rule_72'Access,
73 => Enum_Name_For_Grammar_Rule_73'Access,
74 => Enum_Name_For_Grammar_Rule_74'Access,
75 => Enum_Name_For_Grammar_Rule_75'Access,
76 => Enum_Name_For_Grammar_Rule_76'Access,
77 => Enum_Name_For_Grammar_Rule_77'Access,
78 => Enum_Name_For_Grammar_Rule_78'Access,
79 => Enum_Name_For_Grammar_Rule_79'Access,
80 => Enum_Name_For_Grammar_Rule_80'Access,
81 => Enum_Name_For_Grammar_Rule_81'Access,
82 => Enum_Name_For_Grammar_Rule_82'Access,
83 => Enum_Name_For_Grammar_Rule_83'Access,
84 => Enum_Name_For_Grammar_Rule_84'Access,
85 => Enum_Name_For_Grammar_Rule_85'Access,
86 => Enum_Name_For_Grammar_Rule_86'Access,
87 => Enum_Name_For_Grammar_Rule_87'Access,
88 => Enum_Name_For_Grammar_Rule_88'Access,
89 => Enum_Name_For_Grammar_Rule_89'Access,
90 => Enum_Name_For_Grammar_Rule_90'Access,
91 => Enum_Name_For_Grammar_Rule_91'Access,
92 => Enum_Name_For_Grammar_Rule_92'Access,
93 => Enum_Name_For_Grammar_Rule_93'Access,
94 => Enum_Name_For_Grammar_Rule_94'Access,
95 => Enum_Name_For_Grammar_Rule_95'Access,
96 => Enum_Name_For_Grammar_Rule_96'Access,
97 => Enum_Name_For_Grammar_Rule_97'Access,
98 => Enum_Name_For_Grammar_Rule_98'Access,
99 => Enum_Name_For_Grammar_Rule_99'Access,
100 => Enum_Name_For_Grammar_Rule_100'Access,
101 => Enum_Name_For_Grammar_Rule_101'Access,
102 => Enum_Name_For_Grammar_Rule_102'Access,
103 => Enum_Name_For_Grammar_Rule_103'Access,
104 => Enum_Name_For_Grammar_Rule_104'Access,
105 => Enum_Name_For_Grammar_Rule_105'Access,
106 => Enum_Name_For_Grammar_Rule_106'Access,
107 => Enum_Name_For_Grammar_Rule_107'Access,
108 => Enum_Name_For_Grammar_Rule_108'Access,
109 => Enum_Name_For_Grammar_Rule_109'Access,
110 => Enum_Name_For_Grammar_Rule_110'Access,
111 => Enum_Name_For_Grammar_Rule_111'Access,
112 => Enum_Name_For_Grammar_Rule_112'Access,
113 => Enum_Name_For_Grammar_Rule_113'Access,
114 => Enum_Name_For_Grammar_Rule_114'Access,
115 => Enum_Name_For_Grammar_Rule_115'Access,
116 => Enum_Name_For_Grammar_Rule_116'Access,
117 => Enum_Name_For_Grammar_Rule_117'Access,
118 => Enum_Name_For_Grammar_Rule_118'Access,
119 => Enum_Name_For_Grammar_Rule_119'Access,
120 => Enum_Name_For_Grammar_Rule_120'Access,
121 => Enum_Name_For_Grammar_Rule_121'Access,
122 => Enum_Name_For_Grammar_Rule_122'Access,
123 => Enum_Name_For_Grammar_Rule_123'Access,
124 => Enum_Name_For_Grammar_Rule_124'Access,
125 => Enum_Name_For_Grammar_Rule_125'Access,
126 => Enum_Name_For_Grammar_Rule_126'Access,
127 => Enum_Name_For_Grammar_Rule_127'Access,
128 => Enum_Name_For_Grammar_Rule_128'Access,
129 => Enum_Name_For_Grammar_Rule_129'Access,
130 => Enum_Name_For_Grammar_Rule_130'Access,
131 => Enum_Name_For_Grammar_Rule_131'Access,
132 => Enum_Name_For_Grammar_Rule_132'Access,
133 => Enum_Name_For_Grammar_Rule_133'Access,
134 => Enum_Name_For_Grammar_Rule_134'Access,
135 => Enum_Name_For_Grammar_Rule_135'Access,
136 => Enum_Name_For_Grammar_Rule_136'Access,
137 => Enum_Name_For_Grammar_Rule_137'Access,
138 => Enum_Name_For_Grammar_Rule_138'Access,
139 => Enum_Name_For_Grammar_Rule_139'Access,
140 => Enum_Name_For_Grammar_Rule_140'Access,
141 => Enum_Name_For_Grammar_Rule_141'Access,
142 => Enum_Name_For_Grammar_Rule_142'Access,
143 => Enum_Name_For_Grammar_Rule_143'Access,
144 => Enum_Name_For_Grammar_Rule_144'Access,
145 => Enum_Name_For_Grammar_Rule_145'Access,
146 => Enum_Name_For_Grammar_Rule_146'Access,
147 => Enum_Name_For_Grammar_Rule_147'Access,
148 => Enum_Name_For_Grammar_Rule_148'Access,
149 => Enum_Name_For_Grammar_Rule_149'Access,
150 => Enum_Name_For_Grammar_Rule_150'Access,
151 => Enum_Name_For_Grammar_Rule_151'Access,
152 => Enum_Name_For_Grammar_Rule_152'Access,
153 => Enum_Name_For_Grammar_Rule_153'Access,
154 => Enum_Name_For_Grammar_Rule_154'Access,
155 => Enum_Name_For_Grammar_Rule_155'Access,
156 => Enum_Name_For_Grammar_Rule_156'Access,
157 => Enum_Name_For_Grammar_Rule_157'Access,
158 => Enum_Name_For_Grammar_Rule_158'Access,
159 => Enum_Name_For_Grammar_Rule_159'Access,
160 => Enum_Name_For_Grammar_Rule_160'Access,
161 => Enum_Name_For_Grammar_Rule_161'Access,
162 => Enum_Name_For_Grammar_Rule_162'Access,
163 => Enum_Name_For_Grammar_Rule_163'Access,
164 => Enum_Name_For_Grammar_Rule_164'Access,
165 => Enum_Name_For_Grammar_Rule_165'Access,
166 => Enum_Name_For_Grammar_Rule_166'Access,
167 => Enum_Name_For_Grammar_Rule_167'Access,
168 => Enum_Name_For_Grammar_Rule_168'Access,
169 => Enum_Name_For_Grammar_Rule_169'Access,
170 => Enum_Name_For_Grammar_Rule_170'Access,
171 => Enum_Name_For_Grammar_Rule_171'Access,
172 => Enum_Name_For_Grammar_Rule_172'Access,
173 => Enum_Name_For_Grammar_Rule_173'Access,
174 => Enum_Name_For_Grammar_Rule_174'Access,
175 => Enum_Name_For_Grammar_Rule_175'Access,
176 => Enum_Name_For_Grammar_Rule_176'Access,
177 => Enum_Name_For_Grammar_Rule_177'Access,
178 => Enum_Name_For_Grammar_Rule_178'Access,
179 => Enum_Name_For_Grammar_Rule_179'Access,
180 => Enum_Name_For_Grammar_Rule_180'Access,
181 => Enum_Name_For_Grammar_Rule_181'Access,
182 => Enum_Name_For_Grammar_Rule_182'Access,
183 => Enum_Name_For_Grammar_Rule_183'Access,
184 => Enum_Name_For_Grammar_Rule_184'Access,
185 => Enum_Name_For_Grammar_Rule_185'Access,
186 => Enum_Name_For_Grammar_Rule_186'Access,
187 => Enum_Name_For_Grammar_Rule_187'Access,
188 => Enum_Name_For_Grammar_Rule_188'Access,
189 => Enum_Name_For_Grammar_Rule_189'Access,
190 => Enum_Name_For_Grammar_Rule_190'Access,
191 => Enum_Name_For_Grammar_Rule_191'Access,
192 => Enum_Name_For_Grammar_Rule_192'Access,
193 => Enum_Name_For_Grammar_Rule_193'Access,
194 => Enum_Name_For_Grammar_Rule_194'Access,
195 => Enum_Name_For_Grammar_Rule_195'Access,
196 => Enum_Name_For_Grammar_Rule_196'Access,
197 => Enum_Name_For_Grammar_Rule_197'Access,
198 => Enum_Name_For_Grammar_Rule_198'Access,
199 => Enum_Name_For_Grammar_Rule_199'Access,
200 => Enum_Name_For_Grammar_Rule_200'Access,
201 => Enum_Name_For_Grammar_Rule_201'Access,
202 => Enum_Name_For_Grammar_Rule_202'Access,
203 => Enum_Name_For_Grammar_Rule_203'Access,
204 => Enum_Name_For_Grammar_Rule_204'Access,
205 => Enum_Name_For_Grammar_Rule_205'Access,
206 => Enum_Name_For_Grammar_Rule_206'Access,
207 => Enum_Name_For_Grammar_Rule_207'Access,
208 => Enum_Name_For_Grammar_Rule_208'Access,
209 => Enum_Name_For_Grammar_Rule_209'Access
         )
      );
   Enum_Types : aliased constant Enum_Type_Descriptor_Array := (
      Type_Index_For_Analysis_Unit_Kind => Enum_Desc_For_Analysis_Unit_Kind'Access,
Type_Index_For_Lookup_Kind => Enum_Desc_For_Lookup_Kind'Access,
Type_Index_For_Designated_Env_Kind => Enum_Desc_For_Designated_Env_Kind'Access,
Type_Index_For_Ref_Result_Kind => Enum_Desc_For_Ref_Result_Kind'Access,
Type_Index_For_Call_Expr_Kind => Enum_Desc_For_Call_Expr_Kind'Access,
Type_Index_For_Grammar_Rule => Enum_Desc_For_Grammar_Rule'Access
   );

   ------------------------------------
   -- Introspection values for enums --
   ------------------------------------

      
      type Internal_Rec_Analysis_Unit_Kind is new Base_Internal_Enum_Value with record
         Value : Analysis_Unit_Kind;
      end record;
      type Internal_Acc_Analysis_Unit_Kind is access all Internal_Rec_Analysis_Unit_Kind;

      overriding function "=" (Left, Right : Internal_Rec_Analysis_Unit_Kind) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Analysis_Unit_Kind) return Type_Index;
      overriding function Image (Value : Internal_Rec_Analysis_Unit_Kind) return String;
      overriding function Value_Index (Value : Internal_Rec_Analysis_Unit_Kind) return Enum_Value_Index;
      
      type Internal_Rec_Lookup_Kind is new Base_Internal_Enum_Value with record
         Value : Lookup_Kind;
      end record;
      type Internal_Acc_Lookup_Kind is access all Internal_Rec_Lookup_Kind;

      overriding function "=" (Left, Right : Internal_Rec_Lookup_Kind) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Lookup_Kind) return Type_Index;
      overriding function Image (Value : Internal_Rec_Lookup_Kind) return String;
      overriding function Value_Index (Value : Internal_Rec_Lookup_Kind) return Enum_Value_Index;
      
      type Internal_Rec_Designated_Env_Kind is new Base_Internal_Enum_Value with record
         Value : Designated_Env_Kind;
      end record;
      type Internal_Acc_Designated_Env_Kind is access all Internal_Rec_Designated_Env_Kind;

      overriding function "=" (Left, Right : Internal_Rec_Designated_Env_Kind) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Designated_Env_Kind) return Type_Index;
      overriding function Image (Value : Internal_Rec_Designated_Env_Kind) return String;
      overriding function Value_Index (Value : Internal_Rec_Designated_Env_Kind) return Enum_Value_Index;
      
      type Internal_Rec_Ref_Result_Kind is new Base_Internal_Enum_Value with record
         Value : Ref_Result_Kind;
      end record;
      type Internal_Acc_Ref_Result_Kind is access all Internal_Rec_Ref_Result_Kind;

      overriding function "=" (Left, Right : Internal_Rec_Ref_Result_Kind) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Ref_Result_Kind) return Type_Index;
      overriding function Image (Value : Internal_Rec_Ref_Result_Kind) return String;
      overriding function Value_Index (Value : Internal_Rec_Ref_Result_Kind) return Enum_Value_Index;
      
      type Internal_Rec_Call_Expr_Kind is new Base_Internal_Enum_Value with record
         Value : Call_Expr_Kind;
      end record;
      type Internal_Acc_Call_Expr_Kind is access all Internal_Rec_Call_Expr_Kind;

      overriding function "=" (Left, Right : Internal_Rec_Call_Expr_Kind) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Call_Expr_Kind) return Type_Index;
      overriding function Image (Value : Internal_Rec_Call_Expr_Kind) return String;
      overriding function Value_Index (Value : Internal_Rec_Call_Expr_Kind) return Enum_Value_Index;
      
      type Internal_Rec_Grammar_Rule is new Base_Internal_Enum_Value with record
         Value : Grammar_Rule;
      end record;
      type Internal_Acc_Grammar_Rule is access all Internal_Rec_Grammar_Rule;

      overriding function "=" (Left, Right : Internal_Rec_Grammar_Rule) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Grammar_Rule) return Type_Index;
      overriding function Image (Value : Internal_Rec_Grammar_Rule) return String;
      overriding function Value_Index (Value : Internal_Rec_Grammar_Rule) return Enum_Value_Index;

   function Create_Enum
     (Enum_Type   : Type_Index;
      Value_Index : Enum_Value_Index) return Internal_Value_Access;
   --  Implementation of the Create_Enum operation in the lanugage descriptor

   ----------------------------
   -- Array type descriptors --
   ----------------------------

   
   Array_Types : aliased constant Array_Type_Descriptor_Array := (
      Type_Index_For_Discriminant_Values_Array => (Element_Type => Type_Index_For_Discriminant_Values),
Type_Index_For_Doc_Annotation_Array => (Element_Type => Type_Index_For_Doc_Annotation),
Type_Index_For_Accept_Stmt_Array => (Element_Type => Type_Index_For_Accept_Stmt),
Type_Index_For_Ada_Node_Array => (Element_Type => Type_Index_For_Ada_Node),
Type_Index_For_Base_Formal_Param_Decl_Array => (Element_Type => Type_Index_For_Base_Formal_Param_Decl),
Type_Index_For_Base_Type_Decl_Array => (Element_Type => Type_Index_For_Base_Type_Decl),
Type_Index_For_Basic_Decl_Array => (Element_Type => Type_Index_For_Basic_Decl),
Type_Index_For_Compilation_Unit_Array => (Element_Type => Type_Index_For_Compilation_Unit),
Type_Index_For_Defining_Name_Array => (Element_Type => Type_Index_For_Defining_Name),
Type_Index_For_Expr_Array => (Element_Type => Type_Index_For_Expr),
Type_Index_For_Generic_Instantiation_Array => (Element_Type => Type_Index_For_Generic_Instantiation),
Type_Index_For_Param_Spec_Array => (Element_Type => Type_Index_For_Param_Spec),
Type_Index_For_Pragma_Array => (Element_Type => Type_Index_For_Pragma),
Type_Index_For_Type_Decl_Array => (Element_Type => Type_Index_For_Type_Decl),
Type_Index_For_Param_Actual_Array => (Element_Type => Type_Index_For_Param_Actual),
Type_Index_For_Ref_Result_Array => (Element_Type => Type_Index_For_Ref_Result),
Type_Index_For_Shape_Array => (Element_Type => Type_Index_For_Shape),
Type_Index_For_Substitution_Array => (Element_Type => Type_Index_For_Substitution),
Type_Index_For_Analysis_Unit_Array => (Element_Type => Type_Index_For_Analysis_Unit),
Type_Index_For_Symbol_Array => (Element_Type => Type_Index_For_Symbol)
   );

   -------------------------------------
   -- Introspection values for arrays --
   -------------------------------------

      

      type Internal_Stored_Discriminant_Values_Array is access all Discriminant_Values_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Discriminant_Values_Array, Internal_Stored_Discriminant_Values_Array);

      type Internal_Rec_Discriminant_Values_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Discriminant_Values_Array;
      end record;
      type Internal_Acc_Discriminant_Values_Array is access all Internal_Rec_Discriminant_Values_Array;

      overriding function "=" (Left, Right : Internal_Rec_Discriminant_Values_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Discriminant_Values_Array);
      overriding function Type_Of (Value : Internal_Rec_Discriminant_Values_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Discriminant_Values_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Discriminant_Values_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Discriminant_Values_Array;
      

      type Internal_Stored_Doc_Annotation_Array is access all Doc_Annotation_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Doc_Annotation_Array, Internal_Stored_Doc_Annotation_Array);

      type Internal_Rec_Doc_Annotation_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Doc_Annotation_Array;
      end record;
      type Internal_Acc_Doc_Annotation_Array is access all Internal_Rec_Doc_Annotation_Array;

      overriding function "=" (Left, Right : Internal_Rec_Doc_Annotation_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Doc_Annotation_Array);
      overriding function Type_Of (Value : Internal_Rec_Doc_Annotation_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Doc_Annotation_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Doc_Annotation_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Doc_Annotation_Array;
      

      type Internal_Stored_Accept_Stmt_Array is access all Accept_Stmt_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Accept_Stmt_Array, Internal_Stored_Accept_Stmt_Array);

      type Internal_Rec_Accept_Stmt_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Accept_Stmt_Array;
      end record;
      type Internal_Acc_Accept_Stmt_Array is access all Internal_Rec_Accept_Stmt_Array;

      overriding function "=" (Left, Right : Internal_Rec_Accept_Stmt_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Accept_Stmt_Array);
      overriding function Type_Of (Value : Internal_Rec_Accept_Stmt_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Accept_Stmt_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Accept_Stmt_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Accept_Stmt_Array;
      

      type Internal_Stored_Ada_Node_Array is access all Ada_Node_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Ada_Node_Array, Internal_Stored_Ada_Node_Array);

      type Internal_Rec_Ada_Node_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Ada_Node_Array;
      end record;
      type Internal_Acc_Ada_Node_Array is access all Internal_Rec_Ada_Node_Array;

      overriding function "=" (Left, Right : Internal_Rec_Ada_Node_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Ada_Node_Array);
      overriding function Type_Of (Value : Internal_Rec_Ada_Node_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Ada_Node_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Ada_Node_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Ada_Node_Array;
      

      type Internal_Stored_Base_Formal_Param_Decl_Array is access all Base_Formal_Param_Decl_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Base_Formal_Param_Decl_Array, Internal_Stored_Base_Formal_Param_Decl_Array);

      type Internal_Rec_Base_Formal_Param_Decl_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Base_Formal_Param_Decl_Array;
      end record;
      type Internal_Acc_Base_Formal_Param_Decl_Array is access all Internal_Rec_Base_Formal_Param_Decl_Array;

      overriding function "=" (Left, Right : Internal_Rec_Base_Formal_Param_Decl_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Base_Formal_Param_Decl_Array);
      overriding function Type_Of (Value : Internal_Rec_Base_Formal_Param_Decl_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Base_Formal_Param_Decl_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Base_Formal_Param_Decl_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Base_Formal_Param_Decl_Array;
      

      type Internal_Stored_Base_Type_Decl_Array is access all Base_Type_Decl_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Base_Type_Decl_Array, Internal_Stored_Base_Type_Decl_Array);

      type Internal_Rec_Base_Type_Decl_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Base_Type_Decl_Array;
      end record;
      type Internal_Acc_Base_Type_Decl_Array is access all Internal_Rec_Base_Type_Decl_Array;

      overriding function "=" (Left, Right : Internal_Rec_Base_Type_Decl_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Base_Type_Decl_Array);
      overriding function Type_Of (Value : Internal_Rec_Base_Type_Decl_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Base_Type_Decl_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Base_Type_Decl_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Base_Type_Decl_Array;
      

      type Internal_Stored_Basic_Decl_Array is access all Basic_Decl_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Basic_Decl_Array, Internal_Stored_Basic_Decl_Array);

      type Internal_Rec_Basic_Decl_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Basic_Decl_Array;
      end record;
      type Internal_Acc_Basic_Decl_Array is access all Internal_Rec_Basic_Decl_Array;

      overriding function "=" (Left, Right : Internal_Rec_Basic_Decl_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Basic_Decl_Array);
      overriding function Type_Of (Value : Internal_Rec_Basic_Decl_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Basic_Decl_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Basic_Decl_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Basic_Decl_Array;
      

      type Internal_Stored_Compilation_Unit_Array is access all Compilation_Unit_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Compilation_Unit_Array, Internal_Stored_Compilation_Unit_Array);

      type Internal_Rec_Compilation_Unit_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Compilation_Unit_Array;
      end record;
      type Internal_Acc_Compilation_Unit_Array is access all Internal_Rec_Compilation_Unit_Array;

      overriding function "=" (Left, Right : Internal_Rec_Compilation_Unit_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Compilation_Unit_Array);
      overriding function Type_Of (Value : Internal_Rec_Compilation_Unit_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Compilation_Unit_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Compilation_Unit_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Compilation_Unit_Array;
      

      type Internal_Stored_Defining_Name_Array is access all Defining_Name_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Defining_Name_Array, Internal_Stored_Defining_Name_Array);

      type Internal_Rec_Defining_Name_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Defining_Name_Array;
      end record;
      type Internal_Acc_Defining_Name_Array is access all Internal_Rec_Defining_Name_Array;

      overriding function "=" (Left, Right : Internal_Rec_Defining_Name_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Defining_Name_Array);
      overriding function Type_Of (Value : Internal_Rec_Defining_Name_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Defining_Name_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Defining_Name_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Defining_Name_Array;
      

      type Internal_Stored_Expr_Array is access all Expr_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Expr_Array, Internal_Stored_Expr_Array);

      type Internal_Rec_Expr_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Expr_Array;
      end record;
      type Internal_Acc_Expr_Array is access all Internal_Rec_Expr_Array;

      overriding function "=" (Left, Right : Internal_Rec_Expr_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Expr_Array);
      overriding function Type_Of (Value : Internal_Rec_Expr_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Expr_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Expr_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Expr_Array;
      

      type Internal_Stored_Generic_Instantiation_Array is access all Generic_Instantiation_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Generic_Instantiation_Array, Internal_Stored_Generic_Instantiation_Array);

      type Internal_Rec_Generic_Instantiation_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Generic_Instantiation_Array;
      end record;
      type Internal_Acc_Generic_Instantiation_Array is access all Internal_Rec_Generic_Instantiation_Array;

      overriding function "=" (Left, Right : Internal_Rec_Generic_Instantiation_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Generic_Instantiation_Array);
      overriding function Type_Of (Value : Internal_Rec_Generic_Instantiation_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Generic_Instantiation_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Generic_Instantiation_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Generic_Instantiation_Array;
      

      type Internal_Stored_Param_Spec_Array is access all Param_Spec_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Param_Spec_Array, Internal_Stored_Param_Spec_Array);

      type Internal_Rec_Param_Spec_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Param_Spec_Array;
      end record;
      type Internal_Acc_Param_Spec_Array is access all Internal_Rec_Param_Spec_Array;

      overriding function "=" (Left, Right : Internal_Rec_Param_Spec_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Param_Spec_Array);
      overriding function Type_Of (Value : Internal_Rec_Param_Spec_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Param_Spec_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Param_Spec_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Param_Spec_Array;
      

      type Internal_Stored_Pragma_Array is access all Pragma_Node_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Pragma_Node_Array, Internal_Stored_Pragma_Array);

      type Internal_Rec_Pragma_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Pragma_Array;
      end record;
      type Internal_Acc_Pragma_Array is access all Internal_Rec_Pragma_Array;

      overriding function "=" (Left, Right : Internal_Rec_Pragma_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Pragma_Array);
      overriding function Type_Of (Value : Internal_Rec_Pragma_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Pragma_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Pragma_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Pragma_Array;
      

      type Internal_Stored_Type_Decl_Array is access all Type_Decl_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Type_Decl_Array, Internal_Stored_Type_Decl_Array);

      type Internal_Rec_Type_Decl_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Type_Decl_Array;
      end record;
      type Internal_Acc_Type_Decl_Array is access all Internal_Rec_Type_Decl_Array;

      overriding function "=" (Left, Right : Internal_Rec_Type_Decl_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Type_Decl_Array);
      overriding function Type_Of (Value : Internal_Rec_Type_Decl_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Type_Decl_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Type_Decl_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Type_Decl_Array;
      

      type Internal_Stored_Param_Actual_Array is access all Param_Actual_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Param_Actual_Array, Internal_Stored_Param_Actual_Array);

      type Internal_Rec_Param_Actual_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Param_Actual_Array;
      end record;
      type Internal_Acc_Param_Actual_Array is access all Internal_Rec_Param_Actual_Array;

      overriding function "=" (Left, Right : Internal_Rec_Param_Actual_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Param_Actual_Array);
      overriding function Type_Of (Value : Internal_Rec_Param_Actual_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Param_Actual_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Param_Actual_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Param_Actual_Array;
      

      type Internal_Stored_Ref_Result_Array is access all Ref_Result_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Ref_Result_Array, Internal_Stored_Ref_Result_Array);

      type Internal_Rec_Ref_Result_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Ref_Result_Array;
      end record;
      type Internal_Acc_Ref_Result_Array is access all Internal_Rec_Ref_Result_Array;

      overriding function "=" (Left, Right : Internal_Rec_Ref_Result_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Ref_Result_Array);
      overriding function Type_Of (Value : Internal_Rec_Ref_Result_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Ref_Result_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Ref_Result_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Ref_Result_Array;
      

      type Internal_Stored_Shape_Array is access all Shape_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Shape_Array, Internal_Stored_Shape_Array);

      type Internal_Rec_Shape_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Shape_Array;
      end record;
      type Internal_Acc_Shape_Array is access all Internal_Rec_Shape_Array;

      overriding function "=" (Left, Right : Internal_Rec_Shape_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Shape_Array);
      overriding function Type_Of (Value : Internal_Rec_Shape_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Shape_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Shape_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Shape_Array;
      

      type Internal_Stored_Substitution_Array is access all Substitution_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Substitution_Array, Internal_Stored_Substitution_Array);

      type Internal_Rec_Substitution_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Substitution_Array;
      end record;
      type Internal_Acc_Substitution_Array is access all Internal_Rec_Substitution_Array;

      overriding function "=" (Left, Right : Internal_Rec_Substitution_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Substitution_Array);
      overriding function Type_Of (Value : Internal_Rec_Substitution_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Substitution_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Substitution_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Substitution_Array;
      

      type Internal_Stored_Analysis_Unit_Array is access all Analysis_Unit_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Analysis_Unit_Array, Internal_Stored_Analysis_Unit_Array);

      type Internal_Rec_Analysis_Unit_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Analysis_Unit_Array;
      end record;
      type Internal_Acc_Analysis_Unit_Array is access all Internal_Rec_Analysis_Unit_Array;

      overriding function "=" (Left, Right : Internal_Rec_Analysis_Unit_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Analysis_Unit_Array);
      overriding function Type_Of (Value : Internal_Rec_Analysis_Unit_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Analysis_Unit_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Analysis_Unit_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Analysis_Unit_Array;
      

      type Internal_Stored_Symbol_Array is access all Unbounded_Text_Type_Array;
      procedure Free is new Ada.Unchecked_Deallocation (Unbounded_Text_Type_Array, Internal_Stored_Symbol_Array);

      type Internal_Rec_Symbol_Array is new Base_Internal_Array_Value with record
         Value : Internal_Stored_Symbol_Array;
      end record;
      type Internal_Acc_Symbol_Array is access all Internal_Rec_Symbol_Array;

      overriding function "=" (Left, Right : Internal_Rec_Symbol_Array) return Boolean;
      overriding procedure Destroy (Value : in out Internal_Rec_Symbol_Array);
      overriding function Type_Of (Value : Internal_Rec_Symbol_Array) return Type_Index;
      overriding function Array_Length (Value : Internal_Rec_Symbol_Array) return Natural;
      overriding function Array_Item
        (Value : Internal_Rec_Symbol_Array; Index : Positive) return Internal_Value_Access;

      function Create_Array
        (Values : Internal_Value_Array) return Internal_Acc_Symbol_Array;

   function Create_Array
     (Array_Type : Type_Index;
      Values     : Internal_Value_Array) return Internal_Value_Access;
   --  Implementation of the Create_Array operation in the language descriptor

   -------------------------------
   -- Iterator type descriptors --
   -------------------------------

   
   Iterator_Types : aliased constant Iterator_Type_Descriptor_Array := (
         Type_Index_For_Completion_Item_Iterator => (Element_Type => Type_Index_For_Completion_Item)
   );

      

      type Internal_Rec_Completion_Item_Iterator is new Base_Internal_Iterator_Value with record
         Value : Completion_Item_Iterator;
      end record;
      type Internal_Acc_Completion_Item_Iterator is access all Internal_Rec_Completion_Item_Iterator;

      overriding function "=" (Left, Right : Internal_Rec_Completion_Item_Iterator) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Completion_Item_Iterator) return Type_Index;
      overriding function Next (Value : Internal_Rec_Completion_Item_Iterator) return Internal_Value_Access;

   --------------------------------------
   -- Introspection values for structs --
   --------------------------------------

      

      type Internal_Rec_Aspect is new Base_Internal_Struct_Value with record
         Value : Aspect;
      end record;
      type Internal_Acc_Aspect is access all Internal_Rec_Aspect;

      overriding function "=" (Left, Right : Internal_Rec_Aspect) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Aspect) return Type_Index;
      overriding function Eval_Member
        (Value  : Internal_Rec_Aspect;
         Member : Struct_Member_Index) return Internal_Value_Access;
      function Create_Struct
        (Values : Internal_Value_Array) return Internal_Acc_Aspect;
      

      type Internal_Rec_Completion_Item is new Base_Internal_Struct_Value with record
         Value : Completion_Item;
      end record;
      type Internal_Acc_Completion_Item is access all Internal_Rec_Completion_Item;

      overriding function "=" (Left, Right : Internal_Rec_Completion_Item) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Completion_Item) return Type_Index;
      overriding function Eval_Member
        (Value  : Internal_Rec_Completion_Item;
         Member : Struct_Member_Index) return Internal_Value_Access;
      function Create_Struct
        (Values : Internal_Value_Array) return Internal_Acc_Completion_Item;
      

      type Internal_Rec_Discrete_Range is new Base_Internal_Struct_Value with record
         Value : Discrete_Range;
      end record;
      type Internal_Acc_Discrete_Range is access all Internal_Rec_Discrete_Range;

      overriding function "=" (Left, Right : Internal_Rec_Discrete_Range) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Discrete_Range) return Type_Index;
      overriding function Eval_Member
        (Value  : Internal_Rec_Discrete_Range;
         Member : Struct_Member_Index) return Internal_Value_Access;
      function Create_Struct
        (Values : Internal_Value_Array) return Internal_Acc_Discrete_Range;
      

      type Internal_Rec_Discriminant_Values is new Base_Internal_Struct_Value with record
         Value : Discriminant_Values;
      end record;
      type Internal_Acc_Discriminant_Values is access all Internal_Rec_Discriminant_Values;

      overriding function "=" (Left, Right : Internal_Rec_Discriminant_Values) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Discriminant_Values) return Type_Index;
      overriding function Eval_Member
        (Value  : Internal_Rec_Discriminant_Values;
         Member : Struct_Member_Index) return Internal_Value_Access;
      function Create_Struct
        (Values : Internal_Value_Array) return Internal_Acc_Discriminant_Values;
      

      type Internal_Rec_Doc_Annotation is new Base_Internal_Struct_Value with record
         Value : Doc_Annotation;
      end record;
      type Internal_Acc_Doc_Annotation is access all Internal_Rec_Doc_Annotation;

      overriding function "=" (Left, Right : Internal_Rec_Doc_Annotation) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Doc_Annotation) return Type_Index;
      overriding function Eval_Member
        (Value  : Internal_Rec_Doc_Annotation;
         Member : Struct_Member_Index) return Internal_Value_Access;
      function Create_Struct
        (Values : Internal_Value_Array) return Internal_Acc_Doc_Annotation;
      

      type Internal_Rec_Param_Actual is new Base_Internal_Struct_Value with record
         Value : Param_Actual;
      end record;
      type Internal_Acc_Param_Actual is access all Internal_Rec_Param_Actual;

      overriding function "=" (Left, Right : Internal_Rec_Param_Actual) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Param_Actual) return Type_Index;
      overriding function Eval_Member
        (Value  : Internal_Rec_Param_Actual;
         Member : Struct_Member_Index) return Internal_Value_Access;
      function Create_Struct
        (Values : Internal_Value_Array) return Internal_Acc_Param_Actual;
      

      type Internal_Rec_Ref_Result is new Base_Internal_Struct_Value with record
         Value : Ref_Result;
      end record;
      type Internal_Acc_Ref_Result is access all Internal_Rec_Ref_Result;

      overriding function "=" (Left, Right : Internal_Rec_Ref_Result) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Ref_Result) return Type_Index;
      overriding function Eval_Member
        (Value  : Internal_Rec_Ref_Result;
         Member : Struct_Member_Index) return Internal_Value_Access;
      function Create_Struct
        (Values : Internal_Value_Array) return Internal_Acc_Ref_Result;
      

      type Internal_Rec_Refd_Decl is new Base_Internal_Struct_Value with record
         Value : Refd_Decl;
      end record;
      type Internal_Acc_Refd_Decl is access all Internal_Rec_Refd_Decl;

      overriding function "=" (Left, Right : Internal_Rec_Refd_Decl) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Refd_Decl) return Type_Index;
      overriding function Eval_Member
        (Value  : Internal_Rec_Refd_Decl;
         Member : Struct_Member_Index) return Internal_Value_Access;
      function Create_Struct
        (Values : Internal_Value_Array) return Internal_Acc_Refd_Decl;
      

      type Internal_Rec_Refd_Def is new Base_Internal_Struct_Value with record
         Value : Refd_Def;
      end record;
      type Internal_Acc_Refd_Def is access all Internal_Rec_Refd_Def;

      overriding function "=" (Left, Right : Internal_Rec_Refd_Def) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Refd_Def) return Type_Index;
      overriding function Eval_Member
        (Value  : Internal_Rec_Refd_Def;
         Member : Struct_Member_Index) return Internal_Value_Access;
      function Create_Struct
        (Values : Internal_Value_Array) return Internal_Acc_Refd_Def;
      

      type Internal_Rec_Shape is new Base_Internal_Struct_Value with record
         Value : Shape;
      end record;
      type Internal_Acc_Shape is access all Internal_Rec_Shape;

      overriding function "=" (Left, Right : Internal_Rec_Shape) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Shape) return Type_Index;
      overriding function Eval_Member
        (Value  : Internal_Rec_Shape;
         Member : Struct_Member_Index) return Internal_Value_Access;
      function Create_Struct
        (Values : Internal_Value_Array) return Internal_Acc_Shape;
      

      type Internal_Rec_Substitution is new Base_Internal_Struct_Value with record
         Value : Substitution;
      end record;
      type Internal_Acc_Substitution is access all Internal_Rec_Substitution;

      overriding function "=" (Left, Right : Internal_Rec_Substitution) return Boolean;
      overriding function Type_Of (Value : Internal_Rec_Substitution) return Type_Index;
      overriding function Eval_Member
        (Value  : Internal_Rec_Substitution;
         Member : Struct_Member_Index) return Internal_Value_Access;
      function Create_Struct
        (Values : Internal_Value_Array) return Internal_Acc_Substitution;

   function Create_Struct
     (Struct_Type : Type_Index;
      Values      : Internal_Value_Array) return Internal_Value_Access;
   --  Implementation for the Create_Struct operation in the language
   --  descriptor.

   -------------------------------
   -- Struct member descriptors --
   -------------------------------

   
      


      Member_Name_For_Aspect_Exists : aliased constant Text_Type :=
        "Exists";
      Member_Desc_For_Aspect_Exists : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Aspect_Exists'Access,
         Owner         => Type_Index_For_Aspect,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Aspect_Node : aliased constant Text_Type :=
        "Node";
      Member_Desc_For_Aspect_Node : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Aspect_Node'Access,
         Owner         => Type_Index_For_Aspect,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Aspect_Value : aliased constant Text_Type :=
        "Value";
      Member_Desc_For_Aspect_Value : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Aspect_Value'Access,
         Owner         => Type_Index_For_Aspect,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Completion_Item_Decl : aliased constant Text_Type :=
        "Decl";
      Member_Desc_For_Completion_Item_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Completion_Item_Decl'Access,
         Owner         => Type_Index_For_Completion_Item,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Completion_Item_Is_Dot_Call : aliased constant Text_Type :=
        "Is_Dot_Call";
      Member_Desc_For_Completion_Item_Is_Dot_Call : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Completion_Item_Is_Dot_Call'Access,
         Owner         => Type_Index_For_Completion_Item,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Completion_Item_Is_Visible : aliased constant Text_Type :=
        "Is_Visible";
      Member_Desc_For_Completion_Item_Is_Visible : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Completion_Item_Is_Visible'Access,
         Owner         => Type_Index_For_Completion_Item,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Completion_Item_Weight : aliased constant Text_Type :=
        "Weight";
      Member_Desc_For_Completion_Item_Weight : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Completion_Item_Weight'Access,
         Owner         => Type_Index_For_Completion_Item,
         Member_Type   => Type_Index_For_Int,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Discrete_Range_Low_Bound : aliased constant Text_Type :=
        "Low_Bound";
      Member_Desc_For_Discrete_Range_Low_Bound : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Discrete_Range_Low_Bound'Access,
         Owner         => Type_Index_For_Discrete_Range,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Discrete_Range_High_Bound : aliased constant Text_Type :=
        "High_Bound";
      Member_Desc_For_Discrete_Range_High_Bound : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Discrete_Range_High_Bound'Access,
         Owner         => Type_Index_For_Discrete_Range,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Discriminant_Values_Discriminant : aliased constant Text_Type :=
        "Discriminant";
      Member_Desc_For_Discriminant_Values_Discriminant : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Discriminant_Values_Discriminant'Access,
         Owner         => Type_Index_For_Discriminant_Values,
         Member_Type   => Type_Index_For_Identifier,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Discriminant_Values_Values : aliased constant Text_Type :=
        "Values";
      Member_Desc_For_Discriminant_Values_Values : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Discriminant_Values_Values'Access,
         Owner         => Type_Index_For_Discriminant_Values,
         Member_Type   => Type_Index_For_Alternatives_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Doc_Annotation_Key : aliased constant Text_Type :=
        "Key";
      Member_Desc_For_Doc_Annotation_Key : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Doc_Annotation_Key'Access,
         Owner         => Type_Index_For_Doc_Annotation,
         Member_Type   => Type_Index_For_String,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Doc_Annotation_Value : aliased constant Text_Type :=
        "Value";
      Member_Desc_For_Doc_Annotation_Value : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Doc_Annotation_Value'Access,
         Owner         => Type_Index_For_Doc_Annotation,
         Member_Type   => Type_Index_For_String,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Param_Actual_Param : aliased constant Text_Type :=
        "Param";
      Member_Desc_For_Param_Actual_Param : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Param_Actual_Param'Access,
         Owner         => Type_Index_For_Param_Actual,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Param_Actual_Actual : aliased constant Text_Type :=
        "Actual";
      Member_Desc_For_Param_Actual_Actual : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Param_Actual_Actual'Access,
         Owner         => Type_Index_For_Param_Actual,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ref_Result_Ref : aliased constant Text_Type :=
        "Ref";
      Member_Desc_For_Ref_Result_Ref : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ref_Result_Ref'Access,
         Owner         => Type_Index_For_Ref_Result,
         Member_Type   => Type_Index_For_Base_Id,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ref_Result_Kind : aliased constant Text_Type :=
        "Kind";
      Member_Desc_For_Ref_Result_Kind : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ref_Result_Kind'Access,
         Owner         => Type_Index_For_Ref_Result,
         Member_Type   => Type_Index_For_Ref_Result_Kind,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Refd_Decl_Decl : aliased constant Text_Type :=
        "Decl";
      Member_Desc_For_Refd_Decl_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Refd_Decl_Decl'Access,
         Owner         => Type_Index_For_Refd_Decl,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Refd_Decl_Kind : aliased constant Text_Type :=
        "Kind";
      Member_Desc_For_Refd_Decl_Kind : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Refd_Decl_Kind'Access,
         Owner         => Type_Index_For_Refd_Decl,
         Member_Type   => Type_Index_For_Ref_Result_Kind,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Refd_Def_Def_Name : aliased constant Text_Type :=
        "Def_Name";
      Member_Desc_For_Refd_Def_Def_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Refd_Def_Def_Name'Access,
         Owner         => Type_Index_For_Refd_Def,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Refd_Def_Kind : aliased constant Text_Type :=
        "Kind";
      Member_Desc_For_Refd_Def_Kind : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Refd_Def_Kind'Access,
         Owner         => Type_Index_For_Refd_Def,
         Member_Type   => Type_Index_For_Ref_Result_Kind,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Shape_Components : aliased constant Text_Type :=
        "Components";
      Member_Desc_For_Shape_Components : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Shape_Components'Access,
         Owner         => Type_Index_For_Shape,
         Member_Type   => Type_Index_For_Base_Formal_Param_Decl_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Shape_Discriminants_Values : aliased constant Text_Type :=
        "Discriminants_Values";
      Member_Desc_For_Shape_Discriminants_Values : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Shape_Discriminants_Values'Access,
         Owner         => Type_Index_For_Shape,
         Member_Type   => Type_Index_For_Discriminant_Values_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Substitution_From_Decl : aliased constant Text_Type :=
        "From_Decl";
      Member_Desc_For_Substitution_From_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Substitution_From_Decl'Access,
         Owner         => Type_Index_For_Substitution,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Substitution_To_Value : aliased constant Text_Type :=
        "To_Value";
      Member_Desc_For_Substitution_To_Value : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Substitution_To_Value'Access,
         Owner         => Type_Index_For_Substitution,
         Member_Type   => Type_Index_For_Big_Int,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Substitution_Value_Type : aliased constant Text_Type :=
        "Value_Type";
      Member_Desc_For_Substitution_Value_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Substitution_Value_Type'Access,
         Owner         => Type_Index_For_Substitution,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Constrained_Array_Indices_F_List : aliased constant Text_Type :=
        "F_List";
      Member_Desc_For_Constrained_Array_Indices_F_List : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Constrained_Array_Indices_F_List'Access,
         Owner         => Type_Index_For_Constrained_Array_Indices,
         Member_Type   => Type_Index_For_Constraint_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Unconstrained_Array_Indices_F_Types : aliased constant Text_Type :=
        "F_Types";
      Member_Desc_For_Unconstrained_Array_Indices_F_Types : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Unconstrained_Array_Indices_F_Types'Access,
         Owner         => Type_Index_For_Unconstrained_Array_Indices,
         Member_Type   => Type_Index_For_Unconstrained_Array_Index_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Aspect_Assoc_F_Id : aliased constant Text_Type :=
        "F_Id";
      Member_Desc_For_Aspect_Assoc_F_Id : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Aspect_Assoc_F_Id'Access,
         Owner         => Type_Index_For_Aspect_Assoc,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Aspect_Assoc_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Aspect_Assoc_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Aspect_Assoc_F_Expr'Access,
         Owner         => Type_Index_For_Aspect_Assoc,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_At_Clause_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_At_Clause_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_At_Clause_F_Name'Access,
         Owner         => Type_Index_For_At_Clause,
         Member_Type   => Type_Index_For_Base_Id,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_At_Clause_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_At_Clause_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_At_Clause_F_Expr'Access,
         Owner         => Type_Index_For_At_Clause,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Attribute_Def_Clause_F_Attribute_Expr : aliased constant Text_Type :=
        "F_Attribute_Expr";
      Member_Desc_For_Attribute_Def_Clause_F_Attribute_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Attribute_Def_Clause_F_Attribute_Expr'Access,
         Owner         => Type_Index_For_Attribute_Def_Clause,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Attribute_Def_Clause_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Attribute_Def_Clause_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Attribute_Def_Clause_F_Expr'Access,
         Owner         => Type_Index_For_Attribute_Def_Clause,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Enum_Rep_Clause_F_Type_Name : aliased constant Text_Type :=
        "F_Type_Name";
      Member_Desc_For_Enum_Rep_Clause_F_Type_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Enum_Rep_Clause_F_Type_Name'Access,
         Owner         => Type_Index_For_Enum_Rep_Clause,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Enum_Rep_Clause_F_Aggregate : aliased constant Text_Type :=
        "F_Aggregate";
      Member_Desc_For_Enum_Rep_Clause_F_Aggregate : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Enum_Rep_Clause_F_Aggregate'Access,
         Owner         => Type_Index_For_Enum_Rep_Clause,
         Member_Type   => Type_Index_For_Base_Aggregate,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Record_Rep_Clause_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Record_Rep_Clause_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Record_Rep_Clause_F_Name'Access,
         Owner         => Type_Index_For_Record_Rep_Clause,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Record_Rep_Clause_F_At_Expr : aliased constant Text_Type :=
        "F_At_Expr";
      Member_Desc_For_Record_Rep_Clause_F_At_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Record_Rep_Clause_F_At_Expr'Access,
         Owner         => Type_Index_For_Record_Rep_Clause,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Record_Rep_Clause_F_Components : aliased constant Text_Type :=
        "F_Components";
      Member_Desc_For_Record_Rep_Clause_F_Components : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Record_Rep_Clause_F_Components'Access,
         Owner         => Type_Index_For_Record_Rep_Clause,
         Member_Type   => Type_Index_For_Ada_Node_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Aspect_Spec_F_Aspect_Assocs : aliased constant Text_Type :=
        "F_Aspect_Assocs";
      Member_Desc_For_Aspect_Spec_F_Aspect_Assocs : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Aspect_Spec_F_Aspect_Assocs'Access,
         Owner         => Type_Index_For_Aspect_Spec,
         Member_Type   => Type_Index_For_Aspect_Assoc_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Contract_Case_Assoc_F_Guard : aliased constant Text_Type :=
        "F_Guard";
      Member_Desc_For_Contract_Case_Assoc_F_Guard : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Contract_Case_Assoc_F_Guard'Access,
         Owner         => Type_Index_For_Contract_Case_Assoc,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Contract_Case_Assoc_F_Consequence : aliased constant Text_Type :=
        "F_Consequence";
      Member_Desc_For_Contract_Case_Assoc_F_Consequence : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Contract_Case_Assoc_F_Consequence'Access,
         Owner         => Type_Index_For_Contract_Case_Assoc,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Pragma_Argument_Assoc_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Pragma_Argument_Assoc_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Pragma_Argument_Assoc_F_Name'Access,
         Owner         => Type_Index_For_Pragma_Argument_Assoc,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Pragma_Argument_Assoc_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Pragma_Argument_Assoc_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Pragma_Argument_Assoc_F_Expr'Access,
         Owner         => Type_Index_For_Pragma_Argument_Assoc,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Spec_F_Entry_Name : aliased constant Text_Type :=
        "F_Entry_Name";
      Member_Desc_For_Entry_Spec_F_Entry_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Spec_F_Entry_Name'Access,
         Owner         => Type_Index_For_Entry_Spec,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Spec_F_Family_Type : aliased constant Text_Type :=
        "F_Family_Type";
      Member_Desc_For_Entry_Spec_F_Family_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Spec_F_Family_Type'Access,
         Owner         => Type_Index_For_Entry_Spec,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Spec_F_Entry_Params : aliased constant Text_Type :=
        "F_Entry_Params";
      Member_Desc_For_Entry_Spec_F_Entry_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Spec_F_Entry_Params'Access,
         Owner         => Type_Index_For_Entry_Spec,
         Member_Type   => Type_Index_For_Params,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subp_Spec_F_Subp_Kind : aliased constant Text_Type :=
        "F_Subp_Kind";
      Member_Desc_For_Subp_Spec_F_Subp_Kind : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subp_Spec_F_Subp_Kind'Access,
         Owner         => Type_Index_For_Subp_Spec,
         Member_Type   => Type_Index_For_Subp_Kind,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subp_Spec_F_Subp_Name : aliased constant Text_Type :=
        "F_Subp_Name";
      Member_Desc_For_Subp_Spec_F_Subp_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subp_Spec_F_Subp_Name'Access,
         Owner         => Type_Index_For_Subp_Spec,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subp_Spec_F_Subp_Params : aliased constant Text_Type :=
        "F_Subp_Params";
      Member_Desc_For_Subp_Spec_F_Subp_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subp_Spec_F_Subp_Params'Access,
         Owner         => Type_Index_For_Subp_Spec,
         Member_Type   => Type_Index_For_Params,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subp_Spec_F_Subp_Returns : aliased constant Text_Type :=
        "F_Subp_Returns";
      Member_Desc_For_Subp_Spec_F_Subp_Returns : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subp_Spec_F_Subp_Returns'Access,
         Owner         => Type_Index_For_Subp_Spec,
         Member_Type   => Type_Index_For_Type_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Synthetic_Binary_Spec_F_Left_Param : aliased constant Text_Type :=
        "F_Left_Param";
      Member_Desc_For_Synthetic_Binary_Spec_F_Left_Param : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Synthetic_Binary_Spec_F_Left_Param'Access,
         Owner         => Type_Index_For_Synthetic_Binary_Spec,
         Member_Type   => Type_Index_For_Synthetic_Formal_Param_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Synthetic_Binary_Spec_F_Right_Param : aliased constant Text_Type :=
        "F_Right_Param";
      Member_Desc_For_Synthetic_Binary_Spec_F_Right_Param : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Synthetic_Binary_Spec_F_Right_Param'Access,
         Owner         => Type_Index_For_Synthetic_Binary_Spec,
         Member_Type   => Type_Index_For_Synthetic_Formal_Param_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Synthetic_Binary_Spec_F_Return_Type_Expr : aliased constant Text_Type :=
        "F_Return_Type_Expr";
      Member_Desc_For_Synthetic_Binary_Spec_F_Return_Type_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Synthetic_Binary_Spec_F_Return_Type_Expr'Access,
         Owner         => Type_Index_For_Synthetic_Binary_Spec,
         Member_Type   => Type_Index_For_Type_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Synthetic_Unary_Spec_F_Right_Param : aliased constant Text_Type :=
        "F_Right_Param";
      Member_Desc_For_Synthetic_Unary_Spec_F_Right_Param : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Synthetic_Unary_Spec_F_Right_Param'Access,
         Owner         => Type_Index_For_Synthetic_Unary_Spec,
         Member_Type   => Type_Index_For_Synthetic_Formal_Param_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Synthetic_Unary_Spec_F_Return_Type_Expr : aliased constant Text_Type :=
        "F_Return_Type_Expr";
      Member_Desc_For_Synthetic_Unary_Spec_F_Return_Type_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Synthetic_Unary_Spec_F_Return_Type_Expr'Access,
         Owner         => Type_Index_For_Synthetic_Unary_Spec,
         Member_Type   => Type_Index_For_Synthetic_Type_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Component_List_F_Components : aliased constant Text_Type :=
        "F_Components";
      Member_Desc_For_Component_List_F_Components : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Component_List_F_Components'Access,
         Owner         => Type_Index_For_Component_List,
         Member_Type   => Type_Index_For_Ada_Node_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Component_List_F_Variant_Part : aliased constant Text_Type :=
        "F_Variant_Part";
      Member_Desc_For_Component_List_F_Variant_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Component_List_F_Variant_Part'Access,
         Owner         => Type_Index_For_Component_List,
         Member_Type   => Type_Index_For_Variant_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Known_Discriminant_Part_F_Discr_Specs : aliased constant Text_Type :=
        "F_Discr_Specs";
      Member_Desc_For_Known_Discriminant_Part_F_Discr_Specs : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Known_Discriminant_Part_F_Discr_Specs'Access,
         Owner         => Type_Index_For_Known_Discriminant_Part,
         Member_Type   => Type_Index_For_Discriminant_Spec_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Completion_Formal_Params_F_Params : aliased constant Text_Type :=
        "F_Params";
      Member_Desc_For_Entry_Completion_Formal_Params_F_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Completion_Formal_Params_F_Params'Access,
         Owner         => Type_Index_For_Entry_Completion_Formal_Params,
         Member_Type   => Type_Index_For_Params,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Formal_Part_F_Decls : aliased constant Text_Type :=
        "F_Decls";
      Member_Desc_For_Generic_Formal_Part_F_Decls : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Formal_Part_F_Decls'Access,
         Owner         => Type_Index_For_Generic_Formal_Part,
         Member_Type   => Type_Index_For_Ada_Node_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Record_Def_F_Components : aliased constant Text_Type :=
        "F_Components";
      Member_Desc_For_Base_Record_Def_F_Components : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Record_Def_F_Components'Access,
         Owner         => Type_Index_For_Base_Record_Def,
         Member_Type   => Type_Index_For_Component_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Aggregate_Assoc_F_Designators : aliased constant Text_Type :=
        "F_Designators";
      Member_Desc_For_Aggregate_Assoc_F_Designators : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Aggregate_Assoc_F_Designators'Access,
         Owner         => Type_Index_For_Aggregate_Assoc,
         Member_Type   => Type_Index_For_Alternatives_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Aggregate_Assoc_F_R_Expr : aliased constant Text_Type :=
        "F_R_Expr";
      Member_Desc_For_Aggregate_Assoc_F_R_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Aggregate_Assoc_F_R_Expr'Access,
         Owner         => Type_Index_For_Aggregate_Assoc,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Composite_Constraint_Assoc_F_Ids : aliased constant Text_Type :=
        "F_Ids";
      Member_Desc_For_Composite_Constraint_Assoc_F_Ids : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Composite_Constraint_Assoc_F_Ids'Access,
         Owner         => Type_Index_For_Composite_Constraint_Assoc,
         Member_Type   => Type_Index_For_Discriminant_Choice_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Composite_Constraint_Assoc_F_Constraint_Expr : aliased constant Text_Type :=
        "F_Constraint_Expr";
      Member_Desc_For_Composite_Constraint_Assoc_F_Constraint_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Composite_Constraint_Assoc_F_Constraint_Expr'Access,
         Owner         => Type_Index_For_Composite_Constraint_Assoc,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Iterated_Assoc_F_Spec : aliased constant Text_Type :=
        "F_Spec";
      Member_Desc_For_Iterated_Assoc_F_Spec : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Iterated_Assoc_F_Spec'Access,
         Owner         => Type_Index_For_Iterated_Assoc,
         Member_Type   => Type_Index_For_For_Loop_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Iterated_Assoc_F_R_Expr : aliased constant Text_Type :=
        "F_R_Expr";
      Member_Desc_For_Iterated_Assoc_F_R_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Iterated_Assoc_F_R_Expr'Access,
         Owner         => Type_Index_For_Iterated_Assoc,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Param_Assoc_F_Designator : aliased constant Text_Type :=
        "F_Designator";
      Member_Desc_For_Param_Assoc_F_Designator : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Param_Assoc_F_Designator'Access,
         Owner         => Type_Index_For_Param_Assoc,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Param_Assoc_F_R_Expr : aliased constant Text_Type :=
        "F_R_Expr";
      Member_Desc_For_Param_Assoc_F_R_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Param_Assoc_F_R_Expr'Access,
         Owner         => Type_Index_For_Param_Assoc,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Basic_Decl_F_Aspects : aliased constant Text_Type :=
        "F_Aspects";
      Member_Desc_For_Basic_Decl_F_Aspects : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_F_Aspects'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Aspect_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Abstract_State_Decl_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Abstract_State_Decl_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Abstract_State_Decl_F_Name'Access,
         Owner         => Type_Index_For_Abstract_State_Decl,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Anonymous_Expr_Decl_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Anonymous_Expr_Decl_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Anonymous_Expr_Decl_F_Expr'Access,
         Owner         => Type_Index_For_Anonymous_Expr_Decl,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Component_Decl_F_Ids : aliased constant Text_Type :=
        "F_Ids";
      Member_Desc_For_Component_Decl_F_Ids : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Component_Decl_F_Ids'Access,
         Owner         => Type_Index_For_Component_Decl,
         Member_Type   => Type_Index_For_Defining_Name_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Component_Decl_F_Component_Def : aliased constant Text_Type :=
        "F_Component_Def";
      Member_Desc_For_Component_Decl_F_Component_Def : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Component_Decl_F_Component_Def'Access,
         Owner         => Type_Index_For_Component_Decl,
         Member_Type   => Type_Index_For_Component_Def,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Component_Decl_F_Default_Expr : aliased constant Text_Type :=
        "F_Default_Expr";
      Member_Desc_For_Component_Decl_F_Default_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Component_Decl_F_Default_Expr'Access,
         Owner         => Type_Index_For_Component_Decl,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Discriminant_Spec_F_Ids : aliased constant Text_Type :=
        "F_Ids";
      Member_Desc_For_Discriminant_Spec_F_Ids : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Discriminant_Spec_F_Ids'Access,
         Owner         => Type_Index_For_Discriminant_Spec,
         Member_Type   => Type_Index_For_Defining_Name_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Discriminant_Spec_F_Type_Expr : aliased constant Text_Type :=
        "F_Type_Expr";
      Member_Desc_For_Discriminant_Spec_F_Type_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Discriminant_Spec_F_Type_Expr'Access,
         Owner         => Type_Index_For_Discriminant_Spec,
         Member_Type   => Type_Index_For_Type_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Discriminant_Spec_F_Default_Expr : aliased constant Text_Type :=
        "F_Default_Expr";
      Member_Desc_For_Discriminant_Spec_F_Default_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Discriminant_Spec_F_Default_Expr'Access,
         Owner         => Type_Index_For_Discriminant_Spec,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Formal_F_Decl : aliased constant Text_Type :=
        "F_Decl";
      Member_Desc_For_Generic_Formal_F_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Formal_F_Decl'Access,
         Owner         => Type_Index_For_Generic_Formal,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Param_Spec_F_Ids : aliased constant Text_Type :=
        "F_Ids";
      Member_Desc_For_Param_Spec_F_Ids : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Param_Spec_F_Ids'Access,
         Owner         => Type_Index_For_Param_Spec,
         Member_Type   => Type_Index_For_Defining_Name_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Param_Spec_F_Has_Aliased : aliased constant Text_Type :=
        "F_Has_Aliased";
      Member_Desc_For_Param_Spec_F_Has_Aliased : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Param_Spec_F_Has_Aliased'Access,
         Owner         => Type_Index_For_Param_Spec,
         Member_Type   => Type_Index_For_Aliased,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Param_Spec_F_Mode : aliased constant Text_Type :=
        "F_Mode";
      Member_Desc_For_Param_Spec_F_Mode : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Param_Spec_F_Mode'Access,
         Owner         => Type_Index_For_Param_Spec,
         Member_Type   => Type_Index_For_Mode,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Param_Spec_F_Type_Expr : aliased constant Text_Type :=
        "F_Type_Expr";
      Member_Desc_For_Param_Spec_F_Type_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Param_Spec_F_Type_Expr'Access,
         Owner         => Type_Index_For_Param_Spec,
         Member_Type   => Type_Index_For_Type_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Param_Spec_F_Default_Expr : aliased constant Text_Type :=
        "F_Default_Expr";
      Member_Desc_For_Param_Spec_F_Default_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Param_Spec_F_Default_Expr'Access,
         Owner         => Type_Index_For_Param_Spec,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Synthetic_Formal_Param_Decl_F_Param_Type : aliased constant Text_Type :=
        "F_Param_Type";
      Member_Desc_For_Synthetic_Formal_Param_Decl_F_Param_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Synthetic_Formal_Param_Decl_F_Param_Type'Access,
         Owner         => Type_Index_For_Synthetic_Formal_Param_Decl,
         Member_Type   => Type_Index_For_Type_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Package_Decl_F_Package_Name : aliased constant Text_Type :=
        "F_Package_Name";
      Member_Desc_For_Base_Package_Decl_F_Package_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Package_Decl_F_Package_Name'Access,
         Owner         => Type_Index_For_Base_Package_Decl,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Package_Decl_F_Public_Part : aliased constant Text_Type :=
        "F_Public_Part";
      Member_Desc_For_Base_Package_Decl_F_Public_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Package_Decl_F_Public_Part'Access,
         Owner         => Type_Index_For_Base_Package_Decl,
         Member_Type   => Type_Index_For_Public_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Package_Decl_F_Private_Part : aliased constant Text_Type :=
        "F_Private_Part";
      Member_Desc_For_Base_Package_Decl_F_Private_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Package_Decl_F_Private_Part'Access,
         Owner         => Type_Index_For_Base_Package_Decl,
         Member_Type   => Type_Index_For_Private_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Package_Decl_F_End_Name : aliased constant Text_Type :=
        "F_End_Name";
      Member_Desc_For_Base_Package_Decl_F_End_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Package_Decl_F_End_Name'Access,
         Owner         => Type_Index_For_Base_Package_Decl,
         Member_Type   => Type_Index_For_End_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Type_Decl_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Base_Type_Decl_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Type_Decl_F_Name'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subtype_Decl_F_Subtype : aliased constant Text_Type :=
        "F_Subtype";
      Member_Desc_For_Subtype_Decl_F_Subtype : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subtype_Decl_F_Subtype'Access,
         Owner         => Type_Index_For_Subtype_Decl,
         Member_Type   => Type_Index_For_Subtype_Indication,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Incomplete_Type_Decl_F_Discriminants : aliased constant Text_Type :=
        "F_Discriminants";
      Member_Desc_For_Incomplete_Type_Decl_F_Discriminants : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Incomplete_Type_Decl_F_Discriminants'Access,
         Owner         => Type_Index_For_Incomplete_Type_Decl,
         Member_Type   => Type_Index_For_Discriminant_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Incomplete_Formal_Type_Decl_F_Is_Tagged : aliased constant Text_Type :=
        "F_Is_Tagged";
      Member_Desc_For_Incomplete_Formal_Type_Decl_F_Is_Tagged : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Incomplete_Formal_Type_Decl_F_Is_Tagged'Access,
         Owner         => Type_Index_For_Incomplete_Formal_Type_Decl,
         Member_Type   => Type_Index_For_Tagged,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Incomplete_Formal_Type_Decl_F_Default_Type : aliased constant Text_Type :=
        "F_Default_Type";
      Member_Desc_For_Incomplete_Formal_Type_Decl_F_Default_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Incomplete_Formal_Type_Decl_F_Default_Type'Access,
         Owner         => Type_Index_For_Incomplete_Formal_Type_Decl,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Incomplete_Tagged_Type_Decl_F_Has_Abstract : aliased constant Text_Type :=
        "F_Has_Abstract";
      Member_Desc_For_Incomplete_Tagged_Type_Decl_F_Has_Abstract : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Incomplete_Tagged_Type_Decl_F_Has_Abstract'Access,
         Owner         => Type_Index_For_Incomplete_Tagged_Type_Decl,
         Member_Type   => Type_Index_For_Abstract,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Protected_Type_Decl_F_Discriminants : aliased constant Text_Type :=
        "F_Discriminants";
      Member_Desc_For_Protected_Type_Decl_F_Discriminants : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Protected_Type_Decl_F_Discriminants'Access,
         Owner         => Type_Index_For_Protected_Type_Decl,
         Member_Type   => Type_Index_For_Discriminant_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Protected_Type_Decl_F_Interfaces : aliased constant Text_Type :=
        "F_Interfaces";
      Member_Desc_For_Protected_Type_Decl_F_Interfaces : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Protected_Type_Decl_F_Interfaces'Access,
         Owner         => Type_Index_For_Protected_Type_Decl,
         Member_Type   => Type_Index_For_Parent_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Protected_Type_Decl_F_Definition : aliased constant Text_Type :=
        "F_Definition";
      Member_Desc_For_Protected_Type_Decl_F_Definition : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Protected_Type_Decl_F_Definition'Access,
         Owner         => Type_Index_For_Protected_Type_Decl,
         Member_Type   => Type_Index_For_Protected_Def,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Task_Type_Decl_F_Discriminants : aliased constant Text_Type :=
        "F_Discriminants";
      Member_Desc_For_Task_Type_Decl_F_Discriminants : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Task_Type_Decl_F_Discriminants'Access,
         Owner         => Type_Index_For_Task_Type_Decl,
         Member_Type   => Type_Index_For_Discriminant_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Task_Type_Decl_F_Definition : aliased constant Text_Type :=
        "F_Definition";
      Member_Desc_For_Task_Type_Decl_F_Definition : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Task_Type_Decl_F_Definition'Access,
         Owner         => Type_Index_For_Task_Type_Decl,
         Member_Type   => Type_Index_For_Task_Def,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Type_Decl_F_Discriminants : aliased constant Text_Type :=
        "F_Discriminants";
      Member_Desc_For_Type_Decl_F_Discriminants : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Type_Decl_F_Discriminants'Access,
         Owner         => Type_Index_For_Type_Decl,
         Member_Type   => Type_Index_For_Discriminant_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Type_Decl_F_Type_Def : aliased constant Text_Type :=
        "F_Type_Def";
      Member_Desc_For_Type_Decl_F_Type_Def : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Type_Decl_F_Type_Def'Access,
         Owner         => Type_Index_For_Type_Decl,
         Member_Type   => Type_Index_For_Type_Def,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Formal_Type_Decl_F_Default_Type : aliased constant Text_Type :=
        "F_Default_Type";
      Member_Desc_For_Formal_Type_Decl_F_Default_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Formal_Type_Decl_F_Default_Type'Access,
         Owner         => Type_Index_For_Formal_Type_Decl,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Classic_Subp_Decl_F_Overriding : aliased constant Text_Type :=
        "F_Overriding";
      Member_Desc_For_Classic_Subp_Decl_F_Overriding : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Classic_Subp_Decl_F_Overriding'Access,
         Owner         => Type_Index_For_Classic_Subp_Decl,
         Member_Type   => Type_Index_For_Overriding,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Classic_Subp_Decl_F_Subp_Spec : aliased constant Text_Type :=
        "F_Subp_Spec";
      Member_Desc_For_Classic_Subp_Decl_F_Subp_Spec : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Classic_Subp_Decl_F_Subp_Spec'Access,
         Owner         => Type_Index_For_Classic_Subp_Decl,
         Member_Type   => Type_Index_For_Subp_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Formal_Subp_Decl_F_Default_Expr : aliased constant Text_Type :=
        "F_Default_Expr";
      Member_Desc_For_Formal_Subp_Decl_F_Default_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Formal_Subp_Decl_F_Default_Expr'Access,
         Owner         => Type_Index_For_Formal_Subp_Decl,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Decl_F_Overriding : aliased constant Text_Type :=
        "F_Overriding";
      Member_Desc_For_Entry_Decl_F_Overriding : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Decl_F_Overriding'Access,
         Owner         => Type_Index_For_Entry_Decl,
         Member_Type   => Type_Index_For_Overriding,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Decl_F_Spec : aliased constant Text_Type :=
        "F_Spec";
      Member_Desc_For_Entry_Decl_F_Spec : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Decl_F_Spec'Access,
         Owner         => Type_Index_For_Entry_Decl,
         Member_Type   => Type_Index_For_Entry_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Enum_Literal_Decl_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Enum_Literal_Decl_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Enum_Literal_Decl_F_Name'Access,
         Owner         => Type_Index_For_Enum_Literal_Decl,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Subp_Internal_F_Subp_Spec : aliased constant Text_Type :=
        "F_Subp_Spec";
      Member_Desc_For_Generic_Subp_Internal_F_Subp_Spec : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Subp_Internal_F_Subp_Spec'Access,
         Owner         => Type_Index_For_Generic_Subp_Internal,
         Member_Type   => Type_Index_For_Subp_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Synthetic_Subp_Decl_F_Spec : aliased constant Text_Type :=
        "F_Spec";
      Member_Desc_For_Synthetic_Subp_Decl_F_Spec : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Synthetic_Subp_Decl_F_Spec'Access,
         Owner         => Type_Index_For_Synthetic_Subp_Decl,
         Member_Type   => Type_Index_For_Base_Subp_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Subp_Body_F_Overriding : aliased constant Text_Type :=
        "F_Overriding";
      Member_Desc_For_Base_Subp_Body_F_Overriding : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Subp_Body_F_Overriding'Access,
         Owner         => Type_Index_For_Base_Subp_Body,
         Member_Type   => Type_Index_For_Overriding,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Subp_Body_F_Subp_Spec : aliased constant Text_Type :=
        "F_Subp_Spec";
      Member_Desc_For_Base_Subp_Body_F_Subp_Spec : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Subp_Body_F_Subp_Spec'Access,
         Owner         => Type_Index_For_Base_Subp_Body,
         Member_Type   => Type_Index_For_Subp_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Expr_Function_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Expr_Function_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Expr_Function_F_Expr'Access,
         Owner         => Type_Index_For_Expr_Function,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subp_Body_F_Decls : aliased constant Text_Type :=
        "F_Decls";
      Member_Desc_For_Subp_Body_F_Decls : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subp_Body_F_Decls'Access,
         Owner         => Type_Index_For_Subp_Body,
         Member_Type   => Type_Index_For_Declarative_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subp_Body_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Subp_Body_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subp_Body_F_Stmts'Access,
         Owner         => Type_Index_For_Subp_Body,
         Member_Type   => Type_Index_For_Handled_Stmts,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subp_Body_F_End_Name : aliased constant Text_Type :=
        "F_End_Name";
      Member_Desc_For_Subp_Body_F_End_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subp_Body_F_End_Name'Access,
         Owner         => Type_Index_For_Subp_Body,
         Member_Type   => Type_Index_For_End_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subp_Renaming_Decl_F_Renames : aliased constant Text_Type :=
        "F_Renames";
      Member_Desc_For_Subp_Renaming_Decl_F_Renames : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subp_Renaming_Decl_F_Renames'Access,
         Owner         => Type_Index_For_Subp_Renaming_Decl,
         Member_Type   => Type_Index_For_Renaming_Clause,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Package_Body_Stub_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Package_Body_Stub_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Package_Body_Stub_F_Name'Access,
         Owner         => Type_Index_For_Package_Body_Stub,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Protected_Body_Stub_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Protected_Body_Stub_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Protected_Body_Stub_F_Name'Access,
         Owner         => Type_Index_For_Protected_Body_Stub,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subp_Body_Stub_F_Overriding : aliased constant Text_Type :=
        "F_Overriding";
      Member_Desc_For_Subp_Body_Stub_F_Overriding : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subp_Body_Stub_F_Overriding'Access,
         Owner         => Type_Index_For_Subp_Body_Stub,
         Member_Type   => Type_Index_For_Overriding,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subp_Body_Stub_F_Subp_Spec : aliased constant Text_Type :=
        "F_Subp_Spec";
      Member_Desc_For_Subp_Body_Stub_F_Subp_Spec : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subp_Body_Stub_F_Subp_Spec'Access,
         Owner         => Type_Index_For_Subp_Body_Stub,
         Member_Type   => Type_Index_For_Subp_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Task_Body_Stub_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Task_Body_Stub_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Task_Body_Stub_F_Name'Access,
         Owner         => Type_Index_For_Task_Body_Stub,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Body_F_Entry_Name : aliased constant Text_Type :=
        "F_Entry_Name";
      Member_Desc_For_Entry_Body_F_Entry_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Body_F_Entry_Name'Access,
         Owner         => Type_Index_For_Entry_Body,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Body_F_Index_Spec : aliased constant Text_Type :=
        "F_Index_Spec";
      Member_Desc_For_Entry_Body_F_Index_Spec : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Body_F_Index_Spec'Access,
         Owner         => Type_Index_For_Entry_Body,
         Member_Type   => Type_Index_For_Entry_Index_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Body_F_Params : aliased constant Text_Type :=
        "F_Params";
      Member_Desc_For_Entry_Body_F_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Body_F_Params'Access,
         Owner         => Type_Index_For_Entry_Body,
         Member_Type   => Type_Index_For_Entry_Completion_Formal_Params,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Body_F_Barrier : aliased constant Text_Type :=
        "F_Barrier";
      Member_Desc_For_Entry_Body_F_Barrier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Body_F_Barrier'Access,
         Owner         => Type_Index_For_Entry_Body,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Body_F_Decls : aliased constant Text_Type :=
        "F_Decls";
      Member_Desc_For_Entry_Body_F_Decls : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Body_F_Decls'Access,
         Owner         => Type_Index_For_Entry_Body,
         Member_Type   => Type_Index_For_Declarative_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Body_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Entry_Body_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Body_F_Stmts'Access,
         Owner         => Type_Index_For_Entry_Body,
         Member_Type   => Type_Index_For_Handled_Stmts,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Body_F_End_Name : aliased constant Text_Type :=
        "F_End_Name";
      Member_Desc_For_Entry_Body_F_End_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Body_F_End_Name'Access,
         Owner         => Type_Index_For_Entry_Body,
         Member_Type   => Type_Index_For_End_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Package_Body_F_Package_Name : aliased constant Text_Type :=
        "F_Package_Name";
      Member_Desc_For_Package_Body_F_Package_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Package_Body_F_Package_Name'Access,
         Owner         => Type_Index_For_Package_Body,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Package_Body_F_Decls : aliased constant Text_Type :=
        "F_Decls";
      Member_Desc_For_Package_Body_F_Decls : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Package_Body_F_Decls'Access,
         Owner         => Type_Index_For_Package_Body,
         Member_Type   => Type_Index_For_Declarative_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Package_Body_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Package_Body_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Package_Body_F_Stmts'Access,
         Owner         => Type_Index_For_Package_Body,
         Member_Type   => Type_Index_For_Handled_Stmts,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Package_Body_F_End_Name : aliased constant Text_Type :=
        "F_End_Name";
      Member_Desc_For_Package_Body_F_End_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Package_Body_F_End_Name'Access,
         Owner         => Type_Index_For_Package_Body,
         Member_Type   => Type_Index_For_End_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Protected_Body_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Protected_Body_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Protected_Body_F_Name'Access,
         Owner         => Type_Index_For_Protected_Body,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Protected_Body_F_Decls : aliased constant Text_Type :=
        "F_Decls";
      Member_Desc_For_Protected_Body_F_Decls : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Protected_Body_F_Decls'Access,
         Owner         => Type_Index_For_Protected_Body,
         Member_Type   => Type_Index_For_Declarative_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Protected_Body_F_End_Name : aliased constant Text_Type :=
        "F_End_Name";
      Member_Desc_For_Protected_Body_F_End_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Protected_Body_F_End_Name'Access,
         Owner         => Type_Index_For_Protected_Body,
         Member_Type   => Type_Index_For_End_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Task_Body_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Task_Body_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Task_Body_F_Name'Access,
         Owner         => Type_Index_For_Task_Body,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Task_Body_F_Decls : aliased constant Text_Type :=
        "F_Decls";
      Member_Desc_For_Task_Body_F_Decls : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Task_Body_F_Decls'Access,
         Owner         => Type_Index_For_Task_Body,
         Member_Type   => Type_Index_For_Declarative_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Task_Body_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Task_Body_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Task_Body_F_Stmts'Access,
         Owner         => Type_Index_For_Task_Body,
         Member_Type   => Type_Index_For_Handled_Stmts,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Task_Body_F_End_Name : aliased constant Text_Type :=
        "F_End_Name";
      Member_Desc_For_Task_Body_F_End_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Task_Body_F_End_Name'Access,
         Owner         => Type_Index_For_Task_Body,
         Member_Type   => Type_Index_For_End_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Index_Spec_F_Id : aliased constant Text_Type :=
        "F_Id";
      Member_Desc_For_Entry_Index_Spec_F_Id : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Index_Spec_F_Id'Access,
         Owner         => Type_Index_For_Entry_Index_Spec,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Entry_Index_Spec_F_Subtype : aliased constant Text_Type :=
        "F_Subtype";
      Member_Desc_For_Entry_Index_Spec_F_Subtype : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Index_Spec_F_Subtype'Access,
         Owner         => Type_Index_For_Entry_Index_Spec,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Exception_Decl_F_Ids : aliased constant Text_Type :=
        "F_Ids";
      Member_Desc_For_Exception_Decl_F_Ids : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Exception_Decl_F_Ids'Access,
         Owner         => Type_Index_For_Exception_Decl,
         Member_Type   => Type_Index_For_Defining_Name_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Exception_Decl_F_Renames : aliased constant Text_Type :=
        "F_Renames";
      Member_Desc_For_Exception_Decl_F_Renames : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Exception_Decl_F_Renames'Access,
         Owner         => Type_Index_For_Exception_Decl,
         Member_Type   => Type_Index_For_Renaming_Clause,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Exception_Handler_F_Exception_Name : aliased constant Text_Type :=
        "F_Exception_Name";
      Member_Desc_For_Exception_Handler_F_Exception_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Exception_Handler_F_Exception_Name'Access,
         Owner         => Type_Index_For_Exception_Handler,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Exception_Handler_F_Handled_Exceptions : aliased constant Text_Type :=
        "F_Handled_Exceptions";
      Member_Desc_For_Exception_Handler_F_Handled_Exceptions : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Exception_Handler_F_Handled_Exceptions'Access,
         Owner         => Type_Index_For_Exception_Handler,
         Member_Type   => Type_Index_For_Alternatives_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Exception_Handler_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Exception_Handler_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Exception_Handler_F_Stmts'Access,
         Owner         => Type_Index_For_Exception_Handler,
         Member_Type   => Type_Index_For_Stmt_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_For_Loop_Var_Decl_F_Id : aliased constant Text_Type :=
        "F_Id";
      Member_Desc_For_For_Loop_Var_Decl_F_Id : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_For_Loop_Var_Decl_F_Id'Access,
         Owner         => Type_Index_For_For_Loop_Var_Decl,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_For_Loop_Var_Decl_F_Id_Type : aliased constant Text_Type :=
        "F_Id_Type";
      Member_Desc_For_For_Loop_Var_Decl_F_Id_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_For_Loop_Var_Decl_F_Id_Type'Access,
         Owner         => Type_Index_For_For_Loop_Var_Decl,
         Member_Type   => Type_Index_For_Type_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Decl_F_Formal_Part : aliased constant Text_Type :=
        "F_Formal_Part";
      Member_Desc_For_Generic_Decl_F_Formal_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Decl_F_Formal_Part'Access,
         Owner         => Type_Index_For_Generic_Decl,
         Member_Type   => Type_Index_For_Generic_Formal_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Package_Decl_F_Package_Decl : aliased constant Text_Type :=
        "F_Package_Decl";
      Member_Desc_For_Generic_Package_Decl_F_Package_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Package_Decl_F_Package_Decl'Access,
         Owner         => Type_Index_For_Generic_Package_Decl,
         Member_Type   => Type_Index_For_Generic_Package_Internal,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Subp_Decl_F_Subp_Decl : aliased constant Text_Type :=
        "F_Subp_Decl";
      Member_Desc_For_Generic_Subp_Decl_F_Subp_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Subp_Decl_F_Subp_Decl'Access,
         Owner         => Type_Index_For_Generic_Subp_Decl,
         Member_Type   => Type_Index_For_Generic_Subp_Internal,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Package_Instantiation_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Generic_Package_Instantiation_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Package_Instantiation_F_Name'Access,
         Owner         => Type_Index_For_Generic_Package_Instantiation,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Package_Instantiation_F_Generic_Pkg_Name : aliased constant Text_Type :=
        "F_Generic_Pkg_Name";
      Member_Desc_For_Generic_Package_Instantiation_F_Generic_Pkg_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Package_Instantiation_F_Generic_Pkg_Name'Access,
         Owner         => Type_Index_For_Generic_Package_Instantiation,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Package_Instantiation_F_Params : aliased constant Text_Type :=
        "F_Params";
      Member_Desc_For_Generic_Package_Instantiation_F_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Package_Instantiation_F_Params'Access,
         Owner         => Type_Index_For_Generic_Package_Instantiation,
         Member_Type   => Type_Index_For_Assoc_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Subp_Instantiation_F_Overriding : aliased constant Text_Type :=
        "F_Overriding";
      Member_Desc_For_Generic_Subp_Instantiation_F_Overriding : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Subp_Instantiation_F_Overriding'Access,
         Owner         => Type_Index_For_Generic_Subp_Instantiation,
         Member_Type   => Type_Index_For_Overriding,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Subp_Instantiation_F_Kind : aliased constant Text_Type :=
        "F_Kind";
      Member_Desc_For_Generic_Subp_Instantiation_F_Kind : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Subp_Instantiation_F_Kind'Access,
         Owner         => Type_Index_For_Generic_Subp_Instantiation,
         Member_Type   => Type_Index_For_Subp_Kind,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Subp_Instantiation_F_Subp_Name : aliased constant Text_Type :=
        "F_Subp_Name";
      Member_Desc_For_Generic_Subp_Instantiation_F_Subp_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Subp_Instantiation_F_Subp_Name'Access,
         Owner         => Type_Index_For_Generic_Subp_Instantiation,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Subp_Instantiation_F_Generic_Subp_Name : aliased constant Text_Type :=
        "F_Generic_Subp_Name";
      Member_Desc_For_Generic_Subp_Instantiation_F_Generic_Subp_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Subp_Instantiation_F_Generic_Subp_Name'Access,
         Owner         => Type_Index_For_Generic_Subp_Instantiation,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Subp_Instantiation_F_Params : aliased constant Text_Type :=
        "F_Params";
      Member_Desc_For_Generic_Subp_Instantiation_F_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Subp_Instantiation_F_Params'Access,
         Owner         => Type_Index_For_Generic_Subp_Instantiation,
         Member_Type   => Type_Index_For_Assoc_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Package_Renaming_Decl_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Generic_Package_Renaming_Decl_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Package_Renaming_Decl_F_Name'Access,
         Owner         => Type_Index_For_Generic_Package_Renaming_Decl,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Package_Renaming_Decl_F_Renames : aliased constant Text_Type :=
        "F_Renames";
      Member_Desc_For_Generic_Package_Renaming_Decl_F_Renames : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Package_Renaming_Decl_F_Renames'Access,
         Owner         => Type_Index_For_Generic_Package_Renaming_Decl,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Subp_Renaming_Decl_F_Kind : aliased constant Text_Type :=
        "F_Kind";
      Member_Desc_For_Generic_Subp_Renaming_Decl_F_Kind : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Subp_Renaming_Decl_F_Kind'Access,
         Owner         => Type_Index_For_Generic_Subp_Renaming_Decl,
         Member_Type   => Type_Index_For_Subp_Kind,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Subp_Renaming_Decl_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Generic_Subp_Renaming_Decl_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Subp_Renaming_Decl_F_Name'Access,
         Owner         => Type_Index_For_Generic_Subp_Renaming_Decl,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Subp_Renaming_Decl_F_Renames : aliased constant Text_Type :=
        "F_Renames";
      Member_Desc_For_Generic_Subp_Renaming_Decl_F_Renames : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Subp_Renaming_Decl_F_Renames'Access,
         Owner         => Type_Index_For_Generic_Subp_Renaming_Decl,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Label_Decl_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Label_Decl_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Label_Decl_F_Name'Access,
         Owner         => Type_Index_For_Label_Decl,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Named_Stmt_Decl_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Named_Stmt_Decl_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Named_Stmt_Decl_F_Name'Access,
         Owner         => Type_Index_For_Named_Stmt_Decl,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Number_Decl_F_Ids : aliased constant Text_Type :=
        "F_Ids";
      Member_Desc_For_Number_Decl_F_Ids : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Number_Decl_F_Ids'Access,
         Owner         => Type_Index_For_Number_Decl,
         Member_Type   => Type_Index_For_Defining_Name_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Number_Decl_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Number_Decl_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Number_Decl_F_Expr'Access,
         Owner         => Type_Index_For_Number_Decl,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Object_Decl_F_Ids : aliased constant Text_Type :=
        "F_Ids";
      Member_Desc_For_Object_Decl_F_Ids : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Object_Decl_F_Ids'Access,
         Owner         => Type_Index_For_Object_Decl,
         Member_Type   => Type_Index_For_Defining_Name_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Object_Decl_F_Has_Aliased : aliased constant Text_Type :=
        "F_Has_Aliased";
      Member_Desc_For_Object_Decl_F_Has_Aliased : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Object_Decl_F_Has_Aliased'Access,
         Owner         => Type_Index_For_Object_Decl,
         Member_Type   => Type_Index_For_Aliased,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Object_Decl_F_Has_Constant : aliased constant Text_Type :=
        "F_Has_Constant";
      Member_Desc_For_Object_Decl_F_Has_Constant : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Object_Decl_F_Has_Constant'Access,
         Owner         => Type_Index_For_Object_Decl,
         Member_Type   => Type_Index_For_Constant,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Object_Decl_F_Mode : aliased constant Text_Type :=
        "F_Mode";
      Member_Desc_For_Object_Decl_F_Mode : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Object_Decl_F_Mode'Access,
         Owner         => Type_Index_For_Object_Decl,
         Member_Type   => Type_Index_For_Mode,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Object_Decl_F_Type_Expr : aliased constant Text_Type :=
        "F_Type_Expr";
      Member_Desc_For_Object_Decl_F_Type_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Object_Decl_F_Type_Expr'Access,
         Owner         => Type_Index_For_Object_Decl,
         Member_Type   => Type_Index_For_Type_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Object_Decl_F_Default_Expr : aliased constant Text_Type :=
        "F_Default_Expr";
      Member_Desc_For_Object_Decl_F_Default_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Object_Decl_F_Default_Expr'Access,
         Owner         => Type_Index_For_Object_Decl,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Object_Decl_F_Renaming_Clause : aliased constant Text_Type :=
        "F_Renaming_Clause";
      Member_Desc_For_Object_Decl_F_Renaming_Clause : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Object_Decl_F_Renaming_Clause'Access,
         Owner         => Type_Index_For_Object_Decl,
         Member_Type   => Type_Index_For_Renaming_Clause,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Package_Renaming_Decl_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Package_Renaming_Decl_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Package_Renaming_Decl_F_Name'Access,
         Owner         => Type_Index_For_Package_Renaming_Decl,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Package_Renaming_Decl_F_Renames : aliased constant Text_Type :=
        "F_Renames";
      Member_Desc_For_Package_Renaming_Decl_F_Renames : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Package_Renaming_Decl_F_Renames'Access,
         Owner         => Type_Index_For_Package_Renaming_Decl,
         Member_Type   => Type_Index_For_Renaming_Clause,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Single_Protected_Decl_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Single_Protected_Decl_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Single_Protected_Decl_F_Name'Access,
         Owner         => Type_Index_For_Single_Protected_Decl,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Single_Protected_Decl_F_Interfaces : aliased constant Text_Type :=
        "F_Interfaces";
      Member_Desc_For_Single_Protected_Decl_F_Interfaces : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Single_Protected_Decl_F_Interfaces'Access,
         Owner         => Type_Index_For_Single_Protected_Decl,
         Member_Type   => Type_Index_For_Parent_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Single_Protected_Decl_F_Definition : aliased constant Text_Type :=
        "F_Definition";
      Member_Desc_For_Single_Protected_Decl_F_Definition : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Single_Protected_Decl_F_Definition'Access,
         Owner         => Type_Index_For_Single_Protected_Decl,
         Member_Type   => Type_Index_For_Protected_Def,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Single_Task_Decl_F_Task_Type : aliased constant Text_Type :=
        "F_Task_Type";
      Member_Desc_For_Single_Task_Decl_F_Task_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Single_Task_Decl_F_Task_Type'Access,
         Owner         => Type_Index_For_Single_Task_Decl,
         Member_Type   => Type_Index_For_Single_Task_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Case_Stmt_Alternative_F_Choices : aliased constant Text_Type :=
        "F_Choices";
      Member_Desc_For_Case_Stmt_Alternative_F_Choices : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Case_Stmt_Alternative_F_Choices'Access,
         Owner         => Type_Index_For_Case_Stmt_Alternative,
         Member_Type   => Type_Index_For_Alternatives_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Case_Stmt_Alternative_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Case_Stmt_Alternative_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Case_Stmt_Alternative_F_Stmts'Access,
         Owner         => Type_Index_For_Case_Stmt_Alternative,
         Member_Type   => Type_Index_For_Stmt_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Compilation_Unit_F_Prelude : aliased constant Text_Type :=
        "F_Prelude";
      Member_Desc_For_Compilation_Unit_F_Prelude : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Compilation_Unit_F_Prelude'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Ada_Node_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Compilation_Unit_F_Body : aliased constant Text_Type :=
        "F_Body";
      Member_Desc_For_Compilation_Unit_F_Body : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Compilation_Unit_F_Body'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Compilation_Unit_F_Pragmas : aliased constant Text_Type :=
        "F_Pragmas";
      Member_Desc_For_Compilation_Unit_F_Pragmas : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Compilation_Unit_F_Pragmas'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Pragma_Node_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Component_Clause_F_Id : aliased constant Text_Type :=
        "F_Id";
      Member_Desc_For_Component_Clause_F_Id : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Component_Clause_F_Id'Access,
         Owner         => Type_Index_For_Component_Clause,
         Member_Type   => Type_Index_For_Identifier,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Component_Clause_F_Position : aliased constant Text_Type :=
        "F_Position";
      Member_Desc_For_Component_Clause_F_Position : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Component_Clause_F_Position'Access,
         Owner         => Type_Index_For_Component_Clause,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Component_Clause_F_Range : aliased constant Text_Type :=
        "F_Range";
      Member_Desc_For_Component_Clause_F_Range : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Component_Clause_F_Range'Access,
         Owner         => Type_Index_For_Component_Clause,
         Member_Type   => Type_Index_For_Range_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Component_Def_F_Has_Aliased : aliased constant Text_Type :=
        "F_Has_Aliased";
      Member_Desc_For_Component_Def_F_Has_Aliased : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Component_Def_F_Has_Aliased'Access,
         Owner         => Type_Index_For_Component_Def,
         Member_Type   => Type_Index_For_Aliased,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Component_Def_F_Has_Constant : aliased constant Text_Type :=
        "F_Has_Constant";
      Member_Desc_For_Component_Def_F_Has_Constant : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Component_Def_F_Has_Constant'Access,
         Owner         => Type_Index_For_Component_Def,
         Member_Type   => Type_Index_For_Constant,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Component_Def_F_Type_Expr : aliased constant Text_Type :=
        "F_Type_Expr";
      Member_Desc_For_Component_Def_F_Type_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Component_Def_F_Type_Expr'Access,
         Owner         => Type_Index_For_Component_Def,
         Member_Type   => Type_Index_For_Type_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Composite_Constraint_F_Constraints : aliased constant Text_Type :=
        "F_Constraints";
      Member_Desc_For_Composite_Constraint_F_Constraints : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Composite_Constraint_F_Constraints'Access,
         Owner         => Type_Index_For_Composite_Constraint,
         Member_Type   => Type_Index_For_Assoc_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Delta_Constraint_F_Digits : aliased constant Text_Type :=
        "F_Digits";
      Member_Desc_For_Delta_Constraint_F_Digits : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Delta_Constraint_F_Digits'Access,
         Owner         => Type_Index_For_Delta_Constraint,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Delta_Constraint_F_Range : aliased constant Text_Type :=
        "F_Range";
      Member_Desc_For_Delta_Constraint_F_Range : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Delta_Constraint_F_Range'Access,
         Owner         => Type_Index_For_Delta_Constraint,
         Member_Type   => Type_Index_For_Range_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Digits_Constraint_F_Digits : aliased constant Text_Type :=
        "F_Digits";
      Member_Desc_For_Digits_Constraint_F_Digits : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Digits_Constraint_F_Digits'Access,
         Owner         => Type_Index_For_Digits_Constraint,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Digits_Constraint_F_Range : aliased constant Text_Type :=
        "F_Range";
      Member_Desc_For_Digits_Constraint_F_Range : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Digits_Constraint_F_Range'Access,
         Owner         => Type_Index_For_Digits_Constraint,
         Member_Type   => Type_Index_For_Range_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Range_Constraint_F_Range : aliased constant Text_Type :=
        "F_Range";
      Member_Desc_For_Range_Constraint_F_Range : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Range_Constraint_F_Range'Access,
         Owner         => Type_Index_For_Range_Constraint,
         Member_Type   => Type_Index_For_Range_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Declarative_Part_F_Decls : aliased constant Text_Type :=
        "F_Decls";
      Member_Desc_For_Declarative_Part_F_Decls : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Declarative_Part_F_Decls'Access,
         Owner         => Type_Index_For_Declarative_Part,
         Member_Type   => Type_Index_For_Ada_Node_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Elsif_Expr_Part_F_Cond_Expr : aliased constant Text_Type :=
        "F_Cond_Expr";
      Member_Desc_For_Elsif_Expr_Part_F_Cond_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Elsif_Expr_Part_F_Cond_Expr'Access,
         Owner         => Type_Index_For_Elsif_Expr_Part,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Elsif_Expr_Part_F_Then_Expr : aliased constant Text_Type :=
        "F_Then_Expr";
      Member_Desc_For_Elsif_Expr_Part_F_Then_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Elsif_Expr_Part_F_Then_Expr'Access,
         Owner         => Type_Index_For_Elsif_Expr_Part,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Elsif_Stmt_Part_F_Cond_Expr : aliased constant Text_Type :=
        "F_Cond_Expr";
      Member_Desc_For_Elsif_Stmt_Part_F_Cond_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Elsif_Stmt_Part_F_Cond_Expr'Access,
         Owner         => Type_Index_For_Elsif_Stmt_Part,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Elsif_Stmt_Part_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Elsif_Stmt_Part_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Elsif_Stmt_Part_F_Stmts'Access,
         Owner         => Type_Index_For_Elsif_Stmt_Part,
         Member_Type   => Type_Index_For_Stmt_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Abstract_State_Decl_Expr_F_State_Decl : aliased constant Text_Type :=
        "F_State_Decl";
      Member_Desc_For_Abstract_State_Decl_Expr_F_State_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Abstract_State_Decl_Expr_F_State_Decl'Access,
         Owner         => Type_Index_For_Abstract_State_Decl_Expr,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Allocator_F_Subpool : aliased constant Text_Type :=
        "F_Subpool";
      Member_Desc_For_Allocator_F_Subpool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Allocator_F_Subpool'Access,
         Owner         => Type_Index_For_Allocator,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Allocator_F_Type_Or_Expr : aliased constant Text_Type :=
        "F_Type_Or_Expr";
      Member_Desc_For_Allocator_F_Type_Or_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Allocator_F_Type_Or_Expr'Access,
         Owner         => Type_Index_For_Allocator,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Aggregate_F_Ancestor_Expr : aliased constant Text_Type :=
        "F_Ancestor_Expr";
      Member_Desc_For_Base_Aggregate_F_Ancestor_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Aggregate_F_Ancestor_Expr'Access,
         Owner         => Type_Index_For_Base_Aggregate,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Aggregate_F_Assocs : aliased constant Text_Type :=
        "F_Assocs";
      Member_Desc_For_Base_Aggregate_F_Assocs : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Aggregate_F_Assocs'Access,
         Owner         => Type_Index_For_Base_Aggregate,
         Member_Type   => Type_Index_For_Assoc_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Bin_Op_F_Left : aliased constant Text_Type :=
        "F_Left";
      Member_Desc_For_Bin_Op_F_Left : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Bin_Op_F_Left'Access,
         Owner         => Type_Index_For_Bin_Op,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Bin_Op_F_Op : aliased constant Text_Type :=
        "F_Op";
      Member_Desc_For_Bin_Op_F_Op : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Bin_Op_F_Op'Access,
         Owner         => Type_Index_For_Bin_Op,
         Member_Type   => Type_Index_For_Op,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Bin_Op_F_Right : aliased constant Text_Type :=
        "F_Right";
      Member_Desc_For_Bin_Op_F_Right : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Bin_Op_F_Right'Access,
         Owner         => Type_Index_For_Bin_Op,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Case_Expr_Alternative_F_Choices : aliased constant Text_Type :=
        "F_Choices";
      Member_Desc_For_Case_Expr_Alternative_F_Choices : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Case_Expr_Alternative_F_Choices'Access,
         Owner         => Type_Index_For_Case_Expr_Alternative,
         Member_Type   => Type_Index_For_Alternatives_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Case_Expr_Alternative_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Case_Expr_Alternative_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Case_Expr_Alternative_F_Expr'Access,
         Owner         => Type_Index_For_Case_Expr_Alternative,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Concat_Op_F_First_Operand : aliased constant Text_Type :=
        "F_First_Operand";
      Member_Desc_For_Concat_Op_F_First_Operand : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Concat_Op_F_First_Operand'Access,
         Owner         => Type_Index_For_Concat_Op,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Concat_Op_F_Other_Operands : aliased constant Text_Type :=
        "F_Other_Operands";
      Member_Desc_For_Concat_Op_F_Other_Operands : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Concat_Op_F_Other_Operands'Access,
         Owner         => Type_Index_For_Concat_Op,
         Member_Type   => Type_Index_For_Concat_Operand_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Concat_Operand_F_Operator : aliased constant Text_Type :=
        "F_Operator";
      Member_Desc_For_Concat_Operand_F_Operator : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Concat_Operand_F_Operator'Access,
         Owner         => Type_Index_For_Concat_Operand,
         Member_Type   => Type_Index_For_Op_Concat,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Concat_Operand_F_Operand : aliased constant Text_Type :=
        "F_Operand";
      Member_Desc_For_Concat_Operand_F_Operand : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Concat_Operand_F_Operand'Access,
         Owner         => Type_Index_For_Concat_Operand,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Case_Expr_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Case_Expr_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Case_Expr_F_Expr'Access,
         Owner         => Type_Index_For_Case_Expr,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Case_Expr_F_Cases : aliased constant Text_Type :=
        "F_Cases";
      Member_Desc_For_Case_Expr_F_Cases : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Case_Expr_F_Cases'Access,
         Owner         => Type_Index_For_Case_Expr,
         Member_Type   => Type_Index_For_Case_Expr_Alternative_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_If_Expr_F_Cond_Expr : aliased constant Text_Type :=
        "F_Cond_Expr";
      Member_Desc_For_If_Expr_F_Cond_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_If_Expr_F_Cond_Expr'Access,
         Owner         => Type_Index_For_If_Expr,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_If_Expr_F_Then_Expr : aliased constant Text_Type :=
        "F_Then_Expr";
      Member_Desc_For_If_Expr_F_Then_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_If_Expr_F_Then_Expr'Access,
         Owner         => Type_Index_For_If_Expr,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_If_Expr_F_Alternatives : aliased constant Text_Type :=
        "F_Alternatives";
      Member_Desc_For_If_Expr_F_Alternatives : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_If_Expr_F_Alternatives'Access,
         Owner         => Type_Index_For_If_Expr,
         Member_Type   => Type_Index_For_Elsif_Expr_Part_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_If_Expr_F_Else_Expr : aliased constant Text_Type :=
        "F_Else_Expr";
      Member_Desc_For_If_Expr_F_Else_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_If_Expr_F_Else_Expr'Access,
         Owner         => Type_Index_For_If_Expr,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Contract_Cases_F_Contract_Cases : aliased constant Text_Type :=
        "F_Contract_Cases";
      Member_Desc_For_Contract_Cases_F_Contract_Cases : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Contract_Cases_F_Contract_Cases'Access,
         Owner         => Type_Index_For_Contract_Cases,
         Member_Type   => Type_Index_For_Contract_Case_Assoc_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Decl_Expr_F_Decls : aliased constant Text_Type :=
        "F_Decls";
      Member_Desc_For_Decl_Expr_F_Decls : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Decl_Expr_F_Decls'Access,
         Owner         => Type_Index_For_Decl_Expr,
         Member_Type   => Type_Index_For_Basic_Decl_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Decl_Expr_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Decl_Expr_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Decl_Expr_F_Expr'Access,
         Owner         => Type_Index_For_Decl_Expr,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Membership_Expr_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Membership_Expr_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Membership_Expr_F_Expr'Access,
         Owner         => Type_Index_For_Membership_Expr,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Membership_Expr_F_Op : aliased constant Text_Type :=
        "F_Op";
      Member_Desc_For_Membership_Expr_F_Op : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Membership_Expr_F_Op'Access,
         Owner         => Type_Index_For_Membership_Expr,
         Member_Type   => Type_Index_For_Op,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Membership_Expr_F_Membership_Exprs : aliased constant Text_Type :=
        "F_Membership_Exprs";
      Member_Desc_For_Membership_Expr_F_Membership_Exprs : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Membership_Expr_F_Membership_Exprs'Access,
         Owner         => Type_Index_For_Membership_Expr,
         Member_Type   => Type_Index_For_Expr_Alternatives_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Attribute_Ref_F_Prefix : aliased constant Text_Type :=
        "F_Prefix";
      Member_Desc_For_Attribute_Ref_F_Prefix : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Attribute_Ref_F_Prefix'Access,
         Owner         => Type_Index_For_Attribute_Ref,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Attribute_Ref_F_Attribute : aliased constant Text_Type :=
        "F_Attribute";
      Member_Desc_For_Attribute_Ref_F_Attribute : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Attribute_Ref_F_Attribute'Access,
         Owner         => Type_Index_For_Attribute_Ref,
         Member_Type   => Type_Index_For_Identifier,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Attribute_Ref_F_Args : aliased constant Text_Type :=
        "F_Args";
      Member_Desc_For_Attribute_Ref_F_Args : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Attribute_Ref_F_Args'Access,
         Owner         => Type_Index_For_Attribute_Ref,
         Member_Type   => Type_Index_For_Assoc_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Call_Expr_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Call_Expr_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Call_Expr_F_Name'Access,
         Owner         => Type_Index_For_Call_Expr,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Call_Expr_F_Suffix : aliased constant Text_Type :=
        "F_Suffix";
      Member_Desc_For_Call_Expr_F_Suffix : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Call_Expr_F_Suffix'Access,
         Owner         => Type_Index_For_Call_Expr,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Defining_Name_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Defining_Name_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Defining_Name_F_Name'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Discrete_Subtype_Name_F_Subtype : aliased constant Text_Type :=
        "F_Subtype";
      Member_Desc_For_Discrete_Subtype_Name_F_Subtype : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Discrete_Subtype_Name_F_Subtype'Access,
         Owner         => Type_Index_For_Discrete_Subtype_Name,
         Member_Type   => Type_Index_For_Discrete_Subtype_Indication,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Dotted_Name_F_Prefix : aliased constant Text_Type :=
        "F_Prefix";
      Member_Desc_For_Dotted_Name_F_Prefix : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Dotted_Name_F_Prefix'Access,
         Owner         => Type_Index_For_Dotted_Name,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Dotted_Name_F_Suffix : aliased constant Text_Type :=
        "F_Suffix";
      Member_Desc_For_Dotted_Name_F_Suffix : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Dotted_Name_F_Suffix'Access,
         Owner         => Type_Index_For_Dotted_Name,
         Member_Type   => Type_Index_For_Base_Id,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_End_Name_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_End_Name_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_End_Name_F_Name'Access,
         Owner         => Type_Index_For_End_Name,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Explicit_Deref_F_Prefix : aliased constant Text_Type :=
        "F_Prefix";
      Member_Desc_For_Explicit_Deref_F_Prefix : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Explicit_Deref_F_Prefix'Access,
         Owner         => Type_Index_For_Explicit_Deref,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Qual_Expr_F_Prefix : aliased constant Text_Type :=
        "F_Prefix";
      Member_Desc_For_Qual_Expr_F_Prefix : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Qual_Expr_F_Prefix'Access,
         Owner         => Type_Index_For_Qual_Expr,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Qual_Expr_F_Suffix : aliased constant Text_Type :=
        "F_Suffix";
      Member_Desc_For_Qual_Expr_F_Suffix : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Qual_Expr_F_Suffix'Access,
         Owner         => Type_Index_For_Qual_Expr,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Reduce_Attribute_Ref_F_Prefix : aliased constant Text_Type :=
        "F_Prefix";
      Member_Desc_For_Reduce_Attribute_Ref_F_Prefix : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Reduce_Attribute_Ref_F_Prefix'Access,
         Owner         => Type_Index_For_Reduce_Attribute_Ref,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Reduce_Attribute_Ref_F_Attribute : aliased constant Text_Type :=
        "F_Attribute";
      Member_Desc_For_Reduce_Attribute_Ref_F_Attribute : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Reduce_Attribute_Ref_F_Attribute'Access,
         Owner         => Type_Index_For_Reduce_Attribute_Ref,
         Member_Type   => Type_Index_For_Identifier,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Reduce_Attribute_Ref_F_Args : aliased constant Text_Type :=
        "F_Args";
      Member_Desc_For_Reduce_Attribute_Ref_F_Args : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Reduce_Attribute_Ref_F_Args'Access,
         Owner         => Type_Index_For_Reduce_Attribute_Ref,
         Member_Type   => Type_Index_For_Assoc_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Update_Attribute_Ref_F_Prefix : aliased constant Text_Type :=
        "F_Prefix";
      Member_Desc_For_Update_Attribute_Ref_F_Prefix : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Update_Attribute_Ref_F_Prefix'Access,
         Owner         => Type_Index_For_Update_Attribute_Ref,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Update_Attribute_Ref_F_Attribute : aliased constant Text_Type :=
        "F_Attribute";
      Member_Desc_For_Update_Attribute_Ref_F_Attribute : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Update_Attribute_Ref_F_Attribute'Access,
         Owner         => Type_Index_For_Update_Attribute_Ref,
         Member_Type   => Type_Index_For_Identifier,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Update_Attribute_Ref_F_Values : aliased constant Text_Type :=
        "F_Values";
      Member_Desc_For_Update_Attribute_Ref_F_Values : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Update_Attribute_Ref_F_Values'Access,
         Owner         => Type_Index_For_Update_Attribute_Ref,
         Member_Type   => Type_Index_For_Base_Aggregate,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Paren_Expr_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Paren_Expr_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Paren_Expr_F_Expr'Access,
         Owner         => Type_Index_For_Paren_Expr,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Quantified_Expr_F_Quantifier : aliased constant Text_Type :=
        "F_Quantifier";
      Member_Desc_For_Quantified_Expr_F_Quantifier : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Quantified_Expr_F_Quantifier'Access,
         Owner         => Type_Index_For_Quantified_Expr,
         Member_Type   => Type_Index_For_Quantifier,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Quantified_Expr_F_Loop_Spec : aliased constant Text_Type :=
        "F_Loop_Spec";
      Member_Desc_For_Quantified_Expr_F_Loop_Spec : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Quantified_Expr_F_Loop_Spec'Access,
         Owner         => Type_Index_For_Quantified_Expr,
         Member_Type   => Type_Index_For_For_Loop_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Quantified_Expr_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Quantified_Expr_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Quantified_Expr_F_Expr'Access,
         Owner         => Type_Index_For_Quantified_Expr,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Raise_Expr_F_Exception_Name : aliased constant Text_Type :=
        "F_Exception_Name";
      Member_Desc_For_Raise_Expr_F_Exception_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Raise_Expr_F_Exception_Name'Access,
         Owner         => Type_Index_For_Raise_Expr,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Raise_Expr_F_Error_Message : aliased constant Text_Type :=
        "F_Error_Message";
      Member_Desc_For_Raise_Expr_F_Error_Message : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Raise_Expr_F_Error_Message'Access,
         Owner         => Type_Index_For_Raise_Expr,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Un_Op_F_Op : aliased constant Text_Type :=
        "F_Op";
      Member_Desc_For_Un_Op_F_Op : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Un_Op_F_Op'Access,
         Owner         => Type_Index_For_Un_Op,
         Member_Type   => Type_Index_For_Op,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Un_Op_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Un_Op_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Un_Op_F_Expr'Access,
         Owner         => Type_Index_For_Un_Op,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Handled_Stmts_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Handled_Stmts_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Handled_Stmts_F_Stmts'Access,
         Owner         => Type_Index_For_Handled_Stmts,
         Member_Type   => Type_Index_For_Stmt_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Handled_Stmts_F_Exceptions : aliased constant Text_Type :=
        "F_Exceptions";
      Member_Desc_For_Handled_Stmts_F_Exceptions : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Handled_Stmts_F_Exceptions'Access,
         Owner         => Type_Index_For_Handled_Stmts,
         Member_Type   => Type_Index_For_Ada_Node_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Library_Item_F_Has_Private : aliased constant Text_Type :=
        "F_Has_Private";
      Member_Desc_For_Library_Item_F_Has_Private : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Library_Item_F_Has_Private'Access,
         Owner         => Type_Index_For_Library_Item,
         Member_Type   => Type_Index_For_Private,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Library_Item_F_Item : aliased constant Text_Type :=
        "F_Item";
      Member_Desc_For_Library_Item_F_Item : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Library_Item_F_Item'Access,
         Owner         => Type_Index_For_Library_Item,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_For_Loop_Spec_F_Var_Decl : aliased constant Text_Type :=
        "F_Var_Decl";
      Member_Desc_For_For_Loop_Spec_F_Var_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_For_Loop_Spec_F_Var_Decl'Access,
         Owner         => Type_Index_For_For_Loop_Spec,
         Member_Type   => Type_Index_For_For_Loop_Var_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_For_Loop_Spec_F_Loop_Type : aliased constant Text_Type :=
        "F_Loop_Type";
      Member_Desc_For_For_Loop_Spec_F_Loop_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_For_Loop_Spec_F_Loop_Type'Access,
         Owner         => Type_Index_For_For_Loop_Spec,
         Member_Type   => Type_Index_For_Iter_Type,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_For_Loop_Spec_F_Has_Reverse : aliased constant Text_Type :=
        "F_Has_Reverse";
      Member_Desc_For_For_Loop_Spec_F_Has_Reverse : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_For_Loop_Spec_F_Has_Reverse'Access,
         Owner         => Type_Index_For_For_Loop_Spec,
         Member_Type   => Type_Index_For_Reverse,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_For_Loop_Spec_F_Iter_Expr : aliased constant Text_Type :=
        "F_Iter_Expr";
      Member_Desc_For_For_Loop_Spec_F_Iter_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_For_Loop_Spec_F_Iter_Expr'Access,
         Owner         => Type_Index_For_For_Loop_Spec,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_For_Loop_Spec_F_Iter_Filter : aliased constant Text_Type :=
        "F_Iter_Filter";
      Member_Desc_For_For_Loop_Spec_F_Iter_Filter : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_For_Loop_Spec_F_Iter_Filter'Access,
         Owner         => Type_Index_For_For_Loop_Spec,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_While_Loop_Spec_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_While_Loop_Spec_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_While_Loop_Spec_F_Expr'Access,
         Owner         => Type_Index_For_While_Loop_Spec,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Multi_Abstract_State_Decl_F_Decls : aliased constant Text_Type :=
        "F_Decls";
      Member_Desc_For_Multi_Abstract_State_Decl_F_Decls : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Multi_Abstract_State_Decl_F_Decls'Access,
         Owner         => Type_Index_For_Multi_Abstract_State_Decl,
         Member_Type   => Type_Index_For_Abstract_State_Decl_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Params_F_Params : aliased constant Text_Type :=
        "F_Params";
      Member_Desc_For_Params_F_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Params_F_Params'Access,
         Owner         => Type_Index_For_Params,
         Member_Type   => Type_Index_For_Param_Spec_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Paren_Abstract_State_Decl_F_Decl : aliased constant Text_Type :=
        "F_Decl";
      Member_Desc_For_Paren_Abstract_State_Decl_F_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Paren_Abstract_State_Decl_F_Decl'Access,
         Owner         => Type_Index_For_Paren_Abstract_State_Decl,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Pp_Elsif_Directive_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Pp_Elsif_Directive_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Pp_Elsif_Directive_F_Expr'Access,
         Owner         => Type_Index_For_Pp_Elsif_Directive,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Pp_Elsif_Directive_F_Then_Kw : aliased constant Text_Type :=
        "F_Then_Kw";
      Member_Desc_For_Pp_Elsif_Directive_F_Then_Kw : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Pp_Elsif_Directive_F_Then_Kw'Access,
         Owner         => Type_Index_For_Pp_Elsif_Directive,
         Member_Type   => Type_Index_For_Pp_Then_Kw,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Pp_If_Directive_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Pp_If_Directive_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Pp_If_Directive_F_Expr'Access,
         Owner         => Type_Index_For_Pp_If_Directive,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Pp_If_Directive_F_Then_Kw : aliased constant Text_Type :=
        "F_Then_Kw";
      Member_Desc_For_Pp_If_Directive_F_Then_Kw : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Pp_If_Directive_F_Then_Kw'Access,
         Owner         => Type_Index_For_Pp_If_Directive,
         Member_Type   => Type_Index_For_Pp_Then_Kw,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Pragma_Node_F_Id : aliased constant Text_Type :=
        "F_Id";
      Member_Desc_For_Pragma_Node_F_Id : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Pragma_Node_F_Id'Access,
         Owner         => Type_Index_For_Pragma,
         Member_Type   => Type_Index_For_Identifier,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Pragma_Node_F_Args : aliased constant Text_Type :=
        "F_Args";
      Member_Desc_For_Pragma_Node_F_Args : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Pragma_Node_F_Args'Access,
         Owner         => Type_Index_For_Pragma,
         Member_Type   => Type_Index_For_Base_Assoc_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Protected_Def_F_Public_Part : aliased constant Text_Type :=
        "F_Public_Part";
      Member_Desc_For_Protected_Def_F_Public_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Protected_Def_F_Public_Part'Access,
         Owner         => Type_Index_For_Protected_Def,
         Member_Type   => Type_Index_For_Public_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Protected_Def_F_Private_Part : aliased constant Text_Type :=
        "F_Private_Part";
      Member_Desc_For_Protected_Def_F_Private_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Protected_Def_F_Private_Part'Access,
         Owner         => Type_Index_For_Protected_Def,
         Member_Type   => Type_Index_For_Private_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Protected_Def_F_End_Name : aliased constant Text_Type :=
        "F_End_Name";
      Member_Desc_For_Protected_Def_F_End_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Protected_Def_F_End_Name'Access,
         Owner         => Type_Index_For_Protected_Def,
         Member_Type   => Type_Index_For_End_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Range_Spec_F_Range : aliased constant Text_Type :=
        "F_Range";
      Member_Desc_For_Range_Spec_F_Range : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Range_Spec_F_Range'Access,
         Owner         => Type_Index_For_Range_Spec,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Renaming_Clause_F_Renamed_Object : aliased constant Text_Type :=
        "F_Renamed_Object";
      Member_Desc_For_Renaming_Clause_F_Renamed_Object : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Renaming_Clause_F_Renamed_Object'Access,
         Owner         => Type_Index_For_Renaming_Clause,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Select_When_Part_F_Cond_Expr : aliased constant Text_Type :=
        "F_Cond_Expr";
      Member_Desc_For_Select_When_Part_F_Cond_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Select_When_Part_F_Cond_Expr'Access,
         Owner         => Type_Index_For_Select_When_Part,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Select_When_Part_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Select_When_Part_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Select_When_Part_F_Stmts'Access,
         Owner         => Type_Index_For_Select_When_Part,
         Member_Type   => Type_Index_For_Stmt_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Accept_Stmt_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Accept_Stmt_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Accept_Stmt_F_Name'Access,
         Owner         => Type_Index_For_Accept_Stmt,
         Member_Type   => Type_Index_For_Identifier,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Accept_Stmt_F_Entry_Index_Expr : aliased constant Text_Type :=
        "F_Entry_Index_Expr";
      Member_Desc_For_Accept_Stmt_F_Entry_Index_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Accept_Stmt_F_Entry_Index_Expr'Access,
         Owner         => Type_Index_For_Accept_Stmt,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Accept_Stmt_F_Params : aliased constant Text_Type :=
        "F_Params";
      Member_Desc_For_Accept_Stmt_F_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Accept_Stmt_F_Params'Access,
         Owner         => Type_Index_For_Accept_Stmt,
         Member_Type   => Type_Index_For_Entry_Completion_Formal_Params,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Accept_Stmt_With_Stmts_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Accept_Stmt_With_Stmts_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Accept_Stmt_With_Stmts_F_Stmts'Access,
         Owner         => Type_Index_For_Accept_Stmt_With_Stmts,
         Member_Type   => Type_Index_For_Handled_Stmts,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Accept_Stmt_With_Stmts_F_End_Name : aliased constant Text_Type :=
        "F_End_Name";
      Member_Desc_For_Accept_Stmt_With_Stmts_F_End_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Accept_Stmt_With_Stmts_F_End_Name'Access,
         Owner         => Type_Index_For_Accept_Stmt_With_Stmts,
         Member_Type   => Type_Index_For_End_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Loop_Stmt_F_Spec : aliased constant Text_Type :=
        "F_Spec";
      Member_Desc_For_Base_Loop_Stmt_F_Spec : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Loop_Stmt_F_Spec'Access,
         Owner         => Type_Index_For_Base_Loop_Stmt,
         Member_Type   => Type_Index_For_Loop_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Loop_Stmt_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Base_Loop_Stmt_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Loop_Stmt_F_Stmts'Access,
         Owner         => Type_Index_For_Base_Loop_Stmt,
         Member_Type   => Type_Index_For_Stmt_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Loop_Stmt_F_End_Name : aliased constant Text_Type :=
        "F_End_Name";
      Member_Desc_For_Base_Loop_Stmt_F_End_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Loop_Stmt_F_End_Name'Access,
         Owner         => Type_Index_For_Base_Loop_Stmt,
         Member_Type   => Type_Index_For_End_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Begin_Block_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Begin_Block_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Begin_Block_F_Stmts'Access,
         Owner         => Type_Index_For_Begin_Block,
         Member_Type   => Type_Index_For_Handled_Stmts,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Begin_Block_F_End_Name : aliased constant Text_Type :=
        "F_End_Name";
      Member_Desc_For_Begin_Block_F_End_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Begin_Block_F_End_Name'Access,
         Owner         => Type_Index_For_Begin_Block,
         Member_Type   => Type_Index_For_End_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Decl_Block_F_Decls : aliased constant Text_Type :=
        "F_Decls";
      Member_Desc_For_Decl_Block_F_Decls : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Decl_Block_F_Decls'Access,
         Owner         => Type_Index_For_Decl_Block,
         Member_Type   => Type_Index_For_Declarative_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Decl_Block_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Decl_Block_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Decl_Block_F_Stmts'Access,
         Owner         => Type_Index_For_Decl_Block,
         Member_Type   => Type_Index_For_Handled_Stmts,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Decl_Block_F_End_Name : aliased constant Text_Type :=
        "F_End_Name";
      Member_Desc_For_Decl_Block_F_End_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Decl_Block_F_End_Name'Access,
         Owner         => Type_Index_For_Decl_Block,
         Member_Type   => Type_Index_For_End_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Case_Stmt_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Case_Stmt_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Case_Stmt_F_Expr'Access,
         Owner         => Type_Index_For_Case_Stmt,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Case_Stmt_F_Pragmas : aliased constant Text_Type :=
        "F_Pragmas";
      Member_Desc_For_Case_Stmt_F_Pragmas : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Case_Stmt_F_Pragmas'Access,
         Owner         => Type_Index_For_Case_Stmt,
         Member_Type   => Type_Index_For_Pragma_Node_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Case_Stmt_F_Alternatives : aliased constant Text_Type :=
        "F_Alternatives";
      Member_Desc_For_Case_Stmt_F_Alternatives : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Case_Stmt_F_Alternatives'Access,
         Owner         => Type_Index_For_Case_Stmt,
         Member_Type   => Type_Index_For_Case_Stmt_Alternative_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Extended_Return_Stmt_F_Decl : aliased constant Text_Type :=
        "F_Decl";
      Member_Desc_For_Extended_Return_Stmt_F_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Extended_Return_Stmt_F_Decl'Access,
         Owner         => Type_Index_For_Extended_Return_Stmt,
         Member_Type   => Type_Index_For_Extended_Return_Stmt_Object_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Extended_Return_Stmt_F_Stmts : aliased constant Text_Type :=
        "F_Stmts";
      Member_Desc_For_Extended_Return_Stmt_F_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Extended_Return_Stmt_F_Stmts'Access,
         Owner         => Type_Index_For_Extended_Return_Stmt,
         Member_Type   => Type_Index_For_Handled_Stmts,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_If_Stmt_F_Cond_Expr : aliased constant Text_Type :=
        "F_Cond_Expr";
      Member_Desc_For_If_Stmt_F_Cond_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_If_Stmt_F_Cond_Expr'Access,
         Owner         => Type_Index_For_If_Stmt,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_If_Stmt_F_Then_Stmts : aliased constant Text_Type :=
        "F_Then_Stmts";
      Member_Desc_For_If_Stmt_F_Then_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_If_Stmt_F_Then_Stmts'Access,
         Owner         => Type_Index_For_If_Stmt,
         Member_Type   => Type_Index_For_Stmt_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_If_Stmt_F_Alternatives : aliased constant Text_Type :=
        "F_Alternatives";
      Member_Desc_For_If_Stmt_F_Alternatives : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_If_Stmt_F_Alternatives'Access,
         Owner         => Type_Index_For_If_Stmt,
         Member_Type   => Type_Index_For_Elsif_Stmt_Part_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_If_Stmt_F_Else_Stmts : aliased constant Text_Type :=
        "F_Else_Stmts";
      Member_Desc_For_If_Stmt_F_Else_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_If_Stmt_F_Else_Stmts'Access,
         Owner         => Type_Index_For_If_Stmt,
         Member_Type   => Type_Index_For_Stmt_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Named_Stmt_F_Decl : aliased constant Text_Type :=
        "F_Decl";
      Member_Desc_For_Named_Stmt_F_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Named_Stmt_F_Decl'Access,
         Owner         => Type_Index_For_Named_Stmt,
         Member_Type   => Type_Index_For_Named_Stmt_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Named_Stmt_F_Stmt : aliased constant Text_Type :=
        "F_Stmt";
      Member_Desc_For_Named_Stmt_F_Stmt : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Named_Stmt_F_Stmt'Access,
         Owner         => Type_Index_For_Named_Stmt,
         Member_Type   => Type_Index_For_Composite_Stmt,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Select_Stmt_F_Guards : aliased constant Text_Type :=
        "F_Guards";
      Member_Desc_For_Select_Stmt_F_Guards : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Select_Stmt_F_Guards'Access,
         Owner         => Type_Index_For_Select_Stmt,
         Member_Type   => Type_Index_For_Select_When_Part_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Select_Stmt_F_Else_Stmts : aliased constant Text_Type :=
        "F_Else_Stmts";
      Member_Desc_For_Select_Stmt_F_Else_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Select_Stmt_F_Else_Stmts'Access,
         Owner         => Type_Index_For_Select_Stmt,
         Member_Type   => Type_Index_For_Stmt_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Select_Stmt_F_Abort_Stmts : aliased constant Text_Type :=
        "F_Abort_Stmts";
      Member_Desc_For_Select_Stmt_F_Abort_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Select_Stmt_F_Abort_Stmts'Access,
         Owner         => Type_Index_For_Select_Stmt,
         Member_Type   => Type_Index_For_Stmt_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Abort_Stmt_F_Names : aliased constant Text_Type :=
        "F_Names";
      Member_Desc_For_Abort_Stmt_F_Names : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Abort_Stmt_F_Names'Access,
         Owner         => Type_Index_For_Abort_Stmt,
         Member_Type   => Type_Index_For_Name_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Assign_Stmt_F_Dest : aliased constant Text_Type :=
        "F_Dest";
      Member_Desc_For_Assign_Stmt_F_Dest : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Assign_Stmt_F_Dest'Access,
         Owner         => Type_Index_For_Assign_Stmt,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Assign_Stmt_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Assign_Stmt_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Assign_Stmt_F_Expr'Access,
         Owner         => Type_Index_For_Assign_Stmt,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Call_Stmt_F_Call : aliased constant Text_Type :=
        "F_Call";
      Member_Desc_For_Call_Stmt_F_Call : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Call_Stmt_F_Call'Access,
         Owner         => Type_Index_For_Call_Stmt,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Delay_Stmt_F_Has_Until : aliased constant Text_Type :=
        "F_Has_Until";
      Member_Desc_For_Delay_Stmt_F_Has_Until : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Delay_Stmt_F_Has_Until'Access,
         Owner         => Type_Index_For_Delay_Stmt,
         Member_Type   => Type_Index_For_Until,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Delay_Stmt_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Delay_Stmt_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Delay_Stmt_F_Expr'Access,
         Owner         => Type_Index_For_Delay_Stmt,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Exit_Stmt_F_Loop_Name : aliased constant Text_Type :=
        "F_Loop_Name";
      Member_Desc_For_Exit_Stmt_F_Loop_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Exit_Stmt_F_Loop_Name'Access,
         Owner         => Type_Index_For_Exit_Stmt,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Exit_Stmt_F_Cond_Expr : aliased constant Text_Type :=
        "F_Cond_Expr";
      Member_Desc_For_Exit_Stmt_F_Cond_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Exit_Stmt_F_Cond_Expr'Access,
         Owner         => Type_Index_For_Exit_Stmt,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Goto_Stmt_F_Label_Name : aliased constant Text_Type :=
        "F_Label_Name";
      Member_Desc_For_Goto_Stmt_F_Label_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Goto_Stmt_F_Label_Name'Access,
         Owner         => Type_Index_For_Goto_Stmt,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Label_F_Decl : aliased constant Text_Type :=
        "F_Decl";
      Member_Desc_For_Label_F_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Label_F_Decl'Access,
         Owner         => Type_Index_For_Label,
         Member_Type   => Type_Index_For_Label_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Raise_Stmt_F_Exception_Name : aliased constant Text_Type :=
        "F_Exception_Name";
      Member_Desc_For_Raise_Stmt_F_Exception_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Raise_Stmt_F_Exception_Name'Access,
         Owner         => Type_Index_For_Raise_Stmt,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Raise_Stmt_F_Error_Message : aliased constant Text_Type :=
        "F_Error_Message";
      Member_Desc_For_Raise_Stmt_F_Error_Message : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Raise_Stmt_F_Error_Message'Access,
         Owner         => Type_Index_For_Raise_Stmt,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Requeue_Stmt_F_Call_Name : aliased constant Text_Type :=
        "F_Call_Name";
      Member_Desc_For_Requeue_Stmt_F_Call_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Requeue_Stmt_F_Call_Name'Access,
         Owner         => Type_Index_For_Requeue_Stmt,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Requeue_Stmt_F_Has_Abort : aliased constant Text_Type :=
        "F_Has_Abort";
      Member_Desc_For_Requeue_Stmt_F_Has_Abort : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Requeue_Stmt_F_Has_Abort'Access,
         Owner         => Type_Index_For_Requeue_Stmt,
         Member_Type   => Type_Index_For_Abort,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Return_Stmt_F_Return_Expr : aliased constant Text_Type :=
        "F_Return_Expr";
      Member_Desc_For_Return_Stmt_F_Return_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Return_Stmt_F_Return_Expr'Access,
         Owner         => Type_Index_For_Return_Stmt,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subunit_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Subunit_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subunit_F_Name'Access,
         Owner         => Type_Index_For_Subunit,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subunit_F_Body : aliased constant Text_Type :=
        "F_Body";
      Member_Desc_For_Subunit_F_Body : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subunit_F_Body'Access,
         Owner         => Type_Index_For_Subunit,
         Member_Type   => Type_Index_For_Body,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Task_Def_F_Interfaces : aliased constant Text_Type :=
        "F_Interfaces";
      Member_Desc_For_Task_Def_F_Interfaces : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Task_Def_F_Interfaces'Access,
         Owner         => Type_Index_For_Task_Def,
         Member_Type   => Type_Index_For_Parent_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Task_Def_F_Public_Part : aliased constant Text_Type :=
        "F_Public_Part";
      Member_Desc_For_Task_Def_F_Public_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Task_Def_F_Public_Part'Access,
         Owner         => Type_Index_For_Task_Def,
         Member_Type   => Type_Index_For_Public_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Task_Def_F_Private_Part : aliased constant Text_Type :=
        "F_Private_Part";
      Member_Desc_For_Task_Def_F_Private_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Task_Def_F_Private_Part'Access,
         Owner         => Type_Index_For_Task_Def,
         Member_Type   => Type_Index_For_Private_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Task_Def_F_End_Name : aliased constant Text_Type :=
        "F_End_Name";
      Member_Desc_For_Task_Def_F_End_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Task_Def_F_End_Name'Access,
         Owner         => Type_Index_For_Task_Def,
         Member_Type   => Type_Index_For_End_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Access_Def_F_Has_Not_Null : aliased constant Text_Type :=
        "F_Has_Not_Null";
      Member_Desc_For_Access_Def_F_Has_Not_Null : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Access_Def_F_Has_Not_Null'Access,
         Owner         => Type_Index_For_Access_Def,
         Member_Type   => Type_Index_For_Not_Null,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Access_To_Subp_Def_F_Has_Protected : aliased constant Text_Type :=
        "F_Has_Protected";
      Member_Desc_For_Access_To_Subp_Def_F_Has_Protected : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Access_To_Subp_Def_F_Has_Protected'Access,
         Owner         => Type_Index_For_Access_To_Subp_Def,
         Member_Type   => Type_Index_For_Protected,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Access_To_Subp_Def_F_Subp_Spec : aliased constant Text_Type :=
        "F_Subp_Spec";
      Member_Desc_For_Access_To_Subp_Def_F_Subp_Spec : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Access_To_Subp_Def_F_Subp_Spec'Access,
         Owner         => Type_Index_For_Access_To_Subp_Def,
         Member_Type   => Type_Index_For_Subp_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Anonymous_Type_Access_Def_F_Type_Decl : aliased constant Text_Type :=
        "F_Type_Decl";
      Member_Desc_For_Anonymous_Type_Access_Def_F_Type_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Anonymous_Type_Access_Def_F_Type_Decl'Access,
         Owner         => Type_Index_For_Anonymous_Type_Access_Def,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Type_Access_Def_F_Has_All : aliased constant Text_Type :=
        "F_Has_All";
      Member_Desc_For_Type_Access_Def_F_Has_All : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Type_Access_Def_F_Has_All'Access,
         Owner         => Type_Index_For_Type_Access_Def,
         Member_Type   => Type_Index_For_All,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Type_Access_Def_F_Has_Constant : aliased constant Text_Type :=
        "F_Has_Constant";
      Member_Desc_For_Type_Access_Def_F_Has_Constant : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Type_Access_Def_F_Has_Constant'Access,
         Owner         => Type_Index_For_Type_Access_Def,
         Member_Type   => Type_Index_For_Constant,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Type_Access_Def_F_Subtype_Indication : aliased constant Text_Type :=
        "F_Subtype_Indication";
      Member_Desc_For_Type_Access_Def_F_Subtype_Indication : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Type_Access_Def_F_Subtype_Indication'Access,
         Owner         => Type_Index_For_Type_Access_Def,
         Member_Type   => Type_Index_For_Subtype_Indication,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Array_Type_Def_F_Indices : aliased constant Text_Type :=
        "F_Indices";
      Member_Desc_For_Array_Type_Def_F_Indices : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Array_Type_Def_F_Indices'Access,
         Owner         => Type_Index_For_Array_Type_Def,
         Member_Type   => Type_Index_For_Array_Indices,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Array_Type_Def_F_Component_Type : aliased constant Text_Type :=
        "F_Component_Type";
      Member_Desc_For_Array_Type_Def_F_Component_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Array_Type_Def_F_Component_Type'Access,
         Owner         => Type_Index_For_Array_Type_Def,
         Member_Type   => Type_Index_For_Component_Def,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Derived_Type_Def_F_Has_Abstract : aliased constant Text_Type :=
        "F_Has_Abstract";
      Member_Desc_For_Derived_Type_Def_F_Has_Abstract : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Derived_Type_Def_F_Has_Abstract'Access,
         Owner         => Type_Index_For_Derived_Type_Def,
         Member_Type   => Type_Index_For_Abstract,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Derived_Type_Def_F_Has_Limited : aliased constant Text_Type :=
        "F_Has_Limited";
      Member_Desc_For_Derived_Type_Def_F_Has_Limited : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Derived_Type_Def_F_Has_Limited'Access,
         Owner         => Type_Index_For_Derived_Type_Def,
         Member_Type   => Type_Index_For_Limited,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Derived_Type_Def_F_Has_Synchronized : aliased constant Text_Type :=
        "F_Has_Synchronized";
      Member_Desc_For_Derived_Type_Def_F_Has_Synchronized : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Derived_Type_Def_F_Has_Synchronized'Access,
         Owner         => Type_Index_For_Derived_Type_Def,
         Member_Type   => Type_Index_For_Synchronized,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Derived_Type_Def_F_Subtype_Indication : aliased constant Text_Type :=
        "F_Subtype_Indication";
      Member_Desc_For_Derived_Type_Def_F_Subtype_Indication : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Derived_Type_Def_F_Subtype_Indication'Access,
         Owner         => Type_Index_For_Derived_Type_Def,
         Member_Type   => Type_Index_For_Subtype_Indication,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Derived_Type_Def_F_Interfaces : aliased constant Text_Type :=
        "F_Interfaces";
      Member_Desc_For_Derived_Type_Def_F_Interfaces : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Derived_Type_Def_F_Interfaces'Access,
         Owner         => Type_Index_For_Derived_Type_Def,
         Member_Type   => Type_Index_For_Parent_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Derived_Type_Def_F_Record_Extension : aliased constant Text_Type :=
        "F_Record_Extension";
      Member_Desc_For_Derived_Type_Def_F_Record_Extension : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Derived_Type_Def_F_Record_Extension'Access,
         Owner         => Type_Index_For_Derived_Type_Def,
         Member_Type   => Type_Index_For_Base_Record_Def,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Derived_Type_Def_F_Has_With_Private : aliased constant Text_Type :=
        "F_Has_With_Private";
      Member_Desc_For_Derived_Type_Def_F_Has_With_Private : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Derived_Type_Def_F_Has_With_Private'Access,
         Owner         => Type_Index_For_Derived_Type_Def,
         Member_Type   => Type_Index_For_With_Private,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Enum_Type_Def_F_Enum_Literals : aliased constant Text_Type :=
        "F_Enum_Literals";
      Member_Desc_For_Enum_Type_Def_F_Enum_Literals : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Enum_Type_Def_F_Enum_Literals'Access,
         Owner         => Type_Index_For_Enum_Type_Def,
         Member_Type   => Type_Index_For_Enum_Literal_Decl_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Interface_Type_Def_F_Interface_Kind : aliased constant Text_Type :=
        "F_Interface_Kind";
      Member_Desc_For_Interface_Type_Def_F_Interface_Kind : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Interface_Type_Def_F_Interface_Kind'Access,
         Owner         => Type_Index_For_Interface_Type_Def,
         Member_Type   => Type_Index_For_Interface_Kind,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Interface_Type_Def_F_Interfaces : aliased constant Text_Type :=
        "F_Interfaces";
      Member_Desc_For_Interface_Type_Def_F_Interfaces : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Interface_Type_Def_F_Interfaces'Access,
         Owner         => Type_Index_For_Interface_Type_Def,
         Member_Type   => Type_Index_For_Parent_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Mod_Int_Type_Def_F_Expr : aliased constant Text_Type :=
        "F_Expr";
      Member_Desc_For_Mod_Int_Type_Def_F_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Mod_Int_Type_Def_F_Expr'Access,
         Owner         => Type_Index_For_Mod_Int_Type_Def,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Private_Type_Def_F_Has_Abstract : aliased constant Text_Type :=
        "F_Has_Abstract";
      Member_Desc_For_Private_Type_Def_F_Has_Abstract : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Private_Type_Def_F_Has_Abstract'Access,
         Owner         => Type_Index_For_Private_Type_Def,
         Member_Type   => Type_Index_For_Abstract,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Private_Type_Def_F_Has_Tagged : aliased constant Text_Type :=
        "F_Has_Tagged";
      Member_Desc_For_Private_Type_Def_F_Has_Tagged : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Private_Type_Def_F_Has_Tagged'Access,
         Owner         => Type_Index_For_Private_Type_Def,
         Member_Type   => Type_Index_For_Tagged,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Private_Type_Def_F_Has_Limited : aliased constant Text_Type :=
        "F_Has_Limited";
      Member_Desc_For_Private_Type_Def_F_Has_Limited : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Private_Type_Def_F_Has_Limited'Access,
         Owner         => Type_Index_For_Private_Type_Def,
         Member_Type   => Type_Index_For_Limited,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Decimal_Fixed_Point_Def_F_Delta : aliased constant Text_Type :=
        "F_Delta";
      Member_Desc_For_Decimal_Fixed_Point_Def_F_Delta : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Decimal_Fixed_Point_Def_F_Delta'Access,
         Owner         => Type_Index_For_Decimal_Fixed_Point_Def,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Decimal_Fixed_Point_Def_F_Digits : aliased constant Text_Type :=
        "F_Digits";
      Member_Desc_For_Decimal_Fixed_Point_Def_F_Digits : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Decimal_Fixed_Point_Def_F_Digits'Access,
         Owner         => Type_Index_For_Decimal_Fixed_Point_Def,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Decimal_Fixed_Point_Def_F_Range : aliased constant Text_Type :=
        "F_Range";
      Member_Desc_For_Decimal_Fixed_Point_Def_F_Range : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Decimal_Fixed_Point_Def_F_Range'Access,
         Owner         => Type_Index_For_Decimal_Fixed_Point_Def,
         Member_Type   => Type_Index_For_Range_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Floating_Point_Def_F_Num_Digits : aliased constant Text_Type :=
        "F_Num_Digits";
      Member_Desc_For_Floating_Point_Def_F_Num_Digits : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Floating_Point_Def_F_Num_Digits'Access,
         Owner         => Type_Index_For_Floating_Point_Def,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Floating_Point_Def_F_Range : aliased constant Text_Type :=
        "F_Range";
      Member_Desc_For_Floating_Point_Def_F_Range : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Floating_Point_Def_F_Range'Access,
         Owner         => Type_Index_For_Floating_Point_Def,
         Member_Type   => Type_Index_For_Range_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ordinary_Fixed_Point_Def_F_Delta : aliased constant Text_Type :=
        "F_Delta";
      Member_Desc_For_Ordinary_Fixed_Point_Def_F_Delta : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ordinary_Fixed_Point_Def_F_Delta'Access,
         Owner         => Type_Index_For_Ordinary_Fixed_Point_Def,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ordinary_Fixed_Point_Def_F_Range : aliased constant Text_Type :=
        "F_Range";
      Member_Desc_For_Ordinary_Fixed_Point_Def_F_Range : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ordinary_Fixed_Point_Def_F_Range'Access,
         Owner         => Type_Index_For_Ordinary_Fixed_Point_Def,
         Member_Type   => Type_Index_For_Range_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Record_Type_Def_F_Has_Abstract : aliased constant Text_Type :=
        "F_Has_Abstract";
      Member_Desc_For_Record_Type_Def_F_Has_Abstract : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Record_Type_Def_F_Has_Abstract'Access,
         Owner         => Type_Index_For_Record_Type_Def,
         Member_Type   => Type_Index_For_Abstract,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Record_Type_Def_F_Has_Tagged : aliased constant Text_Type :=
        "F_Has_Tagged";
      Member_Desc_For_Record_Type_Def_F_Has_Tagged : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Record_Type_Def_F_Has_Tagged'Access,
         Owner         => Type_Index_For_Record_Type_Def,
         Member_Type   => Type_Index_For_Tagged,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Record_Type_Def_F_Has_Limited : aliased constant Text_Type :=
        "F_Has_Limited";
      Member_Desc_For_Record_Type_Def_F_Has_Limited : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Record_Type_Def_F_Has_Limited'Access,
         Owner         => Type_Index_For_Record_Type_Def,
         Member_Type   => Type_Index_For_Limited,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Record_Type_Def_F_Record_Def : aliased constant Text_Type :=
        "F_Record_Def";
      Member_Desc_For_Record_Type_Def_F_Record_Def : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Record_Type_Def_F_Record_Def'Access,
         Owner         => Type_Index_For_Record_Type_Def,
         Member_Type   => Type_Index_For_Base_Record_Def,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Signed_Int_Type_Def_F_Range : aliased constant Text_Type :=
        "F_Range";
      Member_Desc_For_Signed_Int_Type_Def_F_Range : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Signed_Int_Type_Def_F_Range'Access,
         Owner         => Type_Index_For_Signed_Int_Type_Def,
         Member_Type   => Type_Index_For_Range_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Anonymous_Type_F_Type_Decl : aliased constant Text_Type :=
        "F_Type_Decl";
      Member_Desc_For_Anonymous_Type_F_Type_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Anonymous_Type_F_Type_Decl'Access,
         Owner         => Type_Index_For_Anonymous_Type,
         Member_Type   => Type_Index_For_Anonymous_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subtype_Indication_F_Has_Not_Null : aliased constant Text_Type :=
        "F_Has_Not_Null";
      Member_Desc_For_Subtype_Indication_F_Has_Not_Null : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subtype_Indication_F_Has_Not_Null'Access,
         Owner         => Type_Index_For_Subtype_Indication,
         Member_Type   => Type_Index_For_Not_Null,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subtype_Indication_F_Name : aliased constant Text_Type :=
        "F_Name";
      Member_Desc_For_Subtype_Indication_F_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subtype_Indication_F_Name'Access,
         Owner         => Type_Index_For_Subtype_Indication,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Subtype_Indication_F_Constraint : aliased constant Text_Type :=
        "F_Constraint";
      Member_Desc_For_Subtype_Indication_F_Constraint : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subtype_Indication_F_Constraint'Access,
         Owner         => Type_Index_For_Subtype_Indication,
         Member_Type   => Type_Index_For_Constraint,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Synthetic_Type_Expr_F_Target_Type : aliased constant Text_Type :=
        "F_Target_Type";
      Member_Desc_For_Synthetic_Type_Expr_F_Target_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Synthetic_Type_Expr_F_Target_Type'Access,
         Owner         => Type_Index_For_Synthetic_Type_Expr,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Unconstrained_Array_Index_F_Subtype_Indication : aliased constant Text_Type :=
        "F_Subtype_Indication";
      Member_Desc_For_Unconstrained_Array_Index_F_Subtype_Indication : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Unconstrained_Array_Index_F_Subtype_Indication'Access,
         Owner         => Type_Index_For_Unconstrained_Array_Index,
         Member_Type   => Type_Index_For_Subtype_Indication,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Use_Package_Clause_F_Packages : aliased constant Text_Type :=
        "F_Packages";
      Member_Desc_For_Use_Package_Clause_F_Packages : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Use_Package_Clause_F_Packages'Access,
         Owner         => Type_Index_For_Use_Package_Clause,
         Member_Type   => Type_Index_For_Name_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Use_Type_Clause_F_Has_All : aliased constant Text_Type :=
        "F_Has_All";
      Member_Desc_For_Use_Type_Clause_F_Has_All : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Use_Type_Clause_F_Has_All'Access,
         Owner         => Type_Index_For_Use_Type_Clause,
         Member_Type   => Type_Index_For_All,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Use_Type_Clause_F_Types : aliased constant Text_Type :=
        "F_Types";
      Member_Desc_For_Use_Type_Clause_F_Types : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Use_Type_Clause_F_Types'Access,
         Owner         => Type_Index_For_Use_Type_Clause,
         Member_Type   => Type_Index_For_Name_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Value_Sequence_F_Iter_Assoc : aliased constant Text_Type :=
        "F_Iter_Assoc";
      Member_Desc_For_Value_Sequence_F_Iter_Assoc : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Value_Sequence_F_Iter_Assoc'Access,
         Owner         => Type_Index_For_Value_Sequence,
         Member_Type   => Type_Index_For_Iterated_Assoc,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Variant_F_Choices : aliased constant Text_Type :=
        "F_Choices";
      Member_Desc_For_Variant_F_Choices : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Variant_F_Choices'Access,
         Owner         => Type_Index_For_Variant,
         Member_Type   => Type_Index_For_Alternatives_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Variant_F_Components : aliased constant Text_Type :=
        "F_Components";
      Member_Desc_For_Variant_F_Components : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Variant_F_Components'Access,
         Owner         => Type_Index_For_Variant,
         Member_Type   => Type_Index_For_Component_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Variant_Part_F_Discr_Name : aliased constant Text_Type :=
        "F_Discr_Name";
      Member_Desc_For_Variant_Part_F_Discr_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Variant_Part_F_Discr_Name'Access,
         Owner         => Type_Index_For_Variant_Part,
         Member_Type   => Type_Index_For_Identifier,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Variant_Part_F_Variant : aliased constant Text_Type :=
        "F_Variant";
      Member_Desc_For_Variant_Part_F_Variant : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Variant_Part_F_Variant'Access,
         Owner         => Type_Index_For_Variant_Part,
         Member_Type   => Type_Index_For_Variant_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_With_Clause_F_Has_Limited : aliased constant Text_Type :=
        "F_Has_Limited";
      Member_Desc_For_With_Clause_F_Has_Limited : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_With_Clause_F_Has_Limited'Access,
         Owner         => Type_Index_For_With_Clause,
         Member_Type   => Type_Index_For_Limited,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_With_Clause_F_Has_Private : aliased constant Text_Type :=
        "F_Has_Private";
      Member_Desc_For_With_Clause_F_Has_Private : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_With_Clause_F_Has_Private'Access,
         Owner         => Type_Index_For_With_Clause,
         Member_Type   => Type_Index_For_Private,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_With_Clause_F_Packages : aliased constant Text_Type :=
        "F_Packages";
      Member_Desc_For_With_Clause_F_Packages : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_With_Clause_F_Packages'Access,
         Owner         => Type_Index_For_With_Clause,
         Member_Type   => Type_Index_For_Name_List,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Declarative_Scope : aliased constant Text_Type :=
        "P_Declarative_Scope";
      Member_Desc_For_Ada_Node_P_Declarative_Scope : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Declarative_Scope'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Declarative_Part,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Enclosing_Compilation_Unit : aliased constant Text_Type :=
        "P_Enclosing_Compilation_Unit";
      Member_Desc_For_Ada_Node_P_Enclosing_Compilation_Unit : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Enclosing_Compilation_Unit'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Compilation_Unit,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Get_Uninstantiated_Node : aliased constant Text_Type :=
        "P_Get_Uninstantiated_Node";
      Member_Desc_For_Ada_Node_P_Get_Uninstantiated_Node : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Get_Uninstantiated_Node'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Complete : aliased constant Text_Type :=
        "P_Complete";
      Member_Desc_For_Ada_Node_P_Complete : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Complete'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Completion_Item_Iterator,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Valid_Keywords : aliased constant Text_Type :=
        "P_Valid_Keywords";
      Member_Desc_For_Ada_Node_P_Valid_Keywords : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Valid_Keywords'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Symbol_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Generic_Instantiations : aliased constant Text_Type :=
        "P_Generic_Instantiations";
      Member_Desc_For_Ada_Node_P_Generic_Instantiations : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Generic_Instantiations'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Generic_Instantiation_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Semantic_Parent : aliased constant Text_Type :=
        "P_Semantic_Parent";
      Member_Desc_For_Ada_Node_P_Semantic_Parent : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Semantic_Parent'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Parent_Basic_Decl : aliased constant Text_Type :=
        "P_Parent_Basic_Decl";
      Member_Desc_For_Ada_Node_P_Parent_Basic_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Parent_Basic_Decl'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_1 : aliased constant Text_Type :=
           "Units";
         
         Arg_Name_2 : aliased constant Text_Type :=
           "Transitive";
         

      Member_Name_For_Ada_Node_P_Filter_Is_Imported_By : aliased constant Text_Type :=
        "P_Filter_Is_Imported_By";
      Member_Desc_For_Ada_Node_P_Filter_Is_Imported_By : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Ada_Node_P_Filter_Is_Imported_By'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Analysis_Unit_Array,
         Arguments     => (
               1 => (Name          => Arg_Name_1'Access,  Argument_Type => Type_Index_For_Analysis_Unit_Array,  Default_Value => (Kind => None)),
2 => (Name          => Arg_Name_2'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => None))
        ));

      


      Member_Name_For_Ada_Node_P_Xref_Entry_Point : aliased constant Text_Type :=
        "P_Xref_Entry_Point";
      Member_Desc_For_Ada_Node_P_Xref_Entry_Point : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Xref_Entry_Point'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Resolve_Names : aliased constant Text_Type :=
        "P_Resolve_Names";
      Member_Desc_For_Ada_Node_P_Resolve_Names : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Resolve_Names'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Standard_Unit : aliased constant Text_Type :=
        "P_Standard_Unit";
      Member_Desc_For_Ada_Node_P_Standard_Unit : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Standard_Unit'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Analysis_Unit,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_3 : aliased constant Text_Type :=
           "Sym";
         

      Member_Name_For_Ada_Node_P_Std_Entity : aliased constant Text_Type :=
        "P_Std_Entity";
      Member_Desc_For_Ada_Node_P_Std_Entity : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Ada_Node_P_Std_Entity'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               3 => (Name          => Arg_Name_3'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None))
        ));

      


      Member_Name_For_Ada_Node_P_Bool_Type : aliased constant Text_Type :=
        "P_Bool_Type";
      Member_Desc_For_Ada_Node_P_Bool_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Bool_Type'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Int_Type : aliased constant Text_Type :=
        "P_Int_Type";
      Member_Desc_For_Ada_Node_P_Int_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Int_Type'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Universal_Int_Type : aliased constant Text_Type :=
        "P_Universal_Int_Type";
      Member_Desc_For_Ada_Node_P_Universal_Int_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Universal_Int_Type'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Universal_Real_Type : aliased constant Text_Type :=
        "P_Universal_Real_Type";
      Member_Desc_For_Ada_Node_P_Universal_Real_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Universal_Real_Type'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Std_Char_Type : aliased constant Text_Type :=
        "P_Std_Char_Type";
      Member_Desc_For_Ada_Node_P_Std_Char_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Std_Char_Type'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Std_Wide_Char_Type : aliased constant Text_Type :=
        "P_Std_Wide_Char_Type";
      Member_Desc_For_Ada_Node_P_Std_Wide_Char_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Std_Wide_Char_Type'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Ada_Node_P_Std_Wide_Wide_Char_Type : aliased constant Text_Type :=
        "P_Std_Wide_Wide_Char_Type";
      Member_Desc_For_Ada_Node_P_Std_Wide_Wide_Char_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Ada_Node_P_Std_Wide_Wide_Char_Type'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_4 : aliased constant Text_Type :=
           "Unit";
         

      Member_Name_For_Ada_Node_P_Top_Level_Decl : aliased constant Text_Type :=
        "P_Top_Level_Decl";
      Member_Desc_For_Ada_Node_P_Top_Level_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Ada_Node_P_Top_Level_Decl'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               4 => (Name          => Arg_Name_4'Access,  Argument_Type => Type_Index_For_Analysis_Unit,  Default_Value => (Kind => None))
        ));

      

         Arg_Name_5 : aliased constant Text_Type :=
           "Value";
         

      Member_Name_For_Ada_Node_P_Choice_Match : aliased constant Text_Type :=
        "P_Choice_Match";
      Member_Desc_For_Ada_Node_P_Choice_Match : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Ada_Node_P_Choice_Match'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               5 => (Name          => Arg_Name_5'Access,  Argument_Type => Type_Index_For_Big_Int,  Default_Value => (Kind => None))
        ));

      

         Arg_Name_6 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Ada_Node_P_Gnat_Xref : aliased constant Text_Type :=
        "P_Gnat_Xref";
      Member_Desc_For_Ada_Node_P_Gnat_Xref : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Ada_Node_P_Gnat_Xref'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               6 => (Name          => Arg_Name_6'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Parent : aliased constant Text_Type :=
        "Parent";
      Member_Desc_For_Parent : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Parent'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_7 : aliased constant Text_Type :=
           "With_Self";
         

      Member_Name_For_Parents : aliased constant Text_Type :=
        "Parents";
      Member_Desc_For_Parents : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Parents'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Ada_Node_Array,
         Arguments     => (
               7 => (Name          => Arg_Name_7'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => True))
        ));

      


      Member_Name_For_Children : aliased constant Text_Type :=
        "Children";
      Member_Desc_For_Children : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Children'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Ada_Node_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Token_Start : aliased constant Text_Type :=
        "Token_Start";
      Member_Desc_For_Token_Start : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Token_Start'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Token,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Token_End : aliased constant Text_Type :=
        "Token_End";
      Member_Desc_For_Token_End : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Token_End'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Token,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Child_Index : aliased constant Text_Type :=
        "Child_Index";
      Member_Desc_For_Child_Index : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Child_Index'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Int,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Previous_Sibling : aliased constant Text_Type :=
        "Previous_Sibling";
      Member_Desc_For_Previous_Sibling : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Previous_Sibling'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Next_Sibling : aliased constant Text_Type :=
        "Next_Sibling";
      Member_Desc_For_Next_Sibling : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Next_Sibling'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Ada_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Unit : aliased constant Text_Type :=
        "Unit";
      Member_Desc_For_Unit : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Unit'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Analysis_Unit,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Is_Ghost : aliased constant Text_Type :=
        "Is_Ghost";
      Member_Desc_For_Is_Ghost : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Is_Ghost'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Full_Sloc_Image : aliased constant Text_Type :=
        "Full_Sloc_Image";
      Member_Desc_For_Full_Sloc_Image : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Full_Sloc_Image'Access,
         Owner         => Type_Index_For_Ada_Node,
         Member_Type   => Type_Index_For_String,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Abort_Node_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_Abort_Node_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Abort_Node_P_As_Bool'Access,
         Owner         => Type_Index_For_Abort,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Abstract_Node_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_Abstract_Node_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Abstract_Node_P_As_Bool'Access,
         Owner         => Type_Index_For_Abstract,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_8 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Assoc_List_P_Zip_With_Params : aliased constant Text_Type :=
        "P_Zip_With_Params";
      Member_Desc_For_Assoc_List_P_Zip_With_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Assoc_List_P_Zip_With_Params'Access,
         Owner         => Type_Index_For_Assoc_List,
         Member_Type   => Type_Index_For_Param_Actual_Array,
         Arguments     => (
               8 => (Name          => Arg_Name_8'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Aliased_Node_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_Aliased_Node_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Aliased_Node_P_As_Bool'Access,
         Owner         => Type_Index_For_Aliased,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_All_Node_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_All_Node_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_All_Node_P_As_Bool'Access,
         Owner         => Type_Index_For_All,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Aspect_Assoc_P_Is_Ghost_Code : aliased constant Text_Type :=
        "P_Is_Ghost_Code";
      Member_Desc_For_Aspect_Assoc_P_Is_Ghost_Code : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Aspect_Assoc_P_Is_Ghost_Code'Access,
         Owner         => Type_Index_For_Aspect_Assoc,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Enum_Rep_Clause_P_Params : aliased constant Text_Type :=
        "P_Params";
      Member_Desc_For_Enum_Rep_Clause_P_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Enum_Rep_Clause_P_Params'Access,
         Owner         => Type_Index_For_Enum_Rep_Clause,
         Member_Type   => Type_Index_For_Param_Actual_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Assoc_P_Assoc_Expr : aliased constant Text_Type :=
        "P_Assoc_Expr";
      Member_Desc_For_Base_Assoc_P_Assoc_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Assoc_P_Assoc_Expr'Access,
         Owner         => Type_Index_For_Base_Assoc,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Formal_Param_Holder_P_Abstract_Formal_Params : aliased constant Text_Type :=
        "P_Abstract_Formal_Params";
      Member_Desc_For_Base_Formal_Param_Holder_P_Abstract_Formal_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Formal_Param_Holder_P_Abstract_Formal_Params'Access,
         Owner         => Type_Index_For_Base_Formal_Param_Holder,
         Member_Type   => Type_Index_For_Base_Formal_Param_Decl_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Formal_Param_Holder_P_Formal_Params : aliased constant Text_Type :=
        "P_Formal_Params";
      Member_Desc_For_Base_Formal_Param_Holder_P_Formal_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Formal_Param_Holder_P_Formal_Params'Access,
         Owner         => Type_Index_For_Base_Formal_Param_Holder,
         Member_Type   => Type_Index_For_Defining_Name_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Formal_Param_Holder_P_Nb_Min_Params : aliased constant Text_Type :=
        "P_Nb_Min_Params";
      Member_Desc_For_Base_Formal_Param_Holder_P_Nb_Min_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Formal_Param_Holder_P_Nb_Min_Params'Access,
         Owner         => Type_Index_For_Base_Formal_Param_Holder,
         Member_Type   => Type_Index_For_Int,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Formal_Param_Holder_P_Nb_Max_Params : aliased constant Text_Type :=
        "P_Nb_Max_Params";
      Member_Desc_For_Base_Formal_Param_Holder_P_Nb_Max_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Formal_Param_Holder_P_Nb_Max_Params'Access,
         Owner         => Type_Index_For_Base_Formal_Param_Holder,
         Member_Type   => Type_Index_For_Int,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_9 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Formal_Param_Holder_P_Param_Types : aliased constant Text_Type :=
        "P_Param_Types";
      Member_Desc_For_Base_Formal_Param_Holder_P_Param_Types : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Formal_Param_Holder_P_Param_Types'Access,
         Owner         => Type_Index_For_Base_Formal_Param_Holder,
         Member_Type   => Type_Index_For_Base_Type_Decl_Array,
         Arguments     => (
               9 => (Name          => Arg_Name_9'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      


      Member_Name_For_Base_Subp_Spec_P_Returns : aliased constant Text_Type :=
        "P_Returns";
      Member_Desc_For_Base_Subp_Spec_P_Returns : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Subp_Spec_P_Returns'Access,
         Owner         => Type_Index_For_Base_Subp_Spec,
         Member_Type   => Type_Index_For_Type_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Subp_Spec_P_Params : aliased constant Text_Type :=
        "P_Params";
      Member_Desc_For_Base_Subp_Spec_P_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Subp_Spec_P_Params'Access,
         Owner         => Type_Index_For_Base_Subp_Spec,
         Member_Type   => Type_Index_For_Param_Spec_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_10 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Base_Subp_Spec_P_Primitive_Subp_Types : aliased constant Text_Type :=
        "P_Primitive_Subp_Types";
      Member_Desc_For_Base_Subp_Spec_P_Primitive_Subp_Types : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Subp_Spec_P_Primitive_Subp_Types'Access,
         Owner         => Type_Index_For_Base_Subp_Spec,
         Member_Type   => Type_Index_For_Base_Type_Decl_Array,
         Arguments     => (
               10 => (Name          => Arg_Name_10'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_11 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Base_Subp_Spec_P_Primitive_Subp_First_Type : aliased constant Text_Type :=
        "P_Primitive_Subp_First_Type";
      Member_Desc_For_Base_Subp_Spec_P_Primitive_Subp_First_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Subp_Spec_P_Primitive_Subp_First_Type'Access,
         Owner         => Type_Index_For_Base_Subp_Spec,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               11 => (Name          => Arg_Name_11'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_12 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Base_Subp_Spec_P_Primitive_Subp_Tagged_Type : aliased constant Text_Type :=
        "P_Primitive_Subp_Tagged_Type";
      Member_Desc_For_Base_Subp_Spec_P_Primitive_Subp_Tagged_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Subp_Spec_P_Primitive_Subp_Tagged_Type'Access,
         Owner         => Type_Index_For_Base_Subp_Spec,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               12 => (Name          => Arg_Name_12'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_13 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Subp_Spec_P_Return_Type : aliased constant Text_Type :=
        "P_Return_Type";
      Member_Desc_For_Base_Subp_Spec_P_Return_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Subp_Spec_P_Return_Type'Access,
         Owner         => Type_Index_For_Base_Subp_Spec,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               13 => (Name          => Arg_Name_13'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_14 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Assoc_P_Get_Params : aliased constant Text_Type :=
        "P_Get_Params";
      Member_Desc_For_Basic_Assoc_P_Get_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Assoc_P_Get_Params'Access,
         Owner         => Type_Index_For_Basic_Assoc,
         Member_Type   => Type_Index_For_Defining_Name_Array,
         Arguments     => (
               14 => (Name          => Arg_Name_14'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Basic_Decl_P_Is_Formal : aliased constant Text_Type :=
        "P_Is_Formal";
      Member_Desc_For_Basic_Decl_P_Is_Formal : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Is_Formal'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Basic_Decl_P_Doc_Annotations : aliased constant Text_Type :=
        "P_Doc_Annotations";
      Member_Desc_For_Basic_Decl_P_Doc_Annotations : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Doc_Annotations'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Doc_Annotation_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Basic_Decl_P_Doc : aliased constant Text_Type :=
        "P_Doc";
      Member_Desc_For_Basic_Decl_P_Doc : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Doc'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_String,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_15 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_Previous_Part_For_Decl : aliased constant Text_Type :=
        "P_Previous_Part_For_Decl";
      Member_Desc_For_Basic_Decl_P_Previous_Part_For_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_Previous_Part_For_Decl'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               15 => (Name          => Arg_Name_15'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_16 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_Canonical_Part : aliased constant Text_Type :=
        "P_Canonical_Part";
      Member_Desc_For_Basic_Decl_P_Canonical_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_Canonical_Part'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               16 => (Name          => Arg_Name_16'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_17 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_All_Parts : aliased constant Text_Type :=
        "P_All_Parts";
      Member_Desc_For_Basic_Decl_P_All_Parts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_All_Parts'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Basic_Decl_Array,
         Arguments     => (
               17 => (Name          => Arg_Name_17'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_18 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_Is_Static_Decl : aliased constant Text_Type :=
        "P_Is_Static_Decl";
      Member_Desc_For_Basic_Decl_P_Is_Static_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_Is_Static_Decl'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               18 => (Name          => Arg_Name_18'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_19 : aliased constant Text_Type :=
           "Name";
         

      Member_Name_For_Basic_Decl_P_Get_Aspect_Assoc : aliased constant Text_Type :=
        "P_Get_Aspect_Assoc";
      Member_Desc_For_Basic_Decl_P_Get_Aspect_Assoc : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_Get_Aspect_Assoc'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Aspect_Assoc,
         Arguments     => (
               19 => (Name          => Arg_Name_19'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None))
        ));

      

         Arg_Name_20 : aliased constant Text_Type :=
           "Name";
         

      Member_Name_For_Basic_Decl_P_Get_Aspect_Spec_Expr : aliased constant Text_Type :=
        "P_Get_Aspect_Spec_Expr";
      Member_Desc_For_Basic_Decl_P_Get_Aspect_Spec_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_Get_Aspect_Spec_Expr'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Expr,
         Arguments     => (
               20 => (Name          => Arg_Name_20'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None))
        ));

      

         Arg_Name_21 : aliased constant Text_Type :=
           "Name";
         
         Arg_Name_22 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_Get_Aspect : aliased constant Text_Type :=
        "P_Get_Aspect";
      Member_Desc_For_Basic_Decl_P_Get_Aspect : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Basic_Decl_P_Get_Aspect'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Aspect,
         Arguments     => (
               21 => (Name          => Arg_Name_21'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None)),
22 => (Name          => Arg_Name_22'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_23 : aliased constant Text_Type :=
           "Name";
         
         Arg_Name_24 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_Has_Aspect : aliased constant Text_Type :=
        "P_Has_Aspect";
      Member_Desc_For_Basic_Decl_P_Has_Aspect : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Basic_Decl_P_Has_Aspect'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               23 => (Name          => Arg_Name_23'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None)),
24 => (Name          => Arg_Name_24'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_25 : aliased constant Text_Type :=
           "Name";
         

      Member_Name_For_Basic_Decl_P_Get_Pragma : aliased constant Text_Type :=
        "P_Get_Pragma";
      Member_Desc_For_Basic_Decl_P_Get_Pragma : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_Get_Pragma'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Pragma,
         Arguments     => (
               25 => (Name          => Arg_Name_25'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None))
        ));

      

         Arg_Name_26 : aliased constant Text_Type :=
           "Name";
         
         Arg_Name_27 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_Get_Representation_Clause : aliased constant Text_Type :=
        "P_Get_Representation_Clause";
      Member_Desc_For_Basic_Decl_P_Get_Representation_Clause : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Basic_Decl_P_Get_Representation_Clause'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Attribute_Def_Clause,
         Arguments     => (
               26 => (Name          => Arg_Name_26'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None)),
27 => (Name          => Arg_Name_27'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_28 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_Get_At_Clause : aliased constant Text_Type :=
        "P_Get_At_Clause";
      Member_Desc_For_Basic_Decl_P_Get_At_Clause : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_Get_At_Clause'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_At_Clause,
         Arguments     => (
               28 => (Name          => Arg_Name_28'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Basic_Decl_P_Is_Imported : aliased constant Text_Type :=
        "P_Is_Imported";
      Member_Desc_For_Basic_Decl_P_Is_Imported : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Is_Imported'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Basic_Decl_P_Is_Ghost_Code : aliased constant Text_Type :=
        "P_Is_Ghost_Code";
      Member_Desc_For_Basic_Decl_P_Is_Ghost_Code : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Is_Ghost_Code'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Basic_Decl_P_Is_Compilation_Unit_Root : aliased constant Text_Type :=
        "P_Is_Compilation_Unit_Root";
      Member_Desc_For_Basic_Decl_P_Is_Compilation_Unit_Root : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Is_Compilation_Unit_Root'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_29 : aliased constant Text_Type :=
           "From_Node";
         

      Member_Name_For_Basic_Decl_P_Is_Visible : aliased constant Text_Type :=
        "P_Is_Visible";
      Member_Desc_For_Basic_Decl_P_Is_Visible : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_Is_Visible'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               29 => (Name          => Arg_Name_29'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => None))
        ));

      

         Arg_Name_30 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_Base_Subp_Declarations : aliased constant Text_Type :=
        "P_Base_Subp_Declarations";
      Member_Desc_For_Basic_Decl_P_Base_Subp_Declarations : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_Base_Subp_Declarations'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Basic_Decl_Array,
         Arguments     => (
               30 => (Name          => Arg_Name_30'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_31 : aliased constant Text_Type :=
           "Origin";
         
         Arg_Name_32 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_Root_Subp_Declarations : aliased constant Text_Type :=
        "P_Root_Subp_Declarations";
      Member_Desc_For_Basic_Decl_P_Root_Subp_Declarations : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Basic_Decl_P_Root_Subp_Declarations'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Basic_Decl_Array,
         Arguments     => (
               31 => (Name          => Arg_Name_31'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value)),
32 => (Name          => Arg_Name_32'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_33 : aliased constant Text_Type :=
           "Units";
         
         Arg_Name_34 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_Find_All_Overrides : aliased constant Text_Type :=
        "P_Find_All_Overrides";
      Member_Desc_For_Basic_Decl_P_Find_All_Overrides : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Basic_Decl_P_Find_All_Overrides'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Basic_Decl_Array,
         Arguments     => (
               33 => (Name          => Arg_Name_33'Access,  Argument_Type => Type_Index_For_Analysis_Unit_Array,  Default_Value => (Kind => None)),
34 => (Name          => Arg_Name_34'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Basic_Decl_P_Defining_Names : aliased constant Text_Type :=
        "P_Defining_Names";
      Member_Desc_For_Basic_Decl_P_Defining_Names : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Defining_Names'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Defining_Name_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Basic_Decl_P_Defining_Name : aliased constant Text_Type :=
        "P_Defining_Name";
      Member_Desc_For_Basic_Decl_P_Defining_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Defining_Name'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Basic_Decl_P_Type_Expression : aliased constant Text_Type :=
        "P_Type_Expression";
      Member_Desc_For_Basic_Decl_P_Type_Expression : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Type_Expression'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Type_Expr,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_35 : aliased constant Text_Type :=
           "Follow_Generic";
         

      Member_Name_For_Basic_Decl_P_Subp_Spec_Or_Null : aliased constant Text_Type :=
        "P_Subp_Spec_Or_Null";
      Member_Desc_For_Basic_Decl_P_Subp_Spec_Or_Null : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_Subp_Spec_Or_Null'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Base_Subp_Spec,
         Arguments     => (
               35 => (Name          => Arg_Name_35'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => True))
        ));

      


      Member_Name_For_Basic_Decl_P_Is_Subprogram : aliased constant Text_Type :=
        "P_Is_Subprogram";
      Member_Desc_For_Basic_Decl_P_Is_Subprogram : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Is_Subprogram'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Basic_Decl_P_Relative_Name : aliased constant Text_Type :=
        "P_Relative_Name";
      Member_Desc_For_Basic_Decl_P_Relative_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Relative_Name'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Single_Tok_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Basic_Decl_P_Relative_Name_Text : aliased constant Text_Type :=
        "P_Relative_Name_Text";
      Member_Desc_For_Basic_Decl_P_Relative_Name_Text : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Relative_Name_Text'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Symbol,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_36 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_Next_Part_For_Decl : aliased constant Text_Type :=
        "P_Next_Part_For_Decl";
      Member_Desc_For_Basic_Decl_P_Next_Part_For_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_Next_Part_For_Decl'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               36 => (Name          => Arg_Name_36'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_37 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_Body_Part_For_Decl : aliased constant Text_Type :=
        "P_Body_Part_For_Decl";
      Member_Desc_For_Basic_Decl_P_Body_Part_For_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_Body_Part_For_Decl'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Body,
         Arguments     => (
               37 => (Name          => Arg_Name_37'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_38 : aliased constant Text_Type :=
           "Origin";
         
         Arg_Name_39 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Basic_Decl_P_Most_Visible_Part : aliased constant Text_Type :=
        "P_Most_Visible_Part";
      Member_Desc_For_Basic_Decl_P_Most_Visible_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Basic_Decl_P_Most_Visible_Part'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               38 => (Name          => Arg_Name_38'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => None)),
39 => (Name          => Arg_Name_39'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_40 : aliased constant Text_Type :=
           "Include_Profile";
         

      Member_Name_For_Basic_Decl_P_Fully_Qualified_Name_Array : aliased constant Text_Type :=
        "P_Fully_Qualified_Name_Array";
      Member_Desc_For_Basic_Decl_P_Fully_Qualified_Name_Array : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Basic_Decl_P_Fully_Qualified_Name_Array'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Symbol_Array,
         Arguments     => (
               40 => (Name          => Arg_Name_40'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Basic_Decl_P_Fully_Qualified_Name : aliased constant Text_Type :=
        "P_Fully_Qualified_Name";
      Member_Desc_For_Basic_Decl_P_Fully_Qualified_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Fully_Qualified_Name'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_String,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Basic_Decl_P_Canonical_Fully_Qualified_Name : aliased constant Text_Type :=
        "P_Canonical_Fully_Qualified_Name";
      Member_Desc_For_Basic_Decl_P_Canonical_Fully_Qualified_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Canonical_Fully_Qualified_Name'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_String,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Basic_Decl_P_Unique_Identifying_Name : aliased constant Text_Type :=
        "P_Unique_Identifying_Name";
      Member_Desc_For_Basic_Decl_P_Unique_Identifying_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Unique_Identifying_Name'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_String,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Basic_Decl_P_Is_Constant_Object : aliased constant Text_Type :=
        "P_Is_Constant_Object";
      Member_Desc_For_Basic_Decl_P_Is_Constant_Object : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Decl_P_Is_Constant_Object'Access,
         Owner         => Type_Index_For_Basic_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_41 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Anonymous_Expr_Decl_P_Get_Formal : aliased constant Text_Type :=
        "P_Get_Formal";
      Member_Desc_For_Anonymous_Expr_Decl_P_Get_Formal : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Anonymous_Expr_Decl_P_Get_Formal'Access,
         Owner         => Type_Index_For_Anonymous_Expr_Decl,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               41 => (Name          => Arg_Name_41'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_42 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Formal_Param_Decl_P_Formal_Type : aliased constant Text_Type :=
        "P_Formal_Type";
      Member_Desc_For_Base_Formal_Param_Decl_P_Formal_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Formal_Param_Decl_P_Formal_Type'Access,
         Owner         => Type_Index_For_Base_Formal_Param_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               42 => (Name          => Arg_Name_42'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      


      Member_Name_For_Base_Package_Decl_P_Body_Part : aliased constant Text_Type :=
        "P_Body_Part";
      Member_Desc_For_Base_Package_Decl_P_Body_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Package_Decl_P_Body_Part'Access,
         Owner         => Type_Index_For_Base_Package_Decl,
         Member_Type   => Type_Index_For_Package_Body,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_43 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Base_Subtype : aliased constant Text_Type :=
        "P_Base_Subtype";
      Member_Desc_For_Base_Type_Decl_P_Base_Subtype : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Base_Subtype'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               43 => (Name          => Arg_Name_43'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      


      Member_Name_For_Base_Type_Decl_P_Private_Completion : aliased constant Text_Type :=
        "P_Private_Completion";
      Member_Desc_For_Base_Type_Decl_P_Private_Completion : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Type_Decl_P_Private_Completion'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_44 : aliased constant Text_Type :=
           "P";
         

      Member_Name_For_Base_Type_Decl_P_Is_Inherited_Primitive : aliased constant Text_Type :=
        "P_Is_Inherited_Primitive";
      Member_Desc_For_Base_Type_Decl_P_Is_Inherited_Primitive : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Inherited_Primitive'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               44 => (Name          => Arg_Name_44'Access,  Argument_Type => Type_Index_For_Basic_Decl,  Default_Value => (Kind => None))
        ));

      

         Arg_Name_45 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Base_Type_Decl_P_Get_Record_Representation_Clause : aliased constant Text_Type :=
        "P_Get_Record_Representation_Clause";
      Member_Desc_For_Base_Type_Decl_P_Get_Record_Representation_Clause : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Get_Record_Representation_Clause'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Record_Rep_Clause,
         Arguments     => (
               45 => (Name          => Arg_Name_45'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_46 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Base_Type_Decl_P_Get_Enum_Representation_Clause : aliased constant Text_Type :=
        "P_Get_Enum_Representation_Clause";
      Member_Desc_For_Base_Type_Decl_P_Get_Enum_Representation_Clause : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Get_Enum_Representation_Clause'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Enum_Rep_Clause,
         Arguments     => (
               46 => (Name          => Arg_Name_46'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_47 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Record_Type : aliased constant Text_Type :=
        "P_Is_Record_Type";
      Member_Desc_For_Base_Type_Decl_P_Is_Record_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Record_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               47 => (Name          => Arg_Name_47'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_48 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Array_Type : aliased constant Text_Type :=
        "P_Is_Array_Type";
      Member_Desc_For_Base_Type_Decl_P_Is_Array_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Array_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               48 => (Name          => Arg_Name_48'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_49 : aliased constant Text_Type :=
           "Root";
         
         Arg_Name_50 : aliased constant Text_Type :=
           "Origin";
         
         Arg_Name_51 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Base_Type_Decl_P_Find_Derived_Types : aliased constant Text_Type :=
        "P_Find_Derived_Types";
      Member_Desc_For_Base_Type_Decl_P_Find_Derived_Types : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 3,
         Name          => Member_Name_For_Base_Type_Decl_P_Find_Derived_Types'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Type_Decl_Array,
         Arguments     => (
               49 => (Name          => Arg_Name_49'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => None)),
50 => (Name          => Arg_Name_50'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => None)),
51 => (Name          => Arg_Name_51'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_52 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Real_Type : aliased constant Text_Type :=
        "P_Is_Real_Type";
      Member_Desc_For_Base_Type_Decl_P_Is_Real_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Real_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               52 => (Name          => Arg_Name_52'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_53 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Float_Type : aliased constant Text_Type :=
        "P_Is_Float_Type";
      Member_Desc_For_Base_Type_Decl_P_Is_Float_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Float_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               53 => (Name          => Arg_Name_53'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_54 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Fixed_Point : aliased constant Text_Type :=
        "P_Is_Fixed_Point";
      Member_Desc_For_Base_Type_Decl_P_Is_Fixed_Point : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Fixed_Point'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               54 => (Name          => Arg_Name_54'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_55 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Enum_Type : aliased constant Text_Type :=
        "P_Is_Enum_Type";
      Member_Desc_For_Base_Type_Decl_P_Is_Enum_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Enum_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               55 => (Name          => Arg_Name_55'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_56 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Access_Type : aliased constant Text_Type :=
        "P_Is_Access_Type";
      Member_Desc_For_Base_Type_Decl_P_Is_Access_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Access_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               56 => (Name          => Arg_Name_56'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_57 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Char_Type : aliased constant Text_Type :=
        "P_Is_Char_Type";
      Member_Desc_For_Base_Type_Decl_P_Is_Char_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Char_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               57 => (Name          => Arg_Name_57'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      


      Member_Name_For_Base_Type_Decl_P_Discrete_Range : aliased constant Text_Type :=
        "P_Discrete_Range";
      Member_Desc_For_Base_Type_Decl_P_Discrete_Range : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Type_Decl_P_Discrete_Range'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Discrete_Range,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_58 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Discrete_Type : aliased constant Text_Type :=
        "P_Is_Discrete_Type";
      Member_Desc_For_Base_Type_Decl_P_Is_Discrete_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Discrete_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               58 => (Name          => Arg_Name_58'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_59 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Int_Type : aliased constant Text_Type :=
        "P_Is_Int_Type";
      Member_Desc_For_Base_Type_Decl_P_Is_Int_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Int_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               59 => (Name          => Arg_Name_59'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_60 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Accessed_Type : aliased constant Text_Type :=
        "P_Accessed_Type";
      Member_Desc_For_Base_Type_Decl_P_Accessed_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Accessed_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               60 => (Name          => Arg_Name_60'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_61 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Tagged_Type : aliased constant Text_Type :=
        "P_Is_Tagged_Type";
      Member_Desc_For_Base_Type_Decl_P_Is_Tagged_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Tagged_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               61 => (Name          => Arg_Name_61'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_62 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Base_Type : aliased constant Text_Type :=
        "P_Base_Type";
      Member_Desc_For_Base_Type_Decl_P_Base_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Base_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               62 => (Name          => Arg_Name_62'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_63 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Base_Types : aliased constant Text_Type :=
        "P_Base_Types";
      Member_Desc_For_Base_Type_Decl_P_Base_Types : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Base_Types'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl_Array,
         Arguments     => (
               63 => (Name          => Arg_Name_63'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_64 : aliased constant Text_Type :=
           "Units";
         
         Arg_Name_65 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Base_Type_Decl_P_Find_All_Derived_Types : aliased constant Text_Type :=
        "P_Find_All_Derived_Types";
      Member_Desc_For_Base_Type_Decl_P_Find_All_Derived_Types : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Base_Type_Decl_P_Find_All_Derived_Types'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Type_Decl_Array,
         Arguments     => (
               64 => (Name          => Arg_Name_64'Access,  Argument_Type => Type_Index_For_Analysis_Unit_Array,  Default_Value => (Kind => None)),
65 => (Name          => Arg_Name_65'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_66 : aliased constant Text_Type :=
           "Is_Subscript";
         
         Arg_Name_67 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Comp_Type : aliased constant Text_Type :=
        "P_Comp_Type";
      Member_Desc_For_Base_Type_Decl_P_Comp_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Base_Type_Decl_P_Comp_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               66 => (Name          => Arg_Name_66'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False)),
67 => (Name          => Arg_Name_67'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_68 : aliased constant Text_Type :=
           "Dim";
         
         Arg_Name_69 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Index_Type : aliased constant Text_Type :=
        "P_Index_Type";
      Member_Desc_For_Base_Type_Decl_P_Index_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Base_Type_Decl_P_Index_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               68 => (Name          => Arg_Name_68'Access,  Argument_Type => Type_Index_For_Int,  Default_Value => (Kind => None)),
69 => (Name          => Arg_Name_69'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_70 : aliased constant Text_Type :=
           "Other_Type";
         
         Arg_Name_71 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Derived_Type : aliased constant Text_Type :=
        "P_Is_Derived_Type";
      Member_Desc_For_Base_Type_Decl_P_Is_Derived_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Derived_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               70 => (Name          => Arg_Name_70'Access,  Argument_Type => Type_Index_For_Base_Type_Decl,  Default_Value => (Kind => None)),
71 => (Name          => Arg_Name_71'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_72 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Interface_Type : aliased constant Text_Type :=
        "P_Is_Interface_Type";
      Member_Desc_For_Base_Type_Decl_P_Is_Interface_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Interface_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               72 => (Name          => Arg_Name_72'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_73 : aliased constant Text_Type :=
           "Expected_Type";
         
         Arg_Name_74 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Matching_Type : aliased constant Text_Type :=
        "P_Matching_Type";
      Member_Desc_For_Base_Type_Decl_P_Matching_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Base_Type_Decl_P_Matching_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               73 => (Name          => Arg_Name_73'Access,  Argument_Type => Type_Index_For_Base_Type_Decl,  Default_Value => (Kind => None)),
74 => (Name          => Arg_Name_74'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_75 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Canonical_Type : aliased constant Text_Type :=
        "P_Canonical_Type";
      Member_Desc_For_Base_Type_Decl_P_Canonical_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Canonical_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               75 => (Name          => Arg_Name_75'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_76 : aliased constant Text_Type :=
           "Go_To_Incomplete";
         

      Member_Name_For_Base_Type_Decl_P_Previous_Part : aliased constant Text_Type :=
        "P_Previous_Part";
      Member_Desc_For_Base_Type_Decl_P_Previous_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Previous_Part'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               76 => (Name          => Arg_Name_76'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => True))
        ));

      


      Member_Name_For_Base_Type_Decl_P_Next_Part : aliased constant Text_Type :=
        "P_Next_Part";
      Member_Desc_For_Base_Type_Decl_P_Next_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Type_Decl_P_Next_Part'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Type_Decl_P_Full_View : aliased constant Text_Type :=
        "P_Full_View";
      Member_Desc_For_Base_Type_Decl_P_Full_View : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Type_Decl_P_Full_View'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_77 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Is_Definite_Subtype : aliased constant Text_Type :=
        "P_Is_Definite_Subtype";
      Member_Desc_For_Base_Type_Decl_P_Is_Definite_Subtype : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Definite_Subtype'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               77 => (Name          => Arg_Name_77'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      


      Member_Name_For_Base_Type_Decl_P_Is_Private : aliased constant Text_Type :=
        "P_Is_Private";
      Member_Desc_For_Base_Type_Decl_P_Is_Private : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Type_Decl_P_Is_Private'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_78 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Discriminants_List : aliased constant Text_Type :=
        "P_Discriminants_List";
      Member_Desc_For_Base_Type_Decl_P_Discriminants_List : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Discriminants_List'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Base_Formal_Param_Decl_Array,
         Arguments     => (
               78 => (Name          => Arg_Name_78'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_79 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Root_Type : aliased constant Text_Type :=
        "P_Root_Type";
      Member_Desc_For_Base_Type_Decl_P_Root_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Type_Decl_P_Root_Type'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               79 => (Name          => Arg_Name_79'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_80 : aliased constant Text_Type :=
           "Include_Discriminants";
         
         Arg_Name_81 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Type_Decl_P_Shapes : aliased constant Text_Type :=
        "P_Shapes";
      Member_Desc_For_Base_Type_Decl_P_Shapes : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Base_Type_Decl_P_Shapes'Access,
         Owner         => Type_Index_For_Base_Type_Decl,
         Member_Type   => Type_Index_For_Shape_Array,
         Arguments     => (
               80 => (Name          => Arg_Name_80'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => True)),
81 => (Name          => Arg_Name_81'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_82 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Base_Subtype_Decl_P_Get_Type : aliased constant Text_Type :=
        "P_Get_Type";
      Member_Desc_For_Base_Subtype_Decl_P_Get_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Base_Subtype_Decl_P_Get_Type'Access,
         Owner         => Type_Index_For_Base_Subtype_Decl,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               82 => (Name          => Arg_Name_82'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      

         Arg_Name_83 : aliased constant Text_Type :=
           "Only_Inherited";
         
         Arg_Name_84 : aliased constant Text_Type :=
           "Include_Predefined_Operators";
         

      Member_Name_For_Type_Decl_P_Get_Primitives : aliased constant Text_Type :=
        "P_Get_Primitives";
      Member_Desc_For_Type_Decl_P_Get_Primitives : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Type_Decl_P_Get_Primitives'Access,
         Owner         => Type_Index_For_Type_Decl,
         Member_Type   => Type_Index_For_Basic_Decl_Array,
         Arguments     => (
               83 => (Name          => Arg_Name_83'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False)),
84 => (Name          => Arg_Name_84'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Basic_Subp_Decl_P_Subp_Decl_Spec : aliased constant Text_Type :=
        "P_Subp_Decl_Spec";
      Member_Desc_For_Basic_Subp_Decl_P_Subp_Decl_Spec : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Basic_Subp_Decl_P_Subp_Decl_Spec'Access,
         Owner         => Type_Index_For_Basic_Subp_Decl,
         Member_Type   => Type_Index_For_Base_Subp_Spec,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_85 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Classic_Subp_Decl_P_Body_Part : aliased constant Text_Type :=
        "P_Body_Part";
      Member_Desc_For_Classic_Subp_Decl_P_Body_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Classic_Subp_Decl_P_Body_Part'Access,
         Owner         => Type_Index_For_Classic_Subp_Decl,
         Member_Type   => Type_Index_For_Base_Subp_Body,
         Arguments     => (
               85 => (Name          => Arg_Name_85'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_86 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Entry_Decl_P_Body_Part : aliased constant Text_Type :=
        "P_Body_Part";
      Member_Desc_For_Entry_Decl_P_Body_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Entry_Decl_P_Body_Part'Access,
         Owner         => Type_Index_For_Entry_Decl,
         Member_Type   => Type_Index_For_Entry_Body,
         Arguments     => (
               86 => (Name          => Arg_Name_86'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Entry_Decl_P_Accept_Stmts : aliased constant Text_Type :=
        "P_Accept_Stmts";
      Member_Desc_For_Entry_Decl_P_Accept_Stmts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Entry_Decl_P_Accept_Stmts'Access,
         Owner         => Type_Index_For_Entry_Decl,
         Member_Type   => Type_Index_For_Accept_Stmt_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Enum_Literal_Decl_P_Enum_Type : aliased constant Text_Type :=
        "P_Enum_Type";
      Member_Desc_For_Enum_Literal_Decl_P_Enum_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Enum_Literal_Decl_P_Enum_Type'Access,
         Owner         => Type_Index_For_Enum_Literal_Decl,
         Member_Type   => Type_Index_For_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Synthetic_Char_Enum_Lit_P_Expr : aliased constant Text_Type :=
        "P_Expr";
      Member_Desc_For_Synthetic_Char_Enum_Lit_P_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Synthetic_Char_Enum_Lit_P_Expr'Access,
         Owner         => Type_Index_For_Synthetic_Char_Enum_Lit,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_87 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Body_Node_P_Previous_Part : aliased constant Text_Type :=
        "P_Previous_Part";
      Member_Desc_For_Body_Node_P_Previous_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Body_Node_P_Previous_Part'Access,
         Owner         => Type_Index_For_Body,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               87 => (Name          => Arg_Name_87'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_88 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Body_Node_P_Decl_Part : aliased constant Text_Type :=
        "P_Decl_Part";
      Member_Desc_For_Body_Node_P_Decl_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Body_Node_P_Decl_Part'Access,
         Owner         => Type_Index_For_Body,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               88 => (Name          => Arg_Name_88'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Body_Node_P_Subunit_Root : aliased constant Text_Type :=
        "P_Subunit_Root";
      Member_Desc_For_Body_Node_P_Subunit_Root : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Body_Node_P_Subunit_Root'Access,
         Owner         => Type_Index_For_Body,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Body_Stub_P_Syntactic_Fully_Qualified_Name : aliased constant Text_Type :=
        "P_Syntactic_Fully_Qualified_Name";
      Member_Desc_For_Body_Stub_P_Syntactic_Fully_Qualified_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Body_Stub_P_Syntactic_Fully_Qualified_Name'Access,
         Owner         => Type_Index_For_Body_Stub,
         Member_Type   => Type_Index_For_Symbol_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Package_Decl_P_Body_Part : aliased constant Text_Type :=
        "P_Body_Part";
      Member_Desc_For_Generic_Package_Decl_P_Body_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Package_Decl_P_Body_Part'Access,
         Owner         => Type_Index_For_Generic_Package_Decl,
         Member_Type   => Type_Index_For_Package_Body,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_89 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Generic_Subp_Decl_P_Body_Part : aliased constant Text_Type :=
        "P_Body_Part";
      Member_Desc_For_Generic_Subp_Decl_P_Body_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Generic_Subp_Decl_P_Body_Part'Access,
         Owner         => Type_Index_For_Generic_Subp_Decl,
         Member_Type   => Type_Index_For_Base_Subp_Body,
         Arguments     => (
               89 => (Name          => Arg_Name_89'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Generic_Instantiation_P_Designated_Generic_Decl : aliased constant Text_Type :=
        "P_Designated_Generic_Decl";
      Member_Desc_For_Generic_Instantiation_P_Designated_Generic_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Instantiation_P_Designated_Generic_Decl'Access,
         Owner         => Type_Index_For_Generic_Instantiation,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Instantiation_P_Inst_Params : aliased constant Text_Type :=
        "P_Inst_Params";
      Member_Desc_For_Generic_Instantiation_P_Inst_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Instantiation_P_Inst_Params'Access,
         Owner         => Type_Index_For_Generic_Instantiation,
         Member_Type   => Type_Index_For_Param_Actual_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Generic_Subp_Instantiation_P_Designated_Subp : aliased constant Text_Type :=
        "P_Designated_Subp";
      Member_Desc_For_Generic_Subp_Instantiation_P_Designated_Subp : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Generic_Subp_Instantiation_P_Designated_Subp'Access,
         Owner         => Type_Index_For_Generic_Subp_Instantiation,
         Member_Type   => Type_Index_For_Basic_Subp_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Object_Decl_P_Private_Part_Decl : aliased constant Text_Type :=
        "P_Private_Part_Decl";
      Member_Desc_For_Object_Decl_P_Private_Part_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Object_Decl_P_Private_Part_Decl'Access,
         Owner         => Type_Index_For_Object_Decl,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Object_Decl_P_Public_Part_Decl : aliased constant Text_Type :=
        "P_Public_Part_Decl";
      Member_Desc_For_Object_Decl_P_Public_Part_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Object_Decl_P_Public_Part_Decl'Access,
         Owner         => Type_Index_For_Object_Decl,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Package_Renaming_Decl_P_Renamed_Package : aliased constant Text_Type :=
        "P_Renamed_Package";
      Member_Desc_For_Package_Renaming_Decl_P_Renamed_Package : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Package_Renaming_Decl_P_Renamed_Package'Access,
         Owner         => Type_Index_For_Package_Renaming_Decl,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Package_Renaming_Decl_P_Final_Renamed_Package : aliased constant Text_Type :=
        "P_Final_Renamed_Package";
      Member_Desc_For_Package_Renaming_Decl_P_Final_Renamed_Package : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Package_Renaming_Decl_P_Final_Renamed_Package'Access,
         Owner         => Type_Index_For_Package_Renaming_Decl,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Compilation_Unit_P_Syntactic_Fully_Qualified_Name : aliased constant Text_Type :=
        "P_Syntactic_Fully_Qualified_Name";
      Member_Desc_For_Compilation_Unit_P_Syntactic_Fully_Qualified_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Compilation_Unit_P_Syntactic_Fully_Qualified_Name'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Symbol_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Compilation_Unit_P_Unit_Kind : aliased constant Text_Type :=
        "P_Unit_Kind";
      Member_Desc_For_Compilation_Unit_P_Unit_Kind : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Compilation_Unit_P_Unit_Kind'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Analysis_Unit_Kind,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Compilation_Unit_P_Withed_Units : aliased constant Text_Type :=
        "P_Withed_Units";
      Member_Desc_For_Compilation_Unit_P_Withed_Units : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Compilation_Unit_P_Withed_Units'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Compilation_Unit_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Compilation_Unit_P_Imported_Units : aliased constant Text_Type :=
        "P_Imported_Units";
      Member_Desc_For_Compilation_Unit_P_Imported_Units : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Compilation_Unit_P_Imported_Units'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Compilation_Unit_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Compilation_Unit_P_Unit_Dependencies : aliased constant Text_Type :=
        "P_Unit_Dependencies";
      Member_Desc_For_Compilation_Unit_P_Unit_Dependencies : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Compilation_Unit_P_Unit_Dependencies'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Compilation_Unit_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Compilation_Unit_P_Decl : aliased constant Text_Type :=
        "P_Decl";
      Member_Desc_For_Compilation_Unit_P_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Compilation_Unit_P_Decl'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_90 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Compilation_Unit_P_Is_Preelaborable : aliased constant Text_Type :=
        "P_Is_Preelaborable";
      Member_Desc_For_Compilation_Unit_P_Is_Preelaborable : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Compilation_Unit_P_Is_Preelaborable'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               90 => (Name          => Arg_Name_90'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Compilation_Unit_P_Other_Part : aliased constant Text_Type :=
        "P_Other_Part";
      Member_Desc_For_Compilation_Unit_P_Other_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Compilation_Unit_P_Other_Part'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Compilation_Unit,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_91 : aliased constant Text_Type :=
           "Name";
         

      Member_Name_For_Compilation_Unit_P_Has_Restriction : aliased constant Text_Type :=
        "P_Has_Restriction";
      Member_Desc_For_Compilation_Unit_P_Has_Restriction : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Compilation_Unit_P_Has_Restriction'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               91 => (Name          => Arg_Name_91'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None))
        ));

      


      Member_Name_For_Compilation_Unit_P_All_Config_Pragmas : aliased constant Text_Type :=
        "P_All_Config_Pragmas";
      Member_Desc_For_Compilation_Unit_P_All_Config_Pragmas : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Compilation_Unit_P_All_Config_Pragmas'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Pragma_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_92 : aliased constant Text_Type :=
           "Name";
         

      Member_Name_For_Compilation_Unit_P_Config_Pragmas : aliased constant Text_Type :=
        "P_Config_Pragmas";
      Member_Desc_For_Compilation_Unit_P_Config_Pragmas : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Compilation_Unit_P_Config_Pragmas'Access,
         Owner         => Type_Index_For_Compilation_Unit,
         Member_Type   => Type_Index_For_Pragma_Array,
         Arguments     => (
               92 => (Name          => Arg_Name_92'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None))
        ));

      


      Member_Name_For_Constant_Node_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_Constant_Node_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Constant_Node_P_As_Bool'Access,
         Owner         => Type_Index_For_Constant,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Composite_Constraint_P_Is_Index_Constraint : aliased constant Text_Type :=
        "P_Is_Index_Constraint";
      Member_Desc_For_Composite_Constraint_P_Is_Index_Constraint : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Composite_Constraint_P_Is_Index_Constraint'Access,
         Owner         => Type_Index_For_Composite_Constraint,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Composite_Constraint_P_Is_Discriminant_Constraint : aliased constant Text_Type :=
        "P_Is_Discriminant_Constraint";
      Member_Desc_For_Composite_Constraint_P_Is_Discriminant_Constraint : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Composite_Constraint_P_Is_Discriminant_Constraint'Access,
         Owner         => Type_Index_For_Composite_Constraint,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Expr_P_Expression_Type : aliased constant Text_Type :=
        "P_Expression_Type";
      Member_Desc_For_Expr_P_Expression_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Expr_P_Expression_Type'Access,
         Owner         => Type_Index_For_Expr,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Expr_P_Expected_Expression_Type : aliased constant Text_Type :=
        "P_Expected_Expression_Type";
      Member_Desc_For_Expr_P_Expected_Expression_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Expr_P_Expected_Expression_Type'Access,
         Owner         => Type_Index_For_Expr,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_93 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Expr_P_Is_Dynamically_Tagged : aliased constant Text_Type :=
        "P_Is_Dynamically_Tagged";
      Member_Desc_For_Expr_P_Is_Dynamically_Tagged : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Expr_P_Is_Dynamically_Tagged'Access,
         Owner         => Type_Index_For_Expr,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               93 => (Name          => Arg_Name_93'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_94 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Expr_P_Is_Dispatching_Call : aliased constant Text_Type :=
        "P_Is_Dispatching_Call";
      Member_Desc_For_Expr_P_Is_Dispatching_Call : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Expr_P_Is_Dispatching_Call'Access,
         Owner         => Type_Index_For_Expr,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               94 => (Name          => Arg_Name_94'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_95 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Expr_P_Is_Static_Expr : aliased constant Text_Type :=
        "P_Is_Static_Expr";
      Member_Desc_For_Expr_P_Is_Static_Expr : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Expr_P_Is_Static_Expr'Access,
         Owner         => Type_Index_For_Expr,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               95 => (Name          => Arg_Name_95'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Expr_P_First_Corresponding_Decl : aliased constant Text_Type :=
        "P_First_Corresponding_Decl";
      Member_Desc_For_Expr_P_First_Corresponding_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Expr_P_First_Corresponding_Decl'Access,
         Owner         => Type_Index_For_Expr,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Expr_P_Eval_As_Int : aliased constant Text_Type :=
        "P_Eval_As_Int";
      Member_Desc_For_Expr_P_Eval_As_Int : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Expr_P_Eval_As_Int'Access,
         Owner         => Type_Index_For_Expr,
         Member_Type   => Type_Index_For_Big_Int,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_96 : aliased constant Text_Type :=
           "Env";
         

      Member_Name_For_Expr_P_Eval_As_Int_In_Env : aliased constant Text_Type :=
        "P_Eval_As_Int_In_Env";
      Member_Desc_For_Expr_P_Eval_As_Int_In_Env : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Expr_P_Eval_As_Int_In_Env'Access,
         Owner         => Type_Index_For_Expr,
         Member_Type   => Type_Index_For_Big_Int,
         Arguments     => (
               96 => (Name          => Arg_Name_96'Access,  Argument_Type => Type_Index_For_Substitution_Array,  Default_Value => (Kind => None))
        ));

      


      Member_Name_For_Expr_P_Eval_As_String : aliased constant Text_Type :=
        "P_Eval_As_String";
      Member_Desc_For_Expr_P_Eval_As_String : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Expr_P_Eval_As_String'Access,
         Owner         => Type_Index_For_Expr,
         Member_Type   => Type_Index_For_String,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_97 : aliased constant Text_Type :=
           "Env";
         

      Member_Name_For_Expr_P_Eval_As_String_In_Env : aliased constant Text_Type :=
        "P_Eval_As_String_In_Env";
      Member_Desc_For_Expr_P_Eval_As_String_In_Env : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Expr_P_Eval_As_String_In_Env'Access,
         Owner         => Type_Index_For_Expr,
         Member_Type   => Type_Index_For_String,
         Arguments     => (
               97 => (Name          => Arg_Name_97'Access,  Argument_Type => Type_Index_For_Substitution_Array,  Default_Value => (Kind => None))
        ));

      


      Member_Name_For_Expr_P_Matching_Nodes : aliased constant Text_Type :=
        "P_Matching_Nodes";
      Member_Desc_For_Expr_P_Matching_Nodes : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Expr_P_Matching_Nodes'Access,
         Owner         => Type_Index_For_Expr,
         Member_Type   => Type_Index_For_Ada_Node_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Allocator_P_Get_Allocated_Type : aliased constant Text_Type :=
        "P_Get_Allocated_Type";
      Member_Desc_For_Allocator_P_Get_Allocated_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Allocator_P_Get_Allocated_Type'Access,
         Owner         => Type_Index_For_Allocator,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Aggregate_P_Aggregate_Params : aliased constant Text_Type :=
        "P_Aggregate_Params";
      Member_Desc_For_Base_Aggregate_P_Aggregate_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Aggregate_P_Aggregate_Params'Access,
         Owner         => Type_Index_For_Base_Aggregate,
         Member_Type   => Type_Index_For_Param_Actual_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Base_Aggregate_P_Is_Subaggregate : aliased constant Text_Type :=
        "P_Is_Subaggregate";
      Member_Desc_For_Base_Aggregate_P_Is_Subaggregate : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Base_Aggregate_P_Is_Subaggregate'Access,
         Owner         => Type_Index_For_Base_Aggregate,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Concat_Op_P_Operands : aliased constant Text_Type :=
        "P_Operands";
      Member_Desc_For_Concat_Op_P_Operands : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Concat_Op_P_Operands'Access,
         Owner         => Type_Index_For_Concat_Op,
         Member_Type   => Type_Index_For_Expr_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Cond_Expr_P_Dependent_Exprs : aliased constant Text_Type :=
        "P_Dependent_Exprs";
      Member_Desc_For_Cond_Expr_P_Dependent_Exprs : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Cond_Expr_P_Dependent_Exprs'Access,
         Owner         => Type_Index_For_Cond_Expr,
         Member_Type   => Type_Index_For_Expr_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Name_P_Enclosing_Defining_Name : aliased constant Text_Type :=
        "P_Enclosing_Defining_Name";
      Member_Desc_For_Name_P_Enclosing_Defining_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Name_P_Enclosing_Defining_Name'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Name_P_Is_Defining : aliased constant Text_Type :=
        "P_Is_Defining";
      Member_Desc_For_Name_P_Is_Defining : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Name_P_Is_Defining'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_98 : aliased constant Text_Type :=
           "Sym";
         

      Member_Name_For_Name_P_Name_Is : aliased constant Text_Type :=
        "P_Name_Is";
      Member_Desc_For_Name_P_Name_Is : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Name_P_Name_Is'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               98 => (Name          => Arg_Name_98'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None))
        ));

      


      Member_Name_For_Name_P_Is_Direct_Call : aliased constant Text_Type :=
        "P_Is_Direct_Call";
      Member_Desc_For_Name_P_Is_Direct_Call : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Name_P_Is_Direct_Call'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Name_P_Is_Access_Call : aliased constant Text_Type :=
        "P_Is_Access_Call";
      Member_Desc_For_Name_P_Is_Access_Call : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Name_P_Is_Access_Call'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Name_P_Is_Call : aliased constant Text_Type :=
        "P_Is_Call";
      Member_Desc_For_Name_P_Is_Call : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Name_P_Is_Call'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_99 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Name_P_Is_Dot_Call : aliased constant Text_Type :=
        "P_Is_Dot_Call";
      Member_Desc_For_Name_P_Is_Dot_Call : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Name_P_Is_Dot_Call'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               99 => (Name          => Arg_Name_99'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_100 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Name_P_Failsafe_Referenced_Def_Name : aliased constant Text_Type :=
        "P_Failsafe_Referenced_Def_Name";
      Member_Desc_For_Name_P_Failsafe_Referenced_Def_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Name_P_Failsafe_Referenced_Def_Name'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Refd_Def,
         Arguments     => (
               100 => (Name          => Arg_Name_100'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_101 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Name_P_Referenced_Defining_Name : aliased constant Text_Type :=
        "P_Referenced_Defining_Name";
      Member_Desc_For_Name_P_Referenced_Defining_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Name_P_Referenced_Defining_Name'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               101 => (Name          => Arg_Name_101'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_102 : aliased constant Text_Type :=
           "Seq";
         
         Arg_Name_103 : aliased constant Text_Type :=
           "Seq_From";
         

      Member_Name_For_Name_P_All_Env_Elements : aliased constant Text_Type :=
        "P_All_Env_Elements";
      Member_Desc_For_Name_P_All_Env_Elements : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Name_P_All_Env_Elements'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Ada_Node_Array,
         Arguments     => (
               102 => (Name          => Arg_Name_102'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => True)),
103 => (Name          => Arg_Name_103'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      


      Member_Name_For_Name_P_Called_Subp_Spec : aliased constant Text_Type :=
        "P_Called_Subp_Spec";
      Member_Desc_For_Name_P_Called_Subp_Spec : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Name_P_Called_Subp_Spec'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Base_Formal_Param_Holder,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_104 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Name_P_Referenced_Decl : aliased constant Text_Type :=
        "P_Referenced_Decl";
      Member_Desc_For_Name_P_Referenced_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Name_P_Referenced_Decl'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               104 => (Name          => Arg_Name_104'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_105 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Name_P_Failsafe_Referenced_Decl : aliased constant Text_Type :=
        "P_Failsafe_Referenced_Decl";
      Member_Desc_For_Name_P_Failsafe_Referenced_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Name_P_Failsafe_Referenced_Decl'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Refd_Decl,
         Arguments     => (
               105 => (Name          => Arg_Name_105'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_106 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Name_P_Referenced_Decl_Internal : aliased constant Text_Type :=
        "P_Referenced_Decl_Internal";
      Member_Desc_For_Name_P_Referenced_Decl_Internal : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Name_P_Referenced_Decl_Internal'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Refd_Decl,
         Arguments     => (
               106 => (Name          => Arg_Name_106'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Name_P_Name_Designated_Type : aliased constant Text_Type :=
        "P_Name_Designated_Type";
      Member_Desc_For_Name_P_Name_Designated_Type : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Name_P_Name_Designated_Type'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_107 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Name_P_Is_Static_Subtype : aliased constant Text_Type :=
        "P_Is_Static_Subtype";
      Member_Desc_For_Name_P_Is_Static_Subtype : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Name_P_Is_Static_Subtype'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               107 => (Name          => Arg_Name_107'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_108 : aliased constant Text_Type :=
           "N";
         

      Member_Name_For_Name_P_Name_Matches : aliased constant Text_Type :=
        "P_Name_Matches";
      Member_Desc_For_Name_P_Name_Matches : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Name_P_Name_Matches'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               108 => (Name          => Arg_Name_108'Access,  Argument_Type => Type_Index_For_Name,  Default_Value => (Kind => None))
        ));

      


      Member_Name_For_Name_P_Relative_Name : aliased constant Text_Type :=
        "P_Relative_Name";
      Member_Desc_For_Name_P_Relative_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Name_P_Relative_Name'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Single_Tok_Node,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Name_P_Is_Operator_Name : aliased constant Text_Type :=
        "P_Is_Operator_Name";
      Member_Desc_For_Name_P_Is_Operator_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Name_P_Is_Operator_Name'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_109 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Name_P_Is_Write_Reference : aliased constant Text_Type :=
        "P_Is_Write_Reference";
      Member_Desc_For_Name_P_Is_Write_Reference : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Name_P_Is_Write_Reference'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               109 => (Name          => Arg_Name_109'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_110 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Name_P_Is_Static_Call : aliased constant Text_Type :=
        "P_Is_Static_Call";
      Member_Desc_For_Name_P_Is_Static_Call : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Name_P_Is_Static_Call'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               110 => (Name          => Arg_Name_110'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Name_P_As_Symbol_Array : aliased constant Text_Type :=
        "P_As_Symbol_Array";
      Member_Desc_For_Name_P_As_Symbol_Array : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Name_P_As_Symbol_Array'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Symbol_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Name_P_Canonical_Text : aliased constant Text_Type :=
        "P_Canonical_Text";
      Member_Desc_For_Name_P_Canonical_Text : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Name_P_Canonical_Text'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Symbol,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Name_P_Is_Constant : aliased constant Text_Type :=
        "P_Is_Constant";
      Member_Desc_For_Name_P_Is_Constant : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Name_P_Is_Constant'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Name_P_Call_Params : aliased constant Text_Type :=
        "P_Call_Params";
      Member_Desc_For_Name_P_Call_Params : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Name_P_Call_Params'Access,
         Owner         => Type_Index_For_Name,
         Member_Type   => Type_Index_For_Param_Actual_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Call_Expr_P_Kind : aliased constant Text_Type :=
        "P_Kind";
      Member_Desc_For_Call_Expr_P_Kind : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Call_Expr_P_Kind'Access,
         Owner         => Type_Index_For_Call_Expr,
         Member_Type   => Type_Index_For_Call_Expr_Kind,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Call_Expr_P_Is_Array_Slice : aliased constant Text_Type :=
        "P_Is_Array_Slice";
      Member_Desc_For_Call_Expr_P_Is_Array_Slice : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Call_Expr_P_Is_Array_Slice'Access,
         Owner         => Type_Index_For_Call_Expr,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Defining_Name_P_Canonical_Fully_Qualified_Name : aliased constant Text_Type :=
        "P_Canonical_Fully_Qualified_Name";
      Member_Desc_For_Defining_Name_P_Canonical_Fully_Qualified_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Defining_Name_P_Canonical_Fully_Qualified_Name'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_String,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Defining_Name_P_Unique_Identifying_Name : aliased constant Text_Type :=
        "P_Unique_Identifying_Name";
      Member_Desc_For_Defining_Name_P_Unique_Identifying_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Defining_Name_P_Unique_Identifying_Name'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_String,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Defining_Name_P_Fully_Qualified_Name_Array : aliased constant Text_Type :=
        "P_Fully_Qualified_Name_Array";
      Member_Desc_For_Defining_Name_P_Fully_Qualified_Name_Array : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Defining_Name_P_Fully_Qualified_Name_Array'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Symbol_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Defining_Name_P_Fully_Qualified_Name : aliased constant Text_Type :=
        "P_Fully_Qualified_Name";
      Member_Desc_For_Defining_Name_P_Fully_Qualified_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Defining_Name_P_Fully_Qualified_Name'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_String,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Defining_Name_P_Basic_Decl : aliased constant Text_Type :=
        "P_Basic_Decl";
      Member_Desc_For_Defining_Name_P_Basic_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Defining_Name_P_Basic_Decl'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_111 : aliased constant Text_Type :=
           "Root";
         
         Arg_Name_112 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Defining_Name_P_Find_Refs : aliased constant Text_Type :=
        "P_Find_Refs";
      Member_Desc_For_Defining_Name_P_Find_Refs : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Defining_Name_P_Find_Refs'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Ref_Result_Array,
         Arguments     => (
               111 => (Name          => Arg_Name_111'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => None)),
112 => (Name          => Arg_Name_112'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_113 : aliased constant Text_Type :=
           "Units";
         
         Arg_Name_114 : aliased constant Text_Type :=
           "Follow_Renamings";
         
         Arg_Name_115 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Defining_Name_P_Find_All_References : aliased constant Text_Type :=
        "P_Find_All_References";
      Member_Desc_For_Defining_Name_P_Find_All_References : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 3,
         Name          => Member_Name_For_Defining_Name_P_Find_All_References'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Ref_Result_Array,
         Arguments     => (
               113 => (Name          => Arg_Name_113'Access,  Argument_Type => Type_Index_For_Analysis_Unit_Array,  Default_Value => (Kind => None)),
114 => (Name          => Arg_Name_114'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False)),
115 => (Name          => Arg_Name_115'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_116 : aliased constant Text_Type :=
           "Units";
         
         Arg_Name_117 : aliased constant Text_Type :=
           "Follow_Renamings";
         
         Arg_Name_118 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Defining_Name_P_Find_All_Calls : aliased constant Text_Type :=
        "P_Find_All_Calls";
      Member_Desc_For_Defining_Name_P_Find_All_Calls : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 3,
         Name          => Member_Name_For_Defining_Name_P_Find_All_Calls'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Ref_Result_Array,
         Arguments     => (
               116 => (Name          => Arg_Name_116'Access,  Argument_Type => Type_Index_For_Analysis_Unit_Array,  Default_Value => (Kind => None)),
117 => (Name          => Arg_Name_117'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False)),
118 => (Name          => Arg_Name_118'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_119 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Defining_Name_P_Next_Part : aliased constant Text_Type :=
        "P_Next_Part";
      Member_Desc_For_Defining_Name_P_Next_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Defining_Name_P_Next_Part'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               119 => (Name          => Arg_Name_119'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_120 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Defining_Name_P_Previous_Part : aliased constant Text_Type :=
        "P_Previous_Part";
      Member_Desc_For_Defining_Name_P_Previous_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Defining_Name_P_Previous_Part'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               120 => (Name          => Arg_Name_120'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_121 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Defining_Name_P_Canonical_Part : aliased constant Text_Type :=
        "P_Canonical_Part";
      Member_Desc_For_Defining_Name_P_Canonical_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Defining_Name_P_Canonical_Part'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               121 => (Name          => Arg_Name_121'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_122 : aliased constant Text_Type :=
           "Origin";
         
         Arg_Name_123 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Defining_Name_P_Most_Visible_Part : aliased constant Text_Type :=
        "P_Most_Visible_Part";
      Member_Desc_For_Defining_Name_P_Most_Visible_Part : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Defining_Name_P_Most_Visible_Part'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Defining_Name,
         Arguments     => (
               122 => (Name          => Arg_Name_122'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => None)),
123 => (Name          => Arg_Name_123'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_124 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Defining_Name_P_All_Parts : aliased constant Text_Type :=
        "P_All_Parts";
      Member_Desc_For_Defining_Name_P_All_Parts : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Defining_Name_P_All_Parts'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Defining_Name_Array,
         Arguments     => (
               124 => (Name          => Arg_Name_124'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_125 : aliased constant Text_Type :=
           "Name";
         
         Arg_Name_126 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Defining_Name_P_Get_Aspect : aliased constant Text_Type :=
        "P_Get_Aspect";
      Member_Desc_For_Defining_Name_P_Get_Aspect : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Defining_Name_P_Get_Aspect'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Aspect,
         Arguments     => (
               125 => (Name          => Arg_Name_125'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None)),
126 => (Name          => Arg_Name_126'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_127 : aliased constant Text_Type :=
           "Name";
         
         Arg_Name_128 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Defining_Name_P_Has_Aspect : aliased constant Text_Type :=
        "P_Has_Aspect";
      Member_Desc_For_Defining_Name_P_Has_Aspect : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Defining_Name_P_Has_Aspect'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               127 => (Name          => Arg_Name_127'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None)),
128 => (Name          => Arg_Name_128'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_129 : aliased constant Text_Type :=
           "Name";
         

      Member_Name_For_Defining_Name_P_Get_Pragma : aliased constant Text_Type :=
        "P_Get_Pragma";
      Member_Desc_For_Defining_Name_P_Get_Pragma : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Defining_Name_P_Get_Pragma'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Pragma,
         Arguments     => (
               129 => (Name          => Arg_Name_129'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None))
        ));

      

         Arg_Name_130 : aliased constant Text_Type :=
           "Name";
         
         Arg_Name_131 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Defining_Name_P_Get_Representation_Clause : aliased constant Text_Type :=
        "P_Get_Representation_Clause";
      Member_Desc_For_Defining_Name_P_Get_Representation_Clause : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 2,
         Name          => Member_Name_For_Defining_Name_P_Get_Representation_Clause'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Attribute_Def_Clause,
         Arguments     => (
               130 => (Name          => Arg_Name_130'Access,  Argument_Type => Type_Index_For_Symbol,  Default_Value => (Kind => None)),
131 => (Name          => Arg_Name_131'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      

         Arg_Name_132 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Defining_Name_P_Get_At_Clause : aliased constant Text_Type :=
        "P_Get_At_Clause";
      Member_Desc_For_Defining_Name_P_Get_At_Clause : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Defining_Name_P_Get_At_Clause'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_At_Clause,
         Arguments     => (
               132 => (Name          => Arg_Name_132'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Defining_Name_P_Is_Imported : aliased constant Text_Type :=
        "P_Is_Imported";
      Member_Desc_For_Defining_Name_P_Is_Imported : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Defining_Name_P_Is_Imported'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Defining_Name_P_Is_Ghost_Code : aliased constant Text_Type :=
        "P_Is_Ghost_Code";
      Member_Desc_For_Defining_Name_P_Is_Ghost_Code : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Defining_Name_P_Is_Ghost_Code'Access,
         Owner         => Type_Index_For_Defining_Name,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_End_Name_P_Basic_Decl : aliased constant Text_Type :=
        "P_Basic_Decl";
      Member_Desc_For_End_Name_P_Basic_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_End_Name_P_Basic_Decl'Access,
         Owner         => Type_Index_For_End_Name,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Char_Literal_P_Denoted_Value : aliased constant Text_Type :=
        "P_Denoted_Value";
      Member_Desc_For_Char_Literal_P_Denoted_Value : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Char_Literal_P_Denoted_Value'Access,
         Owner         => Type_Index_For_Char_Literal,
         Member_Type   => Type_Index_For_Character,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_String_Literal_P_Denoted_Value : aliased constant Text_Type :=
        "P_Denoted_Value";
      Member_Desc_For_String_Literal_P_Denoted_Value : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_String_Literal_P_Denoted_Value'Access,
         Owner         => Type_Index_For_String_Literal,
         Member_Type   => Type_Index_For_String,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Int_Literal_P_Denoted_Value : aliased constant Text_Type :=
        "P_Denoted_Value";
      Member_Desc_For_Int_Literal_P_Denoted_Value : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Int_Literal_P_Denoted_Value'Access,
         Owner         => Type_Index_For_Int_Literal,
         Member_Type   => Type_Index_For_Big_Int,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Limited_Node_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_Limited_Node_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Limited_Node_P_As_Bool'Access,
         Owner         => Type_Index_For_Limited,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Not_Null_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_Not_Null_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Not_Null_P_As_Bool'Access,
         Owner         => Type_Index_For_Not_Null,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Pragma_Node_P_Is_Ghost_Code : aliased constant Text_Type :=
        "P_Is_Ghost_Code";
      Member_Desc_For_Pragma_Node_P_Is_Ghost_Code : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Pragma_Node_P_Is_Ghost_Code'Access,
         Owner         => Type_Index_For_Pragma,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Pragma_Node_P_Associated_Entities : aliased constant Text_Type :=
        "P_Associated_Entities";
      Member_Desc_For_Pragma_Node_P_Associated_Entities : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Pragma_Node_P_Associated_Entities'Access,
         Owner         => Type_Index_For_Pragma,
         Member_Type   => Type_Index_For_Defining_Name_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Private_Node_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_Private_Node_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Private_Node_P_As_Bool'Access,
         Owner         => Type_Index_For_Private,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Protected_Node_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_Protected_Node_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Protected_Node_P_As_Bool'Access,
         Owner         => Type_Index_For_Protected,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Reverse_Node_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_Reverse_Node_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Reverse_Node_P_As_Bool'Access,
         Owner         => Type_Index_For_Reverse,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Stmt_P_Is_Ghost_Code : aliased constant Text_Type :=
        "P_Is_Ghost_Code";
      Member_Desc_For_Stmt_P_Is_Ghost_Code : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Stmt_P_Is_Ghost_Code'Access,
         Owner         => Type_Index_For_Stmt,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_133 : aliased constant Text_Type :=
           "Origin";
         

      Member_Name_For_Accept_Stmt_P_Corresponding_Entry : aliased constant Text_Type :=
        "P_Corresponding_Entry";
      Member_Desc_For_Accept_Stmt_P_Corresponding_Entry : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Accept_Stmt_P_Corresponding_Entry'Access,
         Owner         => Type_Index_For_Accept_Stmt,
         Member_Type   => Type_Index_For_Entry_Decl,
         Arguments     => (
               133 => (Name          => Arg_Name_133'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => Null_Node_Value))
        ));

      


      Member_Name_For_Subunit_P_Body_Root : aliased constant Text_Type :=
        "P_Body_Root";
      Member_Desc_For_Subunit_P_Body_Root : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subunit_P_Body_Root'Access,
         Owner         => Type_Index_For_Subunit,
         Member_Type   => Type_Index_For_Basic_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Synchronized_Node_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_Synchronized_Node_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Synchronized_Node_P_As_Bool'Access,
         Owner         => Type_Index_For_Synchronized,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Tagged_Node_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_Tagged_Node_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Tagged_Node_P_As_Bool'Access,
         Owner         => Type_Index_For_Tagged,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Type_Expr_P_Type_Name : aliased constant Text_Type :=
        "P_Type_Name";
      Member_Desc_For_Type_Expr_P_Type_Name : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Type_Expr_P_Type_Name'Access,
         Owner         => Type_Index_For_Type_Expr,
         Member_Type   => Type_Index_For_Name,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_Type_Expr_P_Designated_Type_Decl : aliased constant Text_Type :=
        "P_Designated_Type_Decl";
      Member_Desc_For_Type_Expr_P_Designated_Type_Decl : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Type_Expr_P_Designated_Type_Decl'Access,
         Owner         => Type_Index_For_Type_Expr,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_134 : aliased constant Text_Type :=
           "Origin_Node";
         

      Member_Name_For_Type_Expr_P_Designated_Type_Decl_From : aliased constant Text_Type :=
        "P_Designated_Type_Decl_From";
      Member_Desc_For_Type_Expr_P_Designated_Type_Decl_From : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Type_Expr_P_Designated_Type_Decl_From'Access,
         Owner         => Type_Index_For_Type_Expr,
         Member_Type   => Type_Index_For_Base_Type_Decl,
         Arguments     => (
               134 => (Name          => Arg_Name_134'Access,  Argument_Type => Type_Index_For_Ada_Node,  Default_Value => (Kind => None))
        ));

      


      Member_Name_For_Subtype_Indication_P_Subtype_Constraints : aliased constant Text_Type :=
        "P_Subtype_Constraints";
      Member_Desc_For_Subtype_Indication_P_Subtype_Constraints : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Subtype_Indication_P_Subtype_Constraints'Access,
         Owner         => Type_Index_For_Subtype_Indication,
         Member_Type   => Type_Index_For_Param_Actual_Array,
         Arguments     => (
               1 .. 0 => <>
        ));

      

         Arg_Name_135 : aliased constant Text_Type :=
           "Imprecise_Fallback";
         

      Member_Name_For_Subtype_Indication_P_Is_Static_Subtype : aliased constant Text_Type :=
        "P_Is_Static_Subtype";
      Member_Desc_For_Subtype_Indication_P_Is_Static_Subtype : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 1,
         Name          => Member_Name_For_Subtype_Indication_P_Is_Static_Subtype'Access,
         Owner         => Type_Index_For_Subtype_Indication,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               135 => (Name          => Arg_Name_135'Access,  Argument_Type => Type_Index_For_Bool,  Default_Value => (Kind => Boolean_Value, Boolean_Value => False))
        ));

      


      Member_Name_For_Until_Node_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_Until_Node_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_Until_Node_P_As_Bool'Access,
         Owner         => Type_Index_For_Until,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));

      


      Member_Name_For_With_Private_P_As_Bool : aliased constant Text_Type :=
        "P_As_Bool";
      Member_Desc_For_With_Private_P_As_Bool : aliased constant Struct_Member_Descriptor :=
        (Last_Argument => 0,
         Name          => Member_Name_For_With_Private_P_As_Bool'Access,
         Owner         => Type_Index_For_With_Private,
         Member_Type   => Type_Index_For_Bool,
         Arguments     => (
               1 .. 0 => <>
        ));


   Struct_Members : aliased constant Struct_Member_Descriptor_Array := (
      Member_Index_For_Aspect_Exists => Member_Desc_For_Aspect_Exists'Access,
Member_Index_For_Aspect_Node => Member_Desc_For_Aspect_Node'Access,
Member_Index_For_Aspect_Value => Member_Desc_For_Aspect_Value'Access,
Member_Index_For_Completion_Item_Decl => Member_Desc_For_Completion_Item_Decl'Access,
Member_Index_For_Completion_Item_Is_Dot_Call => Member_Desc_For_Completion_Item_Is_Dot_Call'Access,
Member_Index_For_Completion_Item_Is_Visible => Member_Desc_For_Completion_Item_Is_Visible'Access,
Member_Index_For_Completion_Item_Weight => Member_Desc_For_Completion_Item_Weight'Access,
Member_Index_For_Discrete_Range_Low_Bound => Member_Desc_For_Discrete_Range_Low_Bound'Access,
Member_Index_For_Discrete_Range_High_Bound => Member_Desc_For_Discrete_Range_High_Bound'Access,
Member_Index_For_Discriminant_Values_Discriminant => Member_Desc_For_Discriminant_Values_Discriminant'Access,
Member_Index_For_Discriminant_Values_Values => Member_Desc_For_Discriminant_Values_Values'Access,
Member_Index_For_Doc_Annotation_Key => Member_Desc_For_Doc_Annotation_Key'Access,
Member_Index_For_Doc_Annotation_Value => Member_Desc_For_Doc_Annotation_Value'Access,
Member_Index_For_Param_Actual_Param => Member_Desc_For_Param_Actual_Param'Access,
Member_Index_For_Param_Actual_Actual => Member_Desc_For_Param_Actual_Actual'Access,
Member_Index_For_Ref_Result_Ref => Member_Desc_For_Ref_Result_Ref'Access,
Member_Index_For_Ref_Result_Kind => Member_Desc_For_Ref_Result_Kind'Access,
Member_Index_For_Refd_Decl_Decl => Member_Desc_For_Refd_Decl_Decl'Access,
Member_Index_For_Refd_Decl_Kind => Member_Desc_For_Refd_Decl_Kind'Access,
Member_Index_For_Refd_Def_Def_Name => Member_Desc_For_Refd_Def_Def_Name'Access,
Member_Index_For_Refd_Def_Kind => Member_Desc_For_Refd_Def_Kind'Access,
Member_Index_For_Shape_Components => Member_Desc_For_Shape_Components'Access,
Member_Index_For_Shape_Discriminants_Values => Member_Desc_For_Shape_Discriminants_Values'Access,
Member_Index_For_Substitution_From_Decl => Member_Desc_For_Substitution_From_Decl'Access,
Member_Index_For_Substitution_To_Value => Member_Desc_For_Substitution_To_Value'Access,
Member_Index_For_Substitution_Value_Type => Member_Desc_For_Substitution_Value_Type'Access,
Member_Index_For_Constrained_Array_Indices_F_List => Member_Desc_For_Constrained_Array_Indices_F_List'Access,
Member_Index_For_Unconstrained_Array_Indices_F_Types => Member_Desc_For_Unconstrained_Array_Indices_F_Types'Access,
Member_Index_For_Aspect_Assoc_F_Id => Member_Desc_For_Aspect_Assoc_F_Id'Access,
Member_Index_For_Aspect_Assoc_F_Expr => Member_Desc_For_Aspect_Assoc_F_Expr'Access,
Member_Index_For_At_Clause_F_Name => Member_Desc_For_At_Clause_F_Name'Access,
Member_Index_For_At_Clause_F_Expr => Member_Desc_For_At_Clause_F_Expr'Access,
Member_Index_For_Attribute_Def_Clause_F_Attribute_Expr => Member_Desc_For_Attribute_Def_Clause_F_Attribute_Expr'Access,
Member_Index_For_Attribute_Def_Clause_F_Expr => Member_Desc_For_Attribute_Def_Clause_F_Expr'Access,
Member_Index_For_Enum_Rep_Clause_F_Type_Name => Member_Desc_For_Enum_Rep_Clause_F_Type_Name'Access,
Member_Index_For_Enum_Rep_Clause_F_Aggregate => Member_Desc_For_Enum_Rep_Clause_F_Aggregate'Access,
Member_Index_For_Record_Rep_Clause_F_Name => Member_Desc_For_Record_Rep_Clause_F_Name'Access,
Member_Index_For_Record_Rep_Clause_F_At_Expr => Member_Desc_For_Record_Rep_Clause_F_At_Expr'Access,
Member_Index_For_Record_Rep_Clause_F_Components => Member_Desc_For_Record_Rep_Clause_F_Components'Access,
Member_Index_For_Aspect_Spec_F_Aspect_Assocs => Member_Desc_For_Aspect_Spec_F_Aspect_Assocs'Access,
Member_Index_For_Contract_Case_Assoc_F_Guard => Member_Desc_For_Contract_Case_Assoc_F_Guard'Access,
Member_Index_For_Contract_Case_Assoc_F_Consequence => Member_Desc_For_Contract_Case_Assoc_F_Consequence'Access,
Member_Index_For_Pragma_Argument_Assoc_F_Name => Member_Desc_For_Pragma_Argument_Assoc_F_Name'Access,
Member_Index_For_Pragma_Argument_Assoc_F_Expr => Member_Desc_For_Pragma_Argument_Assoc_F_Expr'Access,
Member_Index_For_Entry_Spec_F_Entry_Name => Member_Desc_For_Entry_Spec_F_Entry_Name'Access,
Member_Index_For_Entry_Spec_F_Family_Type => Member_Desc_For_Entry_Spec_F_Family_Type'Access,
Member_Index_For_Entry_Spec_F_Entry_Params => Member_Desc_For_Entry_Spec_F_Entry_Params'Access,
Member_Index_For_Subp_Spec_F_Subp_Kind => Member_Desc_For_Subp_Spec_F_Subp_Kind'Access,
Member_Index_For_Subp_Spec_F_Subp_Name => Member_Desc_For_Subp_Spec_F_Subp_Name'Access,
Member_Index_For_Subp_Spec_F_Subp_Params => Member_Desc_For_Subp_Spec_F_Subp_Params'Access,
Member_Index_For_Subp_Spec_F_Subp_Returns => Member_Desc_For_Subp_Spec_F_Subp_Returns'Access,
Member_Index_For_Synthetic_Binary_Spec_F_Left_Param => Member_Desc_For_Synthetic_Binary_Spec_F_Left_Param'Access,
Member_Index_For_Synthetic_Binary_Spec_F_Right_Param => Member_Desc_For_Synthetic_Binary_Spec_F_Right_Param'Access,
Member_Index_For_Synthetic_Binary_Spec_F_Return_Type_Expr => Member_Desc_For_Synthetic_Binary_Spec_F_Return_Type_Expr'Access,
Member_Index_For_Synthetic_Unary_Spec_F_Right_Param => Member_Desc_For_Synthetic_Unary_Spec_F_Right_Param'Access,
Member_Index_For_Synthetic_Unary_Spec_F_Return_Type_Expr => Member_Desc_For_Synthetic_Unary_Spec_F_Return_Type_Expr'Access,
Member_Index_For_Component_List_F_Components => Member_Desc_For_Component_List_F_Components'Access,
Member_Index_For_Component_List_F_Variant_Part => Member_Desc_For_Component_List_F_Variant_Part'Access,
Member_Index_For_Known_Discriminant_Part_F_Discr_Specs => Member_Desc_For_Known_Discriminant_Part_F_Discr_Specs'Access,
Member_Index_For_Entry_Completion_Formal_Params_F_Params => Member_Desc_For_Entry_Completion_Formal_Params_F_Params'Access,
Member_Index_For_Generic_Formal_Part_F_Decls => Member_Desc_For_Generic_Formal_Part_F_Decls'Access,
Member_Index_For_Base_Record_Def_F_Components => Member_Desc_For_Base_Record_Def_F_Components'Access,
Member_Index_For_Aggregate_Assoc_F_Designators => Member_Desc_For_Aggregate_Assoc_F_Designators'Access,
Member_Index_For_Aggregate_Assoc_F_R_Expr => Member_Desc_For_Aggregate_Assoc_F_R_Expr'Access,
Member_Index_For_Composite_Constraint_Assoc_F_Ids => Member_Desc_For_Composite_Constraint_Assoc_F_Ids'Access,
Member_Index_For_Composite_Constraint_Assoc_F_Constraint_Expr => Member_Desc_For_Composite_Constraint_Assoc_F_Constraint_Expr'Access,
Member_Index_For_Iterated_Assoc_F_Spec => Member_Desc_For_Iterated_Assoc_F_Spec'Access,
Member_Index_For_Iterated_Assoc_F_R_Expr => Member_Desc_For_Iterated_Assoc_F_R_Expr'Access,
Member_Index_For_Param_Assoc_F_Designator => Member_Desc_For_Param_Assoc_F_Designator'Access,
Member_Index_For_Param_Assoc_F_R_Expr => Member_Desc_For_Param_Assoc_F_R_Expr'Access,
Member_Index_For_Basic_Decl_F_Aspects => Member_Desc_For_Basic_Decl_F_Aspects'Access,
Member_Index_For_Abstract_State_Decl_F_Name => Member_Desc_For_Abstract_State_Decl_F_Name'Access,
Member_Index_For_Anonymous_Expr_Decl_F_Expr => Member_Desc_For_Anonymous_Expr_Decl_F_Expr'Access,
Member_Index_For_Component_Decl_F_Ids => Member_Desc_For_Component_Decl_F_Ids'Access,
Member_Index_For_Component_Decl_F_Component_Def => Member_Desc_For_Component_Decl_F_Component_Def'Access,
Member_Index_For_Component_Decl_F_Default_Expr => Member_Desc_For_Component_Decl_F_Default_Expr'Access,
Member_Index_For_Discriminant_Spec_F_Ids => Member_Desc_For_Discriminant_Spec_F_Ids'Access,
Member_Index_For_Discriminant_Spec_F_Type_Expr => Member_Desc_For_Discriminant_Spec_F_Type_Expr'Access,
Member_Index_For_Discriminant_Spec_F_Default_Expr => Member_Desc_For_Discriminant_Spec_F_Default_Expr'Access,
Member_Index_For_Generic_Formal_F_Decl => Member_Desc_For_Generic_Formal_F_Decl'Access,
Member_Index_For_Param_Spec_F_Ids => Member_Desc_For_Param_Spec_F_Ids'Access,
Member_Index_For_Param_Spec_F_Has_Aliased => Member_Desc_For_Param_Spec_F_Has_Aliased'Access,
Member_Index_For_Param_Spec_F_Mode => Member_Desc_For_Param_Spec_F_Mode'Access,
Member_Index_For_Param_Spec_F_Type_Expr => Member_Desc_For_Param_Spec_F_Type_Expr'Access,
Member_Index_For_Param_Spec_F_Default_Expr => Member_Desc_For_Param_Spec_F_Default_Expr'Access,
Member_Index_For_Synthetic_Formal_Param_Decl_F_Param_Type => Member_Desc_For_Synthetic_Formal_Param_Decl_F_Param_Type'Access,
Member_Index_For_Base_Package_Decl_F_Package_Name => Member_Desc_For_Base_Package_Decl_F_Package_Name'Access,
Member_Index_For_Base_Package_Decl_F_Public_Part => Member_Desc_For_Base_Package_Decl_F_Public_Part'Access,
Member_Index_For_Base_Package_Decl_F_Private_Part => Member_Desc_For_Base_Package_Decl_F_Private_Part'Access,
Member_Index_For_Base_Package_Decl_F_End_Name => Member_Desc_For_Base_Package_Decl_F_End_Name'Access,
Member_Index_For_Base_Type_Decl_F_Name => Member_Desc_For_Base_Type_Decl_F_Name'Access,
Member_Index_For_Subtype_Decl_F_Subtype => Member_Desc_For_Subtype_Decl_F_Subtype'Access,
Member_Index_For_Incomplete_Type_Decl_F_Discriminants => Member_Desc_For_Incomplete_Type_Decl_F_Discriminants'Access,
Member_Index_For_Incomplete_Formal_Type_Decl_F_Is_Tagged => Member_Desc_For_Incomplete_Formal_Type_Decl_F_Is_Tagged'Access,
Member_Index_For_Incomplete_Formal_Type_Decl_F_Default_Type => Member_Desc_For_Incomplete_Formal_Type_Decl_F_Default_Type'Access,
Member_Index_For_Incomplete_Tagged_Type_Decl_F_Has_Abstract => Member_Desc_For_Incomplete_Tagged_Type_Decl_F_Has_Abstract'Access,
Member_Index_For_Protected_Type_Decl_F_Discriminants => Member_Desc_For_Protected_Type_Decl_F_Discriminants'Access,
Member_Index_For_Protected_Type_Decl_F_Interfaces => Member_Desc_For_Protected_Type_Decl_F_Interfaces'Access,
Member_Index_For_Protected_Type_Decl_F_Definition => Member_Desc_For_Protected_Type_Decl_F_Definition'Access,
Member_Index_For_Task_Type_Decl_F_Discriminants => Member_Desc_For_Task_Type_Decl_F_Discriminants'Access,
Member_Index_For_Task_Type_Decl_F_Definition => Member_Desc_For_Task_Type_Decl_F_Definition'Access,
Member_Index_For_Type_Decl_F_Discriminants => Member_Desc_For_Type_Decl_F_Discriminants'Access,
Member_Index_For_Type_Decl_F_Type_Def => Member_Desc_For_Type_Decl_F_Type_Def'Access,
Member_Index_For_Formal_Type_Decl_F_Default_Type => Member_Desc_For_Formal_Type_Decl_F_Default_Type'Access,
Member_Index_For_Classic_Subp_Decl_F_Overriding => Member_Desc_For_Classic_Subp_Decl_F_Overriding'Access,
Member_Index_For_Classic_Subp_Decl_F_Subp_Spec => Member_Desc_For_Classic_Subp_Decl_F_Subp_Spec'Access,
Member_Index_For_Formal_Subp_Decl_F_Default_Expr => Member_Desc_For_Formal_Subp_Decl_F_Default_Expr'Access,
Member_Index_For_Entry_Decl_F_Overriding => Member_Desc_For_Entry_Decl_F_Overriding'Access,
Member_Index_For_Entry_Decl_F_Spec => Member_Desc_For_Entry_Decl_F_Spec'Access,
Member_Index_For_Enum_Literal_Decl_F_Name => Member_Desc_For_Enum_Literal_Decl_F_Name'Access,
Member_Index_For_Generic_Subp_Internal_F_Subp_Spec => Member_Desc_For_Generic_Subp_Internal_F_Subp_Spec'Access,
Member_Index_For_Synthetic_Subp_Decl_F_Spec => Member_Desc_For_Synthetic_Subp_Decl_F_Spec'Access,
Member_Index_For_Base_Subp_Body_F_Overriding => Member_Desc_For_Base_Subp_Body_F_Overriding'Access,
Member_Index_For_Base_Subp_Body_F_Subp_Spec => Member_Desc_For_Base_Subp_Body_F_Subp_Spec'Access,
Member_Index_For_Expr_Function_F_Expr => Member_Desc_For_Expr_Function_F_Expr'Access,
Member_Index_For_Subp_Body_F_Decls => Member_Desc_For_Subp_Body_F_Decls'Access,
Member_Index_For_Subp_Body_F_Stmts => Member_Desc_For_Subp_Body_F_Stmts'Access,
Member_Index_For_Subp_Body_F_End_Name => Member_Desc_For_Subp_Body_F_End_Name'Access,
Member_Index_For_Subp_Renaming_Decl_F_Renames => Member_Desc_For_Subp_Renaming_Decl_F_Renames'Access,
Member_Index_For_Package_Body_Stub_F_Name => Member_Desc_For_Package_Body_Stub_F_Name'Access,
Member_Index_For_Protected_Body_Stub_F_Name => Member_Desc_For_Protected_Body_Stub_F_Name'Access,
Member_Index_For_Subp_Body_Stub_F_Overriding => Member_Desc_For_Subp_Body_Stub_F_Overriding'Access,
Member_Index_For_Subp_Body_Stub_F_Subp_Spec => Member_Desc_For_Subp_Body_Stub_F_Subp_Spec'Access,
Member_Index_For_Task_Body_Stub_F_Name => Member_Desc_For_Task_Body_Stub_F_Name'Access,
Member_Index_For_Entry_Body_F_Entry_Name => Member_Desc_For_Entry_Body_F_Entry_Name'Access,
Member_Index_For_Entry_Body_F_Index_Spec => Member_Desc_For_Entry_Body_F_Index_Spec'Access,
Member_Index_For_Entry_Body_F_Params => Member_Desc_For_Entry_Body_F_Params'Access,
Member_Index_For_Entry_Body_F_Barrier => Member_Desc_For_Entry_Body_F_Barrier'Access,
Member_Index_For_Entry_Body_F_Decls => Member_Desc_For_Entry_Body_F_Decls'Access,
Member_Index_For_Entry_Body_F_Stmts => Member_Desc_For_Entry_Body_F_Stmts'Access,
Member_Index_For_Entry_Body_F_End_Name => Member_Desc_For_Entry_Body_F_End_Name'Access,
Member_Index_For_Package_Body_F_Package_Name => Member_Desc_For_Package_Body_F_Package_Name'Access,
Member_Index_For_Package_Body_F_Decls => Member_Desc_For_Package_Body_F_Decls'Access,
Member_Index_For_Package_Body_F_Stmts => Member_Desc_For_Package_Body_F_Stmts'Access,
Member_Index_For_Package_Body_F_End_Name => Member_Desc_For_Package_Body_F_End_Name'Access,
Member_Index_For_Protected_Body_F_Name => Member_Desc_For_Protected_Body_F_Name'Access,
Member_Index_For_Protected_Body_F_Decls => Member_Desc_For_Protected_Body_F_Decls'Access,
Member_Index_For_Protected_Body_F_End_Name => Member_Desc_For_Protected_Body_F_End_Name'Access,
Member_Index_For_Task_Body_F_Name => Member_Desc_For_Task_Body_F_Name'Access,
Member_Index_For_Task_Body_F_Decls => Member_Desc_For_Task_Body_F_Decls'Access,
Member_Index_For_Task_Body_F_Stmts => Member_Desc_For_Task_Body_F_Stmts'Access,
Member_Index_For_Task_Body_F_End_Name => Member_Desc_For_Task_Body_F_End_Name'Access,
Member_Index_For_Entry_Index_Spec_F_Id => Member_Desc_For_Entry_Index_Spec_F_Id'Access,
Member_Index_For_Entry_Index_Spec_F_Subtype => Member_Desc_For_Entry_Index_Spec_F_Subtype'Access,
Member_Index_For_Exception_Decl_F_Ids => Member_Desc_For_Exception_Decl_F_Ids'Access,
Member_Index_For_Exception_Decl_F_Renames => Member_Desc_For_Exception_Decl_F_Renames'Access,
Member_Index_For_Exception_Handler_F_Exception_Name => Member_Desc_For_Exception_Handler_F_Exception_Name'Access,
Member_Index_For_Exception_Handler_F_Handled_Exceptions => Member_Desc_For_Exception_Handler_F_Handled_Exceptions'Access,
Member_Index_For_Exception_Handler_F_Stmts => Member_Desc_For_Exception_Handler_F_Stmts'Access,
Member_Index_For_For_Loop_Var_Decl_F_Id => Member_Desc_For_For_Loop_Var_Decl_F_Id'Access,
Member_Index_For_For_Loop_Var_Decl_F_Id_Type => Member_Desc_For_For_Loop_Var_Decl_F_Id_Type'Access,
Member_Index_For_Generic_Decl_F_Formal_Part => Member_Desc_For_Generic_Decl_F_Formal_Part'Access,
Member_Index_For_Generic_Package_Decl_F_Package_Decl => Member_Desc_For_Generic_Package_Decl_F_Package_Decl'Access,
Member_Index_For_Generic_Subp_Decl_F_Subp_Decl => Member_Desc_For_Generic_Subp_Decl_F_Subp_Decl'Access,
Member_Index_For_Generic_Package_Instantiation_F_Name => Member_Desc_For_Generic_Package_Instantiation_F_Name'Access,
Member_Index_For_Generic_Package_Instantiation_F_Generic_Pkg_Name => Member_Desc_For_Generic_Package_Instantiation_F_Generic_Pkg_Name'Access,
Member_Index_For_Generic_Package_Instantiation_F_Params => Member_Desc_For_Generic_Package_Instantiation_F_Params'Access,
Member_Index_For_Generic_Subp_Instantiation_F_Overriding => Member_Desc_For_Generic_Subp_Instantiation_F_Overriding'Access,
Member_Index_For_Generic_Subp_Instantiation_F_Kind => Member_Desc_For_Generic_Subp_Instantiation_F_Kind'Access,
Member_Index_For_Generic_Subp_Instantiation_F_Subp_Name => Member_Desc_For_Generic_Subp_Instantiation_F_Subp_Name'Access,
Member_Index_For_Generic_Subp_Instantiation_F_Generic_Subp_Name => Member_Desc_For_Generic_Subp_Instantiation_F_Generic_Subp_Name'Access,
Member_Index_For_Generic_Subp_Instantiation_F_Params => Member_Desc_For_Generic_Subp_Instantiation_F_Params'Access,
Member_Index_For_Generic_Package_Renaming_Decl_F_Name => Member_Desc_For_Generic_Package_Renaming_Decl_F_Name'Access,
Member_Index_For_Generic_Package_Renaming_Decl_F_Renames => Member_Desc_For_Generic_Package_Renaming_Decl_F_Renames'Access,
Member_Index_For_Generic_Subp_Renaming_Decl_F_Kind => Member_Desc_For_Generic_Subp_Renaming_Decl_F_Kind'Access,
Member_Index_For_Generic_Subp_Renaming_Decl_F_Name => Member_Desc_For_Generic_Subp_Renaming_Decl_F_Name'Access,
Member_Index_For_Generic_Subp_Renaming_Decl_F_Renames => Member_Desc_For_Generic_Subp_Renaming_Decl_F_Renames'Access,
Member_Index_For_Label_Decl_F_Name => Member_Desc_For_Label_Decl_F_Name'Access,
Member_Index_For_Named_Stmt_Decl_F_Name => Member_Desc_For_Named_Stmt_Decl_F_Name'Access,
Member_Index_For_Number_Decl_F_Ids => Member_Desc_For_Number_Decl_F_Ids'Access,
Member_Index_For_Number_Decl_F_Expr => Member_Desc_For_Number_Decl_F_Expr'Access,
Member_Index_For_Object_Decl_F_Ids => Member_Desc_For_Object_Decl_F_Ids'Access,
Member_Index_For_Object_Decl_F_Has_Aliased => Member_Desc_For_Object_Decl_F_Has_Aliased'Access,
Member_Index_For_Object_Decl_F_Has_Constant => Member_Desc_For_Object_Decl_F_Has_Constant'Access,
Member_Index_For_Object_Decl_F_Mode => Member_Desc_For_Object_Decl_F_Mode'Access,
Member_Index_For_Object_Decl_F_Type_Expr => Member_Desc_For_Object_Decl_F_Type_Expr'Access,
Member_Index_For_Object_Decl_F_Default_Expr => Member_Desc_For_Object_Decl_F_Default_Expr'Access,
Member_Index_For_Object_Decl_F_Renaming_Clause => Member_Desc_For_Object_Decl_F_Renaming_Clause'Access,
Member_Index_For_Package_Renaming_Decl_F_Name => Member_Desc_For_Package_Renaming_Decl_F_Name'Access,
Member_Index_For_Package_Renaming_Decl_F_Renames => Member_Desc_For_Package_Renaming_Decl_F_Renames'Access,
Member_Index_For_Single_Protected_Decl_F_Name => Member_Desc_For_Single_Protected_Decl_F_Name'Access,
Member_Index_For_Single_Protected_Decl_F_Interfaces => Member_Desc_For_Single_Protected_Decl_F_Interfaces'Access,
Member_Index_For_Single_Protected_Decl_F_Definition => Member_Desc_For_Single_Protected_Decl_F_Definition'Access,
Member_Index_For_Single_Task_Decl_F_Task_Type => Member_Desc_For_Single_Task_Decl_F_Task_Type'Access,
Member_Index_For_Case_Stmt_Alternative_F_Choices => Member_Desc_For_Case_Stmt_Alternative_F_Choices'Access,
Member_Index_For_Case_Stmt_Alternative_F_Stmts => Member_Desc_For_Case_Stmt_Alternative_F_Stmts'Access,
Member_Index_For_Compilation_Unit_F_Prelude => Member_Desc_For_Compilation_Unit_F_Prelude'Access,
Member_Index_For_Compilation_Unit_F_Body => Member_Desc_For_Compilation_Unit_F_Body'Access,
Member_Index_For_Compilation_Unit_F_Pragmas => Member_Desc_For_Compilation_Unit_F_Pragmas'Access,
Member_Index_For_Component_Clause_F_Id => Member_Desc_For_Component_Clause_F_Id'Access,
Member_Index_For_Component_Clause_F_Position => Member_Desc_For_Component_Clause_F_Position'Access,
Member_Index_For_Component_Clause_F_Range => Member_Desc_For_Component_Clause_F_Range'Access,
Member_Index_For_Component_Def_F_Has_Aliased => Member_Desc_For_Component_Def_F_Has_Aliased'Access,
Member_Index_For_Component_Def_F_Has_Constant => Member_Desc_For_Component_Def_F_Has_Constant'Access,
Member_Index_For_Component_Def_F_Type_Expr => Member_Desc_For_Component_Def_F_Type_Expr'Access,
Member_Index_For_Composite_Constraint_F_Constraints => Member_Desc_For_Composite_Constraint_F_Constraints'Access,
Member_Index_For_Delta_Constraint_F_Digits => Member_Desc_For_Delta_Constraint_F_Digits'Access,
Member_Index_For_Delta_Constraint_F_Range => Member_Desc_For_Delta_Constraint_F_Range'Access,
Member_Index_For_Digits_Constraint_F_Digits => Member_Desc_For_Digits_Constraint_F_Digits'Access,
Member_Index_For_Digits_Constraint_F_Range => Member_Desc_For_Digits_Constraint_F_Range'Access,
Member_Index_For_Range_Constraint_F_Range => Member_Desc_For_Range_Constraint_F_Range'Access,
Member_Index_For_Declarative_Part_F_Decls => Member_Desc_For_Declarative_Part_F_Decls'Access,
Member_Index_For_Elsif_Expr_Part_F_Cond_Expr => Member_Desc_For_Elsif_Expr_Part_F_Cond_Expr'Access,
Member_Index_For_Elsif_Expr_Part_F_Then_Expr => Member_Desc_For_Elsif_Expr_Part_F_Then_Expr'Access,
Member_Index_For_Elsif_Stmt_Part_F_Cond_Expr => Member_Desc_For_Elsif_Stmt_Part_F_Cond_Expr'Access,
Member_Index_For_Elsif_Stmt_Part_F_Stmts => Member_Desc_For_Elsif_Stmt_Part_F_Stmts'Access,
Member_Index_For_Abstract_State_Decl_Expr_F_State_Decl => Member_Desc_For_Abstract_State_Decl_Expr_F_State_Decl'Access,
Member_Index_For_Allocator_F_Subpool => Member_Desc_For_Allocator_F_Subpool'Access,
Member_Index_For_Allocator_F_Type_Or_Expr => Member_Desc_For_Allocator_F_Type_Or_Expr'Access,
Member_Index_For_Base_Aggregate_F_Ancestor_Expr => Member_Desc_For_Base_Aggregate_F_Ancestor_Expr'Access,
Member_Index_For_Base_Aggregate_F_Assocs => Member_Desc_For_Base_Aggregate_F_Assocs'Access,
Member_Index_For_Bin_Op_F_Left => Member_Desc_For_Bin_Op_F_Left'Access,
Member_Index_For_Bin_Op_F_Op => Member_Desc_For_Bin_Op_F_Op'Access,
Member_Index_For_Bin_Op_F_Right => Member_Desc_For_Bin_Op_F_Right'Access,
Member_Index_For_Case_Expr_Alternative_F_Choices => Member_Desc_For_Case_Expr_Alternative_F_Choices'Access,
Member_Index_For_Case_Expr_Alternative_F_Expr => Member_Desc_For_Case_Expr_Alternative_F_Expr'Access,
Member_Index_For_Concat_Op_F_First_Operand => Member_Desc_For_Concat_Op_F_First_Operand'Access,
Member_Index_For_Concat_Op_F_Other_Operands => Member_Desc_For_Concat_Op_F_Other_Operands'Access,
Member_Index_For_Concat_Operand_F_Operator => Member_Desc_For_Concat_Operand_F_Operator'Access,
Member_Index_For_Concat_Operand_F_Operand => Member_Desc_For_Concat_Operand_F_Operand'Access,
Member_Index_For_Case_Expr_F_Expr => Member_Desc_For_Case_Expr_F_Expr'Access,
Member_Index_For_Case_Expr_F_Cases => Member_Desc_For_Case_Expr_F_Cases'Access,
Member_Index_For_If_Expr_F_Cond_Expr => Member_Desc_For_If_Expr_F_Cond_Expr'Access,
Member_Index_For_If_Expr_F_Then_Expr => Member_Desc_For_If_Expr_F_Then_Expr'Access,
Member_Index_For_If_Expr_F_Alternatives => Member_Desc_For_If_Expr_F_Alternatives'Access,
Member_Index_For_If_Expr_F_Else_Expr => Member_Desc_For_If_Expr_F_Else_Expr'Access,
Member_Index_For_Contract_Cases_F_Contract_Cases => Member_Desc_For_Contract_Cases_F_Contract_Cases'Access,
Member_Index_For_Decl_Expr_F_Decls => Member_Desc_For_Decl_Expr_F_Decls'Access,
Member_Index_For_Decl_Expr_F_Expr => Member_Desc_For_Decl_Expr_F_Expr'Access,
Member_Index_For_Membership_Expr_F_Expr => Member_Desc_For_Membership_Expr_F_Expr'Access,
Member_Index_For_Membership_Expr_F_Op => Member_Desc_For_Membership_Expr_F_Op'Access,
Member_Index_For_Membership_Expr_F_Membership_Exprs => Member_Desc_For_Membership_Expr_F_Membership_Exprs'Access,
Member_Index_For_Attribute_Ref_F_Prefix => Member_Desc_For_Attribute_Ref_F_Prefix'Access,
Member_Index_For_Attribute_Ref_F_Attribute => Member_Desc_For_Attribute_Ref_F_Attribute'Access,
Member_Index_For_Attribute_Ref_F_Args => Member_Desc_For_Attribute_Ref_F_Args'Access,
Member_Index_For_Call_Expr_F_Name => Member_Desc_For_Call_Expr_F_Name'Access,
Member_Index_For_Call_Expr_F_Suffix => Member_Desc_For_Call_Expr_F_Suffix'Access,
Member_Index_For_Defining_Name_F_Name => Member_Desc_For_Defining_Name_F_Name'Access,
Member_Index_For_Discrete_Subtype_Name_F_Subtype => Member_Desc_For_Discrete_Subtype_Name_F_Subtype'Access,
Member_Index_For_Dotted_Name_F_Prefix => Member_Desc_For_Dotted_Name_F_Prefix'Access,
Member_Index_For_Dotted_Name_F_Suffix => Member_Desc_For_Dotted_Name_F_Suffix'Access,
Member_Index_For_End_Name_F_Name => Member_Desc_For_End_Name_F_Name'Access,
Member_Index_For_Explicit_Deref_F_Prefix => Member_Desc_For_Explicit_Deref_F_Prefix'Access,
Member_Index_For_Qual_Expr_F_Prefix => Member_Desc_For_Qual_Expr_F_Prefix'Access,
Member_Index_For_Qual_Expr_F_Suffix => Member_Desc_For_Qual_Expr_F_Suffix'Access,
Member_Index_For_Reduce_Attribute_Ref_F_Prefix => Member_Desc_For_Reduce_Attribute_Ref_F_Prefix'Access,
Member_Index_For_Reduce_Attribute_Ref_F_Attribute => Member_Desc_For_Reduce_Attribute_Ref_F_Attribute'Access,
Member_Index_For_Reduce_Attribute_Ref_F_Args => Member_Desc_For_Reduce_Attribute_Ref_F_Args'Access,
Member_Index_For_Update_Attribute_Ref_F_Prefix => Member_Desc_For_Update_Attribute_Ref_F_Prefix'Access,
Member_Index_For_Update_Attribute_Ref_F_Attribute => Member_Desc_For_Update_Attribute_Ref_F_Attribute'Access,
Member_Index_For_Update_Attribute_Ref_F_Values => Member_Desc_For_Update_Attribute_Ref_F_Values'Access,
Member_Index_For_Paren_Expr_F_Expr => Member_Desc_For_Paren_Expr_F_Expr'Access,
Member_Index_For_Quantified_Expr_F_Quantifier => Member_Desc_For_Quantified_Expr_F_Quantifier'Access,
Member_Index_For_Quantified_Expr_F_Loop_Spec => Member_Desc_For_Quantified_Expr_F_Loop_Spec'Access,
Member_Index_For_Quantified_Expr_F_Expr => Member_Desc_For_Quantified_Expr_F_Expr'Access,
Member_Index_For_Raise_Expr_F_Exception_Name => Member_Desc_For_Raise_Expr_F_Exception_Name'Access,
Member_Index_For_Raise_Expr_F_Error_Message => Member_Desc_For_Raise_Expr_F_Error_Message'Access,
Member_Index_For_Un_Op_F_Op => Member_Desc_For_Un_Op_F_Op'Access,
Member_Index_For_Un_Op_F_Expr => Member_Desc_For_Un_Op_F_Expr'Access,
Member_Index_For_Handled_Stmts_F_Stmts => Member_Desc_For_Handled_Stmts_F_Stmts'Access,
Member_Index_For_Handled_Stmts_F_Exceptions => Member_Desc_For_Handled_Stmts_F_Exceptions'Access,
Member_Index_For_Library_Item_F_Has_Private => Member_Desc_For_Library_Item_F_Has_Private'Access,
Member_Index_For_Library_Item_F_Item => Member_Desc_For_Library_Item_F_Item'Access,
Member_Index_For_For_Loop_Spec_F_Var_Decl => Member_Desc_For_For_Loop_Spec_F_Var_Decl'Access,
Member_Index_For_For_Loop_Spec_F_Loop_Type => Member_Desc_For_For_Loop_Spec_F_Loop_Type'Access,
Member_Index_For_For_Loop_Spec_F_Has_Reverse => Member_Desc_For_For_Loop_Spec_F_Has_Reverse'Access,
Member_Index_For_For_Loop_Spec_F_Iter_Expr => Member_Desc_For_For_Loop_Spec_F_Iter_Expr'Access,
Member_Index_For_For_Loop_Spec_F_Iter_Filter => Member_Desc_For_For_Loop_Spec_F_Iter_Filter'Access,
Member_Index_For_While_Loop_Spec_F_Expr => Member_Desc_For_While_Loop_Spec_F_Expr'Access,
Member_Index_For_Multi_Abstract_State_Decl_F_Decls => Member_Desc_For_Multi_Abstract_State_Decl_F_Decls'Access,
Member_Index_For_Params_F_Params => Member_Desc_For_Params_F_Params'Access,
Member_Index_For_Paren_Abstract_State_Decl_F_Decl => Member_Desc_For_Paren_Abstract_State_Decl_F_Decl'Access,
Member_Index_For_Pp_Elsif_Directive_F_Expr => Member_Desc_For_Pp_Elsif_Directive_F_Expr'Access,
Member_Index_For_Pp_Elsif_Directive_F_Then_Kw => Member_Desc_For_Pp_Elsif_Directive_F_Then_Kw'Access,
Member_Index_For_Pp_If_Directive_F_Expr => Member_Desc_For_Pp_If_Directive_F_Expr'Access,
Member_Index_For_Pp_If_Directive_F_Then_Kw => Member_Desc_For_Pp_If_Directive_F_Then_Kw'Access,
Member_Index_For_Pragma_Node_F_Id => Member_Desc_For_Pragma_Node_F_Id'Access,
Member_Index_For_Pragma_Node_F_Args => Member_Desc_For_Pragma_Node_F_Args'Access,
Member_Index_For_Protected_Def_F_Public_Part => Member_Desc_For_Protected_Def_F_Public_Part'Access,
Member_Index_For_Protected_Def_F_Private_Part => Member_Desc_For_Protected_Def_F_Private_Part'Access,
Member_Index_For_Protected_Def_F_End_Name => Member_Desc_For_Protected_Def_F_End_Name'Access,
Member_Index_For_Range_Spec_F_Range => Member_Desc_For_Range_Spec_F_Range'Access,
Member_Index_For_Renaming_Clause_F_Renamed_Object => Member_Desc_For_Renaming_Clause_F_Renamed_Object'Access,
Member_Index_For_Select_When_Part_F_Cond_Expr => Member_Desc_For_Select_When_Part_F_Cond_Expr'Access,
Member_Index_For_Select_When_Part_F_Stmts => Member_Desc_For_Select_When_Part_F_Stmts'Access,
Member_Index_For_Accept_Stmt_F_Name => Member_Desc_For_Accept_Stmt_F_Name'Access,
Member_Index_For_Accept_Stmt_F_Entry_Index_Expr => Member_Desc_For_Accept_Stmt_F_Entry_Index_Expr'Access,
Member_Index_For_Accept_Stmt_F_Params => Member_Desc_For_Accept_Stmt_F_Params'Access,
Member_Index_For_Accept_Stmt_With_Stmts_F_Stmts => Member_Desc_For_Accept_Stmt_With_Stmts_F_Stmts'Access,
Member_Index_For_Accept_Stmt_With_Stmts_F_End_Name => Member_Desc_For_Accept_Stmt_With_Stmts_F_End_Name'Access,
Member_Index_For_Base_Loop_Stmt_F_Spec => Member_Desc_For_Base_Loop_Stmt_F_Spec'Access,
Member_Index_For_Base_Loop_Stmt_F_Stmts => Member_Desc_For_Base_Loop_Stmt_F_Stmts'Access,
Member_Index_For_Base_Loop_Stmt_F_End_Name => Member_Desc_For_Base_Loop_Stmt_F_End_Name'Access,
Member_Index_For_Begin_Block_F_Stmts => Member_Desc_For_Begin_Block_F_Stmts'Access,
Member_Index_For_Begin_Block_F_End_Name => Member_Desc_For_Begin_Block_F_End_Name'Access,
Member_Index_For_Decl_Block_F_Decls => Member_Desc_For_Decl_Block_F_Decls'Access,
Member_Index_For_Decl_Block_F_Stmts => Member_Desc_For_Decl_Block_F_Stmts'Access,
Member_Index_For_Decl_Block_F_End_Name => Member_Desc_For_Decl_Block_F_End_Name'Access,
Member_Index_For_Case_Stmt_F_Expr => Member_Desc_For_Case_Stmt_F_Expr'Access,
Member_Index_For_Case_Stmt_F_Pragmas => Member_Desc_For_Case_Stmt_F_Pragmas'Access,
Member_Index_For_Case_Stmt_F_Alternatives => Member_Desc_For_Case_Stmt_F_Alternatives'Access,
Member_Index_For_Extended_Return_Stmt_F_Decl => Member_Desc_For_Extended_Return_Stmt_F_Decl'Access,
Member_Index_For_Extended_Return_Stmt_F_Stmts => Member_Desc_For_Extended_Return_Stmt_F_Stmts'Access,
Member_Index_For_If_Stmt_F_Cond_Expr => Member_Desc_For_If_Stmt_F_Cond_Expr'Access,
Member_Index_For_If_Stmt_F_Then_Stmts => Member_Desc_For_If_Stmt_F_Then_Stmts'Access,
Member_Index_For_If_Stmt_F_Alternatives => Member_Desc_For_If_Stmt_F_Alternatives'Access,
Member_Index_For_If_Stmt_F_Else_Stmts => Member_Desc_For_If_Stmt_F_Else_Stmts'Access,
Member_Index_For_Named_Stmt_F_Decl => Member_Desc_For_Named_Stmt_F_Decl'Access,
Member_Index_For_Named_Stmt_F_Stmt => Member_Desc_For_Named_Stmt_F_Stmt'Access,
Member_Index_For_Select_Stmt_F_Guards => Member_Desc_For_Select_Stmt_F_Guards'Access,
Member_Index_For_Select_Stmt_F_Else_Stmts => Member_Desc_For_Select_Stmt_F_Else_Stmts'Access,
Member_Index_For_Select_Stmt_F_Abort_Stmts => Member_Desc_For_Select_Stmt_F_Abort_Stmts'Access,
Member_Index_For_Abort_Stmt_F_Names => Member_Desc_For_Abort_Stmt_F_Names'Access,
Member_Index_For_Assign_Stmt_F_Dest => Member_Desc_For_Assign_Stmt_F_Dest'Access,
Member_Index_For_Assign_Stmt_F_Expr => Member_Desc_For_Assign_Stmt_F_Expr'Access,
Member_Index_For_Call_Stmt_F_Call => Member_Desc_For_Call_Stmt_F_Call'Access,
Member_Index_For_Delay_Stmt_F_Has_Until => Member_Desc_For_Delay_Stmt_F_Has_Until'Access,
Member_Index_For_Delay_Stmt_F_Expr => Member_Desc_For_Delay_Stmt_F_Expr'Access,
Member_Index_For_Exit_Stmt_F_Loop_Name => Member_Desc_For_Exit_Stmt_F_Loop_Name'Access,
Member_Index_For_Exit_Stmt_F_Cond_Expr => Member_Desc_For_Exit_Stmt_F_Cond_Expr'Access,
Member_Index_For_Goto_Stmt_F_Label_Name => Member_Desc_For_Goto_Stmt_F_Label_Name'Access,
Member_Index_For_Label_F_Decl => Member_Desc_For_Label_F_Decl'Access,
Member_Index_For_Raise_Stmt_F_Exception_Name => Member_Desc_For_Raise_Stmt_F_Exception_Name'Access,
Member_Index_For_Raise_Stmt_F_Error_Message => Member_Desc_For_Raise_Stmt_F_Error_Message'Access,
Member_Index_For_Requeue_Stmt_F_Call_Name => Member_Desc_For_Requeue_Stmt_F_Call_Name'Access,
Member_Index_For_Requeue_Stmt_F_Has_Abort => Member_Desc_For_Requeue_Stmt_F_Has_Abort'Access,
Member_Index_For_Return_Stmt_F_Return_Expr => Member_Desc_For_Return_Stmt_F_Return_Expr'Access,
Member_Index_For_Subunit_F_Name => Member_Desc_For_Subunit_F_Name'Access,
Member_Index_For_Subunit_F_Body => Member_Desc_For_Subunit_F_Body'Access,
Member_Index_For_Task_Def_F_Interfaces => Member_Desc_For_Task_Def_F_Interfaces'Access,
Member_Index_For_Task_Def_F_Public_Part => Member_Desc_For_Task_Def_F_Public_Part'Access,
Member_Index_For_Task_Def_F_Private_Part => Member_Desc_For_Task_Def_F_Private_Part'Access,
Member_Index_For_Task_Def_F_End_Name => Member_Desc_For_Task_Def_F_End_Name'Access,
Member_Index_For_Access_Def_F_Has_Not_Null => Member_Desc_For_Access_Def_F_Has_Not_Null'Access,
Member_Index_For_Access_To_Subp_Def_F_Has_Protected => Member_Desc_For_Access_To_Subp_Def_F_Has_Protected'Access,
Member_Index_For_Access_To_Subp_Def_F_Subp_Spec => Member_Desc_For_Access_To_Subp_Def_F_Subp_Spec'Access,
Member_Index_For_Anonymous_Type_Access_Def_F_Type_Decl => Member_Desc_For_Anonymous_Type_Access_Def_F_Type_Decl'Access,
Member_Index_For_Type_Access_Def_F_Has_All => Member_Desc_For_Type_Access_Def_F_Has_All'Access,
Member_Index_For_Type_Access_Def_F_Has_Constant => Member_Desc_For_Type_Access_Def_F_Has_Constant'Access,
Member_Index_For_Type_Access_Def_F_Subtype_Indication => Member_Desc_For_Type_Access_Def_F_Subtype_Indication'Access,
Member_Index_For_Array_Type_Def_F_Indices => Member_Desc_For_Array_Type_Def_F_Indices'Access,
Member_Index_For_Array_Type_Def_F_Component_Type => Member_Desc_For_Array_Type_Def_F_Component_Type'Access,
Member_Index_For_Derived_Type_Def_F_Has_Abstract => Member_Desc_For_Derived_Type_Def_F_Has_Abstract'Access,
Member_Index_For_Derived_Type_Def_F_Has_Limited => Member_Desc_For_Derived_Type_Def_F_Has_Limited'Access,
Member_Index_For_Derived_Type_Def_F_Has_Synchronized => Member_Desc_For_Derived_Type_Def_F_Has_Synchronized'Access,
Member_Index_For_Derived_Type_Def_F_Subtype_Indication => Member_Desc_For_Derived_Type_Def_F_Subtype_Indication'Access,
Member_Index_For_Derived_Type_Def_F_Interfaces => Member_Desc_For_Derived_Type_Def_F_Interfaces'Access,
Member_Index_For_Derived_Type_Def_F_Record_Extension => Member_Desc_For_Derived_Type_Def_F_Record_Extension'Access,
Member_Index_For_Derived_Type_Def_F_Has_With_Private => Member_Desc_For_Derived_Type_Def_F_Has_With_Private'Access,
Member_Index_For_Enum_Type_Def_F_Enum_Literals => Member_Desc_For_Enum_Type_Def_F_Enum_Literals'Access,
Member_Index_For_Interface_Type_Def_F_Interface_Kind => Member_Desc_For_Interface_Type_Def_F_Interface_Kind'Access,
Member_Index_For_Interface_Type_Def_F_Interfaces => Member_Desc_For_Interface_Type_Def_F_Interfaces'Access,
Member_Index_For_Mod_Int_Type_Def_F_Expr => Member_Desc_For_Mod_Int_Type_Def_F_Expr'Access,
Member_Index_For_Private_Type_Def_F_Has_Abstract => Member_Desc_For_Private_Type_Def_F_Has_Abstract'Access,
Member_Index_For_Private_Type_Def_F_Has_Tagged => Member_Desc_For_Private_Type_Def_F_Has_Tagged'Access,
Member_Index_For_Private_Type_Def_F_Has_Limited => Member_Desc_For_Private_Type_Def_F_Has_Limited'Access,
Member_Index_For_Decimal_Fixed_Point_Def_F_Delta => Member_Desc_For_Decimal_Fixed_Point_Def_F_Delta'Access,
Member_Index_For_Decimal_Fixed_Point_Def_F_Digits => Member_Desc_For_Decimal_Fixed_Point_Def_F_Digits'Access,
Member_Index_For_Decimal_Fixed_Point_Def_F_Range => Member_Desc_For_Decimal_Fixed_Point_Def_F_Range'Access,
Member_Index_For_Floating_Point_Def_F_Num_Digits => Member_Desc_For_Floating_Point_Def_F_Num_Digits'Access,
Member_Index_For_Floating_Point_Def_F_Range => Member_Desc_For_Floating_Point_Def_F_Range'Access,
Member_Index_For_Ordinary_Fixed_Point_Def_F_Delta => Member_Desc_For_Ordinary_Fixed_Point_Def_F_Delta'Access,
Member_Index_For_Ordinary_Fixed_Point_Def_F_Range => Member_Desc_For_Ordinary_Fixed_Point_Def_F_Range'Access,
Member_Index_For_Record_Type_Def_F_Has_Abstract => Member_Desc_For_Record_Type_Def_F_Has_Abstract'Access,
Member_Index_For_Record_Type_Def_F_Has_Tagged => Member_Desc_For_Record_Type_Def_F_Has_Tagged'Access,
Member_Index_For_Record_Type_Def_F_Has_Limited => Member_Desc_For_Record_Type_Def_F_Has_Limited'Access,
Member_Index_For_Record_Type_Def_F_Record_Def => Member_Desc_For_Record_Type_Def_F_Record_Def'Access,
Member_Index_For_Signed_Int_Type_Def_F_Range => Member_Desc_For_Signed_Int_Type_Def_F_Range'Access,
Member_Index_For_Anonymous_Type_F_Type_Decl => Member_Desc_For_Anonymous_Type_F_Type_Decl'Access,
Member_Index_For_Subtype_Indication_F_Has_Not_Null => Member_Desc_For_Subtype_Indication_F_Has_Not_Null'Access,
Member_Index_For_Subtype_Indication_F_Name => Member_Desc_For_Subtype_Indication_F_Name'Access,
Member_Index_For_Subtype_Indication_F_Constraint => Member_Desc_For_Subtype_Indication_F_Constraint'Access,
Member_Index_For_Synthetic_Type_Expr_F_Target_Type => Member_Desc_For_Synthetic_Type_Expr_F_Target_Type'Access,
Member_Index_For_Unconstrained_Array_Index_F_Subtype_Indication => Member_Desc_For_Unconstrained_Array_Index_F_Subtype_Indication'Access,
Member_Index_For_Use_Package_Clause_F_Packages => Member_Desc_For_Use_Package_Clause_F_Packages'Access,
Member_Index_For_Use_Type_Clause_F_Has_All => Member_Desc_For_Use_Type_Clause_F_Has_All'Access,
Member_Index_For_Use_Type_Clause_F_Types => Member_Desc_For_Use_Type_Clause_F_Types'Access,
Member_Index_For_Value_Sequence_F_Iter_Assoc => Member_Desc_For_Value_Sequence_F_Iter_Assoc'Access,
Member_Index_For_Variant_F_Choices => Member_Desc_For_Variant_F_Choices'Access,
Member_Index_For_Variant_F_Components => Member_Desc_For_Variant_F_Components'Access,
Member_Index_For_Variant_Part_F_Discr_Name => Member_Desc_For_Variant_Part_F_Discr_Name'Access,
Member_Index_For_Variant_Part_F_Variant => Member_Desc_For_Variant_Part_F_Variant'Access,
Member_Index_For_With_Clause_F_Has_Limited => Member_Desc_For_With_Clause_F_Has_Limited'Access,
Member_Index_For_With_Clause_F_Has_Private => Member_Desc_For_With_Clause_F_Has_Private'Access,
Member_Index_For_With_Clause_F_Packages => Member_Desc_For_With_Clause_F_Packages'Access,
Member_Index_For_Ada_Node_P_Declarative_Scope => Member_Desc_For_Ada_Node_P_Declarative_Scope'Access,
Member_Index_For_Ada_Node_P_Enclosing_Compilation_Unit => Member_Desc_For_Ada_Node_P_Enclosing_Compilation_Unit'Access,
Member_Index_For_Ada_Node_P_Get_Uninstantiated_Node => Member_Desc_For_Ada_Node_P_Get_Uninstantiated_Node'Access,
Member_Index_For_Ada_Node_P_Complete => Member_Desc_For_Ada_Node_P_Complete'Access,
Member_Index_For_Ada_Node_P_Valid_Keywords => Member_Desc_For_Ada_Node_P_Valid_Keywords'Access,
Member_Index_For_Ada_Node_P_Generic_Instantiations => Member_Desc_For_Ada_Node_P_Generic_Instantiations'Access,
Member_Index_For_Ada_Node_P_Semantic_Parent => Member_Desc_For_Ada_Node_P_Semantic_Parent'Access,
Member_Index_For_Ada_Node_P_Parent_Basic_Decl => Member_Desc_For_Ada_Node_P_Parent_Basic_Decl'Access,
Member_Index_For_Ada_Node_P_Filter_Is_Imported_By => Member_Desc_For_Ada_Node_P_Filter_Is_Imported_By'Access,
Member_Index_For_Ada_Node_P_Xref_Entry_Point => Member_Desc_For_Ada_Node_P_Xref_Entry_Point'Access,
Member_Index_For_Ada_Node_P_Resolve_Names => Member_Desc_For_Ada_Node_P_Resolve_Names'Access,
Member_Index_For_Ada_Node_P_Standard_Unit => Member_Desc_For_Ada_Node_P_Standard_Unit'Access,
Member_Index_For_Ada_Node_P_Std_Entity => Member_Desc_For_Ada_Node_P_Std_Entity'Access,
Member_Index_For_Ada_Node_P_Bool_Type => Member_Desc_For_Ada_Node_P_Bool_Type'Access,
Member_Index_For_Ada_Node_P_Int_Type => Member_Desc_For_Ada_Node_P_Int_Type'Access,
Member_Index_For_Ada_Node_P_Universal_Int_Type => Member_Desc_For_Ada_Node_P_Universal_Int_Type'Access,
Member_Index_For_Ada_Node_P_Universal_Real_Type => Member_Desc_For_Ada_Node_P_Universal_Real_Type'Access,
Member_Index_For_Ada_Node_P_Std_Char_Type => Member_Desc_For_Ada_Node_P_Std_Char_Type'Access,
Member_Index_For_Ada_Node_P_Std_Wide_Char_Type => Member_Desc_For_Ada_Node_P_Std_Wide_Char_Type'Access,
Member_Index_For_Ada_Node_P_Std_Wide_Wide_Char_Type => Member_Desc_For_Ada_Node_P_Std_Wide_Wide_Char_Type'Access,
Member_Index_For_Ada_Node_P_Top_Level_Decl => Member_Desc_For_Ada_Node_P_Top_Level_Decl'Access,
Member_Index_For_Ada_Node_P_Choice_Match => Member_Desc_For_Ada_Node_P_Choice_Match'Access,
Member_Index_For_Ada_Node_P_Gnat_Xref => Member_Desc_For_Ada_Node_P_Gnat_Xref'Access,
Member_Index_For_Parent => Member_Desc_For_Parent'Access,
Member_Index_For_Parents => Member_Desc_For_Parents'Access,
Member_Index_For_Children => Member_Desc_For_Children'Access,
Member_Index_For_Token_Start => Member_Desc_For_Token_Start'Access,
Member_Index_For_Token_End => Member_Desc_For_Token_End'Access,
Member_Index_For_Child_Index => Member_Desc_For_Child_Index'Access,
Member_Index_For_Previous_Sibling => Member_Desc_For_Previous_Sibling'Access,
Member_Index_For_Next_Sibling => Member_Desc_For_Next_Sibling'Access,
Member_Index_For_Unit => Member_Desc_For_Unit'Access,
Member_Index_For_Is_Ghost => Member_Desc_For_Is_Ghost'Access,
Member_Index_For_Full_Sloc_Image => Member_Desc_For_Full_Sloc_Image'Access,
Member_Index_For_Abort_Node_P_As_Bool => Member_Desc_For_Abort_Node_P_As_Bool'Access,
Member_Index_For_Abstract_Node_P_As_Bool => Member_Desc_For_Abstract_Node_P_As_Bool'Access,
Member_Index_For_Assoc_List_P_Zip_With_Params => Member_Desc_For_Assoc_List_P_Zip_With_Params'Access,
Member_Index_For_Aliased_Node_P_As_Bool => Member_Desc_For_Aliased_Node_P_As_Bool'Access,
Member_Index_For_All_Node_P_As_Bool => Member_Desc_For_All_Node_P_As_Bool'Access,
Member_Index_For_Aspect_Assoc_P_Is_Ghost_Code => Member_Desc_For_Aspect_Assoc_P_Is_Ghost_Code'Access,
Member_Index_For_Enum_Rep_Clause_P_Params => Member_Desc_For_Enum_Rep_Clause_P_Params'Access,
Member_Index_For_Base_Assoc_P_Assoc_Expr => Member_Desc_For_Base_Assoc_P_Assoc_Expr'Access,
Member_Index_For_Base_Formal_Param_Holder_P_Abstract_Formal_Params => Member_Desc_For_Base_Formal_Param_Holder_P_Abstract_Formal_Params'Access,
Member_Index_For_Base_Formal_Param_Holder_P_Formal_Params => Member_Desc_For_Base_Formal_Param_Holder_P_Formal_Params'Access,
Member_Index_For_Base_Formal_Param_Holder_P_Nb_Min_Params => Member_Desc_For_Base_Formal_Param_Holder_P_Nb_Min_Params'Access,
Member_Index_For_Base_Formal_Param_Holder_P_Nb_Max_Params => Member_Desc_For_Base_Formal_Param_Holder_P_Nb_Max_Params'Access,
Member_Index_For_Base_Formal_Param_Holder_P_Param_Types => Member_Desc_For_Base_Formal_Param_Holder_P_Param_Types'Access,
Member_Index_For_Base_Subp_Spec_P_Returns => Member_Desc_For_Base_Subp_Spec_P_Returns'Access,
Member_Index_For_Base_Subp_Spec_P_Params => Member_Desc_For_Base_Subp_Spec_P_Params'Access,
Member_Index_For_Base_Subp_Spec_P_Primitive_Subp_Types => Member_Desc_For_Base_Subp_Spec_P_Primitive_Subp_Types'Access,
Member_Index_For_Base_Subp_Spec_P_Primitive_Subp_First_Type => Member_Desc_For_Base_Subp_Spec_P_Primitive_Subp_First_Type'Access,
Member_Index_For_Base_Subp_Spec_P_Primitive_Subp_Tagged_Type => Member_Desc_For_Base_Subp_Spec_P_Primitive_Subp_Tagged_Type'Access,
Member_Index_For_Base_Subp_Spec_P_Return_Type => Member_Desc_For_Base_Subp_Spec_P_Return_Type'Access,
Member_Index_For_Basic_Assoc_P_Get_Params => Member_Desc_For_Basic_Assoc_P_Get_Params'Access,
Member_Index_For_Basic_Decl_P_Is_Formal => Member_Desc_For_Basic_Decl_P_Is_Formal'Access,
Member_Index_For_Basic_Decl_P_Doc_Annotations => Member_Desc_For_Basic_Decl_P_Doc_Annotations'Access,
Member_Index_For_Basic_Decl_P_Doc => Member_Desc_For_Basic_Decl_P_Doc'Access,
Member_Index_For_Basic_Decl_P_Previous_Part_For_Decl => Member_Desc_For_Basic_Decl_P_Previous_Part_For_Decl'Access,
Member_Index_For_Basic_Decl_P_Canonical_Part => Member_Desc_For_Basic_Decl_P_Canonical_Part'Access,
Member_Index_For_Basic_Decl_P_All_Parts => Member_Desc_For_Basic_Decl_P_All_Parts'Access,
Member_Index_For_Basic_Decl_P_Is_Static_Decl => Member_Desc_For_Basic_Decl_P_Is_Static_Decl'Access,
Member_Index_For_Basic_Decl_P_Get_Aspect_Assoc => Member_Desc_For_Basic_Decl_P_Get_Aspect_Assoc'Access,
Member_Index_For_Basic_Decl_P_Get_Aspect_Spec_Expr => Member_Desc_For_Basic_Decl_P_Get_Aspect_Spec_Expr'Access,
Member_Index_For_Basic_Decl_P_Get_Aspect => Member_Desc_For_Basic_Decl_P_Get_Aspect'Access,
Member_Index_For_Basic_Decl_P_Has_Aspect => Member_Desc_For_Basic_Decl_P_Has_Aspect'Access,
Member_Index_For_Basic_Decl_P_Get_Pragma => Member_Desc_For_Basic_Decl_P_Get_Pragma'Access,
Member_Index_For_Basic_Decl_P_Get_Representation_Clause => Member_Desc_For_Basic_Decl_P_Get_Representation_Clause'Access,
Member_Index_For_Basic_Decl_P_Get_At_Clause => Member_Desc_For_Basic_Decl_P_Get_At_Clause'Access,
Member_Index_For_Basic_Decl_P_Is_Imported => Member_Desc_For_Basic_Decl_P_Is_Imported'Access,
Member_Index_For_Basic_Decl_P_Is_Ghost_Code => Member_Desc_For_Basic_Decl_P_Is_Ghost_Code'Access,
Member_Index_For_Basic_Decl_P_Is_Compilation_Unit_Root => Member_Desc_For_Basic_Decl_P_Is_Compilation_Unit_Root'Access,
Member_Index_For_Basic_Decl_P_Is_Visible => Member_Desc_For_Basic_Decl_P_Is_Visible'Access,
Member_Index_For_Basic_Decl_P_Base_Subp_Declarations => Member_Desc_For_Basic_Decl_P_Base_Subp_Declarations'Access,
Member_Index_For_Basic_Decl_P_Root_Subp_Declarations => Member_Desc_For_Basic_Decl_P_Root_Subp_Declarations'Access,
Member_Index_For_Basic_Decl_P_Find_All_Overrides => Member_Desc_For_Basic_Decl_P_Find_All_Overrides'Access,
Member_Index_For_Basic_Decl_P_Defining_Names => Member_Desc_For_Basic_Decl_P_Defining_Names'Access,
Member_Index_For_Basic_Decl_P_Defining_Name => Member_Desc_For_Basic_Decl_P_Defining_Name'Access,
Member_Index_For_Basic_Decl_P_Type_Expression => Member_Desc_For_Basic_Decl_P_Type_Expression'Access,
Member_Index_For_Basic_Decl_P_Subp_Spec_Or_Null => Member_Desc_For_Basic_Decl_P_Subp_Spec_Or_Null'Access,
Member_Index_For_Basic_Decl_P_Is_Subprogram => Member_Desc_For_Basic_Decl_P_Is_Subprogram'Access,
Member_Index_For_Basic_Decl_P_Relative_Name => Member_Desc_For_Basic_Decl_P_Relative_Name'Access,
Member_Index_For_Basic_Decl_P_Relative_Name_Text => Member_Desc_For_Basic_Decl_P_Relative_Name_Text'Access,
Member_Index_For_Basic_Decl_P_Next_Part_For_Decl => Member_Desc_For_Basic_Decl_P_Next_Part_For_Decl'Access,
Member_Index_For_Basic_Decl_P_Body_Part_For_Decl => Member_Desc_For_Basic_Decl_P_Body_Part_For_Decl'Access,
Member_Index_For_Basic_Decl_P_Most_Visible_Part => Member_Desc_For_Basic_Decl_P_Most_Visible_Part'Access,
Member_Index_For_Basic_Decl_P_Fully_Qualified_Name_Array => Member_Desc_For_Basic_Decl_P_Fully_Qualified_Name_Array'Access,
Member_Index_For_Basic_Decl_P_Fully_Qualified_Name => Member_Desc_For_Basic_Decl_P_Fully_Qualified_Name'Access,
Member_Index_For_Basic_Decl_P_Canonical_Fully_Qualified_Name => Member_Desc_For_Basic_Decl_P_Canonical_Fully_Qualified_Name'Access,
Member_Index_For_Basic_Decl_P_Unique_Identifying_Name => Member_Desc_For_Basic_Decl_P_Unique_Identifying_Name'Access,
Member_Index_For_Basic_Decl_P_Is_Constant_Object => Member_Desc_For_Basic_Decl_P_Is_Constant_Object'Access,
Member_Index_For_Anonymous_Expr_Decl_P_Get_Formal => Member_Desc_For_Anonymous_Expr_Decl_P_Get_Formal'Access,
Member_Index_For_Base_Formal_Param_Decl_P_Formal_Type => Member_Desc_For_Base_Formal_Param_Decl_P_Formal_Type'Access,
Member_Index_For_Base_Package_Decl_P_Body_Part => Member_Desc_For_Base_Package_Decl_P_Body_Part'Access,
Member_Index_For_Base_Type_Decl_P_Base_Subtype => Member_Desc_For_Base_Type_Decl_P_Base_Subtype'Access,
Member_Index_For_Base_Type_Decl_P_Private_Completion => Member_Desc_For_Base_Type_Decl_P_Private_Completion'Access,
Member_Index_For_Base_Type_Decl_P_Is_Inherited_Primitive => Member_Desc_For_Base_Type_Decl_P_Is_Inherited_Primitive'Access,
Member_Index_For_Base_Type_Decl_P_Get_Record_Representation_Clause => Member_Desc_For_Base_Type_Decl_P_Get_Record_Representation_Clause'Access,
Member_Index_For_Base_Type_Decl_P_Get_Enum_Representation_Clause => Member_Desc_For_Base_Type_Decl_P_Get_Enum_Representation_Clause'Access,
Member_Index_For_Base_Type_Decl_P_Is_Record_Type => Member_Desc_For_Base_Type_Decl_P_Is_Record_Type'Access,
Member_Index_For_Base_Type_Decl_P_Is_Array_Type => Member_Desc_For_Base_Type_Decl_P_Is_Array_Type'Access,
Member_Index_For_Base_Type_Decl_P_Find_Derived_Types => Member_Desc_For_Base_Type_Decl_P_Find_Derived_Types'Access,
Member_Index_For_Base_Type_Decl_P_Is_Real_Type => Member_Desc_For_Base_Type_Decl_P_Is_Real_Type'Access,
Member_Index_For_Base_Type_Decl_P_Is_Float_Type => Member_Desc_For_Base_Type_Decl_P_Is_Float_Type'Access,
Member_Index_For_Base_Type_Decl_P_Is_Fixed_Point => Member_Desc_For_Base_Type_Decl_P_Is_Fixed_Point'Access,
Member_Index_For_Base_Type_Decl_P_Is_Enum_Type => Member_Desc_For_Base_Type_Decl_P_Is_Enum_Type'Access,
Member_Index_For_Base_Type_Decl_P_Is_Access_Type => Member_Desc_For_Base_Type_Decl_P_Is_Access_Type'Access,
Member_Index_For_Base_Type_Decl_P_Is_Char_Type => Member_Desc_For_Base_Type_Decl_P_Is_Char_Type'Access,
Member_Index_For_Base_Type_Decl_P_Discrete_Range => Member_Desc_For_Base_Type_Decl_P_Discrete_Range'Access,
Member_Index_For_Base_Type_Decl_P_Is_Discrete_Type => Member_Desc_For_Base_Type_Decl_P_Is_Discrete_Type'Access,
Member_Index_For_Base_Type_Decl_P_Is_Int_Type => Member_Desc_For_Base_Type_Decl_P_Is_Int_Type'Access,
Member_Index_For_Base_Type_Decl_P_Accessed_Type => Member_Desc_For_Base_Type_Decl_P_Accessed_Type'Access,
Member_Index_For_Base_Type_Decl_P_Is_Tagged_Type => Member_Desc_For_Base_Type_Decl_P_Is_Tagged_Type'Access,
Member_Index_For_Base_Type_Decl_P_Base_Type => Member_Desc_For_Base_Type_Decl_P_Base_Type'Access,
Member_Index_For_Base_Type_Decl_P_Base_Types => Member_Desc_For_Base_Type_Decl_P_Base_Types'Access,
Member_Index_For_Base_Type_Decl_P_Find_All_Derived_Types => Member_Desc_For_Base_Type_Decl_P_Find_All_Derived_Types'Access,
Member_Index_For_Base_Type_Decl_P_Comp_Type => Member_Desc_For_Base_Type_Decl_P_Comp_Type'Access,
Member_Index_For_Base_Type_Decl_P_Index_Type => Member_Desc_For_Base_Type_Decl_P_Index_Type'Access,
Member_Index_For_Base_Type_Decl_P_Is_Derived_Type => Member_Desc_For_Base_Type_Decl_P_Is_Derived_Type'Access,
Member_Index_For_Base_Type_Decl_P_Is_Interface_Type => Member_Desc_For_Base_Type_Decl_P_Is_Interface_Type'Access,
Member_Index_For_Base_Type_Decl_P_Matching_Type => Member_Desc_For_Base_Type_Decl_P_Matching_Type'Access,
Member_Index_For_Base_Type_Decl_P_Canonical_Type => Member_Desc_For_Base_Type_Decl_P_Canonical_Type'Access,
Member_Index_For_Base_Type_Decl_P_Previous_Part => Member_Desc_For_Base_Type_Decl_P_Previous_Part'Access,
Member_Index_For_Base_Type_Decl_P_Next_Part => Member_Desc_For_Base_Type_Decl_P_Next_Part'Access,
Member_Index_For_Base_Type_Decl_P_Full_View => Member_Desc_For_Base_Type_Decl_P_Full_View'Access,
Member_Index_For_Base_Type_Decl_P_Is_Definite_Subtype => Member_Desc_For_Base_Type_Decl_P_Is_Definite_Subtype'Access,
Member_Index_For_Base_Type_Decl_P_Is_Private => Member_Desc_For_Base_Type_Decl_P_Is_Private'Access,
Member_Index_For_Base_Type_Decl_P_Discriminants_List => Member_Desc_For_Base_Type_Decl_P_Discriminants_List'Access,
Member_Index_For_Base_Type_Decl_P_Root_Type => Member_Desc_For_Base_Type_Decl_P_Root_Type'Access,
Member_Index_For_Base_Type_Decl_P_Shapes => Member_Desc_For_Base_Type_Decl_P_Shapes'Access,
Member_Index_For_Base_Subtype_Decl_P_Get_Type => Member_Desc_For_Base_Subtype_Decl_P_Get_Type'Access,
Member_Index_For_Type_Decl_P_Get_Primitives => Member_Desc_For_Type_Decl_P_Get_Primitives'Access,
Member_Index_For_Basic_Subp_Decl_P_Subp_Decl_Spec => Member_Desc_For_Basic_Subp_Decl_P_Subp_Decl_Spec'Access,
Member_Index_For_Classic_Subp_Decl_P_Body_Part => Member_Desc_For_Classic_Subp_Decl_P_Body_Part'Access,
Member_Index_For_Entry_Decl_P_Body_Part => Member_Desc_For_Entry_Decl_P_Body_Part'Access,
Member_Index_For_Entry_Decl_P_Accept_Stmts => Member_Desc_For_Entry_Decl_P_Accept_Stmts'Access,
Member_Index_For_Enum_Literal_Decl_P_Enum_Type => Member_Desc_For_Enum_Literal_Decl_P_Enum_Type'Access,
Member_Index_For_Synthetic_Char_Enum_Lit_P_Expr => Member_Desc_For_Synthetic_Char_Enum_Lit_P_Expr'Access,
Member_Index_For_Body_Node_P_Previous_Part => Member_Desc_For_Body_Node_P_Previous_Part'Access,
Member_Index_For_Body_Node_P_Decl_Part => Member_Desc_For_Body_Node_P_Decl_Part'Access,
Member_Index_For_Body_Node_P_Subunit_Root => Member_Desc_For_Body_Node_P_Subunit_Root'Access,
Member_Index_For_Body_Stub_P_Syntactic_Fully_Qualified_Name => Member_Desc_For_Body_Stub_P_Syntactic_Fully_Qualified_Name'Access,
Member_Index_For_Generic_Package_Decl_P_Body_Part => Member_Desc_For_Generic_Package_Decl_P_Body_Part'Access,
Member_Index_For_Generic_Subp_Decl_P_Body_Part => Member_Desc_For_Generic_Subp_Decl_P_Body_Part'Access,
Member_Index_For_Generic_Instantiation_P_Designated_Generic_Decl => Member_Desc_For_Generic_Instantiation_P_Designated_Generic_Decl'Access,
Member_Index_For_Generic_Instantiation_P_Inst_Params => Member_Desc_For_Generic_Instantiation_P_Inst_Params'Access,
Member_Index_For_Generic_Subp_Instantiation_P_Designated_Subp => Member_Desc_For_Generic_Subp_Instantiation_P_Designated_Subp'Access,
Member_Index_For_Object_Decl_P_Private_Part_Decl => Member_Desc_For_Object_Decl_P_Private_Part_Decl'Access,
Member_Index_For_Object_Decl_P_Public_Part_Decl => Member_Desc_For_Object_Decl_P_Public_Part_Decl'Access,
Member_Index_For_Package_Renaming_Decl_P_Renamed_Package => Member_Desc_For_Package_Renaming_Decl_P_Renamed_Package'Access,
Member_Index_For_Package_Renaming_Decl_P_Final_Renamed_Package => Member_Desc_For_Package_Renaming_Decl_P_Final_Renamed_Package'Access,
Member_Index_For_Compilation_Unit_P_Syntactic_Fully_Qualified_Name => Member_Desc_For_Compilation_Unit_P_Syntactic_Fully_Qualified_Name'Access,
Member_Index_For_Compilation_Unit_P_Unit_Kind => Member_Desc_For_Compilation_Unit_P_Unit_Kind'Access,
Member_Index_For_Compilation_Unit_P_Withed_Units => Member_Desc_For_Compilation_Unit_P_Withed_Units'Access,
Member_Index_For_Compilation_Unit_P_Imported_Units => Member_Desc_For_Compilation_Unit_P_Imported_Units'Access,
Member_Index_For_Compilation_Unit_P_Unit_Dependencies => Member_Desc_For_Compilation_Unit_P_Unit_Dependencies'Access,
Member_Index_For_Compilation_Unit_P_Decl => Member_Desc_For_Compilation_Unit_P_Decl'Access,
Member_Index_For_Compilation_Unit_P_Is_Preelaborable => Member_Desc_For_Compilation_Unit_P_Is_Preelaborable'Access,
Member_Index_For_Compilation_Unit_P_Other_Part => Member_Desc_For_Compilation_Unit_P_Other_Part'Access,
Member_Index_For_Compilation_Unit_P_Has_Restriction => Member_Desc_For_Compilation_Unit_P_Has_Restriction'Access,
Member_Index_For_Compilation_Unit_P_All_Config_Pragmas => Member_Desc_For_Compilation_Unit_P_All_Config_Pragmas'Access,
Member_Index_For_Compilation_Unit_P_Config_Pragmas => Member_Desc_For_Compilation_Unit_P_Config_Pragmas'Access,
Member_Index_For_Constant_Node_P_As_Bool => Member_Desc_For_Constant_Node_P_As_Bool'Access,
Member_Index_For_Composite_Constraint_P_Is_Index_Constraint => Member_Desc_For_Composite_Constraint_P_Is_Index_Constraint'Access,
Member_Index_For_Composite_Constraint_P_Is_Discriminant_Constraint => Member_Desc_For_Composite_Constraint_P_Is_Discriminant_Constraint'Access,
Member_Index_For_Expr_P_Expression_Type => Member_Desc_For_Expr_P_Expression_Type'Access,
Member_Index_For_Expr_P_Expected_Expression_Type => Member_Desc_For_Expr_P_Expected_Expression_Type'Access,
Member_Index_For_Expr_P_Is_Dynamically_Tagged => Member_Desc_For_Expr_P_Is_Dynamically_Tagged'Access,
Member_Index_For_Expr_P_Is_Dispatching_Call => Member_Desc_For_Expr_P_Is_Dispatching_Call'Access,
Member_Index_For_Expr_P_Is_Static_Expr => Member_Desc_For_Expr_P_Is_Static_Expr'Access,
Member_Index_For_Expr_P_First_Corresponding_Decl => Member_Desc_For_Expr_P_First_Corresponding_Decl'Access,
Member_Index_For_Expr_P_Eval_As_Int => Member_Desc_For_Expr_P_Eval_As_Int'Access,
Member_Index_For_Expr_P_Eval_As_Int_In_Env => Member_Desc_For_Expr_P_Eval_As_Int_In_Env'Access,
Member_Index_For_Expr_P_Eval_As_String => Member_Desc_For_Expr_P_Eval_As_String'Access,
Member_Index_For_Expr_P_Eval_As_String_In_Env => Member_Desc_For_Expr_P_Eval_As_String_In_Env'Access,
Member_Index_For_Expr_P_Matching_Nodes => Member_Desc_For_Expr_P_Matching_Nodes'Access,
Member_Index_For_Allocator_P_Get_Allocated_Type => Member_Desc_For_Allocator_P_Get_Allocated_Type'Access,
Member_Index_For_Base_Aggregate_P_Aggregate_Params => Member_Desc_For_Base_Aggregate_P_Aggregate_Params'Access,
Member_Index_For_Base_Aggregate_P_Is_Subaggregate => Member_Desc_For_Base_Aggregate_P_Is_Subaggregate'Access,
Member_Index_For_Concat_Op_P_Operands => Member_Desc_For_Concat_Op_P_Operands'Access,
Member_Index_For_Cond_Expr_P_Dependent_Exprs => Member_Desc_For_Cond_Expr_P_Dependent_Exprs'Access,
Member_Index_For_Name_P_Enclosing_Defining_Name => Member_Desc_For_Name_P_Enclosing_Defining_Name'Access,
Member_Index_For_Name_P_Is_Defining => Member_Desc_For_Name_P_Is_Defining'Access,
Member_Index_For_Name_P_Name_Is => Member_Desc_For_Name_P_Name_Is'Access,
Member_Index_For_Name_P_Is_Direct_Call => Member_Desc_For_Name_P_Is_Direct_Call'Access,
Member_Index_For_Name_P_Is_Access_Call => Member_Desc_For_Name_P_Is_Access_Call'Access,
Member_Index_For_Name_P_Is_Call => Member_Desc_For_Name_P_Is_Call'Access,
Member_Index_For_Name_P_Is_Dot_Call => Member_Desc_For_Name_P_Is_Dot_Call'Access,
Member_Index_For_Name_P_Failsafe_Referenced_Def_Name => Member_Desc_For_Name_P_Failsafe_Referenced_Def_Name'Access,
Member_Index_For_Name_P_Referenced_Defining_Name => Member_Desc_For_Name_P_Referenced_Defining_Name'Access,
Member_Index_For_Name_P_All_Env_Elements => Member_Desc_For_Name_P_All_Env_Elements'Access,
Member_Index_For_Name_P_Called_Subp_Spec => Member_Desc_For_Name_P_Called_Subp_Spec'Access,
Member_Index_For_Name_P_Referenced_Decl => Member_Desc_For_Name_P_Referenced_Decl'Access,
Member_Index_For_Name_P_Failsafe_Referenced_Decl => Member_Desc_For_Name_P_Failsafe_Referenced_Decl'Access,
Member_Index_For_Name_P_Referenced_Decl_Internal => Member_Desc_For_Name_P_Referenced_Decl_Internal'Access,
Member_Index_For_Name_P_Name_Designated_Type => Member_Desc_For_Name_P_Name_Designated_Type'Access,
Member_Index_For_Name_P_Is_Static_Subtype => Member_Desc_For_Name_P_Is_Static_Subtype'Access,
Member_Index_For_Name_P_Name_Matches => Member_Desc_For_Name_P_Name_Matches'Access,
Member_Index_For_Name_P_Relative_Name => Member_Desc_For_Name_P_Relative_Name'Access,
Member_Index_For_Name_P_Is_Operator_Name => Member_Desc_For_Name_P_Is_Operator_Name'Access,
Member_Index_For_Name_P_Is_Write_Reference => Member_Desc_For_Name_P_Is_Write_Reference'Access,
Member_Index_For_Name_P_Is_Static_Call => Member_Desc_For_Name_P_Is_Static_Call'Access,
Member_Index_For_Name_P_As_Symbol_Array => Member_Desc_For_Name_P_As_Symbol_Array'Access,
Member_Index_For_Name_P_Canonical_Text => Member_Desc_For_Name_P_Canonical_Text'Access,
Member_Index_For_Name_P_Is_Constant => Member_Desc_For_Name_P_Is_Constant'Access,
Member_Index_For_Name_P_Call_Params => Member_Desc_For_Name_P_Call_Params'Access,
Member_Index_For_Call_Expr_P_Kind => Member_Desc_For_Call_Expr_P_Kind'Access,
Member_Index_For_Call_Expr_P_Is_Array_Slice => Member_Desc_For_Call_Expr_P_Is_Array_Slice'Access,
Member_Index_For_Defining_Name_P_Canonical_Fully_Qualified_Name => Member_Desc_For_Defining_Name_P_Canonical_Fully_Qualified_Name'Access,
Member_Index_For_Defining_Name_P_Unique_Identifying_Name => Member_Desc_For_Defining_Name_P_Unique_Identifying_Name'Access,
Member_Index_For_Defining_Name_P_Fully_Qualified_Name_Array => Member_Desc_For_Defining_Name_P_Fully_Qualified_Name_Array'Access,
Member_Index_For_Defining_Name_P_Fully_Qualified_Name => Member_Desc_For_Defining_Name_P_Fully_Qualified_Name'Access,
Member_Index_For_Defining_Name_P_Basic_Decl => Member_Desc_For_Defining_Name_P_Basic_Decl'Access,
Member_Index_For_Defining_Name_P_Find_Refs => Member_Desc_For_Defining_Name_P_Find_Refs'Access,
Member_Index_For_Defining_Name_P_Find_All_References => Member_Desc_For_Defining_Name_P_Find_All_References'Access,
Member_Index_For_Defining_Name_P_Find_All_Calls => Member_Desc_For_Defining_Name_P_Find_All_Calls'Access,
Member_Index_For_Defining_Name_P_Next_Part => Member_Desc_For_Defining_Name_P_Next_Part'Access,
Member_Index_For_Defining_Name_P_Previous_Part => Member_Desc_For_Defining_Name_P_Previous_Part'Access,
Member_Index_For_Defining_Name_P_Canonical_Part => Member_Desc_For_Defining_Name_P_Canonical_Part'Access,
Member_Index_For_Defining_Name_P_Most_Visible_Part => Member_Desc_For_Defining_Name_P_Most_Visible_Part'Access,
Member_Index_For_Defining_Name_P_All_Parts => Member_Desc_For_Defining_Name_P_All_Parts'Access,
Member_Index_For_Defining_Name_P_Get_Aspect => Member_Desc_For_Defining_Name_P_Get_Aspect'Access,
Member_Index_For_Defining_Name_P_Has_Aspect => Member_Desc_For_Defining_Name_P_Has_Aspect'Access,
Member_Index_For_Defining_Name_P_Get_Pragma => Member_Desc_For_Defining_Name_P_Get_Pragma'Access,
Member_Index_For_Defining_Name_P_Get_Representation_Clause => Member_Desc_For_Defining_Name_P_Get_Representation_Clause'Access,
Member_Index_For_Defining_Name_P_Get_At_Clause => Member_Desc_For_Defining_Name_P_Get_At_Clause'Access,
Member_Index_For_Defining_Name_P_Is_Imported => Member_Desc_For_Defining_Name_P_Is_Imported'Access,
Member_Index_For_Defining_Name_P_Is_Ghost_Code => Member_Desc_For_Defining_Name_P_Is_Ghost_Code'Access,
Member_Index_For_End_Name_P_Basic_Decl => Member_Desc_For_End_Name_P_Basic_Decl'Access,
Member_Index_For_Char_Literal_P_Denoted_Value => Member_Desc_For_Char_Literal_P_Denoted_Value'Access,
Member_Index_For_String_Literal_P_Denoted_Value => Member_Desc_For_String_Literal_P_Denoted_Value'Access,
Member_Index_For_Int_Literal_P_Denoted_Value => Member_Desc_For_Int_Literal_P_Denoted_Value'Access,
Member_Index_For_Limited_Node_P_As_Bool => Member_Desc_For_Limited_Node_P_As_Bool'Access,
Member_Index_For_Not_Null_P_As_Bool => Member_Desc_For_Not_Null_P_As_Bool'Access,
Member_Index_For_Pragma_Node_P_Is_Ghost_Code => Member_Desc_For_Pragma_Node_P_Is_Ghost_Code'Access,
Member_Index_For_Pragma_Node_P_Associated_Entities => Member_Desc_For_Pragma_Node_P_Associated_Entities'Access,
Member_Index_For_Private_Node_P_As_Bool => Member_Desc_For_Private_Node_P_As_Bool'Access,
Member_Index_For_Protected_Node_P_As_Bool => Member_Desc_For_Protected_Node_P_As_Bool'Access,
Member_Index_For_Reverse_Node_P_As_Bool => Member_Desc_For_Reverse_Node_P_As_Bool'Access,
Member_Index_For_Stmt_P_Is_Ghost_Code => Member_Desc_For_Stmt_P_Is_Ghost_Code'Access,
Member_Index_For_Accept_Stmt_P_Corresponding_Entry => Member_Desc_For_Accept_Stmt_P_Corresponding_Entry'Access,
Member_Index_For_Subunit_P_Body_Root => Member_Desc_For_Subunit_P_Body_Root'Access,
Member_Index_For_Synchronized_Node_P_As_Bool => Member_Desc_For_Synchronized_Node_P_As_Bool'Access,
Member_Index_For_Tagged_Node_P_As_Bool => Member_Desc_For_Tagged_Node_P_As_Bool'Access,
Member_Index_For_Type_Expr_P_Type_Name => Member_Desc_For_Type_Expr_P_Type_Name'Access,
Member_Index_For_Type_Expr_P_Designated_Type_Decl => Member_Desc_For_Type_Expr_P_Designated_Type_Decl'Access,
Member_Index_For_Type_Expr_P_Designated_Type_Decl_From => Member_Desc_For_Type_Expr_P_Designated_Type_Decl_From'Access,
Member_Index_For_Subtype_Indication_P_Subtype_Constraints => Member_Desc_For_Subtype_Indication_P_Subtype_Constraints'Access,
Member_Index_For_Subtype_Indication_P_Is_Static_Subtype => Member_Desc_For_Subtype_Indication_P_Is_Static_Subtype'Access,
Member_Index_For_Until_Node_P_As_Bool => Member_Desc_For_Until_Node_P_As_Bool'Access,
Member_Index_For_With_Private_P_As_Bool => Member_Desc_For_With_Private_P_As_Bool'Access
   );

   -----------------------------
   -- Struct type descriptors --
   -----------------------------

   
      
      Node_Name_For_Aspect : aliased constant Text_Type :=
        "Aspect";
      Node_Desc_For_Aspect : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => No_Type_Index,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Aspect'Access,
         Inherited_Members => 3,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Aspect_Exists,
2 => Member_Index_For_Aspect_Node,
3 => Member_Index_For_Aspect_Value
         ));
      
      Node_Name_For_Completion_Item : aliased constant Text_Type :=
        "Completion_Item";
      Node_Desc_For_Completion_Item : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => No_Type_Index,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Completion_Item'Access,
         Inherited_Members => 4,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Completion_Item_Decl,
2 => Member_Index_For_Completion_Item_Is_Dot_Call,
3 => Member_Index_For_Completion_Item_Is_Visible,
4 => Member_Index_For_Completion_Item_Weight
         ));
      
      Node_Name_For_Discrete_Range : aliased constant Text_Type :=
        "Discrete_Range";
      Node_Desc_For_Discrete_Range : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => No_Type_Index,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Discrete_Range'Access,
         Inherited_Members => 2,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Discrete_Range_Low_Bound,
2 => Member_Index_For_Discrete_Range_High_Bound
         ));
      
      Node_Name_For_Discriminant_Values : aliased constant Text_Type :=
        "Discriminant_Values";
      Node_Desc_For_Discriminant_Values : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => No_Type_Index,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Discriminant_Values'Access,
         Inherited_Members => 2,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Discriminant_Values_Discriminant,
2 => Member_Index_For_Discriminant_Values_Values
         ));
      
      Node_Name_For_Doc_Annotation : aliased constant Text_Type :=
        "Doc_Annotation";
      Node_Desc_For_Doc_Annotation : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => No_Type_Index,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Doc_Annotation'Access,
         Inherited_Members => 2,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Doc_Annotation_Key,
2 => Member_Index_For_Doc_Annotation_Value
         ));
      
      Node_Name_For_Param_Actual : aliased constant Text_Type :=
        "Param_Actual";
      Node_Desc_For_Param_Actual : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => No_Type_Index,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Param_Actual'Access,
         Inherited_Members => 2,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Param_Actual_Param,
2 => Member_Index_For_Param_Actual_Actual
         ));
      
      Node_Name_For_Ref_Result : aliased constant Text_Type :=
        "Ref_Result";
      Node_Desc_For_Ref_Result : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => No_Type_Index,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Ref_Result'Access,
         Inherited_Members => 2,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Ref_Result_Ref,
2 => Member_Index_For_Ref_Result_Kind
         ));
      
      Node_Name_For_Refd_Decl : aliased constant Text_Type :=
        "Refd_Decl";
      Node_Desc_For_Refd_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => No_Type_Index,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Refd_Decl'Access,
         Inherited_Members => 2,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Refd_Decl_Decl,
2 => Member_Index_For_Refd_Decl_Kind
         ));
      
      Node_Name_For_Refd_Def : aliased constant Text_Type :=
        "Refd_Def";
      Node_Desc_For_Refd_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => No_Type_Index,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Refd_Def'Access,
         Inherited_Members => 2,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Refd_Def_Def_Name,
2 => Member_Index_For_Refd_Def_Kind
         ));
      
      Node_Name_For_Shape : aliased constant Text_Type :=
        "Shape";
      Node_Desc_For_Shape : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => No_Type_Index,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Shape'Access,
         Inherited_Members => 2,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Shape_Components,
2 => Member_Index_For_Shape_Discriminants_Values
         ));
      
      Node_Name_For_Substitution : aliased constant Text_Type :=
        "Substitution";
      Node_Desc_For_Substitution : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => No_Type_Index,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Substitution'Access,
         Inherited_Members => 3,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Substitution_From_Decl,
2 => Member_Index_For_Substitution_To_Value,
3 => Member_Index_For_Substitution_Value_Type
         ));
      
      Node_Name_For_Ada_Node : aliased constant Text_Type :=
        "Ada_Node";
      Node_Desc_For_Ada_Node : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 66,
         Member_Count      => 34,
         Base_Type         => No_Type_Index,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Ada_Node'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 => Type_Index_For_Abort,
2 => Type_Index_For_Abstract,
3 => Type_Index_For_Ada_List,
4 => Type_Index_For_Aliased,
5 => Type_Index_For_All,
6 => Type_Index_For_Array_Indices,
7 => Type_Index_For_Aspect_Assoc,
8 => Type_Index_For_Aspect_Clause,
9 => Type_Index_For_Aspect_Spec,
10 => Type_Index_For_Base_Assoc,
11 => Type_Index_For_Base_Formal_Param_Holder,
12 => Type_Index_For_Base_Record_Def,
13 => Type_Index_For_Basic_Assoc,
14 => Type_Index_For_Basic_Decl,
15 => Type_Index_For_Case_Stmt_Alternative,
16 => Type_Index_For_Compilation_Unit,
17 => Type_Index_For_Component_Clause,
18 => Type_Index_For_Component_Def,
19 => Type_Index_For_Constant,
20 => Type_Index_For_Constraint,
21 => Type_Index_For_Declarative_Part,
22 => Type_Index_For_Elsif_Expr_Part,
23 => Type_Index_For_Elsif_Stmt_Part,
24 => Type_Index_For_Expr,
25 => Type_Index_For_Handled_Stmts,
26 => Type_Index_For_Interface_Kind,
27 => Type_Index_For_Iter_Type,
28 => Type_Index_For_Library_Item,
29 => Type_Index_For_Limited,
30 => Type_Index_For_Loop_Spec,
31 => Type_Index_For_Mode,
32 => Type_Index_For_Multi_Abstract_State_Decl,
33 => Type_Index_For_Not_Null,
34 => Type_Index_For_Null_Component_Decl,
35 => Type_Index_For_Others_Designator,
36 => Type_Index_For_Overriding,
37 => Type_Index_For_Params,
38 => Type_Index_For_Paren_Abstract_State_Decl,
39 => Type_Index_For_Pp_Directive,
40 => Type_Index_For_Pp_Then_Kw,
41 => Type_Index_For_Pragma,
42 => Type_Index_For_Private,
43 => Type_Index_For_Protected_Def,
44 => Type_Index_For_Protected,
45 => Type_Index_For_Quantifier,
46 => Type_Index_For_Range_Spec,
47 => Type_Index_For_Renaming_Clause,
48 => Type_Index_For_Reverse,
49 => Type_Index_For_Select_When_Part,
50 => Type_Index_For_Stmt,
51 => Type_Index_For_Subp_Kind,
52 => Type_Index_For_Subunit,
53 => Type_Index_For_Synchronized,
54 => Type_Index_For_Tagged,
55 => Type_Index_For_Task_Def,
56 => Type_Index_For_Type_Attributes_Repository,
57 => Type_Index_For_Type_Def,
58 => Type_Index_For_Type_Expr,
59 => Type_Index_For_Unconstrained_Array_Index,
60 => Type_Index_For_Until,
61 => Type_Index_For_Use_Clause,
62 => Type_Index_For_Value_Sequence,
63 => Type_Index_For_Variant,
64 => Type_Index_For_Variant_Part,
65 => Type_Index_For_With_Clause,
66 => Type_Index_For_With_Private
         ),
         Members           => (
              1 => Member_Index_For_Ada_Node_P_Declarative_Scope,
2 => Member_Index_For_Ada_Node_P_Enclosing_Compilation_Unit,
3 => Member_Index_For_Ada_Node_P_Get_Uninstantiated_Node,
4 => Member_Index_For_Ada_Node_P_Complete,
5 => Member_Index_For_Ada_Node_P_Valid_Keywords,
6 => Member_Index_For_Ada_Node_P_Generic_Instantiations,
7 => Member_Index_For_Ada_Node_P_Semantic_Parent,
8 => Member_Index_For_Ada_Node_P_Parent_Basic_Decl,
9 => Member_Index_For_Ada_Node_P_Filter_Is_Imported_By,
10 => Member_Index_For_Ada_Node_P_Xref_Entry_Point,
11 => Member_Index_For_Ada_Node_P_Resolve_Names,
12 => Member_Index_For_Ada_Node_P_Standard_Unit,
13 => Member_Index_For_Ada_Node_P_Std_Entity,
14 => Member_Index_For_Ada_Node_P_Bool_Type,
15 => Member_Index_For_Ada_Node_P_Int_Type,
16 => Member_Index_For_Ada_Node_P_Universal_Int_Type,
17 => Member_Index_For_Ada_Node_P_Universal_Real_Type,
18 => Member_Index_For_Ada_Node_P_Std_Char_Type,
19 => Member_Index_For_Ada_Node_P_Std_Wide_Char_Type,
20 => Member_Index_For_Ada_Node_P_Std_Wide_Wide_Char_Type,
21 => Member_Index_For_Ada_Node_P_Top_Level_Decl,
22 => Member_Index_For_Ada_Node_P_Choice_Match,
23 => Member_Index_For_Ada_Node_P_Gnat_Xref,
24 => Member_Index_For_Parent,
25 => Member_Index_For_Parents,
26 => Member_Index_For_Children,
27 => Member_Index_For_Token_Start,
28 => Member_Index_For_Token_End,
29 => Member_Index_For_Child_Index,
30 => Member_Index_For_Previous_Sibling,
31 => Member_Index_For_Next_Sibling,
32 => Member_Index_For_Unit,
33 => Member_Index_For_Is_Ghost,
34 => Member_Index_For_Full_Sloc_Image
         ));
      
      Node_Name_For_Abort_Node : aliased constant Text_Type :=
        "Abort_Node";
      Node_Desc_For_Abort_Node : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Abort_Node'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 => Type_Index_For_Abort_Absent,
2 => Type_Index_For_Abort_Present
         ),
         Members           => (
              1 => Member_Index_For_Abort_Node_P_As_Bool
         ));
      
      Node_Name_For_Abort_Absent : aliased constant Text_Type :=
        "Abort_Absent";
      Node_Desc_For_Abort_Absent : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Abort,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Abort_Absent'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Abort_Present : aliased constant Text_Type :=
        "Abort_Present";
      Node_Desc_For_Abort_Present : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Abort,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Abort_Present'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Abstract_Node : aliased constant Text_Type :=
        "Abstract_Node";
      Node_Desc_For_Abstract_Node : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Abstract_Node'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 => Type_Index_For_Abstract_Absent,
2 => Type_Index_For_Abstract_Present
         ),
         Members           => (
              1 => Member_Index_For_Abstract_Node_P_As_Bool
         ));
      
      Node_Name_For_Abstract_Absent : aliased constant Text_Type :=
        "Abstract_Absent";
      Node_Desc_For_Abstract_Absent : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Abstract,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Abstract_Absent'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Abstract_Present : aliased constant Text_Type :=
        "Abstract_Present";
      Node_Desc_For_Abstract_Present : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Abstract,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Abstract_Present'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Ada_List : aliased constant Text_Type :=
        "Ada_List";
      Node_Desc_For_Ada_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 23,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Ada_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 => Type_Index_For_Ada_Node_List,
2 => Type_Index_For_Aspect_Assoc_List,
3 => Type_Index_For_Base_Assoc_List,
4 => Type_Index_For_Basic_Assoc_List,
5 => Type_Index_For_Basic_Decl_List,
6 => Type_Index_For_Case_Expr_Alternative_List,
7 => Type_Index_For_Case_Stmt_Alternative_List,
8 => Type_Index_For_Compilation_Unit_List,
9 => Type_Index_For_Concat_Operand_List,
10 => Type_Index_For_Contract_Case_Assoc_List,
11 => Type_Index_For_Defining_Name_List,
12 => Type_Index_For_Discriminant_Spec_List,
13 => Type_Index_For_Elsif_Expr_Part_List,
14 => Type_Index_For_Elsif_Stmt_Part_List,
15 => Type_Index_For_Enum_Literal_Decl_List,
16 => Type_Index_For_Expr_List,
17 => Type_Index_For_Identifier_List,
18 => Type_Index_For_Name_List,
19 => Type_Index_For_Param_Spec_List,
20 => Type_Index_For_Pragma_Node_List,
21 => Type_Index_For_Select_When_Part_List,
22 => Type_Index_For_Unconstrained_Array_Index_List,
23 => Type_Index_For_Variant_List
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Ada_Node_List : aliased constant Text_Type :=
        "Ada_Node_List";
      Node_Desc_For_Ada_Node_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 5,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Ada_Node_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 => Type_Index_For_Abstract_State_Decl_List,
2 => Type_Index_For_Alternatives_List,
3 => Type_Index_For_Constraint_List,
4 => Type_Index_For_Decl_List,
5 => Type_Index_For_Stmt_List
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Abstract_State_Decl_List : aliased constant Text_Type :=
        "Abstract_State_Decl_List";
      Node_Desc_For_Abstract_State_Decl_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_Node_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Abstract_State_Decl_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Alternatives_List : aliased constant Text_Type :=
        "Alternatives_List";
      Node_Desc_For_Alternatives_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_Node_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Alternatives_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Constraint_List : aliased constant Text_Type :=
        "Constraint_List";
      Node_Desc_For_Constraint_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_Node_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Constraint_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Decl_List : aliased constant Text_Type :=
        "Decl_List";
      Node_Desc_For_Decl_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_Node_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Decl_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Stmt_List : aliased constant Text_Type :=
        "Stmt_List";
      Node_Desc_For_Stmt_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_Node_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Stmt_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Aspect_Assoc_List : aliased constant Text_Type :=
        "Aspect_Assoc_List";
      Node_Desc_For_Aspect_Assoc_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Aspect_Assoc_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Base_Assoc_List : aliased constant Text_Type :=
        "Base_Assoc_List";
      Node_Desc_For_Base_Assoc_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Base_Assoc_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Basic_Assoc_List : aliased constant Text_Type :=
        "Basic_Assoc_List";
      Node_Desc_For_Basic_Assoc_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 1,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Basic_Assoc_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 => Type_Index_For_Assoc_List
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Assoc_List : aliased constant Text_Type :=
        "Assoc_List";
      Node_Desc_For_Assoc_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Basic_Assoc_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Assoc_List'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Assoc_List_P_Zip_With_Params
         ));
      
      Node_Name_For_Basic_Decl_List : aliased constant Text_Type :=
        "Basic_Decl_List";
      Node_Desc_For_Basic_Decl_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Basic_Decl_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Case_Expr_Alternative_List : aliased constant Text_Type :=
        "Case_Expr_Alternative_List";
      Node_Desc_For_Case_Expr_Alternative_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Case_Expr_Alternative_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Case_Stmt_Alternative_List : aliased constant Text_Type :=
        "Case_Stmt_Alternative_List";
      Node_Desc_For_Case_Stmt_Alternative_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Case_Stmt_Alternative_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Compilation_Unit_List : aliased constant Text_Type :=
        "Compilation_Unit_List";
      Node_Desc_For_Compilation_Unit_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Compilation_Unit_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Concat_Operand_List : aliased constant Text_Type :=
        "Concat_Operand_List";
      Node_Desc_For_Concat_Operand_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Concat_Operand_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Contract_Case_Assoc_List : aliased constant Text_Type :=
        "Contract_Case_Assoc_List";
      Node_Desc_For_Contract_Case_Assoc_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Contract_Case_Assoc_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Defining_Name_List : aliased constant Text_Type :=
        "Defining_Name_List";
      Node_Desc_For_Defining_Name_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Defining_Name_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Discriminant_Spec_List : aliased constant Text_Type :=
        "Discriminant_Spec_List";
      Node_Desc_For_Discriminant_Spec_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Discriminant_Spec_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Elsif_Expr_Part_List : aliased constant Text_Type :=
        "Elsif_Expr_Part_List";
      Node_Desc_For_Elsif_Expr_Part_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Elsif_Expr_Part_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Elsif_Stmt_Part_List : aliased constant Text_Type :=
        "Elsif_Stmt_Part_List";
      Node_Desc_For_Elsif_Stmt_Part_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Elsif_Stmt_Part_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Enum_Literal_Decl_List : aliased constant Text_Type :=
        "Enum_Literal_Decl_List";
      Node_Desc_For_Enum_Literal_Decl_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Enum_Literal_Decl_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Expr_List : aliased constant Text_Type :=
        "Expr_List";
      Node_Desc_For_Expr_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 1,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Expr_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 => Type_Index_For_Expr_Alternatives_List
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Expr_Alternatives_List : aliased constant Text_Type :=
        "Expr_Alternatives_List";
      Node_Desc_For_Expr_Alternatives_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Expr_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Expr_Alternatives_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Identifier_List : aliased constant Text_Type :=
        "Identifier_List";
      Node_Desc_For_Identifier_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 1,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Identifier_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 => Type_Index_For_Discriminant_Choice_List
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Discriminant_Choice_List : aliased constant Text_Type :=
        "Discriminant_Choice_List";
      Node_Desc_For_Discriminant_Choice_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Identifier_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Discriminant_Choice_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Name_List : aliased constant Text_Type :=
        "Name_List";
      Node_Desc_For_Name_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 1,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Name_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 => Type_Index_For_Parent_List
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Parent_List : aliased constant Text_Type :=
        "Parent_List";
      Node_Desc_For_Parent_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Name_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Parent_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Param_Spec_List : aliased constant Text_Type :=
        "Param_Spec_List";
      Node_Desc_For_Param_Spec_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Param_Spec_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Pragma_Node_List : aliased constant Text_Type :=
        "Pragma_Node_List";
      Node_Desc_For_Pragma_Node_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Pragma_Node_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Select_When_Part_List : aliased constant Text_Type :=
        "Select_When_Part_List";
      Node_Desc_For_Select_When_Part_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Select_When_Part_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Unconstrained_Array_Index_List : aliased constant Text_Type :=
        "Unconstrained_Array_Index_List";
      Node_Desc_For_Unconstrained_Array_Index_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Unconstrained_Array_Index_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Variant_List : aliased constant Text_Type :=
        "Variant_List";
      Node_Desc_For_Variant_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_List,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => True,
         Name              => Node_Name_For_Variant_List'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Aliased_Node : aliased constant Text_Type :=
        "Aliased_Node";
      Node_Desc_For_Aliased_Node : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Aliased_Node'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 => Type_Index_For_Aliased_Absent,
2 => Type_Index_For_Aliased_Present
         ),
         Members           => (
              1 => Member_Index_For_Aliased_Node_P_As_Bool
         ));
      
      Node_Name_For_Aliased_Absent : aliased constant Text_Type :=
        "Aliased_Absent";
      Node_Desc_For_Aliased_Absent : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Aliased,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Aliased_Absent'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Aliased_Present : aliased constant Text_Type :=
        "Aliased_Present";
      Node_Desc_For_Aliased_Present : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Aliased,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Aliased_Present'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_All_Node : aliased constant Text_Type :=
        "All_Node";
      Node_Desc_For_All_Node : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_All_Node'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 => Type_Index_For_All_Absent,
2 => Type_Index_For_All_Present
         ),
         Members           => (
              1 => Member_Index_For_All_Node_P_As_Bool
         ));
      
      Node_Name_For_All_Absent : aliased constant Text_Type :=
        "All_Absent";
      Node_Desc_For_All_Absent : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_All,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_All_Absent'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_All_Present : aliased constant Text_Type :=
        "All_Present";
      Node_Desc_For_All_Present : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_All,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_All_Present'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Array_Indices : aliased constant Text_Type :=
        "Array_Indices";
      Node_Desc_For_Array_Indices : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Array_Indices'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 => Type_Index_For_Constrained_Array_Indices,
2 => Type_Index_For_Unconstrained_Array_Indices
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Constrained_Array_Indices : aliased constant Text_Type :=
        "Constrained_Array_Indices";
      Node_Desc_For_Constrained_Array_Indices : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Array_Indices,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Constrained_Array_Indices'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Constrained_Array_Indices_F_List
         ));
      
      Node_Name_For_Unconstrained_Array_Indices : aliased constant Text_Type :=
        "Unconstrained_Array_Indices";
      Node_Desc_For_Unconstrained_Array_Indices : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Array_Indices,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Unconstrained_Array_Indices'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Unconstrained_Array_Indices_F_Types
         ));
      
      Node_Name_For_Aspect_Assoc : aliased constant Text_Type :=
        "Aspect_Assoc";
      Node_Desc_For_Aspect_Assoc : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Aspect_Assoc'Access,
         Inherited_Members => 37,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Aspect_Assoc_F_Id,
2 => Member_Index_For_Aspect_Assoc_F_Expr,
3 => Member_Index_For_Aspect_Assoc_P_Is_Ghost_Code
         ));
      
      Node_Name_For_Aspect_Clause : aliased constant Text_Type :=
        "Aspect_Clause";
      Node_Desc_For_Aspect_Clause : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 4,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Aspect_Clause'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 => Type_Index_For_At_Clause,
2 => Type_Index_For_Attribute_Def_Clause,
3 => Type_Index_For_Enum_Rep_Clause,
4 => Type_Index_For_Record_Rep_Clause
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_At_Clause : aliased constant Text_Type :=
        "At_Clause";
      Node_Desc_For_At_Clause : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Aspect_Clause,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_At_Clause'Access,
         Inherited_Members => 36,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_At_Clause_F_Name,
2 => Member_Index_For_At_Clause_F_Expr
         ));
      
      Node_Name_For_Attribute_Def_Clause : aliased constant Text_Type :=
        "Attribute_Def_Clause";
      Node_Desc_For_Attribute_Def_Clause : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Aspect_Clause,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attribute_Def_Clause'Access,
         Inherited_Members => 36,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Attribute_Def_Clause_F_Attribute_Expr,
2 => Member_Index_For_Attribute_Def_Clause_F_Expr
         ));
      
      Node_Name_For_Enum_Rep_Clause : aliased constant Text_Type :=
        "Enum_Rep_Clause";
      Node_Desc_For_Enum_Rep_Clause : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Aspect_Clause,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Enum_Rep_Clause'Access,
         Inherited_Members => 37,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Enum_Rep_Clause_F_Type_Name,
2 => Member_Index_For_Enum_Rep_Clause_F_Aggregate,
3 => Member_Index_For_Enum_Rep_Clause_P_Params
         ));
      
      Node_Name_For_Record_Rep_Clause : aliased constant Text_Type :=
        "Record_Rep_Clause";
      Node_Desc_For_Record_Rep_Clause : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Aspect_Clause,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Record_Rep_Clause'Access,
         Inherited_Members => 37,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Record_Rep_Clause_F_Name,
2 => Member_Index_For_Record_Rep_Clause_F_At_Expr,
3 => Member_Index_For_Record_Rep_Clause_F_Components
         ));
      
      Node_Name_For_Aspect_Spec : aliased constant Text_Type :=
        "Aspect_Spec";
      Node_Desc_For_Aspect_Spec : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Aspect_Spec'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Aspect_Spec_F_Aspect_Assocs
         ));
      
      Node_Name_For_Base_Assoc : aliased constant Text_Type :=
        "Base_Assoc";
      Node_Desc_For_Base_Assoc : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Base_Assoc'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 => Type_Index_For_Contract_Case_Assoc,
2 => Type_Index_For_Pragma_Argument_Assoc
         ),
         Members           => (
              1 => Member_Index_For_Base_Assoc_P_Assoc_Expr
         ));
      
      Node_Name_For_Contract_Case_Assoc : aliased constant Text_Type :=
        "Contract_Case_Assoc";
      Node_Desc_For_Contract_Case_Assoc : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Base_Assoc,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Contract_Case_Assoc'Access,
         Inherited_Members => 37,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Contract_Case_Assoc_F_Guard,
2 => Member_Index_For_Contract_Case_Assoc_F_Consequence
         ));
      
      Node_Name_For_Pragma_Argument_Assoc : aliased constant Text_Type :=
        "Pragma_Argument_Assoc";
      Node_Desc_For_Pragma_Argument_Assoc : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Base_Assoc,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Pragma_Argument_Assoc'Access,
         Inherited_Members => 37,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Pragma_Argument_Assoc_F_Name,
2 => Member_Index_For_Pragma_Argument_Assoc_F_Expr
         ));
      
      Node_Name_For_Base_Formal_Param_Holder : aliased constant Text_Type :=
        "Base_Formal_Param_Holder";
      Node_Desc_For_Base_Formal_Param_Holder : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 5,
         Member_Count      => 5,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Base_Formal_Param_Holder'Access,
         Inherited_Members => 39,
         Derivations       => (
             1 => Type_Index_For_Base_Subp_Spec,
2 => Type_Index_For_Component_List,
3 => Type_Index_For_Discriminant_Part,
4 => Type_Index_For_Entry_Completion_Formal_Params,
5 => Type_Index_For_Generic_Formal_Part
         ),
         Members           => (
              1 => Member_Index_For_Base_Formal_Param_Holder_P_Abstract_Formal_Params,
2 => Member_Index_For_Base_Formal_Param_Holder_P_Formal_Params,
3 => Member_Index_For_Base_Formal_Param_Holder_P_Nb_Min_Params,
4 => Member_Index_For_Base_Formal_Param_Holder_P_Nb_Max_Params,
5 => Member_Index_For_Base_Formal_Param_Holder_P_Param_Types
         ));
      
      Node_Name_For_Base_Subp_Spec : aliased constant Text_Type :=
        "Base_Subp_Spec";
      Node_Desc_For_Base_Subp_Spec : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 5,
         Member_Count      => 6,
         Base_Type         => Type_Index_For_Base_Formal_Param_Holder,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Base_Subp_Spec'Access,
         Inherited_Members => 45,
         Derivations       => (
             1 => Type_Index_For_Entry_Spec,
2 => Type_Index_For_Enum_Subp_Spec,
3 => Type_Index_For_Subp_Spec,
4 => Type_Index_For_Synthetic_Binary_Spec,
5 => Type_Index_For_Synthetic_Unary_Spec
         ),
         Members           => (
              1 => Member_Index_For_Base_Subp_Spec_P_Returns,
2 => Member_Index_For_Base_Subp_Spec_P_Params,
3 => Member_Index_For_Base_Subp_Spec_P_Primitive_Subp_Types,
4 => Member_Index_For_Base_Subp_Spec_P_Primitive_Subp_First_Type,
5 => Member_Index_For_Base_Subp_Spec_P_Primitive_Subp_Tagged_Type,
6 => Member_Index_For_Base_Subp_Spec_P_Return_Type
         ));
      
      Node_Name_For_Entry_Spec : aliased constant Text_Type :=
        "Entry_Spec";
      Node_Desc_For_Entry_Spec : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Base_Subp_Spec,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Entry_Spec'Access,
         Inherited_Members => 48,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Entry_Spec_F_Entry_Name,
2 => Member_Index_For_Entry_Spec_F_Family_Type,
3 => Member_Index_For_Entry_Spec_F_Entry_Params
         ));
      
      Node_Name_For_Enum_Subp_Spec : aliased constant Text_Type :=
        "Enum_Subp_Spec";
      Node_Desc_For_Enum_Subp_Spec : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Base_Subp_Spec,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Enum_Subp_Spec'Access,
         Inherited_Members => 45,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Subp_Spec : aliased constant Text_Type :=
        "Subp_Spec";
      Node_Desc_For_Subp_Spec : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Base_Subp_Spec,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Subp_Spec'Access,
         Inherited_Members => 49,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Subp_Spec_F_Subp_Kind,
2 => Member_Index_For_Subp_Spec_F_Subp_Name,
3 => Member_Index_For_Subp_Spec_F_Subp_Params,
4 => Member_Index_For_Subp_Spec_F_Subp_Returns
         ));
      
      Node_Name_For_Synthetic_Binary_Spec : aliased constant Text_Type :=
        "Synthetic_Binary_Spec";
      Node_Desc_For_Synthetic_Binary_Spec : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Base_Subp_Spec,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Synthetic_Binary_Spec'Access,
         Inherited_Members => 48,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Synthetic_Binary_Spec_F_Left_Param,
2 => Member_Index_For_Synthetic_Binary_Spec_F_Right_Param,
3 => Member_Index_For_Synthetic_Binary_Spec_F_Return_Type_Expr
         ));
      
      Node_Name_For_Synthetic_Unary_Spec : aliased constant Text_Type :=
        "Synthetic_Unary_Spec";
      Node_Desc_For_Synthetic_Unary_Spec : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Base_Subp_Spec,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Synthetic_Unary_Spec'Access,
         Inherited_Members => 47,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Synthetic_Unary_Spec_F_Right_Param,
2 => Member_Index_For_Synthetic_Unary_Spec_F_Return_Type_Expr
         ));
      
      Node_Name_For_Component_List : aliased constant Text_Type :=
        "Component_List";
      Node_Desc_For_Component_List : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Base_Formal_Param_Holder,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Component_List'Access,
         Inherited_Members => 41,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Component_List_F_Components,
2 => Member_Index_For_Component_List_F_Variant_Part
         ));
      
      Node_Name_For_Discriminant_Part : aliased constant Text_Type :=
        "Discriminant_Part";
      Node_Desc_For_Discriminant_Part : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Base_Formal_Param_Holder,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Discriminant_Part'Access,
         Inherited_Members => 39,
         Derivations       => (
             1 => Type_Index_For_Known_Discriminant_Part,
2 => Type_Index_For_Unknown_Discriminant_Part
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Known_Discriminant_Part : aliased constant Text_Type :=
        "Known_Discriminant_Part";
      Node_Desc_For_Known_Discriminant_Part : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Discriminant_Part,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Known_Discriminant_Part'Access,
         Inherited_Members => 40,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Known_Discriminant_Part_F_Discr_Specs
         ));
      
      Node_Name_For_Unknown_Discriminant_Part : aliased constant Text_Type :=
        "Unknown_Discriminant_Part";
      Node_Desc_For_Unknown_Discriminant_Part : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Discriminant_Part,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Unknown_Discriminant_Part'Access,
         Inherited_Members => 39,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Entry_Completion_Formal_Params : aliased constant Text_Type :=
        "Entry_Completion_Formal_Params";
      Node_Desc_For_Entry_Completion_Formal_Params : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Base_Formal_Param_Holder,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Entry_Completion_Formal_Params'Access,
         Inherited_Members => 40,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Entry_Completion_Formal_Params_F_Params
         ));
      
      Node_Name_For_Generic_Formal_Part : aliased constant Text_Type :=
        "Generic_Formal_Part";
      Node_Desc_For_Generic_Formal_Part : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Base_Formal_Param_Holder,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Formal_Part'Access,
         Inherited_Members => 40,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Generic_Formal_Part_F_Decls
         ));
      
      Node_Name_For_Base_Record_Def : aliased constant Text_Type :=
        "Base_Record_Def";
      Node_Desc_For_Base_Record_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Base_Record_Def'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 => Type_Index_For_Null_Record_Def,
2 => Type_Index_For_Record_Def
         ),
         Members           => (
              1 => Member_Index_For_Base_Record_Def_F_Components
         ));
      
      Node_Name_For_Null_Record_Def : aliased constant Text_Type :=
        "Null_Record_Def";
      Node_Desc_For_Null_Record_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Base_Record_Def,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Null_Record_Def'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Record_Def : aliased constant Text_Type :=
        "Record_Def";
      Node_Desc_For_Record_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Base_Record_Def,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Record_Def'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Basic_Assoc : aliased constant Text_Type :=
        "Basic_Assoc";
      Node_Desc_For_Basic_Assoc : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 4,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Basic_Assoc'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 => Type_Index_For_Aggregate_Assoc,
2 => Type_Index_For_Composite_Constraint_Assoc,
3 => Type_Index_For_Iterated_Assoc,
4 => Type_Index_For_Param_Assoc
         ),
         Members           => (
              1 => Member_Index_For_Basic_Assoc_P_Get_Params
         ));
      
      Node_Name_For_Aggregate_Assoc : aliased constant Text_Type :=
        "Aggregate_Assoc";
      Node_Desc_For_Aggregate_Assoc : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 1,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Basic_Assoc,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Aggregate_Assoc'Access,
         Inherited_Members => 37,
         Derivations       => (
             1 => Type_Index_For_Multi_Dim_Array_Assoc
         ),
         Members           => (
              1 => Member_Index_For_Aggregate_Assoc_F_Designators,
2 => Member_Index_For_Aggregate_Assoc_F_R_Expr
         ));
      
      Node_Name_For_Multi_Dim_Array_Assoc : aliased constant Text_Type :=
        "Multi_Dim_Array_Assoc";
      Node_Desc_For_Multi_Dim_Array_Assoc : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Aggregate_Assoc,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Multi_Dim_Array_Assoc'Access,
         Inherited_Members => 37,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Composite_Constraint_Assoc : aliased constant Text_Type :=
        "Composite_Constraint_Assoc";
      Node_Desc_For_Composite_Constraint_Assoc : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Basic_Assoc,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Composite_Constraint_Assoc'Access,
         Inherited_Members => 37,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Composite_Constraint_Assoc_F_Ids,
2 => Member_Index_For_Composite_Constraint_Assoc_F_Constraint_Expr
         ));
      
      Node_Name_For_Iterated_Assoc : aliased constant Text_Type :=
        "Iterated_Assoc";
      Node_Desc_For_Iterated_Assoc : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Basic_Assoc,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Iterated_Assoc'Access,
         Inherited_Members => 37,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Iterated_Assoc_F_Spec,
2 => Member_Index_For_Iterated_Assoc_F_R_Expr
         ));
      
      Node_Name_For_Param_Assoc : aliased constant Text_Type :=
        "Param_Assoc";
      Node_Desc_For_Param_Assoc : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Basic_Assoc,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Param_Assoc'Access,
         Inherited_Members => 37,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Param_Assoc_F_Designator,
2 => Member_Index_For_Param_Assoc_F_R_Expr
         ));
      
      Node_Name_For_Basic_Decl : aliased constant Text_Type :=
        "Basic_Decl";
      Node_Desc_For_Basic_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 22,
         Member_Count      => 37,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Basic_Decl'Access,
         Inherited_Members => 71,
         Derivations       => (
             1 => Type_Index_For_Abstract_State_Decl,
2 => Type_Index_For_Anonymous_Expr_Decl,
3 => Type_Index_For_Base_Formal_Param_Decl,
4 => Type_Index_For_Base_Package_Decl,
5 => Type_Index_For_Base_Type_Decl,
6 => Type_Index_For_Basic_Subp_Decl,
7 => Type_Index_For_Body,
8 => Type_Index_For_Entry_Index_Spec,
9 => Type_Index_For_Error_Decl,
10 => Type_Index_For_Exception_Decl,
11 => Type_Index_For_Exception_Handler,
12 => Type_Index_For_For_Loop_Var_Decl,
13 => Type_Index_For_Generic_Decl,
14 => Type_Index_For_Generic_Instantiation,
15 => Type_Index_For_Generic_Renaming_Decl,
16 => Type_Index_For_Label_Decl,
17 => Type_Index_For_Named_Stmt_Decl,
18 => Type_Index_For_Number_Decl,
19 => Type_Index_For_Object_Decl,
20 => Type_Index_For_Package_Renaming_Decl,
21 => Type_Index_For_Single_Protected_Decl,
22 => Type_Index_For_Single_Task_Decl
         ),
         Members           => (
              1 => Member_Index_For_Basic_Decl_F_Aspects,
2 => Member_Index_For_Basic_Decl_P_Is_Formal,
3 => Member_Index_For_Basic_Decl_P_Doc_Annotations,
4 => Member_Index_For_Basic_Decl_P_Doc,
5 => Member_Index_For_Basic_Decl_P_Previous_Part_For_Decl,
6 => Member_Index_For_Basic_Decl_P_Canonical_Part,
7 => Member_Index_For_Basic_Decl_P_All_Parts,
8 => Member_Index_For_Basic_Decl_P_Is_Static_Decl,
9 => Member_Index_For_Basic_Decl_P_Get_Aspect_Assoc,
10 => Member_Index_For_Basic_Decl_P_Get_Aspect_Spec_Expr,
11 => Member_Index_For_Basic_Decl_P_Get_Aspect,
12 => Member_Index_For_Basic_Decl_P_Has_Aspect,
13 => Member_Index_For_Basic_Decl_P_Get_Pragma,
14 => Member_Index_For_Basic_Decl_P_Get_Representation_Clause,
15 => Member_Index_For_Basic_Decl_P_Get_At_Clause,
16 => Member_Index_For_Basic_Decl_P_Is_Imported,
17 => Member_Index_For_Basic_Decl_P_Is_Ghost_Code,
18 => Member_Index_For_Basic_Decl_P_Is_Compilation_Unit_Root,
19 => Member_Index_For_Basic_Decl_P_Is_Visible,
20 => Member_Index_For_Basic_Decl_P_Base_Subp_Declarations,
21 => Member_Index_For_Basic_Decl_P_Root_Subp_Declarations,
22 => Member_Index_For_Basic_Decl_P_Find_All_Overrides,
23 => Member_Index_For_Basic_Decl_P_Defining_Names,
24 => Member_Index_For_Basic_Decl_P_Defining_Name,
25 => Member_Index_For_Basic_Decl_P_Type_Expression,
26 => Member_Index_For_Basic_Decl_P_Subp_Spec_Or_Null,
27 => Member_Index_For_Basic_Decl_P_Is_Subprogram,
28 => Member_Index_For_Basic_Decl_P_Relative_Name,
29 => Member_Index_For_Basic_Decl_P_Relative_Name_Text,
30 => Member_Index_For_Basic_Decl_P_Next_Part_For_Decl,
31 => Member_Index_For_Basic_Decl_P_Body_Part_For_Decl,
32 => Member_Index_For_Basic_Decl_P_Most_Visible_Part,
33 => Member_Index_For_Basic_Decl_P_Fully_Qualified_Name_Array,
34 => Member_Index_For_Basic_Decl_P_Fully_Qualified_Name,
35 => Member_Index_For_Basic_Decl_P_Canonical_Fully_Qualified_Name,
36 => Member_Index_For_Basic_Decl_P_Unique_Identifying_Name,
37 => Member_Index_For_Basic_Decl_P_Is_Constant_Object
         ));
      
      Node_Name_For_Abstract_State_Decl : aliased constant Text_Type :=
        "Abstract_State_Decl";
      Node_Desc_For_Abstract_State_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Abstract_State_Decl'Access,
         Inherited_Members => 72,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Abstract_State_Decl_F_Name,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Anonymous_Expr_Decl : aliased constant Text_Type :=
        "Anonymous_Expr_Decl";
      Node_Desc_For_Anonymous_Expr_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Anonymous_Expr_Decl'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Anonymous_Expr_Decl_F_Expr,
2 => Member_Index_For_Basic_Decl_F_Aspects,
3 => Member_Index_For_Anonymous_Expr_Decl_P_Get_Formal
         ));
      
      Node_Name_For_Base_Formal_Param_Decl : aliased constant Text_Type :=
        "Base_Formal_Param_Decl";
      Node_Desc_For_Base_Formal_Param_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 5,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Base_Formal_Param_Decl'Access,
         Inherited_Members => 72,
         Derivations       => (
             1 => Type_Index_For_Component_Decl,
2 => Type_Index_For_Discriminant_Spec,
3 => Type_Index_For_Generic_Formal,
4 => Type_Index_For_Param_Spec,
5 => Type_Index_For_Synthetic_Formal_Param_Decl
         ),
         Members           => (
              1 => Member_Index_For_Base_Formal_Param_Decl_P_Formal_Type
         ));
      
      Node_Name_For_Component_Decl : aliased constant Text_Type :=
        "Component_Decl";
      Node_Desc_For_Component_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Base_Formal_Param_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Component_Decl'Access,
         Inherited_Members => 75,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Component_Decl_F_Ids,
2 => Member_Index_For_Component_Decl_F_Component_Def,
3 => Member_Index_For_Component_Decl_F_Default_Expr,
4 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Discriminant_Spec : aliased constant Text_Type :=
        "Discriminant_Spec";
      Node_Desc_For_Discriminant_Spec : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Base_Formal_Param_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Discriminant_Spec'Access,
         Inherited_Members => 75,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Discriminant_Spec_F_Ids,
2 => Member_Index_For_Discriminant_Spec_F_Type_Expr,
3 => Member_Index_For_Discriminant_Spec_F_Default_Expr,
4 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Generic_Formal : aliased constant Text_Type :=
        "Generic_Formal";
      Node_Desc_For_Generic_Formal : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 4,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Base_Formal_Param_Decl,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Formal'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 => Type_Index_For_Generic_Formal_Obj_Decl,
2 => Type_Index_For_Generic_Formal_Package,
3 => Type_Index_For_Generic_Formal_Subp_Decl,
4 => Type_Index_For_Generic_Formal_Type_Decl
         ),
         Members           => (
              1 => Member_Index_For_Generic_Formal_F_Decl,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Generic_Formal_Obj_Decl : aliased constant Text_Type :=
        "Generic_Formal_Obj_Decl";
      Node_Desc_For_Generic_Formal_Obj_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Generic_Formal,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Formal_Obj_Decl'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Generic_Formal_Package : aliased constant Text_Type :=
        "Generic_Formal_Package";
      Node_Desc_For_Generic_Formal_Package : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Generic_Formal,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Formal_Package'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Generic_Formal_Subp_Decl : aliased constant Text_Type :=
        "Generic_Formal_Subp_Decl";
      Node_Desc_For_Generic_Formal_Subp_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Generic_Formal,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Formal_Subp_Decl'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Generic_Formal_Type_Decl : aliased constant Text_Type :=
        "Generic_Formal_Type_Decl";
      Node_Desc_For_Generic_Formal_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Generic_Formal,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Formal_Type_Decl'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Param_Spec : aliased constant Text_Type :=
        "Param_Spec";
      Node_Desc_For_Param_Spec : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 6,
         Base_Type         => Type_Index_For_Base_Formal_Param_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Param_Spec'Access,
         Inherited_Members => 77,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Param_Spec_F_Ids,
2 => Member_Index_For_Param_Spec_F_Has_Aliased,
3 => Member_Index_For_Param_Spec_F_Mode,
4 => Member_Index_For_Param_Spec_F_Type_Expr,
5 => Member_Index_For_Param_Spec_F_Default_Expr,
6 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Synthetic_Formal_Param_Decl : aliased constant Text_Type :=
        "Synthetic_Formal_Param_Decl";
      Node_Desc_For_Synthetic_Formal_Param_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Base_Formal_Param_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Synthetic_Formal_Param_Decl'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Synthetic_Formal_Param_Decl_F_Param_Type,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Base_Package_Decl : aliased constant Text_Type :=
        "Base_Package_Decl";
      Node_Desc_For_Base_Package_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 6,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Base_Package_Decl'Access,
         Inherited_Members => 76,
         Derivations       => (
             1 => Type_Index_For_Generic_Package_Internal,
2 => Type_Index_For_Package_Decl
         ),
         Members           => (
              1 => Member_Index_For_Base_Package_Decl_F_Package_Name,
2 => Member_Index_For_Basic_Decl_F_Aspects,
3 => Member_Index_For_Base_Package_Decl_F_Public_Part,
4 => Member_Index_For_Base_Package_Decl_F_Private_Part,
5 => Member_Index_For_Base_Package_Decl_F_End_Name,
6 => Member_Index_For_Base_Package_Decl_P_Body_Part
         ));
      
      Node_Name_For_Generic_Package_Internal : aliased constant Text_Type :=
        "Generic_Package_Internal";
      Node_Desc_For_Generic_Package_Internal : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Base_Package_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Package_Internal'Access,
         Inherited_Members => 76,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Package_Decl : aliased constant Text_Type :=
        "Package_Decl";
      Node_Desc_For_Package_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Base_Package_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Package_Decl'Access,
         Inherited_Members => 76,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Base_Type_Decl : aliased constant Text_Type :=
        "Base_Type_Decl";
      Node_Desc_For_Base_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 6,
         Member_Count      => 37,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Base_Type_Decl'Access,
         Inherited_Members => 108,
         Derivations       => (
             1 => Type_Index_For_Base_Subtype_Decl,
2 => Type_Index_For_Classwide_Type_Decl,
3 => Type_Index_For_Incomplete_Type_Decl,
4 => Type_Index_For_Protected_Type_Decl,
5 => Type_Index_For_Task_Type_Decl,
6 => Type_Index_For_Type_Decl
         ),
         Members           => (
              1 => Member_Index_For_Base_Type_Decl_F_Name,
2 => Member_Index_For_Base_Type_Decl_P_Base_Subtype,
3 => Member_Index_For_Base_Type_Decl_P_Private_Completion,
4 => Member_Index_For_Base_Type_Decl_P_Is_Inherited_Primitive,
5 => Member_Index_For_Base_Type_Decl_P_Get_Record_Representation_Clause,
6 => Member_Index_For_Base_Type_Decl_P_Get_Enum_Representation_Clause,
7 => Member_Index_For_Base_Type_Decl_P_Is_Record_Type,
8 => Member_Index_For_Base_Type_Decl_P_Is_Array_Type,
9 => Member_Index_For_Base_Type_Decl_P_Find_Derived_Types,
10 => Member_Index_For_Base_Type_Decl_P_Is_Real_Type,
11 => Member_Index_For_Base_Type_Decl_P_Is_Float_Type,
12 => Member_Index_For_Base_Type_Decl_P_Is_Fixed_Point,
13 => Member_Index_For_Base_Type_Decl_P_Is_Enum_Type,
14 => Member_Index_For_Base_Type_Decl_P_Is_Access_Type,
15 => Member_Index_For_Base_Type_Decl_P_Is_Char_Type,
16 => Member_Index_For_Base_Type_Decl_P_Discrete_Range,
17 => Member_Index_For_Base_Type_Decl_P_Is_Discrete_Type,
18 => Member_Index_For_Base_Type_Decl_P_Is_Int_Type,
19 => Member_Index_For_Base_Type_Decl_P_Accessed_Type,
20 => Member_Index_For_Base_Type_Decl_P_Is_Tagged_Type,
21 => Member_Index_For_Base_Type_Decl_P_Base_Type,
22 => Member_Index_For_Base_Type_Decl_P_Base_Types,
23 => Member_Index_For_Base_Type_Decl_P_Find_All_Derived_Types,
24 => Member_Index_For_Base_Type_Decl_P_Comp_Type,
25 => Member_Index_For_Base_Type_Decl_P_Index_Type,
26 => Member_Index_For_Base_Type_Decl_P_Is_Derived_Type,
27 => Member_Index_For_Base_Type_Decl_P_Is_Interface_Type,
28 => Member_Index_For_Base_Type_Decl_P_Matching_Type,
29 => Member_Index_For_Base_Type_Decl_P_Canonical_Type,
30 => Member_Index_For_Base_Type_Decl_P_Previous_Part,
31 => Member_Index_For_Base_Type_Decl_P_Next_Part,
32 => Member_Index_For_Base_Type_Decl_P_Full_View,
33 => Member_Index_For_Base_Type_Decl_P_Is_Definite_Subtype,
34 => Member_Index_For_Base_Type_Decl_P_Is_Private,
35 => Member_Index_For_Base_Type_Decl_P_Discriminants_List,
36 => Member_Index_For_Base_Type_Decl_P_Root_Type,
37 => Member_Index_For_Base_Type_Decl_P_Shapes
         ));
      
      Node_Name_For_Base_Subtype_Decl : aliased constant Text_Type :=
        "Base_Subtype_Decl";
      Node_Desc_For_Base_Subtype_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Base_Type_Decl,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Base_Subtype_Decl'Access,
         Inherited_Members => 109,
         Derivations       => (
             1 => Type_Index_For_Discrete_Base_Subtype_Decl,
2 => Type_Index_For_Subtype_Decl
         ),
         Members           => (
              1 => Member_Index_For_Base_Subtype_Decl_P_Get_Type
         ));
      
      Node_Name_For_Discrete_Base_Subtype_Decl : aliased constant Text_Type :=
        "Discrete_Base_Subtype_Decl";
      Node_Desc_For_Discrete_Base_Subtype_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Base_Subtype_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Discrete_Base_Subtype_Decl'Access,
         Inherited_Members => 109,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Subtype_Decl : aliased constant Text_Type :=
        "Subtype_Decl";
      Node_Desc_For_Subtype_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Base_Subtype_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Subtype_Decl'Access,
         Inherited_Members => 110,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Subtype_Decl_F_Subtype,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Classwide_Type_Decl : aliased constant Text_Type :=
        "Classwide_Type_Decl";
      Node_Desc_For_Classwide_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Base_Type_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Classwide_Type_Decl'Access,
         Inherited_Members => 108,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Incomplete_Type_Decl : aliased constant Text_Type :=
        "Incomplete_Type_Decl";
      Node_Desc_For_Incomplete_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Base_Type_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Incomplete_Type_Decl'Access,
         Inherited_Members => 109,
         Derivations       => (
             1 => Type_Index_For_Incomplete_Formal_Type_Decl,
2 => Type_Index_For_Incomplete_Tagged_Type_Decl
         ),
         Members           => (
              1 => Member_Index_For_Incomplete_Type_Decl_F_Discriminants,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Incomplete_Formal_Type_Decl : aliased constant Text_Type :=
        "Incomplete_Formal_Type_Decl";
      Node_Desc_For_Incomplete_Formal_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Incomplete_Type_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Incomplete_Formal_Type_Decl'Access,
         Inherited_Members => 111,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Incomplete_Formal_Type_Decl_F_Is_Tagged,
2 => Member_Index_For_Incomplete_Formal_Type_Decl_F_Default_Type
         ));
      
      Node_Name_For_Incomplete_Tagged_Type_Decl : aliased constant Text_Type :=
        "Incomplete_Tagged_Type_Decl";
      Node_Desc_For_Incomplete_Tagged_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Incomplete_Type_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Incomplete_Tagged_Type_Decl'Access,
         Inherited_Members => 110,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Incomplete_Tagged_Type_Decl_F_Has_Abstract
         ));
      
      Node_Name_For_Protected_Type_Decl : aliased constant Text_Type :=
        "Protected_Type_Decl";
      Node_Desc_For_Protected_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Base_Type_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Protected_Type_Decl'Access,
         Inherited_Members => 111,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Protected_Type_Decl_F_Discriminants,
2 => Member_Index_For_Basic_Decl_F_Aspects,
3 => Member_Index_For_Protected_Type_Decl_F_Interfaces,
4 => Member_Index_For_Protected_Type_Decl_F_Definition
         ));
      
      Node_Name_For_Task_Type_Decl : aliased constant Text_Type :=
        "Task_Type_Decl";
      Node_Desc_For_Task_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 1,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Base_Type_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Task_Type_Decl'Access,
         Inherited_Members => 110,
         Derivations       => (
             1 => Type_Index_For_Single_Task_Type_Decl
         ),
         Members           => (
              1 => Member_Index_For_Task_Type_Decl_F_Discriminants,
2 => Member_Index_For_Basic_Decl_F_Aspects,
3 => Member_Index_For_Task_Type_Decl_F_Definition
         ));
      
      Node_Name_For_Single_Task_Type_Decl : aliased constant Text_Type :=
        "Single_Task_Type_Decl";
      Node_Desc_For_Single_Task_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Task_Type_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Single_Task_Type_Decl'Access,
         Inherited_Members => 110,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Type_Decl : aliased constant Text_Type :=
        "Type_Decl";
      Node_Desc_For_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 3,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Base_Type_Decl,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Type_Decl'Access,
         Inherited_Members => 111,
         Derivations       => (
             1 => Type_Index_For_Anonymous_Type_Decl,
2 => Type_Index_For_Concrete_Type_Decl,
3 => Type_Index_For_Formal_Type_Decl
         ),
         Members           => (
              1 => Member_Index_For_Type_Decl_F_Discriminants,
2 => Member_Index_For_Type_Decl_F_Type_Def,
3 => Member_Index_For_Type_Decl_P_Get_Primitives
         ));
      
      Node_Name_For_Anonymous_Type_Decl : aliased constant Text_Type :=
        "Anonymous_Type_Decl";
      Node_Desc_For_Anonymous_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 1,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Type_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Anonymous_Type_Decl'Access,
         Inherited_Members => 111,
         Derivations       => (
             1 => Type_Index_For_Synth_Anonymous_Type_Decl
         ),
         Members           => (
              1 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Synth_Anonymous_Type_Decl : aliased constant Text_Type :=
        "Synth_Anonymous_Type_Decl";
      Node_Desc_For_Synth_Anonymous_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Anonymous_Type_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Synth_Anonymous_Type_Decl'Access,
         Inherited_Members => 111,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Concrete_Type_Decl : aliased constant Text_Type :=
        "Concrete_Type_Decl";
      Node_Desc_For_Concrete_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Type_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Concrete_Type_Decl'Access,
         Inherited_Members => 111,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Formal_Type_Decl : aliased constant Text_Type :=
        "Formal_Type_Decl";
      Node_Desc_For_Formal_Type_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Type_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Formal_Type_Decl'Access,
         Inherited_Members => 112,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Formal_Type_Decl_F_Default_Type,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Basic_Subp_Decl : aliased constant Text_Type :=
        "Basic_Subp_Decl";
      Node_Desc_For_Basic_Subp_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 5,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Basic_Subp_Decl'Access,
         Inherited_Members => 72,
         Derivations       => (
             1 => Type_Index_For_Classic_Subp_Decl,
2 => Type_Index_For_Entry_Decl,
3 => Type_Index_For_Enum_Literal_Decl,
4 => Type_Index_For_Generic_Subp_Internal,
5 => Type_Index_For_Synthetic_Subp_Decl
         ),
         Members           => (
              1 => Member_Index_For_Basic_Subp_Decl_P_Subp_Decl_Spec
         ));
      
      Node_Name_For_Classic_Subp_Decl : aliased constant Text_Type :=
        "Classic_Subp_Decl";
      Node_Desc_For_Classic_Subp_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 3,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Basic_Subp_Decl,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Classic_Subp_Decl'Access,
         Inherited_Members => 75,
         Derivations       => (
             1 => Type_Index_For_Abstract_Subp_Decl,
2 => Type_Index_For_Formal_Subp_Decl,
3 => Type_Index_For_Subp_Decl
         ),
         Members           => (
              1 => Member_Index_For_Classic_Subp_Decl_F_Overriding,
2 => Member_Index_For_Classic_Subp_Decl_F_Subp_Spec,
3 => Member_Index_For_Classic_Subp_Decl_P_Body_Part
         ));
      
      Node_Name_For_Abstract_Subp_Decl : aliased constant Text_Type :=
        "Abstract_Subp_Decl";
      Node_Desc_For_Abstract_Subp_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Classic_Subp_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Abstract_Subp_Decl'Access,
         Inherited_Members => 75,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Formal_Subp_Decl : aliased constant Text_Type :=
        "Formal_Subp_Decl";
      Node_Desc_For_Formal_Subp_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Classic_Subp_Decl,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Formal_Subp_Decl'Access,
         Inherited_Members => 76,
         Derivations       => (
             1 => Type_Index_For_Abstract_Formal_Subp_Decl,
2 => Type_Index_For_Concrete_Formal_Subp_Decl
         ),
         Members           => (
              1 => Member_Index_For_Formal_Subp_Decl_F_Default_Expr,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Abstract_Formal_Subp_Decl : aliased constant Text_Type :=
        "Abstract_Formal_Subp_Decl";
      Node_Desc_For_Abstract_Formal_Subp_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Formal_Subp_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Abstract_Formal_Subp_Decl'Access,
         Inherited_Members => 76,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Concrete_Formal_Subp_Decl : aliased constant Text_Type :=
        "Concrete_Formal_Subp_Decl";
      Node_Desc_For_Concrete_Formal_Subp_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Formal_Subp_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Concrete_Formal_Subp_Decl'Access,
         Inherited_Members => 76,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Subp_Decl : aliased constant Text_Type :=
        "Subp_Decl";
      Node_Desc_For_Subp_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Classic_Subp_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Subp_Decl'Access,
         Inherited_Members => 75,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Entry_Decl : aliased constant Text_Type :=
        "Entry_Decl";
      Node_Desc_For_Entry_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 5,
         Base_Type         => Type_Index_For_Basic_Subp_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Entry_Decl'Access,
         Inherited_Members => 76,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Entry_Decl_F_Overriding,
2 => Member_Index_For_Entry_Decl_F_Spec,
3 => Member_Index_For_Basic_Decl_F_Aspects,
4 => Member_Index_For_Entry_Decl_P_Body_Part,
5 => Member_Index_For_Entry_Decl_P_Accept_Stmts
         ));
      
      Node_Name_For_Enum_Literal_Decl : aliased constant Text_Type :=
        "Enum_Literal_Decl";
      Node_Desc_For_Enum_Literal_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 1,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Basic_Subp_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Enum_Literal_Decl'Access,
         Inherited_Members => 74,
         Derivations       => (
             1 => Type_Index_For_Synthetic_Char_Enum_Lit
         ),
         Members           => (
              1 => Member_Index_For_Enum_Literal_Decl_F_Name,
2 => Member_Index_For_Basic_Decl_F_Aspects,
3 => Member_Index_For_Enum_Literal_Decl_P_Enum_Type
         ));
      
      Node_Name_For_Synthetic_Char_Enum_Lit : aliased constant Text_Type :=
        "Synthetic_Char_Enum_Lit";
      Node_Desc_For_Synthetic_Char_Enum_Lit : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Enum_Literal_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Synthetic_Char_Enum_Lit'Access,
         Inherited_Members => 75,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Synthetic_Char_Enum_Lit_P_Expr
         ));
      
      Node_Name_For_Generic_Subp_Internal : aliased constant Text_Type :=
        "Generic_Subp_Internal";
      Node_Desc_For_Generic_Subp_Internal : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Basic_Subp_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Subp_Internal'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Generic_Subp_Internal_F_Subp_Spec,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Synthetic_Subp_Decl : aliased constant Text_Type :=
        "Synthetic_Subp_Decl";
      Node_Desc_For_Synthetic_Subp_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Basic_Subp_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Synthetic_Subp_Decl'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Basic_Decl_F_Aspects,
2 => Member_Index_For_Synthetic_Subp_Decl_F_Spec
         ));
      
      Node_Name_For_Body_Node : aliased constant Text_Type :=
        "Body_Node";
      Node_Desc_For_Body_Node : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 6,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Body_Node'Access,
         Inherited_Members => 74,
         Derivations       => (
             1 => Type_Index_For_Base_Subp_Body,
2 => Type_Index_For_Body_Stub,
3 => Type_Index_For_Entry_Body,
4 => Type_Index_For_Package_Body,
5 => Type_Index_For_Protected_Body,
6 => Type_Index_For_Task_Body
         ),
         Members           => (
              1 => Member_Index_For_Body_Node_P_Previous_Part,
2 => Member_Index_For_Body_Node_P_Decl_Part,
3 => Member_Index_For_Body_Node_P_Subunit_Root
         ));
      
      Node_Name_For_Base_Subp_Body : aliased constant Text_Type :=
        "Base_Subp_Body";
      Node_Desc_For_Base_Subp_Body : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 4,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Body,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Base_Subp_Body'Access,
         Inherited_Members => 76,
         Derivations       => (
             1 => Type_Index_For_Expr_Function,
2 => Type_Index_For_Null_Subp_Decl,
3 => Type_Index_For_Subp_Body,
4 => Type_Index_For_Subp_Renaming_Decl
         ),
         Members           => (
              1 => Member_Index_For_Base_Subp_Body_F_Overriding,
2 => Member_Index_For_Base_Subp_Body_F_Subp_Spec
         ));
      
      Node_Name_For_Expr_Function : aliased constant Text_Type :=
        "Expr_Function";
      Node_Desc_For_Expr_Function : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Base_Subp_Body,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Expr_Function'Access,
         Inherited_Members => 77,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Expr_Function_F_Expr,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Null_Subp_Decl : aliased constant Text_Type :=
        "Null_Subp_Decl";
      Node_Desc_For_Null_Subp_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Base_Subp_Body,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Null_Subp_Decl'Access,
         Inherited_Members => 76,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Subp_Body : aliased constant Text_Type :=
        "Subp_Body";
      Node_Desc_For_Subp_Body : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Base_Subp_Body,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Subp_Body'Access,
         Inherited_Members => 79,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Basic_Decl_F_Aspects,
2 => Member_Index_For_Subp_Body_F_Decls,
3 => Member_Index_For_Subp_Body_F_Stmts,
4 => Member_Index_For_Subp_Body_F_End_Name
         ));
      
      Node_Name_For_Subp_Renaming_Decl : aliased constant Text_Type :=
        "Subp_Renaming_Decl";
      Node_Desc_For_Subp_Renaming_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Base_Subp_Body,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Subp_Renaming_Decl'Access,
         Inherited_Members => 77,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Subp_Renaming_Decl_F_Renames,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Body_Stub : aliased constant Text_Type :=
        "Body_Stub";
      Node_Desc_For_Body_Stub : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 4,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Body,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Body_Stub'Access,
         Inherited_Members => 75,
         Derivations       => (
             1 => Type_Index_For_Package_Body_Stub,
2 => Type_Index_For_Protected_Body_Stub,
3 => Type_Index_For_Subp_Body_Stub,
4 => Type_Index_For_Task_Body_Stub
         ),
         Members           => (
              1 => Member_Index_For_Body_Stub_P_Syntactic_Fully_Qualified_Name
         ));
      
      Node_Name_For_Package_Body_Stub : aliased constant Text_Type :=
        "Package_Body_Stub";
      Node_Desc_For_Package_Body_Stub : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Body_Stub,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Package_Body_Stub'Access,
         Inherited_Members => 76,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Package_Body_Stub_F_Name,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Protected_Body_Stub : aliased constant Text_Type :=
        "Protected_Body_Stub";
      Node_Desc_For_Protected_Body_Stub : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Body_Stub,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Protected_Body_Stub'Access,
         Inherited_Members => 76,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Protected_Body_Stub_F_Name,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Subp_Body_Stub : aliased constant Text_Type :=
        "Subp_Body_Stub";
      Node_Desc_For_Subp_Body_Stub : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Body_Stub,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Subp_Body_Stub'Access,
         Inherited_Members => 77,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Subp_Body_Stub_F_Overriding,
2 => Member_Index_For_Subp_Body_Stub_F_Subp_Spec,
3 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Task_Body_Stub : aliased constant Text_Type :=
        "Task_Body_Stub";
      Node_Desc_For_Task_Body_Stub : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Body_Stub,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Task_Body_Stub'Access,
         Inherited_Members => 76,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Task_Body_Stub_F_Name,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Entry_Body : aliased constant Text_Type :=
        "Entry_Body";
      Node_Desc_For_Entry_Body : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 8,
         Base_Type         => Type_Index_For_Body,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Entry_Body'Access,
         Inherited_Members => 81,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Entry_Body_F_Entry_Name,
2 => Member_Index_For_Entry_Body_F_Index_Spec,
3 => Member_Index_For_Entry_Body_F_Params,
4 => Member_Index_For_Basic_Decl_F_Aspects,
5 => Member_Index_For_Entry_Body_F_Barrier,
6 => Member_Index_For_Entry_Body_F_Decls,
7 => Member_Index_For_Entry_Body_F_Stmts,
8 => Member_Index_For_Entry_Body_F_End_Name
         ));
      
      Node_Name_For_Package_Body : aliased constant Text_Type :=
        "Package_Body";
      Node_Desc_For_Package_Body : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 5,
         Base_Type         => Type_Index_For_Body,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Package_Body'Access,
         Inherited_Members => 78,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Package_Body_F_Package_Name,
2 => Member_Index_For_Basic_Decl_F_Aspects,
3 => Member_Index_For_Package_Body_F_Decls,
4 => Member_Index_For_Package_Body_F_Stmts,
5 => Member_Index_For_Package_Body_F_End_Name
         ));
      
      Node_Name_For_Protected_Body : aliased constant Text_Type :=
        "Protected_Body";
      Node_Desc_For_Protected_Body : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Body,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Protected_Body'Access,
         Inherited_Members => 77,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Protected_Body_F_Name,
2 => Member_Index_For_Basic_Decl_F_Aspects,
3 => Member_Index_For_Protected_Body_F_Decls,
4 => Member_Index_For_Protected_Body_F_End_Name
         ));
      
      Node_Name_For_Task_Body : aliased constant Text_Type :=
        "Task_Body";
      Node_Desc_For_Task_Body : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 5,
         Base_Type         => Type_Index_For_Body,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Task_Body'Access,
         Inherited_Members => 78,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Task_Body_F_Name,
2 => Member_Index_For_Basic_Decl_F_Aspects,
3 => Member_Index_For_Task_Body_F_Decls,
4 => Member_Index_For_Task_Body_F_Stmts,
5 => Member_Index_For_Task_Body_F_End_Name
         ));
      
      Node_Name_For_Entry_Index_Spec : aliased constant Text_Type :=
        "Entry_Index_Spec";
      Node_Desc_For_Entry_Index_Spec : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Entry_Index_Spec'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Entry_Index_Spec_F_Id,
2 => Member_Index_For_Entry_Index_Spec_F_Subtype,
3 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Error_Decl : aliased constant Text_Type :=
        "Error_Decl";
      Node_Desc_For_Error_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Error_Decl'Access,
         Inherited_Members => 71,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Exception_Decl : aliased constant Text_Type :=
        "Exception_Decl";
      Node_Desc_For_Exception_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Exception_Decl'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Exception_Decl_F_Ids,
2 => Member_Index_For_Exception_Decl_F_Renames,
3 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Exception_Handler : aliased constant Text_Type :=
        "Exception_Handler";
      Node_Desc_For_Exception_Handler : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Exception_Handler'Access,
         Inherited_Members => 74,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Exception_Handler_F_Exception_Name,
2 => Member_Index_For_Exception_Handler_F_Handled_Exceptions,
3 => Member_Index_For_Exception_Handler_F_Stmts,
4 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_For_Loop_Var_Decl : aliased constant Text_Type :=
        "For_Loop_Var_Decl";
      Node_Desc_For_For_Loop_Var_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_For_Loop_Var_Decl'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_For_Loop_Var_Decl_F_Id,
2 => Member_Index_For_For_Loop_Var_Decl_F_Id_Type,
3 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Generic_Decl : aliased constant Text_Type :=
        "Generic_Decl";
      Node_Desc_For_Generic_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Decl'Access,
         Inherited_Members => 72,
         Derivations       => (
             1 => Type_Index_For_Generic_Package_Decl,
2 => Type_Index_For_Generic_Subp_Decl
         ),
         Members           => (
              1 => Member_Index_For_Generic_Decl_F_Formal_Part
         ));
      
      Node_Name_For_Generic_Package_Decl : aliased constant Text_Type :=
        "Generic_Package_Decl";
      Node_Desc_For_Generic_Package_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Generic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Package_Decl'Access,
         Inherited_Members => 74,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Generic_Package_Decl_F_Package_Decl,
2 => Member_Index_For_Basic_Decl_F_Aspects,
3 => Member_Index_For_Generic_Package_Decl_P_Body_Part
         ));
      
      Node_Name_For_Generic_Subp_Decl : aliased constant Text_Type :=
        "Generic_Subp_Decl";
      Node_Desc_For_Generic_Subp_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Generic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Subp_Decl'Access,
         Inherited_Members => 74,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Generic_Subp_Decl_F_Subp_Decl,
2 => Member_Index_For_Basic_Decl_F_Aspects,
3 => Member_Index_For_Generic_Subp_Decl_P_Body_Part
         ));
      
      Node_Name_For_Generic_Instantiation : aliased constant Text_Type :=
        "Generic_Instantiation";
      Node_Desc_For_Generic_Instantiation : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Instantiation'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 => Type_Index_For_Generic_Package_Instantiation,
2 => Type_Index_For_Generic_Subp_Instantiation
         ),
         Members           => (
              1 => Member_Index_For_Generic_Instantiation_P_Designated_Generic_Decl,
2 => Member_Index_For_Generic_Instantiation_P_Inst_Params
         ));
      
      Node_Name_For_Generic_Package_Instantiation : aliased constant Text_Type :=
        "Generic_Package_Instantiation";
      Node_Desc_For_Generic_Package_Instantiation : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Generic_Instantiation,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Package_Instantiation'Access,
         Inherited_Members => 76,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Generic_Package_Instantiation_F_Name,
2 => Member_Index_For_Generic_Package_Instantiation_F_Generic_Pkg_Name,
3 => Member_Index_For_Generic_Package_Instantiation_F_Params,
4 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Generic_Subp_Instantiation : aliased constant Text_Type :=
        "Generic_Subp_Instantiation";
      Node_Desc_For_Generic_Subp_Instantiation : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 7,
         Base_Type         => Type_Index_For_Generic_Instantiation,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Subp_Instantiation'Access,
         Inherited_Members => 79,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Generic_Subp_Instantiation_F_Overriding,
2 => Member_Index_For_Generic_Subp_Instantiation_F_Kind,
3 => Member_Index_For_Generic_Subp_Instantiation_F_Subp_Name,
4 => Member_Index_For_Generic_Subp_Instantiation_F_Generic_Subp_Name,
5 => Member_Index_For_Generic_Subp_Instantiation_F_Params,
6 => Member_Index_For_Basic_Decl_F_Aspects,
7 => Member_Index_For_Generic_Subp_Instantiation_P_Designated_Subp
         ));
      
      Node_Name_For_Generic_Renaming_Decl : aliased constant Text_Type :=
        "Generic_Renaming_Decl";
      Node_Desc_For_Generic_Renaming_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Renaming_Decl'Access,
         Inherited_Members => 71,
         Derivations       => (
             1 => Type_Index_For_Generic_Package_Renaming_Decl,
2 => Type_Index_For_Generic_Subp_Renaming_Decl
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Generic_Package_Renaming_Decl : aliased constant Text_Type :=
        "Generic_Package_Renaming_Decl";
      Node_Desc_For_Generic_Package_Renaming_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Generic_Renaming_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Package_Renaming_Decl'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Generic_Package_Renaming_Decl_F_Name,
2 => Member_Index_For_Generic_Package_Renaming_Decl_F_Renames,
3 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Generic_Subp_Renaming_Decl : aliased constant Text_Type :=
        "Generic_Subp_Renaming_Decl";
      Node_Desc_For_Generic_Subp_Renaming_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Generic_Renaming_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Generic_Subp_Renaming_Decl'Access,
         Inherited_Members => 74,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Generic_Subp_Renaming_Decl_F_Kind,
2 => Member_Index_For_Generic_Subp_Renaming_Decl_F_Name,
3 => Member_Index_For_Generic_Subp_Renaming_Decl_F_Renames,
4 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Label_Decl : aliased constant Text_Type :=
        "Label_Decl";
      Node_Desc_For_Label_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Label_Decl'Access,
         Inherited_Members => 72,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Label_Decl_F_Name,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Named_Stmt_Decl : aliased constant Text_Type :=
        "Named_Stmt_Decl";
      Node_Desc_For_Named_Stmt_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Named_Stmt_Decl'Access,
         Inherited_Members => 72,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Named_Stmt_Decl_F_Name,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Number_Decl : aliased constant Text_Type :=
        "Number_Decl";
      Node_Desc_For_Number_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Number_Decl'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Number_Decl_F_Ids,
2 => Member_Index_For_Number_Decl_F_Expr,
3 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Object_Decl : aliased constant Text_Type :=
        "Object_Decl";
      Node_Desc_For_Object_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 10,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Object_Decl'Access,
         Inherited_Members => 80,
         Derivations       => (
             1 => Type_Index_For_Extended_Return_Stmt_Object_Decl,
2 => Type_Index_For_No_Type_Object_Renaming_Decl
         ),
         Members           => (
              1 => Member_Index_For_Object_Decl_F_Ids,
2 => Member_Index_For_Object_Decl_F_Has_Aliased,
3 => Member_Index_For_Object_Decl_F_Has_Constant,
4 => Member_Index_For_Object_Decl_F_Mode,
5 => Member_Index_For_Object_Decl_F_Type_Expr,
6 => Member_Index_For_Object_Decl_F_Default_Expr,
7 => Member_Index_For_Object_Decl_F_Renaming_Clause,
8 => Member_Index_For_Basic_Decl_F_Aspects,
9 => Member_Index_For_Object_Decl_P_Private_Part_Decl,
10 => Member_Index_For_Object_Decl_P_Public_Part_Decl
         ));
      
      Node_Name_For_Extended_Return_Stmt_Object_Decl : aliased constant Text_Type :=
        "Extended_Return_Stmt_Object_Decl";
      Node_Desc_For_Extended_Return_Stmt_Object_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Object_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Extended_Return_Stmt_Object_Decl'Access,
         Inherited_Members => 80,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_No_Type_Object_Renaming_Decl : aliased constant Text_Type :=
        "No_Type_Object_Renaming_Decl";
      Node_Desc_For_No_Type_Object_Renaming_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Object_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_No_Type_Object_Renaming_Decl'Access,
         Inherited_Members => 80,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Package_Renaming_Decl : aliased constant Text_Type :=
        "Package_Renaming_Decl";
      Node_Desc_For_Package_Renaming_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 5,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Package_Renaming_Decl'Access,
         Inherited_Members => 75,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Package_Renaming_Decl_F_Name,
2 => Member_Index_For_Package_Renaming_Decl_F_Renames,
3 => Member_Index_For_Basic_Decl_F_Aspects,
4 => Member_Index_For_Package_Renaming_Decl_P_Renamed_Package,
5 => Member_Index_For_Package_Renaming_Decl_P_Final_Renamed_Package
         ));
      
      Node_Name_For_Single_Protected_Decl : aliased constant Text_Type :=
        "Single_Protected_Decl";
      Node_Desc_For_Single_Protected_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Single_Protected_Decl'Access,
         Inherited_Members => 74,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Single_Protected_Decl_F_Name,
2 => Member_Index_For_Basic_Decl_F_Aspects,
3 => Member_Index_For_Single_Protected_Decl_F_Interfaces,
4 => Member_Index_For_Single_Protected_Decl_F_Definition
         ));
      
      Node_Name_For_Single_Task_Decl : aliased constant Text_Type :=
        "Single_Task_Decl";
      Node_Desc_For_Single_Task_Decl : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Basic_Decl,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Single_Task_Decl'Access,
         Inherited_Members => 72,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Single_Task_Decl_F_Task_Type,
2 => Member_Index_For_Basic_Decl_F_Aspects
         ));
      
      Node_Name_For_Case_Stmt_Alternative : aliased constant Text_Type :=
        "Case_Stmt_Alternative";
      Node_Desc_For_Case_Stmt_Alternative : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Case_Stmt_Alternative'Access,
         Inherited_Members => 36,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Case_Stmt_Alternative_F_Choices,
2 => Member_Index_For_Case_Stmt_Alternative_F_Stmts
         ));
      
      Node_Name_For_Compilation_Unit : aliased constant Text_Type :=
        "Compilation_Unit";
      Node_Desc_For_Compilation_Unit : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 14,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Compilation_Unit'Access,
         Inherited_Members => 48,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Compilation_Unit_F_Prelude,
2 => Member_Index_For_Compilation_Unit_F_Body,
3 => Member_Index_For_Compilation_Unit_F_Pragmas,
4 => Member_Index_For_Compilation_Unit_P_Syntactic_Fully_Qualified_Name,
5 => Member_Index_For_Compilation_Unit_P_Unit_Kind,
6 => Member_Index_For_Compilation_Unit_P_Withed_Units,
7 => Member_Index_For_Compilation_Unit_P_Imported_Units,
8 => Member_Index_For_Compilation_Unit_P_Unit_Dependencies,
9 => Member_Index_For_Compilation_Unit_P_Decl,
10 => Member_Index_For_Compilation_Unit_P_Is_Preelaborable,
11 => Member_Index_For_Compilation_Unit_P_Other_Part,
12 => Member_Index_For_Compilation_Unit_P_Has_Restriction,
13 => Member_Index_For_Compilation_Unit_P_All_Config_Pragmas,
14 => Member_Index_For_Compilation_Unit_P_Config_Pragmas
         ));
      
      Node_Name_For_Component_Clause : aliased constant Text_Type :=
        "Component_Clause";
      Node_Desc_For_Component_Clause : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Component_Clause'Access,
         Inherited_Members => 37,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Component_Clause_F_Id,
2 => Member_Index_For_Component_Clause_F_Position,
3 => Member_Index_For_Component_Clause_F_Range
         ));
      
      Node_Name_For_Component_Def : aliased constant Text_Type :=
        "Component_Def";
      Node_Desc_For_Component_Def : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Component_Def'Access,
         Inherited_Members => 37,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Component_Def_F_Has_Aliased,
2 => Member_Index_For_Component_Def_F_Has_Constant,
3 => Member_Index_For_Component_Def_F_Type_Expr
         ));
      
      Node_Name_For_Constant_Node : aliased constant Text_Type :=
        "Constant_Node";
      Node_Desc_For_Constant_Node : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Constant_Node'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 => Type_Index_For_Constant_Absent,
2 => Type_Index_For_Constant_Present
         ),
         Members           => (
              1 => Member_Index_For_Constant_Node_P_As_Bool
         ));
      
      Node_Name_For_Constant_Absent : aliased constant Text_Type :=
        "Constant_Absent";
      Node_Desc_For_Constant_Absent : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Constant,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Constant_Absent'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Constant_Present : aliased constant Text_Type :=
        "Constant_Present";
      Node_Desc_For_Constant_Present : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Constant,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Constant_Present'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Constraint : aliased constant Text_Type :=
        "Constraint";
      Node_Desc_For_Constraint : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 4,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Constraint'Access,
         Inherited_Members => 34,
         Derivations       => (
             1 => Type_Index_For_Composite_Constraint,
2 => Type_Index_For_Delta_Constraint,
3 => Type_Index_For_Digits_Constraint,
4 => Type_Index_For_Range_Constraint
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Composite_Constraint : aliased constant Text_Type :=
        "Composite_Constraint";
      Node_Desc_For_Composite_Constraint : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Constraint,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Composite_Constraint'Access,
         Inherited_Members => 37,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Composite_Constraint_F_Constraints,
2 => Member_Index_For_Composite_Constraint_P_Is_Index_Constraint,
3 => Member_Index_For_Composite_Constraint_P_Is_Discriminant_Constraint
         ));
      
      Node_Name_For_Delta_Constraint : aliased constant Text_Type :=
        "Delta_Constraint";
      Node_Desc_For_Delta_Constraint : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Constraint,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Delta_Constraint'Access,
         Inherited_Members => 36,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Delta_Constraint_F_Digits,
2 => Member_Index_For_Delta_Constraint_F_Range
         ));
      
      Node_Name_For_Digits_Constraint : aliased constant Text_Type :=
        "Digits_Constraint";
      Node_Desc_For_Digits_Constraint : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Constraint,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Digits_Constraint'Access,
         Inherited_Members => 36,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Digits_Constraint_F_Digits,
2 => Member_Index_For_Digits_Constraint_F_Range
         ));
      
      Node_Name_For_Range_Constraint : aliased constant Text_Type :=
        "Range_Constraint";
      Node_Desc_For_Range_Constraint : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Constraint,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Range_Constraint'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Range_Constraint_F_Range
         ));
      
      Node_Name_For_Declarative_Part : aliased constant Text_Type :=
        "Declarative_Part";
      Node_Desc_For_Declarative_Part : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Declarative_Part'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 => Type_Index_For_Private_Part,
2 => Type_Index_For_Public_Part
         ),
         Members           => (
              1 => Member_Index_For_Declarative_Part_F_Decls
         ));
      
      Node_Name_For_Private_Part : aliased constant Text_Type :=
        "Private_Part";
      Node_Desc_For_Private_Part : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Declarative_Part,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Private_Part'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Public_Part : aliased constant Text_Type :=
        "Public_Part";
      Node_Desc_For_Public_Part : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Declarative_Part,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Public_Part'Access,
         Inherited_Members => 35,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Elsif_Expr_Part : aliased constant Text_Type :=
        "Elsif_Expr_Part";
      Node_Desc_For_Elsif_Expr_Part : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Elsif_Expr_Part'Access,
         Inherited_Members => 36,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Elsif_Expr_Part_F_Cond_Expr,
2 => Member_Index_For_Elsif_Expr_Part_F_Then_Expr
         ));
      
      Node_Name_For_Elsif_Stmt_Part : aliased constant Text_Type :=
        "Elsif_Stmt_Part";
      Node_Desc_For_Elsif_Stmt_Part : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Elsif_Stmt_Part'Access,
         Inherited_Members => 36,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Elsif_Stmt_Part_F_Cond_Expr,
2 => Member_Index_For_Elsif_Stmt_Part_F_Stmts
         ));
      
      Node_Name_For_Expr : aliased constant Text_Type :=
        "Expr";
      Node_Desc_For_Expr : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 17,
         Member_Count      => 11,
         Base_Type         => Type_Index_For_Ada_Node,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Expr'Access,
         Inherited_Members => 45,
         Derivations       => (
             1 => Type_Index_For_Abstract_State_Decl_Expr,
2 => Type_Index_For_Allocator,
3 => Type_Index_For_Base_Aggregate,
4 => Type_Index_For_Bin_Op,
5 => Type_Index_For_Box_Expr,
6 => Type_Index_For_Case_Expr_Alternative,
7 => Type_Index_For_Concat_Op,
8 => Type_Index_For_Concat_Operand,
9 => Type_Index_For_Cond_Expr,
10 => Type_Index_For_Contract_Cases,
11 => Type_Index_For_Decl_Expr,
12 => Type_Index_For_Membership_Expr,
13 => Type_Index_For_Name,
14 => Type_Index_For_Paren_Expr,
15 => Type_Index_For_Quantified_Expr,
16 => Type_Index_For_Raise_Expr,
17 => Type_Index_For_Un_Op
         ),
         Members           => (
              1 => Member_Index_For_Expr_P_Expression_Type,
2 => Member_Index_For_Expr_P_Expected_Expression_Type,
3 => Member_Index_For_Expr_P_Is_Dynamically_Tagged,
4 => Member_Index_For_Expr_P_Is_Dispatching_Call,
5 => Member_Index_For_Expr_P_Is_Static_Expr,
6 => Member_Index_For_Expr_P_First_Corresponding_Decl,
7 => Member_Index_For_Expr_P_Eval_As_Int,
8 => Member_Index_For_Expr_P_Eval_As_Int_In_Env,
9 => Member_Index_For_Expr_P_Eval_As_String,
10 => Member_Index_For_Expr_P_Eval_As_String_In_Env,
11 => Member_Index_For_Expr_P_Matching_Nodes
         ));
      
      Node_Name_For_Abstract_State_Decl_Expr : aliased constant Text_Type :=
        "Abstract_State_Decl_Expr";
      Node_Desc_For_Abstract_State_Decl_Expr : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Abstract_State_Decl_Expr'Access,
         Inherited_Members => 46,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Abstract_State_Decl_Expr_F_State_Decl
         ));
      
      Node_Name_For_Allocator : aliased constant Text_Type :=
        "Allocator";
      Node_Desc_For_Allocator : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Allocator'Access,
         Inherited_Members => 48,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Allocator_F_Subpool,
2 => Member_Index_For_Allocator_F_Type_Or_Expr,
3 => Member_Index_For_Allocator_P_Get_Allocated_Type
         ));
      
      Node_Name_For_Base_Aggregate : aliased constant Text_Type :=
        "Base_Aggregate";
      Node_Desc_For_Base_Aggregate : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 3,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Base_Aggregate'Access,
         Inherited_Members => 49,
         Derivations       => (
             1 => Type_Index_For_Aggregate,
2 => Type_Index_For_Delta_Aggregate,
3 => Type_Index_For_Null_Record_Aggregate
         ),
         Members           => (
              1 => Member_Index_For_Base_Aggregate_F_Ancestor_Expr,
2 => Member_Index_For_Base_Aggregate_F_Assocs,
3 => Member_Index_For_Base_Aggregate_P_Aggregate_Params,
4 => Member_Index_For_Base_Aggregate_P_Is_Subaggregate
         ));
      
      Node_Name_For_Aggregate : aliased constant Text_Type :=
        "Aggregate";
      Node_Desc_For_Aggregate : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 1,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Base_Aggregate,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Aggregate'Access,
         Inherited_Members => 49,
         Derivations       => (
             1 => Type_Index_For_Bracket_Aggregate
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Bracket_Aggregate : aliased constant Text_Type :=
        "Bracket_Aggregate";
      Node_Desc_For_Bracket_Aggregate : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Aggregate,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Bracket_Aggregate'Access,
         Inherited_Members => 49,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Delta_Aggregate : aliased constant Text_Type :=
        "Delta_Aggregate";
      Node_Desc_For_Delta_Aggregate : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 1,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Base_Aggregate,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Delta_Aggregate'Access,
         Inherited_Members => 49,
         Derivations       => (
             1 => Type_Index_For_Bracket_Delta_Aggregate
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Bracket_Delta_Aggregate : aliased constant Text_Type :=
        "Bracket_Delta_Aggregate";
      Node_Desc_For_Bracket_Delta_Aggregate : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Delta_Aggregate,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Bracket_Delta_Aggregate'Access,
         Inherited_Members => 49,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Null_Record_Aggregate : aliased constant Text_Type :=
        "Null_Record_Aggregate";
      Node_Desc_For_Null_Record_Aggregate : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Base_Aggregate,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Null_Record_Aggregate'Access,
         Inherited_Members => 49,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Bin_Op : aliased constant Text_Type :=
        "Bin_Op";
      Node_Desc_For_Bin_Op : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 1,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Bin_Op'Access,
         Inherited_Members => 48,
         Derivations       => (
             1 => Type_Index_For_Relation_Op
         ),
         Members           => (
              1 => Member_Index_For_Bin_Op_F_Left,
2 => Member_Index_For_Bin_Op_F_Op,
3 => Member_Index_For_Bin_Op_F_Right
         ));
      
      Node_Name_For_Relation_Op : aliased constant Text_Type :=
        "Relation_Op";
      Node_Desc_For_Relation_Op : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Bin_Op,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Relation_Op'Access,
         Inherited_Members => 48,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Box_Expr : aliased constant Text_Type :=
        "Box_Expr";
      Node_Desc_For_Box_Expr : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Box_Expr'Access,
         Inherited_Members => 45,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Case_Expr_Alternative : aliased constant Text_Type :=
        "Case_Expr_Alternative";
      Node_Desc_For_Case_Expr_Alternative : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Case_Expr_Alternative'Access,
         Inherited_Members => 47,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Case_Expr_Alternative_F_Choices,
2 => Member_Index_For_Case_Expr_Alternative_F_Expr
         ));
      
      Node_Name_For_Concat_Op : aliased constant Text_Type :=
        "Concat_Op";
      Node_Desc_For_Concat_Op : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Concat_Op'Access,
         Inherited_Members => 48,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Concat_Op_F_First_Operand,
2 => Member_Index_For_Concat_Op_F_Other_Operands,
3 => Member_Index_For_Concat_Op_P_Operands
         ));
      
      Node_Name_For_Concat_Operand : aliased constant Text_Type :=
        "Concat_Operand";
      Node_Desc_For_Concat_Operand : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Concat_Operand'Access,
         Inherited_Members => 47,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Concat_Operand_F_Operator,
2 => Member_Index_For_Concat_Operand_F_Operand
         ));
      
      Node_Name_For_Cond_Expr : aliased constant Text_Type :=
        "Cond_Expr";
      Node_Desc_For_Cond_Expr : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 2,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Cond_Expr'Access,
         Inherited_Members => 46,
         Derivations       => (
             1 => Type_Index_For_Case_Expr,
2 => Type_Index_For_If_Expr
         ),
         Members           => (
              1 => Member_Index_For_Cond_Expr_P_Dependent_Exprs
         ));
      
      Node_Name_For_Case_Expr : aliased constant Text_Type :=
        "Case_Expr";
      Node_Desc_For_Case_Expr : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Cond_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Case_Expr'Access,
         Inherited_Members => 48,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Case_Expr_F_Expr,
2 => Member_Index_For_Case_Expr_F_Cases
         ));
      
      Node_Name_For_If_Expr : aliased constant Text_Type :=
        "If_Expr";
      Node_Desc_For_If_Expr : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Cond_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_If_Expr'Access,
         Inherited_Members => 50,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_If_Expr_F_Cond_Expr,
2 => Member_Index_For_If_Expr_F_Then_Expr,
3 => Member_Index_For_If_Expr_F_Alternatives,
4 => Member_Index_For_If_Expr_F_Else_Expr
         ));
      
      Node_Name_For_Contract_Cases : aliased constant Text_Type :=
        "Contract_Cases";
      Node_Desc_For_Contract_Cases : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Contract_Cases'Access,
         Inherited_Members => 46,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Contract_Cases_F_Contract_Cases
         ));
      
      Node_Name_For_Decl_Expr : aliased constant Text_Type :=
        "Decl_Expr";
      Node_Desc_For_Decl_Expr : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Decl_Expr'Access,
         Inherited_Members => 47,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Decl_Expr_F_Decls,
2 => Member_Index_For_Decl_Expr_F_Expr
         ));
      
      Node_Name_For_Membership_Expr : aliased constant Text_Type :=
        "Membership_Expr";
      Node_Desc_For_Membership_Expr : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Membership_Expr'Access,
         Inherited_Members => 48,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Membership_Expr_F_Expr,
2 => Member_Index_For_Membership_Expr_F_Op,
3 => Member_Index_For_Membership_Expr_F_Membership_Exprs
         ));
      
      Node_Name_For_Name : aliased constant Text_Type :=
        "Name";
      Node_Desc_For_Name : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 13,
         Member_Count      => 25,
         Base_Type         => Type_Index_For_Expr,
         Is_Abstract       => True,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Name'Access,
         Inherited_Members => 70,
         Derivations       => (
             1 => Type_Index_For_Attribute_Ref,
2 => Type_Index_For_Call_Expr,
3 => Type_Index_For_Defining_Name,
4 => Type_Index_For_Discrete_Subtype_Name,
5 => Type_Index_For_Dotted_Name,
6 => Type_Index_For_End_Name,
7 => Type_Index_For_Explicit_Deref,
8 => Type_Index_For_Qual_Expr,
9 => Type_Index_For_Reduce_Attribute_Ref,
10 => Type_Index_For_Single_Tok_Node,
11 => Type_Index_For_Synthetic_Identifier,
12 => Type_Index_For_Target_Name,
13 => Type_Index_For_Update_Attribute_Ref
         ),
         Members           => (
              1 => Member_Index_For_Name_P_Enclosing_Defining_Name,
2 => Member_Index_For_Name_P_Is_Defining,
3 => Member_Index_For_Name_P_Name_Is,
4 => Member_Index_For_Name_P_Is_Direct_Call,
5 => Member_Index_For_Name_P_Is_Access_Call,
6 => Member_Index_For_Name_P_Is_Call,
7 => Member_Index_For_Name_P_Is_Dot_Call,
8 => Member_Index_For_Name_P_Failsafe_Referenced_Def_Name,
9 => Member_Index_For_Name_P_Referenced_Defining_Name,
10 => Member_Index_For_Name_P_All_Env_Elements,
11 => Member_Index_For_Name_P_Called_Subp_Spec,
12 => Member_Index_For_Name_P_Referenced_Decl,
13 => Member_Index_For_Name_P_Failsafe_Referenced_Decl,
14 => Member_Index_For_Name_P_Referenced_Decl_Internal,
15 => Member_Index_For_Name_P_Name_Designated_Type,
16 => Member_Index_For_Name_P_Is_Static_Subtype,
17 => Member_Index_For_Name_P_Name_Matches,
18 => Member_Index_For_Name_P_Relative_Name,
19 => Member_Index_For_Name_P_Is_Operator_Name,
20 => Member_Index_For_Name_P_Is_Write_Reference,
21 => Member_Index_For_Name_P_Is_Static_Call,
22 => Member_Index_For_Name_P_As_Symbol_Array,
23 => Member_Index_For_Name_P_Canonical_Text,
24 => Member_Index_For_Name_P_Is_Constant,
25 => Member_Index_For_Name_P_Call_Params
         ));
      
      Node_Name_For_Attribute_Ref : aliased constant Text_Type :=
        "Attribute_Ref";
      Node_Desc_For_Attribute_Ref : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Name,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Attribute_Ref'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Attribute_Ref_F_Prefix,
2 => Member_Index_For_Attribute_Ref_F_Attribute,
3 => Member_Index_For_Attribute_Ref_F_Args
         ));
      
      Node_Name_For_Call_Expr : aliased constant Text_Type :=
        "Call_Expr";
      Node_Desc_For_Call_Expr : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 4,
         Base_Type         => Type_Index_For_Name,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Call_Expr'Access,
         Inherited_Members => 74,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Call_Expr_F_Name,
2 => Member_Index_For_Call_Expr_F_Suffix,
3 => Member_Index_For_Call_Expr_P_Kind,
4 => Member_Index_For_Call_Expr_P_Is_Array_Slice
         ));
      
      Node_Name_For_Defining_Name : aliased constant Text_Type :=
        "Defining_Name";
      Node_Desc_For_Defining_Name : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 1,
         Member_Count      => 21,
         Base_Type         => Type_Index_For_Name,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Defining_Name'Access,
         Inherited_Members => 91,
         Derivations       => (
             1 => Type_Index_For_Synthetic_Defining_Name
         ),
         Members           => (
              1 => Member_Index_For_Defining_Name_F_Name,
2 => Member_Index_For_Defining_Name_P_Canonical_Fully_Qualified_Name,
3 => Member_Index_For_Defining_Name_P_Unique_Identifying_Name,
4 => Member_Index_For_Defining_Name_P_Fully_Qualified_Name_Array,
5 => Member_Index_For_Defining_Name_P_Fully_Qualified_Name,
6 => Member_Index_For_Defining_Name_P_Basic_Decl,
7 => Member_Index_For_Defining_Name_P_Find_Refs,
8 => Member_Index_For_Defining_Name_P_Find_All_References,
9 => Member_Index_For_Defining_Name_P_Find_All_Calls,
10 => Member_Index_For_Defining_Name_P_Next_Part,
11 => Member_Index_For_Defining_Name_P_Previous_Part,
12 => Member_Index_For_Defining_Name_P_Canonical_Part,
13 => Member_Index_For_Defining_Name_P_Most_Visible_Part,
14 => Member_Index_For_Defining_Name_P_All_Parts,
15 => Member_Index_For_Defining_Name_P_Get_Aspect,
16 => Member_Index_For_Defining_Name_P_Has_Aspect,
17 => Member_Index_For_Defining_Name_P_Get_Pragma,
18 => Member_Index_For_Defining_Name_P_Get_Representation_Clause,
19 => Member_Index_For_Defining_Name_P_Get_At_Clause,
20 => Member_Index_For_Defining_Name_P_Is_Imported,
21 => Member_Index_For_Defining_Name_P_Is_Ghost_Code
         ));
      
      Node_Name_For_Synthetic_Defining_Name : aliased constant Text_Type :=
        "Synthetic_Defining_Name";
      Node_Desc_For_Synthetic_Defining_Name : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Defining_Name,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Synthetic_Defining_Name'Access,
         Inherited_Members => 91,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Discrete_Subtype_Name : aliased constant Text_Type :=
        "Discrete_Subtype_Name";
      Node_Desc_For_Discrete_Subtype_Name : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Name,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Discrete_Subtype_Name'Access,
         Inherited_Members => 71,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Discrete_Subtype_Name_F_Subtype
         ));
      
      Node_Name_For_Dotted_Name : aliased constant Text_Type :=
        "Dotted_Name";
      Node_Desc_For_Dotted_Name : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Name,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Dotted_Name'Access,
         Inherited_Members => 72,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Dotted_Name_F_Prefix,
2 => Member_Index_For_Dotted_Name_F_Suffix
         ));
      
      Node_Name_For_End_Name : aliased constant Text_Type :=
        "End_Name";
      Node_Desc_For_End_Name : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Name,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_End_Name'Access,
         Inherited_Members => 72,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_End_Name_F_Name,
2 => Member_Index_For_End_Name_P_Basic_Decl
         ));
      
      Node_Name_For_Explicit_Deref : aliased constant Text_Type :=
        "Explicit_Deref";
      Node_Desc_For_Explicit_Deref : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Name,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Explicit_Deref'Access,
         Inherited_Members => 71,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Explicit_Deref_F_Prefix
         ));
      
      Node_Name_For_Qual_Expr : aliased constant Text_Type :=
        "Qual_Expr";
      Node_Desc_For_Qual_Expr : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 2,
         Base_Type         => Type_Index_For_Name,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Qual_Expr'Access,
         Inherited_Members => 72,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Qual_Expr_F_Prefix,
2 => Member_Index_For_Qual_Expr_F_Suffix
         ));
      
      Node_Name_For_Reduce_Attribute_Ref : aliased constant Text_Type :=
        "Reduce_Attribute_Ref";
      Node_Desc_For_Reduce_Attribute_Ref : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 3,
         Base_Type         => Type_Index_For_Name,
         Is_Abstract       => False,
         Is_Token_Node     => False,
         Is_List_Node      => False,
         Name              => Node_Name_For_Reduce_Attribute_Ref'Access,
         Inherited_Members => 73,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Reduce_Attribute_Ref_F_Prefix,
2 => Member_Index_For_Reduce_Attribute_Ref_F_Attribute,
3 => Member_Index_For_Reduce_Attribute_Ref_F_Args
         ));
      
      Node_Name_For_Single_Tok_Node : aliased constant Text_Type :=
        "Single_Tok_Node";
      Node_Desc_For_Single_Tok_Node : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 3,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Name,
         Is_Abstract       => True,
         Is_Token_Node     => True,
         Is_List_Node      => False,
         Name              => Node_Name_For_Single_Tok_Node'Access,
         Inherited_Members => 70,
         Derivations       => (
             1 => Type_Index_For_Base_Id,
2 => Type_Index_For_Null_Literal,
3 => Type_Index_For_Num_Literal
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Base_Id : aliased constant Text_Type :=
        "Base_Id";
      Node_Desc_For_Base_Id : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 4,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Single_Tok_Node,
         Is_Abstract       => True,
         Is_Token_Node     => True,
         Is_List_Node      => False,
         Name              => Node_Name_For_Base_Id'Access,
         Inherited_Members => 70,
         Derivations       => (
             1 => Type_Index_For_Char_Literal,
2 => Type_Index_For_Identifier,
3 => Type_Index_For_Op,
4 => Type_Index_For_String_Literal
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Char_Literal : aliased constant Text_Type :=
        "Char_Literal";
      Node_Desc_For_Char_Literal : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 1,
         Base_Type         => Type_Index_For_Base_Id,
         Is_Abstract       => False,
         Is_Token_Node     => True,
         Is_List_Node      => False,
         Name              => Node_Name_For_Char_Literal'Access,
         Inherited_Members => 71,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 => Member_Index_For_Char_Literal_P_Denoted_Value
         ));
      
      Node_Name_For_Identifier : aliased constant Text_Type :=
        "Identifier";
      Node_Desc_For_Identifier : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Base_Id,
         Is_Abstract       => False,
         Is_Token_Node     => True,
         Is_List_Node      => False,
         Name              => Node_Name_For_Identifier'Access,
         Inherited_Members => 70,
         Derivations       => (
             1 .. 0 => <>
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op : aliased constant Text_Type :=
        "Op";
      Node_Desc_For_Op : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 24,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Base_Id,
         Is_Abstract       => True,
         Is_Token_Node     => True,
         Is_List_Node      => False,
         Name              => Node_Name_For_Op'Access,
         Inherited_Members => 70,
         Derivations       => (
             1 => Type_Index_For_Op_Abs,
2 => Type_Index_For_Op_And,
3 => Type_Index_For_Op_And_Then,
4 => Type_Index_For_Op_Concat,
5 => Type_Index_For_Op_Div,
6 => Type_Index_For_Op_Double_Dot,
7 => Type_Index_For_Op_Eq,
8 => Type_Index_For_Op_Gt,
9 => Type_Index_For_Op_Gte,
10 => Type_Index_For_Op_In,
11 => Type_Index_For_Op_Lt,
12 => Type_Index_For_Op_Lte,
13 => Type_Index_For_Op_Minus,
14 => Type_Index_For_Op_Mod,
15 => Type_Index_For_Op_Mult,
16 => Type_Index_For_Op_Neq,
17 => Type_Index_For_Op_Not,
18 => Type_Index_For_Op_Not_In,
19 => Type_Index_For_Op_Or,
20 => Type_Index_For_Op_Or_Else,
21 => Type_Index_For_Op_Plus,
22 => Type_Index_For_Op_Pow,
23 => Type_Index_For_Op_Rem,
24 => Type_Index_For_Op_Xor
         ),
         Members           => (
              1 .. 0 => <>
         ));
      
      Node_Name_For_Op_Abs : aliased constant Text_Type :=
        "Op_Abs";
      Node_Desc_For_Op_Abs : aliased constant Struct_Type_Descriptor :=
        (Derivations_Count => 0,
         Member_Count      => 0,
         Base_Type         => Type_Index_For_Op,
         Is_Abstract       => False,