; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @use(i32)
define i1 @cmpeq_xor_cst1(i32 %a, i32 %b) {
; CHECK-LABEL: @cmpeq_xor_cst1(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[TMP1]], 10
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %c = xor i32 %a, 10
  %cmp = icmp eq i32 %c, %b
  ret i1 %cmp
}

define i1 @cmpeq_xor_cst2(i32 %a, i32 %b) {
; CHECK-LABEL: @cmpeq_xor_cst2(
; CHECK-NEXT:    [[C:%.*]] = xor i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[C]], 10
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %c = xor i32 %a, %b
  %cmp = icmp eq i32 %c, 10
  ret i1 %cmp
}

define i1 @cmpeq_xor_cst3(i32 %a, i32 %b) {
; CHECK-LABEL: @cmpeq_xor_cst3(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %c = xor i32 %a, 10
  %d = xor i32 %b, 10
  %cmp = icmp eq i32 %c, %d
  ret i1 %cmp
}

define i1 @cmpne_xor_cst1(i32 %a, i32 %b) {
; CHECK-LABEL: @cmpne_xor_cst1(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[TMP1]], 10
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %c = xor i32 %a, 10
  %cmp = icmp ne i32 %c, %b
  ret i1 %cmp
}

define i1 @cmpne_xor_cst2(i32 %a, i32 %b) {
; CHECK-LABEL: @cmpne_xor_cst2(
; CHECK-NEXT:    [[C:%.*]] = xor i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[C]], 10
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %c = xor i32 %a, %b
  %cmp = icmp ne i32 %c, 10
  ret i1 %cmp
}

define i1 @cmpne_xor_cst3(i32 %a, i32 %b) {
; CHECK-LABEL: @cmpne_xor_cst3(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %c = xor i32 %a, 10
  %d = xor i32 %b, 10
  %cmp = icmp ne i32 %c, %d
  ret i1 %cmp
}

define i1 @cmpeq_xor_cst1_multiuse(i32 %a, i32 %b) {
; CHECK-LABEL: @cmpeq_xor_cst1_multiuse(
; CHECK-NEXT:    [[C:%.*]] = xor i32 [[A:%.*]], 10
; CHECK-NEXT:    call void @use(i32 [[C]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[C]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %c = xor i32 %a, 10
  call void @use(i32 %c)
  %cmp = icmp eq i32 %c, %b
  ret i1 %cmp
}

define i1 @cmpeq_xor_cst1_commuted(i32 %a, i32 %b) {
; CHECK-LABEL: @cmpeq_xor_cst1_commuted(
; CHECK-NEXT:    [[B2:%.*]] = mul i32 [[B:%.*]], [[B]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[B2]], [[A:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[TMP1]], 10
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %b2 = mul i32 %b, %b ; thwart complexity-based canonicalization
  %c = xor i32 %a, 10
  %cmp = icmp eq i32 %b2, %c
  ret i1 %cmp
}

define <2 x i1> @cmpeq_xor_cst1_vec(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: @cmpeq_xor_cst1_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = xor <2 x i32> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i32> [[TMP1]], <i32 10, i32 11>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %c = xor <2 x i32> %a, <i32 10, i32 11>
  %cmp = icmp eq <2 x i32> %b, %c
  ret <2 x i1> %cmp
}

; tests from PR65968
define i1 @foo1(i32 %x, i32 %y) {
; CHECK-LABEL: @foo1(
; CHECK-NEXT:    [[NEG1:%.*]] = xor i32 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[NEG1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %and = and i32 %x, -2147483648
  %neg = xor i32 %y, -1
  %and1 = and i32 %neg, -2147483648
  %cmp = icmp eq i32 %and, %and1
  ret i1 %cmp
}

define i1 @foo2(i32 %x, i32 %y) {
; CHECK-LABEL: @foo2(
; CHECK-NEXT:    [[NEG1:%.*]] = xor i32 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[NEG1]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %and = and i32 %x, -2147483648
  %neg = and i32 %y, -2147483648
  %and1 = xor i32 %neg, -2147483648
  %cmp = icmp eq i32 %and, %and1
  ret i1 %cmp
}

; tests from PR67783
define <2 x i1> @foo3(<2 x i8> %x) {
; CHECK-LABEL: @foo3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[XOR:%.*]] = xor <2 x i8> [[X:%.*]], <i8 -2, i8 -1>
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i8> [[XOR]], <i8 9, i8 79>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
entry:
  %xor = xor <2 x i8> %x, <i8 -2, i8 -1>
  %cmp = icmp ne <2 x i8> %xor, <i8 9, i8 79>
  ret <2 x i1> %cmp
}
