; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- | FileCheck %s

;
; 32-bit float to signed integer
;

declare <4 x i1> @llvm.fptosi.sat.v4i1.v4f32(<4 x float>)
declare <4 x i8> @llvm.fptosi.sat.v4i8.v4f32(<4 x float>)
declare <4 x i16> @llvm.fptosi.sat.v4i16.v4f32(<4 x float>)
declare <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float>)
declare <4 x i64> @llvm.fptosi.sat.v4i64.v4f32(<4 x float>)
declare <4 x i128> @llvm.fptosi.sat.v4i128.v4f32(<4 x float>)

define <4 x i1> @test_signed_v4i1_v4f32(<4 x float> %f) nounwind {
; CHECK-LABEL: test_signed_v4i1_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movaps %xmm0, %xmm1
; CHECK-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm0[3,3]
; CHECK-NEXT:    movss {{.*#+}} xmm2 = [-1.0E+0,0.0E+0,0.0E+0,0.0E+0]
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    ucomiss %xmm1, %xmm1
; CHECK-NEXT:    maxss %xmm2, %xmm1
; CHECK-NEXT:    xorps %xmm3, %xmm3
; CHECK-NEXT:    minss %xmm3, %xmm1
; CHECK-NEXT:    cvttss2si %xmm1, %ecx
; CHECK-NEXT:    cmovpl %eax, %ecx
; CHECK-NEXT:    movd %ecx, %xmm1
; CHECK-NEXT:    movaps %xmm0, %xmm4
; CHECK-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm0[1]
; CHECK-NEXT:    ucomiss %xmm4, %xmm4
; CHECK-NEXT:    maxss %xmm2, %xmm4
; CHECK-NEXT:    minss %xmm3, %xmm4
; CHECK-NEXT:    cvttss2si %xmm4, %ecx
; CHECK-NEXT:    cmovpl %eax, %ecx
; CHECK-NEXT:    movd %ecx, %xmm4
; CHECK-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; CHECK-NEXT:    movaps %xmm0, %xmm1
; CHECK-NEXT:    maxss %xmm2, %xmm1
; CHECK-NEXT:    minss %xmm3, %xmm1
; CHECK-NEXT:    cvttss2si %xmm1, %ecx
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %eax, %ecx
; CHECK-NEXT:    movd %ecx, %xmm1
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    maxss %xmm2, %xmm0
; CHECK-NEXT:    minss %xmm3, %xmm0
; CHECK-NEXT:    cvttss2si %xmm0, %ecx
; CHECK-NEXT:    cmovpl %eax, %ecx
; CHECK-NEXT:    movd %ecx, %xmm0
; CHECK-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; CHECK-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm4[0]
; CHECK-NEXT:    movdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %x = call <4 x i1> @llvm.fptosi.sat.v4i1.v4f32(<4 x float> %f)
  ret <4 x i1> %x
}

define <4 x i8> @test_signed_v4i8_v4f32(<4 x float> %f) nounwind {
; CHECK-LABEL: test_signed_v4i8_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movss {{.*#+}} xmm1 = [-1.28E+2,0.0E+0,0.0E+0,0.0E+0]
; CHECK-NEXT:    movaps %xmm1, %xmm3
; CHECK-NEXT:    maxss %xmm0, %xmm3
; CHECK-NEXT:    movss {{.*#+}} xmm2 = [1.27E+2,0.0E+0,0.0E+0,0.0E+0]
; CHECK-NEXT:    movaps %xmm2, %xmm4
; CHECK-NEXT:    minss %xmm3, %xmm4
; CHECK-NEXT:    cvttss2si %xmm4, %eax
; CHECK-NEXT:    movzbl %al, %eax
; CHECK-NEXT:    movaps %xmm0, %xmm3
; CHECK-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm0[1,1]
; CHECK-NEXT:    movaps %xmm1, %xmm4
; CHECK-NEXT:    maxss %xmm3, %xmm4
; CHECK-NEXT:    movaps %xmm2, %xmm3
; CHECK-NEXT:    minss %xmm4, %xmm3
; CHECK-NEXT:    cvttss2si %xmm3, %ecx
; CHECK-NEXT:    movzbl %cl, %ecx
; CHECK-NEXT:    shll $8, %ecx
; CHECK-NEXT:    orl %eax, %ecx
; CHECK-NEXT:    movaps %xmm0, %xmm3
; CHECK-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm0[1]
; CHECK-NEXT:    movaps %xmm1, %xmm4
; CHECK-NEXT:    maxss %xmm3, %xmm4
; CHECK-NEXT:    movaps %xmm2, %xmm3
; CHECK-NEXT:    minss %xmm4, %xmm3
; CHECK-NEXT:    cvttss2si %xmm3, %eax
; CHECK-NEXT:    movzbl %al, %eax
; CHECK-NEXT:    shll $16, %eax
; CHECK-NEXT:    orl %ecx, %eax
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-NEXT:    maxss %xmm0, %xmm1
; CHECK-NEXT:    minss %xmm1, %xmm2
; CHECK-NEXT:    cvttss2si %xmm2, %ecx
; CHECK-NEXT:    shll $24, %ecx
; CHECK-NEXT:    orl %eax, %ecx
; CHECK-NEXT:    movd %ecx, %xmm0
; CHECK-NEXT:    retq
  %x = call <4 x i8> @llvm.fptosi.sat.v4i8.v4f32(<4 x float> %f)
  ret <4 x i8> %x
}

define <4 x i16> @test_signed_v4i16_v4f32(<4 x float> %f) nounwind {
; CHECK-LABEL: test_signed_v4i16_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movaps %xmm0, %xmm1
; CHECK-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; CHECK-NEXT:    movss {{.*#+}} xmm2 = [-3.2768E+4,0.0E+0,0.0E+0,0.0E+0]
; CHECK-NEXT:    movaps %xmm2, %xmm3
; CHECK-NEXT:    maxss %xmm1, %xmm3
; CHECK-NEXT:    movss {{.*#+}} xmm4 = [3.2767E+4,0.0E+0,0.0E+0,0.0E+0]
; CHECK-NEXT:    movaps %xmm4, %xmm1
; CHECK-NEXT:    minss %xmm3, %xmm1
; CHECK-NEXT:    cvttss2si %xmm1, %eax
; CHECK-NEXT:    movaps %xmm2, %xmm1
; CHECK-NEXT:    maxss %xmm0, %xmm1
; CHECK-NEXT:    movaps %xmm4, %xmm3
; CHECK-NEXT:    minss %xmm1, %xmm3
; CHECK-NEXT:    cvttss2si %xmm3, %ecx
; CHECK-NEXT:    movd %ecx, %xmm1
; CHECK-NEXT:    pinsrw $1, %eax, %xmm1
; CHECK-NEXT:    movaps %xmm0, %xmm3
; CHECK-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm0[1]
; CHECK-NEXT:    movaps %xmm2, %xmm5
; CHECK-NEXT:    maxss %xmm3, %xmm5
; CHECK-NEXT:    movaps %xmm4, %xmm3
; CHECK-NEXT:    minss %xmm5, %xmm3
; CHECK-NEXT:    cvttss2si %xmm3, %eax
; CHECK-NEXT:    pinsrw $2, %eax, %xmm1
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-NEXT:    maxss %xmm0, %xmm2
; CHECK-NEXT:    minss %xmm2, %xmm4
; CHECK-NEXT:    cvttss2si %xmm4, %eax
; CHECK-NEXT:    pinsrw $3, %eax, %xmm1
; CHECK-NEXT:    movdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %x = call <4 x i16> @llvm.fptosi.sat.v4i16.v4f32(<4 x float> %f)
  ret <4 x i16> %x
}

define <4 x i32> @test_signed_v4i32_v4f32(<4 x float> %f) nounwind {
; CHECK-LABEL: test_signed_v4i32_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movaps %xmm0, %xmm1
; CHECK-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm0[3,3]
; CHECK-NEXT:    cvttss2si %xmm1, %edx
; CHECK-NEXT:    movss {{.*#+}} xmm2 = [2.14748352E+9,0.0E+0,0.0E+0,0.0E+0]
; CHECK-NEXT:    ucomiss %xmm2, %xmm1
; CHECK-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; CHECK-NEXT:    cmoval %eax, %edx
; CHECK-NEXT:    xorl %ecx, %ecx
; CHECK-NEXT:    ucomiss %xmm1, %xmm1
; CHECK-NEXT:    cmovpl %ecx, %edx
; CHECK-NEXT:    movd %edx, %xmm1
; CHECK-NEXT:    movaps %xmm0, %xmm3
; CHECK-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm0[1]
; CHECK-NEXT:    cvttss2si %xmm3, %edx
; CHECK-NEXT:    ucomiss %xmm2, %xmm3
; CHECK-NEXT:    cmoval %eax, %edx
; CHECK-NEXT:    ucomiss %xmm3, %xmm3
; CHECK-NEXT:    cmovpl %ecx, %edx
; CHECK-NEXT:    movd %edx, %xmm3
; CHECK-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; CHECK-NEXT:    cvttss2si %xmm0, %edx
; CHECK-NEXT:    ucomiss %xmm2, %xmm0
; CHECK-NEXT:    cmoval %eax, %edx
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %ecx, %edx
; CHECK-NEXT:    movd %edx, %xmm1
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-NEXT:    cvttss2si %xmm0, %edx
; CHECK-NEXT:    ucomiss %xmm2, %xmm0
; CHECK-NEXT:    cmoval %eax, %edx
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %ecx, %edx
; CHECK-NEXT:    movd %edx, %xmm0
; CHECK-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; CHECK-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; CHECK-NEXT:    movdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %x = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float> %f)
  ret <4 x i32> %x
}

define <4 x i64> @test_signed_v4i64_v4f32(<4 x float> %f) nounwind {
; CHECK-LABEL: test_signed_v4i64_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvttss2si %xmm0, %rdx
; CHECK-NEXT:    movss {{.*#+}} xmm1 = [9.22337149E+18,0.0E+0,0.0E+0,0.0E+0]
; CHECK-NEXT:    ucomiss %xmm1, %xmm0
; CHECK-NEXT:    movabsq $9223372036854775807, %rax # imm = 0x7FFFFFFFFFFFFFFF
; CHECK-NEXT:    cmovaq %rax, %rdx
; CHECK-NEXT:    xorl %ecx, %ecx
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %rcx, %rdx
; CHECK-NEXT:    movq %rdx, %xmm2
; CHECK-NEXT:    movaps %xmm0, %xmm3
; CHECK-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm0[1,1]
; CHECK-NEXT:    cvttss2si %xmm3, %rdx
; CHECK-NEXT:    ucomiss %xmm1, %xmm3
; CHECK-NEXT:    cmovaq %rax, %rdx
; CHECK-NEXT:    ucomiss %xmm3, %xmm3
; CHECK-NEXT:    cmovpq %rcx, %rdx
; CHECK-NEXT:    movq %rdx, %xmm3
; CHECK-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; CHECK-NEXT:    movaps %xmm0, %xmm3
; CHECK-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm0[3,3]
; CHECK-NEXT:    cvttss2si %xmm3, %rdx
; CHECK-NEXT:    ucomiss %xmm1, %xmm3
; CHECK-NEXT:    cmovaq %rax, %rdx
; CHECK-NEXT:    ucomiss %xmm3, %xmm3
; CHECK-NEXT:    cmovpq %rcx, %rdx
; CHECK-NEXT:    movq %rdx, %xmm3
; CHECK-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    cvttss2si %xmm0, %rdx
; CHECK-NEXT:    ucomiss %xmm1, %xmm0
; CHECK-NEXT:    cmovaq %rax, %rdx
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %rcx, %rdx
; CHECK-NEXT:    movq %rdx, %xmm1
; CHECK-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; CHECK-NEXT:    movdqa %xmm2, %xmm0
; CHECK-NEXT:    retq
  %x = call <4 x i64> @llvm.fptosi.sat.v4i64.v4f32(<4 x float> %f)
  ret <4 x i64> %x
}

define <4 x i128> @test_signed_v4i128_v4f32(<4 x float> %f) nounwind {
; CHECK-LABEL: test_signed_v4i128_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r15
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %r13
; CHECK-NEXT:    pushq %r12
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $56, %rsp
; CHECK-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-NEXT:    movq %rdi, %rbx
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    callq __fixsfti@PLT
; CHECK-NEXT:    movq %rdx, %r15
; CHECK-NEXT:    xorl %r14d, %r14d
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %r14, %rax
; CHECK-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; CHECK-NEXT:    cmovbq %rcx, %r15
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movabsq $9223372036854775807, %rbp # imm = 0x7FFFFFFFFFFFFFFF
; CHECK-NEXT:    cmovaq %rbp, %r15
; CHECK-NEXT:    movq $-1, %rcx
; CHECK-NEXT:    cmovaq %rcx, %rax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r14, %rax
; CHECK-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    cmovpq %r14, %r15
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    callq __fixsfti@PLT
; CHECK-NEXT:    movq %rax, %r12
; CHECK-NEXT:    movq %rdx, %r13
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %r14, %r12
; CHECK-NEXT:    movabsq $-9223372036854775808, %rax # imm = 0x8000000000000000
; CHECK-NEXT:    cmovbq %rax, %r13
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %rbp, %r13
; CHECK-NEXT:    movq $-1, %rax
; CHECK-NEXT:    cmovaq %rax, %r12
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r14, %r12
; CHECK-NEXT:    cmovpq %r14, %r13
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    callq __fixsfti@PLT
; CHECK-NEXT:    movq %rax, %rbp
; CHECK-NEXT:    movq %rdx, %r14
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movl $0, %eax
; CHECK-NEXT:    cmovbq %rax, %rbp
; CHECK-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; CHECK-NEXT:    cmovbq %rcx, %r14
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; CHECK-NEXT:    cmovaq %rcx, %r14
; CHECK-NEXT:    movq $-1, %rcx
; CHECK-NEXT:    cmovaq %rcx, %rbp
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %rax, %rbp
; CHECK-NEXT:    cmovpq %rax, %r14
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    callq __fixsfti@PLT
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movl $0, %esi
; CHECK-NEXT:    cmovbq %rsi, %rax
; CHECK-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; CHECK-NEXT:    cmovbq %rcx, %rdx
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; CHECK-NEXT:    cmovaq %rcx, %rdx
; CHECK-NEXT:    movq $-1, %rcx
; CHECK-NEXT:    cmovaq %rcx, %rax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %rsi, %rax
; CHECK-NEXT:    movl $0, %ecx
; CHECK-NEXT:    cmovpq %rcx, %rdx
; CHECK-NEXT:    movq %rdx, 8(%rbx)
; CHECK-NEXT:    movq %rax, (%rbx)
; CHECK-NEXT:    movq %r14, 56(%rbx)
; CHECK-NEXT:    movq %rbp, 48(%rbx)
; CHECK-NEXT:    movq %r13, 40(%rbx)
; CHECK-NEXT:    movq %r12, 32(%rbx)
; CHECK-NEXT:    movq %r15, 24(%rbx)
; CHECK-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; CHECK-NEXT:    movq %rax, 16(%rbx)
; CHECK-NEXT:    movq %rbx, %rax
; CHECK-NEXT:    addq $56, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r12
; CHECK-NEXT:    popq %r13
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %r15
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
  %x = call <4 x i128> @llvm.fptosi.sat.v4i128.v4f32(<4 x float> %f)
  ret <4 x i128> %x
}

;
; 64-bit float to signed integer
;

declare <2 x i1> @llvm.fptosi.sat.v2i1.v2f64(<2 x double>)
declare <2 x i8> @llvm.fptosi.sat.v2i8.v2f64(<2 x double>)
declare <2 x i16> @llvm.fptosi.sat.v2i16.v2f64(<2 x double>)
declare <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double>)
declare <2 x i64> @llvm.fptosi.sat.v2i64.v2f64(<2 x double>)
declare <2 x i128> @llvm.fptosi.sat.v2i128.v2f64(<2 x double>)

define <2 x i1> @test_signed_v2i1_v2f64(<2 x double> %f) nounwind {
; CHECK-LABEL: test_signed_v2i1_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movsd {{.*#+}} xmm2 = [-1.0E+0,0.0E+0]
; CHECK-NEXT:    movapd %xmm0, %xmm1
; CHECK-NEXT:    maxsd %xmm2, %xmm1
; CHECK-NEXT:    xorpd %xmm3, %xmm3
; CHECK-NEXT:    minsd %xmm3, %xmm1
; CHECK-NEXT:    cvttsd2si %xmm1, %rax
; CHECK-NEXT:    xorl %ecx, %ecx
; CHECK-NEXT:    ucomisd %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %rcx, %rax
; CHECK-NEXT:    movq %rax, %xmm1
; CHECK-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    ucomisd %xmm0, %xmm0
; CHECK-NEXT:    maxsd %xmm2, %xmm0
; CHECK-NEXT:    minsd %xmm3, %xmm0
; CHECK-NEXT:    cvttsd2si %xmm0, %rax
; CHECK-NEXT:    cmovpq %rcx, %rax
; CHECK-NEXT:    movq %rax, %xmm0
; CHECK-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; CHECK-NEXT:    movdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %x = call <2 x i1> @llvm.fptosi.sat.v2i1.v2f64(<2 x double> %f)
  ret <2 x i1> %x
}

define <2 x i8> @test_signed_v2i8_v2f64(<2 x double> %f) nounwind {
; CHECK-LABEL: test_signed_v2i8_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movsd {{.*#+}} xmm1 = [-1.28E+2,0.0E+0]
; CHECK-NEXT:    movapd %xmm1, %xmm2
; CHECK-NEXT:    maxsd %xmm0, %xmm2
; CHECK-NEXT:    movsd {{.*#+}} xmm3 = [1.27E+2,0.0E+0]
; CHECK-NEXT:    movapd %xmm3, %xmm4
; CHECK-NEXT:    minsd %xmm2, %xmm4
; CHECK-NEXT:    cvttsd2si %xmm4, %eax
; CHECK-NEXT:    movzbl %al, %eax
; CHECK-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    maxsd %xmm0, %xmm1
; CHECK-NEXT:    minsd %xmm1, %xmm3
; CHECK-NEXT:    cvttsd2si %xmm3, %ecx
; CHECK-NEXT:    shll $8, %ecx
; CHECK-NEXT:    orl %eax, %ecx
; CHECK-NEXT:    movd %ecx, %xmm0
; CHECK-NEXT:    retq
  %x = call <2 x i8> @llvm.fptosi.sat.v2i8.v2f64(<2 x double> %f)
  ret <2 x i8> %x
}

define <2 x i16> @test_signed_v2i16_v2f64(<2 x double> %f) nounwind {
; CHECK-LABEL: test_signed_v2i16_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movsd {{.*#+}} xmm1 = [-3.2768E+4,0.0E+0]
; CHECK-NEXT:    movapd %xmm1, %xmm2
; CHECK-NEXT:    maxsd %xmm0, %xmm1
; CHECK-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    maxsd %xmm0, %xmm2
; CHECK-NEXT:    movsd {{.*#+}} xmm0 = [3.2767E+4,0.0E+0]
; CHECK-NEXT:    movapd %xmm0, %xmm3
; CHECK-NEXT:    minsd %xmm2, %xmm3
; CHECK-NEXT:    cvttsd2si %xmm3, %eax
; CHECK-NEXT:    minsd %xmm1, %xmm0
; CHECK-NEXT:    cvttsd2si %xmm0, %ecx
; CHECK-NEXT:    movd %ecx, %xmm0
; CHECK-NEXT:    pinsrw $1, %eax, %xmm0
; CHECK-NEXT:    retq
  %x = call <2 x i16> @llvm.fptosi.sat.v2i16.v2f64(<2 x double> %f)
  ret <2 x i16> %x
}

define <2 x i32> @test_signed_v2i32_v2f64(<2 x double> %f) nounwind {
; CHECK-LABEL: test_signed_v2i32_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movsd {{.*#+}} xmm2 = [-2.147483648E+9,0.0E+0]
; CHECK-NEXT:    movapd %xmm0, %xmm1
; CHECK-NEXT:    maxsd %xmm2, %xmm1
; CHECK-NEXT:    movsd {{.*#+}} xmm3 = [2.147483647E+9,0.0E+0]
; CHECK-NEXT:    minsd %xmm3, %xmm1
; CHECK-NEXT:    cvttsd2si %xmm1, %eax
; CHECK-NEXT:    xorl %ecx, %ecx
; CHECK-NEXT:    ucomisd %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %ecx, %eax
; CHECK-NEXT:    movd %eax, %xmm1
; CHECK-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    ucomisd %xmm0, %xmm0
; CHECK-NEXT:    maxsd %xmm2, %xmm0
; CHECK-NEXT:    minsd %xmm3, %xmm0
; CHECK-NEXT:    cvttsd2si %xmm0, %eax
; CHECK-NEXT:    cmovpl %ecx, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; CHECK-NEXT:    movdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %x = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double> %f)
  ret <2 x i32> %x
}

define <2 x i64> @test_signed_v2i64_v2f64(<2 x double> %f) nounwind {
; CHECK-LABEL: test_signed_v2i64_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvttsd2si %xmm0, %rax
; CHECK-NEXT:    movsd {{.*#+}} xmm2 = [9.2233720368547748E+18,0.0E+0]
; CHECK-NEXT:    ucomisd %xmm2, %xmm0
; CHECK-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; CHECK-NEXT:    cmovaq %rcx, %rax
; CHECK-NEXT:    xorl %edx, %edx
; CHECK-NEXT:    ucomisd %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %rdx, %rax
; CHECK-NEXT:    movq %rax, %xmm1
; CHECK-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    cvttsd2si %xmm0, %rax
; CHECK-NEXT:    ucomisd %xmm2, %xmm0
; CHECK-NEXT:    cmovaq %rcx, %rax
; CHECK-NEXT:    ucomisd %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %rdx, %rax
; CHECK-NEXT:    movq %rax, %xmm0
; CHECK-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; CHECK-NEXT:    movdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %x = call <2 x i64> @llvm.fptosi.sat.v2i64.v2f64(<2 x double> %f)
  ret <2 x i64> %x
}

define <2 x i128> @test_signed_v2i128_v2f64(<2 x double> %f) nounwind {
; CHECK-LABEL: test_signed_v2i128_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r15
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %r13
; CHECK-NEXT:    pushq %r12
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $40, %rsp
; CHECK-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-NEXT:    movq %rdi, %rbx
; CHECK-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    callq __fixdfti@PLT
; CHECK-NEXT:    movq %rax, %r14
; CHECK-NEXT:    movq %rdx, %r15
; CHECK-NEXT:    xorl %r12d, %r12d
; CHECK-NEXT:    movapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    ucomisd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %r12, %r14
; CHECK-NEXT:    movabsq $-9223372036854775808, %rax # imm = 0x8000000000000000
; CHECK-NEXT:    cmovbq %rax, %r15
; CHECK-NEXT:    ucomisd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movabsq $9223372036854775807, %rbp # imm = 0x7FFFFFFFFFFFFFFF
; CHECK-NEXT:    cmovaq %rbp, %r15
; CHECK-NEXT:    movq $-1, %r13
; CHECK-NEXT:    cmovaq %r13, %r14
; CHECK-NEXT:    ucomisd %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r12, %r14
; CHECK-NEXT:    cmovpq %r12, %r15
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    callq __fixdfti@PLT
; CHECK-NEXT:    movapd (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    ucomisd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %r12, %rax
; CHECK-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; CHECK-NEXT:    cmovbq %rcx, %rdx
; CHECK-NEXT:    ucomisd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %rbp, %rdx
; CHECK-NEXT:    cmovaq %r13, %rax
; CHECK-NEXT:    ucomisd %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r12, %rax
; CHECK-NEXT:    cmovpq %r12, %rdx
; CHECK-NEXT:    movq %rdx, 8(%rbx)
; CHECK-NEXT:    movq %rax, (%rbx)
; CHECK-NEXT:    movq %r15, 24(%rbx)
; CHECK-NEXT:    movq %r14, 16(%rbx)
; CHECK-NEXT:    movq %rbx, %rax
; CHECK-NEXT:    addq $40, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r12
; CHECK-NEXT:    popq %r13
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %r15
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
  %x = call <2 x i128> @llvm.fptosi.sat.v2i128.v2f64(<2 x double> %f)
  ret <2 x i128> %x
}

;
; 16-bit float to signed integer
;

declare <8 x i1> @llvm.fptosi.sat.v8i1.v8f16(<8 x half>)
declare <8 x i8> @llvm.fptosi.sat.v8i8.v8f16(<8 x half>)
declare <8 x i16> @llvm.fptosi.sat.v8i16.v8f16(<8 x half>)
declare <8 x i32> @llvm.fptosi.sat.v8i32.v8f16(<8 x half>)
declare <8 x i64> @llvm.fptosi.sat.v8i64.v8f16(<8 x half>)
declare <8 x i128> @llvm.fptosi.sat.v8i128.v8f16(<8 x half>)

define <8 x i1> @test_signed_v8i1_v8f16(<8 x half> %f) nounwind {
; CHECK-LABEL: test_signed_v8i1_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $72, %rsp
; CHECK-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; CHECK-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movl $65535, %ebp # imm = 0xFFFF
; CHECK-NEXT:    cmovbl %ebp, %eax
; CHECK-NEXT:    xorl %ebx, %ebx
; CHECK-NEXT:    xorps %xmm1, %xmm1
; CHECK-NEXT:    ucomiss %xmm1, %xmm0
; CHECK-NEXT:    cmoval %ebx, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %ebx, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebp, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebx, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %ebx, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    punpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebp, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebx, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %ebx, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebp, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebx, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %ebx, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    punpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; CHECK-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrlq $48, %xmm0
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebp, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebx, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %ebx, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebp, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebx, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %ebx, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    punpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebp, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebx, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %ebx, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrld $16, %xmm0
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebp, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebx, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %ebx, %eax
; CHECK-NEXT:    movd %eax, %xmm1
; CHECK-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; CHECK-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; CHECK-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0]
; CHECK-NEXT:    addq $72, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
  %x = call <8 x i1> @llvm.fptosi.sat.v8i1.v8f16(<8 x half> %f)
  ret <8 x i1> %x
}

define <8 x i8> @test_signed_v8i8_v8f16(<8 x half> %f) nounwind {
; CHECK-LABEL: test_signed_v8i8_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r15
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %r13
; CHECK-NEXT:    pushq %r12
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $40, %rsp
; CHECK-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; CHECK-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %r12d
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movl $128, %ebx
; CHECK-NEXT:    cmovbl %ebx, %r12d
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movl $127, %ebp
; CHECK-NEXT:    cmoval %ebp, %r12d
; CHECK-NEXT:    xorl %r14d, %r14d
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %r12d
; CHECK-NEXT:    shll $8, %r12d
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movzbl %al, %r15d
; CHECK-NEXT:    orl %r12d, %r15d
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movzbl %al, %r12d
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrld $16, %xmm0
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movzbl %al, %r13d
; CHECK-NEXT:    shll $8, %r13d
; CHECK-NEXT:    orl %r12d, %r13d
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movzbl %al, %r12d
; CHECK-NEXT:    shll $16, %r12d
; CHECK-NEXT:    orl %r13d, %r12d
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrlq $48, %xmm0
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    shll $24, %eax
; CHECK-NEXT:    orl %r12d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    pinsrw $2, %r15d, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %r15d
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %r15d
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %r15d
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %r15d
; CHECK-NEXT:    shll $8, %r15d
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movzbl %al, %eax
; CHECK-NEXT:    orl %r15d, %eax
; CHECK-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    pinsrw $3, %eax, %xmm0
; CHECK-NEXT:    addq $40, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r12
; CHECK-NEXT:    popq %r13
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %r15
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
  %x = call <8 x i8> @llvm.fptosi.sat.v8i8.v8f16(<8 x half> %f)
  ret <8 x i8> %x
}

define <8 x i16> @test_signed_v8i16_v8f16(<8 x half> %f) nounwind {
; CHECK-LABEL: test_signed_v8i16_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $64, %rsp
; CHECK-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; CHECK-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movl $32768, %ebx # imm = 0x8000
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movl $32767, %ebp # imm = 0x7FFF
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    xorl %r14d, %r14d
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    punpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    punpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; CHECK-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrlq $48, %xmm0
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    punpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrld $16, %xmm0
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm1
; CHECK-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; CHECK-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; CHECK-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0]
; CHECK-NEXT:    addq $64, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
  %x = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f16(<8 x half> %f)
  ret <8 x i16> %x
}

define <8 x i32> @test_signed_v8i32_v8f16(<8 x half> %f) nounwind {
; CHECK-LABEL: test_signed_v8i32_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $64, %rsp
; CHECK-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; CHECK-NEXT:    psrlq $48, %xmm0
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movl $-2147483648, %ebx # imm = 0x80000000
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movl $2147483647, %ebp # imm = 0x7FFFFFFF
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    xorl %r14d, %r14d
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrld $16, %xmm0
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; CHECK-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; CHECK-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm1 = xmm1[0],mem[0]
; CHECK-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbl %ebx, %eax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmoval %ebp, %eax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpl %r14d, %eax
; CHECK-NEXT:    movd %eax, %xmm1
; CHECK-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; CHECK-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm1 = xmm1[0],mem[0]
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    addq $64, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
  %x = call <8 x i32> @llvm.fptosi.sat.v8i32.v8f16(<8 x half> %f)
  ret <8 x i32> %x
}

define <8 x i64> @test_signed_v8i64_v8f16(<8 x half> %f) nounwind {
; CHECK-LABEL: test_signed_v8i64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %r15
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $80, %rsp
; CHECK-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movabsq $-9223372036854775808, %rbx # imm = 0x8000000000000000
; CHECK-NEXT:    cmovbq %rbx, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movabsq $9223372036854775807, %r14 # imm = 0x7FFFFFFFFFFFFFFF
; CHECK-NEXT:    cmovaq %r14, %rax
; CHECK-NEXT:    xorl %r15d, %r15d
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r15, %rax
; CHECK-NEXT:    movq %rax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrld $16, %xmm0
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %rbx, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %r14, %rax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r15, %rax
; CHECK-NEXT:    movq %rax, %xmm0
; CHECK-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; CHECK-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; CHECK-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrlq $48, %xmm0
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %rbx, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %r14, %rax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r15, %rax
; CHECK-NEXT:    movq %rax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %rbx, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %r14, %rax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r15, %rax
; CHECK-NEXT:    movq %rax, %xmm0
; CHECK-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0]
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %rbx, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %r14, %rax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r15, %rax
; CHECK-NEXT:    movq %rax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %rbx, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %r14, %rax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r15, %rax
; CHECK-NEXT:    movq %rax, %xmm0
; CHECK-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm0 = xmm0[0],mem[0]
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %rbx, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %r14, %rax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r15, %rax
; CHECK-NEXT:    movq %rax, %xmm0
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    cvttss2si %xmm0, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %rbx, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %r14, %rax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r15, %rax
; CHECK-NEXT:    movq %rax, %xmm3
; CHECK-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; CHECK-NEXT:    # xmm3 = xmm3[0],mem[0]
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; CHECK-NEXT:    addq $80, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %r15
; CHECK-NEXT:    retq
  %x = call <8 x i64> @llvm.fptosi.sat.v8i64.v8f16(<8 x half> %f)
  ret <8 x i64> %x
}

define <8 x i128> @test_signed_v8i128_v8f16(<8 x half> %f) nounwind {
; CHECK-LABEL: test_signed_v8i128_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r15
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %r13
; CHECK-NEXT:    pushq %r12
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $104, %rsp
; CHECK-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movq %rdi, %rbx
; CHECK-NEXT:    psrld $16, %xmm0
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    movd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    callq __fixsfti@PLT
; CHECK-NEXT:    xorl %r12d, %r12d
; CHECK-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %r12, %rax
; CHECK-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; CHECK-NEXT:    cmovbq %rcx, %rdx
; CHECK-NEXT:    movq %rcx, %r14
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; CHECK-NEXT:    cmovaq %rcx, %rdx
; CHECK-NEXT:    movq %rcx, %r15
; CHECK-NEXT:    movq $-1, %rcx
; CHECK-NEXT:    cmovaq %rcx, %rax
; CHECK-NEXT:    movq $-1, %r13
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r12, %rax
; CHECK-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    cmovpq %r12, %rdx
; CHECK-NEXT:    movq %rdx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    callq __fixsfti@PLT
; CHECK-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %r12, %rax
; CHECK-NEXT:    cmovbq %r14, %rdx
; CHECK-NEXT:    movq %r14, %rbp
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %r15, %rdx
; CHECK-NEXT:    cmovaq %r13, %rax
; CHECK-NEXT:    movq $-1, %r14
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r12, %rax
; CHECK-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    cmovpq %r12, %rdx
; CHECK-NEXT:    movq %rdx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrlq $48, %xmm0
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    movd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    callq __fixsfti@PLT
; CHECK-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %r12, %rax
; CHECK-NEXT:    cmovbq %rbp, %rdx
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %r15, %rdx
; CHECK-NEXT:    cmovaq %r14, %rax
; CHECK-NEXT:    movq $-1, %r14
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r12, %rax
; CHECK-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    cmovpq %r12, %rdx
; CHECK-NEXT:    movq %rdx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    callq __fixsfti@PLT
; CHECK-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %r12, %rax
; CHECK-NEXT:    cmovbq %rbp, %rdx
; CHECK-NEXT:    movq %rbp, %r13
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %r15, %rdx
; CHECK-NEXT:    cmovaq %r14, %rax
; CHECK-NEXT:    movq $-1, %r14
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r12, %rax
; CHECK-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    cmovpq %r12, %rdx
; CHECK-NEXT:    movq %rdx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    movd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    callq __fixsfti@PLT
; CHECK-NEXT:    movq %rdx, %rbp
; CHECK-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %r12, %rax
; CHECK-NEXT:    cmovbq %r13, %rbp
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %r15, %rbp
; CHECK-NEXT:    movq %r15, %r13
; CHECK-NEXT:    cmovaq %r14, %rax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r12, %rax
; CHECK-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    cmovpq %r12, %rbp
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    callq __fixsfti@PLT
; CHECK-NEXT:    movq %rax, %r14
; CHECK-NEXT:    movq %rdx, %r15
; CHECK-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovbq %r12, %r14
; CHECK-NEXT:    movabsq $-9223372036854775808, %rax # imm = 0x8000000000000000
; CHECK-NEXT:    cmovbq %rax, %r15
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    cmovaq %r13, %r15
; CHECK-NEXT:    movq $-1, %rax
; CHECK-NEXT:    cmovaq %rax, %r14
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %r12, %r14
; CHECK-NEXT:    cmovpq %r12, %r15
; CHECK-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    movd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    callq __fixsfti@PLT
; CHECK-NEXT:    movq %rax, %r12
; CHECK-NEXT:    movq %rdx, %r13
; CHECK-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movl $0, %eax
; CHECK-NEXT:    cmovbq %rax, %r12
; CHECK-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; CHECK-NEXT:    cmovbq %rcx, %r13
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; CHECK-NEXT:    cmovaq %rcx, %r13
; CHECK-NEXT:    movq $-1, %rcx
; CHECK-NEXT:    cmovaq %rcx, %r12
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %rax, %r12
; CHECK-NEXT:    cmovpq %rax, %r13
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    callq __fixsfti@PLT
; CHECK-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; CHECK-NEXT:    cmovbq %rcx, %rdx
; CHECK-NEXT:    movl $0, %esi
; CHECK-NEXT:    cmovbq %rsi, %rax
; CHECK-NEXT:    ucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; CHECK-NEXT:    cmovaq %rcx, %rdx
; CHECK-NEXT:    movq $-1, %rcx
; CHECK-NEXT:    cmovaq %rcx, %rax
; CHECK-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-NEXT:    cmovpq %rsi, %rax
; CHECK-NEXT:    movl $0, %ecx
; CHECK-NEXT:    cmovpq %rcx, %rdx
; CHECK-NEXT:    movq %rdx, 8(%rbx)
; CHECK-NEXT:    movq %rax, (%rbx)
; CHECK-NEXT:    movq %r13, 120(%rbx)
; CHECK-NEXT:    movq %r12, 112(%rbx)
; CHECK-NEXT:    movq %r15, 104(%rbx)
; CHECK-NEXT:    movq %r14, 96(%rbx)
; CHECK-NEXT:    movq %rbp, 88(%rbx)
; CHECK-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; CHECK-NEXT:    movq %rax, 80(%rbx)
; CHECK-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; CHECK-NEXT:    movq %rax, 72(%rbx)
; CHECK-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; CHECK-NEXT:    movq %rax, 64(%rbx)
; CHECK-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; CHECK-NEXT:    movq %rax, 56(%rbx)
; CHECK-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; CHECK-NEXT:    movq %rax, 48(%rbx)
; CHECK-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; CHECK-NEXT:    movq %rax, 40(%rbx)
; CHECK-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; CHECK-NEXT:    movq %rax, 32(%rbx)
; CHECK-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; CHECK-NEXT:    movq %rax, 24(%rbx)
; CHECK-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; CHECK-NEXT:    movq %rax, 16(%rbx)
; CHECK-NEXT:    movq %rbx, %rax
; CHECK-NEXT:    addq $104, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r12
; CHECK-NEXT:    popq %r13
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %r15
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
  %x = call <8 x i128> @llvm.fptosi.sat.v8i128.v8f16(<8 x half> %f)
  ret <8 x i128> %x
}
