; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=slp-vectorizer -S -mtriple=x86_64-- -mattr=+avx  | FileCheck %s
; RUN: opt < %s -passes=slp-vectorizer -S -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s

define float @matching_scalar(ptr dereferenceable(16) %p) {
; CHECK-LABEL: @matching_scalar(
; CHECK-NEXT:    [[R:%.*]] = load float, ptr [[P:%.*]], align 16
; CHECK-NEXT:    ret float [[R]]
;
  %r = load float, ptr %p, align 16
  ret float %r
}

define i32 @nonmatching_scalar(ptr dereferenceable(16) %p) {
; CHECK-LABEL: @nonmatching_scalar(
; CHECK-NEXT:    [[R:%.*]] = load i32, ptr [[P:%.*]], align 16
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = load i32, ptr %p, align 16
  ret i32 %r
}

define i64 @larger_scalar(ptr dereferenceable(16) %p) {
; CHECK-LABEL: @larger_scalar(
; CHECK-NEXT:    [[R:%.*]] = load i64, ptr [[P:%.*]], align 16
; CHECK-NEXT:    ret i64 [[R]]
;
  %r = load i64, ptr %p, align 16
  ret i64 %r
}

define i8 @smaller_scalar(ptr dereferenceable(16) %p) {
; CHECK-LABEL: @smaller_scalar(
; CHECK-NEXT:    [[R:%.*]] = load i8, ptr [[P:%.*]], align 16
; CHECK-NEXT:    ret i8 [[R]]
;
  %r = load i8, ptr %p, align 16
  ret i8 %r
}

define i8 @smaller_scalar_256bit_vec(ptr dereferenceable(32) %p) {
; CHECK-LABEL: @smaller_scalar_256bit_vec(
; CHECK-NEXT:    [[R:%.*]] = load i8, ptr [[P:%.*]], align 32
; CHECK-NEXT:    ret i8 [[R]]
;
  %r = load i8, ptr %p, align 32
  ret i8 %r
}

define i8 @smaller_scalar_less_aligned(ptr dereferenceable(16) %p) {
; CHECK-LABEL: @smaller_scalar_less_aligned(
; CHECK-NEXT:    [[R:%.*]] = load i8, ptr [[P:%.*]], align 4
; CHECK-NEXT:    ret i8 [[R]]
;
  %r = load i8, ptr %p, align 4
  ret i8 %r
}

define float @matching_scalar_small_deref(ptr dereferenceable(15) %p) {
; CHECK-LABEL: @matching_scalar_small_deref(
; CHECK-NEXT:    [[R:%.*]] = load float, ptr [[P:%.*]], align 16
; CHECK-NEXT:    ret float [[R]]
;
  %r = load float, ptr %p, align 16
  ret float %r
}

define float @matching_scalar_volatile(ptr dereferenceable(16) %p) {
; CHECK-LABEL: @matching_scalar_volatile(
; CHECK-NEXT:    [[R:%.*]] = load volatile float, ptr [[P:%.*]], align 16
; CHECK-NEXT:    ret float [[R]]
;
  %r = load volatile float, ptr %p, align 16
  ret float %r
}

define float @nonvector(ptr dereferenceable(16) %p) {
; CHECK-LABEL: @nonvector(
; CHECK-NEXT:    [[R:%.*]] = load float, ptr [[P:%.*]], align 16
; CHECK-NEXT:    ret float [[R]]
;
  %r = load float, ptr %p, align 16
  ret float %r
}
