; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -verify-machineinstrs -mtriple=arm64-none-linux-gnu -mattr=+neon | FileCheck %s

define <16 x i8> @div16xi8(<16 x i8> %x) {
; CHECK-LABEL: div16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #41
; CHECK-NEXT:    smull2 v2.8h, v0.16b, v1.16b
; CHECK-NEXT:    smull v0.8h, v0.8b, v1.8b
; CHECK-NEXT:    uzp2 v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    sshr v0.16b, v0.16b, #2
; CHECK-NEXT:    usra v0.16b, v0.16b, #7
; CHECK-NEXT:    ret
  %div = sdiv <16 x i8> %x, <i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25>
  ret <16 x i8> %div
}

define <8 x i16> @div8xi16(<8 x i16> %x) {
; CHECK-LABEL: div8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #40815 // =0x9f6f
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    smull2 v2.4s, v0.8h, v1.8h
; CHECK-NEXT:    smull v1.4s, v0.4h, v1.4h
; CHECK-NEXT:    uzp2 v1.8h, v1.8h, v2.8h
; CHECK-NEXT:    add v0.8h, v1.8h, v0.8h
; CHECK-NEXT:    sshr v0.8h, v0.8h, #12
; CHECK-NEXT:    usra v0.8h, v0.8h, #15
; CHECK-NEXT:    ret
  %div = sdiv <8 x i16> %x, <i16 6577, i16 6577, i16 6577, i16 6577, i16 6577, i16 6577, i16 6577, i16 6577>
  ret <8 x i16> %div
}

define <4 x i32> @div32xi4(<4 x i32> %x) {
; CHECK-LABEL: div32xi4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7527 // =0x1d67
; CHECK-NEXT:    movk w8, #28805, lsl #16
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    smull2 v2.2d, v0.4s, v1.4s
; CHECK-NEXT:    smull v0.2d, v0.2s, v1.2s
; CHECK-NEXT:    uzp2 v1.4s, v0.4s, v2.4s
; CHECK-NEXT:    sshr v0.4s, v1.4s, #22
; CHECK-NEXT:    usra v0.4s, v1.4s, #31
; CHECK-NEXT:    ret
  %div = sdiv <4 x i32> %x, <i32 9542677, i32 9542677, i32 9542677, i32 9542677>
  ret <4 x i32> %div
}

define <16 x i8> @udiv16xi8(<16 x i8> %x) {
; CHECK-LABEL: udiv16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #121
; CHECK-NEXT:    umull2 v2.8h, v0.16b, v1.16b
; CHECK-NEXT:    umull v0.8h, v0.8b, v1.8b
; CHECK-NEXT:    uzp2 v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #5
; CHECK-NEXT:    ret
  %div = udiv <16 x i8> %x, <i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68>
  ret <16 x i8> %div
}

define <8 x i16> @udiv8xi16(<8 x i16> %x) {
; CHECK-LABEL: udiv8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #16593 // =0x40d1
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    umull2 v2.4s, v0.8h, v1.8h
; CHECK-NEXT:    umull v1.4s, v0.4h, v1.4h
; CHECK-NEXT:    uzp2 v1.8h, v1.8h, v2.8h
; CHECK-NEXT:    sub v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    usra v1.8h, v0.8h, #1
; CHECK-NEXT:    ushr v0.8h, v1.8h, #12
; CHECK-NEXT:    ret
  %div = udiv <8 x i16> %x, <i16 6537, i16 6537, i16 6537, i16 6537, i16 6537, i16 6537, i16 6537, i16 6537>
  ret <8 x i16> %div
}

define <4 x i32> @udiv32xi4(<4 x i32> %x) {
; CHECK-LABEL: udiv32xi4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #16747 // =0x416b
; CHECK-NEXT:    movk w8, #31439, lsl #16
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    umull2 v2.2d, v0.4s, v1.4s
; CHECK-NEXT:    umull v0.2d, v0.2s, v1.2s
; CHECK-NEXT:    uzp2 v0.4s, v0.4s, v2.4s
; CHECK-NEXT:    ushr v0.4s, v0.4s, #22
; CHECK-NEXT:    ret
  %div = udiv <4 x i32> %x, <i32 8743143, i32 8743143, i32 8743143, i32 8743143>
  ret <4 x i32> %div
}
