; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx600 < %s | FileCheck --check-prefixes=GFX6 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx700 < %s | FileCheck --check-prefixes=GFX7 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1010 < %s | FileCheck --check-prefixes=GFX10-WGP %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1010 -mattr=+cumode < %s | FileCheck --check-prefixes=GFX10-CU %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -O0 -mcpu=gfx700 -amdgcn-skip-cache-invalidations < %s | FileCheck --check-prefixes=SKIP-CACHE-INV %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX90A-NOTTGSPLIT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx90a -mattr=+tgsplit < %s | FileCheck -check-prefixes=GFX90A-TGSPLIT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx940 < %s | FileCheck -check-prefixes=GFX940-NOTTGSPLIT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx940 -mattr=+tgsplit < %s | FileCheck -check-prefixes=GFX940-TGSPLIT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1100 < %s | FileCheck --check-prefixes=GFX11-WGP %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1100 -mattr=+cumode < %s | FileCheck --check-prefixes=GFX11-CU %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1200 < %s | FileCheck --check-prefixes=GFX12-WGP %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1200 -mattr=+cumode < %s | FileCheck --check-prefixes=GFX12-CU %s

define amdgpu_kernel void @workgroup_acquire_fence() {
; GFX6-LABEL: workgroup_acquire_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: workgroup_acquire_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: workgroup_acquire_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: workgroup_acquire_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: workgroup_acquire_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: workgroup_acquire_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: workgroup_acquire_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: workgroup_acquire_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: workgroup_acquire_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc0
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: workgroup_acquire_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: workgroup_acquire_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: workgroup_acquire_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: workgroup_acquire_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("workgroup") acquire, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @workgroup_release_fence() {
; GFX6-LABEL: workgroup_release_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: workgroup_release_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: workgroup_release_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: workgroup_release_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: workgroup_release_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: workgroup_release_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: workgroup_release_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: workgroup_release_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: workgroup_release_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: workgroup_release_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: workgroup_release_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: workgroup_release_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: workgroup_release_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("workgroup") release, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @workgroup_acq_rel_fence() {
; GFX6-LABEL: workgroup_acq_rel_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: workgroup_acq_rel_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: workgroup_acq_rel_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: workgroup_acq_rel_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: workgroup_acq_rel_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: workgroup_acq_rel_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: workgroup_acq_rel_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: workgroup_acq_rel_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: workgroup_acq_rel_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc0
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: workgroup_acq_rel_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: workgroup_acq_rel_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: workgroup_acq_rel_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: workgroup_acq_rel_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("workgroup") acq_rel, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @workgroup_seq_cst_fence() {
; GFX6-LABEL: workgroup_seq_cst_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: workgroup_seq_cst_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: workgroup_seq_cst_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: workgroup_seq_cst_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: workgroup_seq_cst_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: workgroup_seq_cst_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: workgroup_seq_cst_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: workgroup_seq_cst_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: workgroup_seq_cst_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc0
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: workgroup_seq_cst_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: workgroup_seq_cst_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: workgroup_seq_cst_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: workgroup_seq_cst_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("workgroup") seq_cst, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @workgroup_one_as_acquire_fence() {
; GFX6-LABEL: workgroup_one_as_acquire_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: workgroup_one_as_acquire_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: workgroup_one_as_acquire_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: workgroup_one_as_acquire_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: workgroup_one_as_acquire_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: workgroup_one_as_acquire_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: workgroup_one_as_acquire_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: workgroup_one_as_acquire_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: workgroup_one_as_acquire_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc0
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: workgroup_one_as_acquire_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: workgroup_one_as_acquire_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: workgroup_one_as_acquire_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: workgroup_one_as_acquire_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("workgroup-one-as") acquire, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @workgroup_one_as_release_fence() {
; GFX6-LABEL: workgroup_one_as_release_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: workgroup_one_as_release_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: workgroup_one_as_release_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: workgroup_one_as_release_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: workgroup_one_as_release_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: workgroup_one_as_release_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: workgroup_one_as_release_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: workgroup_one_as_release_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: workgroup_one_as_release_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: workgroup_one_as_release_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: workgroup_one_as_release_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: workgroup_one_as_release_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: workgroup_one_as_release_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("workgroup-one-as") release, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @workgroup_one_as_acq_rel_fence() {
; GFX6-LABEL: workgroup_one_as_acq_rel_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: workgroup_one_as_acq_rel_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: workgroup_one_as_acq_rel_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: workgroup_one_as_acq_rel_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: workgroup_one_as_acq_rel_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: workgroup_one_as_acq_rel_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: workgroup_one_as_acq_rel_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: workgroup_one_as_acq_rel_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: workgroup_one_as_acq_rel_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc0
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: workgroup_one_as_acq_rel_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: workgroup_one_as_acq_rel_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: workgroup_one_as_acq_rel_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: workgroup_one_as_acq_rel_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("workgroup-one-as") acq_rel, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @workgroup_one_as_seq_cst_fence() {
; GFX6-LABEL: workgroup_one_as_seq_cst_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: workgroup_one_as_seq_cst_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: workgroup_one_as_seq_cst_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: workgroup_one_as_seq_cst_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: workgroup_one_as_seq_cst_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: workgroup_one_as_seq_cst_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: workgroup_one_as_seq_cst_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: workgroup_one_as_seq_cst_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: workgroup_one_as_seq_cst_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc0
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: workgroup_one_as_seq_cst_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: workgroup_one_as_seq_cst_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: workgroup_one_as_seq_cst_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: workgroup_one_as_seq_cst_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("workgroup-one-as") seq_cst, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @agent_acquire_fence() {
; GFX6-LABEL: agent_acquire_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: agent_acquire_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: agent_acquire_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl1_inv
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: agent_acquire_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    buffer_gl1_inv
; GFX10-CU-NEXT:    buffer_gl0_inv
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: agent_acquire_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: agent_acquire_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: agent_acquire_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: agent_acquire_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    buffer_inv sc1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: agent_acquire_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: agent_acquire_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl1_inv
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: agent_acquire_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    buffer_gl1_inv
; GFX11-CU-NEXT:    buffer_gl0_inv
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: agent_acquire_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: agent_acquire_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("agent") acquire, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @agent_release_fence() {
; GFX6-LABEL: agent_release_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: agent_release_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: agent_release_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: agent_release_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: agent_release_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: agent_release_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: agent_release_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: agent_release_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    buffer_wbl2 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: agent_release_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    buffer_wbl2 sc1
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: agent_release_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: agent_release_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: agent_release_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: agent_release_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("agent") release, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @agent_acq_rel_fence() {
; GFX6-LABEL: agent_acq_rel_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: agent_acq_rel_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: agent_acq_rel_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl1_inv
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: agent_acq_rel_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    buffer_gl1_inv
; GFX10-CU-NEXT:    buffer_gl0_inv
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: agent_acq_rel_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: agent_acq_rel_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: agent_acq_rel_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: agent_acq_rel_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    buffer_wbl2 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    buffer_inv sc1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: agent_acq_rel_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    buffer_wbl2 sc1
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: agent_acq_rel_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl1_inv
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: agent_acq_rel_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    buffer_gl1_inv
; GFX11-CU-NEXT:    buffer_gl0_inv
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: agent_acq_rel_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: agent_acq_rel_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("agent") acq_rel, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @agent_seq_cst_fence() {
; GFX6-LABEL: agent_seq_cst_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: agent_seq_cst_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: agent_seq_cst_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl1_inv
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: agent_seq_cst_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    buffer_gl1_inv
; GFX10-CU-NEXT:    buffer_gl0_inv
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: agent_seq_cst_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: agent_seq_cst_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: agent_seq_cst_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: agent_seq_cst_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    buffer_wbl2 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    buffer_inv sc1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: agent_seq_cst_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    buffer_wbl2 sc1
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: agent_seq_cst_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl1_inv
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: agent_seq_cst_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    buffer_gl1_inv
; GFX11-CU-NEXT:    buffer_gl0_inv
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: agent_seq_cst_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: agent_seq_cst_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("agent") seq_cst, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @agent_one_as_acquire_fence() {
; GFX6-LABEL: agent_one_as_acquire_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: agent_one_as_acquire_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: agent_one_as_acquire_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl1_inv
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: agent_one_as_acquire_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    buffer_gl1_inv
; GFX10-CU-NEXT:    buffer_gl0_inv
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: agent_one_as_acquire_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: agent_one_as_acquire_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: agent_one_as_acquire_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: agent_one_as_acquire_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    buffer_inv sc1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: agent_one_as_acquire_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: agent_one_as_acquire_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl1_inv
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: agent_one_as_acquire_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    buffer_gl1_inv
; GFX11-CU-NEXT:    buffer_gl0_inv
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: agent_one_as_acquire_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: agent_one_as_acquire_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("agent-one-as") acquire, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @agent_one_as_release_fence() {
; GFX6-LABEL: agent_one_as_release_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: agent_one_as_release_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: agent_one_as_release_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: agent_one_as_release_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: agent_one_as_release_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: agent_one_as_release_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: agent_one_as_release_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: agent_one_as_release_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    buffer_wbl2 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: agent_one_as_release_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    buffer_wbl2 sc1
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: agent_one_as_release_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: agent_one_as_release_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: agent_one_as_release_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: agent_one_as_release_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("agent-one-as") release, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @agent_one_as_acq_rel_fence() {
; GFX6-LABEL: agent_one_as_acq_rel_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: agent_one_as_acq_rel_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: agent_one_as_acq_rel_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl1_inv
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: agent_one_as_acq_rel_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    buffer_gl1_inv
; GFX10-CU-NEXT:    buffer_gl0_inv
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: agent_one_as_acq_rel_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: agent_one_as_acq_rel_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: agent_one_as_acq_rel_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: agent_one_as_acq_rel_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    buffer_wbl2 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    buffer_inv sc1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: agent_one_as_acq_rel_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    buffer_wbl2 sc1
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: agent_one_as_acq_rel_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl1_inv
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: agent_one_as_acq_rel_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    buffer_gl1_inv
; GFX11-CU-NEXT:    buffer_gl0_inv
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: agent_one_as_acq_rel_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: agent_one_as_acq_rel_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("agent-one-as") acq_rel, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @agent_one_as_seq_cst_fence() {
; GFX6-LABEL: agent_one_as_seq_cst_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: agent_one_as_seq_cst_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: agent_one_as_seq_cst_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl1_inv
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: agent_one_as_seq_cst_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    buffer_gl1_inv
; GFX10-CU-NEXT:    buffer_gl0_inv
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: agent_one_as_seq_cst_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: agent_one_as_seq_cst_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: agent_one_as_seq_cst_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: agent_one_as_seq_cst_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    buffer_wbl2 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    buffer_inv sc1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: agent_one_as_seq_cst_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    buffer_wbl2 sc1
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: agent_one_as_seq_cst_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl1_inv
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: agent_one_as_seq_cst_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    buffer_gl1_inv
; GFX11-CU-NEXT:    buffer_gl0_inv
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: agent_one_as_seq_cst_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: agent_one_as_seq_cst_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("agent-one-as") seq_cst, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @system_acquire_fence() {
; GFX6-LABEL: system_acquire_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: system_acquire_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: system_acquire_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl1_inv
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: system_acquire_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    buffer_gl1_inv
; GFX10-CU-NEXT:    buffer_gl0_inv
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: system_acquire_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: system_acquire_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    buffer_invl2
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: system_acquire_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_invl2
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: system_acquire_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    buffer_inv sc0 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: system_acquire_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc0 sc1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: system_acquire_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl1_inv
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: system_acquire_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    buffer_gl1_inv
; GFX11-CU-NEXT:    buffer_gl0_inv
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: system_acquire_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: system_acquire_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence acquire, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @system_release_fence() {
; GFX6-LABEL: system_release_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: system_release_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: system_release_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: system_release_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: system_release_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: system_release_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbl2
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: system_release_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    buffer_wbl2
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: system_release_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: system_release_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: system_release_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: system_release_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: system_release_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: system_release_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence release, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @system_acq_rel_fence() {
; GFX6-LABEL: system_acq_rel_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: system_acq_rel_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: system_acq_rel_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl1_inv
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: system_acq_rel_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    buffer_gl1_inv
; GFX10-CU-NEXT:    buffer_gl0_inv
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: system_acq_rel_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: system_acq_rel_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbl2
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    buffer_invl2
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: system_acq_rel_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    buffer_wbl2
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_invl2
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: system_acq_rel_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    buffer_inv sc0 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: system_acq_rel_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc0 sc1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: system_acq_rel_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl1_inv
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: system_acq_rel_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    buffer_gl1_inv
; GFX11-CU-NEXT:    buffer_gl0_inv
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: system_acq_rel_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: system_acq_rel_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence acq_rel, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @system_seq_cst_fence() {
; GFX6-LABEL: system_seq_cst_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: system_seq_cst_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: system_seq_cst_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl1_inv
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: system_seq_cst_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    buffer_gl1_inv
; GFX10-CU-NEXT:    buffer_gl0_inv
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: system_seq_cst_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: system_seq_cst_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbl2
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    buffer_invl2
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: system_seq_cst_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    buffer_wbl2
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_invl2
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: system_seq_cst_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    buffer_inv sc0 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: system_seq_cst_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc0 sc1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: system_seq_cst_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl1_inv
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: system_seq_cst_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    buffer_gl1_inv
; GFX11-CU-NEXT:    buffer_gl0_inv
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: system_seq_cst_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: system_seq_cst_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence seq_cst, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @system_one_as_acquire_fence() {
; GFX6-LABEL: system_one_as_acquire_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: system_one_as_acquire_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: system_one_as_acquire_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl1_inv
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: system_one_as_acquire_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    buffer_gl1_inv
; GFX10-CU-NEXT:    buffer_gl0_inv
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: system_one_as_acquire_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: system_one_as_acquire_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    buffer_invl2
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: system_one_as_acquire_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_invl2
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: system_one_as_acquire_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    buffer_inv sc0 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: system_one_as_acquire_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc0 sc1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: system_one_as_acquire_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl1_inv
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: system_one_as_acquire_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    buffer_gl1_inv
; GFX11-CU-NEXT:    buffer_gl0_inv
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: system_one_as_acquire_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: system_one_as_acquire_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("one-as") acquire, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @system_one_as_release_fence() {
; GFX6-LABEL: system_one_as_release_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: system_one_as_release_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: system_one_as_release_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: system_one_as_release_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: system_one_as_release_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: system_one_as_release_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbl2
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: system_one_as_release_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    buffer_wbl2
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: system_one_as_release_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: system_one_as_release_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: system_one_as_release_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: system_one_as_release_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: system_one_as_release_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: system_one_as_release_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("one-as") release, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @system_one_as_acq_rel_fence() {
; GFX6-LABEL: system_one_as_acq_rel_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: system_one_as_acq_rel_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: system_one_as_acq_rel_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl1_inv
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: system_one_as_acq_rel_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    buffer_gl1_inv
; GFX10-CU-NEXT:    buffer_gl0_inv
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: system_one_as_acq_rel_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: system_one_as_acq_rel_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbl2
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    buffer_invl2
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: system_one_as_acq_rel_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    buffer_wbl2
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_invl2
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: system_one_as_acq_rel_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    buffer_inv sc0 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: system_one_as_acq_rel_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc0 sc1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: system_one_as_acq_rel_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl1_inv
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: system_one_as_acq_rel_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    buffer_gl1_inv
; GFX11-CU-NEXT:    buffer_gl0_inv
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: system_one_as_acq_rel_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: system_one_as_acq_rel_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("one-as") acq_rel, !mmra !{!"amdgpu-as", !"global"}
  ret void
}

define amdgpu_kernel void @system_one_as_seq_cst_fence() {
; GFX6-LABEL: system_one_as_seq_cst_fence:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: system_one_as_seq_cst_fence:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: system_one_as_seq_cst_fence:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    buffer_gl1_inv
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: system_one_as_seq_cst_fence:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    buffer_gl1_inv
; GFX10-CU-NEXT:    buffer_gl0_inv
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: system_one_as_seq_cst_fence:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: system_one_as_seq_cst_fence:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbl2
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    buffer_invl2
; GFX90A-NOTTGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: system_one_as_seq_cst_fence:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    buffer_wbl2
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    buffer_invl2
; GFX90A-TGSPLIT-NEXT:    buffer_wbinvl1_vol
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: system_one_as_seq_cst_fence:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    buffer_inv sc0 sc1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: system_one_as_seq_cst_fence:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX940-TGSPLIT-NEXT:    buffer_inv sc0 sc1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: system_one_as_seq_cst_fence:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    buffer_gl1_inv
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: system_one_as_seq_cst_fence:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    buffer_gl1_inv
; GFX11-CU-NEXT:    buffer_gl0_inv
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: system_one_as_seq_cst_fence:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: system_one_as_seq_cst_fence:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_endpgm
entry:
  fence syncscope("one-as") seq_cst, !mmra !{!"amdgpu-as", !"global"}
  ret void
}
