; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=hexagon -mattr=+hvxv60,+hvx-length128b,-packets < %s | FileCheck --check-prefix=V60 %s
; RUN: llc -march=hexagon -mattr=+hvxv62,+hvx-length128b,-packets < %s | FileCheck --check-prefix=V62 %s
; RUN: llc -march=hexagon -mattr=+hvxv66,+hvx-length128b,-packets < %s | FileCheck --check-prefix=V66 %s

define <128 x i8> @f0(<128 x i8> %a0, <128 x i8> %a1, i8 %a2) #0 {
; V60-LABEL: f0:
; V60:       // %bb.0:
; V60-NEXT:    {
; V60-NEXT:     r0 = vsplatb(r0)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     r1 = ##117901063
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1:0.b = vshuffoe(v0.b,v1.b)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2 = vsplat(r0)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v3 = vsplat(r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2 = vand(v2,v3)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v3:2.uh = vzxt(v2.ub)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0.h = vasl(v0.h,v2.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1.h = vasl(v1.h,v3.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0.b = vshuffo(v1.b,v0.b)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     jumpr r31
; V60-NEXT:    }
;
; V62-LABEL: f0:
; V62:       // %bb.0:
; V62-NEXT:    {
; V62-NEXT:     r2 = #7
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2.b = vsplat(r0)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1:0.b = vshuffoe(v0.b,v1.b)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3.b = vsplat(r2)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2 = vand(v2,v3)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3:2.uh = vzxt(v2.ub)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.h = vasl(v0.h,v2.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1.h = vasl(v1.h,v3.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.b = vshuffo(v1.b,v0.b)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     jumpr r31
; V62-NEXT:    }
;
; V66-LABEL: f0:
; V66:       // %bb.0:
; V66-NEXT:    {
; V66-NEXT:     r2 = #7
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2.b = vsplat(r0)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v1:0.b = vshuffoe(v0.b,v1.b)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3.b = vsplat(r2)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2 = vand(v2,v3)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3:2.uh = vzxt(v2.ub)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0.h = vasl(v0.h,v2.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v1.h = vasl(v1.h,v3.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0.b = vshuffo(v1.b,v0.b)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     jumpr r31
; V66-NEXT:    }
  %v0 = insertelement <128 x i8> undef, i8 %a2, i32 0
  %v1 = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> zeroinitializer
  %v2 = call <128 x i8> @llvm.fshl.v128i8(<128 x i8> %a0, <128 x i8> %a1, <128 x i8> %v1)
  ret <128 x i8> %v2
}

define <64 x i16> @f1(<64 x i16> %a0, <64 x i16> %a1, i16 %a2) #0 {
; V60-LABEL: f1:
; V60:       // %bb.0:
; V60-NEXT:    {
; V60-NEXT:     r1 = and(r0,#15)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     p0 = bitsclr(r0,#15)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2.h = vasl(v0.h,r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     r1 = sub(#16,r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1.uh = vlsr(v1.uh,r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1 = vor(v2,v1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     if (!p0) v0 = v1
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     jumpr r31
; V60-NEXT:    }
;
; V62-LABEL: f1:
; V62:       // %bb.0:
; V62-NEXT:    {
; V62-NEXT:     r1 = and(r0,#15)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     p0 = bitsclr(r0,#15)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2.h = vasl(v0.h,r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     r1 = sub(#16,r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1.uh = vlsr(v1.uh,r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1 = vor(v2,v1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     if (!p0) v0 = v1
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     jumpr r31
; V62-NEXT:    }
;
; V66-LABEL: f1:
; V66:       // %bb.0:
; V66-NEXT:    {
; V66-NEXT:     r1 = and(r0,#15)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     p0 = bitsclr(r0,#15)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2.h = vasl(v0.h,r1)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     r1 = sub(#16,r1)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v1.uh = vlsr(v1.uh,r1)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v1 = vor(v2,v1)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     if (!p0) v0 = v1
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     jumpr r31
; V66-NEXT:    }
  %v0 = insertelement <64 x i16> undef, i16 %a2, i32 0
  %v1 = shufflevector <64 x i16> %v0, <64 x i16> undef, <64 x i32> zeroinitializer
  %v2 = call <64 x i16> @llvm.fshl.v64i16(<64 x i16> %a0, <64 x i16> %a1, <64 x i16> %v1)
  ret <64 x i16> %v2
}

define <32 x i32> @f2(<32 x i32> %a0, <32 x i32> %a1, i32 %a2) #0 {
; V60-LABEL: f2:
; V60:       // %bb.0:
; V60-NEXT:    {
; V60-NEXT:     r1 = and(r0,#31)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     p0 = bitsclr(r0,#31)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2.w = vasl(v0.w,r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     r1 = sub(#32,r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1.uw = vlsr(v1.uw,r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1 = vor(v2,v1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     if (!p0) v0 = v1
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     jumpr r31
; V60-NEXT:    }
;
; V62-LABEL: f2:
; V62:       // %bb.0:
; V62-NEXT:    {
; V62-NEXT:     r1 = and(r0,#31)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     p0 = bitsclr(r0,#31)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2.w = vasl(v0.w,r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     r1 = sub(#32,r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1.uw = vlsr(v1.uw,r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1 = vor(v2,v1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     if (!p0) v0 = v1
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     jumpr r31
; V62-NEXT:    }
;
; V66-LABEL: f2:
; V66:       // %bb.0:
; V66-NEXT:    {
; V66-NEXT:     r0 = and(r0,#31)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     r1 = #32
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v4 = vxor(v4,v4)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2 = vsplat(r0)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3 = vsplat(r1)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3.w = vsub(v3.w,v2.w)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2.w = vsub(v4.w,v2.w)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v4.w = vlsr(v1.w,v3.w)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v5:4.w = vasrinto(v0.w,v2.w)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0 = v5
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     jumpr r31
; V66-NEXT:    }
  %v0 = insertelement <32 x i32> undef, i32 %a2, i32 0
  %v1 = shufflevector <32 x i32> %v0, <32 x i32> undef, <32 x i32> zeroinitializer
  %v2 = call <32 x i32> @llvm.fshl.v32i32(<32 x i32> %a0, <32 x i32> %a1, <32 x i32> %v1)
  ret <32 x i32> %v2
}

define <128 x i8> @f3(<128 x i8> %a0, <128 x i8> %a1, i8 %a2) #0 {
; V60-LABEL: f3:
; V60:       // %bb.0:
; V60-NEXT:    {
; V60-NEXT:     r0 = vsplatb(r0)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     r1 = ##117901063
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1:0.b = vshuffoe(v0.b,v1.b)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2 = vsplat(r0)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v3 = vsplat(r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2 = vand(v2,v3)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v3:2.uh = vzxt(v2.ub)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0.h = vlsr(v0.h,v2.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1.h = vlsr(v1.h,v3.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0.b = vshuffe(v1.b,v0.b)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     jumpr r31
; V60-NEXT:    }
;
; V62-LABEL: f3:
; V62:       // %bb.0:
; V62-NEXT:    {
; V62-NEXT:     r2 = #7
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2.b = vsplat(r0)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1:0.b = vshuffoe(v0.b,v1.b)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3.b = vsplat(r2)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2 = vand(v2,v3)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3:2.uh = vzxt(v2.ub)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.h = vlsr(v0.h,v2.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1.h = vlsr(v1.h,v3.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.b = vshuffe(v1.b,v0.b)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     jumpr r31
; V62-NEXT:    }
;
; V66-LABEL: f3:
; V66:       // %bb.0:
; V66-NEXT:    {
; V66-NEXT:     r2 = #7
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2.b = vsplat(r0)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v1:0.b = vshuffoe(v0.b,v1.b)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3.b = vsplat(r2)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2 = vand(v2,v3)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3:2.uh = vzxt(v2.ub)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0.h = vlsr(v0.h,v2.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v1.h = vlsr(v1.h,v3.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0.b = vshuffe(v1.b,v0.b)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     jumpr r31
; V66-NEXT:    }
  %v0 = insertelement <128 x i8> undef, i8 %a2, i32 0
  %v1 = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> zeroinitializer
  %v2 = call <128 x i8> @llvm.fshr.v128i8(<128 x i8> %a0, <128 x i8> %a1, <128 x i8> %v1)
  ret <128 x i8> %v2
}

define <64 x i16> @f4(<64 x i16> %a0, <64 x i16> %a1, i16 %a2) #0 {
; V60-LABEL: f4:
; V60:       // %bb.0:
; V60-NEXT:    {
; V60-NEXT:     r1 = and(r0,#15)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     p0 = bitsclr(r0,#15)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2.uh = vlsr(v1.uh,r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     r1 = sub(#16,r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0.h = vasl(v0.h,r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0 = vor(v0,v2)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     if (p0) v0 = v1
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     jumpr r31
; V60-NEXT:    }
;
; V62-LABEL: f4:
; V62:       // %bb.0:
; V62-NEXT:    {
; V62-NEXT:     r1 = and(r0,#15)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     p0 = bitsclr(r0,#15)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2.uh = vlsr(v1.uh,r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     r1 = sub(#16,r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.h = vasl(v0.h,r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0 = vor(v0,v2)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     if (p0) v0 = v1
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     jumpr r31
; V62-NEXT:    }
;
; V66-LABEL: f4:
; V66:       // %bb.0:
; V66-NEXT:    {
; V66-NEXT:     r1 = and(r0,#15)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     p0 = bitsclr(r0,#15)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2.uh = vlsr(v1.uh,r1)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     r1 = sub(#16,r1)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0.h = vasl(v0.h,r1)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0 = vor(v0,v2)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     if (p0) v0 = v1
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     jumpr r31
; V66-NEXT:    }
  %v0 = insertelement <64 x i16> undef, i16 %a2, i32 0
  %v1 = shufflevector <64 x i16> %v0, <64 x i16> undef, <64 x i32> zeroinitializer
  %v2 = call <64 x i16> @llvm.fshr.v64i16(<64 x i16> %a0, <64 x i16> %a1, <64 x i16> %v1)
  ret <64 x i16> %v2
}

define <32 x i32> @f5(<32 x i32> %a0, <32 x i32> %a1, i32 %a2) #0 {
; V60-LABEL: f5:
; V60:       // %bb.0:
; V60-NEXT:    {
; V60-NEXT:     r1 = and(r0,#31)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     p0 = bitsclr(r0,#31)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2.uw = vlsr(v1.uw,r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     r1 = sub(#32,r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0.w = vasl(v0.w,r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0 = vor(v0,v2)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     if (p0) v0 = v1
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     jumpr r31
; V60-NEXT:    }
;
; V62-LABEL: f5:
; V62:       // %bb.0:
; V62-NEXT:    {
; V62-NEXT:     r1 = and(r0,#31)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     p0 = bitsclr(r0,#31)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2.uw = vlsr(v1.uw,r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     r1 = sub(#32,r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.w = vasl(v0.w,r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0 = vor(v0,v2)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     if (p0) v0 = v1
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     jumpr r31
; V62-NEXT:    }
;
; V66-LABEL: f5:
; V66:       // %bb.0:
; V66-NEXT:    {
; V66-NEXT:     r0 = and(r0,#31)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3 = vsplat(r0)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2.w = vlsr(v1.w,v3.w)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3:2.w = vasrinto(v0.w,v3.w)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0 = v2
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     jumpr r31
; V66-NEXT:    }
  %v0 = insertelement <32 x i32> undef, i32 %a2, i32 0
  %v1 = shufflevector <32 x i32> %v0, <32 x i32> undef, <32 x i32> zeroinitializer
  %v2 = call <32 x i32> @llvm.fshr.v32i32(<32 x i32> %a0, <32 x i32> %a1, <32 x i32> %v1)
  ret <32 x i32> %v2
}

define <128 x i8> @f6(<128 x i8> %a0, <128 x i8> %a1, <128 x i8> %a2) #0 {
; V60-LABEL: f6:
; V60:       // %bb.0:
; V60-NEXT:    {
; V60-NEXT:     r0 = ##117901063
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1:0.b = vshuffoe(v0.b,v1.b)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v3 = vsplat(r0)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2 = vand(v2,v3)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v3:2.uh = vzxt(v2.ub)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0.h = vasl(v0.h,v2.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1.h = vasl(v1.h,v3.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0.b = vshuffo(v1.b,v0.b)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     jumpr r31
; V60-NEXT:    }
;
; V62-LABEL: f6:
; V62:       // %bb.0:
; V62-NEXT:    {
; V62-NEXT:     r0 = #7
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1:0.b = vshuffoe(v0.b,v1.b)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3.b = vsplat(r0)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2 = vand(v2,v3)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3:2.uh = vzxt(v2.ub)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.h = vasl(v0.h,v2.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1.h = vasl(v1.h,v3.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.b = vshuffo(v1.b,v0.b)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     jumpr r31
; V62-NEXT:    }
;
; V66-LABEL: f6:
; V66:       // %bb.0:
; V66-NEXT:    {
; V66-NEXT:     r0 = #7
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v1:0.b = vshuffoe(v0.b,v1.b)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3.b = vsplat(r0)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2 = vand(v2,v3)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3:2.uh = vzxt(v2.ub)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0.h = vasl(v0.h,v2.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v1.h = vasl(v1.h,v3.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0.b = vshuffo(v1.b,v0.b)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     jumpr r31
; V66-NEXT:    }
  %v0 = call <128 x i8> @llvm.fshl.v128i8(<128 x i8> %a0, <128 x i8> %a1, <128 x i8> %a2)
  ret <128 x i8> %v0
}

define <64 x i16> @f7(<64 x i16> %a0, <64 x i16> %a1, <64 x i16> %a2) #0 {
; V60-LABEL: f7:
; V60:       // %bb.0:
; V60-NEXT:    {
; V60-NEXT:     r0 = ##983055
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     r1 = ##1048592
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v3 = vxor(v3,v3)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v4 = vsplat(r0)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v5 = vsplat(r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2 = vand(v2,v4)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v4.h = vsub(v5.h,v2.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     q0 = vcmp.eq(v2.h,v3.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v31.h = vasl(v0.h,v2.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1.h = vlsr(v1.h,v4.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1 = vor(v31,v1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0 = vmux(q0,v0,v1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     jumpr r31
; V60-NEXT:    }
;
; V62-LABEL: f7:
; V62:       // %bb.0:
; V62-NEXT:    {
; V62-NEXT:     r1:0 = combine(#16,#15)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3.h = vsplat(r0)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v4.h = vsplat(r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2 = vand(v2,v3)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3.h = vsub(v4.h,v2.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.h = vasl(v0.h,v2.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1.h = vlsr(v1.h,v3.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0 = vor(v0,v1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     jumpr r31
; V62-NEXT:    }
;
; V66-LABEL: f7:
; V66:       // %bb.0:
; V66-NEXT:    {
; V66-NEXT:     r1:0 = combine(#16,#15)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3.h = vsplat(r0)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v4.h = vsplat(r1)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2 = vand(v2,v3)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3.h = vsub(v4.h,v2.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0.h = vasl(v0.h,v2.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v1.h = vlsr(v1.h,v3.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0 = vor(v0,v1)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     jumpr r31
; V66-NEXT:    }
  %v0 = call <64 x i16> @llvm.fshl.v64i16(<64 x i16> %a0, <64 x i16> %a1, <64 x i16> %a2)
  ret <64 x i16> %v0
}

define <32 x i32> @f8(<32 x i32> %a0, <32 x i32> %a1, <32 x i32> %a2) #0 {
; V60-LABEL: f8:
; V60:       // %bb.0:
; V60-NEXT:    {
; V60-NEXT:     r1:0 = combine(#32,#31)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v3 = vxor(v3,v3)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v4 = vsplat(r0)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v5 = vsplat(r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2 = vand(v2,v4)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v5.w = vsub(v5.w,v2.w)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v4 = vand(v2,v4)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2.w = vasl(v0.w,v2.w)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     q0 = vcmp.eq(v4.w,v3.w)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1.w = vlsr(v1.w,v5.w)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1 = vor(v2,v1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0 = vmux(q0,v0,v1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     jumpr r31
; V60-NEXT:    }
;
; V62-LABEL: f8:
; V62:       // %bb.0:
; V62-NEXT:    {
; V62-NEXT:     r1:0 = combine(#32,#31)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3 = vsplat(r0)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v4 = vsplat(r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2 = vand(v2,v3)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3.w = vsub(v4.w,v2.w)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.w = vasl(v0.w,v2.w)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1.w = vlsr(v1.w,v3.w)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0 = vor(v0,v1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     jumpr r31
; V62-NEXT:    }
;
; V66-LABEL: f8:
; V66:       // %bb.0:
; V66-NEXT:    {
; V66-NEXT:     r1:0 = combine(#32,#31)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v31 = vxor(v31,v31)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3 = vsplat(r0)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v4 = vsplat(r1)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2 = vand(v2,v3)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v4.w = vsub(v4.w,v2.w)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2.w = vsub(v31.w,v2.w)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v4.w = vlsr(v1.w,v4.w)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v5:4.w = vasrinto(v0.w,v2.w)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0 = v5
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     jumpr r31
; V66-NEXT:    }
  %v0 = call <32 x i32> @llvm.fshl.v32i32(<32 x i32> %a0, <32 x i32> %a1, <32 x i32> %a2)
  ret <32 x i32> %v0
}

define <128 x i8> @f9(<128 x i8> %a0, <128 x i8> %a1, <128 x i8> %a2) #0 {
; V60-LABEL: f9:
; V60:       // %bb.0:
; V60-NEXT:    {
; V60-NEXT:     r0 = ##117901063
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1:0.b = vshuffoe(v0.b,v1.b)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v3 = vsplat(r0)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2 = vand(v2,v3)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v3:2.uh = vzxt(v2.ub)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0.h = vlsr(v0.h,v2.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v1.h = vlsr(v1.h,v3.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0.b = vshuffe(v1.b,v0.b)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     jumpr r31
; V60-NEXT:    }
;
; V62-LABEL: f9:
; V62:       // %bb.0:
; V62-NEXT:    {
; V62-NEXT:     r0 = #7
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1:0.b = vshuffoe(v0.b,v1.b)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3.b = vsplat(r0)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2 = vand(v2,v3)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3:2.uh = vzxt(v2.ub)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.h = vlsr(v0.h,v2.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1.h = vlsr(v1.h,v3.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.b = vshuffe(v1.b,v0.b)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     jumpr r31
; V62-NEXT:    }
;
; V66-LABEL: f9:
; V66:       // %bb.0:
; V66-NEXT:    {
; V66-NEXT:     r0 = #7
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v1:0.b = vshuffoe(v0.b,v1.b)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3.b = vsplat(r0)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2 = vand(v2,v3)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3:2.uh = vzxt(v2.ub)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0.h = vlsr(v0.h,v2.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v1.h = vlsr(v1.h,v3.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0.b = vshuffe(v1.b,v0.b)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     jumpr r31
; V66-NEXT:    }
  %v0 = call <128 x i8> @llvm.fshr.v128i8(<128 x i8> %a0, <128 x i8> %a1, <128 x i8> %a2)
  ret <128 x i8> %v0
}

define <64 x i16> @f10(<64 x i16> %a0, <64 x i16> %a1, <64 x i16> %a2) #0 {
; V60-LABEL: f10:
; V60:       // %bb.0:
; V60-NEXT:    {
; V60-NEXT:     r0 = ##983055
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     r1 = ##1048592
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v3 = vxor(v3,v3)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v4 = vsplat(r0)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v5 = vsplat(r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2 = vand(v2,v4)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v4.h = vsub(v5.h,v2.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     q0 = vcmp.eq(v2.h,v3.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v31.h = vlsr(v1.h,v2.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0.h = vasl(v0.h,v4.h)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0 = vor(v0,v31)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0 = vmux(q0,v1,v0)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     jumpr r31
; V60-NEXT:    }
;
; V62-LABEL: f10:
; V62:       // %bb.0:
; V62-NEXT:    {
; V62-NEXT:     r1:0 = combine(#16,#15)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3.h = vsplat(r0)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v4.h = vsplat(r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2 = vand(v2,v3)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3.h = vsub(v2.h,v4.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1.h = vlsr(v1.h,v2.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.h = vlsr(v0.h,v3.h)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0 = vor(v0,v1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     jumpr r31
; V62-NEXT:    }
;
; V66-LABEL: f10:
; V66:       // %bb.0:
; V66-NEXT:    {
; V66-NEXT:     r1:0 = combine(#16,#15)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3.h = vsplat(r0)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v4.h = vsplat(r1)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2 = vand(v2,v3)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3.h = vsub(v2.h,v4.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v1.h = vlsr(v1.h,v2.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0.h = vlsr(v0.h,v3.h)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0 = vor(v0,v1)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     jumpr r31
; V66-NEXT:    }
  %v0 = call <64 x i16> @llvm.fshr.v64i16(<64 x i16> %a0, <64 x i16> %a1, <64 x i16> %a2)
  ret <64 x i16> %v0
}

define <32 x i32> @f11(<32 x i32> %a0, <32 x i32> %a1, <32 x i32> %a2) #0 {
; V60-LABEL: f11:
; V60:       // %bb.0:
; V60-NEXT:    {
; V60-NEXT:     r1:0 = combine(#32,#31)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v3 = vxor(v3,v3)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v4 = vsplat(r0)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v5 = vsplat(r1)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v2 = vand(v2,v4)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v4.w = vsub(v5.w,v2.w)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     q0 = vcmp.eq(v2.w,v3.w)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v31.w = vlsr(v1.w,v2.w)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0.w = vasl(v0.w,v4.w)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0 = vor(v0,v31)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     v0 = vmux(q0,v1,v0)
; V60-NEXT:    }
; V60-NEXT:    {
; V60-NEXT:     jumpr r31
; V60-NEXT:    }
;
; V62-LABEL: f11:
; V62:       // %bb.0:
; V62-NEXT:    {
; V62-NEXT:     r1:0 = combine(#32,#31)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3 = vsplat(r0)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v4 = vsplat(r1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v2 = vand(v2,v3)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v3.w = vsub(v2.w,v4.w)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v1.w = vlsr(v1.w,v2.w)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0.w = vlsr(v0.w,v3.w)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     v0 = vor(v0,v1)
; V62-NEXT:    }
; V62-NEXT:    {
; V62-NEXT:     jumpr r31
; V62-NEXT:    }
;
; V66-LABEL: f11:
; V66:       // %bb.0:
; V66-NEXT:    {
; V66-NEXT:     r0 = #31
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3 = vsplat(r0)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3 = vand(v2,v3)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v2.w = vlsr(v1.w,v3.w)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v3:2.w = vasrinto(v0.w,v3.w)
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     v0 = v2
; V66-NEXT:    }
; V66-NEXT:    {
; V66-NEXT:     jumpr r31
; V66-NEXT:    }
  %v0 = call <32 x i32> @llvm.fshr.v32i32(<32 x i32> %a0, <32 x i32> %a1, <32 x i32> %a2)
  ret <32 x i32> %v0
}

declare <128 x i8> @llvm.fshl.v128i8(<128 x i8>, <128 x i8>, <128 x i8>)
declare <128 x i8> @llvm.fshr.v128i8(<128 x i8>, <128 x i8>, <128 x i8>)
declare <64 x i16> @llvm.fshl.v64i16(<64 x i16>, <64 x i16>, <64 x i16>)
declare <64 x i16> @llvm.fshr.v64i16(<64 x i16>, <64 x i16>, <64 x i16>)
declare <32 x i32> @llvm.fshl.v32i32(<32 x i32>, <32 x i32>, <32 x i32>)
declare <32 x i32> @llvm.fshr.v32i32(<32 x i32>, <32 x i32>, <32 x i32>)

attributes #0 = { nounwind }
