; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=aarch64 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define <2 x double> @insert_v2f64_0(<2 x double> %a, double %b, i32 %c) {
; CHECK-LABEL: insert_v2f64_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mov v0.d[0], v1.d[0]
; CHECK-NEXT:    ret
entry:
  %d = insertelement <2 x double> %a, double %b, i32 0
  ret <2 x double> %d
}

define <2 x double> @insert_v2f64_1(<2 x double> %a, double %b, i32 %c) {
; CHECK-LABEL: insert_v2f64_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    ret
entry:
  %d = insertelement <2 x double> %a, double %b, i32 1
  ret <2 x double> %d
}

define <2 x double> @insert_v2f64_c(<2 x double> %a, double %b, i32 %c) {
; CHECK-SD-LABEL: insert_v2f64_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x0, #3, #1
; CHECK-SD-NEXT:    str d1, [x8]
; CHECK-SD-NEXT:    ldr q0, [sp], #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v2f64_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x1
; CHECK-GI-NEXT:    str d1, [x8, x9, lsl #3]
; CHECK-GI-NEXT:    ldr q0, [sp], #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <2 x double> %a, double %b, i32 %c
  ret <2 x double> %d
}

define <3 x double> @insert_v3f64_0(<3 x double> %a, double %b, i32 %c) {
; CHECK-SD-LABEL: insert_v3f64_0:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    // kill: def $d3 killed $d3 def $q3
; CHECK-SD-NEXT:    mov v0.d[0], v3.d[0]
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v3f64_0:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    fmov d0, d3
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <3 x double> %a, double %b, i32 0
  ret <3 x double> %d
}

define <3 x double> @insert_v3f64_2(<3 x double> %a, double %b, i32 %c) {
; CHECK-LABEL: insert_v3f64_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov d2, d3
; CHECK-NEXT:    ret
entry:
  %d = insertelement <3 x double> %a, double %b, i32 2
  ret <3 x double> %d
}

define <3 x double> @insert_v3f64_c(<3 x double> %a, double %b, i32 %c) {
; CHECK-SD-LABEL: insert_v3f64_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    stp q0, q2, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    and x9, x0, #0x3
; CHECK-SD-NEXT:    str d3, [x8, x9, lsl #3]
; CHECK-SD-NEXT:    ldr q0, [sp]
; CHECK-SD-NEXT:    ldr d2, [sp, #16]
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    add sp, sp, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v3f64_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    and x8, x8, #0x3
; CHECK-GI-NEXT:    stp q0, q2, [sp]
; CHECK-GI-NEXT:    str d3, [x9, x8, lsl #3]
; CHECK-GI-NEXT:    ldp q0, q2, [sp]
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <3 x double> %a, double %b, i32 %c
  ret <3 x double> %d
}

define <4 x double> @insert_v4f64_0(<4 x double> %a, double %b, i32 %c) {
; CHECK-LABEL: insert_v4f64_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mov v0.d[0], v2.d[0]
; CHECK-NEXT:    ret
entry:
  %d = insertelement <4 x double> %a, double %b, i32 0
  ret <4 x double> %d
}

define <4 x double> @insert_v4f64_2(<4 x double> %a, double %b, i32 %c) {
; CHECK-LABEL: insert_v4f64_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mov v1.d[0], v2.d[0]
; CHECK-NEXT:    ret
entry:
  %d = insertelement <4 x double> %a, double %b, i32 2
  ret <4 x double> %d
}

define <4 x double> @insert_v4f64_c(<4 x double> %a, double %b, i32 %c) {
; CHECK-SD-LABEL: insert_v4f64_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x0, #0x3
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    str d2, [x9, x8, lsl #3]
; CHECK-SD-NEXT:    ldp q0, q1, [sp], #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v4f64_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    and x8, x8, #0x3
; CHECK-GI-NEXT:    str d2, [x9, x8, lsl #3]
; CHECK-GI-NEXT:    ldp q0, q1, [sp]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <4 x double> %a, double %b, i32 %c
  ret <4 x double> %d
}

define <2 x float> @insert_v2f32_0(<2 x float> %a, float %b, i32 %c) {
; CHECK-LABEL: insert_v2f32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-NEXT:    mov v0.s[0], v1.s[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <2 x float> %a, float %b, i32 0
  ret <2 x float> %d
}

define <2 x float> @insert_v2f32_1(<2 x float> %a, float %b, i32 %c) {
; CHECK-LABEL: insert_v2f32_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <2 x float> %a, float %b, i32 1
  ret <2 x float> %d
}

define <2 x float> @insert_v2f32_c(<2 x float> %a, float %b, i32 %c) {
; CHECK-SD-LABEL: insert_v2f32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    add x8, sp, #8
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str d0, [sp, #8]
; CHECK-SD-NEXT:    bfi x8, x0, #2, #1
; CHECK-SD-NEXT:    str s1, [x8]
; CHECK-SD-NEXT:    ldr d0, [sp, #8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v2f32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    add x8, sp, #8
; CHECK-GI-NEXT:    str d0, [sp, #8]
; CHECK-GI-NEXT:    and x9, x9, #0x1
; CHECK-GI-NEXT:    str s1, [x8, x9, lsl #2]
; CHECK-GI-NEXT:    ldr d0, [sp, #8]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <2 x float> %a, float %b, i32 %c
  ret <2 x float> %d
}

define <3 x float> @insert_v3f32_0(<3 x float> %a, float %b, i32 %c) {
; CHECK-SD-LABEL: insert_v3f32_0:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-SD-NEXT:    mov v1.s[1], v0.s[1]
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[2]
; CHECK-SD-NEXT:    mov v0.16b, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v3f32_0:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov s2, v0.s[1]
; CHECK-GI-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-GI-NEXT:    mov s0, v0.s[2]
; CHECK-GI-NEXT:    mov v1.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <3 x float> %a, float %b, i32 0
  ret <3 x float> %d
}

define <3 x float> @insert_v3f32_2(<3 x float> %a, float %b, i32 %c) {
; CHECK-SD-LABEL: insert_v3f32_2:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-SD-NEXT:    mov v0.s[2], v1.s[0]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v3f32_2:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov s2, v0.s[1]
; CHECK-GI-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-GI-NEXT:    mov v0.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v0.s[2], v1.s[0]
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <3 x float> %a, float %b, i32 2
  ret <3 x float> %d
}

define <3 x float> @insert_v3f32_c(<3 x float> %a, float %b, i32 %c) {
; CHECK-SD-LABEL: insert_v3f32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x0, #2, #2
; CHECK-SD-NEXT:    str s1, [x8]
; CHECK-SD-NEXT:    ldr q0, [sp], #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v3f32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x3
; CHECK-GI-NEXT:    str s1, [x8, x9, lsl #2]
; CHECK-GI-NEXT:    ldr q0, [sp], #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <3 x float> %a, float %b, i32 %c
  ret <3 x float> %d
}

define <4 x float> @insert_v4f32_0(<4 x float> %a, float %b, i32 %c) {
; CHECK-LABEL: insert_v4f32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-NEXT:    mov v0.s[0], v1.s[0]
; CHECK-NEXT:    ret
entry:
  %d = insertelement <4 x float> %a, float %b, i32 0
  ret <4 x float> %d
}

define <4 x float> @insert_v4f32_2(<4 x float> %a, float %b, i32 %c) {
; CHECK-LABEL: insert_v4f32_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-NEXT:    mov v0.s[2], v1.s[0]
; CHECK-NEXT:    ret
entry:
  %d = insertelement <4 x float> %a, float %b, i32 2
  ret <4 x float> %d
}

define <4 x float> @insert_v4f32_c(<4 x float> %a, float %b, i32 %c) {
; CHECK-SD-LABEL: insert_v4f32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x0, #2, #2
; CHECK-SD-NEXT:    str s1, [x8]
; CHECK-SD-NEXT:    ldr q0, [sp], #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v4f32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x3
; CHECK-GI-NEXT:    str s1, [x8, x9, lsl #2]
; CHECK-GI-NEXT:    ldr q0, [sp], #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <4 x float> %a, float %b, i32 %c
  ret <4 x float> %d
}

define <8 x float> @insert_v8f32_0(<8 x float> %a, float %b, i32 %c) {
; CHECK-LABEL: insert_v8f32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $s2 killed $s2 def $q2
; CHECK-NEXT:    mov v0.s[0], v2.s[0]
; CHECK-NEXT:    ret
entry:
  %d = insertelement <8 x float> %a, float %b, i32 0
  ret <8 x float> %d
}

define <8 x float> @insert_v8f32_2(<8 x float> %a, float %b, i32 %c) {
; CHECK-LABEL: insert_v8f32_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $s2 killed $s2 def $q2
; CHECK-NEXT:    mov v0.s[2], v2.s[0]
; CHECK-NEXT:    ret
entry:
  %d = insertelement <8 x float> %a, float %b, i32 2
  ret <8 x float> %d
}

define <8 x float> @insert_v8f32_c(<8 x float> %a, float %b, i32 %c) {
; CHECK-SD-LABEL: insert_v8f32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x0, #0x7
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    str s2, [x9, x8, lsl #2]
; CHECK-SD-NEXT:    ldp q0, q1, [sp], #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v8f32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    and x8, x8, #0x7
; CHECK-GI-NEXT:    str s2, [x9, x8, lsl #2]
; CHECK-GI-NEXT:    ldp q0, q1, [sp]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <8 x float> %a, float %b, i32 %c
  ret <8 x float> %d
}

define <4 x half> @insert_v4f16_0(<4 x half> %a, half %b, i32 %c) {
; CHECK-LABEL: insert_v4f16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $q1
; CHECK-NEXT:    mov v0.h[0], v1.h[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <4 x half> %a, half %b, i32 0
  ret <4 x half> %d
}

define <4 x half> @insert_v4f16_2(<4 x half> %a, half %b, i32 %c) {
; CHECK-LABEL: insert_v4f16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $q1
; CHECK-NEXT:    mov v0.h[2], v1.h[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <4 x half> %a, half %b, i32 2
  ret <4 x half> %d
}

define <4 x half> @insert_v4f16_c(<4 x half> %a, half %b, i32 %c) {
; CHECK-SD-LABEL: insert_v4f16_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    add x8, sp, #8
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str d0, [sp, #8]
; CHECK-SD-NEXT:    bfi x8, x0, #1, #2
; CHECK-SD-NEXT:    str h1, [x8]
; CHECK-SD-NEXT:    ldr d0, [sp, #8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v4f16_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    add x8, sp, #8
; CHECK-GI-NEXT:    str d0, [sp, #8]
; CHECK-GI-NEXT:    and x9, x9, #0x3
; CHECK-GI-NEXT:    str h1, [x8, x9, lsl #1]
; CHECK-GI-NEXT:    ldr d0, [sp, #8]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <4 x half> %a, half %b, i32 %c
  ret <4 x half> %d
}

define <8 x half> @insert_v8f16_0(<8 x half> %a, half %b, i32 %c) {
; CHECK-LABEL: insert_v8f16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $q1
; CHECK-NEXT:    mov v0.h[0], v1.h[0]
; CHECK-NEXT:    ret
entry:
  %d = insertelement <8 x half> %a, half %b, i32 0
  ret <8 x half> %d
}

define <8 x half> @insert_v8f16_2(<8 x half> %a, half %b, i32 %c) {
; CHECK-LABEL: insert_v8f16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $q1
; CHECK-NEXT:    mov v0.h[2], v1.h[0]
; CHECK-NEXT:    ret
entry:
  %d = insertelement <8 x half> %a, half %b, i32 2
  ret <8 x half> %d
}

define <8 x half> @insert_v8f16_c(<8 x half> %a, half %b, i32 %c) {
; CHECK-SD-LABEL: insert_v8f16_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x0, #1, #3
; CHECK-SD-NEXT:    str h1, [x8]
; CHECK-SD-NEXT:    ldr q0, [sp], #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v8f16_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x7
; CHECK-GI-NEXT:    str h1, [x8, x9, lsl #1]
; CHECK-GI-NEXT:    ldr q0, [sp], #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <8 x half> %a, half %b, i32 %c
  ret <8 x half> %d
}

define <16 x half> @insert_v16f16_0(<16 x half> %a, half %b, i32 %c) {
; CHECK-LABEL: insert_v16f16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $h2 killed $h2 def $q2
; CHECK-NEXT:    mov v0.h[0], v2.h[0]
; CHECK-NEXT:    ret
entry:
  %d = insertelement <16 x half> %a, half %b, i32 0
  ret <16 x half> %d
}

define <16 x half> @insert_v16f16_2(<16 x half> %a, half %b, i32 %c) {
; CHECK-LABEL: insert_v16f16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $h2 killed $h2 def $q2
; CHECK-NEXT:    mov v0.h[2], v2.h[0]
; CHECK-NEXT:    ret
entry:
  %d = insertelement <16 x half> %a, half %b, i32 2
  ret <16 x half> %d
}

define <16 x half> @insert_v16f16_c(<16 x half> %a, half %b, i32 %c) {
; CHECK-SD-LABEL: insert_v16f16_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x0, #0xf
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    str h2, [x9, x8, lsl #1]
; CHECK-SD-NEXT:    ldp q0, q1, [sp], #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v16f16_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    and x8, x8, #0xf
; CHECK-GI-NEXT:    str h2, [x9, x8, lsl #1]
; CHECK-GI-NEXT:    ldp q0, q1, [sp]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <16 x half> %a, half %b, i32 %c
  ret <16 x half> %d
}

define <8 x i8> @insert_v8i8_0(<8 x i8> %a, i8 %b, i32 %c) {
; CHECK-LABEL: insert_v8i8_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.b[0], w0
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <8 x i8> %a, i8 %b, i32 0
  ret <8 x i8> %d
}

define <8 x i8> @insert_v8i8_2(<8 x i8> %a, i8 %b, i32 %c) {
; CHECK-LABEL: insert_v8i8_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.b[2], w0
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <8 x i8> %a, i8 %b, i32 2
  ret <8 x i8> %d
}

define <8 x i8> @insert_v8i8_c(<8 x i8> %a, i8 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v8i8_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    add x8, sp, #8
; CHECK-SD-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-SD-NEXT:    str d0, [sp, #8]
; CHECK-SD-NEXT:    bfxil x8, x1, #0, #3
; CHECK-SD-NEXT:    strb w0, [x8]
; CHECK-SD-NEXT:    ldr d0, [sp, #8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v8i8_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w1
; CHECK-GI-NEXT:    mov w8, #1 // =0x1
; CHECK-GI-NEXT:    str d0, [sp, #8]
; CHECK-GI-NEXT:    and x9, x9, #0x7
; CHECK-GI-NEXT:    mul x8, x9, x8
; CHECK-GI-NEXT:    add x9, sp, #8
; CHECK-GI-NEXT:    strb w0, [x9, x8]
; CHECK-GI-NEXT:    ldr d0, [sp, #8]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <8 x i8> %a, i8 %b, i32 %c
  ret <8 x i8> %d
}

define <16 x i8> @insert_v16i8_0(<16 x i8> %a, i8 %b, i32 %c) {
; CHECK-LABEL: insert_v16i8_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.b[0], w0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <16 x i8> %a, i8 %b, i32 0
  ret <16 x i8> %d
}

define <16 x i8> @insert_v16i8_2(<16 x i8> %a, i8 %b, i32 %c) {
; CHECK-LABEL: insert_v16i8_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.b[2], w0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <16 x i8> %a, i8 %b, i32 2
  ret <16 x i8> %d
}

define <16 x i8> @insert_v16i8_c(<16 x i8> %a, i8 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v16i8_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfxil x8, x1, #0, #4
; CHECK-SD-NEXT:    strb w0, [x8]
; CHECK-SD-NEXT:    ldr q0, [sp], #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v16i8_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w1
; CHECK-GI-NEXT:    mov w8, #1 // =0x1
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0xf
; CHECK-GI-NEXT:    mul x8, x9, x8
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    strb w0, [x9, x8]
; CHECK-GI-NEXT:    ldr q0, [sp], #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <16 x i8> %a, i8 %b, i32 %c
  ret <16 x i8> %d
}

define <32 x i8> @insert_v32i8_0(<32 x i8> %a, i8 %b, i32 %c) {
; CHECK-LABEL: insert_v32i8_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.b[0], w0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <32 x i8> %a, i8 %b, i32 0
  ret <32 x i8> %d
}

define <32 x i8> @insert_v32i8_2(<32 x i8> %a, i8 %b, i32 %c) {
; CHECK-LABEL: insert_v32i8_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.b[2], w0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <32 x i8> %a, i8 %b, i32 2
  ret <32 x i8> %d
}

define <32 x i8> @insert_v32i8_c(<32 x i8> %a, i8 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v32i8_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x1, #0x1f
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    strb w0, [x9, x8]
; CHECK-SD-NEXT:    ldp q0, q1, [sp], #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v32i8_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w1
; CHECK-GI-NEXT:    mov x10, sp
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    and x8, x8, #0x1f
; CHECK-GI-NEXT:    lsl x9, x8, #1
; CHECK-GI-NEXT:    sub x8, x9, x8
; CHECK-GI-NEXT:    strb w0, [x10, x8]
; CHECK-GI-NEXT:    ldp q0, q1, [sp]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <32 x i8> %a, i8 %b, i32 %c
  ret <32 x i8> %d
}

define <4 x i16> @insert_v4i16_0(<4 x i16> %a, i16 %b, i32 %c) {
; CHECK-LABEL: insert_v4i16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.h[0], w0
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <4 x i16> %a, i16 %b, i32 0
  ret <4 x i16> %d
}

define <4 x i16> @insert_v4i16_2(<4 x i16> %a, i16 %b, i32 %c) {
; CHECK-LABEL: insert_v4i16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.h[2], w0
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <4 x i16> %a, i16 %b, i32 2
  ret <4 x i16> %d
}

define <4 x i16> @insert_v4i16_c(<4 x i16> %a, i16 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v4i16_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    add x8, sp, #8
; CHECK-SD-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-SD-NEXT:    str d0, [sp, #8]
; CHECK-SD-NEXT:    bfi x8, x1, #1, #2
; CHECK-SD-NEXT:    strh w0, [x8]
; CHECK-SD-NEXT:    ldr d0, [sp, #8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v4i16_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w1
; CHECK-GI-NEXT:    add x8, sp, #8
; CHECK-GI-NEXT:    str d0, [sp, #8]
; CHECK-GI-NEXT:    and x9, x9, #0x3
; CHECK-GI-NEXT:    strh w0, [x8, x9, lsl #1]
; CHECK-GI-NEXT:    ldr d0, [sp, #8]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <4 x i16> %a, i16 %b, i32 %c
  ret <4 x i16> %d
}

define <8 x i16> @insert_v8i16_0(<8 x i16> %a, i16 %b, i32 %c) {
; CHECK-LABEL: insert_v8i16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.h[0], w0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <8 x i16> %a, i16 %b, i32 0
  ret <8 x i16> %d
}

define <8 x i16> @insert_v8i16_2(<8 x i16> %a, i16 %b, i32 %c) {
; CHECK-LABEL: insert_v8i16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.h[2], w0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <8 x i16> %a, i16 %b, i32 2
  ret <8 x i16> %d
}

define <8 x i16> @insert_v8i16_c(<8 x i16> %a, i16 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v8i16_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x1, #1, #3
; CHECK-SD-NEXT:    strh w0, [x8]
; CHECK-SD-NEXT:    ldr q0, [sp], #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v8i16_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w1
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x7
; CHECK-GI-NEXT:    strh w0, [x8, x9, lsl #1]
; CHECK-GI-NEXT:    ldr q0, [sp], #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <8 x i16> %a, i16 %b, i32 %c
  ret <8 x i16> %d
}

define <16 x i16> @insert_v16i16_0(<16 x i16> %a, i16 %b, i32 %c) {
; CHECK-LABEL: insert_v16i16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.h[0], w0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <16 x i16> %a, i16 %b, i32 0
  ret <16 x i16> %d
}

define <16 x i16> @insert_v16i16_2(<16 x i16> %a, i16 %b, i32 %c) {
; CHECK-LABEL: insert_v16i16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.h[2], w0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <16 x i16> %a, i16 %b, i32 2
  ret <16 x i16> %d
}

define <16 x i16> @insert_v16i16_c(<16 x i16> %a, i16 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v16i16_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x1, #0xf
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    strh w0, [x9, x8, lsl #1]
; CHECK-SD-NEXT:    ldp q0, q1, [sp], #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v16i16_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w1
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    and x8, x8, #0xf
; CHECK-GI-NEXT:    strh w0, [x9, x8, lsl #1]
; CHECK-GI-NEXT:    ldp q0, q1, [sp]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <16 x i16> %a, i16 %b, i32 %c
  ret <16 x i16> %d
}

define <2 x i32> @insert_v2i32_0(<2 x i32> %a, i32 %b, i32 %c) {
; CHECK-LABEL: insert_v2i32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.s[0], w0
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <2 x i32> %a, i32 %b, i32 0
  ret <2 x i32> %d
}

define <2 x i32> @insert_v2i32_1(<2 x i32> %a, i32 %b, i32 %c) {
; CHECK-LABEL: insert_v2i32_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.s[1], w0
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <2 x i32> %a, i32 %b, i32 1
  ret <2 x i32> %d
}

define <2 x i32> @insert_v2i32_c(<2 x i32> %a, i32 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v2i32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    add x8, sp, #8
; CHECK-SD-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-SD-NEXT:    str d0, [sp, #8]
; CHECK-SD-NEXT:    bfi x8, x1, #2, #1
; CHECK-SD-NEXT:    str w0, [x8]
; CHECK-SD-NEXT:    ldr d0, [sp, #8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v2i32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w1
; CHECK-GI-NEXT:    add x8, sp, #8
; CHECK-GI-NEXT:    str d0, [sp, #8]
; CHECK-GI-NEXT:    and x9, x9, #0x1
; CHECK-GI-NEXT:    str w0, [x8, x9, lsl #2]
; CHECK-GI-NEXT:    ldr d0, [sp, #8]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <2 x i32> %a, i32 %b, i32 %c
  ret <2 x i32> %d
}

define <3 x i32> @insert_v3i32_0(<3 x i32> %a, i32 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v3i32_0:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    fmov s1, w0
; CHECK-SD-NEXT:    mov v1.s[1], v0.s[1]
; CHECK-SD-NEXT:    mov v1.s[2], v0.s[2]
; CHECK-SD-NEXT:    mov v0.16b, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v3i32_0:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov w8, v0.s[1]
; CHECK-GI-NEXT:    fmov s1, w0
; CHECK-GI-NEXT:    mov w9, v0.s[2]
; CHECK-GI-NEXT:    mov v1.s[1], w8
; CHECK-GI-NEXT:    mov v1.s[2], w9
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <3 x i32> %a, i32 %b, i32 0
  ret <3 x i32> %d
}

define <3 x i32> @insert_v3i32_2(<3 x i32> %a, i32 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v3i32_2:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    mov v0.s[2], w0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v3i32_2:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-GI-NEXT:    fmov s1, w0
; CHECK-GI-NEXT:    mov v0.s[2], v1.s[0]
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <3 x i32> %a, i32 %b, i32 2
  ret <3 x i32> %d
}

define <3 x i32> @insert_v3i32_c(<3 x i32> %a, i32 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v3i32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x1, #2, #2
; CHECK-SD-NEXT:    str w0, [x8]
; CHECK-SD-NEXT:    ldr q0, [sp], #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v3i32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w1
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x3
; CHECK-GI-NEXT:    str w0, [x8, x9, lsl #2]
; CHECK-GI-NEXT:    ldr q0, [sp], #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <3 x i32> %a, i32 %b, i32 %c
  ret <3 x i32> %d
}

define <4 x i32> @insert_v4i32_0(<4 x i32> %a, i32 %b, i32 %c) {
; CHECK-LABEL: insert_v4i32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.s[0], w0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <4 x i32> %a, i32 %b, i32 0
  ret <4 x i32> %d
}

define <4 x i32> @insert_v4i32_2(<4 x i32> %a, i32 %b, i32 %c) {
; CHECK-LABEL: insert_v4i32_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.s[2], w0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <4 x i32> %a, i32 %b, i32 2
  ret <4 x i32> %d
}

define <4 x i32> @insert_v4i32_c(<4 x i32> %a, i32 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v4i32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x1, #2, #2
; CHECK-SD-NEXT:    str w0, [x8]
; CHECK-SD-NEXT:    ldr q0, [sp], #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v4i32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w1
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x3
; CHECK-GI-NEXT:    str w0, [x8, x9, lsl #2]
; CHECK-GI-NEXT:    ldr q0, [sp], #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <4 x i32> %a, i32 %b, i32 %c
  ret <4 x i32> %d
}

define <8 x i32> @insert_v8i32_0(<8 x i32> %a, i32 %b, i32 %c) {
; CHECK-LABEL: insert_v8i32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.s[0], w0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <8 x i32> %a, i32 %b, i32 0
  ret <8 x i32> %d
}

define <8 x i32> @insert_v8i32_2(<8 x i32> %a, i32 %b, i32 %c) {
; CHECK-LABEL: insert_v8i32_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.s[2], w0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <8 x i32> %a, i32 %b, i32 2
  ret <8 x i32> %d
}

define <8 x i32> @insert_v8i32_c(<8 x i32> %a, i32 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v8i32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x1, #0x7
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    str w0, [x9, x8, lsl #2]
; CHECK-SD-NEXT:    ldp q0, q1, [sp], #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v8i32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w1
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    and x8, x8, #0x7
; CHECK-GI-NEXT:    str w0, [x9, x8, lsl #2]
; CHECK-GI-NEXT:    ldp q0, q1, [sp]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <8 x i32> %a, i32 %b, i32 %c
  ret <8 x i32> %d
}

define <2 x i64> @insert_v2i64_0(<2 x i64> %a, i64 %b, i32 %c) {
; CHECK-LABEL: insert_v2i64_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.d[0], x0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <2 x i64> %a, i64 %b, i32 0
  ret <2 x i64> %d
}

define <2 x i64> @insert_v2i64_1(<2 x i64> %a, i64 %b, i32 %c) {
; CHECK-LABEL: insert_v2i64_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.d[1], x0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <2 x i64> %a, i64 %b, i32 1
  ret <2 x i64> %d
}

define <2 x i64> @insert_v2i64_c(<2 x i64> %a, i64 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v2i64_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x1, #3, #1
; CHECK-SD-NEXT:    str x0, [x8]
; CHECK-SD-NEXT:    ldr q0, [sp], #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v2i64_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w1
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x1
; CHECK-GI-NEXT:    str x0, [x8, x9, lsl #3]
; CHECK-GI-NEXT:    ldr q0, [sp], #16
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <2 x i64> %a, i64 %b, i32 %c
  ret <2 x i64> %d
}

define <3 x i64> @insert_v3i64_0(<3 x i64> %a, i64 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v3i64_0:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    mov v0.d[0], x0
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v3i64_0:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    fmov d0, x0
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <3 x i64> %a, i64 %b, i32 0
  ret <3 x i64> %d
}

define <3 x i64> @insert_v3i64_2(<3 x i64> %a, i64 %b, i32 %c) {
; CHECK-LABEL: insert_v3i64_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov d2, x0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <3 x i64> %a, i64 %b, i32 2
  ret <3 x i64> %d
}

define <3 x i64> @insert_v3i64_c(<3 x i64> %a, i64 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v3i64_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    stp q0, q2, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    and x9, x1, #0x3
; CHECK-SD-NEXT:    str x0, [x8, x9, lsl #3]
; CHECK-SD-NEXT:    ldr q0, [sp]
; CHECK-SD-NEXT:    ldr d2, [sp, #16]
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    add sp, sp, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v3i64_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    mov w8, w1
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    and x8, x8, #0x3
; CHECK-GI-NEXT:    stp q0, q2, [sp]
; CHECK-GI-NEXT:    str x0, [x9, x8, lsl #3]
; CHECK-GI-NEXT:    ldp q0, q2, [sp]
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <3 x i64> %a, i64 %b, i32 %c
  ret <3 x i64> %d
}

define <4 x i64> @insert_v4i64_0(<4 x i64> %a, i64 %b, i32 %c) {
; CHECK-LABEL: insert_v4i64_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.d[0], x0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <4 x i64> %a, i64 %b, i32 0
  ret <4 x i64> %d
}

define <4 x i64> @insert_v4i64_2(<4 x i64> %a, i64 %b, i32 %c) {
; CHECK-LABEL: insert_v4i64_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v1.d[0], x0
; CHECK-NEXT:    ret
entry:
  %d = insertelement <4 x i64> %a, i64 %b, i32 2
  ret <4 x i64> %d
}

define <4 x i64> @insert_v4i64_c(<4 x i64> %a, i64 %b, i32 %c) {
; CHECK-SD-LABEL: insert_v4i64_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x1, #0x3
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    str x0, [x9, x8, lsl #3]
; CHECK-SD-NEXT:    ldp q0, q1, [sp], #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: insert_v4i64_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w1
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    and x8, x8, #0x3
; CHECK-GI-NEXT:    str x0, [x9, x8, lsl #3]
; CHECK-GI-NEXT:    ldp q0, q1, [sp]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = insertelement <4 x i64> %a, i64 %b, i32 %c
  ret <4 x i64> %d
}

define double @extract_v2f64_0(<2 x double> %a, i32 %c) {
; CHECK-LABEL: extract_v2f64_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = extractelement <2 x double> %a, i32 0
  ret double %d
}

define double @extract_v2f64_1(<2 x double> %a, i32 %c) {
; CHECK-LABEL: extract_v2f64_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov d0, v0.d[1]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <2 x double> %a, i32 1
  ret double %d
}

define double @extract_v2f64_c(<2 x double> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v2f64_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x0, #3, #1
; CHECK-SD-NEXT:    ldr d0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v2f64_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x1
; CHECK-GI-NEXT:    ldr d0, [x8, x9, lsl #3]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <2 x double> %a, i32 %c
  ret double %d
}

define double @extract_v3f64_0(<3 x double> %a, i32 %c) {
; CHECK-LABEL: extract_v3f64_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %d = extractelement <3 x double> %a, i32 0
  ret double %d
}

define double @extract_v3f64_2(<3 x double> %a, i32 %c) {
; CHECK-LABEL: extract_v3f64_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov d0, d2
; CHECK-NEXT:    ret
entry:
  %d = extractelement <3 x double> %a, i32 2
  ret double %d
}

define double @extract_v3f64_c(<3 x double> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v3f64_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    and x8, x0, #0x3
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    stp q0, q2, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    ldr d0, [x9, x8, lsl #3]
; CHECK-SD-NEXT:    add sp, sp, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v3f64_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    and x8, x8, #0x3
; CHECK-GI-NEXT:    stp q0, q2, [sp]
; CHECK-GI-NEXT:    ldr d0, [x9, x8, lsl #3]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <3 x double> %a, i32 %c
  ret double %d
}

define double @extract_v4f64_0(<4 x double> %a, i32 %c) {
; CHECK-LABEL: extract_v4f64_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = extractelement <4 x double> %a, i32 0
  ret double %d
}

define double @extract_v4f64_2(<4 x double> %a, i32 %c) {
; CHECK-LABEL: extract_v4f64_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = extractelement <4 x double> %a, i32 2
  ret double %d
}

define double @extract_v4f64_c(<4 x double> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v4f64_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x0, #0x3
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    ldr d0, [x9, x8, lsl #3]
; CHECK-SD-NEXT:    add sp, sp, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v4f64_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    and x8, x8, #0x3
; CHECK-GI-NEXT:    ldr d0, [x9, x8, lsl #3]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <4 x double> %a, i32 %c
  ret double %d
}

define float @extract_v2f32_0(<2 x float> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v2f32_0:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v2f32_0:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $d0
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <2 x float> %a, i32 0
  ret float %d
}

define float @extract_v2f32_1(<2 x float> %a, i32 %c) {
; CHECK-LABEL: extract_v2f32_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <2 x float> %a, i32 1
  ret float %d
}

define float @extract_v2f32_c(<2 x float> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v2f32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    add x8, sp, #8
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str d0, [sp, #8]
; CHECK-SD-NEXT:    bfi x8, x0, #2, #1
; CHECK-SD-NEXT:    ldr s0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v2f32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    add x8, sp, #8
; CHECK-GI-NEXT:    str d0, [sp, #8]
; CHECK-GI-NEXT:    and x9, x9, #0x1
; CHECK-GI-NEXT:    ldr s0, [x8, x9, lsl #2]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <2 x float> %a, i32 %c
  ret float %d
}

define float @extract_v3f32_0(<3 x float> %a, i32 %c) {
; CHECK-LABEL: extract_v3f32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = extractelement <3 x float> %a, i32 0
  ret float %d
}

define float @extract_v3f32_2(<3 x float> %a, i32 %c) {
; CHECK-LABEL: extract_v3f32_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov s0, v0.s[2]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <3 x float> %a, i32 2
  ret float %d
}

define float @extract_v3f32_c(<3 x float> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v3f32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x0, #2, #2
; CHECK-SD-NEXT:    ldr s0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v3f32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x3
; CHECK-GI-NEXT:    ldr s0, [x8, x9, lsl #2]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <3 x float> %a, i32 %c
  ret float %d
}

define float @extract_v4f32_0(<4 x float> %a, i32 %c) {
; CHECK-LABEL: extract_v4f32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = extractelement <4 x float> %a, i32 0
  ret float %d
}

define float @extract_v4f32_2(<4 x float> %a, i32 %c) {
; CHECK-LABEL: extract_v4f32_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov s0, v0.s[2]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <4 x float> %a, i32 2
  ret float %d
}

define float @extract_v4f32_c(<4 x float> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v4f32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x0, #2, #2
; CHECK-SD-NEXT:    ldr s0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v4f32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x3
; CHECK-GI-NEXT:    ldr s0, [x8, x9, lsl #2]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <4 x float> %a, i32 %c
  ret float %d
}

define float @extract_v8f32_0(<8 x float> %a, i32 %c) {
; CHECK-LABEL: extract_v8f32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = extractelement <8 x float> %a, i32 0
  ret float %d
}

define float @extract_v8f32_2(<8 x float> %a, i32 %c) {
; CHECK-LABEL: extract_v8f32_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov s0, v0.s[2]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <8 x float> %a, i32 2
  ret float %d
}

define float @extract_v8f32_c(<8 x float> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v8f32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x0, #0x7
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    ldr s0, [x9, x8, lsl #2]
; CHECK-SD-NEXT:    add sp, sp, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v8f32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    and x8, x8, #0x7
; CHECK-GI-NEXT:    ldr s0, [x9, x8, lsl #2]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <8 x float> %a, i32 %c
  ret float %d
}

define half @extract_v4f16_0(<4 x half> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v4f16_0:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $h0 killed $h0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v4f16_0:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 killed $d0
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <4 x half> %a, i32 0
  ret half %d
}

define half @extract_v4f16_2(<4 x half> %a, i32 %c) {
; CHECK-LABEL: extract_v4f16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov h0, v0.h[2]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <4 x half> %a, i32 2
  ret half %d
}

define half @extract_v4f16_c(<4 x half> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v4f16_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    add x8, sp, #8
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str d0, [sp, #8]
; CHECK-SD-NEXT:    bfi x8, x0, #1, #2
; CHECK-SD-NEXT:    ldr h0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v4f16_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    add x8, sp, #8
; CHECK-GI-NEXT:    str d0, [sp, #8]
; CHECK-GI-NEXT:    and x9, x9, #0x3
; CHECK-GI-NEXT:    ldr h0, [x8, x9, lsl #1]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <4 x half> %a, i32 %c
  ret half %d
}

define half @extract_v8f16_0(<8 x half> %a, i32 %c) {
; CHECK-LABEL: extract_v8f16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = extractelement <8 x half> %a, i32 0
  ret half %d
}

define half @extract_v8f16_2(<8 x half> %a, i32 %c) {
; CHECK-LABEL: extract_v8f16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov h0, v0.h[2]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <8 x half> %a, i32 2
  ret half %d
}

define half @extract_v8f16_c(<8 x half> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v8f16_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x0, #1, #3
; CHECK-SD-NEXT:    ldr h0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v8f16_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x7
; CHECK-GI-NEXT:    ldr h0, [x8, x9, lsl #1]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <8 x half> %a, i32 %c
  ret half %d
}

define half @extract_v16f16_0(<16 x half> %a, i32 %c) {
; CHECK-LABEL: extract_v16f16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $q0
; CHECK-NEXT:    ret
entry:
  %d = extractelement <16 x half> %a, i32 0
  ret half %d
}

define half @extract_v16f16_2(<16 x half> %a, i32 %c) {
; CHECK-LABEL: extract_v16f16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov h0, v0.h[2]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <16 x half> %a, i32 2
  ret half %d
}

define half @extract_v16f16_c(<16 x half> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v16f16_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x0, #0xf
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    ldr h0, [x9, x8, lsl #1]
; CHECK-SD-NEXT:    add sp, sp, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v16f16_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    and x8, x8, #0xf
; CHECK-GI-NEXT:    ldr h0, [x9, x8, lsl #1]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <16 x half> %a, i32 %c
  ret half %d
}

define i8 @extract_v8i8_0(<8 x i8> %a, i32 %c) {
; CHECK-LABEL: extract_v8i8_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    umov w0, v0.b[0]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <8 x i8> %a, i32 0
  ret i8 %d
}

define i8 @extract_v8i8_2(<8 x i8> %a, i32 %c) {
; CHECK-LABEL: extract_v8i8_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    umov w0, v0.b[2]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <8 x i8> %a, i32 2
  ret i8 %d
}

define i8 @extract_v8i8_c(<8 x i8> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v8i8_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    add x8, sp, #8
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str d0, [sp, #8]
; CHECK-SD-NEXT:    bfxil x8, x0, #0, #3
; CHECK-SD-NEXT:    ldrb w0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v8i8_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    add x8, sp, #8
; CHECK-GI-NEXT:    str d0, [sp, #8]
; CHECK-GI-NEXT:    and x9, x9, #0x7
; CHECK-GI-NEXT:    lsl x10, x9, #1
; CHECK-GI-NEXT:    sub x9, x10, x9
; CHECK-GI-NEXT:    ldrb w0, [x8, x9]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <8 x i8> %a, i32 %c
  ret i8 %d
}

define i8 @extract_v16i8_0(<16 x i8> %a, i32 %c) {
; CHECK-LABEL: extract_v16i8_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umov w0, v0.b[0]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <16 x i8> %a, i32 0
  ret i8 %d
}

define i8 @extract_v16i8_2(<16 x i8> %a, i32 %c) {
; CHECK-LABEL: extract_v16i8_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umov w0, v0.b[2]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <16 x i8> %a, i32 2
  ret i8 %d
}

define i8 @extract_v16i8_c(<16 x i8> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v16i8_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfxil x8, x0, #0, #4
; CHECK-SD-NEXT:    ldrb w0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v16i8_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0xf
; CHECK-GI-NEXT:    lsl x10, x9, #1
; CHECK-GI-NEXT:    sub x9, x10, x9
; CHECK-GI-NEXT:    ldrb w0, [x8, x9]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <16 x i8> %a, i32 %c
  ret i8 %d
}

define i8 @extract_v32i8_0(<32 x i8> %a, i32 %c) {
; CHECK-LABEL: extract_v32i8_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umov w0, v0.b[0]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <32 x i8> %a, i32 0
  ret i8 %d
}

define i8 @extract_v32i8_2(<32 x i8> %a, i32 %c) {
; CHECK-LABEL: extract_v32i8_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umov w0, v0.b[2]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <32 x i8> %a, i32 2
  ret i8 %d
}

define i8 @extract_v32i8_c(<32 x i8> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v32i8_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x0, #0x1f
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    ldrb w0, [x9, x8]
; CHECK-SD-NEXT:    add sp, sp, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v32i8_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    mov x10, sp
; CHECK-GI-NEXT:    and x8, x8, #0x1f
; CHECK-GI-NEXT:    lsl x9, x8, #1
; CHECK-GI-NEXT:    sub x8, x9, x8
; CHECK-GI-NEXT:    ldrb w0, [x10, x8]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <32 x i8> %a, i32 %c
  ret i8 %d
}

define i16 @extract_v4i16_0(<4 x i16> %a, i32 %c) {
; CHECK-LABEL: extract_v4i16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    umov w0, v0.h[0]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <4 x i16> %a, i32 0
  ret i16 %d
}

define i16 @extract_v4i16_2(<4 x i16> %a, i32 %c) {
; CHECK-LABEL: extract_v4i16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    umov w0, v0.h[2]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <4 x i16> %a, i32 2
  ret i16 %d
}

define i16 @extract_v4i16_c(<4 x i16> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v4i16_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    add x8, sp, #8
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str d0, [sp, #8]
; CHECK-SD-NEXT:    bfi x8, x0, #1, #2
; CHECK-SD-NEXT:    ldrh w0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v4i16_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    add x8, sp, #8
; CHECK-GI-NEXT:    str d0, [sp, #8]
; CHECK-GI-NEXT:    and x9, x9, #0x3
; CHECK-GI-NEXT:    ldrh w0, [x8, x9, lsl #1]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <4 x i16> %a, i32 %c
  ret i16 %d
}

define i16 @extract_v8i16_0(<8 x i16> %a, i32 %c) {
; CHECK-LABEL: extract_v8i16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umov w0, v0.h[0]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <8 x i16> %a, i32 0
  ret i16 %d
}

define i16 @extract_v8i16_2(<8 x i16> %a, i32 %c) {
; CHECK-LABEL: extract_v8i16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umov w0, v0.h[2]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <8 x i16> %a, i32 2
  ret i16 %d
}

define i16 @extract_v8i16_c(<8 x i16> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v8i16_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x0, #1, #3
; CHECK-SD-NEXT:    ldrh w0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v8i16_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x7
; CHECK-GI-NEXT:    ldrh w0, [x8, x9, lsl #1]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <8 x i16> %a, i32 %c
  ret i16 %d
}

define i16 @extract_v16i16_0(<16 x i16> %a, i32 %c) {
; CHECK-LABEL: extract_v16i16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umov w0, v0.h[0]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <16 x i16> %a, i32 0
  ret i16 %d
}

define i16 @extract_v16i16_2(<16 x i16> %a, i32 %c) {
; CHECK-LABEL: extract_v16i16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umov w0, v0.h[2]
; CHECK-NEXT:    ret
entry:
  %d = extractelement <16 x i16> %a, i32 2
  ret i16 %d
}

define i16 @extract_v16i16_c(<16 x i16> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v16i16_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x0, #0xf
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    ldrh w0, [x9, x8, lsl #1]
; CHECK-SD-NEXT:    add sp, sp, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v16i16_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    and x8, x8, #0xf
; CHECK-GI-NEXT:    ldrh w0, [x9, x8, lsl #1]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <16 x i16> %a, i32 %c
  ret i16 %d
}

define i32 @extract_v2i32_0(<2 x i32> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v2i32_0:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    fmov w0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v2i32_0:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <2 x i32> %a, i32 0
  ret i32 %d
}

define i32 @extract_v2i32_1(<2 x i32> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v2i32_1:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov w0, v0.s[1]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v2i32_1:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    mov s0, v0.s[1]
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <2 x i32> %a, i32 1
  ret i32 %d
}

define i32 @extract_v2i32_c(<2 x i32> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v2i32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    add x8, sp, #8
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str d0, [sp, #8]
; CHECK-SD-NEXT:    bfi x8, x0, #2, #1
; CHECK-SD-NEXT:    ldr w0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v2i32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    add x8, sp, #8
; CHECK-GI-NEXT:    str d0, [sp, #8]
; CHECK-GI-NEXT:    and x9, x9, #0x1
; CHECK-GI-NEXT:    ldr w0, [x8, x9, lsl #2]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <2 x i32> %a, i32 %c
  ret i32 %d
}

define i32 @extract_v3i32_0(<3 x i32> %a, i32 %c) {
; CHECK-LABEL: extract_v3i32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
entry:
  %d = extractelement <3 x i32> %a, i32 0
  ret i32 %d
}

define i32 @extract_v3i32_2(<3 x i32> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v3i32_2:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    mov w0, v0.s[2]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v3i32_2:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov s0, v0.s[2]
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <3 x i32> %a, i32 2
  ret i32 %d
}

define i32 @extract_v3i32_c(<3 x i32> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v3i32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x0, #2, #2
; CHECK-SD-NEXT:    ldr w0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v3i32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x3
; CHECK-GI-NEXT:    ldr w0, [x8, x9, lsl #2]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <3 x i32> %a, i32 %c
  ret i32 %d
}

define i32 @extract_v4i32_0(<4 x i32> %a, i32 %c) {
; CHECK-LABEL: extract_v4i32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
entry:
  %d = extractelement <4 x i32> %a, i32 0
  ret i32 %d
}

define i32 @extract_v4i32_2(<4 x i32> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v4i32_2:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    mov w0, v0.s[2]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v4i32_2:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov s0, v0.s[2]
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <4 x i32> %a, i32 2
  ret i32 %d
}

define i32 @extract_v4i32_c(<4 x i32> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v4i32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x0, #2, #2
; CHECK-SD-NEXT:    ldr w0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v4i32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x3
; CHECK-GI-NEXT:    ldr w0, [x8, x9, lsl #2]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <4 x i32> %a, i32 %c
  ret i32 %d
}

define i32 @extract_v8i32_0(<8 x i32> %a, i32 %c) {
; CHECK-LABEL: extract_v8i32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
entry:
  %d = extractelement <8 x i32> %a, i32 0
  ret i32 %d
}

define i32 @extract_v8i32_2(<8 x i32> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v8i32_2:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    mov w0, v0.s[2]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v8i32_2:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov s0, v0.s[2]
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <8 x i32> %a, i32 2
  ret i32 %d
}

define i32 @extract_v8i32_c(<8 x i32> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v8i32_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x0, #0x7
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    ldr w0, [x9, x8, lsl #2]
; CHECK-SD-NEXT:    add sp, sp, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v8i32_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    and x8, x8, #0x7
; CHECK-GI-NEXT:    ldr w0, [x9, x8, lsl #2]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <8 x i32> %a, i32 %c
  ret i32 %d
}

define i64 @extract_v2i64_0(<2 x i64> %a, i32 %c) {
; CHECK-LABEL: extract_v2i64_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
entry:
  %d = extractelement <2 x i64> %a, i32 0
  ret i64 %d
}

define i64 @extract_v2i64_1(<2 x i64> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v2i64_1:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    mov x0, v0.d[1]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v2i64_1:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov d0, v0.d[1]
; CHECK-GI-NEXT:    fmov x0, d0
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <2 x i64> %a, i32 1
  ret i64 %d
}

define i64 @extract_v2i64_c(<2 x i64> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v2i64_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    mov x8, sp
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    str q0, [sp]
; CHECK-SD-NEXT:    bfi x8, x0, #3, #1
; CHECK-SD-NEXT:    ldr x0, [x8]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v2i64_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sub sp, sp, #16
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    mov w9, w0
; CHECK-GI-NEXT:    mov x8, sp
; CHECK-GI-NEXT:    str q0, [sp]
; CHECK-GI-NEXT:    and x9, x9, #0x1
; CHECK-GI-NEXT:    ldr x0, [x8, x9, lsl #3]
; CHECK-GI-NEXT:    add sp, sp, #16
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <2 x i64> %a, i32 %c
  ret i64 %d
}

define i64 @extract_v3i64_0(<3 x i64> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v3i64_0:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    fmov x0, d0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v3i64_0:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    fmov x0, d0
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <3 x i64> %a, i32 0
  ret i64 %d
}

define i64 @extract_v3i64_2(<3 x i64> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v3i64_2:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    fmov x0, d2
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v3i64_2:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    fmov x0, d2
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <3 x i64> %a, i32 2
  ret i64 %d
}

define i64 @extract_v3i64_c(<3 x i64> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v3i64_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    and x8, x0, #0x3
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    stp q0, q2, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    ldr x0, [x9, x8, lsl #3]
; CHECK-SD-NEXT:    add sp, sp, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v3i64_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    and x8, x8, #0x3
; CHECK-GI-NEXT:    stp q0, q2, [sp]
; CHECK-GI-NEXT:    ldr x0, [x9, x8, lsl #3]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <3 x i64> %a, i32 %c
  ret i64 %d
}

define i64 @extract_v4i64_0(<4 x i64> %a, i32 %c) {
; CHECK-LABEL: extract_v4i64_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
entry:
  %d = extractelement <4 x i64> %a, i32 0
  ret i64 %d
}

define i64 @extract_v4i64_2(<4 x i64> %a, i32 %c) {
; CHECK-LABEL: extract_v4i64_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov x0, d1
; CHECK-NEXT:    ret
entry:
  %d = extractelement <4 x i64> %a, i32 2
  ret i64 %d
}

define i64 @extract_v4i64_c(<4 x i64> %a, i32 %c) {
; CHECK-SD-LABEL: extract_v4i64_c:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    and x8, x0, #0x3
; CHECK-SD-NEXT:    mov x9, sp
; CHECK-SD-NEXT:    ldr x0, [x9, x8, lsl #3]
; CHECK-SD-NEXT:    add sp, sp, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extract_v4i64_c:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-GI-NEXT:    sub x9, sp, #48
; CHECK-GI-NEXT:    mov x29, sp
; CHECK-GI-NEXT:    and sp, x9, #0xffffffffffffffe0
; CHECK-GI-NEXT:    .cfi_def_cfa w29, 16
; CHECK-GI-NEXT:    .cfi_offset w30, -8
; CHECK-GI-NEXT:    .cfi_offset w29, -16
; CHECK-GI-NEXT:    mov w8, w0
; CHECK-GI-NEXT:    stp q0, q1, [sp]
; CHECK-GI-NEXT:    mov x9, sp
; CHECK-GI-NEXT:    and x8, x8, #0x3
; CHECK-GI-NEXT:    ldr x0, [x9, x8, lsl #3]
; CHECK-GI-NEXT:    mov sp, x29
; CHECK-GI-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-GI-NEXT:    ret
entry:
  %d = extractelement <4 x i64> %a, i32 %c
  ret i64 %d
}
