; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -verify-machineinstrs < %s | FileCheck -check-prefix=SI-NOHSA %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn--amdhsa -mcpu=kaveri -verify-machineinstrs < %s | FileCheck -check-prefix=GCNX3-HSA %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefix=GCNX3-NOHSA %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=r600 -mcpu=redwood < %s | FileCheck -check-prefix=EG %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn--amdhsa -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefix=GCN-HSA -check-prefix=GCN-GFX900-HSA %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn--amdhsa -mcpu=gfx908 -verify-machineinstrs < %s | FileCheck -check-prefix=GCN-HSA -check-prefix=GCN-GFX908-HSA %s

define amdgpu_kernel void @global_load_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_i32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_load_i32:
; GCNX3-HSA:       ; %bb.0: ; %entry
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dword v2, v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-HSA-NEXT:    flat_store_dword v[0:1], v2
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_i32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_load_i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 1, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_load_i32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dword v1, v0, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    global_store_dword v0, v1, s[0:1]
; GCN-HSA-NEXT:    s_endpgm
entry:
  %ld = load i32, ptr addrspace(1) %in
  store i32 %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v2i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v2i32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_load_v2i32:
; GCNX3-HSA:       ; %bb.0: ; %entry
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, s0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v3, s1
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-HSA-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v2i32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_load_v2i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 1, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_load_v2i32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
entry:
  %ld = load <2 x i32>, ptr addrspace(1) %in
  store <2 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v3i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v3i32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:8
; SI-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_load_v3i32:
; GCNX3-HSA:       ; %bb.0: ; %entry
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dwordx3 v[0:2], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v3, s0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s1
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-HSA-NEXT:    flat_store_dwordx3 v[3:4], v[0:2]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v3i32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx3 v[0:2], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_load_v3i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 6, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.X, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     MOV * T2.X, T0.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR * T3.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_load_v3i32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v3, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx3 v[0:2], v3, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
entry:
  %ld = load <3 x i32>, ptr addrspace(1) %in
  store <3 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v4i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v4i32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_load_v4i32:
; GCNX3-HSA:       ; %bb.0: ; %entry
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v4i32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_load_v4i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 1, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_load_v4i32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v4, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[0:3], v4, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
entry:
  %ld = load <4 x i32>, ptr addrspace(1) %in
  store <4 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v8i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v8i32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_load_v8i32:
; GCNX3-HSA:       ; %bb.0: ; %entry
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s2, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s0
; GCNX3-HSA-NEXT:    s_add_u32 s0, s0, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v11, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v10, s0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(1)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[10:11], v[0:3]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(1)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v8i32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_load_v8i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 4, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 0, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 16, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     ADD_INT * T2.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T2.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T3.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_load_v8i32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v8, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[0:3], v8, s[2:3] offset:16
; GCN-HSA-NEXT:    global_load_dwordx4 v[4:7], v8, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(1)
; GCN-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] offset:16
; GCN-HSA-NEXT:    s_waitcnt vmcnt(1)
; GCN-HSA-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
entry:
  %ld = load <8 x i32>, ptr addrspace(1) %in
  store <8 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v9i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v9i32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_load_dword v8, off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:32
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_load_v9i32:
; GCNX3-HSA:       ; %bb.0: ; %entry
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 32
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    s_add_u32 s2, s2, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s4
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCNX3-HSA-NEXT:    flat_load_dword v14, v[8:9]
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s1
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s0
; GCNX3-HSA-NEXT:    s_add_u32 s0, s0, 32
; GCNX3-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v11, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v13, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v10, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v12, s0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    flat_store_dword v[12:13], v14
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v9i32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_load_dword v8, off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_load_v9i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 8, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 2 @8
; EG-NEXT:    ALU 1, @23, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.X, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T4.XYZW, T2.X, 0, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T2.X, 16, #1
; EG-NEXT:     VTX_READ_32 T3.X, T3.X, 32, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T1.X, PV.W, literal.x,
; EG-NEXT:     MOV * T2.X, KC0[2].Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV * T3.X, PS,
; EG-NEXT:    ALU clause starting at 23:
; EG-NEXT:     LSHR * T5.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_load_v9i32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v8, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[0:3], v8, s[2:3]
; GCN-HSA-NEXT:    global_load_dwordx4 v[4:7], v8, s[2:3] offset:16
; GCN-HSA-NEXT:    global_load_dword v9, v8, s[2:3] offset:32
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] offset:16
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    global_store_dword v8, v9, s[0:1] offset:32
; GCN-HSA-NEXT:    s_endpgm
entry:
  %ld = load <9 x i32>, ptr addrspace(1) %in
  store <9 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v10i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v10i32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_load_dwordx2 v[8:9], off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx2 v[8:9], off, s[4:7], 0 offset:32
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_load_v10i32:
; GCNX3-HSA:       ; %bb.0: ; %entry
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 32
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    s_add_u32 s2, s2, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCNX3-HSA-NEXT:    flat_load_dwordx2 v[8:9], v[8:9]
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v11, s1
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v10, s0
; GCNX3-HSA-NEXT:    s_add_u32 s0, s0, 32
; GCNX3-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v13, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v15, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v12, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v14, s0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[10:11], v[0:3]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[12:13], v[4:7]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    flat_store_dwordx2 v[14:15], v[8:9]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v10i32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx2 v[8:9], off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx2 v[8:9], off, s[4:7], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_load_v10i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 2 @8
; EG-NEXT:    ALU 7, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T4.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T3.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 0, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 32, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T4.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T5.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_load_v10i32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v10, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[0:3], v10, s[2:3]
; GCN-HSA-NEXT:    global_load_dwordx4 v[4:7], v10, s[2:3] offset:16
; GCN-HSA-NEXT:    global_load_dwordx2 v[8:9], v10, s[2:3] offset:32
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    global_store_dwordx4 v10, v[0:3], s[0:1]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    global_store_dwordx4 v10, v[4:7], s[0:1] offset:16
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    global_store_dwordx2 v10, v[8:9], s[0:1] offset:32
; GCN-HSA-NEXT:    s_endpgm
entry:
  %ld = load <10 x i32>, ptr addrspace(1) %in
  store <10 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v11i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v11i32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dword v10, off, s[4:7], 0 offset:40
; SI-NOHSA-NEXT:    buffer_store_dwordx2 v[8:9], off, s[4:7], 0 offset:32
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_load_v11i32:
; GCNX3-HSA:       ; %bb.0: ; %entry
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 32
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    s_add_u32 s2, s2, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCNX3-HSA-NEXT:    flat_load_dwordx3 v[8:10], v[8:9]
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v12, s1
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v11, s0
; GCNX3-HSA-NEXT:    s_add_u32 s0, s0, 32
; GCNX3-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v14, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v13, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v15, s0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[11:12], v[0:3]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[13:14], v[4:7]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    flat_store_dwordx3 v[15:16], v[8:10]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v11i32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx3 v[8:10], off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx3 v[8:10], off, s[4:7], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_load_v11i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 2 @8
; EG-NEXT:    ALU 12, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T7.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T6.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.X, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T3.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 0, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 32, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     MOV * T4.X, T0.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    40(5.605194e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T5.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T6.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T7.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_load_v11i32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v11, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[0:3], v11, s[2:3]
; GCN-HSA-NEXT:    global_load_dwordx4 v[4:7], v11, s[2:3] offset:16
; GCN-HSA-NEXT:    global_load_dwordx3 v[8:10], v11, s[2:3] offset:32
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    global_store_dwordx4 v11, v[0:3], s[0:1]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    global_store_dwordx4 v11, v[4:7], s[0:1] offset:16
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    global_store_dwordx3 v11, v[8:10], s[0:1] offset:32
; GCN-HSA-NEXT:    s_endpgm
entry:
  %ld = load <11 x i32>, ptr addrspace(1) %in
  store <11 x i32> %ld, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @global_load_v12i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v12i32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0 offset:32
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_load_v12i32:
; GCNX3-HSA:       ; %bb.0: ; %entry
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 32
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    s_add_u32 s2, s2, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[8:11], v[8:9]
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v13, s1
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v12, s0
; GCNX3-HSA-NEXT:    s_add_u32 s0, s0, 32
; GCNX3-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v15, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v17, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v14, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, s0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[14:15], v[4:7]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[16:17], v[8:11]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v12i32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_load_v12i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 7, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 2 @8
; EG-NEXT:    ALU 1, @22, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T3.XYZW, T2.X, 0, #1
; EG-NEXT:     VTX_READ_128 T4.XYZW, T2.X, 16, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T2.X, 32, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T1.X, PV.W, literal.x,
; EG-NEXT:     MOV * T2.X, KC0[2].Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 22:
; EG-NEXT:     LSHR * T5.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_load_v12i32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v12, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[0:3], v12, s[2:3]
; GCN-HSA-NEXT:    global_load_dwordx4 v[4:7], v12, s[2:3] offset:16
; GCN-HSA-NEXT:    global_load_dwordx4 v[8:11], v12, s[2:3] offset:32
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    global_store_dwordx4 v12, v[4:7], s[0:1] offset:16
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    global_store_dwordx4 v12, v[8:11], s[0:1] offset:32
; GCN-HSA-NEXT:    s_endpgm
entry:
  %ld = load <12 x i32>, ptr addrspace(1) %in
  store <12 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v16i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v16i32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:48
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0 offset:32
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:48
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_load_v16i32:
; GCNX3-HSA:       ; %bb.0: ; %entry
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v13, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v12, s4
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 48
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    s_add_u32 s2, s2, 32
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s2
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[8:11], v[8:9]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[12:15], v[12:13]
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 32
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v19, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v18, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 48
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v17, s1
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, s0
; GCNX3-HSA-NEXT:    s_add_u32 s0, s0, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v21, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v23, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v20, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v22, s0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[16:17], v[0:3]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[20:21], v[4:7]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[18:19], v[8:11]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[22:23], v[12:15]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v16i32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:48
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:48
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_load_v16i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 11, @16, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 3 @8
; EG-NEXT:    ALU 1, @28, KC0[], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T7.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T5.XYZW, T2.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T6.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T4.XYZW, T3.X, 32, #1
; EG-NEXT:     VTX_READ_128 T5.XYZW, T3.X, 48, #1
; EG-NEXT:     VTX_READ_128 T6.XYZW, T3.X, 0, #1
; EG-NEXT:     VTX_READ_128 T3.XYZW, T3.X, 16, #1
; EG-NEXT:    ALU clause starting at 16:
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T2.X, PV.W, literal.x,
; EG-NEXT:     MOV * T3.X, KC0[2].Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 28:
; EG-NEXT:     LSHR * T7.X, T0.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_load_v16i32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v16, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[0:3], v16, s[2:3] offset:32
; GCN-HSA-NEXT:    global_load_dwordx4 v[4:7], v16, s[2:3] offset:48
; GCN-HSA-NEXT:    global_load_dwordx4 v[8:11], v16, s[2:3]
; GCN-HSA-NEXT:    global_load_dwordx4 v[12:15], v16, s[2:3] offset:16
; GCN-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCN-HSA-NEXT:    global_store_dwordx4 v16, v[0:3], s[0:1] offset:32
; GCN-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCN-HSA-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1] offset:48
; GCN-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCN-HSA-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCN-HSA-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1] offset:16
; GCN-HSA-NEXT:    s_endpgm
entry:
  %ld = load <16 x i32>, ptr addrspace(1) %in
  store <16 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_zextload_i32_to_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_zextload_i32_to_i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_zextload_i32_to_i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dword v0, v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, s0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v3, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-HSA-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_zextload_i32_to_i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_zextload_i32_to_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MOV * T0.Y, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_zextload_i32_to_i64:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dword v0, v1, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    global_store_dwordx2 v1, v[0:1], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
  %ld = load i32, ptr addrspace(1) %in
  %ext = zext i32 %ld to i64
  store i64 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_sextload_i32_to_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_sextload_i32_to_i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; SI-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_sextload_i32_to_i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dword v0, v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, s0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v3, s1
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCNX3-HSA-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_sextload_i32_to_i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_sextload_i32_to_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     ASHR * T0.Y, T0.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
;
; GCN-HSA-LABEL: global_sextload_i32_to_i64:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dword v0, v2, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-HSA-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
  %ld = load i32, ptr addrspace(1) %in
  %ext = sext i32 %ld to i64
  store i64 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_zextload_v1i32_to_v1i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_zextload_v1i32_to_v1i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_zextload_v1i32_to_v1i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dword v0, v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, s0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v3, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-HSA-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_zextload_v1i32_to_v1i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_zextload_v1i32_to_v1i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MOV * T0.Y, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_zextload_v1i32_to_v1i64:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dword v0, v1, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    global_store_dwordx2 v1, v[0:1], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
  %ld = load <1 x i32>, ptr addrspace(1) %in
  %ext = zext <1 x i32> %ld to <1 x i64>
  store <1 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_sextload_v1i32_to_v1i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_sextload_v1i32_to_v1i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; SI-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_sextload_v1i32_to_v1i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dword v0, v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, s0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v3, s1
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCNX3-HSA-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_sextload_v1i32_to_v1i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_sextload_v1i32_to_v1i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     ASHR * T0.Y, T0.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
;
; GCN-HSA-LABEL: global_sextload_v1i32_to_v1i64:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dword v0, v2, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-HSA-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
  %ld = load <1 x i32>, ptr addrspace(1) %in
  %ext = sext <1 x i32> %ld to <1 x i64>
  store <1 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_zextload_v2i32_to_v2i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_zextload_v2i32_to_v2i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx2 v[4:5], off, s[8:11], 0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v3, v1
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v4
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v5
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_zextload_v2i32_to_v2i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dwordx2 v[2:3], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_zextload_v2i32_to_v2i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx2 v[2:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v0, v2
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v2, v3
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v3, v1
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_zextload_v2i32_to_v2i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 5, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MOV T1.X, T0.X,
; EG-NEXT:     MOV T1.Y, 0.0,
; EG-NEXT:     MOV T1.Z, T0.Y,
; EG-NEXT:     MOV T1.W, 0.0,
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_zextload_v2i32_to_v2i64:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx2 v[2:3], v1, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v2
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v3
; GCN-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
  %ld = load <2 x i32>, ptr addrspace(1) %in
  %ext = zext <2 x i32> %ld to <2 x i64>
  store <2 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_sextload_v2i32_to_v2i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_sextload_v2i32_to_v2i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v3, 31, v1
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v1
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_sextload_v2i32_to_v2i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v3, 31, v1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v1
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_sextload_v2i32_to_v2i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v3, 31, v1
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v2, v1
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_sextload_v2i32_to_v2i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 7, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     ASHR * T1.W, T0.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR * T1.Y, T0.X, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T1.X, T0.X,
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV * T1.Z, T0.Y,
;
; GCN-HSA-LABEL: global_sextload_v2i32_to_v2i64:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v4, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx2 v[0:1], v4, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v3, 31, v1
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v1
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
  %ld = load <2 x i32>, ptr addrspace(1) %in
  %ext = sext <2 x i32> %ld to <2 x i64>
  store <2 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_zextload_v4i32_to_v4i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_zextload_v4i32_to_v4i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v5, 0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v7, v5
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v4, v2
; SI-NOHSA-NEXT:    v_mov_b32_e32 v6, v3
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v4, v0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v6, v1
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_zextload_v4i32_to_v4i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v7, v5
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s2
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, v2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v6, v3
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; GCNX3-HSA-NEXT:    s_nop 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, v0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v6, v1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_zextload_v4i32_to_v4i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v5, 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v7, v5
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v4, v2
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v6, v3
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v4, v0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v6, v1
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_zextload_v4i32_to_v4i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 12, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MOV T1.X, T0.Z,
; EG-NEXT:     MOV T1.Y, 0.0,
; EG-NEXT:     MOV * T2.X, T0.X,
; EG-NEXT:     MOV T2.Y, 0.0,
; EG-NEXT:     MOV T1.Z, T0.W,
; EG-NEXT:     MOV T1.W, 0.0,
; EG-NEXT:     MOV * T2.Z, T0.Y,
; EG-NEXT:     MOV * T2.W, 0.0,
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR * T3.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_zextload_v4i32_to_v4i64:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[4:7], v1, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v6
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v7
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:16
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v4
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v5
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
  %ld = load <4 x i32>, ptr addrspace(1) %in
  %ext = zext <4 x i32> %ld to <4 x i64>
  store <4 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_sextload_v4i32_to_v4i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_sextload_v4i32_to_v4i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v6, 31, v1
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v4, 31, v0
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v10, 31, v3
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v8, 31, v2
; SI-NOHSA-NEXT:    v_mov_b32_e32 v7, v2
; SI-NOHSA-NEXT:    v_mov_b32_e32 v9, v3
; SI-NOHSA-NEXT:    v_mov_b32_e32 v3, v0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v5, v1
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[7:10], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[3:6], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_sextload_v4i32_to_v4i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v14, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v12, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v13, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v11, s0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v10, 31, v3
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v8, 31, v2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v7, v2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, v3
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v6, 31, v1
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v4, 31, v0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v3, v0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, v1
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[13:14], v[7:10]
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[11:12], v[3:6]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_sextload_v4i32_to_v4i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v10, 31, v3
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v8, 31, v2
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v7, v2
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v9, v3
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v6, 31, v1
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v4, 31, v0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v3, v0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v5, v1
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[7:10], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[3:6], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_sextload_v4i32_to_v4i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 15, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T0.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     ASHR * T1.W, T0.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T2.X, KC0[2].Y, literal.x,
; EG-NEXT:     ASHR T1.Y, T0.X, literal.y,
; EG-NEXT:     ASHR T3.W, T0.W, literal.y,
; EG-NEXT:     MOV * T1.X, T0.X,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
; EG-NEXT:     ASHR * T3.Y, T0.Z, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T3.X, T0.Z,
; EG-NEXT:     MOV T1.Z, T0.Y,
; EG-NEXT:     ADD_INT * T2.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PV.W, literal.x,
; EG-NEXT:     MOV * T3.Z, T0.W,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_sextload_v4i32_to_v4i64:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v11, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[0:3], v11, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v10, 31, v3
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v8, 31, v2
; GCN-HSA-NEXT:    v_mov_b32_e32 v7, v2
; GCN-HSA-NEXT:    v_mov_b32_e32 v9, v3
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v6, 31, v1
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v4, 31, v0
; GCN-HSA-NEXT:    v_mov_b32_e32 v3, v0
; GCN-HSA-NEXT:    v_mov_b32_e32 v5, v1
; GCN-HSA-NEXT:    global_store_dwordx4 v11, v[7:10], s[0:1] offset:16
; GCN-HSA-NEXT:    global_store_dwordx4 v11, v[3:6], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
  %ld = load <4 x i32>, ptr addrspace(1) %in
  %ext = sext <4 x i32> %ld to <4 x i64>
  store <4 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_zextload_v8i32_to_v8i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_zextload_v8i32_to_v8i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v9, 0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v11, v9
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v8, v2
; SI-NOHSA-NEXT:    v_mov_b32_e32 v10, v3
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0 offset:48
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v8, v0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v10, v1
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0 offset:32
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2) expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v8, v6
; SI-NOHSA-NEXT:    v_mov_b32_e32 v10, v7
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v8, v4
; SI-NOHSA-NEXT:    v_mov_b32_e32 v10, v5
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_zextload_v8i32_to_v8i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v11, v9
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    s_add_u32 s2, s2, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v15, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v14, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 48
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v13, s1
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v12, s0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v17, s3
; GCNX3-HSA-NEXT:    s_add_u32 s0, s0, 32
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, s2
; GCNX3-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(1)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, v2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v10, v3
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[14:15], v[8:11]
; GCNX3-HSA-NEXT:    s_nop 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, v0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v10, v1
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[12:13], v[8:11]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, v6
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v10, v7
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[16:17], v[8:11]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, v4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v10, v5
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[8:11]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_zextload_v8i32_to_v8i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v9, 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v11, v9
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v8, v2
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v10, v3
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0 offset:48
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v8, v0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v10, v1
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v8, v6
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v10, v7
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v8, v4
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v10, v5
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_zextload_v8i32_to_v8i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @8
; EG-NEXT:    ALU 26, @13, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T7.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T6.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T5.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 13:
; EG-NEXT:     MOV T2.X, T1.Z,
; EG-NEXT:     MOV T2.Y, 0.0,
; EG-NEXT:     MOV * T3.X, T1.X,
; EG-NEXT:     MOV * T3.Y, 0.0,
; EG-NEXT:     MOV T4.X, T0.Z,
; EG-NEXT:     MOV T4.Y, 0.0,
; EG-NEXT:     MOV * T5.X, T0.X,
; EG-NEXT:     MOV T5.Y, 0.0,
; EG-NEXT:     MOV T2.Z, T1.W,
; EG-NEXT:     MOV T2.W, 0.0,
; EG-NEXT:     MOV * T3.Z, T1.Y,
; EG-NEXT:     MOV * T3.W, 0.0,
; EG-NEXT:     MOV T4.Z, T0.W,
; EG-NEXT:     MOV T4.W, 0.0,
; EG-NEXT:     MOV * T5.Z, T0.Y,
; EG-NEXT:     MOV * T5.W, 0.0,
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T1.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T6.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR * T7.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_zextload_v8i32_to_v8i64:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[4:7], v1, s[2:3] offset:16
; GCN-HSA-NEXT:    global_load_dwordx4 v[8:11], v1, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(1)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v6
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v7
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:48
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v4
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v5
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:32
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v10
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v11
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:16
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v8
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v9
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
  %ld = load <8 x i32>, ptr addrspace(1) %in
  %ext = zext <8 x i32> %ld to <8 x i64>
  store <8 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_sextload_v8i32_to_v8i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_sextload_v8i32_to_v8i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v10, 31, v1
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v8, 31, v0
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v14, 31, v3
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v12, 31, v2
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v18, 31, v5
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v16, 31, v4
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v22, 31, v7
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v20, 31, v6
; SI-NOHSA-NEXT:    v_mov_b32_e32 v19, v6
; SI-NOHSA-NEXT:    v_mov_b32_e32 v21, v7
; SI-NOHSA-NEXT:    v_mov_b32_e32 v15, v4
; SI-NOHSA-NEXT:    v_mov_b32_e32 v17, v5
; SI-NOHSA-NEXT:    v_mov_b32_e32 v11, v2
; SI-NOHSA-NEXT:    v_mov_b32_e32 v13, v3
; SI-NOHSA-NEXT:    v_mov_b32_e32 v7, v0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v9, v1
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[19:22], off, s[4:7], 0 offset:48
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[15:18], off, s[4:7], 0 offset:32
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[11:14], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[7:10], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_sextload_v8i32_to_v8i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    s_add_u32 s2, s2, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v19, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v18, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 48
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v17, s1
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, s0
; GCNX3-HSA-NEXT:    s_add_u32 s0, s0, 32
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v21, s3
; GCNX3-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v20, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v23, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v22, s0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(1)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v11, 31, v1
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v9, 31, v0
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v15, 31, v3
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v13, 31, v2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v12, v2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v14, v3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, v0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v10, v1
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[18:19], v[12:15]
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[16:17], v[8:11]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v3, 31, v5
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v11, 31, v7
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v9, 31, v6
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, v6
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v10, v7
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v5
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[20:21], v[8:11]
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[22:23], v[0:3]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_sextload_v8i32_to_v8i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s2, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s3
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s7
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_mov_b32 s0, s4
; GCNX3-NOHSA-NEXT:    s_mov_b32 s1, s5
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v10, 31, v1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v22, 31, v7
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v20, 31, v6
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v19, v6
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v21, v7
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v8, 31, v0
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v14, 31, v3
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v12, 31, v2
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v18, 31, v5
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v16, 31, v4
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v15, v4
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v17, v5
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v11, v2
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v13, v3
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v7, v0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v9, v1
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[19:22], off, s[0:3], 0 offset:48
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[15:18], off, s[0:3], 0 offset:32
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[11:14], off, s[0:3], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[7:10], off, s[0:3], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_sextload_v8i32_to_v8i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @8
; EG-NEXT:    ALU 31, @13, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T8.XYZW, T0.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T6.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 13:
; EG-NEXT:     LSHR T2.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T2.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT T2.W, KC0[2].Y, literal.y,
; EG-NEXT:     ASHR * T4.W, T0.Y, literal.z,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T5.X, PV.W, literal.x,
; EG-NEXT:     ASHR T4.Y, T0.X, literal.y,
; EG-NEXT:     ASHR T6.W, T0.W, literal.y,
; EG-NEXT:     MOV * T4.X, T0.X,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
; EG-NEXT:     ASHR T6.Y, T0.Z, literal.x,
; EG-NEXT:     ASHR * T7.W, T1.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T6.X, T0.Z,
; EG-NEXT:     ASHR T7.Y, T1.X, literal.x,
; EG-NEXT:     MOV T4.Z, T0.Y,
; EG-NEXT:     ASHR T8.W, T1.W, literal.x,
; EG-NEXT:     MOV * T7.X, T1.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T8.Y, T1.Z, literal.x,
; EG-NEXT:     MOV * T6.Z, T0.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T8.X, T1.Z,
; EG-NEXT:     MOV T7.Z, T1.Y,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PV.W, literal.x,
; EG-NEXT:     MOV * T8.Z, T1.W,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_sextload_v8i32_to_v8i64:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v23, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[0:3], v23, s[2:3]
; GCN-HSA-NEXT:    global_load_dwordx4 v[4:7], v23, s[2:3] offset:16
; GCN-HSA-NEXT:    s_waitcnt vmcnt(1)
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v10, 31, v1
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v22, 31, v7
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v20, 31, v6
; GCN-HSA-NEXT:    v_mov_b32_e32 v19, v6
; GCN-HSA-NEXT:    v_mov_b32_e32 v21, v7
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v8, 31, v0
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v14, 31, v3
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v12, 31, v2
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v18, 31, v5
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v16, 31, v4
; GCN-HSA-NEXT:    v_mov_b32_e32 v15, v4
; GCN-HSA-NEXT:    v_mov_b32_e32 v17, v5
; GCN-HSA-NEXT:    v_mov_b32_e32 v11, v2
; GCN-HSA-NEXT:    v_mov_b32_e32 v13, v3
; GCN-HSA-NEXT:    v_mov_b32_e32 v7, v0
; GCN-HSA-NEXT:    v_mov_b32_e32 v9, v1
; GCN-HSA-NEXT:    global_store_dwordx4 v23, v[19:22], s[0:1] offset:48
; GCN-HSA-NEXT:    global_store_dwordx4 v23, v[15:18], s[0:1] offset:32
; GCN-HSA-NEXT:    global_store_dwordx4 v23, v[11:14], s[0:1] offset:16
; GCN-HSA-NEXT:    global_store_dwordx4 v23, v[7:10], s[0:1]
; GCN-HSA-NEXT:    s_endpgm
  %ld = load <8 x i32>, ptr addrspace(1) %in
  %ext = sext <8 x i32> %ld to <8 x i64>
  store <8 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_sextload_v16i32_to_v16i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_sextload_v16i32_to_v16i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s2, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s2
; SI-NOHSA-NEXT:    s_mov_b32 s11, s3
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s6
; SI-NOHSA-NEXT:    s_mov_b32 s9, s7
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:48
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v19, 31, v3
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v17, 31, v2
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v23, 31, v1
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v21, 31, v0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v20, v0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v22, v1
; SI-NOHSA-NEXT:    v_mov_b32_e32 v16, v2
; SI-NOHSA-NEXT:    v_mov_b32_e32 v18, v3
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v3, 31, v7
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v6
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v27, 31, v5
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v25, 31, v4
; SI-NOHSA-NEXT:    v_mov_b32_e32 v24, v4
; SI-NOHSA-NEXT:    v_mov_b32_e32 v26, v5
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v6
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v7
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v7, 31, v11
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v5, 31, v10
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v31, 31, v9
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v29, 31, v8
; SI-NOHSA-NEXT:    v_mov_b32_e32 v28, v8
; SI-NOHSA-NEXT:    v_mov_b32_e32 v30, v9
; SI-NOHSA-NEXT:    v_mov_b32_e32 v4, v10
; SI-NOHSA-NEXT:    v_mov_b32_e32 v6, v11
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v11, 31, v15
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v9, 31, v14
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v35, 31, v13
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v33, 31, v12
; SI-NOHSA-NEXT:    v_mov_b32_e32 v32, v12
; SI-NOHSA-NEXT:    v_mov_b32_e32 v34, v13
; SI-NOHSA-NEXT:    v_mov_b32_e32 v8, v14
; SI-NOHSA-NEXT:    v_mov_b32_e32 v10, v15
; SI-NOHSA-NEXT:    s_mov_b32 s0, s4
; SI-NOHSA-NEXT:    s_mov_b32 s1, s5
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[20:23], off, s[0:3], 0 offset:96
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[0:3], 0 offset:112
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[24:27], off, s[0:3], 0 offset:64
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:80
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:32
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:48
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[32:35], off, s[0:3], 0
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:16
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_sextload_v16i32_to_v16i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[8:11], v[0:1]
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 48
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 32
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[12:15], v[0:1]
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GCNX3-HSA-NEXT:    s_add_u32 s2, s2, 16
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[0:1]
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v23, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v22, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x60
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v25, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v24, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x70
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v27, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v21, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v26, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 64
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v20, s0
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v19, 31, v9
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v17, 31, v8
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, v8
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v18, v9
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[20:21], v[16:19]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v21, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v20, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x50
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v29, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v28, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 32
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v19, 31, v11
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v17, 31, v10
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, v10
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v18, v11
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[22:23], v[16:19]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(4)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v11, 31, v15
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v9, 31, v14
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v19, 31, v13
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v17, 31, v12
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, v12
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v18, v13
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, v14
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v10, v15
; GCNX3-HSA-NEXT:    s_add_u32 s0, s0, 48
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v23, s3
; GCNX3-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[24:25], v[16:19]
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[26:27], v[8:11]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(5)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v15, 31, v5
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v11, 31, v7
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v9, 31, v6
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v13, 31, v4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v12, v4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v14, v5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, v6
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v10, v7
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v22, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v31, s1
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[20:21], v[12:15]
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[28:29], v[8:11]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v30, s0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(6)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v11, 31, v1
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v9, 31, v0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, v0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v10, v1
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v7, 31, v3
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v5, 31, v2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, v2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v6, v3
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[22:23], v[8:11]
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[30:31], v[4:7]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_sextload_v16i32_to_v16i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s2, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s3
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s7
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:48
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s0, s4
; GCNX3-NOHSA-NEXT:    s_mov_b32 s1, s5
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v19, 31, v3
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v27, 31, v5
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v25, 31, v4
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v24, v4
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v26, v5
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v17, 31, v2
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v23, 31, v7
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v21, 31, v6
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v20, v6
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v22, v7
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v7, 31, v1
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v5, 31, v0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v4, v0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v6, v1
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v16, v2
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v18, v3
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v3, 31, v11
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v10
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v31, 31, v9
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v29, 31, v8
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v8
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v9
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v0, v10
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v2, v11
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v11, 31, v15
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v9, 31, v14
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v35, 31, v13
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v33, 31, v12
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v32, v12
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v34, v13
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v8, v14
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v10, v15
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[24:27], off, s[0:3], 0 offset:96
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[20:23], off, s[0:3], 0 offset:112
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:64
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[0:3], 0 offset:80
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:32
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:48
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[32:35], off, s[0:3], 0
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_sextload_v16i32_to_v16i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @20, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 3 @12
; EG-NEXT:    ALU 64, @21, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T16.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T11.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T15.XYZW, T9.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T8.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T14.XYZW, T7.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T13.XYZW, T6.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T12.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T10.XYZW, T4.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 12:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 48, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T0.X, 32, #1
; EG-NEXT:     VTX_READ_128 T3.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 20:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 21:
; EG-NEXT:     ADD_INT * T4.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T4.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T5.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T4.W, KC0[2].Y, literal.x,
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T6.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T4.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T7.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T4.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T8.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T4.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T9.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT T4.W, KC0[2].Y, literal.y,
; EG-NEXT:     ASHR * T10.W, T0.W, literal.z,
; EG-NEXT:    2(2.802597e-45), 112(1.569454e-43)
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T11.X, PV.W, literal.x,
; EG-NEXT:     ASHR T10.Y, T0.Z, literal.y,
; EG-NEXT:     ASHR T12.W, T0.Y, literal.y,
; EG-NEXT:     MOV * T10.X, T0.Z,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
; EG-NEXT:     ASHR T12.Y, T0.X, literal.x,
; EG-NEXT:     ASHR * T13.W, T3.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T12.X, T0.X,
; EG-NEXT:     ASHR T13.Y, T3.Z, literal.x,
; EG-NEXT:     MOV T10.Z, T0.W,
; EG-NEXT:     ASHR T14.W, T3.Y, literal.x,
; EG-NEXT:     MOV * T13.X, T3.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T14.Y, T3.X, literal.x,
; EG-NEXT:     MOV T12.Z, T0.Y,
; EG-NEXT:     ASHR * T0.W, T2.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T14.X, T3.X,
; EG-NEXT:     ASHR T0.Y, T2.Z, literal.x,
; EG-NEXT:     MOV T13.Z, T3.W,
; EG-NEXT:     ASHR T15.W, T2.Y, literal.x,
; EG-NEXT:     MOV * T0.X, T2.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T15.Y, T2.X, literal.x,
; EG-NEXT:     MOV T14.Z, T3.Y,
; EG-NEXT:     ASHR * T3.W, T1.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T15.X, T2.X,
; EG-NEXT:     ASHR T3.Y, T1.Z, literal.x,
; EG-NEXT:     MOV T0.Z, T2.W,
; EG-NEXT:     ASHR T16.W, T1.Y, literal.x,
; EG-NEXT:     MOV * T3.X, T1.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T16.Y, T1.X, literal.x,
; EG-NEXT:     MOV * T15.Z, T2.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T16.X, T1.X,
; EG-NEXT:     MOV T3.Z, T1.W,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    96(1.345247e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T1.X, PV.W, literal.x,
; EG-NEXT:     MOV * T16.Z, T1.Y,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_sextload_v16i32_to_v16i64:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v36, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[0:3], v36, s[2:3] offset:32
; GCN-HSA-NEXT:    global_load_dwordx4 v[4:7], v36, s[2:3] offset:48
; GCN-HSA-NEXT:    global_load_dwordx4 v[8:11], v36, s[2:3] offset:16
; GCN-HSA-NEXT:    global_load_dwordx4 v[12:15], v36, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v19, 31, v3
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v27, 31, v5
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v25, 31, v4
; GCN-HSA-NEXT:    v_mov_b32_e32 v24, v4
; GCN-HSA-NEXT:    v_mov_b32_e32 v26, v5
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v17, 31, v2
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v23, 31, v7
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v21, 31, v6
; GCN-HSA-NEXT:    v_mov_b32_e32 v20, v6
; GCN-HSA-NEXT:    v_mov_b32_e32 v22, v7
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v7, 31, v1
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v5, 31, v0
; GCN-HSA-NEXT:    v_mov_b32_e32 v4, v0
; GCN-HSA-NEXT:    v_mov_b32_e32 v6, v1
; GCN-HSA-NEXT:    v_mov_b32_e32 v16, v2
; GCN-HSA-NEXT:    v_mov_b32_e32 v18, v3
; GCN-HSA-NEXT:    s_waitcnt vmcnt(1)
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v3, 31, v11
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v10
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v31, 31, v9
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v29, 31, v8
; GCN-HSA-NEXT:    v_mov_b32_e32 v28, v8
; GCN-HSA-NEXT:    v_mov_b32_e32 v30, v9
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v10
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v11
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v11, 31, v15
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v9, 31, v14
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v35, 31, v13
; GCN-HSA-NEXT:    v_ashrrev_i32_e32 v33, 31, v12
; GCN-HSA-NEXT:    v_mov_b32_e32 v32, v12
; GCN-HSA-NEXT:    v_mov_b32_e32 v34, v13
; GCN-HSA-NEXT:    v_mov_b32_e32 v8, v14
; GCN-HSA-NEXT:    v_mov_b32_e32 v10, v15
; GCN-HSA-NEXT:    global_store_dwordx4 v36, v[24:27], s[0:1] offset:96
; GCN-HSA-NEXT:    global_store_dwordx4 v36, v[20:23], s[0:1] offset:112
; GCN-HSA-NEXT:    global_store_dwordx4 v36, v[4:7], s[0:1] offset:64
; GCN-HSA-NEXT:    global_store_dwordx4 v36, v[16:19], s[0:1] offset:80
; GCN-HSA-NEXT:    global_store_dwordx4 v36, v[28:31], s[0:1] offset:32
; GCN-HSA-NEXT:    global_store_dwordx4 v36, v[0:3], s[0:1] offset:48
; GCN-HSA-NEXT:    global_store_dwordx4 v36, v[32:35], s[0:1]
; GCN-HSA-NEXT:    global_store_dwordx4 v36, v[8:11], s[0:1] offset:16
; GCN-HSA-NEXT:    s_endpgm
  %ld = load <16 x i32>, ptr addrspace(1) %in
  %ext = sext <16 x i32> %ld to <16 x i64>
  store <16 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_zextload_v16i32_to_v16i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_zextload_v16i32_to_v16i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s2, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s2
; SI-NOHSA-NEXT:    s_mov_b32 s11, s3
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s6
; SI-NOHSA-NEXT:    s_mov_b32 s9, s7
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:48
; SI-NOHSA-NEXT:    v_mov_b32_e32 v5, 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    v_mov_b32_e32 v7, v5
; SI-NOHSA-NEXT:    s_mov_b32 s0, s4
; SI-NOHSA-NEXT:    s_mov_b32 s1, s5
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[16:19], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v4, v0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v6, v1
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:96
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v4, v2
; SI-NOHSA-NEXT:    v_mov_b32_e32 v6, v3
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:112
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(4) expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v4, v8
; SI-NOHSA-NEXT:    v_mov_b32_e32 v6, v9
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:64
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v4, v10
; SI-NOHSA-NEXT:    v_mov_b32_e32 v6, v11
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:80
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(4) expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v4, v16
; SI-NOHSA-NEXT:    v_mov_b32_e32 v6, v17
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:32
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v4, v18
; SI-NOHSA-NEXT:    v_mov_b32_e32 v6, v19
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:48
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v4, v12
; SI-NOHSA-NEXT:    v_mov_b32_e32 v6, v13
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v4, v14
; SI-NOHSA-NEXT:    v_mov_b32_e32 v6, v15
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_zextload_v16i32_to_v16i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v17, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v19, v17
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    s_add_u32 s6, s2, 32
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    s_addc_u32 s7, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    s_add_u32 s2, s2, 48
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s7
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s6
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[8:11], v[8:9]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v13, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v12, s4
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[12:15], v[12:13]
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v23, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v22, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x60
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v25, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v24, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x70
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v27, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v21, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v26, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 64
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v20, s0
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, v0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v18, v1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[20:21], v[16:19]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x50
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, v2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v18, v3
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[22:23], v[16:19]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v3, s3
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(4)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, v4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v18, v5
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 32
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[24:25], v[16:19]
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, v6
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v18, v7
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[26:27], v[16:19]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v21, s3
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(5)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, v8
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v18, v9
; GCNX3-HSA-NEXT:    s_add_u32 s0, s0, 48
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[16:19]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v20, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, v10
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v18, v11
; GCNX3-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[2:3], v[16:19]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(6)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, v12
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v18, v13
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[20:21], v[16:19]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, v14
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v18, v15
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[16:19]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_zextload_v16i32_to_v16i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s2, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s3
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s7
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:48
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v17, 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v19, v17
; GCNX3-NOHSA-NEXT:    s_mov_b32 s0, s4
; GCNX3-NOHSA-NEXT:    s_mov_b32 s1, s5
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v16, v0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v18, v1
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[0:3], 0 offset:96
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v16, v2
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v18, v3
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[0:3], 0 offset:112
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(4)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v16, v4
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v18, v5
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[0:3], 0 offset:64
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v16, v6
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v18, v7
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[0:3], 0 offset:80
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(5)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v16, v8
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v18, v9
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[0:3], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v16, v10
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v18, v11
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[0:3], 0 offset:48
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(6)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v16, v12
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v18, v13
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[0:3], 0
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v16, v14
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v18, v15
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[0:3], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_zextload_v16i32_to_v16i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @20, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 3 @12
; EG-NEXT:    ALU 55, @21, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T15.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T5.XYZW, T14.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T6.XYZW, T13.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T12.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T8.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T9.XYZW, T2.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T10.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T11.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 12:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 48, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T0.X, 0, #1
; EG-NEXT:     VTX_READ_128 T3.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 32, #1
; EG-NEXT:    ALU clause starting at 20:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 21:
; EG-NEXT:     MOV T4.X, T1.X,
; EG-NEXT:     MOV T4.Y, 0.0,
; EG-NEXT:     MOV * T5.X, T1.Z,
; EG-NEXT:     MOV * T5.Y, 0.0,
; EG-NEXT:     MOV T6.X, T0.X,
; EG-NEXT:     MOV T6.Y, 0.0,
; EG-NEXT:     MOV * T7.X, T0.Z,
; EG-NEXT:     MOV * T7.Y, 0.0,
; EG-NEXT:     MOV T8.X, T3.X,
; EG-NEXT:     MOV T8.Y, 0.0,
; EG-NEXT:     MOV * T9.X, T3.Z,
; EG-NEXT:     MOV * T9.Y, 0.0,
; EG-NEXT:     MOV T10.X, T2.X,
; EG-NEXT:     MOV T10.Y, 0.0,
; EG-NEXT:     MOV * T11.X, T2.Z,
; EG-NEXT:     MOV T11.Y, 0.0,
; EG-NEXT:     MOV T4.Z, T1.Y,
; EG-NEXT:     MOV T4.W, 0.0,
; EG-NEXT:     MOV * T5.Z, T1.W,
; EG-NEXT:     MOV * T5.W, 0.0,
; EG-NEXT:     MOV T6.Z, T0.Y,
; EG-NEXT:     MOV T6.W, 0.0,
; EG-NEXT:     MOV * T7.Z, T0.W,
; EG-NEXT:     MOV * T7.W, 0.0,
; EG-NEXT:     MOV T8.Z, T3.Y,
; EG-NEXT:     MOV T8.W, 0.0,
; EG-NEXT:     MOV * T9.Z, T3.W,
; EG-NEXT:     MOV * T9.W, 0.0,
; EG-NEXT:     MOV T10.Z, T2.Y,
; EG-NEXT:     MOV T10.W, 0.0,
; EG-NEXT:     MOV * T11.Z, T2.W,
; EG-NEXT:     MOV T11.W, 0.0,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PS, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T2.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T12.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T13.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 112(1.569454e-43)
; EG-NEXT:     LSHR T14.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 96(1.345247e-43)
; EG-NEXT:     LSHR * T15.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_zextload_v16i32_to_v16i64:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[4:7], v1, s[2:3] offset:48
; GCN-HSA-NEXT:    global_load_dwordx4 v[8:11], v1, s[2:3] offset:32
; GCN-HSA-NEXT:    global_load_dwordx4 v[12:15], v1, s[2:3] offset:16
; GCN-HSA-NEXT:    global_load_dwordx4 v[16:19], v1, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v4
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v5
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:96
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v6
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v7
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:112
; GCN-HSA-NEXT:    s_waitcnt vmcnt(4)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v8
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v9
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:64
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v10
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v11
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:80
; GCN-HSA-NEXT:    s_waitcnt vmcnt(5)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v12
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v13
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:32
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v14
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v15
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:48
; GCN-HSA-NEXT:    s_waitcnt vmcnt(6)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v16
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v17
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1]
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v18
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v19
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:16
; GCN-HSA-NEXT:    s_endpgm
  %ld = load <16 x i32>, ptr addrspace(1) %in
  %ext = zext <16 x i32> %ld to <16 x i64>
  store <16 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_sextload_v32i32_to_v32i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_sextload_v32i32_to_v32i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; SI-NOHSA-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; SI-NOHSA-NEXT:    s_mov_b32 s14, -1
; SI-NOHSA-NEXT:    s_mov_b32 s15, 0xe8f000
; SI-NOHSA-NEXT:    s_add_u32 s12, s12, s9
; SI-NOHSA-NEXT:    s_addc_u32 s13, s13, 0
; SI-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s2, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s2
; SI-NOHSA-NEXT:    s_mov_b32 s11, s3
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s6
; SI-NOHSA-NEXT:    s_mov_b32 s9, s7
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[28:31], off, s[8:11], 0 offset:96
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0 offset:112
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:80
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:64
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[16:19], off, s[8:11], 0 offset:48
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[20:23], off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[24:27], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(7)
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v47, 31, v31
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v45, 31, v30
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(6)
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v39, 31, v15
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v37, 31, v14
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v43, 31, v13
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v41, 31, v12
; SI-NOHSA-NEXT:    v_mov_b32_e32 v40, v12
; SI-NOHSA-NEXT:    v_mov_b32_e32 v42, v13
; SI-NOHSA-NEXT:    v_mov_b32_e32 v36, v14
; SI-NOHSA-NEXT:    v_mov_b32_e32 v38, v15
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v35, 31, v29
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v33, 31, v28
; SI-NOHSA-NEXT:    v_mov_b32_e32 v32, v28
; SI-NOHSA-NEXT:    v_mov_b32_e32 v34, v29
; SI-NOHSA-NEXT:    v_mov_b32_e32 v44, v30
; SI-NOHSA-NEXT:    v_mov_b32_e32 v46, v31
; SI-NOHSA-NEXT:    buffer_store_dword v44, off, s[12:15], 0 ; 4-byte Folded Spill
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_store_dword v45, off, s[12:15], 0 offset:4 ; 4-byte Folded Spill
; SI-NOHSA-NEXT:    buffer_store_dword v46, off, s[12:15], 0 offset:8 ; 4-byte Folded Spill
; SI-NOHSA-NEXT:    buffer_store_dword v47, off, s[12:15], 0 offset:12 ; 4-byte Folded Spill
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v15, 31, v7
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v13, 31, v6
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v47, 31, v5
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v45, 31, v4
; SI-NOHSA-NEXT:    v_mov_b32_e32 v44, v4
; SI-NOHSA-NEXT:    v_mov_b32_e32 v46, v5
; SI-NOHSA-NEXT:    v_mov_b32_e32 v12, v6
; SI-NOHSA-NEXT:    v_mov_b32_e32 v14, v7
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v7, 31, v3
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v5, 31, v2
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v51, 31, v1
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v49, 31, v0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v48, v0
; SI-NOHSA-NEXT:    v_mov_b32_e32 v50, v1
; SI-NOHSA-NEXT:    v_mov_b32_e32 v4, v2
; SI-NOHSA-NEXT:    v_mov_b32_e32 v6, v3
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v3, 31, v19
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v18
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v55, 31, v17
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v53, 31, v16
; SI-NOHSA-NEXT:    v_mov_b32_e32 v52, v16
; SI-NOHSA-NEXT:    v_mov_b32_e32 v54, v17
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v18
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v19
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v19, 31, v23
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v17, 31, v22
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v59, 31, v21
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v57, 31, v20
; SI-NOHSA-NEXT:    v_mov_b32_e32 v56, v20
; SI-NOHSA-NEXT:    v_mov_b32_e32 v58, v21
; SI-NOHSA-NEXT:    v_mov_b32_e32 v16, v22
; SI-NOHSA-NEXT:    v_mov_b32_e32 v18, v23
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v23, 31, v27
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v21, 31, v26
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v63, 31, v25
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v61, 31, v24
; SI-NOHSA-NEXT:    v_mov_b32_e32 v60, v24
; SI-NOHSA-NEXT:    v_mov_b32_e32 v62, v25
; SI-NOHSA-NEXT:    v_mov_b32_e32 v20, v26
; SI-NOHSA-NEXT:    v_mov_b32_e32 v22, v27
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v27, 31, v11
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v25, 31, v10
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v31, 31, v9
; SI-NOHSA-NEXT:    v_ashrrev_i32_e32 v29, 31, v8
; SI-NOHSA-NEXT:    v_mov_b32_e32 v28, v8
; SI-NOHSA-NEXT:    v_mov_b32_e32 v30, v9
; SI-NOHSA-NEXT:    v_mov_b32_e32 v24, v10
; SI-NOHSA-NEXT:    v_mov_b32_e32 v26, v11
; SI-NOHSA-NEXT:    s_mov_b32 s0, s4
; SI-NOHSA-NEXT:    s_mov_b32 s1, s5
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[40:43], off, s[0:3], 0 offset:224
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[36:39], off, s[0:3], 0 offset:240
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[32:35], off, s[0:3], 0 offset:192
; SI-NOHSA-NEXT:    buffer_load_dword v8, off, s[12:15], 0 ; 4-byte Folded Reload
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_load_dword v9, off, s[12:15], 0 offset:4 ; 4-byte Folded Reload
; SI-NOHSA-NEXT:    buffer_load_dword v10, off, s[12:15], 0 offset:8 ; 4-byte Folded Reload
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_load_dword v11, off, s[12:15], 0 offset:12 ; 4-byte Folded Reload
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:208
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[44:47], off, s[0:3], 0 offset:160
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:176
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[48:51], off, s[0:3], 0 offset:128
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:144
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[52:55], off, s[0:3], 0 offset:96
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:112
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[56:59], off, s[0:3], 0 offset:64
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[0:3], 0 offset:80
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[60:63], off, s[0:3], 0 offset:32
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[20:23], off, s[0:3], 0 offset:48
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[24:27], off, s[0:3], 0 offset:16
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_sextload_v32i32_to_v32i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[28:31], v[0:1]
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 0x70
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[24:27], v[0:1]
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 0x60
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 0x50
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[20:23], v[0:1]
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 64
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[12:15], v[0:1]
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[0:1]
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 48
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s4
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[16:19], v[8:9]
; GCNX3-HSA-NEXT:    s_add_u32 s6, s2, 32
; GCNX3-HSA-NEXT:    s_addc_u32 s7, s3, 0
; GCNX3-HSA-NEXT:    s_add_u32 s2, s2, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s7
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s6
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[8:11], v[8:9]
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v37, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v36, s0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v35, 31, v29
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v33, 31, v28
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v32, v28
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v34, v29
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v29, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v28, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0xe0
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[36:37], v[32:35]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v37, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v36, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0xf0
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v35, 31, v31
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v33, 31, v30
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v32, v30
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v34, v31
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[28:29], v[32:35]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(8)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v31, 31, v25
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v33, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v32, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0xc0
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v35, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v34, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0xd0
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v29, 31, v24
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v28, v24
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v30, v25
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[36:37], v[28:31]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v37, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v36, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0xa0
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v31, 31, v27
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v29, 31, v26
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v28, v26
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v30, v27
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[32:33], v[28:31]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v33, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v32, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0xb0
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v39, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v38, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x80
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(9)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v27, 31, v21
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v25, 31, v20
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v24, v20
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v26, v21
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v31, 31, v23
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v29, 31, v22
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v28, v22
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v30, v23
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[34:35], v[24:27]
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[36:37], v[28:31]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(10)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v23, 31, v15
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v21, 31, v14
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v27, 31, v13
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v25, 31, v12
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v24, v12
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v26, v13
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v20, v14
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v22, v15
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(9)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v15, 31, v5
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v13, 31, v4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v12, v4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v14, v5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x90
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[32:33], v[24:27]
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[38:39], v[20:23]
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[12:15]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x60
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v26, 31, v7
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v24, 31, v6
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v23, v6
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v25, v7
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[23:26]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(12)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v5, 31, v16
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, v16
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v15, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x70
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v7, 31, v17
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v6, v17
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[15:16], v[4:7]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v15, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 64
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v26, 31, v19
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v24, 31, v18
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v23, v18
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v25, v19
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[15:16], v[23:26]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(12)
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v18, 31, v9
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v16, 31, v8
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v15, v8
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v17, v9
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x50
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[8:9], v[15:18]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 32
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v14, 31, v1
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v12, 31, v0
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v7, 31, v11
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v6, v11
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v11, v0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v13, v1
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    s_add_u32 s0, s0, 48
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[11:14]
; GCNX3-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v22, 31, v3
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v20, 31, v2
; GCNX3-HSA-NEXT:    v_ashrrev_i32_e32 v5, 31, v10
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, v10
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v19, v2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v21, v3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[19:22]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_sextload_v32i32_to_v32i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s2, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s3
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s7
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:96
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0 offset:112
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:80
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:64
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[16:19], off, s[8:11], 0 offset:48
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[20:23], off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[24:27], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[28:31], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_mov_b32 s0, s4
; GCNX3-NOHSA-NEXT:    s_mov_b32 s1, s5
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v35, 31, v11
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v33, 31, v10
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(6)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v39, 31, v15
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v37, 31, v14
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v43, 31, v13
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v41, 31, v12
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v40, v12
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v42, v13
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v36, v14
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v38, v15
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v15, 31, v9
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v13, 31, v8
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v12, v8
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v14, v9
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v32, v10
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v34, v11
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(5)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v11, 31, v7
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v9, 31, v6
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v47, 31, v5
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v45, 31, v4
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v44, v4
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v46, v5
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v8, v6
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v10, v7
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(4)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v7, 31, v3
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v5, 31, v2
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v4, v2
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v6, v3
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v3, 31, v19
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v2, v19
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v19, 31, v23
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v51, 31, v1
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v49, 31, v0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v48, v0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v50, v1
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v18
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v55, 31, v17
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v53, 31, v16
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v52, v16
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v54, v17
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v0, v18
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v17, 31, v22
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v59, 31, v21
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v57, 31, v20
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v56, v20
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v58, v21
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v16, v22
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v18, v23
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v22, 31, v27
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v20, 31, v26
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[40:43], off, s[0:3], 0 offset:224
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[36:39], off, s[0:3], 0 offset:240
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v42, 31, v25
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v40, 31, v24
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v38, 31, v31
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v36, 31, v30
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:192
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v37, v31
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v15, 31, v29
; GCNX3-NOHSA-NEXT:    v_ashrrev_i32_e32 v13, 31, v28
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v12, v28
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v14, v29
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[32:35], off, s[0:3], 0 offset:208
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[44:47], off, s[0:3], 0 offset:160
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:176
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[48:51], off, s[0:3], 0 offset:128
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:144
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[52:55], off, s[0:3], 0 offset:96
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:112
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[56:59], off, s[0:3], 0 offset:64
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[0:3], 0 offset:80
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:32
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v35, v30
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v39, v24
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v41, v25
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v19, v26
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v21, v27
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[35:38], off, s[0:3], 0 offset:48
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[39:42], off, s[0:3], 0
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[19:22], off, s[0:3], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_sextload_v32i32_to_v32i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 33, @36, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 7 @20
; EG-NEXT:    ALU 96, @70, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T32.XYZW, T12.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T14.XYZW, T23.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T31.XYZW, T21.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T15.XYZW, T20.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T30.XYZW, T19.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T16.XYZW, T10.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T29.XYZW, T9.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T17.XYZW, T8.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T28.XYZW, T7.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T18.XYZW, T6.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T27.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T11.XYZW, T4.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T26.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T25.XYZW, T2.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T24.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T22.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 20:
; EG-NEXT:     VTX_READ_128 T12.XYZW, T11.X, 112, #1
; EG-NEXT:     VTX_READ_128 T13.XYZW, T11.X, 96, #1
; EG-NEXT:     VTX_READ_128 T14.XYZW, T11.X, 80, #1
; EG-NEXT:     VTX_READ_128 T15.XYZW, T11.X, 64, #1
; EG-NEXT:     VTX_READ_128 T16.XYZW, T11.X, 48, #1
; EG-NEXT:     VTX_READ_128 T17.XYZW, T11.X, 32, #1
; EG-NEXT:     VTX_READ_128 T18.XYZW, T11.X, 16, #1
; EG-NEXT:     VTX_READ_128 T11.XYZW, T11.X, 0, #1
; EG-NEXT:    ALU clause starting at 36:
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T2.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T4.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T5.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 112(1.569454e-43)
; EG-NEXT:     LSHR T6.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 96(1.345247e-43)
; EG-NEXT:     LSHR T7.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 144(2.017870e-43)
; EG-NEXT:     LSHR T8.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 128(1.793662e-43)
; EG-NEXT:     LSHR T9.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 176(2.466285e-43)
; EG-NEXT:     LSHR T10.X, PV.W, literal.x,
; EG-NEXT:     MOV * T11.X, KC0[2].Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 70:
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    160(2.242078e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T19.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 208(2.914701e-43)
; EG-NEXT:     LSHR T20.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 192(2.690493e-43)
; EG-NEXT:     LSHR T21.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT T0.W, KC0[2].Y, literal.y,
; EG-NEXT:     ASHR * T22.W, T11.W, literal.z,
; EG-NEXT:    2(2.802597e-45), 240(3.363116e-43)
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T23.X, PV.W, literal.x,
; EG-NEXT:     ASHR T22.Y, T11.Z, literal.y,
; EG-NEXT:     ASHR T24.W, T11.Y, literal.y,
; EG-NEXT:     MOV * T22.X, T11.Z,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
; EG-NEXT:     ASHR T24.Y, T11.X, literal.x,
; EG-NEXT:     ASHR * T25.W, T18.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T24.X, T11.X,
; EG-NEXT:     ASHR T25.Y, T18.Z, literal.x,
; EG-NEXT:     MOV T22.Z, T11.W,
; EG-NEXT:     ASHR T26.W, T18.Y, literal.x,
; EG-NEXT:     MOV * T25.X, T18.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T26.Y, T18.X, literal.x,
; EG-NEXT:     MOV T24.Z, T11.Y,
; EG-NEXT:     ASHR * T11.W, T17.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T26.X, T18.X,
; EG-NEXT:     ASHR T11.Y, T17.Z, literal.x,
; EG-NEXT:     MOV T25.Z, T18.W,
; EG-NEXT:     ASHR T27.W, T17.Y, literal.x,
; EG-NEXT:     MOV * T11.X, T17.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T27.Y, T17.X, literal.x,
; EG-NEXT:     MOV T26.Z, T18.Y,
; EG-NEXT:     ASHR * T18.W, T16.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T27.X, T17.X,
; EG-NEXT:     ASHR T18.Y, T16.Z, literal.x,
; EG-NEXT:     MOV T11.Z, T17.W,
; EG-NEXT:     ASHR T28.W, T16.Y, literal.x,
; EG-NEXT:     MOV * T18.X, T16.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T28.Y, T16.X, literal.x,
; EG-NEXT:     MOV T27.Z, T17.Y,
; EG-NEXT:     ASHR * T17.W, T15.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T28.X, T16.X,
; EG-NEXT:     ASHR T17.Y, T15.Z, literal.x,
; EG-NEXT:     MOV T18.Z, T16.W,
; EG-NEXT:     ASHR T29.W, T15.Y, literal.x,
; EG-NEXT:     MOV * T17.X, T15.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T29.Y, T15.X, literal.x,
; EG-NEXT:     MOV T28.Z, T16.Y,
; EG-NEXT:     ASHR * T16.W, T14.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T29.X, T15.X,
; EG-NEXT:     ASHR T16.Y, T14.Z, literal.x,
; EG-NEXT:     MOV T17.Z, T15.W,
; EG-NEXT:     ASHR T30.W, T14.Y, literal.x,
; EG-NEXT:     MOV * T16.X, T14.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T30.Y, T14.X, literal.x,
; EG-NEXT:     MOV T29.Z, T15.Y,
; EG-NEXT:     ASHR * T15.W, T13.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T30.X, T14.X,
; EG-NEXT:     ASHR T15.Y, T13.Z, literal.x,
; EG-NEXT:     MOV T16.Z, T14.W,
; EG-NEXT:     ASHR T31.W, T13.Y, literal.x,
; EG-NEXT:     MOV * T15.X, T13.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T31.Y, T13.X, literal.x,
; EG-NEXT:     MOV T30.Z, T14.Y,
; EG-NEXT:     ASHR * T14.W, T12.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T31.X, T13.X,
; EG-NEXT:     ASHR T14.Y, T12.Z, literal.x,
; EG-NEXT:     MOV T15.Z, T13.W,
; EG-NEXT:     ASHR T32.W, T12.Y, literal.x,
; EG-NEXT:     MOV * T14.X, T12.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T32.Y, T12.X, literal.x,
; EG-NEXT:     MOV * T31.Z, T13.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T32.X, T12.X,
; EG-NEXT:     MOV T14.Z, T12.W,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    224(3.138909e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T12.X, PV.W, literal.x,
; EG-NEXT:     MOV * T32.Z, T12.Y,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-GFX900-HSA-LABEL: global_sextload_v32i32_to_v32i64:
; GCN-GFX900-HSA:       ; %bb.0:
; GCN-GFX900-HSA-NEXT:    s_mov_b64 s[18:19], s[2:3]
; GCN-GFX900-HSA-NEXT:    s_mov_b64 s[16:17], s[0:1]
; GCN-GFX900-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v8, 0
; GCN-GFX900-HSA-NEXT:    s_add_u32 s16, s16, s13
; GCN-GFX900-HSA-NEXT:    s_addc_u32 s17, s17, 0
; GCN-GFX900-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-GFX900-HSA-NEXT:    global_load_dwordx4 v[0:3], v8, s[2:3] offset:96
; GCN-GFX900-HSA-NEXT:    global_load_dwordx4 v[4:7], v8, s[2:3] offset:112
; GCN-GFX900-HSA-NEXT:    global_load_dwordx4 v[9:12], v8, s[2:3] offset:80
; GCN-GFX900-HSA-NEXT:    global_load_dwordx4 v[13:16], v8, s[2:3] offset:64
; GCN-GFX900-HSA-NEXT:    global_load_dwordx4 v[17:20], v8, s[2:3] offset:48
; GCN-GFX900-HSA-NEXT:    global_load_dwordx4 v[21:24], v8, s[2:3] offset:32
; GCN-GFX900-HSA-NEXT:    s_waitcnt vmcnt(5)
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v28, 31, v3
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v26, 31, v2
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v25, v2
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v27, v3
; GCN-GFX900-HSA-NEXT:    s_waitcnt vmcnt(4)
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v32, 31, v7
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v30, 31, v6
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v36, 31, v5
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v34, 31, v4
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v33, v4
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v35, v5
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v29, v6
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v31, v7
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v7, 31, v1
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v5, 31, v0
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v4, v0
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v6, v1
; GCN-GFX900-HSA-NEXT:    buffer_store_dword v25, off, s[16:19], 0 ; 4-byte Folded Spill
; GCN-GFX900-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-GFX900-HSA-NEXT:    buffer_store_dword v26, off, s[16:19], 0 offset:4 ; 4-byte Folded Spill
; GCN-GFX900-HSA-NEXT:    buffer_store_dword v27, off, s[16:19], 0 offset:8 ; 4-byte Folded Spill
; GCN-GFX900-HSA-NEXT:    buffer_store_dword v28, off, s[16:19], 0 offset:12 ; 4-byte Folded Spill
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v28, 31, v12
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v26, 31, v11
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v40, 31, v10
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v38, 31, v9
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v37, v9
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v39, v10
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v25, v11
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v27, v12
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v12, 31, v16
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v10, 31, v15
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v44, 31, v14
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v42, 31, v13
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v41, v13
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v43, v14
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v9, v15
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v11, v16
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v16, 31, v20
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v14, 31, v19
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v48, 31, v18
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v46, 31, v17
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v45, v17
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v47, v18
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v13, v19
; GCN-GFX900-HSA-NEXT:    global_load_dwordx4 v[49:52], v8, s[2:3] offset:16
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v15, v20
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v20, 31, v24
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v18, 31, v23
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v56, 31, v22
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v54, 31, v21
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v53, v21
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v55, v22
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v17, v23
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v19, v24
; GCN-GFX900-HSA-NEXT:    global_load_dwordx4 v[21:24], v8, s[2:3]
; GCN-GFX900-HSA-NEXT:    s_nop 0
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[33:36], s[0:1] offset:224
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[29:32], s[0:1] offset:240
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] offset:192
; GCN-GFX900-HSA-NEXT:    buffer_load_dword v32, off, s[16:19], 0 ; 4-byte Folded Reload
; GCN-GFX900-HSA-NEXT:    s_nop 0
; GCN-GFX900-HSA-NEXT:    buffer_load_dword v33, off, s[16:19], 0 offset:4 ; 4-byte Folded Reload
; GCN-GFX900-HSA-NEXT:    buffer_load_dword v34, off, s[16:19], 0 offset:8 ; 4-byte Folded Reload
; GCN-GFX900-HSA-NEXT:    buffer_load_dword v35, off, s[16:19], 0 offset:12 ; 4-byte Folded Reload
; GCN-GFX900-HSA-NEXT:    s_waitcnt vmcnt(8)
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v60, 31, v52
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v58, 31, v51
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v3, 31, v50
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v49
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v0, v49
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v2, v50
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v57, v51
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v59, v52
; GCN-GFX900-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v31, 31, v24
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v29, 31, v23
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v7, 31, v22
; GCN-GFX900-HSA-NEXT:    v_ashrrev_i32_e32 v5, 31, v21
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v4, v21
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v6, v22
; GCN-GFX900-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[32:35], s[0:1] offset:208
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[37:40], s[0:1] offset:160
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[25:28], s[0:1] offset:176
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[41:44], s[0:1] offset:128
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[9:12], s[0:1] offset:144
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[45:48], s[0:1] offset:96
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[13:16], s[0:1] offset:112
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[53:56], s[0:1] offset:64
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[17:20], s[0:1] offset:80
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] offset:32
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[57:60], s[0:1] offset:48
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1]
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v28, v23
; GCN-GFX900-HSA-NEXT:    v_mov_b32_e32 v30, v24
; GCN-GFX900-HSA-NEXT:    global_store_dwordx4 v8, v[28:31], s[0:1] offset:16
; GCN-GFX900-HSA-NEXT:    s_endpgm
;
; GCN-GFX908-HSA-LABEL: global_sextload_v32i32_to_v32i64:
; GCN-GFX908-HSA:       ; %bb.0:
; GCN-GFX908-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v8, 0
; GCN-GFX908-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-GFX908-HSA-NEXT:    global_load_dwordx4 v[0:3], v8, s[2:3] offset:96
; GCN-GFX908-HSA-NEXT:    global_load_dwordx4 v[4:7], v8, s[2:3] offset:112
; GCN-GFX908-HSA-NEXT:    global_load_dwordx4 v[9:12], v8, s[2:3] offset:80
; GCN-GFX908-HSA-NEXT:    global_load_dwordx4 v[13:16], v8, s[2:3] offset:64
; GCN-GFX908-HSA-NEXT:    global_load_dwordx4 v[17:20], v8, s[2:3] offset:48
; GCN-GFX908-HSA-NEXT:    global_load_dwordx4 v[21:24], v8, s[2:3] offset:32
; GCN-GFX908-HSA-NEXT:    global_load_dwordx4 v[49:52], v8, s[2:3] offset:16
; GCN-GFX908-HSA-NEXT:    s_waitcnt vmcnt(6)
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v25, v2
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v28, 31, v3
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v26, 31, v2
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v27, v3
; GCN-GFX908-HSA-NEXT:    v_accvgpr_write_b32 a0, v25
; GCN-GFX908-HSA-NEXT:    v_accvgpr_write_b32 a1, v26
; GCN-GFX908-HSA-NEXT:    v_accvgpr_write_b32 a2, v27
; GCN-GFX908-HSA-NEXT:    v_accvgpr_write_b32 a3, v28
; GCN-GFX908-HSA-NEXT:    s_waitcnt vmcnt(4)
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v28, 31, v12
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v26, 31, v11
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v40, 31, v10
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v38, 31, v9
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v37, v9
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v39, v10
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v25, v11
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v27, v12
; GCN-GFX908-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v12, 31, v16
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v10, 31, v15
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v44, 31, v14
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v42, 31, v13
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v41, v13
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v43, v14
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v9, v15
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v11, v16
; GCN-GFX908-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v16, 31, v20
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v14, 31, v19
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v48, 31, v18
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v46, 31, v17
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v45, v17
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v47, v18
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v13, v19
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v15, v20
; GCN-GFX908-HSA-NEXT:    s_waitcnt vmcnt(1)
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v20, 31, v24
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v18, 31, v23
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v56, 31, v22
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v54, 31, v21
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v53, v21
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v55, v22
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v17, v23
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v19, v24
; GCN-GFX908-HSA-NEXT:    global_load_dwordx4 v[21:24], v8, s[2:3]
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v32, 31, v7
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v36, 31, v5
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v34, 31, v4
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v33, v4
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v35, v5
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v30, 31, v6
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v29, v6
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v31, v7
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[33:36], s[0:1] offset:224
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[29:32], s[0:1] offset:240
; GCN-GFX908-HSA-NEXT:    v_accvgpr_read_b32 v35, a3
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v7, 31, v1
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v5, 31, v0
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v4, v0
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v6, v1
; GCN-GFX908-HSA-NEXT:    v_accvgpr_read_b32 v34, a2
; GCN-GFX908-HSA-NEXT:    v_accvgpr_read_b32 v33, a1
; GCN-GFX908-HSA-NEXT:    v_accvgpr_read_b32 v32, a0
; GCN-GFX908-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v60, 31, v52
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v58, 31, v51
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v3, 31, v50
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v1, 31, v49
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v0, v49
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v2, v50
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v57, v51
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v59, v52
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] offset:192
; GCN-GFX908-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v31, 31, v24
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v29, 31, v23
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v7, 31, v22
; GCN-GFX908-HSA-NEXT:    v_ashrrev_i32_e32 v5, 31, v21
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v4, v21
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v6, v22
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[32:35], s[0:1] offset:208
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[37:40], s[0:1] offset:160
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[25:28], s[0:1] offset:176
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[41:44], s[0:1] offset:128
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[9:12], s[0:1] offset:144
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[45:48], s[0:1] offset:96
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[13:16], s[0:1] offset:112
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[53:56], s[0:1] offset:64
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[17:20], s[0:1] offset:80
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] offset:32
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[57:60], s[0:1] offset:48
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1]
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v28, v23
; GCN-GFX908-HSA-NEXT:    v_mov_b32_e32 v30, v24
; GCN-GFX908-HSA-NEXT:    global_store_dwordx4 v8, v[28:31], s[0:1] offset:16
; GCN-GFX908-HSA-NEXT:    s_endpgm
  %ld = load <32 x i32>, ptr addrspace(1) %in
  %ext = sext <32 x i32> %ld to <32 x i64>
  store <32 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_zextload_v32i32_to_v32i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_zextload_v32i32_to_v32i64:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s2, -1
; SI-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; SI-NOHSA-NEXT:    s_mov_b32 s10, s2
; SI-NOHSA-NEXT:    s_mov_b32 s11, s3
; SI-NOHSA-NEXT:    v_mov_b32_e32 v3, v1
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s6
; SI-NOHSA-NEXT:    s_mov_b32 s9, s7
; SI-NOHSA-NEXT:    s_mov_b32 s0, s4
; SI-NOHSA-NEXT:    s_mov_b32 s1, s5
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:112
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:96
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[16:19], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[20:23], off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[24:27], off, s[8:11], 0 offset:48
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(5)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v4
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v5
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[28:31], off, s[8:11], 0 offset:64
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[32:35], off, s[8:11], 0 offset:80
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:224
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v6
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v7
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:240
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(8) expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v8
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v9
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:192
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v10
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v11
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:208
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(4) expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v32
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v33
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:160
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v34
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v35
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:176
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v28
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v29
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:128
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v30
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v31
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:144
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v24
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v25
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:96
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v26
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v27
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:112
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v20
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v21
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:64
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v22
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v23
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:80
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v16
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v17
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:32
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v18
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v19
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:48
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v12
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v13
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NOHSA-NEXT:    s_waitcnt expcnt(0)
; SI-NOHSA-NEXT:    v_mov_b32_e32 v0, v14
; SI-NOHSA-NEXT:    v_mov_b32_e32 v2, v15
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_zextload_v32i32_to_v32i64:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    s_add_u32 s6, s2, 32
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    s_addc_u32 s7, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    s_add_u32 s8, s2, 48
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[28:31], v[0:1]
; GCNX3-HSA-NEXT:    s_addc_u32 s9, s3, 0
; GCNX3-HSA-NEXT:    s_add_u32 s10, s2, 64
; GCNX3-HSA-NEXT:    s_addc_u32 s11, s3, 0
; GCNX3-HSA-NEXT:    s_add_u32 s12, s2, 0x50
; GCNX3-HSA-NEXT:    s_addc_u32 s13, s3, 0
; GCNX3-HSA-NEXT:    s_add_u32 s14, s2, 0x60
; GCNX3-HSA-NEXT:    s_addc_u32 s15, s3, 0
; GCNX3-HSA-NEXT:    s_add_u32 s2, s2, 0x70
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[32:35], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s14
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s15
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[24:27], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s13
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[20:23], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s10
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s11
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[16:19], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s9
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[12:15], v[0:1]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s7
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s6
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[8:11], v[8:9]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v28
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v29
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v29, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v28, s0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[28:29], v[0:3]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v29, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v28, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0xe0
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v30
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v31
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v31, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v30, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0xf0
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[28:29], v[0:3]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v29, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v28, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0xc0
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(8)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v32
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v33
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[30:31], v[0:3]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v31, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v30, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0xd0
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v33, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v32, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0xa0
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v34
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v35
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v35, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v34, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0xb0
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[28:29], v[0:3]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v29, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v28, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x80
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(9)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v24
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v25
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v25, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v24, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x90
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[30:31], v[0:3]
; GCNX3-HSA-NEXT:    s_nop 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v26
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v27
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v27, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v26, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x60
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[32:33], v[0:3]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v31, s3
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(10)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v20
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v21
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[34:35], v[0:3]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v30, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v22
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v23
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x70
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[28:29], v[0:3]
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(11)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v16
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v17
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[24:25], v[0:3]
; GCNX3-HSA-NEXT:    s_nop 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v18
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v19
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[26:27], v[0:3]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(12)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v12
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v13
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v13, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v12, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 64
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[30:31], v[0:3]
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v14
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v15
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(12)
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v8
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v9
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x50
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s2
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 32
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v10
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v11
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GCNX3-HSA-NEXT:    s_add_u32 s0, s0, 48
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCNX3-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, v6
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, v7
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_zextload_v32i32_to_v32i64:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s2, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s3
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s7
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:112
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:96
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:80
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0 offset:64
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[16:19], off, s[8:11], 0 offset:48
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[20:23], off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[24:27], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[32:35], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v29, 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v31, v29
; GCNX3-NOHSA-NEXT:    s_mov_b32 s0, s4
; GCNX3-NOHSA-NEXT:    s_mov_b32 s1, s5
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v1
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:224
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v2
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v3
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:240
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(8)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v4
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v5
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:192
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v6
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v7
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:208
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(9)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v8
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v9
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:160
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v10
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v11
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:176
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(10)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v12
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v13
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:128
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v14
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v15
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:144
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(11)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v16
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v17
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:96
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v18
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v19
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:112
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(12)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v20
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v21
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:64
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v22
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v23
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:80
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(13)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v24
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v25
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v26
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v27
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:48
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(14)
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v32
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v33
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0
; GCNX3-NOHSA-NEXT:    s_nop 0
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v28, v34
; GCNX3-NOHSA-NEXT:    v_mov_b32_e32 v30, v35
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[0:3], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_zextload_v32i32_to_v32i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @38, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 2 @22
; EG-NEXT:    ALU 10, @39, KC0[], KC1[]
; EG-NEXT:    TEX 4 @28
; EG-NEXT:    ALU 100, @50, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T31.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T5.XYZW, T30.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T6.XYZW, T29.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T28.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T8.XYZW, T27.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T9.XYZW, T26.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T14.XYZW, T25.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T15.XYZW, T24.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T16.XYZW, T13.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T17.XYZW, T12.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T18.XYZW, T11.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T19.XYZW, T10.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T20.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T21.XYZW, T2.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T22.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T23.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 22:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 112, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T0.X, 80, #1
; EG-NEXT:     VTX_READ_128 T3.XYZW, T0.X, 96, #1
; EG-NEXT:    Fetch clause starting at 28:
; EG-NEXT:     VTX_READ_128 T10.XYZW, T0.X, 0, #1
; EG-NEXT:     VTX_READ_128 T11.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T12.XYZW, T0.X, 32, #1
; EG-NEXT:     VTX_READ_128 T13.XYZW, T0.X, 48, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 64, #1
; EG-NEXT:    ALU clause starting at 38:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 39:
; EG-NEXT:     MOV T4.X, T1.X,
; EG-NEXT:     MOV T4.Y, 0.0,
; EG-NEXT:     MOV * T5.X, T1.Z,
; EG-NEXT:     MOV * T5.Y, 0.0,
; EG-NEXT:     MOV T6.X, T3.X,
; EG-NEXT:     MOV T6.Y, 0.0,
; EG-NEXT:     MOV * T7.X, T3.Z,
; EG-NEXT:     MOV * T7.Y, 0.0,
; EG-NEXT:     MOV T8.X, T2.X,
; EG-NEXT:     MOV T8.Y, 0.0,
; EG-NEXT:     MOV * T9.X, T2.Z,
; EG-NEXT:    ALU clause starting at 50:
; EG-NEXT:     MOV * T9.Y, 0.0,
; EG-NEXT:     MOV T14.X, T0.X,
; EG-NEXT:     MOV T14.Y, 0.0,
; EG-NEXT:     MOV * T15.X, T0.Z,
; EG-NEXT:     MOV * T15.Y, 0.0,
; EG-NEXT:     MOV T16.X, T13.X,
; EG-NEXT:     MOV T16.Y, 0.0,
; EG-NEXT:     MOV * T17.X, T13.Z,
; EG-NEXT:     MOV * T17.Y, 0.0,
; EG-NEXT:     MOV T18.X, T12.X,
; EG-NEXT:     MOV T18.Y, 0.0,
; EG-NEXT:     MOV * T19.X, T12.Z,
; EG-NEXT:     MOV * T19.Y, 0.0,
; EG-NEXT:     MOV T20.X, T11.X,
; EG-NEXT:     MOV T20.Y, 0.0,
; EG-NEXT:     MOV * T21.X, T11.Z,
; EG-NEXT:     MOV * T21.Y, 0.0,
; EG-NEXT:     MOV T22.X, T10.X,
; EG-NEXT:     MOV T22.Y, 0.0,
; EG-NEXT:     MOV * T23.X, T10.Z,
; EG-NEXT:     MOV T23.Y, 0.0,
; EG-NEXT:     MOV T4.Z, T1.Y,
; EG-NEXT:     MOV T4.W, 0.0,
; EG-NEXT:     MOV * T5.Z, T1.W,
; EG-NEXT:     MOV * T5.W, 0.0,
; EG-NEXT:     MOV T6.Z, T3.Y,
; EG-NEXT:     MOV T6.W, 0.0,
; EG-NEXT:     MOV * T7.Z, T3.W,
; EG-NEXT:     MOV * T7.W, 0.0,
; EG-NEXT:     MOV T8.Z, T2.Y,
; EG-NEXT:     MOV T8.W, 0.0,
; EG-NEXT:     MOV * T9.Z, T2.W,
; EG-NEXT:     MOV * T9.W, 0.0,
; EG-NEXT:     MOV T14.Z, T0.Y,
; EG-NEXT:     MOV T14.W, 0.0,
; EG-NEXT:     MOV * T15.Z, T0.W,
; EG-NEXT:     MOV * T15.W, 0.0,
; EG-NEXT:     MOV T16.Z, T13.Y,
; EG-NEXT:     MOV T16.W, 0.0,
; EG-NEXT:     MOV * T17.Z, T13.W,
; EG-NEXT:     MOV * T17.W, 0.0,
; EG-NEXT:     MOV T18.Z, T12.Y,
; EG-NEXT:     MOV T18.W, 0.0,
; EG-NEXT:     MOV * T19.Z, T12.W,
; EG-NEXT:     MOV * T19.W, 0.0,
; EG-NEXT:     MOV T20.Z, T11.Y,
; EG-NEXT:     MOV T20.W, 0.0,
; EG-NEXT:     MOV * T21.Z, T11.W,
; EG-NEXT:     MOV * T21.W, 0.0,
; EG-NEXT:     MOV T22.Z, T10.Y,
; EG-NEXT:     MOV T22.W, 0.0,
; EG-NEXT:     MOV * T23.Z, T10.W,
; EG-NEXT:     MOV T23.W, 0.0,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PS, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T2.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T10.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T11.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 112(1.569454e-43)
; EG-NEXT:     LSHR T12.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 96(1.345247e-43)
; EG-NEXT:     LSHR T13.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 144(2.017870e-43)
; EG-NEXT:     LSHR T24.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 128(1.793662e-43)
; EG-NEXT:     LSHR T25.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 176(2.466285e-43)
; EG-NEXT:     LSHR T26.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 160(2.242078e-43)
; EG-NEXT:     LSHR T27.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 208(2.914701e-43)
; EG-NEXT:     LSHR T28.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 192(2.690493e-43)
; EG-NEXT:     LSHR T29.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 240(3.363116e-43)
; EG-NEXT:     LSHR T30.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 224(3.138909e-43)
; EG-NEXT:     LSHR * T31.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_zextload_v32i32_to_v32i64:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[4:7], v1, s[2:3] offset:112
; GCN-HSA-NEXT:    global_load_dwordx4 v[8:11], v1, s[2:3] offset:96
; GCN-HSA-NEXT:    global_load_dwordx4 v[12:15], v1, s[2:3] offset:80
; GCN-HSA-NEXT:    global_load_dwordx4 v[16:19], v1, s[2:3] offset:64
; GCN-HSA-NEXT:    global_load_dwordx4 v[20:23], v1, s[2:3] offset:48
; GCN-HSA-NEXT:    global_load_dwordx4 v[24:27], v1, s[2:3] offset:32
; GCN-HSA-NEXT:    global_load_dwordx4 v[28:31], v1, s[2:3] offset:16
; GCN-HSA-NEXT:    global_load_dwordx4 v[32:35], v1, s[2:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v4
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v5
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:224
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v6
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v7
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:240
; GCN-HSA-NEXT:    s_waitcnt vmcnt(8)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v8
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v9
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:192
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v10
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v11
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:208
; GCN-HSA-NEXT:    s_waitcnt vmcnt(9)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v12
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v13
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:160
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v14
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v15
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:176
; GCN-HSA-NEXT:    s_waitcnt vmcnt(10)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v16
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v17
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:128
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v18
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v19
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:144
; GCN-HSA-NEXT:    s_waitcnt vmcnt(11)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v20
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v21
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:96
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v22
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v23
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:112
; GCN-HSA-NEXT:    s_waitcnt vmcnt(12)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v24
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v25
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:64
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v26
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v27
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:80
; GCN-HSA-NEXT:    s_waitcnt vmcnt(13)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v28
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v29
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:32
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v30
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v31
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:48
; GCN-HSA-NEXT:    s_waitcnt vmcnt(14)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v32
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v33
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1]
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, v34
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, v35
; GCN-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:16
; GCN-HSA-NEXT:    s_endpgm
  %ld = load <32 x i32>, ptr addrspace(1) %in
  %ext = zext <32 x i32> %ld to <32 x i64>
  store <32 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v32i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v32i32:
; SI-NOHSA:       ; %bb.0:
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:112
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0 offset:96
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[16:19], off, s[8:11], 0 offset:80
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[20:23], off, s[8:11], 0 offset:64
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[24:27], off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[28:31], off, s[8:11], 0 offset:48
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(4)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[4:7], 0 offset:96
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0 offset:112
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(4)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[20:23], off, s[4:7], 0 offset:64
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[4:7], 0 offset:80
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(5)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[24:27], off, s[4:7], 0 offset:32
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(5)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[4:7], 0 offset:48
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_endpgm
;
; GCNX3-HSA-LABEL: global_load_v32i32:
; GCNX3-HSA:       ; %bb.0:
; GCNX3-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCNX3-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    s_add_u32 s6, s2, 48
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v29, s5
; GCNX3-HSA-NEXT:    s_addc_u32 s7, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v28, s4
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 32
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s4
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 0x50
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v13, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v12, s4
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 64
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v17, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v16, s4
; GCNX3-HSA-NEXT:    s_add_u32 s4, s2, 0x70
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s6
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s7
; GCNX3-HSA-NEXT:    s_add_u32 s2, s2, 0x60
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[8:11], v[8:9]
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v21, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v25, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v20, s4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v24, s2
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[12:15], v[12:13]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[16:19], v[16:17]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[20:23], v[20:21]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[24:27], v[24:25]
; GCNX3-HSA-NEXT:    flat_load_dwordx4 v[28:31], v[28:29]
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 0x60
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v33, s1
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v32, s0
; GCNX3-HSA-NEXT:    s_add_u32 s4, s0, 0x70
; GCNX3-HSA-NEXT:    s_addc_u32 s5, s1, 0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[32:33], v[0:3]
; GCNX3-HSA-NEXT:    s_nop 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCNX3-HSA-NEXT:    s_add_u32 s2, s0, 64
; GCNX3-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCNX3-HSA-NEXT:    s_add_u32 s6, s0, 0x50
; GCNX3-HSA-NEXT:    s_addc_u32 s7, s1, 0
; GCNX3-HSA-NEXT:    s_add_u32 s8, s0, 32
; GCNX3-HSA-NEXT:    s_addc_u32 s9, s1, 0
; GCNX3-HSA-NEXT:    s_add_u32 s10, s0, 48
; GCNX3-HSA-NEXT:    s_addc_u32 s11, s1, 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, s10
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v3, s11
; GCNX3-HSA-NEXT:    s_add_u32 s0, s0, 16
; GCNX3-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[2:3], v[4:7]
; GCNX3-HSA-NEXT:    s_nop 0
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v6, s8
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v7, s9
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[6:7], v[8:11]
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v6, s6
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v2, s4
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v7, s7
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v9, s1
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v3, s5
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCNX3-HSA-NEXT:    v_mov_b32_e32 v8, s0
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[6:7], v[12:15]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[16:19]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[2:3], v[20:23]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[24:27]
; GCNX3-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-HSA-NEXT:    flat_store_dwordx4 v[8:9], v[28:31]
; GCNX3-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v32i32:
; GCNX3-NOHSA:       ; %bb.0:
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:112
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:96
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:80
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0 offset:64
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[16:19], off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[20:23], off, s[8:11], 0 offset:48
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[24:27], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[28:31], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(6)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:96
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0 offset:112
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(6)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[4:7], 0 offset:64
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0 offset:80
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[4:7], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[20:23], off, s[4:7], 0 offset:48
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[24:27], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(7)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[28:31], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: global_load_v32i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 23, @28, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 7 @12
; EG-NEXT:    ALU 1, @52, KC0[], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T8.XYZW, T15.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T9.XYZW, T6.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T10.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T11.XYZW, T4.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T12.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T13.XYZW, T2.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T14.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 12:
; EG-NEXT:     VTX_READ_128 T8.XYZW, T7.X, 96, #1
; EG-NEXT:     VTX_READ_128 T9.XYZW, T7.X, 112, #1
; EG-NEXT:     VTX_READ_128 T10.XYZW, T7.X, 64, #1
; EG-NEXT:     VTX_READ_128 T11.XYZW, T7.X, 80, #1
; EG-NEXT:     VTX_READ_128 T12.XYZW, T7.X, 32, #1
; EG-NEXT:     VTX_READ_128 T13.XYZW, T7.X, 48, #1
; EG-NEXT:     VTX_READ_128 T14.XYZW, T7.X, 0, #1
; EG-NEXT:     VTX_READ_128 T7.XYZW, T7.X, 16, #1
; EG-NEXT:    ALU clause starting at 28:
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T2.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T4.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T5.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 112(1.569454e-43)
; EG-NEXT:     LSHR T6.X, PV.W, literal.x,
; EG-NEXT:     MOV * T7.X, KC0[2].Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    96(1.345247e-43), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 52:
; EG-NEXT:     LSHR * T15.X, T0.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GCN-HSA-LABEL: global_load_v32i32:
; GCN-HSA:       ; %bb.0:
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GCN-HSA-NEXT:    v_mov_b32_e32 v32, 0
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    global_load_dwordx4 v[0:3], v32, s[2:3] offset:96
; GCN-HSA-NEXT:    global_load_dwordx4 v[4:7], v32, s[2:3] offset:112
; GCN-HSA-NEXT:    global_load_dwordx4 v[8:11], v32, s[2:3] offset:64
; GCN-HSA-NEXT:    global_load_dwordx4 v[12:15], v32, s[2:3] offset:80
; GCN-HSA-NEXT:    global_load_dwordx4 v[16:19], v32, s[2:3] offset:32
; GCN-HSA-NEXT:    global_load_dwordx4 v[20:23], v32, s[2:3] offset:48
; GCN-HSA-NEXT:    global_load_dwordx4 v[24:27], v32, s[2:3]
; GCN-HSA-NEXT:    global_load_dwordx4 v[28:31], v32, s[2:3] offset:16
; GCN-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCN-HSA-NEXT:    global_store_dwordx4 v32, v[0:3], s[0:1] offset:96
; GCN-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCN-HSA-NEXT:    global_store_dwordx4 v32, v[4:7], s[0:1] offset:112
; GCN-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCN-HSA-NEXT:    global_store_dwordx4 v32, v[8:11], s[0:1] offset:64
; GCN-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCN-HSA-NEXT:    global_store_dwordx4 v32, v[12:15], s[0:1] offset:80
; GCN-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCN-HSA-NEXT:    global_store_dwordx4 v32, v[16:19], s[0:1] offset:32
; GCN-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCN-HSA-NEXT:    global_store_dwordx4 v32, v[20:23], s[0:1] offset:48
; GCN-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCN-HSA-NEXT:    global_store_dwordx4 v32, v[24:27], s[0:1]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(7)
; GCN-HSA-NEXT:    global_store_dwordx4 v32, v[28:31], s[0:1] offset:16
; GCN-HSA-NEXT:    s_endpgm
  %ld = load <32 x i32>, ptr addrspace(1) %in
  store <32 x i32> %ld, ptr addrspace(1) %out
  ret void
}

attributes #0 = { nounwind }
