libconfini {#install}
=====================


Unix
----

On most Unix-like systems, you should be able to install **libconfini** using
the following common steps:

    ./configure
    make
    make install-strip

If the `strip` utility is not available on your machine, use `make install`
instead (it will produce larger binaries)

For a minimum installation without development files (i.e. static libraries,
headers, documentation, examples, etc.) use `./configure --disable-devel`. If
you only want to leave out man pages and examples, use `./configure
--disable-doc --disable-examples`.

If you need to customize the target directories, or otherwise adjust the build
setting, use

    ./configure --help

to list the configure options.

After running the `configure` script you can print the list of commonly used
targets by launching `make help`.

If the `configure` script is missing you need to generate it by running the
`bootstrap` script. Use the `--noconfigure` parameter to prevent `bootstrap`
from automatically running the `configure` script immediately after having
generated it. To list different options use `./bootstrap --help`.

If both the `configure` and `bootstrap` scripts are missing you can initialize
the build environment by launching the following commands from the source
directory:

    libtoolize
    aclocal
    automake --add-missing --copy --gnu
    autoconf
    ./configure

Or you can use a more modern approach and launch directly:

    mkdir m4
    autoreconf -i
    ./configure


Microsoft Windows
-----------------


### MinGW

If you are using Microsoft Windows, a batch script for compiling **libconfini**
with MinGW without GNU Make is available (`mgwmake.bat`). If you want instead
to compile the library manually, you can run:

    cd src
    windres.exe -i winres.rc -o winres.o
    gcc.exe -std=c99 -g -O3 -Wall -shared -static-libgcc -Wl,--no-undefined \
        -Wl,-out-implib,libconfini.lib -o libconfini.dll winres.o confini.c
    strip.exe libconfini.dll

If you want to generate also the `.def` file, use:

    cd src
    windres.exe -i winres.rc -o winres.o
    gcc -c -o confini.o confini.c
    dlltool.exe -z libconfini.def -D libconfini --export-all-symbols confini.o
    gcc.exe -std=c99 -g -O3 -Wall -shared -static-libgcc -Wl,--no-undefined \
        -Wl,-out-implib,libconfini.lib -o libconfini.dll confini.o winres.o
    strip.exe libconfini.dll

If you want to build (and install) **libconfini** via GNU Make under Microsoft
Windows several options are available, such as MinGW + MSYS, MSYS2 (which ships
[an official port][1] of the library, Cygwin (for which [an unofficial port][2]
of **libconfini** exists) and GnuWin32.


### Microsoft Visual Studio

To compile the library with Microsoft Visual Studio the `msvcmake.bat` batch
script is available (please make sure to run it with the right environment
variables). If you want instead to compile the library manually, you can run:

    cd src
    rc.exe winres.rc
    cl.exe /c /O2 confini.c
    link /DLL /DEF:libconfini.def /OUT:libconfini.dll winres.res confini.obj

To create a static library use instead:

    cd src
    rc.exe winres.rc
    cl.exe /c /O2 confini.c
    lib.exe /OUT:libconfini.lib winres.res confini.obj

In both cases, to test the library with a simple program named `my_test.c` you
can launch:

    cl.exe my_test.c /link libconfini.lib

The library is written in standard C99; however MSVC uses an exotic semantics
to access the `.data` segment of a shared library. Accordingly, after having
generated the DLL file, to access its global variables you will need to replace
all occurrences of the `extern` keyword with the special
`__declspec(dllimport)` keyword in the library's header included in your
program. This can be easily done using the C Preprocessor:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~{.c}
/*  my_test.c  */

#pragma push_macro("extern")
#undef extern
#define extern __declspec(dllimport)
#include <confini.h>
#pragma pop_macro("extern")
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

The code above will work if you are using the library in a C program. But, as
the macro will affect also the language-specific directive `extern "C"`, it
will not work under C++. In this last case you will have to edit the header by
hand and place the above macro inside `extern "C" { ... }`. This workaround is
not required with more standard-compliant compilers (GCC, Clang).


### Precompiled DLL

Often a compiled DLL [is available][3] among the assets of each release of the
library. The DLL asset usually contains a header file already sanitized for
Microsoft Visual Studio and a set of DLLs built using different optimizations
and compilers. Unless you used a C++ compiler for compiling the library (we
didn't and you shouldn't, the library is written in C99, not in C++), a binary
built with GCC (MinGW) will be linkable from a Microsoft Visual Studio project
(you may rename the `.dll.a` file extension to `.lib` for that).


Bare metal
----------

The library has almost everything implemented from scratch, with the only
notable exception of the I/O functions `load_ini_file()` and `load_ini_path()`,
which rely on C standard libraries. On some platforms, however, only a rather
exotic I/O API is available, while for some other platforms the C Standard
Library is simply too heavy or just not implementable.

In these situations it will be needed to get rid of every tie with the C
Standard Library and compile **libconfini** as "bare metal". The `configure`
script has two options for creating special forks of the original library able
to function in any environment, `--without-io-api` and `--without-libc`. For
information about how to proceed, please see `dev/hackings/baremetal/README.md`.


Comparison of different compilers
---------------------------------

In all the tests so far GCC always produced the fastest binary. Clang produced
a binary about 10% slower (with both `-O2` and `-O3`), whereas Microsoft Visual
Studio lay far behind.


Complex installations
---------------------

This package has been designed to be able to coexist with other major releases
of itself. However, when two versions share the same major number but have
different minor or revision numbers, only the most recent package must be
installed.

For two or more different major releases to be able to coexist, the major
number of each version must be appended to the package name it refers to, with
the possible exception of only one package (usually version 1.X.X). This can be
done easily by passing the `--with-other-versions` option to the `configure`
script:

    ./configure --with-other-versions

This will ensure **libconfini** X.Y.Z to be installed as **libconfiniX** X.Y.Z.

There are different views concerning which package name should be the only
unnumbered one. According to some conventions the major version number is
appended to the package names of all major version greater than one, while
according to other conventions the major version number is appended to the
package names of all versions that are older than the current version.

If you want to install a modified version of **libconfini** without generating
conflicts with an original version already present in the system, or you simply
want to install **libconfini** under a different name, you can use [Autoconf
transforming rules][4]. In particular, to prepend a prefix to the library name,
use `./configure --program-prefix=[PREFIX]`; to append a suffix, use
`./configure --program-suffix=[SUFFIX]`; to perform a `sed` substitution, use
`./configure --program-transform-name="s/[OLDTEXT]/[NEWTEXT]/[g]"`. Note that
the `lib` prefix at the beginning of the library name is always preserved (for
instance, `./configure --program-transform-name="s/^.*$/hello/"` will rename
the package to "libhello"). If you specify a prefix and/or a suffix together
with a `sed` substitution, the latter will be performed after the former have
been concatenated to the original name.

Do not use Autoconf transforming rules in place of the built-in `./configure
--with-other-versions` for appending the major version number to the name of
the package. If you do so, the header file will be installed as `confiniX.h`,
instead of the more standard `confini-X.h`.

For any issue, drop a message at https://github.com/madmurphy/libconfini/issues.


Distributing the source code
----------------------------

If you aim to re-distribute the source code of **libconfini** you should first
make sure that the `configure` script is present, for granting the possibility
to compile the package without having Autotools installed. If the `configure`
script is present and you have already launched it, use `make distclean` to
reset the configuration that this has created, or use `make dist` to build a
fresh archive that ignores the current configuration.


Distributing the compiled package
---------------------------------

Use `make binary-release` to create a binary package of **libconfini** for a
particular platform. If you want to obtain the list of the files that are going
to be installed, use `make manifest`.


  [1]: https://packages.msys2.org/base/mingw-w64-libconfini
  [2]: https://github.com/fd00/yacp/tree/master/libconfini
  [3]: https://github.com/madmurphy/libconfini/releases
  [4]: https://www.gnu.org/software/automake/manual/html_node/Renaming.html

