#
# @file    TestRDFAnnotation.py
# @brief   fomula units data unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Ben Bornstein
 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestRDFAnnotation.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml

def wrapString(s):
  return s
  pass


class TestRDFAnnotation(unittest.TestCase):

  global d
  d = None
  global m
  m = None

  def equals(self, *x):
    if len(x) == 2:
      return x[0] == x[1]
    elif len(x) == 1:
      return x[0] == self.OSS.str()

  def setUp(self):
    filename = "../../sbml/annotation/test/test-data/annotation.xml"
    self.d = libsbml.readSBML(filename)
    self.m = self.d.getModel()
    pass  

  def tearDown(self):
    self.d = None
    pass  

  def test_RDFAnnotation_delete(self):
    node = libsbml.RDFAnnotationParser.parseCVTerms(self.m.getCompartment(0))
    n1 = libsbml.RDFAnnotationParser.deleteRDFAnnotation(node)
    expected =  "<annotation/>";
    self.assertTrue( n1.getNumChildren() == 0 )
    self.assertTrue( n1.getName() ==  "annotation" )
    self.assertEqual( True, self.equals(expected,n1.toXMLString()) )
    node = None
    pass  

  def test_RDFAnnotation_deleteCVTerms(self):
    node = self.m.getCompartment(0).getAnnotation()
    n1 = None
    empty =  "<annotation/>";
    noRDF = wrapString("<annotation>\n"
"  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
    "    <jd2:header>\n"
 + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "    </jd2:header>\n"
 + 
    "  </jd2:JDesignerLayout>\n"
 + 
    "</annotation>")
    otherRDF = wrapString("<annotation>\n"
 + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "    <jd2:header>\n"
 + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "    </jd2:header>\n"
 + 
    "  </jd2:JDesignerLayout>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description>\n"
 + 
    "      <rdf:other/>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    n1 = libsbml.RDFAnnotationParser.deleteRDFCVTermAnnotation(None)
    self.assertTrue( n1 == None )
    n1 = libsbml.RDFAnnotationParser.deleteRDFCVTermAnnotation(node)
    self.assertTrue( n1.getNumChildren() == 0 )
    self.assertTrue( n1.getName() ==  "annotation" )
    self.assertEqual( True, self.equals(empty,n1.toXMLString()) )
    node = self.m.getCompartment(2).getAnnotation()
    n1 = libsbml.RDFAnnotationParser.deleteRDFCVTermAnnotation(node)
    self.assertEqual( True, self.equals(noRDF,n1.toXMLString()) )
    node = self.m.getCompartment(1).getAnnotation()
    n1 = libsbml.RDFAnnotationParser.deleteRDFCVTermAnnotation(node)
    self.assertEqual( True, self.equals(noRDF,n1.toXMLString()) )
    node = self.m.getCompartment(4).getAnnotation()
    n1 = libsbml.RDFAnnotationParser.deleteRDFCVTermAnnotation(node)
    self.assertEqual( True, self.equals(otherRDF,n1.toXMLString()) )
    node = libsbml.XMLNode.convertStringToXMLNode("<notannotatio/>")
    n1 = libsbml.RDFAnnotationParser.deleteRDFCVTermAnnotation(node)
    self.assertTrue( n1 == None )
    pass  

  def test_RDFAnnotation_deleteWithOther(self):
    c = self.m.getCompartment(1)
    node = libsbml.RDFAnnotationParser.deleteRDFAnnotation(c.getAnnotation())
    expected = wrapString("<annotation>\n" + "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "</annotation>")
    self.assertEqual( True, self.equals(expected,node.toXMLString()) )
    pass  

  def test_RDFAnnotation_deleteWithOtherRDF(self):
    c = self.m.getCompartment(5)
    node = c.getAnnotation()
    expected = wrapString("<annotation>\n"
"  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "    <jd2:header>\n"
 + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "    </jd2:header>\n"
 + 
    "  </jd2:JDesignerLayout>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description>\n"
 + 
    "      <rdf:other/>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    self.assertEqual( True, self.equals(expected,node.toXMLString()) )
    pass  

  def test_RDFAnnotation_deleteWithOutOther(self):
    c = self.m.getCompartment(2)
    node = c.getAnnotation()
    expected = wrapString("<annotation>\n" + "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "</annotation>")
    self.assertEqual( True, self.equals(expected,node.toXMLString()) )
    pass  

  def test_RDFAnnotation_getModelHistory(self):
    self.assertTrue( (self.m == None) == False )
    history = self.m.getModelHistory()
    self.assertTrue( history != None )
    mc = history.getCreator(0)
    self.assertTrue((  "Le Novere" == mc.getFamilyName() ))
    self.assertTrue((  "Nicolas" == mc.getGivenName() ))
    self.assertTrue((  "lenov@ebi.ac.uk" == mc.getEmail() ))
    self.assertTrue((  "EMBL-EBI" == mc.getOrganisation() ))
    date = history.getCreatedDate()
    self.assertTrue( date.getYear() == 2005 )
    self.assertTrue( date.getMonth() == 2 )
    self.assertTrue( date.getDay() == 2 )
    self.assertTrue( date.getHour() == 14 )
    self.assertTrue( date.getMinute() == 56 )
    self.assertTrue( date.getSecond() == 11 )
    self.assertTrue( date.getSignOffset() == 0 )
    self.assertTrue( date.getHoursOffset() == 0 )
    self.assertTrue( date.getMinutesOffset() == 0 )
    self.assertTrue((  "2005-02-02T14:56:11Z" == date.getDateAsString() ))
    date = history.getModifiedDate()
    self.assertTrue( date.getYear() == 2006 )
    self.assertTrue( date.getMonth() == 5 )
    self.assertTrue( date.getDay() == 30 )
    self.assertTrue( date.getHour() == 10 )
    self.assertTrue( date.getMinute() == 46 )
    self.assertTrue( date.getSecond() == 2 )
    self.assertTrue( date.getSignOffset() == 0 )
    self.assertTrue( date.getHoursOffset() == 0 )
    self.assertTrue( date.getMinutesOffset() == 0 )
    self.assertTrue((  "2006-05-30T10:46:02Z" == date.getDateAsString() ))
    pass  

  def test_RDFAnnotation_parseCVTerms(self):
    node = libsbml.RDFAnnotationParser.parseCVTerms(self.m.getCompartment(0))
    self.assertTrue( node.getNumChildren() == 1 )
    rdf = node.getChild(0)
    self.assertTrue((  "RDF" == rdf.getName() ))
    self.assertTrue((  "rdf" == rdf.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == rdf.getURI() ))
    self.assertTrue( rdf.getNumChildren() == 1 )
    desc = rdf.getChild(0)
    self.assertTrue((  "Description" == desc.getName() ))
    self.assertTrue((  "rdf" == desc.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == desc.getURI() ))
    self.assertTrue( desc.getNumChildren() == 1 )
    is1 = desc.getChild(0)
    self.assertTrue((  "is" == is1.getName() ))
    self.assertTrue((  "bqbiol" == is1.getPrefix() ))
    self.assertTrue( is1.getNumChildren() == 1 )
    Bag = is1.getChild(0)
    self.assertTrue((  "Bag" == Bag.getName() ))
    self.assertTrue((  "rdf" == Bag.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == Bag.getURI() ))
    self.assertTrue( Bag.getNumChildren() == 4 )
    li = Bag.getChild(0)
    self.assertTrue((  "li" == li.getName() ))
    self.assertTrue((  "rdf" == li.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li.getURI() ))
    self.assertTrue( li.getNumChildren() == 0 )
    li1 = Bag.getChild(1)
    self.assertTrue((  "li" == li1.getName() ))
    self.assertTrue((  "rdf" == li1.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li1.getURI() ))
    self.assertTrue( li1.getNumChildren() == 0 )
    li2 = Bag.getChild(2)
    self.assertTrue((  "li" == li2.getName() ))
    self.assertTrue((  "rdf" == li2.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li2.getURI() ))
    self.assertTrue( li2.getNumChildren() == 0 )
    li3 = Bag.getChild(3)
    self.assertTrue((  "li" == li3.getName() ))
    self.assertTrue((  "rdf" == li3.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li3.getURI() ))
    self.assertTrue( li3.getNumChildren() == 0 )
    node = None
    node1 = libsbml.RDFAnnotationParser.parseCVTerms(None)
    self.assertTrue( node1 == None )
    node1 = libsbml.RDFAnnotationParser.createCVTerms(None)
    self.assertTrue( node1 == None )
    node1 = libsbml.RDFAnnotationParser.parseCVTerms(self.m.getCompartment(2))
    self.assertTrue( node1 == None )
    node1 = libsbml.RDFAnnotationParser.createCVTerms(self.m.getCompartment(2))
    self.assertTrue( node1 == None )
    node1 = libsbml.RDFAnnotationParser.parseCVTerms(self.m)
    self.assertTrue( node1 == None )
    node1 = libsbml.RDFAnnotationParser.createCVTerms(self.m)
    self.assertTrue( node1 == None )
    c = libsbml.Compartment(3,1)
    c.setMetaId("_002")
    node1 = libsbml.RDFAnnotationParser.parseCVTerms(c)
    self.assertTrue( node1 == None )
    node1 = libsbml.RDFAnnotationParser.createCVTerms(c)
    self.assertTrue( node1 == None )
    cv = libsbml.CVTerm(libsbml.BIOLOGICAL_QUALIFIER)
    cv.setBiologicalQualifierType(23)
    cv.addResource("http://myres")
    c.addCVTerm(cv)
    node1 = libsbml.RDFAnnotationParser.createCVTerms(c)
    self.assertTrue( node1 == None )
    c = None
    m1 = libsbml.Model(3,1)
    m1.setMetaId("_002")
    cv = libsbml.CVTerm(libsbml.MODEL_QUALIFIER)
    cv.setModelQualifierType(23)
    cv.addResource("http://myres")
    m1.addCVTerm(cv)
    node1 = libsbml.RDFAnnotationParser.createCVTerms(m1)
    self.assertTrue( node1 == None )
    pass  

  def test_RDFAnnotation_parseModelHistory(self):
    node = libsbml.RDFAnnotationParser.parseModelHistory(self.m)
    self.assertTrue( node.getNumChildren() == 1 )
    rdf = node.getChild(0)
    self.assertTrue((  "RDF" == rdf.getName() ))
    self.assertTrue((  "rdf" == rdf.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == rdf.getURI() ))
    self.assertTrue( rdf.getNumChildren() == 1 )
    desc = rdf.getChild(0)
    self.assertTrue((  "Description" == desc.getName() ))
    self.assertTrue((  "rdf" == desc.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == desc.getURI() ))
    self.assertTrue( desc.getNumChildren() == 3 )
    creator = desc.getChild(0)
    self.assertTrue((  "creator" == creator.getName() ))
    self.assertTrue((  "dc" == creator.getPrefix() ))
    self.assertTrue( creator.getNumChildren() == 1 )
    Bag = creator.getChild(0)
    self.assertTrue((  "Bag" == Bag.getName() ))
    self.assertTrue((  "rdf" == Bag.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == Bag.getURI() ))
    self.assertTrue( Bag.getNumChildren() == 1 )
    li = Bag.getChild(0)
    self.assertTrue((  "li" == li.getName() ))
    self.assertTrue((  "rdf" == li.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li.getURI() ))
    self.assertTrue( li.getNumChildren() == 3 )
    N = li.getChild(0)
    self.assertTrue((  "N" == N.getName() ))
    self.assertTrue((  "vCard" == N.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == N.getURI() ))
    self.assertTrue( N.getNumChildren() == 2 )
    Family = N.getChild(0)
    self.assertTrue((  "Family" == Family.getName() ))
    self.assertTrue((  "vCard" == Family.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == Family.getURI() ))
    self.assertTrue( Family.getNumChildren() == 1 )
    Given = N.getChild(1)
    self.assertTrue((  "Given" == Given.getName() ))
    self.assertTrue((  "vCard" == Given.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == Given.getURI() ))
    self.assertTrue( Given.getNumChildren() == 1 )
    EMAIL = li.getChild(1)
    self.assertTrue((  "EMAIL" == EMAIL.getName() ))
    self.assertTrue((  "vCard" == EMAIL.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == EMAIL.getURI() ))
    self.assertTrue( EMAIL.getNumChildren() == 1 )
    ORG = li.getChild(2)
    self.assertTrue((  "ORG" == ORG.getName() ))
    self.assertTrue((  "vCard" == ORG.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == ORG.getURI() ))
    self.assertTrue( ORG.getNumChildren() == 1 )
    Orgname = ORG.getChild(0)
    self.assertTrue((  "Orgname" == Orgname.getName() ))
    self.assertTrue((  "vCard" == Orgname.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == Orgname.getURI() ))
    self.assertTrue( Orgname.getNumChildren() == 1 )
    created = desc.getChild(1)
    self.assertTrue((  "created" == created.getName() ))
    self.assertTrue((  "dcterms" == created.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == created.getURI() ))
    self.assertTrue( created.getNumChildren() == 1 )
    cr_date = created.getChild(0)
    self.assertTrue((  "W3CDTF" == cr_date.getName() ))
    self.assertTrue((  "dcterms" == cr_date.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == cr_date.getURI() ))
    self.assertTrue( cr_date.getNumChildren() == 1 )
    modified = desc.getChild(2)
    self.assertTrue((  "modified" == modified.getName() ))
    self.assertTrue((  "dcterms" == modified.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == modified.getURI() ))
    self.assertTrue( modified.getNumChildren() == 1 )
    mo_date = created.getChild(0)
    self.assertTrue((  "W3CDTF" == mo_date.getName() ))
    self.assertTrue((  "dcterms" == mo_date.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == mo_date.getURI() ))
    self.assertTrue( mo_date.getNumChildren() == 1 )
    node = None
    pass  

  def test_RDFAnnotation_removeAnnotation(self):
    n1 = None
    expected = wrapString("<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "    <rdf:Description>\n"
 + 
    "      <rdf:other/>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    i = self.m.getCompartment(4).removeTopLevelAnnotationElement("JDesignerLayout")
    n1 = self.m.getCompartment(4).getAnnotation()
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( True, self.equals(expected,n1.toXMLString()) )
    i = self.m.getListOfCompartments().removeTopLevelAnnotationElement("RDF")
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    pass  

  def test_RDFAnnotation_removeSingleAnnotation(self):
    n1 = None
    i = self.m.getCompartment(0).removeTopLevelAnnotationElement("RDF")
    n1 = self.m.getCompartment(0).getAnnotation()
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( n1 == None )
    i = self.m.getCompartment(2).removeTopLevelAnnotationElement("JDesignerLayout")
    n1 = self.m.getCompartment(2).getAnnotation()
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( n1 == None )
    i = self.m.getCompartment(3).removeTopLevelAnnotationElement("RDF", "http://www.w3.org/1999/02/22-rdf-syntax-ns#")
    n1 = self.m.getCompartment(3).getAnnotation()
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( n1 == None )
    pass  

  def test_RDFAnnotation_removeSingleAnnotation1(self):
    n1 = None
    i = self.m.getCompartment(0).removeTopLevelAnnotationElement("RDF1")
    n1 = self.m.getCompartment(0).getAnnotation()
    self.assertTrue( i == libsbml.LIBSBML_ANNOTATION_NAME_NOT_FOUND )
    self.assertTrue( n1.getNumChildren() == 1 )
    i = self.m.getCompartment(2).removeTopLevelAnnotationElement("JDLayout")
    n1 = self.m.getCompartment(2).getAnnotation()
    self.assertTrue( i == libsbml.LIBSBML_ANNOTATION_NAME_NOT_FOUND )
    self.assertTrue( n1.getNumChildren() == 1 )
    i = self.m.getCompartment(3).removeTopLevelAnnotationElement("RDF", "http://www.w3.org/1999/02/22-rdf-syntax-ns")
    n1 = self.m.getCompartment(3).getAnnotation()
    self.assertTrue( i == libsbml.LIBSBML_ANNOTATION_NS_NOT_FOUND )
    self.assertTrue( n1.getNumChildren() == 1 )
    pass  

  def test_RDFAnnotation_replaceAnnotation(self):
    node = self.m.getCompartment(3).getAnnotation()
    n1 = None
    expected = wrapString("<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    i = self.m.getCompartment(0).replaceTopLevelAnnotationElement(node)
    n1 = self.m.getCompartment(0).getAnnotation()
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( True, self.equals(expected,n1.toXMLString()) )
    pass  

  def test_RDFAnnotation_replaceAnnotation1(self):
    n1 = None
    noRDF = wrapString("<annotation>\n"
"  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"3\" BuildVersion=\"41\">\n"
 + 
    "    <jd2:header>\n"
 + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "      <jd2:ModelHeader Author=\"Sarah\" ModelVersion=\"0.0\" ModelTitle=\"mine\"/>\n"
 + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"12\" numberOfPoints=\"1000\"/>\n"
 + 
    "    </jd2:header>\n"
 + 
    "  </jd2:JDesignerLayout>\n"
 + 
    "</annotation>")
    expected = wrapString("<annotation>\n"
 + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"3\" BuildVersion=\"41\">\n"
 + 
    "    <jd2:header>\n"
 + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "      <jd2:ModelHeader Author=\"Sarah\" ModelVersion=\"0.0\" ModelTitle=\"mine\"/>\n"
 + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"12\" numberOfPoints=\"1000\"/>\n"
 + 
    "    </jd2:header>\n"
 + 
    "  </jd2:JDesignerLayout>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "    <rdf:Description>\n"
 + 
    "      <rdf:other/>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    i = self.m.getCompartment(4).replaceTopLevelAnnotationElement(noRDF)
    n1 = self.m.getCompartment(4).getAnnotation()
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( True, self.equals(expected,n1.toXMLString()) )
    pass  

  def test_RDFAnnotation_replaceAnnotation2(self):
    n1 = None
    jd = wrapString("  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"3\" BuildVersion=\"41\">\n"
"    <jd2:header>\n"
 + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "      <jd2:ModelHeader Author=\"Sarah\" ModelVersion=\"0.0\" ModelTitle=\"mine\"/>\n"
 + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"12\" numberOfPoints=\"1000\"/>\n"
 + 
    "    </jd2:header>\n"
 + 
    "  </jd2:JDesignerLayout>")
    twoAnn = wrapString("<annotation>\n"
 + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"3\" BuildVersion=\"41\">\n"
 + 
    "    <jd2:header>\n"
 + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "      <jd2:ModelHeader Author=\"Sarah\" ModelVersion=\"0.0\" ModelTitle=\"mine\"/>\n"
 + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"12\" numberOfPoints=\"1000\"/>\n"
 + 
    "    </jd2:header>\n"
 + 
    "  </jd2:JDesignerLayout>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "    <rdf:Description>\n"
 + 
    "      <rdf:other/>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    i = self.m.getCompartment(4).replaceTopLevelAnnotationElement(twoAnn)
    self.assertTrue( i == libsbml.LIBSBML_INVALID_OBJECT )
    i = self.m.getCompartment(4).replaceTopLevelAnnotationElement(jd)
    n1 = self.m.getCompartment(4).getAnnotation()
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( True, self.equals(twoAnn,n1.toXMLString()) )
    pass  

  def test_RDFAnnotation_testAnnotationForMetaId(self):
    doc = libsbml.SBMLDocument( 3,1 )
    model = doc.createModel()
    self.assertTrue( model != None )
    model.setId("test1")
    term = libsbml.CVTerm( libsbml.MODEL_QUALIFIER )
    term.addResource("testResource")
    term.setModelQualifierType(libsbml.BQM_IS)
    model.setMetaId("t1")
    model.addCVTerm(term)
    model.setMetaId("")
    test = model.toSBML()
    self.assertTrue( test ==  "<model id=\"test1\"/>" )
    pass  


  def test_RDFAnnotation_testMissingAbout(self):
    withAbout = wrapString("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000004\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>")
    emptyAbout = wrapString("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>")
    noAbout = wrapString("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>")
    cvTerms = libsbml.CVTermList()
    stream = libsbml.XMLInputStream( withAbout,False )
    node = libsbml.XMLNode( stream )
    libsbml.RDFAnnotationParser.parseRDFAnnotation(node,cvTerms)
    self.assertTrue( cvTerms.getSize() == 1 )
    cvTerms = None
    cvTerms = libsbml.CVTermList()
    libsbml.RDFAnnotationParser.parseRDFAnnotation(node,cvTerms )
    self.assertTrue( cvTerms.getSize() == 1 )
    cvTerms = None
    cvTerms = None
    cvTerms = libsbml.CVTermList()
    stream1 = libsbml.XMLInputStream( emptyAbout,False )
    node1 = libsbml.XMLNode( stream1 )
    libsbml.RDFAnnotationParser.parseRDFAnnotation(node1,cvTerms)
    self.assertTrue( cvTerms.getSize() == 0 )
    cvTerms = None
    cvTerms = None
    cvTerms = libsbml.CVTermList()
    stream2 = libsbml.XMLInputStream( noAbout,False )
    node2 = libsbml.XMLNode( stream2 )
    libsbml.RDFAnnotationParser.parseRDFAnnotation(node2,cvTerms)
    self.assertTrue( cvTerms.getSize() == 0 )
    cvTerms = None
    cvTerms = None
    pass  

  def test_RDFAnnotation_testMissingMetaId(self):
    doc = libsbml.SBMLDocument( 3,1 )
    model = doc.createModel()
    self.assertTrue( model != None )
    model.setId("test1")
    term = libsbml.CVTerm( libsbml.MODEL_QUALIFIER )
    term.addResource("testResource")
    term.setModelQualifierType(libsbml.BQM_IS)
    model.setMetaId("t1")
    model.addCVTerm(term)
    model.setMetaId("")
    test = model.toSBML()
    self.assertTrue( test ==  "<model id=\"test1\"/>" )
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestRDFAnnotation))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
