/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_k_pgslb.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t41, t44, t45;
  double t46, t48, t49, t50, t51, t52, t54, t58;
  double t62, tzk0;

  mgga_k_pgslb_params *params;

  assert(p->params != NULL);
  params = (mgga_k_pgslb_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t41 = params->pgslb_mu * t25 * t29;
  t44 = exp(-t41 * t37 / 0.24e2);
  t45 = t25 * t25;
  t46 = params->pgslb_beta * t45;
  t48 = 0.1e1 / t27 / t26;
  t49 = t46 * t48;
  t50 = lapl[0] * lapl[0];
  t51 = t50 * t31;
  t52 = t34 * rho[0];
  t54 = 0.1e1 / t22 / t52;
  t58 = 0.5e1 / 0.72e2 * t30 * t37 + t44 + t49 * t51 * t54 / 0.288e3;
  t62 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t58);
  tzk0 = 0.2e1 * t62;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t41, t44, t45;
  double t46, t48, t49, t50, t51, t52, t54, t58;
  double t62, tzk0;

  double t64, t69, t77, t83, t88, tvrho0, t91, t97;
  double t101, tvsigma0, t104, t107, t110, tvlapl0, tvtau0;

  mgga_k_pgslb_params *params;

  assert(p->params != NULL);
  params = (mgga_k_pgslb_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t41 = params->pgslb_mu * t25 * t29;
  t44 = exp(-t41 * t37 / 0.24e2);
  t45 = t25 * t25;
  t46 = params->pgslb_beta * t45;
  t48 = 0.1e1 / t27 / t26;
  t49 = t46 * t48;
  t50 = lapl[0] * lapl[0];
  t51 = t50 * t31;
  t52 = t34 * rho[0];
  t54 = 0.1e1 / t22 / t52;
  t58 = 0.5e1 / 0.72e2 * t30 * t37 + t44 + t49 * t51 * t54 / 0.288e3;
  t62 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t58);
  tzk0 = 0.2e1 * t62;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t64 = t21 / t22;
  t69 = 0.1e1 / t23 / t52;
  t77 = t34 * t34;
  t83 = -0.5e1 / 0.27e2 * t30 * t33 * t69 + t41 * t33 * t69 * t44 / 0.9e1 - 0.5e1 / 0.432e3 * t49 * t51 / t22 / t77;
  t88 = my_piecewise3(t3, 0, t8 * t64 * t58 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t83);
  tvrho0 = 0.2e1 * rho[0] * t88 + 0.2e1 * t62;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t91 = t32 * t36;
  t97 = 0.5e1 / 0.72e2 * t30 * t91 - t41 * t91 * t44 / 0.24e2;
  t101 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t97);
  tvsigma0 = 0.2e1 * rho[0] * t101;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t104 = t8 * t21 * t36;
  t107 = t46 * t48 * lapl[0] * t31;
  t110 = my_piecewise3(t3, 0, t104 * t107 / 0.96e3);
  tvlapl0 = 0.2e1 * rho[0] * t110;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t41, t44, t45;
  double t46, t48, t49, t50, t51, t52, t54, t58;
  double t62, tzk0;

  double t64, t69, t77, t83, t88, tvrho0, t91, t97;
  double t101, tvsigma0, t104, t107, t110, tvlapl0, tvtau0;

  double t115, t123, t131, t132, t133, t134, t135, t138;
  double t143, t149, t154, tv2rho20, t160, t166, t168, t170;
  double t174, t179, tv2rhosigma0, t183, t186, tv2rholapl0, tv2rhotau0, t190;
  double t191, t193, t196, tv2sigma20, tv2sigmalapl0, tv2sigmatau0, t198, t201;
  double tv2lapl20, tv2lapltau0, tv2tau20;

  mgga_k_pgslb_params *params;

  assert(p->params != NULL);
  params = (mgga_k_pgslb_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t41 = params->pgslb_mu * t25 * t29;
  t44 = exp(-t41 * t37 / 0.24e2);
  t45 = t25 * t25;
  t46 = params->pgslb_beta * t45;
  t48 = 0.1e1 / t27 / t26;
  t49 = t46 * t48;
  t50 = lapl[0] * lapl[0];
  t51 = t50 * t31;
  t52 = t34 * rho[0];
  t54 = 0.1e1 / t22 / t52;
  t58 = 0.5e1 / 0.72e2 * t30 * t37 + t44 + t49 * t51 * t54 / 0.288e3;
  t62 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t58);
  tzk0 = 0.2e1 * t62;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t64 = t21 / t22;
  t69 = 0.1e1 / t23 / t52;
  t77 = t34 * t34;
  t83 = -0.5e1 / 0.27e2 * t30 * t33 * t69 + t41 * t33 * t69 * t44 / 0.9e1 - 0.5e1 / 0.432e3 * t49 * t51 / t22 / t77;
  t88 = my_piecewise3(t3, 0, t8 * t64 * t58 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t83);
  tvrho0 = 0.2e1 * rho[0] * t88 + 0.2e1 * t62;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t91 = t32 * t36;
  t97 = 0.5e1 / 0.72e2 * t30 * t91 - t41 * t91 * t44 / 0.24e2;
  t101 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t97);
  tvsigma0 = 0.2e1 * rho[0] * t101;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t104 = t8 * t21 * t36;
  t107 = t46 * t48 * lapl[0] * t31;
  t110 = my_piecewise3(t3, 0, t104 * t107 / 0.96e3);
  tvlapl0 = 0.2e1 * rho[0] * t110;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t115 = t21 / t22 / rho[0];
  t123 = 0.1e1 / t23 / t77;
  t131 = params->pgslb_mu * params->pgslb_mu;
  t132 = t131 * t45;
  t133 = t132 * t48;
  t134 = sigma[0] * sigma[0];
  t135 = t134 * t31;
  t138 = 0.1e1 / t22 / t77 / t52;
  t143 = t77 * rho[0];
  t149 = 0.55e2 / 0.81e2 * t30 * t33 * t123 - 0.11e2 / 0.27e2 * t41 * t33 * t123 * t44 + 0.2e1 / 0.81e2 * t133 * t135 * t138 * t44 + 0.65e2 / 0.1296e4 * t49 * t51 / t22 / t143;
  t154 = my_piecewise3(t3, 0, -t8 * t115 * t58 / 0.3e2 + t8 * t64 * t83 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t149);
  tv2rho20 = 0.2e1 * rho[0] * t154 + 0.4e1 * t88;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t160 = t32 * t69;
  t166 = t77 * t34;
  t168 = 0.1e1 / t22 / t166;
  t170 = sigma[0] * t44;
  t174 = -0.5e1 / 0.27e2 * t30 * t160 + t41 * t160 * t44 / 0.9e1 - t133 * t31 * t168 * t170 / 0.108e3;
  t179 = my_piecewise3(t3, 0, t8 * t64 * t97 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t174);
  tv2rhosigma0 = 0.2e1 * rho[0] * t179 + 0.2e1 * t101;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t183 = t8 * t21 * t69;
  t186 = my_piecewise3(t3, 0, -t183 * t107 / 0.36e3);
  tv2rholapl0 = 0.2e1 * rho[0] * t186 + 0.2e1 * t110;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t190 = t8 * t21 * t123;
  t191 = t48 * t31;
  t193 = t132 * t191 * t44;
  t196 = my_piecewise3(t3, 0, t190 * t193 / 0.192e4);
  tv2sigma20 = 0.2e1 * rho[0] * t196;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t198 = t46 * t191;
  t201 = my_piecewise3(t3, 0, t104 * t198 / 0.96e3);
  tv2lapl20 = 0.2e1 * rho[0] * t201;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t41, t44, t45;
  double t46, t48, t49, t50, t51, t52, t54, t58;
  double t62, tzk0;

  double t64, t69, t77, t83, t88, tvrho0, t91, t97;
  double t101, tvsigma0, t104, t107, t110, tvlapl0, tvtau0;

  double t115, t123, t131, t132, t133, t134, t135, t138;
  double t143, t149, t154, tv2rho20, t160, t166, t168, t170;
  double t174, t179, tv2rhosigma0, t183, t186, tv2rholapl0, tv2rhotau0, t190;
  double t191, t193, t196, tv2sigma20, tv2sigmalapl0, tv2sigmatau0, t198, t201;
  double tv2lapl20, tv2lapltau0, tv2tau20;

  double t206, t217, t225, t227, t232, t233, t234, t235;
  double t236, t238, t246, t251, tv3rho30, t261, t272, t277;
  double t282, tv3rho2sigma0, t288, tv3rho2lapl0, tv3rho2tau0, t292, t295, t298;
  double t299, t300, t305, tv3rhosigma20, tv3rhosigmalapl0, tv3rhosigmatau0, t310, tv3rholapl20;
  double tv3rholapltau0, tv3rhotau20, t317, tv3sigma30, tv3sigma2lapl0, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0;
  double tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20, tv3tau30;

  mgga_k_pgslb_params *params;

  assert(p->params != NULL);
  params = (mgga_k_pgslb_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t41 = params->pgslb_mu * t25 * t29;
  t44 = exp(-t41 * t37 / 0.24e2);
  t45 = t25 * t25;
  t46 = params->pgslb_beta * t45;
  t48 = 0.1e1 / t27 / t26;
  t49 = t46 * t48;
  t50 = lapl[0] * lapl[0];
  t51 = t50 * t31;
  t52 = t34 * rho[0];
  t54 = 0.1e1 / t22 / t52;
  t58 = 0.5e1 / 0.72e2 * t30 * t37 + t44 + t49 * t51 * t54 / 0.288e3;
  t62 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t58);
  tzk0 = 0.2e1 * t62;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t64 = t21 / t22;
  t69 = 0.1e1 / t23 / t52;
  t77 = t34 * t34;
  t83 = -0.5e1 / 0.27e2 * t30 * t33 * t69 + t41 * t33 * t69 * t44 / 0.9e1 - 0.5e1 / 0.432e3 * t49 * t51 / t22 / t77;
  t88 = my_piecewise3(t3, 0, t8 * t64 * t58 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t83);
  tvrho0 = 0.2e1 * rho[0] * t88 + 0.2e1 * t62;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t91 = t32 * t36;
  t97 = 0.5e1 / 0.72e2 * t30 * t91 - t41 * t91 * t44 / 0.24e2;
  t101 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t97);
  tvsigma0 = 0.2e1 * rho[0] * t101;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t104 = t8 * t21 * t36;
  t107 = t46 * t48 * lapl[0] * t31;
  t110 = my_piecewise3(t3, 0, t104 * t107 / 0.96e3);
  tvlapl0 = 0.2e1 * rho[0] * t110;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t115 = t21 / t22 / rho[0];
  t123 = 0.1e1 / t23 / t77;
  t131 = params->pgslb_mu * params->pgslb_mu;
  t132 = t131 * t45;
  t133 = t132 * t48;
  t134 = sigma[0] * sigma[0];
  t135 = t134 * t31;
  t138 = 0.1e1 / t22 / t77 / t52;
  t143 = t77 * rho[0];
  t149 = 0.55e2 / 0.81e2 * t30 * t33 * t123 - 0.11e2 / 0.27e2 * t41 * t33 * t123 * t44 + 0.2e1 / 0.81e2 * t133 * t135 * t138 * t44 + 0.65e2 / 0.1296e4 * t49 * t51 / t22 / t143;
  t154 = my_piecewise3(t3, 0, -t8 * t115 * t58 / 0.3e2 + t8 * t64 * t83 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t149);
  tv2rho20 = 0.2e1 * rho[0] * t154 + 0.4e1 * t88;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t160 = t32 * t69;
  t166 = t77 * t34;
  t168 = 0.1e1 / t22 / t166;
  t170 = sigma[0] * t44;
  t174 = -0.5e1 / 0.27e2 * t30 * t160 + t41 * t160 * t44 / 0.9e1 - t133 * t31 * t168 * t170 / 0.108e3;
  t179 = my_piecewise3(t3, 0, t8 * t64 * t97 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t174);
  tv2rhosigma0 = 0.2e1 * rho[0] * t179 + 0.2e1 * t101;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t183 = t8 * t21 * t69;
  t186 = my_piecewise3(t3, 0, -t183 * t107 / 0.36e3);
  tv2rholapl0 = 0.2e1 * rho[0] * t186 + 0.2e1 * t110;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t190 = t8 * t21 * t123;
  t191 = t48 * t31;
  t193 = t132 * t191 * t44;
  t196 = my_piecewise3(t3, 0, t190 * t193 / 0.192e4);
  tv2sigma20 = 0.2e1 * rho[0] * t196;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t198 = t46 * t191;
  t201 = my_piecewise3(t3, 0, t104 * t198 / 0.96e3);
  tv2lapl20 = 0.2e1 * rho[0] * t201;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t206 = t21 / t22 / t34;
  t217 = 0.1e1 / t23 / t143;
  t225 = t77 * t77;
  t227 = 0.1e1 / t22 / t225;
  t232 = t131 * params->pgslb_mu;
  t233 = t26 * t26;
  t234 = 0.1e1 / t233;
  t235 = t232 * t234;
  t236 = t134 * sigma[0];
  t238 = 0.1e1 / t225 / t52;
  t246 = -0.77e3 / 0.243e3 * t30 * t33 * t217 + 0.154e3 / 0.81e2 * t41 * t33 * t217 * t44 - 0.22e2 / 0.81e2 * t133 * t135 * t227 * t44 + 0.8e1 / 0.243e3 * t235 * t236 * t238 * t44 - 0.65e2 / 0.243e3 * t49 * t51 * t168;
  t251 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t206 * t58 - t8 * t115 * t83 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t64 * t149 + 0.3e1 / 0.2e2 * t8 * t24 * t246);
  tv3rho30 = 0.2e1 * rho[0] * t251 + 0.6e1 * t154;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t261 = t32 * t123;
  t272 = 0.1e1 / t225 / t34;
  t277 = 0.55e2 / 0.81e2 * t30 * t261 - 0.11e2 / 0.27e2 * t41 * t261 * t44 + t133 * t31 * t138 * t170 / 0.12e2 - t235 * t272 * t134 * t44 / 0.81e2;
  t282 = my_piecewise3(t3, 0, -t8 * t115 * t97 / 0.3e2 + t8 * t64 * t174 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t277);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t282 + 0.4e1 * t179;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t288 = my_piecewise3(t3, 0, 0.11e2 / 0.108e4 * t190 * t107);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t288 + 0.4e1 * t186;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t292 = t8 * t21 * t217;
  t295 = t6 * t6;
  t298 = t5 / t295 / t26;
  t299 = t298 * t21;
  t300 = t227 * t232;
  t305 = my_piecewise3(t3, 0, -0.7e1 / 0.288e4 * t292 * t193 + t299 * t300 * t170 / 0.144e4);
  tv3rhosigma20 = 0.2e1 * rho[0] * t305 + 0.2e1 * t196;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t310 = my_piecewise3(t3, 0, -t183 * t198 / 0.36e3);
  tv3rholapl20 = 0.2e1 * rho[0] * t310 + 0.2e1 * t201;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t317 = my_piecewise3(t3, 0, -t299 * t138 * t232 * t44 / 0.384e4);
  tv3sigma30 = 0.2e1 * rho[0] * t317;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t41, t44, t45;
  double t46, t48, t49, t50, t51, t52, t54, t58;
  double t62, tzk0;

  double t64, t69, t77, t83, t88, tvrho0, t91, t97;
  double t101, tvsigma0, t104, t107, t110, tvlapl0, tvtau0;

  double t115, t123, t131, t132, t133, t134, t135, t138;
  double t143, t149, t154, tv2rho20, t160, t166, t168, t170;
  double t174, t179, tv2rhosigma0, t183, t186, tv2rholapl0, tv2rhotau0, t190;
  double t191, t193, t196, tv2sigma20, tv2sigmalapl0, tv2sigmatau0, t198, t201;
  double tv2lapl20, tv2lapltau0, tv2tau20;

  double t206, t217, t225, t227, t232, t233, t234, t235;
  double t236, t238, t246, t251, tv3rho30, t261, t272, t277;
  double t282, tv3rho2sigma0, t288, tv3rho2lapl0, tv3rho2tau0, t292, t295, t298;
  double t299, t300, t305, tv3rhosigma20, tv3rhosigmalapl0, tv3rhosigmatau0, t310, tv3rholapl20;
  double tv3rholapltau0, tv3rhotau20, t317, tv3sigma30, tv3sigma2lapl0, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0;
  double tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20, tv3tau30;

  double t334, t344, t350, t355, t356, t357, t364, t375;
  double tv4rho40, t388, t414, tv4rho3sigma0, t420, tv4rho3lapl0, tv4rho3tau0, t437;
  double t442, tv4rho2sigma20, tv4rho2sigmalapl0, tv4rho2sigmatau0, t448, tv4rho2lapl20, tv4rho2lapltau0, tv4rho2tau20;
  double t462, tv4rhosigma30, tv4rhosigma2lapl0, tv4rhosigma2tau0, tv4rhosigmalapl20, tv4rhosigmalapltau0, tv4rhosigmatau20, tv4rholapl30;
  double tv4rholapl2tau0, tv4rholapltau20, tv4rhotau30, t471, tv4sigma40, tv4sigma3lapl0, tv4sigma3tau0, tv4sigma2lapl20;
  double tv4sigma2lapltau0, tv4sigma2tau20, tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20, tv4sigmatau30, tv4lapl40, tv4lapl3tau0;
  double tv4lapl2tau20, tv4lapltau30, tv4tau40;

  mgga_k_pgslb_params *params;

  assert(p->params != NULL);
  params = (mgga_k_pgslb_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t41 = params->pgslb_mu * t25 * t29;
  t44 = exp(-t41 * t37 / 0.24e2);
  t45 = t25 * t25;
  t46 = params->pgslb_beta * t45;
  t48 = 0.1e1 / t27 / t26;
  t49 = t46 * t48;
  t50 = lapl[0] * lapl[0];
  t51 = t50 * t31;
  t52 = t34 * rho[0];
  t54 = 0.1e1 / t22 / t52;
  t58 = 0.5e1 / 0.72e2 * t30 * t37 + t44 + t49 * t51 * t54 / 0.288e3;
  t62 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t58);
  tzk0 = 0.2e1 * t62;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t64 = t21 / t22;
  t69 = 0.1e1 / t23 / t52;
  t77 = t34 * t34;
  t83 = -0.5e1 / 0.27e2 * t30 * t33 * t69 + t41 * t33 * t69 * t44 / 0.9e1 - 0.5e1 / 0.432e3 * t49 * t51 / t22 / t77;
  t88 = my_piecewise3(t3, 0, t8 * t64 * t58 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t83);
  tvrho0 = 0.2e1 * rho[0] * t88 + 0.2e1 * t62;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t91 = t32 * t36;
  t97 = 0.5e1 / 0.72e2 * t30 * t91 - t41 * t91 * t44 / 0.24e2;
  t101 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t97);
  tvsigma0 = 0.2e1 * rho[0] * t101;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t104 = t8 * t21 * t36;
  t107 = t46 * t48 * lapl[0] * t31;
  t110 = my_piecewise3(t3, 0, t104 * t107 / 0.96e3);
  tvlapl0 = 0.2e1 * rho[0] * t110;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t115 = t21 / t22 / rho[0];
  t123 = 0.1e1 / t23 / t77;
  t131 = params->pgslb_mu * params->pgslb_mu;
  t132 = t131 * t45;
  t133 = t132 * t48;
  t134 = sigma[0] * sigma[0];
  t135 = t134 * t31;
  t138 = 0.1e1 / t22 / t77 / t52;
  t143 = t77 * rho[0];
  t149 = 0.55e2 / 0.81e2 * t30 * t33 * t123 - 0.11e2 / 0.27e2 * t41 * t33 * t123 * t44 + 0.2e1 / 0.81e2 * t133 * t135 * t138 * t44 + 0.65e2 / 0.1296e4 * t49 * t51 / t22 / t143;
  t154 = my_piecewise3(t3, 0, -t8 * t115 * t58 / 0.3e2 + t8 * t64 * t83 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t149);
  tv2rho20 = 0.2e1 * rho[0] * t154 + 0.4e1 * t88;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t160 = t32 * t69;
  t166 = t77 * t34;
  t168 = 0.1e1 / t22 / t166;
  t170 = sigma[0] * t44;
  t174 = -0.5e1 / 0.27e2 * t30 * t160 + t41 * t160 * t44 / 0.9e1 - t133 * t31 * t168 * t170 / 0.108e3;
  t179 = my_piecewise3(t3, 0, t8 * t64 * t97 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t174);
  tv2rhosigma0 = 0.2e1 * rho[0] * t179 + 0.2e1 * t101;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t183 = t8 * t21 * t69;
  t186 = my_piecewise3(t3, 0, -t183 * t107 / 0.36e3);
  tv2rholapl0 = 0.2e1 * rho[0] * t186 + 0.2e1 * t110;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t190 = t8 * t21 * t123;
  t191 = t48 * t31;
  t193 = t132 * t191 * t44;
  t196 = my_piecewise3(t3, 0, t190 * t193 / 0.192e4);
  tv2sigma20 = 0.2e1 * rho[0] * t196;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t198 = t46 * t191;
  t201 = my_piecewise3(t3, 0, t104 * t198 / 0.96e3);
  tv2lapl20 = 0.2e1 * rho[0] * t201;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t206 = t21 / t22 / t34;
  t217 = 0.1e1 / t23 / t143;
  t225 = t77 * t77;
  t227 = 0.1e1 / t22 / t225;
  t232 = t131 * params->pgslb_mu;
  t233 = t26 * t26;
  t234 = 0.1e1 / t233;
  t235 = t232 * t234;
  t236 = t134 * sigma[0];
  t238 = 0.1e1 / t225 / t52;
  t246 = -0.77e3 / 0.243e3 * t30 * t33 * t217 + 0.154e3 / 0.81e2 * t41 * t33 * t217 * t44 - 0.22e2 / 0.81e2 * t133 * t135 * t227 * t44 + 0.8e1 / 0.243e3 * t235 * t236 * t238 * t44 - 0.65e2 / 0.243e3 * t49 * t51 * t168;
  t251 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t206 * t58 - t8 * t115 * t83 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t64 * t149 + 0.3e1 / 0.2e2 * t8 * t24 * t246);
  tv3rho30 = 0.2e1 * rho[0] * t251 + 0.6e1 * t154;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t261 = t32 * t123;
  t272 = 0.1e1 / t225 / t34;
  t277 = 0.55e2 / 0.81e2 * t30 * t261 - 0.11e2 / 0.27e2 * t41 * t261 * t44 + t133 * t31 * t138 * t170 / 0.12e2 - t235 * t272 * t134 * t44 / 0.81e2;
  t282 = my_piecewise3(t3, 0, -t8 * t115 * t97 / 0.3e2 + t8 * t64 * t174 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t277);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t282 + 0.4e1 * t179;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t288 = my_piecewise3(t3, 0, 0.11e2 / 0.108e4 * t190 * t107);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t288 + 0.4e1 * t186;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t292 = t8 * t21 * t217;
  t295 = t6 * t6;
  t298 = t5 / t295 / t26;
  t299 = t298 * t21;
  t300 = t227 * t232;
  t305 = my_piecewise3(t3, 0, -0.7e1 / 0.288e4 * t292 * t193 + t299 * t300 * t170 / 0.144e4);
  tv3rhosigma20 = 0.2e1 * rho[0] * t305 + 0.2e1 * t196;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t310 = my_piecewise3(t3, 0, -t183 * t198 / 0.36e3);
  tv3rholapl20 = 0.2e1 * rho[0] * t310 + 0.2e1 * t201;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t317 = my_piecewise3(t3, 0, -t299 * t138 * t232 * t44 / 0.384e4);
  tv3sigma30 = 0.2e1 * rho[0] * t317;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t334 = 0.1e1 / t23 / t166;
  t344 = 0.1e1 / t22 / t225 / rho[0];
  t350 = 0.1e1 / t225 / t77;
  t355 = t131 * t131;
  t356 = t355 * t234;
  t357 = t134 * t134;
  t364 = t30 * t32 * t44;
  t375 = my_piecewise3(t3, 0, -0.14e2 / 0.135e3 * t8 * t21 * t54 * t58 + 0.8e1 / 0.45e2 * t8 * t206 * t83 - t8 * t115 * t149 / 0.5e1 + 0.2e1 / 0.5e1 * t8 * t64 * t246 + 0.3e1 / 0.2e2 * t8 * t24 * (0.1309e5 / 0.729e3 * t30 * t33 * t334 - 0.2618e4 / 0.243e3 * t41 * t33 * t334 * t44 + 0.1958e4 / 0.729e3 * t133 * t135 * t344 * t44 - 0.176e3 / 0.243e3 * t235 * t236 * t350 * t44 + 0.8e1 / 0.2187e4 * t356 * t357 / t23 / t225 / t166 * t364 + 0.1235e4 / 0.729e3 * t49 * t51 * t138));
  tv4rho40 = 0.2e1 * rho[0] * t375 + 0.8e1 * t251;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t388 = t32 * t217;
  t414 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t206 * t97 - t8 * t115 * t174 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t64 * t277 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.77e3 / 0.243e3 * t30 * t388 + 0.154e3 / 0.81e2 * t41 * t388 * t44 - 0.341e3 / 0.486e3 * t133 * t31 * t227 * t170 + 0.19e2 / 0.81e2 * t235 * t238 * t134 * t44 - t356 / t23 / t225 / t143 * t236 * t364 / 0.729e3));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t414 + 0.6e1 * t282;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t420 = my_piecewise3(t3, 0, -0.77e2 / 0.162e4 * t292 * t107);
  tv4rho3lapl0 = 0.2e1 * rho[0] * t420 + 0.6e1 * t288;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t437 = t29 * t32 * t44;
  t442 = my_piecewise3(t3, 0, 0.119e3 / 0.864e4 * t8 * t21 * t334 * t193 - 0.13e2 / 0.144e4 * t299 * t344 * t232 * t170 + t298 * t21 * t350 * t355 * t134 * t25 * t437 / 0.1296e5);
  tv4rho2sigma20 = 0.2e1 * rho[0] * t442 + 0.4e1 * t305;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  t448 = my_piecewise3(t3, 0, 0.11e2 / 0.108e4 * t190 * t198);
  tv4rho2lapl20 = 0.2e1 * rho[0] * t448 + 0.4e1 * t310;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t462 = my_piecewise3(t3, 0, 0.11e2 / 0.576e4 * t299 * t300 * t44 - t298 * t21 * t238 * t355 * t30 * t33 * t44 / 0.3456e5);
  tv4rhosigma30 = 0.2e1 * rho[0] * t462 + 0.2e1 * t317;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rholapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rhotau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t471 = my_piecewise3(t3, 0, t298 * t21 * t272 * t355 * t25 * t437 / 0.9216e5);
  tv4sigma40 = 0.2e1 * rho[0] * t471;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigmalapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmatau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4lapl40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4tau40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t47, t48, t52, t53, t54, t56;
  double t57, t58, t59, t61, t65, t69, t70, t71;
  double t73, t74, t75, t76, t77, t79, t80, t81;
  double t82, t83, t85, t89, t93, t94, t95, t96;
  double t98, t102, t106, tzk0;

  mgga_k_pgslb_params *params;

  assert(p->params != NULL);
  params = (mgga_k_pgslb_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t47 = params->pgslb_mu * t33;
  t48 = t37 * sigma[0];
  t52 = exp(-t47 * t48 * t43 / 0.24e2);
  t53 = t33 * t33;
  t54 = params->pgslb_beta * t53;
  t56 = 0.1e1 / t35 / t34;
  t57 = lapl[0] * lapl[0];
  t58 = t56 * t57;
  t59 = t39 * rho[0];
  t61 = 0.1e1 / t40 / t59;
  t65 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43 + t52 + t54 * t58 * t61 / 0.576e3;
  t69 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t65);
  t70 = rho[1] <= p->dens_threshold;
  t71 = -t18;
  t73 = my_piecewise5(t16, t13, t12, t17, t71 * t9);
  t74 = 0.1e1 + t73;
  t75 = t74 <= p->zeta_threshold;
  t76 = POW_1_3(t74);
  t77 = t76 * t76;
  t79 = my_piecewise3(t75, t25, t77 * t74);
  t80 = t79 * t31;
  t81 = rho[1] * rho[1];
  t82 = POW_1_3(rho[1]);
  t83 = t82 * t82;
  t85 = 0.1e1 / t83 / t81;
  t89 = t37 * sigma[2];
  t93 = exp(-t47 * t89 * t85 / 0.24e2);
  t94 = lapl[1] * lapl[1];
  t95 = t56 * t94;
  t96 = t81 * rho[1];
  t98 = 0.1e1 / t82 / t96;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t85 + t93 + t54 * t95 * t98 / 0.576e3;
  t106 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t80 * t102);
  tzk0 = t69 + t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t47, t48, t52, t53, t54, t56;
  double t57, t58, t59, t61, t65, t69, t70, t71;
  double t73, t74, t75, t76, t77, t79, t80, t81;
  double t82, t83, t85, t89, t93, t94, t95, t96;
  double t98, t102, t106, tzk0;

  double t107, t108, t109, t111, t114, t115, t119, t120;
  double t123, t125, t126, t129, t133, t135, t139, t144;
  double t145, t147, t150, t151, t155, t158, t160, tvrho0;
  double t164, t167, t168, t173, t175, t178, t179, t184;
  double t185, t191, t193, t197, t202, tvrho1, t211, t215;
  double tvsigma0, tvsigma1, t222, t226, tvsigma2, t227, t228, t230;
  double t233, tvlapl0, t234, t235, t237, t240, tvlapl1, tvtau0;
  double tvtau1;

  mgga_k_pgslb_params *params;

  assert(p->params != NULL);
  params = (mgga_k_pgslb_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t47 = params->pgslb_mu * t33;
  t48 = t37 * sigma[0];
  t52 = exp(-t47 * t48 * t43 / 0.24e2);
  t53 = t33 * t33;
  t54 = params->pgslb_beta * t53;
  t56 = 0.1e1 / t35 / t34;
  t57 = lapl[0] * lapl[0];
  t58 = t56 * t57;
  t59 = t39 * rho[0];
  t61 = 0.1e1 / t40 / t59;
  t65 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43 + t52 + t54 * t58 * t61 / 0.576e3;
  t69 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t65);
  t70 = rho[1] <= p->dens_threshold;
  t71 = -t18;
  t73 = my_piecewise5(t16, t13, t12, t17, t71 * t9);
  t74 = 0.1e1 + t73;
  t75 = t74 <= p->zeta_threshold;
  t76 = POW_1_3(t74);
  t77 = t76 * t76;
  t79 = my_piecewise3(t75, t25, t77 * t74);
  t80 = t79 * t31;
  t81 = rho[1] * rho[1];
  t82 = POW_1_3(rho[1]);
  t83 = t82 * t82;
  t85 = 0.1e1 / t83 / t81;
  t89 = t37 * sigma[2];
  t93 = exp(-t47 * t89 * t85 / 0.24e2);
  t94 = lapl[1] * lapl[1];
  t95 = t56 * t94;
  t96 = t81 * rho[1];
  t98 = 0.1e1 / t82 / t96;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t85 + t93 + t54 * t95 * t98 / 0.576e3;
  t106 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t80 * t102);
  tzk0 = t69 + t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t107 = t8 * t8;
  t108 = 0.1e1 / t107;
  t109 = t18 * t108;
  t111 = my_piecewise5(t12, 0, t16, 0, t9 - t109);
  t114 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t111);
  t115 = t114 * t31;
  t119 = 0.1e1 / t30;
  t120 = t29 * t119;
  t123 = t7 * t120 * t65 / 0.1e2;
  t125 = 0.1e1 / t41 / t59;
  t126 = sigma[0] * t125;
  t129 = t47 * t37;
  t133 = t39 * t39;
  t135 = 0.1e1 / t40 / t133;
  t139 = -0.5e1 / 0.27e2 * t38 * t126 + t129 * t126 * t52 / 0.9e1 - 0.5e1 / 0.864e3 * t54 * t58 * t135;
  t144 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t115 * t65 + t123 + 0.3e1 / 0.2e2 * t7 * t32 * t139);
  t145 = t71 * t108;
  t147 = my_piecewise5(t16, 0, t12, 0, -t9 - t145);
  t150 = my_piecewise3(t75, 0, 0.5e1 / 0.3e1 * t77 * t147);
  t151 = t150 * t31;
  t155 = t79 * t119;
  t158 = t7 * t155 * t102 / 0.1e2;
  t160 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t151 * t102 + t158);
  tvrho0 = t69 + t106 + t8 * (t144 + t160);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t164 = my_piecewise5(t12, 0, t16, 0, -t9 - t109);
  t167 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t164);
  t168 = t167 * t31;
  t173 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t168 * t65 + t123);
  t175 = my_piecewise5(t16, 0, t12, 0, t9 - t145);
  t178 = my_piecewise3(t75, 0, 0.5e1 / 0.3e1 * t77 * t175);
  t179 = t178 * t31;
  t184 = 0.1e1 / t83 / t96;
  t185 = sigma[2] * t184;
  t191 = t81 * t81;
  t193 = 0.1e1 / t82 / t191;
  t197 = -0.5e1 / 0.27e2 * t38 * t185 + t129 * t185 * t93 / 0.9e1 - 0.5e1 / 0.864e3 * t54 * t95 * t193;
  t202 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t179 * t102 + t158 + 0.3e1 / 0.2e2 * t7 * t80 * t197);
  tvrho1 = t69 + t106 + t8 * (t173 + t202);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t211 = 0.5e1 / 0.72e2 * t38 * t43 - t47 * t37 * t43 * t52 / 0.24e2;
  t215 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t211);
  tvsigma0 = t8 * t215;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t222 = 0.5e1 / 0.72e2 * t38 * t85 - t47 * t37 * t85 * t93 / 0.24e2;
  t226 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t80 * t222);
  tvsigma2 = t8 * t226;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t227 = t7 * t32;
  t228 = t56 * lapl[0];
  t230 = t54 * t228 * t61;
  t233 = my_piecewise3(t2, 0, t227 * t230 / 0.192e4);
  tvlapl0 = t8 * t233;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t234 = t7 * t80;
  t235 = t56 * lapl[1];
  t237 = t54 * t235 * t98;
  t240 = my_piecewise3(t70, 0, t234 * t237 / 0.192e4);
  tvlapl1 = t8 * t240;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t47, t48, t52, t53, t54, t56;
  double t57, t58, t59, t61, t65, t69, t70, t71;
  double t73, t74, t75, t76, t77, t79, t80, t81;
  double t82, t83, t85, t89, t93, t94, t95, t96;
  double t98, t102, t106, tzk0;

  double t107, t108, t109, t111, t114, t115, t119, t120;
  double t123, t125, t126, t129, t133, t135, t139, t144;
  double t145, t147, t150, t151, t155, t158, t160, tvrho0;
  double t164, t167, t168, t173, t175, t178, t179, t184;
  double t185, t191, t193, t197, t202, tvrho1, t211, t215;
  double tvsigma0, tvsigma1, t222, t226, tvsigma2, t227, t228, t230;
  double t233, tvlapl0, t234, t235, t237, t240, tvlapl1, tvtau0;
  double tvtau1;

  double t243, t244, t247, t248, t249, t252, t256, t257;
  double t261, t263, t269, t270, t273, t275, t278, t279;
  double t285, t286, t287, t288, t291, t296, t298, t302;
  double t307, t308, t309, t312, t315, t319, t320, t324;
  double t326, t328, t331, t333, tv2rho20, t336, t340, t344;
  double t345, t349, t351, t359, t360, t364, t368, t369;
  double t373, t375, t382, t385, tv2rho21, t390, t395, t399;
  double t400, t406, t407, t412, t416, t417, t427, t428;
  double t434, t437, t442, t444, t448, t453, tv2rho22, t461;
  double t468, t470, t475, t480, tv2rhosigma0, tv2rhosigma1, t487, t489;
  double tv2rhosigma2, t495, tv2rhosigma3, tv2rhosigma4, t506, t508, t513, t518;
  double tv2rhosigma5, t520, t523, t525, t527, t531, tv2rholapl0, t533;
  double t536, t538, t540, tv2rholapl1, t542, t546, tv2rholapl2, t548;
  double t552, t556, tv2rholapl3, tv2rhotau0, tv2rhotau1, tv2rhotau2, tv2rhotau3, t558;
  double t560, t563, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t564;
  double t566, t569, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4;
  double tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t571;
  double t574, tv2lapl20, tv2lapl21, t576, t579, tv2lapl22, tv2lapltau0, tv2lapltau1;
  double tv2lapltau2, tv2lapltau3, tv2tau20, tv2tau21, tv2tau22;

  mgga_k_pgslb_params *params;

  assert(p->params != NULL);
  params = (mgga_k_pgslb_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t47 = params->pgslb_mu * t33;
  t48 = t37 * sigma[0];
  t52 = exp(-t47 * t48 * t43 / 0.24e2);
  t53 = t33 * t33;
  t54 = params->pgslb_beta * t53;
  t56 = 0.1e1 / t35 / t34;
  t57 = lapl[0] * lapl[0];
  t58 = t56 * t57;
  t59 = t39 * rho[0];
  t61 = 0.1e1 / t40 / t59;
  t65 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43 + t52 + t54 * t58 * t61 / 0.576e3;
  t69 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t65);
  t70 = rho[1] <= p->dens_threshold;
  t71 = -t18;
  t73 = my_piecewise5(t16, t13, t12, t17, t71 * t9);
  t74 = 0.1e1 + t73;
  t75 = t74 <= p->zeta_threshold;
  t76 = POW_1_3(t74);
  t77 = t76 * t76;
  t79 = my_piecewise3(t75, t25, t77 * t74);
  t80 = t79 * t31;
  t81 = rho[1] * rho[1];
  t82 = POW_1_3(rho[1]);
  t83 = t82 * t82;
  t85 = 0.1e1 / t83 / t81;
  t89 = t37 * sigma[2];
  t93 = exp(-t47 * t89 * t85 / 0.24e2);
  t94 = lapl[1] * lapl[1];
  t95 = t56 * t94;
  t96 = t81 * rho[1];
  t98 = 0.1e1 / t82 / t96;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t85 + t93 + t54 * t95 * t98 / 0.576e3;
  t106 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t80 * t102);
  tzk0 = t69 + t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t107 = t8 * t8;
  t108 = 0.1e1 / t107;
  t109 = t18 * t108;
  t111 = my_piecewise5(t12, 0, t16, 0, t9 - t109);
  t114 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t111);
  t115 = t114 * t31;
  t119 = 0.1e1 / t30;
  t120 = t29 * t119;
  t123 = t7 * t120 * t65 / 0.1e2;
  t125 = 0.1e1 / t41 / t59;
  t126 = sigma[0] * t125;
  t129 = t47 * t37;
  t133 = t39 * t39;
  t135 = 0.1e1 / t40 / t133;
  t139 = -0.5e1 / 0.27e2 * t38 * t126 + t129 * t126 * t52 / 0.9e1 - 0.5e1 / 0.864e3 * t54 * t58 * t135;
  t144 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t115 * t65 + t123 + 0.3e1 / 0.2e2 * t7 * t32 * t139);
  t145 = t71 * t108;
  t147 = my_piecewise5(t16, 0, t12, 0, -t9 - t145);
  t150 = my_piecewise3(t75, 0, 0.5e1 / 0.3e1 * t77 * t147);
  t151 = t150 * t31;
  t155 = t79 * t119;
  t158 = t7 * t155 * t102 / 0.1e2;
  t160 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t151 * t102 + t158);
  tvrho0 = t69 + t106 + t8 * (t144 + t160);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t164 = my_piecewise5(t12, 0, t16, 0, -t9 - t109);
  t167 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t164);
  t168 = t167 * t31;
  t173 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t168 * t65 + t123);
  t175 = my_piecewise5(t16, 0, t12, 0, t9 - t145);
  t178 = my_piecewise3(t75, 0, 0.5e1 / 0.3e1 * t77 * t175);
  t179 = t178 * t31;
  t184 = 0.1e1 / t83 / t96;
  t185 = sigma[2] * t184;
  t191 = t81 * t81;
  t193 = 0.1e1 / t82 / t191;
  t197 = -0.5e1 / 0.27e2 * t38 * t185 + t129 * t185 * t93 / 0.9e1 - 0.5e1 / 0.864e3 * t54 * t95 * t193;
  t202 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t179 * t102 + t158 + 0.3e1 / 0.2e2 * t7 * t80 * t197);
  tvrho1 = t69 + t106 + t8 * (t173 + t202);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t211 = 0.5e1 / 0.72e2 * t38 * t43 - t47 * t37 * t43 * t52 / 0.24e2;
  t215 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t211);
  tvsigma0 = t8 * t215;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t222 = 0.5e1 / 0.72e2 * t38 * t85 - t47 * t37 * t85 * t93 / 0.24e2;
  t226 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t80 * t222);
  tvsigma2 = t8 * t226;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t227 = t7 * t32;
  t228 = t56 * lapl[0];
  t230 = t54 * t228 * t61;
  t233 = my_piecewise3(t2, 0, t227 * t230 / 0.192e4);
  tvlapl0 = t8 * t233;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t234 = t7 * t80;
  t235 = t56 * lapl[1];
  t237 = t54 * t235 * t98;
  t240 = my_piecewise3(t70, 0, t234 * t237 / 0.192e4);
  tvlapl1 = t8 * t240;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t243 = 0.1e1 / t26;
  t244 = t111 * t111;
  t247 = t107 * t8;
  t248 = 0.1e1 / t247;
  t249 = t18 * t248;
  t252 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t108 + 0.2e1 * t249);
  t256 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t243 * t244 + 0.5e1 / 0.3e1 * t27 * t252);
  t257 = t256 * t31;
  t261 = t114 * t119;
  t263 = t7 * t261 * t65;
  t269 = 0.1e1 / t30 / t8;
  t270 = t29 * t269;
  t273 = t7 * t270 * t65 / 0.3e2;
  t275 = t7 * t120 * t139;
  t278 = 0.1e1 / t41 / t133;
  t279 = sigma[0] * t278;
  t285 = params->pgslb_mu * params->pgslb_mu;
  t286 = t285 * t53;
  t287 = t286 * t56;
  t288 = sigma[0] * sigma[0];
  t291 = 0.1e1 / t40 / t133 / t59;
  t296 = t133 * rho[0];
  t298 = 0.1e1 / t40 / t296;
  t302 = 0.55e2 / 0.81e2 * t38 * t279 - 0.11e2 / 0.27e2 * t129 * t279 * t52 + t287 * t288 * t291 * t52 / 0.81e2 + 0.65e2 / 0.2592e4 * t54 * t58 * t298;
  t307 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t257 * t65 + t263 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t115 * t139 - t273 + t275 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t302);
  t308 = 0.1e1 / t76;
  t309 = t147 * t147;
  t312 = t71 * t248;
  t315 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t108 + 0.2e1 * t312);
  t319 = my_piecewise3(t75, 0, 0.1e2 / 0.9e1 * t308 * t309 + 0.5e1 / 0.3e1 * t77 * t315);
  t320 = t319 * t31;
  t324 = t150 * t119;
  t326 = t7 * t324 * t102;
  t328 = t79 * t269;
  t331 = t7 * t328 * t102 / 0.3e2;
  t333 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t320 * t102 + t326 / 0.5e1 - t331);
  tv2rho20 = 0.2e1 * t144 + 0.2e1 * t160 + t8 * (t307 + t333);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t336 = t243 * t164;
  t340 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t249);
  t344 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t336 * t111 + 0.5e1 / 0.3e1 * t27 * t340);
  t345 = t344 * t31;
  t349 = t167 * t119;
  t351 = t7 * t349 * t65;
  t359 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t345 * t65 + t351 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t168 * t139 + t263 / 0.1e2 - t273 + t275 / 0.1e2);
  t360 = t308 * t175;
  t364 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t312);
  t368 = my_piecewise3(t75, 0, 0.1e2 / 0.9e1 * t360 * t147 + 0.5e1 / 0.3e1 * t77 * t364);
  t369 = t368 * t31;
  t373 = t178 * t119;
  t375 = t7 * t373 * t102;
  t382 = t7 * t155 * t197;
  t385 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t369 * t102 + t375 / 0.1e2 + t326 / 0.1e2 - t331 + 0.3e1 / 0.2e2 * t7 * t151 * t197 + t382 / 0.1e2);
  tv2rho21 = t144 + t160 + t173 + t202 + t8 * (t359 + t385);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t390 = t164 * t164;
  t395 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t108 + 0.2e1 * t249);
  t399 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t243 * t390 + 0.5e1 / 0.3e1 * t27 * t395);
  t400 = t399 * t31;
  t406 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t400 * t65 + t351 / 0.5e1 - t273);
  t407 = t175 * t175;
  t412 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t108 + 0.2e1 * t312);
  t416 = my_piecewise3(t75, 0, 0.1e2 / 0.9e1 * t308 * t407 + 0.5e1 / 0.3e1 * t77 * t412);
  t417 = t416 * t31;
  t427 = 0.1e1 / t83 / t191;
  t428 = sigma[2] * t427;
  t434 = sigma[2] * sigma[2];
  t437 = 0.1e1 / t82 / t191 / t96;
  t442 = t191 * rho[1];
  t444 = 0.1e1 / t82 / t442;
  t448 = 0.55e2 / 0.81e2 * t38 * t428 - 0.11e2 / 0.27e2 * t129 * t428 * t93 + t287 * t434 * t437 * t93 / 0.81e2 + 0.65e2 / 0.2592e4 * t54 * t95 * t444;
  t453 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t417 * t102 + t375 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t179 * t197 - t331 + t382 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t80 * t448);
  tv2rho22 = 0.2e1 * t173 + 0.2e1 * t202 + t8 * (t406 + t453);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t461 = t7 * t120 * t211 / 0.1e2;
  t468 = t133 * t39;
  t470 = 0.1e1 / t40 / t468;
  t475 = -0.5e1 / 0.27e2 * t38 * t125 + t47 * t37 * t125 * t52 / 0.9e1 - t287 * t470 * sigma[0] * t52 / 0.216e3;
  t480 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t115 * t211 + t461 + 0.3e1 / 0.2e2 * t7 * t32 * t475);
  tv2rhosigma0 = t8 * t480 + t215;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t487 = t7 * t155 * t222 / 0.1e2;
  t489 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t151 * t222 + t487);
  tv2rhosigma2 = t8 * t489 + t226;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t495 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t168 * t211 + t461);
  tv2rhosigma3 = t8 * t495 + t215;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t506 = t191 * t81;
  t508 = 0.1e1 / t82 / t506;
  t513 = -0.5e1 / 0.27e2 * t38 * t184 + t47 * t37 * t184 * t93 / 0.9e1 - t287 * t508 * sigma[2] * t93 / 0.216e3;
  t518 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t179 * t222 + t487 + 0.3e1 / 0.2e2 * t7 * t80 * t513);
  tv2rhosigma5 = t8 * t518 + t226;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t520 = t7 * t115;
  t523 = t7 * t120;
  t525 = t523 * t230 / 0.288e4;
  t527 = t54 * t228 * t135;
  t531 = my_piecewise3(t2, 0, t520 * t230 / 0.192e4 + t525 - t227 * t527 / 0.576e3);
  tv2rholapl0 = t8 * t531 + t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t533 = t7 * t151;
  t536 = t7 * t155;
  t538 = t536 * t237 / 0.288e4;
  t540 = my_piecewise3(t70, 0, t533 * t237 / 0.192e4 + t538);
  tv2rholapl1 = t8 * t540 + t240;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t542 = t7 * t168;
  t546 = my_piecewise3(t2, 0, t542 * t230 / 0.192e4 + t525);
  tv2rholapl2 = t8 * t546 + t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t548 = t7 * t179;
  t552 = t54 * t235 * t193;
  t556 = my_piecewise3(t70, 0, t548 * t237 / 0.192e4 + t538 - t234 * t552 / 0.576e3);
  tv2rholapl3 = t8 * t556 + t240;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t558 = t56 * t298;
  t560 = t286 * t558 * t52;
  t563 = my_piecewise3(t2, 0, t227 * t560 / 0.384e4);
  tv2sigma20 = t8 * t563;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t564 = t56 * t444;
  t566 = t286 * t564 * t93;
  t569 = my_piecewise3(t70, 0, t234 * t566 / 0.384e4);
  tv2sigma25 = t8 * t569;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t571 = t54 * t56 * t61;
  t574 = my_piecewise3(t2, 0, t227 * t571 / 0.192e4);
  tv2lapl20 = t8 * t574;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t576 = t54 * t56 * t98;
  t579 = my_piecewise3(t70, 0, t234 * t576 / 0.192e4);
  tv2lapl22 = t8 * t579;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t47, t48, t52, t53, t54, t56;
  double t57, t58, t59, t61, t65, t69, t70, t71;
  double t73, t74, t75, t76, t77, t79, t80, t81;
  double t82, t83, t85, t89, t93, t94, t95, t96;
  double t98, t102, t106, tzk0;

  double t107, t108, t109, t111, t114, t115, t119, t120;
  double t123, t125, t126, t129, t133, t135, t139, t144;
  double t145, t147, t150, t151, t155, t158, t160, tvrho0;
  double t164, t167, t168, t173, t175, t178, t179, t184;
  double t185, t191, t193, t197, t202, tvrho1, t211, t215;
  double tvsigma0, tvsigma1, t222, t226, tvsigma2, t227, t228, t230;
  double t233, tvlapl0, t234, t235, t237, t240, tvlapl1, tvtau0;
  double tvtau1;

  double t243, t244, t247, t248, t249, t252, t256, t257;
  double t261, t263, t269, t270, t273, t275, t278, t279;
  double t285, t286, t287, t288, t291, t296, t298, t302;
  double t307, t308, t309, t312, t315, t319, t320, t324;
  double t326, t328, t331, t333, tv2rho20, t336, t340, t344;
  double t345, t349, t351, t359, t360, t364, t368, t369;
  double t373, t375, t382, t385, tv2rho21, t390, t395, t399;
  double t400, t406, t407, t412, t416, t417, t427, t428;
  double t434, t437, t442, t444, t448, t453, tv2rho22, t461;
  double t468, t470, t475, t480, tv2rhosigma0, tv2rhosigma1, t487, t489;
  double tv2rhosigma2, t495, tv2rhosigma3, tv2rhosigma4, t506, t508, t513, t518;
  double tv2rhosigma5, t520, t523, t525, t527, t531, tv2rholapl0, t533;
  double t536, t538, t540, tv2rholapl1, t542, t546, tv2rholapl2, t548;
  double t552, t556, tv2rholapl3, tv2rhotau0, tv2rhotau1, tv2rhotau2, tv2rhotau3, t558;
  double t560, t563, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t564;
  double t566, t569, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4;
  double tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t571;
  double t574, tv2lapl20, tv2lapl21, t576, t579, tv2lapl22, tv2lapltau0, tv2lapltau1;
  double tv2lapltau2, tv2lapltau3, tv2tau20, tv2tau21, tv2tau22;

  double t583, t584, t587, t590, t591, t592, t595, t599;
  double t600, t604, t606, t611, t613, t616, t622, t623;
  double t626, t628, t631, t634, t635, t641, t643, t648;
  double t649, t650, t651, t652, t653, t654, t662, t667;
  double t669, t670, t673, t676, t679, t683, t684, t688;
  double t690, t692, t694, t696, t699, t701, tv3rho30, t704;
  double t705, t706, t709, t714, t715, t717, t721, t722;
  double t726, t729, t733, t735, t739, t748, t749, t750;
  double t753, t758, t760, t764, t765, t769, t772, t773;
  double t775, t784, t786, t789, tv3rho31, t792, t797, t801;
  double t805, t806, t810, t812, t821, t822, t827, t831;
  double t835, t836, t840, t842, t849, t857, t859, t860;
  double tv3rho32, t865, t872, t876, t877, t884, t885, t892;
  double t896, t897, t913, t914, t920, t922, t927, t928;
  double t929, t937, t942, tv3rho33, t950, t957, t959, t971;
  double t972, t977, t982, tv3rho2sigma0, tv3rho2sigma1, t989, t993, t995;
  double tv3rho2sigma2, t1001, t1009, tv3rho2sigma3, tv3rho2sigma4, t1015, t1022, t1025;
  double tv3rho2sigma5, t1033, tv3rho2sigma6, tv3rho2sigma7, t1054, t1055, t1060, t1065;
  double tv3rho2sigma8, t1068, t1071, t1072, t1076, t1078, t1079, t1082;
  double t1086, tv3rho2lapl0, t1089, t1092, t1093, t1095, t1097, t1099;
  double tv3rho2lapl1, t1101, t1104, t1105, t1112, tv3rho2lapl2, t1114, t1117;
  double t1118, t1123, t1126, tv3rho2lapl3, t1129, t1134, tv3rho2lapl4, t1137;
  double t1145, t1149, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1, tv3rho2tau2, tv3rho2tau3, tv3rho2tau4;
  double tv3rho2tau5, t1154, t1157, t1160, t1163, t1164, t1165, t1166;
  double t1168, t1169, t1173, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double t1178, t1180, tv3rhosigma25, t1185, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t1191, t1194, t1195, t1196, t1198, t1199, t1203;
  double tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2;
  double tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10;
  double tv3rhosigmatau11, t1208, t1210, t1214, tv3rholapl20, tv3rholapl21, t1219, t1221;
  double tv3rholapl22, t1226, tv3rholapl23, tv3rholapl24, t1231, t1235, tv3rholapl25, tv3rholapltau0;
  double tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, tv3rhotau20;
  double tv3rhotau21, tv3rhotau22, tv3rhotau23, tv3rhotau24, tv3rhotau25, t1237, t1238, t1240;
  double t1241, t1244, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t1245, t1247, t1248, t1251, tv3sigma39;
  double tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7;
  double tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3;
  double tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11;
  double tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27;
  double tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6;
  double tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22;
  double tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, tv3lapl30, tv3lapl31;
  double tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5;
  double tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, tv3tau30, tv3tau31;
  double tv3tau32, tv3tau33;

  mgga_k_pgslb_params *params;

  assert(p->params != NULL);
  params = (mgga_k_pgslb_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t47 = params->pgslb_mu * t33;
  t48 = t37 * sigma[0];
  t52 = exp(-t47 * t48 * t43 / 0.24e2);
  t53 = t33 * t33;
  t54 = params->pgslb_beta * t53;
  t56 = 0.1e1 / t35 / t34;
  t57 = lapl[0] * lapl[0];
  t58 = t56 * t57;
  t59 = t39 * rho[0];
  t61 = 0.1e1 / t40 / t59;
  t65 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43 + t52 + t54 * t58 * t61 / 0.576e3;
  t69 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t65);
  t70 = rho[1] <= p->dens_threshold;
  t71 = -t18;
  t73 = my_piecewise5(t16, t13, t12, t17, t71 * t9);
  t74 = 0.1e1 + t73;
  t75 = t74 <= p->zeta_threshold;
  t76 = POW_1_3(t74);
  t77 = t76 * t76;
  t79 = my_piecewise3(t75, t25, t77 * t74);
  t80 = t79 * t31;
  t81 = rho[1] * rho[1];
  t82 = POW_1_3(rho[1]);
  t83 = t82 * t82;
  t85 = 0.1e1 / t83 / t81;
  t89 = t37 * sigma[2];
  t93 = exp(-t47 * t89 * t85 / 0.24e2);
  t94 = lapl[1] * lapl[1];
  t95 = t56 * t94;
  t96 = t81 * rho[1];
  t98 = 0.1e1 / t82 / t96;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t85 + t93 + t54 * t95 * t98 / 0.576e3;
  t106 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t80 * t102);
  tzk0 = t69 + t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t107 = t8 * t8;
  t108 = 0.1e1 / t107;
  t109 = t18 * t108;
  t111 = my_piecewise5(t12, 0, t16, 0, t9 - t109);
  t114 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t111);
  t115 = t114 * t31;
  t119 = 0.1e1 / t30;
  t120 = t29 * t119;
  t123 = t7 * t120 * t65 / 0.1e2;
  t125 = 0.1e1 / t41 / t59;
  t126 = sigma[0] * t125;
  t129 = t47 * t37;
  t133 = t39 * t39;
  t135 = 0.1e1 / t40 / t133;
  t139 = -0.5e1 / 0.27e2 * t38 * t126 + t129 * t126 * t52 / 0.9e1 - 0.5e1 / 0.864e3 * t54 * t58 * t135;
  t144 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t115 * t65 + t123 + 0.3e1 / 0.2e2 * t7 * t32 * t139);
  t145 = t71 * t108;
  t147 = my_piecewise5(t16, 0, t12, 0, -t9 - t145);
  t150 = my_piecewise3(t75, 0, 0.5e1 / 0.3e1 * t77 * t147);
  t151 = t150 * t31;
  t155 = t79 * t119;
  t158 = t7 * t155 * t102 / 0.1e2;
  t160 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t151 * t102 + t158);
  tvrho0 = t69 + t106 + t8 * (t144 + t160);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t164 = my_piecewise5(t12, 0, t16, 0, -t9 - t109);
  t167 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t164);
  t168 = t167 * t31;
  t173 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t168 * t65 + t123);
  t175 = my_piecewise5(t16, 0, t12, 0, t9 - t145);
  t178 = my_piecewise3(t75, 0, 0.5e1 / 0.3e1 * t77 * t175);
  t179 = t178 * t31;
  t184 = 0.1e1 / t83 / t96;
  t185 = sigma[2] * t184;
  t191 = t81 * t81;
  t193 = 0.1e1 / t82 / t191;
  t197 = -0.5e1 / 0.27e2 * t38 * t185 + t129 * t185 * t93 / 0.9e1 - 0.5e1 / 0.864e3 * t54 * t95 * t193;
  t202 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t179 * t102 + t158 + 0.3e1 / 0.2e2 * t7 * t80 * t197);
  tvrho1 = t69 + t106 + t8 * (t173 + t202);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t211 = 0.5e1 / 0.72e2 * t38 * t43 - t47 * t37 * t43 * t52 / 0.24e2;
  t215 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t211);
  tvsigma0 = t8 * t215;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t222 = 0.5e1 / 0.72e2 * t38 * t85 - t47 * t37 * t85 * t93 / 0.24e2;
  t226 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t80 * t222);
  tvsigma2 = t8 * t226;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t227 = t7 * t32;
  t228 = t56 * lapl[0];
  t230 = t54 * t228 * t61;
  t233 = my_piecewise3(t2, 0, t227 * t230 / 0.192e4);
  tvlapl0 = t8 * t233;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t234 = t7 * t80;
  t235 = t56 * lapl[1];
  t237 = t54 * t235 * t98;
  t240 = my_piecewise3(t70, 0, t234 * t237 / 0.192e4);
  tvlapl1 = t8 * t240;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t243 = 0.1e1 / t26;
  t244 = t111 * t111;
  t247 = t107 * t8;
  t248 = 0.1e1 / t247;
  t249 = t18 * t248;
  t252 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t108 + 0.2e1 * t249);
  t256 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t243 * t244 + 0.5e1 / 0.3e1 * t27 * t252);
  t257 = t256 * t31;
  t261 = t114 * t119;
  t263 = t7 * t261 * t65;
  t269 = 0.1e1 / t30 / t8;
  t270 = t29 * t269;
  t273 = t7 * t270 * t65 / 0.3e2;
  t275 = t7 * t120 * t139;
  t278 = 0.1e1 / t41 / t133;
  t279 = sigma[0] * t278;
  t285 = params->pgslb_mu * params->pgslb_mu;
  t286 = t285 * t53;
  t287 = t286 * t56;
  t288 = sigma[0] * sigma[0];
  t291 = 0.1e1 / t40 / t133 / t59;
  t296 = t133 * rho[0];
  t298 = 0.1e1 / t40 / t296;
  t302 = 0.55e2 / 0.81e2 * t38 * t279 - 0.11e2 / 0.27e2 * t129 * t279 * t52 + t287 * t288 * t291 * t52 / 0.81e2 + 0.65e2 / 0.2592e4 * t54 * t58 * t298;
  t307 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t257 * t65 + t263 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t115 * t139 - t273 + t275 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t302);
  t308 = 0.1e1 / t76;
  t309 = t147 * t147;
  t312 = t71 * t248;
  t315 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t108 + 0.2e1 * t312);
  t319 = my_piecewise3(t75, 0, 0.1e2 / 0.9e1 * t308 * t309 + 0.5e1 / 0.3e1 * t77 * t315);
  t320 = t319 * t31;
  t324 = t150 * t119;
  t326 = t7 * t324 * t102;
  t328 = t79 * t269;
  t331 = t7 * t328 * t102 / 0.3e2;
  t333 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t320 * t102 + t326 / 0.5e1 - t331);
  tv2rho20 = 0.2e1 * t144 + 0.2e1 * t160 + t8 * (t307 + t333);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t336 = t243 * t164;
  t340 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t249);
  t344 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t336 * t111 + 0.5e1 / 0.3e1 * t27 * t340);
  t345 = t344 * t31;
  t349 = t167 * t119;
  t351 = t7 * t349 * t65;
  t359 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t345 * t65 + t351 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t168 * t139 + t263 / 0.1e2 - t273 + t275 / 0.1e2);
  t360 = t308 * t175;
  t364 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t312);
  t368 = my_piecewise3(t75, 0, 0.1e2 / 0.9e1 * t360 * t147 + 0.5e1 / 0.3e1 * t77 * t364);
  t369 = t368 * t31;
  t373 = t178 * t119;
  t375 = t7 * t373 * t102;
  t382 = t7 * t155 * t197;
  t385 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t369 * t102 + t375 / 0.1e2 + t326 / 0.1e2 - t331 + 0.3e1 / 0.2e2 * t7 * t151 * t197 + t382 / 0.1e2);
  tv2rho21 = t144 + t160 + t173 + t202 + t8 * (t359 + t385);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t390 = t164 * t164;
  t395 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t108 + 0.2e1 * t249);
  t399 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t243 * t390 + 0.5e1 / 0.3e1 * t27 * t395);
  t400 = t399 * t31;
  t406 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t400 * t65 + t351 / 0.5e1 - t273);
  t407 = t175 * t175;
  t412 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t108 + 0.2e1 * t312);
  t416 = my_piecewise3(t75, 0, 0.1e2 / 0.9e1 * t308 * t407 + 0.5e1 / 0.3e1 * t77 * t412);
  t417 = t416 * t31;
  t427 = 0.1e1 / t83 / t191;
  t428 = sigma[2] * t427;
  t434 = sigma[2] * sigma[2];
  t437 = 0.1e1 / t82 / t191 / t96;
  t442 = t191 * rho[1];
  t444 = 0.1e1 / t82 / t442;
  t448 = 0.55e2 / 0.81e2 * t38 * t428 - 0.11e2 / 0.27e2 * t129 * t428 * t93 + t287 * t434 * t437 * t93 / 0.81e2 + 0.65e2 / 0.2592e4 * t54 * t95 * t444;
  t453 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t417 * t102 + t375 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t179 * t197 - t331 + t382 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t80 * t448);
  tv2rho22 = 0.2e1 * t173 + 0.2e1 * t202 + t8 * (t406 + t453);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t461 = t7 * t120 * t211 / 0.1e2;
  t468 = t133 * t39;
  t470 = 0.1e1 / t40 / t468;
  t475 = -0.5e1 / 0.27e2 * t38 * t125 + t47 * t37 * t125 * t52 / 0.9e1 - t287 * t470 * sigma[0] * t52 / 0.216e3;
  t480 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t115 * t211 + t461 + 0.3e1 / 0.2e2 * t7 * t32 * t475);
  tv2rhosigma0 = t8 * t480 + t215;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t487 = t7 * t155 * t222 / 0.1e2;
  t489 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t151 * t222 + t487);
  tv2rhosigma2 = t8 * t489 + t226;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t495 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t168 * t211 + t461);
  tv2rhosigma3 = t8 * t495 + t215;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t506 = t191 * t81;
  t508 = 0.1e1 / t82 / t506;
  t513 = -0.5e1 / 0.27e2 * t38 * t184 + t47 * t37 * t184 * t93 / 0.9e1 - t287 * t508 * sigma[2] * t93 / 0.216e3;
  t518 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t179 * t222 + t487 + 0.3e1 / 0.2e2 * t7 * t80 * t513);
  tv2rhosigma5 = t8 * t518 + t226;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t520 = t7 * t115;
  t523 = t7 * t120;
  t525 = t523 * t230 / 0.288e4;
  t527 = t54 * t228 * t135;
  t531 = my_piecewise3(t2, 0, t520 * t230 / 0.192e4 + t525 - t227 * t527 / 0.576e3);
  tv2rholapl0 = t8 * t531 + t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t533 = t7 * t151;
  t536 = t7 * t155;
  t538 = t536 * t237 / 0.288e4;
  t540 = my_piecewise3(t70, 0, t533 * t237 / 0.192e4 + t538);
  tv2rholapl1 = t8 * t540 + t240;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t542 = t7 * t168;
  t546 = my_piecewise3(t2, 0, t542 * t230 / 0.192e4 + t525);
  tv2rholapl2 = t8 * t546 + t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t548 = t7 * t179;
  t552 = t54 * t235 * t193;
  t556 = my_piecewise3(t70, 0, t548 * t237 / 0.192e4 + t538 - t234 * t552 / 0.576e3);
  tv2rholapl3 = t8 * t556 + t240;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t558 = t56 * t298;
  t560 = t286 * t558 * t52;
  t563 = my_piecewise3(t2, 0, t227 * t560 / 0.384e4);
  tv2sigma20 = t8 * t563;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t564 = t56 * t444;
  t566 = t286 * t564 * t93;
  t569 = my_piecewise3(t70, 0, t234 * t566 / 0.384e4);
  tv2sigma25 = t8 * t569;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t571 = t54 * t56 * t61;
  t574 = my_piecewise3(t2, 0, t227 * t571 / 0.192e4);
  tv2lapl20 = t8 * t574;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t576 = t54 * t56 * t98;
  t579 = my_piecewise3(t70, 0, t234 * t576 / 0.192e4);
  tv2lapl22 = t8 * t579;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t583 = 0.1e1 / t26 / t21;
  t584 = t244 * t111;
  t587 = t243 * t111;
  t590 = t107 * t107;
  t591 = 0.1e1 / t590;
  t592 = t18 * t591;
  t595 = my_piecewise5(t12, 0, t16, 0, 0.6e1 * t248 - 0.6e1 * t592);
  t599 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t583 * t584 + 0.1e2 / 0.3e1 * t587 * t252 + 0.5e1 / 0.3e1 * t27 * t595);
  t600 = t599 * t31;
  t604 = t256 * t119;
  t606 = t7 * t604 * t65;
  t611 = t114 * t269;
  t613 = t7 * t611 * t65;
  t616 = t7 * t261 * t139;
  t622 = 0.1e1 / t30 / t107;
  t623 = t29 * t622;
  t626 = 0.2e1 / 0.45e2 * t7 * t623 * t65;
  t628 = t7 * t270 * t139;
  t631 = t7 * t120 * t302;
  t634 = 0.1e1 / t41 / t296;
  t635 = sigma[0] * t634;
  t641 = t133 * t133;
  t643 = 0.1e1 / t40 / t641;
  t648 = t285 * params->pgslb_mu;
  t649 = t34 * t34;
  t650 = 0.1e1 / t649;
  t651 = t648 * t650;
  t652 = t288 * sigma[0];
  t653 = t641 * t59;
  t654 = 0.1e1 / t653;
  t662 = -0.77e3 / 0.243e3 * t38 * t635 + 0.154e3 / 0.81e2 * t129 * t635 * t52 - 0.11e2 / 0.81e2 * t287 * t288 * t643 * t52 + 0.2e1 / 0.243e3 * t651 * t652 * t654 * t52 - 0.65e2 / 0.486e3 * t54 * t58 * t470;
  t667 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t600 * t65 + 0.3e1 / 0.1e2 * t606 + 0.9e1 / 0.2e2 * t7 * t257 * t139 - t613 / 0.1e2 + 0.3e1 / 0.5e1 * t616 + 0.9e1 / 0.2e2 * t7 * t115 * t302 + t626 - t628 / 0.1e2 + 0.3e1 / 0.1e2 * t631 + 0.3e1 / 0.2e2 * t7 * t32 * t662);
  t669 = 0.1e1 / t76 / t74;
  t670 = t309 * t147;
  t673 = t308 * t147;
  t676 = t71 * t591;
  t679 = my_piecewise5(t16, 0, t12, 0, -0.6e1 * t248 - 0.6e1 * t676);
  t683 = my_piecewise3(t75, 0, -0.1e2 / 0.27e2 * t669 * t670 + 0.1e2 / 0.3e1 * t673 * t315 + 0.5e1 / 0.3e1 * t77 * t679);
  t684 = t683 * t31;
  t688 = t319 * t119;
  t690 = t7 * t688 * t102;
  t692 = t150 * t269;
  t694 = t7 * t692 * t102;
  t696 = t79 * t622;
  t699 = 0.2e1 / 0.45e2 * t7 * t696 * t102;
  t701 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t684 * t102 + 0.3e1 / 0.1e2 * t690 - t694 / 0.1e2 + t699);
  tv3rho30 = 0.3e1 * t307 + 0.3e1 * t333 + t8 * (t667 + t701);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t704 = 0.2e1 * t359;
  t705 = 0.2e1 * t385;
  t706 = t583 * t164;
  t709 = t243 * t340;
  t714 = 0.2e1 * t248;
  t715 = 0.6e1 * t592;
  t717 = my_piecewise5(t12, 0, t16, 0, t714 - t715);
  t721 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t706 * t244 + 0.2e2 / 0.9e1 * t709 * t111 + 0.1e2 / 0.9e1 * t336 * t252 + 0.5e1 / 0.3e1 * t27 * t717);
  t722 = t721 * t31;
  t726 = t344 * t119;
  t729 = t7 * t726 * t65 / 0.5e1;
  t733 = t167 * t269;
  t735 = t7 * t733 * t65;
  t739 = t7 * t349 * t139 / 0.5e1;
  t748 = 0.3e1 / 0.2e2 * t7 * t722 * t65 + t729 + 0.3e1 / 0.1e2 * t7 * t345 * t139 - t735 / 0.3e2 + t739 + 0.3e1 / 0.2e2 * t7 * t168 * t302 + t606 / 0.1e2 - t613 / 0.15e2 + t616 / 0.5e1 + t626 - t628 / 0.15e2 + t631 / 0.1e2;
  t749 = my_piecewise3(t2, 0, t748);
  t750 = t669 * t175;
  t753 = t308 * t364;
  t758 = 0.6e1 * t676;
  t760 = my_piecewise5(t16, 0, t12, 0, -t714 - t758);
  t764 = my_piecewise3(t75, 0, -0.1e2 / 0.27e2 * t750 * t309 + 0.2e2 / 0.9e1 * t753 * t147 + 0.1e2 / 0.9e1 * t360 * t315 + 0.5e1 / 0.3e1 * t77 * t760);
  t765 = t764 * t31;
  t769 = t368 * t119;
  t772 = t7 * t769 * t102 / 0.5e1;
  t773 = t178 * t269;
  t775 = t7 * t773 * t102;
  t784 = t7 * t324 * t197 / 0.5e1;
  t786 = t7 * t328 * t197;
  t789 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t765 * t102 + t772 - t775 / 0.3e2 + t690 / 0.1e2 - t694 / 0.15e2 + t699 + 0.3e1 / 0.2e2 * t7 * t320 * t197 + t784 - t786 / 0.3e2);
  tv3rho31 = t307 + t333 + t704 + t705 + t8 * (t749 + t789);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t792 = t583 * t390;
  t797 = t243 * t395;
  t801 = my_piecewise5(t12, 0, t16, 0, -t714 - t715);
  t805 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t792 * t111 + 0.2e2 / 0.9e1 * t336 * t340 + 0.1e2 / 0.9e1 * t797 * t111 + 0.5e1 / 0.3e1 * t27 * t801);
  t806 = t805 * t31;
  t810 = t399 * t119;
  t812 = t7 * t810 * t65;
  t821 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t806 * t65 + t812 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t400 * t139 + t729 - t735 / 0.15e2 + t739 - t613 / 0.3e2 + t626 - t628 / 0.3e2);
  t822 = t669 * t407;
  t827 = t308 * t412;
  t831 = my_piecewise5(t16, 0, t12, 0, t714 - t758);
  t835 = my_piecewise3(t75, 0, -0.1e2 / 0.27e2 * t822 * t147 + 0.2e2 / 0.9e1 * t360 * t364 + 0.1e2 / 0.9e1 * t827 * t147 + 0.5e1 / 0.3e1 * t77 * t831);
  t836 = t835 * t31;
  t840 = t416 * t119;
  t842 = t7 * t840 * t102;
  t849 = t7 * t373 * t197;
  t857 = t7 * t155 * t448;
  t859 = 0.3e1 / 0.2e2 * t7 * t836 * t102 + t842 / 0.1e2 + t772 - t775 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t369 * t197 + t849 / 0.5e1 - t694 / 0.3e2 + t699 + t784 - t786 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t151 * t448 + t857 / 0.1e2;
  t860 = my_piecewise3(t70, 0, t859);
  tv3rho32 = t704 + t705 + t406 + t453 + t8 * (t821 + t860);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t865 = t390 * t164;
  t872 = my_piecewise5(t12, 0, t16, 0, -0.6e1 * t248 - 0.6e1 * t592);
  t876 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t583 * t865 + 0.1e2 / 0.3e1 * t336 * t395 + 0.5e1 / 0.3e1 * t27 * t872);
  t877 = t876 * t31;
  t884 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t877 * t65 + 0.3e1 / 0.1e2 * t812 - t735 / 0.1e2 + t626);
  t885 = t407 * t175;
  t892 = my_piecewise5(t16, 0, t12, 0, 0.6e1 * t248 - 0.6e1 * t676);
  t896 = my_piecewise3(t75, 0, -0.1e2 / 0.27e2 * t669 * t885 + 0.1e2 / 0.3e1 * t360 * t412 + 0.5e1 / 0.3e1 * t77 * t892);
  t897 = t896 * t31;
  t913 = 0.1e1 / t83 / t442;
  t914 = sigma[2] * t913;
  t920 = t191 * t191;
  t922 = 0.1e1 / t82 / t920;
  t927 = t434 * sigma[2];
  t928 = t920 * t96;
  t929 = 0.1e1 / t928;
  t937 = -0.77e3 / 0.243e3 * t38 * t914 + 0.154e3 / 0.81e2 * t129 * t914 * t93 - 0.11e2 / 0.81e2 * t287 * t434 * t922 * t93 + 0.2e1 / 0.243e3 * t651 * t927 * t929 * t93 - 0.65e2 / 0.486e3 * t54 * t95 * t508;
  t942 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t897 * t102 + 0.3e1 / 0.1e2 * t842 + 0.9e1 / 0.2e2 * t7 * t417 * t197 - t775 / 0.1e2 + 0.3e1 / 0.5e1 * t849 + 0.9e1 / 0.2e2 * t7 * t179 * t448 + t699 - t786 / 0.1e2 + 0.3e1 / 0.1e2 * t857 + 0.3e1 / 0.2e2 * t7 * t80 * t937);
  tv3rho33 = 0.3e1 * t406 + 0.3e1 * t453 + t8 * (t884 + t942);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t950 = t7 * t261 * t211;
  t957 = t7 * t270 * t211 / 0.3e2;
  t959 = t7 * t120 * t475;
  t971 = t641 * t39;
  t972 = 0.1e1 / t971;
  t977 = 0.55e2 / 0.81e2 * t38 * t278 - 0.11e2 / 0.27e2 * t47 * t37 * t278 * t52 + t287 * t291 * sigma[0] * t52 / 0.24e2 - t651 * t972 * t288 * t52 / 0.324e3;
  t982 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t257 * t211 + t950 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t115 * t475 - t957 + t959 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t977);
  tv3rho2sigma0 = t8 * t982 + 0.2e1 * t480;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t989 = t7 * t324 * t222;
  t993 = t7 * t328 * t222 / 0.3e2;
  t995 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t320 * t222 + t989 / 0.5e1 - t993);
  tv3rho2sigma2 = t8 * t995 + 0.2e1 * t489;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1001 = t7 * t349 * t211;
  t1009 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t345 * t211 + t1001 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t168 * t475 + t950 / 0.1e2 - t957 + t959 / 0.1e2);
  tv3rho2sigma3 = t8 * t1009 + t480 + t495;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1015 = t7 * t373 * t222;
  t1022 = t7 * t155 * t513;
  t1025 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t369 * t222 + t1015 / 0.1e2 + t989 / 0.1e2 - t993 + 0.3e1 / 0.2e2 * t7 * t151 * t513 + t1022 / 0.1e2);
  tv3rho2sigma5 = t8 * t1025 + t489 + t518;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1033 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t400 * t211 + t1001 / 0.5e1 - t957);
  tv3rho2sigma6 = t8 * t1033 + 0.2e1 * t495;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1054 = t920 * t81;
  t1055 = 0.1e1 / t1054;
  t1060 = 0.55e2 / 0.81e2 * t38 * t427 - 0.11e2 / 0.27e2 * t47 * t37 * t427 * t93 + t287 * t437 * sigma[2] * t93 / 0.24e2 - t651 * t1055 * t434 * t93 / 0.324e3;
  t1065 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t417 * t222 + t1015 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t179 * t513 - t993 + t1022 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t80 * t1060);
  tv3rho2sigma8 = t8 * t1065 + 0.2e1 * t518;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1068 = t7 * t257;
  t1071 = t7 * t261;
  t1072 = t1071 * t230;
  t1076 = t7 * t270;
  t1078 = t1076 * t230 / 0.864e4;
  t1079 = t523 * t527;
  t1082 = t54 * t228 * t298;
  t1086 = my_piecewise3(t2, 0, t1068 * t230 / 0.192e4 + t1072 / 0.144e4 - t520 * t527 / 0.288e3 - t1078 - t1079 / 0.432e3 + 0.13e2 / 0.1728e4 * t227 * t1082);
  tv3rho2lapl0 = t8 * t1086 + 0.2e1 * t531;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1089 = t7 * t320;
  t1092 = t7 * t324;
  t1093 = t1092 * t237;
  t1095 = t7 * t328;
  t1097 = t1095 * t237 / 0.864e4;
  t1099 = my_piecewise3(t70, 0, t1089 * t237 / 0.192e4 + t1093 / 0.144e4 - t1097);
  tv3rho2lapl1 = t8 * t1099 + 0.2e1 * t540;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t1101 = t7 * t345;
  t1104 = t7 * t349;
  t1105 = t1104 * t230;
  t1112 = my_piecewise3(t2, 0, t1101 * t230 / 0.192e4 + t1105 / 0.288e4 - t542 * t527 / 0.576e3 + t1072 / 0.288e4 - t1078 - t1079 / 0.864e3);
  tv3rho2lapl2 = t8 * t1112 + t531 + t546;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t1114 = t7 * t369;
  t1117 = t7 * t373;
  t1118 = t1117 * t237;
  t1123 = t536 * t552;
  t1126 = my_piecewise3(t70, 0, t1114 * t237 / 0.192e4 + t1118 / 0.288e4 + t1093 / 0.288e4 - t1097 - t533 * t552 / 0.576e3 - t1123 / 0.864e3);
  tv3rho2lapl3 = t8 * t1126 + t540 + t556;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t1129 = t7 * t400;
  t1134 = my_piecewise3(t2, 0, t1129 * t230 / 0.192e4 + t1105 / 0.144e4 - t1078);
  tv3rho2lapl4 = t8 * t1134 + 0.2e1 * t546;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t1137 = t7 * t417;
  t1145 = t54 * t235 * t444;
  t1149 = my_piecewise3(t70, 0, t1137 * t237 / 0.192e4 + t1118 / 0.144e4 - t548 * t552 / 0.288e3 - t1097 - t1123 / 0.432e3 + 0.13e2 / 0.1728e4 * t234 * t1145);
  tv3rho2lapl5 = t8 * t1149 + 0.2e1 * t556;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t1154 = t523 * t560 / 0.576e4;
  t1157 = t286 * t56 * t470 * t52;
  t1160 = t5 * t5;
  t1163 = t4 / t1160 / t34;
  t1164 = t1163 * t32;
  t1165 = t641 * rho[0];
  t1166 = 0.1e1 / t1165;
  t1168 = sigma[0] * t52;
  t1169 = t648 * t1166 * t1168;
  t1173 = my_piecewise3(t2, 0, t520 * t560 / 0.384e4 + t1154 - t227 * t1157 / 0.72e3 + t1164 * t1169 / 0.576e4);
  tv3rhosigma20 = t8 * t1173 + t563;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1178 = t536 * t566 / 0.576e4;
  t1180 = my_piecewise3(t70, 0, t533 * t566 / 0.384e4 + t1178);
  tv3rhosigma25 = t8 * t1180 + t569;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1185 = my_piecewise3(t2, 0, t542 * t560 / 0.384e4 + t1154);
  tv3rhosigma26 = t8 * t1185 + t563;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1191 = t286 * t56 * t508 * t93;
  t1194 = t1163 * t80;
  t1195 = t920 * rho[1];
  t1196 = 0.1e1 / t1195;
  t1198 = sigma[2] * t93;
  t1199 = t648 * t1196 * t1198;
  t1203 = my_piecewise3(t70, 0, t548 * t566 / 0.384e4 + t1178 - t234 * t1191 / 0.72e3 + t1194 * t1199 / 0.576e4);
  tv3rhosigma211 = t8 * t1203 + t569;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t1208 = t523 * t571 / 0.288e4;
  t1210 = t54 * t56 * t135;
  t1214 = my_piecewise3(t2, 0, t520 * t571 / 0.192e4 + t1208 - t227 * t1210 / 0.576e3);
  tv3rholapl20 = t8 * t1214 + t574;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t1219 = t536 * t576 / 0.288e4;
  t1221 = my_piecewise3(t70, 0, t533 * t576 / 0.192e4 + t1219);
  tv3rholapl22 = t8 * t1221 + t579;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t1226 = my_piecewise3(t2, 0, t542 * t571 / 0.192e4 + t1208);
  tv3rholapl23 = t8 * t1226 + t574;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t1231 = t54 * t56 * t193;
  t1235 = my_piecewise3(t70, 0, t548 * t576 / 0.192e4 + t1219 - t234 * t1231 / 0.576e3);
  tv3rholapl25 = t8 * t1235 + t579;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t1237 = t1163 * t29;
  t1238 = t31 * t648;
  t1240 = 0.1e1 / t641 * t52;
  t1241 = t1238 * t1240;
  t1244 = my_piecewise3(t2, 0, -t1237 * t1241 / 0.1536e5);
  tv3sigma30 = t8 * t1244;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1245 = t1163 * t79;
  t1247 = 0.1e1 / t920 * t93;
  t1248 = t1238 * t1247;
  t1251 = my_piecewise3(t70, 0, -t1245 * t1248 / 0.1536e5);
  tv3sigma39 = t8 * t1251;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t47, t48, t52, t53, t54, t56;
  double t57, t58, t59, t61, t65, t69, t70, t71;
  double t73, t74, t75, t76, t77, t79, t80, t81;
  double t82, t83, t85, t89, t93, t94, t95, t96;
  double t98, t102, t106, tzk0;

  double t107, t108, t109, t111, t114, t115, t119, t120;
  double t123, t125, t126, t129, t133, t135, t139, t144;
  double t145, t147, t150, t151, t155, t158, t160, tvrho0;
  double t164, t167, t168, t173, t175, t178, t179, t184;
  double t185, t191, t193, t197, t202, tvrho1, t211, t215;
  double tvsigma0, tvsigma1, t222, t226, tvsigma2, t227, t228, t230;
  double t233, tvlapl0, t234, t235, t237, t240, tvlapl1, tvtau0;
  double tvtau1;

  double t243, t244, t247, t248, t249, t252, t256, t257;
  double t261, t263, t269, t270, t273, t275, t278, t279;
  double t285, t286, t287, t288, t291, t296, t298, t302;
  double t307, t308, t309, t312, t315, t319, t320, t324;
  double t326, t328, t331, t333, tv2rho20, t336, t340, t344;
  double t345, t349, t351, t359, t360, t364, t368, t369;
  double t373, t375, t382, t385, tv2rho21, t390, t395, t399;
  double t400, t406, t407, t412, t416, t417, t427, t428;
  double t434, t437, t442, t444, t448, t453, tv2rho22, t461;
  double t468, t470, t475, t480, tv2rhosigma0, tv2rhosigma1, t487, t489;
  double tv2rhosigma2, t495, tv2rhosigma3, tv2rhosigma4, t506, t508, t513, t518;
  double tv2rhosigma5, t520, t523, t525, t527, t531, tv2rholapl0, t533;
  double t536, t538, t540, tv2rholapl1, t542, t546, tv2rholapl2, t548;
  double t552, t556, tv2rholapl3, tv2rhotau0, tv2rhotau1, tv2rhotau2, tv2rhotau3, t558;
  double t560, t563, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t564;
  double t566, t569, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4;
  double tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t571;
  double t574, tv2lapl20, tv2lapl21, t576, t579, tv2lapl22, tv2lapltau0, tv2lapltau1;
  double tv2lapltau2, tv2lapltau3, tv2tau20, tv2tau21, tv2tau22;

  double t583, t584, t587, t590, t591, t592, t595, t599;
  double t600, t604, t606, t611, t613, t616, t622, t623;
  double t626, t628, t631, t634, t635, t641, t643, t648;
  double t649, t650, t651, t652, t653, t654, t662, t667;
  double t669, t670, t673, t676, t679, t683, t684, t688;
  double t690, t692, t694, t696, t699, t701, tv3rho30, t704;
  double t705, t706, t709, t714, t715, t717, t721, t722;
  double t726, t729, t733, t735, t739, t748, t749, t750;
  double t753, t758, t760, t764, t765, t769, t772, t773;
  double t775, t784, t786, t789, tv3rho31, t792, t797, t801;
  double t805, t806, t810, t812, t821, t822, t827, t831;
  double t835, t836, t840, t842, t849, t857, t859, t860;
  double tv3rho32, t865, t872, t876, t877, t884, t885, t892;
  double t896, t897, t913, t914, t920, t922, t927, t928;
  double t929, t937, t942, tv3rho33, t950, t957, t959, t971;
  double t972, t977, t982, tv3rho2sigma0, tv3rho2sigma1, t989, t993, t995;
  double tv3rho2sigma2, t1001, t1009, tv3rho2sigma3, tv3rho2sigma4, t1015, t1022, t1025;
  double tv3rho2sigma5, t1033, tv3rho2sigma6, tv3rho2sigma7, t1054, t1055, t1060, t1065;
  double tv3rho2sigma8, t1068, t1071, t1072, t1076, t1078, t1079, t1082;
  double t1086, tv3rho2lapl0, t1089, t1092, t1093, t1095, t1097, t1099;
  double tv3rho2lapl1, t1101, t1104, t1105, t1112, tv3rho2lapl2, t1114, t1117;
  double t1118, t1123, t1126, tv3rho2lapl3, t1129, t1134, tv3rho2lapl4, t1137;
  double t1145, t1149, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1, tv3rho2tau2, tv3rho2tau3, tv3rho2tau4;
  double tv3rho2tau5, t1154, t1157, t1160, t1163, t1164, t1165, t1166;
  double t1168, t1169, t1173, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double t1178, t1180, tv3rhosigma25, t1185, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t1191, t1194, t1195, t1196, t1198, t1199, t1203;
  double tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2;
  double tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10;
  double tv3rhosigmatau11, t1208, t1210, t1214, tv3rholapl20, tv3rholapl21, t1219, t1221;
  double tv3rholapl22, t1226, tv3rholapl23, tv3rholapl24, t1231, t1235, tv3rholapl25, tv3rholapltau0;
  double tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, tv3rhotau20;
  double tv3rhotau21, tv3rhotau22, tv3rhotau23, tv3rhotau24, tv3rhotau25, t1237, t1238, t1240;
  double t1241, t1244, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t1245, t1247, t1248, t1251, tv3sigma39;
  double tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7;
  double tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3;
  double tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11;
  double tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27;
  double tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6;
  double tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22;
  double tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, tv3lapl30, tv3lapl31;
  double tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5;
  double tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, tv3tau30, tv3tau31;
  double tv3tau32, tv3tau33;

  double t1254, t1256, t1257, t1263, t1269, t1270, t1273, t1277;
  double t1286, t1292, t1295, t1301, t1304, t1307, t1311, t1323;
  double t1329, t1330, t1331, t1337, t1350, t1353, t1357, t1360;
  double t1364, t1366, t1367, t1368, t1370, t1371, t1377, t1382;
  double t1385, t1389, t1396, t1400, t1404, t1409, t1411, tv4rho40;
  double t1435, t1436, t1438, t1442, t1451, t1457, t1458, t1460;
  double t1470, t1474, t1475, t1478, t1483, t1484, t1501, t1503;
  double t1507, t1514, t1518, t1519, t1522, t1531, t1534, t1535;
  double t1537, t1539, t1540, tv4rho41, t1558, t1571, t1575, t1584;
  double t1594, t1598, t1605, t1606, t1615, t1628, t1632, t1639;
  double t1643, t1652, t1655, t1666, t1669, t1671, t1672, tv4rho42;
  double t1693, t1697, t1704, t1715, t1716, t1733, t1737, t1744;
  double t1752, t1761, t1771, t1773, t1774, tv4rho43, t1779, t1784;
  double t1791, t1795, t1804, t1813, t1825, t1831, t1837, t1848;
  double t1853, t1860, t1864, t1881, t1882, tv4rho44, t1890, t1896;
  double t1899, t1906, t1908, t1911, t1940, tv4rho3sigma0, tv4rho3sigma1, t1947;
  double t1950, t1954, t1956, tv4rho3sigma2, t1958, t1964, t1969, t1973;
  double t1982, t1983, tv4rho3sigma3, tv4rho3sigma4, t1985, t1991, t1993, t2002;
  double t2004, t2007, tv4rho3sigma5, t2013, t2022, tv4rho3sigma6, tv4rho3sigma7, t2028;
  double t2035, t2043, t2045, t2046, tv4rho3sigma8, t2055, tv4rho3sigma9, tv4rho3sigma10;
  double t2099, tv4rho3sigma11, t2106, t2111, t2113, t2119, t2120, t2122;
  double t2129, tv4rho3lapl0, t2136, t2139, t2143, t2145, tv4rho3lapl1, t2147;
  double t2153, t2157, t2160, t2168, t2169, tv4rho3lapl2, t2171, t2177;
  double t2179, t2186, t2187, t2190, tv4rho3lapl3, t2196, t2204, tv4rho3lapl4;
  double t2210, t2215, t2221, t2223, t2224, tv4rho3lapl5, t2233, tv4rho3lapl6;
  double t2253, tv4rho3lapl7, tv4rho3tau0, tv4rho3tau1, tv4rho3tau2, tv4rho3tau3, tv4rho3tau4, tv4rho3tau5;
  double tv4rho3tau6, tv4rho3tau7, t2258, t2266, t2267, t2270, t2282, t2286;
  double t2291, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t2296, t2299;
  double t2301, tv4rho2sigma25, t2305, t2316, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29;
  double tv4rho2sigma210, t2320, t2325, t2331, t2334, tv4rho2sigma211, t2341, tv4rho2sigma212;
  double tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t2364, t2368, t2373, tv4rho2sigma217;
  double tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4, tv4rho2sigmalapl5, tv4rho2sigmalapl6, tv4rho2sigmalapl7;
  double tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, tv4rho2sigmalapl11, tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15;
  double tv4rho2sigmalapl16, tv4rho2sigmalapl17, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3, tv4rho2sigmatau4, tv4rho2sigmatau5;
  double tv4rho2sigmatau6, tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, tv4rho2sigmatau11, tv4rho2sigmatau12, tv4rho2sigmatau13;
  double tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16, tv4rho2sigmatau17, t2378, t2383, t2384, t2390;
  double tv4rho2lapl20, tv4rho2lapl21, t2395, t2398, t2400, tv4rho2lapl22, t2404, t2411;
  double tv4rho2lapl23, tv4rho2lapl24, t2415, t2420, t2423, tv4rho2lapl25, t2430, tv4rho2lapl26;
  double tv4rho2lapl27, t2443, tv4rho2lapl28, tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4;
  double tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, tv4rho2tau20;
  double tv4rho2tau21, tv4rho2tau22, tv4rho2tau23, tv4rho2tau24, tv4rho2tau25, tv4rho2tau26, tv4rho2tau27, tv4rho2tau28;
  double t2448, t2451, t2464, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34;
  double tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t2471, t2473, tv4rhosigma39, t2479;
  double tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317;
  double tv4rhosigma318, t2496, tv4rhosigma319, tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4;
  double tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10, tv4rhosigma2lapl11, tv4rhosigma2lapl12;
  double tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20;
  double tv4rhosigma2lapl21, tv4rhosigma2lapl22, tv4rhosigma2lapl23, tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4;
  double tv4rhosigma2tau5, tv4rhosigma2tau6, tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, tv4rhosigma2tau11, tv4rhosigma2tau12;
  double tv4rhosigma2tau13, tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20;
  double tv4rhosigma2tau21, tv4rhosigma2tau22, tv4rhosigma2tau23, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24;
  double tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27, tv4rhosigmalapl28, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212;
  double tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216, tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2;
  double tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10;
  double tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17, tv4rhosigmalapltau18;
  double tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, tv4rhosigmatau20, tv4rhosigmatau21, tv4rhosigmatau22;
  double tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27, tv4rhosigmatau28, tv4rhosigmatau29, tv4rhosigmatau210;
  double tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216, tv4rhosigmatau217, tv4rholapl30;
  double tv4rholapl31, tv4rholapl32, tv4rholapl33, tv4rholapl34, tv4rholapl35, tv4rholapl36, tv4rholapl37, tv4rholapl2tau0;
  double tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8;
  double tv4rholapl2tau9, tv4rholapl2tau10, tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24;
  double tv4rholapltau25, tv4rholapltau26, tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211, tv4rhotau30;
  double tv4rhotau31, tv4rhotau32, tv4rhotau33, tv4rhotau34, tv4rhotau35, tv4rhotau36, tv4rhotau37, t2504;
  double tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47;
  double tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t2511, tv4sigma414;
  double tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4, tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7;
  double tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12, tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15;
  double tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, tv4sigma3lapl19, tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3;
  double tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11;
  double tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, tv4sigma3tau19;
  double tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27;
  double tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215;
  double tv4sigma2lapl216, tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5;
  double tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13;
  double tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21;
  double tv4sigma2lapltau22, tv4sigma2lapltau23, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25;
  double tv4sigma2tau26, tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213;
  double tv4sigma2tau214, tv4sigma2tau215, tv4sigma2tau216, tv4sigma2tau217, tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33;
  double tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310, tv4sigmalapl311;
  double tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7;
  double tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15;
  double tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25;
  double tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213;
  double tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33;
  double tv4sigmatau34, tv4sigmatau35, tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, tv4sigmatau311;
  double tv4lapl40, tv4lapl41, tv4lapl42, tv4lapl43, tv4lapl44, tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2;
  double tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7, tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22;
  double tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27, tv4lapl2tau28, tv4lapltau30, tv4lapltau31;
  double tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36, tv4lapltau37, tv4tau40, tv4tau41;
  double tv4tau42, tv4tau43, tv4tau44;

  mgga_k_pgslb_params *params;

  assert(p->params != NULL);
  params = (mgga_k_pgslb_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t47 = params->pgslb_mu * t33;
  t48 = t37 * sigma[0];
  t52 = exp(-t47 * t48 * t43 / 0.24e2);
  t53 = t33 * t33;
  t54 = params->pgslb_beta * t53;
  t56 = 0.1e1 / t35 / t34;
  t57 = lapl[0] * lapl[0];
  t58 = t56 * t57;
  t59 = t39 * rho[0];
  t61 = 0.1e1 / t40 / t59;
  t65 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43 + t52 + t54 * t58 * t61 / 0.576e3;
  t69 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t65);
  t70 = rho[1] <= p->dens_threshold;
  t71 = -t18;
  t73 = my_piecewise5(t16, t13, t12, t17, t71 * t9);
  t74 = 0.1e1 + t73;
  t75 = t74 <= p->zeta_threshold;
  t76 = POW_1_3(t74);
  t77 = t76 * t76;
  t79 = my_piecewise3(t75, t25, t77 * t74);
  t80 = t79 * t31;
  t81 = rho[1] * rho[1];
  t82 = POW_1_3(rho[1]);
  t83 = t82 * t82;
  t85 = 0.1e1 / t83 / t81;
  t89 = t37 * sigma[2];
  t93 = exp(-t47 * t89 * t85 / 0.24e2);
  t94 = lapl[1] * lapl[1];
  t95 = t56 * t94;
  t96 = t81 * rho[1];
  t98 = 0.1e1 / t82 / t96;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t85 + t93 + t54 * t95 * t98 / 0.576e3;
  t106 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t80 * t102);
  tzk0 = t69 + t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t107 = t8 * t8;
  t108 = 0.1e1 / t107;
  t109 = t18 * t108;
  t111 = my_piecewise5(t12, 0, t16, 0, t9 - t109);
  t114 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t111);
  t115 = t114 * t31;
  t119 = 0.1e1 / t30;
  t120 = t29 * t119;
  t123 = t7 * t120 * t65 / 0.1e2;
  t125 = 0.1e1 / t41 / t59;
  t126 = sigma[0] * t125;
  t129 = t47 * t37;
  t133 = t39 * t39;
  t135 = 0.1e1 / t40 / t133;
  t139 = -0.5e1 / 0.27e2 * t38 * t126 + t129 * t126 * t52 / 0.9e1 - 0.5e1 / 0.864e3 * t54 * t58 * t135;
  t144 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t115 * t65 + t123 + 0.3e1 / 0.2e2 * t7 * t32 * t139);
  t145 = t71 * t108;
  t147 = my_piecewise5(t16, 0, t12, 0, -t9 - t145);
  t150 = my_piecewise3(t75, 0, 0.5e1 / 0.3e1 * t77 * t147);
  t151 = t150 * t31;
  t155 = t79 * t119;
  t158 = t7 * t155 * t102 / 0.1e2;
  t160 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t151 * t102 + t158);
  tvrho0 = t69 + t106 + t8 * (t144 + t160);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t164 = my_piecewise5(t12, 0, t16, 0, -t9 - t109);
  t167 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t164);
  t168 = t167 * t31;
  t173 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t168 * t65 + t123);
  t175 = my_piecewise5(t16, 0, t12, 0, t9 - t145);
  t178 = my_piecewise3(t75, 0, 0.5e1 / 0.3e1 * t77 * t175);
  t179 = t178 * t31;
  t184 = 0.1e1 / t83 / t96;
  t185 = sigma[2] * t184;
  t191 = t81 * t81;
  t193 = 0.1e1 / t82 / t191;
  t197 = -0.5e1 / 0.27e2 * t38 * t185 + t129 * t185 * t93 / 0.9e1 - 0.5e1 / 0.864e3 * t54 * t95 * t193;
  t202 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t179 * t102 + t158 + 0.3e1 / 0.2e2 * t7 * t80 * t197);
  tvrho1 = t69 + t106 + t8 * (t173 + t202);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t211 = 0.5e1 / 0.72e2 * t38 * t43 - t47 * t37 * t43 * t52 / 0.24e2;
  t215 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t211);
  tvsigma0 = t8 * t215;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t222 = 0.5e1 / 0.72e2 * t38 * t85 - t47 * t37 * t85 * t93 / 0.24e2;
  t226 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t80 * t222);
  tvsigma2 = t8 * t226;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t227 = t7 * t32;
  t228 = t56 * lapl[0];
  t230 = t54 * t228 * t61;
  t233 = my_piecewise3(t2, 0, t227 * t230 / 0.192e4);
  tvlapl0 = t8 * t233;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t234 = t7 * t80;
  t235 = t56 * lapl[1];
  t237 = t54 * t235 * t98;
  t240 = my_piecewise3(t70, 0, t234 * t237 / 0.192e4);
  tvlapl1 = t8 * t240;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t243 = 0.1e1 / t26;
  t244 = t111 * t111;
  t247 = t107 * t8;
  t248 = 0.1e1 / t247;
  t249 = t18 * t248;
  t252 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t108 + 0.2e1 * t249);
  t256 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t243 * t244 + 0.5e1 / 0.3e1 * t27 * t252);
  t257 = t256 * t31;
  t261 = t114 * t119;
  t263 = t7 * t261 * t65;
  t269 = 0.1e1 / t30 / t8;
  t270 = t29 * t269;
  t273 = t7 * t270 * t65 / 0.3e2;
  t275 = t7 * t120 * t139;
  t278 = 0.1e1 / t41 / t133;
  t279 = sigma[0] * t278;
  t285 = params->pgslb_mu * params->pgslb_mu;
  t286 = t285 * t53;
  t287 = t286 * t56;
  t288 = sigma[0] * sigma[0];
  t291 = 0.1e1 / t40 / t133 / t59;
  t296 = t133 * rho[0];
  t298 = 0.1e1 / t40 / t296;
  t302 = 0.55e2 / 0.81e2 * t38 * t279 - 0.11e2 / 0.27e2 * t129 * t279 * t52 + t287 * t288 * t291 * t52 / 0.81e2 + 0.65e2 / 0.2592e4 * t54 * t58 * t298;
  t307 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t257 * t65 + t263 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t115 * t139 - t273 + t275 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t302);
  t308 = 0.1e1 / t76;
  t309 = t147 * t147;
  t312 = t71 * t248;
  t315 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t108 + 0.2e1 * t312);
  t319 = my_piecewise3(t75, 0, 0.1e2 / 0.9e1 * t308 * t309 + 0.5e1 / 0.3e1 * t77 * t315);
  t320 = t319 * t31;
  t324 = t150 * t119;
  t326 = t7 * t324 * t102;
  t328 = t79 * t269;
  t331 = t7 * t328 * t102 / 0.3e2;
  t333 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t320 * t102 + t326 / 0.5e1 - t331);
  tv2rho20 = 0.2e1 * t144 + 0.2e1 * t160 + t8 * (t307 + t333);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t336 = t243 * t164;
  t340 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t249);
  t344 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t336 * t111 + 0.5e1 / 0.3e1 * t27 * t340);
  t345 = t344 * t31;
  t349 = t167 * t119;
  t351 = t7 * t349 * t65;
  t359 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t345 * t65 + t351 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t168 * t139 + t263 / 0.1e2 - t273 + t275 / 0.1e2);
  t360 = t308 * t175;
  t364 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t312);
  t368 = my_piecewise3(t75, 0, 0.1e2 / 0.9e1 * t360 * t147 + 0.5e1 / 0.3e1 * t77 * t364);
  t369 = t368 * t31;
  t373 = t178 * t119;
  t375 = t7 * t373 * t102;
  t382 = t7 * t155 * t197;
  t385 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t369 * t102 + t375 / 0.1e2 + t326 / 0.1e2 - t331 + 0.3e1 / 0.2e2 * t7 * t151 * t197 + t382 / 0.1e2);
  tv2rho21 = t144 + t160 + t173 + t202 + t8 * (t359 + t385);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t390 = t164 * t164;
  t395 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t108 + 0.2e1 * t249);
  t399 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t243 * t390 + 0.5e1 / 0.3e1 * t27 * t395);
  t400 = t399 * t31;
  t406 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t400 * t65 + t351 / 0.5e1 - t273);
  t407 = t175 * t175;
  t412 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t108 + 0.2e1 * t312);
  t416 = my_piecewise3(t75, 0, 0.1e2 / 0.9e1 * t308 * t407 + 0.5e1 / 0.3e1 * t77 * t412);
  t417 = t416 * t31;
  t427 = 0.1e1 / t83 / t191;
  t428 = sigma[2] * t427;
  t434 = sigma[2] * sigma[2];
  t437 = 0.1e1 / t82 / t191 / t96;
  t442 = t191 * rho[1];
  t444 = 0.1e1 / t82 / t442;
  t448 = 0.55e2 / 0.81e2 * t38 * t428 - 0.11e2 / 0.27e2 * t129 * t428 * t93 + t287 * t434 * t437 * t93 / 0.81e2 + 0.65e2 / 0.2592e4 * t54 * t95 * t444;
  t453 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t417 * t102 + t375 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t179 * t197 - t331 + t382 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t80 * t448);
  tv2rho22 = 0.2e1 * t173 + 0.2e1 * t202 + t8 * (t406 + t453);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t461 = t7 * t120 * t211 / 0.1e2;
  t468 = t133 * t39;
  t470 = 0.1e1 / t40 / t468;
  t475 = -0.5e1 / 0.27e2 * t38 * t125 + t47 * t37 * t125 * t52 / 0.9e1 - t287 * t470 * sigma[0] * t52 / 0.216e3;
  t480 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t115 * t211 + t461 + 0.3e1 / 0.2e2 * t7 * t32 * t475);
  tv2rhosigma0 = t8 * t480 + t215;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t487 = t7 * t155 * t222 / 0.1e2;
  t489 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t151 * t222 + t487);
  tv2rhosigma2 = t8 * t489 + t226;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t495 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t168 * t211 + t461);
  tv2rhosigma3 = t8 * t495 + t215;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t506 = t191 * t81;
  t508 = 0.1e1 / t82 / t506;
  t513 = -0.5e1 / 0.27e2 * t38 * t184 + t47 * t37 * t184 * t93 / 0.9e1 - t287 * t508 * sigma[2] * t93 / 0.216e3;
  t518 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t179 * t222 + t487 + 0.3e1 / 0.2e2 * t7 * t80 * t513);
  tv2rhosigma5 = t8 * t518 + t226;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t520 = t7 * t115;
  t523 = t7 * t120;
  t525 = t523 * t230 / 0.288e4;
  t527 = t54 * t228 * t135;
  t531 = my_piecewise3(t2, 0, t520 * t230 / 0.192e4 + t525 - t227 * t527 / 0.576e3);
  tv2rholapl0 = t8 * t531 + t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t533 = t7 * t151;
  t536 = t7 * t155;
  t538 = t536 * t237 / 0.288e4;
  t540 = my_piecewise3(t70, 0, t533 * t237 / 0.192e4 + t538);
  tv2rholapl1 = t8 * t540 + t240;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t542 = t7 * t168;
  t546 = my_piecewise3(t2, 0, t542 * t230 / 0.192e4 + t525);
  tv2rholapl2 = t8 * t546 + t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t548 = t7 * t179;
  t552 = t54 * t235 * t193;
  t556 = my_piecewise3(t70, 0, t548 * t237 / 0.192e4 + t538 - t234 * t552 / 0.576e3);
  tv2rholapl3 = t8 * t556 + t240;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t558 = t56 * t298;
  t560 = t286 * t558 * t52;
  t563 = my_piecewise3(t2, 0, t227 * t560 / 0.384e4);
  tv2sigma20 = t8 * t563;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t564 = t56 * t444;
  t566 = t286 * t564 * t93;
  t569 = my_piecewise3(t70, 0, t234 * t566 / 0.384e4);
  tv2sigma25 = t8 * t569;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t571 = t54 * t56 * t61;
  t574 = my_piecewise3(t2, 0, t227 * t571 / 0.192e4);
  tv2lapl20 = t8 * t574;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t576 = t54 * t56 * t98;
  t579 = my_piecewise3(t70, 0, t234 * t576 / 0.192e4);
  tv2lapl22 = t8 * t579;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t583 = 0.1e1 / t26 / t21;
  t584 = t244 * t111;
  t587 = t243 * t111;
  t590 = t107 * t107;
  t591 = 0.1e1 / t590;
  t592 = t18 * t591;
  t595 = my_piecewise5(t12, 0, t16, 0, 0.6e1 * t248 - 0.6e1 * t592);
  t599 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t583 * t584 + 0.1e2 / 0.3e1 * t587 * t252 + 0.5e1 / 0.3e1 * t27 * t595);
  t600 = t599 * t31;
  t604 = t256 * t119;
  t606 = t7 * t604 * t65;
  t611 = t114 * t269;
  t613 = t7 * t611 * t65;
  t616 = t7 * t261 * t139;
  t622 = 0.1e1 / t30 / t107;
  t623 = t29 * t622;
  t626 = 0.2e1 / 0.45e2 * t7 * t623 * t65;
  t628 = t7 * t270 * t139;
  t631 = t7 * t120 * t302;
  t634 = 0.1e1 / t41 / t296;
  t635 = sigma[0] * t634;
  t641 = t133 * t133;
  t643 = 0.1e1 / t40 / t641;
  t648 = t285 * params->pgslb_mu;
  t649 = t34 * t34;
  t650 = 0.1e1 / t649;
  t651 = t648 * t650;
  t652 = t288 * sigma[0];
  t653 = t641 * t59;
  t654 = 0.1e1 / t653;
  t662 = -0.77e3 / 0.243e3 * t38 * t635 + 0.154e3 / 0.81e2 * t129 * t635 * t52 - 0.11e2 / 0.81e2 * t287 * t288 * t643 * t52 + 0.2e1 / 0.243e3 * t651 * t652 * t654 * t52 - 0.65e2 / 0.486e3 * t54 * t58 * t470;
  t667 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t600 * t65 + 0.3e1 / 0.1e2 * t606 + 0.9e1 / 0.2e2 * t7 * t257 * t139 - t613 / 0.1e2 + 0.3e1 / 0.5e1 * t616 + 0.9e1 / 0.2e2 * t7 * t115 * t302 + t626 - t628 / 0.1e2 + 0.3e1 / 0.1e2 * t631 + 0.3e1 / 0.2e2 * t7 * t32 * t662);
  t669 = 0.1e1 / t76 / t74;
  t670 = t309 * t147;
  t673 = t308 * t147;
  t676 = t71 * t591;
  t679 = my_piecewise5(t16, 0, t12, 0, -0.6e1 * t248 - 0.6e1 * t676);
  t683 = my_piecewise3(t75, 0, -0.1e2 / 0.27e2 * t669 * t670 + 0.1e2 / 0.3e1 * t673 * t315 + 0.5e1 / 0.3e1 * t77 * t679);
  t684 = t683 * t31;
  t688 = t319 * t119;
  t690 = t7 * t688 * t102;
  t692 = t150 * t269;
  t694 = t7 * t692 * t102;
  t696 = t79 * t622;
  t699 = 0.2e1 / 0.45e2 * t7 * t696 * t102;
  t701 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t684 * t102 + 0.3e1 / 0.1e2 * t690 - t694 / 0.1e2 + t699);
  tv3rho30 = 0.3e1 * t307 + 0.3e1 * t333 + t8 * (t667 + t701);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t704 = 0.2e1 * t359;
  t705 = 0.2e1 * t385;
  t706 = t583 * t164;
  t709 = t243 * t340;
  t714 = 0.2e1 * t248;
  t715 = 0.6e1 * t592;
  t717 = my_piecewise5(t12, 0, t16, 0, t714 - t715);
  t721 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t706 * t244 + 0.2e2 / 0.9e1 * t709 * t111 + 0.1e2 / 0.9e1 * t336 * t252 + 0.5e1 / 0.3e1 * t27 * t717);
  t722 = t721 * t31;
  t726 = t344 * t119;
  t729 = t7 * t726 * t65 / 0.5e1;
  t733 = t167 * t269;
  t735 = t7 * t733 * t65;
  t739 = t7 * t349 * t139 / 0.5e1;
  t748 = 0.3e1 / 0.2e2 * t7 * t722 * t65 + t729 + 0.3e1 / 0.1e2 * t7 * t345 * t139 - t735 / 0.3e2 + t739 + 0.3e1 / 0.2e2 * t7 * t168 * t302 + t606 / 0.1e2 - t613 / 0.15e2 + t616 / 0.5e1 + t626 - t628 / 0.15e2 + t631 / 0.1e2;
  t749 = my_piecewise3(t2, 0, t748);
  t750 = t669 * t175;
  t753 = t308 * t364;
  t758 = 0.6e1 * t676;
  t760 = my_piecewise5(t16, 0, t12, 0, -t714 - t758);
  t764 = my_piecewise3(t75, 0, -0.1e2 / 0.27e2 * t750 * t309 + 0.2e2 / 0.9e1 * t753 * t147 + 0.1e2 / 0.9e1 * t360 * t315 + 0.5e1 / 0.3e1 * t77 * t760);
  t765 = t764 * t31;
  t769 = t368 * t119;
  t772 = t7 * t769 * t102 / 0.5e1;
  t773 = t178 * t269;
  t775 = t7 * t773 * t102;
  t784 = t7 * t324 * t197 / 0.5e1;
  t786 = t7 * t328 * t197;
  t789 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t765 * t102 + t772 - t775 / 0.3e2 + t690 / 0.1e2 - t694 / 0.15e2 + t699 + 0.3e1 / 0.2e2 * t7 * t320 * t197 + t784 - t786 / 0.3e2);
  tv3rho31 = t307 + t333 + t704 + t705 + t8 * (t749 + t789);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t792 = t583 * t390;
  t797 = t243 * t395;
  t801 = my_piecewise5(t12, 0, t16, 0, -t714 - t715);
  t805 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t792 * t111 + 0.2e2 / 0.9e1 * t336 * t340 + 0.1e2 / 0.9e1 * t797 * t111 + 0.5e1 / 0.3e1 * t27 * t801);
  t806 = t805 * t31;
  t810 = t399 * t119;
  t812 = t7 * t810 * t65;
  t821 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t806 * t65 + t812 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t400 * t139 + t729 - t735 / 0.15e2 + t739 - t613 / 0.3e2 + t626 - t628 / 0.3e2);
  t822 = t669 * t407;
  t827 = t308 * t412;
  t831 = my_piecewise5(t16, 0, t12, 0, t714 - t758);
  t835 = my_piecewise3(t75, 0, -0.1e2 / 0.27e2 * t822 * t147 + 0.2e2 / 0.9e1 * t360 * t364 + 0.1e2 / 0.9e1 * t827 * t147 + 0.5e1 / 0.3e1 * t77 * t831);
  t836 = t835 * t31;
  t840 = t416 * t119;
  t842 = t7 * t840 * t102;
  t849 = t7 * t373 * t197;
  t857 = t7 * t155 * t448;
  t859 = 0.3e1 / 0.2e2 * t7 * t836 * t102 + t842 / 0.1e2 + t772 - t775 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t369 * t197 + t849 / 0.5e1 - t694 / 0.3e2 + t699 + t784 - t786 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t151 * t448 + t857 / 0.1e2;
  t860 = my_piecewise3(t70, 0, t859);
  tv3rho32 = t704 + t705 + t406 + t453 + t8 * (t821 + t860);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t865 = t390 * t164;
  t872 = my_piecewise5(t12, 0, t16, 0, -0.6e1 * t248 - 0.6e1 * t592);
  t876 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t583 * t865 + 0.1e2 / 0.3e1 * t336 * t395 + 0.5e1 / 0.3e1 * t27 * t872);
  t877 = t876 * t31;
  t884 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t877 * t65 + 0.3e1 / 0.1e2 * t812 - t735 / 0.1e2 + t626);
  t885 = t407 * t175;
  t892 = my_piecewise5(t16, 0, t12, 0, 0.6e1 * t248 - 0.6e1 * t676);
  t896 = my_piecewise3(t75, 0, -0.1e2 / 0.27e2 * t669 * t885 + 0.1e2 / 0.3e1 * t360 * t412 + 0.5e1 / 0.3e1 * t77 * t892);
  t897 = t896 * t31;
  t913 = 0.1e1 / t83 / t442;
  t914 = sigma[2] * t913;
  t920 = t191 * t191;
  t922 = 0.1e1 / t82 / t920;
  t927 = t434 * sigma[2];
  t928 = t920 * t96;
  t929 = 0.1e1 / t928;
  t937 = -0.77e3 / 0.243e3 * t38 * t914 + 0.154e3 / 0.81e2 * t129 * t914 * t93 - 0.11e2 / 0.81e2 * t287 * t434 * t922 * t93 + 0.2e1 / 0.243e3 * t651 * t927 * t929 * t93 - 0.65e2 / 0.486e3 * t54 * t95 * t508;
  t942 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t897 * t102 + 0.3e1 / 0.1e2 * t842 + 0.9e1 / 0.2e2 * t7 * t417 * t197 - t775 / 0.1e2 + 0.3e1 / 0.5e1 * t849 + 0.9e1 / 0.2e2 * t7 * t179 * t448 + t699 - t786 / 0.1e2 + 0.3e1 / 0.1e2 * t857 + 0.3e1 / 0.2e2 * t7 * t80 * t937);
  tv3rho33 = 0.3e1 * t406 + 0.3e1 * t453 + t8 * (t884 + t942);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t950 = t7 * t261 * t211;
  t957 = t7 * t270 * t211 / 0.3e2;
  t959 = t7 * t120 * t475;
  t971 = t641 * t39;
  t972 = 0.1e1 / t971;
  t977 = 0.55e2 / 0.81e2 * t38 * t278 - 0.11e2 / 0.27e2 * t47 * t37 * t278 * t52 + t287 * t291 * sigma[0] * t52 / 0.24e2 - t651 * t972 * t288 * t52 / 0.324e3;
  t982 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t257 * t211 + t950 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t115 * t475 - t957 + t959 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t977);
  tv3rho2sigma0 = t8 * t982 + 0.2e1 * t480;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t989 = t7 * t324 * t222;
  t993 = t7 * t328 * t222 / 0.3e2;
  t995 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t320 * t222 + t989 / 0.5e1 - t993);
  tv3rho2sigma2 = t8 * t995 + 0.2e1 * t489;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1001 = t7 * t349 * t211;
  t1009 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t345 * t211 + t1001 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t168 * t475 + t950 / 0.1e2 - t957 + t959 / 0.1e2);
  tv3rho2sigma3 = t8 * t1009 + t480 + t495;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1015 = t7 * t373 * t222;
  t1022 = t7 * t155 * t513;
  t1025 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t369 * t222 + t1015 / 0.1e2 + t989 / 0.1e2 - t993 + 0.3e1 / 0.2e2 * t7 * t151 * t513 + t1022 / 0.1e2);
  tv3rho2sigma5 = t8 * t1025 + t489 + t518;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1033 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t400 * t211 + t1001 / 0.5e1 - t957);
  tv3rho2sigma6 = t8 * t1033 + 0.2e1 * t495;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1054 = t920 * t81;
  t1055 = 0.1e1 / t1054;
  t1060 = 0.55e2 / 0.81e2 * t38 * t427 - 0.11e2 / 0.27e2 * t47 * t37 * t427 * t93 + t287 * t437 * sigma[2] * t93 / 0.24e2 - t651 * t1055 * t434 * t93 / 0.324e3;
  t1065 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t417 * t222 + t1015 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t179 * t513 - t993 + t1022 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t80 * t1060);
  tv3rho2sigma8 = t8 * t1065 + 0.2e1 * t518;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1068 = t7 * t257;
  t1071 = t7 * t261;
  t1072 = t1071 * t230;
  t1076 = t7 * t270;
  t1078 = t1076 * t230 / 0.864e4;
  t1079 = t523 * t527;
  t1082 = t54 * t228 * t298;
  t1086 = my_piecewise3(t2, 0, t1068 * t230 / 0.192e4 + t1072 / 0.144e4 - t520 * t527 / 0.288e3 - t1078 - t1079 / 0.432e3 + 0.13e2 / 0.1728e4 * t227 * t1082);
  tv3rho2lapl0 = t8 * t1086 + 0.2e1 * t531;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1089 = t7 * t320;
  t1092 = t7 * t324;
  t1093 = t1092 * t237;
  t1095 = t7 * t328;
  t1097 = t1095 * t237 / 0.864e4;
  t1099 = my_piecewise3(t70, 0, t1089 * t237 / 0.192e4 + t1093 / 0.144e4 - t1097);
  tv3rho2lapl1 = t8 * t1099 + 0.2e1 * t540;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t1101 = t7 * t345;
  t1104 = t7 * t349;
  t1105 = t1104 * t230;
  t1112 = my_piecewise3(t2, 0, t1101 * t230 / 0.192e4 + t1105 / 0.288e4 - t542 * t527 / 0.576e3 + t1072 / 0.288e4 - t1078 - t1079 / 0.864e3);
  tv3rho2lapl2 = t8 * t1112 + t531 + t546;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t1114 = t7 * t369;
  t1117 = t7 * t373;
  t1118 = t1117 * t237;
  t1123 = t536 * t552;
  t1126 = my_piecewise3(t70, 0, t1114 * t237 / 0.192e4 + t1118 / 0.288e4 + t1093 / 0.288e4 - t1097 - t533 * t552 / 0.576e3 - t1123 / 0.864e3);
  tv3rho2lapl3 = t8 * t1126 + t540 + t556;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t1129 = t7 * t400;
  t1134 = my_piecewise3(t2, 0, t1129 * t230 / 0.192e4 + t1105 / 0.144e4 - t1078);
  tv3rho2lapl4 = t8 * t1134 + 0.2e1 * t546;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t1137 = t7 * t417;
  t1145 = t54 * t235 * t444;
  t1149 = my_piecewise3(t70, 0, t1137 * t237 / 0.192e4 + t1118 / 0.144e4 - t548 * t552 / 0.288e3 - t1097 - t1123 / 0.432e3 + 0.13e2 / 0.1728e4 * t234 * t1145);
  tv3rho2lapl5 = t8 * t1149 + 0.2e1 * t556;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t1154 = t523 * t560 / 0.576e4;
  t1157 = t286 * t56 * t470 * t52;
  t1160 = t5 * t5;
  t1163 = t4 / t1160 / t34;
  t1164 = t1163 * t32;
  t1165 = t641 * rho[0];
  t1166 = 0.1e1 / t1165;
  t1168 = sigma[0] * t52;
  t1169 = t648 * t1166 * t1168;
  t1173 = my_piecewise3(t2, 0, t520 * t560 / 0.384e4 + t1154 - t227 * t1157 / 0.72e3 + t1164 * t1169 / 0.576e4);
  tv3rhosigma20 = t8 * t1173 + t563;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1178 = t536 * t566 / 0.576e4;
  t1180 = my_piecewise3(t70, 0, t533 * t566 / 0.384e4 + t1178);
  tv3rhosigma25 = t8 * t1180 + t569;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1185 = my_piecewise3(t2, 0, t542 * t560 / 0.384e4 + t1154);
  tv3rhosigma26 = t8 * t1185 + t563;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1191 = t286 * t56 * t508 * t93;
  t1194 = t1163 * t80;
  t1195 = t920 * rho[1];
  t1196 = 0.1e1 / t1195;
  t1198 = sigma[2] * t93;
  t1199 = t648 * t1196 * t1198;
  t1203 = my_piecewise3(t70, 0, t548 * t566 / 0.384e4 + t1178 - t234 * t1191 / 0.72e3 + t1194 * t1199 / 0.576e4);
  tv3rhosigma211 = t8 * t1203 + t569;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t1208 = t523 * t571 / 0.288e4;
  t1210 = t54 * t56 * t135;
  t1214 = my_piecewise3(t2, 0, t520 * t571 / 0.192e4 + t1208 - t227 * t1210 / 0.576e3);
  tv3rholapl20 = t8 * t1214 + t574;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t1219 = t536 * t576 / 0.288e4;
  t1221 = my_piecewise3(t70, 0, t533 * t576 / 0.192e4 + t1219);
  tv3rholapl22 = t8 * t1221 + t579;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t1226 = my_piecewise3(t2, 0, t542 * t571 / 0.192e4 + t1208);
  tv3rholapl23 = t8 * t1226 + t574;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t1231 = t54 * t56 * t193;
  t1235 = my_piecewise3(t70, 0, t548 * t576 / 0.192e4 + t1219 - t234 * t1231 / 0.576e3);
  tv3rholapl25 = t8 * t1235 + t579;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t1237 = t1163 * t29;
  t1238 = t31 * t648;
  t1240 = 0.1e1 / t641 * t52;
  t1241 = t1238 * t1240;
  t1244 = my_piecewise3(t2, 0, -t1237 * t1241 / 0.1536e5);
  tv3sigma30 = t8 * t1244;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1245 = t1163 * t79;
  t1247 = 0.1e1 / t920 * t93;
  t1248 = t1238 * t1247;
  t1251 = my_piecewise3(t70, 0, -t1245 * t1248 / 0.1536e5);
  tv3sigma39 = t8 * t1251;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t1254 = t21 * t21;
  t1256 = 0.1e1 / t26 / t1254;
  t1257 = t244 * t244;
  t1263 = t252 * t252;
  t1269 = 0.1e1 / t590 / t8;
  t1270 = t18 * t1269;
  t1273 = my_piecewise5(t12, 0, t16, 0, -0.24e2 * t591 + 0.24e2 * t1270);
  t1277 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t1256 * t1257 - 0.2e2 / 0.9e1 * t583 * t244 * t252 + 0.1e2 / 0.3e1 * t243 * t1263 + 0.4e2 / 0.9e1 * t587 * t595 + 0.5e1 / 0.3e1 * t27 * t1273);
  t1286 = t7 * t604 * t139;
  t1292 = t7 * t611 * t139;
  t1295 = t7 * t261 * t302;
  t1301 = t7 * t623 * t139;
  t1304 = t7 * t270 * t302;
  t1307 = t7 * t120 * t662;
  t1311 = sigma[0] / t41 / t468;
  t1323 = t641 * t133;
  t1329 = t285 * t285;
  t1330 = t1329 * t650;
  t1331 = t288 * t288;
  t1337 = t37 * t52;
  t1350 = t7 * t114 * t622 * t65;
  t1353 = 0.1e1 / t30 / t247;
  t1357 = 0.14e2 / 0.135e3 * t7 * t29 * t1353 * t65;
  t1360 = t7 * t599 * t119 * t65;
  t1364 = t7 * t256 * t269 * t65;
  t1366 = 0.3e1 / 0.2e2 * t7 * t1277 * t31 * t65 + 0.3e1 / 0.5e1 * t7 * t600 * t139 + 0.6e1 / 0.5e1 * t1286 + 0.9e1 / 0.1e2 * t7 * t257 * t302 - 0.2e1 / 0.5e1 * t1292 + 0.6e1 / 0.5e1 * t1295 + 0.3e1 / 0.5e1 * t7 * t115 * t662 + 0.8e1 / 0.45e2 * t1301 - t1304 / 0.5e1 + 0.2e1 / 0.5e1 * t1307 + 0.3e1 / 0.2e2 * t7 * t32 * (0.1309e5 / 0.729e3 * t38 * t1311 - 0.2618e4 / 0.243e3 * t129 * t1311 * t52 + 0.979e3 / 0.729e3 * t287 * t288 / t40 / t1165 * t52 - 0.44e2 / 0.243e3 * t651 * t652 / t1323 * t52 + 0.2e1 / 0.2187e4 * t1330 * t1331 / t41 / t641 / t468 * t33 * t1337 + 0.1235e4 / 0.1458e4 * t54 * t58 * t291) + 0.8e1 / 0.45e2 * t1350 - t1357 + 0.2e1 / 0.5e1 * t1360 - t1364 / 0.5e1;
  t1367 = my_piecewise3(t2, 0, t1366);
  t1368 = t74 * t74;
  t1370 = 0.1e1 / t76 / t1368;
  t1371 = t309 * t309;
  t1377 = t315 * t315;
  t1382 = t71 * t1269;
  t1385 = my_piecewise5(t16, 0, t12, 0, 0.24e2 * t591 + 0.24e2 * t1382);
  t1389 = my_piecewise3(t75, 0, 0.4e2 / 0.81e2 * t1370 * t1371 - 0.2e2 / 0.9e1 * t669 * t309 * t315 + 0.1e2 / 0.3e1 * t308 * t1377 + 0.4e2 / 0.9e1 * t673 * t679 + 0.5e1 / 0.3e1 * t77 * t1385);
  t1396 = t7 * t683 * t119 * t102;
  t1400 = t7 * t319 * t269 * t102;
  t1404 = t7 * t150 * t622 * t102;
  t1409 = 0.14e2 / 0.135e3 * t7 * t79 * t1353 * t102;
  t1411 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t1389 * t31 * t102 + 0.2e1 / 0.5e1 * t1396 - t1400 / 0.5e1 + 0.8e1 / 0.45e2 * t1404 - t1409);
  tv4rho40 = 0.4e1 * t667 + 0.4e1 * t701 + t8 * (t1367 + t1411);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1435 = 0.12e2 * t591;
  t1436 = 0.24e2 * t1270;
  t1438 = my_piecewise5(t12, 0, t16, 0, -t1435 + t1436);
  t1442 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t1256 * t164 * t584 - 0.1e2 / 0.9e1 * t583 * t340 * t244 - 0.1e2 / 0.9e1 * t706 * t111 * t252 + 0.1e2 / 0.3e1 * t243 * t717 * t111 + 0.1e2 / 0.3e1 * t709 * t252 + 0.1e2 / 0.9e1 * t336 * t595 + 0.5e1 / 0.3e1 * t27 * t1438);
  t1451 = t7 * t726 * t139;
  t1457 = t7 * t733 * t139;
  t1458 = t1457 / 0.1e2;
  t1460 = t7 * t349 * t302;
  t1470 = t7 * t721 * t119 * t65;
  t1474 = t7 * t344 * t269 * t65;
  t1475 = t1474 / 0.1e2;
  t1478 = t7 * t167 * t622 * t65;
  t1483 = 0.3e1 / 0.2e2 * t7 * t168 * t662 + 0.3e1 / 0.2e2 * t7 * t1442 * t31 * t65 + 0.9e1 / 0.2e2 * t7 * t722 * t139 + 0.3e1 / 0.5e1 * t1451 + 0.9e1 / 0.2e2 * t7 * t345 * t302 - t1458 + 0.3e1 / 0.1e2 * t1460 + 0.3e1 / 0.1e2 * t1286 - t1292 / 0.5e1 + 0.3e1 / 0.1e2 * t1295 + 0.2e1 / 0.15e2 * t1301 - t1304 / 0.1e2 + t1307 / 0.1e2 + 0.3e1 / 0.1e2 * t1470 - t1475 + 0.2e1 / 0.45e2 * t1478 + 0.2e1 / 0.15e2 * t1350 - t1357 + t1360 / 0.1e2 - t1364 / 0.1e2;
  t1484 = my_piecewise3(t2, 0, t1483);
  t1501 = 0.24e2 * t1382;
  t1503 = my_piecewise5(t16, 0, t12, 0, t1435 + t1501);
  t1507 = my_piecewise3(t75, 0, 0.4e2 / 0.81e2 * t1370 * t175 * t670 - 0.1e2 / 0.9e1 * t669 * t364 * t309 - 0.1e2 / 0.9e1 * t750 * t147 * t315 + 0.1e2 / 0.3e1 * t308 * t760 * t147 + 0.1e2 / 0.3e1 * t753 * t315 + 0.1e2 / 0.9e1 * t360 * t679 + 0.5e1 / 0.3e1 * t77 * t1503);
  t1514 = t7 * t764 * t119 * t102;
  t1518 = t7 * t368 * t269 * t102;
  t1519 = t1518 / 0.1e2;
  t1522 = t7 * t178 * t622 * t102;
  t1531 = t7 * t688 * t197;
  t1534 = t7 * t692 * t197;
  t1535 = t1534 / 0.1e2;
  t1537 = t7 * t696 * t197;
  t1539 = 0.3e1 / 0.2e2 * t7 * t1507 * t31 * t102 + 0.3e1 / 0.1e2 * t1514 - t1519 + 0.2e1 / 0.45e2 * t1522 + t1396 / 0.1e2 - t1400 / 0.1e2 + 0.2e1 / 0.15e2 * t1404 - t1409 + 0.3e1 / 0.2e2 * t7 * t684 * t197 + 0.3e1 / 0.1e2 * t1531 - t1535 + 0.2e1 / 0.45e2 * t1537;
  t1540 = my_piecewise3(t70, 0, t1539);
  tv4rho41 = t667 + t701 + 0.3e1 * t749 + 0.3e1 * t789 + t8 * (t1484 + t1540);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1558 = t340 * t340;
  t1571 = my_piecewise5(t12, 0, t16, 0, t1436);
  t1575 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t1256 * t390 * t244 - 0.4e2 / 0.27e2 * t706 * t111 * t340 - 0.1e2 / 0.27e2 * t792 * t252 + 0.2e2 / 0.9e1 * t243 * t1558 + 0.2e2 / 0.9e1 * t336 * t717 - 0.1e2 / 0.27e2 * t583 * t395 * t244 + 0.2e2 / 0.9e1 * t243 * t801 * t111 + 0.1e2 / 0.9e1 * t797 * t252 + 0.5e1 / 0.3e1 * t27 * t1571);
  t1584 = t7 * t810 * t139;
  t1594 = t7 * t399 * t269 * t65;
  t1598 = t7 * t805 * t119 * t65;
  t1605 = 0.3e1 / 0.2e2 * t7 * t400 * t302 + 0.3e1 / 0.2e2 * t7 * t1575 * t31 * t65 + 0.3e1 / 0.1e2 * t7 * t806 * t139 + t1584 / 0.5e1 + 0.2e1 / 0.5e1 * t1451 - 0.2e1 / 0.15e2 * t1457 + t1460 / 0.5e1 - t1292 / 0.15e2 + 0.4e1 / 0.45e2 * t1301 - t1304 / 0.3e2 - t1594 / 0.3e2 + t1598 / 0.5e1 + t1470 / 0.5e1 - 0.2e1 / 0.15e2 * t1474 + 0.4e1 / 0.45e2 * t1478 + 0.4e1 / 0.45e2 * t1350 - t1357 - t1364 / 0.3e2;
  t1606 = my_piecewise3(t2, 0, t1605);
  t1615 = t364 * t364;
  t1628 = my_piecewise5(t16, 0, t12, 0, t1501);
  t1632 = my_piecewise3(t75, 0, 0.4e2 / 0.81e2 * t1370 * t407 * t309 - 0.4e2 / 0.27e2 * t750 * t147 * t364 - 0.1e2 / 0.27e2 * t822 * t315 + 0.2e2 / 0.9e1 * t308 * t1615 + 0.2e2 / 0.9e1 * t360 * t760 - 0.1e2 / 0.27e2 * t669 * t412 * t309 + 0.2e2 / 0.9e1 * t308 * t831 * t147 + 0.1e2 / 0.9e1 * t827 * t315 + 0.5e1 / 0.3e1 * t77 * t1628);
  t1639 = t7 * t835 * t119 * t102;
  t1643 = t7 * t416 * t269 * t102;
  t1652 = t7 * t769 * t197;
  t1655 = t7 * t773 * t197;
  t1666 = t7 * t324 * t448;
  t1669 = t7 * t328 * t448;
  t1671 = 0.3e1 / 0.2e2 * t7 * t1632 * t31 * t102 + t1639 / 0.5e1 - t1643 / 0.3e2 + t1514 / 0.5e1 - 0.2e1 / 0.15e2 * t1518 + 0.4e1 / 0.45e2 * t1522 + 0.3e1 / 0.1e2 * t7 * t765 * t197 + 0.2e1 / 0.5e1 * t1652 - t1655 / 0.15e2 - t1400 / 0.3e2 + 0.4e1 / 0.45e2 * t1404 - t1409 + t1531 / 0.5e1 - 0.2e1 / 0.15e2 * t1534 + 0.4e1 / 0.45e2 * t1537 + 0.3e1 / 0.2e2 * t7 * t320 * t448 + t1666 / 0.5e1 - t1669 / 0.3e2;
  t1672 = my_piecewise3(t70, 0, t1671);
  tv4rho42 = 0.2e1 * t749 + 0.2e1 * t789 + 0.2e1 * t821 + 0.2e1 * t860 + t8 * (t1606 + t1672);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1693 = my_piecewise5(t12, 0, t16, 0, t1435 + t1436);
  t1697 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t1256 * t865 * t111 - 0.1e2 / 0.9e1 * t792 * t340 - 0.1e2 / 0.9e1 * t706 * t395 * t111 + 0.1e2 / 0.3e1 * t709 * t395 + 0.1e2 / 0.3e1 * t336 * t801 + 0.1e2 / 0.9e1 * t243 * t872 * t111 + 0.5e1 / 0.3e1 * t27 * t1693);
  t1704 = t7 * t876 * t119 * t65;
  t1715 = 0.3e1 / 0.2e2 * t7 * t1697 * t31 * t65 + t1704 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t877 * t139 + 0.3e1 / 0.1e2 * t1598 - t1594 / 0.1e2 + 0.3e1 / 0.1e2 * t1584 - t1475 + 0.2e1 / 0.15e2 * t1478 - t1458 + 0.2e1 / 0.45e2 * t1350 - t1357 + 0.2e1 / 0.45e2 * t1301;
  t1716 = my_piecewise3(t2, 0, t1715);
  t1733 = my_piecewise5(t16, 0, t12, 0, -t1435 + t1501);
  t1737 = my_piecewise3(t75, 0, 0.4e2 / 0.81e2 * t1370 * t885 * t147 - 0.1e2 / 0.9e1 * t822 * t364 - 0.1e2 / 0.9e1 * t750 * t412 * t147 + 0.1e2 / 0.3e1 * t753 * t412 + 0.1e2 / 0.3e1 * t360 * t831 + 0.1e2 / 0.9e1 * t308 * t892 * t147 + 0.5e1 / 0.3e1 * t77 * t1733);
  t1744 = t7 * t896 * t119 * t102;
  t1752 = t7 * t840 * t197;
  t1761 = t7 * t373 * t448;
  t1771 = t7 * t155 * t937;
  t1773 = 0.3e1 / 0.2e2 * t7 * t1737 * t31 * t102 + t1744 / 0.1e2 + 0.3e1 / 0.1e2 * t1639 - t1643 / 0.1e2 + 0.9e1 / 0.2e2 * t7 * t836 * t197 + 0.3e1 / 0.1e2 * t1752 - t1519 + 0.2e1 / 0.15e2 * t1522 + 0.3e1 / 0.5e1 * t1652 - t1655 / 0.5e1 + 0.9e1 / 0.2e2 * t7 * t369 * t448 + 0.3e1 / 0.1e2 * t1761 + 0.2e1 / 0.45e2 * t1404 - t1409 - t1535 + 0.2e1 / 0.15e2 * t1537 + 0.3e1 / 0.1e2 * t1666 - t1669 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t151 * t937 + t1771 / 0.1e2;
  t1774 = my_piecewise3(t70, 0, t1773);
  tv4rho43 = 0.3e1 * t821 + 0.3e1 * t860 + t884 + t942 + t8 * (t1716 + t1774);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1779 = t390 * t390;
  t1784 = t395 * t395;
  t1791 = my_piecewise5(t12, 0, t16, 0, 0.24e2 * t591 + 0.24e2 * t1270);
  t1795 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t1256 * t1779 - 0.2e2 / 0.9e1 * t792 * t395 + 0.1e2 / 0.3e1 * t243 * t1784 + 0.4e2 / 0.9e1 * t336 * t872 + 0.5e1 / 0.3e1 * t27 * t1791);
  t1804 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1795 * t31 * t65 + 0.2e1 / 0.5e1 * t1704 - t1594 / 0.5e1 + 0.8e1 / 0.45e2 * t1478 - t1357);
  t1813 = sigma[2] / t83 / t506;
  t1825 = t920 * t191;
  t1831 = t434 * t434;
  t1837 = t37 * t93;
  t1848 = t407 * t407;
  t1853 = t412 * t412;
  t1860 = my_piecewise5(t16, 0, t12, 0, -0.24e2 * t591 + 0.24e2 * t1382);
  t1864 = my_piecewise3(t75, 0, 0.4e2 / 0.81e2 * t1370 * t1848 - 0.2e2 / 0.9e1 * t822 * t412 + 0.1e2 / 0.3e1 * t308 * t1853 + 0.4e2 / 0.9e1 * t360 * t892 + 0.5e1 / 0.3e1 * t77 * t1860);
  t1881 = 0.9e1 / 0.1e2 * t7 * t417 * t448 + 0.3e1 / 0.5e1 * t7 * t179 * t937 + 0.3e1 / 0.2e2 * t7 * t80 * (0.1309e5 / 0.729e3 * t38 * t1813 - 0.2618e4 / 0.243e3 * t129 * t1813 * t93 + 0.979e3 / 0.729e3 * t287 * t434 / t82 / t1195 * t93 - 0.44e2 / 0.243e3 * t651 * t927 / t1825 * t93 + 0.2e1 / 0.2187e4 * t1330 * t1831 / t83 / t920 / t506 * t33 * t1837 + 0.1235e4 / 0.1458e4 * t54 * t95 * t437) + 0.3e1 / 0.2e2 * t7 * t1864 * t31 * t102 + 0.3e1 / 0.5e1 * t7 * t897 * t197 + 0.2e1 / 0.5e1 * t1744 + 0.6e1 / 0.5e1 * t1752 + 0.6e1 / 0.5e1 * t1761 + 0.2e1 / 0.5e1 * t1771 - t1643 / 0.5e1 - 0.2e1 / 0.5e1 * t1655 - t1669 / 0.5e1 + 0.8e1 / 0.45e2 * t1522 + 0.8e1 / 0.45e2 * t1537 - t1409;
  t1882 = my_piecewise3(t70, 0, t1881);
  tv4rho44 = 0.4e1 * t884 + 0.4e1 * t942 + t8 * (t1804 + t1882);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t1890 = t7 * t604 * t211;
  t1896 = t7 * t611 * t211;
  t1899 = t7 * t261 * t475;
  t1906 = 0.2e1 / 0.45e2 * t7 * t623 * t211;
  t1908 = t7 * t270 * t475;
  t1911 = t7 * t120 * t977;
  t1940 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t600 * t211 + 0.3e1 / 0.1e2 * t1890 + 0.9e1 / 0.2e2 * t7 * t257 * t475 - t1896 / 0.1e2 + 0.3e1 / 0.5e1 * t1899 + 0.9e1 / 0.2e2 * t7 * t115 * t977 + t1906 - t1908 / 0.1e2 + 0.3e1 / 0.1e2 * t1911 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.77e3 / 0.243e3 * t38 * t634 + 0.154e3 / 0.81e2 * t47 * t37 * t634 * t52 - 0.341e3 / 0.972e3 * t287 * t643 * sigma[0] * t52 + 0.19e2 / 0.324e3 * t651 * t654 * t288 * t52 - t1330 / t41 / t641 / t296 * t652 * t33 * t1337 / 0.2916e4));
  tv4rho3sigma0 = t8 * t1940 + 0.3e1 * t982;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t1947 = t7 * t688 * t222;
  t1950 = t7 * t692 * t222;
  t1954 = 0.2e1 / 0.45e2 * t7 * t696 * t222;
  t1956 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t684 * t222 + 0.3e1 / 0.1e2 * t1947 - t1950 / 0.1e2 + t1954);
  tv4rho3sigma2 = t8 * t1956 + 0.3e1 * t995;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t1958 = 0.2e1 * t1009;
  t1964 = t7 * t726 * t211 / 0.5e1;
  t1969 = t7 * t733 * t211;
  t1973 = t7 * t349 * t475 / 0.5e1;
  t1982 = 0.3e1 / 0.2e2 * t7 * t722 * t211 + t1964 + 0.3e1 / 0.1e2 * t7 * t345 * t475 - t1969 / 0.3e2 + t1973 + 0.3e1 / 0.2e2 * t7 * t168 * t977 + t1890 / 0.1e2 - t1896 / 0.15e2 + t1899 / 0.5e1 + t1906 - t1908 / 0.15e2 + t1911 / 0.1e2;
  t1983 = my_piecewise3(t2, 0, t1982);
  tv4rho3sigma3 = t8 * t1983 + t1958 + t982;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t1985 = 0.2e1 * t1025;
  t1991 = t7 * t769 * t222 / 0.5e1;
  t1993 = t7 * t773 * t222;
  t2002 = t7 * t324 * t513 / 0.5e1;
  t2004 = t7 * t328 * t513;
  t2007 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t765 * t222 + t1991 - t1993 / 0.3e2 + t1947 / 0.1e2 - t1950 / 0.15e2 + t1954 + 0.3e1 / 0.2e2 * t7 * t320 * t513 + t2002 - t2004 / 0.3e2);
  tv4rho3sigma5 = t8 * t2007 + t1985 + t995;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t2013 = t7 * t810 * t211;
  t2022 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t806 * t211 + t2013 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t400 * t475 + t1964 - t1969 / 0.15e2 + t1973 - t1896 / 0.3e2 + t1906 - t1908 / 0.3e2);
  tv4rho3sigma6 = t8 * t2022 + t1033 + t1958;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t2028 = t7 * t840 * t222;
  t2035 = t7 * t373 * t513;
  t2043 = t7 * t155 * t1060;
  t2045 = 0.3e1 / 0.2e2 * t7 * t836 * t222 + t2028 / 0.1e2 + t1991 - t1993 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t369 * t513 + t2035 / 0.5e1 - t1950 / 0.3e2 + t1954 + t2002 - t2004 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t151 * t1060 + t2043 / 0.1e2;
  t2046 = my_piecewise3(t70, 0, t2045);
  tv4rho3sigma8 = t8 * t2046 + t1065 + t1985;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t2055 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t877 * t211 + 0.3e1 / 0.1e2 * t2013 - t1969 / 0.1e2 + t1906);
  tv4rho3sigma9 = t8 * t2055 + 0.3e1 * t1033;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t2099 = my_piecewise3(t70, 0, 0.3e1 / 0.2e2 * t7 * t897 * t222 + 0.3e1 / 0.1e2 * t2028 + 0.9e1 / 0.2e2 * t7 * t417 * t513 - t1993 / 0.1e2 + 0.3e1 / 0.5e1 * t2035 + 0.9e1 / 0.2e2 * t7 * t179 * t1060 + t1954 - t2004 / 0.1e2 + 0.3e1 / 0.1e2 * t2043 + 0.3e1 / 0.2e2 * t7 * t80 * (-0.77e3 / 0.243e3 * t38 * t913 + 0.154e3 / 0.81e2 * t47 * t37 * t913 * t93 - 0.341e3 / 0.972e3 * t287 * t922 * sigma[2] * t93 + 0.19e2 / 0.324e3 * t651 * t929 * t434 * t93 - t1330 / t83 / t920 / t442 * t927 * t33 * t1837 / 0.2916e4));
  tv4rho3sigma11 = t8 * t2099 + 0.3e1 * t1065;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t2106 = t7 * t604 * t230;
  t2111 = t7 * t611 * t230;
  t2113 = t1071 * t527;
  t2119 = t7 * t623 * t230 / 0.648e4;
  t2120 = t1076 * t527;
  t2122 = t523 * t1082;
  t2129 = my_piecewise3(t2, 0, t7 * t600 * t230 / 0.192e4 + t2106 / 0.96e3 - t1068 * t527 / 0.192e3 - t2111 / 0.288e4 - t2113 / 0.144e3 + 0.13e2 / 0.576e3 * t520 * t1082 + t2119 + t2120 / 0.864e3 + 0.13e2 / 0.864e3 * t2122 - 0.13e2 / 0.324e3 * t227 * t54 * t228 * t470);
  tv4rho3lapl0 = t8 * t2129 + 0.3e1 * t1086;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t2136 = t7 * t688 * t237;
  t2139 = t7 * t692 * t237;
  t2143 = t7 * t696 * t237 / 0.648e4;
  t2145 = my_piecewise3(t70, 0, t7 * t684 * t237 / 0.192e4 + t2136 / 0.96e3 - t2139 / 0.288e4 + t2143);
  tv4rho3lapl1 = t8 * t2145 + 0.3e1 * t1099;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  t2147 = 0.2e1 * t1112;
  t2153 = t7 * t726 * t230 / 0.144e4;
  t2157 = t7 * t733 * t230;
  t2160 = t1104 * t527 / 0.432e3;
  t2168 = t7 * t722 * t230 / 0.192e4 + t2153 - t1101 * t527 / 0.288e3 - t2157 / 0.864e4 - t2160 + 0.13e2 / 0.1728e4 * t542 * t1082 + t2106 / 0.288e4 - t2111 / 0.432e4 - t2113 / 0.432e3 + t2119 + t2120 / 0.1296e4 + 0.13e2 / 0.2592e4 * t2122;
  t2169 = my_piecewise3(t2, 0, t2168);
  tv4rho3lapl2 = t8 * t2169 + t1086 + t2147;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  t2171 = 0.2e1 * t1126;
  t2177 = t7 * t769 * t237 / 0.144e4;
  t2179 = t7 * t773 * t237;
  t2186 = t1092 * t552 / 0.432e3;
  t2187 = t1095 * t552;
  t2190 = my_piecewise3(t70, 0, t7 * t765 * t237 / 0.192e4 + t2177 - t2179 / 0.864e4 + t2136 / 0.288e4 - t2139 / 0.432e4 + t2143 - t1089 * t552 / 0.576e3 - t2186 + t2187 / 0.2592e4);
  tv4rho3lapl3 = t8 * t2190 + t1099 + t2171;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  t2196 = t7 * t810 * t230;
  t2204 = my_piecewise3(t2, 0, t7 * t806 * t230 / 0.192e4 + t2196 / 0.288e4 - t1129 * t527 / 0.576e3 + t2153 - t2157 / 0.432e4 - t2160 - t2111 / 0.864e4 + t2119 + t2120 / 0.2592e4);
  tv4rho3lapl4 = t8 * t2204 + t1134 + t2147;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  t2210 = t7 * t840 * t237;
  t2215 = t1117 * t552;
  t2221 = t536 * t1145;
  t2223 = t7 * t836 * t237 / 0.192e4 + t2210 / 0.288e4 + t2177 - t2179 / 0.432e4 - t1114 * t552 / 0.288e3 - t2215 / 0.432e3 - t2139 / 0.864e4 + t2143 - t2186 + t2187 / 0.1296e4 + 0.13e2 / 0.1728e4 * t533 * t1145 + 0.13e2 / 0.2592e4 * t2221;
  t2224 = my_piecewise3(t70, 0, t2223);
  tv4rho3lapl5 = t8 * t2224 + t1149 + t2171;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  t2233 = my_piecewise3(t2, 0, t7 * t877 * t230 / 0.192e4 + t2196 / 0.96e3 - t2157 / 0.288e4 + t2119);
  tv4rho3lapl6 = t8 * t2233 + 0.3e1 * t1134;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  t2253 = my_piecewise3(t70, 0, t7 * t897 * t237 / 0.192e4 + t2210 / 0.96e3 - t1137 * t552 / 0.192e3 - t2179 / 0.288e4 - t2215 / 0.144e3 + 0.13e2 / 0.576e3 * t548 * t1145 + t2143 + t2187 / 0.864e3 + 0.13e2 / 0.864e3 * t2221 - 0.13e2 / 0.324e3 * t234 * t54 * t235 * t508);
  tv4rho3lapl7 = t8 * t2253 + 0.3e1 * t1149;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  tv4rho3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  tv4rho3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  tv4rho3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  tv4rho3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  tv4rho3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  tv4rho3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  tv4rho3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t2258 = t1071 * t560;
  t2266 = t1076 * t560 / 0.1728e5;
  t2267 = t523 * t1157;
  t2270 = t1163 * t120 * t1169;
  t2282 = t1163 * t32 * t1329;
  t2286 = t38 * t52;
  t2291 = my_piecewise3(t2, 0, t1068 * t560 / 0.384e4 + t2258 / 0.288e4 - t520 * t1157 / 0.36e3 + t1163 * t115 * t1169 / 0.288e4 - t2266 - t2267 / 0.54e3 + t2270 / 0.432e4 + 0.19e2 / 0.216e4 * t227 * t286 * t56 * t291 * t52 - 0.43e2 / 0.1728e5 * t1164 * t648 * t972 * t1168 + t2282 / t41 / t1323 * t288 * t2286 / 0.5184e5);
  tv4rho2sigma20 = t8 * t2291 + 0.2e1 * t1173;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t2296 = t1092 * t566;
  t2299 = t1095 * t566 / 0.1728e5;
  t2301 = my_piecewise3(t70, 0, t1089 * t566 / 0.384e4 + t2296 / 0.288e4 - t2299);
  tv4rho2sigma25 = t8 * t2301 + 0.2e1 * t1180;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t2305 = t1104 * t560;
  t2316 = my_piecewise3(t2, 0, t1101 * t560 / 0.384e4 + t2305 / 0.576e4 - t542 * t1157 / 0.72e3 + t1163 * t168 * t1169 / 0.576e4 + t2258 / 0.576e4 - t2266 - t2267 / 0.108e4 + t2270 / 0.864e4);
  tv4rho2sigma26 = t8 * t2316 + t1173 + t1185;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t2320 = t1117 * t566;
  t2325 = t536 * t1191;
  t2331 = t1163 * t155 * t1199;
  t2334 = my_piecewise3(t70, 0, t1114 * t566 / 0.384e4 + t2320 / 0.576e4 + t2296 / 0.576e4 - t2299 - t533 * t1191 / 0.72e3 - t2325 / 0.108e4 + t1163 * t151 * t1199 / 0.576e4 + t2331 / 0.864e4);
  tv4rho2sigma211 = t8 * t2334 + t1180 + t1203;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t2341 = my_piecewise3(t2, 0, t1129 * t560 / 0.384e4 + t2305 / 0.288e4 - t2266);
  tv4rho2sigma212 = t8 * t2341 + 0.2e1 * t1185;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t2364 = t1163 * t80 * t1329;
  t2368 = t38 * t93;
  t2373 = my_piecewise3(t70, 0, t1137 * t566 / 0.384e4 + t2320 / 0.288e4 - t548 * t1191 / 0.36e3 + t1163 * t179 * t1199 / 0.288e4 - t2299 - t2325 / 0.54e3 + t2331 / 0.432e4 + 0.19e2 / 0.216e4 * t234 * t286 * t56 * t437 * t93 - 0.43e2 / 0.1728e5 * t1194 * t648 * t1055 * t1198 + t2364 / t83 / t1825 * t434 * t2368 / 0.5184e5);
  tv4rho2sigma217 = t8 * t2373 + 0.2e1 * t1203;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  tv4rho2sigmalapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  tv4rho2sigmalapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  tv4rho2sigmalapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  tv4rho2sigmalapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  tv4rho2sigmalapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  tv4rho2sigmatau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  tv4rho2sigmatau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  tv4rho2sigmatau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  tv4rho2sigmatau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  tv4rho2sigmatau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  t2378 = t1071 * t571;
  t2383 = t1076 * t571 / 0.864e4;
  t2384 = t523 * t1210;
  t2390 = my_piecewise3(t2, 0, t1068 * t571 / 0.192e4 + t2378 / 0.144e4 - t520 * t1210 / 0.288e3 - t2383 - t2384 / 0.432e3 + 0.13e2 / 0.1728e4 * t227 * t54 * t558);
  tv4rho2lapl20 = t8 * t2390 + 0.2e1 * t1214;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  t2395 = t1092 * t576;
  t2398 = t1095 * t576 / 0.864e4;
  t2400 = my_piecewise3(t70, 0, t1089 * t576 / 0.192e4 + t2395 / 0.144e4 - t2398);
  tv4rho2lapl22 = t8 * t2400 + 0.2e1 * t1221;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  t2404 = t1104 * t571;
  t2411 = my_piecewise3(t2, 0, t1101 * t571 / 0.192e4 + t2404 / 0.288e4 - t542 * t1210 / 0.576e3 + t2378 / 0.288e4 - t2383 - t2384 / 0.864e3);
  tv4rho2lapl23 = t8 * t2411 + t1214 + t1226;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  t2415 = t1117 * t576;
  t2420 = t536 * t1231;
  t2423 = my_piecewise3(t70, 0, t1114 * t576 / 0.192e4 + t2415 / 0.288e4 + t2395 / 0.288e4 - t2398 - t533 * t1231 / 0.576e3 - t2420 / 0.864e3);
  tv4rho2lapl25 = t8 * t2423 + t1221 + t1235;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  t2430 = my_piecewise3(t2, 0, t1129 * t571 / 0.192e4 + t2404 / 0.144e4 - t2383);
  tv4rho2lapl26 = t8 * t2430 + 0.2e1 * t1226;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  t2443 = my_piecewise3(t70, 0, t1137 * t576 / 0.192e4 + t2415 / 0.144e4 - t548 * t1231 / 0.288e3 - t2398 - t2420 / 0.432e3 + 0.13e2 / 0.1728e4 * t234 * t54 * t564);
  tv4rho2lapl28 = t8 * t2443 + 0.2e1 * t1235;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  tv4rho2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  tv4rho2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  tv4rho2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  tv4rho2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  tv4rho2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t2448 = t119 * t648;
  t2451 = t1237 * t2448 * t1240 / 0.2304e5;
  t2464 = my_piecewise3(t2, 0, -t1163 * t114 * t1241 / 0.1536e5 - t2451 + t1237 * t1238 * t1166 * t52 / 0.192e4 - t2282 / t41 / t653 * t33 * t48 * t52 / 0.13824e6);
  tv4rhosigma30 = t8 * t2464 + t1244;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t2471 = t1245 * t2448 * t1247 / 0.2304e5;
  t2473 = my_piecewise3(t70, 0, -t1163 * t150 * t1248 / 0.1536e5 - t2471);
  tv4rhosigma39 = t8 * t2473 + t1251;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t2479 = my_piecewise3(t2, 0, -t1163 * t167 * t1241 / 0.1536e5 - t2451);
  tv4rhosigma310 = t8 * t2479 + t1244;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t2496 = my_piecewise3(t70, 0, -t1163 * t178 * t1248 / 0.1536e5 - t2471 + t1245 * t1238 * t1196 * t93 / 0.192e4 - t2364 / t83 / t928 * t33 * t89 * t93 / 0.13824e6);
  tv4rhosigma319 = t8 * t2496 + t1251;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  tv4rhosigma2lapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  tv4rhosigma2lapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  tv4rhosigma2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  tv4rhosigma2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  tv4rhosigma2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  tv4rhosigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  tv4rhosigmalapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  tv4rhosigmalapl29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  tv4rhosigmalapl217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  tv4rhosigmatau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  tv4rhosigmatau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  tv4rhosigmatau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  tv4rholapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  tv4rholapl33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  tv4rholapl34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  tv4rholapl37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  tv4rhotau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  tv4rhotau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  tv4rhotau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  tv4rhotau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t2504 = my_piecewise3(t2, 0, t1164 * t1329 / t41 / t971 * t2286 / 0.36864e6);
  tv4sigma40 = t8 * t2504;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t2511 = my_piecewise3(t70, 0, t1194 * t1329 / t83 / t1054 * t2368 / 0.36864e6);
  tv4sigma414 = t8 * t2511;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  tv4sigma3lapl19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  tv4sigma3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  tv4sigma3tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  tv4sigma2lapl217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  tv4sigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  tv4sigma2tau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  tv4sigmalapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  tv4sigmalapl311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  tv4sigmatau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  tv4sigmatau311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  tv4lapl40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  tv4lapl44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  tv4tau40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  tv4tau44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

