/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_k_csk_loc.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t39, t40, t41;
  double t44, t45, t46, t48, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t63, t64;
  double t65, t66, t67, t68, t69, t70, t72, t76;
  double tzk0;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t39 = 0.5e1 / 0.72e2 * t30 * t37;
  t40 = params->csk_cp * t25;
  t41 = t40 * t29;
  t44 = params->csk_cq * t25;
  t45 = t44 * t29;
  t46 = lapl[0] * t32;
  t48 = 0.1e1 / t23 / rho[0];
  t52 = t41 * t37 / 0.24e2 + t45 * t46 * t48 / 0.24e2 - t39;
  t54 = log(0.1e1 - DBL_EPSILON);
  t55 = 0.1e1 / params->csk_a;
  t56 = pow(-t54, -t55);
  t57 = t52 < -t56;
  t58 = log(DBL_EPSILON);
  t59 = pow(-t58, -t55);
  t60 = -t59 < t52;
  t61 = my_piecewise3(t60, -t59, t52);
  t62 = -t56 < t61;
  t63 = my_piecewise3(t62, t61, -t56);
  t64 = fabs(t63);
  t65 = pow(t64, params->csk_a);
  t66 = 0.1e1 / t65;
  t67 = exp(-t66);
  t68 = 0.1e1 - t67;
  t69 = pow(t68, t55);
  t70 = my_piecewise5(t57, 0, t60, 1, t69);
  t72 = t52 * t70 + t39 + 0.1e1;
  t76 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t72);
  tzk0 = 0.2e1 * t76;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t39, t40, t41;
  double t44, t45, t46, t48, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t63, t64;
  double t65, t66, t67, t68, t69, t70, t72, t76;
  double tzk0;

  double t78, t82, t84, t85, t87, t93, t95, t96;
  double t97, t99, t100, t102, t103, t104, t106, t108;
  double t113, tvrho0, t116, t118, t119, t120, t123, t125;
  double t126, t129, t131, t135, tvsigma0, t137, t144, t145;
  double t148, t150, t154, tvlapl0, tvtau0;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t39 = 0.5e1 / 0.72e2 * t30 * t37;
  t40 = params->csk_cp * t25;
  t41 = t40 * t29;
  t44 = params->csk_cq * t25;
  t45 = t44 * t29;
  t46 = lapl[0] * t32;
  t48 = 0.1e1 / t23 / rho[0];
  t52 = t41 * t37 / 0.24e2 + t45 * t46 * t48 / 0.24e2 - t39;
  t54 = log(0.1e1 - DBL_EPSILON);
  t55 = 0.1e1 / params->csk_a;
  t56 = pow(-t54, -t55);
  t57 = t52 < -t56;
  t58 = log(DBL_EPSILON);
  t59 = pow(-t58, -t55);
  t60 = -t59 < t52;
  t61 = my_piecewise3(t60, -t59, t52);
  t62 = -t56 < t61;
  t63 = my_piecewise3(t62, t61, -t56);
  t64 = fabs(t63);
  t65 = pow(t64, params->csk_a);
  t66 = 0.1e1 / t65;
  t67 = exp(-t66);
  t68 = 0.1e1 - t67;
  t69 = pow(t68, t55);
  t70 = my_piecewise5(t57, 0, t60, 1, t69);
  t72 = t52 * t70 + t39 + 0.1e1;
  t76 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t72);
  tzk0 = 0.2e1 * t76;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t78 = t21 / t22;
  t82 = t34 * rho[0];
  t84 = 0.1e1 / t23 / t82;
  t85 = t33 * t84;
  t87 = 0.5e1 / 0.27e2 * t30 * t85;
  t93 = -t41 * t85 / 0.9e1 - 0.5e1 / 0.72e2 * t45 * t46 * t36 + t87;
  t95 = t69 * t66;
  t96 = my_piecewise3(t60, 0, t93);
  t97 = my_piecewise3(t62, t96, 0);
  t99 = fabs(t63) / t63;
  t100 = 0.1e1 / t64;
  t102 = 0.1e1 / t68;
  t103 = t67 * t102;
  t104 = t99 * t100 * t103;
  t106 = my_piecewise5(t57, 0, t60, 0, -t95 * t97 * t104);
  t108 = t52 * t106 + t93 * t70 - t87;
  t113 = my_piecewise3(t3, 0, t8 * t78 * t72 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t108);
  tvrho0 = 0.2e1 * rho[0] * t113 + 0.2e1 * t76;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t116 = t32 * t36;
  t118 = 0.5e1 / 0.72e2 * t30 * t116;
  t119 = t29 * t32;
  t120 = t119 * t36;
  t123 = t40 * t120 / 0.24e2 - t118;
  t125 = my_piecewise3(t60, 0, t123);
  t126 = my_piecewise3(t62, t125, 0);
  t129 = my_piecewise5(t57, 0, t60, 0, -t95 * t126 * t104);
  t131 = t123 * t70 + t52 * t129 + t118;
  t135 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t131);
  tvsigma0 = 0.2e1 * rho[0] * t135;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t137 = t32 * t48;
  t144 = my_piecewise3(t60, 0, t44 * t119 * t48 / 0.24e2);
  t145 = my_piecewise3(t62, t144, 0);
  t148 = my_piecewise5(t57, 0, t60, 0, -t95 * t145 * t104);
  t150 = t45 * t137 * t70 / 0.24e2 + t52 * t148;
  t154 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t150);
  tvlapl0 = 0.2e1 * rho[0] * t154;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t39, t40, t41;
  double t44, t45, t46, t48, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t63, t64;
  double t65, t66, t67, t68, t69, t70, t72, t76;
  double tzk0;

  double t78, t82, t84, t85, t87, t93, t95, t96;
  double t97, t99, t100, t102, t103, t104, t106, t108;
  double t113, tvrho0, t116, t118, t119, t120, t123, t125;
  double t126, t129, t131, t135, tvsigma0, t137, t144, t145;
  double t148, t150, t154, tvlapl0, tvtau0;

  double t159, t166, t168, t169, t171, t177, t181, t183;
  double t184, t186, t187, t188, t189, t190, t191, t192;
  double t193, t194, t196, t198, t199, t200, t202, t203;
  double t206, t207, t209, t210, t211, t213, t215, t216;
  double t217, t220, t222, t227, tv2rho20, t233, t235, t236;
  double t239, t243, t244, t245, t246, t248, t249, t250;
  double t251, t253, t254, t257, t259, t260, t261, t263;
  double t265, t266, t269, t271, t276, tv2rhosigma0, t289, t290;
  double t292, t293, t297, t298, t301, t303, t305, t309;
  double t311, t316, tv2rholapl0, tv2rhotau0, t321, t324, t327, t328;
  double t330, t331, t332, t334, t338, t340, t344, tv2sigma20;
  double t352, t354, t355, t356, t357, t358, t361, t362;
  double t365, t367, t371, tv2sigmalapl0, tv2sigmatau0, t376, t379, t382;
  double t383, t385, t389, t391, t395, tv2lapl20, tv2lapltau0, tv2tau20;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t39 = 0.5e1 / 0.72e2 * t30 * t37;
  t40 = params->csk_cp * t25;
  t41 = t40 * t29;
  t44 = params->csk_cq * t25;
  t45 = t44 * t29;
  t46 = lapl[0] * t32;
  t48 = 0.1e1 / t23 / rho[0];
  t52 = t41 * t37 / 0.24e2 + t45 * t46 * t48 / 0.24e2 - t39;
  t54 = log(0.1e1 - DBL_EPSILON);
  t55 = 0.1e1 / params->csk_a;
  t56 = pow(-t54, -t55);
  t57 = t52 < -t56;
  t58 = log(DBL_EPSILON);
  t59 = pow(-t58, -t55);
  t60 = -t59 < t52;
  t61 = my_piecewise3(t60, -t59, t52);
  t62 = -t56 < t61;
  t63 = my_piecewise3(t62, t61, -t56);
  t64 = fabs(t63);
  t65 = pow(t64, params->csk_a);
  t66 = 0.1e1 / t65;
  t67 = exp(-t66);
  t68 = 0.1e1 - t67;
  t69 = pow(t68, t55);
  t70 = my_piecewise5(t57, 0, t60, 1, t69);
  t72 = t52 * t70 + t39 + 0.1e1;
  t76 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t72);
  tzk0 = 0.2e1 * t76;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t78 = t21 / t22;
  t82 = t34 * rho[0];
  t84 = 0.1e1 / t23 / t82;
  t85 = t33 * t84;
  t87 = 0.5e1 / 0.27e2 * t30 * t85;
  t93 = -t41 * t85 / 0.9e1 - 0.5e1 / 0.72e2 * t45 * t46 * t36 + t87;
  t95 = t69 * t66;
  t96 = my_piecewise3(t60, 0, t93);
  t97 = my_piecewise3(t62, t96, 0);
  t99 = fabs(t63) / t63;
  t100 = 0.1e1 / t64;
  t102 = 0.1e1 / t68;
  t103 = t67 * t102;
  t104 = t99 * t100 * t103;
  t106 = my_piecewise5(t57, 0, t60, 0, -t95 * t97 * t104);
  t108 = t52 * t106 + t93 * t70 - t87;
  t113 = my_piecewise3(t3, 0, t8 * t78 * t72 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t108);
  tvrho0 = 0.2e1 * rho[0] * t113 + 0.2e1 * t76;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t116 = t32 * t36;
  t118 = 0.5e1 / 0.72e2 * t30 * t116;
  t119 = t29 * t32;
  t120 = t119 * t36;
  t123 = t40 * t120 / 0.24e2 - t118;
  t125 = my_piecewise3(t60, 0, t123);
  t126 = my_piecewise3(t62, t125, 0);
  t129 = my_piecewise5(t57, 0, t60, 0, -t95 * t126 * t104);
  t131 = t123 * t70 + t52 * t129 + t118;
  t135 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t131);
  tvsigma0 = 0.2e1 * rho[0] * t135;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t137 = t32 * t48;
  t144 = my_piecewise3(t60, 0, t44 * t119 * t48 / 0.24e2);
  t145 = my_piecewise3(t62, t144, 0);
  t148 = my_piecewise5(t57, 0, t60, 0, -t95 * t145 * t104);
  t150 = t45 * t137 * t70 / 0.24e2 + t52 * t148;
  t154 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t150);
  tvlapl0 = 0.2e1 * rho[0] * t154;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t159 = t21 / t22 / rho[0];
  t166 = t34 * t34;
  t168 = 0.1e1 / t23 / t166;
  t169 = t33 * t168;
  t171 = 0.55e2 / 0.81e2 * t30 * t169;
  t177 = 0.11e2 / 0.27e2 * t41 * t169 + 0.5e1 / 0.27e2 * t45 * t46 * t84 - t171;
  t181 = t65 * t65;
  t183 = t69 / t181;
  t184 = t97 * t97;
  t186 = t99 * t99;
  t187 = t64 * t64;
  t188 = 0.1e1 / t187;
  t189 = t186 * t188;
  t190 = t67 * t67;
  t191 = t68 * t68;
  t192 = 0.1e1 / t191;
  t193 = t190 * t192;
  t194 = t189 * t193;
  t196 = t184 * t186;
  t198 = t188 * t67;
  t199 = t102 * params->csk_a;
  t200 = t198 * t199;
  t202 = my_piecewise3(t60, 0, t177);
  t203 = my_piecewise3(t62, t202, 0);
  t206 = t95 * t184;
  t207 = 0.0;
  t209 = t207 * t100 * t103;
  t210 = t206 * t209;
  t211 = t189 * t103;
  t213 = t183 * t196;
  t215 = t188 * t190;
  t216 = t192 * params->csk_a;
  t217 = t215 * t216;
  t220 = my_piecewise5(t57, 0, t60, 0, -t95 * t203 * t104 + t183 * t184 * t194 + t95 * t196 * t200 - t213 * t200 + t206 * t211 - t213 * t217 - t210);
  t222 = 0.2e1 * t93 * t106 + t177 * t70 + t52 * t220 + t171;
  t227 = my_piecewise3(t3, 0, -t8 * t159 * t72 / 0.3e2 + t8 * t78 * t108 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t222);
  tv2rho20 = 0.2e1 * rho[0] * t227 + 0.4e1 * t113;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t233 = t32 * t84;
  t235 = 0.5e1 / 0.27e2 * t30 * t233;
  t236 = t119 * t84;
  t239 = -t40 * t236 / 0.9e1 + t235;
  t243 = t97 * t186;
  t244 = t183 * t243;
  t245 = t192 * t126;
  t246 = t215 * t245;
  t248 = t126 * t186;
  t249 = t95 * t248;
  t250 = t199 * t97;
  t251 = t198 * t250;
  t253 = my_piecewise3(t60, 0, t239);
  t254 = my_piecewise3(t62, t253, 0);
  t257 = t126 * t97;
  t259 = t95 * t257 * t209;
  t260 = t102 * t97;
  t261 = t198 * t260;
  t263 = t183 * t248;
  t265 = t216 * t97;
  t266 = t215 * t265;
  t269 = my_piecewise5(t57, 0, t60, 0, -t95 * t254 * t104 + t244 * t246 + t249 * t251 + t249 * t261 - t263 * t251 - t263 * t266 - t259);
  t271 = t123 * t106 + t93 * t129 + t239 * t70 + t52 * t269 - t235;
  t276 = my_piecewise3(t3, 0, t8 * t78 * t131 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t271);
  tv2rhosigma0 = 0.2e1 * rho[0] * t276 + 0.2e1 * t135;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t289 = t192 * t145;
  t290 = t215 * t289;
  t292 = t145 * t186;
  t293 = t95 * t292;
  t297 = my_piecewise3(t60, 0, -0.5e1 / 0.72e2 * t44 * t120);
  t298 = my_piecewise3(t62, t297, 0);
  t301 = t145 * t97;
  t303 = t95 * t301 * t209;
  t305 = t183 * t292;
  t309 = my_piecewise5(t57, 0, t60, 0, -t95 * t298 * t104 + t244 * t290 + t293 * t251 - t305 * t251 + t293 * t261 - t305 * t266 - t303);
  t311 = -0.5e1 / 0.72e2 * t45 * t116 * t70 + t45 * t137 * t106 / 0.24e2 + t93 * t148 + t52 * t309;
  t316 = my_piecewise3(t3, 0, t8 * t78 * t150 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t311);
  tv2rholapl0 = 0.2e1 * rho[0] * t316 + 0.2e1 * t154;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t321 = t126 * t126;
  t324 = t321 * t186;
  t327 = my_piecewise3(t60, 0, 0);
  t328 = my_piecewise3(t62, t327, 0);
  t330 = t95 * t328 * t104;
  t331 = t95 * t321;
  t332 = t331 * t209;
  t334 = t183 * t324;
  t338 = my_piecewise5(t57, 0, t60, 0, t183 * t321 * t194 + t95 * t324 * t200 - t334 * t200 + t331 * t211 - t334 * t217 - t330 - t332);
  t340 = 0.2e1 * t123 * t129 + t52 * t338;
  t344 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t340);
  tv2sigma20 = 0.2e1 * rho[0] * t344;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t352 = t198 * t199 * t126;
  t354 = t145 * t126;
  t355 = t95 * t354;
  t356 = t355 * t209;
  t357 = t102 * t126;
  t358 = t198 * t357;
  t361 = t216 * t126;
  t362 = t215 * t361;
  t365 = my_piecewise5(t57, 0, t60, 0, t263 * t290 + t293 * t352 + t293 * t358 - t305 * t352 - t305 * t362 - t330 - t356);
  t367 = t45 * t137 * t129 / 0.24e2 + t123 * t148 + t52 * t365;
  t371 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t367);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t371;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t376 = t145 * t145;
  t379 = t376 * t186;
  t382 = t95 * t376;
  t383 = t382 * t209;
  t385 = t183 * t379;
  t389 = my_piecewise5(t57, 0, t60, 0, t183 * t376 * t194 + t95 * t379 * t200 - t385 * t200 + t382 * t211 - t385 * t217 - t330 - t383);
  t391 = t45 * t137 * t148 / 0.12e2 + t52 * t389;
  t395 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t391);
  tv2lapl20 = 0.2e1 * rho[0] * t395;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t39, t40, t41;
  double t44, t45, t46, t48, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t63, t64;
  double t65, t66, t67, t68, t69, t70, t72, t76;
  double tzk0;

  double t78, t82, t84, t85, t87, t93, t95, t96;
  double t97, t99, t100, t102, t103, t104, t106, t108;
  double t113, tvrho0, t116, t118, t119, t120, t123, t125;
  double t126, t129, t131, t135, tvsigma0, t137, t144, t145;
  double t148, t150, t154, tvlapl0, tvtau0;

  double t159, t166, t168, t169, t171, t177, t181, t183;
  double t184, t186, t187, t188, t189, t190, t191, t192;
  double t193, t194, t196, t198, t199, t200, t202, t203;
  double t206, t207, t209, t210, t211, t213, t215, t216;
  double t217, t220, t222, t227, tv2rho20, t233, t235, t236;
  double t239, t243, t244, t245, t246, t248, t249, t250;
  double t251, t253, t254, t257, t259, t260, t261, t263;
  double t265, t266, t269, t271, t276, tv2rhosigma0, t289, t290;
  double t292, t293, t297, t298, t301, t303, t305, t309;
  double t311, t316, tv2rholapl0, tv2rhotau0, t321, t324, t327, t328;
  double t330, t331, t332, t334, t338, t340, t344, tv2sigma20;
  double t352, t354, t355, t356, t357, t358, t361, t362;
  double t365, t367, t371, tv2sigmalapl0, tv2sigmatau0, t376, t379, t382;
  double t383, t385, t389, t391, t395, tv2lapl20, tv2lapltau0, tv2tau20;

  double t400, t412, t413, t415, t421, t429, t430, t432;
  double t434, t435, t436, t438, t439, t440, t442, t443;
  double t447, t451, t454, t455, t458, t459, t461, t462;
  double t466, t468, t469, t470, t472, t474, t475, t476;
  double t479, t480, t483, t484, t485, t486, t489, t492;
  double t494, t495, t496, t502, t503, t504, t506, t507;
  double t508, t511, t512, t513, t514, t519, t523, t524;
  double t525, t528, t529, t534, t538, t539, t542, t544;
  double t546, t551, tv3rho30, t561, t563, t564, t567, t575;
  double t576, t579, t580, t581, t583, t584, t587, t588;
  double t590, t591, t594, t595, t596, t597, t598, t601;
  double t602, t606, t609, t613, t614, t619, t622, t625;
  double t626, t628, t629, t630, t631, t632, t634, t637;
  double t638, t640, t645, t646, t647, t648, t649, t650;
  double t651, t653, t654, t655, t657, t659, t660, t663;
  double t664, t670, t671, t678, t682, t683, t684, t686;
  double t688, t690, t695, tv3rho2sigma0, t719, t720, t723, t724;
  double t727, t728, t731, t734, t735, t736, t738, t740;
  double t742, t743, t749, t751, t752, t753, t757, t760;
  double t764, t765, t766, t769, t770, t772, t774, t778;
  double t786, t787, t798, t799, t800, t802, t804, t806;
  double t808, t813, tv3rho2lapl0, tv3rho2tau0, t824, t825, t826, t827;
  double t828, t829, t832, t833, t834, t839, t840, t841;
  double t842, t844, t845, t846, t847, t849, t850, t851;
  double t852, t853, t855, t856, t857, t860, t862, t863;
  double t864, t865, t867, t869, t870, t871, t872, t874;
  double t875, t876, t878, t880, t881, t883, t884, t885;
  double t886, t887, t892, t893, t896, t897, t901, t904;
  double t905, t908, t909, t911, t912, t918, t919, t920;
  double t921, t923, t924, t927, t933, t935, t937, t942;
  double tv3rhosigma20, t957, t958, t960, t961, t963, t964, t965;
  double t966, t968, t969, t970, t974, t976, t977, t979;
  double t982, t983, t984, t985, t986, t989, t990, t991;
  double t992, t995, t996, t999, t1000, t1001, t1002, t1004;
  double t1005, t1006, t1007, t1008, t1011, t1012, t1015, t1016;
  double t1018, t1021, t1029, t1032, t1033, t1040, t1041, t1045;
  double t1047, t1049, t1054, tv3rhosigmalapl0, tv3rhosigmatau0, t1067, t1071, t1072;
  double t1074, t1075, t1078, t1079, t1081, t1082, t1085, t1088;
  double t1090, t1091, t1093, t1095, t1096, t1098, t1100, t1101;
  double t1103, t1106, t1107, t1108, t1113, t1114, t1120, t1136;
  double t1138, t1140, t1145, tv3rholapl20, tv3rholapltau0, tv3rhotau20, t1150, t1151;
  double t1152, t1153, t1154, t1155, t1156, t1157, t1159, t1160;
  double t1161, t1162, t1165, t1167, t1168, t1171, t1172, t1175;
  double t1180, t1182, t1198, t1199, t1200, t1201, t1202, t1204;
  double t1205, t1206, t1207, t1208, t1209, t1211, t1212, t1213;
  double t1214, t1216, t1218, t1222, tv3sigma30, t1229, t1230, t1231;
  double t1232, t1233, t1234, t1235, t1239, t1240, t1241, t1246;
  double t1247, t1248, t1249, t1250, t1251, t1252, t1253, t1254;
  double t1255, t1256, t1257, t1260, t1265, t1266, t1267, t1268;
  double t1269, t1270, t1273, t1274, t1279, t1281, t1282, t1285;
  double t1286, t1287, t1288, t1289, t1292, t1295, t1298, t1299;
  double t1300, t1302, t1304, t1308, tv3sigma2lapl0, tv3sigma2tau0, t1314, t1315;
  double t1316, t1323, t1325, t1326, t1328, t1329, t1330, t1331;
  double t1332, t1333, t1336, t1337, t1340, t1341, t1342, t1348;
  double t1349, t1354, t1355, t1358, t1362, t1363, t1368, t1369;
  double t1370, t1371, t1373, t1375, t1379, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20;
  double t1384, t1385, t1386, t1387, t1388, t1389, t1392, t1393;
  double t1394, t1395, t1396, t1398, t1399, t1400, t1407, t1412;
  double t1427, t1428, t1429, t1431, t1432, t1433, t1434, t1435;
  double t1436, t1437, t1438, t1440, t1442, t1446, tv3lapl30, tv3lapl2tau0;
  double tv3lapltau20, tv3tau30;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t39 = 0.5e1 / 0.72e2 * t30 * t37;
  t40 = params->csk_cp * t25;
  t41 = t40 * t29;
  t44 = params->csk_cq * t25;
  t45 = t44 * t29;
  t46 = lapl[0] * t32;
  t48 = 0.1e1 / t23 / rho[0];
  t52 = t41 * t37 / 0.24e2 + t45 * t46 * t48 / 0.24e2 - t39;
  t54 = log(0.1e1 - DBL_EPSILON);
  t55 = 0.1e1 / params->csk_a;
  t56 = pow(-t54, -t55);
  t57 = t52 < -t56;
  t58 = log(DBL_EPSILON);
  t59 = pow(-t58, -t55);
  t60 = -t59 < t52;
  t61 = my_piecewise3(t60, -t59, t52);
  t62 = -t56 < t61;
  t63 = my_piecewise3(t62, t61, -t56);
  t64 = fabs(t63);
  t65 = pow(t64, params->csk_a);
  t66 = 0.1e1 / t65;
  t67 = exp(-t66);
  t68 = 0.1e1 - t67;
  t69 = pow(t68, t55);
  t70 = my_piecewise5(t57, 0, t60, 1, t69);
  t72 = t52 * t70 + t39 + 0.1e1;
  t76 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t72);
  tzk0 = 0.2e1 * t76;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t78 = t21 / t22;
  t82 = t34 * rho[0];
  t84 = 0.1e1 / t23 / t82;
  t85 = t33 * t84;
  t87 = 0.5e1 / 0.27e2 * t30 * t85;
  t93 = -t41 * t85 / 0.9e1 - 0.5e1 / 0.72e2 * t45 * t46 * t36 + t87;
  t95 = t69 * t66;
  t96 = my_piecewise3(t60, 0, t93);
  t97 = my_piecewise3(t62, t96, 0);
  t99 = fabs(t63) / t63;
  t100 = 0.1e1 / t64;
  t102 = 0.1e1 / t68;
  t103 = t67 * t102;
  t104 = t99 * t100 * t103;
  t106 = my_piecewise5(t57, 0, t60, 0, -t95 * t97 * t104);
  t108 = t52 * t106 + t93 * t70 - t87;
  t113 = my_piecewise3(t3, 0, t8 * t78 * t72 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t108);
  tvrho0 = 0.2e1 * rho[0] * t113 + 0.2e1 * t76;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t116 = t32 * t36;
  t118 = 0.5e1 / 0.72e2 * t30 * t116;
  t119 = t29 * t32;
  t120 = t119 * t36;
  t123 = t40 * t120 / 0.24e2 - t118;
  t125 = my_piecewise3(t60, 0, t123);
  t126 = my_piecewise3(t62, t125, 0);
  t129 = my_piecewise5(t57, 0, t60, 0, -t95 * t126 * t104);
  t131 = t123 * t70 + t52 * t129 + t118;
  t135 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t131);
  tvsigma0 = 0.2e1 * rho[0] * t135;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t137 = t32 * t48;
  t144 = my_piecewise3(t60, 0, t44 * t119 * t48 / 0.24e2);
  t145 = my_piecewise3(t62, t144, 0);
  t148 = my_piecewise5(t57, 0, t60, 0, -t95 * t145 * t104);
  t150 = t45 * t137 * t70 / 0.24e2 + t52 * t148;
  t154 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t150);
  tvlapl0 = 0.2e1 * rho[0] * t154;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t159 = t21 / t22 / rho[0];
  t166 = t34 * t34;
  t168 = 0.1e1 / t23 / t166;
  t169 = t33 * t168;
  t171 = 0.55e2 / 0.81e2 * t30 * t169;
  t177 = 0.11e2 / 0.27e2 * t41 * t169 + 0.5e1 / 0.27e2 * t45 * t46 * t84 - t171;
  t181 = t65 * t65;
  t183 = t69 / t181;
  t184 = t97 * t97;
  t186 = t99 * t99;
  t187 = t64 * t64;
  t188 = 0.1e1 / t187;
  t189 = t186 * t188;
  t190 = t67 * t67;
  t191 = t68 * t68;
  t192 = 0.1e1 / t191;
  t193 = t190 * t192;
  t194 = t189 * t193;
  t196 = t184 * t186;
  t198 = t188 * t67;
  t199 = t102 * params->csk_a;
  t200 = t198 * t199;
  t202 = my_piecewise3(t60, 0, t177);
  t203 = my_piecewise3(t62, t202, 0);
  t206 = t95 * t184;
  t207 = 0.0;
  t209 = t207 * t100 * t103;
  t210 = t206 * t209;
  t211 = t189 * t103;
  t213 = t183 * t196;
  t215 = t188 * t190;
  t216 = t192 * params->csk_a;
  t217 = t215 * t216;
  t220 = my_piecewise5(t57, 0, t60, 0, -t95 * t203 * t104 + t183 * t184 * t194 + t95 * t196 * t200 - t213 * t200 + t206 * t211 - t213 * t217 - t210);
  t222 = 0.2e1 * t93 * t106 + t177 * t70 + t52 * t220 + t171;
  t227 = my_piecewise3(t3, 0, -t8 * t159 * t72 / 0.3e2 + t8 * t78 * t108 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t222);
  tv2rho20 = 0.2e1 * rho[0] * t227 + 0.4e1 * t113;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t233 = t32 * t84;
  t235 = 0.5e1 / 0.27e2 * t30 * t233;
  t236 = t119 * t84;
  t239 = -t40 * t236 / 0.9e1 + t235;
  t243 = t97 * t186;
  t244 = t183 * t243;
  t245 = t192 * t126;
  t246 = t215 * t245;
  t248 = t126 * t186;
  t249 = t95 * t248;
  t250 = t199 * t97;
  t251 = t198 * t250;
  t253 = my_piecewise3(t60, 0, t239);
  t254 = my_piecewise3(t62, t253, 0);
  t257 = t126 * t97;
  t259 = t95 * t257 * t209;
  t260 = t102 * t97;
  t261 = t198 * t260;
  t263 = t183 * t248;
  t265 = t216 * t97;
  t266 = t215 * t265;
  t269 = my_piecewise5(t57, 0, t60, 0, -t95 * t254 * t104 + t244 * t246 + t249 * t251 + t249 * t261 - t263 * t251 - t263 * t266 - t259);
  t271 = t123 * t106 + t93 * t129 + t239 * t70 + t52 * t269 - t235;
  t276 = my_piecewise3(t3, 0, t8 * t78 * t131 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t271);
  tv2rhosigma0 = 0.2e1 * rho[0] * t276 + 0.2e1 * t135;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t289 = t192 * t145;
  t290 = t215 * t289;
  t292 = t145 * t186;
  t293 = t95 * t292;
  t297 = my_piecewise3(t60, 0, -0.5e1 / 0.72e2 * t44 * t120);
  t298 = my_piecewise3(t62, t297, 0);
  t301 = t145 * t97;
  t303 = t95 * t301 * t209;
  t305 = t183 * t292;
  t309 = my_piecewise5(t57, 0, t60, 0, -t95 * t298 * t104 + t244 * t290 + t293 * t251 - t305 * t251 + t293 * t261 - t305 * t266 - t303);
  t311 = -0.5e1 / 0.72e2 * t45 * t116 * t70 + t45 * t137 * t106 / 0.24e2 + t93 * t148 + t52 * t309;
  t316 = my_piecewise3(t3, 0, t8 * t78 * t150 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t311);
  tv2rholapl0 = 0.2e1 * rho[0] * t316 + 0.2e1 * t154;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t321 = t126 * t126;
  t324 = t321 * t186;
  t327 = my_piecewise3(t60, 0, 0);
  t328 = my_piecewise3(t62, t327, 0);
  t330 = t95 * t328 * t104;
  t331 = t95 * t321;
  t332 = t331 * t209;
  t334 = t183 * t324;
  t338 = my_piecewise5(t57, 0, t60, 0, t183 * t321 * t194 + t95 * t324 * t200 - t334 * t200 + t331 * t211 - t334 * t217 - t330 - t332);
  t340 = 0.2e1 * t123 * t129 + t52 * t338;
  t344 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t340);
  tv2sigma20 = 0.2e1 * rho[0] * t344;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t352 = t198 * t199 * t126;
  t354 = t145 * t126;
  t355 = t95 * t354;
  t356 = t355 * t209;
  t357 = t102 * t126;
  t358 = t198 * t357;
  t361 = t216 * t126;
  t362 = t215 * t361;
  t365 = my_piecewise5(t57, 0, t60, 0, t263 * t290 + t293 * t352 + t293 * t358 - t305 * t352 - t305 * t362 - t330 - t356);
  t367 = t45 * t137 * t129 / 0.24e2 + t123 * t148 + t52 * t365;
  t371 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t367);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t371;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t376 = t145 * t145;
  t379 = t376 * t186;
  t382 = t95 * t376;
  t383 = t382 * t209;
  t385 = t183 * t379;
  t389 = my_piecewise5(t57, 0, t60, 0, t183 * t376 * t194 + t95 * t379 * t200 - t385 * t200 + t382 * t211 - t385 * t217 - t330 - t383);
  t391 = t45 * t137 * t148 / 0.12e2 + t52 * t389;
  t395 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t391);
  tv2lapl20 = 0.2e1 * rho[0] * t395;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t400 = t21 / t22 / t34;
  t412 = 0.1e1 / t23 / t166 / rho[0];
  t413 = t33 * t412;
  t415 = 0.77e3 / 0.243e3 * t30 * t413;
  t421 = -0.154e3 / 0.81e2 * t41 * t413 - 0.55e2 / 0.81e2 * t45 * t46 * t168 + t415;
  t429 = t69 / t181 / t65;
  t430 = t184 * t97;
  t432 = t186 * t99;
  t434 = 0.1e1 / t187 / t64;
  t435 = t432 * t434;
  t436 = t190 * t67;
  t438 = 0.1e1 / t191 / t68;
  t439 = t436 * t438;
  t440 = t435 * t439;
  t442 = my_piecewise3(t60, 0, t421);
  t443 = my_piecewise3(t62, t442, 0);
  t447 = t435 * t193;
  t451 = t435 * t103;
  t454 = t203 * t186;
  t455 = t183 * t454;
  t458 = t430 * t207;
  t459 = t183 * t458;
  t461 = t215 * t216 * t99;
  t462 = t459 * t461;
  t466 = t188 * params->csk_a;
  t468 = t99 * t67 * t102;
  t469 = t466 * t468;
  t470 = t459 * t469;
  t472 = t430 * t99;
  t474 = t199 * t207;
  t475 = t198 * t474;
  t476 = t95 * t472 * t475;
  t479 = t199 * t203;
  t480 = t198 * t479;
  t483 = t430 * t432;
  t484 = t183 * t483;
  t485 = t434 * params->csk_a;
  t486 = t485 * t103;
  t489 = t95 * t483;
  t492 = -t95 * t443 * t104 - 0.3e1 * t183 * t430 * t447 + 0.3e1 * t95 * t243 * t480 - t429 * t430 * t440 - 0.2e1 * t95 * t430 * t451 - 0.3e1 * t455 * t251 - 0.3e1 * t455 * t266 + 0.3e1 * t484 * t486 - 0.3e1 * t489 * t486 - t210 - 0.3e1 * t462 - 0.3e1 * t470 + 0.3e1 * t476;
  t494 = t192 * t207;
  t495 = t215 * t494;
  t496 = t183 * t472 * t495;
  t502 = t102 * t99;
  t503 = t198 * t502;
  t504 = t95 * t458 * t503;
  t506 = t429 * t483;
  t507 = t434 * t190;
  t508 = t507 * t216;
  t511 = t434 * t67;
  t512 = params->csk_a * params->csk_a;
  t513 = t102 * t512;
  t514 = t511 * t513;
  t519 = t192 * t203;
  t523 = t434 * t436;
  t524 = t438 * params->csk_a;
  t525 = t523 * t524;
  t528 = t192 * t512;
  t529 = t507 * t528;
  t534 = t95 * t203 * t97 * t209;
  t538 = t438 * t512;
  t539 = t523 * t538;
  t542 = 0.3e1 * t244 * t215 * t519 + 0.3e1 * t95 * t454 * t261 + 0.3e1 * t484 * t514 + 0.3e1 * t484 * t529 - t489 * t514 + 0.3e1 * t506 * t508 - t506 * t514 + 0.3e1 * t506 * t525 - 0.3e1 * t506 * t529 - 0.2e1 * t506 * t539 + 0.3e1 * t496 + 0.3e1 * t504 - 0.3e1 * t534;
  t544 = my_piecewise5(t57, 0, t60, 0, t492 + t542);
  t546 = 0.3e1 * t177 * t106 + 0.3e1 * t93 * t220 + t421 * t70 + t52 * t544 - t415;
  t551 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t400 * t72 - t8 * t159 * t108 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t78 * t222 + 0.3e1 / 0.2e2 * t8 * t24 * t546);
  tv3rho30 = 0.2e1 * rho[0] * t551 + 0.6e1 * t227;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t561 = t32 * t168;
  t563 = 0.55e2 / 0.81e2 * t30 * t561;
  t564 = t119 * t168;
  t567 = 0.11e2 / 0.27e2 * t40 * t564 - t563;
  t575 = my_piecewise3(t60, 0, t567);
  t576 = my_piecewise3(t62, t575, 0);
  t579 = t126 * t432;
  t580 = t429 * t579;
  t581 = t434 * t512;
  t583 = t184 * t190 * t192;
  t584 = t581 * t583;
  t587 = t216 * t203;
  t588 = t215 * t587;
  t590 = t538 * t184;
  t591 = t523 * t590;
  t594 = t184 * t432;
  t595 = t429 * t594;
  t596 = t438 * t126;
  t597 = t596 * params->csk_a;
  t598 = t523 * t597;
  t601 = t254 * t186;
  t602 = t95 * t601;
  t606 = t183 * t579;
  t609 = t183 * t601;
  t613 = t184 * t67 * t102;
  t614 = t485 * t613;
  t619 = t95 * t579;
  t622 = t126 * t184;
  t625 = t207 * t188 * t468;
  t626 = t95 * t622 * t625;
  t628 = t184 * t99;
  t629 = t183 * t628;
  t630 = t245 * t207;
  t631 = t215 * t630;
  t632 = t629 * t631;
  t634 = t507 * t361;
  t637 = t513 * t184;
  t638 = t511 * t637;
  t640 = -t95 * t576 * t104 + t249 * t480 + 0.2e1 * t602 * t251 - 0.2e1 * t609 * t251 - t263 * t588 - 0.2e1 * t609 * t266 - 0.3e1 * t580 * t584 - 0.2e1 * t580 * t591 + 0.3e1 * t606 * t584 + 0.3e1 * t595 * t598 + 0.3e1 * t595 * t634 + 0.3e1 * t606 * t614 - 0.3e1 * t619 * t614 - t619 * t638 + 0.3e1 * t626 + 0.3e1 * t632;
  t645 = t126 * t99;
  t646 = t645 * t188;
  t647 = t95 * t646;
  t648 = params->csk_a * t184;
  t649 = t648 * t207;
  t650 = t103 * t649;
  t651 = t647 * t650;
  t653 = t622 * t207;
  t654 = t183 * t653;
  t655 = t654 * t461;
  t657 = t654 * t469;
  t659 = t102 * t184;
  t660 = t511 * t659;
  t663 = t183 * t594;
  t664 = t507 * t245;
  t670 = t192 * t254;
  t671 = t215 * t670;
  t678 = t95 * t254 * t97 * t209;
  t682 = t95 * t126 * t203 * t209;
  t683 = t102 * t203;
  t684 = t198 * t683;
  t686 = -t595 * t523 * t596 + 0.2e1 * t244 * t671 + t455 * t246 + t249 * t684 + 0.2e1 * t602 * t261 - t263 * t480 - t580 * t638 + 0.3e1 * t606 * t638 - 0.2e1 * t619 * t660 - 0.3e1 * t663 * t664 - t259 + 0.3e1 * t651 - 0.3e1 * t655 - 0.3e1 * t657 - 0.2e1 * t678 - t682;
  t688 = my_piecewise5(t57, 0, t60, 0, t640 + t686);
  t690 = 0.2e1 * t239 * t106 + t123 * t220 + t177 * t129 + 0.2e1 * t93 * t269 + t52 * t688 + t567 * t70 + t563;
  t695 = my_piecewise3(t3, 0, -t8 * t159 * t131 / 0.3e2 + t8 * t78 * t271 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t690);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t695 + 0.4e1 * t276;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t719 = my_piecewise3(t60, 0, 0.5e1 / 0.27e2 * t44 * t236);
  t720 = my_piecewise3(t62, t719, 0);
  t723 = t145 * t432;
  t724 = t183 * t723;
  t727 = t298 * t186;
  t728 = t183 * t727;
  t731 = t95 * t723;
  t734 = t289 * t207;
  t735 = t215 * t734;
  t736 = t629 * t735;
  t738 = t145 * t184;
  t740 = t95 * t738 * t625;
  t742 = t289 * params->csk_a;
  t743 = t507 * t742;
  t749 = t429 * t723;
  t751 = t738 * t207;
  t752 = t183 * t751;
  t753 = t752 * t469;
  t757 = t507 * t289;
  t760 = t95 * t727;
  t764 = -t95 * t720 * t104 - 0.2e1 * t728 * t251 + 0.2e1 * t760 * t261 + t455 * t290 + 0.3e1 * t595 * t743 + 0.3e1 * t724 * t614 - 0.3e1 * t731 * t614 + 0.3e1 * t724 * t638 - t731 * t638 - t749 * t638 - 0.2e1 * t731 * t660 - 0.3e1 * t663 * t757 - t303 + 0.3e1 * t736 + 0.3e1 * t740 - 0.3e1 * t753;
  t765 = t192 * t298;
  t766 = t215 * t765;
  t769 = t438 * t145;
  t770 = t523 * t769;
  t772 = t298 * t97;
  t774 = t95 * t772 * t209;
  t778 = t95 * t145 * t203 * t209;
  t786 = t769 * params->csk_a;
  t787 = t523 * t786;
  t798 = t145 * t99 * t188;
  t799 = t95 * t798;
  t800 = t799 * t650;
  t802 = t752 * t461;
  t804 = 0.2e1 * t244 * t766 + 0.2e1 * t760 * t251 - 0.2e1 * t728 * t266 + t293 * t480 + t293 * t684 - t305 * t480 - t305 * t588 + 0.3e1 * t724 * t584 - 0.3e1 * t749 * t584 - 0.2e1 * t749 * t591 - t595 * t770 + 0.3e1 * t595 * t787 - 0.2e1 * t774 - t778 + 0.3e1 * t800 - 0.3e1 * t802;
  t806 = my_piecewise5(t57, 0, t60, 0, t764 + t804);
  t808 = 0.5e1 / 0.27e2 * t45 * t233 * t70 - 0.5e1 / 0.36e2 * t45 * t116 * t106 + t45 * t137 * t220 / 0.24e2 + t177 * t148 + 0.2e1 * t93 * t309 + t52 * t806;
  t813 = my_piecewise3(t3, 0, -t8 * t159 * t150 / 0.3e2 + t8 * t78 * t311 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t808);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t813 + 0.4e1 * t316;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t824 = t328 * t186;
  t825 = t95 * t824;
  t826 = t825 * t261;
  t827 = t321 * t432;
  t828 = t95 * t827;
  t829 = t511 * t260;
  t832 = t183 * t827;
  t833 = t192 * t97;
  t834 = t507 * t833;
  t839 = t97 * t432;
  t840 = t429 * t839;
  t841 = t438 * t321;
  t842 = t523 * t841;
  t844 = t192 * t328;
  t845 = t215 * t844;
  t846 = t244 * t845;
  t847 = t328 * t97;
  t849 = t95 * t847 * t209;
  t850 = t126 * t207;
  t851 = t95 * t850;
  t852 = t100 * t67;
  t853 = t102 * t254;
  t855 = t851 * t852 * t853;
  t856 = 0.2e1 * t855;
  t857 = t198 * t853;
  t860 = t321 * t207;
  t862 = t183 * t860 * t188;
  t863 = params->csk_a * t97;
  t864 = t863 * t468;
  t865 = t862 * t864;
  t867 = t321 * t99;
  t869 = t95 * t867 * t188;
  t870 = t863 * t207;
  t871 = t103 * t870;
  t872 = t869 * t871;
  t874 = t863 * t99;
  t875 = t193 * t874;
  t876 = t862 * t875;
  t878 = t429 * t827;
  t880 = t97 * t67 * t102;
  t881 = t581 * t880;
  t883 = t825 * t251;
  t884 = 0.2e1 * t249 * t857 + 0.2e1 * t263 * t671 - 0.2e1 * t828 * t829 - 0.3e1 * t832 * t834 - t840 * t842 - t878 * t881 - t330 - t332 + t826 + t846 - t849 - t856 - 0.3e1 * t865 + 0.3e1 * t872 - 0.3e1 * t876 + t883;
  t885 = t183 * t824;
  t886 = t885 * t251;
  t887 = t485 * t880;
  t892 = t216 * t254;
  t893 = t215 * t892;
  t896 = t538 * t97;
  t897 = t523 * t896;
  t901 = t198 * t199 * t254;
  t904 = t528 * t97;
  t905 = t507 * t904;
  t908 = t885 * t266;
  t909 = t95 * t860;
  t911 = t198 * t260 * t99;
  t912 = t909 * t911;
  t918 = t183 * t867;
  t919 = t833 * t207;
  t920 = t215 * t919;
  t921 = t918 * t920;
  t923 = t524 * t97;
  t924 = t523 * t923;
  t927 = t507 * t265;
  t933 = 0.2e1 * t249 * t901 - 0.2e1 * t263 * t893 - 0.2e1 * t263 * t901 - t828 * t881 - 0.3e1 * t828 * t887 + 0.3e1 * t832 * t881 + 0.3e1 * t832 * t887 + 0.3e1 * t832 * t905 - 0.2e1 * t878 * t897 - 0.3e1 * t878 * t905 + 0.3e1 * t878 * t924 + 0.3e1 * t878 * t927 - t886 - t908 + 0.3e1 * t912 + 0.3e1 * t921;
  t935 = my_piecewise5(t57, 0, t60, 0, t884 + t933);
  t937 = 0.2e1 * t123 * t269 + 0.2e1 * t239 * t129 + t93 * t338 + t52 * t935;
  t942 = my_piecewise3(t3, 0, t8 * t78 * t340 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t937);
  tv3rhosigma20 = 0.2e1 * rho[0] * t942 + 0.2e1 * t344;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t957 = t354 * t207;
  t958 = t183 * t957;
  t960 = t466 * t97 * t468;
  t961 = t958 * t960;
  t963 = t103 * params->csk_a;
  t964 = t257 * t207;
  t965 = t963 * t964;
  t966 = t799 * t965;
  t968 = t215 * t192;
  t969 = t968 * t874;
  t970 = t958 * t969;
  t974 = t298 * t126;
  t976 = t95 * t974 * t209;
  t977 = t145 * t254;
  t979 = t95 * t977 * t209;
  t982 = t723 * t434;
  t983 = t95 * t982;
  t984 = params->csk_a * t126;
  t985 = t984 * t97;
  t986 = t103 * t985;
  t989 = t429 * t982;
  t990 = t512 * t126;
  t991 = t193 * t97;
  t992 = t990 * t991;
  t995 = t990 * t97;
  t996 = t439 * t995;
  t999 = t183 * t646;
  t1000 = t301 * t207;
  t1001 = t193 * t1000;
  t1002 = t999 * t1001;
  t1004 = t579 * t434;
  t1005 = t429 * t1004;
  t1006 = t145 * params->csk_a;
  t1007 = t1006 * t97;
  t1008 = t439 * t1007;
  t1011 = 0.3e1 * t1005 * t1008 + t263 * t766 + t609 * t290 + t293 * t857 + t760 * t358 - 0.3e1 * t983 * t986 - 0.3e1 * t989 * t992 - 0.2e1 * t989 * t996 + 0.3e1 * t1002 - t330 - t356 + t826 + t846 - t849 - 0.3e1 * t961 + 0.3e1 * t966 - 0.3e1 * t970 - t976 - t979;
  t1012 = t183 * t982;
  t1015 = t95 * t957;
  t1016 = t1015 * t911;
  t1018 = t193 * t1007;
  t1021 = t103 * t995;
  t1029 = t507 * t289 * t97;
  t1032 = t357 * t97;
  t1033 = t511 * t1032;
  t1040 = t596 * t145;
  t1041 = t523 * t1040;
  t1045 = 0.3e1 * t1005 * t1018 + 0.3e1 * t1012 * t1021 + 0.3e1 * t1012 * t986 + 0.3e1 * t1012 * t992 - t983 * t1021 - t989 * t1021 - 0.3e1 * t606 * t1029 - 0.2e1 * t731 * t1033 - t840 * t1041 + t293 * t901 - t305 * t893 - t305 * t901 - t728 * t352 + t760 * t352 - t728 * t362 + 0.3e1 * t1016 + t883 - t886 - t908;
  t1047 = my_piecewise5(t57, 0, t60, 0, t1011 + t1045);
  t1049 = -0.5e1 / 0.72e2 * t45 * t116 * t129 + t45 * t137 * t269 / 0.24e2 + t239 * t148 + t123 * t309 + t93 * t365 + t52 * t1047;
  t1054 = my_piecewise3(t3, 0, t8 * t78 * t367 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1049);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t1054 + 0.2e1 * t371;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1067 = t102 * t298;
  t1071 = t145 * t207;
  t1072 = t95 * t1071;
  t1074 = t1072 * t852 * t1067;
  t1075 = 0.2e1 * t1074;
  t1078 = t438 * t376;
  t1079 = t523 * t1078;
  t1081 = t376 * t432;
  t1082 = t183 * t1081;
  t1085 = t95 * t1081;
  t1088 = t376 * t207;
  t1090 = t183 * t1088 * t188;
  t1091 = t1090 * t864;
  t1093 = t376 * t99;
  t1095 = t95 * t1093 * t188;
  t1096 = t1095 * t871;
  t1098 = t1090 * t875;
  t1100 = t183 * t1093;
  t1101 = t1100 * t920;
  t1103 = t429 * t1081;
  t1106 = 0.2e1 * t293 * t198 * t1067 - t840 * t1079 - 0.3e1 * t1082 * t834 - 0.2e1 * t1085 * t829 + 0.3e1 * t1103 * t924 + 0.2e1 * t305 * t766 - t1075 - 0.3e1 * t1091 + 0.3e1 * t1096 - 0.3e1 * t1098 + 0.3e1 * t1101 - t330 - t383 + t826 + t846 - t849;
  t1107 = t199 * t298;
  t1108 = t198 * t1107;
  t1113 = t95 * t1088;
  t1114 = t1113 * t911;
  t1120 = t216 * t298;
  t1136 = -0.2e1 * t305 * t215 * t1120 + 0.3e1 * t1082 * t881 + 0.3e1 * t1082 * t887 + 0.3e1 * t1082 * t905 - t1085 * t881 - 0.3e1 * t1085 * t887 - t1103 * t881 - 0.2e1 * t1103 * t897 - 0.3e1 * t1103 * t905 + 0.3e1 * t1103 * t927 + 0.2e1 * t293 * t1108 - 0.2e1 * t305 * t1108 + 0.3e1 * t1114 + t883 - t886 - t908;
  t1138 = my_piecewise5(t57, 0, t60, 0, t1106 + t1136);
  t1140 = -0.5e1 / 0.36e2 * t45 * t116 * t148 + t45 * t137 * t309 / 0.12e2 + t93 * t389 + t52 * t1138;
  t1145 = my_piecewise3(t3, 0, t8 * t78 * t391 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1140);
  tv3rholapl20 = 0.2e1 * rho[0] * t1145 + 0.2e1 * t395;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1150 = t825 * t358;
  t1151 = 0.3e1 * t1150;
  t1152 = t321 * t126;
  t1153 = t1152 * t207;
  t1154 = t95 * t1153;
  t1155 = t1154 * t503;
  t1156 = 0.3e1 * t1155;
  t1157 = t1152 * t99;
  t1159 = t183 * t1157 * t495;
  t1160 = 0.3e1 * t1159;
  t1161 = t1152 * t432;
  t1162 = t429 * t1161;
  t1165 = t328 * t126;
  t1167 = t95 * t1165 * t209;
  t1168 = 0.3e1 * t1167;
  t1171 = t263 * t845;
  t1172 = 0.3e1 * t1171;
  t1175 = t183 * t1161;
  t1180 = t95 * t1161;
  t1182 = 0.3e1 * t1162 * t508 + 0.3e1 * t1162 * t525 - 0.3e1 * t1162 * t529 - 0.2e1 * t1162 * t539 + 0.3e1 * t1175 * t529 - t1180 * t514 + t1151 + t1156 + t1160 - t1168 + t1172 - t330 - t332;
  t1198 = t885 * t352;
  t1199 = 0.3e1 * t1198;
  t1200 = t183 * t1153;
  t1201 = t1200 * t469;
  t1202 = 0.3e1 * t1201;
  t1204 = t95 * t1157 * t475;
  t1205 = 0.3e1 * t1204;
  t1206 = t885 * t362;
  t1207 = 0.3e1 * t1206;
  t1208 = t1200 * t461;
  t1209 = 0.3e1 * t1208;
  t1211 = t198 * t199 * t328;
  t1212 = t249 * t1211;
  t1213 = 0.3e1 * t1212;
  t1214 = -0.3e1 * t183 * t1152 * t447 - t429 * t1152 * t440 - 0.2e1 * t95 * t1152 * t451 - t1162 * t514 + 0.3e1 * t1175 * t486 + 0.3e1 * t1175 * t514 - 0.3e1 * t1180 * t486 - t1199 - t1202 + t1205 - t1207 - t1209 + t1213;
  t1216 = my_piecewise5(t57, 0, t60, 0, t1182 + t1214);
  t1218 = t52 * t1216 + 0.3e1 * t123 * t338;
  t1222 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1218);
  tv3sigma30 = 0.2e1 * rho[0] * t1222;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1229 = 0.2e1 * t1150;
  t1230 = 0.2e1 * t1167;
  t1231 = 0.2e1 * t1171;
  t1232 = t102 * t328;
  t1233 = t198 * t1232;
  t1234 = t293 * t1233;
  t1235 = t885 * t290;
  t1239 = t95 * t145 * t328 * t209;
  t1240 = t102 * t321;
  t1241 = t511 * t1240;
  t1246 = t145 * t321;
  t1247 = t1246 * t207;
  t1248 = t183 * t1247;
  t1249 = t1248 * t469;
  t1250 = 0.3e1 * t1249;
  t1251 = params->csk_a * t321;
  t1252 = t1251 * t207;
  t1253 = t103 * t1252;
  t1254 = t799 * t1253;
  t1255 = 0.3e1 * t1254;
  t1256 = t1248 * t461;
  t1257 = 0.3e1 * t1256;
  t1260 = t485 * t321 * t67 * t102;
  t1265 = -0.2e1 * t731 * t1241 + 0.3e1 * t724 * t1260 - 0.3e1 * t731 * t1260 - 0.3e1 * t832 * t757 - t878 * t770 + t1229 - t1230 + t1231 + t1234 + t1235 - t1239 - t1250 + t1255 - t1257 - t330 - t356;
  t1266 = t95 * t1246;
  t1267 = t1266 * t625;
  t1268 = 0.3e1 * t1267;
  t1269 = t918 * t735;
  t1270 = 0.3e1 * t1269;
  t1273 = t513 * t321;
  t1274 = t511 * t1273;
  t1279 = 0.2e1 * t1198;
  t1281 = t321 * t190 * t192;
  t1282 = t581 * t1281;
  t1285 = t216 * t328;
  t1286 = t215 * t1285;
  t1287 = t305 * t1286;
  t1288 = t538 * t321;
  t1289 = t523 * t1288;
  t1292 = t293 * t1211;
  t1295 = t305 * t1211;
  t1298 = 0.2e1 * t1206;
  t1299 = 0.2e1 * t1212;
  t1300 = 0.3e1 * t724 * t1274 - t731 * t1274 - t749 * t1274 + 0.3e1 * t724 * t1282 - 0.3e1 * t749 * t1282 - 0.2e1 * t749 * t1289 + 0.3e1 * t878 * t743 + 0.3e1 * t878 * t787 + t1268 + t1270 - t1279 - t1287 + t1292 - t1295 - t1298 + t1299;
  t1302 = my_piecewise5(t57, 0, t60, 0, t1265 + t1300);
  t1304 = t45 * t137 * t338 / 0.24e2 + 0.2e1 * t123 * t365 + t52 * t1302;
  t1308 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1304);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1308;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1314 = 0.2e1 * t1234;
  t1315 = 0.2e1 * t1235;
  t1316 = 0.2e1 * t1239;
  t1323 = t984 * t99;
  t1325 = t1090 * t193 * t1323;
  t1326 = 0.3e1 * t1325;
  t1328 = t1090 * t984 * t468;
  t1329 = 0.3e1 * t1328;
  t1330 = t984 * t207;
  t1331 = t103 * t1330;
  t1332 = t1095 * t1331;
  t1333 = 0.3e1 * t1332;
  t1336 = t1113 * t198 * t357 * t99;
  t1337 = 0.3e1 * t1336;
  t1340 = -0.2e1 * t1085 * t511 * t357 - t580 * t1079 - 0.3e1 * t1082 * t664 + 0.3e1 * t1103 * t634 + t1150 - t1167 + t1171 + t1314 + t1315 - t1316 - t1326 - t1329 + t1333 + t1337 - t330 - t383;
  t1341 = t513 * t126;
  t1342 = t511 * t1341;
  t1348 = t126 * t67 * t102;
  t1349 = t485 * t1348;
  t1354 = t193 * t126;
  t1355 = t581 * t1354;
  t1358 = t538 * t126;
  t1362 = t1100 * t631;
  t1363 = 0.3e1 * t1362;
  t1368 = 0.2e1 * t1287;
  t1369 = 0.2e1 * t1292;
  t1370 = 0.2e1 * t1295;
  t1371 = -0.2e1 * t1103 * t523 * t1358 + 0.3e1 * t1082 * t1342 + 0.3e1 * t1082 * t1349 + 0.3e1 * t1082 * t1355 - t1085 * t1342 - 0.3e1 * t1085 * t1349 - t1103 * t1342 - 0.3e1 * t1103 * t1355 + 0.3e1 * t1103 * t598 - t1198 - t1206 + t1212 + t1363 - t1368 + t1369 - t1370;
  t1373 = my_piecewise5(t57, 0, t60, 0, t1340 + t1371);
  t1375 = t45 * t137 * t365 / 0.12e2 + t123 * t389 + t52 * t1373;
  t1379 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1375);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1379;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1384 = 0.3e1 * t1234;
  t1385 = 0.3e1 * t1235;
  t1386 = 0.3e1 * t1239;
  t1387 = t376 * t145;
  t1388 = t1387 * t432;
  t1389 = t95 * t1388;
  t1392 = t1387 * t207;
  t1393 = t95 * t1392;
  t1394 = t1393 * t503;
  t1395 = 0.3e1 * t1394;
  t1396 = t1387 * t99;
  t1398 = t183 * t1396 * t495;
  t1399 = 0.3e1 * t1398;
  t1400 = t429 * t1388;
  t1407 = t183 * t1388;
  t1412 = -0.3e1 * t1389 * t486 + 0.3e1 * t1400 * t508 + 0.3e1 * t1400 * t525 - 0.3e1 * t1400 * t529 - 0.2e1 * t1400 * t539 + 0.3e1 * t1407 * t529 + t1384 + t1385 - t1386 + t1395 + t1399 - t330 - t383;
  t1427 = t183 * t1392;
  t1428 = t1427 * t469;
  t1429 = 0.3e1 * t1428;
  t1431 = t95 * t1396 * t475;
  t1432 = 0.3e1 * t1431;
  t1433 = t1427 * t461;
  t1434 = 0.3e1 * t1433;
  t1435 = 0.3e1 * t1287;
  t1436 = 0.3e1 * t1292;
  t1437 = 0.3e1 * t1295;
  t1438 = -0.3e1 * t183 * t1387 * t447 - t429 * t1387 * t440 - 0.2e1 * t95 * t1387 * t451 - t1389 * t514 - t1400 * t514 + 0.3e1 * t1407 * t486 + 0.3e1 * t1407 * t514 - t1429 + t1432 - t1434 - t1435 + t1436 - t1437;
  t1440 = my_piecewise5(t57, 0, t60, 0, t1412 + t1438);
  t1442 = t45 * t137 * t389 / 0.8e1 + t52 * t1440;
  t1446 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1442);
  tv3lapl30 = 0.2e1 * rho[0] * t1446;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t39, t40, t41;
  double t44, t45, t46, t48, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t63, t64;
  double t65, t66, t67, t68, t69, t70, t72, t76;
  double tzk0;

  double t78, t82, t84, t85, t87, t93, t95, t96;
  double t97, t99, t100, t102, t103, t104, t106, t108;
  double t113, tvrho0, t116, t118, t119, t120, t123, t125;
  double t126, t129, t131, t135, tvsigma0, t137, t144, t145;
  double t148, t150, t154, tvlapl0, tvtau0;

  double t159, t166, t168, t169, t171, t177, t181, t183;
  double t184, t186, t187, t188, t189, t190, t191, t192;
  double t193, t194, t196, t198, t199, t200, t202, t203;
  double t206, t207, t209, t210, t211, t213, t215, t216;
  double t217, t220, t222, t227, tv2rho20, t233, t235, t236;
  double t239, t243, t244, t245, t246, t248, t249, t250;
  double t251, t253, t254, t257, t259, t260, t261, t263;
  double t265, t266, t269, t271, t276, tv2rhosigma0, t289, t290;
  double t292, t293, t297, t298, t301, t303, t305, t309;
  double t311, t316, tv2rholapl0, tv2rhotau0, t321, t324, t327, t328;
  double t330, t331, t332, t334, t338, t340, t344, tv2sigma20;
  double t352, t354, t355, t356, t357, t358, t361, t362;
  double t365, t367, t371, tv2sigmalapl0, tv2sigmatau0, t376, t379, t382;
  double t383, t385, t389, t391, t395, tv2lapl20, tv2lapltau0, tv2tau20;

  double t400, t412, t413, t415, t421, t429, t430, t432;
  double t434, t435, t436, t438, t439, t440, t442, t443;
  double t447, t451, t454, t455, t458, t459, t461, t462;
  double t466, t468, t469, t470, t472, t474, t475, t476;
  double t479, t480, t483, t484, t485, t486, t489, t492;
  double t494, t495, t496, t502, t503, t504, t506, t507;
  double t508, t511, t512, t513, t514, t519, t523, t524;
  double t525, t528, t529, t534, t538, t539, t542, t544;
  double t546, t551, tv3rho30, t561, t563, t564, t567, t575;
  double t576, t579, t580, t581, t583, t584, t587, t588;
  double t590, t591, t594, t595, t596, t597, t598, t601;
  double t602, t606, t609, t613, t614, t619, t622, t625;
  double t626, t628, t629, t630, t631, t632, t634, t637;
  double t638, t640, t645, t646, t647, t648, t649, t650;
  double t651, t653, t654, t655, t657, t659, t660, t663;
  double t664, t670, t671, t678, t682, t683, t684, t686;
  double t688, t690, t695, tv3rho2sigma0, t719, t720, t723, t724;
  double t727, t728, t731, t734, t735, t736, t738, t740;
  double t742, t743, t749, t751, t752, t753, t757, t760;
  double t764, t765, t766, t769, t770, t772, t774, t778;
  double t786, t787, t798, t799, t800, t802, t804, t806;
  double t808, t813, tv3rho2lapl0, tv3rho2tau0, t824, t825, t826, t827;
  double t828, t829, t832, t833, t834, t839, t840, t841;
  double t842, t844, t845, t846, t847, t849, t850, t851;
  double t852, t853, t855, t856, t857, t860, t862, t863;
  double t864, t865, t867, t869, t870, t871, t872, t874;
  double t875, t876, t878, t880, t881, t883, t884, t885;
  double t886, t887, t892, t893, t896, t897, t901, t904;
  double t905, t908, t909, t911, t912, t918, t919, t920;
  double t921, t923, t924, t927, t933, t935, t937, t942;
  double tv3rhosigma20, t957, t958, t960, t961, t963, t964, t965;
  double t966, t968, t969, t970, t974, t976, t977, t979;
  double t982, t983, t984, t985, t986, t989, t990, t991;
  double t992, t995, t996, t999, t1000, t1001, t1002, t1004;
  double t1005, t1006, t1007, t1008, t1011, t1012, t1015, t1016;
  double t1018, t1021, t1029, t1032, t1033, t1040, t1041, t1045;
  double t1047, t1049, t1054, tv3rhosigmalapl0, tv3rhosigmatau0, t1067, t1071, t1072;
  double t1074, t1075, t1078, t1079, t1081, t1082, t1085, t1088;
  double t1090, t1091, t1093, t1095, t1096, t1098, t1100, t1101;
  double t1103, t1106, t1107, t1108, t1113, t1114, t1120, t1136;
  double t1138, t1140, t1145, tv3rholapl20, tv3rholapltau0, tv3rhotau20, t1150, t1151;
  double t1152, t1153, t1154, t1155, t1156, t1157, t1159, t1160;
  double t1161, t1162, t1165, t1167, t1168, t1171, t1172, t1175;
  double t1180, t1182, t1198, t1199, t1200, t1201, t1202, t1204;
  double t1205, t1206, t1207, t1208, t1209, t1211, t1212, t1213;
  double t1214, t1216, t1218, t1222, tv3sigma30, t1229, t1230, t1231;
  double t1232, t1233, t1234, t1235, t1239, t1240, t1241, t1246;
  double t1247, t1248, t1249, t1250, t1251, t1252, t1253, t1254;
  double t1255, t1256, t1257, t1260, t1265, t1266, t1267, t1268;
  double t1269, t1270, t1273, t1274, t1279, t1281, t1282, t1285;
  double t1286, t1287, t1288, t1289, t1292, t1295, t1298, t1299;
  double t1300, t1302, t1304, t1308, tv3sigma2lapl0, tv3sigma2tau0, t1314, t1315;
  double t1316, t1323, t1325, t1326, t1328, t1329, t1330, t1331;
  double t1332, t1333, t1336, t1337, t1340, t1341, t1342, t1348;
  double t1349, t1354, t1355, t1358, t1362, t1363, t1368, t1369;
  double t1370, t1371, t1373, t1375, t1379, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20;
  double t1384, t1385, t1386, t1387, t1388, t1389, t1392, t1393;
  double t1394, t1395, t1396, t1398, t1399, t1400, t1407, t1412;
  double t1427, t1428, t1429, t1431, t1432, t1433, t1434, t1435;
  double t1436, t1437, t1438, t1440, t1442, t1446, tv3lapl30, tv3lapl2tau0;
  double tv3lapltau20, tv3tau30;

  double t1467, t1469, t1475, t1489, t1491, t1492, t1493, t1494;
  double t1495, t1496, t1497, t1498, t1499, t1500, t1501, t1502;
  double t1503, t1504, t1507, t1508, t1511, t1512, t1516, t1517;
  double t1518, t1519, t1524, t1527, t1532, t1533, t1536, t1539;
  double t1544, t1548, t1549, t1552, t1562, t1566, t1568, t1569;
  double t1572, t1573, t1574, t1579, t1580, t1586, t1589, t1590;
  double t1591, t1595, t1596, t1597, t1603, t1604, t1605, t1608;
  double t1609, t1614, t1615, t1616, t1625, t1626, t1629, t1634;
  double t1643, t1648, t1649, t1653, t1654, t1655, t1657, t1658;
  double t1662, t1663, t1666, t1667, t1670, t1674, t1680, t1682;
  double t1685, t1690, t1692, t1695, t1697, t1698, t1701, t1706;
  double t1708, t1711, t1714, t1715, t1719, t1722, t1724, t1729;
  double t1733, t1739, t1742, t1745, t1747, t1751, t1755, t1759;
  double t1763, t1764, t1767, t1771, t1776, t1783, t1786, t1790;
  double t1797, tv4rho40, t1812, t1816, t1833, t1836, t1842, t1843;
  double t1844, t1849, t1850, t1853, t1854, t1857, t1858, t1859;
  double t1860, t1871, t1874, t1881, t1882, t1885, t1889, t1892;
  double t1893, t1901, t1902, t1903, t1904, t1907, t1910, t1913;
  double t1914, t1917, t1918, t1921, t1923, t1924, t1927, t1931;
  double t1936, t1939, t1944, t1946, t1953, t1957, t1958, t1960;
  double t1961, t1964, t1967, t1970, t1973, t1976, t1979, t1982;
  double t1986, t1987, t1991, t1994, t1995, t2004, t2006, t2007;
  double t2014, t2019, t2023, t2027, t2030, t2031, t2032, t2035;
  double t2038, t2041, t2044, t2047, t2052, t2056, t2059, t2062;
  double t2066, t2072, t2077, t2083, t2092, t2102, t2106, t2109;
  double t2113, t2116, t2118, t2121, t2126, t2129, t2134, t2144;
  double t2153, t2159, t2167, t2176, t2180, t2184, t2189, t2192;
  double t2196, t2203, tv4rho3sigma0, t2238, t2241, t2243, t2248, t2250;
  double t2253, t2254, t2257, t2258, t2259, t2263, t2268, t2271;
  double t2278, t2283, t2284, t2289, t2290, t2293, t2294, t2299;
  double t2300, t2307, t2313, t2316, t2324, t2325, t2328, t2329;
  double t2332, t2339, t2342, t2347, t2348, t2355, t2356, t2361;
  double t2362, t2376, t2381, t2384, t2389, t2397, t2400, t2405;
  double t2408, t2413, t2423, t2425, t2432, t2435, t2442, t2447;
  double t2458, t2464, t2470, t2474, t2477, t2481, t2494, t2497;
  double t2499, t2503, t2530, t2534, t2541, tv4rho3lapl0, tv4rho3tau0, t2560;
  double t2561, t2562, t2566, t2571, t2572, t2575, t2576, t2577;
  double t2579, t2583, t2584, t2587, t2588, t2589, t2591, t2592;
  double t2594, t2596, t2599, t2602, t2607, t2611, t2612, t2615;
  double t2616, t2617, t2618, t2619, t2622, t2625, t2628, t2631;
  double t2643, t2659, t2665, t2670, t2672, t2673, t2675, t2678;
  double t2679, t2680, t2681, t2684, t2685, t2688, t2689, t2691;
  double t2692, t2694, t2695, t2698, t2701, t2705, t2708, t2715;
  double t2716, t2718, t2722, t2726, t2729, t2731, t2733, t2736;
  double t2742, t2744, t2747, t2748, t2750, t2762, t2766, t2769;
  double t2772, t2778, t2782, t2787, t2788, t2789, t2791, t2793;
  double t2798, t2799, t2800, t2801, t2805, t2810, t2819, t2822;
  double t2842, t2844, t2846, t2848, t2851, t2852, t2856, t2864;
  double t2866, t2867, t2869, t2870, t2871, t2872, t2874, t2876;
  double t2877, t2878, t2885, t2887, t2890, t2898, t2902, t2905;
  double t2906, t2908, t2909, t2912, t2917, t2921, t2927, t2928;
  double t2929, t2932, t2933, t2944, t2945, t2946, t2949, t2953;
  double t2960, tv4rho2sigma20, t2986, t2987, t2990, t2991, t2996, t3000;
  double t3007, t3011, t3022, t3030, t3041, t3044, t3045, t3046;
  double t3047, t3050, t3051, t3052, t3057, t3058, t3059, t3062;
  double t3065, t3066, t3069, t3072, t3082, t3083, t3084, t3088;
  double t3089, t3092, t3100, t3104, t3107, t3126, t3131, t3134;
  double t3147, t3153, t3163, t3166, t3172, t3199, t3214, t3217;
  double t3221, t3222, t3232, t3250, t3262, t3263, t3276, t3301;
  double t3305, t3328, t3332, t3336, t3343, tv4rho2sigmalapl0, tv4rho2sigmatau0, t3365;
  double t3366, t3371, t3374, t3377, t3378, t3383, t3384, t3385;
  double t3390, t3393, t3407, t3408, t3409, t3437, t3438, t3443;
  double t3445, t3447, t3449, t3453, t3458, t3464, t3465, t3468;
  double t3491, t3492, t3502, t3513, t3530, t3535, t3556, t3558;
  double t3570, t3573, t3575, t3577, t3578, t3589, t3590, t3603;
  double t3604, t3612, t3620, t3630, t3634, t3635, t3643, t3647;
  double t3654, tv4rho2lapl20, tv4rho2lapltau0, tv4rho2tau20, t3665, t3666, t3667, t3669;
  double t3670, t3671, t3672, t3673, t3676, t3677, t3679, t3681;
  double t3683, t3684, t3686, t3689, t3690, t3691, t3692, t3695;
  double t3696, t3697, t3698, t3700, t3702, t3704, t3705, t3709;
  double t3711, t3712, t3716, t3717, t3722, t3726, t3730, t3731;
  double t3739, t3740, t3741, t3745, t3748, t3750, t3753, t3757;
  double t3759, t3760, t3761, t3764, t3766, t3770, t3774, t3777;
  double t3782, t3783, t3786, t3789, t3794, t3798, t3805, t3808;
  double t3812, t3815, t3816, t3819, t3826, t3835, t3838, t3841;
  double t3846, t3848, t3850, t3853, t3857, t3864, t3865, t3866;
  double t3872, t3882, t3887, t3889, t3894, t3902, t3910, t3914;
  double t3916, t3917, t3919, t3920, t3922, t3923, t3924, t3927;
  double t3929, t3935, t3941, t3943, t3947, t3949, t3952, t3961;
  double t3964, t3968, t3975, tv4rhosigma30, t3992, t3993, t3996, t3997;
  double t4000, t4001, t4002, t4005, t4006, t4015, t4016, t4018;
  double t4027, t4029, t4033, t4034, t4036, t4037, t4044, t4045;
  double t4046, t4054, t4057, t4059, t4062, t4066, t4067, t4072;
  double t4080, t4082, t4089, t4090, t4091, t4098, t4100, t4101;
  double t4104, t4110, t4136, t4137, t4141, t4148, t4154, t4161;
  double t4181, t4200, t4205, t4206, t4209, t4210, t4218, t4221;
  double t4224, t4225, t4252, t4261, t4263, t4266, t4268, t4270;
  double t4271, t4275, t4278, t4290, t4312, t4320, t4328, t4333;
  double t4334, t4335, t4340, t4347, tv4rhosigma2lapl0, tv4rhosigma2tau0, t4362, t4363;
  double t4365, t4366, t4369, t4370, t4373, t4376, t4381, t4386;
  double t4391, t4392, t4406, t4407, t4411, t4416, t4417, t4424;
  double t4440, t4443, t4444, t4452, t4456, t4478, t4482, t4515;
  double t4546, t4590, t4592, t4599, t4606, t4608, t4635, t4645;
  double t4650, t4657, tv4rhosigmalapl20, tv4rhosigmalapltau0, tv4rhosigmatau20, t4670, t4671, t4674;
  double t4677, t4678, t4679, t4682, t4685, t4693, t4709, t4725;
  double t4726, t4729, t4735, t4738, t4744, t4760, t4762, t4765;
  double t4768, t4772, t4777, t4778, t4787, t4788, t4801, t4809;
  double t4814, t4820, t4831, t4840, t4842, t4850, t4856, t4857;
  double t4862, t4866, t4871, t4884, t4889, t4893, t4900, tv4rholapl30;
  double tv4rholapl2tau0, tv4rholapltau20, tv4rhotau30, t4905, t4906, t4909, t4910, t4915;
  double t4917, t4919, t4920, t4921, t4924, t4925, t4929, t4930;
  double t4932, t4935, t4937, t4939, t4941, t4946, t4948, t4951;
  double t4953, t4959, t4961, t4963, t4968, t4975, t4983, t4991;
  double t4992, t4994, t4997, t4999, t5000, t5008, t5016, t5017;
  double t5023, t5024, t5027, t5033, t5040, t5044, t5047, t5057;
  double t5065, t5071, t5072, t5074, t5077, t5079, t5103, t5107;
  double t5113, tv4sigma40, t5120, t5121, t5122, t5123, t5124, t5125;
  double t5126, t5127, t5128, t5129, t5130, t5131, t5132, t5133;
  double t5139, t5140, t5144, t5145, t5146, t5150, t5156, t5157;
  double t5158, t5164, t5165, t5167, t5168, t5169, t5170, t5171;
  double t5172, t5173, t5174, t5176, t5177, t5188, t5191, t5194;
  double t5203, t5211, t5224, t5227, t5231, t5236, t5255, t5267;
  double t5268, t5269, t5270, t5279, t5280, t5287, t5294, t5295;
  double t5296, t5297, t5298, t5299, t5301, t5302, t5308, t5325;
  double t5329, t5335, tv4sigma3lapl0, tv4sigma3tau0, t5343, t5350, t5353, t5359;
  double t5367, t5373, t5376, t5380, t5395, t5397, t5402, t5410;
  double t5420, t5427, t5434, t5437, t5457, t5458, t5460, t5462;
  double t5464, t5465, t5467, t5469, t5470, t5474, t5478, t5483;
  double t5493, t5500, t5504, t5514, t5524, t5534, t5537, t5539;
  double t5544, t5557, t5561, t5567, tv4sigma2lapl20, tv4sigma2lapltau0, tv4sigma2tau20, t5574;
  double t5575, t5585, t5602, t5607, t5611, t5615, t5621, t5628;
  double t5639, t5642, t5653, t5677, t5696, t5698, t5700, t5717;
  double t5721, t5727, tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20, tv4sigmatau30, t5735, t5736;
  double t5737, t5740, t5744, t5747, t5750, t5770, t5786, t5789;
  double t5800, t5812, t5813, t5818, t5821, t5836, t5846, t5847;
  double t5857, t5884, t5888, t5894, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20, tv4lapltau30;
  double tv4tau40;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t39 = 0.5e1 / 0.72e2 * t30 * t37;
  t40 = params->csk_cp * t25;
  t41 = t40 * t29;
  t44 = params->csk_cq * t25;
  t45 = t44 * t29;
  t46 = lapl[0] * t32;
  t48 = 0.1e1 / t23 / rho[0];
  t52 = t41 * t37 / 0.24e2 + t45 * t46 * t48 / 0.24e2 - t39;
  t54 = log(0.1e1 - DBL_EPSILON);
  t55 = 0.1e1 / params->csk_a;
  t56 = pow(-t54, -t55);
  t57 = t52 < -t56;
  t58 = log(DBL_EPSILON);
  t59 = pow(-t58, -t55);
  t60 = -t59 < t52;
  t61 = my_piecewise3(t60, -t59, t52);
  t62 = -t56 < t61;
  t63 = my_piecewise3(t62, t61, -t56);
  t64 = fabs(t63);
  t65 = pow(t64, params->csk_a);
  t66 = 0.1e1 / t65;
  t67 = exp(-t66);
  t68 = 0.1e1 - t67;
  t69 = pow(t68, t55);
  t70 = my_piecewise5(t57, 0, t60, 1, t69);
  t72 = t52 * t70 + t39 + 0.1e1;
  t76 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t72);
  tzk0 = 0.2e1 * t76;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t78 = t21 / t22;
  t82 = t34 * rho[0];
  t84 = 0.1e1 / t23 / t82;
  t85 = t33 * t84;
  t87 = 0.5e1 / 0.27e2 * t30 * t85;
  t93 = -t41 * t85 / 0.9e1 - 0.5e1 / 0.72e2 * t45 * t46 * t36 + t87;
  t95 = t69 * t66;
  t96 = my_piecewise3(t60, 0, t93);
  t97 = my_piecewise3(t62, t96, 0);
  t99 = fabs(t63) / t63;
  t100 = 0.1e1 / t64;
  t102 = 0.1e1 / t68;
  t103 = t67 * t102;
  t104 = t99 * t100 * t103;
  t106 = my_piecewise5(t57, 0, t60, 0, -t95 * t97 * t104);
  t108 = t52 * t106 + t93 * t70 - t87;
  t113 = my_piecewise3(t3, 0, t8 * t78 * t72 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t108);
  tvrho0 = 0.2e1 * rho[0] * t113 + 0.2e1 * t76;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t116 = t32 * t36;
  t118 = 0.5e1 / 0.72e2 * t30 * t116;
  t119 = t29 * t32;
  t120 = t119 * t36;
  t123 = t40 * t120 / 0.24e2 - t118;
  t125 = my_piecewise3(t60, 0, t123);
  t126 = my_piecewise3(t62, t125, 0);
  t129 = my_piecewise5(t57, 0, t60, 0, -t95 * t126 * t104);
  t131 = t123 * t70 + t52 * t129 + t118;
  t135 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t131);
  tvsigma0 = 0.2e1 * rho[0] * t135;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t137 = t32 * t48;
  t144 = my_piecewise3(t60, 0, t44 * t119 * t48 / 0.24e2);
  t145 = my_piecewise3(t62, t144, 0);
  t148 = my_piecewise5(t57, 0, t60, 0, -t95 * t145 * t104);
  t150 = t45 * t137 * t70 / 0.24e2 + t52 * t148;
  t154 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t150);
  tvlapl0 = 0.2e1 * rho[0] * t154;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t159 = t21 / t22 / rho[0];
  t166 = t34 * t34;
  t168 = 0.1e1 / t23 / t166;
  t169 = t33 * t168;
  t171 = 0.55e2 / 0.81e2 * t30 * t169;
  t177 = 0.11e2 / 0.27e2 * t41 * t169 + 0.5e1 / 0.27e2 * t45 * t46 * t84 - t171;
  t181 = t65 * t65;
  t183 = t69 / t181;
  t184 = t97 * t97;
  t186 = t99 * t99;
  t187 = t64 * t64;
  t188 = 0.1e1 / t187;
  t189 = t186 * t188;
  t190 = t67 * t67;
  t191 = t68 * t68;
  t192 = 0.1e1 / t191;
  t193 = t190 * t192;
  t194 = t189 * t193;
  t196 = t184 * t186;
  t198 = t188 * t67;
  t199 = t102 * params->csk_a;
  t200 = t198 * t199;
  t202 = my_piecewise3(t60, 0, t177);
  t203 = my_piecewise3(t62, t202, 0);
  t206 = t95 * t184;
  t207 = 0.0;
  t209 = t207 * t100 * t103;
  t210 = t206 * t209;
  t211 = t189 * t103;
  t213 = t183 * t196;
  t215 = t188 * t190;
  t216 = t192 * params->csk_a;
  t217 = t215 * t216;
  t220 = my_piecewise5(t57, 0, t60, 0, -t95 * t203 * t104 + t183 * t184 * t194 + t95 * t196 * t200 - t213 * t200 + t206 * t211 - t213 * t217 - t210);
  t222 = 0.2e1 * t93 * t106 + t177 * t70 + t52 * t220 + t171;
  t227 = my_piecewise3(t3, 0, -t8 * t159 * t72 / 0.3e2 + t8 * t78 * t108 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t222);
  tv2rho20 = 0.2e1 * rho[0] * t227 + 0.4e1 * t113;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t233 = t32 * t84;
  t235 = 0.5e1 / 0.27e2 * t30 * t233;
  t236 = t119 * t84;
  t239 = -t40 * t236 / 0.9e1 + t235;
  t243 = t97 * t186;
  t244 = t183 * t243;
  t245 = t192 * t126;
  t246 = t215 * t245;
  t248 = t126 * t186;
  t249 = t95 * t248;
  t250 = t199 * t97;
  t251 = t198 * t250;
  t253 = my_piecewise3(t60, 0, t239);
  t254 = my_piecewise3(t62, t253, 0);
  t257 = t126 * t97;
  t259 = t95 * t257 * t209;
  t260 = t102 * t97;
  t261 = t198 * t260;
  t263 = t183 * t248;
  t265 = t216 * t97;
  t266 = t215 * t265;
  t269 = my_piecewise5(t57, 0, t60, 0, -t95 * t254 * t104 + t244 * t246 + t249 * t251 + t249 * t261 - t263 * t251 - t263 * t266 - t259);
  t271 = t123 * t106 + t93 * t129 + t239 * t70 + t52 * t269 - t235;
  t276 = my_piecewise3(t3, 0, t8 * t78 * t131 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t271);
  tv2rhosigma0 = 0.2e1 * rho[0] * t276 + 0.2e1 * t135;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t289 = t192 * t145;
  t290 = t215 * t289;
  t292 = t145 * t186;
  t293 = t95 * t292;
  t297 = my_piecewise3(t60, 0, -0.5e1 / 0.72e2 * t44 * t120);
  t298 = my_piecewise3(t62, t297, 0);
  t301 = t145 * t97;
  t303 = t95 * t301 * t209;
  t305 = t183 * t292;
  t309 = my_piecewise5(t57, 0, t60, 0, -t95 * t298 * t104 + t244 * t290 + t293 * t251 - t305 * t251 + t293 * t261 - t305 * t266 - t303);
  t311 = -0.5e1 / 0.72e2 * t45 * t116 * t70 + t45 * t137 * t106 / 0.24e2 + t93 * t148 + t52 * t309;
  t316 = my_piecewise3(t3, 0, t8 * t78 * t150 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t311);
  tv2rholapl0 = 0.2e1 * rho[0] * t316 + 0.2e1 * t154;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t321 = t126 * t126;
  t324 = t321 * t186;
  t327 = my_piecewise3(t60, 0, 0);
  t328 = my_piecewise3(t62, t327, 0);
  t330 = t95 * t328 * t104;
  t331 = t95 * t321;
  t332 = t331 * t209;
  t334 = t183 * t324;
  t338 = my_piecewise5(t57, 0, t60, 0, t183 * t321 * t194 + t95 * t324 * t200 - t334 * t200 + t331 * t211 - t334 * t217 - t330 - t332);
  t340 = 0.2e1 * t123 * t129 + t52 * t338;
  t344 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t340);
  tv2sigma20 = 0.2e1 * rho[0] * t344;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t352 = t198 * t199 * t126;
  t354 = t145 * t126;
  t355 = t95 * t354;
  t356 = t355 * t209;
  t357 = t102 * t126;
  t358 = t198 * t357;
  t361 = t216 * t126;
  t362 = t215 * t361;
  t365 = my_piecewise5(t57, 0, t60, 0, t263 * t290 + t293 * t352 + t293 * t358 - t305 * t352 - t305 * t362 - t330 - t356);
  t367 = t45 * t137 * t129 / 0.24e2 + t123 * t148 + t52 * t365;
  t371 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t367);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t371;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t376 = t145 * t145;
  t379 = t376 * t186;
  t382 = t95 * t376;
  t383 = t382 * t209;
  t385 = t183 * t379;
  t389 = my_piecewise5(t57, 0, t60, 0, t183 * t376 * t194 + t95 * t379 * t200 - t385 * t200 + t382 * t211 - t385 * t217 - t330 - t383);
  t391 = t45 * t137 * t148 / 0.12e2 + t52 * t389;
  t395 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t391);
  tv2lapl20 = 0.2e1 * rho[0] * t395;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t400 = t21 / t22 / t34;
  t412 = 0.1e1 / t23 / t166 / rho[0];
  t413 = t33 * t412;
  t415 = 0.77e3 / 0.243e3 * t30 * t413;
  t421 = -0.154e3 / 0.81e2 * t41 * t413 - 0.55e2 / 0.81e2 * t45 * t46 * t168 + t415;
  t429 = t69 / t181 / t65;
  t430 = t184 * t97;
  t432 = t186 * t99;
  t434 = 0.1e1 / t187 / t64;
  t435 = t432 * t434;
  t436 = t190 * t67;
  t438 = 0.1e1 / t191 / t68;
  t439 = t436 * t438;
  t440 = t435 * t439;
  t442 = my_piecewise3(t60, 0, t421);
  t443 = my_piecewise3(t62, t442, 0);
  t447 = t435 * t193;
  t451 = t435 * t103;
  t454 = t203 * t186;
  t455 = t183 * t454;
  t458 = t430 * t207;
  t459 = t183 * t458;
  t461 = t215 * t216 * t99;
  t462 = t459 * t461;
  t466 = t188 * params->csk_a;
  t468 = t99 * t67 * t102;
  t469 = t466 * t468;
  t470 = t459 * t469;
  t472 = t430 * t99;
  t474 = t199 * t207;
  t475 = t198 * t474;
  t476 = t95 * t472 * t475;
  t479 = t199 * t203;
  t480 = t198 * t479;
  t483 = t430 * t432;
  t484 = t183 * t483;
  t485 = t434 * params->csk_a;
  t486 = t485 * t103;
  t489 = t95 * t483;
  t492 = -t95 * t443 * t104 - 0.3e1 * t183 * t430 * t447 + 0.3e1 * t95 * t243 * t480 - t429 * t430 * t440 - 0.2e1 * t95 * t430 * t451 - 0.3e1 * t455 * t251 - 0.3e1 * t455 * t266 + 0.3e1 * t484 * t486 - 0.3e1 * t489 * t486 - t210 - 0.3e1 * t462 - 0.3e1 * t470 + 0.3e1 * t476;
  t494 = t192 * t207;
  t495 = t215 * t494;
  t496 = t183 * t472 * t495;
  t502 = t102 * t99;
  t503 = t198 * t502;
  t504 = t95 * t458 * t503;
  t506 = t429 * t483;
  t507 = t434 * t190;
  t508 = t507 * t216;
  t511 = t434 * t67;
  t512 = params->csk_a * params->csk_a;
  t513 = t102 * t512;
  t514 = t511 * t513;
  t519 = t192 * t203;
  t523 = t434 * t436;
  t524 = t438 * params->csk_a;
  t525 = t523 * t524;
  t528 = t192 * t512;
  t529 = t507 * t528;
  t534 = t95 * t203 * t97 * t209;
  t538 = t438 * t512;
  t539 = t523 * t538;
  t542 = 0.3e1 * t244 * t215 * t519 + 0.3e1 * t95 * t454 * t261 + 0.3e1 * t484 * t514 + 0.3e1 * t484 * t529 - t489 * t514 + 0.3e1 * t506 * t508 - t506 * t514 + 0.3e1 * t506 * t525 - 0.3e1 * t506 * t529 - 0.2e1 * t506 * t539 + 0.3e1 * t496 + 0.3e1 * t504 - 0.3e1 * t534;
  t544 = my_piecewise5(t57, 0, t60, 0, t492 + t542);
  t546 = 0.3e1 * t177 * t106 + 0.3e1 * t93 * t220 + t421 * t70 + t52 * t544 - t415;
  t551 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t400 * t72 - t8 * t159 * t108 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t78 * t222 + 0.3e1 / 0.2e2 * t8 * t24 * t546);
  tv3rho30 = 0.2e1 * rho[0] * t551 + 0.6e1 * t227;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t561 = t32 * t168;
  t563 = 0.55e2 / 0.81e2 * t30 * t561;
  t564 = t119 * t168;
  t567 = 0.11e2 / 0.27e2 * t40 * t564 - t563;
  t575 = my_piecewise3(t60, 0, t567);
  t576 = my_piecewise3(t62, t575, 0);
  t579 = t126 * t432;
  t580 = t429 * t579;
  t581 = t434 * t512;
  t583 = t184 * t190 * t192;
  t584 = t581 * t583;
  t587 = t216 * t203;
  t588 = t215 * t587;
  t590 = t538 * t184;
  t591 = t523 * t590;
  t594 = t184 * t432;
  t595 = t429 * t594;
  t596 = t438 * t126;
  t597 = t596 * params->csk_a;
  t598 = t523 * t597;
  t601 = t254 * t186;
  t602 = t95 * t601;
  t606 = t183 * t579;
  t609 = t183 * t601;
  t613 = t184 * t67 * t102;
  t614 = t485 * t613;
  t619 = t95 * t579;
  t622 = t126 * t184;
  t625 = t207 * t188 * t468;
  t626 = t95 * t622 * t625;
  t628 = t184 * t99;
  t629 = t183 * t628;
  t630 = t245 * t207;
  t631 = t215 * t630;
  t632 = t629 * t631;
  t634 = t507 * t361;
  t637 = t513 * t184;
  t638 = t511 * t637;
  t640 = -t95 * t576 * t104 + t249 * t480 + 0.2e1 * t602 * t251 - 0.2e1 * t609 * t251 - t263 * t588 - 0.2e1 * t609 * t266 - 0.3e1 * t580 * t584 - 0.2e1 * t580 * t591 + 0.3e1 * t606 * t584 + 0.3e1 * t595 * t598 + 0.3e1 * t595 * t634 + 0.3e1 * t606 * t614 - 0.3e1 * t619 * t614 - t619 * t638 + 0.3e1 * t626 + 0.3e1 * t632;
  t645 = t126 * t99;
  t646 = t645 * t188;
  t647 = t95 * t646;
  t648 = params->csk_a * t184;
  t649 = t648 * t207;
  t650 = t103 * t649;
  t651 = t647 * t650;
  t653 = t622 * t207;
  t654 = t183 * t653;
  t655 = t654 * t461;
  t657 = t654 * t469;
  t659 = t102 * t184;
  t660 = t511 * t659;
  t663 = t183 * t594;
  t664 = t507 * t245;
  t670 = t192 * t254;
  t671 = t215 * t670;
  t678 = t95 * t254 * t97 * t209;
  t682 = t95 * t126 * t203 * t209;
  t683 = t102 * t203;
  t684 = t198 * t683;
  t686 = -t595 * t523 * t596 + 0.2e1 * t244 * t671 + t455 * t246 + t249 * t684 + 0.2e1 * t602 * t261 - t263 * t480 - t580 * t638 + 0.3e1 * t606 * t638 - 0.2e1 * t619 * t660 - 0.3e1 * t663 * t664 - t259 + 0.3e1 * t651 - 0.3e1 * t655 - 0.3e1 * t657 - 0.2e1 * t678 - t682;
  t688 = my_piecewise5(t57, 0, t60, 0, t640 + t686);
  t690 = 0.2e1 * t239 * t106 + t123 * t220 + t177 * t129 + 0.2e1 * t93 * t269 + t52 * t688 + t567 * t70 + t563;
  t695 = my_piecewise3(t3, 0, -t8 * t159 * t131 / 0.3e2 + t8 * t78 * t271 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t690);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t695 + 0.4e1 * t276;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t719 = my_piecewise3(t60, 0, 0.5e1 / 0.27e2 * t44 * t236);
  t720 = my_piecewise3(t62, t719, 0);
  t723 = t145 * t432;
  t724 = t183 * t723;
  t727 = t298 * t186;
  t728 = t183 * t727;
  t731 = t95 * t723;
  t734 = t289 * t207;
  t735 = t215 * t734;
  t736 = t629 * t735;
  t738 = t145 * t184;
  t740 = t95 * t738 * t625;
  t742 = t289 * params->csk_a;
  t743 = t507 * t742;
  t749 = t429 * t723;
  t751 = t738 * t207;
  t752 = t183 * t751;
  t753 = t752 * t469;
  t757 = t507 * t289;
  t760 = t95 * t727;
  t764 = -t95 * t720 * t104 - 0.2e1 * t728 * t251 + 0.2e1 * t760 * t261 + t455 * t290 + 0.3e1 * t595 * t743 + 0.3e1 * t724 * t614 - 0.3e1 * t731 * t614 + 0.3e1 * t724 * t638 - t731 * t638 - t749 * t638 - 0.2e1 * t731 * t660 - 0.3e1 * t663 * t757 - t303 + 0.3e1 * t736 + 0.3e1 * t740 - 0.3e1 * t753;
  t765 = t192 * t298;
  t766 = t215 * t765;
  t769 = t438 * t145;
  t770 = t523 * t769;
  t772 = t298 * t97;
  t774 = t95 * t772 * t209;
  t778 = t95 * t145 * t203 * t209;
  t786 = t769 * params->csk_a;
  t787 = t523 * t786;
  t798 = t145 * t99 * t188;
  t799 = t95 * t798;
  t800 = t799 * t650;
  t802 = t752 * t461;
  t804 = 0.2e1 * t244 * t766 + 0.2e1 * t760 * t251 - 0.2e1 * t728 * t266 + t293 * t480 + t293 * t684 - t305 * t480 - t305 * t588 + 0.3e1 * t724 * t584 - 0.3e1 * t749 * t584 - 0.2e1 * t749 * t591 - t595 * t770 + 0.3e1 * t595 * t787 - 0.2e1 * t774 - t778 + 0.3e1 * t800 - 0.3e1 * t802;
  t806 = my_piecewise5(t57, 0, t60, 0, t764 + t804);
  t808 = 0.5e1 / 0.27e2 * t45 * t233 * t70 - 0.5e1 / 0.36e2 * t45 * t116 * t106 + t45 * t137 * t220 / 0.24e2 + t177 * t148 + 0.2e1 * t93 * t309 + t52 * t806;
  t813 = my_piecewise3(t3, 0, -t8 * t159 * t150 / 0.3e2 + t8 * t78 * t311 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t808);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t813 + 0.4e1 * t316;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t824 = t328 * t186;
  t825 = t95 * t824;
  t826 = t825 * t261;
  t827 = t321 * t432;
  t828 = t95 * t827;
  t829 = t511 * t260;
  t832 = t183 * t827;
  t833 = t192 * t97;
  t834 = t507 * t833;
  t839 = t97 * t432;
  t840 = t429 * t839;
  t841 = t438 * t321;
  t842 = t523 * t841;
  t844 = t192 * t328;
  t845 = t215 * t844;
  t846 = t244 * t845;
  t847 = t328 * t97;
  t849 = t95 * t847 * t209;
  t850 = t126 * t207;
  t851 = t95 * t850;
  t852 = t100 * t67;
  t853 = t102 * t254;
  t855 = t851 * t852 * t853;
  t856 = 0.2e1 * t855;
  t857 = t198 * t853;
  t860 = t321 * t207;
  t862 = t183 * t860 * t188;
  t863 = params->csk_a * t97;
  t864 = t863 * t468;
  t865 = t862 * t864;
  t867 = t321 * t99;
  t869 = t95 * t867 * t188;
  t870 = t863 * t207;
  t871 = t103 * t870;
  t872 = t869 * t871;
  t874 = t863 * t99;
  t875 = t193 * t874;
  t876 = t862 * t875;
  t878 = t429 * t827;
  t880 = t97 * t67 * t102;
  t881 = t581 * t880;
  t883 = t825 * t251;
  t884 = 0.2e1 * t249 * t857 + 0.2e1 * t263 * t671 - 0.2e1 * t828 * t829 - 0.3e1 * t832 * t834 - t840 * t842 - t878 * t881 - t330 - t332 + t826 + t846 - t849 - t856 - 0.3e1 * t865 + 0.3e1 * t872 - 0.3e1 * t876 + t883;
  t885 = t183 * t824;
  t886 = t885 * t251;
  t887 = t485 * t880;
  t892 = t216 * t254;
  t893 = t215 * t892;
  t896 = t538 * t97;
  t897 = t523 * t896;
  t901 = t198 * t199 * t254;
  t904 = t528 * t97;
  t905 = t507 * t904;
  t908 = t885 * t266;
  t909 = t95 * t860;
  t911 = t198 * t260 * t99;
  t912 = t909 * t911;
  t918 = t183 * t867;
  t919 = t833 * t207;
  t920 = t215 * t919;
  t921 = t918 * t920;
  t923 = t524 * t97;
  t924 = t523 * t923;
  t927 = t507 * t265;
  t933 = 0.2e1 * t249 * t901 - 0.2e1 * t263 * t893 - 0.2e1 * t263 * t901 - t828 * t881 - 0.3e1 * t828 * t887 + 0.3e1 * t832 * t881 + 0.3e1 * t832 * t887 + 0.3e1 * t832 * t905 - 0.2e1 * t878 * t897 - 0.3e1 * t878 * t905 + 0.3e1 * t878 * t924 + 0.3e1 * t878 * t927 - t886 - t908 + 0.3e1 * t912 + 0.3e1 * t921;
  t935 = my_piecewise5(t57, 0, t60, 0, t884 + t933);
  t937 = 0.2e1 * t123 * t269 + 0.2e1 * t239 * t129 + t93 * t338 + t52 * t935;
  t942 = my_piecewise3(t3, 0, t8 * t78 * t340 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t937);
  tv3rhosigma20 = 0.2e1 * rho[0] * t942 + 0.2e1 * t344;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t957 = t354 * t207;
  t958 = t183 * t957;
  t960 = t466 * t97 * t468;
  t961 = t958 * t960;
  t963 = t103 * params->csk_a;
  t964 = t257 * t207;
  t965 = t963 * t964;
  t966 = t799 * t965;
  t968 = t215 * t192;
  t969 = t968 * t874;
  t970 = t958 * t969;
  t974 = t298 * t126;
  t976 = t95 * t974 * t209;
  t977 = t145 * t254;
  t979 = t95 * t977 * t209;
  t982 = t723 * t434;
  t983 = t95 * t982;
  t984 = params->csk_a * t126;
  t985 = t984 * t97;
  t986 = t103 * t985;
  t989 = t429 * t982;
  t990 = t512 * t126;
  t991 = t193 * t97;
  t992 = t990 * t991;
  t995 = t990 * t97;
  t996 = t439 * t995;
  t999 = t183 * t646;
  t1000 = t301 * t207;
  t1001 = t193 * t1000;
  t1002 = t999 * t1001;
  t1004 = t579 * t434;
  t1005 = t429 * t1004;
  t1006 = t145 * params->csk_a;
  t1007 = t1006 * t97;
  t1008 = t439 * t1007;
  t1011 = 0.3e1 * t1005 * t1008 + t263 * t766 + t609 * t290 + t293 * t857 + t760 * t358 - 0.3e1 * t983 * t986 - 0.3e1 * t989 * t992 - 0.2e1 * t989 * t996 + 0.3e1 * t1002 - t330 - t356 + t826 + t846 - t849 - 0.3e1 * t961 + 0.3e1 * t966 - 0.3e1 * t970 - t976 - t979;
  t1012 = t183 * t982;
  t1015 = t95 * t957;
  t1016 = t1015 * t911;
  t1018 = t193 * t1007;
  t1021 = t103 * t995;
  t1029 = t507 * t289 * t97;
  t1032 = t357 * t97;
  t1033 = t511 * t1032;
  t1040 = t596 * t145;
  t1041 = t523 * t1040;
  t1045 = 0.3e1 * t1005 * t1018 + 0.3e1 * t1012 * t1021 + 0.3e1 * t1012 * t986 + 0.3e1 * t1012 * t992 - t983 * t1021 - t989 * t1021 - 0.3e1 * t606 * t1029 - 0.2e1 * t731 * t1033 - t840 * t1041 + t293 * t901 - t305 * t893 - t305 * t901 - t728 * t352 + t760 * t352 - t728 * t362 + 0.3e1 * t1016 + t883 - t886 - t908;
  t1047 = my_piecewise5(t57, 0, t60, 0, t1011 + t1045);
  t1049 = -0.5e1 / 0.72e2 * t45 * t116 * t129 + t45 * t137 * t269 / 0.24e2 + t239 * t148 + t123 * t309 + t93 * t365 + t52 * t1047;
  t1054 = my_piecewise3(t3, 0, t8 * t78 * t367 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1049);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t1054 + 0.2e1 * t371;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1067 = t102 * t298;
  t1071 = t145 * t207;
  t1072 = t95 * t1071;
  t1074 = t1072 * t852 * t1067;
  t1075 = 0.2e1 * t1074;
  t1078 = t438 * t376;
  t1079 = t523 * t1078;
  t1081 = t376 * t432;
  t1082 = t183 * t1081;
  t1085 = t95 * t1081;
  t1088 = t376 * t207;
  t1090 = t183 * t1088 * t188;
  t1091 = t1090 * t864;
  t1093 = t376 * t99;
  t1095 = t95 * t1093 * t188;
  t1096 = t1095 * t871;
  t1098 = t1090 * t875;
  t1100 = t183 * t1093;
  t1101 = t1100 * t920;
  t1103 = t429 * t1081;
  t1106 = 0.2e1 * t293 * t198 * t1067 - t840 * t1079 - 0.3e1 * t1082 * t834 - 0.2e1 * t1085 * t829 + 0.3e1 * t1103 * t924 + 0.2e1 * t305 * t766 - t1075 - 0.3e1 * t1091 + 0.3e1 * t1096 - 0.3e1 * t1098 + 0.3e1 * t1101 - t330 - t383 + t826 + t846 - t849;
  t1107 = t199 * t298;
  t1108 = t198 * t1107;
  t1113 = t95 * t1088;
  t1114 = t1113 * t911;
  t1120 = t216 * t298;
  t1136 = -0.2e1 * t305 * t215 * t1120 + 0.3e1 * t1082 * t881 + 0.3e1 * t1082 * t887 + 0.3e1 * t1082 * t905 - t1085 * t881 - 0.3e1 * t1085 * t887 - t1103 * t881 - 0.2e1 * t1103 * t897 - 0.3e1 * t1103 * t905 + 0.3e1 * t1103 * t927 + 0.2e1 * t293 * t1108 - 0.2e1 * t305 * t1108 + 0.3e1 * t1114 + t883 - t886 - t908;
  t1138 = my_piecewise5(t57, 0, t60, 0, t1106 + t1136);
  t1140 = -0.5e1 / 0.36e2 * t45 * t116 * t148 + t45 * t137 * t309 / 0.12e2 + t93 * t389 + t52 * t1138;
  t1145 = my_piecewise3(t3, 0, t8 * t78 * t391 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1140);
  tv3rholapl20 = 0.2e1 * rho[0] * t1145 + 0.2e1 * t395;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1150 = t825 * t358;
  t1151 = 0.3e1 * t1150;
  t1152 = t321 * t126;
  t1153 = t1152 * t207;
  t1154 = t95 * t1153;
  t1155 = t1154 * t503;
  t1156 = 0.3e1 * t1155;
  t1157 = t1152 * t99;
  t1159 = t183 * t1157 * t495;
  t1160 = 0.3e1 * t1159;
  t1161 = t1152 * t432;
  t1162 = t429 * t1161;
  t1165 = t328 * t126;
  t1167 = t95 * t1165 * t209;
  t1168 = 0.3e1 * t1167;
  t1171 = t263 * t845;
  t1172 = 0.3e1 * t1171;
  t1175 = t183 * t1161;
  t1180 = t95 * t1161;
  t1182 = 0.3e1 * t1162 * t508 + 0.3e1 * t1162 * t525 - 0.3e1 * t1162 * t529 - 0.2e1 * t1162 * t539 + 0.3e1 * t1175 * t529 - t1180 * t514 + t1151 + t1156 + t1160 - t1168 + t1172 - t330 - t332;
  t1198 = t885 * t352;
  t1199 = 0.3e1 * t1198;
  t1200 = t183 * t1153;
  t1201 = t1200 * t469;
  t1202 = 0.3e1 * t1201;
  t1204 = t95 * t1157 * t475;
  t1205 = 0.3e1 * t1204;
  t1206 = t885 * t362;
  t1207 = 0.3e1 * t1206;
  t1208 = t1200 * t461;
  t1209 = 0.3e1 * t1208;
  t1211 = t198 * t199 * t328;
  t1212 = t249 * t1211;
  t1213 = 0.3e1 * t1212;
  t1214 = -0.3e1 * t183 * t1152 * t447 - t429 * t1152 * t440 - 0.2e1 * t95 * t1152 * t451 - t1162 * t514 + 0.3e1 * t1175 * t486 + 0.3e1 * t1175 * t514 - 0.3e1 * t1180 * t486 - t1199 - t1202 + t1205 - t1207 - t1209 + t1213;
  t1216 = my_piecewise5(t57, 0, t60, 0, t1182 + t1214);
  t1218 = t52 * t1216 + 0.3e1 * t123 * t338;
  t1222 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1218);
  tv3sigma30 = 0.2e1 * rho[0] * t1222;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1229 = 0.2e1 * t1150;
  t1230 = 0.2e1 * t1167;
  t1231 = 0.2e1 * t1171;
  t1232 = t102 * t328;
  t1233 = t198 * t1232;
  t1234 = t293 * t1233;
  t1235 = t885 * t290;
  t1239 = t95 * t145 * t328 * t209;
  t1240 = t102 * t321;
  t1241 = t511 * t1240;
  t1246 = t145 * t321;
  t1247 = t1246 * t207;
  t1248 = t183 * t1247;
  t1249 = t1248 * t469;
  t1250 = 0.3e1 * t1249;
  t1251 = params->csk_a * t321;
  t1252 = t1251 * t207;
  t1253 = t103 * t1252;
  t1254 = t799 * t1253;
  t1255 = 0.3e1 * t1254;
  t1256 = t1248 * t461;
  t1257 = 0.3e1 * t1256;
  t1260 = t485 * t321 * t67 * t102;
  t1265 = -0.2e1 * t731 * t1241 + 0.3e1 * t724 * t1260 - 0.3e1 * t731 * t1260 - 0.3e1 * t832 * t757 - t878 * t770 + t1229 - t1230 + t1231 + t1234 + t1235 - t1239 - t1250 + t1255 - t1257 - t330 - t356;
  t1266 = t95 * t1246;
  t1267 = t1266 * t625;
  t1268 = 0.3e1 * t1267;
  t1269 = t918 * t735;
  t1270 = 0.3e1 * t1269;
  t1273 = t513 * t321;
  t1274 = t511 * t1273;
  t1279 = 0.2e1 * t1198;
  t1281 = t321 * t190 * t192;
  t1282 = t581 * t1281;
  t1285 = t216 * t328;
  t1286 = t215 * t1285;
  t1287 = t305 * t1286;
  t1288 = t538 * t321;
  t1289 = t523 * t1288;
  t1292 = t293 * t1211;
  t1295 = t305 * t1211;
  t1298 = 0.2e1 * t1206;
  t1299 = 0.2e1 * t1212;
  t1300 = 0.3e1 * t724 * t1274 - t731 * t1274 - t749 * t1274 + 0.3e1 * t724 * t1282 - 0.3e1 * t749 * t1282 - 0.2e1 * t749 * t1289 + 0.3e1 * t878 * t743 + 0.3e1 * t878 * t787 + t1268 + t1270 - t1279 - t1287 + t1292 - t1295 - t1298 + t1299;
  t1302 = my_piecewise5(t57, 0, t60, 0, t1265 + t1300);
  t1304 = t45 * t137 * t338 / 0.24e2 + 0.2e1 * t123 * t365 + t52 * t1302;
  t1308 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1304);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1308;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1314 = 0.2e1 * t1234;
  t1315 = 0.2e1 * t1235;
  t1316 = 0.2e1 * t1239;
  t1323 = t984 * t99;
  t1325 = t1090 * t193 * t1323;
  t1326 = 0.3e1 * t1325;
  t1328 = t1090 * t984 * t468;
  t1329 = 0.3e1 * t1328;
  t1330 = t984 * t207;
  t1331 = t103 * t1330;
  t1332 = t1095 * t1331;
  t1333 = 0.3e1 * t1332;
  t1336 = t1113 * t198 * t357 * t99;
  t1337 = 0.3e1 * t1336;
  t1340 = -0.2e1 * t1085 * t511 * t357 - t580 * t1079 - 0.3e1 * t1082 * t664 + 0.3e1 * t1103 * t634 + t1150 - t1167 + t1171 + t1314 + t1315 - t1316 - t1326 - t1329 + t1333 + t1337 - t330 - t383;
  t1341 = t513 * t126;
  t1342 = t511 * t1341;
  t1348 = t126 * t67 * t102;
  t1349 = t485 * t1348;
  t1354 = t193 * t126;
  t1355 = t581 * t1354;
  t1358 = t538 * t126;
  t1362 = t1100 * t631;
  t1363 = 0.3e1 * t1362;
  t1368 = 0.2e1 * t1287;
  t1369 = 0.2e1 * t1292;
  t1370 = 0.2e1 * t1295;
  t1371 = -0.2e1 * t1103 * t523 * t1358 + 0.3e1 * t1082 * t1342 + 0.3e1 * t1082 * t1349 + 0.3e1 * t1082 * t1355 - t1085 * t1342 - 0.3e1 * t1085 * t1349 - t1103 * t1342 - 0.3e1 * t1103 * t1355 + 0.3e1 * t1103 * t598 - t1198 - t1206 + t1212 + t1363 - t1368 + t1369 - t1370;
  t1373 = my_piecewise5(t57, 0, t60, 0, t1340 + t1371);
  t1375 = t45 * t137 * t365 / 0.12e2 + t123 * t389 + t52 * t1373;
  t1379 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1375);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1379;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1384 = 0.3e1 * t1234;
  t1385 = 0.3e1 * t1235;
  t1386 = 0.3e1 * t1239;
  t1387 = t376 * t145;
  t1388 = t1387 * t432;
  t1389 = t95 * t1388;
  t1392 = t1387 * t207;
  t1393 = t95 * t1392;
  t1394 = t1393 * t503;
  t1395 = 0.3e1 * t1394;
  t1396 = t1387 * t99;
  t1398 = t183 * t1396 * t495;
  t1399 = 0.3e1 * t1398;
  t1400 = t429 * t1388;
  t1407 = t183 * t1388;
  t1412 = -0.3e1 * t1389 * t486 + 0.3e1 * t1400 * t508 + 0.3e1 * t1400 * t525 - 0.3e1 * t1400 * t529 - 0.2e1 * t1400 * t539 + 0.3e1 * t1407 * t529 + t1384 + t1385 - t1386 + t1395 + t1399 - t330 - t383;
  t1427 = t183 * t1392;
  t1428 = t1427 * t469;
  t1429 = 0.3e1 * t1428;
  t1431 = t95 * t1396 * t475;
  t1432 = 0.3e1 * t1431;
  t1433 = t1427 * t461;
  t1434 = 0.3e1 * t1433;
  t1435 = 0.3e1 * t1287;
  t1436 = 0.3e1 * t1292;
  t1437 = 0.3e1 * t1295;
  t1438 = -0.3e1 * t183 * t1387 * t447 - t429 * t1387 * t440 - 0.2e1 * t95 * t1387 * t451 - t1389 * t514 - t1400 * t514 + 0.3e1 * t1407 * t486 + 0.3e1 * t1407 * t514 - t1429 + t1432 - t1434 - t1435 + t1436 - t1437;
  t1440 = my_piecewise5(t57, 0, t60, 0, t1412 + t1438);
  t1442 = t45 * t137 * t389 / 0.8e1 + t52 * t1440;
  t1446 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1442);
  tv3lapl30 = 0.2e1 * rho[0] * t1446;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1467 = t33 / t23 / t166 / t34;
  t1469 = 0.1309e5 / 0.729e3 * t30 * t1467;
  t1475 = 0.2618e4 / 0.243e3 * t41 * t1467 + 0.77e3 / 0.243e3 * t45 * t46 * t412 - t1469;
  t1489 = t181 * t181;
  t1491 = t69 / t1489;
  t1492 = t184 * t184;
  t1493 = t186 * t186;
  t1494 = t1492 * t1493;
  t1495 = t1491 * t1494;
  t1496 = t187 * t187;
  t1497 = 0.1e1 / t1496;
  t1498 = t190 * t190;
  t1499 = t1497 * t1498;
  t1500 = t191 * t191;
  t1501 = 0.1e1 / t1500;
  t1502 = t512 * params->csk_a;
  t1503 = t1501 * t1502;
  t1504 = t1499 * t1503;
  t1507 = t1497 * t1502;
  t1508 = t1507 * t193;
  t1511 = t1501 * t512;
  t1512 = t1499 * t1511;
  t1516 = t429 * t1494;
  t1517 = t1497 * t436;
  t1518 = t438 * t1502;
  t1519 = t1517 * t1518;
  t1524 = t1517 * t538;
  t1527 = t183 * t1494;
  t1532 = t1497 * t190;
  t1533 = t1532 * t216;
  t1536 = t1532 * t528;
  t1539 = t507 * t519;
  t1544 = t438 * t203;
  t1548 = t1501 * params->csk_a;
  t1549 = t1499 * t1548;
  t1552 = -0.6e1 * t595 * t523 * t1544 - 0.12e2 * t1495 * t1519 + 0.18e2 * t1495 * t1524 - 0.6e1 * t1495 * t1549 + 0.18e2 * t1516 * t1508 - 0.7e1 * t1527 * t1508 + 0.12e2 * t1516 * t1519 - 0.18e2 * t1516 * t1533 + 0.7e1 * t1527 * t1533 - 0.11e2 * t1527 * t1536 - 0.18e2 * t663 * t1539;
  t1562 = t203 * t432;
  t1566 = t1492 * t207;
  t1568 = t102 * t186;
  t1569 = t511 * t1568;
  t1572 = t207 * t207;
  t1573 = t1492 * t1572;
  t1574 = t183 * t1573;
  t1579 = t1497 * params->csk_a;
  t1580 = t1579 * t103;
  t1586 = t95 * t1494;
  t1589 = t1492 * t186;
  t1590 = t183 * t1589;
  t1591 = t507 * t494;
  t1595 = t203 * t203;
  t1596 = t1595 * t186;
  t1597 = t183 * t1596;
  t1603 = t429 * t1589;
  t1604 = t438 * t207;
  t1605 = t523 * t1604;
  t1608 = t443 * t186;
  t1609 = t95 * t1608;
  t1614 = t1497 * t67;
  t1615 = t102 * t1502;
  t1616 = t1614 * t1615;
  t1625 = t1497 * t512;
  t1626 = t1625 * t103;
  t1629 = 0.3e1 * t95 * t1596 * t200 - t1495 * t1616 - 0.6e1 * t1516 * t1524 + 0.6e1 * t1516 * t1616 - 0.7e1 * t1527 * t1616 - 0.18e2 * t1527 * t1626 + t1586 * t1616 - 0.3e1 * t1597 * t200 - 0.3e1 * t1597 * t217 - 0.6e1 * t1603 * t1605 + 0.4e1 * t1609 * t261;
  t1634 = t1517 * t524;
  t1643 = t95 * t1595;
  t1648 = my_piecewise3(t60, 0, t1475);
  t1649 = my_piecewise3(t62, t1648, 0);
  t1653 = t1493 * t1497;
  t1654 = t1498 * t1501;
  t1655 = t1653 * t1654;
  t1657 = t95 * t1492;
  t1658 = t1653 * t103;
  t1662 = t1572 * t188;
  t1663 = t1662 * t103;
  t1666 = t183 * t1492;
  t1667 = t1662 * t193;
  t1670 = t1653 * t193;
  t1674 = t1653 * t439;
  t1680 = t203 * t99;
  t1682 = t183 * t1680 * t188;
  t1685 = t193 * t649;
  t1690 = params->csk_a * t207;
  t1692 = t103 * t1690 * t203;
  t1695 = t183 * t1566;
  t1697 = t186 * t67 * t102;
  t1698 = t581 * t1697;
  t1701 = t429 * t1566;
  t1706 = 0.18e2 * t95 * t628 * t188 * t1692 + 0.6e1 * t429 * t1492 * t1674 + 0.3e1 * t183 * t1595 * t194 + 0.4e1 * t1609 * t251 + 0.3e1 * t1657 * t1663 + 0.3e1 * t1666 * t1667 + 0.11e2 * t1666 * t1670 - 0.18e2 * t1682 * t1685 - 0.18e2 * t1682 * t650 + 0.18e2 * t1695 * t1698 - 0.6e1 * t1701 * t1698;
  t1708 = t183 * t1562;
  t1711 = t485 * t1697;
  t1714 = t95 * t1589;
  t1715 = t511 * t474;
  t1719 = t511 * t513 * t207;
  t1722 = t95 * t594;
  t1724 = t511 * t513 * t203;
  t1729 = t429 * t1562;
  t1733 = t523 * t1544 * params->csk_a;
  t1739 = t523 * t538 * t186;
  t1742 = t511 * t479;
  t1745 = 0.18e2 * t1695 * t1711 - 0.12e2 * t1701 * t1739 + 0.18e2 * t1708 * t614 + 0.18e2 * t1708 * t638 - 0.18e2 * t1714 * t1715 - 0.6e1 * t1714 * t1719 - 0.6e1 * t1722 * t1724 - 0.18e2 * t1722 * t1742 - 0.12e2 * t1729 * t591 - 0.6e1 * t1729 * t638 + 0.18e2 * t595 * t1733;
  t1747 = t215 * t494 * t203;
  t1751 = t523 * t1604 * params->csk_a;
  t1755 = t507 * t528 * t203;
  t1759 = t507 * t494 * params->csk_a;
  t1763 = t186 * t190 * t192;
  t1764 = t581 * t1763;
  t1767 = t183 * t1608;
  t1771 = t507 * t528 * t207;
  t1776 = t507 * t587;
  t1783 = t198 * t659 * t207;
  t1786 = 0.18e2 * t95 * t1680 * t1783 + 0.18e2 * t1590 * t1771 + 0.18e2 * t1603 * t1751 + 0.18e2 * t1603 * t1759 - 0.18e2 * t1701 * t1764 - 0.18e2 * t1729 * t584 + 0.18e2 * t629 * t1747 + 0.18e2 * t663 * t1755 - 0.4e1 * t1767 * t251 - 0.4e1 * t1767 * t266 + 0.18e2 * t595 * t1776;
  t1790 = my_piecewise5(t57, 0, t60, 0, -0.12e2 * t95 * t1562 * t660 - 0.12e2 * t95 * t1566 * t1569 + 0.3e1 * t95 * t1573 * t200 - t95 * t1649 * t104 + t1491 * t1492 * t1655 + 0.6e1 * t1516 * t1626 - 0.6e1 * t1495 * t1634 - 0.18e2 * t1590 * t1591 - 0.3e1 * t1574 * t217 - 0.3e1 * t1574 * t200 - 0.11e2 * t1527 * t1580 + 0.11e2 * t1586 * t1580 - 0.6e1 * t1495 * t1504 - 0.7e1 * t1495 * t1508 + 0.11e2 * t1495 * t1512 + 0.6e1 * t1586 * t1626 - 0.12e2 * t1516 * t1634 + 0.7e1 * t1495 * t1536 - 0.3e1 * t1643 * t209 + 0.3e1 * t1643 * t211 + 0.6e1 * t1657 * t1658 - 0.4e1 * t95 * t443 * t97 * t209 + 0.4e1 * t244 * t215 * t192 * t443 + t1786 + t1745 + t1706 + t1629 + t1552 - 0.5e1 * t534 + 0.4e1 * t504 + 0.4e1 * t496 + 0.4e1 * t476 - 0.4e1 * t470 - 0.4e1 * t462 - t210);
  t1797 = my_piecewise3(t3, 0, -0.14e2 / 0.135e3 * t8 * t21 / t22 / t82 * t72 + 0.8e1 / 0.45e2 * t8 * t400 * t108 - t8 * t159 * t222 / 0.5e1 + 0.2e1 / 0.5e1 * t8 * t78 * t546 + 0.3e1 / 0.2e2 * t8 * t24 * (0.4e1 * t421 * t106 + t1475 * t70 + 0.6e1 * t177 * t220 + t52 * t1790 + 0.4e1 * t93 * t544 + t1469));
  tv4rho40 = 0.2e1 * rho[0] * t1797 + 0.8e1 * t551;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1812 = 0.77e3 / 0.243e3 * t30 * t32 * t412;
  t1816 = -0.154e3 / 0.81e2 * t40 * t119 * t412 + t1812;
  t1833 = params->csk_a * t203;
  t1836 = t1833 * t67 * t260 * t207;
  t1842 = params->csk_a * t99;
  t1843 = t1842 * t203;
  t1844 = t968 * t1843;
  t1849 = t576 * t186;
  t1850 = t95 * t1849;
  t1853 = t438 * t254;
  t1854 = t523 * t1853;
  t1857 = -0.9e1 * t183 * t964 * t1844 + 0.9e1 * t647 * t1836 - 0.9e1 * t999 * t1836 + 0.3e1 * t1850 * t261 - 0.3e1 * t595 * t1854 - t259 + 0.4e1 * t626 + 0.4e1 * t632 + 0.4e1 * t651 - 0.4e1 * t655 - 0.4e1 * t657 - 0.3e1 * t678 - 0.2e1 * t682;
  t1858 = t430 * t1493;
  t1859 = t1491 * t1858;
  t1860 = t1501 * t126;
  t1871 = t198 * t102 * t443;
  t1874 = t215 * t192 * t576;
  t1881 = t254 * t432;
  t1882 = t95 * t1881;
  t1885 = t183 * t1858;
  t1889 = t507 * t670;
  t1892 = t429 * t1858;
  t1893 = t1517 * t596;
  t1901 = t126 * t1493;
  t1902 = t95 * t1901;
  t1903 = t102 * t430;
  t1904 = t1614 * t1903;
  t1907 = t1859 * t1499 * t1860 - 0.3e1 * t95 * t254 * t203 * t209 - t95 * t126 * t443 * t209 + t249 * t1871 + 0.3e1 * t244 * t1874 - 0.3e1 * t95 * t576 * t97 * t209 - 0.6e1 * t1882 * t660 + 0.11e2 * t1885 * t1532 * t245 - 0.9e1 * t663 * t1889 + 0.6e1 * t1892 * t1893 + 0.3e1 * t602 * t684 + t1767 * t246 + 0.3e1 * t455 * t671 + 0.6e1 * t1902 * t1904;
  t1910 = t183 * t430 * t1572;
  t1913 = t126 * t430;
  t1914 = t95 * t1913;
  t1917 = my_piecewise3(t60, 0, t1816);
  t1918 = my_piecewise3(t62, t1917, 0);
  t1921 = t183 * t1004;
  t1923 = t512 * t203 * t97;
  t1924 = t193 * t1923;
  t1927 = t1913 * t207;
  t1931 = t429 * t1927;
  t1936 = t198 * t502 * t203;
  t1939 = t254 * t184;
  t1944 = t430 * t186;
  t1946 = t429 * t1944 * t434;
  t1953 = t254 * t99 * t188;
  t1957 = t248 * t434;
  t1958 = t95 * t1957;
  t1960 = t512 * t430 * t207;
  t1961 = t103 * t1960;
  t1964 = t183 * t1957;
  t1967 = t193 * t1330;
  t1970 = -0.9e1 * t183 * t1939 * t207 * t461 - t95 * t1918 * t104 + 0.18e2 * t1946 * t439 * t1330 + 0.18e2 * t183 * t1927 * t1711 + 0.9e1 * t95 * t964 * t1936 + 0.9e1 * t95 * t1953 * t650 + 0.3e1 * t1914 * t1663 - 0.12e2 * t1931 * t1739 - 0.18e2 * t1931 * t1764 + 0.3e1 * t1910 * t246 + 0.9e1 * t1921 * t1924 + 0.18e2 * t1946 * t1967 - 0.6e1 * t1958 * t1961 + 0.18e2 * t1964 * t1961;
  t1973 = t103 * params->csk_a * t430 * t207;
  t1976 = t429 * t1957;
  t1979 = t1833 * t880;
  t1982 = t183 * t1953;
  t1986 = t429 * t839 * t434;
  t1987 = t984 * t203;
  t1991 = t439 * t1923;
  t1994 = t95 * t1004;
  t1995 = t103 * t1923;
  t2004 = t97 * t99;
  t2006 = t183 * t2004 * t188;
  t2007 = t850 * t203;
  t2014 = t193 * t1960;
  t2019 = 0.9e1 * t1986 * t193 * t1987 + 0.9e1 * t2006 * t193 * t2007 + 0.9e1 * t1986 * t439 * t1987 - 0.9e1 * t1005 * t1924 - 0.6e1 * t1005 * t1991 - 0.3e1 * t1005 * t1995 + 0.9e1 * t1921 * t1979 + 0.9e1 * t1921 * t1995 - 0.18e2 * t1958 * t1973 - 0.6e1 * t1976 * t1961 + 0.18e2 * t1964 * t2014 - 0.9e1 * t1994 * t1979 - 0.9e1 * t1982 * t650 - 0.3e1 * t1994 * t1995;
  t2023 = t1614 * t199 * t430;
  t2027 = t207 * t434 * t1697;
  t2030 = t183 * t1913;
  t2031 = t193 * params->csk_a;
  t2032 = t1662 * t2031;
  t2035 = t183 * t1881;
  t2038 = t429 * t1901;
  t2041 = t1507 * t430 * t67 * t102;
  t2044 = t1491 * t1901;
  t2047 = t1517 * t1518 * t430;
  t2052 = t429 * t1881;
  t2056 = t1614 * t513 * t430;
  t2059 = t183 * t1901;
  t2062 = t1532 * t361;
  t2066 = -0.18e2 * t1892 * t2062 + 0.11e2 * t1902 * t2023 + t1902 * t2041 + 0.6e1 * t1902 * t2056 - 0.12e2 * t1914 * t2027 - 0.3e1 * t2030 * t2032 + 0.9e1 * t2035 * t614 + 0.9e1 * t2035 * t638 + 0.6e1 * t2038 * t2041 + 0.12e2 * t2038 * t2047 - t2044 * t2041 - 0.3e1 * t2052 * t638 - 0.18e2 * t2059 * t2056;
  t2072 = t1532 * t245 * t512;
  t2077 = t1662 * t963;
  t2083 = t1517 * t538 * t430;
  t2092 = t1532 * t192 * t1502 * t430;
  t2102 = t183 * t1944;
  t2106 = 0.9e1 * t95 * t1939 * t625 - 0.18e2 * t2102 * t507 * t630 + 0.3e1 * t1850 * t251 + 0.7e1 * t1859 * t2072 - 0.3e1 * t1882 * t638 + 0.3e1 * t1914 * t2077 - 0.11e2 * t2059 * t2023 - 0.3e1 * t2030 * t2077 + 0.6e1 * t2038 * t2056 - 0.6e1 * t2038 * t2083 + 0.18e2 * t2038 * t2092 - 0.7e1 * t2059 * t2041 - 0.7e1 * t2044 * t2092 - 0.7e1 * t2059 * t2092;
  t2109 = t511 * t260 * t203;
  t2113 = t215 * t670 * t207;
  t2116 = t429 * t1944;
  t2118 = t523 * t596 * t207;
  t2121 = t183 * t839;
  t2126 = t1517 * t597;
  t2129 = t183 * t1849;
  t2134 = t507 * t892;
  t2144 = t1532 * t528 * t430;
  t2153 = -0.6e1 * t619 * t2109 + 0.9e1 * t629 * t2113 - 0.6e1 * t2116 * t2118 - 0.9e1 * t2121 * t507 * t245 * t203 - 0.12e2 * t1892 * t2126 - 0.3e1 * t2129 * t251 - 0.3e1 * t609 * t480 + 0.9e1 * t595 * t2134 - 0.9e1 * t2052 * t584 - 0.9e1 * t1882 * t614 + 0.7e1 * t1885 * t2062 - 0.11e2 * t2059 * t2144 - 0.3e1 * t2129 * t266 - 0.3e1 * t840 * t523 * t1544 * t126;
  t2159 = t198 * t199 * t443;
  t2167 = t215 * t216 * t443;
  t2176 = t1499 * t1503 * t430;
  t2180 = t523 * t1853 * params->csk_a;
  t2184 = t1499 * t1860 * params->csk_a;
  t2189 = t1517 * t1358;
  t2192 = 0.11e2 * t1859 * t1499 * t1860 * t512 - 0.6e1 * t1859 * t2126 - 0.6e1 * t1859 * t2184 + 0.18e2 * t1859 * t2189 + 0.9e1 * t2035 * t584 - 0.12e2 * t2044 * t2047 - 0.6e1 * t2044 * t2176 - 0.6e1 * t2052 * t591 + t249 * t2159 - t263 * t2159 - t263 * t2167 + 0.9e1 * t595 * t2180 + 0.3e1 * t602 * t480 - 0.3e1 * t609 * t588;
  t2196 = my_piecewise5(t57, 0, t60, 0, t1857 + t1907 + t1970 + t2019 + t2066 + t2106 + t2153 + t2192);
  t2203 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t400 * t131 - t8 * t159 * t271 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t78 * t690 + 0.3e1 / 0.2e2 * t8 * t24 * (0.3e1 * t567 * t106 + t123 * t544 + t421 * t129 + 0.3e1 * t177 * t269 + t1816 * t70 + t52 * t2196 + 0.3e1 * t239 * t220 + 0.3e1 * t93 * t688 - t1812));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t2203 + 0.6e1 * t695;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t2238 = t183 * t1000;
  t2241 = t466 * t99;
  t2243 = t2241 * t103 * t203;
  t2248 = t298 * t184;
  t2250 = t183 * t2248 * t207;
  t2253 = t1071 * params->csk_a;
  t2254 = t439 * t2253;
  t2257 = t145 * t430;
  t2258 = t2257 * t207;
  t2259 = t429 * t2258;
  t2263 = t193 * t1071 * t203;
  t2268 = t193 * t2253;
  t2271 = 0.9e1 * t1012 * t1924 - 0.12e2 * t2259 * t1739 + 0.9e1 * t799 * t1836 - 0.9e1 * t2238 * t1844 + 0.18e2 * t1946 * t2254 + 0.18e2 * t1946 * t2268 + 0.9e1 * t2006 * t2263 - 0.9e1 * t2238 * t2243 - 0.9e1 * t2250 * t461 - 0.9e1 * t2250 * t469 + 0.4e1 * t736 + 0.4e1 * t740 - 0.4e1 * t753;
  t2278 = t183 * t2258;
  t2283 = t292 * t434;
  t2284 = t95 * t2283;
  t2289 = t298 * t432;
  t2290 = t429 * t2289;
  t2293 = t145 * t1493;
  t2294 = t95 * t2293;
  t2299 = t720 * t186;
  t2300 = t95 * t2299;
  t2307 = -0.3e1 * t95 * t298 * t203 * t209 + 0.9e1 * t1012 * t1979 - 0.6e1 * t2259 * t1698 + 0.18e2 * t2278 * t1698 - 0.18e2 * t2259 * t1764 - 0.6e1 * t2284 * t1961 - 0.18e2 * t2284 * t1973 - 0.9e1 * t983 * t1979 + 0.6e1 * t2294 * t2056 - 0.3e1 * t2290 * t638 + 0.3e1 * t2300 * t261 - t303 - 0.3e1 * t774 - 0.2e1 * t778;
  t2313 = t507 * t765;
  t2316 = t1517 * t769;
  t2324 = t438 * t298;
  t2325 = t523 * t2324;
  t2328 = t1501 * t145;
  t2329 = t1499 * t2328;
  t2332 = t215 * t192 * t720;
  t2339 = t95 * t2289;
  t2342 = t1532 * t289;
  t2347 = -t95 * t145 * t443 * t209 - 0.3e1 * t95 * t720 * t97 * t209 + t1767 * t290 + t1859 * t2329 + t293 * t1871 + 0.11e2 * t1885 * t2342 + 0.6e1 * t1892 * t2316 + 0.3e1 * t1910 * t290 - 0.9e1 * t663 * t2313 - 0.3e1 * t595 * t2325 + 0.3e1 * t244 * t2332 - 0.6e1 * t2339 * t660 + 0.3e1 * t455 * t766 + 0.3e1 * t760 * t684;
  t2348 = t95 * t2257;
  t2355 = my_piecewise3(t60, 0, -0.55e2 / 0.81e2 * t44 * t564);
  t2356 = my_piecewise3(t62, t2355, 0);
  t2361 = t1006 * t203;
  t2362 = t439 * t2361;
  t2376 = t193 * t2361;
  t2381 = t95 * t298 * t99 * t188;
  t2384 = t183 * t2283;
  t2389 = 0.9e1 * t95 * t1000 * t1936 - t95 * t2356 * t104 + 0.9e1 * t1012 * t1995 + 0.3e1 * t2348 * t1663 + 0.18e2 * t2278 * t1711 + 0.6e1 * t2294 * t1904 - 0.9e1 * t989 * t1924 + 0.9e1 * t1986 * t2362 + 0.9e1 * t1986 * t2376 - 0.6e1 * t989 * t1991 - 0.3e1 * t983 * t1995 - 0.3e1 * t989 * t1995 + 0.18e2 * t2384 * t2014 + 0.9e1 * t2381 * t650;
  t2397 = t1532 * t289 * t512;
  t2400 = t429 * t2293;
  t2405 = t183 * t2257;
  t2408 = t507 * t734;
  t2413 = t183 * t2293;
  t2423 = t1491 * t2293;
  t2425 = -0.12e2 * t293 * t511 * t1903 * t207 + 0.7e1 * t1859 * t2397 + 0.11e2 * t2294 * t2023 - 0.11e2 * t2413 * t2023 - 0.3e1 * t2405 * t2032 + t2294 * t2041 + 0.6e1 * t2400 * t2041 - 0.7e1 * t2413 * t2041 - t2423 * t2041 + 0.3e1 * t2348 * t2077 - 0.3e1 * t2405 * t2077 - 0.6e1 * t2400 * t2083 - 0.18e2 * t2102 * t2408;
  t2432 = t183 * t2289;
  t2435 = t507 * t1120;
  t2442 = t1532 * t742;
  t2447 = t183 * t2299;
  t2458 = 0.7e1 * t1885 * t2442 + 0.12e2 * t2400 * t2047 - 0.12e2 * t2423 * t2047 + 0.6e1 * t2400 * t2056 - 0.18e2 * t2413 * t2056 - 0.6e1 * t731 * t2109 - 0.11e2 * t2413 * t2144 - 0.9e1 * t2290 * t584 - 0.9e1 * t2339 * t614 + 0.9e1 * t2432 * t614 + 0.9e1 * t2432 * t638 + 0.9e1 * t595 * t2435 - 0.3e1 * t2447 * t266 - 0.3e1 * t728 * t588;
  t2464 = t1499 * t2328 * t512;
  t2470 = t523 * t2324 * params->csk_a;
  t2474 = t1499 * t2328 * params->csk_a;
  t2477 = t1517 * t786;
  t2481 = t1517 * t769 * t512;
  t2494 = t215 * t765 * t207;
  t2497 = 0.11e2 * t1859 * t2464 - 0.6e1 * t1859 * t2474 - 0.6e1 * t1859 * t2477 + 0.18e2 * t1859 * t2481 + 0.18e2 * t2400 * t2092 - 0.7e1 * t2413 * t2092 - 0.7e1 * t2423 * t2092 - t305 * t2159 - t305 * t2167 - 0.6e1 * t2423 * t2176 - 0.6e1 * t2290 * t591 - 0.3e1 * t2339 * t638 + 0.9e1 * t595 * t2470 + 0.9e1 * t629 * t2494;
  t2499 = t523 * t769 * t207;
  t2503 = t507 * t289 * t203;
  t2530 = -0.3e1 * t840 * t523 * t1544 * t145 + 0.9e1 * t95 * t2248 * t625 - 0.18e2 * t1892 * t2442 - 0.12e2 * t1892 * t2477 - 0.6e1 * t2116 * t2499 - 0.9e1 * t2121 * t2503 + t293 * t2159 + 0.3e1 * t2300 * t251 + 0.9e1 * t2432 * t584 - 0.3e1 * t2447 * t251 - 0.3e1 * t728 * t480 + 0.3e1 * t760 * t480 + 0.4e1 * t800 - 0.4e1 * t802;
  t2534 = my_piecewise5(t57, 0, t60, 0, t2271 + t2307 + t2347 + t2389 + t2425 + t2458 + t2497 + t2530);
  t2541 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t400 * t150 - t8 * t159 * t311 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t78 * t808 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.55e2 / 0.81e2 * t45 * t561 * t70 + 0.5e1 / 0.9e1 * t45 * t233 * t106 - 0.5e1 / 0.24e2 * t45 * t116 * t220 + t45 * t137 * t544 / 0.24e2 + t421 * t148 + 0.3e1 * t177 * t309 + 0.3e1 * t93 * t806 + t52 * t2534));
  tv4rho3lapl0 = 0.2e1 * rho[0] * t2541 + 0.6e1 * t813;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t2560 = t850 * t188;
  t2561 = t183 * t2560;
  t2562 = t2004 * t254;
  t2566 = t103 * t254;
  t2571 = t97 * t207 * t254;
  t2572 = t963 * t2571;
  t2575 = t324 * t434;
  t2576 = t429 * t2575;
  t2577 = t512 * t184;
  t2579 = t2577 * t103 * t207;
  t2583 = t512 * t254 * t97;
  t2584 = t193 * t2583;
  t2587 = t328 * t99;
  t2588 = t2587 * t188;
  t2589 = t183 * t2588;
  t2591 = 0.3e1 * t2589 * t1685;
  t2592 = t95 * t2588;
  t2594 = 0.3e1 * t2592 * t650;
  t2596 = 0.3e1 * t2589 * t650;
  t2599 = t95 * t2575;
  t2602 = t183 * t2575;
  t2607 = t193 * t1843;
  t2611 = t429 * t196 * t434;
  t2612 = t439 * t1252;
  t2615 = -0.12e2 * t2561 * t2031 * t2562 - 0.12e2 * t2561 * t874 * t2566 - 0.12e2 * t1005 * t2584 + 0.18e2 * t2576 * t1685 + 0.12e2 * t1921 * t2584 + 0.12e2 * t647 * t2572 - 0.6e1 * t2576 * t2579 - 0.6e1 * t2599 * t2579 + 0.18e2 * t2602 * t2579 - 0.3e1 * t862 * t2607 + 0.18e2 * t2611 * t2612 - t2591 + t2594 - t2596 - t330 - t332;
  t2616 = t860 * t434;
  t2617 = t429 * t2616;
  t2618 = t2577 * t186;
  t2619 = t439 * t2618;
  t2622 = t1833 * t468;
  t2625 = t2577 * t1763;
  t2628 = t863 * t2566;
  t2631 = t103 * t2583;
  t2643 = t648 * t1697;
  t2659 = t439 * t2583;
  t2665 = t193 * t2577 * t207;
  t2670 = -0.12e2 * t2617 * t2619 - 0.3e1 * t862 * t2622 - 0.18e2 * t2617 * t2625 + 0.12e2 * t1921 * t2628 - 0.4e1 * t1994 * t2631 + 0.12e2 * t1921 * t2631 - 0.4e1 * t1005 * t2631 + 0.12e2 * t1005 * t193 * t863 * t254 + 0.18e2 * t183 * t2616 * t2643 - 0.18e2 * t2599 * t650 + 0.12e2 * t999 * t193 * t2571 + 0.12e2 * t95 * t2560 * t103 * t2562 + 0.12e2 * t1986 * t439 * t984 * t254 - 0.8e1 * t1005 * t2659 + 0.3e1 * t869 * t1692 + 0.18e2 * t2602 * t2665 - 0.12e2 * t1994 * t2628;
  t2672 = t321 * t1493;
  t2673 = t95 * t2672;
  t2675 = t1614 * t199 * t184;
  t2678 = t321 * t1572;
  t2679 = t183 * t2678;
  t2680 = t216 * t184;
  t2681 = t215 * t2680;
  t2684 = t429 * t2672;
  t2685 = t1517 * t590;
  t2688 = t328 * t432;
  t2689 = t95 * t2688;
  t2691 = 0.3e1 * t2689 * t614;
  t2692 = t183 * t2688;
  t2694 = 0.3e1 * t2692 * t614;
  t2695 = t466 * t613;
  t2698 = t183 * t2672;
  t2701 = t321 * t184;
  t2705 = t1532 * t2680;
  t2708 = t1614 * t637;
  t2715 = t429 * t2688;
  t2716 = t2715 * t638;
  t2718 = t1517 * t1518 * t184;
  t2722 = t1614 * t1615 * t184;
  t2726 = 0.3e1 * t95 * t2701 * t2077 + 0.11e2 * t2673 * t2675 + 0.6e1 * t2673 * t2708 + t2673 * t2722 - 0.11e2 * t2698 * t2675 - 0.3e1 * t2679 * t2681 - 0.3e1 * t2679 * t2695 - 0.6e1 * t2684 * t2685 - 0.18e2 * t2684 * t2705 + 0.6e1 * t2684 * t2708 + 0.12e2 * t2684 * t2718 - 0.18e2 * t2698 * t2708 - 0.7e1 * t2698 * t2722 - t2691 + t2694 - t2716;
  t2729 = t1491 * t2672;
  t2731 = t2689 * t638;
  t2733 = 0.3e1 * t2692 * t638;
  t2736 = t1507 * t583;
  t2742 = t825 * t480;
  t2744 = 0.3e1 * t2692 * t584;
  t2747 = t184 * t1493;
  t2748 = t1491 * t2747;
  t2750 = t1517 * t841 * params->csk_a;
  t2762 = t511 * t659 * t186;
  t2766 = t523 * t538 * t203;
  t2769 = 0.7e1 * t2729 * t1532 * t528 * t184 + 0.3e1 * t832 * t1724 - t878 * t1724 + 0.3e1 * t878 * t1776 + 0.6e1 * t2684 * t2722 + 0.18e2 * t2684 * t2736 + 0.18e2 * t2729 * t2685 - 0.12e2 * t2729 * t2718 - t2729 * t2722 - 0.7e1 * t2729 * t2736 - 0.6e1 * t2748 * t2750 - 0.12e2 * t909 * t2762 - 0.2e1 * t878 * t2766 - t2731 + t2733 + t2742 + t2744;
  t2772 = t1501 * t321;
  t2778 = t1499 * t1503 * t184;
  t2782 = t198 * t199 * t576;
  t2787 = t885 * t588;
  t2788 = t885 * t480;
  t2789 = t507 * t1285;
  t2791 = 0.3e1 * t595 * t2789;
  t2793 = 0.3e1 * t2715 * t584;
  t2798 = t183 * t2747;
  t2799 = t192 * t321;
  t2800 = t2799 * params->csk_a;
  t2801 = t1532 * t2800;
  t2805 = t215 * t216 * t576;
  t2810 = t1532 * t2799 * t512;
  t2819 = 0.11e2 * t2748 * t1499 * t2772 * t512 - 0.4e1 * t840 * t523 * t596 * t254 - t828 * t1724 - 0.3e1 * t828 * t1742 + 0.3e1 * t832 * t1742 + 0.3e1 * t832 * t1755 + 0.2e1 * t249 * t2782 - 0.2e1 * t263 * t2805 - 0.7e1 * t2698 * t2736 - 0.6e1 * t2729 * t2778 + 0.7e1 * t2798 * t2801 - 0.11e2 * t2798 * t2810 - t2787 - t2788 + t2791 - t2793;
  t2822 = t429 * t196;
  t2842 = t438 * t328;
  t2844 = t523 * t2842 * params->csk_a;
  t2846 = 0.3e1 * t595 * t2844;
  t2848 = 0.2e1 * t2715 * t591;
  t2851 = t2799 * t207;
  t2852 = t507 * t2851;
  t2856 = t511 * t260 * t254;
  t2864 = t215 * t844 * t207;
  t2866 = 0.3e1 * t629 * t2864;
  t2867 = t95 * t2587;
  t2869 = 0.3e1 * t2867 * t1783;
  t2870 = 0.2e1 * t826;
  t2871 = 0.2e1 * t846;
  t2872 = 0.3e1 * t918 * t1747 - 0.6e1 * t2822 * t523 * t841 * t207 - 0.12e2 * t606 * t507 * t833 * t254 - 0.12e2 * t2684 * t1517 * t438 * t184 * params->csk_a + 0.3e1 * t878 * t1733 - 0.6e1 * t2748 * t1499 * t2772 * params->csk_a + t2846 - t2848 + 0.3e1 * t909 * t1936 - 0.18e2 * t213 * t2852 - 0.8e1 * t619 * t2856 - 0.2e1 * t263 * t2782 - 0.3e1 * t878 * t1755 + t2866 + t2869 + t2870 + t2871;
  t2874 = 0.3e1 * t849;
  t2876 = t254 * t254;
  t2877 = t2876 * t186;
  t2878 = t183 * t2877;
  t2885 = 0.2e1 * t2689 * t660;
  t2887 = t198 * t659;
  t2890 = t1614 * t659;
  t2898 = t102 * t576;
  t2902 = t198 * t2898;
  t2905 = t825 * t684;
  t2906 = t507 * t844;
  t2908 = 0.3e1 * t663 * t2906;
  t2909 = t511 * t683;
  t2912 = t1532 * t2799;
  t2917 = t429 * t2747;
  t2921 = 0.6e1 * t2917 * t1517 * t841 + 0.3e1 * t183 * t2701 * t1667 + 0.2e1 * t95 * t2877 * t200 + 0.3e1 * t95 * t2678 * t2887 - 0.2e1 * t851 * t852 * t2898 - 0.3e1 * t832 * t1539 - 0.2e1 * t2878 * t200 - 0.2e1 * t2878 * t217 + 0.2e1 * t249 * t2902 + 0.6e1 * t2673 * t2890 + 0.11e2 * t2798 * t2912 - 0.2e1 * t828 * t2909 - t2874 - t2885 + t2905 - t2908 - 0.4e1 * t855;
  t2927 = t455 * t845;
  t2928 = t523 * t2842;
  t2929 = t595 * t2928;
  t2932 = t95 * t328 * t203 * t209;
  t2933 = t95 * t2876;
  t2944 = 0.2e1 * t883;
  t2945 = 0.2e1 * t886;
  t2946 = 0.2e1 * t908;
  t2949 = t2748 * t1499 * t2772 + 0.2e1 * t183 * t2876 * t194 - t1729 * t842 + 0.2e1 * t263 * t1874 - 0.2e1 * t2933 * t209 + 0.2e1 * t2933 * t211 + t2927 - t2929 - t2932 + t2944 - t2945 - t2946 - 0.4e1 * t865 + 0.4e1 * t872 - 0.4e1 * t876 + 0.4e1 * t912 + 0.4e1 * t921;
  t2953 = my_piecewise5(t57, 0, t60, 0, t2615 + t2670 + t2726 + t2769 + t2819 + t2872 + t2921 + t2949);
  t2960 = my_piecewise3(t3, 0, -t8 * t159 * t340 / 0.3e2 + t8 * t78 * t937 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (0.2e1 * t123 * t688 + 0.2e1 * t567 * t129 + t177 * t338 + 0.4e1 * t239 * t269 + t52 * t2953 + 0.2e1 * t93 * t935));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t2960 + 0.4e1 * t942;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t2986 = t974 * t207;
  t2987 = t183 * t2986;
  t2990 = t977 * t207;
  t2991 = t183 * t2990;
  t2996 = t439 * t145;
  t3000 = t429 * t957;
  t3007 = t193 * t145;
  t3011 = t581 * t184;
  t3022 = t193 * t512;
  t3030 = t3011 * t1697;
  t3041 = -t330 - 0.6e1 * t2987 * t969 - 0.6e1 * t2991 * t969 - 0.3e1 * t958 * t1844 + 0.18e2 * t2611 * t2996 * t1330 - 0.12e2 * t3000 * t523 * t438 * t2618 - 0.3e1 * t958 * t2243 + 0.18e2 * t2611 * t3007 * t1330 - 0.18e2 * t3000 * t3011 * t1763 + 0.6e1 * t2381 * t965 + 0.6e1 * t799 * t2572 + 0.3e1 * t799 * t963 * t2007 + 0.18e2 * t2384 * t3022 * t653 - 0.6e1 * t2987 * t960 - 0.6e1 * t2991 * t960 + 0.18e2 * t958 * t3030 + 0.18e2 * t958 * t485 * t184 * t1697 - 0.18e2 * t2284 * t963 * t653 - 0.4e1 * t961;
  t3044 = t2293 * t1497;
  t3045 = t1491 * t3044;
  t3046 = t1502 * t126;
  t3047 = t3046 * t583;
  t3050 = t1901 * t1497;
  t3051 = t1491 * t3050;
  t3052 = t145 * t512;
  t3057 = t95 * t3044;
  t3058 = t990 * t184;
  t3059 = t103 * t3058;
  t3062 = t429 * t3044;
  t3065 = t3046 * t184;
  t3066 = t439 * t3065;
  t3069 = t183 * t3044;
  t3072 = t103 * t3065;
  t3082 = t2747 * t1497;
  t3083 = t1491 * t3082;
  t3084 = t3052 * t126;
  t3088 = t2289 * t434;
  t3089 = t183 * t3088;
  t3092 = t1833 * t1348;
  t3100 = t103 * t984 * t184;
  t3104 = t183 * t354 * t1572;
  t3107 = 0.7e1 * t3051 * t193 * t3052 * t184 + 0.11e2 * t3083 * t1654 * t3084 + 0.6e1 * t1012 * t2628 + 0.3e1 * t1012 * t3092 - 0.12e2 * t1015 * t2762 - 0.3e1 * t3104 * t2681 - 0.7e1 * t3045 * t3047 + 0.18e2 * t3062 * t3047 - 0.7e1 * t3069 * t3047 + 0.6e1 * t3057 * t3059 + t3057 * t3072 + 0.11e2 * t3057 * t3100 + 0.6e1 * t3062 * t3059 - 0.18e2 * t3069 * t3059 + 0.12e2 * t3062 * t3066 + 0.6e1 * t3062 * t3072 - 0.7e1 * t3069 * t3072 + 0.6e1 * t3089 * t986 + 0.4e1 * t966 - 0.4e1 * t970;
  t3126 = t354 * params->csk_a;
  t3131 = t193 * t3126;
  t3134 = t95 * t3088;
  t3147 = t429 * t3088;
  t3153 = t990 * t193 * t203;
  t3163 = -0.6e1 * t3062 * t439 * t3058 - 0.18e2 * t1964 * t193 * t751 - 0.3e1 * t3104 * t2695 - 0.11e2 * t3069 * t3100 + 0.3e1 * t95 * t738 * t1572 * t352 - t3045 * t3072 + 0.3e1 * t1005 * t2362 - 0.6e1 * t3083 * t1654 * t3126 - 0.18e2 * t429 * t3082 * t3131 - 0.6e1 * t3134 * t986 - 0.6e1 * t983 * t2628 - 0.3e1 * t983 * t3092 + 0.7e1 * t183 * t3082 * t3131 - 0.11e2 * t3069 * t193 * t3058 - 0.6e1 * t3147 * t992 - 0.6e1 * t989 * t2584 - 0.3e1 * t989 * t3153 + 0.18e2 * t3083 * t439 * t3084 - 0.12e2 * t3045 * t3066 - 0.4e1 * t3147 * t996;
  t3166 = t990 * t203;
  t3172 = t103 * t3166;
  t3199 = t772 * t207;
  t3214 = t429 * t1881 * t434;
  t3217 = -0.4e1 * t989 * t2659 - 0.2e1 * t989 * t439 * t3166 - 0.2e1 * t983 * t2631 - t983 * t3172 + 0.6e1 * t3089 * t1021 + 0.3e1 * t1012 * t3172 + 0.6e1 * t1012 * t2631 + 0.6e1 * t3089 * t992 + 0.6e1 * t1012 * t2584 + 0.3e1 * t1012 * t3153 + 0.6e1 * t95 * t2986 * t911 + 0.6e1 * t95 * t2990 * t911 + 0.3e1 * t1015 * t1936 - 0.6e1 * t3045 * t1654 * t3065 + 0.6e1 * t1982 * t1001 + 0.6e1 * t999 * t193 * t3199 + 0.3e1 * t999 * t2263 - 0.6e1 * t2611 * t439 * t957 - 0.12e2 * t429 * t3050 * t439 * t738 * params->csk_a + 0.6e1 * t3214 * t1008;
  t3221 = t298 * params->csk_a * t97;
  t3222 = t439 * t3221;
  t3232 = t193 * t3221;
  t3250 = t1662 * t3007;
  t3262 = 0.6e1 * t1005 * t3222 - 0.2e1 * t3147 * t1021 - 0.2e1 * t989 * t2631 - t989 * t3172 + 0.6e1 * t3214 * t1018 + 0.6e1 * t1005 * t3232 + 0.3e1 * t1005 * t2376 - 0.6e1 * t3083 * t439 * t3126 - 0.2e1 * t3134 * t1021 - t2591 + t2594 - t2596 + 0.3e1 * t355 * t1662 * t613 + 0.6e1 * t2294 * t1614 * t357 * t184 + 0.3e1 * t183 * t622 * t3250 + 0.11e2 * t2059 * t1532 * t289 * t184 - 0.2e1 * t728 * t893 - t305 * t2805 - 0.6e1 * t2035 * t1029;
  t3263 = t765 * t97;
  t3276 = t523 * t1853 * t145;
  t3301 = -0.6e1 * t606 * t507 * t3263 - 0.3e1 * t606 * t2503 + 0.6e1 * t2917 * t1517 * t1040 - 0.4e1 * t2339 * t1033 - t1729 * t1041 - 0.2e1 * t840 * t3276 - 0.2e1 * t840 * t523 * t596 * t298 + t2748 * t1499 * t1860 * t145 + t2300 * t352 + 0.2e1 * t760 * t901 + t293 * t2782 - 0.4e1 * t731 * t2856 - 0.2e1 * t731 * t511 * t357 * t203 - t2447 * t352 - 0.2e1 * t728 * t901 - t305 * t2782 - t2447 * t362 - t2691 + t2694 - t2716;
  t3305 = -t2731 + t2733 + t2742 + t2744 - t2787 - t2788 + t2791 - t2793 + t2846 - t2848 + t2866 + t2869 - t356 + t2870 + t2871 - t2874 - 0.2e1 * t976 - 0.2e1 * t979 - t2885 + t2905;
  t3328 = t103 * t512;
  t3332 = -t2908 + t2927 - t2929 - t2932 + 0.4e1 * t1002 + 0.4e1 * t1016 + t2944 - t2945 - t2946 + 0.2e1 * t760 * t857 + t293 * t2902 + t2129 * t290 + 0.2e1 * t609 * t766 + t263 * t2332 - t95 * t720 * t126 * t209 - 0.2e1 * t95 * t298 * t254 * t209 - t95 * t145 * t576 * t209 + t2300 * t358 - 0.6e1 * t3000 * t3030 - 0.6e1 * t2284 * t3328 * t653;
  t3336 = my_piecewise5(t57, 0, t60, 0, t3041 + t3107 + t3163 + t3217 + t3262 + t3301 + t3305 + t3332);
  t3343 = my_piecewise3(t3, 0, -t8 * t159 * t367 / 0.3e2 + t8 * t78 * t1049 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (0.5e1 / 0.27e2 * t45 * t233 * t129 - 0.5e1 / 0.36e2 * t45 * t116 * t269 + t45 * t137 * t688 / 0.24e2 + t567 * t148 + 0.2e1 * t239 * t309 + t123 * t806 + t177 * t365 + 0.2e1 * t93 * t1047 + t52 * t3336));
  tv4rho2sigmalapl0 = 0.2e1 * rho[0] * t3343 + 0.4e1 * t1054;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  t3365 = t379 * t434;
  t3366 = t429 * t3365;
  t3371 = t95 * t3365;
  t3374 = t183 * t3365;
  t3377 = t1088 * t434;
  t3378 = t183 * t3377;
  t3383 = t512 * t97;
  t3384 = t103 * t298;
  t3385 = t3383 * t3384;
  t3390 = t429 * t3377;
  t3393 = t863 * t3384;
  t3407 = -0.8e1 * t989 * t439 * t512 * t298 * t97 + 0.12e2 * t1012 * t3385 + 0.12e2 * t1012 * t3393 - 0.3e1 * t1090 * t2622 + 0.18e2 * t3366 * t1685 - 0.6e1 * t3366 * t2579 - 0.6e1 * t3371 * t2579 + 0.18e2 * t3374 * t2579 - 0.18e2 * t3390 * t2625 + 0.18e2 * t3378 * t2643 + 0.12e2 * t989 * t3232 - 0.18e2 * t3371 * t650 - 0.4e1 * t983 * t3385 - 0.4e1 * t989 * t3385 - t330 - t383;
  t3408 = t512 * t190;
  t3409 = t3408 * t3263;
  t3437 = t376 * t1493;
  t3438 = t429 * t3437;
  t3443 = t1491 * t3437;
  t3445 = -0.12e2 * t989 * t3409 + 0.12e2 * t1012 * t3409 - 0.12e2 * t3390 * t2619 + 0.12e2 * t799 * t103 * t3199 + 0.12e2 * t2006 * t193 * t1071 * t298 + 0.12e2 * t989 * t3222 + 0.3e1 * t1095 * t1692 + 0.18e2 * t3374 * t2665 - 0.12e2 * t983 * t3393 - 0.3e1 * t1090 * t2607 + 0.18e2 * t2611 * t439 * t1088 * params->csk_a - t2591 + t2594 - t2596 - 0.6e1 * t3438 * t2685 + 0.6e1 * t3438 * t2722 - t3443 * t2722;
  t3447 = t95 * t3437;
  t3449 = t183 * t3437;
  t3453 = t1517 * t1078 * params->csk_a;
  t3458 = t376 * t184;
  t3464 = t376 * t1572;
  t3465 = t183 * t3464;
  t3468 = t192 * t184;
  t3491 = 0.11e2 * t3443 * t1499 * t1511 * t184 - 0.18e2 * t385 * t507 * t3468 * t207 + 0.3e1 * t95 * t3458 * t2077 - 0.3e1 * t1085 * t1742 - 0.12e2 * t1113 * t2762 + 0.11e2 * t3447 * t2675 - 0.11e2 * t3449 * t2675 - 0.3e1 * t3465 * t2681 - 0.3e1 * t3465 * t2695 - 0.18e2 * t3438 * t2705 + 0.6e1 * t3438 * t2708 + 0.6e1 * t3447 * t2708 - 0.18e2 * t3449 * t2708 + t3447 * t2722 - 0.7e1 * t3449 * t2722 - 0.12e2 * t2917 * t3453;
  t3492 = t192 * t376;
  t3502 = t523 * t769 * t298;
  t3513 = t1532 * t3492 * t512;
  t3530 = t466 * t103 * t720;
  t3535 = 0.7e1 * t2798 * t1532 * t3492 * params->csk_a - 0.12e2 * t2121 * t507 * t289 * t298 + 0.3e1 * t1082 * t1724 + 0.3e1 * t1082 * t1742 - t1085 * t1724 - t1103 * t1724 - 0.3e1 * t1103 * t1755 + 0.3e1 * t1103 * t1776 + 0.18e2 * t3443 * t2685 + 0.18e2 * t3438 * t2736 - 0.7e1 * t3443 * t2736 - 0.7e1 * t3449 * t2736 - 0.6e1 * t2748 * t3453 + 0.7e1 * t2748 * t3513 - 0.11e2 * t2798 * t3513 - 0.2e1 * t305 * t3530 - 0.4e1 * t840 * t3502;
  t3556 = t1501 * t376;
  t3558 = t1499 * t3556 * params->csk_a;
  t3570 = t523 * t1078 * t207;
  t3573 = -0.8e1 * t731 * t511 * t1067 * t97 - 0.2e1 * t305 * t215 * t216 * t720 + 0.3e1 * t1082 * t1755 + 0.3e1 * t1100 * t1747 + 0.3e1 * t1103 * t1733 - 0.2e1 * t1103 * t2766 + 0.3e1 * t1113 * t1936 + 0.12e2 * t3438 * t2718 - 0.12e2 * t3443 * t2718 - 0.6e1 * t2748 * t3558 - 0.6e1 * t3443 * t2778 - 0.6e1 * t2822 * t3570 + 0.2e1 * t293 * t3530 - t2691 + t2694 - t2716;
  t3575 = -t2731 + t2733 + t2742 + t2744 - t2787 - t2788 + t2791 - t2793 + t2846 - t2848 + t2866 + t2869 + t2870 + t2871 - t2874 - 0.4e1 * t1074 - t2885;
  t3577 = t1071 * t188;
  t3578 = t183 * t3577;
  t3589 = t298 * t298;
  t3590 = t95 * t3589;
  t3603 = -0.12e2 * t3578 * t2031 * t2004 * t298 + 0.2e1 * t183 * t3589 * t194 + 0.12e2 * t799 * t963 * t3199 - 0.12e2 * t3578 * t874 * t3384 - 0.2e1 * t3590 * t209 + 0.2e1 * t3590 * t211 - 0.4e1 * t1091 + 0.4e1 * t1096 - 0.4e1 * t1098 + 0.4e1 * t1101 + 0.4e1 * t1114 + t2905 - t2908 + t2927 - t2929 - t2932 + t2944;
  t3604 = t95 * t3464;
  t3612 = t1517 * t1078;
  t3620 = t102 * t720;
  t3630 = t1499 * t3556;
  t3634 = t3589 * t186;
  t3635 = t183 * t3634;
  t3643 = -t2945 - t2946 + 0.3e1 * t3604 * t2887 + 0.6e1 * t3447 * t2890 + 0.11e2 * t3449 * t1532 * t3468 + 0.6e1 * t2917 * t3612 + 0.3e1 * t183 * t3458 * t1667 - 0.2e1 * t1085 * t2909 + 0.2e1 * t293 * t198 * t3620 - 0.2e1 * t1072 * t852 * t3620 + 0.2e1 * t305 * t2332 - t1729 * t1079 + t2748 * t3630 - 0.3e1 * t1082 * t1539 - 0.2e1 * t3635 * t217 + 0.2e1 * t95 * t3634 * t200 - 0.2e1 * t3635 * t200;
  t3647 = my_piecewise5(t57, 0, t60, 0, t3407 + t3445 + t3491 + t3535 + t3573 + t3575 + t3603 + t3643);
  t3654 = my_piecewise3(t3, 0, -t8 * t159 * t391 / 0.3e2 + t8 * t78 * t1140 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (0.1e2 / 0.27e2 * t45 * t233 * t148 - 0.5e1 / 0.18e2 * t45 * t116 * t309 + t45 * t137 * t806 / 0.12e2 + t177 * t389 + 0.2e1 * t93 * t1138 + t52 * t3647));
  tv4rho2lapl20 = 0.2e1 * rho[0] * t3654 + 0.4e1 * t1145;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t3665 = t2688 * t434;
  t3666 = t429 * t3665;
  t3667 = t3666 * t992;
  t3669 = t1153 * t434;
  t3670 = t429 * t3669;
  t3671 = t512 * t186;
  t3672 = t3671 * t97;
  t3673 = t193 * t3672;
  t3676 = t328 * params->csk_a;
  t3677 = t3676 * t97;
  t3679 = t1005 * t193 * t3677;
  t3681 = t3666 * t1021;
  t3683 = t183 * t3665;
  t3684 = t3683 * t992;
  t3686 = t183 * t3669;
  t3689 = t1152 * t186;
  t3690 = t3689 * t434;
  t3691 = t429 * t3690;
  t3692 = t193 * t870;
  t3695 = t512 * t328;
  t3696 = t3695 * t97;
  t3697 = t103 * t3696;
  t3698 = t1994 * t3697;
  t3700 = t1921 * t3697;
  t3702 = t3666 * t996;
  t3704 = t1842 * t254;
  t3705 = t193 * t3704;
  t3709 = t95 * t3665 * t986;
  t3711 = -0.18e2 * t3670 * t3673 + 0.18e2 * t3686 * t3673 + 0.18e2 * t3691 * t3692 - 0.9e1 * t862 * t3705 - t330 - t332 - 0.9e1 * t3667 + 0.9e1 * t3679 - 0.3e1 * t3681 + 0.9e1 * t3684 - 0.3e1 * t3698 + 0.9e1 * t3700 - 0.6e1 * t3702 - 0.9e1 * t3709;
  t3712 = t3683 * t986;
  t3716 = t186 * params->csk_a * t97;
  t3717 = t103 * t3716;
  t3722 = t1842 * t2566;
  t3726 = t103 * t1690 * t254;
  t3730 = t3383 * t207;
  t3731 = t103 * t3730;
  t3739 = t243 * t434;
  t3740 = t429 * t3739;
  t3741 = t1153 * params->csk_a;
  t3745 = t439 * t3672;
  t3748 = t1165 * t207;
  t3750 = t2006 * t193 * t3748;
  t3753 = t2592 * t103 * t964;
  t3757 = t1986 * t439 * t3676 * t126;
  t3759 = t1152 * t1493;
  t3760 = t1491 * t3759;
  t3761 = t1507 * t991;
  t3764 = 0.18e2 * t183 * t3690 * t3731 - 0.18e2 * t95 * t3669 * t3717 - 0.6e1 * t95 * t3690 * t3731 + 0.18e2 * t3740 * t439 * t3741 - 0.12e2 * t3670 * t3745 + 0.18e2 * t3686 * t3717 - 0.6e1 * t3691 * t3731 - 0.9e1 * t862 * t3722 + 0.9e1 * t869 * t3726 - 0.7e1 * t3760 * t3761 + 0.9e1 * t3712 + 0.9e1 * t3750 + 0.9e1 * t3753 + 0.9e1 * t3757;
  t3766 = t1532 * t904;
  t3770 = t1517 * t1518 * t97;
  t3774 = t198 * t502 * t254;
  t3777 = t192 * t1152;
  t3782 = t95 * t3759;
  t3783 = t1614 * t250;
  t3786 = t183 * t3759;
  t3789 = t429 * t3759;
  t3794 = t1517 * t923;
  t3798 = t1614 * t1615 * t97;
  t3805 = t1532 * t265;
  t3808 = -0.18e2 * t244 * t507 * t3777 * t207 + 0.7e1 * t3760 * t3766 - 0.12e2 * t3760 * t3770 - 0.6e1 * t3760 * t3794 - t3760 * t3798 - 0.7e1 * t3786 * t3761 + 0.18e2 * t3789 * t3761 + 0.9e1 * t909 * t3774 + 0.11e2 * t3782 * t3783 + t3782 * t3798 - 0.11e2 * t3786 * t3783 - 0.7e1 * t3786 * t3798 + 0.6e1 * t3789 * t3798 - 0.18e2 * t3789 * t3805;
  t3812 = t523 * t538 * t254;
  t3815 = t1152 * t1572;
  t3816 = t183 * t3815;
  t3819 = t1152 * t97;
  t3826 = t1614 * t513 * t97;
  t3835 = t1517 * t896;
  t3838 = t2689 * t1033;
  t3841 = t511 * t1568 * t97;
  t3846 = t2121 * t507 * t844 * t126;
  t3848 = t885 * t893;
  t3850 = t485 * t2566;
  t3853 = 0.3e1 * t95 * t3819 * t2077 - 0.12e2 * t1154 * t3841 - 0.3e1 * t3816 * t251 - 0.3e1 * t3816 * t266 - 0.11e2 * t3786 * t3766 + 0.12e2 * t3789 * t3770 + 0.6e1 * t3782 * t3826 - 0.18e2 * t3786 * t3826 + 0.6e1 * t3789 * t3826 - 0.6e1 * t3789 * t3835 - 0.6e1 * t878 * t3812 + 0.9e1 * t832 * t3850 - 0.6e1 * t3838 - 0.9e1 * t3846 - 0.3e1 * t3848;
  t3857 = t511 * t513 * t254;
  t3864 = t97 * t1493;
  t3865 = t1491 * t3864;
  t3866 = t1501 * t1152;
  t3872 = t507 * t528 * t254;
  t3882 = t1499 * t1503 * t97;
  t3887 = t438 * t1152;
  t3889 = t1517 * t3887 * t512;
  t3894 = t840 * t523 * t596 * t328;
  t3902 = 0.11e2 * t3865 * t1499 * t3866 * t512 - 0.6e1 * t3865 * t1499 * t3866 * params->csk_a + 0.9e1 * t918 * t2113 + 0.9e1 * t878 * t2134 + 0.9e1 * t878 * t2180 - 0.6e1 * t3760 * t3882 + 0.7e1 * t3786 * t3805 - 0.3e1 * t828 * t3857 + 0.9e1 * t832 * t3857 - 0.3e1 * t878 * t3857 + 0.18e2 * t3865 * t3889 + 0.9e1 * t832 * t3872 - 0.9e1 * t878 * t3872 - 0.3e1 * t3894;
  t3910 = t602 * t1211;
  t3914 = t885 * t901;
  t3916 = 0.6e1 * t1167;
  t3917 = -0.6e1 * t429 * t243 * t523 * t3887 * t207 - 0.12e2 * t3789 * t3794 - 0.9e1 * t828 * t3850 + t1151 + t1156 + t1160 + t1172 + 0.3e1 * t3910 - 0.3e1 * t3914 - t3916 + t826 + t846 - t849 - t856;
  t3919 = t2031 * t964;
  t3920 = t2589 * t3919;
  t3922 = t847 * t207;
  t3923 = t963 * t3922;
  t3924 = t647 * t3923;
  t3927 = t183 * t3748 * t960;
  t3929 = -0.9e1 * t3920 + 0.9e1 * t3924 - 0.9e1 * t3927 - t865 + t872 - t876 - t1199 - t1202 + t1205 - t1207 - t1209 + t1213 + t883 - t886;
  t3935 = t429 * t3864;
  t3941 = t95 * t328 * t254 * t209;
  t3943 = t609 * t845;
  t3947 = t825 * t857;
  t3949 = t511 * t853;
  t3952 = t183 * t3864;
  t3961 = t1614 * t260;
  t3964 = t3865 * t1499 * t3866 + 0.6e1 * t3935 * t1517 * t3887 + 0.11e2 * t3952 * t1532 * t3777 + 0.3e1 * t183 * t3819 * t1667 + 0.3e1 * t95 * t3815 * t261 - 0.3e1 * t878 * t1854 - 0.9e1 * t832 * t1889 + 0.6e1 * t3782 * t3961 - 0.6e1 * t828 * t3949 - 0.3e1 * t3941 + 0.3e1 * t3943 + 0.3e1 * t3947 - t908 + t912 + t921;
  t3968 = my_piecewise5(t57, 0, t60, 0, t3711 + t3764 + t3808 + t3853 + t3902 + t3917 + t3929 + t3964);
  t3975 = my_piecewise3(t3, 0, t8 * t78 * t1218 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (t93 * t1216 + 0.3e1 * t123 * t935 + 0.3e1 * t239 * t338 + t52 * t3968));
  tv4rhosigma30 = 0.2e1 * rho[0] * t3975 + 0.2e1 * t1222;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t3992 = t983 * t3697;
  t3993 = t1012 * t3697;
  t3996 = t1502 * t321 * t97;
  t3997 = t193 * t3996;
  t4000 = t989 * t3697;
  t4001 = t2672 * t1497;
  t4002 = t1491 * t4001;
  t4005 = t512 * t321;
  t4006 = t4005 * t880;
  t4015 = t193 * t3696;
  t4016 = t1012 * t4015;
  t4018 = t439 * t3996;
  t4027 = t989 * t4015;
  t4029 = t4005 * t97;
  t4033 = t103 * t3677;
  t4034 = t983 * t4033;
  t4036 = 0.7e1 * t4002 * t193 * t3052 * t97 - 0.6e1 * t3062 * t439 * t4029 - 0.6e1 * t4002 * t1008 - 0.7e1 * t3045 * t3997 + 0.6e1 * t3057 * t4006 + 0.18e2 * t3062 * t3997 + 0.6e1 * t3062 * t4006 + 0.12e2 * t3062 * t4018 - 0.7e1 * t3069 * t3997 - 0.18e2 * t3069 * t4006 - t330 - t3992 + 0.3e1 * t3993 - t4000 + 0.3e1 * t4016 - 0.3e1 * t4027 - 0.3e1 * t4034 - t961 + t966 - t970;
  t4037 = t103 * t3996;
  t4044 = t3864 * t1497;
  t4045 = t1491 * t4044;
  t4046 = t3052 * t321;
  t4054 = t990 * t193 * t254;
  t4057 = t298 * t321;
  t4059 = t183 * t4057 * t207;
  t4062 = t984 * t2566;
  t4066 = t1006 * t321;
  t4067 = t193 * t4066;
  t4072 = t1006 * t254;
  t4080 = t799 * t103 * t3922;
  t4082 = t2589 * t1001;
  t4089 = t1006 * t328;
  t4090 = t193 * t4089;
  t4091 = t1986 * t4090;
  t4098 = -0.6e1 * t2576 * t439 * t1000 + 0.6e1 * t1005 * t439 * t4072 - 0.6e1 * t3045 * t1654 * t3996 + 0.11e2 * t4045 * t1654 * t4046 - 0.6e1 * t4045 * t1654 * t4066 - 0.18e2 * t429 * t4044 * t4067 + 0.18e2 * t4045 * t439 * t4046 + 0.6e1 * t1012 * t4054 + 0.6e1 * t1012 * t4062 + 0.3e1 * t2381 * t1253 - 0.12e2 * t3045 * t4018 - t3045 * t4037 + t3057 * t4037 + 0.6e1 * t3062 * t4037 - 0.7e1 * t3069 * t4037 - 0.6e1 * t989 * t4054 - 0.3e1 * t4059 * t469 + 0.3e1 * t4080 + 0.3e1 * t4082 + 0.3e1 * t4091;
  t4100 = t439 * t4089;
  t4101 = t1986 * t4100;
  t4104 = t989 * t439 * t3696;
  t4110 = t990 * t2566;
  t4136 = t199 * t321;
  t4137 = t198 * t4136;
  t4141 = t103 * t1251 * t97;
  t4148 = t183 * t1246 * t1572;
  t4154 = t1012 * t4033;
  t4161 = 0.3e1 * t4101 - 0.2e1 * t4104 - 0.4e1 * t989 * t439 * t990 * t254 + 0.6e1 * t1012 * t4110 - 0.2e1 * t989 * t4110 + 0.6e1 * t1005 * t193 * t4072 - 0.6e1 * t983 * t4062 + 0.7e1 * t183 * t4044 * t4067 + 0.6e1 * t1015 * t3774 - 0.18e2 * t183 * t3739 * t193 * t1247 - 0.3e1 * t4059 * t461 + 0.6e1 * t999 * t193 * t2990 + 0.3e1 * t95 * t301 * t1572 * t4137 + 0.11e2 * t3057 * t4141 - 0.12e2 * t95 * t1247 * t3841 - 0.3e1 * t4148 * t266 - 0.11e2 * t3069 * t193 * t4029 + 0.3e1 * t4154 - 0.12e2 * t429 * t4001 * t1008 - 0.3e1 * t4148 * t251;
  t4181 = t731 * t511 * t1232 * t97;
  t4200 = 0.6e1 * t2684 * t1517 * t769 * t97 - 0.4e1 * t731 * t511 * t357 * t254 + 0.3e1 * t95 * t4057 * t625 - 0.3e1 * t2339 * t1260 + 0.3e1 * t2432 * t1260 + 0.3e1 * t878 * t2470 + 0.6e1 * t3712 + 0.6e1 * t3750 + 0.6e1 * t3753 + 0.6e1 * t3757 - 0.2e1 * t4181;
  t4205 = t507 * t289 * t328;
  t4206 = t2121 * t4205;
  t4209 = t523 * t2842 * t145;
  t4210 = t840 * t4209;
  t4218 = t728 * t1286;
  t4221 = t760 * t1211;
  t4224 = t728 * t1211;
  t4225 = t321 * t97;
  t4252 = -0.3e1 * t4206 - t4210 - 0.2e1 * t580 * t3276 + t3865 * t1499 * t2772 * t145 - 0.3e1 * t2290 * t1282 - t4218 - 0.2e1 * t2290 * t1289 + t4221 + 0.3e1 * t2432 * t1282 - t4224 + 0.3e1 * t183 * t4225 * t3250 + 0.3e1 * t1266 * t1662 * t880 + 0.6e1 * t2294 * t1614 * t1240 * t97 - t2290 * t1274 + 0.11e2 * t3952 * t1532 * t289 * t321 + 0.3e1 * t918 * t2494 - 0.6e1 * t606 * t507 * t289 * t254 + 0.3e1 * t878 * t2435 - t2339 * t1274 + 0.3e1 * t2432 * t1274;
  t4261 = t429 * t2283;
  t4263 = t4005 * t190 * t919;
  t4266 = t183 * t798;
  t4268 = t4266 * t2031 * t3922;
  t4270 = t439 * t512;
  t4271 = t4225 * t207;
  t4275 = -0.12e2 * t4261 * t4270 * t4271 - 0.18e2 * t4261 * t4263 - 0.4e1 * t1167 + t1229 + t1231 + t1234 + t1235 - t1316 - 0.3e1 * t4268 - t976 - t979;
  t4278 = t799 * t3923;
  t4290 = t581 * t186 * t880;
  t4312 = t4266 * t3923;
  t4320 = 0.3e1 * t4278 + 0.18e2 * t2384 * t4263 - 0.18e2 * t2284 * t963 * t4271 + 0.18e2 * t1248 * t485 * t186 * t880 + 0.18e2 * t1248 * t4290 - 0.6e1 * t429 * t1247 * t4290 - 0.6e1 * t2284 * t3328 * t4271 - 0.6e1 * t958 * t2241 * t2566 + 0.18e2 * t3740 * t3007 * t1252 + 0.6e1 * t799 * t963 * t850 * t254 - 0.6e1 * t958 * t968 * t3704 - 0.3e1 * t4312 + 0.18e2 * t2576 * t2996 * t870 - 0.6e1 * t3920 + 0.6e1 * t3924 - 0.6e1 * t3927 - t1250 + t1255 - t1257 + t1002;
  t4328 = t95 * t298 * t328 * t209;
  t4333 = t760 * t1233;
  t4334 = t885 * t766;
  t4335 = -0.2e1 * t2339 * t1241 - 0.3e1 * t832 * t2313 - t878 * t2325 - 0.2e1 * t3941 + 0.2e1 * t3943 + 0.2e1 * t3947 - t4328 + t4333 + t4334 - t886 - t908;
  t4340 = my_piecewise5(t57, 0, t60, 0, -0.11e2 * t3069 * t4141 - 0.2e1 * t983 * t4110 + t4335 + t4320 + t4275 + t4252 + t4200 + t4161 + t4098 + t4036 - 0.2e1 * t3914 + 0.2e1 * t3910 - 0.2e1 * t3894 - 0.6e1 * t3846 - 0.2e1 * t3848 - 0.4e1 * t3838 - 0.6e1 * t3709 - 0.4e1 * t3702 - 0.2e1 * t3698 + 0.6e1 * t3700 + 0.6e1 * t3684 + 0.6e1 * t3679 - 0.2e1 * t3681 - 0.6e1 * t3667 - t1295 - t1298 + t1299 + t1292 - t1287 - t1279 + t1268 + t1270 + t1016 + t883 + t846 - t849 + t826 - t356);
  t4347 = my_piecewise3(t3, 0, t8 * t78 * t1304 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.5e1 / 0.72e2 * t45 * t116 * t338 + t45 * t137 * t935 / 0.24e2 + 0.2e1 * t239 * t365 + 0.2e1 * t123 * t1047 + t93 * t1302 + t52 * t4340));
  tv4rhosigma2lapl0 = 0.2e1 * rho[0] * t4347 + 0.2e1 * t1308;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  t4362 = t3437 * t1497;
  t4363 = t429 * t4362;
  t4365 = t245 * t97;
  t4366 = t1502 * t190 * t4365;
  t4369 = t3046 * t97;
  t4370 = t439 * t4369;
  t4373 = t193 * t985;
  t4376 = t183 * t4362;
  t4381 = t1491 * t4362;
  t4386 = t376 * params->csk_a;
  t4391 = t95 * t4362;
  t4392 = t103 * t4369;
  t4406 = t245 * t298;
  t4407 = t3408 * t4406;
  t4411 = t183 * t3464 * t188;
  t4416 = -0.6e1 * t3051 * t439 * t4386 * t97 + 0.6e1 * t4266 * t193 * t2986 + 0.18e2 * t4363 * t4366 + 0.12e2 * t4363 * t4370 - 0.18e2 * t4363 * t4373 + 0.6e1 * t4363 * t4392 - 0.7e1 * t4376 * t4366 - 0.7e1 * t4381 * t4366 + 0.7e1 * t4376 * t4373 - 0.3e1 * t4411 * t4373 - 0.7e1 * t4376 * t4392 - 0.11e2 * t4376 * t986 - t4381 * t4392 + 0.7e1 * t4381 * t992 + t4391 * t4392 + 0.11e2 * t4391 * t986 - 0.6e1 * t989 * t4407 - 0.3e1 * t4411 * t986 - t330 - t383;
  t4417 = t376 * t97;
  t4424 = t95 * t3377;
  t4440 = t984 * t3384;
  t4443 = t990 * t298;
  t4444 = t103 * t4443;
  t4452 = t645 * t298;
  t4456 = t984 * t298;
  t4478 = t376 * t512 * t126;
  t4482 = 0.3e1 * t95 * t4417 * t1572 * t352 - 0.11e2 * t4376 * t992 - 0.12e2 * t4424 * t103 * t248 * t97 + 0.6e1 * t4391 * t1021 - 0.18e2 * t4376 * t1021 + 0.6e1 * t4363 * t1021 - 0.6e1 * t4363 * t996 - 0.18e2 * t3374 * t193 * t964 + 0.6e1 * t1012 * t4440 - 0.2e1 * t983 * t4444 + 0.6e1 * t1012 * t4444 - 0.2e1 * t989 * t4444 + 0.6e1 * t95 * t3577 * t103 * t4452 + 0.6e1 * t989 * t193 * t4456 - 0.6e1 * t3740 * t439 * t376 * t126 * t207 - 0.12e2 * t4363 * t439 * t985 + 0.6e1 * t989 * t439 * t4456 - 0.6e1 * t4045 * t1654 * t4386 * t126 + 0.6e1 * t1012 * t4407 + 0.18e2 * t4045 * t439 * t4478;
  t4515 = 0.11e2 * t4045 * t1654 * t4478 - 0.6e1 * t4381 * t1654 * t4369 - 0.4e1 * t989 * t439 * t4443 - 0.3e1 * t1090 * t3705 - 0.3e1 * t1090 * t3722 + 0.3e1 * t1095 * t3726 - 0.12e2 * t4381 * t4370 - 0.6e1 * t983 * t4440 - 0.2e1 * t3992 + 0.6e1 * t3993 - 0.2e1 * t4000 + 0.6e1 * t4016 - 0.6e1 * t4027 - 0.6e1 * t4034 + 0.6e1 * t4080 + 0.6e1 * t4082 + 0.6e1 * t4091 + 0.6e1 * t4101 - 0.4e1 * t4104 + 0.6e1 * t4154;
  t4546 = t3865 * t1499 * t1860 * t376 - 0.4e1 * t731 * t511 * t357 * t298 + 0.3e1 * t1082 * t3850 - 0.3e1 * t1085 * t3850 - t1085 * t3857 + 0.3e1 * t1103 * t2134 - t1103 * t3857 + 0.3e1 * t1113 * t3774 - 0.2e1 * t580 * t3502 + 0.3e1 * t3753 + 0.3e1 * t3757;
  t4590 = -0.2e1 * t1103 * t3812 + 0.3e1 * t1100 * t2113 - 0.6e1 * t724 * t507 * t4406 + 0.6e1 * t3935 * t1517 * t1078 * t126 + 0.3e1 * t1103 * t2180 + 0.3e1 * t1082 * t3872 - 0.3e1 * t1103 * t3872 + 0.3e1 * t3604 * t198 * t1032 + 0.6e1 * t3447 * t1614 * t1032 + 0.3e1 * t183 * t4417 * t1662 * t1354 + 0.11e2 * t3449 * t1532 * t4365 + 0.3e1 * t1082 * t3857 - 0.4e1 * t4181 - 0.6e1 * t4206 - 0.2e1 * t4210 - 0.2e1 * t4218 + 0.2e1 * t4221 - 0.2e1 * t4224 - 0.2e1 * t3838 - 0.3e1 * t3846;
  t4592 = t1348 * t3716;
  t4599 = t3328 * t964;
  t4606 = 0.18e2 * t3366 * t3919 - 0.6e1 * t3366 * t4599 - 0.6e1 * t3371 * t4599 + 0.18e2 * t3374 * t4599 + 0.18e2 * t3378 * t4592 - 0.18e2 * t4424 * t4592 - t1075 + t1150 + t1171 - t1230 - 0.4e1 * t1239 + t1314 + t1315 - t3848 - t3894 + t3910 - t3914 + t826 + t846 - t849;
  t4608 = t3022 * t964;
  t4635 = 0.18e2 * t3366 * t439 * t126 * t870 - 0.6e1 * t3578 * t1323 * t3384 - 0.6e1 * t3578 * t2031 * t4452 + 0.6e1 * t799 * t963 * t2986 - 0.12e2 * t3366 * t4270 * t964 - 0.18e2 * t3366 * t4608 + 0.18e2 * t3374 * t4608 - t1091 + t1096 - t1098 - t1326 - t1329 + t1333 + t1337 - 0.3e1 * t3920 + 0.3e1 * t3924 - 0.3e1 * t3927 - 0.6e1 * t4268 + 0.6e1 * t4278 - 0.6e1 * t4312;
  t4645 = -t2052 * t1079 - 0.3e1 * t1082 * t1889 - 0.2e1 * t1085 * t3949 - t3941 + t3943 + t3947 - 0.2e1 * t4328 + 0.2e1 * t4333 + 0.2e1 * t4334 - t886 - t908;
  t4650 = my_piecewise5(t57, 0, t60, 0, t4645 + t4635 + t4606 + t4590 + t4546 + t4515 + t4482 + t4416 + 0.3e1 * t3750 + 0.3e1 * t3712 - 0.3e1 * t3709 - 0.2e1 * t3702 - t3698 + 0.3e1 * t3700 + 0.3e1 * t3684 + 0.3e1 * t3679 - t3681 - 0.3e1 * t3667 - t1368 + t1369 - t1370 + t1363 + t1212 - t1206 - t1198 + t1114 + t1101 + t883);
  t4657 = my_piecewise3(t3, 0, t8 * t78 * t1375 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.5e1 / 0.36e2 * t45 * t116 * t365 + t45 * t137 * t1047 / 0.12e2 + t239 * t389 + t123 * t1138 + t93 * t1373 + t52 * t4650));
  tv4rhosigmalapl20 = 0.2e1 * rho[0] * t4657 + 0.2e1 * t1379;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  t4670 = t1392 * t434;
  t4671 = t183 * t4670;
  t4674 = t429 * t4670;
  t4677 = t1387 * t186;
  t4678 = t4677 * t434;
  t4679 = t183 * t4678;
  t4682 = t429 * t4678;
  t4685 = t95 * t4678;
  t4693 = t439 * t1392 * params->csk_a;
  t4709 = 0.9e1 * t1095 * t103 * t1690 * t298 - 0.9e1 * t1090 * t193 * t1842 * t298 + 0.18e2 * t4679 * t193 * t3730 - 0.18e2 * t4674 * t3673 + 0.18e2 * t4682 * t3692 + 0.18e2 * t4671 * t3717 + 0.18e2 * t4679 * t3731 - 0.6e1 * t4682 * t3731 - 0.6e1 * t4685 * t3731 + 0.18e2 * t3740 * t4693 - 0.12e2 * t4674 * t3745 - 0.18e2 * t4685 * t871 - t330 - t383;
  t4725 = t1387 * t1493;
  t4726 = t429 * t4725;
  t4729 = -0.9e1 * t1090 * t1842 * t3384 - 0.18e2 * t4726 * t3805 - 0.3e1 * t3992 + 0.9e1 * t3993 - 0.3e1 * t4000 + 0.9e1 * t4016 - 0.9e1 * t4027 - 0.9e1 * t4034 + 0.9e1 * t4080 + 0.9e1 * t4082 + 0.9e1 * t4091 + 0.9e1 * t4101 - 0.6e1 * t4104 + 0.9e1 * t4154;
  t4735 = t183 * t4725;
  t4738 = t95 * t4725;
  t4744 = t1491 * t4725;
  t4760 = t192 * t1387;
  t4762 = t507 * t4760 * t207;
  t4765 = 0.9e1 * t1113 * t198 * t502 * t298 - 0.18e2 * t244 * t4762 + 0.18e2 * t4726 * t3761 - 0.7e1 * t4735 * t3761 - 0.7e1 * t4744 * t3761 + 0.7e1 * t4744 * t3766 + 0.12e2 * t4726 * t3770 - 0.6e1 * t4744 * t3794 + 0.6e1 * t4726 * t3798 - 0.7e1 * t4735 * t3798 + t4738 * t3798 - t4744 * t3798 - 0.18e2 * t4735 * t3826 + 0.6e1 * t4738 * t3826;
  t4768 = t511 * t1107;
  t4772 = t1532 * t4760 * params->csk_a;
  t4777 = t429 * t4677;
  t4778 = t438 * t97;
  t4787 = t1387 * t1572;
  t4788 = t183 * t4787;
  t4801 = t1387 * t97;
  t4809 = -0.6e1 * t4744 * t1499 * t1548 * t97 - 0.6e1 * t4777 * t523 * t4778 * t207 + 0.3e1 * t95 * t4801 * t2077 - 0.9e1 * t1085 * t4768 + 0.9e1 * t1100 * t2494 - 0.12e2 * t1393 * t3841 - 0.3e1 * t4788 * t251 - 0.3e1 * t4788 * t266 - 0.11e2 * t4735 * t3766 - 0.11e2 * t4735 * t3783 + 0.11e2 * t4738 * t3783 - 0.12e2 * t4726 * t3794 + 0.6e1 * t4726 * t3826 - 0.6e1 * t4726 * t3835 + 0.7e1 * t3952 * t4772;
  t4814 = t581 * t3384;
  t4820 = t507 * t528 * t298;
  t4831 = t1517 * t438 * t1387 * t512;
  t4840 = t1501 * t1387;
  t4842 = t1499 * t4840 * t512;
  t4850 = -0.6e1 * t1103 * t523 * t538 * t298 + 0.9e1 * t1082 * t4768 + 0.9e1 * t1082 * t4814 + 0.9e1 * t1082 * t4820 - 0.3e1 * t1085 * t4814 + 0.9e1 * t1103 * t2435 + 0.9e1 * t1103 * t2470 - 0.3e1 * t1103 * t4814 - 0.9e1 * t1103 * t4820 - 0.12e2 * t4744 * t3770 + 0.18e2 * t3865 * t4831 + 0.11e2 * t3865 * t4842 - 0.6e1 * t4744 * t3882 - 0.6e1 * t4181;
  t4856 = 0.6e1 * t1239;
  t4857 = -0.9e1 * t4206 - 0.3e1 * t4210 - 0.3e1 * t4218 + 0.3e1 * t4221 - 0.3e1 * t4224 + t826 + t846 - t849 - t1075 + t1384 + t1385 - t4856 + t1395 + t1399;
  t4862 = -0.9e1 * t4268 + 0.9e1 * t4278 - 0.9e1 * t4312 - t1091 + t1096 - t1098 - t1429 + t1432 - t1434 - t1435 + t1436 - t1437 + t1101 + t1114;
  t4866 = t1532 * t4760;
  t4871 = t95 * t4787;
  t4884 = t1499 * t4840;
  t4889 = -0.6e1 * t1085 * t511 * t1067 + 0.6e1 * t4726 * t1517 * t4778 + 0.3e1 * t183 * t4801 * t1667 - 0.9e1 * t1082 * t2313 - 0.3e1 * t1103 * t2325 + 0.3e1 * t4871 * t261 + t3865 * t4884 + 0.11e2 * t3952 * t4866 + 0.6e1 * t4738 * t3961 - 0.3e1 * t4328 + 0.3e1 * t4333 + 0.3e1 * t4334 + t883 - t886 - t908;
  t4893 = my_piecewise5(t57, 0, t60, 0, t4709 + t4729 + t4765 + t4809 + t4850 + t4857 + t4862 + t4889);
  t4900 = my_piecewise3(t3, 0, t8 * t78 * t1442 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.5e1 / 0.24e2 * t45 * t116 * t389 + t45 * t137 * t1138 / 0.8e1 + t93 * t1440 + t52 * t4893));
  tv4rholapl30 = 0.2e1 * rho[0] * t4900 + 0.2e1 * t1446;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rhotau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t4905 = t193 * t1252;
  t4906 = t2589 * t4905;
  t4909 = t103 * t3676 * t207;
  t4910 = t869 * t4909;
  t4915 = t183 * t328 * t321 * t207 * t469;
  t4917 = t2692 * t1282;
  t4919 = t321 * t321;
  t4920 = t4919 * t207;
  t4921 = t183 * t4920;
  t4924 = t4919 * t186;
  t4925 = t429 * t4924;
  t4929 = t511 * t513 * t328;
  t4930 = t828 * t4929;
  t4932 = t832 * t4929;
  t4935 = t878 * t2789;
  t4937 = t2689 * t1260;
  t4939 = t2692 * t1260;
  t4941 = t95 * t4920;
  t4946 = t2715 * t1282;
  t4948 = t429 * t4920;
  t4951 = t878 * t4929;
  t4953 = t2715 * t1289;
  t4959 = 0.18e2 * t4921 * t1711 - 0.18e2 * t4941 * t1711 - 0.12e2 * t4948 * t1739 + 0.18e2 * t4925 * t1751 - 0.18e2 * t4948 * t1764 + 0.18e2 * t4935 - 0.18e2 * t4937 + 0.18e2 * t4939 - 0.18e2 * t4946 - 0.6e1 * t4951 - 0.12e2 * t4953;
  t4961 = t918 * t2864;
  t4963 = t878 * t2844;
  t4968 = t183 * t4924;
  t4975 = t2867 * t198 * t1240 * t207;
  t4983 = t183 * t4919;
  t4991 = t328 * t328;
  t4992 = t95 * t4991;
  t4994 = 0.3e1 * t4992 * t209;
  t4997 = 0.3e1 * t183 * t4991 * t194;
  t4999 = 0.3e1 * t4992 * t211;
  t5000 = t95 * t4919;
  t5008 = t1491 * t4919 * t1655 + 0.6e1 * t429 * t4919 * t1674 + 0.6e1 * t5000 * t1658 + 0.3e1 * t5000 * t1663 + 0.3e1 * t4983 * t1667 + 0.11e2 * t4983 * t1670 + 0.4e1 * t1171 - 0.4e1 * t1198 - t4994 + t4997 + t4999;
  t5016 = t4919 * t1572;
  t5017 = t183 * t5016;
  t5023 = t4919 * t1493;
  t5024 = t183 * t5023;
  t5027 = t95 * t5023;
  t5033 = t429 * t5023;
  t5040 = t2689 * t1241;
  t5044 = t1491 * t5023;
  t5047 = t878 * t2928;
  t5057 = -0.6e1 * t5033 * t1524 + 0.18e2 * t5044 * t1524 + 0.7e1 * t5024 * t1533 - 0.6e1 * t5044 * t1549 - 0.12e2 * t4941 * t1569 - 0.18e2 * t4968 * t1591 - 0.6e1 * t4925 * t1605 + 0.6e1 * t5033 * t1626 - 0.3e1 * t5017 * t217 - 0.12e2 * t5040 - 0.6e1 * t5047;
  t5065 = t832 * t2906;
  t5071 = t4991 * t186;
  t5072 = t183 * t5071;
  t5074 = 0.3e1 * t5072 * t200;
  t5077 = 0.3e1 * t95 * t5071 * t200;
  t5079 = 0.3e1 * t5072 * t217;
  t5103 = -0.7e1 * t5024 * t1508 + 0.18e2 * t5033 * t1508 - 0.7e1 * t5044 * t1508 + 0.12e2 * t5033 * t1519 - 0.12e2 * t5044 * t1519 + 0.7e1 * t5044 * t1536 - 0.7e1 * t5024 * t1616 + t5027 * t1616 + 0.6e1 * t5033 * t1616 - t5044 * t1616 - 0.6e1 * t5044 * t1634;
  t5107 = my_piecewise5(t57, 0, t60, 0, 0.11e2 * t5027 * t1580 - 0.11e2 * t5024 * t1580 - 0.18e2 * t5033 * t1533 - 0.12e2 * t5033 * t1634 + 0.11e2 * t5044 * t1512 - 0.6e1 * t5044 * t1504 - 0.3e1 * t5017 * t200 - 0.11e2 * t5024 * t1536 + 0.6e1 * t5027 * t1626 - 0.18e2 * t5024 * t1626 + 0.18e2 * t4968 * t1719 - 0.6e1 * t4925 * t1719 + 0.18e2 * t4925 * t1759 + 0.18e2 * t4921 * t1764 - 0.6e1 * t95 * t4924 * t1719 + 0.3e1 * t95 * t5016 * t200 + t5103 - t5079 + t5077 - t5074 - 0.18e2 * t5065 + t5057 + t5008 + 0.18e2 * t4975 + 0.18e2 * t4961 + 0.18e2 * t4963 + t4959 - 0.6e1 * t4930 + 0.18e2 * t4932 - 0.18e2 * t4915 + 0.18e2 * t4917 + 0.18e2 * t4910 - 0.18e2 * t4906 + 0.4e1 * t1212 - 0.4e1 * t1208 + 0.4e1 * t1204 - 0.4e1 * t1206 - 0.4e1 * t1201 - 0.9e1 * t1167 + 0.4e1 * t1159 + 0.4e1 * t1155 + 0.4e1 * t1150 - t330 - t332);
  t5113 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (0.4e1 * t123 * t1216 + t52 * t5107));
  tv4sigma40 = 0.2e1 * rho[0] * t5113;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  t5120 = t3695 * t126;
  t5121 = t193 * t5120;
  t5122 = t1012 * t5121;
  t5123 = 0.9e1 * t5122;
  t5124 = t103 * t5120;
  t5125 = t983 * t5124;
  t5126 = 0.3e1 * t5125;
  t5127 = t1012 * t5124;
  t5128 = 0.9e1 * t5127;
  t5129 = t989 * t5124;
  t5130 = 0.3e1 * t5129;
  t5131 = t145 * t1152;
  t5132 = t5131 * t207;
  t5133 = t183 * t5132;
  t5139 = t512 * t1152;
  t5140 = t5139 * t207;
  t5144 = t3676 * t1348;
  t5145 = t1012 * t5144;
  t5146 = 0.9e1 * t5145;
  t5150 = t5139 * t193 * t207;
  t5156 = t983 * t5144;
  t5157 = 0.9e1 * t5156;
  t5158 = -0.6e1 * t2284 * t103 * t5140 - 0.6e1 * t429 * t5132 * t1698 - 0.12e2 * t4261 * t439 * t5140 + 0.18e2 * t5133 * t1698 + 0.18e2 * t3691 * t2254 - 0.18e2 * t4261 * t5150 - t330 + t5123 - t5126 + t5128 - t5130 + t5146 - t5157;
  t5164 = t799 * t103 * t3748;
  t5165 = 0.9e1 * t5164;
  t5167 = t2589 * t193 * t957;
  t5168 = 0.9e1 * t5167;
  t5169 = t1005 * t4090;
  t5170 = 0.9e1 * t5169;
  t5171 = t989 * t5121;
  t5172 = 0.9e1 * t5171;
  t5173 = t1005 * t4100;
  t5174 = 0.9e1 * t5173;
  t5176 = t989 * t439 * t5120;
  t5177 = 0.6e1 * t5176;
  t5188 = t1507 * t1152 * t190 * t192;
  t5191 = -0.18e2 * t2284 * t103 * t3741 + 0.18e2 * t5133 * t1711 + 0.18e2 * t3691 * t2268 + 0.18e2 * t2384 * t5150 + 0.18e2 * t2400 * t5188 - 0.9e1 * t4906 + 0.9e1 * t4910 - 0.9e1 * t4915 + t5165 + t5168 + t5170 - t5172 + t5174 - t5177;
  t5194 = t1517 * t1518 * t1152;
  t5203 = t1625 * t1152 * t67 * t102;
  t5211 = t1614 * t1615 * t1152;
  t5224 = 0.6e1 * t2294 * t5203 + t2294 * t5211 + 0.7e1 * t3760 * t2397 + 0.12e2 * t2400 * t5194 + 0.6e1 * t2400 * t5203 + 0.6e1 * t2400 * t5211 - 0.7e1 * t2413 * t5188 - 0.18e2 * t2413 * t5203 - 0.7e1 * t2413 * t5211 - 0.7e1 * t2423 * t5188 - t2423 * t5211 - 0.6e1 * t3760 * t2477 + 0.18e2 * t3760 * t2481;
  t5227 = t95 * t5131;
  t5231 = t1614 * t199 * t1152;
  t5236 = t183 * t5131;
  t5255 = -0.11e2 * t2413 * t1532 * t528 * t1152 - 0.12e2 * t5227 * t2027 - 0.3e1 * t5236 * t2032 + 0.3e1 * t5227 * t2077 - 0.3e1 * t5236 * t2077 + 0.11e2 * t2294 * t5231 - 0.6e1 * t2400 * t3889 - 0.11e2 * t2413 * t5231 - 0.12e2 * t2423 * t5194 - 0.12e2 * t3789 * t2477 + 0.9e1 * t4917 - 0.3e1 * t4930 + 0.9e1 * t4932 + 0.9e1 * t4935;
  t5267 = t606 * t4205;
  t5268 = 0.9e1 * t5267;
  t5269 = t580 * t4209;
  t5270 = 0.3e1 * t5269;
  t5279 = t731 * t511 * t1232 * t126;
  t5280 = 0.6e1 * t5279;
  t5287 = -0.6e1 * t2423 * t1499 * t1503 * t1152 - 0.18e2 * t183 * t3689 * t2408 - 0.6e1 * t429 * t3689 * t2499 + 0.7e1 * t3786 * t2442 - 0.18e2 * t3789 * t2442 + 0.11e2 * t3760 * t2464 - 0.6e1 * t3760 * t2474 - 0.9e1 * t4937 + 0.9e1 * t4939 - 0.9e1 * t4946 - t5268 - t5270 - t5280;
  t5294 = t4266 * t2031 * t3748;
  t5295 = 0.9e1 * t5294;
  t5296 = t963 * t3748;
  t5297 = t799 * t5296;
  t5298 = 0.9e1 * t5297;
  t5299 = -0.3e1 * t4951 - 0.6e1 * t4953 + 0.9e1 * t4961 + 0.9e1 * t4963 + 0.9e1 * t4975 - t356 + t1151 - t3916 + t1172 + t1234 + t1235 - t1386 - t5295 + t5298;
  t5301 = t4266 * t5296;
  t5302 = 0.9e1 * t5301;
  t5308 = -t5302 - t4994 + t4997 + t4999 - 0.4e1 * t1249 + 0.4e1 * t1254 - 0.4e1 * t1256 + 0.4e1 * t1267 + 0.4e1 * t1269 - t1199 - t1287 + t1292 - t1295;
  t5325 = 0.6e1 * t2294 * t1614 * t102 * t1152 + 0.3e1 * t5227 * t1663 + 0.6e1 * t3789 * t2316 + t3760 * t2329 + 0.11e2 * t3786 * t2342 + 0.3e1 * t3816 * t290 - t1207 + t1213 - 0.6e1 * t5040 - 0.3e1 * t5047 - 0.9e1 * t5065 - t5074 + t5077 - t5079;
  t5329 = my_piecewise5(t57, 0, t60, 0, t5158 + t5191 + t5224 + t5255 + t5287 + t5299 + t5308 + t5325);
  t5335 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (t45 * t137 * t1216 / 0.24e2 + 0.3e1 * t123 * t1302 + t52 * t5329));
  tv4sigma3lapl0 = 0.2e1 * rho[0] * t5335;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  t5343 = t103 * t324 * params->csk_a;
  t5350 = t3408 * t2851;
  t5353 = t4005 * t207;
  t5359 = t103 * t5353;
  t5367 = t1090 * t3676 * t468;
  t5373 = -0.12e2 * t3366 * t439 * t5353 + 0.18e2 * t3366 * t2612 + 0.18e2 * t3366 * t4905 - 0.18e2 * t3366 * t5350 - 0.6e1 * t3366 * t5359 - 0.6e1 * t3371 * t5359 + 0.18e2 * t3374 * t5350 + 0.18e2 * t3374 * t5359 + 0.18e2 * t3378 * t5343 - 0.18e2 * t4424 * t5343 - t330 - t383 + 0.12e2 * t5122 - 0.4e1 * t5125 - 0.3e1 * t5367;
  t5376 = t1095 * t4909;
  t5380 = t1090 * t193 * t3676 * t99;
  t5395 = 0.7e1 * t3449 * t2801 - 0.3e1 * t4906 + 0.3e1 * t4910 - 0.3e1 * t4915 + 0.12e2 * t5127 - 0.4e1 * t5129 + 0.12e2 * t5145 - 0.12e2 * t5156 + 0.12e2 * t5164 + 0.12e2 * t5167 + 0.12e2 * t5169 - 0.12e2 * t5171 + 0.12e2 * t5173 - 0.8e1 * t5176 + 0.3e1 * t5376 - 0.3e1 * t5380;
  t5397 = t1614 * t4136;
  t5402 = t1507 * t1281;
  t5410 = t1517 * t1518 * t321;
  t5420 = t1614 * t1615 * t321;
  t5427 = t376 * t321;
  t5434 = t1614 * t1273;
  t5437 = 0.3e1 * t95 * t5427 * t2077 - 0.3e1 * t3465 * t215 * t2800 - 0.6e1 * t2729 * t3453 - 0.18e2 * t3438 * t2801 + 0.7e1 * t3443 * t2810 + 0.18e2 * t3438 * t5402 + 0.12e2 * t3438 * t5410 + 0.6e1 * t3438 * t5420 - 0.7e1 * t3443 * t5402 - t3443 * t5420 + 0.11e2 * t3447 * t5397 + t3447 * t5420 + 0.6e1 * t3447 * t5434 - 0.11e2 * t3449 * t5397 - 0.7e1 * t3449 * t5402 - 0.7e1 * t3449 * t5420;
  t5457 = t485 * t328 * t67 * t102;
  t5458 = t1082 * t5457;
  t5460 = t1085 * t5457;
  t5462 = t1103 * t2789;
  t5464 = t1085 * t4929;
  t5465 = t1082 * t4929;
  t5467 = t1103 * t4929;
  t5469 = t507 * t528 * t328;
  t5470 = t1082 * t5469;
  t5474 = t1113 * t198 * t1232 * t99;
  t5478 = -0.12e2 * t1113 * t511 * t1240 * t186 - 0.6e1 * t3438 * t1517 * t1288 - 0.11e2 * t3449 * t2810 - 0.18e2 * t385 * t2852 + 0.6e1 * t3438 * t5434 - 0.12e2 * t3443 * t5410 - 0.18e2 * t3449 * t5434 - 0.3e1 * t3465 * t4137 + 0.3e1 * t5458 - 0.3e1 * t5460 + 0.3e1 * t5462 - t5464 + 0.3e1 * t5465 - t5467 + 0.3e1 * t5470 + 0.3e1 * t5474;
  t5483 = t1103 * t523 * t538 * t328;
  t5493 = t1100 * t2864;
  t5500 = t1103 * t2844;
  t5504 = t1103 * t5469;
  t5514 = 0.18e2 * t2729 * t1517 * t1078 * t512 - 0.6e1 * t3443 * t1499 * t1503 * t321 + 0.11e2 * t2729 * t1499 * t3556 * t512 - 0.6e1 * t429 * t324 * t3570 - 0.6e1 * t2729 * t3558 - 0.12e2 * t3438 * t2750 + 0.3e1 * t4917 - t4930 + 0.3e1 * t4932 + 0.3e1 * t4935 - 0.12e2 * t5267 - 0.2e1 * t5483 + 0.3e1 * t5493 + 0.3e1 * t5500 - 0.3e1 * t5504;
  t5524 = -0.4e1 * t5269 - 0.8e1 * t5279 - 0.3e1 * t4937 + 0.3e1 * t4939 - 0.3e1 * t4946 - t4951 - 0.2e1 * t4953 + 0.3e1 * t4961 + 0.3e1 * t4963 + 0.3e1 * t4975 + t1229 - t1168 + t1231 + t1314 + t1315 - t4856;
  t5534 = -0.12e2 * t5294 + 0.12e2 * t5297 - 0.12e2 * t5301 - t4994 + t4997 + t4999 - 0.4e1 * t1325 - 0.4e1 * t1328 + 0.4e1 * t1332 + 0.4e1 * t1336 + 0.4e1 * t1362 - t1279 - t1368 + t1369 - t1370 - t1298;
  t5537 = t2715 * t1079;
  t5539 = t1082 * t2906;
  t5544 = t1085 * t511 * t1232;
  t5557 = 0.6e1 * t3447 * t1614 * t1240 + 0.3e1 * t3604 * t198 * t1240 + 0.3e1 * t183 * t5427 * t1667 + 0.6e1 * t2684 * t3612 + t2729 * t3630 + 0.11e2 * t3449 * t2912 + t1299 - 0.2e1 * t5040 - t5047 - 0.3e1 * t5065 - t5074 + t5077 - t5079 - t5537 - 0.3e1 * t5539 - 0.2e1 * t5544;
  t5561 = my_piecewise5(t57, 0, t60, 0, t5373 + t5395 + t5437 + t5478 + t5514 + t5524 + t5534 + t5557);
  t5567 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (t45 * t137 * t1302 / 0.12e2 + 0.2e1 * t123 * t1373 + t52 * t5561));
  tv4sigma2lapl20 = 0.2e1 * rho[0] * t5567;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  t5574 = t512 * t207 * t126;
  t5575 = t103 * t5574;
  t5585 = t3671 * t126;
  t5602 = 0.18e2 * t4671 * t984 * t1697 - 0.18e2 * t4674 * t193 * t5585 + 0.18e2 * t4679 * t193 * t5574 - 0.12e2 * t4674 * t439 * t5585 - 0.18e2 * t4685 * t1331 + 0.18e2 * t4682 * t1967 + 0.18e2 * t1976 * t4693 + 0.18e2 * t4679 * t5575 - 0.6e1 * t4682 * t5575 - 0.6e1 * t4685 * t5575 - t330 - t383 + t5123 - 0.9e1 * t5367;
  t5607 = -0.6e1 * t4744 * t2126 - t5126 + t5128 - t5130 + t5146 - t5157 + t5165 + t5168 + t5170 - t5172 + t5174 - t5177 + 0.9e1 * t5376 - 0.9e1 * t5380;
  t5611 = t1507 * t1354;
  t5615 = t1517 * t1518 * t126;
  t5621 = t1614 * t1615 * t126;
  t5628 = t1614 * t1341;
  t5639 = t1579 * t1348;
  t5642 = -0.18e2 * t4726 * t2062 + 0.7e1 * t4744 * t2072 - 0.12e2 * t4726 * t2126 + 0.18e2 * t4726 * t5611 + 0.12e2 * t4726 * t5615 + 0.6e1 * t4726 * t5621 - 0.7e1 * t4735 * t5611 - 0.7e1 * t4735 * t5621 - 0.18e2 * t4735 * t5628 - 0.11e2 * t4735 * t5639 + t4738 * t5621 + 0.6e1 * t4738 * t5628 - 0.7e1 * t4744 * t5611 - t4744 * t5621;
  t5653 = t1387 * t126;
  t5677 = -0.12e2 * t1393 * t511 * t1568 * t126 - 0.6e1 * t4744 * t1499 * t1503 * t126 + 0.3e1 * t95 * t5653 * t2077 + 0.18e2 * t2044 * t4831 + 0.11e2 * t2044 * t4842 - 0.6e1 * t4777 * t2118 - 0.6e1 * t4744 * t2184 - 0.6e1 * t4726 * t2189 - 0.18e2 * t263 * t4762 - 0.3e1 * t4788 * t352 - 0.3e1 * t4788 * t362 + 0.6e1 * t4726 * t5628 + 0.11e2 * t4738 * t5639 - 0.12e2 * t4744 * t5615;
  t5696 = 0.7e1 * t2059 * t4772 - 0.11e2 * t4735 * t2072 + 0.9e1 * t5458 - 0.9e1 * t5460 + 0.9e1 * t5462 - 0.3e1 * t5464 + 0.9e1 * t5465 - 0.3e1 * t5467 + 0.9e1 * t5470 + 0.9e1 * t5474 - 0.6e1 * t5483 + 0.9e1 * t5493 + 0.9e1 * t5500 - 0.9e1 * t5504;
  t5698 = -t5268 - t5270 - t5280 + t1150 - t1167 + t1171 + t1384 + t1385 - 0.8e1 * t1239 + t1395 + t1399 - t5295 + t5298 - t5302;
  t5700 = -t4994 + t4997 + t4999 - t1325 - t1328 + t1332 - t1429 + t1336 + t1432 - t1434 + t1362 - t1198 - t1435 + t1436;
  t5717 = 0.6e1 * t4738 * t1614 * t357 + 0.3e1 * t183 * t5653 * t1667 + 0.6e1 * t4726 * t1893 + t2044 * t4884 + 0.11e2 * t2059 * t4866 + 0.3e1 * t4871 * t358 - t1206 + t1212 - t1437 - t5074 + t5077 - t5079 - 0.3e1 * t5537 - 0.9e1 * t5539 - 0.6e1 * t5544;
  t5721 = my_piecewise5(t57, 0, t60, 0, t5602 + t5607 + t5642 + t5677 + t5696 + t5698 + t5700 + t5717);
  t5727 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (t45 * t137 * t1373 / 0.8e1 + t123 * t1440 + t52 * t5721));
  tv4sigmalapl30 = 0.2e1 * rho[0] * t5727;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmatau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  t5735 = t376 * t376;
  t5736 = t5735 * t186;
  t5737 = t429 * t5736;
  t5740 = t5735 * t207;
  t5744 = t429 * t5740;
  t5747 = t95 * t5736;
  t5750 = t183 * t5736;
  t5770 = -0.18e2 * t5747 * t1715 - 0.6e1 * t5737 * t1719 - 0.12e2 * t5744 * t1739 + 0.18e2 * t5737 * t1751 + 0.18e2 * t5750 * t1771 + 0.18e2 * t5458 - 0.18e2 * t5460 + 0.18e2 * t5462 - 0.6e1 * t5464 + 0.18e2 * t5465 - 0.6e1 * t5467;
  t5786 = t183 * t5735;
  t5789 = t95 * t5735;
  t5800 = t1491 * t5735 * t1655 + 0.6e1 * t429 * t5735 * t1674 + 0.6e1 * t5789 * t1658 + 0.3e1 * t5789 * t1663 + 0.3e1 * t5786 * t1667 + 0.11e2 * t5786 * t1670 + 0.4e1 * t1398 - 0.4e1 * t1428 - t4994 + t4997 + t4999;
  t5812 = t5735 * t1493;
  t5813 = t1491 * t5812;
  t5818 = t429 * t5812;
  t5821 = t183 * t5812;
  t5836 = -0.6e1 * t5813 * t1504 - 0.7e1 * t5813 * t1508 + 0.11e2 * t5813 * t1512 - 0.12e2 * t5813 * t1519 + 0.18e2 * t5813 * t1524 + 0.7e1 * t5821 * t1533 + 0.7e1 * t5813 * t1536 - 0.11e2 * t5821 * t1536 - 0.11e2 * t5821 * t1580 - 0.12e2 * t5818 * t1634 - 0.12e2 * t5544;
  t5846 = t5735 * t1572;
  t5847 = t183 * t5846;
  t5857 = t95 * t5812;
  t5884 = 0.18e2 * t5818 * t1508 - 0.7e1 * t5821 * t1508 + 0.12e2 * t5818 * t1519 - 0.18e2 * t5818 * t1533 - t5813 * t1616 + 0.6e1 * t5818 * t1616 - 0.7e1 * t5821 * t1616 + t5857 * t1616 - 0.18e2 * t5821 * t1626 + 0.6e1 * t5857 * t1626 - 0.6e1 * t5813 * t1634;
  t5888 = my_piecewise5(t57, 0, t60, 0, 0.18e2 * t5737 * t1759 - 0.18e2 * t5744 * t1764 - 0.6e1 * t5747 * t1719 + 0.18e2 * t5750 * t1719 - 0.18e2 * t5750 * t1591 - 0.6e1 * t5737 * t1605 + 0.6e1 * t5818 * t1626 - 0.3e1 * t5847 * t200 - 0.6e1 * t5818 * t1524 - 0.3e1 * t5847 * t217 + 0.11e2 * t5857 * t1580 - 0.6e1 * t5813 * t1549 + 0.18e2 * t183 * t5740 * t1711 + 0.3e1 * t95 * t5846 * t200 - 0.12e2 * t95 * t5740 * t1569 + t5884 + t5836 + t5800 + t5770 - 0.18e2 * t5539 - 0.6e1 * t5537 - 0.18e2 * t5504 + 0.18e2 * t5500 + 0.18e2 * t5493 - 0.12e2 * t5483 + 0.18e2 * t5474 + 0.18e2 * t5470 - 0.18e2 * t5380 + 0.18e2 * t5376 - 0.18e2 * t5367 - t5079 + t5077 - t5074 + 0.4e1 * t1431 - 0.4e1 * t1433 + 0.4e1 * t1394 - 0.4e1 * t1295 + 0.4e1 * t1292 - 0.4e1 * t1287 + 0.4e1 * t1235 - 0.9e1 * t1239 + 0.4e1 * t1234 - t383 - t330);
  t5894 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (t45 * t137 * t1440 / 0.6e1 + t52 * t5888));
  tv4lapl40 = 0.2e1 * rho[0] * t5894;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4tau40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t46, t47, t48, t52, t53, t55;
  double t59, t61, t62, t63, t64, t65, t66, t67;
  double t68, t69, t70, t71, t72, t73, t74, t75;
  double t76, t77, t79, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t94, t95, t96, t97;
  double t99, t102, t103, t107, t109, t113, t114, t115;
  double t116, t117, t118, t119, t120, t121, t122, t123;
  double t124, t125, t127, t131, tzk0;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t46 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43;
  t47 = params->csk_cp * t33;
  t48 = t37 * sigma[0];
  t52 = params->csk_cq * t33;
  t53 = t37 * lapl[0];
  t55 = 0.1e1 / t41 / rho[0];
  t59 = t47 * t48 * t43 / 0.24e2 + t52 * t53 * t55 / 0.24e2 - t46;
  t61 = log(0.1e1 - DBL_EPSILON);
  t62 = 0.1e1 / params->csk_a;
  t63 = pow(-t61, -t62);
  t64 = t59 < -t63;
  t65 = log(DBL_EPSILON);
  t66 = pow(-t65, -t62);
  t67 = -t66 < t59;
  t68 = my_piecewise3(t67, -t66, t59);
  t69 = -t63 < t68;
  t70 = my_piecewise3(t69, t68, -t63);
  t71 = fabs(t70);
  t72 = pow(t71, params->csk_a);
  t73 = 0.1e1 / t72;
  t74 = exp(-t73);
  t75 = 0.1e1 - t74;
  t76 = pow(t75, t62);
  t77 = my_piecewise5(t64, 0, t67, 1, t76);
  t79 = t59 * t77 + t46 + 0.1e1;
  t83 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t79);
  t84 = rho[1] <= p->dens_threshold;
  t85 = -t18;
  t87 = my_piecewise5(t16, t13, t12, t17, t85 * t9);
  t88 = 0.1e1 + t87;
  t89 = t88 <= p->zeta_threshold;
  t90 = POW_1_3(t88);
  t91 = t90 * t90;
  t93 = my_piecewise3(t89, t25, t91 * t88);
  t94 = t93 * t31;
  t95 = rho[1] * rho[1];
  t96 = POW_1_3(rho[1]);
  t97 = t96 * t96;
  t99 = 0.1e1 / t97 / t95;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t99;
  t103 = t37 * sigma[2];
  t107 = t37 * lapl[1];
  t109 = 0.1e1 / t97 / rho[1];
  t113 = t47 * t103 * t99 / 0.24e2 + t52 * t107 * t109 / 0.24e2 - t102;
  t114 = t113 < -t63;
  t115 = -t66 < t113;
  t116 = my_piecewise3(t115, -t66, t113);
  t117 = -t63 < t116;
  t118 = my_piecewise3(t117, t116, -t63);
  t119 = fabs(t118);
  t120 = pow(t119, params->csk_a);
  t121 = 0.1e1 / t120;
  t122 = exp(-t121);
  t123 = 0.1e1 - t122;
  t124 = pow(t123, t62);
  t125 = my_piecewise5(t114, 0, t115, 1, t124);
  t127 = t113 * t125 + t102 + 0.1e1;
  t131 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t127);
  tzk0 = t83 + t131;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t46, t47, t48, t52, t53, t55;
  double t59, t61, t62, t63, t64, t65, t66, t67;
  double t68, t69, t70, t71, t72, t73, t74, t75;
  double t76, t77, t79, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t94, t95, t96, t97;
  double t99, t102, t103, t107, t109, t113, t114, t115;
  double t116, t117, t118, t119, t120, t121, t122, t123;
  double t124, t125, t127, t131, tzk0;

  double t132, t133, t134, t136, t139, t140, t144, t145;
  double t148, t151, t154, t161, t163, t164, t165, t167;
  double t168, t170, t171, t172, t174, t176, t181, t182;
  double t184, t187, t188, t192, t195, t197, tvrho0, t201;
  double t204, t205, t210, t212, t215, t216, t222, t225;
  double t232, t234, t235, t236, t238, t239, t241, t242;
  double t243, t245, t247, t252, tvrho1, t256, t257, t260;
  double t262, t263, t266, t268, t272, tvsigma0, tvsigma1, t274;
  double t275, t278, t280, t281, t284, t286, t290, tvsigma2;
  double t291, t297, t298, t301, t303, t307, tvlapl0, t308;
  double t314, t315, t318, t320, t324, tvlapl1, tvtau0, tvtau1;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t46 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43;
  t47 = params->csk_cp * t33;
  t48 = t37 * sigma[0];
  t52 = params->csk_cq * t33;
  t53 = t37 * lapl[0];
  t55 = 0.1e1 / t41 / rho[0];
  t59 = t47 * t48 * t43 / 0.24e2 + t52 * t53 * t55 / 0.24e2 - t46;
  t61 = log(0.1e1 - DBL_EPSILON);
  t62 = 0.1e1 / params->csk_a;
  t63 = pow(-t61, -t62);
  t64 = t59 < -t63;
  t65 = log(DBL_EPSILON);
  t66 = pow(-t65, -t62);
  t67 = -t66 < t59;
  t68 = my_piecewise3(t67, -t66, t59);
  t69 = -t63 < t68;
  t70 = my_piecewise3(t69, t68, -t63);
  t71 = fabs(t70);
  t72 = pow(t71, params->csk_a);
  t73 = 0.1e1 / t72;
  t74 = exp(-t73);
  t75 = 0.1e1 - t74;
  t76 = pow(t75, t62);
  t77 = my_piecewise5(t64, 0, t67, 1, t76);
  t79 = t59 * t77 + t46 + 0.1e1;
  t83 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t79);
  t84 = rho[1] <= p->dens_threshold;
  t85 = -t18;
  t87 = my_piecewise5(t16, t13, t12, t17, t85 * t9);
  t88 = 0.1e1 + t87;
  t89 = t88 <= p->zeta_threshold;
  t90 = POW_1_3(t88);
  t91 = t90 * t90;
  t93 = my_piecewise3(t89, t25, t91 * t88);
  t94 = t93 * t31;
  t95 = rho[1] * rho[1];
  t96 = POW_1_3(rho[1]);
  t97 = t96 * t96;
  t99 = 0.1e1 / t97 / t95;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t99;
  t103 = t37 * sigma[2];
  t107 = t37 * lapl[1];
  t109 = 0.1e1 / t97 / rho[1];
  t113 = t47 * t103 * t99 / 0.24e2 + t52 * t107 * t109 / 0.24e2 - t102;
  t114 = t113 < -t63;
  t115 = -t66 < t113;
  t116 = my_piecewise3(t115, -t66, t113);
  t117 = -t63 < t116;
  t118 = my_piecewise3(t117, t116, -t63);
  t119 = fabs(t118);
  t120 = pow(t119, params->csk_a);
  t121 = 0.1e1 / t120;
  t122 = exp(-t121);
  t123 = 0.1e1 - t122;
  t124 = pow(t123, t62);
  t125 = my_piecewise5(t114, 0, t115, 1, t124);
  t127 = t113 * t125 + t102 + 0.1e1;
  t131 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t127);
  tzk0 = t83 + t131;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t132 = t8 * t8;
  t133 = 0.1e1 / t132;
  t134 = t18 * t133;
  t136 = my_piecewise5(t12, 0, t16, 0, t9 - t134);
  t139 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t136);
  t140 = t139 * t31;
  t144 = 0.1e1 / t30;
  t145 = t29 * t144;
  t148 = t7 * t145 * t79 / 0.1e2;
  t151 = 0.1e1 / t41 / t39 / rho[0];
  t154 = 0.5e1 / 0.27e2 * t38 * sigma[0] * t151;
  t161 = -t47 * t48 * t151 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t53 * t43 + t154;
  t163 = t76 * t73;
  t164 = my_piecewise3(t67, 0, t161);
  t165 = my_piecewise3(t69, t164, 0);
  t167 = fabs(t70) / t70;
  t168 = 0.1e1 / t71;
  t170 = 0.1e1 / t75;
  t171 = t74 * t170;
  t172 = t167 * t168 * t171;
  t174 = my_piecewise5(t64, 0, t67, 0, -t163 * t165 * t172);
  t176 = t161 * t77 + t174 * t59 - t154;
  t181 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t79 + t148 + 0.3e1 / 0.2e2 * t7 * t32 * t176);
  t182 = t85 * t133;
  t184 = my_piecewise5(t16, 0, t12, 0, -t9 - t182);
  t187 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t184);
  t188 = t187 * t31;
  t192 = t93 * t144;
  t195 = t7 * t192 * t127 / 0.1e2;
  t197 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t127 + t195);
  tvrho0 = t83 + t131 + t8 * (t181 + t197);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t201 = my_piecewise5(t12, 0, t16, 0, -t9 - t134);
  t204 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t201);
  t205 = t204 * t31;
  t210 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t79 + t148);
  t212 = my_piecewise5(t16, 0, t12, 0, t9 - t182);
  t215 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t212);
  t216 = t215 * t31;
  t222 = 0.1e1 / t97 / t95 / rho[1];
  t225 = 0.5e1 / 0.27e2 * t38 * sigma[2] * t222;
  t232 = -t47 * t103 * t222 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t107 * t99 + t225;
  t234 = t124 * t121;
  t235 = my_piecewise3(t115, 0, t232);
  t236 = my_piecewise3(t117, t235, 0);
  t238 = fabs(t118) / t118;
  t239 = 0.1e1 / t119;
  t241 = 0.1e1 / t123;
  t242 = t122 * t241;
  t243 = t238 * t239 * t242;
  t245 = my_piecewise5(t114, 0, t115, 0, -t234 * t236 * t243);
  t247 = t113 * t245 + t125 * t232 - t225;
  t252 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t127 + t195 + 0.3e1 / 0.2e2 * t7 * t94 * t247);
  tvrho1 = t83 + t131 + t8 * (t210 + t252);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t256 = 0.5e1 / 0.72e2 * t38 * t43;
  t257 = t37 * t43;
  t260 = t47 * t257 / 0.24e2 - t256;
  t262 = my_piecewise3(t67, 0, t260);
  t263 = my_piecewise3(t69, t262, 0);
  t266 = my_piecewise5(t64, 0, t67, 0, -t163 * t263 * t172);
  t268 = t260 * t77 + t266 * t59 + t256;
  t272 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t268);
  tvsigma0 = t8 * t272;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t274 = 0.5e1 / 0.72e2 * t38 * t99;
  t275 = t37 * t99;
  t278 = t47 * t275 / 0.24e2 - t274;
  t280 = my_piecewise3(t115, 0, t278);
  t281 = my_piecewise3(t117, t280, 0);
  t284 = my_piecewise5(t114, 0, t115, 0, -t234 * t281 * t243);
  t286 = t113 * t284 + t125 * t278 + t274;
  t290 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t286);
  tvsigma2 = t8 * t290;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t291 = t37 * t55;
  t297 = my_piecewise3(t67, 0, t52 * t291 / 0.24e2);
  t298 = my_piecewise3(t69, t297, 0);
  t301 = my_piecewise5(t64, 0, t67, 0, -t163 * t298 * t172);
  t303 = t52 * t291 * t77 / 0.24e2 + t59 * t301;
  t307 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t303);
  tvlapl0 = t8 * t307;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t308 = t37 * t109;
  t314 = my_piecewise3(t115, 0, t52 * t308 / 0.24e2);
  t315 = my_piecewise3(t117, t314, 0);
  t318 = my_piecewise5(t114, 0, t115, 0, -t234 * t315 * t243);
  t320 = t52 * t308 * t125 / 0.24e2 + t113 * t318;
  t324 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t320);
  tvlapl1 = t8 * t324;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t46, t47, t48, t52, t53, t55;
  double t59, t61, t62, t63, t64, t65, t66, t67;
  double t68, t69, t70, t71, t72, t73, t74, t75;
  double t76, t77, t79, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t94, t95, t96, t97;
  double t99, t102, t103, t107, t109, t113, t114, t115;
  double t116, t117, t118, t119, t120, t121, t122, t123;
  double t124, t125, t127, t131, tzk0;

  double t132, t133, t134, t136, t139, t140, t144, t145;
  double t148, t151, t154, t161, t163, t164, t165, t167;
  double t168, t170, t171, t172, t174, t176, t181, t182;
  double t184, t187, t188, t192, t195, t197, tvrho0, t201;
  double t204, t205, t210, t212, t215, t216, t222, t225;
  double t232, t234, t235, t236, t238, t239, t241, t242;
  double t243, t245, t247, t252, tvrho1, t256, t257, t260;
  double t262, t263, t266, t268, t272, tvsigma0, tvsigma1, t274;
  double t275, t278, t280, t281, t284, t286, t290, tvsigma2;
  double t291, t297, t298, t301, t303, t307, tvlapl0, t308;
  double t314, t315, t318, t320, t324, tvlapl1, tvtau0, tvtau1;

  double t327, t328, t331, t332, t333, t336, t340, t341;
  double t345, t347, t353, t354, t357, t359, t361, t363;
  double t366, t373, t377, t379, t380, t382, t383, t384;
  double t385, t386, t387, t388, t389, t390, t392, t394;
  double t395, t396, t398, t399, t402, t403, t405, t406;
  double t407, t409, t411, t412, t413, t416, t418, t423;
  double t424, t425, t428, t431, t435, t436, t440, t442;
  double t444, t447, t449, tv2rho20, t452, t456, t460, t461;
  double t465, t467, t475, t476, t480, t484, t485, t489;
  double t491, t498, t501, tv2rho21, t506, t511, t515, t516;
  double t522, t523, t528, t532, t533, t542, t544, t547;
  double t554, t558, t560, t561, t563, t564, t565, t566;
  double t567, t568, t569, t570, t571, t573, t575, t576;
  double t577, t579, t580, t583, t584, t586, t587, t588;
  double t590, t592, t593, t594, t597, t599, t604, tv2rho22;
  double t612, t614, t615, t618, t622, t623, t624, t625;
  double t627, t628, t629, t630, t632, t633, t636, t638;
  double t639, t640, t642, t644, t645, t648, t650, t655;
  double tv2rhosigma0, tv2rhosigma1, t662, t664, tv2rhosigma2, t670, tv2rhosigma3, tv2rhosigma4;
  double t676, t677, t680, t684, t685, t686, t687, t689;
  double t690, t692, t694, t695, t698, t700, t701, t702;
  double t704, t706, t707, t710, t712, t717, tv2rhosigma5, t724;
  double t732, t733, t735, t736, t740, t741, t744, t746;
  double t748, t752, t754, t759, tv2rholapl0, t766, t768, tv2rholapl1;
  double t774, tv2rholapl2, t786, t787, t789, t790, t794, t795;
  double t798, t800, t802, t806, t808, t813, tv2rholapl3, tv2rhotau0;
  double tv2rhotau1, tv2rhotau2, tv2rhotau3, t817, t820, t823, t824, t826;
  double t827, t828, t830, t834, t836, t840, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t843, t846, t849, t850, t852;
  double t853, t854, t856, t860, t862, t866, tv2sigma25, t872;
  double t873, t875, t876, t877, t878, t879, t882, t883;
  double t886, t888, t892, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4;
  double t898, t899, t901, t902, t903, t904, t905, t908;
  double t909, t912, t914, t918, tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2;
  double tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t922, t925, t926, t928, t929;
  double t931, t935, t937, t941, tv2lapl20, tv2lapl21, t945, t948;
  double t949, t951, t952, t954, t958, t960, t964, tv2lapl22;
  double tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20, tv2tau21, tv2tau22;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t46 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43;
  t47 = params->csk_cp * t33;
  t48 = t37 * sigma[0];
  t52 = params->csk_cq * t33;
  t53 = t37 * lapl[0];
  t55 = 0.1e1 / t41 / rho[0];
  t59 = t47 * t48 * t43 / 0.24e2 + t52 * t53 * t55 / 0.24e2 - t46;
  t61 = log(0.1e1 - DBL_EPSILON);
  t62 = 0.1e1 / params->csk_a;
  t63 = pow(-t61, -t62);
  t64 = t59 < -t63;
  t65 = log(DBL_EPSILON);
  t66 = pow(-t65, -t62);
  t67 = -t66 < t59;
  t68 = my_piecewise3(t67, -t66, t59);
  t69 = -t63 < t68;
  t70 = my_piecewise3(t69, t68, -t63);
  t71 = fabs(t70);
  t72 = pow(t71, params->csk_a);
  t73 = 0.1e1 / t72;
  t74 = exp(-t73);
  t75 = 0.1e1 - t74;
  t76 = pow(t75, t62);
  t77 = my_piecewise5(t64, 0, t67, 1, t76);
  t79 = t59 * t77 + t46 + 0.1e1;
  t83 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t79);
  t84 = rho[1] <= p->dens_threshold;
  t85 = -t18;
  t87 = my_piecewise5(t16, t13, t12, t17, t85 * t9);
  t88 = 0.1e1 + t87;
  t89 = t88 <= p->zeta_threshold;
  t90 = POW_1_3(t88);
  t91 = t90 * t90;
  t93 = my_piecewise3(t89, t25, t91 * t88);
  t94 = t93 * t31;
  t95 = rho[1] * rho[1];
  t96 = POW_1_3(rho[1]);
  t97 = t96 * t96;
  t99 = 0.1e1 / t97 / t95;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t99;
  t103 = t37 * sigma[2];
  t107 = t37 * lapl[1];
  t109 = 0.1e1 / t97 / rho[1];
  t113 = t47 * t103 * t99 / 0.24e2 + t52 * t107 * t109 / 0.24e2 - t102;
  t114 = t113 < -t63;
  t115 = -t66 < t113;
  t116 = my_piecewise3(t115, -t66, t113);
  t117 = -t63 < t116;
  t118 = my_piecewise3(t117, t116, -t63);
  t119 = fabs(t118);
  t120 = pow(t119, params->csk_a);
  t121 = 0.1e1 / t120;
  t122 = exp(-t121);
  t123 = 0.1e1 - t122;
  t124 = pow(t123, t62);
  t125 = my_piecewise5(t114, 0, t115, 1, t124);
  t127 = t113 * t125 + t102 + 0.1e1;
  t131 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t127);
  tzk0 = t83 + t131;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t132 = t8 * t8;
  t133 = 0.1e1 / t132;
  t134 = t18 * t133;
  t136 = my_piecewise5(t12, 0, t16, 0, t9 - t134);
  t139 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t136);
  t140 = t139 * t31;
  t144 = 0.1e1 / t30;
  t145 = t29 * t144;
  t148 = t7 * t145 * t79 / 0.1e2;
  t151 = 0.1e1 / t41 / t39 / rho[0];
  t154 = 0.5e1 / 0.27e2 * t38 * sigma[0] * t151;
  t161 = -t47 * t48 * t151 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t53 * t43 + t154;
  t163 = t76 * t73;
  t164 = my_piecewise3(t67, 0, t161);
  t165 = my_piecewise3(t69, t164, 0);
  t167 = fabs(t70) / t70;
  t168 = 0.1e1 / t71;
  t170 = 0.1e1 / t75;
  t171 = t74 * t170;
  t172 = t167 * t168 * t171;
  t174 = my_piecewise5(t64, 0, t67, 0, -t163 * t165 * t172);
  t176 = t161 * t77 + t174 * t59 - t154;
  t181 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t79 + t148 + 0.3e1 / 0.2e2 * t7 * t32 * t176);
  t182 = t85 * t133;
  t184 = my_piecewise5(t16, 0, t12, 0, -t9 - t182);
  t187 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t184);
  t188 = t187 * t31;
  t192 = t93 * t144;
  t195 = t7 * t192 * t127 / 0.1e2;
  t197 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t127 + t195);
  tvrho0 = t83 + t131 + t8 * (t181 + t197);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t201 = my_piecewise5(t12, 0, t16, 0, -t9 - t134);
  t204 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t201);
  t205 = t204 * t31;
  t210 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t79 + t148);
  t212 = my_piecewise5(t16, 0, t12, 0, t9 - t182);
  t215 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t212);
  t216 = t215 * t31;
  t222 = 0.1e1 / t97 / t95 / rho[1];
  t225 = 0.5e1 / 0.27e2 * t38 * sigma[2] * t222;
  t232 = -t47 * t103 * t222 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t107 * t99 + t225;
  t234 = t124 * t121;
  t235 = my_piecewise3(t115, 0, t232);
  t236 = my_piecewise3(t117, t235, 0);
  t238 = fabs(t118) / t118;
  t239 = 0.1e1 / t119;
  t241 = 0.1e1 / t123;
  t242 = t122 * t241;
  t243 = t238 * t239 * t242;
  t245 = my_piecewise5(t114, 0, t115, 0, -t234 * t236 * t243);
  t247 = t113 * t245 + t125 * t232 - t225;
  t252 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t127 + t195 + 0.3e1 / 0.2e2 * t7 * t94 * t247);
  tvrho1 = t83 + t131 + t8 * (t210 + t252);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t256 = 0.5e1 / 0.72e2 * t38 * t43;
  t257 = t37 * t43;
  t260 = t47 * t257 / 0.24e2 - t256;
  t262 = my_piecewise3(t67, 0, t260);
  t263 = my_piecewise3(t69, t262, 0);
  t266 = my_piecewise5(t64, 0, t67, 0, -t163 * t263 * t172);
  t268 = t260 * t77 + t266 * t59 + t256;
  t272 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t268);
  tvsigma0 = t8 * t272;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t274 = 0.5e1 / 0.72e2 * t38 * t99;
  t275 = t37 * t99;
  t278 = t47 * t275 / 0.24e2 - t274;
  t280 = my_piecewise3(t115, 0, t278);
  t281 = my_piecewise3(t117, t280, 0);
  t284 = my_piecewise5(t114, 0, t115, 0, -t234 * t281 * t243);
  t286 = t113 * t284 + t125 * t278 + t274;
  t290 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t286);
  tvsigma2 = t8 * t290;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t291 = t37 * t55;
  t297 = my_piecewise3(t67, 0, t52 * t291 / 0.24e2);
  t298 = my_piecewise3(t69, t297, 0);
  t301 = my_piecewise5(t64, 0, t67, 0, -t163 * t298 * t172);
  t303 = t52 * t291 * t77 / 0.24e2 + t59 * t301;
  t307 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t303);
  tvlapl0 = t8 * t307;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t308 = t37 * t109;
  t314 = my_piecewise3(t115, 0, t52 * t308 / 0.24e2);
  t315 = my_piecewise3(t117, t314, 0);
  t318 = my_piecewise5(t114, 0, t115, 0, -t234 * t315 * t243);
  t320 = t52 * t308 * t125 / 0.24e2 + t113 * t318;
  t324 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t320);
  tvlapl1 = t8 * t324;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t327 = 0.1e1 / t26;
  t328 = t136 * t136;
  t331 = t132 * t8;
  t332 = 0.1e1 / t331;
  t333 = t18 * t332;
  t336 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t133 + 0.2e1 * t333);
  t340 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t327 * t328 + 0.5e1 / 0.3e1 * t27 * t336);
  t341 = t340 * t31;
  t345 = t139 * t144;
  t347 = t7 * t345 * t79;
  t353 = 0.1e1 / t30 / t8;
  t354 = t29 * t353;
  t357 = t7 * t354 * t79 / 0.3e2;
  t359 = t7 * t145 * t176;
  t361 = t39 * t39;
  t363 = 0.1e1 / t41 / t361;
  t366 = 0.55e2 / 0.81e2 * t38 * sigma[0] * t363;
  t373 = 0.11e2 / 0.27e2 * t47 * t48 * t363 + 0.5e1 / 0.27e2 * t52 * t53 * t151 - t366;
  t377 = t72 * t72;
  t379 = t76 / t377;
  t380 = t165 * t165;
  t382 = t167 * t167;
  t383 = t71 * t71;
  t384 = 0.1e1 / t383;
  t385 = t382 * t384;
  t386 = t74 * t74;
  t387 = t75 * t75;
  t388 = 0.1e1 / t387;
  t389 = t386 * t388;
  t390 = t385 * t389;
  t392 = t380 * t382;
  t394 = t384 * t74;
  t395 = t170 * params->csk_a;
  t396 = t394 * t395;
  t398 = my_piecewise3(t67, 0, t373);
  t399 = my_piecewise3(t69, t398, 0);
  t402 = t163 * t380;
  t403 = 0.0;
  t405 = t403 * t168 * t171;
  t406 = t402 * t405;
  t407 = t385 * t171;
  t409 = t379 * t392;
  t411 = t384 * t386;
  t412 = t388 * params->csk_a;
  t413 = t411 * t412;
  t416 = my_piecewise5(t64, 0, t67, 0, -t163 * t172 * t399 + t163 * t392 * t396 + t379 * t380 * t390 - t396 * t409 + t402 * t407 - t409 * t413 - t406);
  t418 = 0.2e1 * t161 * t174 + t373 * t77 + t416 * t59 + t366;
  t423 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t79 + t347 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t176 - t357 + t359 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t418);
  t424 = 0.1e1 / t90;
  t425 = t184 * t184;
  t428 = t85 * t332;
  t431 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t133 + 0.2e1 * t428);
  t435 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t424 * t425 + 0.5e1 / 0.3e1 * t91 * t431);
  t436 = t435 * t31;
  t440 = t187 * t144;
  t442 = t7 * t440 * t127;
  t444 = t93 * t353;
  t447 = t7 * t444 * t127 / 0.3e2;
  t449 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t127 + t442 / 0.5e1 - t447);
  tv2rho20 = 0.2e1 * t181 + 0.2e1 * t197 + t8 * (t423 + t449);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t452 = t327 * t201;
  t456 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t333);
  t460 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t452 * t136 + 0.5e1 / 0.3e1 * t27 * t456);
  t461 = t460 * t31;
  t465 = t204 * t144;
  t467 = t7 * t465 * t79;
  t475 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t79 + t467 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t176 + t347 / 0.1e2 - t357 + t359 / 0.1e2);
  t476 = t424 * t212;
  t480 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t428);
  t484 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t476 * t184 + 0.5e1 / 0.3e1 * t91 * t480);
  t485 = t484 * t31;
  t489 = t215 * t144;
  t491 = t7 * t489 * t127;
  t498 = t7 * t192 * t247;
  t501 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t127 + t491 / 0.1e2 + t442 / 0.1e2 - t447 + 0.3e1 / 0.2e2 * t7 * t188 * t247 + t498 / 0.1e2);
  tv2rho21 = t181 + t197 + t210 + t252 + t8 * (t475 + t501);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t506 = t201 * t201;
  t511 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t133 + 0.2e1 * t333);
  t515 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t327 * t506 + 0.5e1 / 0.3e1 * t27 * t511);
  t516 = t515 * t31;
  t522 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t79 + t467 / 0.5e1 - t357);
  t523 = t212 * t212;
  t528 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t133 + 0.2e1 * t428);
  t532 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t424 * t523 + 0.5e1 / 0.3e1 * t91 * t528);
  t533 = t532 * t31;
  t542 = t95 * t95;
  t544 = 0.1e1 / t97 / t542;
  t547 = 0.55e2 / 0.81e2 * t38 * sigma[2] * t544;
  t554 = 0.11e2 / 0.27e2 * t47 * t103 * t544 + 0.5e1 / 0.27e2 * t52 * t107 * t222 - t547;
  t558 = t120 * t120;
  t560 = t124 / t558;
  t561 = t236 * t236;
  t563 = t238 * t238;
  t564 = t119 * t119;
  t565 = 0.1e1 / t564;
  t566 = t563 * t565;
  t567 = t122 * t122;
  t568 = t123 * t123;
  t569 = 0.1e1 / t568;
  t570 = t567 * t569;
  t571 = t566 * t570;
  t573 = t561 * t563;
  t575 = t565 * t122;
  t576 = t241 * params->csk_a;
  t577 = t575 * t576;
  t579 = my_piecewise3(t115, 0, t554);
  t580 = my_piecewise3(t117, t579, 0);
  t583 = t234 * t561;
  t584 = 0.0;
  t586 = t584 * t239 * t242;
  t587 = t583 * t586;
  t588 = t566 * t242;
  t590 = t560 * t573;
  t592 = t565 * t567;
  t593 = t569 * params->csk_a;
  t594 = t592 * t593;
  t597 = my_piecewise5(t114, 0, t115, 0, -t234 * t243 * t580 + t234 * t573 * t577 + t560 * t561 * t571 - t577 * t590 + t583 * t588 - t590 * t594 - t587);
  t599 = t113 * t597 + t125 * t554 + 0.2e1 * t232 * t245 + t547;
  t604 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t127 + t491 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t247 - t447 + t498 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t599);
  tv2rho22 = 0.2e1 * t210 + 0.2e1 * t252 + t8 * (t522 + t604);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t612 = t7 * t145 * t268 / 0.1e2;
  t614 = 0.5e1 / 0.27e2 * t38 * t151;
  t615 = t37 * t151;
  t618 = -t47 * t615 / 0.9e1 + t614;
  t622 = t165 * t382;
  t623 = t379 * t622;
  t624 = t388 * t263;
  t625 = t411 * t624;
  t627 = t263 * t382;
  t628 = t163 * t627;
  t629 = t395 * t165;
  t630 = t394 * t629;
  t632 = my_piecewise3(t67, 0, t618);
  t633 = my_piecewise3(t69, t632, 0);
  t636 = t263 * t165;
  t638 = t163 * t636 * t405;
  t639 = t170 * t165;
  t640 = t394 * t639;
  t642 = t379 * t627;
  t644 = t412 * t165;
  t645 = t411 * t644;
  t648 = my_piecewise5(t64, 0, t67, 0, -t163 * t172 * t633 + t623 * t625 + t628 * t630 + t628 * t640 - t630 * t642 - t642 * t645 - t638);
  t650 = t161 * t266 + t174 * t260 + t59 * t648 + t618 * t77 - t614;
  t655 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t268 + t612 + 0.3e1 / 0.2e2 * t7 * t32 * t650);
  tv2rhosigma0 = t655 * t8 + t272;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t662 = t7 * t192 * t286 / 0.1e2;
  t664 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t286 + t662);
  tv2rhosigma2 = t664 * t8 + t290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t670 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t268 + t612);
  tv2rhosigma3 = t670 * t8 + t272;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t676 = 0.5e1 / 0.27e2 * t38 * t222;
  t677 = t37 * t222;
  t680 = -t47 * t677 / 0.9e1 + t676;
  t684 = t236 * t563;
  t685 = t560 * t684;
  t686 = t569 * t281;
  t687 = t592 * t686;
  t689 = t281 * t563;
  t690 = t234 * t689;
  t692 = t575 * t576 * t236;
  t694 = my_piecewise3(t115, 0, t680);
  t695 = my_piecewise3(t117, t694, 0);
  t698 = t281 * t236;
  t700 = t234 * t698 * t586;
  t701 = t241 * t236;
  t702 = t575 * t701;
  t704 = t560 * t689;
  t706 = t593 * t236;
  t707 = t592 * t706;
  t710 = my_piecewise5(t114, 0, t115, 0, -t234 * t243 * t695 + t685 * t687 + t690 * t692 + t690 * t702 - t692 * t704 - t704 * t707 - t700);
  t712 = t113 * t710 + t125 * t680 + t232 * t284 + t245 * t278 - t676;
  t717 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t286 + t662 + 0.3e1 / 0.2e2 * t7 * t94 * t712);
  tv2rhosigma5 = t717 * t8 + t290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t724 = t7 * t145 * t303 / 0.1e2;
  t732 = t388 * t298;
  t733 = t411 * t732;
  t735 = t298 * t382;
  t736 = t163 * t735;
  t740 = my_piecewise3(t67, 0, -0.5e1 / 0.72e2 * t52 * t257);
  t741 = my_piecewise3(t69, t740, 0);
  t744 = t298 * t165;
  t746 = t163 * t744 * t405;
  t748 = t379 * t735;
  t752 = my_piecewise5(t64, 0, t67, 0, -t163 * t172 * t741 + t623 * t733 + t630 * t736 - t630 * t748 + t640 * t736 - t645 * t748 - t746);
  t754 = -0.5e1 / 0.72e2 * t52 * t257 * t77 + t52 * t291 * t174 / 0.24e2 + t161 * t301 + t59 * t752;
  t759 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t303 + t724 + 0.3e1 / 0.2e2 * t7 * t32 * t754);
  tv2rholapl0 = t759 * t8 + t307;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t766 = t7 * t192 * t320 / 0.1e2;
  t768 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t320 + t766);
  tv2rholapl1 = t768 * t8 + t324;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t774 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t303 + t724);
  tv2rholapl2 = t774 * t8 + t307;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t786 = t569 * t315;
  t787 = t592 * t786;
  t789 = t315 * t563;
  t790 = t234 * t789;
  t794 = my_piecewise3(t115, 0, -0.5e1 / 0.72e2 * t52 * t275);
  t795 = my_piecewise3(t117, t794, 0);
  t798 = t315 * t236;
  t800 = t234 * t798 * t586;
  t802 = t560 * t789;
  t806 = my_piecewise5(t114, 0, t115, 0, -t234 * t243 * t795 + t685 * t787 + t692 * t790 - t692 * t802 + t702 * t790 - t707 * t802 - t800);
  t808 = -0.5e1 / 0.72e2 * t52 * t275 * t125 + t52 * t308 * t245 / 0.24e2 + t232 * t318 + t113 * t806;
  t813 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t320 + t766 + 0.3e1 / 0.2e2 * t7 * t94 * t808);
  tv2rholapl3 = t8 * t813 + t324;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t817 = t263 * t263;
  t820 = t817 * t382;
  t823 = my_piecewise3(t67, 0, 0);
  t824 = my_piecewise3(t69, t823, 0);
  t826 = t163 * t824 * t172;
  t827 = t163 * t817;
  t828 = t827 * t405;
  t830 = t379 * t820;
  t834 = my_piecewise5(t64, 0, t67, 0, t163 * t396 * t820 + t379 * t390 * t817 - t396 * t830 + t407 * t827 - t413 * t830 - t826 - t828);
  t836 = 0.2e1 * t260 * t266 + t59 * t834;
  t840 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t836);
  tv2sigma20 = t8 * t840;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t843 = t281 * t281;
  t846 = t843 * t563;
  t849 = my_piecewise3(t115, 0, 0);
  t850 = my_piecewise3(t117, t849, 0);
  t852 = t234 * t850 * t243;
  t853 = t234 * t843;
  t854 = t853 * t586;
  t856 = t560 * t846;
  t860 = my_piecewise5(t114, 0, t115, 0, t234 * t577 * t846 + t560 * t571 * t843 - t577 * t856 + t588 * t853 - t594 * t856 - t852 - t854);
  t862 = t113 * t860 + 0.2e1 * t278 * t284;
  t866 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t862);
  tv2sigma25 = t8 * t866;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t872 = t395 * t263;
  t873 = t394 * t872;
  t875 = t298 * t263;
  t876 = t163 * t875;
  t877 = t876 * t405;
  t878 = t170 * t263;
  t879 = t394 * t878;
  t882 = t412 * t263;
  t883 = t411 * t882;
  t886 = my_piecewise5(t64, 0, t67, 0, t642 * t733 + t736 * t873 + t736 * t879 - t748 * t873 - t748 * t883 - t826 - t877);
  t888 = t52 * t291 * t266 / 0.24e2 + t260 * t301 + t59 * t886;
  t892 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t888);
  tv2sigmalapl0 = t8 * t892;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t898 = t576 * t281;
  t899 = t575 * t898;
  t901 = t315 * t281;
  t902 = t234 * t901;
  t903 = t902 * t586;
  t904 = t241 * t281;
  t905 = t575 * t904;
  t908 = t593 * t281;
  t909 = t592 * t908;
  t912 = my_piecewise5(t114, 0, t115, 0, t704 * t787 + t790 * t899 + t790 * t905 - t802 * t899 - t802 * t909 - t852 - t903);
  t914 = t52 * t308 * t284 / 0.24e2 + t278 * t318 + t113 * t912;
  t918 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t914);
  tv2sigmalapl5 = t8 * t918;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t922 = t298 * t298;
  t925 = t922 * t382;
  t926 = t163 * t925;
  t928 = t163 * t922;
  t929 = t928 * t405;
  t931 = t379 * t925;
  t935 = my_piecewise5(t64, 0, t67, 0, t379 * t390 * t922 + t396 * t926 - t396 * t931 + t407 * t928 - t413 * t931 - t826 - t929);
  t937 = t52 * t291 * t301 / 0.12e2 + t59 * t935;
  t941 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t937);
  tv2lapl20 = t8 * t941;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t945 = t315 * t315;
  t948 = t945 * t563;
  t949 = t234 * t948;
  t951 = t234 * t945;
  t952 = t951 * t586;
  t954 = t560 * t948;
  t958 = my_piecewise5(t114, 0, t115, 0, t560 * t571 * t945 + t577 * t949 - t577 * t954 + t588 * t951 - t594 * t954 - t852 - t952);
  t960 = t52 * t308 * t318 / 0.12e2 + t113 * t958;
  t964 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t960);
  tv2lapl22 = t8 * t964;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t46, t47, t48, t52, t53, t55;
  double t59, t61, t62, t63, t64, t65, t66, t67;
  double t68, t69, t70, t71, t72, t73, t74, t75;
  double t76, t77, t79, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t94, t95, t96, t97;
  double t99, t102, t103, t107, t109, t113, t114, t115;
  double t116, t117, t118, t119, t120, t121, t122, t123;
  double t124, t125, t127, t131, tzk0;

  double t132, t133, t134, t136, t139, t140, t144, t145;
  double t148, t151, t154, t161, t163, t164, t165, t167;
  double t168, t170, t171, t172, t174, t176, t181, t182;
  double t184, t187, t188, t192, t195, t197, tvrho0, t201;
  double t204, t205, t210, t212, t215, t216, t222, t225;
  double t232, t234, t235, t236, t238, t239, t241, t242;
  double t243, t245, t247, t252, tvrho1, t256, t257, t260;
  double t262, t263, t266, t268, t272, tvsigma0, tvsigma1, t274;
  double t275, t278, t280, t281, t284, t286, t290, tvsigma2;
  double t291, t297, t298, t301, t303, t307, tvlapl0, t308;
  double t314, t315, t318, t320, t324, tvlapl1, tvtau0, tvtau1;

  double t327, t328, t331, t332, t333, t336, t340, t341;
  double t345, t347, t353, t354, t357, t359, t361, t363;
  double t366, t373, t377, t379, t380, t382, t383, t384;
  double t385, t386, t387, t388, t389, t390, t392, t394;
  double t395, t396, t398, t399, t402, t403, t405, t406;
  double t407, t409, t411, t412, t413, t416, t418, t423;
  double t424, t425, t428, t431, t435, t436, t440, t442;
  double t444, t447, t449, tv2rho20, t452, t456, t460, t461;
  double t465, t467, t475, t476, t480, t484, t485, t489;
  double t491, t498, t501, tv2rho21, t506, t511, t515, t516;
  double t522, t523, t528, t532, t533, t542, t544, t547;
  double t554, t558, t560, t561, t563, t564, t565, t566;
  double t567, t568, t569, t570, t571, t573, t575, t576;
  double t577, t579, t580, t583, t584, t586, t587, t588;
  double t590, t592, t593, t594, t597, t599, t604, tv2rho22;
  double t612, t614, t615, t618, t622, t623, t624, t625;
  double t627, t628, t629, t630, t632, t633, t636, t638;
  double t639, t640, t642, t644, t645, t648, t650, t655;
  double tv2rhosigma0, tv2rhosigma1, t662, t664, tv2rhosigma2, t670, tv2rhosigma3, tv2rhosigma4;
  double t676, t677, t680, t684, t685, t686, t687, t689;
  double t690, t692, t694, t695, t698, t700, t701, t702;
  double t704, t706, t707, t710, t712, t717, tv2rhosigma5, t724;
  double t732, t733, t735, t736, t740, t741, t744, t746;
  double t748, t752, t754, t759, tv2rholapl0, t766, t768, tv2rholapl1;
  double t774, tv2rholapl2, t786, t787, t789, t790, t794, t795;
  double t798, t800, t802, t806, t808, t813, tv2rholapl3, tv2rhotau0;
  double tv2rhotau1, tv2rhotau2, tv2rhotau3, t817, t820, t823, t824, t826;
  double t827, t828, t830, t834, t836, t840, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t843, t846, t849, t850, t852;
  double t853, t854, t856, t860, t862, t866, tv2sigma25, t872;
  double t873, t875, t876, t877, t878, t879, t882, t883;
  double t886, t888, t892, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4;
  double t898, t899, t901, t902, t903, t904, t905, t908;
  double t909, t912, t914, t918, tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2;
  double tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t922, t925, t926, t928, t929;
  double t931, t935, t937, t941, tv2lapl20, tv2lapl21, t945, t948;
  double t949, t951, t952, t954, t958, t960, t964, tv2lapl22;
  double tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20, tv2tau21, tv2tau22;

  double t968, t969, t972, t975, t976, t977, t980, t984;
  double t985, t989, t991, t996, t998, t1001, t1007, t1008;
  double t1011, t1013, t1016, t1020, t1023, t1030, t1036, t1037;
  double t1040, t1041, t1042, t1043, t1045, t1046, t1047, t1049;
  double t1051, t1052, t1053, t1056, t1057, t1063, t1064, t1068;
  double t1070, t1072, t1073, t1074, t1076, t1077, t1078, t1080;
  double t1081, t1085, t1089, t1092, t1093, t1094, t1095, t1098;
  double t1101, t1103, t1104, t1105, t1111, t1112, t1113, t1115;
  double t1116, t1117, t1120, t1122, t1123, t1127, t1131, t1132;
  double t1133, t1136, t1137, t1142, t1146, t1147, t1150, t1152;
  double t1154, t1159, t1161, t1162, t1165, t1168, t1171, t1175;
  double t1176, t1180, t1182, t1184, t1186, t1188, t1191, t1193;
  double tv3rho30, t1196, t1197, t1198, t1201, t1206, t1207, t1209;
  double t1213, t1214, t1218, t1221, t1225, t1227, t1231, t1240;
  double t1241, t1242, t1245, t1250, t1252, t1256, t1257, t1261;
  double t1264, t1265, t1267, t1276, t1278, t1281, tv3rho31, t1284;
  double t1289, t1293, t1297, t1298, t1302, t1304, t1313, t1314;
  double t1319, t1323, t1327, t1328, t1332, t1334, t1341, t1349;
  double t1351, t1352, tv3rho32, t1357, t1364, t1368, t1369, t1376;
  double t1377, t1384, t1388, t1389, t1406, t1409, t1416, t1422;
  double t1423, t1426, t1427, t1428, t1429, t1431, t1432, t1433;
  double t1435, t1437, t1438, t1439, t1442, t1443, t1446, t1447;
  double t1454, t1456, t1458, t1459, t1460, t1462, t1463, t1464;
  double t1466, t1467, t1471, t1475, t1478, t1479, t1480, t1481;
  double t1483, t1484, t1485, t1488, t1489, t1492, t1493, t1494;
  double t1498, t1499, t1500, t1506, t1507, t1508, t1510, t1511;
  double t1517, t1521, t1522, t1525, t1526, t1531, t1535, t1537;
  double t1539, t1544, tv3rho33, t1552, t1559, t1561, t1564, t1565;
  double t1568, t1576, t1577, t1578, t1580, t1583, t1586, t1587;
  double t1589, t1590, t1591, t1592, t1593, t1595, t1596, t1597;
  double t1600, t1602, t1604, t1607, t1611, t1612, t1615, t1616;
  double t1618, t1619, t1622, t1623, t1629, t1632, t1633, t1634;
  double t1635, t1642, t1643, t1644, t1646, t1647, t1648, t1649;
  double t1650, t1651, t1652, t1654, t1656, t1657, t1660, t1661;
  double t1664, t1665, t1670, t1671, t1672, t1675, t1676, t1681;
  double t1683, t1687, t1689, t1691, t1696, tv3rho2sigma0, tv3rho2sigma1, t1703;
  double t1707, t1709, tv3rho2sigma2, t1715, t1723, tv3rho2sigma3, tv3rho2sigma4, t1729;
  double t1736, t1739, tv3rho2sigma5, t1747, tv3rho2sigma6, tv3rho2sigma7, t1759, t1760;
  double t1763, t1771, t1772, t1773, t1774, t1775, t1778, t1779;
  double t1780, t1781, t1782, t1784, t1787, t1788, t1790, t1792;
  double t1793, t1795, t1796, t1797, t1801, t1806, t1807, t1810;
  double t1811, t1813, t1814, t1817, t1818, t1819, t1822, t1823;
  double t1829, t1830, t1837, t1838, t1839, t1841, t1842, t1843;
  double t1844, t1845, t1846, t1847, t1849, t1851, t1852, t1855;
  double t1856, t1858, t1859, t1862, t1863, t1868, t1872, t1874;
  double t1875, t1882, t1884, t1886, t1891, tv3rho2sigma8, t1898, t1905;
  double t1907, t1921, t1922, t1925, t1926, t1929, t1932, t1933;
  double t1934, t1936, t1938, t1940, t1941, t1947, t1955, t1956;
  double t1957, t1960, t1963, t1970, t1971, t1974, t1975, t1976;
  double t1978, t1982, t1983, t1988, t1989, t1992, t1994, t1996;
  double t1998, t2000, t2003, t2008, t2010, t2012, t2017, tv3rho2lapl0;
  double t2024, t2028, t2030, tv3rho2lapl1, t2036, t2044, tv3rho2lapl2, t2050;
  double t2057, t2060, tv3rho2lapl3, t2068, tv3rho2lapl4, t2091, t2092, t2095;
  double t2096, t2099, t2102, t2103, t2104, t2106, t2108, t2110;
  double t2111, t2117, t2119, t2120, t2121, t2124, t2133, t2140;
  double t2141, t2144, t2145, t2146, t2148, t2152, t2153, t2156;
  double t2158, t2160, t2162, t2165, t2166, t2169, t2171, t2178;
  double t2180, t2182, t2187, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1, tv3rho2tau2, tv3rho2tau3;
  double tv3rho2tau4, tv3rho2tau5, t2194, t2200, t2201, t2202, t2205, t2207;
  double t2209, t2214, t2215, t2218, t2219, t2220, t2221, t2222;
  double t2225, t2226, t2229, t2230, t2231, t2233, t2234, t2236;
  double t2237, t2242, t2243, t2246, t2247, t2248, t2249, t2250;
  double t2251, t2253, t2254, t2257, t2260, t2261, t2265, t2266;
  double t2267, t2268, t2271, t2272, t2273, t2274, t2276, t2277;
  double t2278, t2280, t2281, t2282, t2283, t2285, t2286, t2287;
  double t2288, t2289, t2291, t2292, t2293, t2298, t2299, t2300;
  double t2301, t2303, t2304, t2307, t2310, t2312, t2314, t2319;
  double tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t2326, t2328, tv3rhosigma25;
  double t2334, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t2344, t2345;
  double t2346, t2347, t2350, t2351, t2354, t2355, t2356, t2359;
  double t2360, t2361, t2362, t2363, t2365, t2366, t2370, t2371;
  double t2372, t2373, t2374, t2375, t2377, t2380, t2381, t2383;
  double t2388, t2389, t2390, t2392, t2393, t2400, t2401, t2402;
  double t2405, t2406, t2410, t2411, t2412, t2413, t2416, t2417;
  double t2418, t2419, t2421, t2422, t2423, t2425, t2426, t2429;
  double t2434, t2435, t2436, t2437, t2438, t2440, t2441, t2442;
  double t2447, t2448, t2449, t2450, t2452, t2453, t2454, t2455;
  double t2457, t2459, t2464, tv3rhosigma211, t2471, t2481, t2482, t2486;
  double t2487, t2490, t2491, t2498, t2499, t2500, t2501, t2502;
  double t2505, t2506, t2509, t2511, t2512, t2514, t2515, t2516;
  double t2517, t2518, t2521, t2524, t2527, t2528, t2530, t2534;
  double t2535, t2540, t2541, t2542, t2544, t2546, t2547, t2549;
  double t2550, t2551, t2552, t2554, t2555, t2556, t2558, t2560;
  double t2561, t2563, t2568, t2570, t2572, t2577, tv3rhosigmalapl0, tv3rhosigmalapl1;
  double tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, t2584, t2586, tv3rhosigmalapl5, t2592, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2612, t2613, t2615, t2616;
  double t2619, t2620, t2621, t2622, t2623, t2626, t2628, t2629;
  double t2631, t2632, t2633, t2634, t2635, t2638, t2641, t2642;
  double t2643, t2645, t2649, t2650, t2653, t2656, t2661, t2662;
  double t2663, t2665, t2667, t2668, t2670, t2671, t2672, t2673;
  double t2675, t2676, t2677, t2679, t2680, t2683, t2685, t2686;
  double t2688, t2693, t2695, t2697, t2702, tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1;
  double tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9;
  double tv3rhosigmatau10, tv3rhosigmatau11, t2709, t2717, t2719, t2720, t2722, t2724;
  double t2725, t2727, t2729, t2730, t2733, t2735, t2743, t2749;
  double t2753, t2758, t2759, t2765, t2766, t2774, t2775, t2777;
  double t2778, t2779, t2781, t2782, t2786, t2788, t2790, t2795;
  double tv3rholapl20, tv3rholapl21, t2802, t2804, tv3rholapl22, t2810, tv3rholapl23, tv3rholapl24;
  double t2822, t2824, t2825, t2827, t2829, t2830, t2832, t2834;
  double t2835, t2839, t2845, t2847, t2856, t2859, t2860, t2866;
  double t2870, t2871, t2877, t2878, t2880, t2881, t2882, t2884;
  double t2885, t2891, t2893, t2895, t2900, tv3rholapl25, tv3rholapltau0, tv3rholapltau1;
  double tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, tv3rhotau20, tv3rhotau21;
  double tv3rhotau22, tv3rhotau23, tv3rhotau24, tv3rhotau25, t2904, t2913, t2914, t2915;
  double t2916, t2917, t2918, t2919, t2920, t2921, t2922, t2923;
  double t2924, t2925, t2926, t2927, t2929, t2930, t2931, t2932;
  double t2937, t2938, t2939, t2942, t2945, t2947, t2948, t2950;
  double t2951, t2952, t2953, t2954, t2955, t2956, t2959, t2968;
  double t2970, t2972, t2976, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34;
  double tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t2979, t2988, t2989, t2990;
  double t2991, t2992, t2993, t2994, t2995, t2996, t2997, t2998;
  double t2999, t3000, t3001, t3002, t3004, t3005, t3006, t3007;
  double t3010, t3013, t3014, t3017, t3019, t3020, t3023, t3024;
  double t3028, t3029, t3030, t3031, t3032, t3033, t3034, t3043;
  double t3045, t3047, t3051, tv3sigma39, t3057, t3058, t3059, t3060;
  double t3061, t3062, t3063, t3064, t3065, t3066, t3067, t3068;
  double t3069, t3070, t3071, t3075, t3076, t3084, t3089, t3090;
  double t3091, t3092, t3093, t3094, t3097, t3098, t3099, t3100;
  double t3101, t3102, t3107, t3108, t3109, t3110, t3111, t3112;
  double t3115, t3116, t3119, t3121, t3123, t3124, t3125, t3126;
  double t3127, t3129, t3131, t3135, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3;
  double tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, t3141;
  double t3142, t3143, t3144, t3145, t3146, t3147, t3148, t3149;
  double t3150, t3151, t3152, t3154, t3158, t3160, t3161, t3164;
  double t3165, t3166, t3167, t3168, t3173, t3177, t3178, t3186;
  double t3187, t3188, t3189, t3190, t3191, t3192, t3193, t3194;
  double t3195, t3196, t3197, t3200, t3201, t3204, t3206, t3208;
  double t3209, t3210, t3211, t3212, t3214, t3216, t3220, tv3sigma2lapl11;
  double tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7;
  double tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, t3225, t3227, t3228, t3232;
  double t3237, t3240, t3241, t3244, t3248, t3249, t3256, t3257;
  double t3260, t3261, t3262, t3263, t3264, t3266, t3267, t3268;
  double t3270, t3271, t3272, t3273, t3274, t3281, t3283, t3285;
  double t3289, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26;
  double tv3sigmalapl27, t3294, t3296, t3297, t3298, t3299, t3300, t3301;
  double t3302, t3304, t3305, t3308, t3309, t3310, t3315, t3316;
  double t3323, t3324, t3327, t3331, t3332, t3337, t3338, t3339;
  double t3340, t3341, t3342, t3343, t3350, t3352, t3354, t3358;
  double tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6;
  double tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22;
  double tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, t3362, t3371;
  double t3372, t3373, t3374, t3375, t3377, t3378, t3379, t3380;
  double t3381, t3382, t3383, t3384, t3385, t3386, t3387, t3389;
  double t3390, t3392, t3393, t3394, t3395, t3398, t3401, t3416;
  double t3418, t3420, t3424, tv3lapl30, tv3lapl31, tv3lapl32, t3428, t3437;
  double t3438, t3439, t3440, t3441, t3442, t3443, t3445, t3446;
  double t3447, t3448, t3449, t3450, t3451, t3452, t3453, t3454;
  double t3455, t3458, t3465, t3466, t3467, t3469, t3470, t3471;
  double t3482, t3484, t3486, t3490, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2;
  double tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24;
  double tv3lapltau25, tv3tau30, tv3tau31, tv3tau32, tv3tau33;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t46 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43;
  t47 = params->csk_cp * t33;
  t48 = t37 * sigma[0];
  t52 = params->csk_cq * t33;
  t53 = t37 * lapl[0];
  t55 = 0.1e1 / t41 / rho[0];
  t59 = t47 * t48 * t43 / 0.24e2 + t52 * t53 * t55 / 0.24e2 - t46;
  t61 = log(0.1e1 - DBL_EPSILON);
  t62 = 0.1e1 / params->csk_a;
  t63 = pow(-t61, -t62);
  t64 = t59 < -t63;
  t65 = log(DBL_EPSILON);
  t66 = pow(-t65, -t62);
  t67 = -t66 < t59;
  t68 = my_piecewise3(t67, -t66, t59);
  t69 = -t63 < t68;
  t70 = my_piecewise3(t69, t68, -t63);
  t71 = fabs(t70);
  t72 = pow(t71, params->csk_a);
  t73 = 0.1e1 / t72;
  t74 = exp(-t73);
  t75 = 0.1e1 - t74;
  t76 = pow(t75, t62);
  t77 = my_piecewise5(t64, 0, t67, 1, t76);
  t79 = t59 * t77 + t46 + 0.1e1;
  t83 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t79);
  t84 = rho[1] <= p->dens_threshold;
  t85 = -t18;
  t87 = my_piecewise5(t16, t13, t12, t17, t85 * t9);
  t88 = 0.1e1 + t87;
  t89 = t88 <= p->zeta_threshold;
  t90 = POW_1_3(t88);
  t91 = t90 * t90;
  t93 = my_piecewise3(t89, t25, t91 * t88);
  t94 = t93 * t31;
  t95 = rho[1] * rho[1];
  t96 = POW_1_3(rho[1]);
  t97 = t96 * t96;
  t99 = 0.1e1 / t97 / t95;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t99;
  t103 = t37 * sigma[2];
  t107 = t37 * lapl[1];
  t109 = 0.1e1 / t97 / rho[1];
  t113 = t47 * t103 * t99 / 0.24e2 + t52 * t107 * t109 / 0.24e2 - t102;
  t114 = t113 < -t63;
  t115 = -t66 < t113;
  t116 = my_piecewise3(t115, -t66, t113);
  t117 = -t63 < t116;
  t118 = my_piecewise3(t117, t116, -t63);
  t119 = fabs(t118);
  t120 = pow(t119, params->csk_a);
  t121 = 0.1e1 / t120;
  t122 = exp(-t121);
  t123 = 0.1e1 - t122;
  t124 = pow(t123, t62);
  t125 = my_piecewise5(t114, 0, t115, 1, t124);
  t127 = t113 * t125 + t102 + 0.1e1;
  t131 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t127);
  tzk0 = t83 + t131;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t132 = t8 * t8;
  t133 = 0.1e1 / t132;
  t134 = t18 * t133;
  t136 = my_piecewise5(t12, 0, t16, 0, t9 - t134);
  t139 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t136);
  t140 = t139 * t31;
  t144 = 0.1e1 / t30;
  t145 = t29 * t144;
  t148 = t7 * t145 * t79 / 0.1e2;
  t151 = 0.1e1 / t41 / t39 / rho[0];
  t154 = 0.5e1 / 0.27e2 * t38 * sigma[0] * t151;
  t161 = -t47 * t48 * t151 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t53 * t43 + t154;
  t163 = t76 * t73;
  t164 = my_piecewise3(t67, 0, t161);
  t165 = my_piecewise3(t69, t164, 0);
  t167 = fabs(t70) / t70;
  t168 = 0.1e1 / t71;
  t170 = 0.1e1 / t75;
  t171 = t74 * t170;
  t172 = t167 * t168 * t171;
  t174 = my_piecewise5(t64, 0, t67, 0, -t163 * t165 * t172);
  t176 = t161 * t77 + t174 * t59 - t154;
  t181 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t79 + t148 + 0.3e1 / 0.2e2 * t7 * t32 * t176);
  t182 = t85 * t133;
  t184 = my_piecewise5(t16, 0, t12, 0, -t9 - t182);
  t187 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t184);
  t188 = t187 * t31;
  t192 = t93 * t144;
  t195 = t7 * t192 * t127 / 0.1e2;
  t197 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t127 + t195);
  tvrho0 = t83 + t131 + t8 * (t181 + t197);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t201 = my_piecewise5(t12, 0, t16, 0, -t9 - t134);
  t204 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t201);
  t205 = t204 * t31;
  t210 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t79 + t148);
  t212 = my_piecewise5(t16, 0, t12, 0, t9 - t182);
  t215 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t212);
  t216 = t215 * t31;
  t222 = 0.1e1 / t97 / t95 / rho[1];
  t225 = 0.5e1 / 0.27e2 * t38 * sigma[2] * t222;
  t232 = -t47 * t103 * t222 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t107 * t99 + t225;
  t234 = t124 * t121;
  t235 = my_piecewise3(t115, 0, t232);
  t236 = my_piecewise3(t117, t235, 0);
  t238 = fabs(t118) / t118;
  t239 = 0.1e1 / t119;
  t241 = 0.1e1 / t123;
  t242 = t122 * t241;
  t243 = t238 * t239 * t242;
  t245 = my_piecewise5(t114, 0, t115, 0, -t234 * t236 * t243);
  t247 = t113 * t245 + t125 * t232 - t225;
  t252 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t127 + t195 + 0.3e1 / 0.2e2 * t7 * t94 * t247);
  tvrho1 = t83 + t131 + t8 * (t210 + t252);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t256 = 0.5e1 / 0.72e2 * t38 * t43;
  t257 = t37 * t43;
  t260 = t47 * t257 / 0.24e2 - t256;
  t262 = my_piecewise3(t67, 0, t260);
  t263 = my_piecewise3(t69, t262, 0);
  t266 = my_piecewise5(t64, 0, t67, 0, -t163 * t263 * t172);
  t268 = t260 * t77 + t266 * t59 + t256;
  t272 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t268);
  tvsigma0 = t8 * t272;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t274 = 0.5e1 / 0.72e2 * t38 * t99;
  t275 = t37 * t99;
  t278 = t47 * t275 / 0.24e2 - t274;
  t280 = my_piecewise3(t115, 0, t278);
  t281 = my_piecewise3(t117, t280, 0);
  t284 = my_piecewise5(t114, 0, t115, 0, -t234 * t281 * t243);
  t286 = t113 * t284 + t125 * t278 + t274;
  t290 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t286);
  tvsigma2 = t8 * t290;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t291 = t37 * t55;
  t297 = my_piecewise3(t67, 0, t52 * t291 / 0.24e2);
  t298 = my_piecewise3(t69, t297, 0);
  t301 = my_piecewise5(t64, 0, t67, 0, -t163 * t298 * t172);
  t303 = t52 * t291 * t77 / 0.24e2 + t59 * t301;
  t307 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t303);
  tvlapl0 = t8 * t307;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t308 = t37 * t109;
  t314 = my_piecewise3(t115, 0, t52 * t308 / 0.24e2);
  t315 = my_piecewise3(t117, t314, 0);
  t318 = my_piecewise5(t114, 0, t115, 0, -t234 * t315 * t243);
  t320 = t52 * t308 * t125 / 0.24e2 + t113 * t318;
  t324 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t320);
  tvlapl1 = t8 * t324;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t327 = 0.1e1 / t26;
  t328 = t136 * t136;
  t331 = t132 * t8;
  t332 = 0.1e1 / t331;
  t333 = t18 * t332;
  t336 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t133 + 0.2e1 * t333);
  t340 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t327 * t328 + 0.5e1 / 0.3e1 * t27 * t336);
  t341 = t340 * t31;
  t345 = t139 * t144;
  t347 = t7 * t345 * t79;
  t353 = 0.1e1 / t30 / t8;
  t354 = t29 * t353;
  t357 = t7 * t354 * t79 / 0.3e2;
  t359 = t7 * t145 * t176;
  t361 = t39 * t39;
  t363 = 0.1e1 / t41 / t361;
  t366 = 0.55e2 / 0.81e2 * t38 * sigma[0] * t363;
  t373 = 0.11e2 / 0.27e2 * t47 * t48 * t363 + 0.5e1 / 0.27e2 * t52 * t53 * t151 - t366;
  t377 = t72 * t72;
  t379 = t76 / t377;
  t380 = t165 * t165;
  t382 = t167 * t167;
  t383 = t71 * t71;
  t384 = 0.1e1 / t383;
  t385 = t382 * t384;
  t386 = t74 * t74;
  t387 = t75 * t75;
  t388 = 0.1e1 / t387;
  t389 = t386 * t388;
  t390 = t385 * t389;
  t392 = t380 * t382;
  t394 = t384 * t74;
  t395 = t170 * params->csk_a;
  t396 = t394 * t395;
  t398 = my_piecewise3(t67, 0, t373);
  t399 = my_piecewise3(t69, t398, 0);
  t402 = t163 * t380;
  t403 = 0.0;
  t405 = t403 * t168 * t171;
  t406 = t402 * t405;
  t407 = t385 * t171;
  t409 = t379 * t392;
  t411 = t384 * t386;
  t412 = t388 * params->csk_a;
  t413 = t411 * t412;
  t416 = my_piecewise5(t64, 0, t67, 0, -t163 * t172 * t399 + t163 * t392 * t396 + t379 * t380 * t390 - t396 * t409 + t402 * t407 - t409 * t413 - t406);
  t418 = 0.2e1 * t161 * t174 + t373 * t77 + t416 * t59 + t366;
  t423 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t79 + t347 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t176 - t357 + t359 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t418);
  t424 = 0.1e1 / t90;
  t425 = t184 * t184;
  t428 = t85 * t332;
  t431 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t133 + 0.2e1 * t428);
  t435 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t424 * t425 + 0.5e1 / 0.3e1 * t91 * t431);
  t436 = t435 * t31;
  t440 = t187 * t144;
  t442 = t7 * t440 * t127;
  t444 = t93 * t353;
  t447 = t7 * t444 * t127 / 0.3e2;
  t449 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t127 + t442 / 0.5e1 - t447);
  tv2rho20 = 0.2e1 * t181 + 0.2e1 * t197 + t8 * (t423 + t449);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t452 = t327 * t201;
  t456 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t333);
  t460 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t452 * t136 + 0.5e1 / 0.3e1 * t27 * t456);
  t461 = t460 * t31;
  t465 = t204 * t144;
  t467 = t7 * t465 * t79;
  t475 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t79 + t467 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t176 + t347 / 0.1e2 - t357 + t359 / 0.1e2);
  t476 = t424 * t212;
  t480 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t428);
  t484 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t476 * t184 + 0.5e1 / 0.3e1 * t91 * t480);
  t485 = t484 * t31;
  t489 = t215 * t144;
  t491 = t7 * t489 * t127;
  t498 = t7 * t192 * t247;
  t501 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t127 + t491 / 0.1e2 + t442 / 0.1e2 - t447 + 0.3e1 / 0.2e2 * t7 * t188 * t247 + t498 / 0.1e2);
  tv2rho21 = t181 + t197 + t210 + t252 + t8 * (t475 + t501);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t506 = t201 * t201;
  t511 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t133 + 0.2e1 * t333);
  t515 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t327 * t506 + 0.5e1 / 0.3e1 * t27 * t511);
  t516 = t515 * t31;
  t522 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t79 + t467 / 0.5e1 - t357);
  t523 = t212 * t212;
  t528 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t133 + 0.2e1 * t428);
  t532 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t424 * t523 + 0.5e1 / 0.3e1 * t91 * t528);
  t533 = t532 * t31;
  t542 = t95 * t95;
  t544 = 0.1e1 / t97 / t542;
  t547 = 0.55e2 / 0.81e2 * t38 * sigma[2] * t544;
  t554 = 0.11e2 / 0.27e2 * t47 * t103 * t544 + 0.5e1 / 0.27e2 * t52 * t107 * t222 - t547;
  t558 = t120 * t120;
  t560 = t124 / t558;
  t561 = t236 * t236;
  t563 = t238 * t238;
  t564 = t119 * t119;
  t565 = 0.1e1 / t564;
  t566 = t563 * t565;
  t567 = t122 * t122;
  t568 = t123 * t123;
  t569 = 0.1e1 / t568;
  t570 = t567 * t569;
  t571 = t566 * t570;
  t573 = t561 * t563;
  t575 = t565 * t122;
  t576 = t241 * params->csk_a;
  t577 = t575 * t576;
  t579 = my_piecewise3(t115, 0, t554);
  t580 = my_piecewise3(t117, t579, 0);
  t583 = t234 * t561;
  t584 = 0.0;
  t586 = t584 * t239 * t242;
  t587 = t583 * t586;
  t588 = t566 * t242;
  t590 = t560 * t573;
  t592 = t565 * t567;
  t593 = t569 * params->csk_a;
  t594 = t592 * t593;
  t597 = my_piecewise5(t114, 0, t115, 0, -t234 * t243 * t580 + t234 * t573 * t577 + t560 * t561 * t571 - t577 * t590 + t583 * t588 - t590 * t594 - t587);
  t599 = t113 * t597 + t125 * t554 + 0.2e1 * t232 * t245 + t547;
  t604 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t127 + t491 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t247 - t447 + t498 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t599);
  tv2rho22 = 0.2e1 * t210 + 0.2e1 * t252 + t8 * (t522 + t604);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t612 = t7 * t145 * t268 / 0.1e2;
  t614 = 0.5e1 / 0.27e2 * t38 * t151;
  t615 = t37 * t151;
  t618 = -t47 * t615 / 0.9e1 + t614;
  t622 = t165 * t382;
  t623 = t379 * t622;
  t624 = t388 * t263;
  t625 = t411 * t624;
  t627 = t263 * t382;
  t628 = t163 * t627;
  t629 = t395 * t165;
  t630 = t394 * t629;
  t632 = my_piecewise3(t67, 0, t618);
  t633 = my_piecewise3(t69, t632, 0);
  t636 = t263 * t165;
  t638 = t163 * t636 * t405;
  t639 = t170 * t165;
  t640 = t394 * t639;
  t642 = t379 * t627;
  t644 = t412 * t165;
  t645 = t411 * t644;
  t648 = my_piecewise5(t64, 0, t67, 0, -t163 * t172 * t633 + t623 * t625 + t628 * t630 + t628 * t640 - t630 * t642 - t642 * t645 - t638);
  t650 = t161 * t266 + t174 * t260 + t59 * t648 + t618 * t77 - t614;
  t655 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t268 + t612 + 0.3e1 / 0.2e2 * t7 * t32 * t650);
  tv2rhosigma0 = t655 * t8 + t272;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t662 = t7 * t192 * t286 / 0.1e2;
  t664 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t286 + t662);
  tv2rhosigma2 = t664 * t8 + t290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t670 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t268 + t612);
  tv2rhosigma3 = t670 * t8 + t272;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t676 = 0.5e1 / 0.27e2 * t38 * t222;
  t677 = t37 * t222;
  t680 = -t47 * t677 / 0.9e1 + t676;
  t684 = t236 * t563;
  t685 = t560 * t684;
  t686 = t569 * t281;
  t687 = t592 * t686;
  t689 = t281 * t563;
  t690 = t234 * t689;
  t692 = t575 * t576 * t236;
  t694 = my_piecewise3(t115, 0, t680);
  t695 = my_piecewise3(t117, t694, 0);
  t698 = t281 * t236;
  t700 = t234 * t698 * t586;
  t701 = t241 * t236;
  t702 = t575 * t701;
  t704 = t560 * t689;
  t706 = t593 * t236;
  t707 = t592 * t706;
  t710 = my_piecewise5(t114, 0, t115, 0, -t234 * t243 * t695 + t685 * t687 + t690 * t692 + t690 * t702 - t692 * t704 - t704 * t707 - t700);
  t712 = t113 * t710 + t125 * t680 + t232 * t284 + t245 * t278 - t676;
  t717 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t286 + t662 + 0.3e1 / 0.2e2 * t7 * t94 * t712);
  tv2rhosigma5 = t717 * t8 + t290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t724 = t7 * t145 * t303 / 0.1e2;
  t732 = t388 * t298;
  t733 = t411 * t732;
  t735 = t298 * t382;
  t736 = t163 * t735;
  t740 = my_piecewise3(t67, 0, -0.5e1 / 0.72e2 * t52 * t257);
  t741 = my_piecewise3(t69, t740, 0);
  t744 = t298 * t165;
  t746 = t163 * t744 * t405;
  t748 = t379 * t735;
  t752 = my_piecewise5(t64, 0, t67, 0, -t163 * t172 * t741 + t623 * t733 + t630 * t736 - t630 * t748 + t640 * t736 - t645 * t748 - t746);
  t754 = -0.5e1 / 0.72e2 * t52 * t257 * t77 + t52 * t291 * t174 / 0.24e2 + t161 * t301 + t59 * t752;
  t759 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t303 + t724 + 0.3e1 / 0.2e2 * t7 * t32 * t754);
  tv2rholapl0 = t759 * t8 + t307;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t766 = t7 * t192 * t320 / 0.1e2;
  t768 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t320 + t766);
  tv2rholapl1 = t768 * t8 + t324;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t774 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t303 + t724);
  tv2rholapl2 = t774 * t8 + t307;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t786 = t569 * t315;
  t787 = t592 * t786;
  t789 = t315 * t563;
  t790 = t234 * t789;
  t794 = my_piecewise3(t115, 0, -0.5e1 / 0.72e2 * t52 * t275);
  t795 = my_piecewise3(t117, t794, 0);
  t798 = t315 * t236;
  t800 = t234 * t798 * t586;
  t802 = t560 * t789;
  t806 = my_piecewise5(t114, 0, t115, 0, -t234 * t243 * t795 + t685 * t787 + t692 * t790 - t692 * t802 + t702 * t790 - t707 * t802 - t800);
  t808 = -0.5e1 / 0.72e2 * t52 * t275 * t125 + t52 * t308 * t245 / 0.24e2 + t232 * t318 + t113 * t806;
  t813 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t320 + t766 + 0.3e1 / 0.2e2 * t7 * t94 * t808);
  tv2rholapl3 = t8 * t813 + t324;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t817 = t263 * t263;
  t820 = t817 * t382;
  t823 = my_piecewise3(t67, 0, 0);
  t824 = my_piecewise3(t69, t823, 0);
  t826 = t163 * t824 * t172;
  t827 = t163 * t817;
  t828 = t827 * t405;
  t830 = t379 * t820;
  t834 = my_piecewise5(t64, 0, t67, 0, t163 * t396 * t820 + t379 * t390 * t817 - t396 * t830 + t407 * t827 - t413 * t830 - t826 - t828);
  t836 = 0.2e1 * t260 * t266 + t59 * t834;
  t840 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t836);
  tv2sigma20 = t8 * t840;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t843 = t281 * t281;
  t846 = t843 * t563;
  t849 = my_piecewise3(t115, 0, 0);
  t850 = my_piecewise3(t117, t849, 0);
  t852 = t234 * t850 * t243;
  t853 = t234 * t843;
  t854 = t853 * t586;
  t856 = t560 * t846;
  t860 = my_piecewise5(t114, 0, t115, 0, t234 * t577 * t846 + t560 * t571 * t843 - t577 * t856 + t588 * t853 - t594 * t856 - t852 - t854);
  t862 = t113 * t860 + 0.2e1 * t278 * t284;
  t866 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t862);
  tv2sigma25 = t8 * t866;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t872 = t395 * t263;
  t873 = t394 * t872;
  t875 = t298 * t263;
  t876 = t163 * t875;
  t877 = t876 * t405;
  t878 = t170 * t263;
  t879 = t394 * t878;
  t882 = t412 * t263;
  t883 = t411 * t882;
  t886 = my_piecewise5(t64, 0, t67, 0, t642 * t733 + t736 * t873 + t736 * t879 - t748 * t873 - t748 * t883 - t826 - t877);
  t888 = t52 * t291 * t266 / 0.24e2 + t260 * t301 + t59 * t886;
  t892 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t888);
  tv2sigmalapl0 = t8 * t892;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t898 = t576 * t281;
  t899 = t575 * t898;
  t901 = t315 * t281;
  t902 = t234 * t901;
  t903 = t902 * t586;
  t904 = t241 * t281;
  t905 = t575 * t904;
  t908 = t593 * t281;
  t909 = t592 * t908;
  t912 = my_piecewise5(t114, 0, t115, 0, t704 * t787 + t790 * t899 + t790 * t905 - t802 * t899 - t802 * t909 - t852 - t903);
  t914 = t52 * t308 * t284 / 0.24e2 + t278 * t318 + t113 * t912;
  t918 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t914);
  tv2sigmalapl5 = t8 * t918;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t922 = t298 * t298;
  t925 = t922 * t382;
  t926 = t163 * t925;
  t928 = t163 * t922;
  t929 = t928 * t405;
  t931 = t379 * t925;
  t935 = my_piecewise5(t64, 0, t67, 0, t379 * t390 * t922 + t396 * t926 - t396 * t931 + t407 * t928 - t413 * t931 - t826 - t929);
  t937 = t52 * t291 * t301 / 0.12e2 + t59 * t935;
  t941 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t937);
  tv2lapl20 = t8 * t941;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t945 = t315 * t315;
  t948 = t945 * t563;
  t949 = t234 * t948;
  t951 = t234 * t945;
  t952 = t951 * t586;
  t954 = t560 * t948;
  t958 = my_piecewise5(t114, 0, t115, 0, t560 * t571 * t945 + t577 * t949 - t577 * t954 + t588 * t951 - t594 * t954 - t852 - t952);
  t960 = t52 * t308 * t318 / 0.12e2 + t113 * t958;
  t964 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t960);
  tv2lapl22 = t8 * t964;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t968 = 0.1e1 / t26 / t21;
  t969 = t328 * t136;
  t972 = t327 * t136;
  t975 = t132 * t132;
  t976 = 0.1e1 / t975;
  t977 = t18 * t976;
  t980 = my_piecewise5(t12, 0, t16, 0, 0.6e1 * t332 - 0.6e1 * t977);
  t984 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t968 * t969 + 0.1e2 / 0.3e1 * t972 * t336 + 0.5e1 / 0.3e1 * t27 * t980);
  t985 = t984 * t31;
  t989 = t340 * t144;
  t991 = t7 * t989 * t79;
  t996 = t139 * t353;
  t998 = t7 * t996 * t79;
  t1001 = t7 * t345 * t176;
  t1007 = 0.1e1 / t30 / t132;
  t1008 = t29 * t1007;
  t1011 = 0.2e1 / 0.45e2 * t7 * t1008 * t79;
  t1013 = t7 * t354 * t176;
  t1016 = t7 * t145 * t418;
  t1020 = 0.1e1 / t41 / t361 / rho[0];
  t1023 = 0.77e3 / 0.243e3 * t38 * sigma[0] * t1020;
  t1030 = -0.154e3 / 0.81e2 * t47 * t48 * t1020 - 0.55e2 / 0.81e2 * t52 * t53 * t363 + t1023;
  t1036 = t399 * t382;
  t1037 = t379 * t1036;
  t1040 = t380 * t165;
  t1041 = t1040 * t403;
  t1042 = t379 * t1041;
  t1043 = t384 * params->csk_a;
  t1045 = t167 * t74 * t170;
  t1046 = t1043 * t1045;
  t1047 = t1042 * t1046;
  t1049 = t1040 * t167;
  t1051 = t395 * t403;
  t1052 = t394 * t1051;
  t1053 = t163 * t1049 * t1052;
  t1056 = t395 * t399;
  t1057 = t394 * t1056;
  t1063 = t411 * t412 * t167;
  t1064 = t1042 * t1063;
  t1068 = t76 / t377 / t72;
  t1070 = t382 * t167;
  t1072 = 0.1e1 / t383 / t71;
  t1073 = t1070 * t1072;
  t1074 = t386 * t74;
  t1076 = 0.1e1 / t387 / t75;
  t1077 = t1074 * t1076;
  t1078 = t1073 * t1077;
  t1080 = my_piecewise3(t67, 0, t1030);
  t1081 = my_piecewise3(t69, t1080, 0);
  t1085 = t1073 * t389;
  t1089 = t1073 * t171;
  t1092 = t1040 * t1070;
  t1093 = t379 * t1092;
  t1094 = t1072 * params->csk_a;
  t1095 = t1094 * t171;
  t1098 = t163 * t1092;
  t1101 = -t1040 * t1068 * t1078 - 0.3e1 * t1040 * t1085 * t379 - 0.2e1 * t1040 * t1089 * t163 + 0.3e1 * t1057 * t163 * t622 - t1081 * t163 * t172 - 0.3e1 * t1037 * t630 - 0.3e1 * t1037 * t645 + 0.3e1 * t1093 * t1095 - 0.3e1 * t1095 * t1098 - 0.3e1 * t1047 + 0.3e1 * t1053 - 0.3e1 * t1064 - t406;
  t1103 = t388 * t403;
  t1104 = t411 * t1103;
  t1105 = t379 * t1049 * t1104;
  t1111 = t170 * t167;
  t1112 = t394 * t1111;
  t1113 = t163 * t1041 * t1112;
  t1115 = params->csk_a * params->csk_a;
  t1116 = t1072 * t1115;
  t1117 = t1116 * t171;
  t1120 = t1068 * t1092;
  t1122 = t1072 * t386;
  t1123 = t1122 * t412;
  t1127 = t388 * t399;
  t1131 = t1072 * t1074;
  t1132 = t1076 * params->csk_a;
  t1133 = t1131 * t1132;
  t1136 = t388 * t1115;
  t1137 = t1122 * t1136;
  t1142 = t163 * t399 * t165 * t405;
  t1146 = t1076 * t1115;
  t1147 = t1131 * t1146;
  t1150 = 0.3e1 * t1036 * t163 * t640 + 0.3e1 * t1127 * t411 * t623 + 0.3e1 * t1093 * t1117 + 0.3e1 * t1093 * t1137 - t1098 * t1117 - t1117 * t1120 + 0.3e1 * t1120 * t1123 + 0.3e1 * t1120 * t1133 - 0.3e1 * t1120 * t1137 - 0.2e1 * t1120 * t1147 + 0.3e1 * t1105 + 0.3e1 * t1113 - 0.3e1 * t1142;
  t1152 = my_piecewise5(t64, 0, t67, 0, t1101 + t1150);
  t1154 = t1030 * t77 + t1152 * t59 + 0.3e1 * t161 * t416 + 0.3e1 * t174 * t373 - t1023;
  t1159 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t985 * t79 + 0.3e1 / 0.1e2 * t991 + 0.9e1 / 0.2e2 * t7 * t341 * t176 - t998 / 0.1e2 + 0.3e1 / 0.5e1 * t1001 + 0.9e1 / 0.2e2 * t7 * t140 * t418 + t1011 - t1013 / 0.1e2 + 0.3e1 / 0.1e2 * t1016 + 0.3e1 / 0.2e2 * t7 * t32 * t1154);
  t1161 = 0.1e1 / t90 / t88;
  t1162 = t425 * t184;
  t1165 = t424 * t184;
  t1168 = t85 * t976;
  t1171 = my_piecewise5(t16, 0, t12, 0, -0.6e1 * t332 - 0.6e1 * t1168);
  t1175 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1161 * t1162 + 0.1e2 / 0.3e1 * t1165 * t431 + 0.5e1 / 0.3e1 * t91 * t1171);
  t1176 = t1175 * t31;
  t1180 = t435 * t144;
  t1182 = t7 * t1180 * t127;
  t1184 = t187 * t353;
  t1186 = t7 * t1184 * t127;
  t1188 = t93 * t1007;
  t1191 = 0.2e1 / 0.45e2 * t7 * t1188 * t127;
  t1193 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1176 * t127 + 0.3e1 / 0.1e2 * t1182 - t1186 / 0.1e2 + t1191);
  tv3rho30 = 0.3e1 * t423 + 0.3e1 * t449 + t8 * (t1159 + t1193);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1196 = 0.2e1 * t475;
  t1197 = 0.2e1 * t501;
  t1198 = t968 * t201;
  t1201 = t327 * t456;
  t1206 = 0.2e1 * t332;
  t1207 = 0.6e1 * t977;
  t1209 = my_piecewise5(t12, 0, t16, 0, t1206 - t1207);
  t1213 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1198 * t328 + 0.2e2 / 0.9e1 * t1201 * t136 + 0.1e2 / 0.9e1 * t452 * t336 + 0.5e1 / 0.3e1 * t27 * t1209);
  t1214 = t1213 * t31;
  t1218 = t460 * t144;
  t1221 = t7 * t1218 * t79 / 0.5e1;
  t1225 = t204 * t353;
  t1227 = t7 * t1225 * t79;
  t1231 = t7 * t465 * t176 / 0.5e1;
  t1240 = 0.3e1 / 0.2e2 * t7 * t1214 * t79 + t1221 + 0.3e1 / 0.1e2 * t7 * t461 * t176 - t1227 / 0.3e2 + t1231 + 0.3e1 / 0.2e2 * t7 * t205 * t418 + t991 / 0.1e2 - t998 / 0.15e2 + t1001 / 0.5e1 + t1011 - t1013 / 0.15e2 + t1016 / 0.1e2;
  t1241 = my_piecewise3(t2, 0, t1240);
  t1242 = t1161 * t212;
  t1245 = t424 * t480;
  t1250 = 0.6e1 * t1168;
  t1252 = my_piecewise5(t16, 0, t12, 0, -t1206 - t1250);
  t1256 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1242 * t425 + 0.2e2 / 0.9e1 * t1245 * t184 + 0.1e2 / 0.9e1 * t476 * t431 + 0.5e1 / 0.3e1 * t91 * t1252);
  t1257 = t1256 * t31;
  t1261 = t484 * t144;
  t1264 = t7 * t1261 * t127 / 0.5e1;
  t1265 = t215 * t353;
  t1267 = t7 * t1265 * t127;
  t1276 = t7 * t440 * t247 / 0.5e1;
  t1278 = t7 * t444 * t247;
  t1281 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1257 * t127 + t1264 - t1267 / 0.3e2 + t1182 / 0.1e2 - t1186 / 0.15e2 + t1191 + 0.3e1 / 0.2e2 * t7 * t436 * t247 + t1276 - t1278 / 0.3e2);
  tv3rho31 = t423 + t449 + t1196 + t1197 + t8 * (t1241 + t1281);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1284 = t968 * t506;
  t1289 = t327 * t511;
  t1293 = my_piecewise5(t12, 0, t16, 0, -t1206 - t1207);
  t1297 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1284 * t136 + 0.2e2 / 0.9e1 * t452 * t456 + 0.1e2 / 0.9e1 * t1289 * t136 + 0.5e1 / 0.3e1 * t27 * t1293);
  t1298 = t1297 * t31;
  t1302 = t515 * t144;
  t1304 = t7 * t1302 * t79;
  t1313 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1298 * t79 + t1304 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t516 * t176 + t1221 - t1227 / 0.15e2 + t1231 - t998 / 0.3e2 + t1011 - t1013 / 0.3e2);
  t1314 = t1161 * t523;
  t1319 = t424 * t528;
  t1323 = my_piecewise5(t16, 0, t12, 0, t1206 - t1250);
  t1327 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1314 * t184 + 0.2e2 / 0.9e1 * t476 * t480 + 0.1e2 / 0.9e1 * t1319 * t184 + 0.5e1 / 0.3e1 * t91 * t1323);
  t1328 = t1327 * t31;
  t1332 = t532 * t144;
  t1334 = t7 * t1332 * t127;
  t1341 = t7 * t489 * t247;
  t1349 = t7 * t192 * t599;
  t1351 = 0.3e1 / 0.2e2 * t7 * t1328 * t127 + t1334 / 0.1e2 + t1264 - t1267 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t485 * t247 + t1341 / 0.5e1 - t1186 / 0.3e2 + t1191 + t1276 - t1278 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t188 * t599 + t1349 / 0.1e2;
  t1352 = my_piecewise3(t84, 0, t1351);
  tv3rho32 = t1196 + t1197 + t522 + t604 + t8 * (t1313 + t1352);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1357 = t506 * t201;
  t1364 = my_piecewise5(t12, 0, t16, 0, -0.6e1 * t332 - 0.6e1 * t977);
  t1368 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t968 * t1357 + 0.1e2 / 0.3e1 * t452 * t511 + 0.5e1 / 0.3e1 * t27 * t1364);
  t1369 = t1368 * t31;
  t1376 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1369 * t79 + 0.3e1 / 0.1e2 * t1304 - t1227 / 0.1e2 + t1011);
  t1377 = t523 * t212;
  t1384 = my_piecewise5(t16, 0, t12, 0, 0.6e1 * t332 - 0.6e1 * t1168);
  t1388 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1161 * t1377 + 0.1e2 / 0.3e1 * t476 * t528 + 0.5e1 / 0.3e1 * t91 * t1384);
  t1389 = t1388 * t31;
  t1406 = 0.1e1 / t97 / t542 / rho[1];
  t1409 = 0.77e3 / 0.243e3 * t38 * sigma[2] * t1406;
  t1416 = -0.154e3 / 0.81e2 * t47 * t103 * t1406 - 0.55e2 / 0.81e2 * t52 * t107 * t544 + t1409;
  t1422 = t580 * t563;
  t1423 = t560 * t1422;
  t1426 = t561 * t236;
  t1427 = t1426 * t584;
  t1428 = t560 * t1427;
  t1429 = t565 * params->csk_a;
  t1431 = t238 * t122 * t241;
  t1432 = t1429 * t1431;
  t1433 = t1428 * t1432;
  t1435 = t1426 * t238;
  t1437 = t576 * t584;
  t1438 = t575 * t1437;
  t1439 = t234 * t1435 * t1438;
  t1442 = t592 * t593 * t238;
  t1443 = t1428 * t1442;
  t1446 = t576 * t580;
  t1447 = t575 * t1446;
  t1454 = t124 / t558 / t120;
  t1456 = t563 * t238;
  t1458 = 0.1e1 / t564 / t119;
  t1459 = t1456 * t1458;
  t1460 = t567 * t122;
  t1462 = 0.1e1 / t568 / t123;
  t1463 = t1460 * t1462;
  t1464 = t1459 * t1463;
  t1466 = my_piecewise3(t115, 0, t1416);
  t1467 = my_piecewise3(t117, t1466, 0);
  t1471 = t1459 * t242;
  t1475 = t1459 * t570;
  t1478 = t1426 * t1456;
  t1479 = t1454 * t1478;
  t1480 = t1458 * t1115;
  t1481 = t1480 * t242;
  t1483 = t560 * t1478;
  t1484 = t1458 * params->csk_a;
  t1485 = t1484 * t242;
  t1488 = -t1426 * t1454 * t1464 - 0.2e1 * t1426 * t1471 * t234 - 0.3e1 * t1426 * t1475 * t560 + 0.3e1 * t1447 * t234 * t684 - t1467 * t234 * t243 - 0.3e1 * t1423 * t692 - 0.3e1 * t1423 * t707 - t1479 * t1481 + 0.3e1 * t1483 * t1485 - 0.3e1 * t1433 + 0.3e1 * t1439 - 0.3e1 * t1443 - t587;
  t1489 = t234 * t1478;
  t1492 = t1458 * t1460;
  t1493 = t1462 * t1115;
  t1494 = t1492 * t1493;
  t1498 = t569 * t584;
  t1499 = t592 * t1498;
  t1500 = t560 * t1435 * t1499;
  t1506 = t241 * t238;
  t1507 = t575 * t1506;
  t1508 = t234 * t1427 * t1507;
  t1510 = t1458 * t567;
  t1511 = t1510 * t593;
  t1517 = t569 * t580;
  t1521 = t1462 * params->csk_a;
  t1522 = t1492 * t1521;
  t1525 = t569 * t1115;
  t1526 = t1510 * t1525;
  t1531 = t234 * t580 * t236 * t586;
  t1535 = 0.3e1 * t1422 * t234 * t702 + 0.3e1 * t1517 * t592 * t685 - 0.2e1 * t1479 * t1494 + 0.3e1 * t1479 * t1511 + 0.3e1 * t1479 * t1522 - 0.3e1 * t1479 * t1526 + 0.3e1 * t1481 * t1483 - t1481 * t1489 + 0.3e1 * t1483 * t1526 - 0.3e1 * t1485 * t1489 + 0.3e1 * t1500 + 0.3e1 * t1508 - 0.3e1 * t1531;
  t1537 = my_piecewise5(t114, 0, t115, 0, t1488 + t1535);
  t1539 = t113 * t1537 + t125 * t1416 + 0.3e1 * t232 * t597 + 0.3e1 * t245 * t554 - t1409;
  t1544 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1389 * t127 + 0.3e1 / 0.1e2 * t1334 + 0.9e1 / 0.2e2 * t7 * t533 * t247 - t1267 / 0.1e2 + 0.3e1 / 0.5e1 * t1341 + 0.9e1 / 0.2e2 * t7 * t216 * t599 + t1191 - t1278 / 0.1e2 + 0.3e1 / 0.1e2 * t1349 + 0.3e1 / 0.2e2 * t7 * t94 * t1539);
  tv3rho33 = 0.3e1 * t522 + 0.3e1 * t604 + t8 * (t1376 + t1544);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1552 = t7 * t345 * t268;
  t1559 = t7 * t354 * t268 / 0.3e2;
  t1561 = t7 * t145 * t650;
  t1564 = 0.55e2 / 0.81e2 * t38 * t363;
  t1565 = t37 * t363;
  t1568 = 0.11e2 / 0.27e2 * t47 * t1565 - t1564;
  t1576 = t263 * t1070;
  t1577 = t163 * t1576;
  t1578 = t1072 * t74;
  t1580 = t1578 * t395 * t380;
  t1583 = t263 * t380;
  t1586 = t403 * t384 * t1045;
  t1587 = t163 * t1583 * t1586;
  t1589 = t380 * t167;
  t1590 = t379 * t1589;
  t1591 = t624 * t403;
  t1592 = t411 * t1591;
  t1593 = t1590 * t1592;
  t1595 = t380 * t1070;
  t1596 = t1068 * t1595;
  t1597 = t1122 * t882;
  t1600 = t170 * t1115;
  t1602 = t1578 * t1600 * t380;
  t1604 = t379 * t1576;
  t1607 = t1068 * t1576;
  t1611 = t380 * t386 * t388;
  t1612 = t1116 * t1611;
  t1615 = t412 * t399;
  t1616 = t411 * t1615;
  t1618 = t1146 * t380;
  t1619 = t1131 * t1618;
  t1622 = t633 * t382;
  t1623 = t163 * t1622;
  t1629 = t379 * t1622;
  t1632 = t1057 * t628 - t1057 * t642 - 0.3e1 * t1577 * t1580 - t1577 * t1602 + 0.3e1 * t1596 * t1597 + 0.3e1 * t1602 * t1604 - t1602 * t1607 + 0.3e1 * t1604 * t1612 - 0.3e1 * t1607 * t1612 - 0.2e1 * t1607 * t1619 - t1616 * t642 + 0.2e1 * t1623 * t630 - 0.2e1 * t1629 * t645 + 0.3e1 * t1587 + 0.3e1 * t1593 - t638;
  t1633 = t1076 * t263;
  t1634 = t1633 * params->csk_a;
  t1635 = t1131 * t1634;
  t1642 = t1583 * t403;
  t1643 = t379 * t1642;
  t1644 = t1643 * t1046;
  t1646 = t263 * t167;
  t1647 = t1646 * t384;
  t1648 = t163 * t1647;
  t1649 = params->csk_a * t380;
  t1650 = t1649 * t403;
  t1651 = t171 * t1650;
  t1652 = t1648 * t1651;
  t1654 = t1643 * t1063;
  t1656 = my_piecewise3(t67, 0, t1568);
  t1657 = my_piecewise3(t69, t1656, 0);
  t1660 = t170 * t380;
  t1661 = t1578 * t1660;
  t1664 = t379 * t1595;
  t1665 = t1122 * t624;
  t1670 = t163 * t263 * t399 * t405;
  t1671 = t170 * t399;
  t1672 = t394 * t1671;
  t1675 = t388 * t633;
  t1676 = t411 * t1675;
  t1681 = t633 * t165;
  t1683 = t163 * t1681 * t405;
  t1687 = -t1131 * t1596 * t1633 - t163 * t1657 * t172 + t1037 * t625 - 0.2e1 * t1577 * t1661 + 0.3e1 * t1580 * t1604 + 0.3e1 * t1596 * t1635 + 0.2e1 * t1623 * t640 - 0.2e1 * t1629 * t630 - 0.3e1 * t1664 * t1665 + t1672 * t628 + 0.2e1 * t1676 * t623 - 0.3e1 * t1644 + 0.3e1 * t1652 - 0.3e1 * t1654 - t1670 - 0.2e1 * t1683;
  t1689 = my_piecewise5(t64, 0, t67, 0, t1632 + t1687);
  t1691 = t1568 * t77 + 0.2e1 * t161 * t648 + t1689 * t59 + 0.2e1 * t174 * t618 + t260 * t416 + t266 * t373 + t1564;
  t1696 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t268 + t1552 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t650 - t1559 + t1561 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t1691);
  tv3rho2sigma0 = t1696 * t8 + 0.2e1 * t655;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1703 = t7 * t440 * t286;
  t1707 = t7 * t444 * t286 / 0.3e2;
  t1709 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t286 + t1703 / 0.5e1 - t1707);
  tv3rho2sigma2 = t1709 * t8 + 0.2e1 * t664;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1715 = t7 * t465 * t268;
  t1723 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t268 + t1715 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t650 + t1552 / 0.1e2 - t1559 + t1561 / 0.1e2);
  tv3rho2sigma3 = t1723 * t8 + t655 + t670;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1729 = t7 * t489 * t286;
  t1736 = t7 * t192 * t712;
  t1739 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t286 + t1729 / 0.1e2 + t1703 / 0.1e2 - t1707 + 0.3e1 / 0.2e2 * t7 * t188 * t712 + t1736 / 0.1e2);
  tv3rho2sigma5 = t1739 * t8 + t664 + t717;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1747 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t268 + t1715 / 0.5e1 - t1559);
  tv3rho2sigma6 = t1747 * t8 + 0.2e1 * t670;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1759 = 0.55e2 / 0.81e2 * t38 * t544;
  t1760 = t37 * t544;
  t1763 = 0.11e2 / 0.27e2 * t47 * t1760 - t1759;
  t1771 = t281 * t1456;
  t1772 = t234 * t1771;
  t1773 = t1458 * t122;
  t1774 = t576 * t561;
  t1775 = t1773 * t1774;
  t1778 = t561 * t238;
  t1779 = t560 * t1778;
  t1780 = t686 * t584;
  t1781 = t592 * t1780;
  t1782 = t1779 * t1781;
  t1784 = t281 * t561;
  t1787 = t584 * t565 * t1431;
  t1788 = t234 * t1784 * t1787;
  t1790 = t1454 * t1771;
  t1792 = t561 * t122 * t241;
  t1793 = t1480 * t1792;
  t1795 = t561 * t1456;
  t1796 = t1454 * t1795;
  t1797 = t1510 * t908;
  t1801 = t560 * t1771;
  t1806 = t561 * t567 * t569;
  t1807 = t1480 * t1806;
  t1810 = t593 * t580;
  t1811 = t592 * t1810;
  t1813 = t1493 * t561;
  t1814 = t1492 * t1813;
  t1817 = t1462 * t281;
  t1818 = t1817 * params->csk_a;
  t1819 = t1492 * t1818;
  t1822 = t695 * t563;
  t1823 = t234 * t1822;
  t1829 = t1447 * t690 - t1447 * t704 - 0.3e1 * t1772 * t1775 - t1772 * t1793 - t1790 * t1793 - 0.3e1 * t1790 * t1807 - 0.2e1 * t1790 * t1814 + 0.3e1 * t1793 * t1801 + 0.3e1 * t1796 * t1797 + 0.3e1 * t1796 * t1819 + 0.3e1 * t1801 * t1807 - t1811 * t704 + 0.2e1 * t1823 * t692 + 0.3e1 * t1782 + 0.3e1 * t1788 - t700;
  t1830 = t560 * t1822;
  t1837 = t1784 * t584;
  t1838 = t560 * t1837;
  t1839 = t1838 * t1432;
  t1841 = t281 * t238;
  t1842 = t1841 * t565;
  t1843 = t234 * t1842;
  t1844 = params->csk_a * t561;
  t1845 = t1844 * t584;
  t1846 = t242 * t1845;
  t1847 = t1843 * t1846;
  t1849 = t1838 * t1442;
  t1851 = my_piecewise3(t115, 0, t1763);
  t1852 = my_piecewise3(t117, t1851, 0);
  t1855 = t241 * t580;
  t1856 = t575 * t1855;
  t1858 = t560 * t1795;
  t1859 = t1510 * t686;
  t1862 = t241 * t561;
  t1863 = t1773 * t1862;
  t1868 = t234 * t695 * t236 * t586;
  t1872 = t234 * t281 * t580 * t586;
  t1874 = t569 * t695;
  t1875 = t592 * t1874;
  t1882 = -t1492 * t1796 * t1817 - t1852 * t234 * t243 + t1423 * t687 - 0.2e1 * t1772 * t1863 + 0.3e1 * t1775 * t1801 + 0.2e1 * t1823 * t702 - 0.2e1 * t1830 * t692 - 0.2e1 * t1830 * t707 + t1856 * t690 - 0.3e1 * t1858 * t1859 + 0.2e1 * t1875 * t685 - 0.3e1 * t1839 + 0.3e1 * t1847 - 0.3e1 * t1849 - 0.2e1 * t1868 - t1872;
  t1884 = my_piecewise5(t114, 0, t115, 0, t1829 + t1882);
  t1886 = t113 * t1884 + t125 * t1763 + 0.2e1 * t232 * t710 + 0.2e1 * t245 * t680 + t278 * t597 + t284 * t554 + t1759;
  t1891 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t286 + t1729 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t712 - t1707 + t1736 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t1886);
  tv3rho2sigma8 = t1891 * t8 + 0.2e1 * t717;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1898 = t7 * t345 * t303;
  t1905 = t7 * t354 * t303 / 0.3e2;
  t1907 = t7 * t145 * t754;
  t1921 = t298 * t1070;
  t1922 = t379 * t1921;
  t1925 = t741 * t382;
  t1926 = t379 * t1925;
  t1929 = t163 * t1921;
  t1932 = t732 * t403;
  t1933 = t411 * t1932;
  t1934 = t1590 * t1933;
  t1936 = t298 * t380;
  t1938 = t163 * t1936 * t1586;
  t1940 = t732 * params->csk_a;
  t1941 = t1122 * t1940;
  t1947 = t1068 * t1921;
  t1955 = t1076 * t298;
  t1956 = t1955 * params->csk_a;
  t1957 = t1131 * t1956;
  t1960 = t163 * t1925;
  t1963 = -t1057 * t748 + 0.3e1 * t1580 * t1922 - 0.3e1 * t1580 * t1929 + 0.3e1 * t1596 * t1941 + 0.3e1 * t1596 * t1957 + 0.3e1 * t1602 * t1922 - t1602 * t1929 - t1602 * t1947 - 0.3e1 * t1612 * t1947 - t1616 * t748 - 0.2e1 * t1619 * t1947 - 0.2e1 * t1926 * t630 + 0.2e1 * t1960 * t630 + 0.3e1 * t1934 + 0.3e1 * t1938 - t746;
  t1970 = t379 * t1936 * t403;
  t1971 = t1970 * t1046;
  t1974 = t298 * t167 * t384;
  t1975 = t163 * t1974;
  t1976 = t1975 * t1651;
  t1978 = t1970 * t1063;
  t1982 = my_piecewise3(t67, 0, 0.5e1 / 0.27e2 * t52 * t615);
  t1983 = my_piecewise3(t69, t1982, 0);
  t1988 = t388 * t741;
  t1989 = t411 * t1988;
  t1992 = t1131 * t1955;
  t1994 = t741 * t165;
  t1996 = t163 * t1994 * t405;
  t1998 = t298 * t399;
  t2000 = t163 * t1998 * t405;
  t2003 = t1122 * t732;
  t2008 = -t163 * t172 * t1983 + t1037 * t733 + t1057 * t736 - t1596 * t1992 + 0.3e1 * t1612 * t1922 - 0.2e1 * t1661 * t1929 - 0.3e1 * t1664 * t2003 + t1672 * t736 - 0.2e1 * t1926 * t645 + 0.2e1 * t1960 * t640 + 0.2e1 * t1989 * t623 - 0.3e1 * t1971 + 0.3e1 * t1976 - 0.3e1 * t1978 - 0.2e1 * t1996 - t2000;
  t2010 = my_piecewise5(t64, 0, t67, 0, t1963 + t2008);
  t2012 = 0.5e1 / 0.27e2 * t52 * t615 * t77 - 0.5e1 / 0.36e2 * t52 * t257 * t174 + t52 * t291 * t416 / 0.24e2 + t373 * t301 + 0.2e1 * t161 * t752 + t59 * t2010;
  t2017 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t303 + t1898 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t754 - t1905 + t1907 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t2012);
  tv3rho2lapl0 = t2017 * t8 + 0.2e1 * t759;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t2024 = t7 * t440 * t320;
  t2028 = t7 * t444 * t320 / 0.3e2;
  t2030 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t320 + t2024 / 0.5e1 - t2028);
  tv3rho2lapl1 = t2030 * t8 + 0.2e1 * t768;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2036 = t7 * t465 * t303;
  t2044 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t303 + t2036 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t754 + t1898 / 0.1e2 - t1905 + t1907 / 0.1e2);
  tv3rho2lapl2 = t2044 * t8 + t759 + t774;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2050 = t7 * t489 * t320;
  t2057 = t7 * t192 * t808;
  t2060 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t320 + t2050 / 0.1e2 + t2024 / 0.1e2 - t2028 + 0.3e1 / 0.2e2 * t7 * t188 * t808 + t2057 / 0.1e2);
  tv3rho2lapl3 = t2060 * t8 + t768 + t813;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2068 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t303 + t2036 / 0.5e1 - t1905);
  tv3rho2lapl4 = t2068 * t8 + 0.2e1 * t774;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2091 = t315 * t1456;
  t2092 = t560 * t2091;
  t2095 = t795 * t563;
  t2096 = t560 * t2095;
  t2099 = t234 * t2091;
  t2102 = t786 * t584;
  t2103 = t592 * t2102;
  t2104 = t1779 * t2103;
  t2106 = t315 * t561;
  t2108 = t234 * t2106 * t1787;
  t2110 = t786 * params->csk_a;
  t2111 = t1510 * t2110;
  t2117 = t1454 * t2091;
  t2119 = t1462 * t315;
  t2120 = t2119 * params->csk_a;
  t2121 = t1492 * t2120;
  t2124 = t234 * t2095;
  t2133 = t1447 * t790 - t1447 * t802 + 0.3e1 * t1775 * t2092 - 0.3e1 * t1775 * t2099 + 0.3e1 * t1793 * t2092 - t1793 * t2099 - t1793 * t2117 + 0.3e1 * t1796 * t2111 + 0.3e1 * t1796 * t2121 + 0.3e1 * t1807 * t2092 - 0.2e1 * t2096 * t692 - 0.2e1 * t2096 * t707 + 0.2e1 * t2124 * t692 + 0.3e1 * t2104 + 0.3e1 * t2108 - t800;
  t2140 = t560 * t2106 * t584;
  t2141 = t2140 * t1432;
  t2144 = t315 * t238 * t565;
  t2145 = t234 * t2144;
  t2146 = t2145 * t1846;
  t2148 = t2140 * t1442;
  t2152 = my_piecewise3(t115, 0, 0.5e1 / 0.27e2 * t52 * t677);
  t2153 = my_piecewise3(t117, t2152, 0);
  t2156 = t795 * t236;
  t2158 = t234 * t2156 * t586;
  t2160 = t315 * t580;
  t2162 = t234 * t2160 * t586;
  t2165 = t569 * t795;
  t2166 = t592 * t2165;
  t2169 = t1492 * t2119;
  t2171 = t1510 * t786;
  t2178 = -t2153 * t234 * t243 + t1423 * t787 - t1796 * t2169 - 0.3e1 * t1807 * t2117 - t1811 * t802 - 0.2e1 * t1814 * t2117 + t1856 * t790 - 0.3e1 * t1858 * t2171 - 0.2e1 * t1863 * t2099 + 0.2e1 * t2124 * t702 + 0.2e1 * t2166 * t685 - 0.3e1 * t2141 + 0.3e1 * t2146 - 0.3e1 * t2148 - 0.2e1 * t2158 - t2162;
  t2180 = my_piecewise5(t114, 0, t115, 0, t2133 + t2178);
  t2182 = 0.5e1 / 0.27e2 * t52 * t677 * t125 - 0.5e1 / 0.36e2 * t52 * t275 * t245 + t52 * t308 * t597 / 0.24e2 + t554 * t318 + 0.2e1 * t232 * t806 + t113 * t2180;
  t2187 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t320 + t2050 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t808 - t2028 + t2057 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t2182);
  tv3rho2lapl5 = t2187 * t8 + 0.2e1 * t813;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2194 = t7 * t145 * t836 / 0.1e2;
  t2200 = t817 * t1070;
  t2201 = t1068 * t2200;
  t2202 = t1122 * t644;
  t2205 = t163 * t2200;
  t2207 = t1578 * t1600 * t165;
  t2209 = t379 * t2200;
  t2214 = t165 * t74 * t170;
  t2215 = t1094 * t2214;
  t2218 = t824 * t382;
  t2219 = t163 * t2218;
  t2220 = t2219 * t630;
  t2221 = t379 * t2218;
  t2222 = t2221 * t630;
  t2225 = t1136 * t165;
  t2226 = t1122 * t2225;
  t2229 = t2221 * t645;
  t2230 = t817 * t403;
  t2231 = t163 * t2230;
  t2233 = t394 * t639 * t167;
  t2234 = t2231 * t2233;
  t2236 = t171 * t633;
  t2237 = t1043 * t2236;
  t2242 = t412 * t633;
  t2243 = t411 * t2242;
  t2246 = t817 * t167;
  t2247 = t379 * t2246;
  t2248 = t388 * t165;
  t2249 = t2248 * t403;
  t2250 = t411 * t2249;
  t2251 = t2247 * t2250;
  t2253 = t1132 * t165;
  t2254 = t1131 * t2253;
  t2257 = 0.3e1 * t2201 * t2202 - t2201 * t2207 - 0.3e1 * t2201 * t2226 + 0.3e1 * t2201 * t2254 - t2205 * t2207 - 0.3e1 * t2205 * t2215 + 0.3e1 * t2207 * t2209 + 0.3e1 * t2209 * t2215 + 0.3e1 * t2209 * t2226 - 0.2e1 * t2237 * t642 - 0.2e1 * t2243 * t642 + t2220 - t2222 - t2229 + 0.3e1 * t2234 + 0.3e1 * t2251;
  t2260 = t1146 * t165;
  t2261 = t1131 * t2260;
  t2265 = t379 * t2230 * t384;
  t2266 = params->csk_a * t165;
  t2267 = t2266 * t1045;
  t2268 = t2265 * t2267;
  t2271 = t163 * t2246 * t384;
  t2272 = t2266 * t403;
  t2273 = t171 * t2272;
  t2274 = t2271 * t2273;
  t2276 = t2266 * t167;
  t2277 = t389 * t2276;
  t2278 = t2265 * t2277;
  t2280 = t388 * t824;
  t2281 = t411 * t2280;
  t2282 = t623 * t2281;
  t2283 = t824 * t165;
  t2285 = t163 * t2283 * t405;
  t2286 = t263 * t403;
  t2287 = t163 * t2286;
  t2288 = t168 * t74;
  t2289 = t170 * t633;
  t2291 = t2287 * t2288 * t2289;
  t2292 = 0.2e1 * t2291;
  t2293 = t394 * t2289;
  t2298 = t165 * t1070;
  t2299 = t1068 * t2298;
  t2300 = t1076 * t817;
  t2301 = t1131 * t2300;
  t2303 = t2219 * t640;
  t2304 = t1578 * t639;
  t2307 = t1122 * t2248;
  t2310 = 0.2e1 * t1676 * t642 - 0.2e1 * t2201 * t2261 - 0.2e1 * t2205 * t2304 - 0.3e1 * t2209 * t2307 + 0.2e1 * t2237 * t628 + 0.2e1 * t2293 * t628 - t2299 * t2301 - 0.3e1 * t2268 + 0.3e1 * t2274 - 0.3e1 * t2278 + t2282 - t2285 - t2292 + t2303 - t826 - t828;
  t2312 = my_piecewise5(t64, 0, t67, 0, t2257 + t2310);
  t2314 = t161 * t834 + t2312 * t59 + 0.2e1 * t260 * t648 + 0.2e1 * t266 * t618;
  t2319 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t836 + t2194 + 0.3e1 / 0.2e2 * t7 * t32 * t2314);
  tv3rhosigma20 = t2319 * t8 + t840;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2326 = t7 * t192 * t862 / 0.1e2;
  t2328 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t862 + t2326);
  tv3rhosigma25 = t2328 * t8 + t866;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2334 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t836 + t2194);
  tv3rhosigma26 = t2334 * t8 + t840;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2344 = t843 * t1456;
  t2345 = t1454 * t2344;
  t2346 = t1521 * t236;
  t2347 = t1492 * t2346;
  t2350 = t576 * t695;
  t2351 = t575 * t2350;
  t2354 = t560 * t2344;
  t2355 = t1525 * t236;
  t2356 = t1510 * t2355;
  t2359 = t850 * t563;
  t2360 = t560 * t2359;
  t2361 = t2360 * t707;
  t2362 = t843 * t584;
  t2363 = t234 * t2362;
  t2365 = t575 * t701 * t238;
  t2366 = t2363 * t2365;
  t2370 = t843 * t238;
  t2371 = t560 * t2370;
  t2372 = t569 * t236;
  t2373 = t2372 * t584;
  t2374 = t592 * t2373;
  t2375 = t2371 * t2374;
  t2377 = t1510 * t706;
  t2380 = t234 * t2344;
  t2381 = t241 * t1115;
  t2383 = t1773 * t2381 * t236;
  t2388 = t234 * t2359;
  t2389 = t2388 * t692;
  t2390 = t2360 * t692;
  t2392 = t236 * t122 * t241;
  t2393 = t1484 * t2392;
  t2400 = 0.3e1 * t2345 * t2347 - 0.3e1 * t2345 * t2356 + 0.3e1 * t2345 * t2377 - t2345 * t2383 + 0.2e1 * t2351 * t690 - 0.2e1 * t2351 * t704 + 0.3e1 * t2354 * t2356 + 0.3e1 * t2354 * t2383 + 0.3e1 * t2354 * t2393 - t2380 * t2383 - 0.3e1 * t2380 * t2393 - t2361 + 0.3e1 * t2366 + 0.3e1 * t2375 + t2389 - t2390;
  t2401 = t593 * t695;
  t2402 = t592 * t2401;
  t2405 = t1493 * t236;
  t2406 = t1492 * t2405;
  t2410 = t560 * t2362 * t565;
  t2411 = params->csk_a * t236;
  t2412 = t2411 * t1431;
  t2413 = t2410 * t2412;
  t2416 = t234 * t2370 * t565;
  t2417 = t2411 * t584;
  t2418 = t242 * t2417;
  t2419 = t2416 * t2418;
  t2421 = t2411 * t238;
  t2422 = t570 * t2421;
  t2423 = t2410 * t2422;
  t2425 = t2388 * t702;
  t2426 = t1773 * t701;
  t2429 = t1510 * t2372;
  t2434 = t234 * t850 * t236 * t586;
  t2435 = t281 * t584;
  t2436 = t234 * t2435;
  t2437 = t239 * t122;
  t2438 = t241 * t695;
  t2440 = t2436 * t2437 * t2438;
  t2441 = 0.2e1 * t2440;
  t2442 = t575 * t2438;
  t2447 = t236 * t1456;
  t2448 = t1454 * t2447;
  t2449 = t1462 * t843;
  t2450 = t1492 * t2449;
  t2452 = t569 * t850;
  t2453 = t592 * t2452;
  t2454 = t685 * t2453;
  t2455 = 0.2e1 * t1875 * t704 - 0.2e1 * t2345 * t2406 - 0.3e1 * t2354 * t2429 - 0.2e1 * t2380 * t2426 - 0.2e1 * t2402 * t704 + 0.2e1 * t2442 * t690 - t2448 * t2450 - 0.3e1 * t2413 + 0.3e1 * t2419 - 0.3e1 * t2423 + t2425 - t2434 - t2441 + t2454 - t852 - t854;
  t2457 = my_piecewise5(t114, 0, t115, 0, t2400 + t2455);
  t2459 = t113 * t2457 + t232 * t860 + 0.2e1 * t278 * t710 + 0.2e1 * t284 * t680;
  t2464 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t862 + t2326 + 0.3e1 / 0.2e2 * t7 * t94 * t2459);
  tv3rhosigma211 = t2464 * t8 + t866;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2471 = t7 * t145 * t888 / 0.1e2;
  t2481 = t1633 * t298;
  t2482 = t1131 * t2481;
  t2486 = t878 * t165;
  t2487 = t1578 * t2486;
  t2490 = t732 * t165;
  t2491 = t1122 * t2490;
  t2498 = t1921 * t1072;
  t2499 = t1068 * t2498;
  t2500 = t1115 * t263;
  t2501 = t389 * t165;
  t2502 = t2500 * t2501;
  t2505 = t2500 * t165;
  t2506 = t1077 * t2505;
  t2509 = t379 * t1647;
  t2511 = t389 * t744 * t403;
  t2512 = t2509 * t2511;
  t2514 = t1576 * t1072;
  t2515 = t1068 * t2514;
  t2516 = t298 * params->csk_a;
  t2517 = t2516 * t165;
  t2518 = t1077 * t2517;
  t2521 = t379 * t2498;
  t2524 = t389 * t2517;
  t2527 = t163 * t2498;
  t2528 = t171 * t2505;
  t2530 = -0.3e1 * t1604 * t2491 - t1926 * t873 - t1926 * t883 - 0.2e1 * t1929 * t2487 + t1960 * t873 + t2237 * t736 - t2237 * t748 - t2243 * t748 - t2299 * t2482 - 0.3e1 * t2499 * t2502 - 0.2e1 * t2499 * t2506 + 0.3e1 * t2502 * t2521 + 0.3e1 * t2515 * t2518 + 0.3e1 * t2515 * t2524 - t2527 * t2528 + t2220 - t2222 - t2229 + 0.3e1 * t2512;
  t2534 = t171 * t263;
  t2535 = t2266 * t2534;
  t2540 = t875 * t403;
  t2541 = t163 * t2540;
  t2542 = t2541 * t2233;
  t2544 = t379 * t2540;
  t2546 = t1043 * t165 * t1045;
  t2547 = t2544 * t2546;
  t2549 = t171 * params->csk_a;
  t2550 = t636 * t403;
  t2551 = t2549 * t2550;
  t2552 = t1975 * t2551;
  t2554 = t411 * t388;
  t2555 = t2554 * t2276;
  t2556 = t2544 * t2555;
  t2558 = t741 * t263;
  t2560 = t163 * t2558 * t405;
  t2561 = t298 * t633;
  t2563 = t163 * t2561 * t405;
  t2568 = t1629 * t733 + t1960 * t879 + t1989 * t642 + t2293 * t736 - t2499 * t2528 + 0.3e1 * t2521 * t2528 + 0.3e1 * t2521 * t2535 - 0.3e1 * t2527 * t2535 + t2282 - t2285 + t2303 + 0.3e1 * t2542 - 0.3e1 * t2547 + 0.3e1 * t2552 - 0.3e1 * t2556 - t2560 - t2563 - t826 - t877;
  t2570 = my_piecewise5(t64, 0, t67, 0, t2530 + t2568);
  t2572 = -0.5e1 / 0.72e2 * t52 * t257 * t266 + t52 * t291 * t648 / 0.24e2 + t618 * t301 + t260 * t752 + t161 * t886 + t59 * t2570;
  t2577 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t888 + t2471 + 0.3e1 / 0.2e2 * t7 * t32 * t2572);
  tv3rhosigmalapl0 = t2577 * t8 + t892;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2584 = t7 * t192 * t914 / 0.1e2;
  t2586 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t914 + t2584);
  tv3rhosigmalapl5 = t2586 * t8 + t918;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2592 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t888 + t2471);
  tv3rhosigmalapl6 = t2592 * t8 + t892;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2612 = t1817 * t315;
  t2613 = t1492 * t2612;
  t2615 = t904 * t236;
  t2616 = t1773 * t2615;
  t2619 = t2091 * t1458;
  t2620 = t1454 * t2619;
  t2621 = t1115 * t281;
  t2622 = t570 * t236;
  t2623 = t2621 * t2622;
  t2626 = t560 * t1842;
  t2628 = t570 * t798 * t584;
  t2629 = t2626 * t2628;
  t2631 = t1771 * t1458;
  t2632 = t1454 * t2631;
  t2633 = t315 * params->csk_a;
  t2634 = t2633 * t236;
  t2635 = t1463 * t2634;
  t2638 = t570 * t2634;
  t2641 = t234 * t2619;
  t2642 = t2621 * t236;
  t2643 = t242 * t2642;
  t2645 = t560 * t2619;
  t2649 = t242 * t281;
  t2650 = t2411 * t2649;
  t2653 = -t2096 * t899 - t2096 * t909 - 0.2e1 * t2099 * t2616 + t2124 * t899 + t2351 * t790 - t2351 * t802 - t2402 * t802 - t2448 * t2613 - 0.3e1 * t2620 * t2623 - t2620 * t2643 + 0.3e1 * t2632 * t2635 + 0.3e1 * t2632 * t2638 - t2641 * t2643 + 0.3e1 * t2643 * t2645 + 0.3e1 * t2645 * t2650 - t2361 + t2389 - t2390 + 0.3e1 * t2629;
  t2656 = t1463 * t2642;
  t2661 = t901 * t584;
  t2662 = t234 * t2661;
  t2663 = t2662 * t2365;
  t2665 = t560 * t2661;
  t2667 = t1429 * t236 * t1431;
  t2668 = t2665 * t2667;
  t2670 = t242 * params->csk_a;
  t2671 = t698 * t584;
  t2672 = t2670 * t2671;
  t2673 = t2145 * t2672;
  t2675 = t592 * t569;
  t2676 = t2675 * t2421;
  t2677 = t2665 * t2676;
  t2679 = t786 * t236;
  t2680 = t1510 * t2679;
  t2683 = t795 * t281;
  t2685 = t234 * t2683 * t586;
  t2686 = t315 * t695;
  t2688 = t234 * t2686 * t586;
  t2693 = -0.3e1 * t1801 * t2680 + t1830 * t787 + t2124 * t905 + t2166 * t704 + t2442 * t790 - 0.2e1 * t2620 * t2656 + 0.3e1 * t2623 * t2645 - 0.3e1 * t2641 * t2650 + t2425 - t2434 + t2454 + 0.3e1 * t2663 - 0.3e1 * t2668 + 0.3e1 * t2673 - 0.3e1 * t2677 - t2685 - t2688 - t852 - t903;
  t2695 = my_piecewise5(t114, 0, t115, 0, t2653 + t2693);
  t2697 = -0.5e1 / 0.72e2 * t52 * t275 * t284 + t52 * t308 * t710 / 0.24e2 + t680 * t318 + t278 * t806 + t232 * t912 + t113 * t2695;
  t2702 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t914 + t2584 + 0.3e1 / 0.2e2 * t7 * t94 * t2697);
  tv3rhosigmalapl11 = t2702 * t8 + t918;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2709 = t7 * t145 * t937 / 0.1e2;
  t2717 = t922 * t167;
  t2719 = t163 * t2717 * t384;
  t2720 = t2719 * t2273;
  t2722 = t922 * t403;
  t2724 = t379 * t2722 * t384;
  t2725 = t2724 * t2277;
  t2727 = t2724 * t2267;
  t2729 = t922 * t1070;
  t2730 = t1068 * t2729;
  t2733 = t163 * t2729;
  t2735 = t379 * t2729;
  t2743 = t412 * t741;
  t2749 = -0.2e1 * t2743 * t411 * t748 + 0.3e1 * t2202 * t2730 - t2207 * t2730 - t2207 * t2733 + 0.3e1 * t2207 * t2735 - 0.3e1 * t2215 * t2733 + 0.3e1 * t2215 * t2735 - 0.2e1 * t2261 * t2730 + t2220 - t2222 - t2229 + 0.3e1 * t2720 - 0.3e1 * t2725 - 0.3e1 * t2727 - t826 - t929;
  t2753 = t394 * t395 * t741;
  t2758 = t163 * t2722;
  t2759 = t2758 * t2233;
  t2765 = t379 * t2717;
  t2766 = t2765 * t2250;
  t2774 = t1076 * t922;
  t2775 = t1131 * t2774;
  t2777 = t298 * t403;
  t2778 = t163 * t2777;
  t2779 = t170 * t741;
  t2781 = t2778 * t2288 * t2779;
  t2782 = 0.2e1 * t2781;
  t2786 = 0.2e1 * t2779 * t394 * t736 + 0.2e1 * t1989 * t748 - 0.3e1 * t2226 * t2730 + 0.3e1 * t2226 * t2735 + 0.3e1 * t2254 * t2730 - t2299 * t2775 - 0.2e1 * t2304 * t2733 - 0.3e1 * t2307 * t2735 + 0.2e1 * t2753 * t736 - 0.2e1 * t2753 * t748 + t2282 - t2285 + t2303 + 0.3e1 * t2759 + 0.3e1 * t2766 - t2782;
  t2788 = my_piecewise5(t64, 0, t67, 0, t2749 + t2786);
  t2790 = -0.5e1 / 0.36e2 * t52 * t257 * t301 + t52 * t291 * t752 / 0.12e2 + t161 * t935 + t59 * t2788;
  t2795 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t937 + t2709 + 0.3e1 / 0.2e2 * t7 * t32 * t2790);
  tv3rholapl20 = t2795 * t8 + t941;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2802 = t7 * t192 * t960 / 0.1e2;
  t2804 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t960 + t2802);
  tv3rholapl22 = t2804 * t8 + t964;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2810 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t937 + t2709);
  tv3rholapl23 = t2810 * t8 + t941;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2822 = t945 * t584;
  t2824 = t560 * t2822 * t565;
  t2825 = t2824 * t2412;
  t2827 = t945 * t238;
  t2829 = t234 * t2827 * t565;
  t2830 = t2829 * t2418;
  t2832 = t2824 * t2422;
  t2834 = t945 * t1456;
  t2835 = t1454 * t2834;
  t2839 = t575 * t576 * t795;
  t2845 = t234 * t2834;
  t2847 = t560 * t2834;
  t2856 = 0.3e1 * t2347 * t2835 + 0.3e1 * t2377 * t2835 - t2383 * t2835 - t2383 * t2845 + 0.3e1 * t2383 * t2847 - 0.3e1 * t2393 * t2845 + 0.3e1 * t2393 * t2847 - 0.2e1 * t2406 * t2835 + 0.2e1 * t2839 * t790 - t2361 + t2389 - t2390 - 0.3e1 * t2825 + 0.3e1 * t2830 - 0.3e1 * t2832 - t952;
  t2859 = t234 * t2822;
  t2860 = t2859 * t2365;
  t2866 = t593 * t795;
  t2870 = t560 * t2827;
  t2871 = t2870 * t2374;
  t2877 = t1462 * t945;
  t2878 = t1492 * t2877;
  t2880 = t315 * t584;
  t2881 = t234 * t2880;
  t2882 = t241 * t795;
  t2884 = t2881 * t2437 * t2882;
  t2885 = 0.2e1 * t2884;
  t2891 = -0.2e1 * t2866 * t592 * t802 + 0.2e1 * t2882 * t575 * t790 + 0.2e1 * t2166 * t802 - 0.3e1 * t2356 * t2835 + 0.3e1 * t2356 * t2847 - 0.2e1 * t2426 * t2845 - 0.3e1 * t2429 * t2847 - t2448 * t2878 - 0.2e1 * t2839 * t802 + t2425 - t2434 + t2454 + 0.3e1 * t2860 + 0.3e1 * t2871 - t2885 - t852;
  t2893 = my_piecewise5(t114, 0, t115, 0, t2856 + t2891);
  t2895 = -0.5e1 / 0.36e2 * t52 * t275 * t318 + t52 * t308 * t806 / 0.12e2 + t232 * t958 + t113 * t2893;
  t2900 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t960 + t2802 + 0.3e1 / 0.2e2 * t7 * t94 * t2895);
  tv3rholapl25 = t2900 * t8 + t964;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2904 = t817 * t263;
  t2913 = t395 * t824;
  t2914 = t394 * t2913;
  t2915 = t628 * t2914;
  t2916 = 0.3e1 * t2915;
  t2917 = t2221 * t883;
  t2918 = 0.3e1 * t2917;
  t2919 = t2904 * t403;
  t2920 = t379 * t2919;
  t2921 = t2920 * t1063;
  t2922 = 0.3e1 * t2921;
  t2923 = t2221 * t873;
  t2924 = 0.3e1 * t2923;
  t2925 = t2920 * t1046;
  t2926 = 0.3e1 * t2925;
  t2927 = t2904 * t167;
  t2929 = t163 * t2927 * t1052;
  t2930 = 0.3e1 * t2929;
  t2931 = t2904 * t1070;
  t2932 = t1068 * t2931;
  t2937 = -t1068 * t1078 * t2904 - 0.3e1 * t1085 * t2904 * t379 - 0.2e1 * t1089 * t163 * t2904 - 0.3e1 * t1137 * t2932 - 0.2e1 * t1147 * t2932 + t2916 - t2918 - t2922 - t2924 - t2926 + t2930 - t826 - t828;
  t2938 = t642 * t2281;
  t2939 = 0.3e1 * t2938;
  t2942 = t379 * t2931;
  t2945 = t824 * t263;
  t2947 = t163 * t2945 * t405;
  t2948 = 0.3e1 * t2947;
  t2950 = t379 * t2927 * t1104;
  t2951 = 0.3e1 * t2950;
  t2952 = t2219 * t879;
  t2953 = 0.3e1 * t2952;
  t2954 = t163 * t2919;
  t2955 = t2954 * t1112;
  t2956 = 0.3e1 * t2955;
  t2959 = t163 * t2931;
  t2968 = 0.3e1 * t1095 * t2942 - 0.3e1 * t1095 * t2959 - t1117 * t2932 + 0.3e1 * t1117 * t2942 - t1117 * t2959 + 0.3e1 * t1123 * t2932 + 0.3e1 * t1133 * t2932 + 0.3e1 * t1137 * t2942 + t2939 - t2948 + t2951 + t2953 + t2956;
  t2970 = my_piecewise5(t64, 0, t67, 0, t2937 + t2968);
  t2972 = 0.3e1 * t260 * t834 + t2970 * t59;
  t2976 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t2972);
  tv3sigma30 = t8 * t2976;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2979 = t843 * t281;
  t2988 = t2360 * t899;
  t2989 = 0.3e1 * t2988;
  t2990 = t2979 * t584;
  t2991 = t560 * t2990;
  t2992 = t2991 * t1432;
  t2993 = 0.3e1 * t2992;
  t2994 = t576 * t850;
  t2995 = t575 * t2994;
  t2996 = t690 * t2995;
  t2997 = 0.3e1 * t2996;
  t2998 = t2360 * t909;
  t2999 = 0.3e1 * t2998;
  t3000 = t2991 * t1442;
  t3001 = 0.3e1 * t3000;
  t3002 = t2979 * t238;
  t3004 = t234 * t3002 * t1438;
  t3005 = 0.3e1 * t3004;
  t3006 = t2979 * t1456;
  t3007 = t234 * t3006;
  t3010 = t1454 * t3006;
  t3013 = -t1454 * t1464 * t2979 - 0.2e1 * t1471 * t234 * t2979 - 0.3e1 * t1475 * t2979 * t560 - 0.3e1 * t1485 * t3007 - 0.2e1 * t1494 * t3010 - t2989 - t2993 + t2997 - t2999 - t3001 + t3005 - t852 - t854;
  t3014 = t560 * t3006;
  t3017 = t850 * t281;
  t3019 = t234 * t3017 * t586;
  t3020 = 0.3e1 * t3019;
  t3023 = t704 * t2453;
  t3024 = 0.3e1 * t3023;
  t3028 = t560 * t3002 * t1499;
  t3029 = 0.3e1 * t3028;
  t3030 = t2388 * t905;
  t3031 = 0.3e1 * t3030;
  t3032 = t234 * t2990;
  t3033 = t3032 * t1507;
  t3034 = 0.3e1 * t3033;
  t3043 = -t1481 * t3007 - t1481 * t3010 + 0.3e1 * t1481 * t3014 + 0.3e1 * t1485 * t3014 + 0.3e1 * t1511 * t3010 + 0.3e1 * t1522 * t3010 - 0.3e1 * t1526 * t3010 + 0.3e1 * t1526 * t3014 - t3020 + t3024 + t3029 + t3031 + t3034;
  t3045 = my_piecewise5(t114, 0, t115, 0, t3013 + t3043);
  t3047 = t113 * t3045 + 0.3e1 * t278 * t860;
  t3051 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3047);
  tv3sigma39 = t8 * t3051;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3057 = t298 * t817;
  t3058 = t3057 * t403;
  t3059 = t379 * t3058;
  t3060 = t3059 * t1046;
  t3061 = 0.3e1 * t3060;
  t3062 = params->csk_a * t817;
  t3063 = t3062 * t403;
  t3064 = t171 * t3063;
  t3065 = t1975 * t3064;
  t3066 = 0.3e1 * t3065;
  t3067 = t3059 * t1063;
  t3068 = 0.3e1 * t3067;
  t3069 = t736 * t2914;
  t3070 = t1136 * t817;
  t3071 = t1122 * t3070;
  t3075 = t817 * t74 * t170;
  t3076 = t1094 * t3075;
  t3084 = t1578 * t1600 * t817;
  t3089 = t2247 * t1933;
  t3090 = 0.3e1 * t3089;
  t3091 = t163 * t3057;
  t3092 = t3091 * t1586;
  t3093 = 0.3e1 * t3092;
  t3094 = t748 * t2914;
  t3097 = t412 * t824;
  t3098 = t411 * t3097;
  t3099 = t748 * t3098;
  t3100 = 0.3e1 * t1922 * t3071 + 0.3e1 * t1922 * t3076 + 0.3e1 * t1922 * t3084 - 0.3e1 * t1929 * t3076 - t1929 * t3084 + 0.3e1 * t1941 * t2201 - 0.3e1 * t1947 * t3071 - t1947 * t3084 - t3061 + t3066 - t3068 + t3069 + t3090 + t3093 - t3094 - t3099;
  t3101 = t1146 * t817;
  t3102 = t1131 * t3101;
  t3107 = 0.2e1 * t2915;
  t3108 = 0.2e1 * t2917;
  t3109 = 0.2e1 * t2923;
  t3110 = 0.2e1 * t2938;
  t3111 = 0.2e1 * t2947;
  t3112 = 0.2e1 * t2952;
  t3115 = t170 * t817;
  t3116 = t1578 * t3115;
  t3119 = t2221 * t733;
  t3121 = t298 * t824;
  t3123 = t163 * t3121 * t405;
  t3124 = t170 * t824;
  t3125 = t394 * t3124;
  t3126 = t736 * t3125;
  t3127 = -0.2e1 * t1929 * t3116 - 0.2e1 * t1947 * t3102 + 0.3e1 * t1957 * t2201 - t1992 * t2201 - 0.3e1 * t2003 * t2209 + t3107 - t3108 - t3109 + t3110 - t3111 + t3112 + t3119 - t3123 + t3126 - t826 - t877;
  t3129 = my_piecewise5(t64, 0, t67, 0, t3100 + t3127);
  t3131 = t52 * t291 * t834 / 0.24e2 + 0.2e1 * t260 * t886 + t59 * t3129;
  t3135 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3131);
  tv3sigma2lapl0 = t8 * t3135;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3141 = t315 * t843;
  t3142 = t3141 * t584;
  t3143 = t560 * t3142;
  t3144 = t3143 * t1442;
  t3145 = 0.3e1 * t3144;
  t3146 = t3143 * t1432;
  t3147 = 0.3e1 * t3146;
  t3148 = params->csk_a * t843;
  t3149 = t3148 * t584;
  t3150 = t242 * t3149;
  t3151 = t2145 * t3150;
  t3152 = 0.3e1 * t3151;
  t3154 = t1773 * t2381 * t843;
  t3158 = t802 * t2995;
  t3160 = t843 * t567 * t569;
  t3161 = t1480 * t3160;
  t3164 = t593 * t850;
  t3165 = t592 * t3164;
  t3166 = t802 * t3165;
  t3167 = t1493 * t843;
  t3168 = t1492 * t3167;
  t3173 = t790 * t2995;
  t3177 = t843 * t122 * t241;
  t3178 = t1484 * t3177;
  t3186 = 0.3e1 * t2092 * t3154 + 0.3e1 * t2092 * t3161 + 0.3e1 * t2092 * t3178 - t2099 * t3154 - 0.3e1 * t2099 * t3178 + 0.3e1 * t2111 * t2345 - t2117 * t3154 - 0.3e1 * t2117 * t3161 - 0.2e1 * t2117 * t3168 + 0.3e1 * t2121 * t2345 - t3145 - t3147 + t3152 - t3158 - t3166 + t3173;
  t3187 = t2371 * t2103;
  t3188 = 0.3e1 * t3187;
  t3189 = t234 * t3141;
  t3190 = t3189 * t1787;
  t3191 = 0.3e1 * t3190;
  t3192 = 0.2e1 * t2988;
  t3193 = 0.2e1 * t2996;
  t3194 = 0.2e1 * t2998;
  t3195 = 0.2e1 * t3019;
  t3196 = 0.2e1 * t3023;
  t3197 = 0.2e1 * t3030;
  t3200 = t241 * t843;
  t3201 = t1773 * t3200;
  t3204 = t2360 * t787;
  t3206 = t315 * t850;
  t3208 = t234 * t3206 * t586;
  t3209 = t241 * t850;
  t3210 = t575 * t3209;
  t3211 = t790 * t3210;
  t3212 = -0.2e1 * t2099 * t3201 - t2169 * t2345 - 0.3e1 * t2171 * t2354 + t3188 + t3191 - t3192 + t3193 - t3194 - t3195 + t3196 + t3197 + t3204 - t3208 + t3211 - t852 - t903;
  t3214 = my_piecewise5(t114, 0, t115, 0, t3186 + t3212);
  t3216 = t52 * t308 * t860 / 0.24e2 + 0.2e1 * t278 * t912 + t113 * t3214;
  t3220 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3216);
  tv3sigma2lapl11 = t8 * t3220;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3225 = params->csk_a * t263;
  t3227 = t2724 * t3225 * t1045;
  t3228 = 0.3e1 * t3227;
  t3232 = t1578 * t1600 * t263;
  t3237 = t1094 * t2534;
  t3240 = t389 * t263;
  t3241 = t1116 * t3240;
  t3244 = t1146 * t263;
  t3248 = t2765 * t1592;
  t3249 = 0.3e1 * t3248;
  t3256 = t2758 * t394 * t878 * t167;
  t3257 = 0.3e1 * t3256;
  t3260 = 0.2e1 * t3069;
  t3261 = 0.2e1 * t3094;
  t3262 = 0.2e1 * t3099;
  t3263 = -0.2e1 * t1131 * t2730 * t3244 + 0.3e1 * t1597 * t2730 + 0.3e1 * t1635 * t2730 - t2730 * t3232 - 0.3e1 * t2730 * t3241 - t2733 * t3232 - 0.3e1 * t2733 * t3237 + 0.3e1 * t2735 * t3232 + 0.3e1 * t2735 * t3237 + 0.3e1 * t2735 * t3241 - t3228 + t3249 + t3257 + t3260 - t3261 - t3262;
  t3264 = t3225 * t403;
  t3266 = t2719 * t171 * t3264;
  t3267 = 0.3e1 * t3266;
  t3268 = t3225 * t167;
  t3270 = t2724 * t389 * t3268;
  t3271 = 0.3e1 * t3270;
  t3272 = 0.2e1 * t3119;
  t3273 = 0.2e1 * t3123;
  t3274 = 0.2e1 * t3126;
  t3281 = -0.2e1 * t1578 * t2733 * t878 - t1607 * t2775 - 0.3e1 * t1665 * t2735 + t2915 - t2917 - t2923 + t2938 - t2947 + t2952 + t3267 - t3271 + t3272 - t3273 + t3274 - t826 - t929;
  t3283 = my_piecewise5(t64, 0, t67, 0, t3263 + t3281);
  t3285 = t52 * t291 * t886 / 0.12e2 + t260 * t935 + t59 * t3283;
  t3289 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3285);
  tv3sigmalapl20 = t8 * t3289;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3294 = params->csk_a * t281;
  t3296 = t2824 * t3294 * t1431;
  t3297 = 0.3e1 * t3296;
  t3298 = t3294 * t584;
  t3299 = t242 * t3298;
  t3300 = t2829 * t3299;
  t3301 = 0.3e1 * t3300;
  t3302 = t3294 * t238;
  t3304 = t2824 * t570 * t3302;
  t3305 = 0.3e1 * t3304;
  t3308 = t2859 * t575 * t904 * t238;
  t3309 = 0.3e1 * t3308;
  t3310 = t1773 * t898;
  t3315 = t2381 * t281;
  t3316 = t1773 * t3315;
  t3323 = t570 * t281;
  t3324 = t1480 * t3323;
  t3327 = t1493 * t281;
  t3331 = t2870 * t1781;
  t3332 = 0.3e1 * t3331;
  t3337 = -0.2e1 * t1492 * t2835 * t3327 + 0.3e1 * t1797 * t2835 + 0.3e1 * t1819 * t2835 - t2835 * t3316 - 0.3e1 * t2835 * t3324 - 0.3e1 * t2845 * t3310 - t2845 * t3316 + 0.3e1 * t2847 * t3310 + 0.3e1 * t2847 * t3316 + 0.3e1 * t2847 * t3324 - t3297 + t3301 - t3305 + t3309 + t3332 - t952;
  t3338 = 0.2e1 * t3158;
  t3339 = 0.2e1 * t3166;
  t3340 = 0.2e1 * t3173;
  t3341 = 0.2e1 * t3204;
  t3342 = 0.2e1 * t3208;
  t3343 = 0.2e1 * t3211;
  t3350 = -0.2e1 * t1773 * t2845 * t904 - t1790 * t2878 - 0.3e1 * t1859 * t2847 - t2988 + t2996 - t2998 - t3019 + t3023 + t3030 - t3338 - t3339 + t3340 + t3341 - t3342 + t3343 - t852;
  t3352 = my_piecewise5(t114, 0, t115, 0, t3337 + t3350);
  t3354 = t52 * t308 * t912 / 0.12e2 + t278 * t958 + t113 * t3352;
  t3358 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3354);
  tv3sigmalapl28 = t8 * t3358;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3362 = t922 * t298;
  t3371 = t3362 * t403;
  t3372 = t379 * t3371;
  t3373 = t3372 * t1063;
  t3374 = 0.3e1 * t3373;
  t3375 = t3362 * t167;
  t3377 = t163 * t3375 * t1052;
  t3378 = 0.3e1 * t3377;
  t3379 = t3372 * t1046;
  t3380 = 0.3e1 * t3379;
  t3381 = 0.3e1 * t3069;
  t3382 = 0.3e1 * t3094;
  t3383 = 0.3e1 * t3099;
  t3384 = 0.3e1 * t3119;
  t3385 = 0.3e1 * t3123;
  t3386 = -t1068 * t1078 * t3362 - 0.3e1 * t1085 * t3362 * t379 - 0.2e1 * t1089 * t163 * t3362 - t3374 + t3378 - t3380 + t3381 - t3382 - t3383 + t3384 - t3385 - t826 - t929;
  t3387 = 0.3e1 * t3126;
  t3389 = t379 * t3375 * t1104;
  t3390 = 0.3e1 * t3389;
  t3392 = t163 * t3371 * t1112;
  t3393 = 0.3e1 * t3392;
  t3394 = t3362 * t1070;
  t3395 = t163 * t3394;
  t3398 = t1068 * t3394;
  t3401 = t379 * t3394;
  t3416 = -0.3e1 * t1095 * t3395 + 0.3e1 * t1095 * t3401 - t1117 * t3395 - t1117 * t3398 + 0.3e1 * t1117 * t3401 + 0.3e1 * t1123 * t3398 + 0.3e1 * t1133 * t3398 - 0.3e1 * t1137 * t3398 + 0.3e1 * t1137 * t3401 - 0.2e1 * t1147 * t3398 + t3387 + t3390 + t3393;
  t3418 = my_piecewise5(t64, 0, t67, 0, t3386 + t3416);
  t3420 = t52 * t291 * t935 / 0.8e1 + t59 * t3418;
  t3424 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3420);
  tv3lapl30 = t8 * t3424;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3428 = t945 * t315;
  t3437 = t3428 * t584;
  t3438 = t560 * t3437;
  t3439 = t3438 * t1432;
  t3440 = 0.3e1 * t3439;
  t3441 = t3438 * t1442;
  t3442 = 0.3e1 * t3441;
  t3443 = t3428 * t238;
  t3445 = t234 * t3443 * t1438;
  t3446 = 0.3e1 * t3445;
  t3447 = 0.3e1 * t3158;
  t3448 = 0.3e1 * t3166;
  t3449 = 0.3e1 * t3173;
  t3450 = 0.3e1 * t3204;
  t3451 = 0.3e1 * t3208;
  t3452 = -t1454 * t1464 * t3428 - 0.2e1 * t1471 * t234 * t3428 - 0.3e1 * t1475 * t3428 * t560 - t3440 - t3442 + t3446 - t3447 - t3448 + t3449 + t3450 - t3451 - t852 - t952;
  t3453 = 0.3e1 * t3211;
  t3454 = t3428 * t1456;
  t3455 = t560 * t3454;
  t3458 = t1454 * t3454;
  t3465 = t234 * t3437;
  t3466 = t3465 * t1507;
  t3467 = 0.3e1 * t3466;
  t3469 = t560 * t3443 * t1499;
  t3470 = 0.3e1 * t3469;
  t3471 = t234 * t3454;
  t3482 = 0.3e1 * t1481 * t3455 - t1481 * t3458 - t1481 * t3471 + 0.3e1 * t1485 * t3455 - 0.3e1 * t1485 * t3471 - 0.2e1 * t1494 * t3458 + 0.3e1 * t1511 * t3458 + 0.3e1 * t1522 * t3458 + 0.3e1 * t1526 * t3455 - 0.3e1 * t1526 * t3458 + t3453 + t3467 + t3470;
  t3484 = my_piecewise5(t114, 0, t115, 0, t3452 + t3482);
  t3486 = t52 * t308 * t958 / 0.8e1 + t113 * t3484;
  t3490 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3486);
  tv3lapl33 = t8 * t3490;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t46, t47, t48, t52, t53, t55;
  double t59, t61, t62, t63, t64, t65, t66, t67;
  double t68, t69, t70, t71, t72, t73, t74, t75;
  double t76, t77, t79, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t94, t95, t96, t97;
  double t99, t102, t103, t107, t109, t113, t114, t115;
  double t116, t117, t118, t119, t120, t121, t122, t123;
  double t124, t125, t127, t131, tzk0;

  double t132, t133, t134, t136, t139, t140, t144, t145;
  double t148, t151, t154, t161, t163, t164, t165, t167;
  double t168, t170, t171, t172, t174, t176, t181, t182;
  double t184, t187, t188, t192, t195, t197, tvrho0, t201;
  double t204, t205, t210, t212, t215, t216, t222, t225;
  double t232, t234, t235, t236, t238, t239, t241, t242;
  double t243, t245, t247, t252, tvrho1, t256, t257, t260;
  double t262, t263, t266, t268, t272, tvsigma0, tvsigma1, t274;
  double t275, t278, t280, t281, t284, t286, t290, tvsigma2;
  double t291, t297, t298, t301, t303, t307, tvlapl0, t308;
  double t314, t315, t318, t320, t324, tvlapl1, tvtau0, tvtau1;

  double t327, t328, t331, t332, t333, t336, t340, t341;
  double t345, t347, t353, t354, t357, t359, t361, t363;
  double t366, t373, t377, t379, t380, t382, t383, t384;
  double t385, t386, t387, t388, t389, t390, t392, t394;
  double t395, t396, t398, t399, t402, t403, t405, t406;
  double t407, t409, t411, t412, t413, t416, t418, t423;
  double t424, t425, t428, t431, t435, t436, t440, t442;
  double t444, t447, t449, tv2rho20, t452, t456, t460, t461;
  double t465, t467, t475, t476, t480, t484, t485, t489;
  double t491, t498, t501, tv2rho21, t506, t511, t515, t516;
  double t522, t523, t528, t532, t533, t542, t544, t547;
  double t554, t558, t560, t561, t563, t564, t565, t566;
  double t567, t568, t569, t570, t571, t573, t575, t576;
  double t577, t579, t580, t583, t584, t586, t587, t588;
  double t590, t592, t593, t594, t597, t599, t604, tv2rho22;
  double t612, t614, t615, t618, t622, t623, t624, t625;
  double t627, t628, t629, t630, t632, t633, t636, t638;
  double t639, t640, t642, t644, t645, t648, t650, t655;
  double tv2rhosigma0, tv2rhosigma1, t662, t664, tv2rhosigma2, t670, tv2rhosigma3, tv2rhosigma4;
  double t676, t677, t680, t684, t685, t686, t687, t689;
  double t690, t692, t694, t695, t698, t700, t701, t702;
  double t704, t706, t707, t710, t712, t717, tv2rhosigma5, t724;
  double t732, t733, t735, t736, t740, t741, t744, t746;
  double t748, t752, t754, t759, tv2rholapl0, t766, t768, tv2rholapl1;
  double t774, tv2rholapl2, t786, t787, t789, t790, t794, t795;
  double t798, t800, t802, t806, t808, t813, tv2rholapl3, tv2rhotau0;
  double tv2rhotau1, tv2rhotau2, tv2rhotau3, t817, t820, t823, t824, t826;
  double t827, t828, t830, t834, t836, t840, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t843, t846, t849, t850, t852;
  double t853, t854, t856, t860, t862, t866, tv2sigma25, t872;
  double t873, t875, t876, t877, t878, t879, t882, t883;
  double t886, t888, t892, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4;
  double t898, t899, t901, t902, t903, t904, t905, t908;
  double t909, t912, t914, t918, tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2;
  double tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t922, t925, t926, t928, t929;
  double t931, t935, t937, t941, tv2lapl20, tv2lapl21, t945, t948;
  double t949, t951, t952, t954, t958, t960, t964, tv2lapl22;
  double tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20, tv2tau21, tv2tau22;

  double t968, t969, t972, t975, t976, t977, t980, t984;
  double t985, t989, t991, t996, t998, t1001, t1007, t1008;
  double t1011, t1013, t1016, t1020, t1023, t1030, t1036, t1037;
  double t1040, t1041, t1042, t1043, t1045, t1046, t1047, t1049;
  double t1051, t1052, t1053, t1056, t1057, t1063, t1064, t1068;
  double t1070, t1072, t1073, t1074, t1076, t1077, t1078, t1080;
  double t1081, t1085, t1089, t1092, t1093, t1094, t1095, t1098;
  double t1101, t1103, t1104, t1105, t1111, t1112, t1113, t1115;
  double t1116, t1117, t1120, t1122, t1123, t1127, t1131, t1132;
  double t1133, t1136, t1137, t1142, t1146, t1147, t1150, t1152;
  double t1154, t1159, t1161, t1162, t1165, t1168, t1171, t1175;
  double t1176, t1180, t1182, t1184, t1186, t1188, t1191, t1193;
  double tv3rho30, t1196, t1197, t1198, t1201, t1206, t1207, t1209;
  double t1213, t1214, t1218, t1221, t1225, t1227, t1231, t1240;
  double t1241, t1242, t1245, t1250, t1252, t1256, t1257, t1261;
  double t1264, t1265, t1267, t1276, t1278, t1281, tv3rho31, t1284;
  double t1289, t1293, t1297, t1298, t1302, t1304, t1313, t1314;
  double t1319, t1323, t1327, t1328, t1332, t1334, t1341, t1349;
  double t1351, t1352, tv3rho32, t1357, t1364, t1368, t1369, t1376;
  double t1377, t1384, t1388, t1389, t1406, t1409, t1416, t1422;
  double t1423, t1426, t1427, t1428, t1429, t1431, t1432, t1433;
  double t1435, t1437, t1438, t1439, t1442, t1443, t1446, t1447;
  double t1454, t1456, t1458, t1459, t1460, t1462, t1463, t1464;
  double t1466, t1467, t1471, t1475, t1478, t1479, t1480, t1481;
  double t1483, t1484, t1485, t1488, t1489, t1492, t1493, t1494;
  double t1498, t1499, t1500, t1506, t1507, t1508, t1510, t1511;
  double t1517, t1521, t1522, t1525, t1526, t1531, t1535, t1537;
  double t1539, t1544, tv3rho33, t1552, t1559, t1561, t1564, t1565;
  double t1568, t1576, t1577, t1578, t1580, t1583, t1586, t1587;
  double t1589, t1590, t1591, t1592, t1593, t1595, t1596, t1597;
  double t1600, t1602, t1604, t1607, t1611, t1612, t1615, t1616;
  double t1618, t1619, t1622, t1623, t1629, t1632, t1633, t1634;
  double t1635, t1642, t1643, t1644, t1646, t1647, t1648, t1649;
  double t1650, t1651, t1652, t1654, t1656, t1657, t1660, t1661;
  double t1664, t1665, t1670, t1671, t1672, t1675, t1676, t1681;
  double t1683, t1687, t1689, t1691, t1696, tv3rho2sigma0, tv3rho2sigma1, t1703;
  double t1707, t1709, tv3rho2sigma2, t1715, t1723, tv3rho2sigma3, tv3rho2sigma4, t1729;
  double t1736, t1739, tv3rho2sigma5, t1747, tv3rho2sigma6, tv3rho2sigma7, t1759, t1760;
  double t1763, t1771, t1772, t1773, t1774, t1775, t1778, t1779;
  double t1780, t1781, t1782, t1784, t1787, t1788, t1790, t1792;
  double t1793, t1795, t1796, t1797, t1801, t1806, t1807, t1810;
  double t1811, t1813, t1814, t1817, t1818, t1819, t1822, t1823;
  double t1829, t1830, t1837, t1838, t1839, t1841, t1842, t1843;
  double t1844, t1845, t1846, t1847, t1849, t1851, t1852, t1855;
  double t1856, t1858, t1859, t1862, t1863, t1868, t1872, t1874;
  double t1875, t1882, t1884, t1886, t1891, tv3rho2sigma8, t1898, t1905;
  double t1907, t1921, t1922, t1925, t1926, t1929, t1932, t1933;
  double t1934, t1936, t1938, t1940, t1941, t1947, t1955, t1956;
  double t1957, t1960, t1963, t1970, t1971, t1974, t1975, t1976;
  double t1978, t1982, t1983, t1988, t1989, t1992, t1994, t1996;
  double t1998, t2000, t2003, t2008, t2010, t2012, t2017, tv3rho2lapl0;
  double t2024, t2028, t2030, tv3rho2lapl1, t2036, t2044, tv3rho2lapl2, t2050;
  double t2057, t2060, tv3rho2lapl3, t2068, tv3rho2lapl4, t2091, t2092, t2095;
  double t2096, t2099, t2102, t2103, t2104, t2106, t2108, t2110;
  double t2111, t2117, t2119, t2120, t2121, t2124, t2133, t2140;
  double t2141, t2144, t2145, t2146, t2148, t2152, t2153, t2156;
  double t2158, t2160, t2162, t2165, t2166, t2169, t2171, t2178;
  double t2180, t2182, t2187, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1, tv3rho2tau2, tv3rho2tau3;
  double tv3rho2tau4, tv3rho2tau5, t2194, t2200, t2201, t2202, t2205, t2207;
  double t2209, t2214, t2215, t2218, t2219, t2220, t2221, t2222;
  double t2225, t2226, t2229, t2230, t2231, t2233, t2234, t2236;
  double t2237, t2242, t2243, t2246, t2247, t2248, t2249, t2250;
  double t2251, t2253, t2254, t2257, t2260, t2261, t2265, t2266;
  double t2267, t2268, t2271, t2272, t2273, t2274, t2276, t2277;
  double t2278, t2280, t2281, t2282, t2283, t2285, t2286, t2287;
  double t2288, t2289, t2291, t2292, t2293, t2298, t2299, t2300;
  double t2301, t2303, t2304, t2307, t2310, t2312, t2314, t2319;
  double tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t2326, t2328, tv3rhosigma25;
  double t2334, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t2344, t2345;
  double t2346, t2347, t2350, t2351, t2354, t2355, t2356, t2359;
  double t2360, t2361, t2362, t2363, t2365, t2366, t2370, t2371;
  double t2372, t2373, t2374, t2375, t2377, t2380, t2381, t2383;
  double t2388, t2389, t2390, t2392, t2393, t2400, t2401, t2402;
  double t2405, t2406, t2410, t2411, t2412, t2413, t2416, t2417;
  double t2418, t2419, t2421, t2422, t2423, t2425, t2426, t2429;
  double t2434, t2435, t2436, t2437, t2438, t2440, t2441, t2442;
  double t2447, t2448, t2449, t2450, t2452, t2453, t2454, t2455;
  double t2457, t2459, t2464, tv3rhosigma211, t2471, t2481, t2482, t2486;
  double t2487, t2490, t2491, t2498, t2499, t2500, t2501, t2502;
  double t2505, t2506, t2509, t2511, t2512, t2514, t2515, t2516;
  double t2517, t2518, t2521, t2524, t2527, t2528, t2530, t2534;
  double t2535, t2540, t2541, t2542, t2544, t2546, t2547, t2549;
  double t2550, t2551, t2552, t2554, t2555, t2556, t2558, t2560;
  double t2561, t2563, t2568, t2570, t2572, t2577, tv3rhosigmalapl0, tv3rhosigmalapl1;
  double tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, t2584, t2586, tv3rhosigmalapl5, t2592, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2612, t2613, t2615, t2616;
  double t2619, t2620, t2621, t2622, t2623, t2626, t2628, t2629;
  double t2631, t2632, t2633, t2634, t2635, t2638, t2641, t2642;
  double t2643, t2645, t2649, t2650, t2653, t2656, t2661, t2662;
  double t2663, t2665, t2667, t2668, t2670, t2671, t2672, t2673;
  double t2675, t2676, t2677, t2679, t2680, t2683, t2685, t2686;
  double t2688, t2693, t2695, t2697, t2702, tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1;
  double tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9;
  double tv3rhosigmatau10, tv3rhosigmatau11, t2709, t2717, t2719, t2720, t2722, t2724;
  double t2725, t2727, t2729, t2730, t2733, t2735, t2743, t2749;
  double t2753, t2758, t2759, t2765, t2766, t2774, t2775, t2777;
  double t2778, t2779, t2781, t2782, t2786, t2788, t2790, t2795;
  double tv3rholapl20, tv3rholapl21, t2802, t2804, tv3rholapl22, t2810, tv3rholapl23, tv3rholapl24;
  double t2822, t2824, t2825, t2827, t2829, t2830, t2832, t2834;
  double t2835, t2839, t2845, t2847, t2856, t2859, t2860, t2866;
  double t2870, t2871, t2877, t2878, t2880, t2881, t2882, t2884;
  double t2885, t2891, t2893, t2895, t2900, tv3rholapl25, tv3rholapltau0, tv3rholapltau1;
  double tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, tv3rhotau20, tv3rhotau21;
  double tv3rhotau22, tv3rhotau23, tv3rhotau24, tv3rhotau25, t2904, t2913, t2914, t2915;
  double t2916, t2917, t2918, t2919, t2920, t2921, t2922, t2923;
  double t2924, t2925, t2926, t2927, t2929, t2930, t2931, t2932;
  double t2937, t2938, t2939, t2942, t2945, t2947, t2948, t2950;
  double t2951, t2952, t2953, t2954, t2955, t2956, t2959, t2968;
  double t2970, t2972, t2976, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34;
  double tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t2979, t2988, t2989, t2990;
  double t2991, t2992, t2993, t2994, t2995, t2996, t2997, t2998;
  double t2999, t3000, t3001, t3002, t3004, t3005, t3006, t3007;
  double t3010, t3013, t3014, t3017, t3019, t3020, t3023, t3024;
  double t3028, t3029, t3030, t3031, t3032, t3033, t3034, t3043;
  double t3045, t3047, t3051, tv3sigma39, t3057, t3058, t3059, t3060;
  double t3061, t3062, t3063, t3064, t3065, t3066, t3067, t3068;
  double t3069, t3070, t3071, t3075, t3076, t3084, t3089, t3090;
  double t3091, t3092, t3093, t3094, t3097, t3098, t3099, t3100;
  double t3101, t3102, t3107, t3108, t3109, t3110, t3111, t3112;
  double t3115, t3116, t3119, t3121, t3123, t3124, t3125, t3126;
  double t3127, t3129, t3131, t3135, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3;
  double tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, t3141;
  double t3142, t3143, t3144, t3145, t3146, t3147, t3148, t3149;
  double t3150, t3151, t3152, t3154, t3158, t3160, t3161, t3164;
  double t3165, t3166, t3167, t3168, t3173, t3177, t3178, t3186;
  double t3187, t3188, t3189, t3190, t3191, t3192, t3193, t3194;
  double t3195, t3196, t3197, t3200, t3201, t3204, t3206, t3208;
  double t3209, t3210, t3211, t3212, t3214, t3216, t3220, tv3sigma2lapl11;
  double tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7;
  double tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, t3225, t3227, t3228, t3232;
  double t3237, t3240, t3241, t3244, t3248, t3249, t3256, t3257;
  double t3260, t3261, t3262, t3263, t3264, t3266, t3267, t3268;
  double t3270, t3271, t3272, t3273, t3274, t3281, t3283, t3285;
  double t3289, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26;
  double tv3sigmalapl27, t3294, t3296, t3297, t3298, t3299, t3300, t3301;
  double t3302, t3304, t3305, t3308, t3309, t3310, t3315, t3316;
  double t3323, t3324, t3327, t3331, t3332, t3337, t3338, t3339;
  double t3340, t3341, t3342, t3343, t3350, t3352, t3354, t3358;
  double tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6;
  double tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22;
  double tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, t3362, t3371;
  double t3372, t3373, t3374, t3375, t3377, t3378, t3379, t3380;
  double t3381, t3382, t3383, t3384, t3385, t3386, t3387, t3389;
  double t3390, t3392, t3393, t3394, t3395, t3398, t3401, t3416;
  double t3418, t3420, t3424, tv3lapl30, tv3lapl31, tv3lapl32, t3428, t3437;
  double t3438, t3439, t3440, t3441, t3442, t3443, t3445, t3446;
  double t3447, t3448, t3449, t3450, t3451, t3452, t3453, t3454;
  double t3455, t3458, t3465, t3466, t3467, t3469, t3470, t3471;
  double t3482, t3484, t3486, t3490, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2;
  double tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24;
  double tv3lapltau25, tv3tau30, tv3tau31, tv3tau32, tv3tau33;

  double t3493, t3495, t3496, t3502, t3508, t3509, t3512, t3516;
  double t3525, t3531, t3534, t3540, t3543, t3546, t3550, t3553;
  double t3560, t3573, t3575, t3578, t3580, t3581, t3586, t3587;
  double t3588, t3589, t3590, t3593, t3594, t3595, t3596, t3597;
  double t3600, t3601, t3605, t3609, t3612, t3614, t3616, t3617;
  double t3618, t3619, t3620, t3622, t3623, t3626, t3630, t3635;
  double t3636, t3638, t3641, t3643, t3646, t3647, t3650, t3653;
  double t3655, t3656, t3658, t3659, t3662, t3665, t3673, t3676;
  double t3677, t3680, t3685, t3687, t3696, t3698, t3704, t3710;
  double t3713, t3715, t3719, t3723, t3724, t3727, t3729, t3732;
  double t3735, t3741, t3742, t3743, t3744, t3747, t3748, t3749;
  double t3750, t3751, t3754, t3755, t3757, t3760, t3761, t3766;
  double t3767, t3773, t3778, t3782, t3793, t3796, t3806, t3808;
  double t3809, t3815, t3822, t3823, t3829, t3830, t3831, t3834;
  double t3841, t3842, t3845, t3850, t3851, t3860, t3861, t3870;
  double t3874, t3882, t3886, t3890, t3893, t3897, t3898, t3899;
  double t3900, t3902, t3903, t3909, t3914, t3917, t3921, t3928;
  double t3932, t3936, t3941, t3943, tv4rho40, t3950, t3954, t3955;
  double t3958, t3976, t3977, t3979, t3983, t3992, t3998, t3999;
  double t4001, t4015, t4016, t4033, t4035, t4039, t4046, t4050;
  double t4051, t4054, t4063, t4066, t4067, t4069, t4071, t4072;
  double tv4rho41, t4087, t4100, t4104, t4113, t4120, t4124, t4137;
  double t4138, t4147, t4160, t4164, t4171, t4175, t4184, t4187;
  double t4198, t4201, t4203, t4204, tv4rho42, t4225, t4229, t4236;
  double t4247, t4248, t4265, t4269, t4276, t4284, t4293, t4303;
  double t4305, t4306, tv4rho43, t4311, t4316, t4323, t4327, t4336;
  double t4345, t4348, t4355, t4366, t4367, t4368, t4370, t4373;
  double t4376, t4379, t4381, t4384, t4388, t4391, t4392, t4397;
  double t4402, t4403, t4406, t4408, t4411, t4415, t4422, t4423;
  double t4426, t4429, t4433, t4436, t4438, t4441, t4449, t4450;
  double t4451, t4456, t4458, t4465, t4466, t4467, t4468, t4471;
  double t4475, t4481, t4482, t4483, t4484, t4485, t4489, t4492;
  double t4493, t4496, t4499, t4501, t4503, t4504, t4505, t4506;
  double t4507, t4509, t4510, t4515, t4517, t4521, t4525, t4528;
  double t4530, t4533, t4536, t4542, t4546, t4549, t4550, t4551;
  double t4552, t4555, t4556, t4557, t4558, t4563, t4566, t4567;
  double t4571, t4574, t4577, t4579, t4582, t4583, t4590, t4601;
  double t4608, t4612, t4625, t4626, t4629, t4632, t4633, t4641;
  double t4642, t4645, t4646, t4649, t4650, t4658, t4659, t4669;
  double t4673, t4679, t4684, t4691, t4695, t4712, t4713, tv4rho44;
  double t4721, t4727, t4730, t4737, t4739, t4742, t4745, t4749;
  double t4766, t4767, t4770, t4773, t4776, t4777, t4780, t4783;
  double t4786, t4788, t4792, t4795, t4796, t4798, t4802, t4805;
  double t4806, t4807, t4811, t4815, t4818, t4819, t4820, t4827;
  double t4830, t4833, t4834, t4835, t4839, t4843, t4846, t4850;
  double t4851, t4854, t4855, t4860, t4865, t4868, t4877, t4881;
  double t4890, t4895, t4896, t4901, t4906, t4909, t4916, t4920;
  double t4923, t4933, t4935, t4945, t4952, t4954, t4958, t4962;
  double t4963, t4964, t4965, t4968, t4969, t4970, t4973, t4975;
  double t4976, t4979, t4980, t4983, t4986, t4989, t4992, t4993;
  double t4995, t4996, t5003, t5007, t5011, t5017, t5019, t5020;
  double t5025, t5036, t5039, t5044, t5049, t5051, t5056, t5060;
  double t5061, t5062, t5065, t5072, t5073, t5083, t5086, t5089;
  double t5101, t5117, t5120, t5121, t5125, t5130, t5134, t5141;
  double tv4rho3sigma0, tv4rho3sigma1, t5148, t5151, t5155, t5157, tv4rho3sigma2, t5159;
  double t5165, t5170, t5174, t5183, t5184, tv4rho3sigma3, tv4rho3sigma4, t5186;
  double t5192, t5194, t5203, t5205, t5208, tv4rho3sigma5, t5214, t5223;
  double tv4rho3sigma6, tv4rho3sigma7, t5229, t5236, t5244, t5246, t5247, tv4rho3sigma8;
  double t5256, tv4rho3sigma9, tv4rho3sigma10, t5274, t5278, t5295, t5296, t5298;
  double t5299, t5302, t5305, t5306, t5309, t5312, t5315, t5318;
  double t5320, t5325, t5332, t5333, t5334, t5335, t5338, t5343;
  double t5344, t5347, t5348, t5353, t5358, t5363, t5364, t5365;
  double t5368, t5372, t5374, t5381, t5384, t5385, t5390, t5395;
  double t5398, t5401, t5404, t5405, t5414, t5418, t5422, t5426;
  double t5433, t5435, t5439, t5446, t5454, t5458, t5462, t5465;
  double t5475, t5483, t5484, t5488, t5489, t5492, t5493, t5494;
  double t5497, t5498, t5501, t5504, t5506, t5507, t5510, t5511;
  double t5512, t5517, t5518, t5522, t5523, t5526, t5527, t5529;
  double t5535, t5538, t5539, t5543, t5549, t5552, t5554, t5555;
  double t5560, t5564, t5577, t5580, t5583, t5587, t5588, t5589;
  double t5601, t5604, t5612, t5614, t5620, t5631, t5633, t5637;
  double t5653, t5654, t5659, t5663, t5670, tv4rho3sigma11, t5677, t5683;
  double t5686, t5693, t5695, t5698, t5726, t5727, t5728, t5731;
  double t5732, t5737, t5742, t5747, t5748, t5752, t5774, t5777;
  double t5779, t5780, t5785, t5790, t5791, t5794, t5797, t5800;
  double t5803, t5806, t5813, t5814, t5817, t5820, t5828, t5837;
  double t5839, t5842, t5844, t5848, t5851, t5852, t5856, t5863;
  double t5866, t5869, t5874, t5881, t5884, t5896, t5900, t5903;
  double t5913, t5919, t5934, t5943, t5947, t5952, t5955, t5972;
  double t5973, t5982, t5985, t5995, t6000, t6001, t6006, t6010;
  double t6017, tv4rho3lapl0, t6024, t6027, t6031, t6033, tv4rho3lapl1, t6035;
  double t6041, t6046, t6050, t6059, t6060, tv4rho3lapl2, t6062, t6068;
  double t6070, t6079, t6081, t6084, tv4rho3lapl3, t6090, t6099, tv4rho3lapl4;
  double t6105, t6112, t6120, t6122, t6123, tv4rho3lapl5, t6132, tv4rho3lapl6;
  double t6171, t6174, t6175, t6178, t6179, t6182, t6187, t6192;
  double t6193, t6196, t6200, t6203, t6212, t6213, t6216, t6222;
  double t6224, t6229, t6231, t6234, t6235, t6243, t6247, t6254;
  double t6258, t6263, t6264, t6267, t6270, t6271, t6276, t6279;
  double t6280, t6284, t6291, t6292, t6311, t6314, t6317, t6318;
  double t6321, t6328, t6341, t6346, t6350, t6353, t6366, t6368;
  double t6379, t6384, t6394, t6411, t6414, t6415, t6418, t6434;
  double t6437, t6440, t6447, t6448, t6453, t6457, t6464, tv4rho3lapl7;
  double tv4rho3tau0, tv4rho3tau1, tv4rho3tau2, tv4rho3tau3, tv4rho3tau4, tv4rho3tau5, tv4rho3tau6, tv4rho3tau7;
  double t6471, t6478, t6480, t6491, t6492, t6493, t6500, t6503;
  double t6504, t6506, t6507, t6510, t6514, t6517, t6518, t6520;
  double t6521, t6523, t6524, t6525, t6526, t6529, t6532, t6533;
  double t6534, t6537, t6540, t6542, t6546, t6549, t6550, t6552;
  double t6555, t6561, t6565, t6585, t6586, t6591, t6594, t6602;
  double t6605, t6607, t6609, t6610, t6613, t6615, t6621, t6628;
  double t6629, t6631, t6634, t6636, t6639, t6641, t6642, t6643;
  double t6645, t6648, t6649, t6650, t6658, t6663, t6665, t6669;
  double t6676, t6678, t6679, t6682, t6686, t6689, t6695, t6697;
  double t6700, t6701, t6702, t6703, t6704, t6709, t6710, t6713;
  double t6722, t6725, t6728, t6729, t6731, t6732, t6736, t6739;
  double t6744, t6747, t6750, t6751, t6752, t6757, t6758, t6766;
  double t6767, t6772, t6776, t6777, t6782, t6783, t6790, t6793;
  double t6798, t6799, t6803, t6808, t6809, t6810, t6811, t6819;
  double t6821, t6824, t6830, t6832, t6833, t6838, t6846, t6849;
  double t6850, t6854, t6862, t6863, t6864, t6872, t6873, t6875;
  double t6876, t6880, t6887, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24;
  double t6894, t6898, t6900, tv4rho2sigma25, t6906, t6914, tv4rho2sigma26, tv4rho2sigma27;
  double tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t6920, t6927, t6930, tv4rho2sigma211, t6938;
  double tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t6958, t6961, t6962;
  double t6966, t6967, t6968, t6969, t6971, t6974, t6976, t6977;
  double t6979, t6981, t6982, t6985, t6986, t6987, t6990, t6995;
  double t6998, t7002, t7003, t7013, t7014, t7021, t7022, t7028;
  double t7031, t7034, t7037, t7042, t7045, t7054, t7061, t7063;
  double t7064, t7066, t7069, t7070, t7072, t7073, t7076, t7078;
  double t7079, t7081, t7082, t7083, t7086, t7090, t7093, t7094;
  double t7098, t7103, t7104, t7105, t7110, t7112, t7119, t7120;
  double t7122, t7123, t7125, t7131, t7132, t7133, t7137, t7140;
  double t7142, t7147, t7148, t7157, t7162, t7163, t7165, t7167;
  double t7168, t7172, t7175, t7181, t7191, t7196, t7201, t7209;
  double t7210, t7219, t7221, t7223, t7226, t7227, t7228, t7231;
  double t7240, t7241, t7242, t7245, t7248, t7258, t7260, t7263;
  double t7266, t7273, t7274, t7275, t7277, t7280, t7285, t7288;
  double t7291, t7292, t7295, t7301, t7302, t7306, t7307, t7313;
  double t7314, t7315, t7327, t7328, t7336, t7337, t7339, t7340;
  double t7344, t7351, tv4rho2sigma217, t7358, t7365, t7367, t7390, t7391;
  double t7392, t7395, t7398, t7399, t7400, t7401, t7404, t7409;
  double t7412, t7413, t7422, t7423, t7426, t7427, t7432, t7433;
  double t7439, t7445, t7448, t7449, t7454, t7464, t7465, t7470;
  double t7482, t7483, t7486, t7488, t7489, t7490, t7495, t7496;
  double t7501, t7517, t7520, t7540, t7541, t7544, t7548, t7553;
  double t7557, t7558, t7568, t7573, t7596, t7609, t7624, t7634;
  double t7646, t7647, t7650, t7658, t7663, t7664, t7667, t7670;
  double t7681, t7682, t7685, t7687, t7688, t7691, t7698, t7706;
  double t7712, t7716, t7725, t7744, t7748, t7755, tv4rho2sigmalapl0, tv4rho2sigmalapl1;
  double tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4, t7762, t7766, t7768, tv4rho2sigmalapl5, t7774;
  double t7782, tv4rho2sigmalapl6, tv4rho2sigmalapl7, tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, t7788, t7795;
  double t7798, tv4rho2sigmalapl11, t7806, tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16;
  double t7845, t7846, t7847, t7850, t7854, t7859, t7860, t7861;
  double t7865, t7873, t7879, t7882, t7890, t7891, t7896, t7901;
  double t7904, t7905, t7906, t7909, t7910, t7911, t7912, t7915;
  double t7918, t7919, t7925, t7927, t7934, t7935, t7936, t7937;
  double t7942, t7946, t7947, t7952, t7962, t7965, t7978, t7979;
  double t7986, t7989, t7995, t7996, t8003, t8004, t8005, t8006;
  double t8011, t8012, t8034, t8037, t8052, t8062, t8065, t8066;
  double t8072, t8077, t8082, t8084, t8092, t8106, t8109, t8120;
  double t8143, t8157, t8165, t8172, t8189, t8193, t8200, tv4rho2sigmalapl17;
  double tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3, tv4rho2sigmatau4, tv4rho2sigmatau5, tv4rho2sigmatau6, tv4rho2sigmatau7;
  double tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, tv4rho2sigmatau11, tv4rho2sigmatau12, tv4rho2sigmatau13, tv4rho2sigmatau14, tv4rho2sigmatau15;
  double tv4rho2sigmatau16, tv4rho2sigmatau17, t8207, t8214, t8216, t8233, t8234, t8248;
  double t8255, t8256, t8264, t8266, t8270, t8273, t8274, t8277;
  double t8282, t8283, t8285, t8288, t8303, t8306, t8313, t8316;
  double t8320, t8326, t8330, t8343, t8344, t8352, t8354, t8358;
  double t8365, t8376, t8387, t8390, t8404, t8410, t8414, t8415;
  double t8420, t8443, t8448, t8453, t8455, t8462, t8463, t8467;
  double t8475, t8485, t8493, t8495, t8499, t8507, t8511, t8518;
  double tv4rho2lapl20, tv4rho2lapl21, t8525, t8529, t8531, tv4rho2lapl22, t8537, t8545;
  double tv4rho2lapl23, tv4rho2lapl24, t8551, t8558, t8561, tv4rho2lapl25, t8569, tv4rho2lapl26;
  double tv4rho2lapl27, t8595, t8596, t8610, t8617, t8618, t8624, t8625;
  double t8626, t8635, t8636, t8643, t8644, t8647, t8650, t8651;
  double t8652, t8658, t8663, t8666, t8677, t8682, t8686, t8690;
  double t8704, t8706, t8709, t8710, t8715, t8725, t8733, t8743;
  double t8749, t8755, t8758, t8765, t8780, t8781, t8786, t8804;
  double t8806, t8813, t8815, t8826, t8831, t8835, t8837, t8838;
  double t8839, t8850, t8855, t8856, t8867, t8871, t8878, tv4rho2lapl28;
  double tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7;
  double tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, tv4rho2tau20, tv4rho2tau21, tv4rho2tau22, tv4rho2tau23;
  double tv4rho2tau24, tv4rho2tau25, tv4rho2tau26, tv4rho2tau27, tv4rho2tau28, t8885, t8891, t8892;
  double t8893, t8895, t8896, t8898, t8900, t8901, t8903, t8905;
  double t8906, t8907, t8911, t8912, t8913, t8915, t8916, t8918;
  double t8919, t8923, t8924, t8927, t8930, t8933, t8935, t8936;
  double t8937, t8938, t8947, t8951, t8955, t8958, t8960, t8961;
  double t8962, t8965, t8967, t8968, t8969, t8971, t8974, t8980;
  double t8982, t8983, t8985, t8988, t8990, t8991, t8992, t8995;
  double t8996, t8999, t9001, t9002, t9007, t9009, t9012, t9014;
  double t9019, t9023, t9025, t9028, t9034, t9041, t9043, t9046;
  double t9047, t9051, t9056, t9059, t9064, t9067, t9068, t9071;
  double t9074, t9075, t9076, t9080, t9083, t9089, t9094, t9104;
  double t9105, t9112, t9114, t9121, t9130, t9139, t9144, t9158;
  double t9163, t9165, t9168, t9172, t9178, t9179, t9180, t9184;
  double t9191, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36;
  double tv4rhosigma37, tv4rhosigma38, t9198, t9200, tv4rhosigma39, t9206, tv4rhosigma310, tv4rhosigma311;
  double tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t9216;
  double t9217, t9218, t9219, t9221, t9222, t9223, t9225, t9226;
  double t9227, t9229, t9232, t9234, t9236, t9237, t9239, t9242;
  double t9243, t9244, t9246, t9252, t9255, t9258, t9259, t9262;
  double t9263, t9266, t9267, t9270, t9272, t9273, t9275, t9278;
  double t9280, t9283, t9284, t9286, t9288, t9291, t9295, t9298;
  double t9301, t9302, t9304, t9306, t9312, t9313, t9316, t9321;
  double t9325, t9330, t9331, t9337, t9340, t9343, t9346, t9352;
  double t9353, t9354, t9358, t9365, t9367, t9370, t9373, t9374;
  double t9377, t9381, t9385, t9388, t9390, t9395, t9402, t9405;
  double t9412, t9414, t9415, t9418, t9421, t9423, t9428, t9430;
  double t9435, t9437, t9440, t9444, t9456, t9460, t9471, t9473;
  double t9483, t9488, t9500, t9502, t9505, t9506, t9507, t9511;
  double t9518, tv4rhosigma319, t9525, t9537, t9538, t9542, t9544, t9550;
  double t9552, t9557, t9561, t9562, t9570, t9573, t9574, t9579;
  double t9584, t9585, t9589, t9590, t9599, t9603, t9605, t9609;
  double t9610, t9611, t9613, t9617, t9620, t9622, t9625, t9630;
  double t9631, t9637, t9644, t9650, t9656, t9658, t9670, t9682;
  double t9684, t9687, t9689, t9692, t9695, t9703, t9704, t9705;
  double t9708, t9710, t9711, t9714, t9721, t9724, t9740, t9747;
  double t9774, t9775, t9783, t9784, t9794, t9805, t9814, t9831;
  double t9836, t9841, t9851, t9852, t9857, t9861, t9864, t9869;
  double t9876, tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6;
  double tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10, t9883, t9885, tv4rhosigma2lapl11, t9891;
  double tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19;
  double tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22, t9907, t9908, t9911, t9913, t9915;
  double t9920, t9927, t9928, t9931, t9932, t9937, t9947, t9948;
  double t9951, t9953, t9957, t9958, t9959, t9962, t9966, t9975;
  double t9976, t9980, t9986, t9987, t9997, t10005, t10008, t10010;
  double t10013, t10015, t10019, t10023, t10024, t10029, t10045, t10052;
  double t10057, t10062, t10066, t10068, t10088, t10090, t10094, t10098;
  double t10099, t10105, t10115, t10121, t10123, t10126, t10127, t10128;
  double t10142, t10143, t10146, t10150, t10151, t10157, t10181, t10191;
  double t10193, t10200, t10222, t10226, t10227, t10231, t10234, t10239;
  double t10246, tv4rhosigma2lapl23, tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5;
  double tv4rhosigma2tau6, tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, tv4rhosigma2tau11, tv4rhosigma2tau12, tv4rhosigma2tau13;
  double tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21;
  double tv4rhosigma2tau22, tv4rhosigma2tau23, t10253, t10265, t10268, t10273, t10274, t10277;
  double t10282, t10286, t10287, t10299, t10311, t10314, t10321, t10322;
  double t10325, t10331, t10342, t10343, t10356, t10366, t10389, t10392;
  double t10393, t10403, t10423, t10436, t10446, t10447, t10483, t10489;
  double t10511, t10526, t10529, t10545, t10550, t10557, tv4rhosigmalapl20, tv4rhosigmalapl21;
  double tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27, t10564, t10566;
  double tv4rhosigmalapl28, t10572, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214;
  double tv4rhosigmalapl215, tv4rhosigmalapl216, t10600, t10615, t10616, t10621, t10624, t10630;
  double t10642, t10648, t10678, t10700, t10718, t10731, t10732, t10739;
  double t10745, t10748, t10753, t10754, t10760, t10763, t10768, t10769;
  double t10774, t10781, t10806, t10811, t10816, t10835, t10840, t10842;
  double t10866, t10871, t10878, tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3;
  double tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10, tv4rhosigmalapltau11;
  double tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19;
  double tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, tv4rhosigmatau20, tv4rhosigmatau21, tv4rhosigmatau22, tv4rhosigmatau23;
  double tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27, tv4rhosigmatau28, tv4rhosigmatau29, tv4rhosigmatau210, tv4rhosigmatau211;
  double tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216, tv4rhosigmatau217, t10885, t10901;
  double t10909, t10910, t10913, t10918, t10921, t10927, t10938, t10940;
  double t10948, t10950, t10959, t10960, t10964, t10967, t10970, t10972;
  double t10980, t10988, t10994, t11011, t11018, t11019, t11024, t11038;
  double t11040, t11043, t11047, t11060, t11066, t11067, t11068, t11071;
  double t11074, t11077, t11079, t11080, t11086, t11098, t11108, t11111;
  double t11112, t11113, t11117, t11124, tv4rholapl30, tv4rholapl31, tv4rholapl32, t11131;
  double t11133, tv4rholapl33, t11139, tv4rholapl34, tv4rholapl35, tv4rholapl36, t11152, t11162;
  double t11171, t11172, t11175, t11179, t11182, t11186, t11202, t11204;
  double t11208, t11215, t11217, t11223, t11228, t11231, t11236, t11250;
  double t11258, t11260, t11266, t11271, t11280, t11281, t11286, t11300;
  double t11306, t11311, t11316, t11321, t11328, t11329, t11332, t11334;
  double t11337, t11352, t11365, t11366, t11367, t11371, t11378, tv4rholapl37;
  double tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7;
  double tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10, tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23;
  double tv4rholapltau24, tv4rholapltau25, tv4rholapltau26, tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211;
  double tv4rhotau30, tv4rhotau31, tv4rhotau32, tv4rhotau33, tv4rhotau34, tv4rhotau35, tv4rhotau36, tv4rhotau37;
  double t11382, t11383, t11385, t11387, t11388, t11390, t11392, t11394;
  double t11395, t11396, t11402, t11403, t11406, t11407, t11409, t11410;
  double t11418, t11422, t11425, t11426, t11428, t11431, t11432, t11434;
  double t11436, t11440, t11442, t11444, t11454, t11456, t11457, t11462;
  double t11472, t11475, t11482, t11494, t11497, t11498, t11514, t11521;
  double t11527, t11528, t11529, t11531, t11534, t11536, t11545, t11548;
  double t11552, t11560, t11562, t11565, t11567, t11582, t11586, t11592;
  double tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47;
  double tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t11596, t11597;
  double t11599, t11601, t11602, t11604, t11606, t11607, t11608, t11611;
  double t11612, t11614, t11616, t11620, t11624, t11627, t11628, t11631;
  double t11634, t11635, t11637, t11640, t11641, t11643, t11645, t11650;
  double t11652, t11658, t11666, t11668, t11669, t11672, t11676, t11686;
  double t11690, t11706, t11715, t11716, t11720, t11725, t11731, t11741;
  double t11742, t11743, t11745, t11747, t11752, t11761, t11763, t11771;
  double t11776, t11778, t11781, t11783, t11796, t11800, t11806, tv4sigma414;
  double t11816, t11817, t11818, t11819, t11820, t11821, t11822, t11823;
  double t11826, t11827, t11828, t11829, t11830, t11831, t11832, t11834;
  double t11835, t11839, t11840, t11841, t11844, t11845, t11859, t11860;
  double t11861, t11862, t11863, t11866, t11867, t11870, t11871, t11872;
  double t11873, t11879, t11883, t11884, t11885, t11886, t11887, t11888;
  double t11890, t11891, t11894, t11896, t11901, t11904, t11917, t11924;
  double t11937, t11938, t11939, t11940, t11945, t11946, t11950, t11951;
  double t11957, t11966, t11977, t11987, t12006, t12016, t12018, t12022;
  double t12028, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4, tv4sigma3lapl5, tv4sigma3lapl6;
  double tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12, tv4sigma3lapl13, tv4sigma3lapl14;
  double tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, t12038, t12039, t12040, t12041;
  double t12042, t12043, t12044, t12045, t12046, t12047, t12048, t12049;
  double t12050, t12051, t12055, t12056, t12057, t12058, t12059, t12060;
  double t12064, t12065, t12068, t12072, t12075, t12076, t12077, t12078;
  double t12079, t12080, t12081, t12082, t12097, t12098, t12101, t12105;
  double t12106, t12107, t12108, t12110, t12111, t12112, t12113, t12116;
  double t12119, t12126, t12130, t12135, t12142, t12150, t12165, t12177;
  double t12188, t12207, t12208, t12209, t12210, t12215, t12216, t12217;
  double t12224, t12237, t12240, t12244, t12250, tv4sigma3lapl19, tv4sigma3tau0, tv4sigma3tau1;
  double tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9;
  double tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17;
  double tv4sigma3tau18, tv4sigma3tau19, t12257, t12261, t12265, t12271, t12274, t12275;
  double t12284, t12295, t12312, t12330, t12331, t12335, t12338, t12343;
  double t12355, t12358, t12366, t12379, t12381, t12383, t12384, t12386;
  double t12387, t12389, t12393, t12398, t12405, t12409, t12413, t12420;
  double t12423, t12432, t12434, t12449, t12461, t12464, t12468, t12474;
  double tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27;
  double tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215;
  double tv4sigma2lapl216, t12481, t12484, t12492, t12495, t12497, t12514, t12531;
  double t12543, t12551, t12555, t12559, t12560, t12571, t12575, t12580;
  double t12583, t12591, t12599, t12600, t12602, t12604, t12605, t12607;
  double t12609, t12611, t12613, t12617, t12622, t12629, t12633, t12636;
  double t12641, t12648, t12657, t12666, t12674, t12682, t12687, t12691;
  double t12697, tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5;
  double tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13;
  double tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21;
  double tv4sigma2lapltau22, tv4sigma2lapltau23, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25;
  double tv4sigma2tau26, tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213;
  double tv4sigma2tau214, tv4sigma2tau215, tv4sigma2tau216, tv4sigma2tau217, t12705, t12714, t12721, t12734;
  double t12740, t12749, t12760, t12764, t12777, t12781, t12801, t12806;
  double t12807, t12814, t12820, t12835, t12847, t12849, t12853, t12859;
  double tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37;
  double tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310, t12867, t12875, t12876, t12884, t12895;
  double t12905, t12916, t12928, t12948, t12953, t12974, t12981, t12984;
  double t12993, t12997, t13008, t13010, t13014, t13020, tv4sigmalapl311, tv4sigmalapl2tau0;
  double tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7, tv4sigmalapl2tau8;
  double tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15, tv4sigmalapl2tau16;
  double tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25, tv4sigmalapltau26;
  double tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213, tv4sigmalapltau214;
  double tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33, tv4sigmatau34;
  double tv4sigmatau35, tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, tv4sigmatau311, t13026;
  double t13027, t13028, t13031, t13032, t13035, t13038, t13046, t13051;
  double t13052, t13055, t13059, t13064, t13076, t13084, t13085, t13125;
  double t13143, t13148, t13153, t13178, t13182, t13188, tv4lapl40, tv4lapl41;
  double tv4lapl42, tv4lapl43, t13195, t13196, t13197, t13203, t13207, t13223;
  double t13224, t13227, t13232, t13238, t13243, t13267, t13268, t13290;
  double t13313, t13316, t13320, t13342, t13346, t13352, tv4lapl44, tv4lapl3tau0;
  double tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7, tv4lapl2tau20;
  double tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27, tv4lapl2tau28;
  double tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36, tv4lapltau37;
  double tv4tau40, tv4tau41, tv4tau42, tv4tau43, tv4tau44;

  mgga_k_csk_loc_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_loc_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t46 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43;
  t47 = params->csk_cp * t33;
  t48 = t37 * sigma[0];
  t52 = params->csk_cq * t33;
  t53 = t37 * lapl[0];
  t55 = 0.1e1 / t41 / rho[0];
  t59 = t47 * t48 * t43 / 0.24e2 + t52 * t53 * t55 / 0.24e2 - t46;
  t61 = log(0.1e1 - DBL_EPSILON);
  t62 = 0.1e1 / params->csk_a;
  t63 = pow(-t61, -t62);
  t64 = t59 < -t63;
  t65 = log(DBL_EPSILON);
  t66 = pow(-t65, -t62);
  t67 = -t66 < t59;
  t68 = my_piecewise3(t67, -t66, t59);
  t69 = -t63 < t68;
  t70 = my_piecewise3(t69, t68, -t63);
  t71 = fabs(t70);
  t72 = pow(t71, params->csk_a);
  t73 = 0.1e1 / t72;
  t74 = exp(-t73);
  t75 = 0.1e1 - t74;
  t76 = pow(t75, t62);
  t77 = my_piecewise5(t64, 0, t67, 1, t76);
  t79 = t59 * t77 + t46 + 0.1e1;
  t83 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t79);
  t84 = rho[1] <= p->dens_threshold;
  t85 = -t18;
  t87 = my_piecewise5(t16, t13, t12, t17, t85 * t9);
  t88 = 0.1e1 + t87;
  t89 = t88 <= p->zeta_threshold;
  t90 = POW_1_3(t88);
  t91 = t90 * t90;
  t93 = my_piecewise3(t89, t25, t91 * t88);
  t94 = t93 * t31;
  t95 = rho[1] * rho[1];
  t96 = POW_1_3(rho[1]);
  t97 = t96 * t96;
  t99 = 0.1e1 / t97 / t95;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t99;
  t103 = t37 * sigma[2];
  t107 = t37 * lapl[1];
  t109 = 0.1e1 / t97 / rho[1];
  t113 = t47 * t103 * t99 / 0.24e2 + t52 * t107 * t109 / 0.24e2 - t102;
  t114 = t113 < -t63;
  t115 = -t66 < t113;
  t116 = my_piecewise3(t115, -t66, t113);
  t117 = -t63 < t116;
  t118 = my_piecewise3(t117, t116, -t63);
  t119 = fabs(t118);
  t120 = pow(t119, params->csk_a);
  t121 = 0.1e1 / t120;
  t122 = exp(-t121);
  t123 = 0.1e1 - t122;
  t124 = pow(t123, t62);
  t125 = my_piecewise5(t114, 0, t115, 1, t124);
  t127 = t113 * t125 + t102 + 0.1e1;
  t131 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t127);
  tzk0 = t83 + t131;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t132 = t8 * t8;
  t133 = 0.1e1 / t132;
  t134 = t18 * t133;
  t136 = my_piecewise5(t12, 0, t16, 0, t9 - t134);
  t139 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t136);
  t140 = t139 * t31;
  t144 = 0.1e1 / t30;
  t145 = t29 * t144;
  t148 = t7 * t145 * t79 / 0.1e2;
  t151 = 0.1e1 / t41 / t39 / rho[0];
  t154 = 0.5e1 / 0.27e2 * t38 * sigma[0] * t151;
  t161 = -t47 * t48 * t151 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t53 * t43 + t154;
  t163 = t76 * t73;
  t164 = my_piecewise3(t67, 0, t161);
  t165 = my_piecewise3(t69, t164, 0);
  t167 = fabs(t70) / t70;
  t168 = 0.1e1 / t71;
  t170 = 0.1e1 / t75;
  t171 = t74 * t170;
  t172 = t167 * t168 * t171;
  t174 = my_piecewise5(t64, 0, t67, 0, -t163 * t165 * t172);
  t176 = t161 * t77 + t174 * t59 - t154;
  t181 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t79 + t148 + 0.3e1 / 0.2e2 * t7 * t32 * t176);
  t182 = t85 * t133;
  t184 = my_piecewise5(t16, 0, t12, 0, -t9 - t182);
  t187 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t184);
  t188 = t187 * t31;
  t192 = t93 * t144;
  t195 = t7 * t192 * t127 / 0.1e2;
  t197 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t127 + t195);
  tvrho0 = t83 + t131 + t8 * (t181 + t197);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t201 = my_piecewise5(t12, 0, t16, 0, -t9 - t134);
  t204 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t201);
  t205 = t204 * t31;
  t210 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t79 + t148);
  t212 = my_piecewise5(t16, 0, t12, 0, t9 - t182);
  t215 = my_piecewise3(t89, 0, 0.5e1 / 0.3e1 * t91 * t212);
  t216 = t215 * t31;
  t222 = 0.1e1 / t97 / t95 / rho[1];
  t225 = 0.5e1 / 0.27e2 * t38 * sigma[2] * t222;
  t232 = -t47 * t103 * t222 / 0.9e1 - 0.5e1 / 0.72e2 * t52 * t107 * t99 + t225;
  t234 = t124 * t121;
  t235 = my_piecewise3(t115, 0, t232);
  t236 = my_piecewise3(t117, t235, 0);
  t238 = fabs(t118) / t118;
  t239 = 0.1e1 / t119;
  t241 = 0.1e1 / t123;
  t242 = t122 * t241;
  t243 = t238 * t239 * t242;
  t245 = my_piecewise5(t114, 0, t115, 0, -t234 * t236 * t243);
  t247 = t113 * t245 + t125 * t232 - t225;
  t252 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t127 + t195 + 0.3e1 / 0.2e2 * t7 * t94 * t247);
  tvrho1 = t83 + t131 + t8 * (t210 + t252);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t256 = 0.5e1 / 0.72e2 * t38 * t43;
  t257 = t37 * t43;
  t260 = t47 * t257 / 0.24e2 - t256;
  t262 = my_piecewise3(t67, 0, t260);
  t263 = my_piecewise3(t69, t262, 0);
  t266 = my_piecewise5(t64, 0, t67, 0, -t163 * t263 * t172);
  t268 = t260 * t77 + t266 * t59 + t256;
  t272 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t268);
  tvsigma0 = t8 * t272;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t274 = 0.5e1 / 0.72e2 * t38 * t99;
  t275 = t37 * t99;
  t278 = t47 * t275 / 0.24e2 - t274;
  t280 = my_piecewise3(t115, 0, t278);
  t281 = my_piecewise3(t117, t280, 0);
  t284 = my_piecewise5(t114, 0, t115, 0, -t234 * t281 * t243);
  t286 = t113 * t284 + t125 * t278 + t274;
  t290 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t286);
  tvsigma2 = t8 * t290;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t291 = t37 * t55;
  t297 = my_piecewise3(t67, 0, t52 * t291 / 0.24e2);
  t298 = my_piecewise3(t69, t297, 0);
  t301 = my_piecewise5(t64, 0, t67, 0, -t163 * t298 * t172);
  t303 = t52 * t291 * t77 / 0.24e2 + t59 * t301;
  t307 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t303);
  tvlapl0 = t8 * t307;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t308 = t37 * t109;
  t314 = my_piecewise3(t115, 0, t52 * t308 / 0.24e2);
  t315 = my_piecewise3(t117, t314, 0);
  t318 = my_piecewise5(t114, 0, t115, 0, -t234 * t315 * t243);
  t320 = t52 * t308 * t125 / 0.24e2 + t113 * t318;
  t324 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t320);
  tvlapl1 = t8 * t324;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t327 = 0.1e1 / t26;
  t328 = t136 * t136;
  t331 = t132 * t8;
  t332 = 0.1e1 / t331;
  t333 = t18 * t332;
  t336 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t133 + 0.2e1 * t333);
  t340 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t327 * t328 + 0.5e1 / 0.3e1 * t27 * t336);
  t341 = t340 * t31;
  t345 = t139 * t144;
  t347 = t7 * t345 * t79;
  t353 = 0.1e1 / t30 / t8;
  t354 = t29 * t353;
  t357 = t7 * t354 * t79 / 0.3e2;
  t359 = t7 * t145 * t176;
  t361 = t39 * t39;
  t363 = 0.1e1 / t41 / t361;
  t366 = 0.55e2 / 0.81e2 * t38 * sigma[0] * t363;
  t373 = 0.11e2 / 0.27e2 * t47 * t48 * t363 + 0.5e1 / 0.27e2 * t52 * t53 * t151 - t366;
  t377 = t72 * t72;
  t379 = t76 / t377;
  t380 = t165 * t165;
  t382 = t167 * t167;
  t383 = t71 * t71;
  t384 = 0.1e1 / t383;
  t385 = t382 * t384;
  t386 = t74 * t74;
  t387 = t75 * t75;
  t388 = 0.1e1 / t387;
  t389 = t386 * t388;
  t390 = t385 * t389;
  t392 = t380 * t382;
  t394 = t384 * t74;
  t395 = t170 * params->csk_a;
  t396 = t394 * t395;
  t398 = my_piecewise3(t67, 0, t373);
  t399 = my_piecewise3(t69, t398, 0);
  t402 = t163 * t380;
  t403 = 0.0;
  t405 = t403 * t168 * t171;
  t406 = t402 * t405;
  t407 = t385 * t171;
  t409 = t379 * t392;
  t411 = t384 * t386;
  t412 = t388 * params->csk_a;
  t413 = t411 * t412;
  t416 = my_piecewise5(t64, 0, t67, 0, -t163 * t172 * t399 + t163 * t392 * t396 + t379 * t380 * t390 - t396 * t409 + t402 * t407 - t409 * t413 - t406);
  t418 = 0.2e1 * t161 * t174 + t373 * t77 + t416 * t59 + t366;
  t423 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t79 + t347 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t176 - t357 + t359 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t418);
  t424 = 0.1e1 / t90;
  t425 = t184 * t184;
  t428 = t85 * t332;
  t431 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t133 + 0.2e1 * t428);
  t435 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t424 * t425 + 0.5e1 / 0.3e1 * t91 * t431);
  t436 = t435 * t31;
  t440 = t187 * t144;
  t442 = t7 * t440 * t127;
  t444 = t93 * t353;
  t447 = t7 * t444 * t127 / 0.3e2;
  t449 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t127 + t442 / 0.5e1 - t447);
  tv2rho20 = 0.2e1 * t181 + 0.2e1 * t197 + t8 * (t423 + t449);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t452 = t327 * t201;
  t456 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t333);
  t460 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t452 * t136 + 0.5e1 / 0.3e1 * t27 * t456);
  t461 = t460 * t31;
  t465 = t204 * t144;
  t467 = t7 * t465 * t79;
  t475 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t79 + t467 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t176 + t347 / 0.1e2 - t357 + t359 / 0.1e2);
  t476 = t424 * t212;
  t480 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t428);
  t484 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t476 * t184 + 0.5e1 / 0.3e1 * t91 * t480);
  t485 = t484 * t31;
  t489 = t215 * t144;
  t491 = t7 * t489 * t127;
  t498 = t7 * t192 * t247;
  t501 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t127 + t491 / 0.1e2 + t442 / 0.1e2 - t447 + 0.3e1 / 0.2e2 * t7 * t188 * t247 + t498 / 0.1e2);
  tv2rho21 = t181 + t197 + t210 + t252 + t8 * (t475 + t501);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t506 = t201 * t201;
  t511 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t133 + 0.2e1 * t333);
  t515 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t327 * t506 + 0.5e1 / 0.3e1 * t27 * t511);
  t516 = t515 * t31;
  t522 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t79 + t467 / 0.5e1 - t357);
  t523 = t212 * t212;
  t528 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t133 + 0.2e1 * t428);
  t532 = my_piecewise3(t89, 0, 0.1e2 / 0.9e1 * t424 * t523 + 0.5e1 / 0.3e1 * t91 * t528);
  t533 = t532 * t31;
  t542 = t95 * t95;
  t544 = 0.1e1 / t97 / t542;
  t547 = 0.55e2 / 0.81e2 * t38 * sigma[2] * t544;
  t554 = 0.11e2 / 0.27e2 * t47 * t103 * t544 + 0.5e1 / 0.27e2 * t52 * t107 * t222 - t547;
  t558 = t120 * t120;
  t560 = t124 / t558;
  t561 = t236 * t236;
  t563 = t238 * t238;
  t564 = t119 * t119;
  t565 = 0.1e1 / t564;
  t566 = t563 * t565;
  t567 = t122 * t122;
  t568 = t123 * t123;
  t569 = 0.1e1 / t568;
  t570 = t567 * t569;
  t571 = t566 * t570;
  t573 = t561 * t563;
  t575 = t565 * t122;
  t576 = t241 * params->csk_a;
  t577 = t575 * t576;
  t579 = my_piecewise3(t115, 0, t554);
  t580 = my_piecewise3(t117, t579, 0);
  t583 = t234 * t561;
  t584 = 0.0;
  t586 = t584 * t239 * t242;
  t587 = t583 * t586;
  t588 = t566 * t242;
  t590 = t560 * t573;
  t592 = t565 * t567;
  t593 = t569 * params->csk_a;
  t594 = t592 * t593;
  t597 = my_piecewise5(t114, 0, t115, 0, -t234 * t243 * t580 + t234 * t573 * t577 + t560 * t561 * t571 - t577 * t590 + t583 * t588 - t590 * t594 - t587);
  t599 = t113 * t597 + t125 * t554 + 0.2e1 * t232 * t245 + t547;
  t604 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t127 + t491 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t247 - t447 + t498 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t599);
  tv2rho22 = 0.2e1 * t210 + 0.2e1 * t252 + t8 * (t522 + t604);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t612 = t7 * t145 * t268 / 0.1e2;
  t614 = 0.5e1 / 0.27e2 * t38 * t151;
  t615 = t37 * t151;
  t618 = -t47 * t615 / 0.9e1 + t614;
  t622 = t165 * t382;
  t623 = t379 * t622;
  t624 = t388 * t263;
  t625 = t411 * t624;
  t627 = t263 * t382;
  t628 = t163 * t627;
  t629 = t395 * t165;
  t630 = t394 * t629;
  t632 = my_piecewise3(t67, 0, t618);
  t633 = my_piecewise3(t69, t632, 0);
  t636 = t263 * t165;
  t638 = t163 * t636 * t405;
  t639 = t170 * t165;
  t640 = t394 * t639;
  t642 = t379 * t627;
  t644 = t412 * t165;
  t645 = t411 * t644;
  t648 = my_piecewise5(t64, 0, t67, 0, -t163 * t172 * t633 + t623 * t625 + t628 * t630 + t628 * t640 - t630 * t642 - t642 * t645 - t638);
  t650 = t161 * t266 + t174 * t260 + t59 * t648 + t618 * t77 - t614;
  t655 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t268 + t612 + 0.3e1 / 0.2e2 * t7 * t32 * t650);
  tv2rhosigma0 = t655 * t8 + t272;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t662 = t7 * t192 * t286 / 0.1e2;
  t664 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t286 + t662);
  tv2rhosigma2 = t664 * t8 + t290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t670 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t268 + t612);
  tv2rhosigma3 = t670 * t8 + t272;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t676 = 0.5e1 / 0.27e2 * t38 * t222;
  t677 = t37 * t222;
  t680 = -t47 * t677 / 0.9e1 + t676;
  t684 = t236 * t563;
  t685 = t560 * t684;
  t686 = t569 * t281;
  t687 = t592 * t686;
  t689 = t281 * t563;
  t690 = t234 * t689;
  t692 = t575 * t576 * t236;
  t694 = my_piecewise3(t115, 0, t680);
  t695 = my_piecewise3(t117, t694, 0);
  t698 = t281 * t236;
  t700 = t234 * t698 * t586;
  t701 = t241 * t236;
  t702 = t575 * t701;
  t704 = t560 * t689;
  t706 = t593 * t236;
  t707 = t592 * t706;
  t710 = my_piecewise5(t114, 0, t115, 0, -t234 * t243 * t695 + t685 * t687 + t690 * t692 + t690 * t702 - t692 * t704 - t704 * t707 - t700);
  t712 = t113 * t710 + t125 * t680 + t232 * t284 + t245 * t278 - t676;
  t717 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t286 + t662 + 0.3e1 / 0.2e2 * t7 * t94 * t712);
  tv2rhosigma5 = t717 * t8 + t290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t724 = t7 * t145 * t303 / 0.1e2;
  t732 = t388 * t298;
  t733 = t411 * t732;
  t735 = t298 * t382;
  t736 = t163 * t735;
  t740 = my_piecewise3(t67, 0, -0.5e1 / 0.72e2 * t52 * t257);
  t741 = my_piecewise3(t69, t740, 0);
  t744 = t298 * t165;
  t746 = t163 * t744 * t405;
  t748 = t379 * t735;
  t752 = my_piecewise5(t64, 0, t67, 0, -t163 * t172 * t741 + t623 * t733 + t630 * t736 - t630 * t748 + t640 * t736 - t645 * t748 - t746);
  t754 = -0.5e1 / 0.72e2 * t52 * t257 * t77 + t52 * t291 * t174 / 0.24e2 + t161 * t301 + t59 * t752;
  t759 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t303 + t724 + 0.3e1 / 0.2e2 * t7 * t32 * t754);
  tv2rholapl0 = t759 * t8 + t307;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t766 = t7 * t192 * t320 / 0.1e2;
  t768 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t320 + t766);
  tv2rholapl1 = t768 * t8 + t324;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t774 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t303 + t724);
  tv2rholapl2 = t774 * t8 + t307;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t786 = t569 * t315;
  t787 = t592 * t786;
  t789 = t315 * t563;
  t790 = t234 * t789;
  t794 = my_piecewise3(t115, 0, -0.5e1 / 0.72e2 * t52 * t275);
  t795 = my_piecewise3(t117, t794, 0);
  t798 = t315 * t236;
  t800 = t234 * t798 * t586;
  t802 = t560 * t789;
  t806 = my_piecewise5(t114, 0, t115, 0, -t234 * t243 * t795 + t685 * t787 + t692 * t790 - t692 * t802 + t702 * t790 - t707 * t802 - t800);
  t808 = -0.5e1 / 0.72e2 * t52 * t275 * t125 + t52 * t308 * t245 / 0.24e2 + t232 * t318 + t113 * t806;
  t813 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t320 + t766 + 0.3e1 / 0.2e2 * t7 * t94 * t808);
  tv2rholapl3 = t8 * t813 + t324;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t817 = t263 * t263;
  t820 = t817 * t382;
  t823 = my_piecewise3(t67, 0, 0);
  t824 = my_piecewise3(t69, t823, 0);
  t826 = t163 * t824 * t172;
  t827 = t163 * t817;
  t828 = t827 * t405;
  t830 = t379 * t820;
  t834 = my_piecewise5(t64, 0, t67, 0, t163 * t396 * t820 + t379 * t390 * t817 - t396 * t830 + t407 * t827 - t413 * t830 - t826 - t828);
  t836 = 0.2e1 * t260 * t266 + t59 * t834;
  t840 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t836);
  tv2sigma20 = t8 * t840;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t843 = t281 * t281;
  t846 = t843 * t563;
  t849 = my_piecewise3(t115, 0, 0);
  t850 = my_piecewise3(t117, t849, 0);
  t852 = t234 * t850 * t243;
  t853 = t234 * t843;
  t854 = t853 * t586;
  t856 = t560 * t846;
  t860 = my_piecewise5(t114, 0, t115, 0, t234 * t577 * t846 + t560 * t571 * t843 - t577 * t856 + t588 * t853 - t594 * t856 - t852 - t854);
  t862 = t113 * t860 + 0.2e1 * t278 * t284;
  t866 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t862);
  tv2sigma25 = t8 * t866;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t872 = t395 * t263;
  t873 = t394 * t872;
  t875 = t298 * t263;
  t876 = t163 * t875;
  t877 = t876 * t405;
  t878 = t170 * t263;
  t879 = t394 * t878;
  t882 = t412 * t263;
  t883 = t411 * t882;
  t886 = my_piecewise5(t64, 0, t67, 0, t642 * t733 + t736 * t873 + t736 * t879 - t748 * t873 - t748 * t883 - t826 - t877);
  t888 = t52 * t291 * t266 / 0.24e2 + t260 * t301 + t59 * t886;
  t892 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t888);
  tv2sigmalapl0 = t8 * t892;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t898 = t576 * t281;
  t899 = t575 * t898;
  t901 = t315 * t281;
  t902 = t234 * t901;
  t903 = t902 * t586;
  t904 = t241 * t281;
  t905 = t575 * t904;
  t908 = t593 * t281;
  t909 = t592 * t908;
  t912 = my_piecewise5(t114, 0, t115, 0, t704 * t787 + t790 * t899 + t790 * t905 - t802 * t899 - t802 * t909 - t852 - t903);
  t914 = t52 * t308 * t284 / 0.24e2 + t278 * t318 + t113 * t912;
  t918 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t914);
  tv2sigmalapl5 = t8 * t918;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t922 = t298 * t298;
  t925 = t922 * t382;
  t926 = t163 * t925;
  t928 = t163 * t922;
  t929 = t928 * t405;
  t931 = t379 * t925;
  t935 = my_piecewise5(t64, 0, t67, 0, t379 * t390 * t922 + t396 * t926 - t396 * t931 + t407 * t928 - t413 * t931 - t826 - t929);
  t937 = t52 * t291 * t301 / 0.12e2 + t59 * t935;
  t941 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t937);
  tv2lapl20 = t8 * t941;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t945 = t315 * t315;
  t948 = t945 * t563;
  t949 = t234 * t948;
  t951 = t234 * t945;
  t952 = t951 * t586;
  t954 = t560 * t948;
  t958 = my_piecewise5(t114, 0, t115, 0, t560 * t571 * t945 + t577 * t949 - t577 * t954 + t588 * t951 - t594 * t954 - t852 - t952);
  t960 = t52 * t308 * t318 / 0.12e2 + t113 * t958;
  t964 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t960);
  tv2lapl22 = t8 * t964;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t968 = 0.1e1 / t26 / t21;
  t969 = t328 * t136;
  t972 = t327 * t136;
  t975 = t132 * t132;
  t976 = 0.1e1 / t975;
  t977 = t18 * t976;
  t980 = my_piecewise5(t12, 0, t16, 0, 0.6e1 * t332 - 0.6e1 * t977);
  t984 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t968 * t969 + 0.1e2 / 0.3e1 * t972 * t336 + 0.5e1 / 0.3e1 * t27 * t980);
  t985 = t984 * t31;
  t989 = t340 * t144;
  t991 = t7 * t989 * t79;
  t996 = t139 * t353;
  t998 = t7 * t996 * t79;
  t1001 = t7 * t345 * t176;
  t1007 = 0.1e1 / t30 / t132;
  t1008 = t29 * t1007;
  t1011 = 0.2e1 / 0.45e2 * t7 * t1008 * t79;
  t1013 = t7 * t354 * t176;
  t1016 = t7 * t145 * t418;
  t1020 = 0.1e1 / t41 / t361 / rho[0];
  t1023 = 0.77e3 / 0.243e3 * t38 * sigma[0] * t1020;
  t1030 = -0.154e3 / 0.81e2 * t47 * t48 * t1020 - 0.55e2 / 0.81e2 * t52 * t53 * t363 + t1023;
  t1036 = t399 * t382;
  t1037 = t379 * t1036;
  t1040 = t380 * t165;
  t1041 = t1040 * t403;
  t1042 = t379 * t1041;
  t1043 = t384 * params->csk_a;
  t1045 = t167 * t74 * t170;
  t1046 = t1043 * t1045;
  t1047 = t1042 * t1046;
  t1049 = t1040 * t167;
  t1051 = t395 * t403;
  t1052 = t394 * t1051;
  t1053 = t163 * t1049 * t1052;
  t1056 = t395 * t399;
  t1057 = t394 * t1056;
  t1063 = t411 * t412 * t167;
  t1064 = t1042 * t1063;
  t1068 = t76 / t377 / t72;
  t1070 = t382 * t167;
  t1072 = 0.1e1 / t383 / t71;
  t1073 = t1070 * t1072;
  t1074 = t386 * t74;
  t1076 = 0.1e1 / t387 / t75;
  t1077 = t1074 * t1076;
  t1078 = t1073 * t1077;
  t1080 = my_piecewise3(t67, 0, t1030);
  t1081 = my_piecewise3(t69, t1080, 0);
  t1085 = t1073 * t389;
  t1089 = t1073 * t171;
  t1092 = t1040 * t1070;
  t1093 = t379 * t1092;
  t1094 = t1072 * params->csk_a;
  t1095 = t1094 * t171;
  t1098 = t163 * t1092;
  t1101 = -t1040 * t1068 * t1078 - 0.3e1 * t1040 * t1085 * t379 - 0.2e1 * t1040 * t1089 * t163 + 0.3e1 * t1057 * t163 * t622 - t1081 * t163 * t172 - 0.3e1 * t1037 * t630 - 0.3e1 * t1037 * t645 + 0.3e1 * t1093 * t1095 - 0.3e1 * t1095 * t1098 - 0.3e1 * t1047 + 0.3e1 * t1053 - 0.3e1 * t1064 - t406;
  t1103 = t388 * t403;
  t1104 = t411 * t1103;
  t1105 = t379 * t1049 * t1104;
  t1111 = t170 * t167;
  t1112 = t394 * t1111;
  t1113 = t163 * t1041 * t1112;
  t1115 = params->csk_a * params->csk_a;
  t1116 = t1072 * t1115;
  t1117 = t1116 * t171;
  t1120 = t1068 * t1092;
  t1122 = t1072 * t386;
  t1123 = t1122 * t412;
  t1127 = t388 * t399;
  t1131 = t1072 * t1074;
  t1132 = t1076 * params->csk_a;
  t1133 = t1131 * t1132;
  t1136 = t388 * t1115;
  t1137 = t1122 * t1136;
  t1142 = t163 * t399 * t165 * t405;
  t1146 = t1076 * t1115;
  t1147 = t1131 * t1146;
  t1150 = 0.3e1 * t1036 * t163 * t640 + 0.3e1 * t1127 * t411 * t623 + 0.3e1 * t1093 * t1117 + 0.3e1 * t1093 * t1137 - t1098 * t1117 - t1117 * t1120 + 0.3e1 * t1120 * t1123 + 0.3e1 * t1120 * t1133 - 0.3e1 * t1120 * t1137 - 0.2e1 * t1120 * t1147 + 0.3e1 * t1105 + 0.3e1 * t1113 - 0.3e1 * t1142;
  t1152 = my_piecewise5(t64, 0, t67, 0, t1101 + t1150);
  t1154 = t1030 * t77 + t1152 * t59 + 0.3e1 * t161 * t416 + 0.3e1 * t174 * t373 - t1023;
  t1159 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t985 * t79 + 0.3e1 / 0.1e2 * t991 + 0.9e1 / 0.2e2 * t7 * t341 * t176 - t998 / 0.1e2 + 0.3e1 / 0.5e1 * t1001 + 0.9e1 / 0.2e2 * t7 * t140 * t418 + t1011 - t1013 / 0.1e2 + 0.3e1 / 0.1e2 * t1016 + 0.3e1 / 0.2e2 * t7 * t32 * t1154);
  t1161 = 0.1e1 / t90 / t88;
  t1162 = t425 * t184;
  t1165 = t424 * t184;
  t1168 = t85 * t976;
  t1171 = my_piecewise5(t16, 0, t12, 0, -0.6e1 * t332 - 0.6e1 * t1168);
  t1175 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1161 * t1162 + 0.1e2 / 0.3e1 * t1165 * t431 + 0.5e1 / 0.3e1 * t91 * t1171);
  t1176 = t1175 * t31;
  t1180 = t435 * t144;
  t1182 = t7 * t1180 * t127;
  t1184 = t187 * t353;
  t1186 = t7 * t1184 * t127;
  t1188 = t93 * t1007;
  t1191 = 0.2e1 / 0.45e2 * t7 * t1188 * t127;
  t1193 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1176 * t127 + 0.3e1 / 0.1e2 * t1182 - t1186 / 0.1e2 + t1191);
  tv3rho30 = 0.3e1 * t423 + 0.3e1 * t449 + t8 * (t1159 + t1193);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1196 = 0.2e1 * t475;
  t1197 = 0.2e1 * t501;
  t1198 = t968 * t201;
  t1201 = t327 * t456;
  t1206 = 0.2e1 * t332;
  t1207 = 0.6e1 * t977;
  t1209 = my_piecewise5(t12, 0, t16, 0, t1206 - t1207);
  t1213 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1198 * t328 + 0.2e2 / 0.9e1 * t1201 * t136 + 0.1e2 / 0.9e1 * t452 * t336 + 0.5e1 / 0.3e1 * t27 * t1209);
  t1214 = t1213 * t31;
  t1218 = t460 * t144;
  t1221 = t7 * t1218 * t79 / 0.5e1;
  t1225 = t204 * t353;
  t1227 = t7 * t1225 * t79;
  t1231 = t7 * t465 * t176 / 0.5e1;
  t1240 = 0.3e1 / 0.2e2 * t7 * t1214 * t79 + t1221 + 0.3e1 / 0.1e2 * t7 * t461 * t176 - t1227 / 0.3e2 + t1231 + 0.3e1 / 0.2e2 * t7 * t205 * t418 + t991 / 0.1e2 - t998 / 0.15e2 + t1001 / 0.5e1 + t1011 - t1013 / 0.15e2 + t1016 / 0.1e2;
  t1241 = my_piecewise3(t2, 0, t1240);
  t1242 = t1161 * t212;
  t1245 = t424 * t480;
  t1250 = 0.6e1 * t1168;
  t1252 = my_piecewise5(t16, 0, t12, 0, -t1206 - t1250);
  t1256 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1242 * t425 + 0.2e2 / 0.9e1 * t1245 * t184 + 0.1e2 / 0.9e1 * t476 * t431 + 0.5e1 / 0.3e1 * t91 * t1252);
  t1257 = t1256 * t31;
  t1261 = t484 * t144;
  t1264 = t7 * t1261 * t127 / 0.5e1;
  t1265 = t215 * t353;
  t1267 = t7 * t1265 * t127;
  t1276 = t7 * t440 * t247 / 0.5e1;
  t1278 = t7 * t444 * t247;
  t1281 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1257 * t127 + t1264 - t1267 / 0.3e2 + t1182 / 0.1e2 - t1186 / 0.15e2 + t1191 + 0.3e1 / 0.2e2 * t7 * t436 * t247 + t1276 - t1278 / 0.3e2);
  tv3rho31 = t423 + t449 + t1196 + t1197 + t8 * (t1241 + t1281);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1284 = t968 * t506;
  t1289 = t327 * t511;
  t1293 = my_piecewise5(t12, 0, t16, 0, -t1206 - t1207);
  t1297 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1284 * t136 + 0.2e2 / 0.9e1 * t452 * t456 + 0.1e2 / 0.9e1 * t1289 * t136 + 0.5e1 / 0.3e1 * t27 * t1293);
  t1298 = t1297 * t31;
  t1302 = t515 * t144;
  t1304 = t7 * t1302 * t79;
  t1313 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1298 * t79 + t1304 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t516 * t176 + t1221 - t1227 / 0.15e2 + t1231 - t998 / 0.3e2 + t1011 - t1013 / 0.3e2);
  t1314 = t1161 * t523;
  t1319 = t424 * t528;
  t1323 = my_piecewise5(t16, 0, t12, 0, t1206 - t1250);
  t1327 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1314 * t184 + 0.2e2 / 0.9e1 * t476 * t480 + 0.1e2 / 0.9e1 * t1319 * t184 + 0.5e1 / 0.3e1 * t91 * t1323);
  t1328 = t1327 * t31;
  t1332 = t532 * t144;
  t1334 = t7 * t1332 * t127;
  t1341 = t7 * t489 * t247;
  t1349 = t7 * t192 * t599;
  t1351 = 0.3e1 / 0.2e2 * t7 * t1328 * t127 + t1334 / 0.1e2 + t1264 - t1267 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t485 * t247 + t1341 / 0.5e1 - t1186 / 0.3e2 + t1191 + t1276 - t1278 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t188 * t599 + t1349 / 0.1e2;
  t1352 = my_piecewise3(t84, 0, t1351);
  tv3rho32 = t1196 + t1197 + t522 + t604 + t8 * (t1313 + t1352);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1357 = t506 * t201;
  t1364 = my_piecewise5(t12, 0, t16, 0, -0.6e1 * t332 - 0.6e1 * t977);
  t1368 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t968 * t1357 + 0.1e2 / 0.3e1 * t452 * t511 + 0.5e1 / 0.3e1 * t27 * t1364);
  t1369 = t1368 * t31;
  t1376 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1369 * t79 + 0.3e1 / 0.1e2 * t1304 - t1227 / 0.1e2 + t1011);
  t1377 = t523 * t212;
  t1384 = my_piecewise5(t16, 0, t12, 0, 0.6e1 * t332 - 0.6e1 * t1168);
  t1388 = my_piecewise3(t89, 0, -0.1e2 / 0.27e2 * t1161 * t1377 + 0.1e2 / 0.3e1 * t476 * t528 + 0.5e1 / 0.3e1 * t91 * t1384);
  t1389 = t1388 * t31;
  t1406 = 0.1e1 / t97 / t542 / rho[1];
  t1409 = 0.77e3 / 0.243e3 * t38 * sigma[2] * t1406;
  t1416 = -0.154e3 / 0.81e2 * t47 * t103 * t1406 - 0.55e2 / 0.81e2 * t52 * t107 * t544 + t1409;
  t1422 = t580 * t563;
  t1423 = t560 * t1422;
  t1426 = t561 * t236;
  t1427 = t1426 * t584;
  t1428 = t560 * t1427;
  t1429 = t565 * params->csk_a;
  t1431 = t238 * t122 * t241;
  t1432 = t1429 * t1431;
  t1433 = t1428 * t1432;
  t1435 = t1426 * t238;
  t1437 = t576 * t584;
  t1438 = t575 * t1437;
  t1439 = t234 * t1435 * t1438;
  t1442 = t592 * t593 * t238;
  t1443 = t1428 * t1442;
  t1446 = t576 * t580;
  t1447 = t575 * t1446;
  t1454 = t124 / t558 / t120;
  t1456 = t563 * t238;
  t1458 = 0.1e1 / t564 / t119;
  t1459 = t1456 * t1458;
  t1460 = t567 * t122;
  t1462 = 0.1e1 / t568 / t123;
  t1463 = t1460 * t1462;
  t1464 = t1459 * t1463;
  t1466 = my_piecewise3(t115, 0, t1416);
  t1467 = my_piecewise3(t117, t1466, 0);
  t1471 = t1459 * t242;
  t1475 = t1459 * t570;
  t1478 = t1426 * t1456;
  t1479 = t1454 * t1478;
  t1480 = t1458 * t1115;
  t1481 = t1480 * t242;
  t1483 = t560 * t1478;
  t1484 = t1458 * params->csk_a;
  t1485 = t1484 * t242;
  t1488 = -t1426 * t1454 * t1464 - 0.2e1 * t1426 * t1471 * t234 - 0.3e1 * t1426 * t1475 * t560 + 0.3e1 * t1447 * t234 * t684 - t1467 * t234 * t243 - 0.3e1 * t1423 * t692 - 0.3e1 * t1423 * t707 - t1479 * t1481 + 0.3e1 * t1483 * t1485 - 0.3e1 * t1433 + 0.3e1 * t1439 - 0.3e1 * t1443 - t587;
  t1489 = t234 * t1478;
  t1492 = t1458 * t1460;
  t1493 = t1462 * t1115;
  t1494 = t1492 * t1493;
  t1498 = t569 * t584;
  t1499 = t592 * t1498;
  t1500 = t560 * t1435 * t1499;
  t1506 = t241 * t238;
  t1507 = t575 * t1506;
  t1508 = t234 * t1427 * t1507;
  t1510 = t1458 * t567;
  t1511 = t1510 * t593;
  t1517 = t569 * t580;
  t1521 = t1462 * params->csk_a;
  t1522 = t1492 * t1521;
  t1525 = t569 * t1115;
  t1526 = t1510 * t1525;
  t1531 = t234 * t580 * t236 * t586;
  t1535 = 0.3e1 * t1422 * t234 * t702 + 0.3e1 * t1517 * t592 * t685 - 0.2e1 * t1479 * t1494 + 0.3e1 * t1479 * t1511 + 0.3e1 * t1479 * t1522 - 0.3e1 * t1479 * t1526 + 0.3e1 * t1481 * t1483 - t1481 * t1489 + 0.3e1 * t1483 * t1526 - 0.3e1 * t1485 * t1489 + 0.3e1 * t1500 + 0.3e1 * t1508 - 0.3e1 * t1531;
  t1537 = my_piecewise5(t114, 0, t115, 0, t1488 + t1535);
  t1539 = t113 * t1537 + t125 * t1416 + 0.3e1 * t232 * t597 + 0.3e1 * t245 * t554 - t1409;
  t1544 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1389 * t127 + 0.3e1 / 0.1e2 * t1334 + 0.9e1 / 0.2e2 * t7 * t533 * t247 - t1267 / 0.1e2 + 0.3e1 / 0.5e1 * t1341 + 0.9e1 / 0.2e2 * t7 * t216 * t599 + t1191 - t1278 / 0.1e2 + 0.3e1 / 0.1e2 * t1349 + 0.3e1 / 0.2e2 * t7 * t94 * t1539);
  tv3rho33 = 0.3e1 * t522 + 0.3e1 * t604 + t8 * (t1376 + t1544);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1552 = t7 * t345 * t268;
  t1559 = t7 * t354 * t268 / 0.3e2;
  t1561 = t7 * t145 * t650;
  t1564 = 0.55e2 / 0.81e2 * t38 * t363;
  t1565 = t37 * t363;
  t1568 = 0.11e2 / 0.27e2 * t47 * t1565 - t1564;
  t1576 = t263 * t1070;
  t1577 = t163 * t1576;
  t1578 = t1072 * t74;
  t1580 = t1578 * t395 * t380;
  t1583 = t263 * t380;
  t1586 = t403 * t384 * t1045;
  t1587 = t163 * t1583 * t1586;
  t1589 = t380 * t167;
  t1590 = t379 * t1589;
  t1591 = t624 * t403;
  t1592 = t411 * t1591;
  t1593 = t1590 * t1592;
  t1595 = t380 * t1070;
  t1596 = t1068 * t1595;
  t1597 = t1122 * t882;
  t1600 = t170 * t1115;
  t1602 = t1578 * t1600 * t380;
  t1604 = t379 * t1576;
  t1607 = t1068 * t1576;
  t1611 = t380 * t386 * t388;
  t1612 = t1116 * t1611;
  t1615 = t412 * t399;
  t1616 = t411 * t1615;
  t1618 = t1146 * t380;
  t1619 = t1131 * t1618;
  t1622 = t633 * t382;
  t1623 = t163 * t1622;
  t1629 = t379 * t1622;
  t1632 = t1057 * t628 - t1057 * t642 - 0.3e1 * t1577 * t1580 - t1577 * t1602 + 0.3e1 * t1596 * t1597 + 0.3e1 * t1602 * t1604 - t1602 * t1607 + 0.3e1 * t1604 * t1612 - 0.3e1 * t1607 * t1612 - 0.2e1 * t1607 * t1619 - t1616 * t642 + 0.2e1 * t1623 * t630 - 0.2e1 * t1629 * t645 + 0.3e1 * t1587 + 0.3e1 * t1593 - t638;
  t1633 = t1076 * t263;
  t1634 = t1633 * params->csk_a;
  t1635 = t1131 * t1634;
  t1642 = t1583 * t403;
  t1643 = t379 * t1642;
  t1644 = t1643 * t1046;
  t1646 = t263 * t167;
  t1647 = t1646 * t384;
  t1648 = t163 * t1647;
  t1649 = params->csk_a * t380;
  t1650 = t1649 * t403;
  t1651 = t171 * t1650;
  t1652 = t1648 * t1651;
  t1654 = t1643 * t1063;
  t1656 = my_piecewise3(t67, 0, t1568);
  t1657 = my_piecewise3(t69, t1656, 0);
  t1660 = t170 * t380;
  t1661 = t1578 * t1660;
  t1664 = t379 * t1595;
  t1665 = t1122 * t624;
  t1670 = t163 * t263 * t399 * t405;
  t1671 = t170 * t399;
  t1672 = t394 * t1671;
  t1675 = t388 * t633;
  t1676 = t411 * t1675;
  t1681 = t633 * t165;
  t1683 = t163 * t1681 * t405;
  t1687 = -t1131 * t1596 * t1633 - t163 * t1657 * t172 + t1037 * t625 - 0.2e1 * t1577 * t1661 + 0.3e1 * t1580 * t1604 + 0.3e1 * t1596 * t1635 + 0.2e1 * t1623 * t640 - 0.2e1 * t1629 * t630 - 0.3e1 * t1664 * t1665 + t1672 * t628 + 0.2e1 * t1676 * t623 - 0.3e1 * t1644 + 0.3e1 * t1652 - 0.3e1 * t1654 - t1670 - 0.2e1 * t1683;
  t1689 = my_piecewise5(t64, 0, t67, 0, t1632 + t1687);
  t1691 = t1568 * t77 + 0.2e1 * t161 * t648 + t1689 * t59 + 0.2e1 * t174 * t618 + t260 * t416 + t266 * t373 + t1564;
  t1696 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t268 + t1552 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t650 - t1559 + t1561 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t1691);
  tv3rho2sigma0 = t1696 * t8 + 0.2e1 * t655;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1703 = t7 * t440 * t286;
  t1707 = t7 * t444 * t286 / 0.3e2;
  t1709 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t286 + t1703 / 0.5e1 - t1707);
  tv3rho2sigma2 = t1709 * t8 + 0.2e1 * t664;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1715 = t7 * t465 * t268;
  t1723 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t268 + t1715 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t650 + t1552 / 0.1e2 - t1559 + t1561 / 0.1e2);
  tv3rho2sigma3 = t1723 * t8 + t655 + t670;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1729 = t7 * t489 * t286;
  t1736 = t7 * t192 * t712;
  t1739 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t286 + t1729 / 0.1e2 + t1703 / 0.1e2 - t1707 + 0.3e1 / 0.2e2 * t7 * t188 * t712 + t1736 / 0.1e2);
  tv3rho2sigma5 = t1739 * t8 + t664 + t717;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1747 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t268 + t1715 / 0.5e1 - t1559);
  tv3rho2sigma6 = t1747 * t8 + 0.2e1 * t670;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1759 = 0.55e2 / 0.81e2 * t38 * t544;
  t1760 = t37 * t544;
  t1763 = 0.11e2 / 0.27e2 * t47 * t1760 - t1759;
  t1771 = t281 * t1456;
  t1772 = t234 * t1771;
  t1773 = t1458 * t122;
  t1774 = t576 * t561;
  t1775 = t1773 * t1774;
  t1778 = t561 * t238;
  t1779 = t560 * t1778;
  t1780 = t686 * t584;
  t1781 = t592 * t1780;
  t1782 = t1779 * t1781;
  t1784 = t281 * t561;
  t1787 = t584 * t565 * t1431;
  t1788 = t234 * t1784 * t1787;
  t1790 = t1454 * t1771;
  t1792 = t561 * t122 * t241;
  t1793 = t1480 * t1792;
  t1795 = t561 * t1456;
  t1796 = t1454 * t1795;
  t1797 = t1510 * t908;
  t1801 = t560 * t1771;
  t1806 = t561 * t567 * t569;
  t1807 = t1480 * t1806;
  t1810 = t593 * t580;
  t1811 = t592 * t1810;
  t1813 = t1493 * t561;
  t1814 = t1492 * t1813;
  t1817 = t1462 * t281;
  t1818 = t1817 * params->csk_a;
  t1819 = t1492 * t1818;
  t1822 = t695 * t563;
  t1823 = t234 * t1822;
  t1829 = t1447 * t690 - t1447 * t704 - 0.3e1 * t1772 * t1775 - t1772 * t1793 - t1790 * t1793 - 0.3e1 * t1790 * t1807 - 0.2e1 * t1790 * t1814 + 0.3e1 * t1793 * t1801 + 0.3e1 * t1796 * t1797 + 0.3e1 * t1796 * t1819 + 0.3e1 * t1801 * t1807 - t1811 * t704 + 0.2e1 * t1823 * t692 + 0.3e1 * t1782 + 0.3e1 * t1788 - t700;
  t1830 = t560 * t1822;
  t1837 = t1784 * t584;
  t1838 = t560 * t1837;
  t1839 = t1838 * t1432;
  t1841 = t281 * t238;
  t1842 = t1841 * t565;
  t1843 = t234 * t1842;
  t1844 = params->csk_a * t561;
  t1845 = t1844 * t584;
  t1846 = t242 * t1845;
  t1847 = t1843 * t1846;
  t1849 = t1838 * t1442;
  t1851 = my_piecewise3(t115, 0, t1763);
  t1852 = my_piecewise3(t117, t1851, 0);
  t1855 = t241 * t580;
  t1856 = t575 * t1855;
  t1858 = t560 * t1795;
  t1859 = t1510 * t686;
  t1862 = t241 * t561;
  t1863 = t1773 * t1862;
  t1868 = t234 * t695 * t236 * t586;
  t1872 = t234 * t281 * t580 * t586;
  t1874 = t569 * t695;
  t1875 = t592 * t1874;
  t1882 = -t1492 * t1796 * t1817 - t1852 * t234 * t243 + t1423 * t687 - 0.2e1 * t1772 * t1863 + 0.3e1 * t1775 * t1801 + 0.2e1 * t1823 * t702 - 0.2e1 * t1830 * t692 - 0.2e1 * t1830 * t707 + t1856 * t690 - 0.3e1 * t1858 * t1859 + 0.2e1 * t1875 * t685 - 0.3e1 * t1839 + 0.3e1 * t1847 - 0.3e1 * t1849 - 0.2e1 * t1868 - t1872;
  t1884 = my_piecewise5(t114, 0, t115, 0, t1829 + t1882);
  t1886 = t113 * t1884 + t125 * t1763 + 0.2e1 * t232 * t710 + 0.2e1 * t245 * t680 + t278 * t597 + t284 * t554 + t1759;
  t1891 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t286 + t1729 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t712 - t1707 + t1736 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t1886);
  tv3rho2sigma8 = t1891 * t8 + 0.2e1 * t717;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1898 = t7 * t345 * t303;
  t1905 = t7 * t354 * t303 / 0.3e2;
  t1907 = t7 * t145 * t754;
  t1921 = t298 * t1070;
  t1922 = t379 * t1921;
  t1925 = t741 * t382;
  t1926 = t379 * t1925;
  t1929 = t163 * t1921;
  t1932 = t732 * t403;
  t1933 = t411 * t1932;
  t1934 = t1590 * t1933;
  t1936 = t298 * t380;
  t1938 = t163 * t1936 * t1586;
  t1940 = t732 * params->csk_a;
  t1941 = t1122 * t1940;
  t1947 = t1068 * t1921;
  t1955 = t1076 * t298;
  t1956 = t1955 * params->csk_a;
  t1957 = t1131 * t1956;
  t1960 = t163 * t1925;
  t1963 = -t1057 * t748 + 0.3e1 * t1580 * t1922 - 0.3e1 * t1580 * t1929 + 0.3e1 * t1596 * t1941 + 0.3e1 * t1596 * t1957 + 0.3e1 * t1602 * t1922 - t1602 * t1929 - t1602 * t1947 - 0.3e1 * t1612 * t1947 - t1616 * t748 - 0.2e1 * t1619 * t1947 - 0.2e1 * t1926 * t630 + 0.2e1 * t1960 * t630 + 0.3e1 * t1934 + 0.3e1 * t1938 - t746;
  t1970 = t379 * t1936 * t403;
  t1971 = t1970 * t1046;
  t1974 = t298 * t167 * t384;
  t1975 = t163 * t1974;
  t1976 = t1975 * t1651;
  t1978 = t1970 * t1063;
  t1982 = my_piecewise3(t67, 0, 0.5e1 / 0.27e2 * t52 * t615);
  t1983 = my_piecewise3(t69, t1982, 0);
  t1988 = t388 * t741;
  t1989 = t411 * t1988;
  t1992 = t1131 * t1955;
  t1994 = t741 * t165;
  t1996 = t163 * t1994 * t405;
  t1998 = t298 * t399;
  t2000 = t163 * t1998 * t405;
  t2003 = t1122 * t732;
  t2008 = -t163 * t172 * t1983 + t1037 * t733 + t1057 * t736 - t1596 * t1992 + 0.3e1 * t1612 * t1922 - 0.2e1 * t1661 * t1929 - 0.3e1 * t1664 * t2003 + t1672 * t736 - 0.2e1 * t1926 * t645 + 0.2e1 * t1960 * t640 + 0.2e1 * t1989 * t623 - 0.3e1 * t1971 + 0.3e1 * t1976 - 0.3e1 * t1978 - 0.2e1 * t1996 - t2000;
  t2010 = my_piecewise5(t64, 0, t67, 0, t1963 + t2008);
  t2012 = 0.5e1 / 0.27e2 * t52 * t615 * t77 - 0.5e1 / 0.36e2 * t52 * t257 * t174 + t52 * t291 * t416 / 0.24e2 + t373 * t301 + 0.2e1 * t161 * t752 + t59 * t2010;
  t2017 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t303 + t1898 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t754 - t1905 + t1907 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t2012);
  tv3rho2lapl0 = t2017 * t8 + 0.2e1 * t759;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t2024 = t7 * t440 * t320;
  t2028 = t7 * t444 * t320 / 0.3e2;
  t2030 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t320 + t2024 / 0.5e1 - t2028);
  tv3rho2lapl1 = t2030 * t8 + 0.2e1 * t768;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2036 = t7 * t465 * t303;
  t2044 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t303 + t2036 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t754 + t1898 / 0.1e2 - t1905 + t1907 / 0.1e2);
  tv3rho2lapl2 = t2044 * t8 + t759 + t774;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2050 = t7 * t489 * t320;
  t2057 = t7 * t192 * t808;
  t2060 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t320 + t2050 / 0.1e2 + t2024 / 0.1e2 - t2028 + 0.3e1 / 0.2e2 * t7 * t188 * t808 + t2057 / 0.1e2);
  tv3rho2lapl3 = t2060 * t8 + t768 + t813;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2068 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t303 + t2036 / 0.5e1 - t1905);
  tv3rho2lapl4 = t2068 * t8 + 0.2e1 * t774;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2091 = t315 * t1456;
  t2092 = t560 * t2091;
  t2095 = t795 * t563;
  t2096 = t560 * t2095;
  t2099 = t234 * t2091;
  t2102 = t786 * t584;
  t2103 = t592 * t2102;
  t2104 = t1779 * t2103;
  t2106 = t315 * t561;
  t2108 = t234 * t2106 * t1787;
  t2110 = t786 * params->csk_a;
  t2111 = t1510 * t2110;
  t2117 = t1454 * t2091;
  t2119 = t1462 * t315;
  t2120 = t2119 * params->csk_a;
  t2121 = t1492 * t2120;
  t2124 = t234 * t2095;
  t2133 = t1447 * t790 - t1447 * t802 + 0.3e1 * t1775 * t2092 - 0.3e1 * t1775 * t2099 + 0.3e1 * t1793 * t2092 - t1793 * t2099 - t1793 * t2117 + 0.3e1 * t1796 * t2111 + 0.3e1 * t1796 * t2121 + 0.3e1 * t1807 * t2092 - 0.2e1 * t2096 * t692 - 0.2e1 * t2096 * t707 + 0.2e1 * t2124 * t692 + 0.3e1 * t2104 + 0.3e1 * t2108 - t800;
  t2140 = t560 * t2106 * t584;
  t2141 = t2140 * t1432;
  t2144 = t315 * t238 * t565;
  t2145 = t234 * t2144;
  t2146 = t2145 * t1846;
  t2148 = t2140 * t1442;
  t2152 = my_piecewise3(t115, 0, 0.5e1 / 0.27e2 * t52 * t677);
  t2153 = my_piecewise3(t117, t2152, 0);
  t2156 = t795 * t236;
  t2158 = t234 * t2156 * t586;
  t2160 = t315 * t580;
  t2162 = t234 * t2160 * t586;
  t2165 = t569 * t795;
  t2166 = t592 * t2165;
  t2169 = t1492 * t2119;
  t2171 = t1510 * t786;
  t2178 = -t2153 * t234 * t243 + t1423 * t787 - t1796 * t2169 - 0.3e1 * t1807 * t2117 - t1811 * t802 - 0.2e1 * t1814 * t2117 + t1856 * t790 - 0.3e1 * t1858 * t2171 - 0.2e1 * t1863 * t2099 + 0.2e1 * t2124 * t702 + 0.2e1 * t2166 * t685 - 0.3e1 * t2141 + 0.3e1 * t2146 - 0.3e1 * t2148 - 0.2e1 * t2158 - t2162;
  t2180 = my_piecewise5(t114, 0, t115, 0, t2133 + t2178);
  t2182 = 0.5e1 / 0.27e2 * t52 * t677 * t125 - 0.5e1 / 0.36e2 * t52 * t275 * t245 + t52 * t308 * t597 / 0.24e2 + t554 * t318 + 0.2e1 * t232 * t806 + t113 * t2180;
  t2187 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t320 + t2050 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t808 - t2028 + t2057 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * t2182);
  tv3rho2lapl5 = t2187 * t8 + 0.2e1 * t813;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2194 = t7 * t145 * t836 / 0.1e2;
  t2200 = t817 * t1070;
  t2201 = t1068 * t2200;
  t2202 = t1122 * t644;
  t2205 = t163 * t2200;
  t2207 = t1578 * t1600 * t165;
  t2209 = t379 * t2200;
  t2214 = t165 * t74 * t170;
  t2215 = t1094 * t2214;
  t2218 = t824 * t382;
  t2219 = t163 * t2218;
  t2220 = t2219 * t630;
  t2221 = t379 * t2218;
  t2222 = t2221 * t630;
  t2225 = t1136 * t165;
  t2226 = t1122 * t2225;
  t2229 = t2221 * t645;
  t2230 = t817 * t403;
  t2231 = t163 * t2230;
  t2233 = t394 * t639 * t167;
  t2234 = t2231 * t2233;
  t2236 = t171 * t633;
  t2237 = t1043 * t2236;
  t2242 = t412 * t633;
  t2243 = t411 * t2242;
  t2246 = t817 * t167;
  t2247 = t379 * t2246;
  t2248 = t388 * t165;
  t2249 = t2248 * t403;
  t2250 = t411 * t2249;
  t2251 = t2247 * t2250;
  t2253 = t1132 * t165;
  t2254 = t1131 * t2253;
  t2257 = 0.3e1 * t2201 * t2202 - t2201 * t2207 - 0.3e1 * t2201 * t2226 + 0.3e1 * t2201 * t2254 - t2205 * t2207 - 0.3e1 * t2205 * t2215 + 0.3e1 * t2207 * t2209 + 0.3e1 * t2209 * t2215 + 0.3e1 * t2209 * t2226 - 0.2e1 * t2237 * t642 - 0.2e1 * t2243 * t642 + t2220 - t2222 - t2229 + 0.3e1 * t2234 + 0.3e1 * t2251;
  t2260 = t1146 * t165;
  t2261 = t1131 * t2260;
  t2265 = t379 * t2230 * t384;
  t2266 = params->csk_a * t165;
  t2267 = t2266 * t1045;
  t2268 = t2265 * t2267;
  t2271 = t163 * t2246 * t384;
  t2272 = t2266 * t403;
  t2273 = t171 * t2272;
  t2274 = t2271 * t2273;
  t2276 = t2266 * t167;
  t2277 = t389 * t2276;
  t2278 = t2265 * t2277;
  t2280 = t388 * t824;
  t2281 = t411 * t2280;
  t2282 = t623 * t2281;
  t2283 = t824 * t165;
  t2285 = t163 * t2283 * t405;
  t2286 = t263 * t403;
  t2287 = t163 * t2286;
  t2288 = t168 * t74;
  t2289 = t170 * t633;
  t2291 = t2287 * t2288 * t2289;
  t2292 = 0.2e1 * t2291;
  t2293 = t394 * t2289;
  t2298 = t165 * t1070;
  t2299 = t1068 * t2298;
  t2300 = t1076 * t817;
  t2301 = t1131 * t2300;
  t2303 = t2219 * t640;
  t2304 = t1578 * t639;
  t2307 = t1122 * t2248;
  t2310 = 0.2e1 * t1676 * t642 - 0.2e1 * t2201 * t2261 - 0.2e1 * t2205 * t2304 - 0.3e1 * t2209 * t2307 + 0.2e1 * t2237 * t628 + 0.2e1 * t2293 * t628 - t2299 * t2301 - 0.3e1 * t2268 + 0.3e1 * t2274 - 0.3e1 * t2278 + t2282 - t2285 - t2292 + t2303 - t826 - t828;
  t2312 = my_piecewise5(t64, 0, t67, 0, t2257 + t2310);
  t2314 = t161 * t834 + t2312 * t59 + 0.2e1 * t260 * t648 + 0.2e1 * t266 * t618;
  t2319 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t836 + t2194 + 0.3e1 / 0.2e2 * t7 * t32 * t2314);
  tv3rhosigma20 = t2319 * t8 + t840;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2326 = t7 * t192 * t862 / 0.1e2;
  t2328 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t862 + t2326);
  tv3rhosigma25 = t2328 * t8 + t866;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2334 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t836 + t2194);
  tv3rhosigma26 = t2334 * t8 + t840;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2344 = t843 * t1456;
  t2345 = t1454 * t2344;
  t2346 = t1521 * t236;
  t2347 = t1492 * t2346;
  t2350 = t576 * t695;
  t2351 = t575 * t2350;
  t2354 = t560 * t2344;
  t2355 = t1525 * t236;
  t2356 = t1510 * t2355;
  t2359 = t850 * t563;
  t2360 = t560 * t2359;
  t2361 = t2360 * t707;
  t2362 = t843 * t584;
  t2363 = t234 * t2362;
  t2365 = t575 * t701 * t238;
  t2366 = t2363 * t2365;
  t2370 = t843 * t238;
  t2371 = t560 * t2370;
  t2372 = t569 * t236;
  t2373 = t2372 * t584;
  t2374 = t592 * t2373;
  t2375 = t2371 * t2374;
  t2377 = t1510 * t706;
  t2380 = t234 * t2344;
  t2381 = t241 * t1115;
  t2383 = t1773 * t2381 * t236;
  t2388 = t234 * t2359;
  t2389 = t2388 * t692;
  t2390 = t2360 * t692;
  t2392 = t236 * t122 * t241;
  t2393 = t1484 * t2392;
  t2400 = 0.3e1 * t2345 * t2347 - 0.3e1 * t2345 * t2356 + 0.3e1 * t2345 * t2377 - t2345 * t2383 + 0.2e1 * t2351 * t690 - 0.2e1 * t2351 * t704 + 0.3e1 * t2354 * t2356 + 0.3e1 * t2354 * t2383 + 0.3e1 * t2354 * t2393 - t2380 * t2383 - 0.3e1 * t2380 * t2393 - t2361 + 0.3e1 * t2366 + 0.3e1 * t2375 + t2389 - t2390;
  t2401 = t593 * t695;
  t2402 = t592 * t2401;
  t2405 = t1493 * t236;
  t2406 = t1492 * t2405;
  t2410 = t560 * t2362 * t565;
  t2411 = params->csk_a * t236;
  t2412 = t2411 * t1431;
  t2413 = t2410 * t2412;
  t2416 = t234 * t2370 * t565;
  t2417 = t2411 * t584;
  t2418 = t242 * t2417;
  t2419 = t2416 * t2418;
  t2421 = t2411 * t238;
  t2422 = t570 * t2421;
  t2423 = t2410 * t2422;
  t2425 = t2388 * t702;
  t2426 = t1773 * t701;
  t2429 = t1510 * t2372;
  t2434 = t234 * t850 * t236 * t586;
  t2435 = t281 * t584;
  t2436 = t234 * t2435;
  t2437 = t239 * t122;
  t2438 = t241 * t695;
  t2440 = t2436 * t2437 * t2438;
  t2441 = 0.2e1 * t2440;
  t2442 = t575 * t2438;
  t2447 = t236 * t1456;
  t2448 = t1454 * t2447;
  t2449 = t1462 * t843;
  t2450 = t1492 * t2449;
  t2452 = t569 * t850;
  t2453 = t592 * t2452;
  t2454 = t685 * t2453;
  t2455 = 0.2e1 * t1875 * t704 - 0.2e1 * t2345 * t2406 - 0.3e1 * t2354 * t2429 - 0.2e1 * t2380 * t2426 - 0.2e1 * t2402 * t704 + 0.2e1 * t2442 * t690 - t2448 * t2450 - 0.3e1 * t2413 + 0.3e1 * t2419 - 0.3e1 * t2423 + t2425 - t2434 - t2441 + t2454 - t852 - t854;
  t2457 = my_piecewise5(t114, 0, t115, 0, t2400 + t2455);
  t2459 = t113 * t2457 + t232 * t860 + 0.2e1 * t278 * t710 + 0.2e1 * t284 * t680;
  t2464 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t862 + t2326 + 0.3e1 / 0.2e2 * t7 * t94 * t2459);
  tv3rhosigma211 = t2464 * t8 + t866;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2471 = t7 * t145 * t888 / 0.1e2;
  t2481 = t1633 * t298;
  t2482 = t1131 * t2481;
  t2486 = t878 * t165;
  t2487 = t1578 * t2486;
  t2490 = t732 * t165;
  t2491 = t1122 * t2490;
  t2498 = t1921 * t1072;
  t2499 = t1068 * t2498;
  t2500 = t1115 * t263;
  t2501 = t389 * t165;
  t2502 = t2500 * t2501;
  t2505 = t2500 * t165;
  t2506 = t1077 * t2505;
  t2509 = t379 * t1647;
  t2511 = t389 * t744 * t403;
  t2512 = t2509 * t2511;
  t2514 = t1576 * t1072;
  t2515 = t1068 * t2514;
  t2516 = t298 * params->csk_a;
  t2517 = t2516 * t165;
  t2518 = t1077 * t2517;
  t2521 = t379 * t2498;
  t2524 = t389 * t2517;
  t2527 = t163 * t2498;
  t2528 = t171 * t2505;
  t2530 = -0.3e1 * t1604 * t2491 - t1926 * t873 - t1926 * t883 - 0.2e1 * t1929 * t2487 + t1960 * t873 + t2237 * t736 - t2237 * t748 - t2243 * t748 - t2299 * t2482 - 0.3e1 * t2499 * t2502 - 0.2e1 * t2499 * t2506 + 0.3e1 * t2502 * t2521 + 0.3e1 * t2515 * t2518 + 0.3e1 * t2515 * t2524 - t2527 * t2528 + t2220 - t2222 - t2229 + 0.3e1 * t2512;
  t2534 = t171 * t263;
  t2535 = t2266 * t2534;
  t2540 = t875 * t403;
  t2541 = t163 * t2540;
  t2542 = t2541 * t2233;
  t2544 = t379 * t2540;
  t2546 = t1043 * t165 * t1045;
  t2547 = t2544 * t2546;
  t2549 = t171 * params->csk_a;
  t2550 = t636 * t403;
  t2551 = t2549 * t2550;
  t2552 = t1975 * t2551;
  t2554 = t411 * t388;
  t2555 = t2554 * t2276;
  t2556 = t2544 * t2555;
  t2558 = t741 * t263;
  t2560 = t163 * t2558 * t405;
  t2561 = t298 * t633;
  t2563 = t163 * t2561 * t405;
  t2568 = t1629 * t733 + t1960 * t879 + t1989 * t642 + t2293 * t736 - t2499 * t2528 + 0.3e1 * t2521 * t2528 + 0.3e1 * t2521 * t2535 - 0.3e1 * t2527 * t2535 + t2282 - t2285 + t2303 + 0.3e1 * t2542 - 0.3e1 * t2547 + 0.3e1 * t2552 - 0.3e1 * t2556 - t2560 - t2563 - t826 - t877;
  t2570 = my_piecewise5(t64, 0, t67, 0, t2530 + t2568);
  t2572 = -0.5e1 / 0.72e2 * t52 * t257 * t266 + t52 * t291 * t648 / 0.24e2 + t618 * t301 + t260 * t752 + t161 * t886 + t59 * t2570;
  t2577 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t888 + t2471 + 0.3e1 / 0.2e2 * t7 * t32 * t2572);
  tv3rhosigmalapl0 = t2577 * t8 + t892;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2584 = t7 * t192 * t914 / 0.1e2;
  t2586 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t914 + t2584);
  tv3rhosigmalapl5 = t2586 * t8 + t918;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2592 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t888 + t2471);
  tv3rhosigmalapl6 = t2592 * t8 + t892;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2612 = t1817 * t315;
  t2613 = t1492 * t2612;
  t2615 = t904 * t236;
  t2616 = t1773 * t2615;
  t2619 = t2091 * t1458;
  t2620 = t1454 * t2619;
  t2621 = t1115 * t281;
  t2622 = t570 * t236;
  t2623 = t2621 * t2622;
  t2626 = t560 * t1842;
  t2628 = t570 * t798 * t584;
  t2629 = t2626 * t2628;
  t2631 = t1771 * t1458;
  t2632 = t1454 * t2631;
  t2633 = t315 * params->csk_a;
  t2634 = t2633 * t236;
  t2635 = t1463 * t2634;
  t2638 = t570 * t2634;
  t2641 = t234 * t2619;
  t2642 = t2621 * t236;
  t2643 = t242 * t2642;
  t2645 = t560 * t2619;
  t2649 = t242 * t281;
  t2650 = t2411 * t2649;
  t2653 = -t2096 * t899 - t2096 * t909 - 0.2e1 * t2099 * t2616 + t2124 * t899 + t2351 * t790 - t2351 * t802 - t2402 * t802 - t2448 * t2613 - 0.3e1 * t2620 * t2623 - t2620 * t2643 + 0.3e1 * t2632 * t2635 + 0.3e1 * t2632 * t2638 - t2641 * t2643 + 0.3e1 * t2643 * t2645 + 0.3e1 * t2645 * t2650 - t2361 + t2389 - t2390 + 0.3e1 * t2629;
  t2656 = t1463 * t2642;
  t2661 = t901 * t584;
  t2662 = t234 * t2661;
  t2663 = t2662 * t2365;
  t2665 = t560 * t2661;
  t2667 = t1429 * t236 * t1431;
  t2668 = t2665 * t2667;
  t2670 = t242 * params->csk_a;
  t2671 = t698 * t584;
  t2672 = t2670 * t2671;
  t2673 = t2145 * t2672;
  t2675 = t592 * t569;
  t2676 = t2675 * t2421;
  t2677 = t2665 * t2676;
  t2679 = t786 * t236;
  t2680 = t1510 * t2679;
  t2683 = t795 * t281;
  t2685 = t234 * t2683 * t586;
  t2686 = t315 * t695;
  t2688 = t234 * t2686 * t586;
  t2693 = -0.3e1 * t1801 * t2680 + t1830 * t787 + t2124 * t905 + t2166 * t704 + t2442 * t790 - 0.2e1 * t2620 * t2656 + 0.3e1 * t2623 * t2645 - 0.3e1 * t2641 * t2650 + t2425 - t2434 + t2454 + 0.3e1 * t2663 - 0.3e1 * t2668 + 0.3e1 * t2673 - 0.3e1 * t2677 - t2685 - t2688 - t852 - t903;
  t2695 = my_piecewise5(t114, 0, t115, 0, t2653 + t2693);
  t2697 = -0.5e1 / 0.72e2 * t52 * t275 * t284 + t52 * t308 * t710 / 0.24e2 + t680 * t318 + t278 * t806 + t232 * t912 + t113 * t2695;
  t2702 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t914 + t2584 + 0.3e1 / 0.2e2 * t7 * t94 * t2697);
  tv3rhosigmalapl11 = t2702 * t8 + t918;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2709 = t7 * t145 * t937 / 0.1e2;
  t2717 = t922 * t167;
  t2719 = t163 * t2717 * t384;
  t2720 = t2719 * t2273;
  t2722 = t922 * t403;
  t2724 = t379 * t2722 * t384;
  t2725 = t2724 * t2277;
  t2727 = t2724 * t2267;
  t2729 = t922 * t1070;
  t2730 = t1068 * t2729;
  t2733 = t163 * t2729;
  t2735 = t379 * t2729;
  t2743 = t412 * t741;
  t2749 = -0.2e1 * t2743 * t411 * t748 + 0.3e1 * t2202 * t2730 - t2207 * t2730 - t2207 * t2733 + 0.3e1 * t2207 * t2735 - 0.3e1 * t2215 * t2733 + 0.3e1 * t2215 * t2735 - 0.2e1 * t2261 * t2730 + t2220 - t2222 - t2229 + 0.3e1 * t2720 - 0.3e1 * t2725 - 0.3e1 * t2727 - t826 - t929;
  t2753 = t394 * t395 * t741;
  t2758 = t163 * t2722;
  t2759 = t2758 * t2233;
  t2765 = t379 * t2717;
  t2766 = t2765 * t2250;
  t2774 = t1076 * t922;
  t2775 = t1131 * t2774;
  t2777 = t298 * t403;
  t2778 = t163 * t2777;
  t2779 = t170 * t741;
  t2781 = t2778 * t2288 * t2779;
  t2782 = 0.2e1 * t2781;
  t2786 = 0.2e1 * t2779 * t394 * t736 + 0.2e1 * t1989 * t748 - 0.3e1 * t2226 * t2730 + 0.3e1 * t2226 * t2735 + 0.3e1 * t2254 * t2730 - t2299 * t2775 - 0.2e1 * t2304 * t2733 - 0.3e1 * t2307 * t2735 + 0.2e1 * t2753 * t736 - 0.2e1 * t2753 * t748 + t2282 - t2285 + t2303 + 0.3e1 * t2759 + 0.3e1 * t2766 - t2782;
  t2788 = my_piecewise5(t64, 0, t67, 0, t2749 + t2786);
  t2790 = -0.5e1 / 0.36e2 * t52 * t257 * t301 + t52 * t291 * t752 / 0.12e2 + t161 * t935 + t59 * t2788;
  t2795 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t937 + t2709 + 0.3e1 / 0.2e2 * t7 * t32 * t2790);
  tv3rholapl20 = t2795 * t8 + t941;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2802 = t7 * t192 * t960 / 0.1e2;
  t2804 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t960 + t2802);
  tv3rholapl22 = t2804 * t8 + t964;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2810 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t937 + t2709);
  tv3rholapl23 = t2810 * t8 + t941;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2822 = t945 * t584;
  t2824 = t560 * t2822 * t565;
  t2825 = t2824 * t2412;
  t2827 = t945 * t238;
  t2829 = t234 * t2827 * t565;
  t2830 = t2829 * t2418;
  t2832 = t2824 * t2422;
  t2834 = t945 * t1456;
  t2835 = t1454 * t2834;
  t2839 = t575 * t576 * t795;
  t2845 = t234 * t2834;
  t2847 = t560 * t2834;
  t2856 = 0.3e1 * t2347 * t2835 + 0.3e1 * t2377 * t2835 - t2383 * t2835 - t2383 * t2845 + 0.3e1 * t2383 * t2847 - 0.3e1 * t2393 * t2845 + 0.3e1 * t2393 * t2847 - 0.2e1 * t2406 * t2835 + 0.2e1 * t2839 * t790 - t2361 + t2389 - t2390 - 0.3e1 * t2825 + 0.3e1 * t2830 - 0.3e1 * t2832 - t952;
  t2859 = t234 * t2822;
  t2860 = t2859 * t2365;
  t2866 = t593 * t795;
  t2870 = t560 * t2827;
  t2871 = t2870 * t2374;
  t2877 = t1462 * t945;
  t2878 = t1492 * t2877;
  t2880 = t315 * t584;
  t2881 = t234 * t2880;
  t2882 = t241 * t795;
  t2884 = t2881 * t2437 * t2882;
  t2885 = 0.2e1 * t2884;
  t2891 = -0.2e1 * t2866 * t592 * t802 + 0.2e1 * t2882 * t575 * t790 + 0.2e1 * t2166 * t802 - 0.3e1 * t2356 * t2835 + 0.3e1 * t2356 * t2847 - 0.2e1 * t2426 * t2845 - 0.3e1 * t2429 * t2847 - t2448 * t2878 - 0.2e1 * t2839 * t802 + t2425 - t2434 + t2454 + 0.3e1 * t2860 + 0.3e1 * t2871 - t2885 - t852;
  t2893 = my_piecewise5(t114, 0, t115, 0, t2856 + t2891);
  t2895 = -0.5e1 / 0.36e2 * t52 * t275 * t318 + t52 * t308 * t806 / 0.12e2 + t232 * t958 + t113 * t2893;
  t2900 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t960 + t2802 + 0.3e1 / 0.2e2 * t7 * t94 * t2895);
  tv3rholapl25 = t2900 * t8 + t964;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2904 = t817 * t263;
  t2913 = t395 * t824;
  t2914 = t394 * t2913;
  t2915 = t628 * t2914;
  t2916 = 0.3e1 * t2915;
  t2917 = t2221 * t883;
  t2918 = 0.3e1 * t2917;
  t2919 = t2904 * t403;
  t2920 = t379 * t2919;
  t2921 = t2920 * t1063;
  t2922 = 0.3e1 * t2921;
  t2923 = t2221 * t873;
  t2924 = 0.3e1 * t2923;
  t2925 = t2920 * t1046;
  t2926 = 0.3e1 * t2925;
  t2927 = t2904 * t167;
  t2929 = t163 * t2927 * t1052;
  t2930 = 0.3e1 * t2929;
  t2931 = t2904 * t1070;
  t2932 = t1068 * t2931;
  t2937 = -t1068 * t1078 * t2904 - 0.3e1 * t1085 * t2904 * t379 - 0.2e1 * t1089 * t163 * t2904 - 0.3e1 * t1137 * t2932 - 0.2e1 * t1147 * t2932 + t2916 - t2918 - t2922 - t2924 - t2926 + t2930 - t826 - t828;
  t2938 = t642 * t2281;
  t2939 = 0.3e1 * t2938;
  t2942 = t379 * t2931;
  t2945 = t824 * t263;
  t2947 = t163 * t2945 * t405;
  t2948 = 0.3e1 * t2947;
  t2950 = t379 * t2927 * t1104;
  t2951 = 0.3e1 * t2950;
  t2952 = t2219 * t879;
  t2953 = 0.3e1 * t2952;
  t2954 = t163 * t2919;
  t2955 = t2954 * t1112;
  t2956 = 0.3e1 * t2955;
  t2959 = t163 * t2931;
  t2968 = 0.3e1 * t1095 * t2942 - 0.3e1 * t1095 * t2959 - t1117 * t2932 + 0.3e1 * t1117 * t2942 - t1117 * t2959 + 0.3e1 * t1123 * t2932 + 0.3e1 * t1133 * t2932 + 0.3e1 * t1137 * t2942 + t2939 - t2948 + t2951 + t2953 + t2956;
  t2970 = my_piecewise5(t64, 0, t67, 0, t2937 + t2968);
  t2972 = 0.3e1 * t260 * t834 + t2970 * t59;
  t2976 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t2972);
  tv3sigma30 = t8 * t2976;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2979 = t843 * t281;
  t2988 = t2360 * t899;
  t2989 = 0.3e1 * t2988;
  t2990 = t2979 * t584;
  t2991 = t560 * t2990;
  t2992 = t2991 * t1432;
  t2993 = 0.3e1 * t2992;
  t2994 = t576 * t850;
  t2995 = t575 * t2994;
  t2996 = t690 * t2995;
  t2997 = 0.3e1 * t2996;
  t2998 = t2360 * t909;
  t2999 = 0.3e1 * t2998;
  t3000 = t2991 * t1442;
  t3001 = 0.3e1 * t3000;
  t3002 = t2979 * t238;
  t3004 = t234 * t3002 * t1438;
  t3005 = 0.3e1 * t3004;
  t3006 = t2979 * t1456;
  t3007 = t234 * t3006;
  t3010 = t1454 * t3006;
  t3013 = -t1454 * t1464 * t2979 - 0.2e1 * t1471 * t234 * t2979 - 0.3e1 * t1475 * t2979 * t560 - 0.3e1 * t1485 * t3007 - 0.2e1 * t1494 * t3010 - t2989 - t2993 + t2997 - t2999 - t3001 + t3005 - t852 - t854;
  t3014 = t560 * t3006;
  t3017 = t850 * t281;
  t3019 = t234 * t3017 * t586;
  t3020 = 0.3e1 * t3019;
  t3023 = t704 * t2453;
  t3024 = 0.3e1 * t3023;
  t3028 = t560 * t3002 * t1499;
  t3029 = 0.3e1 * t3028;
  t3030 = t2388 * t905;
  t3031 = 0.3e1 * t3030;
  t3032 = t234 * t2990;
  t3033 = t3032 * t1507;
  t3034 = 0.3e1 * t3033;
  t3043 = -t1481 * t3007 - t1481 * t3010 + 0.3e1 * t1481 * t3014 + 0.3e1 * t1485 * t3014 + 0.3e1 * t1511 * t3010 + 0.3e1 * t1522 * t3010 - 0.3e1 * t1526 * t3010 + 0.3e1 * t1526 * t3014 - t3020 + t3024 + t3029 + t3031 + t3034;
  t3045 = my_piecewise5(t114, 0, t115, 0, t3013 + t3043);
  t3047 = t113 * t3045 + 0.3e1 * t278 * t860;
  t3051 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3047);
  tv3sigma39 = t8 * t3051;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3057 = t298 * t817;
  t3058 = t3057 * t403;
  t3059 = t379 * t3058;
  t3060 = t3059 * t1046;
  t3061 = 0.3e1 * t3060;
  t3062 = params->csk_a * t817;
  t3063 = t3062 * t403;
  t3064 = t171 * t3063;
  t3065 = t1975 * t3064;
  t3066 = 0.3e1 * t3065;
  t3067 = t3059 * t1063;
  t3068 = 0.3e1 * t3067;
  t3069 = t736 * t2914;
  t3070 = t1136 * t817;
  t3071 = t1122 * t3070;
  t3075 = t817 * t74 * t170;
  t3076 = t1094 * t3075;
  t3084 = t1578 * t1600 * t817;
  t3089 = t2247 * t1933;
  t3090 = 0.3e1 * t3089;
  t3091 = t163 * t3057;
  t3092 = t3091 * t1586;
  t3093 = 0.3e1 * t3092;
  t3094 = t748 * t2914;
  t3097 = t412 * t824;
  t3098 = t411 * t3097;
  t3099 = t748 * t3098;
  t3100 = 0.3e1 * t1922 * t3071 + 0.3e1 * t1922 * t3076 + 0.3e1 * t1922 * t3084 - 0.3e1 * t1929 * t3076 - t1929 * t3084 + 0.3e1 * t1941 * t2201 - 0.3e1 * t1947 * t3071 - t1947 * t3084 - t3061 + t3066 - t3068 + t3069 + t3090 + t3093 - t3094 - t3099;
  t3101 = t1146 * t817;
  t3102 = t1131 * t3101;
  t3107 = 0.2e1 * t2915;
  t3108 = 0.2e1 * t2917;
  t3109 = 0.2e1 * t2923;
  t3110 = 0.2e1 * t2938;
  t3111 = 0.2e1 * t2947;
  t3112 = 0.2e1 * t2952;
  t3115 = t170 * t817;
  t3116 = t1578 * t3115;
  t3119 = t2221 * t733;
  t3121 = t298 * t824;
  t3123 = t163 * t3121 * t405;
  t3124 = t170 * t824;
  t3125 = t394 * t3124;
  t3126 = t736 * t3125;
  t3127 = -0.2e1 * t1929 * t3116 - 0.2e1 * t1947 * t3102 + 0.3e1 * t1957 * t2201 - t1992 * t2201 - 0.3e1 * t2003 * t2209 + t3107 - t3108 - t3109 + t3110 - t3111 + t3112 + t3119 - t3123 + t3126 - t826 - t877;
  t3129 = my_piecewise5(t64, 0, t67, 0, t3100 + t3127);
  t3131 = t52 * t291 * t834 / 0.24e2 + 0.2e1 * t260 * t886 + t59 * t3129;
  t3135 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3131);
  tv3sigma2lapl0 = t8 * t3135;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3141 = t315 * t843;
  t3142 = t3141 * t584;
  t3143 = t560 * t3142;
  t3144 = t3143 * t1442;
  t3145 = 0.3e1 * t3144;
  t3146 = t3143 * t1432;
  t3147 = 0.3e1 * t3146;
  t3148 = params->csk_a * t843;
  t3149 = t3148 * t584;
  t3150 = t242 * t3149;
  t3151 = t2145 * t3150;
  t3152 = 0.3e1 * t3151;
  t3154 = t1773 * t2381 * t843;
  t3158 = t802 * t2995;
  t3160 = t843 * t567 * t569;
  t3161 = t1480 * t3160;
  t3164 = t593 * t850;
  t3165 = t592 * t3164;
  t3166 = t802 * t3165;
  t3167 = t1493 * t843;
  t3168 = t1492 * t3167;
  t3173 = t790 * t2995;
  t3177 = t843 * t122 * t241;
  t3178 = t1484 * t3177;
  t3186 = 0.3e1 * t2092 * t3154 + 0.3e1 * t2092 * t3161 + 0.3e1 * t2092 * t3178 - t2099 * t3154 - 0.3e1 * t2099 * t3178 + 0.3e1 * t2111 * t2345 - t2117 * t3154 - 0.3e1 * t2117 * t3161 - 0.2e1 * t2117 * t3168 + 0.3e1 * t2121 * t2345 - t3145 - t3147 + t3152 - t3158 - t3166 + t3173;
  t3187 = t2371 * t2103;
  t3188 = 0.3e1 * t3187;
  t3189 = t234 * t3141;
  t3190 = t3189 * t1787;
  t3191 = 0.3e1 * t3190;
  t3192 = 0.2e1 * t2988;
  t3193 = 0.2e1 * t2996;
  t3194 = 0.2e1 * t2998;
  t3195 = 0.2e1 * t3019;
  t3196 = 0.2e1 * t3023;
  t3197 = 0.2e1 * t3030;
  t3200 = t241 * t843;
  t3201 = t1773 * t3200;
  t3204 = t2360 * t787;
  t3206 = t315 * t850;
  t3208 = t234 * t3206 * t586;
  t3209 = t241 * t850;
  t3210 = t575 * t3209;
  t3211 = t790 * t3210;
  t3212 = -0.2e1 * t2099 * t3201 - t2169 * t2345 - 0.3e1 * t2171 * t2354 + t3188 + t3191 - t3192 + t3193 - t3194 - t3195 + t3196 + t3197 + t3204 - t3208 + t3211 - t852 - t903;
  t3214 = my_piecewise5(t114, 0, t115, 0, t3186 + t3212);
  t3216 = t52 * t308 * t860 / 0.24e2 + 0.2e1 * t278 * t912 + t113 * t3214;
  t3220 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3216);
  tv3sigma2lapl11 = t8 * t3220;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3225 = params->csk_a * t263;
  t3227 = t2724 * t3225 * t1045;
  t3228 = 0.3e1 * t3227;
  t3232 = t1578 * t1600 * t263;
  t3237 = t1094 * t2534;
  t3240 = t389 * t263;
  t3241 = t1116 * t3240;
  t3244 = t1146 * t263;
  t3248 = t2765 * t1592;
  t3249 = 0.3e1 * t3248;
  t3256 = t2758 * t394 * t878 * t167;
  t3257 = 0.3e1 * t3256;
  t3260 = 0.2e1 * t3069;
  t3261 = 0.2e1 * t3094;
  t3262 = 0.2e1 * t3099;
  t3263 = -0.2e1 * t1131 * t2730 * t3244 + 0.3e1 * t1597 * t2730 + 0.3e1 * t1635 * t2730 - t2730 * t3232 - 0.3e1 * t2730 * t3241 - t2733 * t3232 - 0.3e1 * t2733 * t3237 + 0.3e1 * t2735 * t3232 + 0.3e1 * t2735 * t3237 + 0.3e1 * t2735 * t3241 - t3228 + t3249 + t3257 + t3260 - t3261 - t3262;
  t3264 = t3225 * t403;
  t3266 = t2719 * t171 * t3264;
  t3267 = 0.3e1 * t3266;
  t3268 = t3225 * t167;
  t3270 = t2724 * t389 * t3268;
  t3271 = 0.3e1 * t3270;
  t3272 = 0.2e1 * t3119;
  t3273 = 0.2e1 * t3123;
  t3274 = 0.2e1 * t3126;
  t3281 = -0.2e1 * t1578 * t2733 * t878 - t1607 * t2775 - 0.3e1 * t1665 * t2735 + t2915 - t2917 - t2923 + t2938 - t2947 + t2952 + t3267 - t3271 + t3272 - t3273 + t3274 - t826 - t929;
  t3283 = my_piecewise5(t64, 0, t67, 0, t3263 + t3281);
  t3285 = t52 * t291 * t886 / 0.12e2 + t260 * t935 + t59 * t3283;
  t3289 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3285);
  tv3sigmalapl20 = t8 * t3289;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3294 = params->csk_a * t281;
  t3296 = t2824 * t3294 * t1431;
  t3297 = 0.3e1 * t3296;
  t3298 = t3294 * t584;
  t3299 = t242 * t3298;
  t3300 = t2829 * t3299;
  t3301 = 0.3e1 * t3300;
  t3302 = t3294 * t238;
  t3304 = t2824 * t570 * t3302;
  t3305 = 0.3e1 * t3304;
  t3308 = t2859 * t575 * t904 * t238;
  t3309 = 0.3e1 * t3308;
  t3310 = t1773 * t898;
  t3315 = t2381 * t281;
  t3316 = t1773 * t3315;
  t3323 = t570 * t281;
  t3324 = t1480 * t3323;
  t3327 = t1493 * t281;
  t3331 = t2870 * t1781;
  t3332 = 0.3e1 * t3331;
  t3337 = -0.2e1 * t1492 * t2835 * t3327 + 0.3e1 * t1797 * t2835 + 0.3e1 * t1819 * t2835 - t2835 * t3316 - 0.3e1 * t2835 * t3324 - 0.3e1 * t2845 * t3310 - t2845 * t3316 + 0.3e1 * t2847 * t3310 + 0.3e1 * t2847 * t3316 + 0.3e1 * t2847 * t3324 - t3297 + t3301 - t3305 + t3309 + t3332 - t952;
  t3338 = 0.2e1 * t3158;
  t3339 = 0.2e1 * t3166;
  t3340 = 0.2e1 * t3173;
  t3341 = 0.2e1 * t3204;
  t3342 = 0.2e1 * t3208;
  t3343 = 0.2e1 * t3211;
  t3350 = -0.2e1 * t1773 * t2845 * t904 - t1790 * t2878 - 0.3e1 * t1859 * t2847 - t2988 + t2996 - t2998 - t3019 + t3023 + t3030 - t3338 - t3339 + t3340 + t3341 - t3342 + t3343 - t852;
  t3352 = my_piecewise5(t114, 0, t115, 0, t3337 + t3350);
  t3354 = t52 * t308 * t912 / 0.12e2 + t278 * t958 + t113 * t3352;
  t3358 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3354);
  tv3sigmalapl28 = t8 * t3358;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3362 = t922 * t298;
  t3371 = t3362 * t403;
  t3372 = t379 * t3371;
  t3373 = t3372 * t1063;
  t3374 = 0.3e1 * t3373;
  t3375 = t3362 * t167;
  t3377 = t163 * t3375 * t1052;
  t3378 = 0.3e1 * t3377;
  t3379 = t3372 * t1046;
  t3380 = 0.3e1 * t3379;
  t3381 = 0.3e1 * t3069;
  t3382 = 0.3e1 * t3094;
  t3383 = 0.3e1 * t3099;
  t3384 = 0.3e1 * t3119;
  t3385 = 0.3e1 * t3123;
  t3386 = -t1068 * t1078 * t3362 - 0.3e1 * t1085 * t3362 * t379 - 0.2e1 * t1089 * t163 * t3362 - t3374 + t3378 - t3380 + t3381 - t3382 - t3383 + t3384 - t3385 - t826 - t929;
  t3387 = 0.3e1 * t3126;
  t3389 = t379 * t3375 * t1104;
  t3390 = 0.3e1 * t3389;
  t3392 = t163 * t3371 * t1112;
  t3393 = 0.3e1 * t3392;
  t3394 = t3362 * t1070;
  t3395 = t163 * t3394;
  t3398 = t1068 * t3394;
  t3401 = t379 * t3394;
  t3416 = -0.3e1 * t1095 * t3395 + 0.3e1 * t1095 * t3401 - t1117 * t3395 - t1117 * t3398 + 0.3e1 * t1117 * t3401 + 0.3e1 * t1123 * t3398 + 0.3e1 * t1133 * t3398 - 0.3e1 * t1137 * t3398 + 0.3e1 * t1137 * t3401 - 0.2e1 * t1147 * t3398 + t3387 + t3390 + t3393;
  t3418 = my_piecewise5(t64, 0, t67, 0, t3386 + t3416);
  t3420 = t52 * t291 * t935 / 0.8e1 + t59 * t3418;
  t3424 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3420);
  tv3lapl30 = t8 * t3424;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3428 = t945 * t315;
  t3437 = t3428 * t584;
  t3438 = t560 * t3437;
  t3439 = t3438 * t1432;
  t3440 = 0.3e1 * t3439;
  t3441 = t3438 * t1442;
  t3442 = 0.3e1 * t3441;
  t3443 = t3428 * t238;
  t3445 = t234 * t3443 * t1438;
  t3446 = 0.3e1 * t3445;
  t3447 = 0.3e1 * t3158;
  t3448 = 0.3e1 * t3166;
  t3449 = 0.3e1 * t3173;
  t3450 = 0.3e1 * t3204;
  t3451 = 0.3e1 * t3208;
  t3452 = -t1454 * t1464 * t3428 - 0.2e1 * t1471 * t234 * t3428 - 0.3e1 * t1475 * t3428 * t560 - t3440 - t3442 + t3446 - t3447 - t3448 + t3449 + t3450 - t3451 - t852 - t952;
  t3453 = 0.3e1 * t3211;
  t3454 = t3428 * t1456;
  t3455 = t560 * t3454;
  t3458 = t1454 * t3454;
  t3465 = t234 * t3437;
  t3466 = t3465 * t1507;
  t3467 = 0.3e1 * t3466;
  t3469 = t560 * t3443 * t1499;
  t3470 = 0.3e1 * t3469;
  t3471 = t234 * t3454;
  t3482 = 0.3e1 * t1481 * t3455 - t1481 * t3458 - t1481 * t3471 + 0.3e1 * t1485 * t3455 - 0.3e1 * t1485 * t3471 - 0.2e1 * t1494 * t3458 + 0.3e1 * t1511 * t3458 + 0.3e1 * t1522 * t3458 + 0.3e1 * t1526 * t3455 - 0.3e1 * t1526 * t3458 + t3453 + t3467 + t3470;
  t3484 = my_piecewise5(t114, 0, t115, 0, t3452 + t3482);
  t3486 = t52 * t308 * t958 / 0.8e1 + t113 * t3484;
  t3490 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * t3486);
  tv3lapl33 = t8 * t3490;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t3493 = t21 * t21;
  t3495 = 0.1e1 / t26 / t3493;
  t3496 = t328 * t328;
  t3502 = t336 * t336;
  t3508 = 0.1e1 / t975 / t8;
  t3509 = t18 * t3508;
  t3512 = my_piecewise5(t12, 0, t16, 0, -0.24e2 * t976 + 0.24e2 * t3509);
  t3516 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3495 * t3496 - 0.2e2 / 0.9e1 * t968 * t328 * t336 + 0.1e2 / 0.3e1 * t327 * t3502 + 0.4e2 / 0.9e1 * t972 * t980 + 0.5e1 / 0.3e1 * t27 * t3512);
  t3525 = t7 * t989 * t176;
  t3531 = t7 * t996 * t176;
  t3534 = t7 * t345 * t418;
  t3540 = t7 * t1008 * t176;
  t3543 = t7 * t354 * t418;
  t3546 = t7 * t145 * t1154;
  t3550 = 0.1e1 / t41 / t361 / t39;
  t3553 = 0.1309e5 / 0.729e3 * t38 * sigma[0] * t3550;
  t3560 = 0.2618e4 / 0.243e3 * t47 * t48 * t3550 + 0.77e3 / 0.243e3 * t52 * t53 * t1020 - t3553;
  t3573 = params->csk_a * t403;
  t3575 = t171 * t3573 * t399;
  t3578 = t399 * t167;
  t3580 = t379 * t3578 * t384;
  t3581 = t389 * t1650;
  t3586 = t380 * t380;
  t3587 = t163 * t3586;
  t3588 = t403 * t403;
  t3589 = t3588 * t384;
  t3590 = t3589 * t171;
  t3593 = t382 * t382;
  t3594 = t383 * t383;
  t3595 = 0.1e1 / t3594;
  t3596 = t3593 * t3595;
  t3597 = t3596 * t171;
  t3600 = t379 * t3586;
  t3601 = t3589 * t389;
  t3605 = t3596 * t389;
  t3609 = t3596 * t1077;
  t3612 = t377 * t377;
  t3614 = t76 / t3612;
  t3616 = t386 * t386;
  t3617 = t387 * t387;
  t3618 = 0.1e1 / t3617;
  t3619 = t3616 * t3618;
  t3620 = t3596 * t3619;
  t3622 = my_piecewise3(t67, 0, t3560);
  t3623 = my_piecewise3(t69, t3622, 0);
  t3626 = t399 * t399;
  t3630 = t163 * t3626;
  t3635 = t3586 * t382;
  t3636 = t163 * t3635;
  t3638 = t1578 * t1600 * t403;
  t3641 = t163 * t1595;
  t3643 = t1578 * t1600 * t399;
  t3646 = t399 * t1070;
  t3647 = t379 * t3646;
  t3650 = t1068 * t3646;
  t3653 = 0.6e1 * t1068 * t3586 * t3609 - t163 * t172 * t3623 + t3586 * t3614 * t3620 + 0.3e1 * t3626 * t379 * t390 + 0.18e2 * t1602 * t3647 - 0.6e1 * t1602 * t3650 + 0.11e2 * t3600 * t3605 - 0.3e1 * t3630 * t405 + 0.3e1 * t3630 * t407 - 0.6e1 * t3636 * t3638 - 0.6e1 * t3641 * t3643;
  t3655 = t3586 * t403;
  t3656 = t379 * t3655;
  t3658 = t382 * t74 * t170;
  t3659 = t1116 * t3658;
  t3662 = t1068 * t3655;
  t3665 = t1094 * t3658;
  t3673 = t1578 * t1056;
  t3676 = t1081 * t382;
  t3677 = t379 * t3676;
  t3680 = t1122 * t1615;
  t3685 = t1068 * t3635;
  t3687 = t1122 * t1103 * params->csk_a;
  t3696 = t1076 * t399;
  t3698 = t1131 * t3696 * params->csk_a;
  t3704 = t1131 * t1146 * t382;
  t3710 = t411 * t1103 * t399;
  t3713 = t1076 * t403;
  t3715 = t1131 * t3713 * params->csk_a;
  t3719 = t1122 * t1136 * t399;
  t3723 = t382 * t386 * t388;
  t3724 = t1116 * t3723;
  t3727 = t379 * t3635;
  t3729 = t1122 * t1136 * t403;
  t3732 = t163 * t3676;
  t3735 = 0.18e2 * t163 * t1660 * t3578 * t394 * t403 + 0.18e2 * t1590 * t3710 + 0.18e2 * t1596 * t3698 - 0.12e2 * t1619 * t3650 + 0.18e2 * t1664 * t3719 - 0.12e2 * t3662 * t3704 - 0.18e2 * t3662 * t3724 - 0.4e1 * t3677 * t645 + 0.18e2 * t3685 * t3715 + 0.18e2 * t3727 * t3729 + 0.4e1 * t3732 * t630;
  t3741 = t3586 * t3593;
  t3742 = t1068 * t3741;
  t3743 = t3595 * t1074;
  t3744 = t3743 * t1132;
  t3747 = t379 * t3741;
  t3748 = t3595 * t386;
  t3749 = t1115 * params->csk_a;
  t3750 = t388 * t3749;
  t3751 = t3748 * t3750;
  t3754 = t3614 * t3741;
  t3755 = t3595 * t3616;
  t3757 = t3755 * t3618 * t1115;
  t3760 = t1076 * t3749;
  t3761 = t3743 * t3760;
  t3766 = t3618 * t3749;
  t3767 = t3755 * t3766;
  t3773 = t3748 * t1136;
  t3778 = t3743 * t1146;
  t3782 = t3755 * t3618 * params->csk_a;
  t3793 = t1122 * t1127;
  t3796 = t3748 * t412;
  t3806 = -0.4e1 * t1081 * t163 * t165 * t405 + 0.4e1 * t1081 * t388 * t411 * t623 - 0.6e1 * t1131 * t1596 * t3696 - 0.18e2 * t1664 * t3793 - 0.18e2 * t3742 * t3796 - 0.11e2 * t3747 * t3773 + 0.7e1 * t3747 * t3796 - 0.7e1 * t3751 * t3754 + 0.7e1 * t3754 * t3773 + 0.18e2 * t3754 * t3778 - 0.6e1 * t3754 * t3782;
  t3808 = t3626 * t382;
  t3809 = t379 * t3808;
  t3815 = t1131 * t3713;
  t3822 = t3586 * t3588;
  t3823 = t379 * t3822;
  t3829 = t163 * t3741;
  t3830 = t3595 * t74;
  t3831 = t3830 * t395;
  t3834 = t1122 * t1103;
  t3841 = t170 * t382;
  t3842 = t1578 * t3841;
  t3845 = -0.12e2 * t163 * t1661 * t3646 - 0.12e2 * t163 * t3655 * t3842 + 0.3e1 * t163 * t3808 * t396 + 0.3e1 * t163 * t3822 * t396 - 0.6e1 * t3685 * t3815 - 0.18e2 * t3727 * t3834 + 0.4e1 * t3732 * t640 - 0.3e1 * t3809 * t396 - 0.3e1 * t3809 * t413 - 0.3e1 * t3823 * t413 + 0.11e2 * t3829 * t3831;
  t3850 = t3595 * t3749;
  t3851 = t3850 * t171;
  t3860 = t3595 * t1115;
  t3861 = t3860 * t171;
  t3870 = -0.6e1 * t3742 * t3778 + 0.6e1 * t3742 * t3851 + 0.6e1 * t3742 * t3861 - 0.6e1 * t3744 * t3754 - 0.11e2 * t3747 * t3831 - 0.7e1 * t3747 * t3851 - 0.18e2 * t3747 * t3861 - t3754 * t3851 - 0.3e1 * t3823 * t396 + t3829 * t3851 + 0.6e1 * t3829 * t3861;
  t3874 = my_piecewise5(t64, 0, t67, 0, 0.18e2 * t163 * t1589 * t384 * t3575 + t3870 + t3845 + t3806 + t3735 + t3653 - 0.5e1 * t1142 + 0.4e1 * t1113 + 0.4e1 * t1105 - 0.4e1 * t1064 + 0.4e1 * t1053 - 0.4e1 * t1047 - t406 + 0.12e2 * t3742 * t3761 - 0.12e2 * t3754 * t3761 - 0.6e1 * t3754 * t3767 + 0.18e2 * t3742 * t3751 - 0.12e2 * t3742 * t3744 - 0.7e1 * t3747 * t3751 + 0.11e2 * t3754 * t3757 + 0.18e2 * t1596 * t3680 - 0.18e2 * t3650 * t1612 + 0.18e2 * t3685 * t3687 + 0.18e2 * t3656 * t3659 - 0.6e1 * t3662 * t3659 + 0.18e2 * t3656 * t3665 + 0.18e2 * t3647 * t1580 - 0.18e2 * t3641 * t3673 - 0.4e1 * t3677 * t630 + 0.3e1 * t3600 * t3601 - 0.18e2 * t3580 * t3581 - 0.18e2 * t3580 * t1651 + 0.3e1 * t3587 * t3590 + 0.6e1 * t3587 * t3597 - 0.18e2 * t3636 * t1578 * t1051);
  t3882 = t7 * t984 * t144 * t79;
  t3886 = t7 * t340 * t353 * t79;
  t3890 = t7 * t139 * t1007 * t79;
  t3893 = 0.1e1 / t30 / t331;
  t3897 = 0.14e2 / 0.135e3 * t7 * t29 * t3893 * t79;
  t3898 = 0.3e1 / 0.2e2 * t7 * t3516 * t31 * t79 + 0.3e1 / 0.5e1 * t7 * t985 * t176 + 0.6e1 / 0.5e1 * t3525 + 0.9e1 / 0.1e2 * t7 * t341 * t418 - 0.2e1 / 0.5e1 * t3531 + 0.6e1 / 0.5e1 * t3534 + 0.3e1 / 0.5e1 * t7 * t140 * t1154 + 0.8e1 / 0.45e2 * t3540 - t3543 / 0.5e1 + 0.2e1 / 0.5e1 * t3546 + 0.3e1 / 0.2e2 * t7 * t32 * (0.4e1 * t1030 * t174 + 0.4e1 * t1152 * t161 + t3560 * t77 + 0.6e1 * t373 * t416 + t3874 * t59 + t3553) + 0.2e1 / 0.5e1 * t3882 - t3886 / 0.5e1 + 0.8e1 / 0.45e2 * t3890 - t3897;
  t3899 = my_piecewise3(t2, 0, t3898);
  t3900 = t88 * t88;
  t3902 = 0.1e1 / t90 / t3900;
  t3903 = t425 * t425;
  t3909 = t431 * t431;
  t3914 = t85 * t3508;
  t3917 = my_piecewise5(t16, 0, t12, 0, 0.24e2 * t976 + 0.24e2 * t3914);
  t3921 = my_piecewise3(t89, 0, 0.4e2 / 0.81e2 * t3902 * t3903 - 0.2e2 / 0.9e1 * t1161 * t425 * t431 + 0.1e2 / 0.3e1 * t424 * t3909 + 0.4e2 / 0.9e1 * t1165 * t1171 + 0.5e1 / 0.3e1 * t91 * t3917);
  t3928 = t7 * t1175 * t144 * t127;
  t3932 = t7 * t435 * t353 * t127;
  t3936 = t7 * t187 * t1007 * t127;
  t3941 = 0.14e2 / 0.135e3 * t7 * t93 * t3893 * t127;
  t3943 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t3921 * t31 * t127 + 0.2e1 / 0.5e1 * t3928 - t3932 / 0.5e1 + 0.8e1 / 0.45e2 * t3936 - t3941);
  tv4rho40 = 0.4e1 * t1159 + 0.4e1 * t1193 + t8 * (t3899 + t3943);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t3950 = t7 * t1213 * t144 * t79;
  t3954 = t7 * t460 * t353 * t79;
  t3955 = t3954 / 0.1e2;
  t3958 = t7 * t204 * t1007 * t79;
  t3976 = 0.12e2 * t976;
  t3977 = 0.24e2 * t3509;
  t3979 = my_piecewise5(t12, 0, t16, 0, -t3976 + t3977);
  t3983 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3495 * t201 * t969 - 0.1e2 / 0.9e1 * t968 * t456 * t328 - 0.1e2 / 0.9e1 * t1198 * t136 * t336 + 0.1e2 / 0.3e1 * t327 * t1209 * t136 + 0.1e2 / 0.3e1 * t1201 * t336 + 0.1e2 / 0.9e1 * t452 * t980 + 0.5e1 / 0.3e1 * t27 * t3979);
  t3992 = t7 * t1218 * t176;
  t3998 = t7 * t1225 * t176;
  t3999 = t3998 / 0.1e2;
  t4001 = t7 * t465 * t418;
  t4015 = 0.3e1 / 0.1e2 * t3950 - t3955 + 0.2e1 / 0.45e2 * t3958 + 0.3e1 / 0.2e2 * t7 * t3983 * t31 * t79 + 0.9e1 / 0.2e2 * t7 * t1214 * t176 + 0.3e1 / 0.5e1 * t3992 + 0.9e1 / 0.2e2 * t7 * t461 * t418 - t3999 + 0.3e1 / 0.1e2 * t4001 + 0.3e1 / 0.2e2 * t7 * t205 * t1154 + 0.3e1 / 0.1e2 * t3525 - t3531 / 0.5e1 + 0.3e1 / 0.1e2 * t3534 + 0.2e1 / 0.15e2 * t3540 - t3543 / 0.1e2 + t3546 / 0.1e2 + t3882 / 0.1e2 - t3886 / 0.1e2 + 0.2e1 / 0.15e2 * t3890 - t3897;
  t4016 = my_piecewise3(t2, 0, t4015);
  t4033 = 0.24e2 * t3914;
  t4035 = my_piecewise5(t16, 0, t12, 0, t3976 + t4033);
  t4039 = my_piecewise3(t89, 0, 0.4e2 / 0.81e2 * t3902 * t212 * t1162 - 0.1e2 / 0.9e1 * t1161 * t480 * t425 - 0.1e2 / 0.9e1 * t1242 * t184 * t431 + 0.1e2 / 0.3e1 * t424 * t1252 * t184 + 0.1e2 / 0.3e1 * t1245 * t431 + 0.1e2 / 0.9e1 * t476 * t1171 + 0.5e1 / 0.3e1 * t91 * t4035);
  t4046 = t7 * t1256 * t144 * t127;
  t4050 = t7 * t484 * t353 * t127;
  t4051 = t4050 / 0.1e2;
  t4054 = t7 * t215 * t1007 * t127;
  t4063 = t7 * t1180 * t247;
  t4066 = t7 * t1184 * t247;
  t4067 = t4066 / 0.1e2;
  t4069 = t7 * t1188 * t247;
  t4071 = 0.3e1 / 0.2e2 * t7 * t4039 * t31 * t127 + 0.3e1 / 0.1e2 * t4046 - t4051 + 0.2e1 / 0.45e2 * t4054 + t3928 / 0.1e2 - t3932 / 0.1e2 + 0.2e1 / 0.15e2 * t3936 - t3941 + 0.3e1 / 0.2e2 * t7 * t1176 * t247 + 0.3e1 / 0.1e2 * t4063 - t4067 + 0.2e1 / 0.45e2 * t4069;
  t4072 = my_piecewise3(t84, 0, t4071);
  tv4rho41 = t1159 + t1193 + 0.3e1 * t1241 + 0.3e1 * t1281 + t8 * (t4016 + t4072);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t4087 = t456 * t456;
  t4100 = my_piecewise5(t12, 0, t16, 0, t3977);
  t4104 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3495 * t506 * t328 - 0.4e2 / 0.27e2 * t1198 * t136 * t456 - 0.1e2 / 0.27e2 * t1284 * t336 + 0.2e2 / 0.9e1 * t327 * t4087 + 0.2e2 / 0.9e1 * t452 * t1209 - 0.1e2 / 0.27e2 * t968 * t511 * t328 + 0.2e2 / 0.9e1 * t327 * t1293 * t136 + 0.1e2 / 0.9e1 * t1289 * t336 + 0.5e1 / 0.3e1 * t27 * t4100);
  t4113 = t7 * t1302 * t176;
  t4120 = t7 * t1297 * t144 * t79;
  t4124 = t7 * t515 * t353 * t79;
  t4137 = 0.3e1 / 0.2e2 * t7 * t4104 * t31 * t79 + 0.3e1 / 0.1e2 * t7 * t1298 * t176 + t4113 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t516 * t418 + t4120 / 0.5e1 - t4124 / 0.3e2 + t3950 / 0.5e1 - 0.2e1 / 0.15e2 * t3954 + 0.4e1 / 0.45e2 * t3958 + 0.2e1 / 0.5e1 * t3992 - 0.2e1 / 0.15e2 * t3998 + t4001 / 0.5e1 - t3531 / 0.15e2 + 0.4e1 / 0.45e2 * t3540 - t3543 / 0.3e2 - t3886 / 0.3e2 + 0.4e1 / 0.45e2 * t3890 - t3897;
  t4138 = my_piecewise3(t2, 0, t4137);
  t4147 = t480 * t480;
  t4160 = my_piecewise5(t16, 0, t12, 0, t4033);
  t4164 = my_piecewise3(t89, 0, 0.4e2 / 0.81e2 * t3902 * t523 * t425 - 0.4e2 / 0.27e2 * t1242 * t184 * t480 - 0.1e2 / 0.27e2 * t1314 * t431 + 0.2e2 / 0.9e1 * t424 * t4147 + 0.2e2 / 0.9e1 * t476 * t1252 - 0.1e2 / 0.27e2 * t1161 * t528 * t425 + 0.2e2 / 0.9e1 * t424 * t1323 * t184 + 0.1e2 / 0.9e1 * t1319 * t431 + 0.5e1 / 0.3e1 * t91 * t4160);
  t4171 = t7 * t1327 * t144 * t127;
  t4175 = t7 * t532 * t353 * t127;
  t4184 = t7 * t1261 * t247;
  t4187 = t7 * t1265 * t247;
  t4198 = t7 * t440 * t599;
  t4201 = t7 * t444 * t599;
  t4203 = 0.3e1 / 0.2e2 * t7 * t4164 * t31 * t127 + t4171 / 0.5e1 - t4175 / 0.3e2 + t4046 / 0.5e1 - 0.2e1 / 0.15e2 * t4050 + 0.4e1 / 0.45e2 * t4054 + 0.3e1 / 0.1e2 * t7 * t1257 * t247 + 0.2e1 / 0.5e1 * t4184 - t4187 / 0.15e2 - t3932 / 0.3e2 + 0.4e1 / 0.45e2 * t3936 - t3941 + t4063 / 0.5e1 - 0.2e1 / 0.15e2 * t4066 + 0.4e1 / 0.45e2 * t4069 + 0.3e1 / 0.2e2 * t7 * t436 * t599 + t4198 / 0.5e1 - t4201 / 0.3e2;
  t4204 = my_piecewise3(t84, 0, t4203);
  tv4rho42 = 0.2e1 * t1241 + 0.2e1 * t1281 + 0.2e1 * t1313 + 0.2e1 * t1352 + t8 * (t4138 + t4204);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t4225 = my_piecewise5(t12, 0, t16, 0, t3976 + t3977);
  t4229 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3495 * t1357 * t136 - 0.1e2 / 0.9e1 * t1284 * t456 - 0.1e2 / 0.9e1 * t1198 * t511 * t136 + 0.1e2 / 0.3e1 * t1201 * t511 + 0.1e2 / 0.3e1 * t452 * t1293 + 0.1e2 / 0.9e1 * t327 * t1364 * t136 + 0.5e1 / 0.3e1 * t27 * t4225);
  t4236 = t7 * t1368 * t144 * t79;
  t4247 = 0.3e1 / 0.2e2 * t7 * t4229 * t31 * t79 + t4236 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t1369 * t176 + 0.3e1 / 0.1e2 * t4120 - t4124 / 0.1e2 + 0.3e1 / 0.1e2 * t4113 - t3955 + 0.2e1 / 0.15e2 * t3958 - t3999 + 0.2e1 / 0.45e2 * t3890 - t3897 + 0.2e1 / 0.45e2 * t3540;
  t4248 = my_piecewise3(t2, 0, t4247);
  t4265 = my_piecewise5(t16, 0, t12, 0, -t3976 + t4033);
  t4269 = my_piecewise3(t89, 0, 0.4e2 / 0.81e2 * t3902 * t1377 * t184 - 0.1e2 / 0.9e1 * t1314 * t480 - 0.1e2 / 0.9e1 * t1242 * t528 * t184 + 0.1e2 / 0.3e1 * t1245 * t528 + 0.1e2 / 0.3e1 * t476 * t1323 + 0.1e2 / 0.9e1 * t424 * t1384 * t184 + 0.5e1 / 0.3e1 * t91 * t4265);
  t4276 = t7 * t1388 * t144 * t127;
  t4284 = t7 * t1332 * t247;
  t4293 = t7 * t489 * t599;
  t4303 = t7 * t192 * t1539;
  t4305 = 0.3e1 / 0.2e2 * t7 * t4269 * t31 * t127 + t4276 / 0.1e2 + 0.3e1 / 0.1e2 * t4171 - t4175 / 0.1e2 + 0.9e1 / 0.2e2 * t7 * t1328 * t247 + 0.3e1 / 0.1e2 * t4284 - t4051 + 0.2e1 / 0.15e2 * t4054 + 0.3e1 / 0.5e1 * t4184 - t4187 / 0.5e1 + 0.9e1 / 0.2e2 * t7 * t485 * t599 + 0.3e1 / 0.1e2 * t4293 + 0.2e1 / 0.45e2 * t3936 - t3941 - t4067 + 0.2e1 / 0.15e2 * t4069 + 0.3e1 / 0.1e2 * t4198 - t4201 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t188 * t1539 + t4303 / 0.1e2;
  t4306 = my_piecewise3(t84, 0, t4305);
  tv4rho43 = 0.3e1 * t1313 + 0.3e1 * t1352 + t1376 + t1544 + t8 * (t4248 + t4306);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t4311 = t506 * t506;
  t4316 = t511 * t511;
  t4323 = my_piecewise5(t12, 0, t16, 0, 0.24e2 * t976 + 0.24e2 * t3509);
  t4327 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3495 * t4311 - 0.2e2 / 0.9e1 * t1284 * t511 + 0.1e2 / 0.3e1 * t327 * t4316 + 0.4e2 / 0.9e1 * t452 * t1364 + 0.5e1 / 0.3e1 * t27 * t4323);
  t4336 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t4327 * t31 * t79 + 0.2e1 / 0.5e1 * t4236 - t4124 / 0.5e1 + 0.8e1 / 0.45e2 * t3958 - t3897);
  t4345 = 0.1e1 / t97 / t542 / t95;
  t4348 = 0.1309e5 / 0.729e3 * t38 * sigma[2] * t4345;
  t4355 = 0.2618e4 / 0.243e3 * t47 * t103 * t4345 + 0.77e3 / 0.243e3 * t52 * t107 * t1406 - t4348;
  t4366 = t561 * t561;
  t4367 = t4366 * t563;
  t4368 = t234 * t4367;
  t4370 = t1773 * t2381 * t584;
  t4373 = t1454 * t4367;
  t4376 = t1773 * t1437;
  t4379 = t234 * t1795;
  t4381 = t1773 * t2381 * t580;
  t4384 = t580 * t1456;
  t4388 = t4366 * t584;
  t4391 = t563 * t122 * t241;
  t4392 = t1480 * t4391;
  t4397 = t1510 * t1498 * params->csk_a;
  t4402 = t563 * t567 * t569;
  t4403 = t1480 * t4402;
  t4406 = t560 * t4367;
  t4408 = t1510 * t1525 * t584;
  t4411 = t1773 * t1446;
  t4415 = t1492 * t1493 * t580;
  t4422 = t1467 * t563;
  t4423 = t560 * t4422;
  t4426 = t1510 * t1810;
  t4429 = t1454 * t4384;
  t4433 = t1492 * t1493 * t584;
  t4436 = -0.18e2 * t1454 * t4388 * t4403 - 0.6e1 * t1796 * t4381 - 0.12e2 * t1796 * t4415 + 0.18e2 * t1796 * t4426 - 0.18e2 * t1807 * t4429 + 0.18e2 * t1858 * t4411 + 0.18e2 * t4373 * t4397 - 0.12e2 * t4373 * t4433 - 0.18e2 * t4379 * t4411 + 0.18e2 * t4406 * t4408 - 0.4e1 * t4423 * t692;
  t4438 = t580 * t238;
  t4441 = t575 * t1862 * t584;
  t4449 = params->csk_a * t238;
  t4450 = t4449 * t580;
  t4451 = t570 * t4450;
  t4456 = params->csk_a * t584;
  t4458 = t242 * t4456 * t580;
  t4465 = t234 * t4366;
  t4466 = t584 * t584;
  t4467 = t4466 * t565;
  t4468 = t4467 * t242;
  t4471 = t580 * t580;
  t4475 = t234 * t4471;
  t4481 = t563 * t563;
  t4482 = t564 * t564;
  t4483 = 0.1e1 / t4482;
  t4484 = t4481 * t4483;
  t4485 = t4484 * t1463;
  t4489 = t4484 * t242;
  t4492 = t560 * t4366;
  t4493 = t4467 * t570;
  t4496 = t4484 * t570;
  t4499 = t558 * t558;
  t4501 = t124 / t4499;
  t4503 = t567 * t567;
  t4504 = t568 * t568;
  t4505 = 0.1e1 / t4504;
  t4506 = t4503 * t4505;
  t4507 = t4484 * t4506;
  t4509 = my_piecewise3(t115, 0, t4355);
  t4510 = my_piecewise3(t117, t4509, 0);
  t4515 = t1462 * t584;
  t4517 = t1492 * t4515 * params->csk_a;
  t4521 = t592 * t1498 * t580;
  t4525 = t1510 * t1525 * t580;
  t4528 = t1462 * t580;
  t4530 = t1492 * t4528 * params->csk_a;
  t4533 = t234 * t4422;
  t4536 = -t234 * t243 * t4510 + t4366 * t4501 * t4507 + 0.18e2 * t1779 * t4521 + 0.18e2 * t1796 * t4530 + 0.18e2 * t1858 * t4525 + 0.18e2 * t4373 * t4517 - 0.4e1 * t4423 * t707 + 0.6e1 * t4465 * t4489 + 0.3e1 * t4492 * t4493 + 0.11e2 * t4492 * t4496 + 0.4e1 * t4533 * t692;
  t4542 = t4471 * t563;
  t4546 = t560 * t4542;
  t4549 = t4366 * t4481;
  t4550 = t1454 * t4549;
  t4551 = t4483 * t1460;
  t4552 = t4551 * t1521;
  t4555 = t560 * t4549;
  t4556 = t4483 * t567;
  t4557 = t569 * t3749;
  t4558 = t4556 * t4557;
  t4563 = t1510 * t1517;
  t4566 = t4501 * t4549;
  t4567 = t4551 * t1493;
  t4571 = t4556 * t593;
  t4574 = t4556 * t1525;
  t4577 = t4483 * t4503;
  t4579 = t4577 * t4505 * t1115;
  t4582 = t4505 * t3749;
  t4583 = t4577 * t4582;
  t4590 = t4577 * t4505 * params->csk_a;
  t4601 = t1773 * t1855;
  t4608 = -0.4e1 * t1467 * t234 * t236 * t586 + 0.4e1 * t1467 * t569 * t592 * t685 - 0.6e1 * t1492 * t1796 * t4528 - 0.12e2 * t4379 * t4601 + 0.7e1 * t4555 * t4571 - 0.11e2 * t4555 * t4574 - 0.7e1 * t4558 * t4566 + 0.7e1 * t4566 * t4574 + 0.11e2 * t4566 * t4579 - 0.6e1 * t4566 * t4583 - 0.6e1 * t4566 * t4590;
  t4612 = t1492 * t4515;
  t4625 = t4366 * t4466;
  t4626 = t560 * t4625;
  t4629 = t1510 * t1498;
  t4632 = t4483 * params->csk_a;
  t4633 = t4632 * t242;
  t4641 = -0.12e2 * t1773 * t241 * t4368 * t584 + 0.3e1 * t234 * t4625 * t577 - 0.6e1 * t4373 * t4612 - 0.18e2 * t4406 * t4629 + 0.4e1 * t4533 * t702 - 0.3e1 * t4546 * t577 - 0.6e1 * t4550 * t4567 - 0.18e2 * t4550 * t4571 - 0.11e2 * t4555 * t4633 - 0.3e1 * t4626 * t577 - 0.3e1 * t4626 * t594;
  t4642 = t234 * t4549;
  t4645 = t4483 * t1115;
  t4646 = t4645 * t242;
  t4649 = t4483 * t3749;
  t4650 = t4649 * t242;
  t4658 = t1462 * t3749;
  t4659 = t4551 * t4658;
  t4669 = 0.6e1 * t4550 * t4646 + 0.6e1 * t4550 * t4650 + 0.12e2 * t4550 * t4659 - 0.6e1 * t4552 * t4566 - 0.18e2 * t4555 * t4646 - 0.7e1 * t4555 * t4650 - t4566 * t4650 - 0.12e2 * t4566 * t4659 + 0.11e2 * t4633 * t4642 + 0.6e1 * t4642 * t4646 + t4642 * t4650;
  t4673 = my_piecewise5(t114, 0, t115, 0, -0.18e2 * t560 * t561 * t584 * t565 * t4451 + t4436 - 0.5e1 * t1531 + 0.4e1 * t1508 + 0.4e1 * t1500 - 0.4e1 * t1443 + 0.4e1 * t1439 - 0.4e1 * t1433 - t587 - 0.12e2 * t4550 * t4552 - 0.7e1 * t4555 * t4558 + 0.18e2 * t4550 * t4558 - 0.18e2 * t1858 * t4563 + 0.18e2 * t4566 * t4567 - 0.3e1 * t4546 * t594 + 0.3e1 * t4465 * t4468 - 0.3e1 * t4475 * t586 + 0.3e1 * t4475 * t588 + 0.18e2 * t4406 * t4376 - 0.6e1 * t4373 * t4370 - 0.18e2 * t4368 * t4376 - 0.6e1 * t4379 * t4381 - 0.6e1 * t4368 * t4370 + 0.18e2 * t234 * t1778 * t565 * t4458 - 0.18e2 * t560 * t4438 * t565 * t1846 + 0.18e2 * t560 * t4384 * t1793 + 0.18e2 * t560 * t4388 * t4392 + 0.18e2 * t234 * t4438 * t4441 + 0.3e1 * t560 * t4471 * t571 + 0.6e1 * t1454 * t4366 * t4485 + 0.3e1 * t234 * t4542 * t577 + t4608 + t4641 + t4669 + t4536);
  t4679 = t523 * t523;
  t4684 = t528 * t528;
  t4691 = my_piecewise5(t16, 0, t12, 0, -0.24e2 * t976 + 0.24e2 * t3914);
  t4695 = my_piecewise3(t89, 0, 0.4e2 / 0.81e2 * t3902 * t4679 - 0.2e2 / 0.9e1 * t1314 * t528 + 0.1e2 / 0.3e1 * t424 * t4684 + 0.4e2 / 0.9e1 * t476 * t1384 + 0.5e1 / 0.3e1 * t91 * t4691);
  t4712 = 0.9e1 / 0.1e2 * t7 * t533 * t599 + 0.3e1 / 0.5e1 * t7 * t216 * t1539 + 0.3e1 / 0.2e2 * t7 * t94 * (t113 * t4673 + t125 * t4355 + 0.4e1 * t1416 * t245 + 0.4e1 * t1537 * t232 + 0.6e1 * t554 * t597 + t4348) + 0.3e1 / 0.2e2 * t7 * t4695 * t31 * t127 + 0.3e1 / 0.5e1 * t7 * t1389 * t247 + 0.2e1 / 0.5e1 * t4276 + 0.6e1 / 0.5e1 * t4284 + 0.6e1 / 0.5e1 * t4293 + 0.2e1 / 0.5e1 * t4303 - t4175 / 0.5e1 - 0.2e1 / 0.5e1 * t4187 - t4201 / 0.5e1 + 0.8e1 / 0.45e2 * t4069 + 0.8e1 / 0.45e2 * t4054 - t3941;
  t4713 = my_piecewise3(t84, 0, t4712);
  tv4rho44 = 0.4e1 * t1376 + 0.4e1 * t1544 + t8 * (t4336 + t4713);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t4721 = t7 * t989 * t268;
  t4727 = t7 * t996 * t268;
  t4730 = t7 * t345 * t650;
  t4737 = 0.2e1 / 0.45e2 * t7 * t1008 * t268;
  t4739 = t7 * t354 * t650;
  t4742 = t7 * t145 * t1691;
  t4745 = 0.77e3 / 0.243e3 * t38 * t1020;
  t4749 = -0.154e3 / 0.81e2 * t47 * t37 * t1020 + t4745;
  t4766 = t263 * t3593;
  t4767 = t379 * t4766;
  t4770 = t3860 * t1040 * t74 * t170;
  t4773 = t1068 * t4766;
  t4776 = t633 * t1070;
  t4777 = t379 * t4776;
  t4780 = t1068 * t4776;
  t4783 = t163 * t4766;
  t4786 = t170 * t3749;
  t4788 = t3830 * t4786 * t1040;
  t4792 = 0.9e1 * t1602 * t4777 - 0.3e1 * t1602 * t4780 - 0.18e2 * t4767 * t4770 - 0.7e1 * t4767 * t4788 + 0.6e1 * t4770 * t4773 + 0.6e1 * t4770 * t4783 + t4783 * t4788 + 0.4e1 * t1587 + 0.4e1 * t1593 - 0.4e1 * t1644 + 0.4e1 * t1652 - 0.4e1 * t1654 - t638;
  t4795 = t1040 * t3593;
  t4796 = t3614 * t4795;
  t4798 = t3748 * t624 * t1115;
  t4802 = t3743 * t1146 * t1040;
  t4805 = t263 * t1040;
  t4806 = t163 * t4805;
  t4807 = t3589 * t2549;
  t4811 = t3830 * t395 * t1040;
  t4815 = t403 * t1072 * t3658;
  t4818 = t379 * t4805;
  t4819 = t389 * params->csk_a;
  t4820 = t3589 * t4819;
  t4827 = t3614 * t4766;
  t4830 = t3743 * t3760 * t1040;
  t4833 = t1040 * t382;
  t4834 = t379 * t4833;
  t4835 = t1122 * t1591;
  t4839 = t1578 * t639 * t399;
  t4843 = t411 * t1675 * t403;
  t4846 = -0.6e1 * t1577 * t4839 + 0.9e1 * t1590 * t4843 - 0.11e2 * t4767 * t4811 + 0.6e1 * t4773 * t4788 - 0.6e1 * t4773 * t4802 + 0.12e2 * t4773 * t4830 + 0.11e2 * t4783 * t4811 - t4788 * t4827 + 0.7e1 * t4796 * t4798 + 0.3e1 * t4806 * t4807 - 0.12e2 * t4806 * t4815 - 0.3e1 * t4807 * t4818 - 0.3e1 * t4818 * t4820 - 0.18e2 * t4834 * t4835;
  t4850 = t1068 * t4795;
  t4851 = t3748 * t882;
  t4854 = t1657 * t382;
  t4855 = t379 * t4854;
  t4860 = t1122 * t2242;
  t4865 = t163 * t4854;
  t4868 = t3618 * t263;
  t4877 = t1043 * t1081 * t74 * t170;
  t4881 = t3850 * t1040 * t386 * t388;
  t4890 = t1068 * t4833;
  t4895 = -0.6e1 * t1131 * t1633 * t403 * t4890 - 0.3e1 * t1131 * t2299 * t263 * t3696 - 0.6e1 * t3755 * t4796 * t4868 * params->csk_a - 0.3e1 * t1057 * t1629 + 0.9e1 * t1580 * t4777 + 0.9e1 * t1596 * t4860 - 0.9e1 * t1612 * t4780 + 0.18e2 * t4773 * t4881 - 0.7e1 * t4827 * t4881 - 0.18e2 * t4850 * t4851 - 0.3e1 * t4855 * t630 - 0.3e1 * t4855 * t645 + 0.3e1 * t4865 * t630 - t4877 * t642;
  t4896 = t379 * t2298;
  t4901 = t3743 * t1634;
  t4906 = t3743 * t3244;
  t4909 = t163 * t4776;
  t4916 = t379 * t4795;
  t4920 = t3748 * t1136 * t1040;
  t4923 = t633 * t380;
  t4933 = t411 * t412 * t1081;
  t4935 = -0.9e1 * t1122 * t399 * t4896 * t624 + 0.9e1 * t1586 * t163 * t4923 - 0.9e1 * t1580 * t4909 - 0.3e1 * t1602 * t4909 - 0.3e1 * t1616 * t1629 - 0.7e1 * t4767 * t4881 - 0.11e2 * t4767 * t4920 - 0.6e1 * t4796 * t4901 + 0.18e2 * t4796 * t4906 - 0.12e2 * t4827 * t4830 - 0.12e2 * t4850 * t4901 + 0.7e1 * t4851 * t4916 + t4877 * t628 - t4933 * t642;
  t4945 = t3755 * t3766 * t1040;
  t4952 = t1076 * t633;
  t4954 = t1131 * t4952 * params->csk_a;
  t4958 = t165 * t403 * t399;
  t4962 = t379 * t2550;
  t4963 = params->csk_a * t167;
  t4964 = t4963 * t399;
  t4965 = t2554 * t4964;
  t4968 = t1043 * t167;
  t4969 = t171 * t399;
  t4970 = t4968 * t4969;
  t4973 = t379 * t2514;
  t4975 = t1115 * t399 * t165;
  t4976 = t389 * t4975;
  t4979 = t4805 * t403;
  t4980 = t1068 * t4979;
  t4983 = t2266 * t4969;
  t4986 = t379 * t4979;
  t4989 = 0.11e2 * t1115 * t3755 * t4796 * t4868 + 0.9e1 * t1648 * t2549 * t4958 + 0.3e1 * t1057 * t1623 + 0.9e1 * t1596 * t4954 + 0.9e1 * t1612 * t4777 - 0.6e1 * t1619 * t4780 + 0.18e2 * t3659 * t4986 - 0.18e2 * t3724 * t4980 - 0.6e1 * t4827 * t4945 - 0.9e1 * t4962 * t4965 - 0.9e1 * t4962 * t4970 + 0.9e1 * t4973 * t4976 + 0.9e1 * t4973 * t4983;
  t4992 = t627 * t1072;
  t4993 = t163 * t4992;
  t4995 = t1115 * t1040 * t403;
  t4996 = t171 * t4995;
  t5003 = t171 * params->csk_a * t1040 * t403;
  t5007 = t379 * t4923 * t403;
  t5011 = t1068 * t4833 * t1072;
  t5017 = t165 * t167;
  t5019 = t379 * t5017 * t384;
  t5020 = t2286 * t399;
  t5025 = t1068 * t2298 * t1072;
  t5036 = t389 * t4995;
  t5039 = t163 * t2514;
  t5044 = t394 * t1111 * t399;
  t5049 = -0.6e1 * t4980 * t3659 - 0.6e1 * t4993 * t4996 + 0.18e2 * t4986 * t3665 - 0.18e2 * t4993 * t5003 - 0.9e1 * t5007 * t1063 + 0.18e2 * t5011 * t1077 * t3264 - 0.12e2 * t4980 * t3704 + 0.9e1 * t5019 * t389 * t5020 + 0.9e1 * t5025 * t389 * t3225 * t399 + 0.9e1 * t163 * t633 * t167 * t384 * t1651 + 0.18e2 * t379 * t4992 * t5036 - 0.9e1 * t5039 * t4983 + 0.9e1 * t163 * t2550 * t5044 - 0.9e1 * t5007 * t1046;
  t5051 = t389 * t3264;
  t5056 = t1077 * t4975;
  t5060 = t1068 * t3646 * t1072;
  t5061 = t3225 * t165;
  t5062 = t1077 * t5061;
  t5065 = t171 * t4975;
  t5072 = my_piecewise3(t67, 0, t4749);
  t5073 = my_piecewise3(t69, t5072, 0);
  t5083 = t411 * t388 * t1657;
  t5086 = t1131 * t4952;
  t5089 = -t163 * t172 * t5073 + 0.3e1 * t1037 * t1676 - 0.3e1 * t1596 * t5086 - 0.9e1 * t2515 * t4976 - 0.6e1 * t2515 * t5056 - 0.3e1 * t2515 * t5065 + 0.3e1 * t4865 * t640 + 0.9e1 * t4973 * t5065 + 0.18e2 * t5011 * t5051 - 0.3e1 * t5039 * t5065 + 0.9e1 * t5060 * t5062 + 0.3e1 * t5083 * t623 - 0.2e1 * t1670 - 0.3e1 * t1683;
  t5101 = t1122 * t1675;
  t5117 = t394 * t170 * t1081;
  t5120 = t170 * t1040;
  t5121 = t3830 * t5120;
  t5125 = t379 * t1040 * t3588;
  t5130 = t4796 * t3755 * t4868 - 0.3e1 * t163 * t1657 * t165 * t405 - 0.6e1 * t4909 * t1661 + 0.11e2 * t4916 * t3748 * t624 - 0.9e1 * t1664 * t5101 + 0.6e1 * t4850 * t3743 * t1633 - 0.3e1 * t163 * t633 * t399 * t405 - t163 * t263 * t1081 * t405 + 0.3e1 * t1623 * t1672 + t628 * t5117 + t3677 * t625 + 0.6e1 * t4783 * t5121 + 0.3e1 * t5125 * t625 + 0.3e1 * t4806 * t3590;
  t5134 = my_piecewise5(t64, 0, t67, 0, t4792 + t4846 + t4895 + t4935 + t4989 + t5049 + t5089 + t5130);
  t5141 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t985 * t268 + 0.3e1 / 0.1e2 * t4721 + 0.9e1 / 0.2e2 * t7 * t341 * t650 - t4727 / 0.1e2 + 0.3e1 / 0.5e1 * t4730 + 0.9e1 / 0.2e2 * t7 * t140 * t1691 + t4737 - t4739 / 0.1e2 + 0.3e1 / 0.1e2 * t4742 + 0.3e1 / 0.2e2 * t7 * t32 * (t1030 * t266 + t1152 * t260 + 0.3e1 * t1568 * t174 + 0.3e1 * t161 * t1689 + 0.3e1 * t373 * t648 + 0.3e1 * t416 * t618 + t4749 * t77 + t5134 * t59 - t4745));
  tv4rho3sigma0 = t5141 * t8 + 0.3e1 * t1696;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t5148 = t7 * t1180 * t286;
  t5151 = t7 * t1184 * t286;
  t5155 = 0.2e1 / 0.45e2 * t7 * t1188 * t286;
  t5157 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1176 * t286 + 0.3e1 / 0.1e2 * t5148 - t5151 / 0.1e2 + t5155);
  tv4rho3sigma2 = t5157 * t8 + 0.3e1 * t1709;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t5159 = 0.2e1 * t1723;
  t5165 = t7 * t1218 * t268 / 0.5e1;
  t5170 = t7 * t1225 * t268;
  t5174 = t7 * t465 * t650 / 0.5e1;
  t5183 = 0.3e1 / 0.2e2 * t7 * t1214 * t268 + t5165 + 0.3e1 / 0.1e2 * t7 * t461 * t650 - t5170 / 0.3e2 + t5174 + 0.3e1 / 0.2e2 * t7 * t205 * t1691 + t4721 / 0.1e2 - t4727 / 0.15e2 + t4730 / 0.5e1 + t4737 - t4739 / 0.15e2 + t4742 / 0.1e2;
  t5184 = my_piecewise3(t2, 0, t5183);
  tv4rho3sigma3 = t5184 * t8 + t1696 + t5159;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t5186 = 0.2e1 * t1739;
  t5192 = t7 * t1261 * t286 / 0.5e1;
  t5194 = t7 * t1265 * t286;
  t5203 = t7 * t440 * t712 / 0.5e1;
  t5205 = t7 * t444 * t712;
  t5208 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1257 * t286 + t5192 - t5194 / 0.3e2 + t5148 / 0.1e2 - t5151 / 0.15e2 + t5155 + 0.3e1 / 0.2e2 * t7 * t436 * t712 + t5203 - t5205 / 0.3e2);
  tv4rho3sigma5 = t5208 * t8 + t1709 + t5186;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t5214 = t7 * t1302 * t268;
  t5223 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1298 * t268 + t5214 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t516 * t650 + t5165 - t5170 / 0.15e2 + t5174 - t4727 / 0.3e2 + t4737 - t4739 / 0.3e2);
  tv4rho3sigma6 = t5223 * t8 + t1747 + t5159;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t5229 = t7 * t1332 * t286;
  t5236 = t7 * t489 * t712;
  t5244 = t7 * t192 * t1886;
  t5246 = 0.3e1 / 0.2e2 * t7 * t1328 * t286 + t5229 / 0.1e2 + t5192 - t5194 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t485 * t712 + t5236 / 0.5e1 - t5151 / 0.3e2 + t5155 + t5203 - t5205 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t188 * t1886 + t5244 / 0.1e2;
  t5247 = my_piecewise3(t84, 0, t5246);
  tv4rho3sigma8 = t5247 * t8 + t1891 + t5186;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t5256 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1369 * t268 + 0.3e1 / 0.1e2 * t5214 - t5170 / 0.1e2 + t4737);
  tv4rho3sigma9 = t5256 * t8 + 0.3e1 * t1747;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t5274 = 0.77e3 / 0.243e3 * t38 * t1406;
  t5278 = -0.154e3 / 0.81e2 * t47 * t37 * t1406 + t5274;
  t5295 = t281 * t4481;
  t5296 = t560 * t5295;
  t5298 = t1426 * t122 * t241;
  t5299 = t4645 * t5298;
  t5302 = t1454 * t5295;
  t5305 = t695 * t1456;
  t5306 = t560 * t5305;
  t5309 = t1454 * t5305;
  t5312 = t234 * t5295;
  t5315 = t4649 * t5298;
  t5318 = t4501 * t5295;
  t5320 = 0.9e1 * t1793 * t5306 - 0.3e1 * t1793 * t5309 - 0.18e2 * t5296 * t5299 + 0.6e1 * t5299 * t5302 + 0.6e1 * t5299 * t5312 + 0.6e1 * t5302 * t5315 - t5315 * t5318 + 0.4e1 * t1782 + 0.4e1 * t1788 - 0.4e1 * t1839 + 0.4e1 * t1847 - 0.4e1 * t1849 - t700;
  t5325 = t4551 * t4658 * t1426;
  t5332 = t281 * t1426;
  t5333 = t560 * t5332;
  t5334 = t570 * params->csk_a;
  t5335 = t4467 * t5334;
  t5338 = t4632 * t5298;
  t5343 = t234 * t5332;
  t5344 = t4467 * t2670;
  t5347 = t1426 * t563;
  t5348 = t560 * t5347;
  t5353 = t584 * t1458 * t4391;
  t5358 = t1454 * t5347;
  t5363 = t1426 * t4481;
  t5364 = t1454 * t5363;
  t5365 = t4551 * t1818;
  t5368 = t695 * t561;
  t5372 = -0.6e1 * t1426 * t1493 * t4551 * t5302 - 0.6e1 * t1492 * t1817 * t5358 * t584 - 0.18e2 * t1510 * t1780 * t5348 + 0.9e1 * t1787 * t234 * t5368 - 0.7e1 * t5296 * t5315 - 0.11e2 * t5296 * t5338 + 0.12e2 * t5302 * t5325 + t5312 * t5315 + 0.11e2 * t5312 * t5338 - 0.3e1 * t5333 * t5335 - 0.3e1 * t5333 * t5344 + 0.3e1 * t5343 * t5344 - 0.12e2 * t5343 * t5353 - 0.12e2 * t5364 * t5365;
  t5374 = t560 * t2447;
  t5381 = t4556 * t908;
  t5384 = t1852 * t563;
  t5385 = t560 * t5384;
  t5390 = t1510 * t2401;
  t5395 = t234 * t5305;
  t5398 = t560 * t5363;
  t5401 = t234 * t5384;
  t5404 = t4501 * t5363;
  t5405 = t4505 * t281;
  t5414 = t1429 * t1467 * t122 * t241;
  t5418 = -0.9e1 * t1510 * t5374 * t580 * t686 - 0.6e1 * t4577 * t5404 * t5405 * params->csk_a - 0.3e1 * t1447 * t1830 + 0.9e1 * t1775 * t5306 - 0.9e1 * t1775 * t5395 + 0.9e1 * t1796 * t5390 - 0.9e1 * t1807 * t5309 - 0.12e2 * t5318 * t5325 - 0.18e2 * t5364 * t5381 + 0.7e1 * t5381 * t5398 - 0.3e1 * t5385 * t692 - 0.3e1 * t5385 * t707 + 0.3e1 * t5401 * t692 - t5414 * t704;
  t5422 = t592 * t593 * t1467;
  t5426 = t4649 * t1426 * t567 * t569;
  t5433 = t1462 * t695;
  t5435 = t1492 * t5433 * params->csk_a;
  t5439 = t4556 * t686 * t1115;
  t5446 = t4551 * t3327;
  t5454 = t4556 * t1525 * t1426;
  t5458 = t592 * t1874 * t584;
  t5462 = t1773 * t1855 * t236;
  t5465 = -0.3e1 * t1492 * t2448 * t281 * t4528 - 0.6e1 * t1772 * t5462 + 0.9e1 * t1779 * t5458 - 0.3e1 * t1793 * t5395 + 0.9e1 * t1796 * t5435 - 0.3e1 * t1811 * t1830 - 0.7e1 * t5296 * t5426 - 0.11e2 * t5296 * t5454 + 0.18e2 * t5302 * t5426 - 0.7e1 * t5318 * t5426 - 0.6e1 * t5365 * t5404 + 0.7e1 * t5404 * t5439 + 0.18e2 * t5404 * t5446 - t5422 * t704;
  t5475 = t4577 * t4582 * t1426;
  t5483 = t236 * t584;
  t5484 = t5483 * t580;
  t5488 = t560 * t2671;
  t5489 = t2675 * t4450;
  t5492 = t1429 * t238;
  t5493 = t242 * t580;
  t5494 = t5492 * t5493;
  t5497 = t689 * t1458;
  t5498 = t234 * t5497;
  t5501 = t242 * params->csk_a * t1426 * t584;
  t5504 = t560 * t2631;
  t5506 = t1115 * t580 * t236;
  t5507 = t570 * t5506;
  t5510 = t5332 * t584;
  t5511 = t560 * t5510;
  t5512 = t1484 * t4391;
  t5517 = 0.11e2 * t1115 * t4577 * t5404 * t5405 + 0.9e1 * t1843 * t2670 * t5484 + 0.3e1 * t1447 * t1823 + 0.9e1 * t1807 * t5306 - 0.6e1 * t1814 * t5309 + 0.18e2 * t4392 * t5511 - 0.6e1 * t5318 * t5475 + t5414 * t690 - 0.9e1 * t5488 * t5489 - 0.9e1 * t5488 * t5494 - 0.18e2 * t5498 * t5501 + 0.9e1 * t5504 * t5507 + 0.18e2 * t5511 * t5512;
  t5518 = t1454 * t5510;
  t5522 = t1115 * t1426 * t584;
  t5523 = t242 * t5522;
  t5526 = t234 * t2631;
  t5527 = t580 * params->csk_a;
  t5529 = t242 * t5527 * t236;
  t5535 = t1492 * t1493 * t563;
  t5538 = t1115 * t236;
  t5539 = t5538 * t5493;
  t5543 = t1454 * t2447 * t1458;
  t5549 = t570 * t5522;
  t5552 = t236 * t238;
  t5554 = t560 * t5552 * t565;
  t5555 = t2435 * t580;
  t5560 = t1454 * t5347 * t1458;
  t5564 = t570 * t3298;
  t5577 = -0.6e1 * t5518 * t4392 - 0.6e1 * t5498 * t5523 - 0.9e1 * t5526 * t5529 + 0.9e1 * t5504 * t5529 - 0.12e2 * t5518 * t5535 - 0.3e1 * t2632 * t5539 + 0.9e1 * t5543 * t570 * t3294 * t580 + 0.18e2 * t560 * t5497 * t5549 + 0.9e1 * t5554 * t570 * t5555 + 0.18e2 * t5560 * t1463 * t3298 + 0.18e2 * t5560 * t5564 - 0.18e2 * t5518 * t4403 + 0.9e1 * t234 * t695 * t238 * t565 * t1846 + 0.9e1 * t1843 * t242 * t5484;
  t5580 = t560 * t5368 * t584;
  t5583 = t1463 * t5506;
  t5587 = t1454 * t4384 * t1458;
  t5588 = t3294 * t236;
  t5589 = t1463 * t5588;
  t5601 = t592 * t569 * t1852;
  t5604 = t1492 * t5433;
  t5612 = t575 * t241 * t1467;
  t5614 = t1510 * t1874;
  t5620 = 0.6e1 * t1817 * t4551 * t5364 + t4577 * t5404 * t5405 - 0.9e1 * t1432 * t5580 - 0.9e1 * t1442 * t5580 - 0.3e1 * t1796 * t5604 + 0.3e1 * t1823 * t1856 - 0.9e1 * t1858 * t5614 - 0.9e1 * t2632 * t5507 - 0.6e1 * t2632 * t5583 + 0.9e1 * t5504 * t5539 - 0.3e1 * t5526 * t5539 + 0.9e1 * t5587 * t5589 + 0.3e1 * t5601 * t685 + t5612 * t690;
  t5631 = t4483 * t122;
  t5633 = t5631 * t241 * t1426;
  t5637 = t560 * t1426 * t4466;
  t5653 = my_piecewise3(t115, 0, t5278);
  t5654 = my_piecewise3(t117, t5653, 0);
  t5659 = -t1467 * t234 * t281 * t586 - 0.3e1 * t1852 * t234 * t236 * t586 - 0.3e1 * t234 * t580 * t586 * t695 - t234 * t243 * t5654 + 0.11e2 * t4556 * t5398 * t686 + 0.3e1 * t1423 * t1875 - 0.6e1 * t1863 * t5395 + t4423 * t687 + 0.3e1 * t4468 * t5343 + 0.6e1 * t5312 * t5633 + 0.3e1 * t5401 * t702 + 0.3e1 * t5637 * t687 - 0.3e1 * t1868 - 0.2e1 * t1872;
  t5663 = my_piecewise5(t114, 0, t115, 0, t5320 + t5372 + t5418 + t5465 + t5517 + t5577 + t5620 + t5659);
  t5670 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1389 * t286 + 0.3e1 / 0.1e2 * t5229 + 0.9e1 / 0.2e2 * t7 * t533 * t712 - t5194 / 0.1e2 + 0.3e1 / 0.5e1 * t5236 + 0.9e1 / 0.2e2 * t7 * t216 * t1886 + t5155 - t5205 / 0.1e2 + 0.3e1 / 0.1e2 * t5244 + 0.3e1 / 0.2e2 * t7 * t94 * (t113 * t5663 + t125 * t5278 + t1416 * t284 + t1537 * t278 + 0.3e1 * t1763 * t245 + 0.3e1 * t1884 * t232 + 0.3e1 * t554 * t710 + 0.3e1 * t597 * t680 - t5274));
  tv4rho3sigma11 = t5670 * t8 + 0.3e1 * t1891;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t5677 = t7 * t989 * t303;
  t5683 = t7 * t996 * t303;
  t5686 = t7 * t345 * t754;
  t5693 = 0.2e1 / 0.45e2 * t7 * t1008 * t303;
  t5695 = t7 * t354 * t754;
  t5698 = t7 * t145 * t2012;
  t5726 = t298 * t1040;
  t5727 = t5726 * t403;
  t5728 = t379 * t5727;
  t5731 = t735 * t1072;
  t5732 = t163 * t5731;
  t5737 = t1068 * t5727;
  t5742 = 0.9e1 * t2521 * t4976 + 0.9e1 * t2524 * t5060 + 0.18e2 * t3659 * t5728 - 0.6e1 * t3659 * t5737 + 0.18e2 * t3665 * t5728 - 0.6e1 * t4996 * t5732 - 0.18e2 * t5003 * t5732 + 0.4e1 * t1934 + 0.4e1 * t1938 - 0.4e1 * t1971 + 0.4e1 * t1976 - 0.4e1 * t1978 - t746;
  t5747 = t741 * t380;
  t5748 = t5747 * t403;
  t5752 = t379 * t5748;
  t5774 = t379 * t5731;
  t5777 = 0.9e1 * t1046 * t163 * t5748 + 0.9e1 * t171 * t1975 * t4958 - 0.9e1 * t1046 * t5752 - 0.9e1 * t1063 * t5752 - 0.9e1 * t2499 * t4976 - 0.6e1 * t2499 * t5056 - 0.3e1 * t2499 * t5065 + 0.9e1 * t2511 * t3580 + 0.9e1 * t2518 * t5060 + 0.9e1 * t2521 * t4983 + 0.9e1 * t2521 * t5065 - 0.9e1 * t2527 * t4983 - 0.3e1 * t2527 * t5065 + 0.18e2 * t5036 * t5774;
  t5779 = t2777 * params->csk_a;
  t5780 = t1077 * t5779;
  t5785 = t389 * t5779;
  t5790 = t298 * t3593;
  t5791 = t1068 * t5790;
  t5794 = t379 * t5790;
  t5797 = t163 * t5726;
  t5800 = t163 * t5790;
  t5803 = t1122 * t2743;
  t5806 = t3743 * t1956;
  t5813 = t741 * t1070;
  t5814 = t379 * t5813;
  t5817 = t1068 * t5813;
  t5820 = 0.9e1 * t1596 * t5803 + 0.9e1 * t1602 * t5814 - 0.3e1 * t1602 * t5817 - 0.12e2 * t3704 * t5737 - 0.18e2 * t3724 * t5737 + 0.6e1 * t4770 * t5791 - 0.18e2 * t4770 * t5794 - 0.6e1 * t4796 * t5806 + 0.3e1 * t4807 * t5797 - 0.11e2 * t4811 * t5794 + 0.11e2 * t4811 * t5800 + 0.12e2 * t4830 * t5791 + 0.18e2 * t5011 * t5780 + 0.18e2 * t5011 * t5785;
  t5828 = t3614 * t5790;
  t5837 = t1076 * t741;
  t5839 = t1131 * t5837 * params->csk_a;
  t5842 = t3618 * t298;
  t5844 = t3755 * t5842 * params->csk_a;
  t5848 = t1122 * t732 * t399;
  t5851 = t1983 * t382;
  t5852 = t163 * t5851;
  t5856 = t3748 * t732 * t1115;
  t5863 = -0.3e1 * t1131 * t2299 * t298 * t3696 + 0.9e1 * t1586 * t163 * t5747 + 0.9e1 * t1596 * t5839 + 0.6e1 * t4770 * t5800 + 0.6e1 * t4788 * t5791 - 0.7e1 * t4788 * t5794 + t4788 * t5800 - t4788 * t5828 - 0.6e1 * t4796 * t5844 + 0.7e1 * t4796 * t5856 - 0.6e1 * t4802 * t5791 - 0.12e2 * t4850 * t5806 - 0.9e1 * t4896 * t5848 + 0.3e1 * t5852 * t630;
  t5866 = t379 * t5726;
  t5869 = t1122 * t1932;
  t5874 = t379 * t5851;
  t5881 = t163 * t5813;
  t5884 = t3748 * t1940;
  t5896 = t411 * t1988 * t403;
  t5900 = t1131 * t1955 * t403;
  t5903 = -0.12e2 * t1578 * t403 * t5120 * t736 - 0.3e1 * t1057 * t1926 - 0.9e1 * t1580 * t5881 + 0.9e1 * t1590 * t5896 - 0.9e1 * t1612 * t5817 - 0.6e1 * t1929 * t4839 - 0.3e1 * t4807 * t5866 - 0.3e1 * t4820 * t5866 - 0.18e2 * t4834 * t5869 - 0.6e1 * t4890 * t5900 + 0.7e1 * t4916 * t5884 - 0.11e2 * t4920 * t5794 - 0.3e1 * t5874 * t630;
  t5913 = t3755 * t5842 * t1115;
  t5919 = t3743 * t1955 * t1115;
  t5934 = 0.9e1 * t1580 * t5814 - 0.3e1 * t1602 * t5881 - 0.3e1 * t1616 * t1926 - 0.6e1 * t1619 * t5817 + 0.11e2 * t4796 * t5913 + 0.18e2 * t4796 * t5919 - 0.12e2 * t4830 * t5828 - 0.18e2 * t4850 * t5884 - t4877 * t748 + 0.18e2 * t4881 * t5791 - 0.7e1 * t4881 * t5794 - 0.7e1 * t4881 * t5828 - t4933 * t748 - 0.6e1 * t4945 * t5828;
  t5943 = t1998 * t403;
  t5947 = t379 * t5943;
  t5952 = t1131 * t5837;
  t5955 = t3755 * t5842;
  t5972 = -t1081 * t163 * t298 * t405 - 0.3e1 * t163 * t165 * t1983 * t405 - 0.3e1 * t163 * t399 * t405 * t741 + 0.9e1 * t163 * t2546 * t5943 + 0.3e1 * t1057 * t1960 - 0.3e1 * t1596 * t5952 + 0.9e1 * t1612 * t5814 - 0.6e1 * t1661 * t5881 - 0.9e1 * t2546 * t5947 - 0.9e1 * t2555 * t5947 + t4796 * t5955 + t4877 * t736 + 0.3e1 * t5852 * t640 - 0.3e1 * t5874 * t645;
  t5973 = t3748 * t732;
  t5982 = t1122 * t1988;
  t5985 = t3743 * t1955;
  t5995 = t411 * t388 * t1983;
  t6000 = my_piecewise3(t67, 0, -0.55e2 / 0.81e2 * t52 * t1565);
  t6001 = my_piecewise3(t69, t6000, 0);
  t6006 = -t163 * t172 * t6001 + 0.3e1 * t1037 * t1989 - 0.9e1 * t1664 * t5982 + 0.3e1 * t1672 * t1960 + 0.3e1 * t3590 * t5797 + t3677 * t733 + 0.6e1 * t4850 * t5985 + 0.11e2 * t4916 * t5973 + t5117 * t736 + 0.6e1 * t5121 * t5800 + 0.3e1 * t5125 * t733 + 0.3e1 * t5995 * t623 - 0.3e1 * t1996 - 0.2e1 * t2000;
  t6010 = my_piecewise5(t64, 0, t67, 0, t5742 + t5777 + t5820 + t5863 + t5903 + t5934 + t5972 + t6006);
  t6017 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t985 * t303 + 0.3e1 / 0.1e2 * t5677 + 0.9e1 / 0.2e2 * t7 * t341 * t754 - t5683 / 0.1e2 + 0.3e1 / 0.5e1 * t5686 + 0.9e1 / 0.2e2 * t7 * t140 * t2012 + t5693 - t5695 / 0.1e2 + 0.3e1 / 0.1e2 * t5698 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.55e2 / 0.81e2 * t52 * t1565 * t77 + 0.5e1 / 0.9e1 * t52 * t615 * t174 - 0.5e1 / 0.24e2 * t52 * t257 * t416 + t52 * t291 * t1152 / 0.24e2 + t1030 * t301 + 0.3e1 * t373 * t752 + 0.3e1 * t161 * t2010 + t59 * t6010));
  tv4rho3lapl0 = t6017 * t8 + 0.3e1 * t2017;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t6024 = t7 * t1180 * t320;
  t6027 = t7 * t1184 * t320;
  t6031 = 0.2e1 / 0.45e2 * t7 * t1188 * t320;
  t6033 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1176 * t320 + 0.3e1 / 0.1e2 * t6024 - t6027 / 0.1e2 + t6031);
  tv4rho3lapl1 = t6033 * t8 + 0.3e1 * t2030;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  t6035 = 0.2e1 * t2044;
  t6041 = t7 * t1218 * t303 / 0.5e1;
  t6046 = t7 * t1225 * t303;
  t6050 = t7 * t465 * t754 / 0.5e1;
  t6059 = 0.3e1 / 0.2e2 * t7 * t1214 * t303 + t6041 + 0.3e1 / 0.1e2 * t7 * t461 * t754 - t6046 / 0.3e2 + t6050 + 0.3e1 / 0.2e2 * t7 * t205 * t2012 + t5677 / 0.1e2 - t5683 / 0.15e2 + t5686 / 0.5e1 + t5693 - t5695 / 0.15e2 + t5698 / 0.1e2;
  t6060 = my_piecewise3(t2, 0, t6059);
  tv4rho3lapl2 = t6060 * t8 + t2017 + t6035;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  t6062 = 0.2e1 * t2060;
  t6068 = t7 * t1261 * t320 / 0.5e1;
  t6070 = t7 * t1265 * t320;
  t6079 = t7 * t440 * t808 / 0.5e1;
  t6081 = t7 * t444 * t808;
  t6084 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1257 * t320 + t6068 - t6070 / 0.3e2 + t6024 / 0.1e2 - t6027 / 0.15e2 + t6031 + 0.3e1 / 0.2e2 * t7 * t436 * t808 + t6079 - t6081 / 0.3e2);
  tv4rho3lapl3 = t6084 * t8 + t2030 + t6062;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  t6090 = t7 * t1302 * t303;
  t6099 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1298 * t303 + t6090 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t516 * t754 + t6041 - t6046 / 0.15e2 + t6050 - t5683 / 0.3e2 + t5693 - t5695 / 0.3e2);
  tv4rho3lapl4 = t6099 * t8 + t2068 + t6035;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  t6105 = t7 * t1332 * t320;
  t6112 = t7 * t489 * t808;
  t6120 = t7 * t192 * t2182;
  t6122 = 0.3e1 / 0.2e2 * t7 * t1328 * t320 + t6105 / 0.1e2 + t6068 - t6070 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t485 * t808 + t6112 / 0.5e1 - t6027 / 0.3e2 + t6031 + t6079 - t6081 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t188 * t2182 + t6120 / 0.1e2;
  t6123 = my_piecewise3(t84, 0, t6122);
  tv4rho3lapl5 = t6123 * t8 + t2187 + t6062;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  t6132 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1369 * t303 + 0.3e1 / 0.1e2 * t6090 - t6046 / 0.1e2 + t5693);
  tv4rho3lapl6 = t6132 * t8 + 0.3e1 * t2068;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  t6171 = t4551 * t2120;
  t6174 = t315 * t1426;
  t6175 = t234 * t6174;
  t6178 = t315 * t4481;
  t6179 = t234 * t6178;
  t6182 = t1510 * t2102;
  t6187 = t560 * t6174;
  t6192 = -0.3e1 * t5335 * t6187 + 0.11e2 * t5338 * t6179 + 0.3e1 * t5344 * t6175 - 0.3e1 * t5344 * t6187 - 0.18e2 * t5348 * t6182 - 0.12e2 * t5353 * t6175 - 0.12e2 * t5364 * t6171 + 0.4e1 * t2104 + 0.4e1 * t2108 - 0.4e1 * t2141 + 0.4e1 * t2146 - 0.4e1 * t2148 - t800;
  t6193 = t560 * t6178;
  t6196 = t4501 * t6178;
  t6200 = t1454 * t6178;
  t6203 = t1510 * t2866;
  t6212 = t795 * t1456;
  t6213 = t560 * t6212;
  t6216 = t1454 * t6212;
  t6222 = t4505 * t315;
  t6224 = t4577 * t6222 * params->csk_a;
  t6229 = 0.9e1 * t1775 * t6213 + 0.9e1 * t1793 * t6213 - 0.3e1 * t1793 * t6216 + 0.9e1 * t1796 * t6203 + 0.6e1 * t5299 * t6179 - 0.18e2 * t5299 * t6193 + 0.6e1 * t5299 * t6200 + t5315 * t6179 - 0.7e1 * t5315 * t6193 - t5315 * t6196 + 0.6e1 * t5315 * t6200 - 0.11e2 * t5338 * t6193 - 0.6e1 * t5404 * t6171 - 0.6e1 * t5404 * t6224;
  t6231 = t4556 * t2110;
  t6234 = t2153 * t563;
  t6235 = t560 * t6234;
  t6243 = t592 * t2165 * t584;
  t6247 = t1510 * t786 * t580;
  t6254 = t234 * t6234;
  t6258 = t4556 * t786 * t1115;
  t6263 = t6174 * t584;
  t6264 = t560 * t6263;
  t6267 = t1454 * t6263;
  t6270 = t789 * t1458;
  t6271 = t234 * t6270;
  t6276 = -0.3e1 * t1492 * t2448 * t315 * t4528 - 0.3e1 * t1447 * t2096 + 0.9e1 * t1779 * t6243 - 0.9e1 * t1807 * t6216 + 0.9e1 * t2638 * t5587 - 0.9e1 * t2641 * t5529 + 0.18e2 * t4392 * t6264 - 0.6e1 * t4392 * t6267 - 0.18e2 * t5364 * t6231 - 0.9e1 * t5374 * t6247 + 0.7e1 * t5404 * t6258 - 0.6e1 * t5523 * t6271 - 0.3e1 * t6235 * t692 + 0.3e1 * t6254 * t692;
  t6279 = t795 * t561;
  t6280 = t6279 * t584;
  t6284 = t560 * t6280;
  t6291 = t2160 * t584;
  t6292 = t234 * t6291;
  t6311 = 0.9e1 * t1432 * t234 * t6280 - 0.9e1 * t1432 * t6284 + 0.9e1 * t2365 * t6292 - 0.9e1 * t2620 * t5507 - 0.3e1 * t2620 * t5539 - 0.6e1 * t2620 * t5583 + 0.9e1 * t2635 * t5587 - 0.3e1 * t2641 * t5539 + 0.9e1 * t2645 * t5507 + 0.9e1 * t2645 * t5529 + 0.9e1 * t2645 * t5539 - 0.18e2 * t5501 * t6271 + 0.18e2 * t5512 * t6264 - 0.12e2 * t5535 * t6267;
  t6314 = t560 * t6270;
  t6317 = t2880 * params->csk_a;
  t6318 = t1463 * t6317;
  t6321 = t570 * t6317;
  t6328 = t570 * t6291;
  t6341 = t4577 * t6222 * t1115;
  t6346 = -0.9e1 * t1442 * t6284 + 0.3e1 * t1447 * t2124 - 0.3e1 * t1811 * t2096 - 0.6e1 * t1814 * t6216 - 0.18e2 * t4403 * t6267 + 0.11e2 * t5404 * t6341 - t5414 * t802 - 0.7e1 * t5426 * t6196 + 0.18e2 * t5549 * t6314 + 0.9e1 * t5554 * t6328 + 0.18e2 * t5560 * t6318 + 0.18e2 * t5560 * t6321 - 0.3e1 * t6235 * t707;
  t6350 = t4551 * t2119 * t1115;
  t6353 = t234 * t6212;
  t6366 = t1462 * t795;
  t6368 = t1492 * t6366 * params->csk_a;
  t6379 = t1492 * t2119 * t584;
  t6384 = 0.9e1 * t1787 * t234 * t6279 - 0.9e1 * t1775 * t6353 - 0.3e1 * t1793 * t6353 + 0.9e1 * t1796 * t6368 + 0.9e1 * t1807 * t6213 - 0.6e1 * t2099 * t5462 - 0.12e2 * t5325 * t6196 - 0.6e1 * t5358 * t6379 - 0.6e1 * t5364 * t6350 + 0.7e1 * t5398 * t6231 + 0.18e2 * t5404 * t6350 - 0.7e1 * t5426 * t6193 + 0.18e2 * t5426 * t6200 - 0.11e2 * t5454 * t6193;
  t6394 = t560 * t6291;
  t6411 = t592 * t569 * t2153;
  t6414 = -t1467 * t234 * t315 * t586 + 0.3e1 * t1423 * t2166 + 0.3e1 * t1856 * t2124 - 0.6e1 * t1863 * t6353 + 0.9e1 * t2667 * t6292 - 0.9e1 * t2667 * t6394 - 0.9e1 * t2676 * t6394 + t4423 * t787 + 0.12e2 * t5325 * t6200 + t5414 * t790 - t5422 * t802 - 0.6e1 * t5475 * t6196 + t5612 * t790 + 0.3e1 * t6411 * t685;
  t6415 = t1492 * t6366;
  t6418 = t4577 * t6222;
  t6434 = t4556 * t786;
  t6437 = t1510 * t2165;
  t6440 = t4551 * t2119;
  t6447 = my_piecewise3(t115, 0, -0.55e2 / 0.81e2 * t52 * t1760);
  t6448 = my_piecewise3(t117, t6447, 0);
  t6453 = -0.3e1 * t2153 * t234 * t236 * t586 - 0.3e1 * t234 * t580 * t586 * t795 - t234 * t243 * t6448 - 0.3e1 * t1796 * t6415 - 0.9e1 * t1858 * t6437 + 0.3e1 * t4468 * t6175 + 0.6e1 * t5364 * t6440 + 0.11e2 * t5398 * t6434 + t5404 * t6418 + 0.6e1 * t5633 * t6179 + 0.3e1 * t5637 * t787 + 0.3e1 * t6254 * t702 - 0.3e1 * t2158 - 0.2e1 * t2162;
  t6457 = my_piecewise5(t114, 0, t115, 0, t6192 + t6229 + t6276 + t6311 + t6346 + t6384 + t6414 + t6453);
  t6464 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t1389 * t320 + 0.3e1 / 0.1e2 * t6105 + 0.9e1 / 0.2e2 * t7 * t533 * t808 - t6070 / 0.1e2 + 0.3e1 / 0.5e1 * t6112 + 0.9e1 / 0.2e2 * t7 * t216 * t2182 + t6031 - t6081 / 0.1e2 + 0.3e1 / 0.1e2 * t6120 + 0.3e1 / 0.2e2 * t7 * t94 * (-0.55e2 / 0.81e2 * t52 * t1760 * t125 + 0.5e1 / 0.9e1 * t52 * t677 * t245 - 0.5e1 / 0.24e2 * t52 * t275 * t597 + t52 * t308 * t1537 / 0.24e2 + t1416 * t318 + 0.3e1 * t554 * t806 + 0.3e1 * t232 * t2180 + t113 * t6457));
  tv4rho3lapl7 = t6464 * t8 + 0.3e1 * t2187;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  tv4rho3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  tv4rho3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  tv4rho3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  tv4rho3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  tv4rho3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  tv4rho3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  tv4rho3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t6471 = t7 * t345 * t836;
  t6478 = t7 * t354 * t836 / 0.3e2;
  t6480 = t7 * t145 * t2314;
  t6491 = 0.2e1 * t2220;
  t6492 = 0.2e1 * t2222;
  t6493 = 0.2e1 * t2229;
  t6500 = t1578 * t1660 * t382;
  t6503 = t817 * t3593;
  t6504 = t379 * t6503;
  t6506 = t380 * t74 * t170;
  t6507 = t3860 * t6506;
  t6510 = t1068 * t6503;
  t6514 = t3595 * params->csk_a * t6506;
  t6517 = t824 * t1070;
  t6518 = t163 * t6517;
  t6520 = 0.3e1 * t6518 * t1580;
  t6521 = t379 * t6517;
  t6523 = 0.3e1 * t6521 * t1580;
  t6524 = t817 * t3588;
  t6525 = t379 * t6524;
  t6526 = t1043 * t6506;
  t6529 = t3743 * t1618;
  t6532 = -0.12e2 * t2231 * t6500 - 0.18e2 * t6504 * t6507 - 0.11e2 * t6504 * t6514 + 0.6e1 * t6507 * t6510 - 0.6e1 * t6510 * t6529 - 0.3e1 * t6525 * t6526 + 0.4e1 * t2234 + 0.4e1 * t2251 - 0.4e1 * t2268 + 0.4e1 * t2274 - 0.4e1 * t2278 + t6491 - t6492 - t6493 - t6520 + t6523;
  t6533 = t412 * t380;
  t6534 = t3748 * t6533;
  t6537 = t163 * t6503;
  t6540 = t3614 * t6503;
  t6542 = t3748 * t1136 * t380;
  t6546 = t3743 * t3760 * t380;
  t6549 = t380 * t3593;
  t6550 = t1068 * t6549;
  t6552 = t3743 * t2300 * params->csk_a;
  t6555 = t817 * t380;
  t6561 = t411 * t6533;
  t6565 = t3748 * t3750 * t380;
  t6585 = t3614 * t6549;
  t6586 = t3618 * t817;
  t6591 = -0.18e2 * t6510 * t6534 + 0.6e1 * t6537 * t6507 + 0.7e1 * t6540 * t6542 - 0.12e2 * t6540 * t6546 - 0.12e2 * t6550 * t6552 + 0.3e1 * t163 * t6555 * t4807 + 0.11e2 * t6537 * t6514 - 0.3e1 * t6525 * t6561 - 0.7e1 * t6504 * t6565 + 0.3e1 * t2209 * t3643 + 0.18e2 * t6510 * t6565 - t2201 * t3643 - 0.7e1 * t6540 * t6565 + 0.3e1 * t2209 * t3673 - 0.12e2 * t4896 * t1122 * t624 * t633 - 0.4e1 * t2299 * t1131 * t1633 * t633 - 0.6e1 * t6585 * t3755 * t6586 * params->csk_a;
  t6594 = t1131 * t1146 * t399;
  t6602 = t3755 * t3766 * t380;
  t6605 = t1076 * t824;
  t6607 = t1131 * t6605 * params->csk_a;
  t6609 = 0.3e1 * t1596 * t6607;
  t6610 = t824 * t380;
  t6613 = 0.3e1 * t163 * t6610 * t1586;
  t6615 = t1043 * t171 * t1657;
  t6621 = t411 * t412 * t1657;
  t6628 = t2221 * t1616;
  t6629 = t1068 * t6517;
  t6631 = 0.2e1 * t6629 * t1619;
  t6634 = t388 * t817;
  t6636 = t1122 * t6634 * t403;
  t6639 = t2219 * t1057;
  t6641 = 0.3e1 * t6521 * t1612;
  t6642 = 0.11e2 * t1115 * t3755 * t6585 * t6586 - 0.3e1 * t2201 * t3719 - 0.2e1 * t2201 * t6594 + 0.3e1 * t2209 * t3719 + 0.3e1 * t2231 * t5044 + 0.3e1 * t2247 * t3710 - 0.18e2 * t409 * t6636 - 0.2e1 * t642 * t6615 - 0.2e1 * t642 * t6621 - 0.6e1 * t6540 * t6602 + t6609 + t6613 - t6628 - t6631 + t6639 + t6641;
  t6643 = t2221 * t1057;
  t6645 = 0.3e1 * t6629 * t1612;
  t6648 = t379 * t6549;
  t6649 = t6634 * params->csk_a;
  t6650 = t3748 * t6649;
  t6658 = t3748 * t3070;
  t6663 = t1122 * t3097;
  t6665 = 0.3e1 * t1596 * t6663;
  t6669 = t3830 * t4786 * t380;
  t6676 = t6518 * t1602;
  t6678 = 0.3e1 * t6521 * t1602;
  t6679 = 0.3e1 * t2201 * t3680 - t2205 * t3643 - 0.3e1 * t2205 * t3673 + 0.2e1 * t628 * t6615 - 0.7e1 * t6504 * t6669 + 0.6e1 * t6510 * t6669 + 0.18e2 * t6529 * t6540 + t6537 * t6669 - t6540 * t6669 - 0.6e1 * t6552 * t6585 + 0.7e1 * t6648 * t6650 - 0.11e2 * t6648 * t6658 - t6643 - t6645 + t6665 - t6676 + t6678;
  t6682 = t6629 * t1602;
  t6686 = t1578 * t2289 * t165;
  t6689 = t1068 * t392;
  t6695 = t411 * t2280 * t403;
  t6697 = 0.3e1 * t1590 * t6695;
  t6700 = t820 * t1072;
  t6701 = t1068 * t6700;
  t6702 = t1115 * t380;
  t6703 = t6702 * t403;
  t6704 = t1077 * t6703;
  t6709 = t163 * t6700;
  t6710 = t171 * t6703;
  t6713 = t379 * t6700;
  t6722 = t2266 * t2236;
  t6725 = t6610 * t403;
  t6728 = 0.3e1 * t163 * t6725 * t1046;
  t6729 = t379 * t6725;
  t6731 = 0.3e1 * t6729 * t1046;
  t6732 = -0.6e1 * t1131 * t2300 * t403 * t6689 - 0.8e1 * t1577 * t6686 - 0.18e2 * t1651 * t6709 + 0.18e2 * t1651 * t6713 + 0.3e1 * t2201 * t3698 + 0.18e2 * t3581 * t6701 + 0.12e2 * t4973 * t6722 + 0.12e2 * t6510 * t6546 - 0.12e2 * t6701 * t6704 - 0.6e1 * t6701 * t6710 - 0.6e1 * t6709 * t6710 + 0.18e2 * t6710 * t6713 - t6682 + t6697 + t6728 - t6731;
  t6736 = 0.3e1 * t6729 * t1063;
  t6739 = t1115 * t386 * t1675 * t165;
  t6744 = t389 * t6703;
  t6747 = t389 * t4964;
  t6750 = t392 * t1072;
  t6751 = t1068 * t6750;
  t6752 = t1077 * t3063;
  t6757 = params->csk_a * t399;
  t6758 = t6757 * t1045;
  t6766 = t1115 * t165;
  t6767 = t6766 * t2236;
  t6772 = t2286 * t633;
  t6776 = t2286 * t384;
  t6777 = t163 * t6776;
  t6782 = t633 * params->csk_a;
  t6783 = t6782 * t165;
  t6790 = t1077 * t6766 * t633;
  t6793 = -0.12e2 * t5039 * t6722 - t6736 - 0.12e2 * t2515 * t6739 + 0.3e1 * t2271 * t3575 + 0.18e2 * t6713 * t6744 - 0.3e1 * t2265 * t6747 + 0.18e2 * t6751 * t6752 + 0.12e2 * t4973 * t6739 - 0.3e1 * t2265 * t6758 - 0.18e2 * t1068 * t2230 * t1072 * t6702 * t3723 + 0.12e2 * t4973 * t6767 - 0.4e1 * t2515 * t6767 + 0.12e2 * t5019 * t389 * t6772 + 0.12e2 * t6777 * t171 * t1681 * t167 + 0.12e2 * t2515 * t1077 * t6783 - 0.4e1 * t5039 * t6767 - 0.8e1 * t2515 * t6790;
  t6798 = t379 * t6776;
  t6799 = t389 * t633;
  t6803 = t2236 * t2276;
  t6808 = t1131 * t6605;
  t6809 = t1596 * t6808;
  t6810 = t633 * t633;
  t6811 = t6810 * t382;
  t6819 = 0.2e1 * t6518 * t1661;
  t6821 = t394 * t1660;
  t6824 = t3830 * t1660;
  t6830 = t1122 * t2280;
  t6832 = 0.3e1 * t1664 * t6830;
  t6833 = t379 * t6811;
  t6838 = t1578 * t1671;
  t6846 = 0.12e2 * t2515 * t389 * t6783 - 0.12e2 * t6798 * t6799 * t2276 + 0.12e2 * t6777 * t6803 - 0.12e2 * t6798 * t6803 - t6809 + 0.2e1 * t163 * t6811 * t396 + 0.3e1 * t379 * t6555 * t3601 - t6819 + 0.3e1 * t163 * t6524 * t6821 + 0.6e1 * t6537 * t6824 + 0.6e1 * t6550 * t3743 * t2300 - t6832 - 0.2e1 * t6833 * t396 - 0.2e1 * t6833 * t413 - 0.2e1 * t2205 * t6838 + 0.11e2 * t6648 * t3748 * t6634 - 0.3e1 * t2209 * t3793;
  t6849 = t163 * t824 * t399 * t405;
  t6850 = t170 * t1657;
  t6854 = t394 * t6850;
  t6862 = t2219 * t1672;
  t6863 = t1037 * t2281;
  t6864 = t163 * t6810;
  t6872 = 0.2e1 * t2282;
  t6873 = 0.3e1 * t2285;
  t6875 = 0.2e1 * t2303;
  t6876 = -0.2e1 * t2287 * t2288 * t6850 + t3755 * t6585 * t6586 + 0.2e1 * t379 * t390 * t6810 - t2301 * t3650 - 0.2e1 * t405 * t6864 + 0.2e1 * t407 * t6864 + 0.2e1 * t5083 * t642 + 0.2e1 * t628 * t6854 - 0.4e1 * t2291 - t6849 + t6862 + t6863 + t6872 - t6873 + t6875 - t826 - t828;
  t6880 = my_piecewise5(t64, 0, t67, 0, t6532 + t6591 + t6642 + t6679 + t6732 + t6793 + t6846 + t6876);
  t6887 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t836 + t6471 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t2314 - t6478 + t6480 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (0.2e1 * t1568 * t266 + 0.2e1 * t161 * t2312 + 0.2e1 * t1689 * t260 + t373 * t834 + t59 * t6880 + 0.4e1 * t618 * t648));
  tv4rho2sigma20 = t6887 * t8 + 0.2e1 * t2319;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t6894 = t7 * t440 * t862;
  t6898 = t7 * t444 * t862 / 0.3e2;
  t6900 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t862 + t6894 / 0.5e1 - t6898);
  tv4rho2sigma25 = t6900 * t8 + 0.2e1 * t2328;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t6906 = t7 * t465 * t836;
  t6914 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t836 + t6906 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t2314 + t6471 / 0.1e2 - t6478 + t6480 / 0.1e2);
  tv4rho2sigma26 = t6914 * t8 + t2319 + t2334;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t6920 = t7 * t489 * t862;
  t6927 = t7 * t192 * t2459;
  t6930 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t862 + t6920 / 0.1e2 + t6894 / 0.1e2 - t6898 + 0.3e1 / 0.2e2 * t7 * t188 * t2459 + t6927 / 0.1e2);
  tv4rho2sigma211 = t6930 * t8 + t2328 + t2464;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t6938 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t836 + t6906 / 0.5e1 - t6478);
  tv4rho2sigma212 = t6938 * t8 + 0.2e1 * t2334;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t6958 = 0.2e1 * t2361;
  t6961 = 0.2e1 * t2389;
  t6962 = 0.2e1 * t2390;
  t6966 = t846 * t1458;
  t6967 = t1454 * t6966;
  t6968 = t1115 * t567;
  t6969 = t569 * t561;
  t6971 = t6968 * t6969 * t584;
  t6974 = t850 * t238;
  t6976 = t560 * t6974 * t565;
  t6977 = t570 * t1845;
  t6979 = 0.3e1 * t6976 * t6977;
  t6981 = t2438 * t236;
  t6982 = params->csk_a * t122 * t6981;
  t6985 = t1115 * t561;
  t6986 = t6985 * t584;
  t6987 = t1463 * t6986;
  t6990 = t1463 * t1845;
  t6995 = t560 * t6966;
  t6998 = t3294 * t695;
  t7002 = 0.12e2 * t5543 * t570 * t6998 + 0.12e2 * t5504 * t6982 - 0.12e2 * t5526 * t6982 - 0.18e2 * t6967 * t6971 - 0.12e2 * t6967 * t6987 + 0.18e2 * t6967 * t6990 + 0.18e2 * t6971 * t6995 + 0.4e1 * t2366 + 0.4e1 * t2375 - 0.4e1 * t2413 + 0.4e1 * t2419 - 0.4e1 * t2423 - t6958 + t6961 - t6962 - t6979;
  t7003 = t5483 * t695;
  t7013 = t2372 * t695;
  t7014 = t6968 * t7013;
  t7021 = t1115 * t695 * t236;
  t7022 = t1463 * t7021;
  t7028 = t850 * t561 * t584;
  t7031 = 0.3e1 * t234 * t7028 * t1432;
  t7034 = 0.3e1 * t560 * t7028 * t1432;
  t7037 = t242 * t7021;
  t7042 = t2362 * t1458;
  t7045 = t242 * t573 * params->csk_a;
  t7054 = t242 * t6986;
  t7061 = 0.12e2 * t234 * t242 * t2435 * t5552 * t565 * t695 + 0.12e2 * t1463 * t5543 * t6998 - 0.6e1 * t234 * t6966 * t7054 - 0.18e2 * t234 * t7042 * t7045 + 0.12e2 * t2626 * t570 * t7003 + 0.18e2 * t560 * t7042 * t7045 - 0.12e2 * t2632 * t7014 - 0.8e1 * t2632 * t7022 - 0.4e1 * t2632 * t7037 + 0.12e2 * t5504 * t7014 + 0.12e2 * t5504 * t7037 - 0.4e1 * t5526 * t7037 + 0.18e2 * t6967 * t6977 - 0.6e1 * t6967 * t7054 + 0.18e2 * t6995 * t7054 + t7031 - t7034;
  t7063 = t843 * t4481;
  t7064 = t4501 * t7063;
  t7066 = t4556 * t1525 * t561;
  t7069 = t850 * t1456;
  t7070 = t1454 * t7069;
  t7072 = 0.3e1 * t7070 * t1807;
  t7073 = t4649 * t1806;
  t7076 = t234 * t7069;
  t7078 = 0.3e1 * t7076 * t1775;
  t7079 = t560 * t7069;
  t7081 = 0.3e1 * t7079 * t1775;
  t7082 = t234 * t7063;
  t7083 = t5631 * t1774;
  t7086 = t560 * t7063;
  t7090 = t1773 * t1862 * t563;
  t7093 = t1454 * t7063;
  t7094 = t4551 * t1813;
  t7098 = t4551 * t1521 * t561;
  t7103 = t561 * t4481;
  t7104 = t4501 * t7103;
  t7105 = t4505 * t843;
  t7110 = t241 * t3749;
  t7112 = t5631 * t7110 * t561;
  t7119 = -0.6e1 * t4577 * t7104 * t7105 * params->csk_a - 0.12e2 * t2363 * t7090 + 0.7e1 * t7064 * t7066 - 0.7e1 * t7064 * t7073 - t7064 * t7112 - 0.11e2 * t7066 * t7086 + 0.11e2 * t7082 * t7083 + t7082 * t7112 - 0.11e2 * t7083 * t7086 - 0.7e1 * t7086 * t7112 - 0.6e1 * t7093 * t7094 - 0.12e2 * t7093 * t7098 + 0.6e1 * t7093 * t7112 - t7072 - t7078 + t7081;
  t7120 = t7076 * t1793;
  t7122 = 0.3e1 * t7079 * t1793;
  t7123 = t7070 * t1793;
  t7125 = t4551 * t4658 * t561;
  t7131 = 0.3e1 * t7079 * t1807;
  t7132 = t6969 * params->csk_a;
  t7133 = t4556 * t7132;
  t7137 = t4551 * t2449 * params->csk_a;
  t7140 = t1510 * t3164;
  t7142 = 0.3e1 * t1796 * t7140;
  t7147 = 0.3e1 * t234 * t6974 * t4441;
  t7148 = t1454 * t573;
  t7157 = t575 * t576 * t1852;
  t7162 = t2360 * t1811;
  t7163 = t1462 * t850;
  t7165 = t1492 * t7163 * params->csk_a;
  t7167 = 0.3e1 * t1796 * t7165;
  t7168 = -0.6e1 * t1492 * t2449 * t584 * t7148 - 0.12e2 * t1510 * t1801 * t7013 + 0.3e1 * t2354 * t4525 + 0.2e1 * t690 * t7157 - 0.7e1 * t7073 * t7086 + 0.18e2 * t7073 * t7093 + 0.12e2 * t7093 * t7125 - 0.18e2 * t7093 * t7133 - 0.6e1 * t7104 * t7137 - t7120 + t7122 - t7123 + t7131 + t7142 + t7147 - t7162 + t7167;
  t7172 = 0.2e1 * t7070 * t1814;
  t7175 = t4551 * t3167;
  t7181 = t592 * t593 * t1852;
  t7191 = t4577 * t4582 * t561;
  t7196 = t4645 * t1792;
  t7201 = t2360 * t1447;
  t7209 = 0.11e2 * t1115 * t4577 * t7104 * t7105 - t2345 * t4381 - 0.2e1 * t2345 * t4415 - 0.3e1 * t2345 * t4525 + 0.3e1 * t2345 * t4530 + 0.3e1 * t2354 * t4381 + 0.3e1 * t2354 * t4411 - 0.3e1 * t2380 * t4411 - 0.2e1 * t704 * t7181 - 0.12e2 * t7064 * t7125 - 0.6e1 * t7064 * t7191 - 0.18e2 * t7086 * t7196 + 0.6e1 * t7093 * t7196 + 0.18e2 * t7104 * t7175 - t7172 - t7201;
  t7210 = t2388 * t1447;
  t7219 = t592 * t2452 * t584;
  t7221 = 0.3e1 * t1779 * t7219;
  t7223 = t575 * t1855 * t238;
  t7226 = t569 * t843;
  t7227 = t7226 * t584;
  t7228 = t1510 * t7227;
  t7231 = t1773 * t6981;
  t7240 = t843 * t4466;
  t7241 = t560 * t7240;
  t7242 = t592 * t7132;
  t7245 = t1429 * t1792;
  t7248 = t843 * t561;
  t7258 = t7210 - 0.4e1 * t2448 * t1492 * t1817 * t695 + 0.3e1 * t2345 * t4426 - t2380 * t4381 + t7221 + 0.3e1 * t2363 * t7223 - 0.18e2 * t590 * t7228 - 0.8e1 * t1772 * t7231 + 0.7e1 * t7086 * t7133 - 0.2e1 * t704 * t7157 + 0.3e1 * t2371 * t4521 - 0.3e1 * t7241 * t7242 - 0.3e1 * t7241 * t7245 + 0.3e1 * t234 * t7248 * t5344 + 0.6e1 * t7082 * t7196 + 0.3e1 * t2416 * t4458 - 0.3e1 * t2410 * t4451;
  t7260 = t5527 * t1431;
  t7263 = t5334 * t7003;
  t7266 = t2670 * t7003;
  t7273 = t1423 * t2453;
  t7274 = t2388 * t1856;
  t7275 = t1510 * t2452;
  t7277 = 0.3e1 * t1858 * t7275;
  t7280 = t560 * t7103;
  t7285 = t575 * t1862;
  t7288 = t5631 * t1862;
  t7291 = t1492 * t7163;
  t7292 = t1796 * t7291;
  t7295 = t1454 * t7103;
  t7301 = t234 * t850 * t580 * t586;
  t7302 = t241 * t1852;
  t7306 = -0.3e1 * t2410 * t7260 - 0.12e2 * t2626 * t7263 - 0.12e2 * t2626 * t7266 + 0.12e2 * t1843 * t7266 + t7104 * t4577 * t7105 + t7273 + t7274 - t7277 - 0.2e1 * t2380 * t4601 + 0.11e2 * t7280 * t4556 * t7226 + 0.3e1 * t234 * t7240 * t7285 + 0.6e1 * t7082 * t7288 - t7292 - 0.3e1 * t2354 * t4563 + 0.6e1 * t7295 * t4551 * t2449 - t7301 - 0.2e1 * t2436 * t2437 * t7302;
  t7307 = t575 * t7302;
  t7313 = t695 * t695;
  t7314 = t7313 * t563;
  t7315 = t560 * t7314;
  t7327 = 0.2e1 * t7076 * t1863;
  t7328 = t234 * t7313;
  t7336 = 0.2e1 * t2425;
  t7337 = 0.3e1 * t2434;
  t7339 = 0.2e1 * t2454;
  t7340 = 0.2e1 * t234 * t577 * t7314 + 0.3e1 * t4493 * t560 * t7248 + 0.2e1 * t560 * t571 * t7313 - t2450 * t4429 + 0.2e1 * t5601 * t704 - 0.2e1 * t577 * t7315 - 0.2e1 * t586 * t7328 + 0.2e1 * t588 * t7328 - 0.2e1 * t594 * t7315 + 0.2e1 * t690 * t7307 - 0.4e1 * t2440 - t7327 + t7336 - t7337 + t7339 - t852 - t854;
  t7344 = my_piecewise5(t114, 0, t115, 0, t7002 + t7061 + t7119 + t7168 + t7209 + t7258 + t7306 + t7340);
  t7351 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t862 + t6920 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t2459 - t6898 + t6927 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * (t113 * t7344 + 0.2e1 * t1763 * t284 + 0.2e1 * t1884 * t278 + 0.2e1 * t232 * t2457 + t554 * t860 + 0.4e1 * t680 * t710));
  tv4rho2sigma217 = t7351 * t8 + 0.2e1 * t2464;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t7358 = t7 * t345 * t888;
  t7365 = t7 * t354 * t888 / 0.3e2;
  t7367 = t7 * t145 * t2572;
  t7390 = t5790 * t3595;
  t7391 = t1068 * t7390;
  t7392 = t6702 * t2534;
  t7395 = t163 * t7390;
  t7398 = t6549 * t3595;
  t7399 = t3614 * t7398;
  t7400 = t875 * params->csk_a;
  t7401 = t1077 * t7400;
  t7404 = t2500 * t380;
  t7409 = t379 * t875 * t3588;
  t7412 = t379 * t7390;
  t7413 = t1649 * t2534;
  t7422 = t3749 * t263;
  t7423 = t7422 * t1611;
  t7426 = t7422 * t380;
  t7427 = t1077 * t7426;
  t7432 = 0.3e1 * t163 * t1936 * t3588 * t873 - 0.6e1 * t1077 * t7391 * t7404 - 0.3e1 * t6526 * t7409 + 0.6e1 * t7391 * t7392 + 0.18e2 * t7391 * t7423 + 0.12e2 * t7391 * t7427 + 0.6e1 * t7392 * t7395 + 0.11e2 * t7395 * t7413 - 0.6e1 * t7399 * t7401 - 0.11e2 * t7412 * t7413 - 0.7e1 * t7412 * t7423 + 0.4e1 * t2512 + 0.4e1 * t2542 - 0.4e1 * t2547 + 0.4e1 * t2552 - 0.4e1 * t2556 + t6491 - t6492 - t6493;
  t7433 = t171 * t7426;
  t7439 = t3614 * t7390;
  t7445 = t1068 * t7398;
  t7448 = t5813 * t1072;
  t7449 = t163 * t7448;
  t7454 = t379 * t7448;
  t7464 = t3614 * t4766 * t3595;
  t7465 = t298 * t1115;
  t7470 = t1068 * t7448;
  t7482 = t2558 * t403;
  t7483 = t389 * t7482;
  t7486 = t7395 * t7433 - 0.7e1 * t7412 * t7433 + 0.6e1 * t7391 * t7433 - t7439 * t7433 - 0.18e2 * t7412 * t7392 + 0.6e1 * t2521 * t6739 - 0.12e2 * t7445 * t7401 - 0.2e1 * t7449 * t2528 - 0.2e1 * t2527 * t6767 + 0.6e1 * t7454 * t2528 - 0.3e1 * t7409 * t6561 - 0.12e2 * t2541 * t6500 - 0.7e1 * t7439 * t7423 + 0.7e1 * t7464 * t389 * t7465 * t380 - 0.2e1 * t7470 * t2528 + 0.6e1 * t2521 * t6767 - 0.2e1 * t2499 * t6767 + 0.6e1 * t7454 * t2502 - 0.6e1 * t7399 * t3619 * t7400 + 0.6e1 * t5019 * t7483;
  t7488 = t741 * params->csk_a;
  t7489 = t7488 * t263;
  t7490 = t389 * t7489;
  t7495 = t2516 * t633;
  t7496 = t389 * t7495;
  t7501 = t1077 * t7489;
  t7517 = t6757 * t2534;
  t7520 = t389 * t7400;
  t7540 = t2561 * t403;
  t7541 = t389 * t7540;
  t7544 = 0.6e1 * t5025 * t7490 - 0.6e1 * t7470 * t2502 + 0.6e1 * t5025 * t7496 - 0.6e1 * t2499 * t6739 + 0.6e1 * t5025 * t7501 - 0.4e1 * t7470 * t2506 + 0.6e1 * t7454 * t2535 + 0.6e1 * t2521 * t6722 - 0.6e1 * t6751 * t1077 * t2540 - 0.6e1 * t7449 * t2535 - 0.6e1 * t2527 * t6722 + 0.3e1 * t2521 * t7517 - 0.18e2 * t7445 * t7520 - 0.3e1 * t2527 * t7517 + 0.7e1 * t379 * t7398 * t7520 - 0.11e2 * t7412 * t389 * t7404 + 0.3e1 * t2541 * t5044 - 0.18e2 * t379 * t6750 * t389 * t2540 + 0.6e1 * t163 * t7482 * t2233 + 0.6e1 * t5019 * t7541;
  t7548 = t1077 * t7495;
  t7553 = t2516 * t399;
  t7557 = t2500 * t399;
  t7558 = t171 * t7557;
  t7568 = t389 * t7557;
  t7573 = t7465 * t263;
  t7596 = 0.6e1 * t163 * t7540 * t2233 + 0.6e1 * t5025 * t7548 - 0.4e1 * t2499 * t6790 + 0.3e1 * t2515 * t389 * t7553 - t2527 * t7558 + 0.3e1 * t2521 * t7558 + 0.3e1 * t2509 * t389 * t5943 + 0.3e1 * t2515 * t1077 * t7553 + 0.3e1 * t2521 * t7568 - 0.3e1 * t2499 * t7568 + 0.18e2 * t7399 * t1077 * t7573 - 0.12e2 * t7439 * t7427 - 0.2e1 * t2499 * t1077 * t7557 + 0.11e2 * t7399 * t3619 * t7573 - 0.6e1 * t7439 * t3619 * t7426 - t2499 * t7558 + t6585 * t3755 * t4868 * t298 + t5852 * t873 - t5874 * t873 - 0.2e1 * t1926 * t2237;
  t7609 = t1122 * t732 * t633;
  t7624 = t1122 * t1988 * t263;
  t7634 = t1131 * t4952 * t298;
  t7646 = t389 * t298;
  t7647 = t3589 * t7646;
  t7650 = 0.6e1 * t5800 * t3830 * t878 * t380 + 0.6e1 * t6550 * t3743 * t2481 - 0.3e1 * t1604 * t5848 - 0.6e1 * t4896 * t7609 - 0.2e1 * t1929 * t1578 * t878 * t399 + 0.11e2 * t6648 * t3748 * t732 * t263 + 0.2e1 * t1960 * t2237 + t736 * t6615 - 0.6e1 * t4896 * t7624 - t748 * t6615 - t5874 * t883 - 0.2e1 * t1926 * t2243 - t748 * t6621 - t3650 * t2482 - 0.2e1 * t2299 * t7634 - 0.2e1 * t2299 * t1131 * t1633 * t741 - 0.4e1 * t5881 * t2487 - 0.4e1 * t1929 * t6686 + 0.3e1 * t379 * t1583 * t7647;
  t7658 = 0.18e2 * t1094 * t2544 * t3658 * t380 + 0.3e1 * t3589 * t6506 * t876 - t6520 + t6523 + t6609 + t6613 - t6628 - t6631 + t6639 + t6641 - t6643 - t6645 + t6665 - t6676 + t6678 - t6682 + t6697 + t6728 - t6731 - t6736;
  t7663 = t1116 * t380;
  t7664 = t7663 * t3658;
  t7667 = t1068 * t2540;
  t7670 = t171 * t1115;
  t7681 = t741 * t167 * t384;
  t7682 = t379 * t7681;
  t7685 = t379 * t1974;
  t7687 = t639 * t403;
  t7688 = t6782 * t74 * t7687;
  t7691 = t4819 * t2550;
  t7698 = t163 * t7681;
  t7706 = t389 * t1115;
  t7712 = t1077 * t298;
  t7716 = t1131 * t1076;
  t7725 = -0.18e2 * t5732 * t2549 * t1642 + 0.18e2 * t2544 * t7664 - 0.6e1 * t7667 * t7664 - 0.6e1 * t5732 * t7670 * t1642 + 0.18e2 * t6751 * t7646 * t3264 - 0.18e2 * t7667 * t7663 * t3723 - 0.6e1 * t7682 * t2551 - 0.6e1 * t7685 * t7688 - 0.6e1 * t7682 * t7691 - 0.6e1 * t7685 * t4819 * t1681 * t403 + 0.6e1 * t7698 * t2551 + 0.6e1 * t1975 * t7688 + 0.3e1 * t1975 * t2549 * t5020 + 0.18e2 * t5774 * t7706 * t1642 - 0.3e1 * t2544 * t4965 + 0.18e2 * t6751 * t7712 * t3264 - 0.12e2 * t7667 * t7716 * t6702 * t382 - 0.3e1 * t2544 * t4970 + t736 * t6854 + t4855 * t733;
  t7744 = -t163 * t1657 * t298 * t405 - t163 * t1983 * t263 * t405 - 0.2e1 * t163 * t405 * t633 * t741 + 0.2e1 * t1629 * t1989 + 0.2e1 * t1960 * t2293 + t5852 * t879 + t5995 * t642 - 0.2e1 * t2560 - 0.2e1 * t2563 - t6809 - t6819 - t6832 - t6849 + t6862 + t6863 + t6872 - t6873 + t6875 - t826 - t877;
  t7748 = my_piecewise5(t64, 0, t67, 0, t7432 + t7486 + t7544 + t7596 + t7650 + t7658 + t7725 + t7744);
  t7755 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t888 + t7358 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t2572 - t7365 + t7367 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (0.5e1 / 0.27e2 * t52 * t615 * t266 - 0.5e1 / 0.36e2 * t52 * t257 * t648 + t52 * t291 * t1689 / 0.24e2 + t1568 * t301 + 0.2e1 * t618 * t752 + t260 * t2010 + t373 * t886 + 0.2e1 * t161 * t2570 + t59 * t7748));
  tv4rho2sigmalapl0 = t7755 * t8 + 0.2e1 * t2577;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  t7762 = t7 * t440 * t914;
  t7766 = t7 * t444 * t914 / 0.3e2;
  t7768 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t914 + t7762 / 0.5e1 - t7766);
  tv4rho2sigmalapl5 = t7768 * t8 + 0.2e1 * t2586;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  t7774 = t7 * t465 * t888;
  t7782 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t888 + t7774 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t2572 + t7358 / 0.1e2 - t7365 + t7367 / 0.1e2);
  tv4rho2sigmalapl6 = t7782 * t8 + t2577 + t2592;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  t7788 = t7 * t489 * t914;
  t7795 = t7 * t192 * t2697;
  t7798 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t914 + t7788 / 0.1e2 + t7762 / 0.1e2 - t7766 + 0.3e1 / 0.2e2 * t7 * t188 * t2697 + t7795 / 0.1e2);
  tv4rho2sigmalapl11 = t7798 * t8 + t2586 + t2702;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  t7806 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t888 + t7774 / 0.5e1 - t7365);
  tv4rho2sigmalapl12 = t7806 * t8 + 0.2e1 * t2592;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  t7845 = t1454 * t2661;
  t7846 = t1480 * t561;
  t7847 = t7846 * t4391;
  t7850 = t242 * t1115;
  t7854 = t560 * t2144;
  t7859 = t573 * t1458;
  t7860 = t1454 * t7859;
  t7861 = t1463 * t315;
  t7865 = t1492 * t1462;
  t7873 = t570 * t1115;
  t7879 = -t6958 + t6961 - t6962 + 0.4e1 * t2629 + 0.4e1 * t2663 - 0.4e1 * t2668 + 0.4e1 * t2673 - 0.4e1 * t2677 + 0.18e2 * t2665 * t1484 * t561 * t4391 - 0.18e2 * t6271 * t2670 * t1837 - 0.6e1 * t7845 * t7847 - 0.6e1 * t6271 * t7850 * t1837 - 0.6e1 * t7854 * t7263 + 0.18e2 * t2665 * t7847 + 0.18e2 * t7860 * t7861 * t3298 - 0.12e2 * t7845 * t7865 * t6985 * t563 + 0.3e1 * t2145 * t2670 * t5555 + 0.18e2 * t6314 * t7873 * t1837 - 0.3e1 * t2665 * t5489;
  t7882 = t570 * t315;
  t7890 = t795 * t238 * t565;
  t7891 = t234 * t7890;
  t7896 = t560 * t7890;
  t7901 = t5334 * t2671;
  t7904 = t6178 * t4483;
  t7905 = t560 * t7904;
  t7906 = t1844 * t2649;
  t7909 = t1454 * t7904;
  t7910 = t3749 * t281;
  t7911 = t7910 * t561;
  t7912 = t1463 * t7911;
  t7915 = t570 * t7911;
  t7918 = t234 * t7904;
  t7919 = t242 * t7911;
  t7925 = t4501 * t7904;
  t7927 = t6985 * t2649;
  t7934 = t7103 * t4483;
  t7935 = t4501 * t7934;
  t7936 = t901 * params->csk_a;
  t7937 = t1463 * t7936;
  t7942 = 0.18e2 * t3298 * t7860 * t7882 - 0.18e2 * t4402 * t7845 * t7846 + 0.6e1 * t2145 * t7266 - 0.2e1 * t2641 * t7037 - 0.3e1 * t2665 * t5494 + 0.6e1 * t2672 * t7891 - 0.6e1 * t2672 * t7896 - 0.6e1 * t7266 * t7854 - 0.6e1 * t7896 * t7901 - 0.11e2 * t7905 * t7906 - 0.7e1 * t7905 * t7915 - 0.7e1 * t7905 * t7919 - 0.18e2 * t7905 * t7927 + 0.12e2 * t7909 * t7912 + 0.6e1 * t7909 * t7919 + 0.6e1 * t7909 * t7927 + t7918 * t7919 + 0.6e1 * t7918 * t7927 - t7919 * t7925 - 0.6e1 * t7935 * t7937;
  t7946 = t6212 * t1458;
  t7947 = t1454 * t7946;
  t7952 = t1454 * t7934;
  t7962 = t560 * t901 * t4466;
  t7965 = t2621 * t561;
  t7978 = t4501 * t5295 * t4483;
  t7979 = t315 * t1115;
  t7986 = t234 * t7946;
  t7989 = t560 * t7946;
  t7995 = t2683 * t584;
  t7996 = t570 * t7995;
  t8003 = 0.6e1 * t2645 * t7037 - 0.2e1 * t7947 * t2643 - 0.2e1 * t2620 * t7037 - 0.12e2 * t7952 * t7937 + 0.3e1 * t234 * t2106 * t4466 * t899 + 0.11e2 * t7918 * t7906 - 0.3e1 * t7962 * t7242 - 0.6e1 * t7909 * t1463 * t7965 - 0.12e2 * t2662 * t7090 - 0.3e1 * t7962 * t7245 + 0.18e2 * t7909 * t7915 - 0.7e1 * t7925 * t7915 + 0.7e1 * t7978 * t570 * t7979 * t561 - 0.12e2 * t7925 * t7912 - 0.2e1 * t7986 * t2643 + 0.6e1 * t7989 * t2643 - 0.6e1 * t7935 * t4506 * t7936 + 0.6e1 * t5554 * t7996 + 0.6e1 * t7989 * t2623 + 0.6e1 * t2645 * t7014;
  t8004 = t795 * params->csk_a;
  t8005 = t8004 * t281;
  t8006 = t570 * t8005;
  t8011 = t2633 * t695;
  t8012 = t570 * t8011;
  t8034 = t5527 * t2649;
  t8037 = t570 * t7936;
  t8052 = t7979 * t281;
  t8062 = 0.6e1 * t5543 * t8006 - 0.6e1 * t7947 * t2623 + 0.6e1 * t5543 * t8012 - 0.6e1 * t2620 * t7014 - 0.6e1 * t7860 * t1463 * t2661 - 0.6e1 * t7986 * t2650 - 0.6e1 * t2641 * t6982 + 0.6e1 * t7989 * t2650 + 0.6e1 * t2645 * t6982 + 0.3e1 * t2662 * t7223 - 0.18e2 * t560 * t7859 * t570 * t2661 + 0.3e1 * t2645 * t8034 - 0.18e2 * t7952 * t8037 - 0.3e1 * t2641 * t8034 + 0.7e1 * t560 * t7934 * t8037 - 0.11e2 * t7905 * t570 * t7965 - 0.2e1 * t2620 * t1463 * t2621 * t580 + 0.11e2 * t7935 * t4506 * t8052 - 0.6e1 * t7925 * t4506 * t7911 + 0.6e1 * t234 * t7995 * t2365;
  t8065 = t2686 * t584;
  t8066 = t570 * t8065;
  t8072 = t1463 * t8005;
  t8077 = t1463 * t8011;
  t8082 = t2621 * t5493;
  t8084 = t2633 * t580;
  t8092 = t2621 * t570 * t580;
  t8106 = t1510 * t786 * t695;
  t8109 = 0.3e1 * t1463 * t2632 * t8084 + 0.18e2 * t1463 * t7935 * t8052 + 0.6e1 * t234 * t2365 * t8065 + 0.3e1 * t2632 * t570 * t8084 - 0.4e1 * t2620 * t7022 - t2620 * t8082 - 0.3e1 * t2620 * t8092 + 0.3e1 * t2626 * t6328 - t2641 * t8082 + 0.3e1 * t2645 * t8082 + 0.3e1 * t2645 * t8092 - 0.4e1 * t2656 * t7947 - 0.6e1 * t5374 * t8106 + 0.6e1 * t5543 * t8072 + 0.6e1 * t5543 * t8077 + 0.6e1 * t5554 * t8066 - t6979 + t7031 - t7034;
  t8120 = t1492 * t5433 * t315;
  t8143 = t4467 * t7882;
  t8157 = -t6235 * t899 - 0.2e1 * t2096 * t2351 - t802 * t7157 - t6235 * t909 - 0.2e1 * t2096 * t2402 - t802 * t7181 - t4429 * t2613 - 0.2e1 * t2448 * t8120 - 0.2e1 * t2448 * t1492 * t1817 * t795 + t6254 * t899 + 0.2e1 * t2124 * t2351 + t790 * t7157 - 0.4e1 * t6353 * t2616 - 0.4e1 * t2099 * t7231 + 0.3e1 * t902 * t4467 * t1792 + 0.6e1 * t6179 * t5631 * t904 * t561 + 0.3e1 * t560 * t1784 * t8143 + 0.6e1 * t7295 * t4551 * t2612 - 0.2e1 * t2099 * t1773 * t904 * t580 + 0.11e2 * t7280 * t4556 * t786 * t281;
  t8165 = t1510 * t2165 * t281;
  t8172 = -t2153 * t234 * t281 * t586 + t315 * t4577 * t5405 * t7104 - 0.3e1 * t1801 * t6247 - 0.6e1 * t5374 * t8165 + t6411 * t704 - t7072 - t7078 + t7081 - t7120 + t7122 - t7123 + t7131 + t7142 + t7147 - t7162 + t7167 - t7172 - t7201 + t7210 + t7221;
  t8189 = -t1852 * t234 * t315 * t586 - 0.2e1 * t234 * t586 * t695 * t795 + 0.2e1 * t1830 * t2166 + 0.2e1 * t2124 * t2442 + t5385 * t787 + t6254 * t905 + t7307 * t790 - 0.2e1 * t2685 - 0.2e1 * t2688 + t7273 + t7274 - t7277 - t7292 - t7301 - t7327 + t7336 - t7337 + t7339 - t852 - t903;
  t8193 = my_piecewise5(t114, 0, t115, 0, t7879 + t7942 + t8003 + t8062 + t8109 + t8157 + t8172 + t8189);
  t8200 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t914 + t7788 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t2697 - t7766 + t7795 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * (0.5e1 / 0.27e2 * t52 * t677 * t284 - 0.5e1 / 0.36e2 * t52 * t275 * t710 + t52 * t308 * t1884 / 0.24e2 + t1763 * t318 + 0.2e1 * t680 * t806 + t278 * t2180 + t554 * t912 + 0.2e1 * t232 * t2695 + t113 * t8193));
  tv4rho2sigmalapl17 = t8 * t8200 + 0.2e1 * t2702;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  tv4rho2sigmatau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  tv4rho2sigmatau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  tv4rho2sigmatau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  tv4rho2sigmatau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  tv4rho2sigmatau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  t8207 = t7 * t345 * t937;
  t8214 = t7 * t354 * t937 / 0.3e2;
  t8216 = t7 * t145 * t2790;
  t8233 = t1994 * t403;
  t8234 = t2549 * t8233;
  t8248 = t2516 * t741;
  t8255 = t2777 * t384;
  t8256 = t163 * t8255;
  t8264 = 0.12e2 * t171 * t5017 * t741 * t8256 + 0.12e2 * t1077 * t5025 * t8248 + 0.12e2 * t389 * t5025 * t8248 + 0.12e2 * t389 * t7685 * t8233 - 0.12e2 * t4819 * t7685 * t8233 + 0.12e2 * t1975 * t8234 + 0.3e1 * t2719 * t3575 - 0.3e1 * t2724 * t6747 - 0.3e1 * t2724 * t6758 - 0.12e2 * t7685 * t8234 + 0.4e1 * t2720 - 0.4e1 * t2725 - 0.4e1 * t2727 + t6491 - t6492 - t6493;
  t8266 = t1115 * t741 * t165;
  t8270 = t389 * t8266;
  t8273 = t925 * t1072;
  t8274 = t1068 * t8273;
  t8277 = t171 * t8266;
  t8282 = t2722 * t1072;
  t8283 = t163 * t8282;
  t8285 = t171 * t392 * params->csk_a;
  t8288 = t379 * t8282;
  t8303 = t171 * t7488 * t165;
  t8306 = t379 * t8273;
  t8313 = t163 * t8273;
  t8316 = 0.18e2 * t1077 * t1650 * t8274 - 0.8e1 * t1077 * t2499 * t8266 - 0.12e2 * t2499 * t8270 - 0.4e1 * t2499 * t8277 + 0.12e2 * t2521 * t8270 + 0.12e2 * t2521 * t8277 + 0.12e2 * t2521 * t8303 - 0.4e1 * t2527 * t8277 - 0.12e2 * t2527 * t8303 + 0.18e2 * t3581 * t8274 - 0.12e2 * t6704 * t8274 - 0.6e1 * t6710 * t8274 - 0.6e1 * t6710 * t8313 - 0.18e2 * t6744 * t8274 + 0.18e2 * t6744 * t8306 - 0.18e2 * t8283 * t8285 + 0.18e2 * t8285 * t8288;
  t8320 = t388 * t380;
  t8326 = t1131 * t2774 * t403;
  t8330 = t1131 * t1955 * t741;
  t8343 = t922 * t3593;
  t8344 = t1068 * t8343;
  t8352 = t3618 * t922;
  t8354 = t3755 * t8352 * params->csk_a;
  t8358 = t394 * t395 * t1983;
  t8365 = -0.12e2 * t1076 * t3743 * t380 * t8344 * params->csk_a - 0.18e2 * t1122 * t403 * t8320 * t931 - 0.4e1 * t2299 * t8330 - t2730 * t3643 + 0.3e1 * t2730 * t3680 + 0.3e1 * t2730 * t3698 - t2733 * t3643 - 0.3e1 * t2733 * t3673 + 0.3e1 * t2735 * t3643 + 0.3e1 * t2735 * t3673 + 0.3e1 * t2735 * t3719 + 0.3e1 * t2758 * t5044 - 0.6e1 * t6585 * t8354 - 0.6e1 * t6689 * t8326 + 0.18e2 * t6710 * t8306 + 0.2e1 * t736 * t8358;
  t8376 = t3614 * t8343;
  t8387 = t379 * t8343;
  t8390 = t163 * t8343;
  t8404 = -0.8e1 * t1578 * t1929 * t639 * t741 - 0.3e1 * t2730 * t3719 + 0.3e1 * t2765 * t3710 - 0.11e2 * t6514 * t8387 + 0.11e2 * t6514 * t8390 + 0.18e2 * t6529 * t8376 - 0.18e2 * t6534 * t8344 + 0.7e1 * t6534 * t8387 + 0.7e1 * t6542 * t8376 + 0.12e2 * t6546 * t8344 - 0.12e2 * t6546 * t8376 + 0.18e2 * t6565 * t8344 - 0.7e1 * t6565 * t8376 + 0.6e1 * t6669 * t8344 - t6669 * t8376 - 0.7e1 * t6669 * t8387 - 0.2e1 * t748 * t8358;
  t8410 = t3743 * t2774 * params->csk_a;
  t8414 = t922 * t3588;
  t8415 = t379 * t8414;
  t8420 = t922 * t380;
  t8443 = t3755 * t8352 * t1115;
  t8448 = -0.2e1 * t1983 * t411 * t412 * t748 + 0.3e1 * t163 * t4807 * t8420 - 0.2e1 * t2730 * t6594 - 0.12e2 * t2758 * t6500 + 0.6e1 * t6507 * t8344 - 0.18e2 * t6507 * t8387 + 0.6e1 * t6507 * t8390 - 0.3e1 * t6526 * t8415 - 0.6e1 * t6529 * t8344 - 0.11e2 * t6542 * t8387 - 0.3e1 * t6561 * t8415 - 0.7e1 * t6565 * t8387 - 0.6e1 * t6585 * t8410 + 0.11e2 * t6585 * t8443 - 0.6e1 * t6602 * t8376 + t6669 * t8390;
  t8453 = -0.12e2 * t1122 * t1922 * t2248 * t741 - t6520 + t6523 + t6609 + t6613 - t6628 - t6631 + t6639 + t6641 - t6643 - t6645 + t6665 - t6676 + t6678 - t6682 + t6697 + t6728;
  t8455 = t170 * t1983;
  t8462 = t741 * t741;
  t8463 = t8462 * t382;
  t8467 = t379 * t8463;
  t8475 = t163 * t8414;
  t8485 = t3743 * t2774;
  t8493 = t3755 * t8352;
  t8495 = -t6731 - t6736 - 0.2e1 * t2778 * t2288 * t8455 + 0.2e1 * t736 * t394 * t8455 + 0.2e1 * t163 * t8463 * t396 - 0.2e1 * t8467 * t396 + 0.3e1 * t379 * t8420 * t3601 + 0.6e1 * t8390 * t6824 + 0.3e1 * t8475 * t6821 + 0.11e2 * t8387 * t3748 * t8320 - 0.2e1 * t8467 * t413 - 0.3e1 * t2735 * t3793 + 0.6e1 * t6550 * t8485 - 0.2e1 * t2733 * t6838 + 0.2e1 * t748 * t5995 - t3650 * t2775 + t6585 * t8493;
  t8499 = t163 * t8462;
  t8507 = 0.2e1 * t379 * t390 * t8462 - 0.2e1 * t405 * t8499 + 0.2e1 * t407 * t8499 + 0.4e1 * t2759 + 0.4e1 * t2766 - 0.4e1 * t2781 - t6809 - t6819 - t6832 - t6849 + t6862 + t6863 + t6872 - t6873 + t6875 - t826 - t929;
  t8511 = my_piecewise5(t64, 0, t67, 0, t8264 + t8316 + t8365 + t8404 + t8448 + t8453 + t8495 + t8507);
  t8518 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t341 * t937 + t8207 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t140 * t2790 - t8214 + t8216 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (0.1e2 / 0.27e2 * t52 * t615 * t301 - 0.5e1 / 0.18e2 * t52 * t257 * t752 + t52 * t291 * t2010 / 0.12e2 + t373 * t935 + 0.2e1 * t161 * t2788 + t59 * t8511));
  tv4rho2lapl20 = t8 * t8518 + 0.2e1 * t2795;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  t8525 = t7 * t440 * t960;
  t8529 = t7 * t444 * t960 / 0.3e2;
  t8531 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t436 * t960 + t8525 / 0.5e1 - t8529);
  tv4rho2lapl22 = t8 * t8531 + 0.2e1 * t2804;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  t8537 = t7 * t465 * t937;
  t8545 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t461 * t937 + t8537 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t205 * t2790 + t8207 / 0.1e2 - t8214 + t8216 / 0.1e2);
  tv4rho2lapl23 = t8 * t8545 + t2795 + t2810;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  t8551 = t7 * t489 * t960;
  t8558 = t7 * t192 * t2895;
  t8561 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t485 * t960 + t8551 / 0.1e2 + t8525 / 0.1e2 - t8529 + 0.3e1 / 0.2e2 * t7 * t188 * t2895 + t8558 / 0.1e2);
  tv4rho2lapl25 = t8 * t8561 + t2804 + t2900;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  t8569 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t516 * t937 + t8537 / 0.5e1 - t8214);
  tv4rho2lapl26 = t8 * t8569 + 0.2e1 * t2810;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  t8595 = t2156 * t584;
  t8596 = t2670 * t8595;
  t8610 = t2633 * t795;
  t8617 = t948 * t1458;
  t8618 = t1454 * t8617;
  t8624 = 0.12e2 * t1463 * t5543 * t8610 - 0.12e2 * t5334 * t7854 * t8595 + 0.12e2 * t5543 * t570 * t8610 + 0.12e2 * t570 * t7854 * t8595 + 0.12e2 * t2145 * t8596 - 0.3e1 * t2824 * t4451 - 0.3e1 * t2824 * t7260 + 0.3e1 * t2829 * t4458 + 0.18e2 * t6990 * t8618 - 0.12e2 * t7854 * t8596 - 0.4e1 * t2825 + 0.4e1 * t2830 - 0.4e1 * t2832 - t6958 + t6961 - t6962;
  t8625 = t2165 * t236;
  t8626 = t6968 * t8625;
  t8635 = t2880 * t565;
  t8636 = t234 * t8635;
  t8643 = t2822 * t1458;
  t8644 = t234 * t8643;
  t8647 = t560 * t8643;
  t8650 = t1115 * t122;
  t8651 = t2882 * t236;
  t8652 = t8650 * t8651;
  t8658 = t242 * t8004 * t236;
  t8663 = t234 * t8617;
  t8666 = t560 * t8617;
  t8677 = -0.8e1 * t1463 * t2620 * t5538 * t795 + 0.12e2 * t242 * t5552 * t795 * t8636 - 0.12e2 * t2620 * t8626 - 0.4e1 * t2620 * t8652 - 0.12e2 * t2641 * t8658 + 0.12e2 * t2645 * t8626 + 0.12e2 * t2645 * t8652 + 0.12e2 * t2645 * t8658 - 0.18e2 * t6971 * t8618 + 0.18e2 * t6971 * t8666 + 0.18e2 * t6977 * t8618 - 0.12e2 * t6987 * t8618 - 0.18e2 * t7045 * t8644 + 0.18e2 * t7045 * t8647 - 0.6e1 * t7054 * t8618 - 0.6e1 * t7054 * t8663 + 0.18e2 * t7054 * t8666;
  t8682 = t575 * t576 * t2153;
  t8686 = t1492 * t2119 * t795;
  t8690 = t569 * t945;
  t8704 = t4505 * t945;
  t8706 = t4577 * t8704 * t1115;
  t8709 = t945 * t4481;
  t8710 = t4501 * t8709;
  t8715 = 0.7e1 * t1115 * t4556 * t7104 * t8690 - 0.4e1 * t2448 * t8686 - 0.4e1 * t2641 * t8652 - t2835 * t4381 + 0.3e1 * t2835 * t4426 - t2845 * t4381 - 0.3e1 * t2845 * t4411 + 0.3e1 * t2847 * t4381 + 0.3e1 * t2847 * t4411 + 0.3e1 * t2847 * t4525 + 0.11e2 * t7104 * t8706 - 0.6e1 * t7191 * t8710 + 0.2e1 * t790 * t8682 - t6979 + t7031 - t7034;
  t8725 = t560 * t8709;
  t8733 = t4551 * t2877 * t1115;
  t8743 = t1492 * t2877 * t584;
  t8749 = t1454 * t8709;
  t8755 = t4577 * t8704 * params->csk_a;
  t8758 = t234 * t8709;
  t8765 = 0.3e1 * t2859 * t7223 - 0.18e2 * t590 * t1510 * t8690 * t584 - 0.8e1 * t2099 * t1773 * t8651 + 0.7e1 * t8725 * t7133 - 0.2e1 * t802 * t8682 - 0.3e1 * t2835 * t4525 + 0.18e2 * t7104 * t8733 - 0.2e1 * t802 * t592 * t593 * t2153 + 0.3e1 * t2870 * t4521 - 0.6e1 * t7148 * t8743 - 0.12e2 * t2092 * t1510 * t8625 - 0.12e2 * t8749 * t7098 + 0.3e1 * t2835 * t4530 - 0.6e1 * t7104 * t8755 + 0.11e2 * t8758 * t7083 - 0.11e2 * t8725 * t7083 - 0.2e1 * t2835 * t4415;
  t8780 = t945 * t4466;
  t8781 = t560 * t8780;
  t8786 = t945 * t561;
  t8804 = 0.3e1 * t234 * t5344 * t8786 - 0.12e2 * t2859 * t7090 - 0.11e2 * t7066 * t8725 - 0.7e1 * t7073 * t8710 - 0.7e1 * t7073 * t8725 + 0.18e2 * t7073 * t8749 - 0.6e1 * t7094 * t8749 - 0.7e1 * t7112 * t8725 - 0.12e2 * t7125 * t8710 + 0.12e2 * t7125 * t8749 - 0.18e2 * t7133 * t8749 - 0.18e2 * t7196 * t8725 + 0.6e1 * t7196 * t8749 + 0.6e1 * t7196 * t8758 - 0.3e1 * t7242 * t8781 - 0.3e1 * t7245 * t8781;
  t8806 = t4551 * t2877 * params->csk_a;
  t8813 = -0.6e1 * t7104 * t8806 - t7112 * t8710 + 0.6e1 * t7112 * t8749 + t7112 * t8758 - t7072 - t7078 + t7081 - t7120 + t7122 - t7123 + t7131 + t7142 + t7147 - t7162 + t7167 - t7172 - t7201;
  t8815 = t241 * t2153;
  t8826 = t4556 * t8690;
  t8831 = t4551 * t2877;
  t8835 = t4577 * t8704;
  t8837 = t795 * t795;
  t8838 = t8837 * t563;
  t8839 = t560 * t8838;
  t8850 = t234 * t8780;
  t8855 = t7210 + t7221 - 0.2e1 * t2881 * t2437 * t8815 + 0.2e1 * t790 * t575 * t8815 + 0.2e1 * t802 * t6411 - 0.2e1 * t2845 * t4601 + 0.11e2 * t7280 * t8826 - 0.3e1 * t2847 * t4563 + 0.6e1 * t7295 * t8831 - t4429 * t2878 + t7104 * t8835 - 0.2e1 * t8839 * t577 - 0.2e1 * t8839 * t594 + 0.2e1 * t234 * t8838 * t577 + 0.3e1 * t560 * t8786 * t4493 + 0.3e1 * t8850 * t7285 + 0.6e1 * t8758 * t7288;
  t8856 = t234 * t8837;
  t8867 = 0.2e1 * t560 * t571 * t8837 - 0.2e1 * t586 * t8856 + 0.2e1 * t588 * t8856 + 0.4e1 * t2860 + 0.4e1 * t2871 - 0.4e1 * t2884 + t7273 + t7274 - t7277 - t7292 - t7301 - t7327 + t7336 - t7337 + t7339 - t852 - t952;
  t8871 = my_piecewise5(t114, 0, t115, 0, t8624 + t8677 + t8715 + t8765 + t8804 + t8813 + t8855 + t8867);
  t8878 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t533 * t960 + t8551 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t216 * t2895 - t8529 + t8558 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t94 * (0.1e2 / 0.27e2 * t52 * t677 * t318 - 0.5e1 / 0.18e2 * t52 * t275 * t806 + t52 * t308 * t2180 / 0.12e2 + t554 * t958 + 0.2e1 * t232 * t2893 + t113 * t8871));
  tv4rho2lapl28 = t8 * t8878 + 0.2e1 * t2900;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  tv4rho2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  tv4rho2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  tv4rho2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  tv4rho2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  tv4rho2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t8885 = t7 * t145 * t2972 / 0.1e2;
  t8891 = t2945 * t403;
  t8892 = t163 * t8891;
  t8893 = t8892 * t2546;
  t8895 = t379 * t8891;
  t8896 = t8895 * t2546;
  t8898 = t8895 * t2555;
  t8900 = t824 * params->csk_a;
  t8901 = t8900 * t165;
  t8903 = t2515 * t1077 * t8901;
  t8905 = t2904 * t382;
  t8906 = t8905 * t1072;
  t8907 = t1068 * t8906;
  t8911 = t6517 * t1072;
  t8912 = t1068 * t8911;
  t8913 = t8912 * t2502;
  t8915 = 0.18e2 * t1077 * t2272 * t8907 + t2220 - t2222 - t2229 + t2234 + t2251 - t2268 + t2274 - t2278 + 0.9e1 * t8893 - 0.9e1 * t8896 - 0.9e1 * t8898 + 0.9e1 * t8903 - 0.9e1 * t8913;
  t8916 = t8912 * t2506;
  t8918 = t4963 * t633;
  t8919 = t389 * t8918;
  t8923 = t6766 * t403;
  t8924 = t171 * t8923;
  t8927 = t379 * t8906;
  t8930 = t389 * t8923;
  t8933 = t8892 * t2233;
  t8935 = t1115 * t824;
  t8936 = t8935 * t165;
  t8937 = t389 * t8936;
  t8938 = t4973 * t8937;
  t8947 = t2509 * t389 * t2283 * t403;
  t8951 = t4963 * t2236;
  t8955 = t171 * t3573 * t633;
  t8958 = t2919 * t1072;
  t8960 = t382 * params->csk_a;
  t8961 = t8960 * t165;
  t8962 = t171 * t8961;
  t8965 = -0.12e2 * t1077 * t8907 * t8923 - 0.6e1 * t163 * t8906 * t8924 - 0.18e2 * t163 * t8958 * t8962 - 0.9e1 * t2265 * t8919 - 0.9e1 * t2265 * t8951 + 0.9e1 * t2271 * t8955 - 0.6e1 * t8907 * t8924 - 0.18e2 * t8907 * t8930 + 0.18e2 * t8924 * t8927 + 0.18e2 * t8927 * t8930 - 0.6e1 * t8916 + 0.9e1 * t8933 + 0.9e1 * t8938 + 0.9e1 * t8947;
  t8967 = t171 * t824;
  t8968 = t6766 * t8967;
  t8969 = t4973 * t8968;
  t8971 = t8912 * t2528;
  t8974 = t2515 * t389 * t8901;
  t8980 = t379 * t8911 * t2535;
  t8982 = t171 * t8901;
  t8983 = t5039 * t8982;
  t8985 = t389 * t2272;
  t8988 = t5039 * t8968;
  t8990 = t2904 * t3593;
  t8991 = t379 * t8990;
  t8992 = t3748 * t2225;
  t8995 = t379 * t8905;
  t8996 = t1122 * t2249;
  t8999 = t6518 * t2487;
  t9001 = t1068 * t8990;
  t9002 = t3743 * t2260;
  t9007 = t1604 * t1122 * t2280 * t165;
  t9009 = t3743 * t2253;
  t9012 = 0.18e2 * t379 * t8958 * t8962 + 0.18e2 * t8907 * t8985 - 0.11e2 * t8991 * t8992 - 0.18e2 * t8995 * t8996 - 0.6e1 * t9001 * t9002 - 0.12e2 * t9001 * t9009 + 0.9e1 * t8969 - 0.3e1 * t8971 + 0.9e1 * t8974 + 0.9e1 * t8980 - 0.9e1 * t8983 - 0.3e1 * t8988 - 0.6e1 * t8999 - 0.9e1 * t9007;
  t9014 = t1578 * t395 * t633;
  t9019 = t2904 * t165;
  t9023 = t1623 * t2914;
  t9025 = t2221 * t2243;
  t9028 = t394 * t1111 * t633;
  t9034 = t1578 * t1600 * t633;
  t9041 = t2221 * t2237;
  t9043 = t3860 * t2214;
  t9046 = t2904 * t3588;
  t9047 = t379 * t9046;
  t9051 = t1578 * t3841 * t165;
  t9056 = 0.3e1 * t163 * t4807 * t9019 + 0.9e1 * t2201 * t4860 - 0.3e1 * t2201 * t9034 - 0.9e1 * t2205 * t9014 - 0.3e1 * t2205 * t9034 + 0.9e1 * t2209 * t9014 + 0.9e1 * t2209 * t9034 + 0.9e1 * t2231 * t9028 - 0.12e2 * t2954 * t9051 - 0.3e1 * t630 * t9047 - 0.3e1 * t645 * t9047 + 0.6e1 * t9001 * t9043 + 0.3e1 * t9023 - 0.3e1 * t9025 - 0.3e1 * t9041;
  t9059 = t163 * t8990;
  t9064 = t1116 * t6799;
  t9067 = t165 * t3593;
  t9068 = t3614 * t9067;
  t9071 = t3743 * t1076 * t2904 * t1115;
  t9074 = t3614 * t8990;
  t9075 = t1077 * t165;
  t9076 = t3850 * t9075;
  t9080 = t1131 * t1146 * t633;
  t9083 = t3618 * t2904;
  t9089 = t3755 * t3766 * t165;
  t9094 = t2299 * t1131 * t1633 * t824;
  t9104 = t1068 * t8905;
  t9105 = t1076 * t165;
  t9112 = 0.11e2 * t1115 * t3755 * t9068 * t9083 - 0.6e1 * t1131 * t403 * t9104 * t9105 - 0.6e1 * t3755 * t9068 * t9083 * params->csk_a + 0.9e1 * t2201 * t4954 - 0.9e1 * t2201 * t9064 - 0.6e1 * t2201 * t9080 + 0.9e1 * t2209 * t9064 + 0.9e1 * t2247 * t4843 - 0.18e2 * t8991 * t9043 + 0.6e1 * t9043 * t9059 + 0.18e2 * t9068 * t9071 - 0.12e2 * t9074 * t9076 - 0.6e1 * t9074 * t9089 - 0.3e1 * t9094;
  t9114 = t3830 * t4786 * t165;
  t9121 = t3850 * t2501;
  t9130 = t3748 * t644;
  t9139 = t3830 * t629;
  t9144 = -0.7e1 * t8991 * t9114 - 0.7e1 * t8991 * t9121 + 0.7e1 * t8991 * t9130 - 0.11e2 * t8991 * t9139 + 0.7e1 * t8992 * t9074 + 0.12e2 * t9001 * t9076 + 0.6e1 * t9001 * t9114 + 0.18e2 * t9001 * t9121 - 0.18e2 * t9001 * t9130 - 0.6e1 * t9009 * t9074 + t9059 * t9114 + 0.11e2 * t9059 * t9139 - t9074 * t9114 - 0.7e1 * t9074 * t9121;
  t9158 = t3830 * t639;
  t9163 = t2219 * t2293;
  t9165 = t1578 * t2289;
  t9168 = t1629 * t2281;
  t9172 = t163 * t824 * t633 * t405;
  t9178 = 0.3e1 * t163 * t640 * t9046 + 0.11e2 * t2248 * t3748 * t8991 + 0.3e1 * t3601 * t379 * t9019 + 0.6e1 * t3743 * t9001 * t9105 + t3755 * t9068 * t9083 - 0.3e1 * t2201 * t5086 - 0.6e1 * t2205 * t9165 - 0.9e1 * t2209 * t5101 + 0.6e1 * t9059 * t9158 + t2916 - t2918 + 0.3e1 * t9163 + 0.3e1 * t9168 - 0.3e1 * t9172;
  t9179 = 0.6e1 * t2947;
  t9180 = -t2922 - t2924 - t2926 + t2930 - t826 - t828 + t2282 - t2285 - t2292 + t2303 + t2939 - t9179 + t2951 + t2953 + t2956;
  t9184 = my_piecewise5(t64, 0, t67, 0, t8915 + t8965 + t9012 + t9056 + t9112 + t9144 + t9178 + t9180);
  t9191 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t2972 + t8885 + 0.3e1 / 0.2e2 * t7 * t32 * (t161 * t2970 + 0.3e1 * t2312 * t260 + t59 * t9184 + 0.3e1 * t618 * t834));
  tv4rhosigma30 = t8 * t9191 + t2976;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t9198 = t7 * t192 * t3047 / 0.1e2;
  t9200 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t3047 + t9198);
  tv4rhosigma39 = t8 * t9200 + t3051;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t9206 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t2972 + t8885);
  tv4rhosigma310 = t8 * t9206 + t2976;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t9216 = t1115 * t850;
  t9217 = t9216 * t236;
  t9218 = t570 * t9217;
  t9219 = t5504 * t9218;
  t9221 = t7069 * t1458;
  t9222 = t1454 * t9221;
  t9223 = t9222 * t2656;
  t9225 = t2979 * t563;
  t9226 = t9225 * t1458;
  t9227 = t1454 * t9226;
  t9229 = t1463 * t5538 * t584;
  t9232 = t3017 * t584;
  t9234 = t5554 * t570 * t9232;
  t9236 = t234 * t9232;
  t9237 = t9236 * t2365;
  t9239 = t6968 * t2373;
  t9242 = -0.12e2 * t9227 * t9229 - 0.18e2 * t9227 * t9239 - t2361 + t2366 + t2375 + t2389 - t2390 - t2413 + t2419 - t2423 + 0.9e1 * t9219 - 0.6e1 * t9223 + 0.9e1 * t9234 + 0.9e1 * t9237;
  t9243 = t850 * params->csk_a;
  t9244 = t9243 * t236;
  t9246 = t2632 * t1463 * t9244;
  t9252 = t242 * t4456 * t695;
  t9255 = t560 * t9226;
  t9258 = t701 * t584;
  t9259 = t8650 * t9258;
  t9262 = t242 * t695;
  t9263 = t4449 * t9262;
  t9266 = t4449 * t695;
  t9267 = t570 * t9266;
  t9270 = t9236 * t2667;
  t9272 = t560 * t9232;
  t9273 = t9272 * t2667;
  t9275 = t9272 * t2676;
  t9278 = t2632 * t570 * t9244;
  t9280 = t570 * t2417;
  t9283 = t242 * t9217;
  t9284 = t5526 * t9283;
  t9286 = t9222 * t2623;
  t9288 = 0.18e2 * t1463 * t2417 * t9227 - 0.9e1 * t2410 * t9263 - 0.9e1 * t2410 * t9267 + 0.9e1 * t2416 * t9252 - 0.6e1 * t9227 * t9259 + 0.18e2 * t9227 * t9280 + 0.18e2 * t9239 * t9255 + 0.9e1 * t9246 + 0.9e1 * t9270 - 0.9e1 * t9273 - 0.9e1 * t9275 + 0.9e1 * t9278 - 0.3e1 * t9284 - 0.9e1 * t9286;
  t9291 = t560 * t9221 * t2650;
  t9295 = t2411 * t4391;
  t9298 = t234 * t9226;
  t9301 = t242 * t9244;
  t9302 = t5526 * t9301;
  t9304 = t5504 * t9283;
  t9306 = t9222 * t2643;
  t9312 = t236 * t4481;
  t9313 = t4501 * t9312;
  t9316 = t4551 * t1462 * t2979 * t1115;
  t9321 = t2448 * t1492 * t1817 * t850;
  t9325 = t4505 * t2979;
  t9330 = t1454 * t9225;
  t9331 = t1462 * t236;
  t9337 = t1510 * t1525 * t695;
  t9340 = 0.18e2 * t1458 * t2990 * t560 * t9295 - 0.6e1 * t1492 * t584 * t9330 * t9331 - 0.6e1 * t4577 * t9313 * t9325 * params->csk_a + 0.9e1 * t2345 * t5435 + 0.9e1 * t2354 * t9337 - 0.18e2 * t2418 * t9298 + 0.18e2 * t9255 * t9259 - 0.6e1 * t9259 * t9298 + 0.18e2 * t9313 * t9316 + 0.9e1 * t9291 - 0.9e1 * t9302 + 0.9e1 * t9304 - 0.3e1 * t9306 - 0.3e1 * t9321;
  t9343 = t1773 * t2350;
  t9346 = t560 * t9312;
  t9352 = t2979 * t4481;
  t9353 = t560 * t9352;
  t9354 = t4556 * t2355;
  t9358 = t1492 * t1493 * t695;
  t9365 = t4501 * t9352;
  t9367 = t4577 * t4582 * t236;
  t9370 = t4632 * t2392;
  t9373 = t1454 * t9352;
  t9374 = t4551 * t2346;
  t9377 = t560 * t9225;
  t9381 = t2979 * t236;
  t9385 = t234 * t9352;
  t9388 = t2360 * t2351;
  t9390 = t1480 * t9262;
  t9395 = -0.9e1 * t2345 * t9337 - 0.9e1 * t2380 * t9343 + 0.7e1 * t9346 * t4556 * t569 * t2979 * params->csk_a - 0.11e2 * t9353 * t9354 - 0.6e1 * t2345 * t9358 + 0.11e2 * t9313 * t4577 * t9325 * t1115 - 0.6e1 * t9365 * t9367 - 0.11e2 * t9353 * t9370 - 0.12e2 * t9373 * t9374 - 0.18e2 * t9377 * t1510 * t2373 + 0.3e1 * t234 * t9381 * t5344 + 0.11e2 * t9385 * t9370 - 0.3e1 * t9388 - 0.3e1 * t2345 * t9390 + 0.9e1 * t2354 * t9343;
  t9402 = t2360 * t2402;
  t9405 = t575 * t1506 * t695;
  t9412 = t1823 * t2995;
  t9414 = t2979 * t4466;
  t9415 = t560 * t9414;
  t9418 = t4645 * t2392;
  t9421 = t241 * t563;
  t9423 = t1773 * t9421 * t236;
  t9428 = t7076 * t2616;
  t9430 = t4551 * t2405;
  t9435 = t1801 * t1510 * t2452 * t236;
  t9437 = 0.9e1 * t2345 * t5390 + 0.9e1 * t2354 * t9390 + 0.9e1 * t2363 * t9405 + 0.9e1 * t2371 * t5458 - 0.3e1 * t2380 * t9390 - 0.12e2 * t3032 * t9423 - 0.3e1 * t692 * t9415 - 0.3e1 * t707 * t9415 + 0.6e1 * t9373 * t9418 - 0.6e1 * t9373 * t9430 - 0.3e1 * t9402 + 0.3e1 * t9412 - 0.6e1 * t9428 - 0.9e1 * t9435;
  t9440 = t4556 * t706;
  t9444 = t5631 * t7110 * t236;
  t9456 = t4551 * t4658 * t236;
  t9460 = t4556 * t4557 * t236;
  t9471 = -0.18e2 * t9353 * t9418 - 0.7e1 * t9353 * t9444 - 0.7e1 * t9353 * t9460 + 0.7e1 * t9354 * t9365 - 0.6e1 * t9365 * t9374 - t9365 * t9444 - 0.12e2 * t9365 * t9456 - 0.7e1 * t9365 * t9460 - 0.18e2 * t9373 * t9440 + 0.6e1 * t9373 * t9444 + 0.12e2 * t9373 * t9456 + 0.18e2 * t9373 * t9460 + 0.6e1 * t9385 * t9418 + t9385 * t9444;
  t9473 = t1830 * t2453;
  t9483 = t234 * t850 * t695 * t586;
  t9488 = t5631 * t701;
  t9500 = t2388 * t2442;
  t9502 = t1773 * t2438;
  t9505 = 0.3e1 * t234 * t702 * t9414 + 0.11e2 * t2372 * t4556 * t9353 + 0.3e1 * t4493 * t560 * t9381 + 0.6e1 * t4551 * t9331 * t9373 + t4577 * t9313 * t9325 - 0.3e1 * t2345 * t5604 - 0.9e1 * t2354 * t5614 - 0.6e1 * t2380 * t9502 + 0.6e1 * t9385 * t9488 - t2989 - t2993 + 0.3e1 * t9473 - 0.3e1 * t9483 + 0.3e1 * t9500;
  t9506 = 0.6e1 * t3019;
  t9507 = t2997 - t2999 - t3001 + t3005 - t852 - t854 + t2425 - t2434 - t2441 + t2454 - t9506 + t3024 + t3029 + t3031 + t3034;
  t9511 = my_piecewise5(t114, 0, t115, 0, t9242 + t9288 + t9340 + t9395 + t9437 + t9471 + t9505 + t9507);
  t9518 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t3047 + t9198 + 0.3e1 / 0.2e2 * t7 * t94 * (t113 * t9511 + t232 * t3045 + 0.3e1 * t2457 * t278 + 0.3e1 * t680 * t860));
  tv4rhosigma319 = t8 * t9518 + t3051;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t9525 = t7 * t145 * t3131 / 0.1e2;
  t9537 = t1115 * t817;
  t9538 = t9537 * t165;
  t9542 = t741 * t817;
  t9544 = t379 * t9542 * t403;
  t9550 = t379 * t824 * t167 * t384 * t2511;
  t9552 = t8912 * t2518;
  t9557 = t1068 * t622 * t1072;
  t9561 = t6503 * t3595;
  t9562 = t1068 * t9561;
  t9570 = t171 * t3225 * t633;
  t9573 = t2500 * t633;
  t9574 = t389 * t9573;
  t9579 = -0.6e1 * t1077 * t3058 * t9557 - 0.6e1 * t1077 * t7391 * t9538 - 0.3e1 * t1063 * t9544 + 0.6e1 * t2509 * t7541 - 0.12e2 * t2518 * t9562 + 0.6e1 * t2521 * t9570 + 0.6e1 * t2521 * t9574 - 0.6e1 * t2527 * t9570 + 0.6e1 * t2541 * t9028 + 0.3e1 * t3064 * t7698 + t2220 - t2222 - t2229 + t2512 + t2542 - t3061 + t3066 - t3068 + 0.3e1 * t9550 + 0.3e1 * t9552;
  t9584 = t3614 * t9067 * t3595;
  t9585 = t7465 * t817;
  t9589 = t3749 * t817;
  t9590 = t9589 * t165;
  t9599 = t9589 * t9075;
  t9603 = t2499 * t1077 * t8936;
  t9605 = t3614 * t9561;
  t9609 = t3121 * t403;
  t9610 = t163 * t9609;
  t9611 = t9610 * t2233;
  t9613 = t2499 * t8937;
  t9617 = t2266 * t3075;
  t9620 = t2527 * t8982;
  t9622 = t2521 * t8982;
  t9625 = t379 * t3057 * t3588;
  t9630 = t395 * t817;
  t9631 = t394 * t9630;
  t9637 = t2500 * t2236;
  t9644 = -0.4e1 * t2499 * t1077 * t9573 + 0.11e2 * t9584 * t3619 * t9585 - 0.6e1 * t7439 * t3619 * t9590 + 0.6e1 * t2515 * t7548 + 0.18e2 * t9584 * t1077 * t9585 - 0.12e2 * t7439 * t9599 - 0.2e1 * t9603 - 0.6e1 * t9605 * t3619 * t2517 + 0.3e1 * t9611 - 0.3e1 * t9613 - 0.6e1 * t2499 * t9574 - 0.11e2 * t7412 * t9617 - 0.3e1 * t9620 + 0.3e1 * t9622 - 0.3e1 * t9625 * t630 + 0.3e1 * t163 * t744 * t3588 * t9631 - 0.11e2 * t7412 * t389 * t9538 - 0.2e1 * t2499 * t9637 + 0.6e1 * t2515 * t7496 - 0.2e1 * t2527 * t9637;
  t9650 = t171 * t9590;
  t9656 = t8912 * t2524;
  t9658 = t9589 * t2501;
  t9670 = t163 * t3058;
  t9682 = t2521 * t8968;
  t9684 = t2499 * t8968;
  t9687 = t2521 * t8937;
  t9689 = 0.7e1 * t165 * t389 * t7465 * t9605 + 0.7e1 * t2524 * t379 * t9561 - 0.3e1 * t1046 * t9544 - 0.18e2 * t2511 * t6713 - 0.6e1 * t2518 * t9605 + 0.6e1 * t2521 * t9637 - 0.18e2 * t2524 * t9562 - 0.3e1 * t645 * t9625 + 0.6e1 * t7391 * t9650 + 0.18e2 * t7391 * t9658 + 0.11e2 * t7395 * t9617 + t7395 * t9650 - 0.7e1 * t7412 * t9650 - t7439 * t9650 - 0.7e1 * t7439 * t9658 - 0.12e2 * t9051 * t9670 + 0.3e1 * t9656 + 0.3e1 * t9682 - t9684 + 0.3e1 * t9687;
  t9692 = t2527 * t8968;
  t9695 = t9537 * t2214;
  t9703 = t1115 * t382;
  t9704 = t9703 * t165;
  t9705 = t1122 * t388 * t9704;
  t9708 = t9610 * t2546;
  t9710 = t379 * t9609;
  t9711 = t9710 * t2546;
  t9714 = t1578 * t170 * t8961;
  t9721 = t1116 * t382 * t2214;
  t9724 = t1068 * t3058;
  t9740 = t9710 * t2555;
  t9747 = -0.6e1 * t165 * t2230 * t5732 * t7670 + 0.18e2 * t2272 * t6701 * t7646 + 0.18e2 * t2272 * t6701 * t7712 - 0.6e1 * t2544 * t2554 * t8918 - 0.12e2 * t7716 * t9704 * t9724 + 0.18e2 * t3059 * t9714 + 0.18e2 * t3059 * t9721 - 0.18e2 * t9705 * t9724 - 0.6e1 * t9721 * t9724 - t2547 - 0.3e1 * t9740;
  t9774 = 0.6e1 * t1975 * t2549 * t6772 - 0.6e1 * t2236 * t2544 * t4968 + 0.3e1 * t3071 * t5814 + t2552 - t2556 + 0.6e1 * t8893 - 0.6e1 * t8896 - 0.6e1 * t8898 + 0.6e1 * t8903 - 0.6e1 * t8913 - 0.4e1 * t8916 + 0.6e1 * t8933 + 0.6e1 * t8938 + 0.6e1 * t8947 + 0.6e1 * t8969 - 0.2e1 * t8971 + 0.6e1 * t8974 + 0.6e1 * t8980 - 0.6e1 * t8983 - 0.2e1 * t8988;
  t9775 = t1926 * t2914;
  t9783 = t1131 * t6605 * t298;
  t9784 = t2299 * t9783;
  t9794 = t1068 * t9067;
  t9805 = t1929 * t1578 * t3124 * t165;
  t9814 = t6521 * t2491;
  t9831 = 0.6e1 * t165 * t3115 * t3830 * t5800 + 0.3e1 * t165 * t379 * t7647 * t817 + 0.3e1 * t2214 * t3091 * t3589 + 0.11e2 * t2490 * t3748 * t6504 + 0.3e1 * t2201 * t5803 + 0.3e1 * t3076 * t5814 - 0.3e1 * t3076 * t5881 - t3084 * t5817 - t3084 * t5881 - 0.2e1 * t9805 - 0.3e1 * t9814;
  t9836 = t1926 * t3098;
  t9841 = t1960 * t2914;
  t9851 = t163 * t741 * t824 * t405;
  t9852 = t1960 * t3125;
  t9857 = t2221 * t1989;
  t9861 = 0.3e1 * t2201 * t5839 - t2201 * t5952 - 0.3e1 * t2209 * t5982 + 0.3e1 * t3084 * t5814 - 0.2e1 * t3102 * t5817 - 0.2e1 * t3116 * t5881 - 0.4e1 * t8999 - 0.6e1 * t9007 + 0.2e1 * t9023 - 0.2e1 * t9025 - 0.2e1 * t9041 - 0.2e1 * t9094 + 0.2e1 * t9163 + 0.2e1 * t9168 - 0.2e1 * t9172 - t9836 + t9841 - t9851 + t9852 + t9857;
  t9864 = t2282 - t2285 + t2303 - t2560 - t2563 + t3110 - 0.4e1 * t2947 + t3112 + t3119 - t3273 + t3126;
  t9869 = my_piecewise5(t64, 0, t67, 0, -0.6e1 * t1604 * t7609 + 0.12e2 * t7391 * t9599 - 0.7e1 * t7412 * t9658 - 0.18e2 * t7412 * t9695 + 0.6e1 * t7391 * t9695 + 0.6e1 * t7395 * t9695 + 0.18e2 * t3059 * t9705 - 0.18e2 * t9670 * t9714 - 0.3e1 * t5817 * t3071 - 0.2e1 * t1607 * t7634 + 0.3e1 * t2247 * t5896 + t9864 + t9861 + t9831 - t9784 + t9774 - t9775 + t9747 - 0.3e1 * t9711 + 0.3e1 * t9708 - t877 - t826 + t3107 - t3108 - t3109 - t3099 + t3093 - t3094 + t3090 + t3069 + t9689 - t9692 + t9644 + t9579 + 0.3e1 * t163 * t9542 * t1586 - 0.4e1 * t1929 * t1578 * t878 * t633 + t9068 * t3755 * t6586 * t298 + 0.6e1 * t9794 * t3743 * t2300 * t298);
  t9876 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t3131 + t9525 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.5e1 / 0.72e2 * t52 * t257 * t834 + t52 * t291 * t2312 / 0.24e2 + 0.2e1 * t618 * t886 + 0.2e1 * t260 * t2570 + t161 * t3129 + t59 * t9869));
  tv4rhosigma2lapl0 = t8 * t9876 + t3135;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  t9883 = t7 * t192 * t3216 / 0.1e2;
  t9885 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t3216 + t9883);
  tv4rhosigma2lapl11 = t8 * t9885 + t3220;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  t9891 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t3131 + t9525);
  tv4rhosigma2lapl12 = t8 * t9891 + t3135;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  t9907 = t3749 * t843;
  t9908 = t9907 * t2622;
  t9911 = t2641 * t9301;
  t9913 = t2645 * t9301;
  t9915 = t7063 * t4483;
  t9920 = t242 * t3148 * t236;
  t9927 = t576 * t843;
  t9928 = t575 * t9927;
  t9931 = t1115 * t843;
  t9932 = t9931 * t236;
  t9937 = t560 * t3141 * t4466;
  t9947 = -t2361 + t2389 - t2390 - t3145 - t3147 + t3152 + t2629 + t2663 - 0.7e1 * t7925 * t9908 - 0.3e1 * t9911 + 0.3e1 * t9913 + 0.7e1 * t560 * t9915 * t2638 + 0.11e2 * t7918 * t9920 - 0.11e2 * t7905 * t9920 + 0.3e1 * t234 * t798 * t4466 * t9928 - 0.11e2 * t7905 * t570 * t9932 - 0.3e1 * t9937 * t692 - 0.6e1 * t7909 * t1463 * t9932 - 0.3e1 * t9937 * t707 - 0.18e2 * t6995 * t2628;
  t9948 = t234 * t3142;
  t9951 = t9222 * t2635;
  t9953 = t4501 * t9915;
  t9957 = t3206 * t584;
  t9958 = t234 * t9957;
  t9959 = t9958 * t2365;
  t9962 = t1454 * t684 * t1458;
  t9966 = t1454 * t9915;
  t9975 = t2621 * t695;
  t9976 = t570 * t9975;
  t9980 = t2620 * t1463 * t9217;
  t9986 = t4501 * t9312 * t4483;
  t9987 = t7979 * t843;
  t9997 = t2620 * t9218;
  t10005 = t9907 * t1463 * t236;
  t10008 = t795 * t843;
  t10010 = t560 * t10008 * t584;
  t10013 = -0.12e2 * t9948 * t9423 + 0.3e1 * t9951 - 0.6e1 * t9953 * t4506 * t2634 + 0.3e1 * t9959 - 0.6e1 * t9962 * t1463 * t3142 - 0.12e2 * t9966 * t2635 + 0.6e1 * t2662 * t9405 + 0.6e1 * t2626 * t8066 + 0.3e1 * t7891 * t3150 + 0.6e1 * t2645 * t9976 - 0.2e1 * t9980 - 0.4e1 * t2620 * t1463 * t9975 + 0.11e2 * t9986 * t4506 * t9987 - 0.6e1 * t7925 * t4506 * t9907 * t236 + 0.6e1 * t2632 * t8077 - 0.3e1 * t9997 - 0.6e1 * t2620 * t9976 + 0.18e2 * t9986 * t1463 * t9987 - 0.12e2 * t7925 * t10005 - 0.3e1 * t10010 * t1442;
  t10015 = t6976 * t2628;
  t10019 = t2645 * t9218;
  t10023 = t2641 * t9283;
  t10024 = t2621 * t9262;
  t10029 = t242 * t6998;
  t10045 = t9931 * t2392;
  t10052 = t9907 * t2392;
  t10057 = 0.7e1 * t570 * t9986 * t9987 + 0.12e2 * t10005 * t7909 - 0.3e1 * t10010 * t1432 - 0.2e1 * t10024 * t2620 - 0.2e1 * t10024 * t2641 + 0.6e1 * t10024 * t2645 - 0.6e1 * t10029 * t2641 + 0.6e1 * t10029 * t2645 - 0.18e2 * t10045 * t7905 + 0.6e1 * t10045 * t7909 + 0.6e1 * t10045 * t7918 + 0.6e1 * t10052 * t7909 + t10052 * t7918 - t10052 * t7925 + 0.6e1 * t2632 * t8012 - 0.7e1 * t7905 * t9908 + 0.18e2 * t7909 * t9908 + 0.3e1 * t10015 + 0.3e1 * t10019 - t10023;
  t10062 = t9222 * t2638;
  t10066 = t2645 * t9283;
  t10068 = t2620 * t9283;
  t10088 = t1454 * t3142;
  t10090 = t1115 * t563 * t236;
  t10094 = 0.6e1 * t2145 * t2435 * t2670 * t695 - 0.12e2 * t10088 * t10090 * t7865 - 0.6e1 * t2665 * t2675 * t9266 - 0.6e1 * t2665 * t5492 * t9262 - t2668 + t2673 - t2677 + 0.6e1 * t9246 + 0.6e1 * t9270 - 0.6e1 * t9273 - 0.6e1 * t9275;
  t10098 = t560 * t9957;
  t10099 = t10098 * t2676;
  t10105 = t1480 * t563 * t2392;
  t10115 = t1510 * t569 * t10090;
  t10121 = t10098 * t2667;
  t10123 = t9958 * t2667;
  t10126 = t563 * params->csk_a;
  t10127 = t10126 * t236;
  t10128 = t1773 * t241 * t10127;
  t10142 = t2096 * t2995;
  t10143 = -0.6e1 * t236 * t2362 * t6271 * t7850 + 0.18e2 * t2417 * t6967 * t7861 + 0.18e2 * t2417 * t6967 * t7882 - 0.6e1 * t10088 * t10105 - 0.18e2 * t10088 * t10115 + 0.18e2 * t10105 * t3143 + 0.18e2 * t10115 * t3143 + 0.18e2 * t10128 * t3143 - 0.18e2 * t10128 * t9948 - 0.3e1 * t10099 - 0.3e1 * t10121 + 0.3e1 * t10123 - t10142 + 0.6e1 * t9278 - 0.2e1 * t9284 - 0.6e1 * t9286 + 0.6e1 * t9291 - 0.6e1 * t9302 + 0.6e1 * t9304 - 0.2e1 * t9306;
  t10146 = t2096 * t3165;
  t10150 = t1492 * t7163 * t315;
  t10151 = t2448 * t10150;
  t10157 = t1454 * t9312;
  t10181 = t2124 * t2995;
  t10191 = t2099 * t1773 * t3209 * t236;
  t10193 = -0.6e1 * t1801 * t8106 + 0.3e1 * t2345 * t6203 + 0.3e1 * t2345 * t6368 + 0.3e1 * t3154 * t6213 - t3154 * t6216 - t3154 * t6353 + 0.3e1 * t3161 * t6213 + 0.3e1 * t3178 * t6213 - 0.3e1 * t3178 * t6353 + t10181 - 0.2e1 * t10191;
  t10200 = t7079 * t2680;
  t10222 = t2360 * t2166;
  t10226 = t234 * t795 * t850 * t586;
  t10227 = t2124 * t3210;
  t10231 = 0.6e1 * t6179 * t5631 * t3200 * t236 - 0.3e1 * t10200 + 0.3e1 * t560 * t843 * t236 * t8143 + 0.11e2 * t7086 * t4556 * t2679 + 0.3e1 * t3189 * t4467 * t2392 - 0.2e1 * t9321 - 0.2e1 * t9388 - 0.2e1 * t9402 + 0.2e1 * t9412 - 0.4e1 * t9428 - 0.6e1 * t9435 - 0.3e1 * t2354 * t6437 - 0.2e1 * t6353 * t3201 + t10222 - t2345 * t6415 - t10226 + t10227 + 0.2e1 * t9473 - 0.2e1 * t9483 + 0.2e1 * t9500;
  t10234 = t2425 - t2434 + t2454 - t2685 - t2688 - 0.4e1 * t3019 + t3196 + t3197 + t3204 - t3342 + t3211;
  t10239 = my_piecewise5(t114, 0, t115, 0, t10231 + t10234 + t10193 - t10151 - t10146 + t10143 + 0.6e1 * t9237 + 0.6e1 * t9234 - 0.4e1 * t9223 + 0.6e1 * t9219 + t10094 + 0.3e1 * t10066 - t10068 + 0.3e1 * t10062 + 0.3e1 * t2371 * t6243 - 0.3e1 * t6216 * t3161 - 0.2e1 * t6216 * t3168 - 0.2e1 * t1790 * t8120 - 0.18e2 * t9966 * t2638 - 0.6e1 * t9953 * t2635 - 0.7e1 * t7905 * t10052 + t10057 + t10013 + t9947 - t903 - t3194 + t3191 - t3192 + t3193 + t3188 + t3173 - t3166 - t852 - t3158 + 0.3e1 * t234 * t10008 * t1787 + t9313 * t4577 * t7105 * t315 + 0.6e1 * t10157 * t4551 * t2449 * t315 - 0.4e1 * t2099 * t1773 * t904 * t695);
  t10246 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t3216 + t9883 + 0.3e1 / 0.2e2 * t7 * t94 * (-0.5e1 / 0.72e2 * t52 * t275 * t860 + t52 * t308 * t2457 / 0.24e2 + 0.2e1 * t680 * t912 + 0.2e1 * t278 * t2695 + t232 * t3214 + t113 * t10239));
  tv4rhosigma2lapl23 = t10246 * t8 + t3220;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  tv4rhosigma2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  tv4rhosigma2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  tv4rhosigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  t10253 = t7 * t145 * t3285 / 0.1e2;
  t10265 = t171 * t7489;
  t10268 = t922 * params->csk_a;
  t10273 = t2500 * t741;
  t10274 = t389 * t10273;
  t10277 = t1646 * t741;
  t10282 = t922 * t1115 * t263;
  t10286 = t8343 * t3595;
  t10287 = t3614 * t10286;
  t10299 = t1068 * t10286;
  t10311 = t3749 * t1074 * t1633 * t165;
  t10314 = t2220 - t2222 - t2229 + t2720 - t2725 - t2727 + 0.3e1 * t2719 * t8955 - 0.6e1 * t2527 * t10265 - 0.6e1 * t9584 * t3619 * t10268 * t263 + 0.6e1 * t2521 * t10274 + 0.6e1 * t8256 * t171 * t10277 + 0.11e2 * t9584 * t3619 * t10282 - 0.6e1 * t10287 * t3619 * t7422 * t165 + 0.6e1 * t7685 * t7483 - 0.6e1 * t9557 * t1077 * t922 * t263 * t403 - 0.12e2 * t10299 * t5062 + 0.6e1 * t2499 * t7501 - 0.6e1 * t2499 * t10274 + 0.18e2 * t9584 * t1077 * t10282 - 0.12e2 * t10287 * t10311;
  t10321 = t379 * t10286;
  t10322 = t389 * t5061;
  t10325 = t7422 * t2214;
  t10331 = t3749 * t386 * t624 * t165;
  t10342 = t171 * t741;
  t10343 = t2500 * t10342;
  t10356 = t163 * t10286;
  t10366 = -0.6e1 * t10268 * t1077 * t165 * t7464 - 0.4e1 * t10273 * t1077 * t2499 - 0.12e2 * t171 * t2550 * t8313 + 0.6e1 * t10265 * t2521 - t10287 * t10325 + 0.12e2 * t10299 * t10311 - 0.18e2 * t10299 * t10322 + 0.6e1 * t10299 * t10325 + 0.18e2 * t10299 * t10331 + 0.7e1 * t10321 * t10322 - 0.7e1 * t10321 * t10331 - 0.18e2 * t10321 * t2528 + t10325 * t10356 - 0.2e1 * t10343 * t2499 + 0.6e1 * t10343 * t2521 - 0.2e1 * t10343 * t2527 + 0.6e1 * t10356 * t2528 + 0.6e1 * t2499 * t7490 - 0.3e1 * t2724 * t8919 - 0.3e1 * t2724 * t8951;
  t10389 = t2500 * t74 * t7687;
  t10392 = -0.7e1 * t10321 * t10325 - 0.6e1 * t10389 * t8274 + 0.3e1 * t8893 - 0.3e1 * t8896 - 0.3e1 * t8898 + 0.6e1 * t9550 + 0.6e1 * t9552 - 0.4e1 * t9603 + 0.6e1 * t9611 - 0.6e1 * t9613 - 0.6e1 * t9620 + 0.6e1 * t9622 + 0.6e1 * t9656 + 0.6e1 * t9682 - 0.2e1 * t9684 + 0.6e1 * t9687 - 0.2e1 * t9692 + 0.6e1 * t9708 - 0.6e1 * t9711 - 0.6e1 * t9740;
  t10393 = t379 * t8255;
  t10403 = t7706 * t2550;
  t10423 = t2534 * t8961;
  t10436 = -0.18e2 * t10423 * t8283 + 0.18e2 * t10423 * t8288 + 0.3e1 * t8903 - 0.3e1 * t8913 - 0.2e1 * t8916 + 0.3e1 * t8933 + 0.3e1 * t8938 + 0.3e1 * t8947 + 0.3e1 * t8969 - t8971 + 0.3e1 * t8974;
  t10446 = t379 * t9067;
  t10447 = t388 * t922;
  t10483 = 0.3e1 * t8980 - 0.3e1 * t8983 - t8988 - 0.4e1 * t1929 * t1578 * t878 * t741 + 0.11e2 * t10446 * t3748 * t10447 * t263 - 0.3e1 * t2730 * t9064 - 0.2e1 * t2730 * t9080 + 0.3e1 * t2735 * t9034 - t2730 * t9034 + 0.3e1 * t2735 * t9014 + 0.3e1 * t2758 * t9028 - 0.3e1 * t2733 * t9014 - 0.2e1 * t1607 * t8330 + t9068 * t3755 * t4868 * t922 + 0.3e1 * t2730 * t4860 - t2733 * t9034 + 0.3e1 * t2765 * t4843 - 0.6e1 * t1922 * t7624 + 0.6e1 * t9794 * t3743 * t2774 * t263 + 0.3e1 * t2730 * t4954;
  t10489 = t922 * t165;
  t10511 = 0.3e1 * t10489 * t3240 * t3589 * t379 + 0.6e1 * t2486 * t3830 * t8390 + 0.3e1 * t2486 * t394 * t8475 - 0.2e1 * t2733 * t9165 - 0.3e1 * t2735 * t5101 + 0.3e1 * t2735 * t9064 - t2775 * t4780 - 0.2e1 * t8999 - 0.3e1 * t9007 + t9023 - t9025 - t9041 - t9094 - 0.2e1 * t9775 - 0.2e1 * t9784 - 0.4e1 * t9805 - 0.6e1 * t9814 - 0.2e1 * t9836 + 0.2e1 * t9841 - 0.2e1 * t9851;
  t10526 = t379 * t8414 * t384;
  t10529 = -0.7e1 * t10287 * t10331 + 0.7e1 * t10287 * t2502 - 0.11e2 * t10321 * t2502 - 0.11e2 * t10321 * t2535 + 0.11e2 * t10356 * t2535 - 0.3e1 * t10526 * t2535 + t2915 - t2917 - t2923 - t3228 + t3249 + t3257 + t3260 - t3261 - t3262 + t9163 + t9168 - t9172 + 0.2e1 * t9852 + 0.2e1 * t9857;
  t10545 = -t3271 + t2282 - t2285 + t2303 - t2782 + t2938 - t3111 + t2952 + t3272 - 0.4e1 * t3123 + t3274;
  t10550 = my_piecewise5(t64, 0, t67, 0, t10314 + 0.6e1 * t10299 * t2528 - 0.3e1 * t10526 * t10322 - 0.6e1 * t10299 * t2506 + 0.18e2 * t8306 * t10389 - 0.18e2 * t8274 * t10403 + 0.18e2 * t8306 * t10403 + 0.18e2 * t8274 * t7691 - 0.6e1 * t8313 * t10389 + t3267 + t10545 + t10529 - t929 + t10511 - t826 + t2766 + t2759 + t10483 - 0.12e2 * t8274 * t1077 * t1115 * t2550 + 0.18e2 * t8274 * t1077 * t263 * t2272 + 0.3e1 * t163 * t10489 * t3588 * t873 - 0.6e1 * t10393 * t3268 * t10342 + 0.6e1 * t1975 * t2549 * t7482 - 0.6e1 * t10393 * t4819 * t10277 - 0.18e2 * t8306 * t389 * t2550 + t10436 + t10366 + t10392);
  t10557 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t3285 + t10253 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.5e1 / 0.36e2 * t52 * t257 * t886 + t52 * t291 * t2570 / 0.12e2 + t618 * t935 + t260 * t2788 + t161 * t3283 + t59 * t10550));
  tv4rhosigmalapl20 = t10557 * t8 + t3289;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  t10564 = t7 * t192 * t3354 / 0.1e2;
  t10566 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t3354 + t10564);
  tv4rhosigmalapl28 = t10566 * t8 + t3358;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  t10572 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t3285 + t10253);
  tv4rhosigmalapl29 = t10572 * t8 + t3289;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  t10600 = -t2361 + t2389 - t2390 - t2825 + t2830 - t2832 - 0.6e1 * t9911 + 0.6e1 * t9913 + 0.6e1 * t9951 + 0.6e1 * t9959 - 0.4e1 * t9980 - 0.6e1 * t9997 + 0.6e1 * t10015 + 0.6e1 * t10019 - 0.2e1 * t10023 + 0.6e1 * t10062 + 0.6e1 * t10066 - 0.2e1 * t10068 + 0.3e1 * t9219 - 0.2e1 * t9223;
  t10615 = t560 * t8635;
  t10616 = t242 * t795;
  t10621 = t2621 * t122 * t9258;
  t10624 = t7873 * t2671;
  t10630 = t1841 * t795;
  t10642 = t2649 * t10127;
  t10648 = -0.12e2 * t1115 * t1463 * t2671 * t8618 + 0.18e2 * t1463 * t2417 * t281 * t8618 - 0.6e1 * t10615 * t10616 * t3302 - 0.6e1 * t10615 * t10630 * t5334 + 0.6e1 * t2145 * t2670 * t7995 - 0.6e1 * t10621 * t8618 - 0.6e1 * t10621 * t8663 + 0.18e2 * t10621 * t8666 - 0.18e2 * t10624 * t8618 + 0.18e2 * t10624 * t8666 - 0.18e2 * t10642 * t8644 + 0.18e2 * t10642 * t8647 + 0.18e2 * t7901 * t8618 - 0.6e1 * t10099 + 0.3e1 * t9234 + 0.3e1 * t9237 + 0.3e1 * t9246 + 0.3e1 * t9270 - 0.3e1 * t9273 - 0.3e1 * t9275;
  t10678 = t4577 * t5405 * t9313 * t945 - 0.2e1 * t1790 * t8686 - 0.2e1 * t2835 * t9358 - t2835 * t9390 - 0.3e1 * t2845 * t9343 - t2845 * t9390 + 0.3e1 * t2847 * t9337 + 0.3e1 * t2847 * t9343 + 0.3e1 * t2847 * t9390 + 0.3e1 * t2859 * t9405 + 0.3e1 * t2870 * t5458 - 0.6e1 * t10121 + 0.6e1 * t10123 + 0.3e1 * t9278 - t9284 - 0.3e1 * t9286 + 0.3e1 * t9291 - 0.3e1 * t9302 + 0.3e1 * t9304 - t9306;
  t10700 = t945 * t236;
  t10718 = -0.2e1 * t10142 - 0.2e1 * t10146 - 0.2e1 * t10151 + 0.2e1 * t10181 - 0.4e1 * t10191 - 0.6e1 * t10200 - t9321 - t9388 - t9402 + t9412 - 0.2e1 * t9428;
  t10731 = t8709 * t4483;
  t10732 = t560 * t10731;
  t10739 = t1454 * t10731;
  t10745 = t4501 * t10731;
  t10748 = t3749 * t567 * t686 * t236;
  t10753 = 0.3e1 * t10700 * t234 * t4466 * t899 - 0.18e2 * t2671 * t570 * t8666 - 0.11e2 * t10732 * t2623 - 0.6e1 * t10739 * t2656 - 0.7e1 * t10745 * t10748 + 0.7e1 * t10745 * t2623 - 0.2e1 * t2845 * t9502 - 0.3e1 * t2847 * t5614 - t2878 * t5309 + 0.2e1 * t10222 - 0.2e1 * t10226 + 0.2e1 * t10227 - t3297 + t3301 - t3305 - 0.3e1 * t9435 + t9473 - t9483 + t9500 - t952;
  t10754 = t234 * t10731;
  t10760 = t560 * t8780 * t565;
  t10763 = t570 * t5588;
  t10768 = t2621 * t795;
  t10769 = t570 * t10768;
  t10774 = t3749 * t1460 * t1817 * t236;
  t10781 = t945 * t1115 * t281;
  t10806 = t3294 * t10616;
  t10811 = t242 * t10768;
  t10816 = 0.11e2 * t10754 * t2650 - 0.11e2 * t10732 * t2650 - 0.3e1 * t10760 * t2650 - 0.3e1 * t10760 * t10763 + 0.6e1 * t10739 * t2643 + 0.6e1 * t2645 * t10769 - 0.12e2 * t10745 * t10774 - 0.4e1 * t2620 * t1463 * t10768 + 0.11e2 * t9986 * t4506 * t10781 - 0.6e1 * t10745 * t4506 * t7910 * t236 + 0.6e1 * t7854 * t7996 - 0.6e1 * t9962 * t1463 * t945 * t281 * t584 - 0.12e2 * t8663 * t242 * t2671 + 0.7e1 * t10732 * t10763 - 0.6e1 * t2620 * t10769 + 0.18e2 * t9986 * t1463 * t10781 + 0.6e1 * t2645 * t10806 - 0.3e1 * t2824 * t9263 - 0.2e1 * t2641 * t10811 + 0.6e1 * t2645 * t10811;
  t10835 = t945 * params->csk_a;
  t10840 = t7910 * t2392;
  t10842 = -0.2e1 * t2620 * t10811 - 0.3e1 * t2824 * t9267 + 0.6e1 * t2620 * t8006 + 0.6e1 * t8636 * t242 * t10630 + 0.3e1 * t2829 * t9252 - 0.6e1 * t2641 * t10806 - 0.12e2 * t10739 * t5589 + 0.6e1 * t2620 * t8072 - 0.6e1 * t9986 * t4506 * t10835 * t281 + t3309 + t3332 - t3338 - t3339 + t3340 - t2988 + t2996 - t2998 + t2860 + t2871 - t10745 * t10840;
  t10866 = -t852 + t2425 - t2434 + t2454 - t2885 - t3195 + t3023 + t3030 + t3341 - 0.4e1 * t3208 + t3343;
  t10871 = my_piecewise5(t114, 0, t115, 0, t10753 + t10718 + t10678 + t10648 + t10754 * t10840 - 0.7e1 * t10732 * t10840 + 0.6e1 * t10739 * t10840 + 0.18e2 * t10739 * t10748 + 0.12e2 * t10739 * t10774 - 0.18e2 * t10739 * t10763 - 0.7e1 * t10732 * t10748 + 0.6e1 * t10754 * t2643 - 0.18e2 * t10732 * t2643 + 0.3e1 * t2835 * t5390 - 0.6e1 * t2092 * t8165 + 0.3e1 * t2835 * t5435 - 0.3e1 * t2835 * t9337 + t10600 + t10866 + 0.6e1 * t10157 * t4551 * t2877 * t281 - 0.4e1 * t2099 * t1773 * t904 * t795 + 0.11e2 * t9346 * t4556 * t8690 * t281 + 0.3e1 * t560 * t10700 * t4467 * t3323 - 0.6e1 * t7978 * t1463 * t10835 * t236 + t10842 + t10816 + 0.3e1 * t8850 * t575 * t2615 + 0.6e1 * t8758 * t5631 * t2615);
  t10878 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t3354 + t10564 + 0.3e1 / 0.2e2 * t7 * t94 * (-0.5e1 / 0.36e2 * t52 * t275 * t912 + t52 * t308 * t2695 / 0.12e2 + t680 * t958 + t278 * t2893 + t232 * t3352 + t113 * t10871));
  tv4rhosigmalapl217 = t10878 * t8 + t3358;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  tv4rhosigmatau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  tv4rhosigmatau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  tv4rhosigmatau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  t10885 = t7 * t145 * t3420 / 0.1e2;
  t10901 = t2220 - t2222 - t2229 + t2720 - t2725 - t2727 + 0.9e1 * t9550 + 0.9e1 * t9552 - 0.6e1 * t9603 + 0.9e1 * t9611 - 0.9e1 * t9613 - 0.9e1 * t9620 + 0.9e1 * t9622 + 0.9e1 * t9656;
  t10909 = t3362 * t3593;
  t10910 = t379 * t10909;
  t10913 = t1068 * t10909;
  t10918 = t3614 * t10909;
  t10921 = t163 * t10909;
  t10927 = -0.18e2 * t10910 * t9043 - 0.7e1 * t10910 * t9114 - 0.7e1 * t10910 * t9121 + 0.12e2 * t10913 * t9076 + 0.6e1 * t10913 * t9114 - 0.6e1 * t10918 * t9009 + t10921 * t9114 + 0.9e1 * t9682 - 0.3e1 * t9684 + 0.9e1 * t9687 - 0.3e1 * t9692 + 0.9e1 * t9708 - 0.9e1 * t9711 - 0.9e1 * t9740;
  t10938 = t3618 * t3362;
  t10940 = t3755 * t10938 * t1115;
  t10948 = t1076 * t3362;
  t10950 = t1131 * t10948 * t403;
  t10959 = t3362 * t382;
  t10960 = t163 * t10959;
  t10964 = t379 * t10959;
  t10967 = t1094 * t10342;
  t10970 = 0.9e1 * t1111 * t2758 * t394 * t741 - 0.6e1 * t1068 * t10950 * t622 - 0.12e2 * t10960 * t1578 * t7687 + 0.7e1 * t10910 * t9130 - 0.11e2 * t10910 * t9139 - 0.12e2 * t10913 * t9009 - 0.18e2 * t10913 * t9130 - t10918 * t9114 + 0.6e1 * t10921 * t9043 + 0.11e2 * t10921 * t9139 + 0.11e2 * t10940 * t9068 - 0.18e2 * t10964 * t8996 + 0.9e1 * t10967 * t2735 + 0.9e1 * t2765 * t5896;
  t10972 = t1578 * t1600 * t741;
  t10980 = t3755 * t10938 * params->csk_a;
  t10988 = t1122 * t1136 * t741;
  t10994 = t3743 * t10948 * t1115;
  t11011 = -0.6e1 * t1131 * t1146 * t2730 * t741 - 0.11e2 * t10910 * t8992 + 0.7e1 * t10918 * t8992 - 0.12e2 * t10918 * t9076 - 0.6e1 * t10918 * t9089 - 0.9e1 * t10967 * t2733 - 0.3e1 * t10972 * t2730 - 0.3e1 * t10972 * t2733 + 0.9e1 * t10972 * t2735 - 0.6e1 * t10980 * t9068 - 0.9e1 * t10988 * t2730 + 0.9e1 * t10988 * t2735 + 0.18e2 * t10994 * t9068 + 0.9e1 * t2730 * t5803 + 0.9e1 * t2730 * t5839;
  t11018 = t3362 * t3588;
  t11019 = t379 * t11018;
  t11024 = t3362 * t165;
  t11038 = t3755 * t10938;
  t11040 = 0.3e1 * t11024 * t163 * t4807 - 0.6e1 * t10913 * t9002 + 0.6e1 * t10913 * t9043 + 0.18e2 * t10913 * t9121 - 0.7e1 * t10918 * t9121 - 0.3e1 * t11019 * t630 - 0.3e1 * t11019 * t645 + t11038 * t9068 - 0.3e1 * t9775 - 0.3e1 * t9784 - 0.6e1 * t9805 - 0.9e1 * t9814 - 0.3e1 * t9836 + 0.3e1 * t9841;
  t11043 = t3743 * t10948;
  t11047 = t3748 * t388 * t3362;
  t11060 = t163 * t11018;
  t11066 = t3371 * t1072;
  t11067 = t1068 * t11066;
  t11068 = t389 * t9704;
  t11071 = t163 * t11066;
  t11074 = t379 * t11066;
  t11077 = 0.3e1 * t11024 * t3601 * t379 - 0.6e1 * t1578 * t2733 * t2779 + 0.11e2 * t10446 * t11047 + 0.6e1 * t10921 * t9158 + 0.6e1 * t11043 * t9794 + 0.3e1 * t11060 * t640 - 0.18e2 * t11067 * t11068 - 0.18e2 * t11071 * t8962 + 0.18e2 * t11074 * t8962 - 0.3e1 * t2730 * t5952 - 0.9e1 * t2735 * t5982 - 0.3e1 * t9851 + 0.3e1 * t9852 + 0.3e1 * t9857;
  t11079 = t10959 * t1072;
  t11080 = t379 * t11079;
  t11086 = t1068 * t11079;
  t11098 = t1077 * t3371 * params->csk_a;
  t11108 = t163 * t11079;
  t11111 = 0.9e1 * t171 * t2719 * t3573 * t741 - 0.9e1 * t2724 * t389 * t4963 * t741 - 0.9e1 * t10342 * t2724 * t4963 - 0.12e2 * t1077 * t11067 * t9704 + 0.18e2 * t11068 * t11074 + 0.18e2 * t11080 * t8924 - 0.6e1 * t11086 * t8924 + 0.18e2 * t11086 * t8985 + 0.18e2 * t11098 * t9557 - 0.6e1 * t11108 * t8924 - t3374 + t3378 - t3380 + t3381;
  t11112 = 0.6e1 * t3123;
  t11113 = -t3382 - t3383 - t826 - t929 + t2759 + t2766 + t2282 - t2285 + t2303 - t2782 + t3384 - t11112 + t3387 + t3390 + t3393;
  t11117 = my_piecewise5(t64, 0, t67, 0, t10901 + t10927 + t10970 + t11011 + t11040 + t11077 + t11111 + t11113);
  t11124 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t140 * t3420 + t10885 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.5e1 / 0.24e2 * t52 * t257 * t935 + t52 * t291 * t2788 / 0.8e1 + t161 * t3418 + t59 * t11117));
  tv4rholapl30 = t11124 * t8 + t3424;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  t11131 = t7 * t192 * t3486 / 0.1e2;
  t11133 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t188 * t3486 + t11131);
  tv4rholapl33 = t11133 * t8 + t3490;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  t11139 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t205 * t3420 + t10885);
  tv4rholapl34 = t11139 * t8 + t3424;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  t11152 = t234 * t3437 * t1458;
  t11162 = -0.18e2 * t11152 * t9295 + 0.9e1 * t10015 - t2361 + t2389 - t2390 - t2825 + t2830 - t2832 - 0.9e1 * t9911 + 0.9e1 * t9913 + 0.9e1 * t9951 + 0.9e1 * t9959 - 0.6e1 * t9980 - 0.9e1 * t9997;
  t11171 = t3428 * t4481;
  t11172 = t234 * t11171;
  t11175 = t4501 * t11171;
  t11179 = t560 * t11171;
  t11182 = t1454 * t11171;
  t11186 = 0.6e1 * t11172 * t9418 + t11172 * t9444 - 0.6e1 * t11175 * t9374 - t11175 * t9444 - 0.7e1 * t11179 * t9444 + 0.6e1 * t11182 * t9444 + 0.9e1 * t10019 - 0.3e1 * t10023 + 0.9e1 * t10062 + 0.9e1 * t10066 - 0.3e1 * t10068 - 0.9e1 * t10099 - 0.9e1 * t10121 + 0.9e1 * t10123;
  t11202 = t569 * t3428;
  t11204 = t1510 * t11202 * t584;
  t11208 = t4556 * t11202 * params->csk_a;
  t11215 = t4505 * t3428;
  t11217 = t4577 * t11215 * t1115;
  t11223 = t1510 * t1525 * t795;
  t11228 = t1484 * t10616;
  t11231 = -0.6e1 * t1492 * t1493 * t2835 * t795 + 0.9e1 * t1506 * t2859 * t575 * t795 - 0.18e2 * t10157 * t11208 + 0.11e2 * t11172 * t9370 - 0.6e1 * t11175 * t9367 - 0.18e2 * t11179 * t9418 - 0.7e1 * t11179 * t9460 + 0.6e1 * t11182 * t9418 + 0.12e2 * t11182 * t9456 - 0.18e2 * t11204 * t685 + 0.11e2 * t11217 * t9313 - 0.9e1 * t11223 * t2835 + 0.9e1 * t11223 * t2847 + 0.9e1 * t11228 * t2847;
  t11236 = t1480 * t10616;
  t11250 = t4577 * t11215 * params->csk_a;
  t11258 = t1462 * t3428;
  t11260 = t1492 * t11258 * t584;
  t11266 = t4551 * t11258 * t1115;
  t11271 = -0.6e1 * t11260 * t1454 * t684 + 0.7e1 * t11175 * t9354 - 0.11e2 * t11179 * t9354 + 0.7e1 * t11179 * t9440 - 0.12e2 * t11182 * t9374 - 0.9e1 * t11228 * t2845 - 0.3e1 * t11236 * t2835 - 0.3e1 * t11236 * t2845 + 0.9e1 * t11236 * t2847 - 0.6e1 * t11250 * t9313 + 0.18e2 * t11266 * t9313 + 0.9e1 * t2835 * t6203 + 0.9e1 * t2835 * t6368 + 0.9e1 * t2870 * t6243 - 0.12e2 * t3465 * t9423;
  t11280 = t3428 * t4466;
  t11281 = t560 * t11280;
  t11286 = t3428 * t236;
  t11300 = 0.3e1 * t11286 * t234 * t5344 - 0.12e2 * t11175 * t9456 - 0.7e1 * t11175 * t9460 - 0.11e2 * t11179 * t9370 - 0.6e1 * t11182 * t9430 + 0.18e2 * t11182 * t9460 - 0.3e1 * t11281 * t692 - 0.3e1 * t11281 * t707 - 0.3e1 * t10142 - 0.3e1 * t10146 - 0.3e1 * t10151 + 0.3e1 * t10181 - 0.6e1 * t10191 - 0.9e1 * t10200;
  t11306 = t234 * t11280;
  t11311 = t4577 * t11215;
  t11316 = t4556 * t11202;
  t11321 = t4551 * t11258;
  t11328 = t3428 * t563 * t1458;
  t11329 = t560 * t11328;
  t11332 = 0.3e1 * t11286 * t4493 * t560 - 0.6e1 * t1773 * t2845 * t2882 + 0.6e1 * t10157 * t11321 + 0.6e1 * t11172 * t9488 + 0.3e1 * t11306 * t702 + t11311 * t9313 + 0.11e2 * t11316 * t9346 + 0.18e2 * t11329 * t9239 - 0.3e1 * t2835 * t6415 - 0.9e1 * t2847 * t6437 + 0.3e1 * t10222 - 0.3e1 * t10226 + 0.3e1 * t10227 - t952;
  t11334 = t1454 * t11328;
  t11337 = t234 * t11328;
  t11352 = t1463 * t3437 * params->csk_a;
  t11365 = 0.9e1 * t242 * t2829 * t4456 * t795 - 0.9e1 * t2824 * t4449 * t570 * t795 - 0.9e1 * t10616 * t2824 * t4449 + 0.18e2 * t11329 * t2418 + 0.18e2 * t11329 * t9259 - 0.12e2 * t11334 * t9229 - 0.18e2 * t11334 * t9239 - 0.6e1 * t11334 * t9259 + 0.18e2 * t11334 * t9280 - 0.6e1 * t11337 * t9259 + 0.18e2 * t11352 * t9962 - t3440 - t3442 + t3446;
  t11366 = 0.6e1 * t3208;
  t11367 = -t3447 - t3448 + t3449 + t2860 + t2871 - t852 + t2425 - t2434 + t2454 - t2885 + t3450 - t11366 + t3453 + t3467 + t3470;
  t11371 = my_piecewise5(t114, 0, t115, 0, t11162 + t11186 + t11231 + t11271 + t11300 + t11332 + t11365 + t11367);
  t11378 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t216 * t3486 + t11131 + 0.3e1 / 0.2e2 * t7 * t94 * (-0.5e1 / 0.24e2 * t52 * t275 * t958 + t52 * t308 * t2893 / 0.8e1 + t232 * t3484 + t113 * t11371));
  tv4rholapl37 = t11378 * t8 + t3490;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  tv4rhotau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  tv4rhotau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  tv4rhotau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  tv4rhotau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t11382 = t824 * t817;
  t11383 = t11382 * t403;
  t11385 = t163 * t11383 * t1046;
  t11387 = t379 * t11383;
  t11388 = t11387 * t1046;
  t11390 = t11387 * t1063;
  t11392 = t6521 * t3076;
  t11394 = t817 * t817;
  t11395 = t11394 * t403;
  t11396 = t163 * t11395;
  t11402 = t1578 * t2913;
  t11403 = t2205 * t11402;
  t11406 = t1131 * t1146 * t824;
  t11407 = t2201 * t11406;
  t11409 = t11394 * t382;
  t11410 = t1068 * t11409;
  t11418 = t2247 * t6695;
  t11422 = t379 * t11409;
  t11425 = t1116 * t8967;
  t11426 = t2201 * t11425;
  t11428 = t2201 * t6607;
  t11431 = t1122 * t1136 * t824;
  t11432 = t2209 * t11431;
  t11434 = t2201 * t11431;
  t11436 = t2201 * t6663;
  t11440 = t2205 * t11425;
  t11442 = t2209 * t11425;
  t11444 = 0.18e2 * t11410 * t3687 + 0.18e2 * t11410 * t3715 + 0.18e2 * t11422 * t3729 + 0.18e2 * t11418 - 0.6e1 * t11426 + 0.18e2 * t11428 + 0.18e2 * t11432 - 0.18e2 * t11434 + 0.18e2 * t11436 - 0.6e1 * t11440 + 0.18e2 * t11442;
  t11454 = t163 * t11382 * t1586;
  t11456 = t11394 * t3593;
  t11457 = t3614 * t11456;
  t11462 = t2201 * t6808;
  t11472 = t1068 * t11456;
  t11475 = t379 * t11456;
  t11482 = t163 * t11456;
  t11494 = -0.6e1 * t11457 * t3744 - 0.7e1 * t11457 * t3751 + 0.7e1 * t11457 * t3773 - t11457 * t3851 + 0.18e2 * t11472 * t3751 + 0.12e2 * t11472 * t3761 - 0.18e2 * t11472 * t3796 + 0.6e1 * t11472 * t3851 - 0.7e1 * t11475 * t3751 - 0.7e1 * t11475 * t3851 + t11482 * t3851;
  t11497 = t11394 * t3588;
  t11498 = t379 * t11497;
  t11514 = t6518 * t3116;
  t11521 = t2209 * t6830;
  t11527 = t824 * t824;
  t11528 = t11527 * t382;
  t11529 = t379 * t11528;
  t11531 = 0.3e1 * t11529 * t396;
  t11534 = 0.3e1 * t163 * t11528 * t396;
  t11536 = 0.3e1 * t11529 * t413;
  t11545 = t163 * t11394;
  t11548 = -0.6e1 * t11410 * t3815 - 0.12e2 * t11472 * t3744 - 0.11e2 * t11475 * t3773 + 0.7e1 * t11475 * t3796 - 0.11e2 * t11475 * t3831 + 0.11e2 * t11482 * t3831 + 0.3e1 * t11545 * t3590 - 0.18e2 * t11521 - t11531 + t11534 - t11536;
  t11552 = t379 * t11394;
  t11560 = t163 * t11527;
  t11562 = 0.3e1 * t11560 * t407;
  t11565 = 0.3e1 * t379 * t11527 * t390;
  t11567 = 0.3e1 * t11560 * t405;
  t11582 = -0.4e1 * t2921 - 0.4e1 * t2923 - 0.4e1 * t2925 + 0.4e1 * t2929 - t826 - t828 + 0.4e1 * t2938 - 0.9e1 * t2947 + 0.4e1 * t2950 + 0.4e1 * t2952 + 0.4e1 * t2955;
  t11586 = my_piecewise5(t64, 0, t67, 0, t11582 - t11567 + t11562 + t11565 + t11548 - 0.12e2 * t11514 + t11494 - 0.6e1 * t11462 + 0.18e2 * t11454 + t11444 - 0.12e2 * t11407 - 0.18e2 * t11403 - 0.18e2 * t11390 + 0.18e2 * t11392 + 0.18e2 * t11385 - 0.18e2 * t11388 - 0.4e1 * t2917 + 0.4e1 * t2915 - 0.12e2 * t11410 * t1131 * t1146 * t403 + 0.6e1 * t11545 * t3597 + 0.11e2 * t11552 * t3605 + 0.3e1 * t11552 * t3601 - 0.6e1 * t11472 * t3778 - 0.3e1 * t11498 * t396 - 0.3e1 * t11498 * t413 + 0.6e1 * t11482 * t3861 - 0.18e2 * t11475 * t3861 + 0.6e1 * t11472 * t3861 - 0.18e2 * t11422 * t3834 - 0.12e2 * t11396 * t3842 + 0.18e2 * t11422 * t3638 - 0.6e1 * t11410 * t3638 + 0.11e2 * t11457 * t3757 - 0.6e1 * t11457 * t3767 - 0.6e1 * t11457 * t3782 + 0.18e2 * t11457 * t3778 - 0.12e2 * t11457 * t3761 - 0.18e2 * t11396 * t3665 - 0.18e2 * t11410 * t3729 + 0.3e1 * t163 * t11497 * t396 + 0.6e1 * t1068 * t11394 * t3609 + t3614 * t11394 * t3620 + 0.18e2 * t379 * t11395 * t3665 - 0.6e1 * t163 * t11409 * t3638);
  t11592 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (t11586 * t59 + 0.4e1 * t260 * t2970));
  tv4sigma40 = t8 * t11592;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t11596 = t242 * t4456 * t850;
  t11597 = t2416 * t11596;
  t11599 = t850 * t843;
  t11601 = t560 * t11599 * t584;
  t11602 = t11601 * t1432;
  t11604 = t11601 * t1442;
  t11606 = t843 * t843;
  t11607 = t11606 * t563;
  t11608 = t234 * t11607;
  t11611 = t1773 * t2994;
  t11612 = t2380 * t11611;
  t11614 = t7079 * t3178;
  t11616 = t11606 * t584;
  t11620 = t1454 * t11607;
  t11624 = t234 * t11599 * t1787;
  t11627 = t1480 * t242 * t850;
  t11628 = t2345 * t11627;
  t11631 = t2371 * t7219;
  t11634 = t1480 * t570 * t850;
  t11635 = t2345 * t11634;
  t11637 = t2345 * t7165;
  t11640 = t1492 * t1493 * t850;
  t11641 = t2345 * t11640;
  t11643 = t2354 * t11634;
  t11645 = t560 * t11607;
  t11650 = t2380 * t11627;
  t11652 = t2354 * t11627;
  t11658 = -0.6e1 * t11608 * t4370 + 0.18e2 * t11620 * t4397 + 0.18e2 * t11645 * t4370 + 0.18e2 * t11645 * t4408 + 0.18e2 * t11631 - 0.18e2 * t11635 + 0.18e2 * t11637 - 0.12e2 * t11641 + 0.18e2 * t11643 - 0.6e1 * t11650 + 0.18e2 * t11652;
  t11666 = t2345 * t7140;
  t11668 = t11606 * t4481;
  t11669 = t4501 * t11668;
  t11672 = t2345 * t7291;
  t11676 = t560 * t11668;
  t11686 = t234 * t11668;
  t11690 = t1454 * t11668;
  t11706 = -0.6e1 * t11669 * t4552 - 0.6e1 * t11669 * t4583 - t11669 * t4650 - 0.7e1 * t11676 * t4558 - 0.18e2 * t11676 * t4646 - 0.7e1 * t11676 * t4650 + 0.6e1 * t11686 * t4646 + t11686 * t4650 - 0.18e2 * t11690 * t4571 + 0.6e1 * t11690 * t4650 + 0.12e2 * t11690 * t4659;
  t11715 = t11606 * t4466;
  t11716 = t560 * t11715;
  t11720 = t1773 * t9421;
  t11725 = t2354 * t7275;
  t11731 = t7076 * t3201;
  t11741 = t850 * t850;
  t11742 = t11741 * t563;
  t11743 = t560 * t11742;
  t11745 = 0.3e1 * t11743 * t577;
  t11747 = 0.3e1 * t11743 * t594;
  t11752 = 0.3e1 * t234 * t11742 * t577;
  t11761 = t11606 * t4501 * t4507 + 0.3e1 * t11715 * t234 * t577 - 0.6e1 * t11620 * t4612 - 0.7e1 * t11669 * t4558 - 0.11e2 * t11676 * t4633 + 0.11e2 * t11686 * t4633 + 0.18e2 * t11690 * t4558 - 0.6e1 * t11690 * t4567 - t11745 - t11747 + t11752;
  t11763 = t234 * t11606;
  t11771 = t560 * t11606;
  t11776 = t234 * t11741;
  t11778 = 0.3e1 * t11776 * t588;
  t11781 = 0.3e1 * t560 * t11741 * t571;
  t11783 = 0.3e1 * t11776 * t586;
  t11796 = 0.4e1 * t2996 - 0.4e1 * t2998 - 0.4e1 * t3000 + 0.4e1 * t3004 - t852 - t854 - 0.9e1 * t3019 + 0.4e1 * t3023 + 0.4e1 * t3028 + 0.4e1 * t3030 + 0.4e1 * t3033;
  t11800 = my_piecewise5(t114, 0, t115, 0, 0.3e1 * t11763 * t4468 + 0.6e1 * t11763 * t4489 + 0.3e1 * t11771 * t4493 + 0.11e2 * t11771 * t4496 - 0.3e1 * t11716 * t594 - 0.12e2 * t11690 * t4552 - 0.18e2 * t11645 * t4629 + 0.7e1 * t11669 * t4574 - 0.12e2 * t11669 * t4659 + 0.6e1 * t11690 * t4646 - 0.3e1 * t11716 * t577 - 0.6e1 * t11669 * t4590 + 0.7e1 * t11676 * t4571 - 0.11e2 * t11676 * t4574 + 0.11e2 * t11669 * t4579 - 0.6e1 * t11620 * t4370 - 0.18e2 * t11620 * t4408 + 0.18e2 * t11620 * t4517 + 0.18e2 * t11669 * t4567 - 0.12e2 * t11620 * t4433 - 0.18e2 * t11608 * t4376 + t11796 + t11781 - t11783 + t11778 + t11761 - 0.12e2 * t11731 - 0.18e2 * t11725 + t11706 - 0.6e1 * t11672 + 0.18e2 * t11666 + t11658 - 0.6e1 * t11628 + 0.18e2 * t11624 - 0.18e2 * t11612 + 0.18e2 * t11614 - 0.18e2 * t11604 - 0.18e2 * t11602 + 0.18e2 * t11597 - 0.4e1 * t2992 - 0.4e1 * t2988 + 0.18e2 * t560 * t11616 * t5512 - 0.12e2 * t234 * t11616 * t11720 + 0.6e1 * t1454 * t11606 * t4485);
  t11806 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * (t113 * t11800 + 0.4e1 * t278 * t3045));
  tv4sigma414 = t8 * t11806;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  t11816 = t171 * t8900 * t263;
  t11817 = t2527 * t11816;
  t11818 = 0.9e1 * t11817;
  t11819 = t2521 * t11816;
  t11820 = 0.9e1 * t11819;
  t11821 = t298 * t2904;
  t11822 = t11821 * t403;
  t11823 = t379 * t11822;
  t11826 = t8912 * t7520;
  t11827 = 0.9e1 * t11826;
  t11828 = t8935 * t2534;
  t11829 = t2521 * t11828;
  t11830 = 0.9e1 * t11829;
  t11831 = t2499 * t11828;
  t11832 = 0.3e1 * t11831;
  t11834 = t2509 * t389 * t9609;
  t11835 = 0.9e1 * t11834;
  t11839 = t394 * t1111 * t824;
  t11840 = t2541 * t11839;
  t11841 = 0.9e1 * t11840;
  t11844 = 0.18e2 * t11823 * t3659 + 0.18e2 * t11823 * t3665 + 0.18e2 * t5780 * t8907 - t11818 + t11820 + t11827 + t11830 - t11832 + t11835 + t11841 - 0.4e1 * t3060 + 0.4e1 * t3065 - 0.4e1 * t3067;
  t11845 = t1068 * t11822;
  t11859 = t2499 * t1077 * t8935 * t263;
  t11860 = 0.6e1 * t11859;
  t11861 = t8935 * t3240;
  t11862 = t2499 * t11861;
  t11863 = 0.9e1 * t11862;
  t11866 = t8912 * t7401;
  t11867 = 0.9e1 * t11866;
  t11870 = t2521 * t11861;
  t11871 = 0.9e1 * t11870;
  t11872 = t2527 * t11828;
  t11873 = 0.3e1 * t11872;
  t11879 = -0.6e1 * t1115 * t171 * t2904 * t403 * t5732 - 0.18e2 * t11822 * t163 * t3665 + 0.18e2 * t11823 * t3724 - 0.6e1 * t11845 * t3659 - 0.12e2 * t11845 * t3704 - 0.18e2 * t11845 * t3724 + 0.18e2 * t5785 * t8907 + 0.9e1 * t11385 - 0.9e1 * t11388 - t11860 - t11863 + t11867 + t11871 - t11873;
  t11883 = t394 * t170 * t3268;
  t11884 = t9610 * t11883;
  t11885 = 0.9e1 * t11884;
  t11886 = t9710 * t11883;
  t11887 = 0.9e1 * t11886;
  t11888 = t4963 * t824;
  t11890 = t2544 * t2554 * t11888;
  t11891 = 0.9e1 * t11890;
  t11894 = t170 * t2904;
  t11896 = t3830 * t11894 * params->csk_a;
  t11901 = t379 * t11821;
  t11904 = t163 * t11821;
  t11917 = -0.11e2 * t1136 * t2904 * t3748 * t5794 - 0.11e2 * t11896 * t5794 + 0.11e2 * t11896 * t5800 - 0.3e1 * t11901 * t4807 - 0.3e1 * t11901 * t4820 + 0.3e1 * t11904 * t4807 - 0.6e1 * t5791 * t9071 - 0.18e2 * t5869 * t8995 + 0.7e1 * t5884 * t8991 - 0.9e1 * t11390 + t11885 - t11887 - t11891;
  t11924 = t3850 * t2904 * t1074 * t1076;
  t11937 = t1929 * t1578 * t878 * t824;
  t11938 = 0.6e1 * t11937;
  t11939 = t1607 * t9783;
  t11940 = 0.3e1 * t11939;
  t11945 = t1604 * t1122 * t732 * t824;
  t11946 = 0.9e1 * t11945;
  t11950 = t2904 * t74 * t170;
  t11951 = t3850 * t11950;
  t11957 = -0.6e1 * t2904 * t3755 * t3766 * t5828 - 0.12e2 * t11904 * t4815 - 0.12e2 * t11924 * t5828 + 0.6e1 * t11951 * t5791 - 0.7e1 * t11951 * t5794 - t11951 * t5828 - 0.12e2 * t5806 * t9001 - 0.6e1 * t5844 * t9074 - 0.6e1 * t5900 * t9104 + 0.11e2 * t5913 * t9074 + 0.18e2 * t5919 * t9074 - t11938 - t11940 - t11946;
  t11966 = t3850 * t2904 * t386 * t388;
  t11977 = t3860 * t11950;
  t11987 = 0.12e2 * t11924 * t5791 + t11951 * t5800 + 0.18e2 * t11966 * t5791 - 0.7e1 * t11966 * t5794 - 0.7e1 * t11966 * t5828 + 0.6e1 * t11977 * t5791 - 0.18e2 * t11977 * t5794 + 0.6e1 * t11977 * t5800 - 0.6e1 * t5806 * t9074 + 0.7e1 * t5856 * t9074 - 0.18e2 * t5884 * t9001 + 0.9e1 * t11392 - 0.9e1 * t11403;
  t12006 = 0.6e1 * t11894 * t3830 * t5800 + 0.3e1 * t11904 * t3590 + t5955 * t9074 + 0.6e1 * t5985 * t9001 - 0.6e1 * t11407 + 0.9e1 * t11418 - 0.3e1 * t11426 + 0.9e1 * t11428 + 0.9e1 * t11432 - 0.9e1 * t11434 + 0.9e1 * t11436 - 0.3e1 * t11440 + 0.9e1 * t11442 + 0.9e1 * t11454;
  t12016 = 0.11e2 * t5973 * t8991 + 0.3e1 * t733 * t9047 - 0.3e1 * t11462 - 0.6e1 * t11514 - 0.9e1 * t11521 - t11531 + t11534 - t11536 + t11562 + t11565 - t11567 + t3069 + 0.4e1 * t3089;
  t12018 = 0.4e1 * t3092 - t3094 - t3099 + t2916 - t2918 - t2924 - t826 - t877 + t2939 - t9179 + t2953 + t3119 - t3385 + t3126;
  t12022 = my_piecewise5(t64, 0, t67, 0, t11844 + t11879 + t11917 + t11957 + t11987 + t12006 + t12016 + t12018);
  t12028 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (t52 * t291 * t2970 / 0.24e2 + 0.3e1 * t260 * t3129 + t59 * t12022));
  tv4sigma3lapl0 = t8 * t12028;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  t12038 = t242 * t9243 * t281;
  t12039 = t2641 * t12038;
  t12040 = 0.9e1 * t12039;
  t12041 = t2645 * t12038;
  t12042 = 0.9e1 * t12041;
  t12043 = t9216 * t281;
  t12044 = t242 * t12043;
  t12045 = t2641 * t12044;
  t12046 = 0.3e1 * t12045;
  t12047 = t9216 * t3323;
  t12048 = t2620 * t12047;
  t12049 = 0.9e1 * t12048;
  t12050 = t9222 * t7937;
  t12051 = 0.9e1 * t12050;
  t12055 = t575 * t1506 * t850;
  t12056 = t2662 * t12055;
  t12057 = 0.9e1 * t12056;
  t12058 = t315 * t2979;
  t12059 = t12058 * t584;
  t12060 = t1454 * t12059;
  t12064 = t2626 * t570 * t9957;
  t12065 = 0.9e1 * t12064;
  t12068 = -0.18e2 * t12060 * t4403 - 0.12e2 * t12060 * t5535 + 0.18e2 * t6318 * t9227 - t12040 + t12042 - t12046 - t12049 + t12051 + t12057 + t12065 - 0.4e1 * t3144 - 0.4e1 * t3146 + 0.4e1 * t3151;
  t12072 = t560 * t12059;
  t12075 = t9222 * t8037;
  t12076 = 0.9e1 * t12075;
  t12077 = t2645 * t12044;
  t12078 = 0.9e1 * t12077;
  t12079 = t2620 * t12044;
  t12080 = 0.3e1 * t12079;
  t12081 = t2645 * t12047;
  t12082 = 0.9e1 * t12081;
  t12097 = t2620 * t1463 * t12043;
  t12098 = 0.6e1 * t12097;
  t12101 = -0.6e1 * t1115 * t242 * t2979 * t584 * t6271 - 0.18e2 * t12059 * t234 * t5512 - 0.6e1 * t12060 * t4392 + 0.18e2 * t12072 * t4392 + 0.18e2 * t12072 * t4403 + 0.18e2 * t12072 * t5512 + 0.18e2 * t6321 * t9227 + 0.9e1 * t11597 - 0.9e1 * t11602 + t12076 + t12078 - t12080 + t12082 - t12098;
  t12105 = t1429 * t281 * t1431;
  t12106 = t10098 * t12105;
  t12107 = 0.9e1 * t12106;
  t12108 = t4449 * t850;
  t12110 = t2665 * t2675 * t12108;
  t12111 = 0.9e1 * t12110;
  t12112 = t9958 * t12105;
  t12113 = 0.9e1 * t12112;
  t12116 = t4649 * t2979 * t567 * t569;
  t12119 = t234 * t12058;
  t12126 = t560 * t12058;
  t12130 = t5631 * t2381 * t2979;
  t12135 = t4649 * t2979 * t122 * t241;
  t12142 = -0.11e2 * t1525 * t2979 * t4556 * t6193 - 0.7e1 * t12116 * t6196 + 0.3e1 * t12119 * t5344 - 0.3e1 * t12126 * t5344 + 0.6e1 * t12130 * t6179 + t12135 * t6179 - 0.7e1 * t12135 * t6193 - t12135 * t6196 + 0.6e1 * t12135 * t6200 - 0.9e1 * t11604 - t12107 - t12111 + t12113;
  t12150 = t4551 * t4658 * t2979;
  t12165 = -0.7e1 * t12116 * t6193 + 0.18e2 * t12116 * t6200 - 0.18e2 * t12130 * t6193 + 0.12e2 * t12150 * t6200 - 0.6e1 * t6171 * t9365 - 0.18e2 * t6231 * t9373 - 0.9e1 * t11612 + 0.9e1 * t11614 + 0.9e1 * t11624 - 0.3e1 * t11628 + 0.9e1 * t11631 - 0.9e1 * t11635 + 0.9e1 * t11637 - 0.6e1 * t11641;
  t12177 = t241 * t2979;
  t12188 = 0.6e1 * t12177 * t5631 * t6179 + 0.3e1 * t12119 * t4468 + t6418 * t9365 + 0.11e2 * t6434 * t9353 + 0.6e1 * t6440 * t9373 + 0.3e1 * t787 * t9415 + 0.9e1 * t11643 - 0.3e1 * t11650 + 0.9e1 * t11652 + 0.9e1 * t11666 - 0.3e1 * t11672 - 0.9e1 * t11725 - 0.6e1 * t11731;
  t12207 = t2099 * t1773 * t904 * t850;
  t12208 = 0.6e1 * t12207;
  t12209 = t1790 * t10150;
  t12210 = 0.3e1 * t12209;
  t12215 = t1801 * t1510 * t786 * t850;
  t12216 = 0.9e1 * t12215;
  t12217 = -0.6e1 * t2979 * t4577 * t4582 * t6196 + 0.6e1 * t12130 * t6200 - 0.12e2 * t12150 * t6196 - 0.6e1 * t6224 * t9365 + 0.7e1 * t6258 * t9365 + 0.11e2 * t6341 * t9365 + 0.18e2 * t6350 * t9365 - 0.6e1 * t6379 * t9330 - t11745 - t11747 + t11752 - t12208 - t12210 - t12216;
  t12224 = t5631 * t12177 * params->csk_a;
  t12237 = -0.12e2 * t12119 * t5353 - 0.3e1 * t12126 * t5335 + 0.11e2 * t12224 * t6179 - 0.11e2 * t12224 * t6193 - 0.12e2 * t6171 * t9373 - 0.18e2 * t6182 * t9377 - 0.6e1 * t6200 * t9316 + 0.7e1 * t6231 * t9353 + t11778 + t11781 - t11783 - t3158 - t3166;
  t12240 = t3173 + 0.4e1 * t3187 + 0.4e1 * t3190 - t2989 + t2997 - t2999 - t852 - t903 - t9506 + t3024 + t3031 + t3204 - t3451 + t3211;
  t12244 = my_piecewise5(t114, 0, t115, 0, t12068 + t12101 + t12142 + t12165 + t12188 + t12217 + t12237 + t12240);
  t12250 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * (t52 * t308 * t3045 / 0.24e2 + 0.3e1 * t278 * t3214 + t113 * t12244));
  tv4sigma3lapl19 = t8 * t12250;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  tv4sigma3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  tv4sigma3tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  t12257 = t2724 * t389 * t11888;
  t12261 = t2719 * t171 * t8900 * t403;
  t12265 = t3062 * t3658;
  t12271 = t9537 * t171 * t403;
  t12274 = t9537 * t403;
  t12275 = t389 * t12274;
  t12284 = t2724 * t8900 * t1045;
  t12295 = -0.12e2 * t1077 * t12274 * t8274 + 0.18e2 * t3063 * t389 * t8274 - 0.18e2 * t12265 * t8283 + 0.18e2 * t12265 * t8288 - 0.6e1 * t12271 * t8274 + 0.18e2 * t12271 * t8306 - 0.6e1 * t12271 * t8313 - 0.18e2 * t12275 * t8274 + 0.18e2 * t12275 * t8306 + 0.18e2 * t6752 * t8274 - 0.12e2 * t11817 + 0.12e2 * t11819 - 0.3e1 * t12257 + 0.3e1 * t12261 - 0.3e1 * t12284;
  t12312 = 0.12e2 * t11826 + 0.12e2 * t11829 - 0.4e1 * t11831 + 0.12e2 * t11834 + 0.12e2 * t11840 - 0.8e1 * t11859 - 0.12e2 * t11862 + 0.12e2 * t11866 + 0.12e2 * t11870 - 0.4e1 * t11872 + 0.3e1 * t11385 - 0.3e1 * t11388 - 0.3e1 * t11390 + 0.12e2 * t11884 - 0.12e2 * t11886 - 0.12e2 * t11890;
  t12330 = 0.11e2 * t10447 * t3748 * t6504 + 0.3e1 * t11392 - 0.3e1 * t11403 - 0.2e1 * t11407 + 0.3e1 * t11418 - t11426 + 0.3e1 * t11428 + 0.3e1 * t11432 - 0.3e1 * t11434 + 0.3e1 * t11436 - t11440 + 0.3e1 * t11442 + 0.3e1 * t11454 - 0.8e1 * t11937 - 0.4e1 * t11939 - 0.12e2 * t11945;
  t12331 = t2735 * t6830;
  t12335 = t6629 * t2775;
  t12338 = t2733 * t1578 * t3124;
  t12343 = t922 * t817;
  t12355 = t3850 * t389 * t817;
  t12358 = 0.3e1 * t12343 * t3601 * t379 + 0.6e1 * t3115 * t3830 * t8390 + 0.3e1 * t3115 * t394 * t8475 - 0.7e1 * t12355 * t8376 + 0.6e1 * t6510 * t8485 + t6540 * t8493 + 0.7e1 * t6658 * t8376 - t11462 - 0.2e1 * t11514 - 0.3e1 * t11521 - t11531 + t11534 - t11536 - 0.3e1 * t12331 - t12335 - 0.2e1 * t12338;
  t12366 = t3860 * t3075;
  t12379 = t2735 * t11402;
  t12381 = t2730 * t6663;
  t12383 = t2733 * t11425;
  t12384 = t2735 * t11425;
  t12386 = t2730 * t11425;
  t12387 = t2758 * t11839;
  t12389 = t2733 * t11402;
  t12393 = 0.3e1 * t12343 * t163 * t4807 - 0.6e1 * t3101 * t3743 * t8344 - 0.3e1 * t411 * t6649 * t8415 + 0.6e1 * t12366 * t8344 + 0.11e2 * t6540 * t8443 - 0.18e2 * t6636 * t931 - 0.11e2 * t6658 * t8387 - 0.3e1 * t8415 * t9631 + 0.3e1 * t12379 + 0.3e1 * t12381 - t12383 + 0.3e1 * t12384 - t12386 + 0.3e1 * t12387 - 0.3e1 * t12389;
  t12398 = t2765 * t6695;
  t12405 = t2730 * t6607;
  t12409 = t2735 * t11431;
  t12413 = t2730 * t11431;
  t12420 = t3850 * t1077 * t817;
  t12423 = t2730 * t11406;
  t12432 = t3830 * t4786 * t817;
  t12434 = 0.18e2 * t1115 * t2774 * t3743 * t6540 - 0.6e1 * t3755 * t3766 * t817 * t8376 - 0.6e1 * t1068 * t820 * t8326 - 0.18e2 * t12366 * t8387 + 0.6e1 * t12366 * t8390 - 0.12e2 * t12420 * t8376 + t12432 * t8390 - 0.6e1 * t6540 * t8354 - 0.6e1 * t6540 * t8410 - 0.12e2 * t6552 * t8344 + 0.7e1 * t6650 * t8387 + 0.3e1 * t12398 + 0.3e1 * t12405 + 0.3e1 * t12409 - 0.3e1 * t12413 - 0.2e1 * t12423;
  t12449 = t3830 * t9630;
  t12461 = -0.12e2 * t1578 * t3115 * t403 * t926 + 0.18e2 * t12355 * t8344 - 0.7e1 * t12355 * t8387 + 0.12e2 * t12420 * t8344 + 0.6e1 * t12432 * t8344 - t12432 * t8376 - 0.7e1 * t12432 * t8387 - 0.11e2 * t12449 * t8387 + 0.11e2 * t12449 * t8390 - 0.18e2 * t6650 * t8344 + t11562 + t11565 - t11567 - 0.4e1 * t3227 + 0.4e1 * t3248 + 0.4e1 * t3256;
  t12464 = t3260 - t3261 - t3262 + t3107 - t3108 - t3109 - t826 - t929 + 0.4e1 * t3266 - 0.4e1 * t3270 + t3110 - t2948 + t3112 + t3272 - t11112 + t3274;
  t12468 = my_piecewise5(t64, 0, t67, 0, t12295 + t12312 + t12330 + t12358 + t12393 + t12434 + t12461 + t12464);
  t12474 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (t52 * t291 * t3129 / 0.12e2 + 0.2e1 * t260 * t3283 + t59 * t12468));
  tv4sigma2lapl20 = t8 * t12474;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  t12481 = t9931 * t242 * t584;
  t12484 = t6968 * t7227;
  t12492 = t2824 * t9243 * t1431;
  t12495 = t2824 * t570 * t12108;
  t12497 = t2829 * t11596;
  t12514 = -0.12e2 * t1463 * t584 * t8618 * t9931 + 0.18e2 * t1463 * t3149 * t8618 + 0.18e2 * t3149 * t570 * t8618 - 0.6e1 * t12481 * t8618 - 0.6e1 * t12481 * t8663 + 0.18e2 * t12481 * t8666 - 0.18e2 * t12484 * t8618 - 0.12e2 * t12039 + 0.12e2 * t12041 - 0.4e1 * t12045 - 0.12e2 * t12048 + 0.12e2 * t12050 - 0.3e1 * t12492 - 0.3e1 * t12495 + 0.3e1 * t12497;
  t12531 = 0.12e2 * t12056 + 0.12e2 * t12064 + 0.12e2 * t12075 + 0.12e2 * t12077 - 0.4e1 * t12079 + 0.12e2 * t12081 - 0.8e1 * t12097 + 0.3e1 * t11597 - 0.3e1 * t11602 - 0.3e1 * t11604 - 0.12e2 * t12106 - 0.12e2 * t12110 + 0.12e2 * t12112 - 0.3e1 * t11612 + 0.3e1 * t11614 + 0.3e1 * t11624;
  t12543 = t945 * t843;
  t12551 = t2845 * t1773 * t3209;
  t12555 = t2847 * t7275;
  t12559 = 0.3e1 * t12543 * t4493 * t560 + 0.6e1 * t3200 * t5631 * t8758 + 0.3e1 * t3200 * t575 * t8850 + 0.11e2 * t7086 * t8826 + 0.6e1 * t7093 * t8831 - t11628 + 0.3e1 * t11631 - 0.3e1 * t11635 + 0.3e1 * t11637 - 0.2e1 * t11641 + 0.3e1 * t11643 - t11650 + 0.3e1 * t11652 + 0.3e1 * t11666 - 0.2e1 * t12551 - 0.3e1 * t12555;
  t12560 = t7070 * t2878;
  t12571 = t4649 * t3160;
  t12575 = t4556 * t1525 * t843;
  t12580 = t4645 * t3177;
  t12583 = -0.12e2 * t1773 * t3200 * t584 * t949 - 0.7e1 * t12571 * t8710 + 0.7e1 * t12575 * t8710 + 0.6e1 * t12580 * t8749 + t7064 * t8835 - 0.3e1 * t8781 * t9928 - t11672 - 0.3e1 * t11725 - 0.2e1 * t11731 - t11745 - t11747 + t11752 - 0.8e1 * t12207 - 0.4e1 * t12209 - 0.12e2 * t12215 - t12560;
  t12591 = t593 * t843;
  t12599 = t2835 * t11627;
  t12600 = t2847 * t11611;
  t12602 = t2835 * t7140;
  t12604 = t2845 * t11627;
  t12605 = t2847 * t11627;
  t12607 = t2847 * t11634;
  t12609 = t2859 * t12055;
  t12611 = t2845 * t11611;
  t12613 = t2835 * t11640;
  t12617 = 0.3e1 * t12543 * t234 * t5344 - 0.3e1 * t12591 * t592 * t8781 - 0.11e2 * t12575 * t8725 + 0.11e2 * t7064 * t8706 - 0.6e1 * t7175 * t8749 - 0.18e2 * t7228 * t954 - t12599 + 0.3e1 * t12600 + 0.3e1 * t12602 - t12604 + 0.3e1 * t12605 + 0.3e1 * t12607 + 0.3e1 * t12609 - 0.3e1 * t12611 - 0.2e1 * t12613;
  t12622 = t2870 * t7219;
  t12629 = t2835 * t7165;
  t12633 = t4556 * t12591;
  t12636 = t2835 * t11634;
  t12641 = t4649 * t1463 * t843;
  t12648 = t5631 * t9927;
  t12657 = -0.6e1 * t4577 * t4582 * t843 * t8710 - 0.6e1 * t1454 * t846 * t8743 - 0.7e1 * t12571 * t8725 + 0.18e2 * t12571 * t8749 + 0.7e1 * t12633 * t8725 - 0.18e2 * t12633 * t8749 - 0.12e2 * t12641 * t8710 + 0.12e2 * t12641 * t8749 - 0.11e2 * t12648 * t8725 + 0.11e2 * t12648 * t8758 + 0.18e2 * t7064 * t8733 - 0.6e1 * t7064 * t8755 - 0.12e2 * t7137 * t8749 + 0.3e1 * t12622 + 0.3e1 * t12629 - 0.3e1 * t12636;
  t12666 = t5631 * t7110 * t843;
  t12674 = t242 * t846 * params->csk_a;
  t12682 = -0.18e2 * t12580 * t8725 + 0.6e1 * t12580 * t8758 - t12666 * t8710 - 0.7e1 * t12666 * t8725 + 0.6e1 * t12666 * t8749 + t12666 * t8758 - 0.18e2 * t12674 * t8644 + 0.18e2 * t12674 * t8647 - 0.6e1 * t7064 * t8806 + t11778 + t11781 - t11783 - 0.4e1 * t3296 + 0.4e1 * t3300 - 0.4e1 * t3304 - t952;
  t12687 = 0.18e2 * t12484 * t8666 - t11366 - t3020 - t3192 + t3193 - t3194 + t3196 + t3197 + 0.4e1 * t3308 + 0.4e1 * t3331 - t3338 - t3339 + t3340 + t3341 + t3343 - t852;
  t12691 = my_piecewise5(t114, 0, t115, 0, t12514 + t12531 + t12559 + t12583 + t12617 + t12657 + t12682 + t12687);
  t12697 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * (t52 * t308 * t3214 / 0.12e2 + 0.2e1 * t278 * t3352 + t113 * t12691));
  tv4sigma2lapl217 = t8 * t12697;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  tv4sigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  tv4sigma2tau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  t12705 = -0.9e1 * t12257 + 0.9e1 * t12261 - 0.9e1 * t12284 - t11818 + t11820 + t11827 + t11830 - t11832 + t11835 + t11841 - t11860 - t11863 + t11867 + t11871;
  t12714 = t3362 * t263;
  t12721 = 0.6e1 * t10921 * t3830 * t878 + 0.3e1 * t12714 * t3601 * t379 + t11038 * t4827 + 0.6e1 * t11043 * t4773 + 0.11e2 * t11047 * t4767 + 0.3e1 * t11060 * t879 - t11873 + t11885 - t11887 - t11891 - t11938 - t11940 - t11946 - 0.9e1 * t12331;
  t12734 = -0.3e1 * t12335 - 0.6e1 * t12338 - t11531 + t11534 - t11536 + 0.9e1 * t12379 + 0.9e1 * t12381 - 0.3e1 * t12383 + 0.9e1 * t12384 - 0.3e1 * t12386 + 0.9e1 * t12387 - 0.9e1 * t12389 + 0.9e1 * t12398 + 0.9e1 * t12405;
  t12740 = t3830 * t872;
  t12749 = t3860 * t2534;
  t12760 = t3830 * t4786 * t263;
  t12764 = 0.3e1 * t12714 * t163 * t4807 - 0.11e2 * t10910 * t12740 - 0.7e1 * t10910 * t12760 + 0.6e1 * t10913 * t12749 - 0.6e1 * t10913 * t4906 + 0.11e2 * t10921 * t12740 + t10921 * t12760 - 0.18e2 * t10964 * t4835 - 0.6e1 * t10980 * t4827 - 0.3e1 * t11019 * t873 - 0.3e1 * t11019 * t883 + 0.9e1 * t12409 - 0.9e1 * t12413 - 0.6e1 * t12423;
  t12777 = t3743 * t3760 * t263;
  t12781 = t3748 * t3750 * t263;
  t12801 = -0.12e2 * t10960 * t1578 * t403 * t878 - 0.6e1 * t1068 * t10950 * t627 - 0.18e2 * t10910 * t12749 - 0.7e1 * t10910 * t12781 - 0.11e2 * t10910 * t4798 + 0.7e1 * t10910 * t4851 + 0.6e1 * t10913 * t12760 + 0.12e2 * t10913 * t12777 - 0.18e2 * t10913 * t4851 - 0.12e2 * t10913 * t4901 - t10918 * t12760 - 0.6e1 * t10918 * t4901 + 0.6e1 * t10921 * t12749 + 0.11e2 * t10940 * t4827;
  t12806 = t9703 * t263;
  t12807 = t389 * t12806;
  t12814 = t171 * t1115 * t403 * t263;
  t12820 = t171 * t8960 * t263;
  t12835 = -0.6e1 * t10918 * t263 * t3755 * t3766 + 0.18e2 * t1068 * t11098 * t4992 - 0.12e2 * t1077 * t11067 * t12806 - 0.18e2 * t11067 * t12807 - 0.18e2 * t11071 * t12820 + 0.18e2 * t11074 * t12807 + 0.18e2 * t11074 * t12820 + 0.18e2 * t11080 * t12814 - 0.6e1 * t11086 * t12814 + 0.18e2 * t11086 * t5051 - 0.6e1 * t11108 * t12814 + t11562 + t11565 - t3227;
  t12847 = 0.18e2 * t10913 * t12781 - 0.12e2 * t10918 * t12777 - 0.7e1 * t10918 * t12781 + 0.7e1 * t10918 * t4798 + 0.18e2 * t10994 * t4827 - t11567 + t3248 + t3256 - t3374 + t3378 - t3380 + t3381 - t3382 - t3383;
  t12849 = t2915 - t2917 - t2923 - t826 - t929 + t3266 - t3270 + t2938 - t2947 + t2952 + t3384 - 0.8e1 * t3123 + t3387 + t3390 + t3393;
  t12853 = my_piecewise5(t64, 0, t67, 0, t12705 + t12721 + t12734 + t12764 + t12801 + t12835 + t12847 + t12849);
  t12859 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (t52 * t291 * t3283 / 0.8e1 + t260 * t3418 + t59 * t12853));
  tv4sigmalapl30 = t8 * t12859;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  t12867 = -0.9e1 * t12492 - 0.9e1 * t12495 + 0.9e1 * t12497 - t12040 + t12042 - t12046 - t12049 + t12051 + t12057 + t12065 + t12076 + t12078 - t12080 + t12082;
  t12875 = t1115 * t584 * t281;
  t12876 = t242 * t12875;
  t12884 = t3428 * t281;
  t12895 = -0.18e2 * t10126 * t11152 * t242 * t281 + 0.6e1 * t11172 * t5631 * t904 + 0.3e1 * t12884 * t4493 * t560 + 0.3e1 * t11306 * t905 + t11311 * t5318 + 0.11e2 * t11316 * t5296 + 0.6e1 * t11321 * t5302 + 0.18e2 * t11329 * t12876 + 0.18e2 * t11334 * t5564 - 0.6e1 * t11337 * t12876 - t12098 - t12107 - t12111 + t12113;
  t12905 = -0.6e1 * t12551 - 0.9e1 * t12555 - 0.3e1 * t12560 - t11745 - t11747 + t11752 - t12208 - t12210 - t12216 - 0.3e1 * t12599 + 0.9e1 * t12600 + 0.9e1 * t12602 - 0.3e1 * t12604 + 0.9e1 * t12605;
  t12916 = t570 * t12875;
  t12928 = -0.12e2 * t11334 * t12875 * t1463 + 0.18e2 * t11352 * t1454 * t5497 + 0.18e2 * t11329 * t12916 + 0.18e2 * t11329 * t3299 - 0.6e1 * t11334 * t12876 - 0.18e2 * t11334 * t12916 + 0.9e1 * t12607 + 0.9e1 * t12609 - 0.9e1 * t12611 - 0.6e1 * t12613 + 0.9e1 * t12622 + 0.9e1 * t12629 - 0.9e1 * t12636 - t3296;
  t12948 = -0.6e1 * t11260 * t1454 * t689 + 0.7e1 * t11179 * t5381 - 0.12e2 * t11182 * t5365 - 0.18e2 * t11204 * t704 - 0.18e2 * t11208 * t5302 + 0.11e2 * t11217 * t5318 - 0.6e1 * t11250 * t5318 + 0.18e2 * t11266 * t5318 + t11778 + t11781 - t11783 + t3300 - t3304 - t952;
  t12953 = t5631 * t898;
  t12974 = t5631 * t7110 * t281;
  t12981 = t5631 * t3315;
  t12984 = -0.6e1 * t11175 * t281 * t4577 * t4582 - 0.12e2 * t1773 * t281 * t3465 * t9421 + 0.3e1 * t12884 * t234 * t5344 + 0.11e2 * t11172 * t12953 + t11172 * t12974 + 0.6e1 * t11172 * t12981 - t11175 * t12974 - 0.11e2 * t11179 * t12953 - 0.7e1 * t11179 * t12974 - 0.11e2 * t11179 * t5439 + 0.6e1 * t11182 * t12974 - 0.6e1 * t11182 * t5446 - 0.3e1 * t11281 * t899 - 0.3e1 * t11281 * t909;
  t12993 = t4551 * t4658 * t281;
  t12997 = t4556 * t4557 * t281;
  t13008 = -0.12e2 * t11175 * t12993 - 0.7e1 * t11175 * t12997 - 0.6e1 * t11175 * t5365 + 0.7e1 * t11175 * t5439 - 0.18e2 * t11179 * t12981 - 0.7e1 * t11179 * t12997 + 0.6e1 * t11182 * t12981 + 0.12e2 * t11182 * t12993 + 0.18e2 * t11182 * t12997 + t3308 + t3331 - t3440 - t3442 + t3446;
  t13010 = -t3447 - t3448 + t3449 - t2988 + t2996 - t2998 - t852 - t3019 + t3023 + t3030 + t3450 - 0.8e1 * t3208 + t3453 + t3467 + t3470;
  t13014 = my_piecewise5(t114, 0, t115, 0, t12867 + t12895 + t12905 + t12928 + t12948 + t12984 + t13008 + t13010);
  t13020 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * (t52 * t308 * t3352 / 0.8e1 + t278 * t3484 + t113 * t13014));
  tv4sigmalapl311 = t8 * t13020;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  tv4sigmatau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  tv4sigmatau311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  t13026 = t922 * t922;
  t13027 = t13026 * t403;
  t13028 = t379 * t13027;
  t13031 = t13026 * t382;
  t13032 = t1068 * t13031;
  t13035 = t163 * t13031;
  t13038 = t379 * t13031;
  t13046 = t1068 * t13027;
  t13051 = t13026 * t3593;
  t13052 = t3614 * t13051;
  t13055 = t1068 * t13051;
  t13059 = t379 * t13051;
  t13064 = t163 * t13051;
  t13076 = -0.6e1 * t13052 * t3744 - 0.7e1 * t13052 * t3751 - t13052 * t3851 + 0.12e2 * t13055 * t3761 - 0.18e2 * t13055 * t3796 + 0.6e1 * t13055 * t3851 - 0.7e1 * t13059 * t3751 - 0.7e1 * t13059 * t3851 - 0.18e2 * t13059 * t3861 + t13064 * t3851 + 0.6e1 * t13064 * t3861;
  t13084 = t13026 * t3588;
  t13085 = t379 * t13084;
  t13125 = -0.6e1 * t13032 * t3815 + 0.11e2 * t13052 * t3757 - 0.6e1 * t13052 * t3767 + 0.18e2 * t13052 * t3778 - 0.6e1 * t13052 * t3782 - 0.12e2 * t13055 * t3744 - 0.11e2 * t13059 * t3773 + 0.7e1 * t13059 * t3796 - 0.11e2 * t13059 * t3831 + 0.11e2 * t13064 * t3831 - 0.18e2 * t12331;
  t13143 = t163 * t13026;
  t13148 = t379 * t13026;
  t13153 = 0.3e1 * t13143 * t3590 + 0.6e1 * t13143 * t3597 + 0.3e1 * t13148 * t3601 + 0.11e2 * t13148 * t3605 + 0.18e2 * t12387 - 0.18e2 * t12389 + 0.18e2 * t12398 + 0.18e2 * t12405 + 0.18e2 * t12409 - 0.18e2 * t12413 - 0.12e2 * t12423;
  t13178 = -0.4e1 * t3379 + 0.4e1 * t3069 - 0.4e1 * t3094 - 0.4e1 * t3099 - t826 - t929 + 0.4e1 * t3119 - 0.9e1 * t3123 + 0.4e1 * t3126 + 0.4e1 * t3389 + 0.4e1 * t3392;
  t13182 = my_piecewise5(t64, 0, t67, 0, t13178 + t13153 + t13125 + t13076 - 0.12e2 * t13052 * t3761 + 0.18e2 * t13055 * t3751 - 0.3e1 * t13085 * t396 + 0.6e1 * t13055 * t3861 + 0.18e2 * t13028 * t3665 - 0.18e2 * t13046 * t3724 + 0.18e2 * t13028 * t3724 + 0.18e2 * t13032 * t3687 - 0.6e1 * t13035 * t3638 + 0.18e2 * t13038 * t3638 - 0.6e1 * t13032 * t3638 + 0.18e2 * t13032 * t3715 - 0.12e2 * t13046 * t3704 - 0.3e1 * t13085 * t413 - 0.18e2 * t13038 * t3834 - 0.6e1 * t13055 * t3778 + 0.7e1 * t13052 * t3773 - 0.18e2 * t12284 + 0.18e2 * t12261 - 0.18e2 * t12257 - t11567 + t11562 + t11565 + t11534 - t11536 - t11531 + 0.4e1 * t3377 - 0.4e1 * t3373 - 0.18e2 * t163 * t13027 * t3665 + 0.3e1 * t163 * t13084 * t396 + 0.6e1 * t1068 * t13026 * t3609 + t3614 * t13026 * t3620 - 0.12e2 * t13035 * t1578 * t170 * t403 + 0.18e2 * t12379 + 0.18e2 * t12381 - 0.6e1 * t12383 + 0.18e2 * t12384 - 0.6e1 * t12386 - 0.6e1 * t12335 - 0.12e2 * t12338);
  t13188 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (t52 * t291 * t3418 / 0.6e1 + t59 * t13182));
  tv4lapl40 = t8 * t13188;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  t13195 = t945 * t945;
  t13196 = t13195 * t563;
  t13197 = t1454 * t13196;
  t13203 = t560 * t13196;
  t13207 = t234 * t13195 * t584;
  t13223 = t13195 * t4481;
  t13224 = t4501 * t13223;
  t13227 = t1454 * t13223;
  t13232 = t560 * t13223;
  t13238 = t234 * t13223;
  t13243 = -0.6e1 * t13197 * t4370 - 0.18e2 * t13197 * t4408 + 0.18e2 * t13203 * t4376 - 0.6e1 * t13224 * t4552 - 0.7e1 * t13224 * t4558 - t13224 * t4650 - 0.12e2 * t13224 * t4659 + 0.18e2 * t13227 * t4558 + 0.6e1 * t13227 * t4650 - 0.7e1 * t13232 * t4650 + 0.6e1 * t13238 * t4646;
  t13267 = t13195 * t4466;
  t13268 = t560 * t13267;
  t13290 = 0.3e1 * t13267 * t234 * t577 - 0.12e2 * t11720 * t13207 + 0.11e2 * t13224 * t4579 - 0.6e1 * t13224 * t4590 - 0.6e1 * t13227 * t4567 - 0.18e2 * t13227 * t4571 - 0.11e2 * t13232 * t4574 - 0.11e2 * t13232 * t4633 + 0.11e2 * t13238 * t4633 - 0.3e1 * t13268 * t577 - 0.3e1 * t13268 * t594;
  t13313 = t234 * t13195;
  t13316 = 0.3e1 * t13313 * t4468 + 0.18e2 * t12602 - 0.6e1 * t12604 + 0.18e2 * t12605 + 0.18e2 * t12607 + 0.18e2 * t12609 - 0.18e2 * t12611 - 0.12e2 * t12613 + 0.18e2 * t12622 + 0.18e2 * t12629 - 0.18e2 * t12636;
  t13320 = t560 * t13195;
  t13342 = -0.4e1 * t3441 + 0.4e1 * t3445 - 0.4e1 * t3158 - 0.4e1 * t3166 + 0.4e1 * t3173 - t852 + 0.4e1 * t3204 - 0.9e1 * t3208 + 0.4e1 * t3211 + 0.4e1 * t3466 + 0.4e1 * t3469;
  t13346 = my_piecewise5(t114, 0, t115, 0, t13342 + t13316 + t13243 + t13290 - 0.18e2 * t12495 + 0.18e2 * t12497 - 0.18e2 * t12492 + 0.6e1 * t13313 * t4489 + 0.3e1 * t13320 * t4493 + 0.11e2 * t13320 * t4496 - 0.6e1 * t13224 * t4583 + 0.18e2 * t13224 * t4567 - 0.7e1 * t13232 * t4558 - 0.18e2 * t13203 * t4629 + 0.7e1 * t13232 * t4571 + 0.7e1 * t13224 * t4574 - 0.6e1 * t13197 * t4612 - 0.12e2 * t13227 * t4552 + t13238 * t4650 - 0.18e2 * t13232 * t4646 + 0.6e1 * t13227 * t4646 + 0.12e2 * t13227 * t4659 + 0.18e2 * t13203 * t4370 - 0.18e2 * t13207 * t5512 - 0.12e2 * t13197 * t4433 + 0.18e2 * t13203 * t4408 + 0.18e2 * t13197 * t4517 + 0.18e2 * t13197 * t4397 - 0.6e1 * t12599 + 0.18e2 * t12600 - 0.6e1 * t12560 - 0.18e2 * t12555 - 0.12e2 * t12551 + t11781 - t11783 + t11778 + t11752 - t11745 - t11747 - 0.4e1 * t3439 - t952 - 0.6e1 * t234 * t13196 * t4370 + 0.6e1 * t1454 * t13195 * t4485 + t4501 * t13195 * t4507);
  t13352 = my_piecewise3(t84, 0, 0.3e1 / 0.2e2 * t7 * t94 * (t52 * t308 * t3484 / 0.6e1 + t113 * t13346));
  tv4lapl44 = t8 * t13352;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  tv4tau40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  tv4tau44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

