; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -function-specialization -func-specialization-max-clones=0 -func-specialization-size-threshold=14 -S < %s | FileCheck %s --check-prefix=NONE
; RUN: opt -function-specialization -func-specialization-max-clones=1 -func-specialization-size-threshold=14 -S < %s | FileCheck %s --check-prefix=ONE
; RUN: opt -function-specialization -func-specialization-max-clones=2 -func-specialization-size-threshold=14 -S < %s | FileCheck %s --check-prefix=TWO
; RUN: opt -function-specialization -func-specialization-max-clones=3 -func-specialization-size-threshold=14 -S < %s | FileCheck %s --check-prefix=THREE

; Make sure that we iterate correctly after sorting the specializations:
; FnSpecialization: Specializations for function compute
; FnSpecialization:   Gain = 608
; FnSpecialization:   FormalArg = binop1, ActualArg = power
; FnSpecialization:   FormalArg = binop2, ActualArg = mul
; FnSpecialization:   Gain = 982
; FnSpecialization:   FormalArg = binop1, ActualArg = plus
; FnSpecialization:   FormalArg = binop2, ActualArg = minus
; FnSpecialization:   Gain = 795
; FnSpecialization:   FormalArg = binop1, ActualArg = minus
; FnSpecialization:   FormalArg = binop2, ActualArg = power

define i64 @main(i64 %x, i64 %y, i1 %flag) {
; NONE-LABEL: @main(
; NONE-NEXT:  entry:
; NONE-NEXT:    br i1 [[FLAG:%.*]], label [[PLUS:%.*]], label [[MINUS:%.*]]
; NONE:       plus:
; NONE-NEXT:    [[TMP0:%.*]] = call i64 @compute(i64 [[X:%.*]], i64 [[Y:%.*]], i64 (i64, i64)* @power, i64 (i64, i64)* @mul)
; NONE-NEXT:    br label [[MERGE:%.*]]
; NONE:       minus:
; NONE-NEXT:    [[TMP1:%.*]] = call i64 @compute(i64 [[X]], i64 [[Y]], i64 (i64, i64)* @plus, i64 (i64, i64)* @minus)
; NONE-NEXT:    br label [[MERGE]]
; NONE:       merge:
; NONE-NEXT:    [[TMP2:%.*]] = phi i64 [ [[TMP0]], [[PLUS]] ], [ [[TMP1]], [[MINUS]] ]
; NONE-NEXT:    [[TMP3:%.*]] = call i64 @compute(i64 [[TMP2]], i64 42, i64 (i64, i64)* @minus, i64 (i64, i64)* @power)
; NONE-NEXT:    ret i64 [[TMP3]]
;
; ONE-LABEL: @main(
; ONE-NEXT:  entry:
; ONE-NEXT:    br i1 [[FLAG:%.*]], label [[PLUS:%.*]], label [[MINUS:%.*]]
; ONE:       plus:
; ONE-NEXT:    [[TMP0:%.*]] = call i64 @compute(i64 [[X:%.*]], i64 [[Y:%.*]], i64 (i64, i64)* @power, i64 (i64, i64)* @mul)
; ONE-NEXT:    br label [[MERGE:%.*]]
; ONE:       minus:
; ONE-NEXT:    [[TMP1:%.*]] = call i64 @compute.1(i64 [[X]], i64 [[Y]], i64 (i64, i64)* @plus, i64 (i64, i64)* @minus)
; ONE-NEXT:    br label [[MERGE]]
; ONE:       merge:
; ONE-NEXT:    [[TMP2:%.*]] = phi i64 [ [[TMP0]], [[PLUS]] ], [ [[TMP1]], [[MINUS]] ]
; ONE-NEXT:    [[TMP3:%.*]] = call i64 @compute(i64 [[TMP2]], i64 42, i64 (i64, i64)* @minus, i64 (i64, i64)* @power)
; ONE-NEXT:    ret i64 [[TMP3]]
;
; TWO-LABEL: @main(
; TWO-NEXT:  entry:
; TWO-NEXT:    br i1 [[FLAG:%.*]], label [[PLUS:%.*]], label [[MINUS:%.*]]
; TWO:       plus:
; TWO-NEXT:    [[TMP0:%.*]] = call i64 @compute(i64 [[X:%.*]], i64 [[Y:%.*]], i64 (i64, i64)* @power, i64 (i64, i64)* @mul)
; TWO-NEXT:    br label [[MERGE:%.*]]
; TWO:       minus:
; TWO-NEXT:    [[TMP1:%.*]] = call i64 @compute.1(i64 [[X]], i64 [[Y]], i64 (i64, i64)* @plus, i64 (i64, i64)* @minus)
; TWO-NEXT:    br label [[MERGE]]
; TWO:       merge:
; TWO-NEXT:    [[TMP2:%.*]] = phi i64 [ [[TMP0]], [[PLUS]] ], [ [[TMP1]], [[MINUS]] ]
; TWO-NEXT:    [[TMP3:%.*]] = call i64 @compute.2(i64 [[TMP2]], i64 42, i64 (i64, i64)* @minus, i64 (i64, i64)* @power)
; TWO-NEXT:    ret i64 [[TMP3]]
;
; THREE-LABEL: @main(
; THREE-NEXT:  entry:
; THREE-NEXT:    br i1 [[FLAG:%.*]], label [[PLUS:%.*]], label [[MINUS:%.*]]
; THREE:       plus:
; THREE-NEXT:    [[TMP0:%.*]] = call i64 @compute.3(i64 [[X:%.*]], i64 [[Y:%.*]], i64 (i64, i64)* @power, i64 (i64, i64)* @mul)
; THREE-NEXT:    br label [[MERGE:%.*]]
; THREE:       minus:
; THREE-NEXT:    [[TMP1:%.*]] = call i64 @compute.1(i64 [[X]], i64 [[Y]], i64 (i64, i64)* @plus, i64 (i64, i64)* @minus)
; THREE-NEXT:    br label [[MERGE]]
; THREE:       merge:
; THREE-NEXT:    [[TMP2:%.*]] = phi i64 [ [[TMP0]], [[PLUS]] ], [ [[TMP1]], [[MINUS]] ]
; THREE-NEXT:    [[TMP3:%.*]] = call i64 @compute.2(i64 [[TMP2]], i64 42, i64 (i64, i64)* @minus, i64 (i64, i64)* @power)
; THREE-NEXT:    ret i64 [[TMP3]]
;
entry:
  br i1 %flag, label %plus, label %minus

plus:
  %tmp0 = call i64 @compute(i64 %x, i64 %y, i64 (i64, i64)* @power, i64 (i64, i64)* @mul)
  br label %merge

minus:
  %tmp1 = call i64 @compute(i64 %x, i64 %y, i64 (i64, i64)* @plus, i64 (i64, i64)* @minus)
  br label %merge

merge:
  %tmp2 = phi i64 [ %tmp0, %plus ], [ %tmp1, %minus]
  %tmp3 = call i64 @compute(i64 %tmp2, i64 42, i64 (i64, i64)* @minus, i64 (i64, i64)* @power)
  ret i64 %tmp3
}

; THREE-NOT: define internal i64 @compute
;
; THREE-LABEL: define internal i64 @compute.1(i64 %x, i64 %y, i64 (i64, i64)* %binop1, i64 (i64, i64)* %binop2) {
; THREE-NEXT:  entry:
; THREE-NEXT:    [[TMP0:%.+]] = call i64 @plus(i64 %x, i64 %y)
; THREE-NEXT:    [[TMP1:%.+]] = call i64 @minus(i64 %x, i64 %y)
; THREE-NEXT:    [[TMP2:%.+]] = add i64 [[TMP0]], [[TMP1]]
; THREE-NEXT:    [[TMP3:%.+]] = sdiv i64 [[TMP2]], %x
; THREE-NEXT:    [[TMP4:%.+]] = sub i64 [[TMP3]], %y
; THREE-NEXT:    [[TMP5:%.+]] = mul i64 [[TMP4]], 2
; THREE-NEXT:    ret i64 [[TMP5]]
; THREE-NEXT:  }
;
; THREE-LABEL: define internal i64 @compute.2(i64 %x, i64 %y, i64 (i64, i64)* %binop1, i64 (i64, i64)* %binop2) {
; THREE-NEXT:  entry:
; THREE-NEXT:    [[TMP0:%.+]] = call i64 @minus(i64 %x, i64 %y)
; THREE-NEXT:    [[TMP1:%.+]] = call i64 @power(i64 %x, i64 %y)
; THREE-NEXT:    [[TMP2:%.+]] = add i64 [[TMP0]], [[TMP1]]
; THREE-NEXT:    [[TMP3:%.+]] = sdiv i64 [[TMP2]], %x
; THREE-NEXT:    [[TMP4:%.+]] = sub i64 [[TMP3]], %y
; THREE-NEXT:    [[TMP5:%.+]] = mul i64 [[TMP4]], 2
; THREE-NEXT:    ret i64 [[TMP5]]
; THREE-NEXT:  }
;
; THREE-LABEL: define internal i64 @compute.3(i64 %x, i64 %y, i64 (i64, i64)* %binop1, i64 (i64, i64)* %binop2) {
; THREE-NEXT:  entry:
; THREE-NEXT:    [[TMP0:%.+]] = call i64 @power(i64 %x, i64 %y)
; THREE-NEXT:    [[TMP1:%.+]] = call i64 @mul(i64 %x, i64 %y)
; THREE-NEXT:    [[TMP2:%.+]] = add i64 [[TMP0]], [[TMP1]]
; THREE-NEXT:    [[TMP3:%.+]] = sdiv i64 [[TMP2]], %x
; THREE-NEXT:    [[TMP4:%.+]] = sub i64 [[TMP3]], %y
; THREE-NEXT:    [[TMP5:%.+]] = mul i64 [[TMP4]], 2
; THREE-NEXT:    ret i64 [[TMP5]]
; THREE-NEXT:  }
;
define internal i64 @compute(i64 %x, i64 %y, i64 (i64, i64)* %binop1, i64 (i64, i64)* %binop2) {
entry:
  %tmp0 = call i64 %binop1(i64 %x, i64 %y)
  %tmp1 = call i64 %binop2(i64 %x, i64 %y)
  %add = add i64 %tmp0, %tmp1
  %div = sdiv i64 %add, %x
  %sub = sub i64 %div, %y
  %mul = mul i64 %sub, 2
  ret i64 %mul
}

define internal i64 @plus(i64 %x, i64 %y) {
entry:
  %tmp0 = add i64 %x, %y
  ret i64 %tmp0
}

define internal i64 @minus(i64 %x, i64 %y) {
entry:
  %tmp0 = sub i64 %x, %y
  ret i64 %tmp0
}

define internal i64 @mul(i64 %x, i64 %n) {
entry:
  %cmp6 = icmp sgt i64 %n, 1
  br i1 %cmp6, label %for.body, label %for.cond.cleanup

for.cond.cleanup:                                 ; preds = %for.body, %entry
  %x.addr.0.lcssa = phi i64 [ %x, %entry ], [ %add, %for.body ]
  ret i64 %x.addr.0.lcssa

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ %indvars.iv.next, %for.body ], [ 1, %entry ]
  %x.addr.07 = phi i64 [ %add, %for.body ], [ %x, %entry ]
  %add = shl nsw i64 %x.addr.07, 1
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond.not = icmp eq i64 %indvars.iv.next, %n
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

define internal i64 @power(i64 %x, i64 %n) {
entry:
  %cmp6 = icmp sgt i64 %n, 1
  br i1 %cmp6, label %for.body, label %for.cond.cleanup

for.cond.cleanup:                                 ; preds = %for.body, %entry
  %x.addr.0.lcssa = phi i64 [ %x, %entry ], [ %mul, %for.body ]
  ret i64 %x.addr.0.lcssa

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ %indvars.iv.next, %for.body ], [ 1, %entry ]
  %x.addr.07 = phi i64 [ %mul, %for.body ], [ %x, %entry ]
  %mul = mul nsw i64 %x.addr.07, %x.addr.07
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond.not = icmp eq i64 %indvars.iv.next, %n
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}
