; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=ipsccp -S %s | FileCheck %s

define i8 @range_from_lshr(i8 %a) {
; CHECK-LABEL: @range_from_lshr(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SHR:%.*]] = lshr i8 [[A:%.*]], 1
; CHECK-NEXT:    [[ADD_1:%.*]] = add i8 [[A_SHR]], 1
; CHECK-NEXT:    [[ADD_2:%.*]] = add i8 [[A_SHR]], -128
; CHECK-NEXT:    [[ADD_3:%.*]] = add i8 [[A_SHR]], -127
; CHECK-NEXT:    [[ADD_4:%.*]] = add i8 [[A_SHR]], -1
; CHECK-NEXT:    [[RES_1:%.*]] = xor i8 [[ADD_1]], [[ADD_2]]
; CHECK-NEXT:    [[RES_2:%.*]] = xor i8 [[RES_1]], [[ADD_3]]
; CHECK-NEXT:    [[RES_3:%.*]] = xor i8 [[RES_2]], [[ADD_4]]
; CHECK-NEXT:    ret i8 [[RES_3]]
;
entry:
  %a.shr = lshr i8 %a, 1
  %add.1 = add i8 %a.shr, 1
  %add.2 = add i8 %a.shr, 128
  %add.3 = add i8 %a.shr, 129
  %add.4 = add i8 %a.shr, -1
  %res.1 = xor i8 %add.1, %add.2
  %res.2 = xor i8 %res.1, %add.3
  %res.3 = xor i8 %res.2, %add.4
  ret i8 %res.3
}

define i8 @a_and_15_add_1(i8 %a) {
; CHECK-LABEL: @a_and_15_add_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_AND:%.*]] = and i8 [[A:%.*]], 15
; CHECK-NEXT:    [[ADD_1:%.*]] = add i8 [[A_AND]], 1
; CHECK-NEXT:    ret i8 [[ADD_1]]
;
entry:
  %a.and = and i8 %a, 15
  %add.1 = add i8 %a.and, 1
  ret i8 %add.1
}

define <4 x i8> @range_from_lshr_vec(<4 x i8> %a) {
; CHECK-LABEL: @range_from_lshr_vec(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SHR:%.*]] = lshr <4 x i8> [[A:%.*]], <i8 1, i8 2, i8 3, i8 4>
; CHECK-NEXT:    [[ADD_1:%.*]] = add <4 x i8> [[A_SHR]], <i8 1, i8 2, i8 3, i8 4>
; CHECK-NEXT:    ret <4 x i8> [[ADD_1]]
;
entry:
  %a.shr = lshr <4 x i8> %a, <i8 1, i8 2, i8 3, i8 4>
  %add.1 = add <4 x i8> %a.shr, <i8 1, i8 2, i8 3, i8 4>
  ret <4 x i8> %add.1
}

define <4 x i8> @range_from_lshr_vec_2(<4 x i8> %a) {
; CHECK-LABEL: @range_from_lshr_vec_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SHR:%.*]] = lshr <4 x i8> [[A:%.*]], <i8 1, i8 1, i8 1, i8 1>
; CHECK-NEXT:    [[ADD_1:%.*]] = add <4 x i8> [[A_SHR]], <i8 2, i8 2, i8 2, i8 2>
; CHECK-NEXT:    ret <4 x i8> [[ADD_1]]
;
entry:
  %a.shr = lshr <4 x i8> %a, <i8 1, i8 1, i8 1, i8 1>
  %add.1 = add <4 x i8> %a.shr, <i8 2, i8 2, i8 2, i8 2>
  ret <4 x i8> %add.1
}

define i8 @sge_0_and_sle_90(i8 %a) {
; CHECK-LABEL: @sge_0_and_sle_90(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SGT:%.*]] = icmp sge i8 [[A:%.*]], 0
; CHECK-NEXT:    [[SLT:%.*]] = icmp sle i8 [[A]], 90
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[SGT]], [[SLT]]
; CHECK-NEXT:    br i1 [[AND]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD_1:%.*]] = add i8 [[A]], 1
; CHECK-NEXT:    [[ADD_2:%.*]] = add i8 [[A]], -1
; CHECK-NEXT:    [[ADD_3:%.*]] = add i8 [[A]], -91
; CHECK-NEXT:    [[ADD_4:%.*]] = add i8 [[A]], -90
; CHECK-NEXT:    [[RES_1:%.*]] = xor i8 [[ADD_1]], [[ADD_2]]
; CHECK-NEXT:    [[RES_2:%.*]] = xor i8 [[RES_1]], [[ADD_3]]
; CHECK-NEXT:    [[RES_3:%.*]] = xor i8 [[RES_2]], [[ADD_4]]
; CHECK-NEXT:    ret i8 [[RES_3]]
; CHECK:       else:
; CHECK-NEXT:    [[ADD_5:%.*]] = add i8 [[A]], 1
; CHECK-NEXT:    [[ADD_6:%.*]] = add i8 [[A]], -1
; CHECK-NEXT:    [[ADD_7:%.*]] = add i8 [[A]], -91
; CHECK-NEXT:    [[ADD_8:%.*]] = add i8 [[A]], -90
; CHECK-NEXT:    [[RES_4:%.*]] = xor i8 [[ADD_5]], [[ADD_6]]
; CHECK-NEXT:    [[RES_5:%.*]] = xor i8 [[RES_4]], [[ADD_7]]
; CHECK-NEXT:    [[RES_6:%.*]] = xor i8 [[RES_5]], [[ADD_8]]
; CHECK-NEXT:    ret i8 [[RES_6]]
;
entry:
  %sgt = icmp sge i8 %a, 0
  %slt = icmp sle i8 %a, 90
  %and = and i1 %sgt, %slt
  br i1 %and, label %then, label %else

then:
  %add.1 = add i8 %a, 1
  %add.2 = add i8 %a, -1
  %add.3 = add i8 %a, 165
  %add.4 = add i8 %a, 166
  %res.1 = xor i8 %add.1, %add.2
  %res.2 = xor i8 %res.1, %add.3
  %res.3 = xor i8 %res.2, %add.4
  ret i8 %res.3

else:
  %add.5 = add i8 %a, 1
  %add.6 = add i8 %a, -1
  %add.7 = add i8 %a, 165
  %add.8 = add i8 %a, 166
  %res.4 = xor i8 %add.5, %add.6
  %res.5 = xor i8 %res.4, %add.7
  %res.6 = xor i8 %res.5, %add.8
  ret i8 %res.6
}
