# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=x86-64 -instruction-tables < %s | FileCheck %s

vaesdec          %zmm16, %zmm17, %zmm19
vaesdec          (%rax), %zmm17, %zmm19

vaesdeclast      %zmm16, %zmm17, %zmm19
vaesdeclast      (%rax), %zmm17, %zmm19

vaesenc          %zmm16, %zmm17, %zmm19
vaesenc          (%rax), %zmm17, %zmm19

vaesenclast      %zmm16, %zmm17, %zmm19
vaesenclast      (%rax), %zmm17, %zmm19

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  2      7     1.00                        vaesdec	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  3      13    1.00    *                   vaesdec	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      7     1.00                        vaesdeclast	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  3      13    1.00    *                   vaesdeclast	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      7     1.00                        vaesenc	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  3      13    1.00    *                   vaesenc	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      7     1.00                        vaesenclast	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  3      13    1.00    *                   vaesenclast	(%rax), %zmm17, %zmm19

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SBDivider
# CHECK-NEXT: [1]   - SBFPDivider
# CHECK-NEXT: [2]   - SBPort0
# CHECK-NEXT: [3]   - SBPort1
# CHECK-NEXT: [4]   - SBPort4
# CHECK-NEXT: [5]   - SBPort5
# CHECK-NEXT: [6.0] - SBPort23
# CHECK-NEXT: [6.1] - SBPort23

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6.0]  [6.1]
# CHECK-NEXT:  -      -     2.67   2.67    -     10.67  2.00   2.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6.0]  [6.1]  Instructions:
# CHECK-NEXT:  -      -     0.33   0.33    -     1.33    -      -     vaesdec	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.33   0.33    -     1.33   0.50   0.50   vaesdec	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.33   0.33    -     1.33    -      -     vaesdeclast	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.33   0.33    -     1.33   0.50   0.50   vaesdeclast	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.33   0.33    -     1.33    -      -     vaesenc	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.33   0.33    -     1.33   0.50   0.50   vaesenc	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.33   0.33    -     1.33    -      -     vaesenclast	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.33   0.33    -     1.33   0.50   0.50   vaesenclast	(%rax), %zmm17, %zmm19
