; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 4
; RUN: llc -global-isel -stop-after=si-memory-legalizer -mtriple=amdgcn-amd- -mcpu=gfx600 < %s | FileCheck -check-prefix=GFX6 %s
; RUN: llc -global-isel -stop-after=si-memory-legalizer -mtriple=amdgcn-amd- -mcpu=gfx803 < %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -global-isel -stop-after=si-memory-legalizer -mtriple=amdgcn-amd-amdhsa -mcpu=gfx803 < %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -global-isel -stop-after=si-memory-legalizer -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1010 < %s | FileCheck -check-prefix=GFX10WGP %s
; RUN: llc -global-isel -stop-after=si-memory-legalizer -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1010 -mattr=+cumode < %s | FileCheck -check-prefix=GFX10CU %s
; RUN: llc -global-isel -stop-after=si-memory-legalizer -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 < %s | FileCheck -check-prefix=GFX11WGP %s
; RUN: llc -global-isel -stop-after=si-memory-legalizer -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 -mattr=+cumode < %s | FileCheck -check-prefix=GFX11CU %s

; Note: we use MIR test checks + stop after legalizer to prevent
; tests from being optimized out.

define amdgpu_kernel void @system_one_as_acquire() {
  ; GFX6-LABEL: name: system_one_as_acquire
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 3952
  ; GFX6-NEXT:   BUFFER_WBINVL1 implicit $exec
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: system_one_as_acquire
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 3952
  ; GFX8-NEXT:   BUFFER_WBINVL1_VOL implicit $exec
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: system_one_as_acquire
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 16240
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: system_one_as_acquire
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 16240
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: system_one_as_acquire
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 1015
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: system_one_as_acquire
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 1015
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("one-as") acquire
  ret void
}

define amdgpu_kernel void @system_one_as_release() {
  ; GFX6-LABEL: name: system_one_as_release
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 3952
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: system_one_as_release
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 3952
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: system_one_as_release
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 16240
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: system_one_as_release
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 16240
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: system_one_as_release
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 1015
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: system_one_as_release
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 1015
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("one-as") release
  ret void
}

define amdgpu_kernel void @system_one_as_acq_rel() {
  ; GFX6-LABEL: name: system_one_as_acq_rel
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 3952
  ; GFX6-NEXT:   BUFFER_WBINVL1 implicit $exec
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: system_one_as_acq_rel
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 3952
  ; GFX8-NEXT:   BUFFER_WBINVL1_VOL implicit $exec
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: system_one_as_acq_rel
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 16240
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: system_one_as_acq_rel
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 16240
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: system_one_as_acq_rel
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 1015
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: system_one_as_acq_rel
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 1015
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("one-as") acq_rel
  ret void
}

define amdgpu_kernel void @system_one_as_seq_cst() {
  ; GFX6-LABEL: name: system_one_as_seq_cst
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 3952
  ; GFX6-NEXT:   BUFFER_WBINVL1 implicit $exec
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: system_one_as_seq_cst
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 3952
  ; GFX8-NEXT:   BUFFER_WBINVL1_VOL implicit $exec
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: system_one_as_seq_cst
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 16240
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: system_one_as_seq_cst
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 16240
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: system_one_as_seq_cst
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 1015
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: system_one_as_seq_cst
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 1015
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("one-as") seq_cst
  ret void
}

define amdgpu_kernel void @singlethread_one_as_acquire() {
  ; GFX6-LABEL: name: singlethread_one_as_acquire
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: singlethread_one_as_acquire
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: singlethread_one_as_acquire
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: singlethread_one_as_acquire
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: singlethread_one_as_acquire
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: singlethread_one_as_acquire
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("singlethread-one-as") acquire
  ret void
}

define amdgpu_kernel void @singlethread_one_as_release() {
  ; GFX6-LABEL: name: singlethread_one_as_release
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: singlethread_one_as_release
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: singlethread_one_as_release
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: singlethread_one_as_release
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: singlethread_one_as_release
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: singlethread_one_as_release
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("singlethread-one-as") release
  ret void
}

define amdgpu_kernel void @singlethread_one_as_acq_rel() {
  ; GFX6-LABEL: name: singlethread_one_as_acq_rel
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: singlethread_one_as_acq_rel
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: singlethread_one_as_acq_rel
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: singlethread_one_as_acq_rel
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: singlethread_one_as_acq_rel
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: singlethread_one_as_acq_rel
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("singlethread-one-as") acq_rel
  ret void
}

define amdgpu_kernel void @singlethread_one_as_seq_cst() {
  ; GFX6-LABEL: name: singlethread_one_as_seq_cst
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: singlethread_one_as_seq_cst
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: singlethread_one_as_seq_cst
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: singlethread_one_as_seq_cst
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: singlethread_one_as_seq_cst
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: singlethread_one_as_seq_cst
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("singlethread-one-as") seq_cst
  ret void
}

define amdgpu_kernel void @agent_one_as_acquire() {
  ; GFX6-LABEL: name: agent_one_as_acquire
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 3952
  ; GFX6-NEXT:   BUFFER_WBINVL1 implicit $exec
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: agent_one_as_acquire
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 3952
  ; GFX8-NEXT:   BUFFER_WBINVL1_VOL implicit $exec
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: agent_one_as_acquire
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 16240
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: agent_one_as_acquire
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 16240
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: agent_one_as_acquire
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 1015
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: agent_one_as_acquire
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 1015
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("agent-one-as") acquire
  ret void
}

define amdgpu_kernel void @agent_one_as_release() {
  ; GFX6-LABEL: name: agent_one_as_release
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 3952
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: agent_one_as_release
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 3952
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: agent_one_as_release
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 16240
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: agent_one_as_release
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 16240
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: agent_one_as_release
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 1015
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: agent_one_as_release
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 1015
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("agent-one-as") release
  ret void
}

define amdgpu_kernel void @agent_one_as_acq_rel() {
  ; GFX6-LABEL: name: agent_one_as_acq_rel
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 3952
  ; GFX6-NEXT:   BUFFER_WBINVL1 implicit $exec
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: agent_one_as_acq_rel
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 3952
  ; GFX8-NEXT:   BUFFER_WBINVL1_VOL implicit $exec
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: agent_one_as_acq_rel
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 16240
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: agent_one_as_acq_rel
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 16240
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: agent_one_as_acq_rel
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 1015
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: agent_one_as_acq_rel
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 1015
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("agent-one-as") acq_rel
  ret void
}

define amdgpu_kernel void @agent_one_as_seq_cst() {
  ; GFX6-LABEL: name: agent_one_as_seq_cst
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 3952
  ; GFX6-NEXT:   BUFFER_WBINVL1 implicit $exec
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: agent_one_as_seq_cst
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 3952
  ; GFX8-NEXT:   BUFFER_WBINVL1_VOL implicit $exec
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: agent_one_as_seq_cst
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 16240
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: agent_one_as_seq_cst
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 16240
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: agent_one_as_seq_cst
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 1015
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: agent_one_as_seq_cst
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 1015
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("agent-one-as") seq_cst
  ret void
}

define amdgpu_kernel void @workgroup_one_as_acquire() {
  ; GFX6-LABEL: name: workgroup_one_as_acquire
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: workgroup_one_as_acquire
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: workgroup_one_as_acquire
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 16240
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: workgroup_one_as_acquire
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: workgroup_one_as_acquire
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 1015
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: workgroup_one_as_acquire
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("workgroup-one-as") acquire
  ret void
}

define amdgpu_kernel void @workgroup_one_as_release() {
  ; GFX6-LABEL: name: workgroup_one_as_release
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: workgroup_one_as_release
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: workgroup_one_as_release
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 16240
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: workgroup_one_as_release
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: workgroup_one_as_release
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 1015
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: workgroup_one_as_release
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("workgroup-one-as") release
  ret void
}

define amdgpu_kernel void @workgroup_one_as_acq_rel() {
  ; GFX6-LABEL: name: workgroup_one_as_acq_rel
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: workgroup_one_as_acq_rel
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: workgroup_one_as_acq_rel
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 16240
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: workgroup_one_as_acq_rel
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: workgroup_one_as_acq_rel
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 1015
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: workgroup_one_as_acq_rel
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("workgroup-one-as") acq_rel
  ret void
}

define amdgpu_kernel void @workgroup_one_as_seq_cst() {
  ; GFX6-LABEL: name: workgroup_one_as_seq_cst
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: workgroup_one_as_seq_cst
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: workgroup_one_as_seq_cst
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 16240
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: workgroup_one_as_seq_cst
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: workgroup_one_as_seq_cst
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 1015
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: workgroup_one_as_seq_cst
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("workgroup-one-as") seq_cst
  ret void
}

define amdgpu_kernel void @wavefront_one_as_acquire() {
  ; GFX6-LABEL: name: wavefront_one_as_acquire
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: wavefront_one_as_acquire
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: wavefront_one_as_acquire
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: wavefront_one_as_acquire
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: wavefront_one_as_acquire
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: wavefront_one_as_acquire
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("wavefront-one-as") acquire
  ret void
}

define amdgpu_kernel void @wavefront_one_as_release() {
  ; GFX6-LABEL: name: wavefront_one_as_release
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: wavefront_one_as_release
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: wavefront_one_as_release
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: wavefront_one_as_release
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: wavefront_one_as_release
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: wavefront_one_as_release
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("wavefront-one-as") release
  ret void
}

define amdgpu_kernel void @wavefront_one_as_acq_rel() {
  ; GFX6-LABEL: name: wavefront_one_as_acq_rel
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: wavefront_one_as_acq_rel
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: wavefront_one_as_acq_rel
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: wavefront_one_as_acq_rel
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: wavefront_one_as_acq_rel
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: wavefront_one_as_acq_rel
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("wavefront-one-as") acq_rel
  ret void
}

define amdgpu_kernel void @wavefront_one_as_seq_cst() {
  ; GFX6-LABEL: name: wavefront_one_as_seq_cst
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: wavefront_one_as_seq_cst
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: wavefront_one_as_seq_cst
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: wavefront_one_as_seq_cst
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: wavefront_one_as_seq_cst
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: wavefront_one_as_seq_cst
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("wavefront-one-as") seq_cst
  ret void
}

define amdgpu_kernel void @system_acquire() {
  ; GFX6-LABEL: name: system_acquire
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 112
  ; GFX6-NEXT:   BUFFER_WBINVL1 implicit $exec
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: system_acquire
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 112
  ; GFX8-NEXT:   BUFFER_WBINVL1_VOL implicit $exec
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: system_acquire
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 112
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: system_acquire
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 112
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: system_acquire
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 7
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: system_acquire
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 7
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence acquire
  ret void
}

define amdgpu_kernel void @system_release() {
  ; GFX6-LABEL: name: system_release
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 112
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: system_release
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 112
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: system_release
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 112
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: system_release
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 112
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: system_release
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 7
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: system_release
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 7
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence release
  ret void
}

define amdgpu_kernel void @system_acq_rel() {
  ; GFX6-LABEL: name: system_acq_rel
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 112
  ; GFX6-NEXT:   BUFFER_WBINVL1 implicit $exec
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: system_acq_rel
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 112
  ; GFX8-NEXT:   BUFFER_WBINVL1_VOL implicit $exec
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: system_acq_rel
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 112
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: system_acq_rel
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 112
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: system_acq_rel
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 7
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: system_acq_rel
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 7
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence acq_rel
  ret void
}

define amdgpu_kernel void @system_seq_cst() {
  ; GFX6-LABEL: name: system_seq_cst
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 112
  ; GFX6-NEXT:   BUFFER_WBINVL1 implicit $exec
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: system_seq_cst
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 112
  ; GFX8-NEXT:   BUFFER_WBINVL1_VOL implicit $exec
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: system_seq_cst
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 112
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: system_seq_cst
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 112
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: system_seq_cst
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 7
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: system_seq_cst
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 7
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence seq_cst
  ret void
}

define amdgpu_kernel void @singlethread_acquire() {
  ; GFX6-LABEL: name: singlethread_acquire
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: singlethread_acquire
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: singlethread_acquire
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: singlethread_acquire
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: singlethread_acquire
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: singlethread_acquire
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("singlethread") acquire
  ret void
}

define amdgpu_kernel void @singlethread_release() {
  ; GFX6-LABEL: name: singlethread_release
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: singlethread_release
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: singlethread_release
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: singlethread_release
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: singlethread_release
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: singlethread_release
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("singlethread") release
  ret void
}

define amdgpu_kernel void @singlethread_acq_rel() {
  ; GFX6-LABEL: name: singlethread_acq_rel
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: singlethread_acq_rel
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: singlethread_acq_rel
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: singlethread_acq_rel
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: singlethread_acq_rel
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: singlethread_acq_rel
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("singlethread") acq_rel
  ret void
}

define amdgpu_kernel void @singlethread_seq_cst() {
  ; GFX6-LABEL: name: singlethread_seq_cst
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: singlethread_seq_cst
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: singlethread_seq_cst
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: singlethread_seq_cst
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: singlethread_seq_cst
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: singlethread_seq_cst
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("singlethread") seq_cst
  ret void
}

define amdgpu_kernel void @agent_acquire() {
  ; GFX6-LABEL: name: agent_acquire
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 112
  ; GFX6-NEXT:   BUFFER_WBINVL1 implicit $exec
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: agent_acquire
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 112
  ; GFX8-NEXT:   BUFFER_WBINVL1_VOL implicit $exec
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: agent_acquire
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 112
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: agent_acquire
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 112
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: agent_acquire
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 7
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: agent_acquire
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 7
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("agent") acquire
  ret void
}

define amdgpu_kernel void @agent_release() {
  ; GFX6-LABEL: name: agent_release
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 112
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: agent_release
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 112
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: agent_release
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 112
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: agent_release
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 112
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: agent_release
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 7
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: agent_release
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 7
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("agent") release
  ret void
}

define amdgpu_kernel void @agent_acq_rel() {
  ; GFX6-LABEL: name: agent_acq_rel
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 112
  ; GFX6-NEXT:   BUFFER_WBINVL1 implicit $exec
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: agent_acq_rel
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 112
  ; GFX8-NEXT:   BUFFER_WBINVL1_VOL implicit $exec
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: agent_acq_rel
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 112
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: agent_acq_rel
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 112
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: agent_acq_rel
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 7
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: agent_acq_rel
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 7
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("agent") acq_rel
  ret void
}

define amdgpu_kernel void @agent_seq_cst() {
  ; GFX6-LABEL: name: agent_seq_cst
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 112
  ; GFX6-NEXT:   BUFFER_WBINVL1 implicit $exec
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: agent_seq_cst
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 112
  ; GFX8-NEXT:   BUFFER_WBINVL1_VOL implicit $exec
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: agent_seq_cst
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 112
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: agent_seq_cst
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 112
  ; GFX10CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: agent_seq_cst
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 7
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: agent_seq_cst
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 7
  ; GFX11CU-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11CU-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11CU-NEXT:   BUFFER_GL1_INV implicit $exec
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @workgroup_acquire() {
  ; GFX6-LABEL: name: workgroup_acquire
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 127
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: workgroup_acquire
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 127
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: workgroup_acquire
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 112
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: workgroup_acquire
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 49279
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: workgroup_acquire
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 7
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: workgroup_acquire
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 64519
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("workgroup") acquire
  ret void
}

define amdgpu_kernel void @workgroup_release() {
  ; GFX6-LABEL: name: workgroup_release
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 127
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: workgroup_release
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 127
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: workgroup_release
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 112
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: workgroup_release
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 49279
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: workgroup_release
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 7
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: workgroup_release
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 64519
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("workgroup") release
  ret void
}

define amdgpu_kernel void @workgroup_acq_rel() {
  ; GFX6-LABEL: name: workgroup_acq_rel
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 127
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: workgroup_acq_rel
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 127
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: workgroup_acq_rel
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 112
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: workgroup_acq_rel
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 49279
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: workgroup_acq_rel
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 7
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: workgroup_acq_rel
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 64519
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("workgroup") acq_rel
  ret void
}

define amdgpu_kernel void @workgroup_seq_cst() {
  ; GFX6-LABEL: name: workgroup_seq_cst
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_WAITCNT_soft 127
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: workgroup_seq_cst
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_WAITCNT_soft 127
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: workgroup_seq_cst
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_WAITCNT_soft 112
  ; GFX10WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX10WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: workgroup_seq_cst
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_WAITCNT_soft 49279
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: workgroup_seq_cst
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_WAITCNT_soft 7
  ; GFX11WGP-NEXT:   S_WAITCNT_VSCNT_soft undef $sgpr_null, 0
  ; GFX11WGP-NEXT:   BUFFER_GL0_INV implicit $exec
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: workgroup_seq_cst
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_WAITCNT_soft 64519
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @wavefront_acquire() {
  ; GFX6-LABEL: name: wavefront_acquire
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: wavefront_acquire
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: wavefront_acquire
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: wavefront_acquire
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: wavefront_acquire
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: wavefront_acquire
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("wavefront") acquire
  ret void
}

define amdgpu_kernel void @wavefront_release() {
  ; GFX6-LABEL: name: wavefront_release
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: wavefront_release
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: wavefront_release
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: wavefront_release
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: wavefront_release
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: wavefront_release
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("wavefront") release
  ret void
}

define amdgpu_kernel void @wavefront_acq_rel() {
  ; GFX6-LABEL: name: wavefront_acq_rel
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: wavefront_acq_rel
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: wavefront_acq_rel
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: wavefront_acq_rel
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: wavefront_acq_rel
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: wavefront_acq_rel
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("wavefront") acq_rel
  ret void
}

define amdgpu_kernel void @wavefront_seq_cst() {
  ; GFX6-LABEL: name: wavefront_seq_cst
  ; GFX6: bb.0.entry:
  ; GFX6-NEXT:   S_ENDPGM 0
  ;
  ; GFX8-LABEL: name: wavefront_seq_cst
  ; GFX8: bb.0.entry:
  ; GFX8-NEXT:   S_ENDPGM 0
  ;
  ; GFX10WGP-LABEL: name: wavefront_seq_cst
  ; GFX10WGP: bb.0.entry:
  ; GFX10WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX10CU-LABEL: name: wavefront_seq_cst
  ; GFX10CU: bb.0.entry:
  ; GFX10CU-NEXT:   S_ENDPGM 0
  ;
  ; GFX11WGP-LABEL: name: wavefront_seq_cst
  ; GFX11WGP: bb.0.entry:
  ; GFX11WGP-NEXT:   S_ENDPGM 0
  ;
  ; GFX11CU-LABEL: name: wavefront_seq_cst
  ; GFX11CU: bb.0.entry:
  ; GFX11CU-NEXT:   S_ENDPGM 0
entry:
  fence syncscope("wavefront") seq_cst
  ret void
}
