; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+zfh \
; RUN:   -verify-machineinstrs -target-abi ilp32f | \
; RUN:   FileCheck -check-prefixes=CHECKIZFH %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+zfh \
; RUN:   -verify-machineinstrs -target-abi lp64f | \
; RUN:   FileCheck -check-prefixes=CHECKIZFH %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+zhinx \
; RUN:   -verify-machineinstrs -target-abi ilp32 | \
; RUN:   FileCheck -check-prefixes=CHECKIZHINX %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+zhinx \
; RUN:   -verify-machineinstrs -target-abi lp64 | \
; RUN:   FileCheck -check-prefixes=CHECKIZHINX %s

declare half @llvm.minimum.f16(half, half)

define half @fminimum_f16(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fminimum_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    feq.h a0, fa0, fa0
; CHECKIZFH-NEXT:    fmv.h fa5, fa1
; CHECKIZFH-NEXT:    beqz a0, .LBB0_3
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    feq.h a0, fa1, fa1
; CHECKIZFH-NEXT:    beqz a0, .LBB0_4
; CHECKIZFH-NEXT:  .LBB0_2:
; CHECKIZFH-NEXT:    fmin.h fa0, fa0, fa5
; CHECKIZFH-NEXT:    ret
; CHECKIZFH-NEXT:  .LBB0_3:
; CHECKIZFH-NEXT:    fmv.h fa5, fa0
; CHECKIZFH-NEXT:    feq.h a0, fa1, fa1
; CHECKIZFH-NEXT:    bnez a0, .LBB0_2
; CHECKIZFH-NEXT:  .LBB0_4:
; CHECKIZFH-NEXT:    fmin.h fa0, fa1, fa5
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fminimum_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    feq.h a3, a0, a0
; CHECKIZHINX-NEXT:    mv a2, a1
; CHECKIZHINX-NEXT:    beqz a3, .LBB0_3
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    feq.h a3, a1, a1
; CHECKIZHINX-NEXT:    beqz a3, .LBB0_4
; CHECKIZHINX-NEXT:  .LBB0_2:
; CHECKIZHINX-NEXT:    fmin.h a0, a0, a2
; CHECKIZHINX-NEXT:    ret
; CHECKIZHINX-NEXT:  .LBB0_3:
; CHECKIZHINX-NEXT:    mv a2, a0
; CHECKIZHINX-NEXT:    feq.h a3, a1, a1
; CHECKIZHINX-NEXT:    bnez a3, .LBB0_2
; CHECKIZHINX-NEXT:  .LBB0_4:
; CHECKIZHINX-NEXT:    fmin.h a0, a1, a2
; CHECKIZHINX-NEXT:    ret
  %1 = call half @llvm.minimum.f16(half %a, half %b)
  ret half %1
}

declare half @llvm.maximum.f16(half, half)

define half @fmaximum_f16(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fmaximum_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    feq.h a0, fa0, fa0
; CHECKIZFH-NEXT:    fmv.h fa5, fa1
; CHECKIZFH-NEXT:    beqz a0, .LBB1_3
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    feq.h a0, fa1, fa1
; CHECKIZFH-NEXT:    beqz a0, .LBB1_4
; CHECKIZFH-NEXT:  .LBB1_2:
; CHECKIZFH-NEXT:    fmax.h fa0, fa0, fa5
; CHECKIZFH-NEXT:    ret
; CHECKIZFH-NEXT:  .LBB1_3:
; CHECKIZFH-NEXT:    fmv.h fa5, fa0
; CHECKIZFH-NEXT:    feq.h a0, fa1, fa1
; CHECKIZFH-NEXT:    bnez a0, .LBB1_2
; CHECKIZFH-NEXT:  .LBB1_4:
; CHECKIZFH-NEXT:    fmax.h fa0, fa1, fa5
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fmaximum_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    feq.h a3, a0, a0
; CHECKIZHINX-NEXT:    mv a2, a1
; CHECKIZHINX-NEXT:    beqz a3, .LBB1_3
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    feq.h a3, a1, a1
; CHECKIZHINX-NEXT:    beqz a3, .LBB1_4
; CHECKIZHINX-NEXT:  .LBB1_2:
; CHECKIZHINX-NEXT:    fmax.h a0, a0, a2
; CHECKIZHINX-NEXT:    ret
; CHECKIZHINX-NEXT:  .LBB1_3:
; CHECKIZHINX-NEXT:    mv a2, a0
; CHECKIZHINX-NEXT:    feq.h a3, a1, a1
; CHECKIZHINX-NEXT:    bnez a3, .LBB1_2
; CHECKIZHINX-NEXT:  .LBB1_4:
; CHECKIZHINX-NEXT:    fmax.h a0, a1, a2
; CHECKIZHINX-NEXT:    ret
  %1 = call half @llvm.maximum.f16(half %a, half %b)
  ret half %1
}

define half @fminimum_nnan_f16(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fminimum_nnan_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fmin.h fa0, fa0, fa1
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fminimum_nnan_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fmin.h a0, a0, a1
; CHECKIZHINX-NEXT:    ret
  %1 = call nnan half @llvm.minimum.f16(half %a, half %b)
  ret half %1
}

define half @fmaximum_nnan_f16(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fmaximum_nnan_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fmax.h fa0, fa0, fa1
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fmaximum_nnan_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fmax.h a0, a0, a1
; CHECKIZHINX-NEXT:    ret
  %1 = call nnan half @llvm.maximum.f16(half %a, half %b)
  ret half %1
}

define half @fminimum_nnan_attr_f16(half %a, half %b) nounwind "no-nans-fp-math"="true" {
; CHECKIZFH-LABEL: fminimum_nnan_attr_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fmin.h fa0, fa0, fa1
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fminimum_nnan_attr_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fmin.h a0, a0, a1
; CHECKIZHINX-NEXT:    ret
  %1 = call half @llvm.minimum.f16(half %a, half %b)
  ret half %1
}

define half @fminimum_nnan_op_f16(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fminimum_nnan_op_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    feq.h a0, fa0, fa0
; CHECKIZFH-NEXT:    bnez a0, .LBB5_2
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    fmin.h fa0, fa0, fa0
; CHECKIZFH-NEXT:    ret
; CHECKIZFH-NEXT:  .LBB5_2:
; CHECKIZFH-NEXT:    fadd.h fa5, fa0, fa0
; CHECKIZFH-NEXT:    fmin.h fa0, fa0, fa5
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fminimum_nnan_op_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    feq.h a1, a0, a0
; CHECKIZHINX-NEXT:    bnez a1, .LBB5_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fmin.h a0, a0, a0
; CHECKIZHINX-NEXT:    ret
; CHECKIZHINX-NEXT:  .LBB5_2:
; CHECKIZHINX-NEXT:    fadd.h a1, a0, a0
; CHECKIZHINX-NEXT:    fmin.h a0, a0, a1
; CHECKIZHINX-NEXT:    ret
  %c = fadd nnan half %a, %a
  %1 = call half @llvm.minimum.f16(half %a, half %c)
  ret half %1
}

define half @fmaximum_nnan_op_f16(half %a, half %b) nounwind {
; CHECKIZFH-LABEL: fmaximum_nnan_op_f16:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fadd.h fa5, fa0, fa1
; CHECKIZFH-NEXT:    fsub.h fa4, fa0, fa1
; CHECKIZFH-NEXT:    fmax.h fa0, fa5, fa4
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fmaximum_nnan_op_f16:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fadd.h a2, a0, a1
; CHECKIZHINX-NEXT:    fsub.h a0, a0, a1
; CHECKIZHINX-NEXT:    fmax.h a0, a2, a0
; CHECKIZHINX-NEXT:    ret
  %c = fadd nnan half %a, %b
  %d = fsub nnan half %a, %b
  %1 = call half @llvm.maximum.f16(half %c, half %d)
  ret half %1
}
