; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -aarch64-sve-vector-bits-min=1024  < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_1024
; RUN: llc -aarch64-sve-vector-bits-min=2048  < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_2048

target triple = "aarch64-unknown-linux-gnu"

define <4 x i32> @load_zext_v4i16i32(ptr %ap) vscale_range(2,0) #0 {
; CHECK-LABEL: load_zext_v4i16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    ret
  %a = load <4 x i16>, ptr %ap
  %val = zext <4 x i16> %a to <4 x i32>
  ret <4 x i32> %val
}

; Don't try to use SVE for irregular types.
define <2 x i256> @load_zext_v2i64i256(ptr %ap) #0 {
; CHECK-LABEL: load_zext_v2i64i256:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    mov x1, xzr
; CHECK-NEXT:    mov x2, xzr
; CHECK-NEXT:    mov x3, xzr
; CHECK-NEXT:    mov x5, xzr
; CHECK-NEXT:    mov x6, xzr
; CHECK-NEXT:    mov x4, v0.d[1]
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    mov x7, xzr
; CHECK-NEXT:    ret
  %a = load <2 x i64>, ptr %ap
  %val = zext <2 x i64> %a to <2 x i256>
  ret <2 x i256> %val
}

define void @load_zext_v8i16i32(ptr %ap, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: load_zext_v8i16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl8
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [x0]
; CHECK-NEXT:    st1w { z0.s }, p0, [x1]
; CHECK-NEXT:    ret
  %a = load <8 x i16>, ptr %ap
  %val = zext <8 x i16> %a to <8 x i32>
  store <8 x i32> %val, ptr %b
  ret void
}

define void @load_zext_v16i16i32(ptr %ap, ptr %b) vscale_range(4,0) #0 {
; CHECK-LABEL: load_zext_v16i16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl16
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [x0]
; CHECK-NEXT:    st1w { z0.s }, p0, [x1]
; CHECK-NEXT:    ret
  %a = load <16 x i16>, ptr %ap
  %val = zext <16 x i16> %a to <16 x i32>
  store <16 x i32> %val, ptr %b
  ret void
}

define void @load_zext_v32i16i32(ptr %ap, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: load_zext_v32i16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl32
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [x0]
; CHECK-NEXT:    st1w { z0.s }, p0, [x1]
; CHECK-NEXT:    ret
  %a = load <32 x i16>, ptr %ap
  %val = zext <32 x i16> %a to <32 x i32>
  store <32 x i32> %val, ptr %b
  ret void
}

define void @load_zext_v64i16i32(ptr %ap, ptr %b) #0 {
; VBITS_GE_1024-LABEL: load_zext_v64i16i32:
; VBITS_GE_1024:       // %bb.0:
; VBITS_GE_1024-NEXT:    ptrue p0.s, vl32
; VBITS_GE_1024-NEXT:    mov x8, #32 // =0x20
; VBITS_GE_1024-NEXT:    ld1h { z0.s }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_1024-NEXT:    ld1h { z1.s }, p0/z, [x0]
; VBITS_GE_1024-NEXT:    st1w { z0.s }, p0, [x1, x8, lsl #2]
; VBITS_GE_1024-NEXT:    st1w { z1.s }, p0, [x1]
; VBITS_GE_1024-NEXT:    ret
;
; VBITS_GE_2048-LABEL: load_zext_v64i16i32:
; VBITS_GE_2048:       // %bb.0:
; VBITS_GE_2048-NEXT:    ptrue p0.s, vl64
; VBITS_GE_2048-NEXT:    ld1h { z0.s }, p0/z, [x0]
; VBITS_GE_2048-NEXT:    st1w { z0.s }, p0, [x1]
; VBITS_GE_2048-NEXT:    ret
  %a = load <64 x i16>, ptr %ap
  %val = zext <64 x i16> %a to <64 x i32>
  store <64 x i32> %val, ptr %b
  ret void
}

define <4 x i32> @load_sext_v4i16i32(ptr %ap) vscale_range(2,0) #0 {
; CHECK-LABEL: load_sext_v4i16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-NEXT:    ret
  %a = load <4 x i16>, ptr %ap
  %val = sext <4 x i16> %a to <4 x i32>
  ret <4 x i32> %val
}

define void @load_sext_v8i16i32(ptr %ap, ptr %b) vscale_range(2,0) #0 {
; CHECK-LABEL: load_sext_v8i16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl8
; CHECK-NEXT:    ld1sh { z0.s }, p0/z, [x0]
; CHECK-NEXT:    st1w { z0.s }, p0, [x1]
; CHECK-NEXT:    ret
  %a = load <8 x i16>, ptr %ap
  %val = sext <8 x i16> %a to <8 x i32>
  store <8 x i32> %val, ptr %b
  ret void
}

define void @load_sext_v16i16i32(ptr %ap, ptr %b) vscale_range(4,0) #0 {
; CHECK-LABEL: load_sext_v16i16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl16
; CHECK-NEXT:    ld1sh { z0.s }, p0/z, [x0]
; CHECK-NEXT:    st1w { z0.s }, p0, [x1]
; CHECK-NEXT:    ret
  %a = load <16 x i16>, ptr %ap
  %val = sext <16 x i16> %a to <16 x i32>
  store <16 x i32> %val, ptr %b
  ret void
}

define void @load_sext_v32i16i32(ptr %ap, ptr %b) vscale_range(8,0) #0 {
; CHECK-LABEL: load_sext_v32i16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl32
; CHECK-NEXT:    ld1sh { z0.s }, p0/z, [x0]
; CHECK-NEXT:    st1w { z0.s }, p0, [x1]
; CHECK-NEXT:    ret
  %a = load <32 x i16>, ptr %ap
  %val = sext <32 x i16> %a to <32 x i32>
  store <32 x i32> %val, ptr %b
  ret void
}

define void @load_sext_v64i16i32(ptr %ap, ptr %b) #0 {
; VBITS_GE_1024-LABEL: load_sext_v64i16i32:
; VBITS_GE_1024:       // %bb.0:
; VBITS_GE_1024-NEXT:    ptrue p0.s, vl32
; VBITS_GE_1024-NEXT:    mov x8, #32 // =0x20
; VBITS_GE_1024-NEXT:    ld1sh { z0.s }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_1024-NEXT:    ld1sh { z1.s }, p0/z, [x0]
; VBITS_GE_1024-NEXT:    st1w { z0.s }, p0, [x1, x8, lsl #2]
; VBITS_GE_1024-NEXT:    st1w { z1.s }, p0, [x1]
; VBITS_GE_1024-NEXT:    ret
;
; VBITS_GE_2048-LABEL: load_sext_v64i16i32:
; VBITS_GE_2048:       // %bb.0:
; VBITS_GE_2048-NEXT:    ptrue p0.s, vl64
; VBITS_GE_2048-NEXT:    ld1sh { z0.s }, p0/z, [x0]
; VBITS_GE_2048-NEXT:    st1w { z0.s }, p0, [x1]
; VBITS_GE_2048-NEXT:    ret
  %a = load <64 x i16>, ptr %ap
  %val = sext <64 x i16> %a to <64 x i32>
  store <64 x i32> %val, ptr %b
  ret void
}

define void @load_zext_v32i8i64(ptr %ap, ptr %b) #0 {
; VBITS_GE_1024-LABEL: load_zext_v32i8i64:
; VBITS_GE_1024:       // %bb.0:
; VBITS_GE_1024-NEXT:    ptrue p0.d, vl16
; VBITS_GE_1024-NEXT:    mov w8, #16 // =0x10
; VBITS_GE_1024-NEXT:    ld1b { z0.d }, p0/z, [x0, x8]
; VBITS_GE_1024-NEXT:    ld1b { z1.d }, p0/z, [x0]
; VBITS_GE_1024-NEXT:    mov x8, #16 // =0x10
; VBITS_GE_1024-NEXT:    st1d { z0.d }, p0, [x1, x8, lsl #3]
; VBITS_GE_1024-NEXT:    st1d { z1.d }, p0, [x1]
; VBITS_GE_1024-NEXT:    ret
;
; VBITS_GE_2048-LABEL: load_zext_v32i8i64:
; VBITS_GE_2048:       // %bb.0:
; VBITS_GE_2048-NEXT:    ptrue p0.d, vl32
; VBITS_GE_2048-NEXT:    ld1b { z0.d }, p0/z, [x0]
; VBITS_GE_2048-NEXT:    st1d { z0.d }, p0, [x1]
; VBITS_GE_2048-NEXT:    ret
  %a = load <32 x i8>, ptr %ap
  %val = zext <32 x i8> %a to <32 x i64>
  store <32 x i64> %val, ptr %b
  ret void
}

define void @load_sext_v32i8i64(ptr %ap, ptr %b) #0 {
; VBITS_GE_1024-LABEL: load_sext_v32i8i64:
; VBITS_GE_1024:       // %bb.0:
; VBITS_GE_1024-NEXT:    ptrue p0.d, vl16
; VBITS_GE_1024-NEXT:    mov w8, #16 // =0x10
; VBITS_GE_1024-NEXT:    ld1sb { z0.d }, p0/z, [x0, x8]
; VBITS_GE_1024-NEXT:    ld1sb { z1.d }, p0/z, [x0]
; VBITS_GE_1024-NEXT:    mov x8, #16 // =0x10
; VBITS_GE_1024-NEXT:    st1d { z0.d }, p0, [x1, x8, lsl #3]
; VBITS_GE_1024-NEXT:    st1d { z1.d }, p0, [x1]
; VBITS_GE_1024-NEXT:    ret
;
; VBITS_GE_2048-LABEL: load_sext_v32i8i64:
; VBITS_GE_2048:       // %bb.0:
; VBITS_GE_2048-NEXT:    ptrue p0.d, vl32
; VBITS_GE_2048-NEXT:    ld1sb { z0.d }, p0/z, [x0]
; VBITS_GE_2048-NEXT:    st1d { z0.d }, p0, [x1]
; VBITS_GE_2048-NEXT:    ret
  %a = load <32 x i8>, ptr %ap
  %val = sext <32 x i8> %a to <32 x i64>
  store <32 x i64> %val, ptr %b
  ret void
}

define void @load_zext_v32i16i64(ptr %ap, ptr %b) #0 {
; VBITS_GE_1024-LABEL: load_zext_v32i16i64:
; VBITS_GE_1024:       // %bb.0:
; VBITS_GE_1024-NEXT:    ptrue p0.d, vl16
; VBITS_GE_1024-NEXT:    mov x8, #16 // =0x10
; VBITS_GE_1024-NEXT:    ld1h { z0.d }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_1024-NEXT:    ld1h { z1.d }, p0/z, [x0]
; VBITS_GE_1024-NEXT:    st1d { z0.d }, p0, [x1, x8, lsl #3]
; VBITS_GE_1024-NEXT:    st1d { z1.d }, p0, [x1]
; VBITS_GE_1024-NEXT:    ret
;
; VBITS_GE_2048-LABEL: load_zext_v32i16i64:
; VBITS_GE_2048:       // %bb.0:
; VBITS_GE_2048-NEXT:    ptrue p0.d, vl32
; VBITS_GE_2048-NEXT:    ld1h { z0.d }, p0/z, [x0]
; VBITS_GE_2048-NEXT:    st1d { z0.d }, p0, [x1]
; VBITS_GE_2048-NEXT:    ret
  %a = load <32 x i16>, ptr %ap
  %val = zext <32 x i16> %a to <32 x i64>
  store <32 x i64> %val, ptr %b
  ret void
}

define void @load_sext_v32i16i64(ptr %ap, ptr %b) #0 {
; VBITS_GE_1024-LABEL: load_sext_v32i16i64:
; VBITS_GE_1024:       // %bb.0:
; VBITS_GE_1024-NEXT:    ptrue p0.d, vl16
; VBITS_GE_1024-NEXT:    mov x8, #16 // =0x10
; VBITS_GE_1024-NEXT:    ld1sh { z0.d }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_1024-NEXT:    ld1sh { z1.d }, p0/z, [x0]
; VBITS_GE_1024-NEXT:    st1d { z0.d }, p0, [x1, x8, lsl #3]
; VBITS_GE_1024-NEXT:    st1d { z1.d }, p0, [x1]
; VBITS_GE_1024-NEXT:    ret
;
; VBITS_GE_2048-LABEL: load_sext_v32i16i64:
; VBITS_GE_2048:       // %bb.0:
; VBITS_GE_2048-NEXT:    ptrue p0.d, vl32
; VBITS_GE_2048-NEXT:    ld1sh { z0.d }, p0/z, [x0]
; VBITS_GE_2048-NEXT:    st1d { z0.d }, p0, [x1]
; VBITS_GE_2048-NEXT:    ret
  %a = load <32 x i16>, ptr %ap
  %val = sext <32 x i16> %a to <32 x i64>
  store <32 x i64> %val, ptr %b
  ret void
}

define void @load_zext_v32i32i64(ptr %ap, ptr %b) #0 {
; VBITS_GE_1024-LABEL: load_zext_v32i32i64:
; VBITS_GE_1024:       // %bb.0:
; VBITS_GE_1024-NEXT:    ptrue p0.d, vl16
; VBITS_GE_1024-NEXT:    mov x8, #16 // =0x10
; VBITS_GE_1024-NEXT:    ld1w { z0.d }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_1024-NEXT:    ld1w { z1.d }, p0/z, [x0]
; VBITS_GE_1024-NEXT:    st1d { z0.d }, p0, [x1, x8, lsl #3]
; VBITS_GE_1024-NEXT:    st1d { z1.d }, p0, [x1]
; VBITS_GE_1024-NEXT:    ret
;
; VBITS_GE_2048-LABEL: load_zext_v32i32i64:
; VBITS_GE_2048:       // %bb.0:
; VBITS_GE_2048-NEXT:    ptrue p0.d, vl32
; VBITS_GE_2048-NEXT:    ld1w { z0.d }, p0/z, [x0]
; VBITS_GE_2048-NEXT:    st1d { z0.d }, p0, [x1]
; VBITS_GE_2048-NEXT:    ret
  %a = load <32 x i32>, ptr %ap
  %val = zext <32 x i32> %a to <32 x i64>
  store <32 x i64> %val, ptr %b
  ret void
}

define void @load_sext_v32i32i64(ptr %ap, ptr %b) #0 {
; VBITS_GE_1024-LABEL: load_sext_v32i32i64:
; VBITS_GE_1024:       // %bb.0:
; VBITS_GE_1024-NEXT:    ptrue p0.d, vl16
; VBITS_GE_1024-NEXT:    mov x8, #16 // =0x10
; VBITS_GE_1024-NEXT:    ld1sw { z0.d }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_1024-NEXT:    ld1sw { z1.d }, p0/z, [x0]
; VBITS_GE_1024-NEXT:    st1d { z0.d }, p0, [x1, x8, lsl #3]
; VBITS_GE_1024-NEXT:    st1d { z1.d }, p0, [x1]
; VBITS_GE_1024-NEXT:    ret
;
; VBITS_GE_2048-LABEL: load_sext_v32i32i64:
; VBITS_GE_2048:       // %bb.0:
; VBITS_GE_2048-NEXT:    ptrue p0.d, vl32
; VBITS_GE_2048-NEXT:    ld1sw { z0.d }, p0/z, [x0]
; VBITS_GE_2048-NEXT:    st1d { z0.d }, p0, [x1]
; VBITS_GE_2048-NEXT:    ret
  %a = load <32 x i32>, ptr %ap
  %val = sext <32 x i32> %a to <32 x i64>
  store <32 x i64> %val, ptr %b
  ret void
}

attributes #0 = { "target-features"="+sve" }
