; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN:   FileCheck %s

; These test cases aim to test the VSX PCV Generate Operations on Power10.

declare <16 x i8> @llvm.ppc.vsx.xxgenpcvbm(<16 x i8>, i32)
declare <8 x i16> @llvm.ppc.vsx.xxgenpcvhm(<8 x i16>, i32)
declare <4 x i32> @llvm.ppc.vsx.xxgenpcvwm(<4 x i32>, i32)
declare <2 x i64> @llvm.ppc.vsx.xxgenpcvdm(<2 x i64>, i32)

define <16 x i8> @test_xxgenpcvbm(<16 x i8> %a) {
; CHECK-LABEL: test_xxgenpcvbm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxgenpcvbm v2, v2, 1
; CHECK-NEXT:    blr
entry:
  %gen = tail call <16 x i8> @llvm.ppc.vsx.xxgenpcvbm(<16 x i8> %a, i32 1)
  ret <16 x i8> %gen
}

define <8 x i16> @test_xxgenpcvhm(<8 x i16> %a) {
; CHECK-LABEL: test_xxgenpcvhm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxgenpcvhm v2, v2, 1
; CHECK-NEXT:    blr
entry:
  %gen = tail call <8 x i16> @llvm.ppc.vsx.xxgenpcvhm(<8 x i16> %a, i32 1)
  ret <8 x i16> %gen
}

define <4 x i32> @test_xxgenpcvwm(<4 x i32> %a) {
; CHECK-LABEL: test_xxgenpcvwm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxgenpcvwm v2, v2, 1
; CHECK-NEXT:    blr
entry:
  %gen = tail call <4 x i32> @llvm.ppc.vsx.xxgenpcvwm(<4 x i32> %a, i32 1)
  ret <4 x i32> %gen
}

define <2 x i64> @test_xxgenpcvdm(<2 x i64> %a) {
; CHECK-LABEL: test_xxgenpcvdm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxgenpcvdm v2, v2, 1
; CHECK-NEXT:    blr
entry:
  %gen = tail call <2 x i64> @llvm.ppc.vsx.xxgenpcvdm(<2 x i64> %a, i32 1)
  ret <2 x i64> %gen
}
