; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -mtriple=riscv32 -mattr=+zve32x,+zvl32b -interleaved-access -S | FileCheck %s -check-prefix=ZVL32B
; RUN: opt < %s -mtriple=riscv32 -mattr=+zve32x,+zvl128b -interleaved-access -S | FileCheck %s -check-prefix=ZVL128B
; RUN: opt < %s -mtriple=riscv32 -mattr=+zve32x,+zvl32b -passes=interleaved-access -S | FileCheck %s -check-prefix=ZVL32B
; RUN: opt < %s -mtriple=riscv32 -mattr=+zve32x,+zvl128b -passes=interleaved-access -S | FileCheck %s -check-prefix=ZVL128B

; Make sure that we don't lower interleaved loads that won't fit into the minimum vlen

define {<16 x i32>, <16 x i32>} @load_factor2_large(ptr %ptr) {
; ZVL32B-LABEL: @load_factor2_large(
; ZVL32B-NEXT:    [[INTERLEAVED_VEC:%.*]] = load <32 x i32>, ptr [[PTR:%.*]], align 128
; ZVL32B-NEXT:    [[V0:%.*]] = shufflevector <32 x i32> [[INTERLEAVED_VEC]], <32 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; ZVL32B-NEXT:    [[V1:%.*]] = shufflevector <32 x i32> [[INTERLEAVED_VEC]], <32 x i32> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; ZVL32B-NEXT:    [[RES0:%.*]] = insertvalue { <16 x i32>, <16 x i32> } undef, <16 x i32> [[V0]], 0
; ZVL32B-NEXT:    [[RES1:%.*]] = insertvalue { <16 x i32>, <16 x i32> } [[RES0]], <16 x i32> [[V1]], 1
; ZVL32B-NEXT:    ret { <16 x i32>, <16 x i32> } [[RES1]]
;
; ZVL128B-LABEL: @load_factor2_large(
; ZVL128B-NEXT:    [[TMP1:%.*]] = call { <16 x i32>, <16 x i32> } @llvm.riscv.seg2.load.v16i32.p0.i32(ptr [[PTR:%.*]], i32 16)
; ZVL128B-NEXT:    [[TMP2:%.*]] = extractvalue { <16 x i32>, <16 x i32> } [[TMP1]], 1
; ZVL128B-NEXT:    [[TMP3:%.*]] = extractvalue { <16 x i32>, <16 x i32> } [[TMP1]], 0
; ZVL128B-NEXT:    [[RES0:%.*]] = insertvalue { <16 x i32>, <16 x i32> } undef, <16 x i32> [[TMP3]], 0
; ZVL128B-NEXT:    [[RES1:%.*]] = insertvalue { <16 x i32>, <16 x i32> } [[RES0]], <16 x i32> [[TMP2]], 1
; ZVL128B-NEXT:    ret { <16 x i32>, <16 x i32> } [[RES1]]
;
  %interleaved.vec = load <32 x i32>, ptr %ptr
  %v0 = shufflevector <32 x i32> %interleaved.vec, <32 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %v1 = shufflevector <32 x i32> %interleaved.vec, <32 x i32> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %res0 = insertvalue {<16 x i32>, <16 x i32>} undef, <16 x i32> %v0, 0
  %res1 = insertvalue {<16 x i32>, <16 x i32>} %res0, <16 x i32> %v1, 1
  ret {<16 x i32>, <16 x i32>} %res1
  ; ret void
}
