; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s

;
; trunc(abs(sub(sext(a),sext(b)))) -> abds(a,b)
;

define i8 @abd_ext_i8(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: abd_ext_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxtb
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %aext = sext i8 %a to i64
  %bext = sext i8 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %trunc = trunc i64 %abs to i8
  ret i8 %trunc
}

define i8 @abd_ext_i8_i16(i8 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_ext_i8_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxth
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %aext = sext i8 %a to i64
  %bext = sext i16 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %trunc = trunc i64 %abs to i8
  ret i8 %trunc
}

define i8 @abd_ext_i8_undef(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: abd_ext_i8_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxtb
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %aext = sext i8 %a to i64
  %bext = sext i8 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 true)
  %trunc = trunc i64 %abs to i8
  ret i8 %trunc
}

define i16 @abd_ext_i16(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_ext_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxth w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxth
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %aext = sext i16 %a to i64
  %bext = sext i16 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %trunc = trunc i64 %abs to i16
  ret i16 %trunc
}

define i16 @abd_ext_i16_i32(i16 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_ext_i16_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxth w8, w0
; CHECK-NEXT:    sub w9, w1, w8
; CHECK-NEXT:    subs w8, w8, w1
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
  %aext = sext i16 %a to i64
  %bext = sext i32 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %trunc = trunc i64 %abs to i16
  ret i16 %trunc
}

define i16 @abd_ext_i16_undef(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_ext_i16_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxth w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxth
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %aext = sext i16 %a to i64
  %bext = sext i16 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 true)
  %trunc = trunc i64 %abs to i16
  ret i16 %trunc
}

define i32 @abd_ext_i32(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_ext_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w1, w0
; CHECK-NEXT:    subs w9, w0, w1
; CHECK-NEXT:    csel w0, w9, w8, gt
; CHECK-NEXT:    ret
  %aext = sext i32 %a to i64
  %bext = sext i32 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %trunc = trunc i64 %abs to i32
  ret i32 %trunc
}

define i32 @abd_ext_i32_i16(i32 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_ext_i32_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxth w8, w1
; CHECK-NEXT:    sub w9, w8, w0
; CHECK-NEXT:    subs w8, w0, w8
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
  %aext = sext i32 %a to i64
  %bext = sext i16 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %trunc = trunc i64 %abs to i32
  ret i32 %trunc
}

define i32 @abd_ext_i32_undef(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_ext_i32_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w1, w0
; CHECK-NEXT:    subs w9, w0, w1
; CHECK-NEXT:    csel w0, w9, w8, gt
; CHECK-NEXT:    ret
  %aext = sext i32 %a to i64
  %bext = sext i32 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 true)
  %trunc = trunc i64 %abs to i32
  ret i32 %trunc
}

define i64 @abd_ext_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: abd_ext_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub x8, x1, x0
; CHECK-NEXT:    subs x9, x0, x1
; CHECK-NEXT:    csel x0, x9, x8, gt
; CHECK-NEXT:    ret
  %aext = sext i64 %a to i128
  %bext = sext i64 %b to i128
  %sub = sub i128 %aext, %bext
  %abs = call i128 @llvm.abs.i128(i128 %sub, i1 false)
  %trunc = trunc i128 %abs to i64
  ret i64 %trunc
}

define i64 @abd_ext_i64_undef(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: abd_ext_i64_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub x8, x1, x0
; CHECK-NEXT:    subs x9, x0, x1
; CHECK-NEXT:    csel x0, x9, x8, gt
; CHECK-NEXT:    ret
  %aext = sext i64 %a to i128
  %bext = sext i64 %b to i128
  %sub = sub i128 %aext, %bext
  %abs = call i128 @llvm.abs.i128(i128 %sub, i1 true)
  %trunc = trunc i128 %abs to i64
  ret i64 %trunc
}

define i128 @abd_ext_i128(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: abd_ext_i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x2
; CHECK-NEXT:    sbc x9, x1, x3
; CHECK-NEXT:    subs x10, x2, x0
; CHECK-NEXT:    sbc x11, x3, x1
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    csel x0, x8, x10, lt
; CHECK-NEXT:    csel x1, x9, x11, lt
; CHECK-NEXT:    ret
  %aext = sext i128 %a to i256
  %bext = sext i128 %b to i256
  %sub = sub i256 %aext, %bext
  %abs = call i256 @llvm.abs.i256(i256 %sub, i1 false)
  %trunc = trunc i256 %abs to i128
  ret i128 %trunc
}

define i128 @abd_ext_i128_undef(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: abd_ext_i128_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x2
; CHECK-NEXT:    sbc x9, x1, x3
; CHECK-NEXT:    subs x10, x2, x0
; CHECK-NEXT:    sbc x11, x3, x1
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    csel x0, x8, x10, lt
; CHECK-NEXT:    csel x1, x9, x11, lt
; CHECK-NEXT:    ret
  %aext = sext i128 %a to i256
  %bext = sext i128 %b to i256
  %sub = sub i256 %aext, %bext
  %abs = call i256 @llvm.abs.i256(i256 %sub, i1 true)
  %trunc = trunc i256 %abs to i128
  ret i128 %trunc
}

;
; sub(smax(a,b),smin(a,b)) -> abds(a,b)
;

define i8 @abd_minmax_i8(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: abd_minmax_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxtb
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %min = call i8 @llvm.smin.i8(i8 %a, i8 %b)
  %max = call i8 @llvm.smax.i8(i8 %a, i8 %b)
  %sub = sub i8 %max, %min
  ret i8 %sub
}

define i16 @abd_minmax_i16(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_minmax_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxth w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxth
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %min = call i16 @llvm.smin.i16(i16 %a, i16 %b)
  %max = call i16 @llvm.smax.i16(i16 %a, i16 %b)
  %sub = sub i16 %max, %min
  ret i16 %sub
}

define i32 @abd_minmax_i32(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_minmax_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w1, w0
; CHECK-NEXT:    subs w9, w0, w1
; CHECK-NEXT:    csel w0, w9, w8, gt
; CHECK-NEXT:    ret
  %min = call i32 @llvm.smin.i32(i32 %a, i32 %b)
  %max = call i32 @llvm.smax.i32(i32 %a, i32 %b)
  %sub = sub i32 %max, %min
  ret i32 %sub
}

define i64 @abd_minmax_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: abd_minmax_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub x8, x1, x0
; CHECK-NEXT:    subs x9, x0, x1
; CHECK-NEXT:    csel x0, x9, x8, gt
; CHECK-NEXT:    ret
  %min = call i64 @llvm.smin.i64(i64 %a, i64 %b)
  %max = call i64 @llvm.smax.i64(i64 %a, i64 %b)
  %sub = sub i64 %max, %min
  ret i64 %sub
}

define i128 @abd_minmax_i128(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: abd_minmax_i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x2
; CHECK-NEXT:    sbc x9, x1, x3
; CHECK-NEXT:    subs x10, x2, x0
; CHECK-NEXT:    sbc x11, x3, x1
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    csel x0, x8, x10, lt
; CHECK-NEXT:    csel x1, x9, x11, lt
; CHECK-NEXT:    ret
  %min = call i128 @llvm.smin.i128(i128 %a, i128 %b)
  %max = call i128 @llvm.smax.i128(i128 %a, i128 %b)
  %sub = sub i128 %max, %min
  ret i128 %sub
}

;
; select(icmp(a,b),sub(a,b),sub(b,a)) -> abds(a,b)
;

define i8 @abd_cmp_i8(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: abd_cmp_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxtb
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %cmp = icmp sgt i8 %a, %b
  %ab = sub i8 %a, %b
  %ba = sub i8 %b, %a
  %sel = select i1 %cmp, i8 %ab, i8 %ba
  ret i8 %sel
}

define i16 @abd_cmp_i16(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_cmp_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxth w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxth
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %cmp = icmp sge i16 %a, %b
  %ab = sub i16 %a, %b
  %ba = sub i16 %b, %a
  %sel = select i1 %cmp, i16 %ab, i16 %ba
  ret i16 %sel
}

define i32 @abd_cmp_i32(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_cmp_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w1, w0
; CHECK-NEXT:    subs w9, w0, w1
; CHECK-NEXT:    csel w0, w9, w8, gt
; CHECK-NEXT:    ret
  %cmp = icmp slt i32 %a, %b
  %ab = sub i32 %a, %b
  %ba = sub i32 %b, %a
  %sel = select i1 %cmp, i32 %ba, i32 %ab
  ret i32 %sel
}

define i64 @abd_cmp_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: abd_cmp_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub x8, x1, x0
; CHECK-NEXT:    subs x9, x0, x1
; CHECK-NEXT:    csel x0, x9, x8, gt
; CHECK-NEXT:    ret
  %cmp = icmp sge i64 %a, %b
  %ab = sub i64 %a, %b
  %ba = sub i64 %b, %a
  %sel = select i1 %cmp, i64 %ab, i64 %ba
  ret i64 %sel
}

define i128 @abd_cmp_i128(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: abd_cmp_i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x2
; CHECK-NEXT:    sbc x9, x1, x3
; CHECK-NEXT:    subs x10, x2, x0
; CHECK-NEXT:    sbc x11, x3, x1
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    csel x0, x8, x10, lt
; CHECK-NEXT:    csel x1, x9, x11, lt
; CHECK-NEXT:    ret
  %cmp = icmp sge i128 %a, %b
  %ab = sub i128 %a, %b
  %ba = sub i128 %b, %a
  %sel = select i1 %cmp, i128 %ab, i128 %ba
  ret i128 %sel
}

;
; abs(sub_nsw(x, y)) -> abds(a,b)
;

define i8 @abd_subnsw_i8(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, w1
; CHECK-NEXT:    sxtb w8, w8
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %sub = sub nsw i8 %a, %b
  %abs = call i8 @llvm.abs.i8(i8 %sub, i1 false)
  ret i8 %abs
}

define i8 @abd_subnsw_i8_undef(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i8_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, w1
; CHECK-NEXT:    sxtb w8, w8
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %sub = sub nsw i8 %a, %b
  %abs = call i8 @llvm.abs.i8(i8 %sub, i1 true)
  ret i8 %abs
}

define i16 @abd_subnsw_i16(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, w1
; CHECK-NEXT:    sxth w8, w8
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %sub = sub nsw i16 %a, %b
  %abs = call i16 @llvm.abs.i16(i16 %sub, i1 false)
  ret i16 %abs
}

define i16 @abd_subnsw_i16_undef(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i16_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, w1
; CHECK-NEXT:    sxth w8, w8
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %sub = sub nsw i16 %a, %b
  %abs = call i16 @llvm.abs.i16(i16 %sub, i1 true)
  ret i16 %abs
}

define i32 @abd_subnsw_i32(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs w8, w0, w1
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %sub = sub nsw i32 %a, %b
  %abs = call i32 @llvm.abs.i32(i32 %sub, i1 false)
  ret i32 %abs
}

define i32 @abd_subnsw_i32_undef(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i32_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs w8, w0, w1
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %sub = sub nsw i32 %a, %b
  %abs = call i32 @llvm.abs.i32(i32 %sub, i1 true)
  ret i32 %abs
}

define i64 @abd_subnsw_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x1
; CHECK-NEXT:    cneg x0, x8, mi
; CHECK-NEXT:    ret
  %sub = sub nsw i64 %a, %b
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  ret i64 %abs
}

define i64 @abd_subnsw_i64_undef(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i64_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x1
; CHECK-NEXT:    cneg x0, x8, mi
; CHECK-NEXT:    ret
  %sub = sub nsw i64 %a, %b
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 true)
  ret i64 %abs
}

define i128 @abd_subnsw_i128(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x2
; CHECK-NEXT:    sbc x9, x1, x3
; CHECK-NEXT:    asr x10, x9, #63
; CHECK-NEXT:    eor x8, x8, x10
; CHECK-NEXT:    eor x9, x9, x10
; CHECK-NEXT:    subs x0, x8, x10
; CHECK-NEXT:    sbc x1, x9, x10
; CHECK-NEXT:    ret
  %sub = sub nsw i128 %a, %b
  %abs = call i128 @llvm.abs.i128(i128 %sub, i1 false)
  ret i128 %abs
}

define i128 @abd_subnsw_i128_undef(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i128_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x2
; CHECK-NEXT:    sbc x9, x1, x3
; CHECK-NEXT:    asr x10, x9, #63
; CHECK-NEXT:    eor x8, x8, x10
; CHECK-NEXT:    eor x9, x9, x10
; CHECK-NEXT:    subs x0, x8, x10
; CHECK-NEXT:    sbc x1, x9, x10
; CHECK-NEXT:    ret
  %sub = sub nsw i128 %a, %b
  %abs = call i128 @llvm.abs.i128(i128 %sub, i1 true)
  ret i128 %abs
}

;
; negative tests
;

define i32 @abd_sub_i32(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_sub_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs w8, w0, w1
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %sub = sub i32 %a, %b
  %abs = call i32 @llvm.abs.i32(i32 %sub, i1 false)
  ret i32 %abs
}

define i64 @vector_legalized(i16 %a, i16 %b) {
; CHECK-LABEL: vector_legalized:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v0.2d, #0000000000000000
; CHECK-NEXT:    sxth w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxth
; CHECK-NEXT:    addp d0, v0.2d
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w8, w8, mi
; CHECK-NEXT:    fmov x9, d0
; CHECK-NEXT:    add x0, x9, x8
; CHECK-NEXT:    ret
  %ea = sext i16 %a to i32
  %eb = sext i16 %b to i32
  %s = sub i32 %ea, %eb
  %ab = call i32 @llvm.abs.i32(i32 %s, i1 false)
  %e = zext i32 %ab to i64
  %red = call i64 @llvm.vector.reduce.add.v32i64(<32 x i64> zeroinitializer)
  %z = add i64 %red, %e
  ret i64 %z
}

;
; sub(select(icmp(a,b),a,b),select(icmp(a,b),b,a)) -> abds(a,b)
;

define i8 @abd_select_i8(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: abd_select_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxtb
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %cmp = icmp slt i8 %a, %b
  %ab = select i1 %cmp, i8 %a, i8 %b
  %ba = select i1 %cmp, i8 %b, i8 %a
  %sub = sub i8 %ba, %ab
  ret i8 %sub
}

define i16 @abd_select_i16(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_select_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxth w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxth
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, mi
; CHECK-NEXT:    ret
  %cmp = icmp sle i16 %a, %b
  %ab = select i1 %cmp, i16 %a, i16 %b
  %ba = select i1 %cmp, i16 %b, i16 %a
  %sub = sub i16 %ba, %ab
  ret i16 %sub
}

define i32 @abd_select_i32(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_select_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w1, w0
; CHECK-NEXT:    subs w9, w0, w1
; CHECK-NEXT:    csel w0, w9, w8, gt
; CHECK-NEXT:    ret
  %cmp = icmp sgt i32 %a, %b
  %ab = select i1 %cmp, i32 %a, i32 %b
  %ba = select i1 %cmp, i32 %b, i32 %a
  %sub = sub i32 %ab, %ba
  ret i32 %sub
}

define i64 @abd_select_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: abd_select_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub x8, x1, x0
; CHECK-NEXT:    subs x9, x0, x1
; CHECK-NEXT:    csel x0, x9, x8, gt
; CHECK-NEXT:    ret
  %cmp = icmp sge i64 %a, %b
  %ab = select i1 %cmp, i64 %a, i64 %b
  %ba = select i1 %cmp, i64 %b, i64 %a
  %sub = sub i64 %ab, %ba
  ret i64 %sub
}

define i128 @abd_select_i128(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: abd_select_i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x2
; CHECK-NEXT:    sbc x9, x1, x3
; CHECK-NEXT:    subs x10, x2, x0
; CHECK-NEXT:    sbc x11, x3, x1
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    csel x0, x8, x10, lt
; CHECK-NEXT:    csel x1, x9, x11, lt
; CHECK-NEXT:    ret
  %cmp = icmp slt i128 %a, %b
  %ab = select i1 %cmp, i128 %a, i128 %b
  %ba = select i1 %cmp, i128 %b, i128 %a
  %sub = sub i128 %ba, %ab
  ret i128 %sub
}

declare i8 @llvm.abs.i8(i8, i1)
declare i16 @llvm.abs.i16(i16, i1)
declare i32 @llvm.abs.i32(i32, i1)
declare i64 @llvm.abs.i64(i64, i1)
declare i128 @llvm.abs.i128(i128, i1)

declare i8 @llvm.smax.i8(i8, i8)
declare i16 @llvm.smax.i16(i16, i16)
declare i32 @llvm.smax.i32(i32, i32)
declare i64 @llvm.smax.i64(i64, i64)

declare i8 @llvm.smin.i8(i8, i8)
declare i16 @llvm.smin.i16(i16, i16)
declare i32 @llvm.smin.i32(i32, i32)
declare i64 @llvm.smin.i64(i64, i64)
