; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=x86_64-linux-gnu < %s | FileCheck %s

; FIXME: Calling convention lowering fails
; define half @roundeven_f16(half %x) {
;   %roundeven = call half @llvm.roundeven.f16(half %x)
;   ret half %roundeven
; }

define float @roundeven_f32(float %x) {
; CHECK-LABEL: roundeven_f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    callq roundevenf
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %roundeven = call float @llvm.roundeven.f32(float %x)
  ret float %roundeven
}

define double @roundeven_f64(double %x) {
; CHECK-LABEL: roundeven_f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    callq roundeven
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %roundeven = call double @llvm.roundeven.f64(double %x)
  ret double %roundeven
}

; FIXME: Insert fails
; define x86_fp80 @roundeven_fp80(x86_fp80 %x) {
;   %roundeven = call x86_fp80 @llvm.roundeven.f80(x86_fp80 %x)
;   ret x86_fp80 %roundeven
; }

define fp128 @roundeven_f128(fp128 %x) {
; CHECK-LABEL: roundeven_f128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    callq roundevenf128
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %roundeven = call fp128 @llvm.roundeven.f128(fp128 %x)
  ret fp128 %roundeven
}

; FIXME: Fails on build_vector
; define <4 x float> @roundeven_v4f32(<4 x float> %x) {
;   %roundeven = call <4 x float> @llvm.roundeven.v4f32(<4 x float> %x)
;   ret <4 x float> %roundeven
; }

declare half @llvm.roundeven.f16(half) #0
declare float @llvm.roundeven.f32(float) #0
declare <4 x float> @llvm.roundeven.v4f32(<4 x float>) #0
declare double @llvm.roundeven.f64(double) #0
declare x86_fp80 @llvm.roundeven.f80(x86_fp80) #0
declare fp128 @llvm.roundeven.f128(fp128) #0

attributes #0 = { nounwind readnone speculatable willreturn }
