; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=aarch64-unknown-unknown < %s | FileCheck --check-prefixes=CHECK %s
; RUN: llc -mtriple=aarch64-apple-darwin < %s | FileCheck --check-prefixes=DARWIN %s
; RUN: llc -mtriple=aarch64-pc-windows < %s | FileCheck --check-prefixes=WIN %s

; This test checks various function call behaviors between preserve_none and
; normal calling conventions.

declare preserve_nonecc void @callee(ptr)

; Normal caller calls preserve_none callee. Will not generated tail call because
; of incompatible calling convention. Callee saved registers are saved/restored
; around the call.
define void @caller1(ptr %a) {
; CHECK-LABEL: caller1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp d15, d14, [sp, #-160]! // 16-byte Folded Spill
; CHECK-NEXT:    stp d13, d12, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    stp d11, d10, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    stp d9, d8, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #64] // 8-byte Folded Spill
; CHECK-NEXT:    stp x28, x27, [sp, #80] // 16-byte Folded Spill
; CHECK-NEXT:    stp x26, x25, [sp, #96] // 16-byte Folded Spill
; CHECK-NEXT:    stp x24, x23, [sp, #112] // 16-byte Folded Spill
; CHECK-NEXT:    stp x22, x21, [sp, #128] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #144] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 160
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w21, -24
; CHECK-NEXT:    .cfi_offset w22, -32
; CHECK-NEXT:    .cfi_offset w23, -40
; CHECK-NEXT:    .cfi_offset w24, -48
; CHECK-NEXT:    .cfi_offset w25, -56
; CHECK-NEXT:    .cfi_offset w26, -64
; CHECK-NEXT:    .cfi_offset w27, -72
; CHECK-NEXT:    .cfi_offset w28, -80
; CHECK-NEXT:    .cfi_offset w30, -96
; CHECK-NEXT:    .cfi_offset b8, -104
; CHECK-NEXT:    .cfi_offset b9, -112
; CHECK-NEXT:    .cfi_offset b10, -120
; CHECK-NEXT:    .cfi_offset b11, -128
; CHECK-NEXT:    .cfi_offset b12, -136
; CHECK-NEXT:    .cfi_offset b13, -144
; CHECK-NEXT:    .cfi_offset b14, -152
; CHECK-NEXT:    .cfi_offset b15, -160
; CHECK-NEXT:    mov x20, x0
; CHECK-NEXT:    bl callee
; CHECK-NEXT:    ldp x20, x19, [sp, #144] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #64] // 8-byte Folded Reload
; CHECK-NEXT:    ldp x22, x21, [sp, #128] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x24, x23, [sp, #112] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x26, x25, [sp, #96] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x28, x27, [sp, #80] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d9, d8, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d11, d10, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d13, d12, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d15, d14, [sp], #160 // 16-byte Folded Reload
; CHECK-NEXT:    ret
;
; DARWIN-LABEL: caller1:
; DARWIN:       ; %bb.0:
; DARWIN-NEXT:    stp d15, d14, [sp, #-160]! ; 16-byte Folded Spill
; DARWIN-NEXT:    stp d13, d12, [sp, #16] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp d11, d10, [sp, #32] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp d9, d8, [sp, #48] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp x28, x27, [sp, #64] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp x26, x25, [sp, #80] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp x24, x23, [sp, #96] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp x22, x21, [sp, #112] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp x20, x19, [sp, #128] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp x29, x30, [sp, #144] ; 16-byte Folded Spill
; DARWIN-NEXT:    .cfi_def_cfa_offset 160
; DARWIN-NEXT:    .cfi_offset w30, -8
; DARWIN-NEXT:    .cfi_offset w29, -16
; DARWIN-NEXT:    .cfi_offset w19, -24
; DARWIN-NEXT:    .cfi_offset w20, -32
; DARWIN-NEXT:    .cfi_offset w21, -40
; DARWIN-NEXT:    .cfi_offset w22, -48
; DARWIN-NEXT:    .cfi_offset w23, -56
; DARWIN-NEXT:    .cfi_offset w24, -64
; DARWIN-NEXT:    .cfi_offset w25, -72
; DARWIN-NEXT:    .cfi_offset w26, -80
; DARWIN-NEXT:    .cfi_offset w27, -88
; DARWIN-NEXT:    .cfi_offset w28, -96
; DARWIN-NEXT:    .cfi_offset b8, -104
; DARWIN-NEXT:    .cfi_offset b9, -112
; DARWIN-NEXT:    .cfi_offset b10, -120
; DARWIN-NEXT:    .cfi_offset b11, -128
; DARWIN-NEXT:    .cfi_offset b12, -136
; DARWIN-NEXT:    .cfi_offset b13, -144
; DARWIN-NEXT:    .cfi_offset b14, -152
; DARWIN-NEXT:    .cfi_offset b15, -160
; DARWIN-NEXT:    mov x20, x0
; DARWIN-NEXT:    bl _callee
; DARWIN-NEXT:    ldp x29, x30, [sp, #144] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp x20, x19, [sp, #128] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp x22, x21, [sp, #112] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp x24, x23, [sp, #96] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp x26, x25, [sp, #80] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp x28, x27, [sp, #64] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp d9, d8, [sp, #48] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp d11, d10, [sp, #32] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp d13, d12, [sp, #16] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp d15, d14, [sp], #160 ; 16-byte Folded Reload
; DARWIN-NEXT:    ret
;
; WIN-LABEL: caller1:
; WIN:       .seh_proc caller1
; WIN-NEXT:  // %bb.0:
; WIN-NEXT:    stp x19, x20, [sp, #-160]! // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_regp_x x19, 160
; WIN-NEXT:    stp x21, x22, [sp, #16] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_regp x21, 16
; WIN-NEXT:    stp x23, x24, [sp, #32] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_regp x23, 32
; WIN-NEXT:    stp x25, x26, [sp, #48] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_regp x25, 48
; WIN-NEXT:    stp x27, x28, [sp, #64] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_regp x27, 64
; WIN-NEXT:    str x30, [sp, #80] // 8-byte Folded Spill
; WIN-NEXT:    .seh_save_reg x30, 80
; WIN-NEXT:    stp d8, d9, [sp, #88] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_fregp d8, 88
; WIN-NEXT:    stp d10, d11, [sp, #104] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_fregp d10, 104
; WIN-NEXT:    stp d12, d13, [sp, #120] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_fregp d12, 120
; WIN-NEXT:    stp d14, d15, [sp, #136] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_fregp d14, 136
; WIN-NEXT:    .seh_endprologue
; WIN-NEXT:    mov x20, x0
; WIN-NEXT:    bl callee
; WIN-NEXT:    .seh_startepilogue
; WIN-NEXT:    ldp d14, d15, [sp, #136] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_fregp d14, 136
; WIN-NEXT:    ldp d12, d13, [sp, #120] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_fregp d12, 120
; WIN-NEXT:    ldp d10, d11, [sp, #104] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_fregp d10, 104
; WIN-NEXT:    ldp d8, d9, [sp, #88] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_fregp d8, 88
; WIN-NEXT:    ldr x30, [sp, #80] // 8-byte Folded Reload
; WIN-NEXT:    .seh_save_reg x30, 80
; WIN-NEXT:    ldp x27, x28, [sp, #64] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_regp x27, 64
; WIN-NEXT:    ldp x25, x26, [sp, #48] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_regp x25, 48
; WIN-NEXT:    ldp x23, x24, [sp, #32] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_regp x23, 32
; WIN-NEXT:    ldp x21, x22, [sp, #16] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_regp x21, 16
; WIN-NEXT:    ldp x19, x20, [sp], #160 // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_regp_x x19, 160
; WIN-NEXT:    .seh_endepilogue
; WIN-NEXT:    ret
; WIN-NEXT:    .seh_endfunclet
; WIN-NEXT:    .seh_endproc
  tail call preserve_nonecc void @callee(ptr %a)
  ret void
}

; Preserve_none caller calls preserve_none callee. Same function body.
; The tail call is preserved. No registers are saved/restored around the call.
; Actually a simple jmp instruction is generated.
define preserve_nonecc void @caller2(ptr %a) {
; CHECK-LABEL: caller2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    b callee
;
; DARWIN-LABEL: caller2:
; DARWIN:       ; %bb.0:
; DARWIN-NEXT:    b _callee
;
; WIN-LABEL: caller2:
; WIN:       // %bb.0:
; WIN-NEXT:    b callee
  tail call preserve_nonecc void @callee(ptr %a)
  ret void
}

; Preserve_none function can use more registers to pass parameters.
declare preserve_nonecc i64 @callee_with_many_param2(i64 %a1, i64 %a2, i64 %a3, i64 %a4, i64 %a5, i64 %a6, i64 %a7, i64 %a8, i64 %a9, i64 %a10, i64 %a11, i64 %a12, i64 %a13, i64 %a14, i64 %a15, i64 %a16, i64 %a17, i64 %a18, i64 %a19, i64 %a20, i64 %a21, i64 %a22, i64 %a23, i64 %a24)
define preserve_nonecc i64 @callee_with_many_param(i64 %a1, i64 %a2, i64 %a3, i64 %a4, i64 %a5, i64 %a6, i64 %a7, i64 %a8, i64 %a9, i64 %a10, i64 %a11, i64 %a12, i64 %a13, i64 %a14, i64 %a15, i64 %a16, i64 %a17, i64 %a18, i64 %a19, i64 %a20, i64 %a21, i64 %a22, i64 %a23, i64 %a24) {
; CHECK-LABEL: callee_with_many_param:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    mov x8, x15
; CHECK-NEXT:    mov x15, x20
; CHECK-NEXT:    mov x20, x21
; CHECK-NEXT:    mov x21, x22
; CHECK-NEXT:    mov x22, x23
; CHECK-NEXT:    mov x23, x24
; CHECK-NEXT:    mov x24, x25
; CHECK-NEXT:    mov x25, x26
; CHECK-NEXT:    mov x26, x27
; CHECK-NEXT:    mov x27, x28
; CHECK-NEXT:    mov x28, x0
; CHECK-NEXT:    mov x0, x1
; CHECK-NEXT:    mov x1, x2
; CHECK-NEXT:    mov x2, x3
; CHECK-NEXT:    mov x3, x4
; CHECK-NEXT:    mov x4, x5
; CHECK-NEXT:    mov x5, x6
; CHECK-NEXT:    mov x6, x7
; CHECK-NEXT:    mov x7, x10
; CHECK-NEXT:    mov x10, x11
; CHECK-NEXT:    mov x11, x12
; CHECK-NEXT:    mov x12, x13
; CHECK-NEXT:    mov x13, x14
; CHECK-NEXT:    mov x14, x9
; CHECK-NEXT:    mov x9, x8
; CHECK-NEXT:    bl callee_with_many_param2
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; DARWIN-LABEL: callee_with_many_param:
; DARWIN:       ; %bb.0:
; DARWIN-NEXT:    stp x29, x30, [sp, #-16]! ; 16-byte Folded Spill
; DARWIN-NEXT:    .cfi_def_cfa_offset 16
; DARWIN-NEXT:    .cfi_offset w30, -8
; DARWIN-NEXT:    .cfi_offset w29, -16
; DARWIN-NEXT:    mov x8, x15
; DARWIN-NEXT:    mov x15, x20
; DARWIN-NEXT:    mov x20, x21
; DARWIN-NEXT:    mov x21, x22
; DARWIN-NEXT:    mov x22, x23
; DARWIN-NEXT:    mov x23, x24
; DARWIN-NEXT:    mov x24, x25
; DARWIN-NEXT:    mov x25, x26
; DARWIN-NEXT:    mov x26, x27
; DARWIN-NEXT:    mov x27, x28
; DARWIN-NEXT:    mov x28, x0
; DARWIN-NEXT:    mov x0, x1
; DARWIN-NEXT:    mov x1, x2
; DARWIN-NEXT:    mov x2, x3
; DARWIN-NEXT:    mov x3, x4
; DARWIN-NEXT:    mov x4, x5
; DARWIN-NEXT:    mov x5, x6
; DARWIN-NEXT:    mov x6, x7
; DARWIN-NEXT:    mov x7, x10
; DARWIN-NEXT:    mov x10, x11
; DARWIN-NEXT:    mov x11, x12
; DARWIN-NEXT:    mov x12, x13
; DARWIN-NEXT:    mov x13, x14
; DARWIN-NEXT:    mov x14, x9
; DARWIN-NEXT:    mov x9, x8
; DARWIN-NEXT:    bl _callee_with_many_param2
; DARWIN-NEXT:    ldp x29, x30, [sp], #16 ; 16-byte Folded Reload
; DARWIN-NEXT:    ret
;
; WIN-LABEL: callee_with_many_param:
; WIN:       .seh_proc callee_with_many_param
; WIN-NEXT:  // %bb.0:
; WIN-NEXT:    sub sp, sp, #32
; WIN-NEXT:    .seh_stackalloc 32
; WIN-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; WIN-NEXT:    .seh_save_reg x30, 16
; WIN-NEXT:    .seh_endprologue
; WIN-NEXT:    ldr x8, [sp, #32]
; WIN-NEXT:    mov x15, x20
; WIN-NEXT:    mov x20, x21
; WIN-NEXT:    mov x21, x22
; WIN-NEXT:    mov x22, x23
; WIN-NEXT:    mov x23, x24
; WIN-NEXT:    mov x24, x25
; WIN-NEXT:    mov x25, x26
; WIN-NEXT:    mov x26, x27
; WIN-NEXT:    mov x27, x28
; WIN-NEXT:    mov x28, x0
; WIN-NEXT:    mov x0, x1
; WIN-NEXT:    mov x1, x2
; WIN-NEXT:    mov x2, x3
; WIN-NEXT:    mov x3, x4
; WIN-NEXT:    mov x4, x5
; WIN-NEXT:    mov x5, x6
; WIN-NEXT:    mov x6, x7
; WIN-NEXT:    mov x7, x10
; WIN-NEXT:    mov x10, x11
; WIN-NEXT:    mov x11, x12
; WIN-NEXT:    mov x12, x13
; WIN-NEXT:    mov x13, x14
; WIN-NEXT:    mov x14, x9
; WIN-NEXT:    mov x9, x8
; WIN-NEXT:    str x15, [sp]
; WIN-NEXT:    bl callee_with_many_param2
; WIN-NEXT:    .seh_startepilogue
; WIN-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; WIN-NEXT:    .seh_save_reg x30, 16
; WIN-NEXT:    add sp, sp, #32
; WIN-NEXT:    .seh_stackalloc 32
; WIN-NEXT:    .seh_endepilogue
; WIN-NEXT:    ret
; WIN-NEXT:    .seh_endfunclet
; WIN-NEXT:    .seh_endproc
  %ret = call preserve_nonecc i64 @callee_with_many_param2(i64 %a2, i64 %a3, i64 %a4, i64 %a5, i64 %a6, i64 %a7, i64 %a8, i64 %a9, i64 %a10, i64 %a11, i64 %a12, i64 %a13, i64 %a14, i64 %a15, i64 %a16, i64 %a17, i64 %a18, i64 %a19, i64 %a20, i64 %a21, i64 %a22, i64 %a23, i64 %a24, i64 %a1)
  ret i64 %ret
}

define i64 @caller3() {
; CHECK-LABEL: caller3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp d15, d14, [sp, #-160]! // 16-byte Folded Spill
; CHECK-NEXT:    stp d13, d12, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    stp d11, d10, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    stp d9, d8, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #64] // 8-byte Folded Spill
; CHECK-NEXT:    stp x28, x27, [sp, #80] // 16-byte Folded Spill
; CHECK-NEXT:    stp x26, x25, [sp, #96] // 16-byte Folded Spill
; CHECK-NEXT:    stp x24, x23, [sp, #112] // 16-byte Folded Spill
; CHECK-NEXT:    stp x22, x21, [sp, #128] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #144] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 160
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w21, -24
; CHECK-NEXT:    .cfi_offset w22, -32
; CHECK-NEXT:    .cfi_offset w23, -40
; CHECK-NEXT:    .cfi_offset w24, -48
; CHECK-NEXT:    .cfi_offset w25, -56
; CHECK-NEXT:    .cfi_offset w26, -64
; CHECK-NEXT:    .cfi_offset w27, -72
; CHECK-NEXT:    .cfi_offset w28, -80
; CHECK-NEXT:    .cfi_offset w30, -96
; CHECK-NEXT:    .cfi_offset b8, -104
; CHECK-NEXT:    .cfi_offset b9, -112
; CHECK-NEXT:    .cfi_offset b10, -120
; CHECK-NEXT:    .cfi_offset b11, -128
; CHECK-NEXT:    .cfi_offset b12, -136
; CHECK-NEXT:    .cfi_offset b13, -144
; CHECK-NEXT:    .cfi_offset b14, -152
; CHECK-NEXT:    .cfi_offset b15, -160
; CHECK-NEXT:    mov w20, #1 // =0x1
; CHECK-NEXT:    mov w21, #2 // =0x2
; CHECK-NEXT:    mov w22, #3 // =0x3
; CHECK-NEXT:    mov w23, #4 // =0x4
; CHECK-NEXT:    mov w24, #5 // =0x5
; CHECK-NEXT:    mov w25, #6 // =0x6
; CHECK-NEXT:    mov w26, #7 // =0x7
; CHECK-NEXT:    mov w27, #8 // =0x8
; CHECK-NEXT:    mov w28, #9 // =0x9
; CHECK-NEXT:    mov w0, #10 // =0xa
; CHECK-NEXT:    mov w1, #11 // =0xb
; CHECK-NEXT:    mov w2, #12 // =0xc
; CHECK-NEXT:    mov w3, #13 // =0xd
; CHECK-NEXT:    mov w4, #14 // =0xe
; CHECK-NEXT:    mov w5, #15 // =0xf
; CHECK-NEXT:    mov w6, #16 // =0x10
; CHECK-NEXT:    mov w7, #17 // =0x11
; CHECK-NEXT:    mov w10, #18 // =0x12
; CHECK-NEXT:    mov w11, #19 // =0x13
; CHECK-NEXT:    mov w12, #20 // =0x14
; CHECK-NEXT:    mov w13, #21 // =0x15
; CHECK-NEXT:    mov w14, #22 // =0x16
; CHECK-NEXT:    mov w9, #23 // =0x17
; CHECK-NEXT:    mov w15, #24 // =0x18
; CHECK-NEXT:    bl callee_with_many_param
; CHECK-NEXT:    ldp x20, x19, [sp, #144] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #64] // 8-byte Folded Reload
; CHECK-NEXT:    ldp x22, x21, [sp, #128] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x24, x23, [sp, #112] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x26, x25, [sp, #96] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x28, x27, [sp, #80] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d9, d8, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d11, d10, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d13, d12, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d15, d14, [sp], #160 // 16-byte Folded Reload
; CHECK-NEXT:    ret
;
; DARWIN-LABEL: caller3:
; DARWIN:       ; %bb.0:
; DARWIN-NEXT:    stp d15, d14, [sp, #-160]! ; 16-byte Folded Spill
; DARWIN-NEXT:    stp d13, d12, [sp, #16] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp d11, d10, [sp, #32] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp d9, d8, [sp, #48] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp x28, x27, [sp, #64] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp x26, x25, [sp, #80] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp x24, x23, [sp, #96] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp x22, x21, [sp, #112] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp x20, x19, [sp, #128] ; 16-byte Folded Spill
; DARWIN-NEXT:    stp x29, x30, [sp, #144] ; 16-byte Folded Spill
; DARWIN-NEXT:    .cfi_def_cfa_offset 160
; DARWIN-NEXT:    .cfi_offset w30, -8
; DARWIN-NEXT:    .cfi_offset w29, -16
; DARWIN-NEXT:    .cfi_offset w19, -24
; DARWIN-NEXT:    .cfi_offset w20, -32
; DARWIN-NEXT:    .cfi_offset w21, -40
; DARWIN-NEXT:    .cfi_offset w22, -48
; DARWIN-NEXT:    .cfi_offset w23, -56
; DARWIN-NEXT:    .cfi_offset w24, -64
; DARWIN-NEXT:    .cfi_offset w25, -72
; DARWIN-NEXT:    .cfi_offset w26, -80
; DARWIN-NEXT:    .cfi_offset w27, -88
; DARWIN-NEXT:    .cfi_offset w28, -96
; DARWIN-NEXT:    .cfi_offset b8, -104
; DARWIN-NEXT:    .cfi_offset b9, -112
; DARWIN-NEXT:    .cfi_offset b10, -120
; DARWIN-NEXT:    .cfi_offset b11, -128
; DARWIN-NEXT:    .cfi_offset b12, -136
; DARWIN-NEXT:    .cfi_offset b13, -144
; DARWIN-NEXT:    .cfi_offset b14, -152
; DARWIN-NEXT:    .cfi_offset b15, -160
; DARWIN-NEXT:    mov w20, #1 ; =0x1
; DARWIN-NEXT:    mov w21, #2 ; =0x2
; DARWIN-NEXT:    mov w22, #3 ; =0x3
; DARWIN-NEXT:    mov w23, #4 ; =0x4
; DARWIN-NEXT:    mov w24, #5 ; =0x5
; DARWIN-NEXT:    mov w25, #6 ; =0x6
; DARWIN-NEXT:    mov w26, #7 ; =0x7
; DARWIN-NEXT:    mov w27, #8 ; =0x8
; DARWIN-NEXT:    mov w28, #9 ; =0x9
; DARWIN-NEXT:    mov w0, #10 ; =0xa
; DARWIN-NEXT:    mov w1, #11 ; =0xb
; DARWIN-NEXT:    mov w2, #12 ; =0xc
; DARWIN-NEXT:    mov w3, #13 ; =0xd
; DARWIN-NEXT:    mov w4, #14 ; =0xe
; DARWIN-NEXT:    mov w5, #15 ; =0xf
; DARWIN-NEXT:    mov w6, #16 ; =0x10
; DARWIN-NEXT:    mov w7, #17 ; =0x11
; DARWIN-NEXT:    mov w10, #18 ; =0x12
; DARWIN-NEXT:    mov w11, #19 ; =0x13
; DARWIN-NEXT:    mov w12, #20 ; =0x14
; DARWIN-NEXT:    mov w13, #21 ; =0x15
; DARWIN-NEXT:    mov w14, #22 ; =0x16
; DARWIN-NEXT:    mov w9, #23 ; =0x17
; DARWIN-NEXT:    mov w15, #24 ; =0x18
; DARWIN-NEXT:    bl _callee_with_many_param
; DARWIN-NEXT:    ldp x29, x30, [sp, #144] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp x20, x19, [sp, #128] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp x22, x21, [sp, #112] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp x24, x23, [sp, #96] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp x26, x25, [sp, #80] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp x28, x27, [sp, #64] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp d9, d8, [sp, #48] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp d11, d10, [sp, #32] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp d13, d12, [sp, #16] ; 16-byte Folded Reload
; DARWIN-NEXT:    ldp d15, d14, [sp], #160 ; 16-byte Folded Reload
; DARWIN-NEXT:    ret
;
; WIN-LABEL: caller3:
; WIN:       .seh_proc caller3
; WIN-NEXT:  // %bb.0:
; WIN-NEXT:    sub sp, sp, #176
; WIN-NEXT:    .seh_stackalloc 176
; WIN-NEXT:    stp x19, x20, [sp, #16] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_regp x19, 16
; WIN-NEXT:    stp x21, x22, [sp, #32] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_regp x21, 32
; WIN-NEXT:    stp x23, x24, [sp, #48] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_regp x23, 48
; WIN-NEXT:    stp x25, x26, [sp, #64] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_regp x25, 64
; WIN-NEXT:    stp x27, x28, [sp, #80] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_regp x27, 80
; WIN-NEXT:    str x30, [sp, #96] // 8-byte Folded Spill
; WIN-NEXT:    .seh_save_reg x30, 96
; WIN-NEXT:    stp d8, d9, [sp, #104] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_fregp d8, 104
; WIN-NEXT:    stp d10, d11, [sp, #120] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_fregp d10, 120
; WIN-NEXT:    stp d12, d13, [sp, #136] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_fregp d12, 136
; WIN-NEXT:    stp d14, d15, [sp, #152] // 16-byte Folded Spill
; WIN-NEXT:    .seh_save_fregp d14, 152
; WIN-NEXT:    .seh_endprologue
; WIN-NEXT:    mov w8, #24 // =0x18
; WIN-NEXT:    mov w20, #1 // =0x1
; WIN-NEXT:    mov w21, #2 // =0x2
; WIN-NEXT:    mov w22, #3 // =0x3
; WIN-NEXT:    mov w23, #4 // =0x4
; WIN-NEXT:    mov w24, #5 // =0x5
; WIN-NEXT:    mov w25, #6 // =0x6
; WIN-NEXT:    mov w26, #7 // =0x7
; WIN-NEXT:    mov w27, #8 // =0x8
; WIN-NEXT:    mov w28, #9 // =0x9
; WIN-NEXT:    mov w0, #10 // =0xa
; WIN-NEXT:    mov w1, #11 // =0xb
; WIN-NEXT:    mov w2, #12 // =0xc
; WIN-NEXT:    mov w3, #13 // =0xd
; WIN-NEXT:    mov w4, #14 // =0xe
; WIN-NEXT:    mov w5, #15 // =0xf
; WIN-NEXT:    mov w6, #16 // =0x10
; WIN-NEXT:    mov w7, #17 // =0x11
; WIN-NEXT:    mov w10, #18 // =0x12
; WIN-NEXT:    mov w11, #19 // =0x13
; WIN-NEXT:    mov w12, #20 // =0x14
; WIN-NEXT:    mov w13, #21 // =0x15
; WIN-NEXT:    mov w14, #22 // =0x16
; WIN-NEXT:    mov w9, #23 // =0x17
; WIN-NEXT:    str x8, [sp]
; WIN-NEXT:    bl callee_with_many_param
; WIN-NEXT:    .seh_startepilogue
; WIN-NEXT:    ldp d14, d15, [sp, #152] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_fregp d14, 152
; WIN-NEXT:    ldp d12, d13, [sp, #136] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_fregp d12, 136
; WIN-NEXT:    ldp d10, d11, [sp, #120] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_fregp d10, 120
; WIN-NEXT:    ldp d8, d9, [sp, #104] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_fregp d8, 104
; WIN-NEXT:    ldr x30, [sp, #96] // 8-byte Folded Reload
; WIN-NEXT:    .seh_save_reg x30, 96
; WIN-NEXT:    ldp x27, x28, [sp, #80] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_regp x27, 80
; WIN-NEXT:    ldp x25, x26, [sp, #64] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_regp x25, 64
; WIN-NEXT:    ldp x23, x24, [sp, #48] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_regp x23, 48
; WIN-NEXT:    ldp x21, x22, [sp, #32] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_regp x21, 32
; WIN-NEXT:    ldp x19, x20, [sp, #16] // 16-byte Folded Reload
; WIN-NEXT:    .seh_save_regp x19, 16
; WIN-NEXT:    add sp, sp, #176
; WIN-NEXT:    .seh_stackalloc 176
; WIN-NEXT:    .seh_endepilogue
; WIN-NEXT:    ret
; WIN-NEXT:    .seh_endfunclet
; WIN-NEXT:    .seh_endproc
  %ret = call preserve_nonecc i64 @callee_with_many_param(i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7, i64 8, i64 9, i64 10, i64 11, i64 12, i64 13, i64 14, i64 15, i64 16, i64 17, i64 18, i64 19, i64 20, i64 21, i64 22, i64 23, i64 24)
  ret i64 %ret
}
