; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs -mcpu=syntacore-scr1-max \
; RUN: -O1 -riscv-enable-machine-combiner=true -riscv-force-machine-combiner-strategy=local < %s | \
; RUN: FileCheck %s --check-prefixes=CHECK_LOCAL_SCR1

; RUN: llc -mtriple=riscv32 -verify-machineinstrs -mcpu=syntacore-scr1-max \
; RUN: -O1 -riscv-enable-machine-combiner=true -riscv-force-machine-combiner-strategy=min-instr < %s | \
; RUN: FileCheck %s --check-prefixes=CHECK_GLOBAL_SCR1

; RUN: llc -mtriple=riscv64 -verify-machineinstrs -mcpu=sifive-u74 \
; RUN: -O1 -riscv-enable-machine-combiner=true -riscv-force-machine-combiner-strategy=local < %s | \
; RUN: FileCheck %s --check-prefixes=CHECK_LOCAL_SIFIVE_U74

; RUN: llc -mtriple=riscv64 -verify-machineinstrs -mcpu=sifive-u74 \
; RUN: -O1 -riscv-enable-machine-combiner=true -riscv-force-machine-combiner-strategy=min-instr < %s | \
; RUN: FileCheck %s --check-prefixes=CHECK_GLOBAL_SIFIVE_U74

define i32 @test_local_strategy(i32 %a0, i32 %a1, i32 %a2, i32 %a3, i32 %a4, i32 %a5) {
; CHECK_LOCAL_SCR1-LABEL: test_local_strategy:
; CHECK_LOCAL_SCR1:       # %bb.0: # %entry
; CHECK_LOCAL_SCR1-NEXT:    div a0, a0, a1
; CHECK_LOCAL_SCR1-NEXT:    sub a0, a0, a2
; CHECK_LOCAL_SCR1-NEXT:    beqz a0, .LBB0_2
; CHECK_LOCAL_SCR1-NEXT:  # %bb.1: # %b2
; CHECK_LOCAL_SCR1-NEXT:    ret
; CHECK_LOCAL_SCR1-NEXT:  .LBB0_2: # %b1
; CHECK_LOCAL_SCR1-NEXT:    add a3, a3, a4
; CHECK_LOCAL_SCR1-NEXT:    add a0, a0, a5
; CHECK_LOCAL_SCR1-NEXT:    add a0, a0, a3
; CHECK_LOCAL_SCR1-NEXT:    ret
;
; CHECK_GLOBAL_SCR1-LABEL: test_local_strategy:
; CHECK_GLOBAL_SCR1:       # %bb.0: # %entry
; CHECK_GLOBAL_SCR1-NEXT:    div a0, a0, a1
; CHECK_GLOBAL_SCR1-NEXT:    sub a0, a0, a2
; CHECK_GLOBAL_SCR1-NEXT:    beqz a0, .LBB0_2
; CHECK_GLOBAL_SCR1-NEXT:  # %bb.1: # %b2
; CHECK_GLOBAL_SCR1-NEXT:    ret
; CHECK_GLOBAL_SCR1-NEXT:  .LBB0_2: # %b1
; CHECK_GLOBAL_SCR1-NEXT:    add a3, a3, a4
; CHECK_GLOBAL_SCR1-NEXT:    add a3, a3, a5
; CHECK_GLOBAL_SCR1-NEXT:    add a0, a0, a3
; CHECK_GLOBAL_SCR1-NEXT:    ret
;
; CHECK_LOCAL_SIFIVE_U74-LABEL: test_local_strategy:
; CHECK_LOCAL_SIFIVE_U74:       # %bb.0: # %entry
; CHECK_LOCAL_SIFIVE_U74-NEXT:    divw a0, a0, a1
; CHECK_LOCAL_SIFIVE_U74-NEXT:    subw a0, a0, a2
; CHECK_LOCAL_SIFIVE_U74-NEXT:    beqz a0, .LBB0_2
; CHECK_LOCAL_SIFIVE_U74-NEXT:  # %bb.1: # %b2
; CHECK_LOCAL_SIFIVE_U74-NEXT:    ret
; CHECK_LOCAL_SIFIVE_U74-NEXT:  .LBB0_2: # %b1
; CHECK_LOCAL_SIFIVE_U74-NEXT:    add a3, a3, a4
; CHECK_LOCAL_SIFIVE_U74-NEXT:    add a0, a0, a5
; CHECK_LOCAL_SIFIVE_U74-NEXT:    addw a0, a0, a3
; CHECK_LOCAL_SIFIVE_U74-NEXT:    ret
;
; CHECK_GLOBAL_SIFIVE_U74-LABEL: test_local_strategy:
; CHECK_GLOBAL_SIFIVE_U74:       # %bb.0: # %entry
; CHECK_GLOBAL_SIFIVE_U74-NEXT:    divw a0, a0, a1
; CHECK_GLOBAL_SIFIVE_U74-NEXT:    subw a0, a0, a2
; CHECK_GLOBAL_SIFIVE_U74-NEXT:    beqz a0, .LBB0_2
; CHECK_GLOBAL_SIFIVE_U74-NEXT:  # %bb.1: # %b2
; CHECK_GLOBAL_SIFIVE_U74-NEXT:    ret
; CHECK_GLOBAL_SIFIVE_U74-NEXT:  .LBB0_2: # %b1
; CHECK_GLOBAL_SIFIVE_U74-NEXT:    add a3, a3, a4
; CHECK_GLOBAL_SIFIVE_U74-NEXT:    add a3, a3, a5
; CHECK_GLOBAL_SIFIVE_U74-NEXT:    addw a0, a0, a3
; CHECK_GLOBAL_SIFIVE_U74-NEXT:    ret
entry:
  %div = sdiv i32 %a0, %a1
  %sub0 = sub i32 %div, %a2
  %cmp = icmp eq i32 %sub0, 0
  br i1 %cmp, label %b1, label %b2
b1:
  %sub1 = add i32 %a3, %a4
  %sub2 = add i32 %a5, %sub1
  %sub3 = add i32 %sub2, %sub0
  ret i32 %sub3
b2:
  ret i32 %sub0
}
