; Verify that a struct as generated by the frontend is correctly accessed in
; both cases of enabling/disabling the vector facility.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-NOVECTOR %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=generic | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-NOVECTOR %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z10 | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-NOVECTOR %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z196 | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-NOVECTOR %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=zEC12 | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-NOVECTOR %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-VECTOR %s

; RUN: llc < %s -mtriple=s390x-linux-gnu -mattr=vector | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-VECTOR %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mattr=+vector | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-VECTOR %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mattr=-vector,vector | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-VECTOR %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mattr=-vector,+vector | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-VECTOR %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mattr=-vector | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-NOVECTOR %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mattr=vector,-vector | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-NOVECTOR %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mattr=+vector,-vector | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-NOVECTOR %s

; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 -mattr=-vector | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-NOVECTOR %s

; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 -mattr=+soft-float | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-NOVECTOR %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 \
; RUN:   -mattr=soft-float,-soft-float | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-VECTOR %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 \
; RUN:   -mattr=-soft-float,soft-float | \
; RUN:   FileCheck -check-prefixes=CHECK,CHECK-NOVECTOR %s

%struct.S_vx = type { i8, <2 x i64> }
%struct.S_novx = type { i8, [15 x i8], <2 x i64> }

define void @fun_vx(ptr %s) nounwind {
; CHECK-LABEL: @fun_vx
;
; CHECK-VECTOR: vl %v0, 8(%r2)
; CHECK-VECTOR: vst %v0, 8(%r2), 3
;
; CHECK-NOVECTOR-DAG: agsi 16(%r2), 1
; CHECK-NOVECTOR-DAG: agsi 8(%r2), 1
  %ptr = getelementptr %struct.S_vx, ptr %s, i64 0, i32 1
  %vec = load <2 x i64>, ptr %ptr
  %add = add <2 x i64> %vec, <i64 1, i64 1>
  store <2 x i64> %add, ptr %ptr
  ret void
}

define void @fun_novx(ptr %s) nounwind {
; CHECK-LABEL: @fun_novx
;
; CHECK-VECTOR: vl  %v0, 16(%r2), 3
; CHECK-VECTOR: vst %v0, 16(%r2), 3
;
; CHECK-NOVECTOR-DAG: agsi 16(%r2), 1
; CHECK-NOVECTOR-DAG: agsi 24(%r2), 1
  %ptr = getelementptr %struct.S_novx, ptr %s, i64 0, i32 2
  %vec = load <2 x i64>, ptr %ptr
  %add = add <2 x i64> %vec, <i64 1, i64 1>
  store <2 x i64> %add, ptr %ptr
  ret void
}

