; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=msan -S | FileCheck %s
;
; Forked from llvm/test/CodeGen/X86/ucmp.ll

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define i8 @ucmp.8.8(i8 %x, i8 %y) nounwind #0 {
; CHECK-LABEL: define i8 @ucmp.8.8(
; CHECK-SAME: i8 [[X:%.*]], i8 [[Y:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i8 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or i8 [[_MSPROP]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = call i8 @llvm.ucmp.i8.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    store i8 [[_MSPROP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i8 [[TMP3]]
;
  %1 = call i8 @llvm.ucmp(i8 %x, i8 %y)
  ret i8 %1
}

define i8 @ucmp.8.16(i16 %x, i16 %y) nounwind #0 {
; CHECK-LABEL: define i8 @ucmp.8.16(
; CHECK-SAME: i16 [[X:%.*]], i16 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i16 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or i16 [[_MSPROP]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i16 [[_MSPROP1]] to i8
; CHECK-NEXT:    [[TMP5:%.*]] = call i8 @llvm.ucmp.i8.i16(i16 [[X]], i16 [[Y]])
; CHECK-NEXT:    store i8 [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i8 [[TMP5]]
;
  %1 = call i8 @llvm.ucmp(i16 %x, i16 %y)
  ret i8 %1
}

define i8 @ucmp.8.32(i32 %x, i32 %y) nounwind #0 {
; CHECK-LABEL: define i8 @ucmp.8.32(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i32 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or i32 [[_MSPROP]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i32 [[_MSPROP1]] to i8
; CHECK-NEXT:    [[TMP5:%.*]] = call i8 @llvm.ucmp.i8.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    store i8 [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i8 [[TMP5]]
;
  %1 = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %1
}

define i8 @ucmp.8.64(i64 %x, i64 %y) nounwind #0 {
; CHECK-LABEL: define i8 @ucmp.8.64(
; CHECK-SAME: i64 [[X:%.*]], i64 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or i64 [[_MSPROP]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i64 [[_MSPROP1]] to i8
; CHECK-NEXT:    [[TMP5:%.*]] = call i8 @llvm.ucmp.i8.i64(i64 [[X]], i64 [[Y]])
; CHECK-NEXT:    store i8 [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i8 [[TMP5]]
;
  %1 = call i8 @llvm.ucmp(i64 %x, i64 %y)
  ret i8 %1
}

define i8 @ucmp.8.128(i128 %x, i128 %y) nounwind #0 {
; CHECK-LABEL: define i8 @ucmp.8.128(
; CHECK-SAME: i128 [[X:%.*]], i128 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i128, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i128, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i128 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or i128 [[_MSPROP]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i128 [[_MSPROP1]] to i8
; CHECK-NEXT:    [[TMP5:%.*]] = call i8 @llvm.ucmp.i8.i128(i128 [[X]], i128 [[Y]])
; CHECK-NEXT:    store i8 [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i8 [[TMP5]]
;
  %1 = call i8 @llvm.ucmp(i128 %x, i128 %y)
  ret i8 %1
}

define i32 @ucmp.32.32(i32 %x, i32 %y) nounwind #0 {
; CHECK-LABEL: define i32 @ucmp.32.32(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i32 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or i32 [[_MSPROP]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.ucmp.i32.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    store i32 [[_MSPROP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %1 = call i32 @llvm.ucmp(i32 %x, i32 %y)
  ret i32 %1
}

define i32 @ucmp.32.64(i64 %x, i64 %y) nounwind #0 {
; CHECK-LABEL: define i32 @ucmp.32.64(
; CHECK-SAME: i64 [[X:%.*]], i64 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or i64 [[_MSPROP]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i64 [[_MSPROP1]] to i32
; CHECK-NEXT:    [[TMP5:%.*]] = call i32 @llvm.ucmp.i32.i64(i64 [[X]], i64 [[Y]])
; CHECK-NEXT:    store i32 [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP5]]
;
  %1 = call i32 @llvm.ucmp(i64 %x, i64 %y)
  ret i32 %1
}

define i64 @ucmp.64.64(i64 %x, i64 %y) nounwind #0 {
; CHECK-LABEL: define i64 @ucmp.64.64(
; CHECK-SAME: i64 [[X:%.*]], i64 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or i64 [[_MSPROP]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.ucmp.i64.i64(i64 [[X]], i64 [[Y]])
; CHECK-NEXT:    store i64 [[_MSPROP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %1 = call i64 @llvm.ucmp(i64 %x, i64 %y)
  ret i64 %1
}

define i4 @ucmp_narrow_result(i32 %x, i32 %y) nounwind #0 {
; CHECK-LABEL: define i4 @ucmp_narrow_result(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i32 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or i32 [[_MSPROP]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i32 [[_MSPROP1]] to i4
; CHECK-NEXT:    [[TMP5:%.*]] = call i4 @llvm.ucmp.i4.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    store i4 [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i4 [[TMP5]]
;
  %1 = call i4 @llvm.ucmp(i32 %x, i32 %y)
  ret i4 %1
}

define i8 @ucmp_narrow_op(i62 %x, i62 %y) nounwind #0 {
; CHECK-LABEL: define i8 @ucmp_narrow_op(
; CHECK-SAME: i62 [[X:%.*]], i62 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i62, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i62, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i62 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or i62 [[_MSPROP]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i62 [[_MSPROP1]] to i8
; CHECK-NEXT:    [[TMP5:%.*]] = call i8 @llvm.ucmp.i8.i62(i62 [[X]], i62 [[Y]])
; CHECK-NEXT:    store i8 [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i8 [[TMP5]]
;
  %1 = call i8 @llvm.ucmp(i62 %x, i62 %y)
  ret i8 %1
}

define i141 @ucmp_wide_result(i32 %x, i32 %y) nounwind #0 {
; CHECK-LABEL: define i141 @ucmp_wide_result(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i32 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or i32 [[_MSPROP]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = zext i32 [[_MSPROP1]] to i141
; CHECK-NEXT:    [[TMP5:%.*]] = call i141 @llvm.ucmp.i141.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    store i141 [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i141 [[TMP5]]
;
  %1 = call i141 @llvm.ucmp(i32 %x, i32 %y)
  ret i141 %1
}

define i8 @ucmp_wide_op(i109 %x, i109 %y) nounwind #0 {
; CHECK-LABEL: define i8 @ucmp_wide_op(
; CHECK-SAME: i109 [[X:%.*]], i109 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i109, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i109, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i109 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or i109 [[_MSPROP]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i109 [[_MSPROP1]] to i8
; CHECK-NEXT:    [[TMP5:%.*]] = call i8 @llvm.ucmp.i8.i109(i109 [[X]], i109 [[Y]])
; CHECK-NEXT:    store i8 [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i8 [[TMP5]]
;
  %1 = call i8 @llvm.ucmp(i109 %x, i109 %y)
  ret i8 %1
}

define i41 @ucmp_uncommon_types(i7 %x, i7 %y) nounwind #0 {
; CHECK-LABEL: define i41 @ucmp_uncommon_types(
; CHECK-SAME: i7 [[X:%.*]], i7 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i7, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i7, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i7 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or i7 [[_MSPROP]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = zext i7 [[_MSPROP1]] to i41
; CHECK-NEXT:    [[TMP5:%.*]] = call i41 @llvm.ucmp.i41.i7(i7 [[X]], i7 [[Y]])
; CHECK-NEXT:    store i41 [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i41 [[TMP5]]
;
  %1 = call i41 @llvm.ucmp(i7 %x, i7 %y)
  ret i41 %1
}

define <4 x i32> @ucmp_normal_vectors(<4 x i32> %x, <4 x i32> %y) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @ucmp_normal_vectors(
; CHECK-SAME: <4 x i32> [[X:%.*]], <4 x i32> [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <4 x i32> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <4 x i32> [[_MSPROP]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> [[X]], <4 x i32> [[Y]])
; CHECK-NEXT:    store <4 x i32> [[_MSPROP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMP3]]
;
  %1 = call <4 x i32> @llvm.ucmp(<4 x i32> %x, <4 x i32> %y)
  ret <4 x i32> %1
}

define <4 x i8> @ucmp_narrow_vec_result(<4 x i32> %x, <4 x i32> %y) nounwind #0 {
; CHECK-LABEL: define <4 x i8> @ucmp_narrow_vec_result(
; CHECK-SAME: <4 x i32> [[X:%.*]], <4 x i32> [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <4 x i32> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <4 x i32> [[_MSPROP]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = trunc <4 x i32> [[_MSPROP1]] to <4 x i8>
; CHECK-NEXT:    [[TMP7:%.*]] = call <4 x i8> @llvm.ucmp.v4i8.v4i32(<4 x i32> [[X]], <4 x i32> [[Y]])
; CHECK-NEXT:    store <4 x i8> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i8> [[TMP7]]
;
  %1 = call <4 x i8> @llvm.ucmp(<4 x i32> %x, <4 x i32> %y)
  ret <4 x i8> %1
}

define <4 x i32> @ucmp_narrow_vec_op(<4 x i8> %x, <4 x i8> %y) nounwind #0 {
; CHECK-LABEL: define <4 x i32> @ucmp_narrow_vec_op(
; CHECK-SAME: <4 x i8> [[X:%.*]], <4 x i8> [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i8>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x i8>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <4 x i8> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <4 x i8> [[_MSPROP]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = zext <4 x i8> [[_MSPROP1]] to <4 x i32>
; CHECK-NEXT:    [[TMP7:%.*]] = call <4 x i32> @llvm.ucmp.v4i32.v4i8(<4 x i8> [[X]], <4 x i8> [[Y]])
; CHECK-NEXT:    store <4 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[TMP7]]
;
  %1 = call <4 x i32> @llvm.ucmp(<4 x i8> %x, <4 x i8> %y)
  ret <4 x i32> %1
}

define <16 x i32> @ucmp_wide_vec_result(<16 x i8> %x, <16 x i8> %y) nounwind #0 {
; CHECK-LABEL: define <16 x i32> @ucmp_wide_vec_result(
; CHECK-SAME: <16 x i8> [[X:%.*]], <16 x i8> [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i8>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i8>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i8> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <16 x i8> [[_MSPROP]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = zext <16 x i8> [[_MSPROP1]] to <16 x i32>
; CHECK-NEXT:    [[TMP7:%.*]] = call <16 x i32> @llvm.ucmp.v16i32.v16i8(<16 x i8> [[X]], <16 x i8> [[Y]])
; CHECK-NEXT:    store <16 x i32> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x i32> [[TMP7]]
;
  %1 = call <16 x i32> @llvm.ucmp(<16 x i8> %x, <16 x i8> %y)
  ret <16 x i32> %1
}

define <16 x i8> @ucmp_wide_vec_op(<16 x i32> %x, <16 x i32> %y) nounwind #0 {
; CHECK-LABEL: define <16 x i8> @ucmp_wide_vec_op(
; CHECK-SAME: <16 x i32> [[X:%.*]], <16 x i32> [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i32> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <16 x i32> [[_MSPROP]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = trunc <16 x i32> [[_MSPROP1]] to <16 x i8>
; CHECK-NEXT:    [[TMP7:%.*]] = call <16 x i8> @llvm.ucmp.v16i8.v16i32(<16 x i32> [[X]], <16 x i32> [[Y]])
; CHECK-NEXT:    store <16 x i8> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x i8> [[TMP7]]
;
  %1 = call <16 x i8> @llvm.ucmp(<16 x i32> %x, <16 x i32> %y)
  ret <16 x i8> %1
}

define <17 x i2> @ucmp_uncommon_vectors(<17 x i71> %x, <17 x i71> %y) nounwind #0 {
; CHECK-LABEL: define <17 x i2> @ucmp_uncommon_vectors(
; CHECK-SAME: <17 x i71> [[X:%.*]], <17 x i71> [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <17 x i71>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <17 x i71>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 256) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <17 x i71> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <17 x i71> [[_MSPROP]], zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = trunc <17 x i71> [[_MSPROP1]] to <17 x i2>
; CHECK-NEXT:    [[TMP7:%.*]] = call <17 x i2> @llvm.ucmp.v17i2.v17i71(<17 x i71> [[X]], <17 x i71> [[Y]])
; CHECK-NEXT:    store <17 x i2> [[TMP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <17 x i2> [[TMP7]]
;
  %1 = call <17 x i2> @llvm.ucmp(<17 x i71> %x, <17 x i71> %y)
  ret <17 x i2> %1
}

attributes #0 = { sanitize_memory }
