#ifndef _flextgl_h_
#define _flextgl_h_
/*
    This file is part of Magnum.

    Copyright © 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019,
                2020 Vladimír Vondruš <mosra@centrum.cz>

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included
    in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*/

#include <Corrade/Utility/VisibilityMacros.h>

#include "Magnum/configure.h"
#include "Magnum/GL/GL.h"
#include "MagnumExternal/OpenGL/KHR/khrplatform.h"

/* Defensive include guards */

#if defined(__gl_h_) || defined(__gl2_h_)
#error Attempt to include auto-generated header after including gl2.h
#endif
#if defined(__gl2ext_h_)
#error Attempt to include auto-generated header after including gl2ext.h
#endif
#if defined(__gl2platform_h_)
#error Attempt to include auto-generated header after including gl2platform.h
#endif

#define __gl_h_
#define __gl2_h_
#define __gl2ext_h_
#define __gl2platform_h_

#ifdef __cplusplus
extern "C" {
#endif

void flextGLInit(Magnum::GL::Context& context);

/* Function declaration macros */

#ifndef MAGNUM_BUILD_STATIC
    #ifdef FlextGL_EXPORTS
        #define FLEXTGL_EXPORT CORRADE_VISIBILITY_EXPORT
    #else
        #define FLEXTGL_EXPORT CORRADE_VISIBILITY_IMPORT
    #endif
#else
    #define FLEXTGL_EXPORT CORRADE_VISIBILITY_STATIC
#endif

#if defined(_WIN32) && !defined(APIENTRY) && !defined(__CYGWIN__) && !defined(__SCITECH_SNAP__)
#define WIN32_LEAN_AND_MEAN 1
#ifndef WINAPI
#define WINAPI __stdcall
#endif
#define APIENTRY WINAPI
#endif

#ifndef APIENTRY
#define APIENTRY
#endif
#ifndef GLAPI
#define GLAPI extern
#endif

/* Data types */

typedef unsigned int GLenum;
typedef unsigned char GLboolean;
typedef unsigned int GLbitfield;
typedef void GLvoid;
typedef khronos_uint8_t GLubyte;
typedef int GLint;
typedef unsigned int GLuint;
typedef int GLsizei;
typedef khronos_float_t GLfloat;
typedef char GLchar;
typedef khronos_intptr_t GLintptr;
typedef khronos_ssize_t GLsizeiptr;
typedef khronos_int64_t GLint64;
typedef khronos_uint64_t GLuint64;
typedef void (APIENTRY *GLDEBUGPROCKHR)(GLenum source,GLenum type,GLuint id,GLenum severity,GLsizei length,const GLchar *message,const void *userParam);

/* Enums */

/* GL_ES_VERSION_2_0 */

#define GL_DEPTH_BUFFER_BIT 0x00000100
#define GL_STENCIL_BUFFER_BIT 0x00000400
#define GL_COLOR_BUFFER_BIT 0x00004000
#define GL_FALSE 0
#define GL_TRUE 1
#define GL_POINTS 0x0000
#define GL_LINES 0x0001
#define GL_LINE_LOOP 0x0002
#define GL_LINE_STRIP 0x0003
#define GL_TRIANGLES 0x0004
#define GL_TRIANGLE_STRIP 0x0005
#define GL_TRIANGLE_FAN 0x0006
#define GL_ZERO 0
#define GL_ONE 1
#define GL_SRC_COLOR 0x0300
#define GL_ONE_MINUS_SRC_COLOR 0x0301
#define GL_SRC_ALPHA 0x0302
#define GL_ONE_MINUS_SRC_ALPHA 0x0303
#define GL_DST_ALPHA 0x0304
#define GL_ONE_MINUS_DST_ALPHA 0x0305
#define GL_DST_COLOR 0x0306
#define GL_ONE_MINUS_DST_COLOR 0x0307
#define GL_SRC_ALPHA_SATURATE 0x0308
#define GL_FUNC_ADD 0x8006
#define GL_BLEND_EQUATION 0x8009
#define GL_BLEND_EQUATION_RGB 0x8009
#define GL_BLEND_EQUATION_ALPHA 0x883D
#define GL_FUNC_SUBTRACT 0x800A
#define GL_FUNC_REVERSE_SUBTRACT 0x800B
#define GL_BLEND_DST_RGB 0x80C8
#define GL_BLEND_SRC_RGB 0x80C9
#define GL_BLEND_DST_ALPHA 0x80CA
#define GL_BLEND_SRC_ALPHA 0x80CB
#define GL_CONSTANT_COLOR 0x8001
#define GL_ONE_MINUS_CONSTANT_COLOR 0x8002
#define GL_CONSTANT_ALPHA 0x8003
#define GL_ONE_MINUS_CONSTANT_ALPHA 0x8004
#define GL_BLEND_COLOR 0x8005
#define GL_ARRAY_BUFFER 0x8892
#define GL_ELEMENT_ARRAY_BUFFER 0x8893
#define GL_ARRAY_BUFFER_BINDING 0x8894
#define GL_ELEMENT_ARRAY_BUFFER_BINDING 0x8895
#define GL_STREAM_DRAW 0x88E0
#define GL_STATIC_DRAW 0x88E4
#define GL_DYNAMIC_DRAW 0x88E8
#define GL_BUFFER_SIZE 0x8764
#define GL_BUFFER_USAGE 0x8765
#define GL_CURRENT_VERTEX_ATTRIB 0x8626
#define GL_FRONT 0x0404
#define GL_BACK 0x0405
#define GL_FRONT_AND_BACK 0x0408
#define GL_TEXTURE_2D 0x0DE1
#define GL_CULL_FACE 0x0B44
#define GL_BLEND 0x0BE2
#define GL_DITHER 0x0BD0
#define GL_STENCIL_TEST 0x0B90
#define GL_DEPTH_TEST 0x0B71
#define GL_SCISSOR_TEST 0x0C11
#define GL_POLYGON_OFFSET_FILL 0x8037
#define GL_SAMPLE_ALPHA_TO_COVERAGE 0x809E
#define GL_SAMPLE_COVERAGE 0x80A0
#define GL_NO_ERROR 0
#define GL_INVALID_ENUM 0x0500
#define GL_INVALID_VALUE 0x0501
#define GL_INVALID_OPERATION 0x0502
#define GL_OUT_OF_MEMORY 0x0505
#define GL_CW 0x0900
#define GL_CCW 0x0901
#define GL_LINE_WIDTH 0x0B21
#define GL_ALIASED_POINT_SIZE_RANGE 0x846D
#define GL_ALIASED_LINE_WIDTH_RANGE 0x846E
#define GL_CULL_FACE_MODE 0x0B45
#define GL_FRONT_FACE 0x0B46
#define GL_DEPTH_RANGE 0x0B70
#define GL_DEPTH_WRITEMASK 0x0B72
#define GL_DEPTH_CLEAR_VALUE 0x0B73
#define GL_DEPTH_FUNC 0x0B74
#define GL_STENCIL_CLEAR_VALUE 0x0B91
#define GL_STENCIL_FUNC 0x0B92
#define GL_STENCIL_FAIL 0x0B94
#define GL_STENCIL_PASS_DEPTH_FAIL 0x0B95
#define GL_STENCIL_PASS_DEPTH_PASS 0x0B96
#define GL_STENCIL_REF 0x0B97
#define GL_STENCIL_VALUE_MASK 0x0B93
#define GL_STENCIL_WRITEMASK 0x0B98
#define GL_STENCIL_BACK_FUNC 0x8800
#define GL_STENCIL_BACK_FAIL 0x8801
#define GL_STENCIL_BACK_PASS_DEPTH_FAIL 0x8802
#define GL_STENCIL_BACK_PASS_DEPTH_PASS 0x8803
#define GL_STENCIL_BACK_REF 0x8CA3
#define GL_STENCIL_BACK_VALUE_MASK 0x8CA4
#define GL_STENCIL_BACK_WRITEMASK 0x8CA5
#define GL_VIEWPORT 0x0BA2
#define GL_SCISSOR_BOX 0x0C10
#define GL_COLOR_CLEAR_VALUE 0x0C22
#define GL_COLOR_WRITEMASK 0x0C23
#define GL_UNPACK_ALIGNMENT 0x0CF5
#define GL_PACK_ALIGNMENT 0x0D05
#define GL_MAX_TEXTURE_SIZE 0x0D33
#define GL_MAX_VIEWPORT_DIMS 0x0D3A
#define GL_SUBPIXEL_BITS 0x0D50
#define GL_RED_BITS 0x0D52
#define GL_GREEN_BITS 0x0D53
#define GL_BLUE_BITS 0x0D54
#define GL_ALPHA_BITS 0x0D55
#define GL_DEPTH_BITS 0x0D56
#define GL_STENCIL_BITS 0x0D57
#define GL_POLYGON_OFFSET_UNITS 0x2A00
#define GL_POLYGON_OFFSET_FACTOR 0x8038
#define GL_TEXTURE_BINDING_2D 0x8069
#define GL_SAMPLE_BUFFERS 0x80A8
#define GL_SAMPLES 0x80A9
#define GL_SAMPLE_COVERAGE_VALUE 0x80AA
#define GL_SAMPLE_COVERAGE_INVERT 0x80AB
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS 0x86A2
#define GL_COMPRESSED_TEXTURE_FORMATS 0x86A3
#define GL_DONT_CARE 0x1100
#define GL_FASTEST 0x1101
#define GL_NICEST 0x1102
#define GL_GENERATE_MIPMAP_HINT 0x8192
#define GL_BYTE 0x1400
#define GL_UNSIGNED_BYTE 0x1401
#define GL_SHORT 0x1402
#define GL_UNSIGNED_SHORT 0x1403
#define GL_INT 0x1404
#define GL_UNSIGNED_INT 0x1405
#define GL_FLOAT 0x1406
#define GL_FIXED 0x140C
#define GL_DEPTH_COMPONENT 0x1902
#define GL_ALPHA 0x1906
#define GL_RGB 0x1907
#define GL_RGBA 0x1908
#define GL_LUMINANCE 0x1909
#define GL_LUMINANCE_ALPHA 0x190A
#define GL_UNSIGNED_SHORT_4_4_4_4 0x8033
#define GL_UNSIGNED_SHORT_5_5_5_1 0x8034
#define GL_UNSIGNED_SHORT_5_6_5 0x8363
#define GL_FRAGMENT_SHADER 0x8B30
#define GL_VERTEX_SHADER 0x8B31
#define GL_MAX_VERTEX_ATTRIBS 0x8869
#define GL_MAX_VERTEX_UNIFORM_VECTORS 0x8DFB
#define GL_MAX_VARYING_VECTORS 0x8DFC
#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS 0x8B4D
#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS 0x8B4C
#define GL_MAX_TEXTURE_IMAGE_UNITS 0x8872
#define GL_MAX_FRAGMENT_UNIFORM_VECTORS 0x8DFD
#define GL_SHADER_TYPE 0x8B4F
#define GL_DELETE_STATUS 0x8B80
#define GL_LINK_STATUS 0x8B82
#define GL_VALIDATE_STATUS 0x8B83
#define GL_ATTACHED_SHADERS 0x8B85
#define GL_ACTIVE_UNIFORMS 0x8B86
#define GL_ACTIVE_UNIFORM_MAX_LENGTH 0x8B87
#define GL_ACTIVE_ATTRIBUTES 0x8B89
#define GL_ACTIVE_ATTRIBUTE_MAX_LENGTH 0x8B8A
#define GL_SHADING_LANGUAGE_VERSION 0x8B8C
#define GL_CURRENT_PROGRAM 0x8B8D
#define GL_NEVER 0x0200
#define GL_LESS 0x0201
#define GL_EQUAL 0x0202
#define GL_LEQUAL 0x0203
#define GL_GREATER 0x0204
#define GL_NOTEQUAL 0x0205
#define GL_GEQUAL 0x0206
#define GL_ALWAYS 0x0207
#define GL_KEEP 0x1E00
#define GL_REPLACE 0x1E01
#define GL_INCR 0x1E02
#define GL_DECR 0x1E03
#define GL_INVERT 0x150A
#define GL_INCR_WRAP 0x8507
#define GL_DECR_WRAP 0x8508
#define GL_VENDOR 0x1F00
#define GL_RENDERER 0x1F01
#define GL_VERSION 0x1F02
#define GL_EXTENSIONS 0x1F03
#define GL_NEAREST 0x2600
#define GL_LINEAR 0x2601
#define GL_NEAREST_MIPMAP_NEAREST 0x2700
#define GL_LINEAR_MIPMAP_NEAREST 0x2701
#define GL_NEAREST_MIPMAP_LINEAR 0x2702
#define GL_LINEAR_MIPMAP_LINEAR 0x2703
#define GL_TEXTURE_MAG_FILTER 0x2800
#define GL_TEXTURE_MIN_FILTER 0x2801
#define GL_TEXTURE_WRAP_S 0x2802
#define GL_TEXTURE_WRAP_T 0x2803
#define GL_TEXTURE 0x1702
#define GL_TEXTURE_CUBE_MAP 0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP 0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X 0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X 0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y 0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y 0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z 0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z 0x851A
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE 0x851C
#define GL_TEXTURE0 0x84C0
#define GL_TEXTURE1 0x84C1
#define GL_TEXTURE2 0x84C2
#define GL_TEXTURE3 0x84C3
#define GL_TEXTURE4 0x84C4
#define GL_TEXTURE5 0x84C5
#define GL_TEXTURE6 0x84C6
#define GL_TEXTURE7 0x84C7
#define GL_TEXTURE8 0x84C8
#define GL_TEXTURE9 0x84C9
#define GL_TEXTURE10 0x84CA
#define GL_TEXTURE11 0x84CB
#define GL_TEXTURE12 0x84CC
#define GL_TEXTURE13 0x84CD
#define GL_TEXTURE14 0x84CE
#define GL_TEXTURE15 0x84CF
#define GL_TEXTURE16 0x84D0
#define GL_TEXTURE17 0x84D1
#define GL_TEXTURE18 0x84D2
#define GL_TEXTURE19 0x84D3
#define GL_TEXTURE20 0x84D4
#define GL_TEXTURE21 0x84D5
#define GL_TEXTURE22 0x84D6
#define GL_TEXTURE23 0x84D7
#define GL_TEXTURE24 0x84D8
#define GL_TEXTURE25 0x84D9
#define GL_TEXTURE26 0x84DA
#define GL_TEXTURE27 0x84DB
#define GL_TEXTURE28 0x84DC
#define GL_TEXTURE29 0x84DD
#define GL_TEXTURE30 0x84DE
#define GL_TEXTURE31 0x84DF
#define GL_ACTIVE_TEXTURE 0x84E0
#define GL_REPEAT 0x2901
#define GL_CLAMP_TO_EDGE 0x812F
#define GL_MIRRORED_REPEAT 0x8370
#define GL_FLOAT_VEC2 0x8B50
#define GL_FLOAT_VEC3 0x8B51
#define GL_FLOAT_VEC4 0x8B52
#define GL_INT_VEC2 0x8B53
#define GL_INT_VEC3 0x8B54
#define GL_INT_VEC4 0x8B55
#define GL_BOOL 0x8B56
#define GL_BOOL_VEC2 0x8B57
#define GL_BOOL_VEC3 0x8B58
#define GL_BOOL_VEC4 0x8B59
#define GL_FLOAT_MAT2 0x8B5A
#define GL_FLOAT_MAT3 0x8B5B
#define GL_FLOAT_MAT4 0x8B5C
#define GL_SAMPLER_2D 0x8B5E
#define GL_SAMPLER_CUBE 0x8B60
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED 0x8622
#define GL_VERTEX_ATTRIB_ARRAY_SIZE 0x8623
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE 0x8624
#define GL_VERTEX_ATTRIB_ARRAY_TYPE 0x8625
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED 0x886A
#define GL_VERTEX_ATTRIB_ARRAY_POINTER 0x8645
#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING 0x889F
#define GL_IMPLEMENTATION_COLOR_READ_TYPE 0x8B9A
#define GL_IMPLEMENTATION_COLOR_READ_FORMAT 0x8B9B
#define GL_COMPILE_STATUS 0x8B81
#define GL_INFO_LOG_LENGTH 0x8B84
#define GL_SHADER_SOURCE_LENGTH 0x8B88
#define GL_SHADER_COMPILER 0x8DFA
#define GL_SHADER_BINARY_FORMATS 0x8DF8
#define GL_NUM_SHADER_BINARY_FORMATS 0x8DF9
#define GL_LOW_FLOAT 0x8DF0
#define GL_MEDIUM_FLOAT 0x8DF1
#define GL_HIGH_FLOAT 0x8DF2
#define GL_LOW_INT 0x8DF3
#define GL_MEDIUM_INT 0x8DF4
#define GL_HIGH_INT 0x8DF5
#define GL_FRAMEBUFFER 0x8D40
#define GL_RENDERBUFFER 0x8D41
#define GL_RGBA4 0x8056
#define GL_RGB5_A1 0x8057
#define GL_RGB565 0x8D62
#define GL_DEPTH_COMPONENT16 0x81A5
#define GL_STENCIL_INDEX8 0x8D48
#define GL_RENDERBUFFER_WIDTH 0x8D42
#define GL_RENDERBUFFER_HEIGHT 0x8D43
#define GL_RENDERBUFFER_INTERNAL_FORMAT 0x8D44
#define GL_RENDERBUFFER_RED_SIZE 0x8D50
#define GL_RENDERBUFFER_GREEN_SIZE 0x8D51
#define GL_RENDERBUFFER_BLUE_SIZE 0x8D52
#define GL_RENDERBUFFER_ALPHA_SIZE 0x8D53
#define GL_RENDERBUFFER_DEPTH_SIZE 0x8D54
#define GL_RENDERBUFFER_STENCIL_SIZE 0x8D55
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE 0x8CD0
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME 0x8CD1
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL 0x8CD2
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE 0x8CD3
#define GL_COLOR_ATTACHMENT0 0x8CE0
#define GL_DEPTH_ATTACHMENT 0x8D00
#define GL_STENCIL_ATTACHMENT 0x8D20
#define GL_NONE 0
#define GL_FRAMEBUFFER_COMPLETE 0x8CD5
#define GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT 0x8CD6
#define GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT 0x8CD7
#define GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS 0x8CD9
#define GL_FRAMEBUFFER_UNSUPPORTED 0x8CDD
#define GL_FRAMEBUFFER_BINDING 0x8CA6
#define GL_RENDERBUFFER_BINDING 0x8CA7
#define GL_MAX_RENDERBUFFER_SIZE 0x84E8
#define GL_INVALID_FRAMEBUFFER_OPERATION 0x0506

/* GL_ANGLE_framebuffer_blit */

#define GL_READ_FRAMEBUFFER_ANGLE 0x8CA8
#define GL_DRAW_FRAMEBUFFER_ANGLE 0x8CA9
#define GL_DRAW_FRAMEBUFFER_BINDING_ANGLE 0x8CA6
#define GL_READ_FRAMEBUFFER_BINDING_ANGLE 0x8CAA

/* GL_ANGLE_framebuffer_multisample */

#define GL_RENDERBUFFER_SAMPLES_ANGLE 0x8CAB
#define GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE 0x8D56
#define GL_MAX_SAMPLES_ANGLE 0x8D57

/* GL_ANGLE_instanced_arrays */

#define GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE 0x88FE

/* GL_ANGLE_depth_texture */

#define GL_DEPTH_COMPONENT 0x1902
#define GL_DEPTH_STENCIL_OES 0x84F9
#define GL_UNSIGNED_SHORT 0x1403
#define GL_UNSIGNED_INT 0x1405
#define GL_UNSIGNED_INT_24_8_OES 0x84FA
#define GL_DEPTH_COMPONENT16 0x81A5
#define GL_DEPTH_COMPONENT32_OES 0x81A7
#define GL_DEPTH24_STENCIL8_OES 0x88F0

/* GL_APPLE_framebuffer_multisample */

#define GL_RENDERBUFFER_SAMPLES_APPLE 0x8CAB
#define GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_APPLE 0x8D56
#define GL_MAX_SAMPLES_APPLE 0x8D57
#define GL_READ_FRAMEBUFFER_APPLE 0x8CA8
#define GL_DRAW_FRAMEBUFFER_APPLE 0x8CA9
#define GL_DRAW_FRAMEBUFFER_BINDING_APPLE 0x8CA6
#define GL_READ_FRAMEBUFFER_BINDING_APPLE 0x8CAA

/* GL_APPLE_texture_max_level */

#define GL_TEXTURE_MAX_LEVEL_APPLE 0x813D

/* GL_APPLE_clip_distance */

#define GL_MAX_CLIP_DISTANCES_APPLE 0x0D32
#define GL_CLIP_DISTANCE0_APPLE 0x3000
#define GL_CLIP_DISTANCE1_APPLE 0x3001
#define GL_CLIP_DISTANCE2_APPLE 0x3002
#define GL_CLIP_DISTANCE3_APPLE 0x3003
#define GL_CLIP_DISTANCE4_APPLE 0x3004
#define GL_CLIP_DISTANCE5_APPLE 0x3005
#define GL_CLIP_DISTANCE6_APPLE 0x3006
#define GL_CLIP_DISTANCE7_APPLE 0x3007

/* GL_EXT_texture_type_2_10_10_10_REV */

#define GL_UNSIGNED_INT_2_10_10_10_REV_EXT 0x8368

/* GL_EXT_discard_framebuffer */

#define GL_COLOR_EXT 0x1800
#define GL_DEPTH_EXT 0x1801
#define GL_STENCIL_EXT 0x1802

/* GL_EXT_blend_minmax */

#define GL_MIN_EXT 0x8007
#define GL_MAX_EXT 0x8008

/* GL_EXT_unpack_subimage */

#define GL_UNPACK_ROW_LENGTH_EXT 0x0CF2
#define GL_UNPACK_SKIP_ROWS_EXT 0x0CF3
#define GL_UNPACK_SKIP_PIXELS_EXT 0x0CF4

/* GL_EXT_occlusion_query_boolean */

#define GL_ANY_SAMPLES_PASSED_EXT 0x8C2F
#define GL_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT 0x8D6A
#define GL_CURRENT_QUERY_EXT 0x8865
#define GL_QUERY_RESULT_EXT 0x8866
#define GL_QUERY_RESULT_AVAILABLE_EXT 0x8867

/* GL_EXT_shadow_samplers */

#define GL_TEXTURE_COMPARE_MODE_EXT 0x884C
#define GL_TEXTURE_COMPARE_FUNC_EXT 0x884D
#define GL_COMPARE_REF_TO_TEXTURE_EXT 0x884E
#define GL_SAMPLER_2D_SHADOW_EXT 0x8B62

/* GL_EXT_texture_rg */

#define GL_RED_EXT 0x1903
#define GL_RG_EXT 0x8227
#define GL_R8_EXT 0x8229
#define GL_RG8_EXT 0x822B

/* GL_EXT_sRGB */

#define GL_SRGB_EXT 0x8C40
#define GL_SRGB_ALPHA_EXT 0x8C42
#define GL_SRGB8_ALPHA8_EXT 0x8C43
#define GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT 0x8210

/* GL_EXT_texture_storage */

#define GL_TEXTURE_IMMUTABLE_FORMAT_EXT 0x912F
#define GL_ALPHA8_EXT 0x803C
#define GL_LUMINANCE8_EXT 0x8040
#define GL_LUMINANCE8_ALPHA8_EXT 0x8045
#define GL_RGBA32F_EXT 0x8814
#define GL_RGB32F_EXT 0x8815
#define GL_ALPHA32F_EXT 0x8816
#define GL_LUMINANCE32F_EXT 0x8818
#define GL_LUMINANCE_ALPHA32F_EXT 0x8819
#define GL_RGBA16F_EXT 0x881A
#define GL_RGB16F_EXT 0x881B
#define GL_ALPHA16F_EXT 0x881C
#define GL_LUMINANCE16F_EXT 0x881E
#define GL_LUMINANCE_ALPHA16F_EXT 0x881F
#define GL_RGB10_A2_EXT 0x8059
#define GL_RGB10_EXT 0x8052
#define GL_BGRA8_EXT 0x93A1
#define GL_R8_EXT 0x8229
#define GL_RG8_EXT 0x822B
#define GL_R32F_EXT 0x822E
#define GL_RG32F_EXT 0x8230
#define GL_R16F_EXT 0x822D
#define GL_RG16F_EXT 0x822F

/* GL_EXT_map_buffer_range */

#define GL_MAP_READ_BIT_EXT 0x0001
#define GL_MAP_WRITE_BIT_EXT 0x0002
#define GL_MAP_INVALIDATE_RANGE_BIT_EXT 0x0004
#define GL_MAP_INVALIDATE_BUFFER_BIT_EXT 0x0008
#define GL_MAP_FLUSH_EXPLICIT_BIT_EXT 0x0010
#define GL_MAP_UNSYNCHRONIZED_BIT_EXT 0x0020

/* GL_EXT_draw_buffers */

#define GL_MAX_COLOR_ATTACHMENTS_EXT 0x8CDF
#define GL_MAX_DRAW_BUFFERS_EXT 0x8824
#define GL_DRAW_BUFFER0_EXT 0x8825
#define GL_DRAW_BUFFER1_EXT 0x8826
#define GL_DRAW_BUFFER2_EXT 0x8827
#define GL_DRAW_BUFFER3_EXT 0x8828
#define GL_DRAW_BUFFER4_EXT 0x8829
#define GL_DRAW_BUFFER5_EXT 0x882A
#define GL_DRAW_BUFFER6_EXT 0x882B
#define GL_DRAW_BUFFER7_EXT 0x882C
#define GL_DRAW_BUFFER8_EXT 0x882D
#define GL_DRAW_BUFFER9_EXT 0x882E
#define GL_DRAW_BUFFER10_EXT 0x882F
#define GL_DRAW_BUFFER11_EXT 0x8830
#define GL_DRAW_BUFFER12_EXT 0x8831
#define GL_DRAW_BUFFER13_EXT 0x8832
#define GL_DRAW_BUFFER14_EXT 0x8833
#define GL_DRAW_BUFFER15_EXT 0x8834
#define GL_COLOR_ATTACHMENT0_EXT 0x8CE0
#define GL_COLOR_ATTACHMENT1_EXT 0x8CE1
#define GL_COLOR_ATTACHMENT2_EXT 0x8CE2
#define GL_COLOR_ATTACHMENT3_EXT 0x8CE3
#define GL_COLOR_ATTACHMENT4_EXT 0x8CE4
#define GL_COLOR_ATTACHMENT5_EXT 0x8CE5
#define GL_COLOR_ATTACHMENT6_EXT 0x8CE6
#define GL_COLOR_ATTACHMENT7_EXT 0x8CE7
#define GL_COLOR_ATTACHMENT8_EXT 0x8CE8
#define GL_COLOR_ATTACHMENT9_EXT 0x8CE9
#define GL_COLOR_ATTACHMENT10_EXT 0x8CEA
#define GL_COLOR_ATTACHMENT11_EXT 0x8CEB
#define GL_COLOR_ATTACHMENT12_EXT 0x8CEC
#define GL_COLOR_ATTACHMENT13_EXT 0x8CED
#define GL_COLOR_ATTACHMENT14_EXT 0x8CEE
#define GL_COLOR_ATTACHMENT15_EXT 0x8CEF

/* GL_EXT_instanced_arrays */

#define GL_VERTEX_ATTRIB_ARRAY_DIVISOR_EXT 0x88FE

/* GL_NV_draw_buffers */

#define GL_MAX_DRAW_BUFFERS_NV 0x8824
#define GL_DRAW_BUFFER0_NV 0x8825
#define GL_DRAW_BUFFER1_NV 0x8826
#define GL_DRAW_BUFFER2_NV 0x8827
#define GL_DRAW_BUFFER3_NV 0x8828
#define GL_DRAW_BUFFER4_NV 0x8829
#define GL_DRAW_BUFFER5_NV 0x882A
#define GL_DRAW_BUFFER6_NV 0x882B
#define GL_DRAW_BUFFER7_NV 0x882C
#define GL_DRAW_BUFFER8_NV 0x882D
#define GL_DRAW_BUFFER9_NV 0x882E
#define GL_DRAW_BUFFER10_NV 0x882F
#define GL_DRAW_BUFFER11_NV 0x8830
#define GL_DRAW_BUFFER12_NV 0x8831
#define GL_DRAW_BUFFER13_NV 0x8832
#define GL_DRAW_BUFFER14_NV 0x8833
#define GL_DRAW_BUFFER15_NV 0x8834
#define GL_COLOR_ATTACHMENT0_NV 0x8CE0
#define GL_COLOR_ATTACHMENT1_NV 0x8CE1
#define GL_COLOR_ATTACHMENT2_NV 0x8CE2
#define GL_COLOR_ATTACHMENT3_NV 0x8CE3
#define GL_COLOR_ATTACHMENT4_NV 0x8CE4
#define GL_COLOR_ATTACHMENT5_NV 0x8CE5
#define GL_COLOR_ATTACHMENT6_NV 0x8CE6
#define GL_COLOR_ATTACHMENT7_NV 0x8CE7
#define GL_COLOR_ATTACHMENT8_NV 0x8CE8
#define GL_COLOR_ATTACHMENT9_NV 0x8CE9
#define GL_COLOR_ATTACHMENT10_NV 0x8CEA
#define GL_COLOR_ATTACHMENT11_NV 0x8CEB
#define GL_COLOR_ATTACHMENT12_NV 0x8CEC
#define GL_COLOR_ATTACHMENT13_NV 0x8CED
#define GL_COLOR_ATTACHMENT14_NV 0x8CEE
#define GL_COLOR_ATTACHMENT15_NV 0x8CEF

/* GL_NV_read_buffer */

#define GL_READ_BUFFER_NV 0x0C02

/* GL_NV_framebuffer_blit */

#define GL_READ_FRAMEBUFFER_NV 0x8CA8
#define GL_DRAW_FRAMEBUFFER_NV 0x8CA9
#define GL_DRAW_FRAMEBUFFER_BINDING_NV 0x8CA6
#define GL_READ_FRAMEBUFFER_BINDING_NV 0x8CAA

/* GL_NV_framebuffer_multisample */

#define GL_RENDERBUFFER_SAMPLES_NV 0x8CAB
#define GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_NV 0x8D56
#define GL_MAX_SAMPLES_NV 0x8D57

/* GL_NV_instanced_arrays */

#define GL_VERTEX_ATTRIB_ARRAY_DIVISOR_NV 0x88FE

/* GL_NV_shadow_samplers_array */

#define GL_SAMPLER_2D_ARRAY_SHADOW_NV 0x8DC4

/* GL_NV_shadow_samplers_cube */

#define GL_SAMPLER_CUBE_SHADOW_NV 0x8DC5

/* GL_OES_depth24 */

#define GL_DEPTH_COMPONENT24_OES 0x81A6

/* GL_OES_element_index_uint */

#define GL_UNSIGNED_INT 0x1405

/* GL_OES_rgb8_rgba8 */

#define GL_RGB8_OES 0x8051
#define GL_RGBA8_OES 0x8058

/* GL_OES_texture_3D */

#define GL_TEXTURE_WRAP_R_OES 0x8072
#define GL_TEXTURE_3D_OES 0x806F
#define GL_TEXTURE_BINDING_3D_OES 0x806A
#define GL_MAX_3D_TEXTURE_SIZE_OES 0x8073
#define GL_SAMPLER_3D_OES 0x8B5F
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES 0x8CD4

/* GL_OES_texture_half_float */

#define GL_HALF_FLOAT_OES 0x8D61

/* GL_OES_texture_float */

#define GL_FLOAT 0x1406

/* GL_OES_vertex_half_float */

#define GL_HALF_FLOAT_OES 0x8D61

/* GL_OES_packed_depth_stencil */

#define GL_DEPTH_STENCIL_OES 0x84F9
#define GL_UNSIGNED_INT_24_8_OES 0x84FA
#define GL_DEPTH24_STENCIL8_OES 0x88F0

/* GL_OES_depth_texture */

#define GL_DEPTH_COMPONENT 0x1902
#define GL_UNSIGNED_SHORT 0x1403
#define GL_UNSIGNED_INT 0x1405

/* GL_OES_standard_derivatives */

#define GL_FRAGMENT_SHADER_DERIVATIVE_HINT_OES 0x8B8B

/* GL_OES_vertex_array_object */

#define GL_VERTEX_ARRAY_BINDING_OES 0x85B5

/* GL_OES_required_internalformat */

#define GL_ALPHA8_OES 0x803C
#define GL_DEPTH_COMPONENT16_OES 0x81A5
#define GL_DEPTH_COMPONENT24_OES 0x81A6
#define GL_DEPTH24_STENCIL8_OES 0x88F0
#define GL_DEPTH_COMPONENT32_OES 0x81A7
#define GL_LUMINANCE4_ALPHA4_OES 0x8043
#define GL_LUMINANCE8_ALPHA8_OES 0x8045
#define GL_LUMINANCE8_OES 0x8040
#define GL_RGBA4_OES 0x8056
#define GL_RGB5_A1_OES 0x8057
#define GL_RGB565_OES 0x8D62
#define GL_RGB8_OES 0x8051
#define GL_RGBA8_OES 0x8058
#define GL_RGB10_EXT 0x8052
#define GL_RGB10_A2_EXT 0x8059

/* GL_OES_surfaceless_context */

#define GL_FRAMEBUFFER_UNDEFINED_OES 0x8219

/* GL_EXT_color_buffer_half_float */

#define GL_RGBA16F_EXT 0x881A
#define GL_RGB16F_EXT 0x881B
#define GL_RG16F_EXT 0x822F
#define GL_R16F_EXT 0x822D
#define GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT 0x8211
#define GL_UNSIGNED_NORMALIZED_EXT 0x8C17

/* GL_EXT_draw_buffers_indexed */

#define GL_BLEND_EQUATION_RGB 0x8009
#define GL_BLEND_EQUATION_ALPHA 0x883D
#define GL_BLEND_SRC_RGB 0x80C9
#define GL_BLEND_SRC_ALPHA 0x80CB
#define GL_BLEND_DST_RGB 0x80C8
#define GL_BLEND_DST_ALPHA 0x80CA
#define GL_COLOR_WRITEMASK 0x0C23
#define GL_BLEND 0x0BE2
#define GL_FUNC_ADD 0x8006
#define GL_FUNC_SUBTRACT 0x800A
#define GL_FUNC_REVERSE_SUBTRACT 0x800B
#define GL_MIN 0x8007
#define GL_MAX 0x8008
#define GL_ZERO 0
#define GL_ONE 1
#define GL_SRC_COLOR 0x0300
#define GL_ONE_MINUS_SRC_COLOR 0x0301
#define GL_DST_COLOR 0x0306
#define GL_ONE_MINUS_DST_COLOR 0x0307
#define GL_SRC_ALPHA 0x0302
#define GL_ONE_MINUS_SRC_ALPHA 0x0303
#define GL_DST_ALPHA 0x0304
#define GL_ONE_MINUS_DST_ALPHA 0x0305
#define GL_CONSTANT_COLOR 0x8001
#define GL_ONE_MINUS_CONSTANT_COLOR 0x8002
#define GL_CONSTANT_ALPHA 0x8003
#define GL_ONE_MINUS_CONSTANT_ALPHA 0x8004
#define GL_SRC_ALPHA_SATURATE 0x0308

/* GL_EXT_texture_border_clamp */

#define GL_TEXTURE_BORDER_COLOR_EXT 0x1004
#define GL_CLAMP_TO_BORDER_EXT 0x812D

/* GL_KHR_texture_compression_astc_ldr */

#define GL_COMPRESSED_RGBA_ASTC_4x4_KHR 0x93B0
#define GL_COMPRESSED_RGBA_ASTC_5x4_KHR 0x93B1
#define GL_COMPRESSED_RGBA_ASTC_5x5_KHR 0x93B2
#define GL_COMPRESSED_RGBA_ASTC_6x5_KHR 0x93B3
#define GL_COMPRESSED_RGBA_ASTC_6x6_KHR 0x93B4
#define GL_COMPRESSED_RGBA_ASTC_8x5_KHR 0x93B5
#define GL_COMPRESSED_RGBA_ASTC_8x6_KHR 0x93B6
#define GL_COMPRESSED_RGBA_ASTC_8x8_KHR 0x93B7
#define GL_COMPRESSED_RGBA_ASTC_10x5_KHR 0x93B8
#define GL_COMPRESSED_RGBA_ASTC_10x6_KHR 0x93B9
#define GL_COMPRESSED_RGBA_ASTC_10x8_KHR 0x93BA
#define GL_COMPRESSED_RGBA_ASTC_10x10_KHR 0x93BB
#define GL_COMPRESSED_RGBA_ASTC_12x10_KHR 0x93BC
#define GL_COMPRESSED_RGBA_ASTC_12x12_KHR 0x93BD
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR 0x93D0
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR 0x93D1
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR 0x93D2
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR 0x93D3
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR 0x93D4
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR 0x93D5
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR 0x93D6
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR 0x93D7
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR 0x93D8
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR 0x93D9
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR 0x93DA
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR 0x93DB
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR 0x93DC
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR 0x93DD

/* GL_KHR_debug */

#define GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR 0x8242
#define GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR 0x8243
#define GL_DEBUG_CALLBACK_FUNCTION_KHR 0x8244
#define GL_DEBUG_CALLBACK_USER_PARAM_KHR 0x8245
#define GL_DEBUG_SOURCE_API_KHR 0x8246
#define GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR 0x8247
#define GL_DEBUG_SOURCE_SHADER_COMPILER_KHR 0x8248
#define GL_DEBUG_SOURCE_THIRD_PARTY_KHR 0x8249
#define GL_DEBUG_SOURCE_APPLICATION_KHR 0x824A
#define GL_DEBUG_SOURCE_OTHER_KHR 0x824B
#define GL_DEBUG_TYPE_ERROR_KHR 0x824C
#define GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR 0x824D
#define GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR 0x824E
#define GL_DEBUG_TYPE_PORTABILITY_KHR 0x824F
#define GL_DEBUG_TYPE_PERFORMANCE_KHR 0x8250
#define GL_DEBUG_TYPE_OTHER_KHR 0x8251
#define GL_DEBUG_TYPE_MARKER_KHR 0x8268
#define GL_DEBUG_TYPE_PUSH_GROUP_KHR 0x8269
#define GL_DEBUG_TYPE_POP_GROUP_KHR 0x826A
#define GL_DEBUG_SEVERITY_NOTIFICATION_KHR 0x826B
#define GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR 0x826C
#define GL_DEBUG_GROUP_STACK_DEPTH_KHR 0x826D
#define GL_BUFFER_KHR 0x82E0
#define GL_SHADER_KHR 0x82E1
#define GL_PROGRAM_KHR 0x82E2
#define GL_VERTEX_ARRAY_KHR 0x8074
#define GL_QUERY_KHR 0x82E3
#define GL_PROGRAM_PIPELINE_KHR 0x82E4
#define GL_SAMPLER_KHR 0x82E6
#define GL_MAX_LABEL_LENGTH_KHR 0x82E8
#define GL_MAX_DEBUG_MESSAGE_LENGTH_KHR 0x9143
#define GL_MAX_DEBUG_LOGGED_MESSAGES_KHR 0x9144
#define GL_DEBUG_LOGGED_MESSAGES_KHR 0x9145
#define GL_DEBUG_SEVERITY_HIGH_KHR 0x9146
#define GL_DEBUG_SEVERITY_MEDIUM_KHR 0x9147
#define GL_DEBUG_SEVERITY_LOW_KHR 0x9148
#define GL_DEBUG_OUTPUT_KHR 0x92E0
#define GL_CONTEXT_FLAG_DEBUG_BIT_KHR 0x00000002
#define GL_STACK_OVERFLOW_KHR 0x0503
#define GL_STACK_UNDERFLOW_KHR 0x0504

/* GL_KHR_blend_equation_advanced */

#define GL_MULTIPLY_KHR 0x9294
#define GL_SCREEN_KHR 0x9295
#define GL_OVERLAY_KHR 0x9296
#define GL_DARKEN_KHR 0x9297
#define GL_LIGHTEN_KHR 0x9298
#define GL_COLORDODGE_KHR 0x9299
#define GL_COLORBURN_KHR 0x929A
#define GL_HARDLIGHT_KHR 0x929B
#define GL_SOFTLIGHT_KHR 0x929C
#define GL_DIFFERENCE_KHR 0x929E
#define GL_EXCLUSION_KHR 0x92A0
#define GL_HSL_HUE_KHR 0x92AD
#define GL_HSL_SATURATION_KHR 0x92AE
#define GL_HSL_COLOR_KHR 0x92AF
#define GL_HSL_LUMINOSITY_KHR 0x92B0

/* GL_KHR_robustness */

#define GL_NO_ERROR 0
#define GL_CONTEXT_ROBUST_ACCESS_KHR 0x90F3
#define GL_LOSE_CONTEXT_ON_RESET_KHR 0x8252
#define GL_GUILTY_CONTEXT_RESET_KHR 0x8253
#define GL_INNOCENT_CONTEXT_RESET_KHR 0x8254
#define GL_UNKNOWN_CONTEXT_RESET_KHR 0x8255
#define GL_RESET_NOTIFICATION_STRATEGY_KHR 0x8256
#define GL_NO_RESET_NOTIFICATION_KHR 0x8261
#define GL_CONTEXT_LOST_KHR 0x0507

/* GL_OES_texture_stencil8 */

#define GL_STENCIL_INDEX_OES 0x1901
#define GL_STENCIL_INDEX8_OES 0x8D48

/* GL_APPLE_texture_format_BGRA8888 */

#define GL_BGRA_EXT 0x80E1
#define GL_BGRA8_EXT 0x93A1

/* GL_ARM_shader_framebuffer_fetch */

#define GL_FETCH_PER_SAMPLE_ARM 0x8F65
#define GL_FRAGMENT_SHADER_FRAMEBUFFER_FETCH_MRT_ARM 0x8F66

/* GL_EXT_texture_filter_anisotropic */

#define GL_TEXTURE_MAX_ANISOTROPY_EXT 0x84FE
#define GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT 0x84FF

/* GL_EXT_texture_format_BGRA8888 */

#define GL_BGRA_EXT 0x80E1

/* GL_EXT_read_format_bgra */

#define GL_BGRA_EXT 0x80E1
#define GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT 0x8365
#define GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT 0x8366

/* GL_EXT_debug_label */

#define GL_PROGRAM_PIPELINE_OBJECT_EXT 0x8A4F
#define GL_PROGRAM_OBJECT_EXT 0x8B40
#define GL_SHADER_OBJECT_EXT 0x8B48
#define GL_BUFFER_OBJECT_EXT 0x9151
#define GL_QUERY_OBJECT_EXT 0x9153
#define GL_VERTEX_ARRAY_OBJECT_EXT 0x9154
#define GL_SAMPLER 0x82E6
#define GL_TRANSFORM_FEEDBACK 0x8E22

/* GL_EXT_separate_shader_objects */

#define GL_VERTEX_SHADER_BIT_EXT 0x00000001
#define GL_FRAGMENT_SHADER_BIT_EXT 0x00000002
#define GL_ALL_SHADER_BITS_EXT 0xFFFFFFFF
#define GL_PROGRAM_SEPARABLE_EXT 0x8258
#define GL_ACTIVE_PROGRAM_EXT 0x8259
#define GL_PROGRAM_PIPELINE_BINDING_EXT 0x825A

/* GL_EXT_multisampled_render_to_texture */

#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT 0x8D6C
#define GL_RENDERBUFFER_SAMPLES_EXT 0x8CAB
#define GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT 0x8D56
#define GL_MAX_SAMPLES_EXT 0x8D57

/* GL_EXT_robustness */

#define GL_NO_ERROR 0
#define GL_GUILTY_CONTEXT_RESET_EXT 0x8253
#define GL_INNOCENT_CONTEXT_RESET_EXT 0x8254
#define GL_UNKNOWN_CONTEXT_RESET_EXT 0x8255
#define GL_CONTEXT_ROBUST_ACCESS_EXT 0x90F3
#define GL_RESET_NOTIFICATION_STRATEGY_EXT 0x8256
#define GL_LOSE_CONTEXT_ON_RESET_EXT 0x8252
#define GL_NO_RESET_NOTIFICATION_EXT 0x8261

/* GL_EXT_shader_framebuffer_fetch */

#define GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT 0x8A52

/* GL_EXT_disjoint_timer_query */

#define GL_QUERY_COUNTER_BITS_EXT 0x8864
#define GL_CURRENT_QUERY_EXT 0x8865
#define GL_QUERY_RESULT_EXT 0x8866
#define GL_QUERY_RESULT_AVAILABLE_EXT 0x8867
#define GL_TIME_ELAPSED_EXT 0x88BF
#define GL_TIMESTAMP_EXT 0x8E28
#define GL_GPU_DISJOINT_EXT 0x8FBB

/* GL_EXT_texture_sRGB_decode */

#define GL_TEXTURE_SRGB_DECODE_EXT 0x8A48
#define GL_DECODE_EXT 0x8A49
#define GL_SKIP_DECODE_EXT 0x8A4A

/* GL_EXT_sRGB_write_control */

#define GL_FRAMEBUFFER_SRGB_EXT 0x8DB9

/* GL_EXT_texture_compression_s3tc */

#define GL_COMPRESSED_RGB_S3TC_DXT1_EXT 0x83F0
#define GL_COMPRESSED_RGBA_S3TC_DXT1_EXT 0x83F1
#define GL_COMPRESSED_RGBA_S3TC_DXT3_EXT 0x83F2
#define GL_COMPRESSED_RGBA_S3TC_DXT5_EXT 0x83F3

/* GL_EXT_pvrtc_sRGB */

#define GL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT 0x8A54
#define GL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT 0x8A55
#define GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT 0x8A56
#define GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT 0x8A57
#define GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG 0x93F0
#define GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG 0x93F1

/* GL_EXT_texture_sRGB_R8 */

#define GL_SR8_EXT 0x8FBD

/* GL_EXT_texture_sRGB_RG8 */

#define GL_SRG8_EXT 0x8FBE

/* GL_EXT_polygon_offset_clamp */

#define GL_POLYGON_OFFSET_CLAMP_EXT 0x8E1B

/* GL_EXT_texture_compression_s3tc_srgb */

#define GL_COMPRESSED_SRGB_S3TC_DXT1_EXT 0x8C4C
#define GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT 0x8C4D
#define GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT 0x8C4E
#define GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT 0x8C4F

/* GL_IMG_texture_compression_pvrtc */

#define GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG 0x8C00
#define GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG 0x8C01
#define GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG 0x8C02
#define GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG 0x8C03

/* GL_KHR_blend_equation_advanced_coherent */

#define GL_BLEND_ADVANCED_COHERENT_KHR 0x9285

/* GL_KHR_context_flush_control */

#define GL_CONTEXT_RELEASE_BEHAVIOR_KHR 0x82FB
#define GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR 0x82FC
#define GL_NONE 0

/* GL_KHR_no_error */

#define GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR 0x00000008

/* GL_NV_texture_border_clamp */

#define GL_TEXTURE_BORDER_COLOR_NV 0x1004
#define GL_CLAMP_TO_BORDER_NV 0x812D

/* GL_NV_sample_locations */

#define GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV 0x933D
#define GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV 0x933E
#define GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV 0x933F
#define GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV 0x9340
#define GL_SAMPLE_LOCATION_NV 0x8E50
#define GL_PROGRAMMABLE_SAMPLE_LOCATION_NV 0x9341
#define GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV 0x9342
#define GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV 0x9343

/* GL_NV_polygon_mode */

#define GL_POLYGON_MODE_NV 0x0B40
#define GL_POLYGON_OFFSET_POINT_NV 0x2A01
#define GL_POLYGON_OFFSET_LINE_NV 0x2A02
#define GL_POINT_NV 0x1B00
#define GL_LINE_NV 0x1B01
#define GL_FILL_NV 0x1B02

/* GL_OES_depth32 */

#define GL_DEPTH_COMPONENT32_OES 0x81A7

/* GL_OES_mapbuffer */

#define GL_WRITE_ONLY_OES 0x88B9
#define GL_BUFFER_ACCESS_OES 0x88BB
#define GL_BUFFER_MAPPED_OES 0x88BC
#define GL_BUFFER_MAP_POINTER_OES 0x88BD

/* GL_OES_stencil1 */

#define GL_STENCIL_INDEX1_OES 0x8D46

/* GL_OES_stencil4 */

#define GL_STENCIL_INDEX4_OES 0x8D47

/* Function prototypes. First an intersection of GL 1.0 / 1.1 functions that
   are also available in ES 2.0, which we can access directly. */

/* GL_ES_VERSION_2_0 */

GLAPI FLEXTGL_EXPORT void APIENTRY glBindTexture(GLenum, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glBlendFunc(GLenum, GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glClear(GLbitfield);
GLAPI FLEXTGL_EXPORT void APIENTRY glClearColor(GLfloat, GLfloat, GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glClearStencil(GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glColorMask(GLboolean, GLboolean, GLboolean, GLboolean);
GLAPI FLEXTGL_EXPORT void APIENTRY glCopyTexImage2D(GLenum, GLint, GLenum, GLint, GLint, GLsizei, GLsizei, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glCopyTexSubImage2D(GLenum, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glCullFace(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glDeleteTextures(GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glDepthFunc(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glDepthMask(GLboolean);
GLAPI FLEXTGL_EXPORT void APIENTRY glDisable(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glDrawArrays(GLenum, GLint, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glDrawElements(GLenum, GLsizei, GLenum, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glEnable(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glFinish(void);
GLAPI FLEXTGL_EXPORT void APIENTRY glFlush(void);
GLAPI FLEXTGL_EXPORT void APIENTRY glFrontFace(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glGenTextures(GLsizei, GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetBooleanv(GLenum, GLboolean *);
GLAPI FLEXTGL_EXPORT GLenum APIENTRY glGetError(void);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetFloatv(GLenum, GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetIntegerv(GLenum, GLint *);
GLAPI FLEXTGL_EXPORT const GLubyte * APIENTRY glGetString(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetTexParameterfv(GLenum, GLenum, GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetTexParameteriv(GLenum, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glHint(GLenum, GLenum);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsEnabled(GLenum);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsTexture(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glLineWidth(GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glPixelStorei(GLenum, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glPolygonOffset(GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glReadPixels(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glScissor(GLint, GLint, GLsizei, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glStencilFunc(GLenum, GLint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glStencilMask(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glStencilOp(GLenum, GLenum, GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexImage2D(GLenum, GLint, GLint, GLsizei, GLsizei, GLint, GLenum, GLenum, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexParameterf(GLenum, GLenum, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexParameterfv(GLenum, GLenum, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexParameteri(GLenum, GLenum, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexParameteriv(GLenum, GLenum, const GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexSubImage2D(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glViewport(GLint, GLint, GLsizei, GLsizei);

/* Dynamically-loaded function prototypes put into a struct in order to handle
   thread-localness and globals unique across shared libs, this also means way
   less symbols is exported, saving on binary size. */
struct FlextGL {

    /* GL_ANGLE_framebuffer_blit */

    void(APIENTRY *BlitFramebufferANGLE)(GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLbitfield, GLenum);

    /* GL_ANGLE_framebuffer_multisample */

    void(APIENTRY *RenderbufferStorageMultisampleANGLE)(GLenum, GLsizei, GLenum, GLsizei, GLsizei);

    /* GL_ANGLE_instanced_arrays */

    void(APIENTRY *DrawArraysInstancedANGLE)(GLenum, GLint, GLsizei, GLsizei);
    void(APIENTRY *DrawElementsInstancedANGLE)(GLenum, GLsizei, GLenum, const void *, GLsizei);
    void(APIENTRY *VertexAttribDivisorANGLE)(GLuint, GLuint);

    /* GL_APPLE_framebuffer_multisample */

    void(APIENTRY *RenderbufferStorageMultisampleAPPLE)(GLenum, GLsizei, GLenum, GLsizei, GLsizei);
    void(APIENTRY *ResolveMultisampleFramebufferAPPLE)(void);

    /* GL_ES_VERSION_2_0 */

    void(APIENTRY *ActiveTexture)(GLenum);
    void(APIENTRY *AttachShader)(GLuint, GLuint);
    void(APIENTRY *BindAttribLocation)(GLuint, GLuint, const GLchar *);
    void(APIENTRY *BindBuffer)(GLenum, GLuint);
    void(APIENTRY *BindFramebuffer)(GLenum, GLuint);
    void(APIENTRY *BindRenderbuffer)(GLenum, GLuint);
    void(APIENTRY *BlendColor)(GLfloat, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *BlendEquation)(GLenum);
    void(APIENTRY *BlendEquationSeparate)(GLenum, GLenum);
    void(APIENTRY *BlendFuncSeparate)(GLenum, GLenum, GLenum, GLenum);
    void(APIENTRY *BufferData)(GLenum, GLsizeiptr, const void *, GLenum);
    void(APIENTRY *BufferSubData)(GLenum, GLintptr, GLsizeiptr, const void *);
    GLenum(APIENTRY *CheckFramebufferStatus)(GLenum);
    void(APIENTRY *ClearDepthf)(GLfloat);
    void(APIENTRY *CompileShader)(GLuint);
    void(APIENTRY *CompressedTexImage2D)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const void *);
    void(APIENTRY *CompressedTexSubImage2D)(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const void *);
    GLuint(APIENTRY *CreateProgram)(void);
    GLuint(APIENTRY *CreateShader)(GLenum);
    void(APIENTRY *DeleteBuffers)(GLsizei, const GLuint *);
    void(APIENTRY *DeleteFramebuffers)(GLsizei, const GLuint *);
    void(APIENTRY *DeleteProgram)(GLuint);
    void(APIENTRY *DeleteRenderbuffers)(GLsizei, const GLuint *);
    void(APIENTRY *DeleteShader)(GLuint);
    void(APIENTRY *DepthRangef)(GLfloat, GLfloat);
    void(APIENTRY *DetachShader)(GLuint, GLuint);
    void(APIENTRY *DisableVertexAttribArray)(GLuint);
    void(APIENTRY *EnableVertexAttribArray)(GLuint);
    void(APIENTRY *FramebufferRenderbuffer)(GLenum, GLenum, GLenum, GLuint);
    void(APIENTRY *FramebufferTexture2D)(GLenum, GLenum, GLenum, GLuint, GLint);
    void(APIENTRY *GenBuffers)(GLsizei, GLuint *);
    void(APIENTRY *GenFramebuffers)(GLsizei, GLuint *);
    void(APIENTRY *GenRenderbuffers)(GLsizei, GLuint *);
    void(APIENTRY *GenerateMipmap)(GLenum);
    void(APIENTRY *GetActiveAttrib)(GLuint, GLuint, GLsizei, GLsizei *, GLint *, GLenum *, GLchar *);
    void(APIENTRY *GetActiveUniform)(GLuint, GLuint, GLsizei, GLsizei *, GLint *, GLenum *, GLchar *);
    void(APIENTRY *GetAttachedShaders)(GLuint, GLsizei, GLsizei *, GLuint *);
    GLint(APIENTRY *GetAttribLocation)(GLuint, const GLchar *);
    void(APIENTRY *GetBufferParameteriv)(GLenum, GLenum, GLint *);
    void(APIENTRY *GetFramebufferAttachmentParameteriv)(GLenum, GLenum, GLenum, GLint *);
    void(APIENTRY *GetProgramInfoLog)(GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetProgramiv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetRenderbufferParameteriv)(GLenum, GLenum, GLint *);
    void(APIENTRY *GetShaderInfoLog)(GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetShaderPrecisionFormat)(GLenum, GLenum, GLint *, GLint *);
    void(APIENTRY *GetShaderSource)(GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetShaderiv)(GLuint, GLenum, GLint *);
    GLint(APIENTRY *GetUniformLocation)(GLuint, const GLchar *);
    void(APIENTRY *GetUniformfv)(GLuint, GLint, GLfloat *);
    void(APIENTRY *GetUniformiv)(GLuint, GLint, GLint *);
    void(APIENTRY *GetVertexAttribPointerv)(GLuint, GLenum, void **);
    void(APIENTRY *GetVertexAttribfv)(GLuint, GLenum, GLfloat *);
    void(APIENTRY *GetVertexAttribiv)(GLuint, GLenum, GLint *);
    GLboolean(APIENTRY *IsBuffer)(GLuint);
    GLboolean(APIENTRY *IsFramebuffer)(GLuint);
    GLboolean(APIENTRY *IsProgram)(GLuint);
    GLboolean(APIENTRY *IsRenderbuffer)(GLuint);
    GLboolean(APIENTRY *IsShader)(GLuint);
    void(APIENTRY *LinkProgram)(GLuint);
    void(APIENTRY *ReleaseShaderCompiler)(void);
    void(APIENTRY *RenderbufferStorage)(GLenum, GLenum, GLsizei, GLsizei);
    void(APIENTRY *SampleCoverage)(GLfloat, GLboolean);
    void(APIENTRY *ShaderBinary)(GLsizei, const GLuint *, GLenum, const void *, GLsizei);
    void(APIENTRY *ShaderSource)(GLuint, GLsizei, const GLchar *const*, const GLint *);
    void(APIENTRY *StencilFuncSeparate)(GLenum, GLenum, GLint, GLuint);
    void(APIENTRY *StencilMaskSeparate)(GLenum, GLuint);
    void(APIENTRY *StencilOpSeparate)(GLenum, GLenum, GLenum, GLenum);
    void(APIENTRY *Uniform1f)(GLint, GLfloat);
    void(APIENTRY *Uniform1fv)(GLint, GLsizei, const GLfloat *);
    void(APIENTRY *Uniform1i)(GLint, GLint);
    void(APIENTRY *Uniform1iv)(GLint, GLsizei, const GLint *);
    void(APIENTRY *Uniform2f)(GLint, GLfloat, GLfloat);
    void(APIENTRY *Uniform2fv)(GLint, GLsizei, const GLfloat *);
    void(APIENTRY *Uniform2i)(GLint, GLint, GLint);
    void(APIENTRY *Uniform2iv)(GLint, GLsizei, const GLint *);
    void(APIENTRY *Uniform3f)(GLint, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *Uniform3fv)(GLint, GLsizei, const GLfloat *);
    void(APIENTRY *Uniform3i)(GLint, GLint, GLint, GLint);
    void(APIENTRY *Uniform3iv)(GLint, GLsizei, const GLint *);
    void(APIENTRY *Uniform4f)(GLint, GLfloat, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *Uniform4fv)(GLint, GLsizei, const GLfloat *);
    void(APIENTRY *Uniform4i)(GLint, GLint, GLint, GLint, GLint);
    void(APIENTRY *Uniform4iv)(GLint, GLsizei, const GLint *);
    void(APIENTRY *UniformMatrix2fv)(GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *UniformMatrix3fv)(GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *UniformMatrix4fv)(GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *UseProgram)(GLuint);
    void(APIENTRY *ValidateProgram)(GLuint);
    void(APIENTRY *VertexAttrib1f)(GLuint, GLfloat);
    void(APIENTRY *VertexAttrib1fv)(GLuint, const GLfloat *);
    void(APIENTRY *VertexAttrib2f)(GLuint, GLfloat, GLfloat);
    void(APIENTRY *VertexAttrib2fv)(GLuint, const GLfloat *);
    void(APIENTRY *VertexAttrib3f)(GLuint, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *VertexAttrib3fv)(GLuint, const GLfloat *);
    void(APIENTRY *VertexAttrib4f)(GLuint, GLfloat, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *VertexAttrib4fv)(GLuint, const GLfloat *);
    void(APIENTRY *VertexAttribPointer)(GLuint, GLint, GLenum, GLboolean, GLsizei, const void *);

    /* GL_EXT_debug_label */

    void(APIENTRY *GetObjectLabelEXT)(GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *LabelObjectEXT)(GLenum, GLuint, GLsizei, const GLchar *);

    /* GL_EXT_debug_marker */

    void(APIENTRY *InsertEventMarkerEXT)(GLsizei, const GLchar *);
    void(APIENTRY *PopGroupMarkerEXT)(void);
    void(APIENTRY *PushGroupMarkerEXT)(GLsizei, const GLchar *);

    /* GL_EXT_discard_framebuffer */

    void(APIENTRY *DiscardFramebufferEXT)(GLenum, GLsizei, const GLenum *);

    /* GL_EXT_disjoint_timer_query */

    void(APIENTRY *GetInteger64vEXT)(GLenum, GLint64 *);
    void(APIENTRY *GetQueryObjecti64vEXT)(GLuint, GLenum, GLint64 *);
    void(APIENTRY *GetQueryObjectivEXT)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetQueryObjectui64vEXT)(GLuint, GLenum, GLuint64 *);
    void(APIENTRY *QueryCounterEXT)(GLuint, GLenum);

    /* GL_EXT_draw_buffers */

    void(APIENTRY *DrawBuffersEXT)(GLsizei, const GLenum *);

    /* GL_EXT_draw_buffers_indexed */

    void(APIENTRY *BlendEquationSeparateiEXT)(GLuint, GLenum, GLenum);
    void(APIENTRY *BlendEquationiEXT)(GLuint, GLenum);
    void(APIENTRY *BlendFuncSeparateiEXT)(GLuint, GLenum, GLenum, GLenum, GLenum);
    void(APIENTRY *BlendFunciEXT)(GLuint, GLenum, GLenum);
    void(APIENTRY *ColorMaskiEXT)(GLuint, GLboolean, GLboolean, GLboolean, GLboolean);
    void(APIENTRY *DisableiEXT)(GLenum, GLuint);
    void(APIENTRY *EnableiEXT)(GLenum, GLuint);
    GLboolean(APIENTRY *IsEnablediEXT)(GLenum, GLuint);

    /* GL_EXT_instanced_arrays */

    void(APIENTRY *DrawArraysInstancedEXT)(GLenum, GLint, GLsizei, GLsizei);
    void(APIENTRY *DrawElementsInstancedEXT)(GLenum, GLsizei, GLenum, const void *, GLsizei);
    void(APIENTRY *VertexAttribDivisorEXT)(GLuint, GLuint);

    /* GL_EXT_map_buffer_range */

    void(APIENTRY *FlushMappedBufferRangeEXT)(GLenum, GLintptr, GLsizeiptr);
    void *(APIENTRY *MapBufferRangeEXT)(GLenum, GLintptr, GLsizeiptr, GLbitfield);

    /* GL_EXT_multi_draw_arrays */

    void(APIENTRY *MultiDrawArraysEXT)(GLenum, const GLint *, const GLsizei *, GLsizei);
    void(APIENTRY *MultiDrawElementsEXT)(GLenum, const GLsizei *, GLenum, const void *const*, GLsizei);

    /* GL_EXT_multisampled_render_to_texture */

    void(APIENTRY *FramebufferTexture2DMultisampleEXT)(GLenum, GLenum, GLenum, GLuint, GLint, GLsizei);
    void(APIENTRY *RenderbufferStorageMultisampleEXT)(GLenum, GLsizei, GLenum, GLsizei, GLsizei);

    /* GL_EXT_occlusion_query_boolean */

    void(APIENTRY *BeginQueryEXT)(GLenum, GLuint);
    void(APIENTRY *DeleteQueriesEXT)(GLsizei, const GLuint *);
    void(APIENTRY *EndQueryEXT)(GLenum);
    void(APIENTRY *GenQueriesEXT)(GLsizei, GLuint *);
    void(APIENTRY *GetQueryObjectuivEXT)(GLuint, GLenum, GLuint *);
    void(APIENTRY *GetQueryivEXT)(GLenum, GLenum, GLint *);
    GLboolean(APIENTRY *IsQueryEXT)(GLuint);

    /* GL_EXT_polygon_offset_clamp */

    void(APIENTRY *PolygonOffsetClampEXT)(GLfloat, GLfloat, GLfloat);

    /* GL_EXT_robustness */

    GLenum(APIENTRY *GetGraphicsResetStatusEXT)(void);
    void(APIENTRY *GetnUniformfvEXT)(GLuint, GLint, GLsizei, GLfloat *);
    void(APIENTRY *GetnUniformivEXT)(GLuint, GLint, GLsizei, GLint *);
    void(APIENTRY *ReadnPixelsEXT)(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, GLsizei, void *);

    /* GL_EXT_separate_shader_objects */

    void(APIENTRY *ActiveShaderProgramEXT)(GLuint, GLuint);
    void(APIENTRY *BindProgramPipelineEXT)(GLuint);
    GLuint(APIENTRY *CreateShaderProgramvEXT)(GLenum, GLsizei, const GLchar **);
    void(APIENTRY *DeleteProgramPipelinesEXT)(GLsizei, const GLuint *);
    void(APIENTRY *GenProgramPipelinesEXT)(GLsizei, GLuint *);
    void(APIENTRY *GetProgramPipelineInfoLogEXT)(GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetProgramPipelineivEXT)(GLuint, GLenum, GLint *);
    GLboolean(APIENTRY *IsProgramPipelineEXT)(GLuint);
    void(APIENTRY *ProgramParameteriEXT)(GLuint, GLenum, GLint);
    void(APIENTRY *ProgramUniform1fEXT)(GLuint, GLint, GLfloat);
    void(APIENTRY *ProgramUniform1fvEXT)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform1iEXT)(GLuint, GLint, GLint);
    void(APIENTRY *ProgramUniform1ivEXT)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform2fEXT)(GLuint, GLint, GLfloat, GLfloat);
    void(APIENTRY *ProgramUniform2fvEXT)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform2iEXT)(GLuint, GLint, GLint, GLint);
    void(APIENTRY *ProgramUniform2ivEXT)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform3fEXT)(GLuint, GLint, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *ProgramUniform3fvEXT)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform3iEXT)(GLuint, GLint, GLint, GLint, GLint);
    void(APIENTRY *ProgramUniform3ivEXT)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform4fEXT)(GLuint, GLint, GLfloat, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *ProgramUniform4fvEXT)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform4iEXT)(GLuint, GLint, GLint, GLint, GLint, GLint);
    void(APIENTRY *ProgramUniform4ivEXT)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniformMatrix2fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix3fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix4fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *UseProgramStagesEXT)(GLuint, GLbitfield, GLuint);
    void(APIENTRY *ValidateProgramPipelineEXT)(GLuint);

    /* GL_EXT_texture_border_clamp */

    void(APIENTRY *GetSamplerParameterIivEXT)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetSamplerParameterIuivEXT)(GLuint, GLenum, GLuint *);
    void(APIENTRY *GetTexParameterIivEXT)(GLenum, GLenum, GLint *);
    void(APIENTRY *GetTexParameterIuivEXT)(GLenum, GLenum, GLuint *);
    void(APIENTRY *SamplerParameterIivEXT)(GLuint, GLenum, const GLint *);
    void(APIENTRY *SamplerParameterIuivEXT)(GLuint, GLenum, const GLuint *);
    void(APIENTRY *TexParameterIivEXT)(GLenum, GLenum, const GLint *);
    void(APIENTRY *TexParameterIuivEXT)(GLenum, GLenum, const GLuint *);

    /* GL_EXT_texture_storage */

    void(APIENTRY *TexStorage2DEXT)(GLenum, GLsizei, GLenum, GLsizei, GLsizei);
    void(APIENTRY *TexStorage3DEXT)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLsizei);

    /* GL_KHR_blend_equation_advanced */

    void(APIENTRY *BlendBarrierKHR)(void);

    /* GL_KHR_debug */

    void(APIENTRY *DebugMessageCallbackKHR)(GLDEBUGPROCKHR, const void *);
    void(APIENTRY *DebugMessageControlKHR)(GLenum, GLenum, GLenum, GLsizei, const GLuint *, GLboolean);
    void(APIENTRY *DebugMessageInsertKHR)(GLenum, GLenum, GLuint, GLenum, GLsizei, const GLchar *);
    GLuint(APIENTRY *GetDebugMessageLogKHR)(GLuint, GLsizei, GLenum *, GLenum *, GLuint *, GLenum *, GLsizei *, GLchar *);
    void(APIENTRY *GetObjectLabelKHR)(GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetObjectPtrLabelKHR)(const void *, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetPointervKHR)(GLenum, void **);
    void(APIENTRY *ObjectLabelKHR)(GLenum, GLuint, GLsizei, const GLchar *);
    void(APIENTRY *ObjectPtrLabelKHR)(const void *, GLsizei, const GLchar *);
    void(APIENTRY *PopDebugGroupKHR)(void);
    void(APIENTRY *PushDebugGroupKHR)(GLenum, GLuint, GLsizei, const GLchar *);

    /* GL_KHR_robustness */

    GLenum(APIENTRY *GetGraphicsResetStatusKHR)(void);
    void(APIENTRY *GetnUniformfvKHR)(GLuint, GLint, GLsizei, GLfloat *);
    void(APIENTRY *GetnUniformivKHR)(GLuint, GLint, GLsizei, GLint *);
    void(APIENTRY *GetnUniformuivKHR)(GLuint, GLint, GLsizei, GLuint *);
    void(APIENTRY *ReadnPixelsKHR)(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, GLsizei, void *);

    /* GL_NV_draw_buffers */

    void(APIENTRY *DrawBuffersNV)(GLsizei, const GLenum *);

    /* GL_NV_draw_instanced */

    void(APIENTRY *DrawArraysInstancedNV)(GLenum, GLint, GLsizei, GLsizei);
    void(APIENTRY *DrawElementsInstancedNV)(GLenum, GLsizei, GLenum, const void *, GLsizei);

    /* GL_NV_framebuffer_blit */

    void(APIENTRY *BlitFramebufferNV)(GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLbitfield, GLenum);

    /* GL_NV_framebuffer_multisample */

    void(APIENTRY *RenderbufferStorageMultisampleNV)(GLenum, GLsizei, GLenum, GLsizei, GLsizei);

    /* GL_NV_instanced_arrays */

    void(APIENTRY *VertexAttribDivisorNV)(GLuint, GLuint);

    /* GL_NV_polygon_mode */

    void(APIENTRY *PolygonModeNV)(GLenum, GLenum);

    /* GL_NV_read_buffer */

    void(APIENTRY *ReadBufferNV)(GLenum);

    /* GL_NV_sample_locations */

    void(APIENTRY *FramebufferSampleLocationsfvNV)(GLenum, GLuint, GLsizei, const GLfloat *);
    void(APIENTRY *NamedFramebufferSampleLocationsfvNV)(GLuint, GLuint, GLsizei, const GLfloat *);
    void(APIENTRY *ResolveDepthValuesNV)(void);

    /* GL_OES_mapbuffer */

    void(APIENTRY *GetBufferPointervOES)(GLenum, GLenum, void **);
    void *(APIENTRY *MapBufferOES)(GLenum, GLenum);
    GLboolean(APIENTRY *UnmapBufferOES)(GLenum);

    /* GL_OES_texture_3D */

    void(APIENTRY *CompressedTexImage3DOES)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const void *);
    void(APIENTRY *CompressedTexSubImage3DOES)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void *);
    void(APIENTRY *CopyTexSubImage3DOES)(GLenum, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
    void(APIENTRY *FramebufferTexture3DOES)(GLenum, GLenum, GLenum, GLuint, GLint, GLint);
    void(APIENTRY *TexImage3DOES)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLenum, GLenum, const void *);
    void(APIENTRY *TexSubImage3DOES)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void *);

    /* GL_OES_vertex_array_object */

    void(APIENTRY *BindVertexArrayOES)(GLuint);
    void(APIENTRY *DeleteVertexArraysOES)(GLsizei, const GLuint *);
    void(APIENTRY *GenVertexArraysOES)(GLsizei, GLuint *);
    GLboolean(APIENTRY *IsVertexArrayOES)(GLuint);
};

extern FLEXTGL_EXPORT FlextGL flextGL;

/* GL_ANGLE_framebuffer_blit */

#define glBlitFramebufferANGLE flextGL.BlitFramebufferANGLE

/* GL_ANGLE_framebuffer_multisample */

#define glRenderbufferStorageMultisampleANGLE flextGL.RenderbufferStorageMultisampleANGLE

/* GL_ANGLE_instanced_arrays */

#define glDrawArraysInstancedANGLE flextGL.DrawArraysInstancedANGLE
#define glDrawElementsInstancedANGLE flextGL.DrawElementsInstancedANGLE
#define glVertexAttribDivisorANGLE flextGL.VertexAttribDivisorANGLE

/* GL_APPLE_framebuffer_multisample */

#define glRenderbufferStorageMultisampleAPPLE flextGL.RenderbufferStorageMultisampleAPPLE
#define glResolveMultisampleFramebufferAPPLE flextGL.ResolveMultisampleFramebufferAPPLE

/* GL_ES_VERSION_2_0 */

#define glActiveTexture flextGL.ActiveTexture
#define glAttachShader flextGL.AttachShader
#define glBindAttribLocation flextGL.BindAttribLocation
#define glBindBuffer flextGL.BindBuffer
#define glBindFramebuffer flextGL.BindFramebuffer
#define glBindRenderbuffer flextGL.BindRenderbuffer
#define glBlendColor flextGL.BlendColor
#define glBlendEquation flextGL.BlendEquation
#define glBlendEquationSeparate flextGL.BlendEquationSeparate
#define glBlendFuncSeparate flextGL.BlendFuncSeparate
#define glBufferData flextGL.BufferData
#define glBufferSubData flextGL.BufferSubData
#define glCheckFramebufferStatus flextGL.CheckFramebufferStatus
#define glClearDepthf flextGL.ClearDepthf
#define glCompileShader flextGL.CompileShader
#define glCompressedTexImage2D flextGL.CompressedTexImage2D
#define glCompressedTexSubImage2D flextGL.CompressedTexSubImage2D
#define glCreateProgram flextGL.CreateProgram
#define glCreateShader flextGL.CreateShader
#define glDeleteBuffers flextGL.DeleteBuffers
#define glDeleteFramebuffers flextGL.DeleteFramebuffers
#define glDeleteProgram flextGL.DeleteProgram
#define glDeleteRenderbuffers flextGL.DeleteRenderbuffers
#define glDeleteShader flextGL.DeleteShader
#define glDepthRangef flextGL.DepthRangef
#define glDetachShader flextGL.DetachShader
#define glDisableVertexAttribArray flextGL.DisableVertexAttribArray
#define glEnableVertexAttribArray flextGL.EnableVertexAttribArray
#define glFramebufferRenderbuffer flextGL.FramebufferRenderbuffer
#define glFramebufferTexture2D flextGL.FramebufferTexture2D
#define glGenBuffers flextGL.GenBuffers
#define glGenFramebuffers flextGL.GenFramebuffers
#define glGenRenderbuffers flextGL.GenRenderbuffers
#define glGenerateMipmap flextGL.GenerateMipmap
#define glGetActiveAttrib flextGL.GetActiveAttrib
#define glGetActiveUniform flextGL.GetActiveUniform
#define glGetAttachedShaders flextGL.GetAttachedShaders
#define glGetAttribLocation flextGL.GetAttribLocation
#define glGetBufferParameteriv flextGL.GetBufferParameteriv
#define glGetFramebufferAttachmentParameteriv flextGL.GetFramebufferAttachmentParameteriv
#define glGetProgramInfoLog flextGL.GetProgramInfoLog
#define glGetProgramiv flextGL.GetProgramiv
#define glGetRenderbufferParameteriv flextGL.GetRenderbufferParameteriv
#define glGetShaderInfoLog flextGL.GetShaderInfoLog
#define glGetShaderPrecisionFormat flextGL.GetShaderPrecisionFormat
#define glGetShaderSource flextGL.GetShaderSource
#define glGetShaderiv flextGL.GetShaderiv
#define glGetUniformLocation flextGL.GetUniformLocation
#define glGetUniformfv flextGL.GetUniformfv
#define glGetUniformiv flextGL.GetUniformiv
#define glGetVertexAttribPointerv flextGL.GetVertexAttribPointerv
#define glGetVertexAttribfv flextGL.GetVertexAttribfv
#define glGetVertexAttribiv flextGL.GetVertexAttribiv
#define glIsBuffer flextGL.IsBuffer
#define glIsFramebuffer flextGL.IsFramebuffer
#define glIsProgram flextGL.IsProgram
#define glIsRenderbuffer flextGL.IsRenderbuffer
#define glIsShader flextGL.IsShader
#define glLinkProgram flextGL.LinkProgram
#define glReleaseShaderCompiler flextGL.ReleaseShaderCompiler
#define glRenderbufferStorage flextGL.RenderbufferStorage
#define glSampleCoverage flextGL.SampleCoverage
#define glShaderBinary flextGL.ShaderBinary
#define glShaderSource flextGL.ShaderSource
#define glStencilFuncSeparate flextGL.StencilFuncSeparate
#define glStencilMaskSeparate flextGL.StencilMaskSeparate
#define glStencilOpSeparate flextGL.StencilOpSeparate
#define glUniform1f flextGL.Uniform1f
#define glUniform1fv flextGL.Uniform1fv
#define glUniform1i flextGL.Uniform1i
#define glUniform1iv flextGL.Uniform1iv
#define glUniform2f flextGL.Uniform2f
#define glUniform2fv flextGL.Uniform2fv
#define glUniform2i flextGL.Uniform2i
#define glUniform2iv flextGL.Uniform2iv
#define glUniform3f flextGL.Uniform3f
#define glUniform3fv flextGL.Uniform3fv
#define glUniform3i flextGL.Uniform3i
#define glUniform3iv flextGL.Uniform3iv
#define glUniform4f flextGL.Uniform4f
#define glUniform4fv flextGL.Uniform4fv
#define glUniform4i flextGL.Uniform4i
#define glUniform4iv flextGL.Uniform4iv
#define glUniformMatrix2fv flextGL.UniformMatrix2fv
#define glUniformMatrix3fv flextGL.UniformMatrix3fv
#define glUniformMatrix4fv flextGL.UniformMatrix4fv
#define glUseProgram flextGL.UseProgram
#define glValidateProgram flextGL.ValidateProgram
#define glVertexAttrib1f flextGL.VertexAttrib1f
#define glVertexAttrib1fv flextGL.VertexAttrib1fv
#define glVertexAttrib2f flextGL.VertexAttrib2f
#define glVertexAttrib2fv flextGL.VertexAttrib2fv
#define glVertexAttrib3f flextGL.VertexAttrib3f
#define glVertexAttrib3fv flextGL.VertexAttrib3fv
#define glVertexAttrib4f flextGL.VertexAttrib4f
#define glVertexAttrib4fv flextGL.VertexAttrib4fv
#define glVertexAttribPointer flextGL.VertexAttribPointer

/* GL_EXT_debug_label */

#define glGetObjectLabelEXT flextGL.GetObjectLabelEXT
#define glLabelObjectEXT flextGL.LabelObjectEXT

/* GL_EXT_debug_marker */

#define glInsertEventMarkerEXT flextGL.InsertEventMarkerEXT
#define glPopGroupMarkerEXT flextGL.PopGroupMarkerEXT
#define glPushGroupMarkerEXT flextGL.PushGroupMarkerEXT

/* GL_EXT_discard_framebuffer */

#define glDiscardFramebufferEXT flextGL.DiscardFramebufferEXT

/* GL_EXT_disjoint_timer_query */

#define glGetInteger64vEXT flextGL.GetInteger64vEXT
#define glGetQueryObjecti64vEXT flextGL.GetQueryObjecti64vEXT
#define glGetQueryObjectivEXT flextGL.GetQueryObjectivEXT
#define glGetQueryObjectui64vEXT flextGL.GetQueryObjectui64vEXT
#define glQueryCounterEXT flextGL.QueryCounterEXT

/* GL_EXT_draw_buffers */

#define glDrawBuffersEXT flextGL.DrawBuffersEXT

/* GL_EXT_draw_buffers_indexed */

#define glBlendEquationSeparateiEXT flextGL.BlendEquationSeparateiEXT
#define glBlendEquationiEXT flextGL.BlendEquationiEXT
#define glBlendFuncSeparateiEXT flextGL.BlendFuncSeparateiEXT
#define glBlendFunciEXT flextGL.BlendFunciEXT
#define glColorMaskiEXT flextGL.ColorMaskiEXT
#define glDisableiEXT flextGL.DisableiEXT
#define glEnableiEXT flextGL.EnableiEXT
#define glIsEnablediEXT flextGL.IsEnablediEXT

/* GL_EXT_instanced_arrays */

#define glDrawArraysInstancedEXT flextGL.DrawArraysInstancedEXT
#define glDrawElementsInstancedEXT flextGL.DrawElementsInstancedEXT
#define glVertexAttribDivisorEXT flextGL.VertexAttribDivisorEXT

/* GL_EXT_map_buffer_range */

#define glFlushMappedBufferRangeEXT flextGL.FlushMappedBufferRangeEXT
#define glMapBufferRangeEXT flextGL.MapBufferRangeEXT

/* GL_EXT_multi_draw_arrays */

#define glMultiDrawArraysEXT flextGL.MultiDrawArraysEXT
#define glMultiDrawElementsEXT flextGL.MultiDrawElementsEXT

/* GL_EXT_multisampled_render_to_texture */

#define glFramebufferTexture2DMultisampleEXT flextGL.FramebufferTexture2DMultisampleEXT
#define glRenderbufferStorageMultisampleEXT flextGL.RenderbufferStorageMultisampleEXT

/* GL_EXT_occlusion_query_boolean */

#define glBeginQueryEXT flextGL.BeginQueryEXT
#define glDeleteQueriesEXT flextGL.DeleteQueriesEXT
#define glEndQueryEXT flextGL.EndQueryEXT
#define glGenQueriesEXT flextGL.GenQueriesEXT
#define glGetQueryObjectuivEXT flextGL.GetQueryObjectuivEXT
#define glGetQueryivEXT flextGL.GetQueryivEXT
#define glIsQueryEXT flextGL.IsQueryEXT

/* GL_EXT_polygon_offset_clamp */

#define glPolygonOffsetClampEXT flextGL.PolygonOffsetClampEXT

/* GL_EXT_robustness */

#define glGetGraphicsResetStatusEXT flextGL.GetGraphicsResetStatusEXT
#define glGetnUniformfvEXT flextGL.GetnUniformfvEXT
#define glGetnUniformivEXT flextGL.GetnUniformivEXT
#define glReadnPixelsEXT flextGL.ReadnPixelsEXT

/* GL_EXT_separate_shader_objects */

#define glActiveShaderProgramEXT flextGL.ActiveShaderProgramEXT
#define glBindProgramPipelineEXT flextGL.BindProgramPipelineEXT
#define glCreateShaderProgramvEXT flextGL.CreateShaderProgramvEXT
#define glDeleteProgramPipelinesEXT flextGL.DeleteProgramPipelinesEXT
#define glGenProgramPipelinesEXT flextGL.GenProgramPipelinesEXT
#define glGetProgramPipelineInfoLogEXT flextGL.GetProgramPipelineInfoLogEXT
#define glGetProgramPipelineivEXT flextGL.GetProgramPipelineivEXT
#define glIsProgramPipelineEXT flextGL.IsProgramPipelineEXT
#define glProgramParameteriEXT flextGL.ProgramParameteriEXT
#define glProgramUniform1fEXT flextGL.ProgramUniform1fEXT
#define glProgramUniform1fvEXT flextGL.ProgramUniform1fvEXT
#define glProgramUniform1iEXT flextGL.ProgramUniform1iEXT
#define glProgramUniform1ivEXT flextGL.ProgramUniform1ivEXT
#define glProgramUniform2fEXT flextGL.ProgramUniform2fEXT
#define glProgramUniform2fvEXT flextGL.ProgramUniform2fvEXT
#define glProgramUniform2iEXT flextGL.ProgramUniform2iEXT
#define glProgramUniform2ivEXT flextGL.ProgramUniform2ivEXT
#define glProgramUniform3fEXT flextGL.ProgramUniform3fEXT
#define glProgramUniform3fvEXT flextGL.ProgramUniform3fvEXT
#define glProgramUniform3iEXT flextGL.ProgramUniform3iEXT
#define glProgramUniform3ivEXT flextGL.ProgramUniform3ivEXT
#define glProgramUniform4fEXT flextGL.ProgramUniform4fEXT
#define glProgramUniform4fvEXT flextGL.ProgramUniform4fvEXT
#define glProgramUniform4iEXT flextGL.ProgramUniform4iEXT
#define glProgramUniform4ivEXT flextGL.ProgramUniform4ivEXT
#define glProgramUniformMatrix2fvEXT flextGL.ProgramUniformMatrix2fvEXT
#define glProgramUniformMatrix3fvEXT flextGL.ProgramUniformMatrix3fvEXT
#define glProgramUniformMatrix4fvEXT flextGL.ProgramUniformMatrix4fvEXT
#define glUseProgramStagesEXT flextGL.UseProgramStagesEXT
#define glValidateProgramPipelineEXT flextGL.ValidateProgramPipelineEXT

/* GL_EXT_texture_border_clamp */

#define glGetSamplerParameterIivEXT flextGL.GetSamplerParameterIivEXT
#define glGetSamplerParameterIuivEXT flextGL.GetSamplerParameterIuivEXT
#define glGetTexParameterIivEXT flextGL.GetTexParameterIivEXT
#define glGetTexParameterIuivEXT flextGL.GetTexParameterIuivEXT
#define glSamplerParameterIivEXT flextGL.SamplerParameterIivEXT
#define glSamplerParameterIuivEXT flextGL.SamplerParameterIuivEXT
#define glTexParameterIivEXT flextGL.TexParameterIivEXT
#define glTexParameterIuivEXT flextGL.TexParameterIuivEXT

/* GL_EXT_texture_storage */

#define glTexStorage2DEXT flextGL.TexStorage2DEXT
#define glTexStorage3DEXT flextGL.TexStorage3DEXT

/* GL_KHR_blend_equation_advanced */

#define glBlendBarrierKHR flextGL.BlendBarrierKHR

/* GL_KHR_debug */

#define glDebugMessageCallbackKHR flextGL.DebugMessageCallbackKHR
#define glDebugMessageControlKHR flextGL.DebugMessageControlKHR
#define glDebugMessageInsertKHR flextGL.DebugMessageInsertKHR
#define glGetDebugMessageLogKHR flextGL.GetDebugMessageLogKHR
#define glGetObjectLabelKHR flextGL.GetObjectLabelKHR
#define glGetObjectPtrLabelKHR flextGL.GetObjectPtrLabelKHR
#define glGetPointervKHR flextGL.GetPointervKHR
#define glObjectLabelKHR flextGL.ObjectLabelKHR
#define glObjectPtrLabelKHR flextGL.ObjectPtrLabelKHR
#define glPopDebugGroupKHR flextGL.PopDebugGroupKHR
#define glPushDebugGroupKHR flextGL.PushDebugGroupKHR

/* GL_KHR_robustness */

#define glGetGraphicsResetStatusKHR flextGL.GetGraphicsResetStatusKHR
#define glGetnUniformfvKHR flextGL.GetnUniformfvKHR
#define glGetnUniformivKHR flextGL.GetnUniformivKHR
#define glGetnUniformuivKHR flextGL.GetnUniformuivKHR
#define glReadnPixelsKHR flextGL.ReadnPixelsKHR

/* GL_NV_draw_buffers */

#define glDrawBuffersNV flextGL.DrawBuffersNV

/* GL_NV_draw_instanced */

#define glDrawArraysInstancedNV flextGL.DrawArraysInstancedNV
#define glDrawElementsInstancedNV flextGL.DrawElementsInstancedNV

/* GL_NV_framebuffer_blit */

#define glBlitFramebufferNV flextGL.BlitFramebufferNV

/* GL_NV_framebuffer_multisample */

#define glRenderbufferStorageMultisampleNV flextGL.RenderbufferStorageMultisampleNV

/* GL_NV_instanced_arrays */

#define glVertexAttribDivisorNV flextGL.VertexAttribDivisorNV

/* GL_NV_polygon_mode */

#define glPolygonModeNV flextGL.PolygonModeNV

/* GL_NV_read_buffer */

#define glReadBufferNV flextGL.ReadBufferNV

/* GL_NV_sample_locations */

#define glFramebufferSampleLocationsfvNV flextGL.FramebufferSampleLocationsfvNV
#define glNamedFramebufferSampleLocationsfvNV flextGL.NamedFramebufferSampleLocationsfvNV
#define glResolveDepthValuesNV flextGL.ResolveDepthValuesNV

/* GL_OES_mapbuffer */

#define glGetBufferPointervOES flextGL.GetBufferPointervOES
#define glMapBufferOES flextGL.MapBufferOES
#define glUnmapBufferOES flextGL.UnmapBufferOES

/* GL_OES_texture_3D */

#define glCompressedTexImage3DOES flextGL.CompressedTexImage3DOES
#define glCompressedTexSubImage3DOES flextGL.CompressedTexSubImage3DOES
#define glCopyTexSubImage3DOES flextGL.CopyTexSubImage3DOES
#define glFramebufferTexture3DOES flextGL.FramebufferTexture3DOES
#define glTexImage3DOES flextGL.TexImage3DOES
#define glTexSubImage3DOES flextGL.TexSubImage3DOES

/* GL_OES_vertex_array_object */

#define glBindVertexArrayOES flextGL.BindVertexArrayOES
#define glDeleteVertexArraysOES flextGL.DeleteVertexArraysOES
#define glGenVertexArraysOES flextGL.GenVertexArraysOES
#define glIsVertexArrayOES flextGL.IsVertexArrayOES

#ifdef __cplusplus
}
#endif

#endif
