# Node.js 22 ChangeLog

<!--lint disable maximum-line-length no-literal-urls prohibited-strings-->

<table>
<tr>
<th>Current</th>
</tr>
<tr>
<td>
<a href="#22.5.1">22.5.1</a><br/>
<a href="#22.5.0">22.5.0</a><br/>
<a href="#22.4.1">22.4.1</a><br/>
<a href="#22.4.0">22.4.0</a><br/>
<a href="#22.3.0">22.3.0</a><br/>
<a href="#22.2.0">22.2.0</a><br/>
<a href="#22.1.0">22.1.0</a><br/>
<a href="#22.0.0">22.0.0</a><br/>
</td>
</tr>
</table>

* Other Versions
  * [21.x](CHANGELOG_V21.md)
  * [20.x](CHANGELOG_V20.md)
  * [19.x](CHANGELOG_V19.md)
  * [18.x](CHANGELOG_V18.md)
  * [17.x](CHANGELOG_V17.md)
  * [16.x](CHANGELOG_V16.md)
  * [15.x](CHANGELOG_V15.md)
  * [14.x](CHANGELOG_V14.md)
  * [13.x](CHANGELOG_V13.md)
  * [12.x](CHANGELOG_V12.md)
  * [11.x](CHANGELOG_V11.md)
  * [10.x](CHANGELOG_V10.md)
  * [9.x](CHANGELOG_V9.md)
  * [8.x](CHANGELOG_V8.md)
  * [7.x](CHANGELOG_V7.md)
  * [6.x](CHANGELOG_V6.md)
  * [5.x](CHANGELOG_V5.md)
  * [4.x](CHANGELOG_V4.md)
  * [0.12.x](CHANGELOG_V012.md)
  * [0.10.x](CHANGELOG_V010.md)
  * [io.js](CHANGELOG_IOJS.md)
  * [Archive](CHANGELOG_ARCHIVE.md)

<a id="22.5.1"></a>

## 2024-07-19, Version 22.5.1 (Current), @richardlau

### Notable Changes

This release fixes a regression introduced in Node.js 22.5.0. The problem is known to display the following symptoms:

* Crash with `FATAL ERROR: v8::Object::GetCreationContextChecked No creation context available` [#53902](https://github.com/nodejs/node/issues/53902)
* npm errors with `npm error Exit handler never called!` [npm/cli#7657](https://github.com/npm/cli/issues/7657)
* yarn hangs or outputs `Usage Error: Couldn't find the node_modules state file - running an install might help (findPackageLocation)` [yarnpkg/berry#6398](https://github.com/yarnpkg/berry/issues/6398)

### Commits

* \[[`e2deeedc6e`](https://github.com/nodejs/node/commit/e2deeedc6e)] - _**Revert**_ "**fs**: add v8 fast api to closeSync" (Aviv Keller) [#53904](https://github.com/nodejs/node/pull/53904)

<a id="22.5.0"></a>

## 2024-07-16, Version 22.5.0 (Current), @RafaelGSS prepared by @aduh95

### Notable Changes

* \[[`1367c5558e`](https://github.com/nodejs/node/commit/1367c5558e)] - **(SEMVER-MINOR)** **http**: expose websockets (Natalia Venditto) [#53721](https://github.com/nodejs/node/pull/53721)
* \[[`b31394920d`](https://github.com/nodejs/node/commit/b31394920d)] - **(SEMVER-MINOR)** **lib**: add `node:sqlite` module (Colin Ihrig) [#53752](https://github.com/nodejs/node/pull/53752)
* \[[`aa7df9551d`](https://github.com/nodejs/node/commit/aa7df9551d)] - **module**: add `__esModule` to `require()`'d ESM (Joyee Cheung) [#52166](https://github.com/nodejs/node/pull/52166)
* \[[`8743c4d65a`](https://github.com/nodejs/node/commit/8743c4d65a)] - **(SEMVER-MINOR)** **path**: add `matchesGlob` method (Aviv Keller) [#52881](https://github.com/nodejs/node/pull/52881)
* \[[`77936c3d24`](https://github.com/nodejs/node/commit/77936c3d24)] - **(SEMVER-MINOR)** **process**: port on-exit-leak-free to core (Vinicius Lourenço) [#53239](https://github.com/nodejs/node/pull/53239)
* \[[`82d88a83f8`](https://github.com/nodejs/node/commit/82d88a83f8)] - **(SEMVER-MINOR)** **stream**: pipeline wait for close before calling the callback (jakecastelli) [#53462](https://github.com/nodejs/node/pull/53462)
* \[[`3a0fcbb17a`](https://github.com/nodejs/node/commit/3a0fcbb17a)] - **test\_runner**: support glob matching coverage files (Aviv Keller) [#53553](https://github.com/nodejs/node/pull/53553)
* \[[`22ca334090`](https://github.com/nodejs/node/commit/22ca334090)] - **(SEMVER-MINOR)** **worker**: add `postMessageToThread` (Paolo Insogna) [#53682](https://github.com/nodejs/node/pull/53682)

### Commits

* \[[`eb4e370933`](https://github.com/nodejs/node/commit/eb4e370933)] - **benchmark**: add require-esm benchmark (Joyee Cheung) [#52166](https://github.com/nodejs/node/pull/52166)
* \[[`4d4a8338db`](https://github.com/nodejs/node/commit/4d4a8338db)] - **benchmark**: add cpSync benchmark (Yagiz Nizipli) [#53612](https://github.com/nodejs/node/pull/53612)
* \[[`3d60b38afa`](https://github.com/nodejs/node/commit/3d60b38afa)] - **build**: fix build warning of c-ares under GN build (Cheng) [#53750](https://github.com/nodejs/node/pull/53750)
* \[[`a45c801048`](https://github.com/nodejs/node/commit/a45c801048)] - **build**: fix build error in sqlite under GN build (Cheng) [#53686](https://github.com/nodejs/node/pull/53686)
* \[[`40032eb623`](https://github.com/nodejs/node/commit/40032eb623)] - **build**: add gn files for deps/nbytes (Cheng) [#53685](https://github.com/nodejs/node/pull/53685)
* \[[`082799debb`](https://github.com/nodejs/node/commit/082799debb)] - **build**: fix mac build error of c-ares under GN (Cheng) [#53687](https://github.com/nodejs/node/pull/53687)
* \[[`b05394ea6a`](https://github.com/nodejs/node/commit/b05394ea6a)] - **build**: add version-specific library path for AIX (Richard Lau) [#53585](https://github.com/nodejs/node/pull/53585)
* \[[`6237172eaf`](https://github.com/nodejs/node/commit/6237172eaf)] - **cli**: update `node.1` to reflect Atom's sunset (Aviv Keller) [#53734](https://github.com/nodejs/node/pull/53734)
* \[[`5697938cb7`](https://github.com/nodejs/node/commit/5697938cb7)] - **crypto**: avoid std::function (Tobias Nießen) [#53683](https://github.com/nodejs/node/pull/53683)
* \[[`3cc01aa314`](https://github.com/nodejs/node/commit/3cc01aa314)] - **crypto**: make deriveBits length parameter optional and nullable (Filip Skokan) [#53601](https://github.com/nodejs/node/pull/53601)
* \[[`f82e20fdea`](https://github.com/nodejs/node/commit/f82e20fdea)] - **crypto**: avoid taking ownership of OpenSSL objects (Tobias Nießen) [#53460](https://github.com/nodejs/node/pull/53460)
* \[[`ad1e5610ec`](https://github.com/nodejs/node/commit/ad1e5610ec)] - **deps**: update googletest to 4b21f1a (Node.js GitHub Bot) [#53842](https://github.com/nodejs/node/pull/53842)
* \[[`d285d610a0`](https://github.com/nodejs/node/commit/d285d610a0)] - **deps**: update minimatch to 10.0.1 (Node.js GitHub Bot) [#53841](https://github.com/nodejs/node/pull/53841)
* \[[`70f5209c9f`](https://github.com/nodejs/node/commit/70f5209c9f)] - **deps**: update corepack to 0.29.2 (Node.js GitHub Bot) [#53838](https://github.com/nodejs/node/pull/53838)
* \[[`4930e12a45`](https://github.com/nodejs/node/commit/4930e12a45)] - **deps**: update simdutf to 5.3.0 (Node.js GitHub Bot) [#53837](https://github.com/nodejs/node/pull/53837)
* \[[`d346833364`](https://github.com/nodejs/node/commit/d346833364)] - **deps**: update ada to 2.9.0 (Node.js GitHub Bot) [#53748](https://github.com/nodejs/node/pull/53748)
* \[[`ab8abb5367`](https://github.com/nodejs/node/commit/ab8abb5367)] - **deps**: upgrade npm to 10.8.2 (npm team) [#53799](https://github.com/nodejs/node/pull/53799)
* \[[`1ad664905a`](https://github.com/nodejs/node/commit/1ad664905a)] - **deps**: update nbytes and add update script (Yagiz Nizipli) [#53790](https://github.com/nodejs/node/pull/53790)
* \[[`a66f11e798`](https://github.com/nodejs/node/commit/a66f11e798)] - **deps**: update googletest to 34ad51b (Node.js GitHub Bot) [#53157](https://github.com/nodejs/node/pull/53157)
* \[[`9bf61d6a0d`](https://github.com/nodejs/node/commit/9bf61d6a0d)] - **deps**: update googletest to 305e5a2 (Node.js GitHub Bot) [#53157](https://github.com/nodejs/node/pull/53157)
* \[[`8542ace488`](https://github.com/nodejs/node/commit/8542ace488)] - **deps**: V8: cherry-pick 9ebca66a5740 (Chengzhong Wu) [#53755](https://github.com/nodejs/node/pull/53755)
* \[[`29a734c21d`](https://github.com/nodejs/node/commit/29a734c21d)] - **deps**: V8: cherry-pick e061cf9970d9 (Joyee Cheung) [#53755](https://github.com/nodejs/node/pull/53755)
* \[[`c7624af44a`](https://github.com/nodejs/node/commit/c7624af44a)] - **deps**: update c-ares to v1.32.1 (Node.js GitHub Bot) [#53753](https://github.com/nodejs/node/pull/53753)
* \[[`bbcec9e129`](https://github.com/nodejs/node/commit/bbcec9e129)] - **deps**: update minimatch to 9.0.5 (Node.js GitHub Bot) [#53646](https://github.com/nodejs/node/pull/53646)
* \[[`76032fd980`](https://github.com/nodejs/node/commit/76032fd980)] - **deps**: update c-ares to v1.32.0 (Node.js GitHub Bot) [#53722](https://github.com/nodejs/node/pull/53722)
* \[[`26386046ad`](https://github.com/nodejs/node/commit/26386046ad)] - **doc**: move MylesBorins to emeritus (Myles Borins) [#53760](https://github.com/nodejs/node/pull/53760)
* \[[`362875bda0`](https://github.com/nodejs/node/commit/362875bda0)] - **doc**: add Rafael to the last security release (Rafael Gonzaga) [#53769](https://github.com/nodejs/node/pull/53769)
* \[[`a1a5ad848d`](https://github.com/nodejs/node/commit/a1a5ad848d)] - **doc**: use mock.callCount() in examples (Sébastien Règne) [#53754](https://github.com/nodejs/node/pull/53754)
* \[[`bb960c5471`](https://github.com/nodejs/node/commit/bb960c5471)] - **doc**: clarify authenticity of plaintexts in update (Tobias Nießen) [#53784](https://github.com/nodejs/node/pull/53784)
* \[[`5dd3018eb4`](https://github.com/nodejs/node/commit/5dd3018eb4)] - **doc**: add option to have support me link (Michael Dawson) [#53312](https://github.com/nodejs/node/pull/53312)
* \[[`0f95ad3d7d`](https://github.com/nodejs/node/commit/0f95ad3d7d)] - **doc**: add OpenSSL security level to TLS docs (Afanasii Kurakin) [#53647](https://github.com/nodejs/node/pull/53647)
* \[[`2d92ec2831`](https://github.com/nodejs/node/commit/2d92ec2831)] - **doc**: update `scroll-padding-top` to 4rem (Cloyd Lau) [#53662](https://github.com/nodejs/node/pull/53662)
* \[[`933359a786`](https://github.com/nodejs/node/commit/933359a786)] - **doc**: mention v8.setFlagsFromString to pm (Rafael Gonzaga) [#53731](https://github.com/nodejs/node/pull/53731)
* \[[`e17c2618e3`](https://github.com/nodejs/node/commit/e17c2618e3)] - **doc**: remove the last \<pre> tag (Claudio W) [#53741](https://github.com/nodejs/node/pull/53741)
* \[[`7f18a5f47a`](https://github.com/nodejs/node/commit/7f18a5f47a)] - **doc**: exclude voting and regular TSC from spotlight (Michael Dawson) [#53694](https://github.com/nodejs/node/pull/53694)
* \[[`df3dcd1bd1`](https://github.com/nodejs/node/commit/df3dcd1bd1)] - **doc**: fix releases guide for recent Git versions (Michaël Zasso) [#53709](https://github.com/nodejs/node/pull/53709)
* \[[`50987ea833`](https://github.com/nodejs/node/commit/50987ea833)] - **doc**: require `node:process` in assert doc examples (Alfredo González) [#53702](https://github.com/nodejs/node/pull/53702)
* \[[`fa58d01497`](https://github.com/nodejs/node/commit/fa58d01497)] - **doc**: add additional explanation to the wildcard section in permissions (jakecastelli) [#53664](https://github.com/nodejs/node/pull/53664)
* \[[`28bf1e48ef`](https://github.com/nodejs/node/commit/28bf1e48ef)] - **doc**: mark NODE\_MODULE\_VERSION for Node.js 22.0.0 (Michaël Zasso) [#53650](https://github.com/nodejs/node/pull/53650)
* \[[`1cc0b41f00`](https://github.com/nodejs/node/commit/1cc0b41f00)] - **doc**: include node.module\_timer on available categories (Vinicius Lourenço) [#53638](https://github.com/nodejs/node/pull/53638)
* \[[`d224e9eab5`](https://github.com/nodejs/node/commit/d224e9eab5)] - **doc**: fix module customization hook examples (Elliot Goodrich) [#53637](https://github.com/nodejs/node/pull/53637)
* \[[`2cf60964e6`](https://github.com/nodejs/node/commit/2cf60964e6)] - **doc**: fix doc for correct usage with plan & TestContext (Emil Tayeb) [#53615](https://github.com/nodejs/node/pull/53615)
* \[[`6df86ae056`](https://github.com/nodejs/node/commit/6df86ae056)] - **doc**: remove some news issues that are no longer (Michael Dawson) [#53608](https://github.com/nodejs/node/pull/53608)
* \[[`42b9408f3e`](https://github.com/nodejs/node/commit/42b9408f3e)] - **doc**: add issue for news from ambassadors (Michael Dawson) [#53607](https://github.com/nodejs/node/pull/53607)
* \[[`2d1ff91953`](https://github.com/nodejs/node/commit/2d1ff91953)] - **doc**: add esm example for os (Leonardo Peixoto) [#53604](https://github.com/nodejs/node/pull/53604)
* \[[`de99d69d75`](https://github.com/nodejs/node/commit/de99d69d75)] - **doc**: clarify usage of coverage reporters (Eliphaz Bouye) [#53523](https://github.com/nodejs/node/pull/53523)
* \[[`519c328dcf`](https://github.com/nodejs/node/commit/519c328dcf)] - **doc**: document addition testing options (Aviv Keller) [#53569](https://github.com/nodejs/node/pull/53569)
* \[[`c6166cdfe4`](https://github.com/nodejs/node/commit/c6166cdfe4)] - **doc**: clarify that fs.exists() may return false for existing symlink (Tobias Nießen) [#53566](https://github.com/nodejs/node/pull/53566)
* \[[`9139ab2848`](https://github.com/nodejs/node/commit/9139ab2848)] - **doc**: note http.closeAllConnections excludes upgraded sockets (Rob Hogan) [#53560](https://github.com/nodejs/node/pull/53560)
* \[[`19b3718ee1`](https://github.com/nodejs/node/commit/19b3718ee1)] - **doc, meta**: add PTAL to glossary (Aviv Keller) [#53770](https://github.com/nodejs/node/pull/53770)
* \[[`80c1f5ce8a`](https://github.com/nodejs/node/commit/80c1f5ce8a)] - **doc, typings**: events.once accepts symbol event type (René) [#53542](https://github.com/nodejs/node/pull/53542)
* \[[`1a21e0f61e`](https://github.com/nodejs/node/commit/1a21e0f61e)] - **esm**: improve `defaultResolve` performance (Yagiz Nizipli) [#53711](https://github.com/nodejs/node/pull/53711)
* \[[`262f2cb3b6`](https://github.com/nodejs/node/commit/262f2cb3b6)] - **esm**: remove unnecessary toNamespacedPath calls (Yagiz Nizipli) [#53656](https://github.com/nodejs/node/pull/53656)
* \[[`e29c9453a9`](https://github.com/nodejs/node/commit/e29c9453a9)] - **esm**: move hooks test with others (Geoffrey Booth) [#53558](https://github.com/nodejs/node/pull/53558)
* \[[`8368555289`](https://github.com/nodejs/node/commit/8368555289)] - **fs**: add v8 fast api to closeSync (Yagiz Nizipli) [#53627](https://github.com/nodejs/node/pull/53627)
* \[[`628a539810`](https://github.com/nodejs/node/commit/628a539810)] - **fs**: reduce throwing unnecessary errors on glob (Yagiz Nizipli) [#53632](https://github.com/nodejs/node/pull/53632)
* \[[`076e82ca40`](https://github.com/nodejs/node/commit/076e82ca40)] - **fs**: move `ToNamespacedPath` dir calls to c++ (Yagiz Nizipli) [#53630](https://github.com/nodejs/node/pull/53630)
* \[[`128e514d81`](https://github.com/nodejs/node/commit/128e514d81)] - **fs**: improve error performance of `fs.dir` (Yagiz Nizipli) [#53667](https://github.com/nodejs/node/pull/53667)
* \[[`603c2c5c08`](https://github.com/nodejs/node/commit/603c2c5c08)] - **fs**: fix typings (Yagiz Nizipli) [#53626](https://github.com/nodejs/node/pull/53626)
* \[[`1367c5558e`](https://github.com/nodejs/node/commit/1367c5558e)] - **(SEMVER-MINOR)** **http**: expose websockets (Natalia Venditto) [#53721](https://github.com/nodejs/node/pull/53721)
* \[[`7debb6c36e`](https://github.com/nodejs/node/commit/7debb6c36e)] - **http**: remove prototype primordials (Antoine du Hamel) [#53698](https://github.com/nodejs/node/pull/53698)
* \[[`b13aea5698`](https://github.com/nodejs/node/commit/b13aea5698)] - **http, readline**: replace sort with toSorted (Benjamin Gruenbaum) [#53623](https://github.com/nodejs/node/pull/53623)
* \[[`1397f5d9f4`](https://github.com/nodejs/node/commit/1397f5d9f4)] - **http2**: remove prototype primordials (Antoine du Hamel) [#53696](https://github.com/nodejs/node/pull/53696)
* \[[`f57d3cee2c`](https://github.com/nodejs/node/commit/f57d3cee2c)] - **lib**: make navigator not runtime-lookup process.version/arch/platform (Jordan Harband) [#53765](https://github.com/nodejs/node/pull/53765)
* \[[`0a01abbd45`](https://github.com/nodejs/node/commit/0a01abbd45)] - **lib**: refactor `platform` utility methods (Daniel Bayley) [#53817](https://github.com/nodejs/node/pull/53817)
* \[[`afe7f4f819`](https://github.com/nodejs/node/commit/afe7f4f819)] - **lib**: remove path.resolve from permissions.js (Rafael Gonzaga) [#53729](https://github.com/nodejs/node/pull/53729)
* \[[`cbe77b30ca`](https://github.com/nodejs/node/commit/cbe77b30ca)] - **lib**: move `ToNamespacedPath` call to c++ (Yagiz Nizipli) [#53654](https://github.com/nodejs/node/pull/53654)
* \[[`0f146aac2c`](https://github.com/nodejs/node/commit/0f146aac2c)] - **lib**: make navigator properties lazy (James M Snell) [#53649](https://github.com/nodejs/node/pull/53649)
* \[[`0540308bd7`](https://github.com/nodejs/node/commit/0540308bd7)] - **lib**: add toJSON to PerformanceMeasure (theanarkh) [#53603](https://github.com/nodejs/node/pull/53603)
* \[[`b31394920d`](https://github.com/nodejs/node/commit/b31394920d)] - **(SEMVER-MINOR)** **lib,src,test,doc**: add node:sqlite module (Colin Ihrig) [#53752](https://github.com/nodejs/node/pull/53752)
* \[[`1a7c2dc5ea`](https://github.com/nodejs/node/commit/1a7c2dc5ea)] - **meta**: remove redudant logging from dep updaters (Aviv Keller) [#53783](https://github.com/nodejs/node/pull/53783)
* \[[`ac5d7b709d`](https://github.com/nodejs/node/commit/ac5d7b709d)] - **meta**: change email address of anonrig (Yagiz Nizipli) [#53829](https://github.com/nodejs/node/pull/53829)
* \[[`085ec5533c`](https://github.com/nodejs/node/commit/085ec5533c)] - **meta**: add `node_sqlite.c` to PR label config (Aviv Keller) [#53797](https://github.com/nodejs/node/pull/53797)
* \[[`c68d873e99`](https://github.com/nodejs/node/commit/c68d873e99)] - **meta**: move one or more collaborators to emeritus (Node.js GitHub Bot) [#53758](https://github.com/nodejs/node/pull/53758)
* \[[`5ae8ea489d`](https://github.com/nodejs/node/commit/5ae8ea489d)] - **meta**: use HTML entities in commit-queue comment (Aviv Keller) [#53744](https://github.com/nodejs/node/pull/53744)
* \[[`ecd8fceb68`](https://github.com/nodejs/node/commit/ecd8fceb68)] - **meta**: move regular TSC member to emeritus (Michael Dawson) [#53693](https://github.com/nodejs/node/pull/53693)
* \[[`05058f9809`](https://github.com/nodejs/node/commit/05058f9809)] - **meta**: bump codecov/codecov-action from 4.4.1 to 4.5.0 (dependabot\[bot]) [#53675](https://github.com/nodejs/node/pull/53675)
* \[[`e272ffa3d6`](https://github.com/nodejs/node/commit/e272ffa3d6)] - **meta**: bump mozilla-actions/sccache-action from 0.0.4 to 0.0.5 (dependabot\[bot]) [#53674](https://github.com/nodejs/node/pull/53674)
* \[[`a39407560c`](https://github.com/nodejs/node/commit/a39407560c)] - **meta**: bump github/codeql-action from 3.25.7 to 3.25.11 (dependabot\[bot]) [#53673](https://github.com/nodejs/node/pull/53673)
* \[[`e4ce92ee31`](https://github.com/nodejs/node/commit/e4ce92ee31)] - **meta**: bump actions/checkout from 4.1.6 to 4.1.7 (dependabot\[bot]) [#53672](https://github.com/nodejs/node/pull/53672)
* \[[`4cf98febe7`](https://github.com/nodejs/node/commit/4cf98febe7)] - **meta**: bump peter-evans/create-pull-request from 6.0.5 to 6.1.0 (dependabot\[bot]) [#53671](https://github.com/nodejs/node/pull/53671)
* \[[`c28af95bf5`](https://github.com/nodejs/node/commit/c28af95bf5)] - **meta**: bump step-security/harden-runner from 2.8.0 to 2.8.1 (dependabot\[bot]) [#53670](https://github.com/nodejs/node/pull/53670)
* \[[`dd2157bc83`](https://github.com/nodejs/node/commit/dd2157bc83)] - **meta**: move member from TSC regular to emeriti (Michael Dawson) [#53599](https://github.com/nodejs/node/pull/53599)
* \[[`508abfe178`](https://github.com/nodejs/node/commit/508abfe178)] - **meta**: warnings bypass deprecation cycle (Benjamin Gruenbaum) [#53513](https://github.com/nodejs/node/pull/53513)
* \[[`3c5ec839e3`](https://github.com/nodejs/node/commit/3c5ec839e3)] - **meta**: prevent constant references to issues in versioning (Aviv Keller) [#53564](https://github.com/nodejs/node/pull/53564)
* \[[`aa7df9551d`](https://github.com/nodejs/node/commit/aa7df9551d)] - **module**: add \_\_esModule to require()'d ESM (Joyee Cheung) [#52166](https://github.com/nodejs/node/pull/52166)
* \[[`8743c4d65a`](https://github.com/nodejs/node/commit/8743c4d65a)] - **(SEMVER-MINOR)** **path**: add `matchesGlob` method (Aviv Keller) [#52881](https://github.com/nodejs/node/pull/52881)
* \[[`77936c3d24`](https://github.com/nodejs/node/commit/77936c3d24)] - **(SEMVER-MINOR)** **process**: port on-exit-leak-free to core (Vinicius Lourenço) [#53239](https://github.com/nodejs/node/pull/53239)
* \[[`5e4ca9fbb6`](https://github.com/nodejs/node/commit/5e4ca9fbb6)] - **src**: update outdated references to spec sections (Tobias Nießen) [#53832](https://github.com/nodejs/node/pull/53832)
* \[[`c22d9d5167`](https://github.com/nodejs/node/commit/c22d9d5167)] - **src**: use Maybe\<void> in ManagedEVPPKey (Tobias Nießen) [#53811](https://github.com/nodejs/node/pull/53811)
* \[[`d41ed44f49`](https://github.com/nodejs/node/commit/d41ed44f49)] - **src**: move `loadEnvFile` toNamespacedPath call (Yagiz Nizipli) [#53658](https://github.com/nodejs/node/pull/53658)
* \[[`dc99dd391f`](https://github.com/nodejs/node/commit/dc99dd391f)] - **src**: fix error handling in ExportJWKAsymmetricKey (Tobias Nießen) [#53767](https://github.com/nodejs/node/pull/53767)
* \[[`ab1e03e8cd`](https://github.com/nodejs/node/commit/ab1e03e8cd)] - **src**: use Maybe\<void> in node::crypto::error (Tobias Nießen) [#53766](https://github.com/nodejs/node/pull/53766)
* \[[`9bde9b254d`](https://github.com/nodejs/node/commit/9bde9b254d)] - **src**: fix implementation of `PropertySetterCallback` (Igor Sheludko) [#53576](https://github.com/nodejs/node/pull/53576)
* \[[`021e2cf40f`](https://github.com/nodejs/node/commit/021e2cf40f)] - **src**: remove unused ContextifyContext::WeakCallback (Chengzhong Wu) [#53517](https://github.com/nodejs/node/pull/53517)
* \[[`87121a17c4`](https://github.com/nodejs/node/commit/87121a17c4)] - **src**: fix typo in node.h (Daeyeon Jeong) [#53759](https://github.com/nodejs/node/pull/53759)
* \[[`94c7054c8d`](https://github.com/nodejs/node/commit/94c7054c8d)] - **src**: document the Node.js context embedder data (Joyee Cheung) [#53611](https://github.com/nodejs/node/pull/53611)
* \[[`c181940e83`](https://github.com/nodejs/node/commit/c181940e83)] - **src**: zero-initialize data that are copied into the snapshot (Joyee Cheung) [#53563](https://github.com/nodejs/node/pull/53563)
* \[[`8cda2db64c`](https://github.com/nodejs/node/commit/8cda2db64c)] - _**Revert**_ "**src**: make sure that memcpy-ed structs in snapshot have no padding" (Joyee Cheung) [#53563](https://github.com/nodejs/node/pull/53563)
* \[[`81767f6089`](https://github.com/nodejs/node/commit/81767f6089)] - **src**: fix Worker termination when '--inspect-brk' is passed (Daeyeon Jeong) [#53724](https://github.com/nodejs/node/pull/53724)
* \[[`a9db553935`](https://github.com/nodejs/node/commit/a9db553935)] - **src**: refactor embedded entrypoint loading (Joyee Cheung) [#53573](https://github.com/nodejs/node/pull/53573)
* \[[`3ab8aba478`](https://github.com/nodejs/node/commit/3ab8aba478)] - **src**: do not get string\_view from temp string (Cheng) [#53688](https://github.com/nodejs/node/pull/53688)
* \[[`664bf6c28f`](https://github.com/nodejs/node/commit/664bf6c28f)] - **src**: replace `kPathSeparator` with std::filesystem (Yagiz Nizipli) [#53063](https://github.com/nodejs/node/pull/53063)
* \[[`cc1f49751a`](https://github.com/nodejs/node/commit/cc1f49751a)] - **src**: move `FromNamespacedPath` to path.cc (Yagiz Nizipli) [#53540](https://github.com/nodejs/node/pull/53540)
* \[[`e43a4e07ec`](https://github.com/nodejs/node/commit/e43a4e07ec)] - **src**: use `starts_with` in node\_dotenv.cc (Yagiz Nizipli) [#53539](https://github.com/nodejs/node/pull/53539)
* \[[`19488fd4ce`](https://github.com/nodejs/node/commit/19488fd4ce)] - **src,test**: further cleanup references to osx (Daniel Bayley) [#53820](https://github.com/nodejs/node/pull/53820)
* \[[`4bf62f6cbd`](https://github.com/nodejs/node/commit/4bf62f6cbd)] - **stream**: improve inspector ergonomics (Benjamin Gruenbaum) [#53800](https://github.com/nodejs/node/pull/53800)
* \[[`82d88a83f8`](https://github.com/nodejs/node/commit/82d88a83f8)] - **(SEMVER-MINOR)** **stream**: pipeline wait for close before calling the callback (jakecastelli) [#53462](https://github.com/nodejs/node/pull/53462)
* \[[`53a7dd7790`](https://github.com/nodejs/node/commit/53a7dd7790)] - **test**: update wpt test (Mert Can Altin) [#53814](https://github.com/nodejs/node/pull/53814)
* \[[`bc480902ab`](https://github.com/nodejs/node/commit/bc480902ab)] - **test**: update WPT WebIDL interfaces (Filip Skokan) [#53720](https://github.com/nodejs/node/pull/53720)
* \[[`d13153d90f`](https://github.com/nodejs/node/commit/d13153d90f)] - **test**: un-set inspector-async-hook-setup-at-inspect-brk as flaky (Abdirahim Musse) [#53692](https://github.com/nodejs/node/pull/53692)
* \[[`ac9c2e6bf2`](https://github.com/nodejs/node/commit/ac9c2e6bf2)] - **test**: use python3 instead of python in pummel test (Mathis Wiehl) [#53057](https://github.com/nodejs/node/pull/53057)
* \[[`bac28678e6`](https://github.com/nodejs/node/commit/bac28678e6)] - **test**: do not assume cwd in snapshot tests (Antoine du Hamel) [#53146](https://github.com/nodejs/node/pull/53146)
* \[[`41e106c0c6`](https://github.com/nodejs/node/commit/41e106c0c6)] - **test**: use `Set.difference()` (Richard Lau) [#53597](https://github.com/nodejs/node/pull/53597)
* \[[`8aab680f66`](https://github.com/nodejs/node/commit/8aab680f66)] - **test**: fix OpenSSL version checks (Richard Lau) [#53503](https://github.com/nodejs/node/pull/53503)
* \[[`6aa4f0f266`](https://github.com/nodejs/node/commit/6aa4f0f266)] - **test**: refactor, add assertion to http-request-end (jakecastelli) [#53411](https://github.com/nodejs/node/pull/53411)
* \[[`fbc5cbb617`](https://github.com/nodejs/node/commit/fbc5cbb617)] - **test\_runner**: remove plan option from run() (Colin Ihrig) [#53834](https://github.com/nodejs/node/pull/53834)
* \[[`c590828ad8`](https://github.com/nodejs/node/commit/c590828ad8)] - **test\_runner**: fix escaping in snapshot tests (Julian Kniephoff) [#53833](https://github.com/nodejs/node/pull/53833)
* \[[`3a0fcbb17a`](https://github.com/nodejs/node/commit/3a0fcbb17a)] - **test\_runner**: support glob matching coverage files (Aviv Keller) [#53553](https://github.com/nodejs/node/pull/53553)
* \[[`e6a1eeb73d`](https://github.com/nodejs/node/commit/e6a1eeb73d)] - **test\_runner**: support module detection in module mocks (Geoffrey Booth) [#53642](https://github.com/nodejs/node/pull/53642)
* \[[`4d777de7d4`](https://github.com/nodejs/node/commit/4d777de7d4)] - **tls**: add setKeyCert() to tls.Socket (Brian White) [#53636](https://github.com/nodejs/node/pull/53636)
* \[[`ab9adfc42a`](https://github.com/nodejs/node/commit/ab9adfc42a)] - **tls**: remove prototype primordials (Antoine du Hamel) [#53699](https://github.com/nodejs/node/pull/53699)
* \[[`03d378ffb9`](https://github.com/nodejs/node/commit/03d378ffb9)] - **tools**: update lint-md-dependencies (Node.js GitHub Bot) [#53840](https://github.com/nodejs/node/pull/53840)
* \[[`06377b1b11`](https://github.com/nodejs/node/commit/06377b1b11)] - **tools**: update eslint to 9.7.0 (Node.js GitHub Bot) [#53839](https://github.com/nodejs/node/pull/53839)
* \[[`d6629a2d84`](https://github.com/nodejs/node/commit/d6629a2d84)] - **tools**: use v8\_features.json to populate config.gypi (Cheng) [#53749](https://github.com/nodejs/node/pull/53749)
* \[[`d3653fe8ac`](https://github.com/nodejs/node/commit/d3653fe8ac)] - **tools**: update eslint to 9.6.0 (Node.js GitHub Bot) [#53645](https://github.com/nodejs/node/pull/53645)
* \[[`1e930e93d4`](https://github.com/nodejs/node/commit/1e930e93d4)] - **tools**: update lint-md-dependencies to unified\@11.0.5 (Node.js GitHub Bot) [#53555](https://github.com/nodejs/node/pull/53555)
* \[[`317a13b30f`](https://github.com/nodejs/node/commit/317a13b30f)] - **tools**: replace reference to NodeMainInstance with SnapshotBuilder (codediverdev) [#53544](https://github.com/nodejs/node/pull/53544)
* \[[`0e25faea0a`](https://github.com/nodejs/node/commit/0e25faea0a)] - **typings**: add `fs_dir` types (Yagiz Nizipli) [#53631](https://github.com/nodejs/node/pull/53631)
* \[[`7637f291be`](https://github.com/nodejs/node/commit/7637f291be)] - **url**: fix typo (KAYYY) [#53827](https://github.com/nodejs/node/pull/53827)
* \[[`2c6548afd1`](https://github.com/nodejs/node/commit/2c6548afd1)] - **url**: reduce unnecessary string copies (Yagiz Nizipli) [#53628](https://github.com/nodejs/node/pull/53628)
* \[[`0f2b57d1bc`](https://github.com/nodejs/node/commit/0f2b57d1bc)] - **url**: make URL.parse enumerable (Filip Skokan) [#53720](https://github.com/nodejs/node/pull/53720)
* \[[`1300169f80`](https://github.com/nodejs/node/commit/1300169f80)] - **url**: add missing documentation for `URL.parse()` (Yagiz Nizipli) [#53733](https://github.com/nodejs/node/pull/53733)
* \[[`c55e72ed8b`](https://github.com/nodejs/node/commit/c55e72ed8b)] - **util**: fix crashing when emitting new Buffer() deprecation warning #53075 (Aras Abbasi) [#53089](https://github.com/nodejs/node/pull/53089)
* \[[`5aa216320e`](https://github.com/nodejs/node/commit/5aa216320e)] - **v8**: move `ToNamespacedPath` to c++ (Yagiz Nizipli) [#53655](https://github.com/nodejs/node/pull/53655)
* \[[`9fd976b09d`](https://github.com/nodejs/node/commit/9fd976b09d)] - **vm,src**: add property query interceptors (Chengzhong Wu) [#53517](https://github.com/nodejs/node/pull/53517)
* \[[`22ca334090`](https://github.com/nodejs/node/commit/22ca334090)] - **(SEMVER-MINOR)** **worker**: add postMessageToThread (Paolo Insogna) [#53682](https://github.com/nodejs/node/pull/53682)
* \[[`5aecbefbd5`](https://github.com/nodejs/node/commit/5aecbefbd5)] - **worker**: allow copied NODE\_OPTIONS in the env setting (Joyee Cheung) [#53596](https://github.com/nodejs/node/pull/53596)

<a id="22.4.1"></a>

## 2024-07-08, Version 22.4.1 (Current), @RafaelGSS

This is a security release.

### Notable Changes

* CVE-2024-36138 - Bypass incomplete fix of CVE-2024-27980 (High)
* CVE-2024-22020 - Bypass network import restriction via data URL (Medium)
* CVE-2024-22018 - fs.lstat bypasses permission model (Low)
* CVE-2024-36137 - fs.fchown/fchmod bypasses permission model (Low)
* CVE-2024-37372 - Permission model improperly processes UNC paths (Low)

### Commits

* \[[`110902ff5e`](https://github.com/nodejs/node/commit/110902ff5e)] - **lib,esm**: handle bypass network-import via data: (RafaelGSS) [nodejs-private/node-private#522](https://github.com/nodejs-private/node-private/pull/522)
* \[[`0a0de3d491`](https://github.com/nodejs/node/commit/0a0de3d491)] - **lib,permission**: support fs.lstat (RafaelGSS)
* \[[`93574335ff`](https://github.com/nodejs/node/commit/93574335ff)] - **lib,permission**: disable fchmod/fchown when pm enabled (RafaelGSS) [nodejs-private/node-private#584](https://github.com/nodejs-private/node-private/pull/584)
* \[[`09899e6302`](https://github.com/nodejs/node/commit/09899e6302)] - **src**: handle permissive extension on cmd check (RafaelGSS) [nodejs-private/node-private#596](https://github.com/nodejs-private/node-private/pull/596)
* \[[`5d9c811634`](https://github.com/nodejs/node/commit/5d9c811634)] - **src,permission**: fix UNC path resolution (RafaelGSS) [nodejs-private/node-private#581](https://github.com/nodejs-private/node-private/pull/581)

<a id="22.4.0"></a>

## 2024-07-02, Version 22.4.0 (Current), @targos

### Notable Changes

#### Experimental Web Storage API

* \[[`9e30724b53`](https://github.com/nodejs/node/commit/9e30724b53)] - **(SEMVER-MINOR)** **deps,lib,src**: add experimental web storage (Colin Ihrig) [#52435](https://github.com/nodejs/node/pull/52435)

#### API stability updates

* \[[`201266706b`](https://github.com/nodejs/node/commit/201266706b)] - **doc**: move `node --run` stability to rc (Yagiz Nizipli) [#53433](https://github.com/nodejs/node/pull/53433)
* \[[`16c0884d48`](https://github.com/nodejs/node/commit/16c0884d48)] - **doc**: mark WebSocket as stable (Matthew Aitken) [#53352](https://github.com/nodejs/node/pull/53352)
* \[[`cf375e73c1`](https://github.com/nodejs/node/commit/cf375e73c1)] - **doc**: mark --heap-prof and related flags stable (Joyee Cheung) [#53343](https://github.com/nodejs/node/pull/53343)
* \[[`0160745057`](https://github.com/nodejs/node/commit/0160745057)] - **doc**: mark --cpu-prof and related flags stable (Joyee Cheung) [#53343](https://github.com/nodejs/node/pull/53343)

#### Other Notable Changes

* \[[`df4762722c`](https://github.com/nodejs/node/commit/df4762722c)] - **doc**: doc-only deprecate OpenSSL engine-based APIs (Richard Lau) [#53329](https://github.com/nodejs/node/pull/53329)
* \[[`ad5282e196`](https://github.com/nodejs/node/commit/ad5282e196)] - **inspector**: fix disable async hooks on `Debugger.setAsyncCallStackDepth` (Joyee Cheung) [#53473](https://github.com/nodejs/node/pull/53473)
* \[[`e95af740fc`](https://github.com/nodejs/node/commit/e95af740fc)] - **(SEMVER-MINOR)** **lib**: add diagnostics\_channel events to module loading (RafaelGSS) [#44340](https://github.com/nodejs/node/pull/44340)
* \[[`50733a1abe`](https://github.com/nodejs/node/commit/50733a1abe)] - **(SEMVER-MINOR)** **util**: support `--no-` for argument with boolean type for parseArgs (Zhenwei Jin) [#53107](https://github.com/nodejs/node/pull/53107)

### Commits

* \[[`9f32002397`](https://github.com/nodejs/node/commit/9f32002397)] - **assert,util**: correct comparison when both contain same reference (Daniel Lemire) [#53431](https://github.com/nodejs/node/pull/53431)
* \[[`dfdc062111`](https://github.com/nodejs/node/commit/dfdc062111)] - **buffer**: make indexOf(byte) faster (Tobias Nießen) [#53455](https://github.com/nodejs/node/pull/53455)
* \[[`1de437527e`](https://github.com/nodejs/node/commit/1de437527e)] - **build**: configure with shared sqlite3 (Chengzhong Wu) [#53519](https://github.com/nodejs/node/pull/53519)
* \[[`c7d44ba1f3`](https://github.com/nodejs/node/commit/c7d44ba1f3)] - **build**: find version of Clang installed on Windows (Stefan Stojanovic) [#53228](https://github.com/nodejs/node/pull/53228)
* \[[`36aad8b204`](https://github.com/nodejs/node/commit/36aad8b204)] - **build**: fix spacing before NINJA\_ARGS (jakecastelli) [#53181](https://github.com/nodejs/node/pull/53181)
* \[[`82092cdaa3`](https://github.com/nodejs/node/commit/82092cdaa3)] - **crypto**: improve GetECGroupBits signature (Tobias Nießen) [#53364](https://github.com/nodejs/node/pull/53364)
* \[[`073c231607`](https://github.com/nodejs/node/commit/073c231607)] - **deps**: update c-ares to v1.31.0 (Node.js GitHub Bot) [#53554](https://github.com/nodejs/node/pull/53554)
* \[[`977beab729`](https://github.com/nodejs/node/commit/977beab729)] - **(SEMVER-MINOR)** **deps**: sqlite: fix Windows compilation (Colin Ihrig) [#52435](https://github.com/nodejs/node/pull/52435)
* \[[`e69b8d202c`](https://github.com/nodejs/node/commit/e69b8d202c)] - **deps**: update undici to 6.19.2 (Node.js GitHub Bot) [#53468](https://github.com/nodejs/node/pull/53468)
* \[[`c4a7e051c8`](https://github.com/nodejs/node/commit/c4a7e051c8)] - **deps**: update undici to 6.19.1 (Node.js GitHub Bot) [#53468](https://github.com/nodejs/node/pull/53468)
* \[[`fa34f8fcf0`](https://github.com/nodejs/node/commit/fa34f8fcf0)] - **deps**: update undici to 6.19.1 (Node.js GitHub Bot) [#53468](https://github.com/nodejs/node/pull/53468)
* \[[`0b40bfad43`](https://github.com/nodejs/node/commit/0b40bfad43)] - **deps**: update undici to 6.19.0 (Node.js GitHub Bot) [#53468](https://github.com/nodejs/node/pull/53468)
* \[[`1877f22a79`](https://github.com/nodejs/node/commit/1877f22a79)] - **deps**: update simdjson to 3.9.4 (Node.js GitHub Bot) [#53467](https://github.com/nodejs/node/pull/53467)
* \[[`1b84964b8d`](https://github.com/nodejs/node/commit/1b84964b8d)] - **deps**: patch V8 to 12.4.254.21 (Node.js GitHub Bot) [#53470](https://github.com/nodejs/node/pull/53470)
* \[[`6acadeb59b`](https://github.com/nodejs/node/commit/6acadeb59b)] - **deps**: update acorn-walk to 8.3.3 (Node.js GitHub Bot) [#53466](https://github.com/nodejs/node/pull/53466)
* \[[`7a7f438841`](https://github.com/nodejs/node/commit/7a7f438841)] - **deps**: update zlib to 1.3.0.1-motley-209717d (Node.js GitHub Bot) [#53156](https://github.com/nodejs/node/pull/53156)
* \[[`bf891bf64c`](https://github.com/nodejs/node/commit/bf891bf64c)] - **deps**: update c-ares to v1.30.0 (Node.js GitHub Bot) [#53416](https://github.com/nodejs/node/pull/53416)
* \[[`bd68888261`](https://github.com/nodejs/node/commit/bd68888261)] - **deps**: V8: cherry-pick a3cc8522a4c8 (kxxt) [#53412](https://github.com/nodejs/node/pull/53412)
* \[[`2defaaf771`](https://github.com/nodejs/node/commit/2defaaf771)] - **deps**: V8: cherry-pick 6ea594ff7132 (kxxt) [#53412](https://github.com/nodejs/node/pull/53412)
* \[[`9e30724b53`](https://github.com/nodejs/node/commit/9e30724b53)] - **(SEMVER-MINOR)** **deps,lib,src**: add experimental web storage (Colin Ihrig) [#52435](https://github.com/nodejs/node/pull/52435)
* \[[`608cc05de1`](https://github.com/nodejs/node/commit/608cc05de1)] - **doc**: recommend not using libuv node-api function (Michael Dawson) [#53521](https://github.com/nodejs/node/pull/53521)
* \[[`30858eca59`](https://github.com/nodejs/node/commit/30858eca59)] - **doc**: add additional guidance for PRs to deps (Michael Dawson) [#53499](https://github.com/nodejs/node/pull/53499)
* \[[`a5852cc710`](https://github.com/nodejs/node/commit/a5852cc710)] - **doc**: only apply content-visibility on all.html (Filip Skokan) [#53510](https://github.com/nodejs/node/pull/53510)
* \[[`befabe5c58`](https://github.com/nodejs/node/commit/befabe5c58)] - **doc**: update the description of the return type for options.filter (Zhenwei Jin) [#52742](https://github.com/nodejs/node/pull/52742)
* \[[`5ed1a036ba`](https://github.com/nodejs/node/commit/5ed1a036ba)] - **doc**: remove first timer badge (Aviv Keller) [#53338](https://github.com/nodejs/node/pull/53338)
* \[[`201266706b`](https://github.com/nodejs/node/commit/201266706b)] - **doc**: move `node --run` stability to rc (Yagiz Nizipli) [#53433](https://github.com/nodejs/node/pull/53433)
* \[[`46a7681cc4`](https://github.com/nodejs/node/commit/46a7681cc4)] - **doc**: add Buffer.from(string) to functions that use buffer pool (Christian Bates-White) [#52801](https://github.com/nodejs/node/pull/52801)
* \[[`ec5364f6de`](https://github.com/nodejs/node/commit/ec5364f6de)] - **doc**: add initial text for ambassadors program (Michael Dawson) [#52857](https://github.com/nodejs/node/pull/52857)
* \[[`fa113b8fc7`](https://github.com/nodejs/node/commit/fa113b8fc7)] - **doc**: fix typo (EhsanKhaki) [#53397](https://github.com/nodejs/node/pull/53397)
* \[[`d9182d0086`](https://github.com/nodejs/node/commit/d9182d0086)] - **doc**: define more cases for stream event emissions (Aviv Keller) [#53317](https://github.com/nodejs/node/pull/53317)
* \[[`923d24b6f2`](https://github.com/nodejs/node/commit/923d24b6f2)] - **doc**: remove mentions of policy model from security info (Aviv Keller) [#53249](https://github.com/nodejs/node/pull/53249)
* \[[`48f78cd31b`](https://github.com/nodejs/node/commit/48f78cd31b)] - **doc**: fix mistakes in the module `load` hook api (István Donkó) [#53349](https://github.com/nodejs/node/pull/53349)
* \[[`16c0884d48`](https://github.com/nodejs/node/commit/16c0884d48)] - **doc**: mark WebSocket as stable (Matthew Aitken) [#53352](https://github.com/nodejs/node/pull/53352)
* \[[`df4762722c`](https://github.com/nodejs/node/commit/df4762722c)] - **doc**: doc-only deprecate OpenSSL engine-based APIs (Richard Lau) [#53329](https://github.com/nodejs/node/pull/53329)
* \[[`cf375e73c1`](https://github.com/nodejs/node/commit/cf375e73c1)] - **doc**: mark --heap-prof and related flags stable (Joyee Cheung) [#53343](https://github.com/nodejs/node/pull/53343)
* \[[`0160745057`](https://github.com/nodejs/node/commit/0160745057)] - **doc**: mark --cpu-prof and related flags stable (Joyee Cheung) [#53343](https://github.com/nodejs/node/pull/53343)
* \[[`6e12d9f049`](https://github.com/nodejs/node/commit/6e12d9f049)] - **doc**: remove IRC from man page (Tobias Nießen) [#53344](https://github.com/nodejs/node/pull/53344)
* \[[`24c7a9415b`](https://github.com/nodejs/node/commit/24c7a9415b)] - **doc, http**: add `rejectNonStandardBodyWrites` option, clear its behaviour (jakecastelli) [#53396](https://github.com/nodejs/node/pull/53396)
* \[[`ec38f3dc6a`](https://github.com/nodejs/node/commit/ec38f3dc6a)] - **doc, meta**: organize contributing to Node-API guide (Aviv Keller) [#53243](https://github.com/nodejs/node/pull/53243)
* \[[`cf5a973c42`](https://github.com/nodejs/node/commit/cf5a973c42)] - **doc, meta**: use markdown rather than HTML in CONTRIBUTING.md (Aviv Keller) [#53235](https://github.com/nodejs/node/pull/53235)
* \[[`105b006fd2`](https://github.com/nodejs/node/commit/105b006fd2)] - **fs**: move `ToNamespacedPath` to c++ (Yagiz Nizipli) [#52135](https://github.com/nodejs/node/pull/52135)
* \[[`568377f7f0`](https://github.com/nodejs/node/commit/568377f7f0)] - **fs**: do not crash if the watched file is removed while setting up watch (Matteo Collina) [#53452](https://github.com/nodejs/node/pull/53452)
* \[[`fad179307c`](https://github.com/nodejs/node/commit/fad179307c)] - **fs**: add fast api for `InternalModuleStat` (Yagiz Nizipli) [#51344](https://github.com/nodejs/node/pull/51344)
* \[[`41100b65f6`](https://github.com/nodejs/node/commit/41100b65f6)] - **http2**: reject failed http2.connect when used with promisify (ehsankhfr) [#53475](https://github.com/nodejs/node/pull/53475)
* \[[`ad5282e196`](https://github.com/nodejs/node/commit/ad5282e196)] - **inspector**: fix disable async hooks on Debugger.setAsyncCallStackDepth (Joyee Cheung) [#53473](https://github.com/nodejs/node/pull/53473)
* \[[`b5fc227344`](https://github.com/nodejs/node/commit/b5fc227344)] - **lib**: fix typo in comment (codediverdev) [#53543](https://github.com/nodejs/node/pull/53543)
* \[[`e95af740fc`](https://github.com/nodejs/node/commit/e95af740fc)] - **(SEMVER-MINOR)** **lib**: add diagnostics\_channel events to module loading (RafaelGSS) [#44340](https://github.com/nodejs/node/pull/44340)
* \[[`123910f1de`](https://github.com/nodejs/node/commit/123910f1de)] - **lib**: remove the unused code (theanarkh) [#53463](https://github.com/nodejs/node/pull/53463)
* \[[`452011b719`](https://github.com/nodejs/node/commit/452011b719)] - **lib**: speed up MessageEvent creation internally (Matthew Aitken) [#52951](https://github.com/nodejs/node/pull/52951)
* \[[`710cf7758c`](https://github.com/nodejs/node/commit/710cf7758c)] - **lib**: reduce amount of caught URL errors (Yagiz Nizipli) [#52658](https://github.com/nodejs/node/pull/52658)
* \[[`45b59e58d1`](https://github.com/nodejs/node/commit/45b59e58d1)] - **lib**: fix naming convention of `Symbol` (Deokjin Kim) [#53387](https://github.com/nodejs/node/pull/53387)
* \[[`515dd24ee7`](https://github.com/nodejs/node/commit/515dd24ee7)] - **lib**: fix timer leak (theanarkh) [#53337](https://github.com/nodejs/node/pull/53337)
* \[[`77166137be`](https://github.com/nodejs/node/commit/77166137be)] - **meta**: use correct source for workflow in PR (Aviv Keller) [#53490](https://github.com/nodejs/node/pull/53490)
* \[[`d1c10fee53`](https://github.com/nodejs/node/commit/d1c10fee53)] - **meta**: move one or more collaborators to emeritus (Node.js GitHub Bot) [#53480](https://github.com/nodejs/node/pull/53480)
* \[[`a5026386bf`](https://github.com/nodejs/node/commit/a5026386bf)] - **meta**: fix typo in dependency updates (Aviv Keller) [#53471](https://github.com/nodejs/node/pull/53471)
* \[[`0b9191da99`](https://github.com/nodejs/node/commit/0b9191da99)] - **meta**: bump step-security/harden-runner from 2.7.1 to 2.8.0 (dependabot\[bot]) [#53245](https://github.com/nodejs/node/pull/53245)
* \[[`49cfb9d001`](https://github.com/nodejs/node/commit/49cfb9d001)] - **src**: reset `process.versions` during pre-execution (Richard Lau) [#53444](https://github.com/nodejs/node/pull/53444)
* \[[`15df4edd22`](https://github.com/nodejs/node/commit/15df4edd22)] - **src**: use `args.This()` instead of `Holder` (Michaël Zasso) [#53474](https://github.com/nodejs/node/pull/53474)
* \[[`e16a04e852`](https://github.com/nodejs/node/commit/e16a04e852)] - **src**: fix dynamically linked OpenSSL version (Richard Lau) [#53456](https://github.com/nodejs/node/pull/53456)
* \[[`5961253824`](https://github.com/nodejs/node/commit/5961253824)] - **src**: remove `base64` from `process.versions` (Richard Lau) [#53442](https://github.com/nodejs/node/pull/53442)
* \[[`11dd15c0b5`](https://github.com/nodejs/node/commit/11dd15c0b5)] - **src**: remove `SetEncoding` from StringEncoder (Yagiz Nizipli) [#53441](https://github.com/nodejs/node/pull/53441)
* \[[`0c7e69acd2`](https://github.com/nodejs/node/commit/0c7e69acd2)] - **src**: simplify `size() == 0` checks (Yagiz Nizipli) [#53440](https://github.com/nodejs/node/pull/53440)
* \[[`f077afafda`](https://github.com/nodejs/node/commit/f077afafda)] - **src**: add utilities to help debugging reproducibility of snapshots (Joyee Cheung) [#50983](https://github.com/nodejs/node/pull/50983)
* \[[`004b9ea4c4`](https://github.com/nodejs/node/commit/004b9ea4c4)] - **src**: make sure that memcpy-ed structs in snapshot have no padding (Joyee Cheung) [#50983](https://github.com/nodejs/node/pull/50983)
* \[[`bfc5236423`](https://github.com/nodejs/node/commit/bfc5236423)] - **src**: return non-empty data in context data serializer (Joyee Cheung) [#50983](https://github.com/nodejs/node/pull/50983)
* \[[`955454ba4d`](https://github.com/nodejs/node/commit/955454ba4d)] - **src**: fix typo in env.cc (EhsanKhaki) [#53418](https://github.com/nodejs/node/pull/53418)
* \[[`7d8787768c`](https://github.com/nodejs/node/commit/7d8787768c)] - **src**: avoid strcmp in favor of operator== (Tobias Nießen) [#53439](https://github.com/nodejs/node/pull/53439)
* \[[`599e7c3d8e`](https://github.com/nodejs/node/commit/599e7c3d8e)] - **src**: remove ArrayBufferAllocator::Reallocate override (Shu-yu Guo) [#52910](https://github.com/nodejs/node/pull/52910)
* \[[`f9075ff38e`](https://github.com/nodejs/node/commit/f9075ff38e)] - **src**: print v8::OOMDetails::detail when it's available (Joyee Cheung) [#53360](https://github.com/nodejs/node/pull/53360)
* \[[`4704270443`](https://github.com/nodejs/node/commit/4704270443)] - **src**: fix IsIPAddress for IPv6 (Hüseyin Açacak) [#53400](https://github.com/nodejs/node/pull/53400)
* \[[`63f62d76de`](https://github.com/nodejs/node/commit/63f62d76de)] - **src**: fix permission inspector crash (theanarkh) [#53389](https://github.com/nodejs/node/pull/53389)
* \[[`70bbc02dac`](https://github.com/nodejs/node/commit/70bbc02dac)] - **src, deps**: add nbytes library (James M Snell) [#53507](https://github.com/nodejs/node/pull/53507)
* \[[`8b877099d0`](https://github.com/nodejs/node/commit/8b877099d0)] - **stream**: update outdated highwatermark doc (Jay Kim) [#53494](https://github.com/nodejs/node/pull/53494)
* \[[`eded1e9768`](https://github.com/nodejs/node/commit/eded1e9768)] - **stream**: support dispose in writable (Benjamin Gruenbaum) [#48547](https://github.com/nodejs/node/pull/48547)
* \[[`b3372a8b0e`](https://github.com/nodejs/node/commit/b3372a8b0e)] - **stream**: callback should be called when pendingcb is 0 (jakecastelli) [#53438](https://github.com/nodejs/node/pull/53438)
* \[[`f4efb7f625`](https://github.com/nodejs/node/commit/f4efb7f625)] - **stream**: make sure \_destroy is called (jakecastelli) [#53213](https://github.com/nodejs/node/pull/53213)
* \[[`7dde37591c`](https://github.com/nodejs/node/commit/7dde37591c)] - **stream**: prevent stream unexpected pause when highWaterMark set to 0 (jakecastelli) [#53261](https://github.com/nodejs/node/pull/53261)
* \[[`6e66d9763f`](https://github.com/nodejs/node/commit/6e66d9763f)] - **test**: mark `test-benchmark-crypto` as flaky (Antoine du Hamel) [#52955](https://github.com/nodejs/node/pull/52955)
* \[[`1eebcbf9bf`](https://github.com/nodejs/node/commit/1eebcbf9bf)] - **test**: skip reproducible snapshot test on 32-bit (Michaël Zasso) [#53592](https://github.com/nodejs/node/pull/53592)
* \[[`91b2850303`](https://github.com/nodejs/node/commit/91b2850303)] - **test**: extend env for `test-node-output-errors` (Richard Lau) [#53535](https://github.com/nodejs/node/pull/53535)
* \[[`bcad560726`](https://github.com/nodejs/node/commit/bcad560726)] - **test**: update `compression` web-platform tests (Yagiz Nizipli) [#53478](https://github.com/nodejs/node/pull/53478)
* \[[`b8f436c755`](https://github.com/nodejs/node/commit/b8f436c755)] - **test**: update encoding web-platform tests (Yagiz Nizipli) [#53477](https://github.com/nodejs/node/pull/53477)
* \[[`d2c169a4f6`](https://github.com/nodejs/node/commit/d2c169a4f6)] - **test**: update `url` web-platform tests (Yagiz Nizipli) [#53472](https://github.com/nodejs/node/pull/53472)
* \[[`513e6aa4c7`](https://github.com/nodejs/node/commit/513e6aa4c7)] - **test**: check against run-time OpenSSL version (Richard Lau) [#53456](https://github.com/nodejs/node/pull/53456)
* \[[`602b9d63c4`](https://github.com/nodejs/node/commit/602b9d63c4)] - **test**: update tests for OpenSSL 3.0.14 (Richard Lau) [#53373](https://github.com/nodejs/node/pull/53373)
* \[[`4a3525bb08`](https://github.com/nodejs/node/commit/4a3525bb08)] - **test**: fix test-http-server-keepalive-req-gc (Etienne Pierre-doray) [#53292](https://github.com/nodejs/node/pull/53292)
* \[[`7349edb28b`](https://github.com/nodejs/node/commit/7349edb28b)] - **test**: update TLS tests for OpenSSL 3.2 (Richard Lau) [#53384](https://github.com/nodejs/node/pull/53384)
* \[[`a11a05763d`](https://github.com/nodejs/node/commit/a11a05763d)] - **tls**: check result of SSL\_CTX\_set\_\*\_proto\_version (Tobias Nießen) [#53459](https://github.com/nodejs/node/pull/53459)
* \[[`4b47f89eb2`](https://github.com/nodejs/node/commit/4b47f89eb2)] - **tls**: avoid taking ownership of OpenSSL objects (Tobias Nießen) [#53436](https://github.com/nodejs/node/pull/53436)
* \[[`ac8adeb99f`](https://github.com/nodejs/node/commit/ac8adeb99f)] - **tls**: use SSL\_get\_peer\_tmp\_key (Tobias Nießen) [#53366](https://github.com/nodejs/node/pull/53366)
* \[[`d5c380bb09`](https://github.com/nodejs/node/commit/d5c380bb09)] - **tools**: lock versions of irrelevant DB deps (Michaël Zasso) [#53546](https://github.com/nodejs/node/pull/53546)
* \[[`71321bb249`](https://github.com/nodejs/node/commit/71321bb249)] - **tools**: fix skip detection of test runner output (Richard Lau) [#53545](https://github.com/nodejs/node/pull/53545)
* \[[`ca198f4125`](https://github.com/nodejs/node/commit/ca198f4125)] - **tools**: update eslint to 9.5.0 (Node.js GitHub Bot) [#53515](https://github.com/nodejs/node/pull/53515)
* \[[`30fdd482a1`](https://github.com/nodejs/node/commit/30fdd482a1)] - **tools**: move ESLint to tools/eslint (Michaël Zasso) [#53413](https://github.com/nodejs/node/pull/53413)
* \[[`fe85e05ba9`](https://github.com/nodejs/node/commit/fe85e05ba9)] - **tools**: fix c-ares update script (Marco Ippolito) [#53414](https://github.com/nodejs/node/pull/53414)
* \[[`8eb7bdf81b`](https://github.com/nodejs/node/commit/8eb7bdf81b)] - **tools**: update lint-md-dependencies (Node.js GitHub Bot) [#53158](https://github.com/nodejs/node/pull/53158)
* \[[`9ece63d415`](https://github.com/nodejs/node/commit/9ece63d415)] - **tools**: do not run Corepack code before it's reviewed (Antoine du Hamel) [#53405](https://github.com/nodejs/node/pull/53405)
* \[[`ab2021492b`](https://github.com/nodejs/node/commit/ab2021492b)] - **tools**: move ESLint tools to tools/eslint (Michaël Zasso) [#53393](https://github.com/nodejs/node/pull/53393)
* \[[`78a9037a6d`](https://github.com/nodejs/node/commit/78a9037a6d)] - **tools**: use Ubuntu 24.04 and Clang on GitHub actions (Michaël Zasso) [#53212](https://github.com/nodejs/node/pull/53212)
* \[[`855eb25dad`](https://github.com/nodejs/node/commit/855eb25dad)] - **tools**: add stream label on PR when related files being changed in lib (jakecastelli) [#53269](https://github.com/nodejs/node/pull/53269)
* \[[`50733a1abe`](https://github.com/nodejs/node/commit/50733a1abe)] - **(SEMVER-MINOR)** **util**: support `--no-` for argument with boolean type for parseArgs (Zhenwei Jin) [#53107](https://github.com/nodejs/node/pull/53107)

<a id="22.3.0"></a>

## 2024-06-11, Version 22.3.0 (Current), @RafaelGSS

### Notable Changes

* \[[`5a41bcf9ca`](https://github.com/nodejs/node/commit/5a41bcf9ca)] - **(SEMVER-MINOR)** **src**: traverse parent folders while running `--run` (Yagiz Nizipli) [#53154](https://github.com/nodejs/node/pull/53154)
* \[[`1d5934524b`](https://github.com/nodejs/node/commit/1d5934524b)] - **(SEMVER-MINOR)** **buffer**: add .bytes() method to Blob (Matthew Aitken) [#53221](https://github.com/nodejs/node/pull/53221)
* \[[`75e5612fae`](https://github.com/nodejs/node/commit/75e5612fae)] - **(SEMVER-MINOR)** **src,permission**: --allow-wasi & prevent WASI exec (Rafael Gonzaga) [#53124](https://github.com/nodejs/node/pull/53124)
* \[[`b5c30e2f5e`](https://github.com/nodejs/node/commit/b5c30e2f5e)] - **(SEMVER-MINOR)** **module**: print amount of load time of a cjs module (Vinicius Lourenço) [#52213](https://github.com/nodejs/node/pull/52213)
* \[[`8c6dffc269`](https://github.com/nodejs/node/commit/8c6dffc269)] - **(SEMVER-MINOR)** **test\_runner**: add snapshot testing (Colin Ihrig) [#53169](https://github.com/nodejs/node/pull/53169)
* \[[`048478d351`](https://github.com/nodejs/node/commit/048478d351)] - **(SEMVER-MINOR)** **doc**: add context.assert docs (Colin Ihrig) [#53169](https://github.com/nodejs/node/pull/53169)
* \[[`f6d2af8ee7`](https://github.com/nodejs/node/commit/f6d2af8ee7)] - **(SEMVER-MINOR)** **test\_runner**: add context.fullName (Colin Ihrig) [#53169](https://github.com/nodejs/node/pull/53169)
* \[[`a0766bdf0e`](https://github.com/nodejs/node/commit/a0766bdf0e)] - **(SEMVER-MINOR)** **net**: add new net.server.listen tracing channel (Paolo Insogna) [#53136](https://github.com/nodejs/node/pull/53136)
* \[[`374743cd4e`](https://github.com/nodejs/node/commit/374743cd4e)] - **(SEMVER-MINOR)** **process**: add process.getBuiltinModule(id) (Joyee Cheung) [#52762](https://github.com/nodejs/node/pull/52762)
* \[[`1eb55f3550`](https://github.com/nodejs/node/commit/1eb55f3550)] - **(SEMVER-MINOR)** **doc**: improve explanation about built-in modules (Joyee Cheung) [#52762](https://github.com/nodejs/node/pull/52762)
* \[[`6165894774`](https://github.com/nodejs/node/commit/6165894774)] - **fs**: mark recursive cp methods as stable (Théo LUDWIG) [#53127](https://github.com/nodejs/node/pull/53127)
* \[[`db5dd0c6df`](https://github.com/nodejs/node/commit/db5dd0c6df)] - **doc**: add StefanStojanovic to collaborators (StefanStojanovic) [#53118](https://github.com/nodejs/node/pull/53118)
* \[[`cfcde78513`](https://github.com/nodejs/node/commit/cfcde78513)] - **(SEMVER-MINOR)** **cli**: add `NODE_RUN_PACKAGE_JSON_PATH` env (Yagiz Nizipli) [#53058](https://github.com/nodejs/node/pull/53058)
* \[[`7a67ecf161`](https://github.com/nodejs/node/commit/7a67ecf161)] - **(SEMVER-MINOR)** **test\_runner**: support module mocking (Colin Ihrig) [#52848](https://github.com/nodejs/node/pull/52848)
* \[[`ee56aecced`](https://github.com/nodejs/node/commit/ee56aecced)] - **(SEMVER-MINOR)** **lib**: add EventSource Client (Aras Abbasi) [#51575](https://github.com/nodejs/node/pull/51575)
* \[[`6413769bc7`](https://github.com/nodejs/node/commit/6413769bc7)] - **(SEMVER-MINOR)** **lib**: replace MessageEvent with undici's (Matthew Aitken) [#52370](https://github.com/nodejs/node/pull/52370)
* \[[`c70b2f7a76`](https://github.com/nodejs/node/commit/c70b2f7a76)] - **(SEMVER-MINOR)** **cli**: add `NODE_RUN_SCRIPT_NAME` env to `node --run` (Yagiz Nizipli) [#53032](https://github.com/nodejs/node/pull/53032)
* \[[`badec0c38b`](https://github.com/nodejs/node/commit/badec0c38b)] - **doc**: add Marco Ippolito to TSC (Rafael Gonzaga) [#53008](https://github.com/nodejs/node/pull/53008)

### Commits

* \[[`feb0ba2860`](https://github.com/nodejs/node/commit/feb0ba2860)] - **benchmark**: fix napi/ref addon (Michaël Zasso) [#53233](https://github.com/nodejs/node/pull/53233)
* \[[`bb844de4e1`](https://github.com/nodejs/node/commit/bb844de4e1)] - **benchmark**: fix api restriction for the permission category (Ryan Tsien) [#51528](https://github.com/nodejs/node/pull/51528)
* \[[`1d5934524b`](https://github.com/nodejs/node/commit/1d5934524b)] - **(SEMVER-MINOR)** **buffer**: add .bytes() method to Blob (Matthew Aitken) [#53221](https://github.com/nodejs/node/pull/53221)
* \[[`d87f9af5aa`](https://github.com/nodejs/node/commit/d87f9af5aa)] - **buffer**: make compare/equals faster (Tobias Nießen) [#52993](https://github.com/nodejs/node/pull/52993)
* \[[`ec83431d71`](https://github.com/nodejs/node/commit/ec83431d71)] - **build**: generate binlog in out directories (Chengzhong Wu) [#53325](https://github.com/nodejs/node/pull/53325)
* \[[`0976439417`](https://github.com/nodejs/node/commit/0976439417)] - **build**: fix --v8-lite-mode build (Daeyeon Jeong) [#52725](https://github.com/nodejs/node/pull/52725)
* \[[`350c733ae6`](https://github.com/nodejs/node/commit/350c733ae6)] - **build**: support python 3.13 (Chengzhong Wu) [#53190](https://github.com/nodejs/node/pull/53190)
* \[[`74cefa55a2`](https://github.com/nodejs/node/commit/74cefa55a2)] - **build**: update ruff to v0.4.5 (Yagiz Nizipli) [#53180](https://github.com/nodejs/node/pull/53180)
* \[[`33242ff042`](https://github.com/nodejs/node/commit/33242ff042)] - **build**: add `--skip-tests` to `test-ci-js` target (Antoine du Hamel) [#53105](https://github.com/nodejs/node/pull/53105)
* \[[`edcadf7f8a`](https://github.com/nodejs/node/commit/edcadf7f8a)] - **build**: fix building embedtest in GN build (Cheng) [#53145](https://github.com/nodejs/node/pull/53145)
* \[[`d711942fce`](https://github.com/nodejs/node/commit/d711942fce)] - **build**: use broader detection for 'help' (Aviv Keller) [#53045](https://github.com/nodejs/node/pull/53045)
* \[[`ca655b61a7`](https://github.com/nodejs/node/commit/ca655b61a7)] - **build**: fix -j propagation to ninja (Tobias Nießen) [#53088](https://github.com/nodejs/node/pull/53088)
* \[[`5fba67ff9f`](https://github.com/nodejs/node/commit/5fba67ff9f)] - **build**: exit on unsupported host OS for Android (Mohammed Keyvanzadeh) [#52882](https://github.com/nodejs/node/pull/52882)
* \[[`b7d7e9a084`](https://github.com/nodejs/node/commit/b7d7e9a084)] - **build**: fix `--enable-d8` builds (Richard Lau) [#53106](https://github.com/nodejs/node/pull/53106)
* \[[`14547c5d32`](https://github.com/nodejs/node/commit/14547c5d32)] - **build**: fix ./configure --help format error (Zhenwei Jin) [#53066](https://github.com/nodejs/node/pull/53066)
* \[[`f9490806d3`](https://github.com/nodejs/node/commit/f9490806d3)] - **build**: set "clang" in config.gypi in GN build (Cheng) [#53004](https://github.com/nodejs/node/pull/53004)
* \[[`638b510ce7`](https://github.com/nodejs/node/commit/638b510ce7)] - **cli**: add `--expose-gc` flag available to `NODE_OPTIONS` (Juan José) [#53078](https://github.com/nodejs/node/pull/53078)
* \[[`cfcde78513`](https://github.com/nodejs/node/commit/cfcde78513)] - **(SEMVER-MINOR)** **cli**: add `NODE_RUN_PACKAGE_JSON_PATH` env (Yagiz Nizipli) [#53058](https://github.com/nodejs/node/pull/53058)
* \[[`c70b2f7a76`](https://github.com/nodejs/node/commit/c70b2f7a76)] - **(SEMVER-MINOR)** **cli**: add `NODE_RUN_SCRIPT_NAME` env to `node --run` (Yagiz Nizipli) [#53032](https://github.com/nodejs/node/pull/53032)
* \[[`34f20983fd`](https://github.com/nodejs/node/commit/34f20983fd)] - **crypto**: fix propagation of "memory limit exceeded" (Tobias Nießen) [#53300](https://github.com/nodejs/node/pull/53300)
* \[[`fef067f4f4`](https://github.com/nodejs/node/commit/fef067f4f4)] - **deps**: update nghttp2 to 1.62.1 (Node.js GitHub Bot) [#52966](https://github.com/nodejs/node/pull/52966)
* \[[`fc949928ac`](https://github.com/nodejs/node/commit/fc949928ac)] - **deps**: update nghttp2 to 1.62.0 (Node.js GitHub Bot) [#52966](https://github.com/nodejs/node/pull/52966)
* \[[`4a17dda8dc`](https://github.com/nodejs/node/commit/4a17dda8dc)] - **deps**: update undici to 6.18.2 (Node.js GitHub Bot) [#53255](https://github.com/nodejs/node/pull/53255)
* \[[`e45cc2a551`](https://github.com/nodejs/node/commit/e45cc2a551)] - **deps**: update ada to 2.8.0 (Node.js GitHub Bot) [#53254](https://github.com/nodejs/node/pull/53254)
* \[[`77907a2619`](https://github.com/nodejs/node/commit/77907a2619)] - **deps**: update corepack to 0.28.2 (Node.js GitHub Bot) [#53253](https://github.com/nodejs/node/pull/53253)
* \[[`b688050778`](https://github.com/nodejs/node/commit/b688050778)] - **deps**: update simdjson to 3.9.3 (Node.js GitHub Bot) [#53252](https://github.com/nodejs/node/pull/53252)
* \[[`6303f19cbe`](https://github.com/nodejs/node/commit/6303f19cbe)] - **deps**: patch V8 to 12.4.254.20 (Node.js GitHub Bot) [#53159](https://github.com/nodejs/node/pull/53159)
* \[[`257004c68f`](https://github.com/nodejs/node/commit/257004c68f)] - **deps**: update c-ares to 1.29.0 (Node.js GitHub Bot) [#53155](https://github.com/nodejs/node/pull/53155)
* \[[`0b375a3e36`](https://github.com/nodejs/node/commit/0b375a3e36)] - **deps**: upgrade npm to 10.8.1 (npm team) [#53207](https://github.com/nodejs/node/pull/53207)
* \[[`728c861b1c`](https://github.com/nodejs/node/commit/728c861b1c)] - **deps**: fix FP16 bitcasts.h (Stefan Stojanovic) [#53134](https://github.com/nodejs/node/pull/53134)
* \[[`52a78737b1`](https://github.com/nodejs/node/commit/52a78737b1)] - **deps**: patch V8 to 12.4.254.19 (Node.js GitHub Bot) [#53094](https://github.com/nodejs/node/pull/53094)
* \[[`4d27b32e58`](https://github.com/nodejs/node/commit/4d27b32e58)] - **deps**: update undici to 6.18.1 (Node.js GitHub Bot) [#53073](https://github.com/nodejs/node/pull/53073)
* \[[`b94199240b`](https://github.com/nodejs/node/commit/b94199240b)] - **deps**: update undici to 6.18.0 (Node.js GitHub Bot) [#53073](https://github.com/nodejs/node/pull/53073)
* \[[`793af1b3e7`](https://github.com/nodejs/node/commit/793af1b3e7)] - **deps**: update undici to 6.17.0 (Node.js GitHub Bot) [#53034](https://github.com/nodejs/node/pull/53034)
* \[[`fe00becc03`](https://github.com/nodejs/node/commit/fe00becc03)] - **deps**: update undici to 6.16.1 (Node.js GitHub Bot) [#52948](https://github.com/nodejs/node/pull/52948)
* \[[`96f72ae54f`](https://github.com/nodejs/node/commit/96f72ae54f)] - **deps**: update undici to 6.15.0 (Matthew Aitken) [#52763](https://github.com/nodejs/node/pull/52763)
* \[[`af60fbb12b`](https://github.com/nodejs/node/commit/af60fbb12b)] - **deps**: update googletest to 33af80a (Node.js GitHub Bot) [#53053](https://github.com/nodejs/node/pull/53053)
* \[[`7b929df489`](https://github.com/nodejs/node/commit/7b929df489)] - **deps**: patch V8 to 12.4.254.18 (Node.js GitHub Bot) [#53054](https://github.com/nodejs/node/pull/53054)
* \[[`626037c0fc`](https://github.com/nodejs/node/commit/626037c0fc)] - **deps**: update zlib to 1.3.0.1-motley-4f653ff (Node.js GitHub Bot) [#53052](https://github.com/nodejs/node/pull/53052)
* \[[`6d8589e558`](https://github.com/nodejs/node/commit/6d8589e558)] - **deps**: patch V8 to 12.4.254.17 (Node.js GitHub Bot) [#52980](https://github.com/nodejs/node/pull/52980)
* \[[`fd91eaab34`](https://github.com/nodejs/node/commit/fd91eaab34)] - **deps**: upgrade npm to 10.8.0 (npm team) [#53014](https://github.com/nodejs/node/pull/53014)
* \[[`133cae0732`](https://github.com/nodejs/node/commit/133cae0732)] - **doc**: fix broken link in `static-analysis.md` (Richard Lau) [#53345](https://github.com/nodejs/node/pull/53345)
* \[[`7bc5f964fd`](https://github.com/nodejs/node/commit/7bc5f964fd)] - **doc**: indicate requirement on VS 17.6 or newer (Chengzhong Wu) [#53301](https://github.com/nodejs/node/pull/53301)
* \[[`8c71522ced`](https://github.com/nodejs/node/commit/8c71522ced)] - **doc**: remove cases for keys not containing "\*" in PATTERN\_KEY\_COMPARE (Maarten Zuidhoorn) [#53215](https://github.com/nodejs/node/pull/53215)
* \[[`718a3ab1ab`](https://github.com/nodejs/node/commit/718a3ab1ab)] - **doc**: add err param to fs.cp callback (Feng Yu) [#53234](https://github.com/nodejs/node/pull/53234)
* \[[`d89bde26ff`](https://github.com/nodejs/node/commit/d89bde26ff)] - **doc**: add `err` param to fs.copyFile callback (Feng Yu) [#53234](https://github.com/nodejs/node/pull/53234)
* \[[`91971ee344`](https://github.com/nodejs/node/commit/91971ee344)] - **doc**: reserve 128 for Electron 32 (Keeley Hammond) [#53203](https://github.com/nodejs/node/pull/53203)
* \[[`812f0e9e14`](https://github.com/nodejs/node/commit/812f0e9e14)] - **doc**: add note to ninjia build for macOS using -jn flag (jakecastelli) [#53187](https://github.com/nodejs/node/pull/53187)
* \[[`048478d351`](https://github.com/nodejs/node/commit/048478d351)] - **(SEMVER-MINOR)** **doc**: add context.assert docs (Colin Ihrig) [#53169](https://github.com/nodejs/node/pull/53169)
* \[[`c391923445`](https://github.com/nodejs/node/commit/c391923445)] - **doc**: include ESM import for HTTP (Aviv Keller) [#53165](https://github.com/nodejs/node/pull/53165)
* \[[`1eb55f3550`](https://github.com/nodejs/node/commit/1eb55f3550)] - **(SEMVER-MINOR)** **doc**: improve explanation about built-in modules (Joyee Cheung) [#52762](https://github.com/nodejs/node/pull/52762)
* \[[`67a766f7d4`](https://github.com/nodejs/node/commit/67a766f7d4)] - **doc**: fix minor grammar and style issues in SECURITY.md (Rich Trott) [#53168](https://github.com/nodejs/node/pull/53168)
* \[[`afbfe8922a`](https://github.com/nodejs/node/commit/afbfe8922a)] - **doc**: mention pm is not enforced when using fd (Rafael Gonzaga) [#53125](https://github.com/nodejs/node/pull/53125)
* \[[`1702d2632e`](https://github.com/nodejs/node/commit/1702d2632e)] - **doc**: fix format in `esm.md` (Pop Moore) [#53170](https://github.com/nodejs/node/pull/53170)
* \[[`070577e7d7`](https://github.com/nodejs/node/commit/070577e7d7)] - **doc**: fix wrong variable name in example of `timers.tick()` (Deokjin Kim) [#53147](https://github.com/nodejs/node/pull/53147)
* \[[`7147c1df1f`](https://github.com/nodejs/node/commit/7147c1df1f)] - **doc**: fix wrong function name in example of `context.plan()` (Deokjin Kim) [#53140](https://github.com/nodejs/node/pull/53140)
* \[[`cf47384148`](https://github.com/nodejs/node/commit/cf47384148)] - **doc**: add note for windows users and symlinks (Aviv Keller) [#53117](https://github.com/nodejs/node/pull/53117)
* \[[`088dff1074`](https://github.com/nodejs/node/commit/088dff1074)] - **doc**: move all TLS-PSK documentation to its section (Alba Mendez) [#35717](https://github.com/nodejs/node/pull/35717)
* \[[`db5dd0c6df`](https://github.com/nodejs/node/commit/db5dd0c6df)] - **doc**: add StefanStojanovic to collaborators (StefanStojanovic) [#53118](https://github.com/nodejs/node/pull/53118)
* \[[`0f0bc98ad7`](https://github.com/nodejs/node/commit/0f0bc98ad7)] - **doc**: improve ninja build for --built-in-modules-path (jakecastelli) [#53007](https://github.com/nodejs/node/pull/53007)
* \[[`4c65c52d30`](https://github.com/nodejs/node/commit/4c65c52d30)] - **doc**: avoid hiding by navigation bar in anchor jumping (Cloyd Lau) [#45131](https://github.com/nodejs/node/pull/45131)
* \[[`63fcbcfd62`](https://github.com/nodejs/node/commit/63fcbcfd62)] - **doc**: remove unavailable youtube link in pull requests (Deokjin Kim) [#52982](https://github.com/nodejs/node/pull/52982)
* \[[`77fd504636`](https://github.com/nodejs/node/commit/77fd504636)] - **doc**: add missing supported timer values in `timers.enable()` (Deokjin Kim) [#52969](https://github.com/nodejs/node/pull/52969)
* \[[`6708536b03`](https://github.com/nodejs/node/commit/6708536b03)] - **fs**: fix cp dir/non-dir mismatch error messages (Mathis Wiehl) [#53150](https://github.com/nodejs/node/pull/53150)
* \[[`6165894774`](https://github.com/nodejs/node/commit/6165894774)] - **fs**: mark recursive cp methods as stable (Théo LUDWIG) [#53127](https://github.com/nodejs/node/pull/53127)
* \[[`7940db7be1`](https://github.com/nodejs/node/commit/7940db7be1)] - **fs**: remove basename in favor of std::filesystem (Yagiz Nizipli) [#53062](https://github.com/nodejs/node/pull/53062)
* \[[`505e9a425b`](https://github.com/nodejs/node/commit/505e9a425b)] - **lib**: fix misleading argument of validateUint32 (Tobias Nießen) [#53307](https://github.com/nodejs/node/pull/53307)
* \[[`98ae1ebdd6`](https://github.com/nodejs/node/commit/98ae1ebdd6)] - **lib**: fix the name of the fetch global function (Gabriel Bota) [#53227](https://github.com/nodejs/node/pull/53227)
* \[[`fe007cd1b4`](https://github.com/nodejs/node/commit/fe007cd1b4)] - **lib**: allow CJS source map cache to be reclaimed (Chengzhong Wu) [#51711](https://github.com/nodejs/node/pull/51711)
* \[[`040be4a7b4`](https://github.com/nodejs/node/commit/040be4a7b4)] - **lib**: do not call callback if socket is closed (theanarkh) [#52829](https://github.com/nodejs/node/pull/52829)
* \[[`ee56aecced`](https://github.com/nodejs/node/commit/ee56aecced)] - **(SEMVER-MINOR)** **lib**: add EventSource Client (Aras Abbasi) [#51575](https://github.com/nodejs/node/pull/51575)
* \[[`6413769bc7`](https://github.com/nodejs/node/commit/6413769bc7)] - **(SEMVER-MINOR)** **lib**: replace MessageEvent with undici's (Matthew Aitken) [#52370](https://github.com/nodejs/node/pull/52370)
* \[[`879679e5a3`](https://github.com/nodejs/node/commit/879679e5a3)] - **lib,doc**: replace references to import assertions (Michaël Zasso) [#52998](https://github.com/nodejs/node/pull/52998)
* \[[`062a0c6f67`](https://github.com/nodejs/node/commit/062a0c6f67)] - **meta**: bump ossf/scorecard-action from 2.3.1 to 2.3.3 (dependabot\[bot]) [#53248](https://github.com/nodejs/node/pull/53248)
* \[[`e59b744b30`](https://github.com/nodejs/node/commit/e59b744b30)] - **meta**: bump actions/checkout from 4.1.4 to 4.1.6 (dependabot\[bot]) [#53247](https://github.com/nodejs/node/pull/53247)
* \[[`96924f48a0`](https://github.com/nodejs/node/commit/96924f48a0)] - **meta**: bump github/codeql-action from 3.25.3 to 3.25.7 (dependabot\[bot]) [#53246](https://github.com/nodejs/node/pull/53246)
* \[[`b7f5662dee`](https://github.com/nodejs/node/commit/b7f5662dee)] - **meta**: bump codecov/codecov-action from 4.3.1 to 4.4.1 (dependabot\[bot]) [#53244](https://github.com/nodejs/node/pull/53244)
* \[[`e079967eb4`](https://github.com/nodejs/node/commit/e079967eb4)] - **meta**: remove `initializeCommand` from devcontainer (Aviv Keller) [#53137](https://github.com/nodejs/node/pull/53137)
* \[[`3afeced572`](https://github.com/nodejs/node/commit/3afeced572)] - **meta**: move one or more collaborators to emeritus (Node.js GitHub Bot) [#53065](https://github.com/nodejs/node/pull/53065)
* \[[`4b9cdea8a6`](https://github.com/nodejs/node/commit/4b9cdea8a6)] - _**Revert**_ "**module**: have a single hooks thread for all workers" (Matteo Collina) [#53183](https://github.com/nodejs/node/pull/53183)
* \[[`b5c30e2f5e`](https://github.com/nodejs/node/commit/b5c30e2f5e)] - **(SEMVER-MINOR)** **module**: print amount of load time of a cjs module (Vinicius Lourenço) [#52213](https://github.com/nodejs/node/pull/52213)
* \[[`4cdb05a7a2`](https://github.com/nodejs/node/commit/4cdb05a7a2)] - **module**: do not set CJS variables for Worker eval (Antoine du Hamel) [#53050](https://github.com/nodejs/node/pull/53050)
* \[[`a0766bdf0e`](https://github.com/nodejs/node/commit/a0766bdf0e)] - **(SEMVER-MINOR)** **net**: add new net.server.listen tracing channel (Paolo Insogna) [#53136](https://github.com/nodejs/node/pull/53136)
* \[[`374743cd4e`](https://github.com/nodejs/node/commit/374743cd4e)] - **(SEMVER-MINOR)** **process**: add process.getBuiltinModule(id) (Joyee Cheung) [#52762](https://github.com/nodejs/node/pull/52762)
* \[[`e66eb376a0`](https://github.com/nodejs/node/commit/e66eb376a0)] - **repl**: fix await object patterns without values (Luke Haas) [#53331](https://github.com/nodejs/node/pull/53331)
* \[[`cb1329a8cf`](https://github.com/nodejs/node/commit/cb1329a8cf)] - **src**: use v8::(Des|S)erializeInternalFieldsCallback (Joyee Cheung) [#53217](https://github.com/nodejs/node/pull/53217)
* \[[`1886fe99af`](https://github.com/nodejs/node/commit/1886fe99af)] - **src**: use \_\_FUNCSIG\_\_ on Windows in backtrace (Joyee Cheung) [#53135](https://github.com/nodejs/node/pull/53135)
* \[[`3bfce6c816`](https://github.com/nodejs/node/commit/3bfce6c816)] - **src**: use new V8 API to define stream accessor (Igor Sheludko) [#53084](https://github.com/nodejs/node/pull/53084)
* \[[`11f790d911`](https://github.com/nodejs/node/commit/11f790d911)] - **src**: do not use deprecated V8 API (ishell) [#53084](https://github.com/nodejs/node/pull/53084)
* \[[`6b1731cbcc`](https://github.com/nodejs/node/commit/6b1731cbcc)] - **src**: convert all endian checks to constexpr (Tobias Nießen) [#52974](https://github.com/nodejs/node/pull/52974)
* \[[`7aa9519ad4`](https://github.com/nodejs/node/commit/7aa9519ad4)] - **src**: fix external module env and kDisableNodeOptionsEnv (Rafael Gonzaga) [#52905](https://github.com/nodejs/node/pull/52905)
* \[[`838fe59787`](https://github.com/nodejs/node/commit/838fe59787)] - **src**: fix execArgv in worker (theanarkh) [#53029](https://github.com/nodejs/node/pull/53029)
* \[[`4a2c6ff05d`](https://github.com/nodejs/node/commit/4a2c6ff05d)] - **src**: reduce unnecessary `GetCwd` calls (Yagiz Nizipli) [#53064](https://github.com/nodejs/node/pull/53064)
* \[[`ec44965b49`](https://github.com/nodejs/node/commit/ec44965b49)] - **src**: simplify node modules traverse path (Yagiz Nizipli) [#53061](https://github.com/nodejs/node/pull/53061)
* \[[`190129b48e`](https://github.com/nodejs/node/commit/190129b48e)] - **src**: remove unused `base64_table_url` (Yagiz Nizipli) [#53040](https://github.com/nodejs/node/pull/53040)
* \[[`d750a3c5c4`](https://github.com/nodejs/node/commit/d750a3c5c4)] - **src**: remove calls to recently deprecated V8 APIs (Adam Klein) [#52996](https://github.com/nodejs/node/pull/52996)
* \[[`f1890abb18`](https://github.com/nodejs/node/commit/f1890abb18)] - **src**: replace deprecated GetImportAssertions V8 API (Michaël Zasso) [#52997](https://github.com/nodejs/node/pull/52997)
* \[[`4347bd2acb`](https://github.com/nodejs/node/commit/4347bd2acb)] - **src**: improve node::Dotenv declarations (Tobias Nießen) [#52973](https://github.com/nodejs/node/pull/52973)
* \[[`e26166f30b`](https://github.com/nodejs/node/commit/e26166f30b)] - **src,permission**: handle process.chdir on pm (Rafael Gonzaga) [#53175](https://github.com/nodejs/node/pull/53175)
* \[[`75e5612fae`](https://github.com/nodejs/node/commit/75e5612fae)] - **(SEMVER-MINOR)** **src,permission**: --allow-wasi & prevent WASI exec (Rafael Gonzaga) [#53124](https://github.com/nodejs/node/pull/53124)
* \[[`7c66b27407`](https://github.com/nodejs/node/commit/7c66b27407)] - **stream**: micro-optimize writable condition (Orgad Shaneh) [#53189](https://github.com/nodejs/node/pull/53189)
* \[[`a656cf6bc8`](https://github.com/nodejs/node/commit/a656cf6bc8)] - **stream**: fix memory usage regression in writable (Orgad Shaneh) [#53188](https://github.com/nodejs/node/pull/53188)
* \[[`0e85a84fdc`](https://github.com/nodejs/node/commit/0e85a84fdc)] - **test**: fix test when compiled without engine support (Richard Lau) [#53232](https://github.com/nodejs/node/pull/53232)
* \[[`cebbd83e47`](https://github.com/nodejs/node/commit/cebbd83e47)] - **test**: update TLS trace tests for OpenSSL >= 3.2 (Richard Lau) [#53229](https://github.com/nodejs/node/pull/53229)
* \[[`45c1eb19f1`](https://github.com/nodejs/node/commit/45c1eb19f1)] - _**Revert**_ "**test**: skip v8-updates/test-linux-perf-logger" (Luke Albao) [#52869](https://github.com/nodejs/node/pull/52869)
* \[[`c1138db3c1`](https://github.com/nodejs/node/commit/c1138db3c1)] - **test**: unskip v8-updates/test-linux-perf-logger (Luke Albao) [#52869](https://github.com/nodejs/node/pull/52869)
* \[[`65b64cf0f1`](https://github.com/nodejs/node/commit/65b64cf0f1)] - **test**: fix Windows native test suites (Stefan Stojanovic) [#53173](https://github.com/nodejs/node/pull/53173)
* \[[`9a47792cd1`](https://github.com/nodejs/node/commit/9a47792cd1)] - **test**: skip `test-setproctitle` when `ps` is not available (Antoine du Hamel) [#53104](https://github.com/nodejs/node/pull/53104)
* \[[`a371dea699`](https://github.com/nodejs/node/commit/a371dea699)] - **test**: increase allocation so it fails for the test (Adam Majer) [#53099](https://github.com/nodejs/node/pull/53099)
* \[[`3ce7a9a1b5`](https://github.com/nodejs/node/commit/3ce7a9a1b5)] - **test**: remove timers from test-tls-socket-close (Luigi Pinca) [#53019](https://github.com/nodejs/node/pull/53019)
* \[[`494fa542af`](https://github.com/nodejs/node/commit/494fa542af)] - **test**: replace `.substr` with `.slice` (Antoine du Hamel) [#53070](https://github.com/nodejs/node/pull/53070)
* \[[`3f7d55b7db`](https://github.com/nodejs/node/commit/3f7d55b7db)] - **test**: add AbortController to knownGlobals (Luigi Pinca) [#53020](https://github.com/nodejs/node/pull/53020)
* \[[`c61f909ab6`](https://github.com/nodejs/node/commit/c61f909ab6)] - **test,doc**: enable running embedtest for Windows (Vladimir Morozov) [#52646](https://github.com/nodejs/node/pull/52646)
* \[[`2d1ecbf827`](https://github.com/nodejs/node/commit/2d1ecbf827)] - **test\_runner**: calculate executed lines using source map (Moshe Atlow) [#53315](https://github.com/nodejs/node/pull/53315)
* \[[`d4f5f80f6c`](https://github.com/nodejs/node/commit/d4f5f80f6c)] - **test\_runner**: handle file rename and deletion under watch mode (jakecastelli) [#53114](https://github.com/nodejs/node/pull/53114)
* \[[`07c601e32f`](https://github.com/nodejs/node/commit/07c601e32f)] - **test\_runner**: refactor to use min/max of `validateInteger` (Deokjin Kim) [#53148](https://github.com/nodejs/node/pull/53148)
* \[[`8c6dffc269`](https://github.com/nodejs/node/commit/8c6dffc269)] - **(SEMVER-MINOR)** **test\_runner**: add snapshot testing (Colin Ihrig) [#53169](https://github.com/nodejs/node/pull/53169)
* \[[`f6d2af8ee7`](https://github.com/nodejs/node/commit/f6d2af8ee7)] - **(SEMVER-MINOR)** **test\_runner**: add context.fullName (Colin Ihrig) [#53169](https://github.com/nodejs/node/pull/53169)
* \[[`7a67ecf161`](https://github.com/nodejs/node/commit/7a67ecf161)] - **(SEMVER-MINOR)** **test\_runner**: support module mocking (Colin Ihrig) [#52848](https://github.com/nodejs/node/pull/52848)
* \[[`3ff174f2bf`](https://github.com/nodejs/node/commit/3ff174f2bf)] - **test\_runner**: fix t.assert methods (Colin Ihrig) [#53049](https://github.com/nodejs/node/pull/53049)
* \[[`e2211a07c2`](https://github.com/nodejs/node/commit/e2211a07c2)] - **test\_runner**: avoid error when coverage line not found (Moshe Atlow) [#53000](https://github.com/nodejs/node/pull/53000)
* \[[`c249289121`](https://github.com/nodejs/node/commit/c249289121)] - **test\_runner,doc**: align documentation with actual stdout/stderr behavior (Moshe Atlow) [#53131](https://github.com/nodejs/node/pull/53131)
* \[[`5110b19a07`](https://github.com/nodejs/node/commit/5110b19a07)] - **tls**: fix negative sessionTimeout handling (Tobias Nießen) [#53002](https://github.com/nodejs/node/pull/53002)
* \[[`0ecb770331`](https://github.com/nodejs/node/commit/0ecb770331)] - **tools**: remove no-goma arg from make-v8 script (Michaël Zasso) [#53336](https://github.com/nodejs/node/pull/53336)
* \[[`e7f3a3c296`](https://github.com/nodejs/node/commit/e7f3a3c296)] - **tools**: use sccache Github action (Moshe Atlow) [#53316](https://github.com/nodejs/node/pull/53316)
* \[[`98cc094bc5`](https://github.com/nodejs/node/commit/98cc094bc5)] - **tools**: update eslint to 9.4.0 (Node.js GitHub Bot) [#53298](https://github.com/nodejs/node/pull/53298)
* \[[`6409b1fe65`](https://github.com/nodejs/node/commit/6409b1fe65)] - **tools**: update gyp-next to 0.18.1 (Node.js GitHub Bot) [#53251](https://github.com/nodejs/node/pull/53251)
* \[[`86e80dcb9b`](https://github.com/nodejs/node/commit/86e80dcb9b)] - **tools**: move webcrypto into no-restricted-properties (Zihong Qu) [#53023](https://github.com/nodejs/node/pull/53023)
* \[[`6022346f0e`](https://github.com/nodejs/node/commit/6022346f0e)] - **tools**: update error message for Type Error (Aviv Keller) [#53047](https://github.com/nodejs/node/pull/53047)
* \[[`c1b3e0ed6f`](https://github.com/nodejs/node/commit/c1b3e0ed6f)] - _**Revert**_ "**tools**: add --certify-safe to nci-ci" (Antoine du Hamel) [#53098](https://github.com/nodejs/node/pull/53098)
* \[[`9f764a873c`](https://github.com/nodejs/node/commit/9f764a873c)] - **tools**: update ESLint to v9 and use flat config (Michaël Zasso) [#52780](https://github.com/nodejs/node/pull/52780)
* \[[`2859f4c027`](https://github.com/nodejs/node/commit/2859f4c027)] - **watch**: fix variable naming (jakecastelli) [#53101](https://github.com/nodejs/node/pull/53101)

<a id="22.2.0"></a>

## 2024-05-15, Version 22.2.0 (Current), @targos

### Notable Changes

* \[[`fb85d38e80`](https://github.com/nodejs/node/commit/fb85d38e80)] - **(SEMVER-MINOR)** **cli**: allow running wasm in limited vmem with --disable-wasm-trap-handler (Joyee Cheung) [#52766](https://github.com/nodejs/node/pull/52766)
* \[[`23a0d3339f`](https://github.com/nodejs/node/commit/23a0d3339f)] - **doc**: add pimterry to collaborators (Tim Perry) [#52874](https://github.com/nodejs/node/pull/52874)
* \[[`7d7a762156`](https://github.com/nodejs/node/commit/7d7a762156)] - **(SEMVER-MINOR)** **fs**: allow 'withFileTypes' to be used with globs (Aviv Keller) [#52837](https://github.com/nodejs/node/pull/52837)
* \[[`8748dd6477`](https://github.com/nodejs/node/commit/8748dd6477)] - **(SEMVER-MINOR)** **inspector**: introduce the `--inspect-wait` flag (Kohei Ueno) [#52734](https://github.com/nodejs/node/pull/52734)
* \[[`9a7ae9b6c4`](https://github.com/nodejs/node/commit/9a7ae9b6c4)] - **lib,src**: remove --experimental-policy (Rafael Gonzaga) [#52583](https://github.com/nodejs/node/pull/52583)
* \[[`1f7c2a93fc`](https://github.com/nodejs/node/commit/1f7c2a93fc)] - **(SEMVER-MINOR)** **perf\_hooks**: add `deliveryType` and `responseStatus` fields (Matthew Aitken) [#51589](https://github.com/nodejs/node/pull/51589)
* \[[`2f59529dc5`](https://github.com/nodejs/node/commit/2f59529dc5)] - **(SEMVER-MINOR)** **test\_runner**: support test plans (Colin Ihrig) [#52860](https://github.com/nodejs/node/pull/52860)
* \[[`6b4dac3eb5`](https://github.com/nodejs/node/commit/6b4dac3eb5)] - **(SEMVER-MINOR)** **zlib**: expose zlib.crc32() (Joyee Cheung) [#52692](https://github.com/nodejs/node/pull/52692)

### Commits

* \[[`0f5716c364`](https://github.com/nodejs/node/commit/0f5716c364)] - **assert**: add deep equal check for more Error type (Zhenwei Jin) [#51805](https://github.com/nodejs/node/pull/51805)
* \[[`2c7d7caa8a`](https://github.com/nodejs/node/commit/2c7d7caa8a)] - **benchmark**: filter non-present deps from `start-cli-version` (Adam Majer) [#51746](https://github.com/nodejs/node/pull/51746)
* \[[`5db4c54bd6`](https://github.com/nodejs/node/commit/5db4c54bd6)] - **bootstrap**: print `--help` message using `console.log` (Jacob Hummer) [#51463](https://github.com/nodejs/node/pull/51463)
* \[[`67fcb6b85e`](https://github.com/nodejs/node/commit/67fcb6b85e)] - **buffer**: even faster atob (Daniel Lemire) [#52443](https://github.com/nodejs/node/pull/52443)
* \[[`a5d63f9052`](https://github.com/nodejs/node/commit/a5d63f9052)] - **buffer**: use size\_t instead of uint32\_t to avoid segmentation fault (Xavier Stouder) [#48033](https://github.com/nodejs/node/pull/48033)
* \[[`f1bc994826`](https://github.com/nodejs/node/commit/f1bc994826)] - **buffer**: remove lines setting indexes to integer value (Zhenwei Jin) [#52588](https://github.com/nodejs/node/pull/52588)
* \[[`a97ff753ab`](https://github.com/nodejs/node/commit/a97ff753ab)] - **build**: add option to enable clang-cl on Windows (Michaël Zasso) [#52870](https://github.com/nodejs/node/pull/52870)
* \[[`f96466a92c`](https://github.com/nodejs/node/commit/f96466a92c)] - **build**: enable building with shared uvwasi lib (Pooja D P) [#43987](https://github.com/nodejs/node/pull/43987)
* \[[`b463385aa8`](https://github.com/nodejs/node/commit/b463385aa8)] - **build**: remove deprecated calls for argument groups (Mohammed Keyvanzadeh) [#52913](https://github.com/nodejs/node/pull/52913)
* \[[`daeb7dbb3e`](https://github.com/nodejs/node/commit/daeb7dbb3e)] - **build**: sync V8 warning cflags with BUILD.gn (Michaël Zasso) [#52873](https://github.com/nodejs/node/pull/52873)
* \[[`eed967430d`](https://github.com/nodejs/node/commit/eed967430d)] - **build**: harmonize Clang checks (Michaël Zasso) [#52873](https://github.com/nodejs/node/pull/52873)
* \[[`e4b187433d`](https://github.com/nodejs/node/commit/e4b187433d)] - **build**: compile with C++20 support (Michaël Zasso) [#52838](https://github.com/nodejs/node/pull/52838)
* \[[`aea6ca25ba`](https://github.com/nodejs/node/commit/aea6ca25ba)] - **build**: drop base64 dep in GN build (Cheng) [#52856](https://github.com/nodejs/node/pull/52856)
* \[[`7f866a8225`](https://github.com/nodejs/node/commit/7f866a8225)] - **build**: make simdjson a public dep in GN build (Cheng) [#52755](https://github.com/nodejs/node/pull/52755)
* \[[`e1bd53c098`](https://github.com/nodejs/node/commit/e1bd53c098)] - **build**: define `NOMINMAX` in common.gypi (Chengzhong Wu) [#52794](https://github.com/nodejs/node/pull/52794)
* \[[`18c530f8f7`](https://github.com/nodejs/node/commit/18c530f8f7)] - **build, tools**: copy release assets to staging R2 bucket once built (flakey5) [#51394](https://github.com/nodejs/node/pull/51394)
* \[[`fb85d38e80`](https://github.com/nodejs/node/commit/fb85d38e80)] - **(SEMVER-MINOR)** **cli**: allow running wasm in limited vmem with --disable-wasm-trap-handler (Joyee Cheung) [#52766](https://github.com/nodejs/node/pull/52766)
* \[[`11e978916f`](https://github.com/nodejs/node/commit/11e978916f)] - **cluster**: replace `forEach` with `for-of` loop (Jérôme Benoit) [#50317](https://github.com/nodejs/node/pull/50317)
* \[[`db76c58d68`](https://github.com/nodejs/node/commit/db76c58d68)] - **console**: colorize console error and warn (Jithil P Ponnan) [#51629](https://github.com/nodejs/node/pull/51629)
* \[[`0d040a3035`](https://github.com/nodejs/node/commit/0d040a3035)] - **crypto**: fix duplicated switch-case return values (Mustafa Ateş UZUN) [#49030](https://github.com/nodejs/node/pull/49030)
* \[[`ab7219f0b2`](https://github.com/nodejs/node/commit/ab7219f0b2)] - **deps**: update googletest to fa6de7f (Node.js GitHub Bot) [#52949](https://github.com/nodejs/node/pull/52949)
* \[[`4ab096eccc`](https://github.com/nodejs/node/commit/4ab096eccc)] - **deps**: update simdjson to 3.9.2 (Node.js GitHub Bot) [#52947](https://github.com/nodejs/node/pull/52947)
* \[[`89f275b1df`](https://github.com/nodejs/node/commit/89f275b1df)] - **deps**: update corepack to 0.28.1 (Node.js GitHub Bot) [#52946](https://github.com/nodejs/node/pull/52946)
* \[[`fc568b4b42`](https://github.com/nodejs/node/commit/fc568b4b42)] - **deps**: update simdutf to 5.2.8 (Node.js GitHub Bot) [#52727](https://github.com/nodejs/node/pull/52727)
* \[[`e399360182`](https://github.com/nodejs/node/commit/e399360182)] - **deps**: update simdutf to 5.2.6 (Node.js GitHub Bot) [#52727](https://github.com/nodejs/node/pull/52727)
* \[[`232831f013`](https://github.com/nodejs/node/commit/232831f013)] - **deps**: enable unbundling of simdjson, simdutf, ada (Daniel Lemire) [#52924](https://github.com/nodejs/node/pull/52924)
* \[[`7ca83a5abc`](https://github.com/nodejs/node/commit/7ca83a5abc)] - **deps**: update googletest to 2d16ed0 (Node.js GitHub Bot) [#51657](https://github.com/nodejs/node/pull/51657)
* \[[`3b15eb5911`](https://github.com/nodejs/node/commit/3b15eb5911)] - **deps**: update googletest to d83fee1 (Node.js GitHub Bot) [#51657](https://github.com/nodejs/node/pull/51657)
* \[[`4190d70035`](https://github.com/nodejs/node/commit/4190d70035)] - **deps**: update googletest to 5a37b51 (Node.js GitHub Bot) [#51657](https://github.com/nodejs/node/pull/51657)
* \[[`7a166a2871`](https://github.com/nodejs/node/commit/7a166a2871)] - **deps**: update googletest to 5197b1a (Node.js GitHub Bot) [#51657](https://github.com/nodejs/node/pull/51657)
* \[[`812dbd749f`](https://github.com/nodejs/node/commit/812dbd749f)] - **deps**: update googletest to eff443c (Node.js GitHub Bot) [#51657](https://github.com/nodejs/node/pull/51657)
* \[[`cb3ae4b9ef`](https://github.com/nodejs/node/commit/cb3ae4b9ef)] - **deps**: update googletest to c231e6f (Node.js GitHub Bot) [#51657](https://github.com/nodejs/node/pull/51657)
* \[[`d97317aaa1`](https://github.com/nodejs/node/commit/d97317aaa1)] - **deps**: update googletest to e4fdb87 (Node.js GitHub Bot) [#51657](https://github.com/nodejs/node/pull/51657)
* \[[`ad8ca1259f`](https://github.com/nodejs/node/commit/ad8ca1259f)] - **deps**: update googletest to 5df0241 (Node.js GitHub Bot) [#51657](https://github.com/nodejs/node/pull/51657)
* \[[`828f0d7096`](https://github.com/nodejs/node/commit/828f0d7096)] - **deps**: update googletest to b75ecf1 (Node.js GitHub Bot) [#51657](https://github.com/nodejs/node/pull/51657)
* \[[`3b60dbcf7b`](https://github.com/nodejs/node/commit/3b60dbcf7b)] - **deps**: update googletest to 4565741 (Node.js GitHub Bot) [#51657](https://github.com/nodejs/node/pull/51657)
* \[[`37098eb880`](https://github.com/nodejs/node/commit/37098eb880)] - **deps**: update simdjson to 3.9.1 (Node.js GitHub Bot) [#52397](https://github.com/nodejs/node/pull/52397)
* \[[`a13cf1c049`](https://github.com/nodejs/node/commit/a13cf1c049)] - **deps**: update uvwasi to 0.0.21 (Node.js GitHub Bot) [#52863](https://github.com/nodejs/node/pull/52863)
* \[[`faf8ada719`](https://github.com/nodejs/node/commit/faf8ada719)] - **deps**: V8: cherry-pick f6bef09b3b0a (Richard Lau) [#52802](https://github.com/nodejs/node/pull/52802)
* \[[`8e5844c2a4`](https://github.com/nodejs/node/commit/8e5844c2a4)] - **doc**: remove reference to AUTHORS file (Marco Ippolito) [#52960](https://github.com/nodejs/node/pull/52960)
* \[[`1f3634e30f`](https://github.com/nodejs/node/commit/1f3634e30f)] - **doc**: update hljs with the latest styles (Aviv Keller) [#52911](https://github.com/nodejs/node/pull/52911)
* \[[`9102255749`](https://github.com/nodejs/node/commit/9102255749)] - **doc**: mention quicker way to build docs (Alex Crawford) [#52937](https://github.com/nodejs/node/pull/52937)
* \[[`15db3ef5fb`](https://github.com/nodejs/node/commit/15db3ef5fb)] - **doc**: mention push.followTags config (Rafael Gonzaga) [#52906](https://github.com/nodejs/node/pull/52906)
* \[[`80fa675af2`](https://github.com/nodejs/node/commit/80fa675af2)] - **doc**: document pipeline with `end` option (Alois Klink) [#48970](https://github.com/nodejs/node/pull/48970)
* \[[`c0000f4118`](https://github.com/nodejs/node/commit/c0000f4118)] - **doc**: add example for `execFileSync` method and ref to stdio (Evan Shortiss) [#39412](https://github.com/nodejs/node/pull/39412)
* \[[`e0148e2653`](https://github.com/nodejs/node/commit/e0148e2653)] - **doc**: add examples and notes to http server.close et al (mary marchini) [#49091](https://github.com/nodejs/node/pull/49091)
* \[[`030f56ee6d`](https://github.com/nodejs/node/commit/030f56ee6d)] - **doc**: fix `dns.lookup` family `0` and `all` descriptions (Adam Jones) [#51653](https://github.com/nodejs/node/pull/51653)
* \[[`a6d624cd5a`](https://github.com/nodejs/node/commit/a6d624cd5a)] - **doc**: update `fs.realpath` documentation (sinkhaha) [#48170](https://github.com/nodejs/node/pull/48170)
* \[[`5dab187ca8`](https://github.com/nodejs/node/commit/5dab187ca8)] - **doc**: update fs read documentation for clarity (Mert Can Altin) [#52453](https://github.com/nodejs/node/pull/52453)
* \[[`5d3ee7205d`](https://github.com/nodejs/node/commit/5d3ee7205d)] - **doc**: watermark string behavior (Benjamin Gruenbaum) [#52842](https://github.com/nodejs/node/pull/52842)
* \[[`2dd8f092a8`](https://github.com/nodejs/node/commit/2dd8f092a8)] - **doc**: exclude commits with baking-for-lts (Marco Ippolito) [#52896](https://github.com/nodejs/node/pull/52896)
* \[[`0c2539b913`](https://github.com/nodejs/node/commit/0c2539b913)] - **doc**: add names next to release key bash commands (Aviv Keller) [#52878](https://github.com/nodejs/node/pull/52878)
* \[[`23a0d3339f`](https://github.com/nodejs/node/commit/23a0d3339f)] - **doc**: add pimterry to collaborators (Tim Perry) [#52874](https://github.com/nodejs/node/pull/52874)
* \[[`15aad62e0c`](https://github.com/nodejs/node/commit/15aad62e0c)] - **doc**: update BUILDING.md previous versions links (Michaël Zasso) [#52852](https://github.com/nodejs/node/pull/52852)
* \[[`f770a993d4`](https://github.com/nodejs/node/commit/f770a993d4)] - **doc**: add more definitions to GLOSSARY.md (Aviv Keller) [#52798](https://github.com/nodejs/node/pull/52798)
* \[[`f35b838a65`](https://github.com/nodejs/node/commit/f35b838a65)] - **doc**: make docs more welcoming and descriptive for newcomers (Serkan Özel) [#38056](https://github.com/nodejs/node/pull/38056)
* \[[`562a019a14`](https://github.com/nodejs/node/commit/562a019a14)] - **doc**: add OpenSSL errors to API docs (John Lamp) [#34213](https://github.com/nodejs/node/pull/34213)
* \[[`0cb7cf7aa9`](https://github.com/nodejs/node/commit/0cb7cf7aa9)] - **doc**: fix grammatical mistake (codershiba) [#52808](https://github.com/nodejs/node/pull/52808)
* \[[`a0147ff8d0`](https://github.com/nodejs/node/commit/a0147ff8d0)] - **doc**: simplify copy-pasting of `branch-diff` commands (Antoine du Hamel) [#52757](https://github.com/nodejs/node/pull/52757)
* \[[`fce31fc829`](https://github.com/nodejs/node/commit/fce31fc829)] - **doc**: add test\_runner to subsystem (Raz Luvaton) [#52774](https://github.com/nodejs/node/pull/52774)
* \[[`ca5607bbc8`](https://github.com/nodejs/node/commit/ca5607bbc8)] - **events**: update MaxListenersExceededWarning message log (sinkhaha) [#51921](https://github.com/nodejs/node/pull/51921)
* \[[`96566fc696`](https://github.com/nodejs/node/commit/96566fc696)] - **events**: add stop propagation flag to `Event.stopImmediatePropagation` (Mickael Meausoone) [#39463](https://github.com/nodejs/node/pull/39463)
* \[[`5ee69243ed`](https://github.com/nodejs/node/commit/5ee69243ed)] - **events**: replace NodeCustomEvent with CustomEvent (Feng Yu) [#43876](https://github.com/nodejs/node/pull/43876)
* \[[`f076e721cb`](https://github.com/nodejs/node/commit/f076e721cb)] - **fs**: keep fs.promises.readFile read until EOF is reached (Zhenwei Jin) [#52178](https://github.com/nodejs/node/pull/52178)
* \[[`7d7a762156`](https://github.com/nodejs/node/commit/7d7a762156)] - **(SEMVER-MINOR)** **fs**: allow 'withFileTypes' to be used with globs (Aviv Keller) [#52837](https://github.com/nodejs/node/pull/52837)
* \[[`ad9c4bddb1`](https://github.com/nodejs/node/commit/ad9c4bddb1)] - **http**: correctly translate HTTP method (Paolo Insogna) [#52701](https://github.com/nodejs/node/pull/52701)
* \[[`8748dd6477`](https://github.com/nodejs/node/commit/8748dd6477)] - **(SEMVER-MINOR)** **inspector**: introduce the `--inspect-wait` flag (Kohei Ueno) [#52734](https://github.com/nodejs/node/pull/52734)
* \[[`9a7ae9b6c4`](https://github.com/nodejs/node/commit/9a7ae9b6c4)] - **lib,src**: remove --experimental-policy (Rafael Gonzaga) [#52583](https://github.com/nodejs/node/pull/52583)
* \[[`a850219600`](https://github.com/nodejs/node/commit/a850219600)] - **meta**: move `@anonrig` to TSC regular member (Yagiz Nizipli) [#52932](https://github.com/nodejs/node/pull/52932)
* \[[`4dc8a387b3`](https://github.com/nodejs/node/commit/4dc8a387b3)] - **meta**: add mailmap entry for legendecas (Chengzhong Wu) [#52795](https://github.com/nodejs/node/pull/52795)
* \[[`d10182d81d`](https://github.com/nodejs/node/commit/d10182d81d)] - **meta**: bump actions/checkout from 4.1.1 to 4.1.4 (dependabot\[bot]) [#52787](https://github.com/nodejs/node/pull/52787)
* \[[`48d0ac0665`](https://github.com/nodejs/node/commit/48d0ac0665)] - **meta**: bump github/codeql-action from 3.24.9 to 3.25.3 (dependabot\[bot]) [#52786](https://github.com/nodejs/node/pull/52786)
* \[[`7c7a25150e`](https://github.com/nodejs/node/commit/7c7a25150e)] - **meta**: bump actions/upload-artifact from 4.3.1 to 4.3.3 (dependabot\[bot]) [#52785](https://github.com/nodejs/node/pull/52785)
* \[[`d9abf18342`](https://github.com/nodejs/node/commit/d9abf18342)] - **meta**: bump actions/download-artifact from 4.1.4 to 4.1.7 (dependabot\[bot]) [#52784](https://github.com/nodejs/node/pull/52784)
* \[[`590e5c6c45`](https://github.com/nodejs/node/commit/590e5c6c45)] - **meta**: bump codecov/codecov-action from 4.1.1 to 4.3.1 (dependabot\[bot]) [#52783](https://github.com/nodejs/node/pull/52783)
* \[[`b3d1720515`](https://github.com/nodejs/node/commit/b3d1720515)] - **meta**: bump step-security/harden-runner from 2.7.0 to 2.7.1 (dependabot\[bot]) [#52782](https://github.com/nodejs/node/pull/52782)
* \[[`f74beb53de`](https://github.com/nodejs/node/commit/f74beb53de)] - **module**: cache synchronous module jobs before linking (Joyee Cheung) [#52868](https://github.com/nodejs/node/pull/52868)
* \[[`8fbf6628d6`](https://github.com/nodejs/node/commit/8fbf6628d6)] - **module**: have a single hooks thread for all workers (Gabriel Bota) [#52706](https://github.com/nodejs/node/pull/52706)
* \[[`609d90bb4b`](https://github.com/nodejs/node/commit/609d90bb4b)] - **path**: fix toNamespacedPath on Windows (Hüseyin Açacak) [#52915](https://github.com/nodejs/node/pull/52915)
* \[[`1f7c2a93fc`](https://github.com/nodejs/node/commit/1f7c2a93fc)] - **(SEMVER-MINOR)** **perf\_hooks**: add `deliveryType` and `responseStatus` fields (Matthew Aitken) [#51589](https://github.com/nodejs/node/pull/51589)
* \[[`0bbc62c42a`](https://github.com/nodejs/node/commit/0bbc62c42a)] - **process**: improve event-loop (Aras Abbasi) [#52108](https://github.com/nodejs/node/pull/52108)
* \[[`619ac79abb`](https://github.com/nodejs/node/commit/619ac79abb)] - **quic**: address coverity warning (Michael Dawson) [#52824](https://github.com/nodejs/node/pull/52824)
* \[[`04de5766ee`](https://github.com/nodejs/node/commit/04de5766ee)] - **repl**: fix disruptive autocomplete without inspector (Nitzan Uziely) [#40661](https://github.com/nodejs/node/pull/40661)
* \[[`663bb973ab`](https://github.com/nodejs/node/commit/663bb973ab)] - **src**: fix Worker termination in `inspector.waitForDebugger` (Daeyeon Jeong) [#52527](https://github.com/nodejs/node/pull/52527)
* \[[`fca38b2d6e`](https://github.com/nodejs/node/commit/fca38b2d6e)] - **src**: use `S_ISDIR` to check if the file is a directory (theanarkh) [#52164](https://github.com/nodejs/node/pull/52164)
* \[[`b228db579f`](https://github.com/nodejs/node/commit/b228db579f)] - **src**: allow preventing debug signal handler start (Shelley Vohr) [#46681](https://github.com/nodejs/node/pull/46681)
* \[[`ace65a9aac`](https://github.com/nodejs/node/commit/ace65a9aac)] - **src**: make sure pass the `argv` to worker threads (theanarkh) [#52827](https://github.com/nodejs/node/pull/52827)
* \[[`75004d32ab`](https://github.com/nodejs/node/commit/75004d32ab)] - **src**: fix typo Unabled -> Unable (Simon Siefke) [#52820](https://github.com/nodejs/node/pull/52820)
* \[[`c40a8273ef`](https://github.com/nodejs/node/commit/c40a8273ef)] - **src**: avoid unused variable 'error' warning (Michaël Zasso) [#52886](https://github.com/nodejs/node/pull/52886)
* \[[`d169d0f181`](https://github.com/nodejs/node/commit/d169d0f181)] - **src**: fix positional args in task runner (Yagiz Nizipli) [#52810](https://github.com/nodejs/node/pull/52810)
* \[[`9c76c95c10`](https://github.com/nodejs/node/commit/9c76c95c10)] - **src**: only apply fix in main thread (Paolo Insogna) [#52702](https://github.com/nodejs/node/pull/52702)
* \[[`e1cba97df3`](https://github.com/nodejs/node/commit/e1cba97df3)] - **src**: fix test local edge case (Paolo Insogna) [#52702](https://github.com/nodejs/node/pull/52702)
* \[[`dc41c135d7`](https://github.com/nodejs/node/commit/dc41c135d7)] - **src**: reduce unnecessary serialization of CLI options in C++ (Joyee Cheung) [#52451](https://github.com/nodejs/node/pull/52451)
* \[[`fb24c4475c`](https://github.com/nodejs/node/commit/fb24c4475c)] - **src**: rewrite task runner in c++ (Yagiz Nizipli) [#52609](https://github.com/nodejs/node/pull/52609)
* \[[`323f95de9e`](https://github.com/nodejs/node/commit/323f95de9e)] - **src**: migrate to new V8 interceptors API (Michaël Zasso) [#52745](https://github.com/nodejs/node/pull/52745)
* \[[`850ff02931`](https://github.com/nodejs/node/commit/850ff02931)] - **src,permission**: resolve path on fs\_permission (Rafael Gonzaga) [#52761](https://github.com/nodejs/node/pull/52761)
* \[[`8d3b0b7ade`](https://github.com/nodejs/node/commit/8d3b0b7ade)] - **stream**: use `ByteLengthQueuingStrategy` when not in `objectMode` (Jason) [#48847](https://github.com/nodejs/node/pull/48847)
* \[[`fa715437b0`](https://github.com/nodejs/node/commit/fa715437b0)] - **stream**: fix util.inspect for compression/decompressionStream (Mert Can Altin) [#52283](https://github.com/nodejs/node/pull/52283)
* \[[`b0e6a6b3d5`](https://github.com/nodejs/node/commit/b0e6a6b3d5)] - **string\_decoder**: throw an error when writing a too long buffer (zhenweijin) [#52215](https://github.com/nodejs/node/pull/52215)
* \[[`e016e952e6`](https://github.com/nodejs/node/commit/e016e952e6)] - **test**: add `Debugger.setInstrumentationBreakpoint` known issue (Konstantin Ulitin) [#31137](https://github.com/nodejs/node/pull/31137)
* \[[`a589de0886`](https://github.com/nodejs/node/commit/a589de0886)] - **test**: use `for-of` instead of `forEach` (Gibby Free) [#49790](https://github.com/nodejs/node/pull/49790)
* \[[`578868ddf8`](https://github.com/nodejs/node/commit/578868ddf8)] - **test**: verify request payload is uploaded consistently (Austin Wright) [#34066](https://github.com/nodejs/node/pull/34066)
* \[[`c676e522e6`](https://github.com/nodejs/node/commit/c676e522e6)] - **test**: add fuzzer for native/js string conversion (Adam Korczynski) [#51120](https://github.com/nodejs/node/pull/51120)
* \[[`5f6415b41d`](https://github.com/nodejs/node/commit/5f6415b41d)] - **test**: add fuzzer for `ClientHelloParser` (AdamKorcz) [#51088](https://github.com/nodejs/node/pull/51088)
* \[[`4d50d51a5e`](https://github.com/nodejs/node/commit/4d50d51a5e)] - **test**: fix broken env fuzzer by initializing process (AdamKorcz) [#51080](https://github.com/nodejs/node/pull/51080)
* \[[`cd00cdcbc8`](https://github.com/nodejs/node/commit/cd00cdcbc8)] - **test**: replace `forEach()` in `test-stream-pipe-unpipe-stream` (Dario) [#50786](https://github.com/nodejs/node/pull/50786)
* \[[`5469adf458`](https://github.com/nodejs/node/commit/5469adf458)] - **test**: test pipeline `end` on transform streams (Alois Klink) [#48970](https://github.com/nodejs/node/pull/48970)
* \[[`ea6070b0e8`](https://github.com/nodejs/node/commit/ea6070b0e8)] - **test**: improve coverage of lib/readline.js (Rongjian Zhang) [#38646](https://github.com/nodejs/node/pull/38646)
* \[[`4f96b00307`](https://github.com/nodejs/node/commit/4f96b00307)] - **test**: updated for each to for of in test file (lyannel) [#50308](https://github.com/nodejs/node/pull/50308)
* \[[`5d91cf1976`](https://github.com/nodejs/node/commit/5d91cf1976)] - **test**: move `test-http-server-request-timeouts-mixed` to sequential (Madhuri) [#45722](https://github.com/nodejs/node/pull/45722)
* \[[`f47e8fccbb`](https://github.com/nodejs/node/commit/f47e8fccbb)] - **test**: fix DNS cancel tests (Szymon Marczak) [#44432](https://github.com/nodejs/node/pull/44432)
* \[[`0b073f885a`](https://github.com/nodejs/node/commit/0b073f885a)] - **test**: add http agent to `executionAsyncResource` (psj-tar-gz) [#34966](https://github.com/nodejs/node/pull/34966)
* \[[`fbce3178ba`](https://github.com/nodejs/node/commit/fbce3178ba)] - **test**: reduce memory usage of test-worker-stdio (Adam Majer) [#37769](https://github.com/nodejs/node/pull/37769)
* \[[`1f8eaec454`](https://github.com/nodejs/node/commit/1f8eaec454)] - **test**: add common.expectRequiredModule() (Joyee Cheung) [#52868](https://github.com/nodejs/node/pull/52868)
* \[[`5e731da572`](https://github.com/nodejs/node/commit/5e731da572)] - **test**: skip unstable shadow realm gc tests (Chengzhong Wu) [#52855](https://github.com/nodejs/node/pull/52855)
* \[[`30a35ae522`](https://github.com/nodejs/node/commit/30a35ae522)] - **test**: crypto-rsa-dsa testing for dynamic openssl (Michael Dawson) [#52781](https://github.com/nodejs/node/pull/52781)
* \[[`968fe6a8b1`](https://github.com/nodejs/node/commit/968fe6a8b1)] - **test**: skip some console tests on dumb terminal (Adam Majer) [#37770](https://github.com/nodejs/node/pull/37770)
* \[[`1448959e0d`](https://github.com/nodejs/node/commit/1448959e0d)] - **test**: skip v8-updates/test-linux-perf-logger (Michaël Zasso) [#52821](https://github.com/nodejs/node/pull/52821)
* \[[`30a4248b48`](https://github.com/nodejs/node/commit/30a4248b48)] - **test**: add env variable test for --run (Yagiz Nizipli) [#52811](https://github.com/nodejs/node/pull/52811)
* \[[`edb4ed3bc9`](https://github.com/nodejs/node/commit/edb4ed3bc9)] - **test**: drop test-crypto-timing-safe-equal-benchmarks (Rafael Gonzaga) [#52751](https://github.com/nodejs/node/pull/52751)
* \[[`944ae598b5`](https://github.com/nodejs/node/commit/944ae598b5)] - **test, crypto**: use correct object on assert (响马) [#51820](https://github.com/nodejs/node/pull/51820)
* \[[`a814e720fa`](https://github.com/nodejs/node/commit/a814e720fa)] - **test\_runner**: fix watch mode race condition (Moshe Atlow) [#52954](https://github.com/nodejs/node/pull/52954)
* \[[`2f59529dc5`](https://github.com/nodejs/node/commit/2f59529dc5)] - **(SEMVER-MINOR)** **test\_runner**: support test plans (Colin Ihrig) [#52860](https://github.com/nodejs/node/pull/52860)
* \[[`3267b3c063`](https://github.com/nodejs/node/commit/3267b3c063)] - **test\_runner**: display failed test stack trace with dot reporter (Mihir Bhansali) [#52655](https://github.com/nodejs/node/pull/52655)
* \[[`b96868b4e7`](https://github.com/nodejs/node/commit/b96868b4e7)] - **test\_runner**: preserve hook promise when executed twice (Moshe Atlow) [#52791](https://github.com/nodejs/node/pull/52791)
* \[[`74341ba3c9`](https://github.com/nodejs/node/commit/74341ba3c9)] - **tools**: fix v8-update workflow (Michaël Zasso) [#52957](https://github.com/nodejs/node/pull/52957)
* \[[`afe39ed0df`](https://github.com/nodejs/node/commit/afe39ed0df)] - **tools**: add --certify-safe to nci-ci (Matteo Collina) [#52940](https://github.com/nodejs/node/pull/52940)
* \[[`bb97e1ccdd`](https://github.com/nodejs/node/commit/bb97e1ccdd)] - **tools**: fix doc update action (Marco Ippolito) [#52890](https://github.com/nodejs/node/pull/52890)
* \[[`c6043fe6c8`](https://github.com/nodejs/node/commit/c6043fe6c8)] - **tools**: fix get\_asan\_state() in tools/test.py (Joyee Cheung) [#52766](https://github.com/nodejs/node/pull/52766)
* \[[`6e71accc5f`](https://github.com/nodejs/node/commit/6e71accc5f)] - **tools**: support max\_virtual\_memory test configuration (Joyee Cheung) [#52766](https://github.com/nodejs/node/pull/52766)
* \[[`1600bdac60`](https://github.com/nodejs/node/commit/1600bdac60)] - **tools**: support != in test status files (Joyee Cheung) [#52766](https://github.com/nodejs/node/pull/52766)
* \[[`8ce23dc9f3`](https://github.com/nodejs/node/commit/8ce23dc9f3)] - **tools**: update gyp-next to 0.18.0 (Node.js GitHub Bot) [#52835](https://github.com/nodejs/node/pull/52835)
* \[[`c5f832adc0`](https://github.com/nodejs/node/commit/c5f832adc0)] - **tools**: update gyp-next to 0.17.0 (Node.js GitHub Bot) [#52835](https://github.com/nodejs/node/pull/52835)
* \[[`646a094782`](https://github.com/nodejs/node/commit/646a094782)] - **tools**: prepare custom rules for ESLint v9 (Michaël Zasso) [#52889](https://github.com/nodejs/node/pull/52889)
* \[[`505566347d`](https://github.com/nodejs/node/commit/505566347d)] - **tools**: update lint-md-dependencies to rollup\@4.17.2 (Node.js GitHub Bot) [#52836](https://github.com/nodejs/node/pull/52836)
* \[[`466e0c1321`](https://github.com/nodejs/node/commit/466e0c1321)] - **tools**: update `gr2m/create-or-update-pull-request-action` (Antoine du Hamel) [#52843](https://github.com/nodejs/node/pull/52843)
* \[[`ce7a751ad1`](https://github.com/nodejs/node/commit/ce7a751ad1)] - **tools**: use sccache GitHub action (Michaël Zasso) [#52839](https://github.com/nodejs/node/pull/52839)
* \[[`1ee38a5ec1`](https://github.com/nodejs/node/commit/1ee38a5ec1)] - **tools**: specify a commit-message for V8 update workflow (Antoine du Hamel) [#52844](https://github.com/nodejs/node/pull/52844)
* \[[`317998a1e8`](https://github.com/nodejs/node/commit/317998a1e8)] - **tools**: fix V8 update workflow (Antoine du Hamel) [#52822](https://github.com/nodejs/node/pull/52822)
* \[[`ef6a2101e2`](https://github.com/nodejs/node/commit/ef6a2101e2)] - **url,tools,benchmark**: replace deprecated `substr()` (Jungku Lee) [#51546](https://github.com/nodejs/node/pull/51546)
* \[[`0deef2d2b1`](https://github.com/nodejs/node/commit/0deef2d2b1)] - **util**: fix `%s` format behavior with `Symbol.toPrimitive` (Chenyu Yang) [#50992](https://github.com/nodejs/node/pull/50992)
* \[[`a42b93b9aa`](https://github.com/nodejs/node/commit/a42b93b9aa)] - **util**: improve `isInsideNodeModules` (uzlopak) [#52147](https://github.com/nodejs/node/pull/52147)
* \[[`d71e16154a`](https://github.com/nodejs/node/commit/d71e16154a)] - **watch**: allow listening for grouped changes (Matthieu Sieben) [#52722](https://github.com/nodejs/node/pull/52722)
* \[[`e895f7cf32`](https://github.com/nodejs/node/commit/e895f7cf32)] - **watch**: enable passthrough ipc in watch mode (Zack) [#50890](https://github.com/nodejs/node/pull/50890)
* \[[`f5d925706a`](https://github.com/nodejs/node/commit/f5d925706a)] - **watch**: fix arguments parsing (Moshe Atlow) [#52760](https://github.com/nodejs/node/pull/52760)
* \[[`6b4dac3eb5`](https://github.com/nodejs/node/commit/6b4dac3eb5)] - **(SEMVER-MINOR)** **zlib**: expose zlib.crc32() (Joyee Cheung) [#52692](https://github.com/nodejs/node/pull/52692)

<a id="22.1.0"></a>

## 2024-05-02, Version 22.1.0 (Current), @targos prepared by @aduh95

### module: implement `NODE_COMPILE_CACHE` for automatic on-disk code caching

This patch implements automatic on-disk code caching that can be enabled
via an environment variable `NODE_COMPILE_CACHE=/path/to/cache/dir`.

When set, whenever Node.js compiles a CommonJS or a ECMAScript Module,
it will use on-disk [V8 code cache](https://v8.dev/blog/code-caching-for-devs)
persisted in the specified directory
to speed up the compilation. This may slow down the first load of a
module graph, but subsequent loads of the same module graph may get
a significant speedup if the contents of the modules do not change.
Locally, this speeds up loading of `test/fixtures/snapshot/typescript.js`
from \~130ms to \~80ms.

To clean up the generated code cache, simply remove the directory.
It will be recreated the next time the same directory is used for
`NODE_COMPILE_CACHE`.

Compilation cache generated by one version of Node.js may not be used
by a different version of Node.js. Cache generated by different versions
of Node.js will be stored separately if the same directory is used
to persist the cache, so they can co-exist.

Caveat: currently when using this with V8 JavaScript code coverage, the
coverage being collected by V8 may be less precise in functions that are
deserialized from the code cache. It's recommended to turn this off when
running tests to generate precise coverage.

Contributed by Joyee Cheung in [#52535](https://github.com/nodejs/node/pull/52535).

### Other Notable Changes

* \[[`44ee04cf9f`](https://github.com/nodejs/node/commit/44ee04cf9f)] - **buffer**: improve `base64` and `base64url` performance (Yagiz Nizipli) [#52428](https://github.com/nodejs/node/pull/52428)
* \[[`3c37ce5710`](https://github.com/nodejs/node/commit/3c37ce5710)] - **(SEMVER-MINOR)** **dns**: add order option and support ipv6first (Paolo Insogna) [#52492](https://github.com/nodejs/node/pull/52492)
* \[[`3026401be1`](https://github.com/nodejs/node/commit/3026401be1)] - **events,doc**: mark CustomEvent as stable (Daeyeon Jeong) [#52618](https://github.com/nodejs/node/pull/52618)
* \[[`64428dc1c9`](https://github.com/nodejs/node/commit/64428dc1c9)] - **(SEMVER-MINOR)** **lib, url**: add a `windows` option to path parsing (Aviv Keller) [#52509](https://github.com/nodejs/node/pull/52509)
* \[[`d79ae74f71`](https://github.com/nodejs/node/commit/d79ae74f71)] - **(SEMVER-MINOR)** **net**: add CLI option for autoSelectFamilyAttemptTimeout (Paolo Insogna) [#52474](https://github.com/nodejs/node/pull/52474)
* \[[`43fa6a1a45`](https://github.com/nodejs/node/commit/43fa6a1a45)] - **(SEMVER-MINOR)** **src**: add `string_view` overload to snapshot FromBlob (Anna Henningsen) [#52595](https://github.com/nodejs/node/pull/52595)
* \[[`c6fe433d42`](https://github.com/nodejs/node/commit/c6fe433d42)] - **src,permission**: throw async errors on async APIs (Rafael Gonzaga) [#52730](https://github.com/nodejs/node/pull/52730)
* \[[`e247a61d15`](https://github.com/nodejs/node/commit/e247a61d15)] - **(SEMVER-MINOR)** **test\_runner**: add --test-skip-pattern cli option (Aviv Keller) [#52529](https://github.com/nodejs/node/pull/52529)
* \[[`9b18df9dcb`](https://github.com/nodejs/node/commit/9b18df9dcb)] - **(SEMVER-MINOR)** **url**: implement parse method for safer URL parsing (Ali Hassan) [#52280](https://github.com/nodejs/node/pull/52280)

### Commits

* \[[`35643c18c0`](https://github.com/nodejs/node/commit/35643c18c0)] - **benchmark**: reduce the buffer size for blob (Debadree Chatterjee) [#52548](https://github.com/nodejs/node/pull/52548)
* \[[`7cdfe8a3fc`](https://github.com/nodejs/node/commit/7cdfe8a3fc)] - **benchmark**: inherit stdio/stderr instead of pipe (Ali Hassan) [#52456](https://github.com/nodejs/node/pull/52456)
* \[[`7b82c17f22`](https://github.com/nodejs/node/commit/7b82c17f22)] - **benchmark**: add ipc support to spawn stdio config (Ali Hassan) [#52456](https://github.com/nodejs/node/pull/52456)
* \[[`dfda6fed61`](https://github.com/nodejs/node/commit/dfda6fed61)] - **buffer**: add missing ARG\_TYPE(ArrayBuffer) for isUtf8 (Jungku Lee) [#52477](https://github.com/nodejs/node/pull/52477)
* \[[`44ee04cf9f`](https://github.com/nodejs/node/commit/44ee04cf9f)] - **buffer**: improve `base64` and `base64url` performance (Yagiz Nizipli) [#52428](https://github.com/nodejs/node/pull/52428)
* \[[`c64a1a3b89`](https://github.com/nodejs/node/commit/c64a1a3b89)] - **build**: fix typo in node.gyp (Michaël Zasso) [#52719](https://github.com/nodejs/node/pull/52719)
* \[[`4f713fbc2e`](https://github.com/nodejs/node/commit/4f713fbc2e)] - **build**: fix headers install for shared mode on Win (Segev Finer) [#52442](https://github.com/nodejs/node/pull/52442)
* \[[`4baeb7b21d`](https://github.com/nodejs/node/commit/4baeb7b21d)] - **build**: fix arm64 cross-compilation bug on non-arm machines (Mahdi Sharifi) [#52559](https://github.com/nodejs/node/pull/52559)
* \[[`d5cd468ce8`](https://github.com/nodejs/node/commit/d5cd468ce8)] - **build,tools,node-api**: fix building node-api tests for Windows Debug (Vladimir Morozov) [#52632](https://github.com/nodejs/node/pull/52632)
* \[[`910533fcfd`](https://github.com/nodejs/node/commit/910533fcfd)] - **crypto**: simplify assertions in Safe\*Print (David Benjamin) [#49709](https://github.com/nodejs/node/pull/49709)
* \[[`61e1ac0b8c`](https://github.com/nodejs/node/commit/61e1ac0b8c)] - **crypto**: enable NODE\_EXTRA\_CA\_CERTS with BoringSSL (Shelley Vohr) [#52217](https://github.com/nodejs/node/pull/52217)
* \[[`6e98eee256`](https://github.com/nodejs/node/commit/6e98eee256)] - **deps**: upgrade npm to 10.7.0 (npm team) [#52767](https://github.com/nodejs/node/pull/52767)
* \[[`27a5f9418c`](https://github.com/nodejs/node/commit/27a5f9418c)] - **deps**: V8: cherry-pick 500de8bd371b (Richard Lau) [#52676](https://github.com/nodejs/node/pull/52676)
* \[[`3b422ddcea`](https://github.com/nodejs/node/commit/3b422ddcea)] - **deps**: update corepack to 0.28.0 (Node.js GitHub Bot) [#52616](https://github.com/nodejs/node/pull/52616)
* \[[`d40e4d4c42`](https://github.com/nodejs/node/commit/d40e4d4c42)] - **deps**: update ada to 2.7.8 (Node.js GitHub Bot) [#52517](https://github.com/nodejs/node/pull/52517)
* \[[`5b52a4870a`](https://github.com/nodejs/node/commit/5b52a4870a)] - **deps**: update icu to 75.1 (Node.js GitHub Bot) [#52573](https://github.com/nodejs/node/pull/52573)
* \[[`80cbe72c1f`](https://github.com/nodejs/node/commit/80cbe72c1f)] - **deps**: update undici to 6.13.0 (Node.js GitHub Bot) [#52493](https://github.com/nodejs/node/pull/52493)
* \[[`9a44059055`](https://github.com/nodejs/node/commit/9a44059055)] - **deps**: update zlib to 1.3.0.1-motley-7d77fb7 (Node.js GitHub Bot) [#52516](https://github.com/nodejs/node/pull/52516)
* \[[`d67a9a5360`](https://github.com/nodejs/node/commit/d67a9a5360)] - **deps**: update minimatch to 9.0.4 (Node.js GitHub Bot) [#52524](https://github.com/nodejs/node/pull/52524)
* \[[`8738b89971`](https://github.com/nodejs/node/commit/8738b89971)] - **deps**: upgrade npm to 10.5.2 (npm team) [#52458](https://github.com/nodejs/node/pull/52458)
* \[[`8e4fd2842b`](https://github.com/nodejs/node/commit/8e4fd2842b)] - **deps,src**: simplify base64 encoding (Daniel Lemire) [#52714](https://github.com/nodejs/node/pull/52714)
* \[[`3c37ce5710`](https://github.com/nodejs/node/commit/3c37ce5710)] - **(SEMVER-MINOR)** **dns**: add order option and support ipv6first (Paolo Insogna) [#52492](https://github.com/nodejs/node/pull/52492)
* \[[`3987a28a9e`](https://github.com/nodejs/node/commit/3987a28a9e)] - **doc**: update process.versions properties (ishabi) [#52736](https://github.com/nodejs/node/pull/52736)
* \[[`c0b58e07f1`](https://github.com/nodejs/node/commit/c0b58e07f1)] - **doc**: remove mold use on mac for speeding up build (Cong Zhang) [#52252](https://github.com/nodejs/node/pull/52252)
* \[[`9a032cf6e2`](https://github.com/nodejs/node/commit/9a032cf6e2)] - **doc**: remove relative limitation to pm (Rafael Gonzaga) [#52648](https://github.com/nodejs/node/pull/52648)
* \[[`90c6e77238`](https://github.com/nodejs/node/commit/90c6e77238)] - **doc**: fix info string causing duplicated code blocks (Mathieu Leenhardt) [#52660](https://github.com/nodejs/node/pull/52660)
* \[[`4d577fa048`](https://github.com/nodejs/node/commit/4d577fa048)] - **doc**: add .gitattributes for md files (Hüseyin Açacak) [#52161](https://github.com/nodejs/node/pull/52161)
* \[[`04c8e110e5`](https://github.com/nodejs/node/commit/04c8e110e5)] - **doc**: run license-builder (github-actions\[bot]) [#52631](https://github.com/nodejs/node/pull/52631)
* \[[`3552829594`](https://github.com/nodejs/node/commit/3552829594)] - **doc**: add info on contributor spotlight program (Michael Dawson) [#52598](https://github.com/nodejs/node/pull/52598)
* \[[`eeb80ad836`](https://github.com/nodejs/node/commit/eeb80ad836)] - **doc**: correct unsafe URL example in http docs (Malte Legenhausen) [#52555](https://github.com/nodejs/node/pull/52555)
* \[[`c83526a688`](https://github.com/nodejs/node/commit/c83526a688)] - **doc**: replace U+00A0 with U+0020 (Luigi Pinca) [#52590](https://github.com/nodejs/node/pull/52590)
* \[[`31831e9db8`](https://github.com/nodejs/node/commit/31831e9db8)] - **doc**: sort options alphabetically (Luigi Pinca) [#52589](https://github.com/nodejs/node/pull/52589)
* \[[`a93f5d4aaa`](https://github.com/nodejs/node/commit/a93f5d4aaa)] - **doc**: correct stream.finished changes (KaKa) [#52551](https://github.com/nodejs/node/pull/52551)
* \[[`27ffa35540`](https://github.com/nodejs/node/commit/27ffa35540)] - **doc**: add RedYetiDev to triage team (Aviv Keller) [#52556](https://github.com/nodejs/node/pull/52556)
* \[[`63cc2b870e`](https://github.com/nodejs/node/commit/63cc2b870e)] - **doc**: fix issue detected in markdown lint update (Rich Trott) [#52566](https://github.com/nodejs/node/pull/52566)
* \[[`7e93c4892b`](https://github.com/nodejs/node/commit/7e93c4892b)] - **doc**: update test runner coverage limitations (Moshe Atlow) [#52515](https://github.com/nodejs/node/pull/52515)
* \[[`3026401be1`](https://github.com/nodejs/node/commit/3026401be1)] - **events,doc**: mark CustomEvent as stable (Daeyeon Jeong) [#52618](https://github.com/nodejs/node/pull/52618)
* \[[`c6e0fe2f22`](https://github.com/nodejs/node/commit/c6e0fe2f22)] - **fs**: allow setting Stat date properties (Nicolò Ribaudo) [#52708](https://github.com/nodejs/node/pull/52708)
* \[[`f23fa1de72`](https://github.com/nodejs/node/commit/f23fa1de72)] - **fs**: fix read / readSync positional offset types (Ruy Adorno) [#52603](https://github.com/nodejs/node/pull/52603)
* \[[`a7e03d301a`](https://github.com/nodejs/node/commit/a7e03d301a)] - **fs**: fixes recursive fs.watch crash on Linux when deleting files (Matteo Collina) [#52349](https://github.com/nodejs/node/pull/52349)
* \[[`d5ecb6cd00`](https://github.com/nodejs/node/commit/d5ecb6cd00)] - **http2**: fix excessive CPU usage when using `allowHTTP1=true` (Eugene) [#52713](https://github.com/nodejs/node/pull/52713)
* \[[`d1adc9b140`](https://github.com/nodejs/node/commit/d1adc9b140)] - **lib**: enforce ASCII order in error code imports (Antoine du Hamel) [#52625](https://github.com/nodejs/node/pull/52625)
* \[[`9ffdcade37`](https://github.com/nodejs/node/commit/9ffdcade37)] - **lib**: use predefined variable instead of bit operation (Deokjin Kim) [#52580](https://github.com/nodejs/node/pull/52580)
* \[[`fdcde845ee`](https://github.com/nodejs/node/commit/fdcde845ee)] - **lib**: refactor lazy loading of undici for fetch method (Victor Chen) [#52275](https://github.com/nodejs/node/pull/52275)
* \[[`f6145aa2ca`](https://github.com/nodejs/node/commit/f6145aa2ca)] - **lib**: convert WeakMaps in cjs loader with private symbol properties (Chengzhong Wu) [#52095](https://github.com/nodejs/node/pull/52095)
* \[[`014bf01efc`](https://github.com/nodejs/node/commit/014bf01efc)] - **lib**: replace string prototype usage with alternatives (Aviv Keller) [#52440](https://github.com/nodejs/node/pull/52440)
* \[[`dc399ddd03`](https://github.com/nodejs/node/commit/dc399ddd03)] - **lib, doc**: rename readme.md to README.md (Aviv Keller) [#52471](https://github.com/nodejs/node/pull/52471)
* \[[`64428dc1c9`](https://github.com/nodejs/node/commit/64428dc1c9)] - **(SEMVER-MINOR)** **lib, url**: add a `windows` option to path parsing (Aviv Keller) [#52509](https://github.com/nodejs/node/pull/52509)
* \[[`9b2b6abb62`](https://github.com/nodejs/node/commit/9b2b6abb62)] - **lib,src**: iterate module requests of a module wrap in JS (Chengzhong Wu) [#52058](https://github.com/nodejs/node/pull/52058)
* \[[`896a80e366`](https://github.com/nodejs/node/commit/896a80e366)] - **meta**: standardize regex (Aviv Keller) [#52693](https://github.com/nodejs/node/pull/52693)
* \[[`20c07e922e`](https://github.com/nodejs/node/commit/20c07e922e)] - **meta**: move one or more collaborators to emeritus (Node.js GitHub Bot) [#52633](https://github.com/nodejs/node/pull/52633)
* \[[`e70d8a4fa9`](https://github.com/nodejs/node/commit/e70d8a4fa9)] - **meta**: move one or more collaborators to emeritus (Node.js GitHub Bot) [#52457](https://github.com/nodejs/node/pull/52457)
* \[[`20ab8f2a88`](https://github.com/nodejs/node/commit/20ab8f2a88)] - **module**: support ESM detection in the CJS loader (Joyee Cheung) [#52047](https://github.com/nodejs/node/pull/52047)
* \[[`544c602b75`](https://github.com/nodejs/node/commit/544c602b75)] - **module**: skip NODE\_COMPILE\_CACHE when policy is enabled (Joyee Cheung) [#52577](https://github.com/nodejs/node/pull/52577)
* \[[`3df3afc284`](https://github.com/nodejs/node/commit/3df3afc284)] - **module**: detect ESM syntax by trying to recompile as SourceTextModule (Joyee Cheung) [#52413](https://github.com/nodejs/node/pull/52413)
* \[[`4d77fd2c46`](https://github.com/nodejs/node/commit/4d77fd2c46)] - **(SEMVER-MINOR)** **module**: implement NODE\_COMPILE\_CACHE for automatic on-disk code caching (Joyee Cheung) [#52535](https://github.com/nodejs/node/pull/52535)
* \[[`9794d21b07`](https://github.com/nodejs/node/commit/9794d21b07)] - **module**: fix submodules loaded by require() and import() (Joyee Cheung) [#52487](https://github.com/nodejs/node/pull/52487)
* \[[`b00766d9e7`](https://github.com/nodejs/node/commit/b00766d9e7)] - **module**: tidy code and comments (Jacob Smith) [#52437](https://github.com/nodejs/node/pull/52437)
* \[[`d79ae74f71`](https://github.com/nodejs/node/commit/d79ae74f71)] - **(SEMVER-MINOR)** **net**: add CLI option for autoSelectFamilyAttemptTimeout (Paolo Insogna) [#52474](https://github.com/nodejs/node/pull/52474)
* \[[`b17cfea289`](https://github.com/nodejs/node/commit/b17cfea289)] - **node-api**: address coverity report (Michael Dawson) [#52584](https://github.com/nodejs/node/pull/52584)
* \[[`1fca8baac1`](https://github.com/nodejs/node/commit/1fca8baac1)] - **node-api**: copy external type tags when they are set (Niels Martignène) [#52426](https://github.com/nodejs/node/pull/52426)
* \[[`d086ab42a1`](https://github.com/nodejs/node/commit/d086ab42a1)] - **quic**: address recent coverity warnings (Michael Dawson) [#52647](https://github.com/nodejs/node/pull/52647)
* \[[`fb4edf70cf`](https://github.com/nodejs/node/commit/fb4edf70cf)] - **quic**: rework TLSContext, additional cleanups (James M Snell) [#51340](https://github.com/nodejs/node/pull/51340)
* \[[`0c58d0319b`](https://github.com/nodejs/node/commit/0c58d0319b)] - **src**: remove misplaced windows code under posix guard in node.cc (Ali Hassan) [#52545](https://github.com/nodejs/node/pull/52545)
* \[[`e20d2f1de3`](https://github.com/nodejs/node/commit/e20d2f1de3)] - **src**: cast to v8::Value before using v8::EmbedderGraph::V8Node (Joyee Cheung) [#52638](https://github.com/nodejs/node/pull/52638)
* \[[`43fa6a1a45`](https://github.com/nodejs/node/commit/43fa6a1a45)] - **(SEMVER-MINOR)** **src**: add `string_view` overload to snapshot FromBlob (Anna Henningsen) [#52595](https://github.com/nodejs/node/pull/52595)
* \[[`a56faff4d0`](https://github.com/nodejs/node/commit/a56faff4d0)] - **src**: parse inspector profiles with simdjson (Joyee Cheung) [#51783](https://github.com/nodejs/node/pull/51783)
* \[[`ac04c6434a`](https://github.com/nodejs/node/commit/ac04c6434a)] - **src**: remove regex usage for env file parsing (IlyasShabi) [#52406](https://github.com/nodejs/node/pull/52406)
* \[[`f283d27285`](https://github.com/nodejs/node/commit/f283d27285)] - **src**: fix loadEnvFile ENOENT error (mathis-west-1) [#52438](https://github.com/nodejs/node/pull/52438)
* \[[`c6fe433d42`](https://github.com/nodejs/node/commit/c6fe433d42)] - **src,permission**: throw async errors on async APIs (Rafael Gonzaga) [#52730](https://github.com/nodejs/node/pull/52730)
* \[[`9f9eca965a`](https://github.com/nodejs/node/commit/9f9eca965a)] - **stream**: update ongoing promise in async iterator return() method (Mattias Buelens) [#52657](https://github.com/nodejs/node/pull/52657)
* \[[`d568a9a38e`](https://github.com/nodejs/node/commit/d568a9a38e)] - **test**: mark `test-error-serdes` as flaky (Antoine du Hamel) [#52739](https://github.com/nodejs/node/pull/52739)
* \[[`45f7002b90`](https://github.com/nodejs/node/commit/45f7002b90)] - **test**: mark test as flaky (Michael Dawson) [#52671](https://github.com/nodejs/node/pull/52671)
* \[[`10596e20e8`](https://github.com/nodejs/node/commit/10596e20e8)] - **test**: fix backtick usage in docs (Aviv Keller) [#52643](https://github.com/nodejs/node/pull/52643)
* \[[`b2f754c9f1`](https://github.com/nodejs/node/commit/b2f754c9f1)] - **test**: skip test-fs-watch-recursive-delete.js on IBM i (Abdirahim Musse) [#52645](https://github.com/nodejs/node/pull/52645)
* \[[`ed080d868d`](https://github.com/nodejs/node/commit/ed080d868d)] - **test**: ensure that all worker servers are ready (Luigi Pinca) [#52563](https://github.com/nodejs/node/pull/52563)
* \[[`c8c61737e4`](https://github.com/nodejs/node/commit/c8c61737e4)] - **test**: fix test-tls-ticket-cluster.js (Hüseyin Açacak) [#52431](https://github.com/nodejs/node/pull/52431)
* \[[`18aa5d6640`](https://github.com/nodejs/node/commit/18aa5d6640)] - **test**: split wasi poll test for windows (Hüseyin Açacak) [#52538](https://github.com/nodejs/node/pull/52538)
* \[[`e34e0a9ba1`](https://github.com/nodejs/node/commit/e34e0a9ba1)] - **test**: write tests for assertIsArray http2 util (Sinan Sonmez (Chaush)) [#52511](https://github.com/nodejs/node/pull/52511)
* \[[`e247a61d15`](https://github.com/nodejs/node/commit/e247a61d15)] - **(SEMVER-MINOR)** **test\_runner**: add --test-skip-pattern cli option (Aviv Keller) [#52529](https://github.com/nodejs/node/pull/52529)
* \[[`e066ba2ae4`](https://github.com/nodejs/node/commit/e066ba2ae4)] - **test\_runner**: better error handing for test hook (Alex Yang) [#52401](https://github.com/nodejs/node/pull/52401)
* \[[`328755341d`](https://github.com/nodejs/node/commit/328755341d)] - **test\_runner**: don't exceed call stack when filtering (Colin Ihrig) [#52488](https://github.com/nodejs/node/pull/52488)
* \[[`b4ccb6c626`](https://github.com/nodejs/node/commit/b4ccb6c626)] - **test\_runner**: move end of work check to finalize() (Colin Ihrig) [#52488](https://github.com/nodejs/node/pull/52488)
* \[[`2ef9380472`](https://github.com/nodejs/node/commit/2ef9380472)] - **tools**: update lint-md-dependencies to rollup\@4.17.0 (Node.js GitHub Bot) [#52729](https://github.com/nodejs/node/pull/52729)
* \[[`db421bdefc`](https://github.com/nodejs/node/commit/db421bdefc)] - **tools**: take co-authors into account in `find-inactive-collaborators` (Antoine du Hamel) [#52669](https://github.com/nodejs/node/pull/52669)
* \[[`01103a85cb`](https://github.com/nodejs/node/commit/01103a85cb)] - **tools**: fix invalid escape sequence in mkssldef (Michaël Zasso) [#52624](https://github.com/nodejs/node/pull/52624)
* \[[`382d951b01`](https://github.com/nodejs/node/commit/382d951b01)] - **tools**: update lint-md-dependencies to rollup\@4.15.0 (Node.js GitHub Bot) [#52617](https://github.com/nodejs/node/pull/52617)
* \[[`f9ddd77ff3`](https://github.com/nodejs/node/commit/f9ddd77ff3)] - **tools**: add lint rule to keep primordials in ASCII order (Antoine du Hamel) [#52592](https://github.com/nodejs/node/pull/52592)
* \[[`552642a498`](https://github.com/nodejs/node/commit/552642a498)] - **tools**: update lint-md-dependencies (Rich Trott) [#52581](https://github.com/nodejs/node/pull/52581)
* \[[`df61feb655`](https://github.com/nodejs/node/commit/df61feb655)] - **tools**: fix heading spaces for osx-entitlements.plist (Jackson Tian) [#52561](https://github.com/nodejs/node/pull/52561)
* \[[`6b4bbfbb1f`](https://github.com/nodejs/node/commit/6b4bbfbb1f)] - **tools**: update lint-md-dependencies to rollup\@4.14.2 vfile-reporter\@8.1.1 (Node.js GitHub Bot) [#52518](https://github.com/nodejs/node/pull/52518)
* \[[`4e5ce3afb7`](https://github.com/nodejs/node/commit/4e5ce3afb7)] - **tools**: use stylistic ESLint plugin for formatting (Michaël Zasso) [#50714](https://github.com/nodejs/node/pull/50714)
* \[[`15c5686381`](https://github.com/nodejs/node/commit/15c5686381)] - **tools**: update minimatch index path (Marco Ippolito) [#52523](https://github.com/nodejs/node/pull/52523)
* \[[`8ae1507ae1`](https://github.com/nodejs/node/commit/8ae1507ae1)] - **tools**: add a linter for README lists (Antoine du Hamel) [#52476](https://github.com/nodejs/node/pull/52476)
* \[[`0b970316bc`](https://github.com/nodejs/node/commit/0b970316bc)] - **typings**: fix invalid JSDoc declarations (Yagiz Nizipli) [#52659](https://github.com/nodejs/node/pull/52659)
* \[[`9b18df9dcb`](https://github.com/nodejs/node/commit/9b18df9dcb)] - **(SEMVER-MINOR)** **url**: implement parse method for safer URL parsing (Ali Hassan) [#52280](https://github.com/nodejs/node/pull/52280)
* \[[`d33131af3a`](https://github.com/nodejs/node/commit/d33131af3a)] - **vm**: fix ASCII-betical order (Aviv Keller) [#52686](https://github.com/nodejs/node/pull/52686)

<a id="22.0.0"></a>

## 2024-04-24, Version 22.0.0 (Current), @RafaelGSS and @marco-ippolito

We're excited to announce the release of Node.js 22!
Highlights include require()ing ESM graphs, WebSocket client, updates of the V8 JavaScript engine, and more!
As a reminder, Node.js 22 will enter long-term support (LTS) in October, but until then, it will be the "Current" release for the next six months.
We encourage you to explore the new features and benefits offered by this latest release and evaluate their potential impact on your applications.

### Other Notable Changes

* \[[`25c79f3331`](https://github.com/nodejs/node/commit/25c79f3331)] - **esm**: drop support for import assertions (Nicolò Ribaudo) [#52104](https://github.com/nodejs/node/pull/52104)
* \[[`818c10e86d`](https://github.com/nodejs/node/commit/818c10e86d)] - **lib**: improve perf of `AbortSignal` creation (Raz Luvaton) [#52408](https://github.com/nodejs/node/pull/52408)
* \[[`4f68c7c1c9`](https://github.com/nodejs/node/commit/4f68c7c1c9)] - **watch**: mark as stable (Moshe Atlow) [#52074](https://github.com/nodejs/node/pull/52074)
* \[[`02b0bc01fe`](https://github.com/nodejs/node/commit/02b0bc01fe)] - **(SEMVER-MAJOR)** **deps**: update V8 to 12.4.254.14 (Michaël Zasso) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`c975384264`](https://github.com/nodejs/node/commit/c975384264)] - **(SEMVER-MAJOR)** **lib**: enable WebSocket by default (Aras Abbasi) [#51594](https://github.com/nodejs/node/pull/51594)
* \[[`1abff07392`](https://github.com/nodejs/node/commit/1abff07392)] - **(SEMVER-MAJOR)** **stream**: bump default highWaterMark (Robert Nagy) [#52037](https://github.com/nodejs/node/pull/52037)
* \[[`1a5acd0638`](https://github.com/nodejs/node/commit/1a5acd0638)] - **(SEMVER-MAJOR)** **v8**: enable maglev on supported architectures (Keyhan Vakil) [#51360](https://github.com/nodejs/node/pull/51360)
* \[[`128c60d906`](https://github.com/nodejs/node/commit/128c60d906)] - **(SEMVER-MINOR)** **cli**: implement `node --run <script-in-package-json>` (Yagiz Nizipli) [#52190](https://github.com/nodejs/node/pull/52190)
* \[[`151d365ad1`](https://github.com/nodejs/node/commit/151d365ad1)] - **(SEMVER-MINOR)** **fs**: expose glob and globSync (Moshe Atlow) [#51912](https://github.com/nodejs/node/pull/51912)
* \[[`5f7fad2605`](https://github.com/nodejs/node/commit/5f7fad2605)] - **(SEMVER-MINOR)** **module**: support require()ing synchronous ESM graphs (Joyee Cheung) [#51977](https://github.com/nodejs/node/pull/51977)

### Semver-Major Commits

* \[[`2b1e7c2fcb`](https://github.com/nodejs/node/commit/2b1e7c2fcb)] - **(SEMVER-MAJOR)** **build**: compile with C++20 support on Windows (StefanStojanovic) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`12d00f1479`](https://github.com/nodejs/node/commit/12d00f1479)] - **(SEMVER-MAJOR)** **build**: reset embedder string to "-node.0" (Michaël Zasso) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`5f08e11a3c`](https://github.com/nodejs/node/commit/5f08e11a3c)] - **(SEMVER-MAJOR)** **build**: reset embedder string to "-node.0" (Michaël Zasso) [#52293](https://github.com/nodejs/node/pull/52293)
* \[[`94f0369d1d`](https://github.com/nodejs/node/commit/94f0369d1d)] - **(SEMVER-MAJOR)** **build**: reset embedder string to "-node.0" (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`58674cd1d8`](https://github.com/nodejs/node/commit/58674cd1d8)] - **(SEMVER-MAJOR)** **build**: reset embedder string to "-node.0" (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`60e836427e`](https://github.com/nodejs/node/commit/60e836427e)] - **(SEMVER-MAJOR)** **console**: treat non-strings as separate argument in console.assert() (Jacob Hummer) [#49722](https://github.com/nodejs/node/pull/49722)
* \[[`d62ab3a1ef`](https://github.com/nodejs/node/commit/d62ab3a1ef)] - **(SEMVER-MAJOR)** **crypto**: runtime deprecate hmac constructor (Marco Ippolito) [#52071](https://github.com/nodejs/node/pull/52071)
* \[[`de0602d190`](https://github.com/nodejs/node/commit/de0602d190)] - **(SEMVER-MAJOR)** **crypto**: runtime deprecate Hash constructor (Marco Ippolito) [#51880](https://github.com/nodejs/node/pull/51880)
* \[[`215f4d04b7`](https://github.com/nodejs/node/commit/215f4d04b7)] - **(SEMVER-MAJOR)** **crypto**: move createCipher and createDecipher to eol (Marco Ippolito) [#50973](https://github.com/nodejs/node/pull/50973)
* \[[`30801b8aaf`](https://github.com/nodejs/node/commit/30801b8aaf)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick cd10ad7cdbe5 (Joyee Cheung) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`521b629ab1`](https://github.com/nodejs/node/commit/521b629ab1)] - **(SEMVER-MAJOR)** **deps**: V8: revert CL 5331688 (Michaël Zasso) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`3795e97e6c`](https://github.com/nodejs/node/commit/3795e97e6c)] - **(SEMVER-MAJOR)** **deps**: patch V8 to support compilation with MSVC (StefanStojanovic) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`5bde9e677d`](https://github.com/nodejs/node/commit/5bde9e677d)] - **(SEMVER-MAJOR)** **deps**: silence internal V8 deprecation warning (Michaël Zasso) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`46e628c6f2`](https://github.com/nodejs/node/commit/46e628c6f2)] - **(SEMVER-MAJOR)** **deps**: patch V8 to avoid duplicated zlib symbol (Michaël Zasso) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`f824e40a82`](https://github.com/nodejs/node/commit/f824e40a82)] - **(SEMVER-MAJOR)** **deps**: remove usage of a C++20 feature from V8 (Michaël Zasso) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`d2c84c9a13`](https://github.com/nodejs/node/commit/d2c84c9a13)] - **(SEMVER-MAJOR)** **deps**: avoid compilation error with ASan (Michaël Zasso) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`95d6045bdb`](https://github.com/nodejs/node/commit/95d6045bdb)] - **(SEMVER-MAJOR)** **deps**: disable V8 concurrent sparkplug compilation (Michaël Zasso) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`00f55f5743`](https://github.com/nodejs/node/commit/00f55f5743)] - **(SEMVER-MAJOR)** **deps**: silence irrelevant V8 warning (Michaël Zasso) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`764085aa66`](https://github.com/nodejs/node/commit/764085aa66)] - **(SEMVER-MAJOR)** **deps**: always define V8\_EXPORT\_PRIVATE as no-op (Michaël Zasso) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`02b0bc01fe`](https://github.com/nodejs/node/commit/02b0bc01fe)] - **(SEMVER-MAJOR)** **deps**: update V8 to 12.4.254.14 (Michaël Zasso) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`0ec50a19dd`](https://github.com/nodejs/node/commit/0ec50a19dd)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick cd10ad7cdbe5 (Joyee Cheung) [#52293](https://github.com/nodejs/node/pull/52293)
* \[[`021b0b7dee`](https://github.com/nodejs/node/commit/021b0b7dee)] - **(SEMVER-MAJOR)** **deps**: V8: backport c4be0a97f981 (Richard Lau) [#52293](https://github.com/nodejs/node/pull/52293)
* \[[`681aaf85c7`](https://github.com/nodejs/node/commit/681aaf85c7)] - **(SEMVER-MAJOR)** **deps**: silence internal V8 deprecation warning (Michaël Zasso) [#52293](https://github.com/nodejs/node/pull/52293)
* \[[`c563a1c4e4`](https://github.com/nodejs/node/commit/c563a1c4e4)] - **(SEMVER-MAJOR)** **deps**: patch V8 to support compilation with MSVC (Stefan Stojanovic) [#52293](https://github.com/nodejs/node/pull/52293)
* \[[`11e94b9987`](https://github.com/nodejs/node/commit/11e94b9987)] - **(SEMVER-MAJOR)** **deps**: patch V8 to avoid duplicated zlib symbol (Michaël Zasso) [#52293](https://github.com/nodejs/node/pull/52293)
* \[[`856163e23c`](https://github.com/nodejs/node/commit/856163e23c)] - **(SEMVER-MAJOR)** **deps**: remove usage of a C++20 feature from V8 (Michaël Zasso) [#52293](https://github.com/nodejs/node/pull/52293)
* \[[`b530214127`](https://github.com/nodejs/node/commit/b530214127)] - **(SEMVER-MAJOR)** **deps**: avoid compilation error with ASan (Michaël Zasso) [#52293](https://github.com/nodejs/node/pull/52293)
* \[[`8054f69dd9`](https://github.com/nodejs/node/commit/8054f69dd9)] - **(SEMVER-MAJOR)** **deps**: disable V8 concurrent sparkplug compilation (Michaël Zasso) [#52293](https://github.com/nodejs/node/pull/52293)
* \[[`dee908be42`](https://github.com/nodejs/node/commit/dee908be42)] - **(SEMVER-MAJOR)** **deps**: silence irrelevant V8 warning (Michaël Zasso) [#52293](https://github.com/nodejs/node/pull/52293)
* \[[`cf069414ee`](https://github.com/nodejs/node/commit/cf069414ee)] - **(SEMVER-MAJOR)** **deps**: always define V8\_EXPORT\_PRIVATE as no-op (Michaël Zasso) [#52293](https://github.com/nodejs/node/pull/52293)
* \[[`cc5792dd85`](https://github.com/nodejs/node/commit/cc5792dd85)] - **(SEMVER-MAJOR)** **deps**: update V8 to 12.3.219.16 (Michaël Zasso) [#52293](https://github.com/nodejs/node/pull/52293)
* \[[`61a0d3b4c4`](https://github.com/nodejs/node/commit/61a0d3b4c4)] - **(SEMVER-MAJOR)** **deps**: V8: backport c4be0a97f981 (Richard Lau) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`f55380a725`](https://github.com/nodejs/node/commit/f55380a725)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick f8d5e576b814 (Richard Lau) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`b9d806a2dd`](https://github.com/nodejs/node/commit/b9d806a2dd)] - **(SEMVER-MAJOR)** **deps**: patch V8 to support compilation with MSVC (StefanStojanovic) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`63b58bc17b`](https://github.com/nodejs/node/commit/63b58bc17b)] - **(SEMVER-MAJOR)** **deps**: patch V8 to avoid duplicated zlib symbol (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`86056353c4`](https://github.com/nodejs/node/commit/86056353c4)] - **(SEMVER-MAJOR)** **deps**: remove usage of a C++20 feature from V8 (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`2e0efc1c8d`](https://github.com/nodejs/node/commit/2e0efc1c8d)] - **(SEMVER-MAJOR)** **deps**: avoid compilation error with ASan (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`59e6f62e34`](https://github.com/nodejs/node/commit/59e6f62e34)] - **(SEMVER-MAJOR)** **deps**: disable V8 concurrent sparkplug compilation (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`0423f7e27e`](https://github.com/nodejs/node/commit/0423f7e27e)] - **(SEMVER-MAJOR)** **deps**: silence irrelevant V8 warning (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`f36620806d`](https://github.com/nodejs/node/commit/f36620806d)] - **(SEMVER-MAJOR)** **deps**: always define V8\_EXPORT\_PRIVATE as no-op (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`09a8440b45`](https://github.com/nodejs/node/commit/09a8440b45)] - **(SEMVER-MAJOR)** **deps**: update V8 to 12.2.281.27 (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`0da3beebfc`](https://github.com/nodejs/node/commit/0da3beebfc)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick de611e69ad51 (Keyhan Vakil) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`b982335637`](https://github.com/nodejs/node/commit/b982335637)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick 0fd478bcdabd (Joyee Cheung) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`481a90116c`](https://github.com/nodejs/node/commit/481a90116c)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick 0f9ebbc672c7 (Chengzhong Wu) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`782addbdc3`](https://github.com/nodejs/node/commit/782addbdc3)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick 8f0b94671ddb (Lu Yahan) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`b682e7f540`](https://github.com/nodejs/node/commit/b682e7f540)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick f7d000a7ae7b (Luke Albao) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`a60090c52f`](https://github.com/nodejs/node/commit/a60090c52f)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick 25902244ad1a (Joyee Cheung) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`8441d1fc18`](https://github.com/nodejs/node/commit/8441d1fc18)] - **(SEMVER-MAJOR)** **deps**: patch V8 to avoid duplicated zlib symbol (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`e8e9bbd7a9`](https://github.com/nodejs/node/commit/e8e9bbd7a9)] - **(SEMVER-MAJOR)** **deps**: remove usage of a C++20 feature from V8 (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`785d5cd006`](https://github.com/nodejs/node/commit/785d5cd006)] - **(SEMVER-MAJOR)** **deps**: avoid compilation error with ASan (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`7071c1dafd`](https://github.com/nodejs/node/commit/7071c1dafd)] - **(SEMVER-MAJOR)** **deps**: disable V8 concurrent sparkplug compilation (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`d1d60b297d`](https://github.com/nodejs/node/commit/d1d60b297d)] - **(SEMVER-MAJOR)** **deps**: silence irrelevant V8 warning (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`5b240c62f9`](https://github.com/nodejs/node/commit/5b240c62f9)] - **(SEMVER-MAJOR)** **deps**: always define V8\_EXPORT\_PRIVATE as no-op (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`d8c97e4857`](https://github.com/nodejs/node/commit/d8c97e4857)] - **(SEMVER-MAJOR)** **deps**: update V8 to 11.9.169.7 (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`b9df88a8c2`](https://github.com/nodejs/node/commit/b9df88a8c2)] - **(SEMVER-MAJOR)** **doc**: runtime deprecate flag --trace-atomics-wait (marco-ippolito) [#51179](https://github.com/nodejs/node/pull/51179)
* \[[`9ba5df30b4`](https://github.com/nodejs/node/commit/9ba5df30b4)] - **(SEMVER-MAJOR)** **doc**: bump FreeBSD experimental support to 13.2 (Michaël Zasso) [#51231](https://github.com/nodejs/node/pull/51231)
* \[[`900d79caf2`](https://github.com/nodejs/node/commit/900d79caf2)] - **(SEMVER-MAJOR)** **doc**: add migration paths for deprecated utils (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`8206f6bb7f`](https://github.com/nodejs/node/commit/8206f6bb7f)] - **(SEMVER-MAJOR)** **fs**: runtime deprecate fs.Stats constructor (Marco Ippolito) [#52067](https://github.com/nodejs/node/pull/52067)
* \[[`c14133503a`](https://github.com/nodejs/node/commit/c14133503a)] - **(SEMVER-MAJOR)** **fs**: use private fields instead of symbols for `Dir` (Jungku Lee) [#51037](https://github.com/nodejs/node/pull/51037)
* \[[`abbdc3efaa`](https://github.com/nodejs/node/commit/abbdc3efaa)] - **(SEMVER-MAJOR)** **fs**: make stats date fields lazy (Yagiz Nizipli) [#50908](https://github.com/nodejs/node/pull/50908)
* \[[`4b76ccea95`](https://github.com/nodejs/node/commit/4b76ccea95)] - **(SEMVER-MAJOR)** **http**: preserve raw header duplicates in writeHead after setHeader calls (Tim Perry) [#50394](https://github.com/nodejs/node/pull/50394)
* \[[`c975384264`](https://github.com/nodejs/node/commit/c975384264)] - **(SEMVER-MAJOR)** **lib**: enable WebSocket by default (Aras Abbasi) [#51594](https://github.com/nodejs/node/pull/51594)
* \[[`351495e938`](https://github.com/nodejs/node/commit/351495e938)] - **(SEMVER-MAJOR)** **lib,test**: handle new Iterator global (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`a8b21fdc90`](https://github.com/nodejs/node/commit/a8b21fdc90)] - **(SEMVER-MAJOR)** **process**: wait for `'exit'` before printing result (Antoine du Hamel) [#52172](https://github.com/nodejs/node/pull/52172)
* \[[`582ff5037c`](https://github.com/nodejs/node/commit/582ff5037c)] - **(SEMVER-MAJOR)** **src**: update NODE\_MODULE\_VERSION to 127 (Michaël Zasso) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`c5c4b50260`](https://github.com/nodejs/node/commit/c5c4b50260)] - **(SEMVER-MAJOR)** **src**: update NODE\_MODULE\_VERSION to 126 (Michaël Zasso) [#52293](https://github.com/nodejs/node/pull/52293)
* \[[`d248639285`](https://github.com/nodejs/node/commit/d248639285)] - **(SEMVER-MAJOR)** **src**: use supported API to get stalled TLA messages (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`d34b02db4c`](https://github.com/nodejs/node/commit/d34b02db4c)] - **(SEMVER-MAJOR)** **src**: update default V8 platform to override functions with location (Etienne Pierre-Doray) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`d9c47e9b5f`](https://github.com/nodejs/node/commit/d9c47e9b5f)] - **(SEMVER-MAJOR)** **src**: add missing TryCatch (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`5cddd3b2d8`](https://github.com/nodejs/node/commit/5cddd3b2d8)] - **(SEMVER-MAJOR)** **src**: update NODE\_MODULE\_VERSION to 124 (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`1528846ada`](https://github.com/nodejs/node/commit/1528846ada)] - **(SEMVER-MAJOR)** **src**: use non-deprecated v8::Uint8Array::kMaxLength (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`7166986626`](https://github.com/nodejs/node/commit/7166986626)] - **(SEMVER-MAJOR)** **src**: adapt to v8::Exception API change (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`4782818020`](https://github.com/nodejs/node/commit/4782818020)] - **(SEMVER-MAJOR)** **src**: use non-deprecated version of CreateSyntheticModule (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`2cff0ce411`](https://github.com/nodejs/node/commit/2cff0ce411)] - **(SEMVER-MAJOR)** **src**: update NODE\_MODULE\_VERSION to 122 (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`1abff07392`](https://github.com/nodejs/node/commit/1abff07392)] - **(SEMVER-MAJOR)** **stream**: bump default highWaterMark (Robert Nagy) [#52037](https://github.com/nodejs/node/pull/52037)
* \[[`9efc84a2cb`](https://github.com/nodejs/node/commit/9efc84a2cb)] - **(SEMVER-MAJOR)** **test**: mark test-worker-arraybuffer-zerofill as flaky (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`84c2e712eb`](https://github.com/nodejs/node/commit/84c2e712eb)] - **(SEMVER-MAJOR)** **test**: mark some GC-related tests as flaky (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`cdc4437b87`](https://github.com/nodejs/node/commit/cdc4437b87)] - **(SEMVER-MAJOR)** **test**: allow slightly more diff in memory leak test (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`515b007fae`](https://github.com/nodejs/node/commit/515b007fae)] - **(SEMVER-MAJOR)** **test**: replace always-opt flag with alway-turbofan (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`2341805eb2`](https://github.com/nodejs/node/commit/2341805eb2)] - **(SEMVER-MAJOR)** **test**: remove tests that create very large buffers (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`941cef5636`](https://github.com/nodejs/node/commit/941cef5636)] - **(SEMVER-MAJOR)** **test**: adapt to new V8 trusted memory spaces (Michaël Zasso) [#50115](https://github.com/nodejs/node/pull/50115)
* \[[`29de7f82cd`](https://github.com/nodejs/node/commit/29de7f82cd)] - **(SEMVER-MAJOR)** **test\_runner**: omit filtered test from output (Colin Ihrig) [#52221](https://github.com/nodejs/node/pull/52221)
* \[[`00dc6d9d97`](https://github.com/nodejs/node/commit/00dc6d9d97)] - **(SEMVER-MAJOR)** **test\_runner**: improve `--test-name-pattern` to allow matching single test (Michał Drobniak) [#51577](https://github.com/nodejs/node/pull/51577)
* \[[`5def8019d5`](https://github.com/nodejs/node/commit/5def8019d5)] - **(SEMVER-MAJOR)** **tools**: update V8 gypfiles for 12.4 (Michaël Zasso) [#52465](https://github.com/nodejs/node/pull/52465)
* \[[`c22793d050`](https://github.com/nodejs/node/commit/c22793d050)] - **(SEMVER-MAJOR)** **tools**: roughly port v8\_abseil to gyp (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`ffb0302f0c`](https://github.com/nodejs/node/commit/ffb0302f0c)] - **(SEMVER-MAJOR)** **tools**: update V8 gypfiles for 12.2 (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`aadea12440`](https://github.com/nodejs/node/commit/aadea12440)] - **(SEMVER-MAJOR)** **tools**: update V8 gypfiles for 12.1 (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`7784773967`](https://github.com/nodejs/node/commit/7784773967)] - **(SEMVER-MAJOR)** **tools**: update V8 gypfiles for 12.0 (Michaël Zasso) [#51362](https://github.com/nodejs/node/pull/51362)
* \[[`9fe0424baa`](https://github.com/nodejs/node/commit/9fe0424baa)] - **(SEMVER-MAJOR)** **trace\_events**: use private fields instead of symbols for `Tracing` (Jungku Lee) [#51180](https://github.com/nodejs/node/pull/51180)
* \[[`e96cd25007`](https://github.com/nodejs/node/commit/e96cd25007)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.log (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`6cf20d5e43`](https://github.com/nodejs/node/commit/6cf20d5e43)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.isUndefined (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`09e424921f`](https://github.com/nodejs/node/commit/09e424921f)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.isSymbol (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`80b6bfd4e9`](https://github.com/nodejs/node/commit/80b6bfd4e9)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.isString (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`d419edded9`](https://github.com/nodejs/node/commit/d419edded9)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.isRegExp (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`e0b8de78ed`](https://github.com/nodejs/node/commit/e0b8de78ed)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.isPrimitive (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`5478e1129a`](https://github.com/nodejs/node/commit/5478e1129a)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.isObject (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`b05b1dd541`](https://github.com/nodejs/node/commit/b05b1dd541)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.isNumber (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`5af9bf5f6a`](https://github.com/nodejs/node/commit/5af9bf5f6a)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.isNullOrUndefined (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`860a10e10e`](https://github.com/nodejs/node/commit/860a10e10e)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.isNull (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`70330f5c2b`](https://github.com/nodejs/node/commit/70330f5c2b)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.isFunction (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`7c69c33acc`](https://github.com/nodejs/node/commit/7c69c33acc)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.isError (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`a0c5b871a9`](https://github.com/nodejs/node/commit/a0c5b871a9)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.isDate (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`3c670cb15d`](https://github.com/nodejs/node/commit/3c670cb15d)] - **(SEMVER-MAJOR)** **util**: runtime deprecation util.isBuffer (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`c17a448ca9`](https://github.com/nodejs/node/commit/c17a448ca9)] - **(SEMVER-MAJOR)** **util**: runtime deprecation util.isBoolean (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`fbb2f891aa`](https://github.com/nodejs/node/commit/fbb2f891aa)] - **(SEMVER-MAJOR)** **util**: runtime deprecate util.isArray (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`22d8062e42`](https://github.com/nodejs/node/commit/22d8062e42)] - **(SEMVER-MAJOR)** **util**: runtime deprecation util.\_extend (Marco Ippolito) [#50488](https://github.com/nodejs/node/pull/50488)
* \[[`1a5acd0638`](https://github.com/nodejs/node/commit/1a5acd0638)] - **(SEMVER-MAJOR)** **v8**: enable maglev on supported architectures (Keyhan Vakil) [#51360](https://github.com/nodejs/node/pull/51360)

### Semver-Minor Commits

* \[[`128c60d906`](https://github.com/nodejs/node/commit/128c60d906)] - **(SEMVER-MINOR)** **cli**: implement `node --run <script-in-package-json>` (Yagiz Nizipli) [#52190](https://github.com/nodejs/node/pull/52190)
* \[[`f69946b905`](https://github.com/nodejs/node/commit/f69946b905)] - **(SEMVER-MINOR)** **deps**: update simdutf to 5.0.0 (Daniel Lemire) [#52138](https://github.com/nodejs/node/pull/52138)
* \[[`828ad42eee`](https://github.com/nodejs/node/commit/828ad42eee)] - **(SEMVER-MINOR)** **deps**: update undici to 6.3.0 (Node.js GitHub Bot) [#51462](https://github.com/nodejs/node/pull/51462)
* \[[`05f8172188`](https://github.com/nodejs/node/commit/05f8172188)] - **(SEMVER-MINOR)** **deps**: update undici to 6.2.1 (Node.js GitHub Bot) [#51278](https://github.com/nodejs/node/pull/51278)
* \[[`a0c466810a`](https://github.com/nodejs/node/commit/a0c466810a)] - **(SEMVER-MINOR)** **doc**: deprecate fs.Stats public constructor (Marco Ippolito) [#51879](https://github.com/nodejs/node/pull/51879)
* \[[`151d365ad1`](https://github.com/nodejs/node/commit/151d365ad1)] - **(SEMVER-MINOR)** **fs**: expose glob and globSync (Moshe Atlow) [#51912](https://github.com/nodejs/node/pull/51912)
* \[[`5f7fad2605`](https://github.com/nodejs/node/commit/5f7fad2605)] - **(SEMVER-MINOR)** **module**: support require()ing synchronous ESM graphs (Joyee Cheung) [#51977](https://github.com/nodejs/node/pull/51977)
* \[[`009665fb56`](https://github.com/nodejs/node/commit/009665fb56)] - **(SEMVER-MINOR)** **report**: add `--report-exclude-network` option (Ethan Arrowood) [#51645](https://github.com/nodejs/node/pull/51645)
* \[[`80f86e5d02`](https://github.com/nodejs/node/commit/80f86e5d02)] - **(SEMVER-MINOR)** **src**: add C++ ProcessEmitWarningSync() (Joyee Cheung) [#51977](https://github.com/nodejs/node/pull/51977)
* \[[`78be0d0f1c`](https://github.com/nodejs/node/commit/78be0d0f1c)] - **(SEMVER-MINOR)** **src**: add uv\_get\_available\_memory to report and process (theanarkh) [#52023](https://github.com/nodejs/node/pull/52023)
* \[[`b34512e38e`](https://github.com/nodejs/node/commit/b34512e38e)] - **(SEMVER-MINOR)** **src**: preload function for Environment (Cheng Zhao) [#51539](https://github.com/nodejs/node/pull/51539)
* \[[`7d258db1d7`](https://github.com/nodejs/node/commit/7d258db1d7)] - **(SEMVER-MINOR)** **stream**: support typed arrays (IlyasShabi) [#51866](https://github.com/nodejs/node/pull/51866)
* \[[`5276c0d5d4`](https://github.com/nodejs/node/commit/5276c0d5d4)] - **(SEMVER-MINOR)** **test\_runner**: add suite() (Colin Ihrig) [#52127](https://github.com/nodejs/node/pull/52127)
* \[[`84de97a61e`](https://github.com/nodejs/node/commit/84de97a61e)] - **(SEMVER-MINOR)** **test\_runner**: support forced exit (Colin Ihrig) [#52038](https://github.com/nodejs/node/pull/52038)
* \[[`aac5ad901d`](https://github.com/nodejs/node/commit/aac5ad901d)] - **(SEMVER-MINOR)** **test\_runner**: add `test:complete` event to reflect execution order (Moshe Atlow) [#51909](https://github.com/nodejs/node/pull/51909)
* \[[`9a1e01c4ce`](https://github.com/nodejs/node/commit/9a1e01c4ce)] - **(SEMVER-MINOR)** **util**: support array of formats in util.styleText (Marco Ippolito) [#52040](https://github.com/nodejs/node/pull/52040)
* \[[`7f2d61f82a`](https://github.com/nodejs/node/commit/7f2d61f82a)] - **(SEMVER-MINOR)** **v8**: implement v8.queryObjects() for memory leak regression testing (Joyee Cheung) [#51927](https://github.com/nodejs/node/pull/51927)
* \[[`d1d5da22e4`](https://github.com/nodejs/node/commit/d1d5da22e4)] - **(SEMVER-MINOR)** **vm**: harden module type checks (Chengzhong Wu) [#52162](https://github.com/nodejs/node/pull/52162)

### Semver-Patch Commits

* \[[`a760dadec3`](https://github.com/nodejs/node/commit/a760dadec3)] - **benchmark**: add AbortSignal.abort benchmarks (Raz Luvaton) [#52408](https://github.com/nodejs/node/pull/52408)
* \[[`47c934e464`](https://github.com/nodejs/node/commit/47c934e464)] - **benchmark**: conditionally use spawn with taskset for cpu pinning (Ali Hassan) [#52253](https://github.com/nodejs/node/pull/52253)
* \[[`dde0cffb2e`](https://github.com/nodejs/node/commit/dde0cffb2e)] - **benchmark**: add toNamespacedPath bench (Rafael Gonzaga) [#52236](https://github.com/nodejs/node/pull/52236)
* \[[`bda66ad711`](https://github.com/nodejs/node/commit/bda66ad711)] - **benchmark**: add style-text benchmark (Rafael Gonzaga) [#52004](https://github.com/nodejs/node/pull/52004)
* \[[`21211a3fa9`](https://github.com/nodejs/node/commit/21211a3fa9)] - **buffer**: improve `btoa` performance (Yagiz Nizipli) [#52427](https://github.com/nodejs/node/pull/52427)
* \[[`6f504b71ac`](https://github.com/nodejs/node/commit/6f504b71ac)] - **buffer**: use simdutf for `atob` implementation (Yagiz Nizipli) [#52381](https://github.com/nodejs/node/pull/52381)
* \[[`0ce7365856`](https://github.com/nodejs/node/commit/0ce7365856)] - **build**: temporary disable ubsan (Rafael Gonzaga) [#52560](https://github.com/nodejs/node/pull/52560)
* \[[`4e278f0253`](https://github.com/nodejs/node/commit/4e278f0253)] - **build**: speed up compilation of some V8 files (Michaël Zasso) [#52083](https://github.com/nodejs/node/pull/52083)
* \[[`ba06c5c509`](https://github.com/nodejs/node/commit/ba06c5c509)] - **build,tools**: add test-ubsan ci (Rafael Gonzaga) [#46297](https://github.com/nodejs/node/pull/46297)
* \[[`562369f348`](https://github.com/nodejs/node/commit/562369f348)] - **child\_process**: use internal addAbortListener (Chemi Atlow) [#52081](https://github.com/nodejs/node/pull/52081)
* \[[`8f61b658de`](https://github.com/nodejs/node/commit/8f61b658de)] - **crypto**: deprecate implicitly shortened GCM tags (Tobias Nießen) [#52345](https://github.com/nodejs/node/pull/52345)
* \[[`08609b5222`](https://github.com/nodejs/node/commit/08609b5222)] - **crypto**: make timingSafeEqual faster for Uint8Array (Tobias Nießen) [#52341](https://github.com/nodejs/node/pull/52341)
* \[[`9f939f5af7`](https://github.com/nodejs/node/commit/9f939f5af7)] - **crypto**: reject Ed25519/Ed448 in Sign/Verify prototypes (Filip Skokan) [#52340](https://github.com/nodejs/node/pull/52340)
* \[[`2241e8c5b3`](https://github.com/nodejs/node/commit/2241e8c5b3)] - **crypto**: validate RSA-PSS saltLength in subtle.sign and subtle.verify (Filip Skokan) [#52262](https://github.com/nodejs/node/pull/52262)
* \[[`6dd1c75f4a`](https://github.com/nodejs/node/commit/6dd1c75f4a)] - **crypto**: fix `input` validation in `crypto.hash` (Antoine du Hamel) [#52070](https://github.com/nodejs/node/pull/52070)
* \[[`a1d48f4a26`](https://github.com/nodejs/node/commit/a1d48f4a26)] - **deps**: update simdutf to 5.2.4 (Node.js GitHub Bot) [#52473](https://github.com/nodejs/node/pull/52473)
* \[[`08ff4a0c9d`](https://github.com/nodejs/node/commit/08ff4a0c9d)] - **deps**: update nghttp2 to 1.61.0 (Node.js GitHub Bot) [#52395](https://github.com/nodejs/node/pull/52395)
* \[[`cf629366b9`](https://github.com/nodejs/node/commit/cf629366b9)] - **deps**: update simdutf to 5.2.3 (Yagiz Nizipli) [#52381](https://github.com/nodejs/node/pull/52381)
* \[[`ad86a12964`](https://github.com/nodejs/node/commit/ad86a12964)] - **deps**: upgrade npm to 10.5.1 (npm team) [#52351](https://github.com/nodejs/node/pull/52351)
* \[[`45cc32c9c6`](https://github.com/nodejs/node/commit/45cc32c9c6)] - **deps**: update c-ares to 1.28.1 (Node.js GitHub Bot) [#52285](https://github.com/nodejs/node/pull/52285)
* \[[`38161c38d9`](https://github.com/nodejs/node/commit/38161c38d9)] - **deps**: update zlib to 1.3.0.1-motley-24c07df (Node.js GitHub Bot) [#52199](https://github.com/nodejs/node/pull/52199)
* \[[`1264414700`](https://github.com/nodejs/node/commit/1264414700)] - **deps**: update simdjson to 3.8.0 (Node.js GitHub Bot) [#52124](https://github.com/nodejs/node/pull/52124)
* \[[`f6996ee150`](https://github.com/nodejs/node/commit/f6996ee150)] - **deps**: V8: backport c4be0a97f981 (Richard Lau) [#52183](https://github.com/nodejs/node/pull/52183)
* \[[`0d4bc4c40e`](https://github.com/nodejs/node/commit/0d4bc4c40e)] - **deps**: V8: cherry-pick f8d5e576b814 (Richard Lau) [#52183](https://github.com/nodejs/node/pull/52183)
* \[[`70a05103c8`](https://github.com/nodejs/node/commit/70a05103c8)] - **deps**: update zlib to 1.3.0.1-motley-24342f6 (Node.js GitHub Bot) [#52123](https://github.com/nodejs/node/pull/52123)
* \[[`4c3e9659ed`](https://github.com/nodejs/node/commit/4c3e9659ed)] - **deps**: update corepack to 0.26.0 (Node.js GitHub Bot) [#52027](https://github.com/nodejs/node/pull/52027)
* \[[`0b4cdb4b42`](https://github.com/nodejs/node/commit/0b4cdb4b42)] - **deps**: update ada to 2.7.7 (Node.js GitHub Bot) [#52028](https://github.com/nodejs/node/pull/52028)
* \[[`b241a1d0ae`](https://github.com/nodejs/node/commit/b241a1d0ae)] - **deps**: update simdutf to 4.0.9 (Node.js GitHub Bot) [#51655](https://github.com/nodejs/node/pull/51655)
* \[[`36dcd399c0`](https://github.com/nodejs/node/commit/36dcd399c0)] - **deps**: upgrade libuv to 1.48.0 (Santiago Gimeno) [#51697](https://github.com/nodejs/node/pull/51697)
* \[[`8cf313cd72`](https://github.com/nodejs/node/commit/8cf313cd72)] - **deps**: update undici to 6.6.0 (Node.js GitHub Bot) [#51630](https://github.com/nodejs/node/pull/51630)
* \[[`dd4767f99f`](https://github.com/nodejs/node/commit/dd4767f99f)] - **deps**: update undici to 6.4.0 (Node.js GitHub Bot) [#51527](https://github.com/nodejs/node/pull/51527)
* \[[`8362caa7d8`](https://github.com/nodejs/node/commit/8362caa7d8)] - **dgram**: use internal addAbortListener (Chemi Atlow) [#52081](https://github.com/nodejs/node/pull/52081)
* \[[`4f3cf4e89a`](https://github.com/nodejs/node/commit/4f3cf4e89a)] - **diagnostics\_channel**: early-exit tracing channel trace methods (Stephen Belanger) [#51915](https://github.com/nodejs/node/pull/51915)
* \[[`204018bba6`](https://github.com/nodejs/node/commit/204018bba6)] - **doc**: deprecate --experimental-policy (RafaelGSS) [#52602](https://github.com/nodejs/node/pull/52602)
* \[[`d32a914ac7`](https://github.com/nodejs/node/commit/d32a914ac7)] - **doc**: add lint-js-fix into BUILDING.md (jakecastelli) [#52290](https://github.com/nodejs/node/pull/52290)
* \[[`411503bacd`](https://github.com/nodejs/node/commit/411503bacd)] - **doc**: remove Internet Explorer mention in BUILDING.md (Rich Trott) [#52455](https://github.com/nodejs/node/pull/52455)
* \[[`e9ccf5aba2`](https://github.com/nodejs/node/commit/e9ccf5aba2)] - **doc**: accommodate upcoming stricter .md linting (Rich Trott) [#52454](https://github.com/nodejs/node/pull/52454)
* \[[`b4186ec2c1`](https://github.com/nodejs/node/commit/b4186ec2c1)] - **doc**: add Rafael to steward list (Rafael Gonzaga) [#52452](https://github.com/nodejs/node/pull/52452)
* \[[`7b01bfb2be`](https://github.com/nodejs/node/commit/7b01bfb2be)] - **doc**: correct naming convention in C++ style guide (Mohammed Keyvanzadeh) [#52424](https://github.com/nodejs/node/pull/52424)
* \[[`c82f3c9e80`](https://github.com/nodejs/node/commit/c82f3c9e80)] - **doc**: update `process.execArg` example to be more useful (Jacob Smith) [#52412](https://github.com/nodejs/node/pull/52412)
* \[[`655b327a4d`](https://github.com/nodejs/node/commit/655b327a4d)] - **doc**: call out http(s).globalAgent default (mathis-west-1) [#52392](https://github.com/nodejs/node/pull/52392)
* \[[`2c77be5488`](https://github.com/nodejs/node/commit/2c77be5488)] - **doc**: update the location of `build_with_cmake` (Emmanuel Ferdman) [#52356](https://github.com/nodejs/node/pull/52356)
* \[[`7dd514f2db`](https://github.com/nodejs/node/commit/7dd514f2db)] - **doc**: reserve 125 for Electron 31 (Shelley Vohr) [#52379](https://github.com/nodejs/node/pull/52379)
* \[[`756acd0877`](https://github.com/nodejs/node/commit/756acd0877)] - **doc**: use consistent plural form of "index" (Rich Trott) [#52373](https://github.com/nodejs/node/pull/52373)
* \[[`ba07e4e5e6`](https://github.com/nodejs/node/commit/ba07e4e5e6)] - **doc**: fix typo in cli.md (Daeyeon Jeong) [#52388](https://github.com/nodejs/node/pull/52388)
* \[[`461d9d665d`](https://github.com/nodejs/node/commit/461d9d665d)] - **doc**: add Rafael to sec release stewards (Rafael Gonzaga) [#52354](https://github.com/nodejs/node/pull/52354)
* \[[`d0c364a844`](https://github.com/nodejs/node/commit/d0c364a844)] - **doc**: document missing options of events.on (Chemi Atlow) [#52080](https://github.com/nodejs/node/pull/52080)
* \[[`a63261cf2c`](https://github.com/nodejs/node/commit/a63261cf2c)] - **doc**: add missing space (Augustin Mauroy) [#52360](https://github.com/nodejs/node/pull/52360)
* \[[`dd711d221a`](https://github.com/nodejs/node/commit/dd711d221a)] - **doc**: add tips about vcpkg cause build faild on windows (Cong Zhang) [#52181](https://github.com/nodejs/node/pull/52181)
* \[[`4df34cf6dd`](https://github.com/nodejs/node/commit/4df34cf6dd)] - **doc**: replace "below" with "following" (Rich Trott) [#52315](https://github.com/nodejs/node/pull/52315)
* \[[`d9aa33fdbf`](https://github.com/nodejs/node/commit/d9aa33fdbf)] - **doc**: fix email pattern to be wrapped with `<<` instead of single `<` (Raz Luvaton) [#52284](https://github.com/nodejs/node/pull/52284)
* \[[`903f28e684`](https://github.com/nodejs/node/commit/903f28e684)] - **doc**: update release gpg keyserver (marco-ippolito) [#52257](https://github.com/nodejs/node/pull/52257)
* \[[`fd55458770`](https://github.com/nodejs/node/commit/fd55458770)] - **doc**: add release key for marco-ippolito (marco-ippolito) [#52257](https://github.com/nodejs/node/pull/52257)
* \[[`27493a1dd7`](https://github.com/nodejs/node/commit/27493a1dd7)] - **doc**: fix arrow vertical alignment in HTML version (Akash Yeole) [#52193](https://github.com/nodejs/node/pull/52193)
* \[[`af48641993`](https://github.com/nodejs/node/commit/af48641993)] - **doc**: move TSC members from regular to emeritus (Michael Dawson) [#52209](https://github.com/nodejs/node/pull/52209)
* \[[`fa13ed6d79`](https://github.com/nodejs/node/commit/fa13ed6d79)] - **doc**: add section explaining todo tests (Colin Ihrig) [#52204](https://github.com/nodejs/node/pull/52204)
* \[[`312ebd97c2`](https://github.com/nodejs/node/commit/312ebd97c2)] - **doc**: edit `ChildProcess` `'message'` event docs (theanarkh) [#52154](https://github.com/nodejs/node/pull/52154)
* \[[`f1635f442f`](https://github.com/nodejs/node/commit/f1635f442f)] - **doc**: quote test\_runner glob parameters (Fabian Meyer) [#52201](https://github.com/nodejs/node/pull/52201)
* \[[`fc029181df`](https://github.com/nodejs/node/commit/fc029181df)] - **doc**: add mold to speeding up section (Cong Zhang) [#52179](https://github.com/nodejs/node/pull/52179)
* \[[`8bd3cb2f8c`](https://github.com/nodejs/node/commit/8bd3cb2f8c)] - **doc**: http event order correction (wh0) [#51464](https://github.com/nodejs/node/pull/51464)
* \[[`a7f170e45a`](https://github.com/nodejs/node/commit/a7f170e45a)] - **doc**: move gabrielschulhof to TSC emeritus (Gabriel Schulhof) [#52192](https://github.com/nodejs/node/pull/52192)
* \[[`305375ac16`](https://github.com/nodejs/node/commit/305375ac16)] - **doc**: fix `--env-file` docs for valid quotes for defining values (Gabriel Bota) [#52157](https://github.com/nodejs/node/pull/52157)
* \[[`3fcaf7b900`](https://github.com/nodejs/node/commit/3fcaf7b900)] - **doc**: clarify what is supported in NODE\_OPTIONS (Michael Dawson) [#52076](https://github.com/nodejs/node/pull/52076)
* \[[`4fe87357f3`](https://github.com/nodejs/node/commit/4fe87357f3)] - **doc**: fix typos in maintaining-dependencies.md (RoboSchmied) [#52160](https://github.com/nodejs/node/pull/52160)
* \[[`f1949ac1ae`](https://github.com/nodejs/node/commit/f1949ac1ae)] - **doc**: add spec for contains module syntax (Geoffrey Booth) [#52059](https://github.com/nodejs/node/pull/52059)
* \[[`707155424b`](https://github.com/nodejs/node/commit/707155424b)] - **doc**: optimize the doc about Unix abstract socket (theanarkh) [#52043](https://github.com/nodejs/node/pull/52043)
* \[[`8a191e4e6a`](https://github.com/nodejs/node/commit/8a191e4e6a)] - **doc**: update pnpm link (Superchupu) [#52113](https://github.com/nodejs/node/pull/52113)
* \[[`454d0806a1`](https://github.com/nodejs/node/commit/454d0806a1)] - **doc**: remove ableist language from crypto (Jamie King) [#52063](https://github.com/nodejs/node/pull/52063)
* \[[`dafe004703`](https://github.com/nodejs/node/commit/dafe004703)] - **doc**: update collaborator email (Ruy Adorno) [#52088](https://github.com/nodejs/node/pull/52088)
* \[[`8824adb031`](https://github.com/nodejs/node/commit/8824adb031)] - **doc**: state that removing npm is a non-goal (Geoffrey Booth) [#51951](https://github.com/nodejs/node/pull/51951)
* \[[`b360532f1a`](https://github.com/nodejs/node/commit/b360532f1a)] - **doc**: mention NodeSource in RafaelGSS steward list (Rafael Gonzaga) [#52057](https://github.com/nodejs/node/pull/52057)
* \[[`57d2e4881c`](https://github.com/nodejs/node/commit/57d2e4881c)] - **doc**: remove ArrayBuffer from crypto.hash() data parameter type (fengmk2) [#52069](https://github.com/nodejs/node/pull/52069)
* \[[`e11c1d2315`](https://github.com/nodejs/node/commit/e11c1d2315)] - **doc**: add some commonly used lables up gront (Michael Dawson) [#52006](https://github.com/nodejs/node/pull/52006)
* \[[`8f9f5db1e8`](https://github.com/nodejs/node/commit/8f9f5db1e8)] - **doc**: document that `const c2 = vm.createContext(c1); c1 === c2` is true (Daniel Kaplan) [#51960](https://github.com/nodejs/node/pull/51960)
* \[[`d78a565713`](https://github.com/nodejs/node/commit/d78a565713)] - **doc**: clarify what moderation issues are for (Antoine du Hamel) [#51990](https://github.com/nodejs/node/pull/51990)
* \[[`4cac07c931`](https://github.com/nodejs/node/commit/4cac07c931)] - **doc**: add Hemanth HM mention to v21.7.0 changelog (Rafael Gonzaga) [#52008](https://github.com/nodejs/node/pull/52008)
* \[[`73025c4dec`](https://github.com/nodejs/node/commit/73025c4dec)] - **doc**: add UlisesGascon as a collaborator (Ulises Gascón) [#51991](https://github.com/nodejs/node/pull/51991)
* \[[`999c6b34fb`](https://github.com/nodejs/node/commit/999c6b34fb)] - **doc**: test for cli options (Aras Abbasi) [#51623](https://github.com/nodejs/node/pull/51623)
* \[[`edd6190836`](https://github.com/nodejs/node/commit/edd6190836)] - **doc**: deprecate hmac public constructor (Marco Ippolito) [#51881](https://github.com/nodejs/node/pull/51881)
* \[[`25c79f3331`](https://github.com/nodejs/node/commit/25c79f3331)] - **esm**: drop support for import assertions (Nicolò Ribaudo) [#52104](https://github.com/nodejs/node/pull/52104)
* \[[`d619aab575`](https://github.com/nodejs/node/commit/d619aab575)] - **events**: rename high & low watermark for consistency (Chemi Atlow) [#52080](https://github.com/nodejs/node/pull/52080)
* \[[`e263946c2e`](https://github.com/nodejs/node/commit/e263946c2e)] - **events**: extract addAbortListener for safe internal use (Chemi Atlow) [#52081](https://github.com/nodejs/node/pull/52081)
* \[[`40ef2da8d6`](https://github.com/nodejs/node/commit/40ef2da8d6)] - **events**: remove abort listener from signal in `on` (Neal Beeken) [#51091](https://github.com/nodejs/node/pull/51091)
* \[[`61e5de1268`](https://github.com/nodejs/node/commit/61e5de1268)] - **fs**: refactor maybeCallback function (Yagiz Nizipli) [#52129](https://github.com/nodejs/node/pull/52129)
* \[[`39f1b899cd`](https://github.com/nodejs/node/commit/39f1b899cd)] - **fs**: fix edge case in readFileSync utf8 fast path (Richard Lau) [#52101](https://github.com/nodejs/node/pull/52101)
* \[[`639c096004`](https://github.com/nodejs/node/commit/639c096004)] - **fs**: validate fd from cpp on `fchown` (Yagiz Nizipli) [#52051](https://github.com/nodejs/node/pull/52051)
* \[[`9ac1fe05d7`](https://github.com/nodejs/node/commit/9ac1fe05d7)] - **fs**: validate fd from cpp on `close` (Yagiz Nizipli) [#52051](https://github.com/nodejs/node/pull/52051)
* \[[`3ec20f25df`](https://github.com/nodejs/node/commit/3ec20f25df)] - **fs**: validate file mode from cpp (Yagiz Nizipli) [#52050](https://github.com/nodejs/node/pull/52050)
* \[[`8c0b723ccb`](https://github.com/nodejs/node/commit/8c0b723ccb)] - **fs,permission**: make handling of buffers consistent (Tobias Nießen) [#52348](https://github.com/nodejs/node/pull/52348)
* \[[`3fc8d2200e`](https://github.com/nodejs/node/commit/3fc8d2200e)] - **http2**: fix h2-over-h2 connection proxying (Tim Perry) [#52368](https://github.com/nodejs/node/pull/52368)
* \[[`b9d8a14a03`](https://github.com/nodejs/node/commit/b9d8a14a03)] - **http2**: use internal addAbortListener (Chemi Atlow) [#52081](https://github.com/nodejs/node/pull/52081)
* \[[`818c10e86d`](https://github.com/nodejs/node/commit/818c10e86d)] - **lib**: improve perf of `AbortSignal` creation (Raz Luvaton) [#52408](https://github.com/nodejs/node/pull/52408)
* \[[`3f5ff8dc20`](https://github.com/nodejs/node/commit/3f5ff8dc20)] - **lib**: .load .save add proper error message when no file passed (Thomas Mauran) [#52225](https://github.com/nodejs/node/pull/52225)
* \[[`0a252c23d9`](https://github.com/nodejs/node/commit/0a252c23d9)] - **lib**: fix type error for \_refreshLine (Jackson Tian) [#52133](https://github.com/nodejs/node/pull/52133)
* \[[`14de082ab4`](https://github.com/nodejs/node/commit/14de082ab4)] - **lib**: emit listening event once when call listen twice (theanarkh) [#52119](https://github.com/nodejs/node/pull/52119)
* \[[`4e9ce7c035`](https://github.com/nodejs/node/commit/4e9ce7c035)] - **lib**: make sure clear the old timer in http server (theanarkh) [#52118](https://github.com/nodejs/node/pull/52118)
* \[[`20525f14b9`](https://github.com/nodejs/node/commit/20525f14b9)] - **lib**: fix listen with handle in cluster worker (theanarkh) [#52056](https://github.com/nodejs/node/pull/52056)
* \[[`8df54481f4`](https://github.com/nodejs/node/commit/8df54481f4)] - **meta**: bump actions/download-artifact from 4.1.3 to 4.1.4 (dependabot\[bot]) [#52314](https://github.com/nodejs/node/pull/52314)
* \[[`bcc102147a`](https://github.com/nodejs/node/commit/bcc102147a)] - **meta**: bump rtCamp/action-slack-notify from 2.2.1 to 2.3.0 (dependabot\[bot]) [#52313](https://github.com/nodejs/node/pull/52313)
* \[[`4e7e0ef9c3`](https://github.com/nodejs/node/commit/4e7e0ef9c3)] - **meta**: bump github/codeql-action from 3.24.6 to 3.24.9 (dependabot\[bot]) [#52312](https://github.com/nodejs/node/pull/52312)
* \[[`14a39881b8`](https://github.com/nodejs/node/commit/14a39881b8)] - **meta**: bump actions/cache from 4.0.1 to 4.0.2 (dependabot\[bot]) [#52311](https://github.com/nodejs/node/pull/52311)
* \[[`2f8f90dadb`](https://github.com/nodejs/node/commit/2f8f90dadb)] - **meta**: bump actions/setup-python from 5.0.0 to 5.1.0 (dependabot\[bot]) [#52310](https://github.com/nodejs/node/pull/52310)
* \[[`95efdaf01a`](https://github.com/nodejs/node/commit/95efdaf01a)] - **meta**: bump codecov/codecov-action from 4.1.0 to 4.1.1 (dependabot\[bot]) [#52308](https://github.com/nodejs/node/pull/52308)
* \[[`24c1a8e739`](https://github.com/nodejs/node/commit/24c1a8e739)] - **meta**: move one or more collaborators to emeritus (Node.js GitHub Bot) [#52300](https://github.com/nodejs/node/pull/52300)
* \[[`60dcfad91e`](https://github.com/nodejs/node/commit/60dcfad91e)] - **meta**: pass Codecov upload token to codecov action (Michaël Zasso) [#51982](https://github.com/nodejs/node/pull/51982)
* \[[`db1746182b`](https://github.com/nodejs/node/commit/db1746182b)] - **module**: disallow CJS <-> ESM edges in a cycle from require(esm) (Joyee Cheung) [#52264](https://github.com/nodejs/node/pull/52264)
* \[[`d6b57f6629`](https://github.com/nodejs/node/commit/d6b57f6629)] - **module**: centralize SourceTextModule compilation for builtin loader (Joyee Cheung) [#52291](https://github.com/nodejs/node/pull/52291)
* \[[`f4a0a3b04b`](https://github.com/nodejs/node/commit/f4a0a3b04b)] - **module**: warn on detection in typeless package (Geoffrey Booth) [#52168](https://github.com/nodejs/node/pull/52168)
* \[[`8bc745944e`](https://github.com/nodejs/node/commit/8bc745944e)] - **module**: eliminate performance cost of detection for cjs entry (Geoffrey Booth) [#52093](https://github.com/nodejs/node/pull/52093)
* \[[`63d04d4d80`](https://github.com/nodejs/node/commit/63d04d4d80)] - **module**: fix detect-module not retrying as esm for cjs-only errors (Geoffrey Booth) [#52024](https://github.com/nodejs/node/pull/52024)
* \[[`575ced8139`](https://github.com/nodejs/node/commit/575ced8139)] - **module**: print location of unsettled top-level await in entry points (Joyee Cheung) [#51999](https://github.com/nodejs/node/pull/51999)
* \[[`075c95f61f`](https://github.com/nodejs/node/commit/075c95f61f)] - **module**: refactor ESM loader initialization and entry point handling (Joyee Cheung) [#51999](https://github.com/nodejs/node/pull/51999)
* \[[`45f0dd0192`](https://github.com/nodejs/node/commit/45f0dd0192)] - **module,win**: fix long path resolve (Stefan Stojanovic) [#51097](https://github.com/nodejs/node/pull/51097)
* \[[`d89fc73d45`](https://github.com/nodejs/node/commit/d89fc73d45)] - **net**: use internal addAbortListener (Chemi Atlow) [#52081](https://github.com/nodejs/node/pull/52081)
* \[[`f0e6acde2d`](https://github.com/nodejs/node/commit/f0e6acde2d)] - **node-api**: make tsfn accept napi\_finalize once more (Gabriel Schulhof) [#51801](https://github.com/nodejs/node/pull/51801)
* \[[`ff93f3e1a8`](https://github.com/nodejs/node/commit/ff93f3e1a8)] - **readline**: use internal addAbortListener (Chemi Atlow) [#52081](https://github.com/nodejs/node/pull/52081)
* \[[`4a6ca7a1d4`](https://github.com/nodejs/node/commit/4a6ca7a1d4)] - **src**: remove erroneous CVE-2024-27980 revert option (Tobias Nießen) [#52543](https://github.com/nodejs/node/pull/52543)
* \[[`64b67779f7`](https://github.com/nodejs/node/commit/64b67779f7)] - **src**: disallow direct .bat and .cmd file spawning (Ben Noordhuis) [nodejs-private/node-private#560](https://github.com/nodejs-private/node-private/pull/560)
* \[[`9ef724bc81`](https://github.com/nodejs/node/commit/9ef724bc81)] - **src**: update branch name in node\_revert.h (Tobias Nießen) [#52390](https://github.com/nodejs/node/pull/52390)
* \[[`ec1550407b`](https://github.com/nodejs/node/commit/ec1550407b)] - **src**: stop using `v8::BackingStore::Reallocate` (Michaël Zasso) [#52292](https://github.com/nodejs/node/pull/52292)
* \[[`681b0a3df3`](https://github.com/nodejs/node/commit/681b0a3df3)] - **src**: address coverity warning in module\_wrap.cc (Michael Dawson) [#52143](https://github.com/nodejs/node/pull/52143)
* \[[`04319228e0`](https://github.com/nodejs/node/commit/04319228e0)] - **src**: fix move after use reported by coverity (Michael Dawson) [#52141](https://github.com/nodejs/node/pull/52141)
* \[[`0eb2b727f6`](https://github.com/nodejs/node/commit/0eb2b727f6)] - **src**: return a number from process.constrainedMemory() constantly (Chengzhong Wu) [#52039](https://github.com/nodejs/node/pull/52039)
* \[[`bec9b5fccc`](https://github.com/nodejs/node/commit/bec9b5fccc)] - **src**: use dedicated routine to compile function for builtin CJS loader (Joyee Cheung) [#52016](https://github.com/nodejs/node/pull/52016)
* \[[`1f193165b9`](https://github.com/nodejs/node/commit/1f193165b9)] - **src**: fix reading empty string views in Blob\[De]serializer (Joyee Cheung) [#52000](https://github.com/nodejs/node/pull/52000)
* \[[`fb356b3305`](https://github.com/nodejs/node/commit/fb356b3305)] - **src**: refactor out FormatErrorMessage for error formatting (Joyee Cheung) [#51999](https://github.com/nodejs/node/pull/51999)
* \[[`1a8ae9d6c0`](https://github.com/nodejs/node/commit/1a8ae9d6c0)] - **src**: use callback-based array iteration in Blob (Joyee Cheung) [#51758](https://github.com/nodejs/node/pull/51758)
* \[[`5cd2ec8bd5`](https://github.com/nodejs/node/commit/5cd2ec8bd5)] - **src**: implement v8 array iteration using the new callback-based API (Joyee Cheung) [#51758](https://github.com/nodejs/node/pull/51758)
* \[[`89a26b451e`](https://github.com/nodejs/node/commit/89a26b451e)] - **src**: fix node\_version.h (Joyee Cheung) [#50375](https://github.com/nodejs/node/pull/50375)
* \[[`c02de658a1`](https://github.com/nodejs/node/commit/c02de658a1)] - **stream**: make Duplex inherit destroy from Writable (Luigi Pinca) [#52318](https://github.com/nodejs/node/pull/52318)
* \[[`63391e749d`](https://github.com/nodejs/node/commit/63391e749d)] - **stream**: add `new` when constructing `ERR_MULTIPLE_CALLBACK` (haze) [#52110](https://github.com/nodejs/node/pull/52110)
* \[[`a9528e87b9`](https://github.com/nodejs/node/commit/a9528e87b9)] - **stream**: use internal addAbortListener (Chemi Atlow) [#52081](https://github.com/nodejs/node/pull/52081)
* \[[`ee4fa77624`](https://github.com/nodejs/node/commit/ee4fa77624)] - **test**: fix watch test with require not testing pid (Raz Luvaton) [#52353](https://github.com/nodejs/node/pull/52353)
* \[[`05cb16dc1a`](https://github.com/nodejs/node/commit/05cb16dc1a)] - **test**: simplify ASan build checks (Michaël Zasso) [#52430](https://github.com/nodejs/node/pull/52430)
* \[[`eb53121b77`](https://github.com/nodejs/node/commit/eb53121b77)] - **test**: fix Windows compiler warnings in overlapped-checker (Michaël Zasso) [#52405](https://github.com/nodejs/node/pull/52405)
* \[[`7dfa4750af`](https://github.com/nodejs/node/commit/7dfa4750af)] - **test**: add test for skip+todo combinations (Colin Ihrig) [#52204](https://github.com/nodejs/node/pull/52204)
* \[[`5905596719`](https://github.com/nodejs/node/commit/5905596719)] - **test**: fix incorrect test fixture (Colin Ihrig) [#52185](https://github.com/nodejs/node/pull/52185)
* \[[`bae14b7914`](https://github.com/nodejs/node/commit/bae14b7914)] - **test**: do not set concurrency on parallelized runs (Antoine du Hamel) [#52177](https://github.com/nodejs/node/pull/52177)
* \[[`0b676736a0`](https://github.com/nodejs/node/commit/0b676736a0)] - **test**: add missing cctest/test\_path.cc (Yagiz Nizipli) [#52148](https://github.com/nodejs/node/pull/52148)
* \[[`c714cda9a7`](https://github.com/nodejs/node/commit/c714cda9a7)] - **test**: add `spawnSyncAndAssert` util (Antoine du Hamel) [#52132](https://github.com/nodejs/node/pull/52132)
* \[[`978d5a26c9`](https://github.com/nodejs/node/commit/978d5a26c9)] - **test**: reduce flakiness of test-runner-output.mjs (Colin Ihrig) [#52146](https://github.com/nodejs/node/pull/52146)
* \[[`afaf889775`](https://github.com/nodejs/node/commit/afaf889775)] - **test**: skip test for dynamically linked OpenSSL (Richard Lau) [#52542](https://github.com/nodejs/node/pull/52542)
* \[[`be75821a12`](https://github.com/nodejs/node/commit/be75821a12)] - **test**: add test for using `--print` with promises (Antoine du Hamel) [#52137](https://github.com/nodejs/node/pull/52137)
* \[[`4e109e5958`](https://github.com/nodejs/node/commit/4e109e5958)] - **test**: un-set test-emit-after-on-destroyed as flaky (Abdirahim Musse) [#51995](https://github.com/nodejs/node/pull/51995)
* \[[`3f8cc88009`](https://github.com/nodejs/node/commit/3f8cc88009)] - **test\_runner**: fix clearing final timeout in own callback (Ben Richeson) [#52332](https://github.com/nodejs/node/pull/52332)
* \[[`52f8dcfccc`](https://github.com/nodejs/node/commit/52f8dcfccc)] - **test\_runner**: make end of work check stricter (Colin Ihrig) [#52326](https://github.com/nodejs/node/pull/52326)
* \[[`433bd1b04d`](https://github.com/nodejs/node/commit/433bd1b04d)] - **test\_runner**: fix recursive run (Moshe Atlow) [#52322](https://github.com/nodejs/node/pull/52322)
* \[[`e57992ffb2`](https://github.com/nodejs/node/commit/e57992ffb2)] - **test\_runner**: hide new line when no error in spec reporter (Moshe Atlow) [#52297](https://github.com/nodejs/node/pull/52297)
* \[[`ac9e5e7527`](https://github.com/nodejs/node/commit/ac9e5e7527)] - **test\_runner**: improve describe.only behavior (Moshe Atlow) [#52296](https://github.com/nodejs/node/pull/52296)
* \[[`2c024cd24d`](https://github.com/nodejs/node/commit/2c024cd24d)] - **test\_runner**: disable highWatermark on TestsStream (Colin Ihrig) [#52287](https://github.com/nodejs/node/pull/52287)
* \[[`7c02486f1f`](https://github.com/nodejs/node/commit/7c02486f1f)] - **test\_runner**: run afterEach hooks in correct order (Colin Ihrig) [#52239](https://github.com/nodejs/node/pull/52239)
* \[[`6af4049810`](https://github.com/nodejs/node/commit/6af4049810)] - **test\_runner**: simplify test end time tracking (Colin Ihrig) [#52182](https://github.com/nodejs/node/pull/52182)
* \[[`878047be0b`](https://github.com/nodejs/node/commit/878047be0b)] - **test\_runner**: simplify test start time tracking (Colin Ihrig) [#52182](https://github.com/nodejs/node/pull/52182)
* \[[`4648c83dbc`](https://github.com/nodejs/node/commit/4648c83dbc)] - **test\_runner**: don't await the same promise for each test (Colin Ihrig) [#52185](https://github.com/nodejs/node/pull/52185)
* \[[`f9755f6f79`](https://github.com/nodejs/node/commit/f9755f6f79)] - **test\_runner**: emit diagnostics when watch mode drains (Moshe Atlow) [#52130](https://github.com/nodejs/node/pull/52130)
* \[[`4ba9f45d99`](https://github.com/nodejs/node/commit/4ba9f45d99)] - **test\_runner**: ignore todo flag when running suites (Colin Ihrig) [#52117](https://github.com/nodejs/node/pull/52117)
* \[[`6f4d6011ea`](https://github.com/nodejs/node/commit/6f4d6011ea)] - **test\_runner**: skip each hooks for skipped tests (Colin Ihrig) [#52115](https://github.com/nodejs/node/pull/52115)
* \[[`05db979c01`](https://github.com/nodejs/node/commit/05db979c01)] - **test\_runner**: run top level tests in a microtask (Colin Ihrig) [#52092](https://github.com/nodejs/node/pull/52092)
* \[[`97b2c5344d`](https://github.com/nodejs/node/commit/97b2c5344d)] - **test\_runner**: remove redundant report call (Colin Ihrig) [#52089](https://github.com/nodejs/node/pull/52089)
* \[[`780d030bdf`](https://github.com/nodejs/node/commit/780d030bdf)] - **test\_runner**: use internal addAbortListener (Chemi Atlow) [#52081](https://github.com/nodejs/node/pull/52081)
* \[[`814fa1ae74`](https://github.com/nodejs/node/commit/814fa1ae74)] - **test\_runner**: use source maps when reporting coverage (Moshe Atlow) [#52060](https://github.com/nodejs/node/pull/52060)
* \[[`3c5764a0e2`](https://github.com/nodejs/node/commit/3c5764a0e2)] - **test\_runner**: handle undefined test locations (Colin Ihrig) [#52036](https://github.com/nodejs/node/pull/52036)
* \[[`328642bbb9`](https://github.com/nodejs/node/commit/328642bbb9)] - **test\_runner**: use paths for test locations (Colin Ihrig) [#52010](https://github.com/nodejs/node/pull/52010)
* \[[`6d625fe616`](https://github.com/nodejs/node/commit/6d625fe616)] - **test\_runner**: support source mapped test locations (Colin Ihrig) [#52010](https://github.com/nodejs/node/pull/52010)
* \[[`592c6907bf`](https://github.com/nodejs/node/commit/592c6907bf)] - **test\_runner**: avoid overwriting root start time (Colin Ihrig) [#52020](https://github.com/nodejs/node/pull/52020)
* \[[`29b231763e`](https://github.com/nodejs/node/commit/29b231763e)] - **test\_runner**: abort unfinished tests on async error (Colin Ihrig) [#51996](https://github.com/nodejs/node/pull/51996)
* \[[`5d13419dbd`](https://github.com/nodejs/node/commit/5d13419dbd)] - **test\_runner**: run before hook immediately if test started (Moshe Atlow) [#52003](https://github.com/nodejs/node/pull/52003)
* \[[`8451990668`](https://github.com/nodejs/node/commit/8451990668)] - **test\_runner**: add support for null and date value output (Malthe Borch) [#51920](https://github.com/nodejs/node/pull/51920)
* \[[`423ad47e0f`](https://github.com/nodejs/node/commit/423ad47e0f)] - **tools**: change inactive limit to 12 months (Yagiz Nizipli) [#52425](https://github.com/nodejs/node/pull/52425)
* \[[`0d1e64f64c`](https://github.com/nodejs/node/commit/0d1e64f64c)] - **tools**: update stale bot messaging (Wes Todd) [#52423](https://github.com/nodejs/node/pull/52423)
* \[[`5bae73df90`](https://github.com/nodejs/node/commit/5bae73df90)] - **tools**: update lint-md-dependencies to rollup\@4.14.0 (Node.js GitHub Bot) [#52398](https://github.com/nodejs/node/pull/52398)
* \[[`468cb99ba4`](https://github.com/nodejs/node/commit/468cb99ba4)] - **tools**: update Ruff to v0.3.4 (Michaël Zasso) [#52302](https://github.com/nodejs/node/pull/52302)
* \[[`67b9dda003`](https://github.com/nodejs/node/commit/67b9dda003)] - **tools**: run test-ubsan on ubuntu-latest (Michaël Zasso) [#52375](https://github.com/nodejs/node/pull/52375)
* \[[`f1f32d89e0`](https://github.com/nodejs/node/commit/f1f32d89e0)] - **tools**: update lint-md-dependencies to rollup\@4.13.2 (Node.js GitHub Bot) [#52286](https://github.com/nodejs/node/pull/52286)
* \[[`d7aa8fc9da`](https://github.com/nodejs/node/commit/d7aa8fc9da)] - _**Revert**_ "**tools**: run `build-windows` workflow only on source changes" (Michaël Zasso) [#52320](https://github.com/nodejs/node/pull/52320)
* \[[`a3b1fc3f27`](https://github.com/nodejs/node/commit/a3b1fc3f27)] - **tools**: use Python 3.12 in GitHub Actions workflows (Michaël Zasso) [#52301](https://github.com/nodejs/node/pull/52301)
* \[[`021cf91208`](https://github.com/nodejs/node/commit/021cf91208)] - **tools**: allow local updates for llhttp (Paolo Insogna) [#52085](https://github.com/nodejs/node/pull/52085)
* \[[`4d8602046e`](https://github.com/nodejs/node/commit/4d8602046e)] - **tools**: install npm PowerShell scripts on Windows (Luke Karrys) [#52009](https://github.com/nodejs/node/pull/52009)
* \[[`081319d762`](https://github.com/nodejs/node/commit/081319d762)] - **tools**: update lint-md-dependencies to rollup\@4.13.0 (Node.js GitHub Bot) [#52122](https://github.com/nodejs/node/pull/52122)
* \[[`c43a944231`](https://github.com/nodejs/node/commit/c43a944231)] - **tools**: fix error reported by coverity in js2c.cc (Michael Dawson) [#52142](https://github.com/nodejs/node/pull/52142)
* \[[`f05b241f07`](https://github.com/nodejs/node/commit/f05b241f07)] - **tools**: sync ubsan workflow with asan (Michaël Zasso) [#52152](https://github.com/nodejs/node/pull/52152)
* \[[`a21b15a14e`](https://github.com/nodejs/node/commit/a21b15a14e)] - **tools**: update github\_reporter to 1.7.0 (Node.js GitHub Bot) [#52121](https://github.com/nodejs/node/pull/52121)
* \[[`d60a871db2`](https://github.com/nodejs/node/commit/d60a871db2)] - **tools**: remove gyp-next .github folder (Marco Ippolito) [#52064](https://github.com/nodejs/node/pull/52064)
* \[[`6ad5353764`](https://github.com/nodejs/node/commit/6ad5353764)] - **tools**: update gyp-next to 0.16.2 (Node.js GitHub Bot) [#52062](https://github.com/nodejs/node/pull/52062)
* \[[`dab85bdc06`](https://github.com/nodejs/node/commit/dab85bdc06)] - **tools**: install manpage to share/man for FreeBSD (Po-Chuan Hsieh) [#51791](https://github.com/nodejs/node/pull/51791)
* \[[`cde37e7b63`](https://github.com/nodejs/node/commit/cde37e7b63)] - **tools**: automate gyp-next update (Marco Ippolito) [#52014](https://github.com/nodejs/node/pull/52014)
* \[[`925a464cb8`](https://github.com/nodejs/node/commit/925a464cb8)] - **url**: remove #context from URLSearchParams (Matt Cowley) [#51520](https://github.com/nodejs/node/pull/51520)
* \[[`893e2cf22b`](https://github.com/nodejs/node/commit/893e2cf22b)] - **watch**: fix some node argument not passed to watched process (Raz Luvaton) [#52358](https://github.com/nodejs/node/pull/52358)
* \[[`fec7e505fc`](https://github.com/nodejs/node/commit/fec7e505fc)] - **watch**: use internal addAbortListener (Chemi Atlow) [#52081](https://github.com/nodejs/node/pull/52081)
* \[[`4f68c7c1c9`](https://github.com/nodejs/node/commit/4f68c7c1c9)] - **watch**: mark as stable (Moshe Atlow) [#52074](https://github.com/nodejs/node/pull/52074)
* \[[`257f32296d`](https://github.com/nodejs/node/commit/257f32296d)] - **watch**: batch file restarts (Moshe Atlow) [#51992](https://github.com/nodejs/node/pull/51992)
