# Advocacy Ambassador program

Node.js aims to support and encourage developers and developer
advocates to promote Node.js as a project and to help communicate
key messages to their constituencies.

The ambassador program does that by:

* Maintaining an up-to-date set of messages that the Node.js maintainers would like ambassadors
  to promote. These will be documented in the nodejs/ambassadors repository.
* Maintaining an up-to-date set of topics on which additional content
  would benefit the community. These will be documented in the
  nodejs/ambassadors repository.
* Providing a space for collaborators to share new topics/features they
  are working on when they would be happy for ambassadors to help share and get
  early feedback.
* Helping ambassadors promote content that aligns with the
  messages and topics defined.
* Advocating for ambassadors to be part of the OpenJS speakers bureau, even if the
  ambassador is not otherwise an active member of the project itself.
* Each ambassador could add a maximum of three links to resources to learn Node.js
  on a dedicated page on the main Node.js website. At least one of those must be a
  free resource. The Node.js TSC members could ask for coupon codes to verify the
  material if they so decide.

## Ambassadors nominations

Any member of the Node.js organization may nominate an ambassador.
The Technical Steering Committee (TSC) will review/approve ambassadors.

In the initial phase of the program:

* There will be a maximum of 4 ambassadors.
* The term will be for the calendar year. After a year, ambassadors automatically
  drop out of the ambassador list and must be re-nominated.
* Ambassadors will be documented on the nodejs/ambassadors `README.md`.

The TSC may remove an ambassador for any reason,
including promoting content misaligned with the project.

Members of the Node.js organization can nominate ambassadors by opening
a discussion issue with the nomination in
[nodejs/collaborators](https://github.com/nodejs/collaborators/)
titled `Nomination X to be an Ambassador`, where X is the name of the person
being nominated.
If there is no objection within 14 days, the nomination is approved.

## Onboarding

To onboard an ambassador, a member of the TSC will:

* \[ ] Add the ambassador to the nodejs/ambassadors team.
* \[ ] Add the ambassador to the nodejs/ambassadors `README.md`.
* \[ ] Add the ambassador to the OpenJS Slack channel.

## Reviewing content

Ambassadors are asked to share links to new content before asking
for the content to be promoted. The goal is to provide the opportunity
for collaborators to help improve content as opposed to a detailed
nitpick review.

This is done by opening an issue in the nodejs/ambassadors
repository, which limits access to members of the Node.js
organization. The issue may include the link to existing published
content or a draft of the content itself.

Interested members of the Node.js organization may comment
in the issue and the ambassadors are expected to
consider those suggestions and update the content when they feel it
is appropriate.

Explicit approval is not required in the issue (i.e. if there is no
input, that's OK), but review comments should be addressed before
requesting promotion.

## Expectations on Ambassadors

Ambassadors are expected to engage both within the project and externally
in a manner that is consistent with the project's
[Code of Conduct](https://github.com/nodejs/admin/blob/main/CODE_OF_CONDUCT.md)
as well as the additional expectations outlined in
[Member Expectations](https://github.com/nodejs/admin/blob/main/MemberExpectations.md).

## Promoting content

We trust ambassadors to only request promotion of content that lines
up with the messages and topics outlined, that this content does not overly
market their employer or product/business, and that they have followed the review
process. An ambassador can request promotion of content in the following ways:

* Requesting that a post be reposted by the Node.js account on a social media platform.
* @-mentioning the nodejs/ambassadors team to ask other ambassadors to repost.
* Posting a link to the content in the "what's new" issue in nodejs/ambassadors
  so that it goes out on the news feed.

Foundation staff will repost the social media post
without any need for validation based on the request coming from
an ambassador. These requests can be made through the existing social channel
in the OpenJS Slack. For that reason and for communication purposes and
collaboration opportunities, ambassadors should be members of the
[OpenJS Slack](https://slack-invite.openjsf.org/).

## Messages and topics to promote

### How to add messages or topics to promote

Messages or topics that ambassadors are asked to promote are added to this
document in the [Current messages for promotion](#current-messages-for-promotion)
section through the standard PR process except that they should be open
for 7 days before landing and should include and at mention to the
nodejs/TSC for awareness. They should be removed through the same process
when no longer relevant.

### Current messages for promotion

#### Sample message (Leave this one at the top)

##### Goal

The goal is to raise awareness of XYZ in the JavaScript ecosystem.

#### Related Links

List of links with more information about the topic to provide brackground
or the information to be shared.

#### Project contacts

Add a list of GitHub handles for those within the project that
have volunteered to be contacated when necessary by ambassadors
to get more info about the message to be promoted.

#### Node.js is a great choice for a JavaScript runtime

##### Goal

Highlight the benefits of chosing Node.js as your backend JavaScript runtime. Focus on what is great
about Node.js without drawing comparisons to alternatives. We don't want to say negative things about
other options, only highlight what is great about Node.js as a choice.

Some of the things to highlight include:

* How widely it is used (you never get fired for chosing Node.js).
* The openess of the project. It is part of the OpenJS Foundation and it's governance is set up to avoid
  any one company from dominating the project. Decisions are made by the collaborators (of which there are quite
  a few) versus a small number of people.
* It has predictable and stable releases and has delivered on the release schedule since 2015.
* It was a well defined security release process and manages security releases well.
* As the defacto standard, it has the highest likelihood of being supported for a given package on npm.
* It is not dependent on any one company for its continued existence reducing risk of using it.
* The large number of platforms supported.
* Asynchronous non-blocking i/o architecture drives high transactional throughput, making it ideal for web workloads.
* Single threaded programming model enables very low resource consumption, making it ideal for containerised workloads.
* Highly vibrant ecosystem with enterprise support from many vendors.

#### Related Links

* <https://github.com/nodejs/release>
* <https://github.com/nodejs/node/blob/main/doc/contributing/security-release-process.md>
* <https://github.com/nodejs/TSC/blob/main/TSC-Charter.md>
* <https://github.com/mhdawson/presentations/blob/main/2024/NodeConfEU_2024-Node.js_whats_next.pdf>
  for slide  usage and topping recent surveys.

#### Project contacts

* @mhdawson
