"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.nvimFunction = void 0;
const properties_1 = require("./properties");
function nvimFunction(name, options = {}) {
    return function (cls, methodName) {
        // const {
        // sync,
        // ...opts,
        // } = options;
        const sync = options && !!options.sync;
        const isMethod = typeof methodName === 'string';
        const f = isMethod ? cls[methodName] : cls;
        const opts = {};
        if (options && options.range) {
            opts.range = options.range;
        }
        if (options && options.eval) {
            opts.eval = options.eval;
        }
        Object.defineProperty(f, properties_1.NVIM_METHOD_NAME, { value: `function:${name}` });
        Object.defineProperty(f, properties_1.NVIM_SYNC, { value: !!sync });
        Object.defineProperty(f, properties_1.NVIM_SPEC, {
            value: {
                type: 'function',
                name,
                sync: !!sync,
                opts,
            },
        });
        if (isMethod) {
            // eslint-disable-next-line no-param-reassign
            cls[methodName] = f;
        }
        return cls;
    };
}
exports.nvimFunction = nvimFunction;
