/*
 * Copyright (c) 2008-2024 Jonathan Schleifer <js@nil.im>
 *
 * All rights reserved.
 *
 * This file is part of ObjFW. It may be distributed under the terms of the
 * Q Public License 1.0, which can be found in the file LICENSE.QPL included in
 * the packaging of this file.
 *
 * Alternatively, it may be distributed under the terms of the GNU General
 * Public License, either version 2 or 3, which can be found in the file
 * LICENSE.GPLv2 or LICENSE.GPLv3 respectively included in the packaging of this
 * file.
 */

#include "config.h"

#import "OFRangeCharacterSet.h"
#import "OFString.h"

#import "OFOutOfRangeException.h"

@implementation OFRangeCharacterSet
- (instancetype)init
{
	OF_INVALID_INIT_METHOD
}

- (instancetype)initWithRange: (OFRange)range
{
	self = [super init];

	@try {
		if (SIZE_MAX - range.location < range.length)
			@throw [OFOutOfRangeException exception];

		_range = range;
	} @catch (id e) {
		[self release];
		@throw e;
	}

	return self;
}

- (bool)characterIsMember: (OFUnichar)character
{
	return (character >= _range.location &&
	    character < _range.location + _range.length);
}
@end
